<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'lo', version '4.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'ໄຟລ໌ແນບກິດຈະກຳການມອບໝາຍ';
$string['activitydate:submissionsdue'] = 'ຮອດກຳນົດ:';
$string['activitydate:submissionsopen'] = 'ເປີດ:';
$string['activitydate:submissionsopened'] = 'ເປີດແລ້ວ:';
$string['activityeditor'] = 'ຄຳແນະນຳກິດຈະກຳ';
$string['activityeditor_help'] = 'ການກະທຳທີ່ທ່ານຢາກໃຫ້ນັກຮຽນເຮັດສຳເລັດສຳລັບວຽກນີ້. ສິ່ງນີ້ແມ່ນສະແດງຢູ່ໃນໜ້າການສົ່ງເທົ່ານັ້ນທີ່ນັກຮຽນແກ້ໄຂ ແລະ ສົ່ງວຽກຂອງເຂົາເຈົ້າ.';
$string['activityoverview'] = 'ທ່ານມີການມອບໝາຍທີ່ຕ້ອງການເອົາໃຈໃສ່';
$string['addattempt'] = 'ອະນຸຍາດໃຫ້ພະຍາຍາມອີກຄັ້ງ';
$string['addnewattempt'] = 'ເພີ່ມຄວາມພະຍາຍາມອີກເທື່ອໃໝ່';
$string['addnewattempt_help'] = 'ສິ່ງນີ້ຈະສ້າງການສົ່ງທີ່ເປົ່າຫວ່າງໃໝ່ເພື່ອໃຫ້ທ່ານເຮັດວຽກ.';
$string['addnewattemptfromprevious'] = 'ເພີ່ມຄວາມພະຍາຍາມໃໝ່ອີງຕາມການສົ່ງກ່ອນໜ້າ';
$string['addnewattemptfromprevious_help'] = 'ສິ່ງນີ້ຈະສຳເນົາເອົາເນື້ອໃນການສົ່ງກ່ອນໜ້າຂອງທ່ານໄປຫາການສົ່ງໃໝ່ເພື່ອໃຫ້ທ່ານເຮັດວຽກ.';
$string['addnewgroupoverride'] = 'ເພີ່ມການລົບລ້າງກຸ່ມ';
$string['addnewuseroverride'] = 'ເພີ່ມການລົບລ້າງຜູ້ໃຊ້';
$string['addsubmission'] = 'ເພີ່ມການສົ່ງ';
$string['addsubmission_help'] = 'ທ່ານຍັງບໍ່ໄດ້ເຮັດການສົ່ງເທື່ອ.';
$string['allocatedmarker'] = 'ຈັດສັນເຄື່ອງໝາຍ';
$string['allocatedmarker_help'] = 'ເຄື່ອງໝາຍໄດ້ຈັດສັນຫາການສົ່ງນີ້.';
$string['allowsubmissions'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ສືບຕໍ່ເຮັດການສົ່ງຫາການມອບໝາຍນີ້.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'ລາຍລະອຽດການມອບໝາຍ ແລະ ແບບຟອມການສົ່ງຈະມີໃຫ້ຈາກ <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'ອະນຸຍາດການສົ່ງຈາກ';
$string['allowsubmissionsfromdate_help'] = 'ຖ້າເປີດໃຊ້ງານ, ນັກຮຽນຈະບໍ່ສາມາດສົ່ງກ່ອນວັນທີນີ້. ຖ້າປິດໃຊ້ງານ, ນັກຮຽນຈະສາມດເລີ່ມການສົ່ງໄດ້ທັນທີ.';
$string['allowsubmissionsfromdatesummary'] = 'ການມອບໝາຍນີ້ຈະຍອມຮັບການສົ່ງຈາກ <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'ອະນຸຍາດໃຫ້ປ່ຽນແປງການສົ່ງ';
$string['alwaysshowdescription'] = 'ສະແດງລາຍລະອຽດສະເໝີ';
$string['alwaysshowdescription_help'] = 'ຖ້າປິດໃຊ້ງານ, ລາຍລະອຽດການມອບໝາຍຂ້າງເທິງຈະສາມາດເບິ່ງເຫັນໄດ້ກັບນັກຮຽນເທົ່ານັ້ນໃນ "ອະນຸຍາດການສົ່ງຈາກ" ວັນທີ.';
$string['applytoteam'] = 'ໃສ່ຄະແນນ ແລະ ຄຳຕິຊົມຫາກຸ່ມທັງໝົດ';
$string['assign:addinstance'] = 'ເພີ່ມການມອບໝາຍໃໝ່';
$string['assign:editothersubmission'] = 'ແກ້ໄຂການສົ່ງຂອງນັກຮຽນຄົນອື່ນ';
$string['assign:exportownsubmission'] = 'ສົ່ງອອກການສົ່ງຂອງຕົວເອງ';
$string['assign:grade'] = 'ການມອບໝາຍຄະແນນ';
$string['assign:grantextension'] = 'ອະນຸມັດສ່ວນຂະຫຍາຍ';
$string['assign:manageallocations'] = 'ຈັດການເຄື່ອງໝາຍທີ່ຈັດສັນຫາການສົ່ງ';
$string['assign:managegrades'] = 'ທົບທວນ ແລະ ປ່ອຍຄະແນນ';
$string['assign:manageoverrides'] = 'ຈັດການການລົບລ້າງການມອບໝາຍ';
$string['assign:receivegradernotifications'] = 'ຮັບແຈ້ງການການສົ່ງຂອງຜູ້ໃຫ້ຄະແນນ';
$string['assign:releasegrades'] = 'ປ່ອຍຄະແນນ';
$string['assign:revealidentities'] = 'ເປີດເຜີຍຕົວຕົນຂອງນັກຮຽນ';
$string['assign:reviewgrades'] = 'ທົບທວນຄະແນນ';
$string['assign:showhiddengrader'] = 'ເບິ່ງຕົວຕົນຂອງຜູ້ໃຫ້ຄະແນນທີ່ເຊື່ອງໄວ້';
$string['assign:submit'] = 'ສົ່ງການມອບໝາຍ';
$string['assign:view'] = 'ເບິ່ງການມອບໝາຍ';
$string['assign:viewblinddetails'] = 'ເບິ່ງຕົວຕົນນັກຮຽນເມື່ອການສົ່ງແບບບໍ່ເປີດເຜີຍຊື່ເປີດໃຊ້ງານ';
$string['assign:viewgrades'] = 'ເບິ່ງຄະແນນ';
$string['assign:viewownsubmissionsummary'] = 'ເບິ່ງສະຫຼຸບການສົ່ງຂອງຕົວເອງ';
$string['assignfeedback'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['assignfeedbackpluginname'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['assignmentisdue'] = 'ການມອບໝາຍຮອດກຳນົດ';
$string['assignmentmail'] = '{$a->grader} ໄດ້ໂພສບາງຄຳຕິຊົມກ່ຽວກັບການສົ່ງການມອຍໝາຍຂອງທ່ານສຳລັບ \'{$a->assignment}\'

ທ່ານສາມາດເຫັນມັນຕິດຢູ່ກັບການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} ໄດ້ໂພສບາງຄຳຕິຊົມກ່ຽວກັບການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ \'<i>{$a->assignment}</i>\'.</p>
<p>ທ່ານສາມາດເຫັນມັນຕິດຢູ່ກັບ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.</p>';
$string['assignmentmailsmall'] = '{$a->grader} ໄດ້ໂພສບາງຄຳຕິຊົມກ່ຽວກັບການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ \'{$a->assignment}\' ທ່ານສາມາດເຫັນມັນຕິດຢູ່ກັບການສົ່ງການມອບໝາຍຂອງທ່ານ';
$string['assignmentname'] = 'ຊື່ການມອບໝາຍ';
$string['assignmentplugins'] = 'ປລັກອິນການມອບໝາຍ';
$string['assignmentsperpage'] = 'ການມອບໝາຍຕໍ່ໜ້າ';
$string['assignsubmission'] = 'ປລັກອິນການມອບໝາຍ';
$string['assignsubmissionpluginname'] = 'ປລັກອິນການມອບໝາຍ';
$string['assigntimeleft'] = 'ເວລາທີ່ຍັງເຫຼືອ';
$string['attemptheading'] = 'ພະຍາຍາມ {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'ຄວາມພະຍາຍາມຄັ້ງກ່ອນໜ້າ';
$string['attemptnumber'] = 'ຈຳນວນຄວາມພະຍາຍາມ';
$string['attemptreopenmethod'] = 'ຄວາມພະຍາຍາມເພີ່ມເຕີມ';
$string['attemptreopenmethod_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າ ນັກຮຽນສາມາດພະຍາຍາມເຮັດວຽກຕື່ມໄດ້ບໍ. ສໍາລັບຄວາມພະຍາຍາມແຕ່ລະຄັ້ງ, ຄະແນນ ແລະ ຄໍາຕິຊົມໄດ້ຖືກບັນທຶກໄວ້, ແລະ ສາມາດເບິ່ງໄດ້ໂດຍຄູ ແລະ ນັກຮຽນ. ຕົວເລືອກທີ່ມີຢູ່ແມ່ນ:

* ບໍ່ເຄີຍ - ມີພຽງແຕ່ໜຶ່ງຄວາມພະຍາຍາມເທົ່ານັ້ນ.
* ດ້ວຍຕົນເອງ - ຄູອາດອະນຸຍາດໃຫ້ພະຍາຍາມເພີ່ມເຕີມໄດ້.
* ອັດຕະໂນມັດຈົນກວ່າຈະຜ່ານ - ຄວາມພະຍາຍາມເພີ່ມເຕີມໄດ້ຖືກອະນຸຍາດໂດຍອັດຕະໂນມັດຈົນກ່ວານັກຮຽນບັນລຸໄດ້ຄະແນນ ເພື່ອຜ່ານການຕັ້ງຢູ່ໃນປຶ້ມຄະແນນສໍາລັບວຽກນີ້.';
$string['attemptreopenmethod_manual'] = 'ດ້ວຍຕົວເອງ';
$string['attemptreopenmethod_none'] = 'ບໍ່ເຄີຍ';
$string['attemptreopenmethod_untilpass'] = 'ອັດຕະໂນມັດຈົນກວ່າຜ່ານ';
$string['attemptsettings'] = 'ການຕັ້ງຄ່າຄວາມພະຍາຍາມ';
$string['availability'] = 'ການມີໃຫ້';
$string['back'] = 'ກັບຄືນ';
$string['backtoassignment'] = 'ກັບໄປທີ່ການມອບໝາຍ';
$string['batchoperationconfirmaddattempt'] = 'ອະນຸຍາມຄວາມພະຍາຍາມອີກຄັ້ງສຳລັບການສົ່ງທີ່ໄດ້ເລືອກຫຼືບໍ?';
$string['batchoperationconfirmdownloadselected'] = 'ດາວໂຫຼດການສົ່ງທີ່ໄດ້ເລືອກຫຼືບໍ?';
$string['batchoperationconfirmgrantextension'] = 'ອະນຸມັດສ່ວນຂະຫຍາຍຫາການສົ່ງທີ່ໄດ້ເລືອກທັງໝົດຫຼືບໍ?';
$string['batchoperationconfirmlock'] = 'ລັອກການສົ່ງທີ່ໄດ້ເລືອກທັງໝົດຫຼືບໍ?';
$string['batchoperationconfirmremovesubmission'] = 'ລຶບການສົ່ງທີ່ໄດ້ເລືອກຫຼືບໍ?';
$string['batchoperationconfirmreverttodraft'] = 'ປິ້ນກັບການສົ່ງທີ່ໄດ້ເລືອກຫາສະບັບຮ່າງຫຼືບໍ?';
$string['batchoperationconfirmsetmarkingallocation'] = 'ຕັ້ງການຈັດສັນການໝາຍສຳລັບການສົ່ງທີ່ໄດ້ເລືອກທັງໝົດຫຼືບໍ?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'ຕັ້ງສະຖານະການເຮັດວຽກການໝາຍສຳລັບການສົ່ງທີ່ໄດ້ເລືອກທັງໝົດຫຼືບໍ?';
$string['batchoperationconfirmunlock'] = 'ປົດລັອກການສົ່ງທີ່ໄດ້ເລືອກທັງໝົດຫຼືບໍ?';
$string['batchoperationlock'] = 'ລັອກການສົ່ງ';
$string['batchoperationreverttodraft'] = 'ປີ້ນກັບການສົ່ງຫາສະບັບຮ່າງ';
$string['batchoperationsdescription'] = 'ກັບທີ່ໄດ້ເລືອກ...';
$string['batchoperationunlock'] = 'ປົດລັອກການສົ່ງ';
$string['batchsetallocatedmarker'] = 'ຕັ້ງເຄື່ອງໝາຍທີ່ໄດ້ຈັດສັນສຳລັບຜູ້ໃຊ້ {$a} ທີ່ໄດ້ເລືອກ.';
$string['batchsetmarkingworkflowstateforusers'] = 'ຕັ້ງສະຖານະການເຮັດວຽກການໝາຍສຳລັບຜູ້ໃຊ້ {$a} ທີ່ໄດ້ເລືອກ.';
$string['beginassignment'] = 'ເລີ່ມການມອບໝາຍ';
$string['blindmarking'] = 'ການສົ່ງທີ່ບໍ່ເປີດເຜີຍຊື່';
$string['blindmarking_help'] = 'ການສົ່ງທີ່ບໍ່ເປີດເຜີຍຊື່ເຊື່ອງຕົວຕົນຂອງນັກຮຽນຈາກເຄື່ອງໝາຍ. ການຕັ້ງຄ່າການສົ່ງທີ່ບໍ່ເປີດເຜີຍຊື່ຈະລັອກເມື່ອມີການເຮັດການສົ່ງ ຫຼື ໃຫ້ຄະແນນທີ່ກ່ຽວຂ້ອງກັບການມອບໝາຍນີ້.';
$string['blindmarkingenabledwarning'] = 'ການສົ່ງທີ່ບໍ່ເປີດເຜີຍຊື່ຖືກເປີດໃຊ້ງານສຳລັບກິດຈະກຳນີ້. ຄະແນນຈະບໍ່ຖືກເພີ່ມໃສ່ປື້ມຄະແນນຈົນກວ່າຕົວຕົນຂອງນັກຮຽນໄດ້ເປີດເຜີຍຜ່ານ ເມນູການປະຕິບັດການໃຫ້ຄະແນນ.';
$string['cachedef_overrides'] = 'ຂໍ້ມູນການລົບລ້າງຜູ້ໃຊ້ ແລະ ກຸ່ມ';
$string['calendardue'] = '{$a} ຮອດກຳນົດ';
$string['calendargradingdue'] = '{$a} ຮອດກຳນົດເພື່ອໃຫ້ຄະແນນ';
$string['caneditsubmission'] = 'ທ່ານສາມາດແກ້ໄຂການສົ່ງ ແລະ ສົ່ງມັນຫຼັງຈາກໄດ້ຜ່ານເວລາທີ່ຈຳກັດ, ແຕ່ມັນຈະຖືກໝາຍວ່າສົ່ງຊ້າ.';
$string['changefilters'] = 'ປ່ຽນແປງຕົວກັ່ນຕອງ';
$string['changeuser'] = 'ປ່ຽນແປງຜູ້ໃຊ້';
$string['choosegradingaction'] = 'ປະຕິບັດການໃຫ້ຄະແນນ';
$string['choosemarker'] = 'ເລືອກ...';
$string['chooseoperation'] = 'ດຳເນີນການເລືອກ';
$string['clickexpandreviewpanel'] = 'ຄລິກເພື່ອຂະຫຍາຍແຜງທົບທວນ';
$string['collapsegradepanel'] = 'ຍຸບແຜງໃຫ້ຄະແນນລົງ';
$string['collapsereviewpanel'] = 'ຍຸບແຜງທົບທວນລົງ';
$string['comment'] = 'ຄຳເຫັນ';
$string['completiondetail:submit'] = 'ເຮັດການສົ່ງ';
$string['completionsubmit'] = 'ນັກຮຽນຕ້ອງສົ່ງກິດຈະກຳນີ້ເພື່ອໃຫ້ມັນສຳເລັດ';
$string['configshowrecentsubmissions'] = 'ທຸກຄົນສາມາດເຫັນແຈ້ງການຂອງການສົ່ງໃນບົດລາຍງານກິດຈະກຳປະຈຸບັນ.';
$string['confirmbatchgradingoperation'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການ {$a->operation} ສຳລັບນັກຮຽນ {$a->count} ຄົນ?';
$string['confirmstart'] = 'ການສົ່ງຂອງທ່ານຈະມີການຈຳກັດເວລາ {$a}. ເມື່ອທ່ານເລີ່ມຕົ້ນ, ເຄື່ອງຈັບເວລາຈະເລີ່ມນັບລົງ  ແລະ ບໍ່ສາມາດຢຸດຊົ່ວຄາວໄດ້. ທ່ານຕ້ອງສໍາເລັດການສົ່ງຂອງທ່ານກ່ອນທີ່ມັນຈະໝົດອາຍຸ. ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການເລີ່ມຕົ້ນດຽວນີ້?';
$string['confirmsubmission'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການສົ່ງວຽກເພື່ອໃຫ້ຄະແນນ? ທ່ານຈະບໍ່ສາມາດເຮັດການປ່ຽນແປງໄດ້ອີກຕໍ່ໄປ.';
$string['confirmsubmissionheading'] = 'ຢືນຢັນການສົ່ງ';
$string['conversionexception'] = 'ບໍ່ສາມາດປ່ຽນການມອບໝາຍໄດ້. ຍົກເວັ້ນ: {$a}.';
$string['couldnotconvertgrade'] = 'ບໍ່ສາມາດປ່ຽນຄະແນນການມອບໝາຍໄດ້ສຳລັບຜູ້ໃຊ້ {$a}.';
$string['couldnotconvertsubmission'] = 'ບໍ່ສາມາດປ່ຽນການສົ່ງການມອບໝາຍສຳລັບຜູ້ໃຊ້ {$a}.';
$string['couldnotcreatecoursemodule'] = 'ບໍ່ສາມາດສ້າງຊຸດລາຍວິຊາ.';
$string['couldnotcreatenewassignmentinstance'] = 'ບໍ່ສາມາດສ້າງຕົວຢ່າງການມອບໝາຍໃໝ່.';
$string['couldnotfindassignmenttoupgrade'] = 'ບໍ່ສາມາດສ້າງຕົວຢ່າງການມອບໝາຍເກົ່າເພື່ອຍົກລະດັບ.';
$string['crontask'] = 'ການປະມວນພື້ນຫຼັງສຳລັບຊຸດການມອບໝາຍ';
$string['currentassigngrade'] = 'ຄະແນນປະຈຸບັນໃນການມອບໝາຍ';
$string['currentattempt'] = 'ນີ້ແມ່ນຄວາມພະຍາຍາມ {$a}.';
$string['currentattemptof'] = 'ນີ້ແມ່ນຄວາມພະຍາຍາມ {$a->attemptnumber} ( {$a->maxattempts} ຄວາມພະຍາຍາມທີ່ອະນຸຍາດ ).';
$string['currentgrade'] = 'ຄະແນນປະຈຸບັນໃນປື້ມຄະແນນ';
$string['cutoffdate'] = 'ວັນທີຕັດອອກ';
$string['cutoffdate_help'] = 'ຖ້າຕັ້ງຄ່າ, ການມອບໝາຍຈະບໍ່ຍອມຮັບການສົ່ງຫຼັງຈາກວັນທີນີ້ໂດຍປາສະຈາກສ່ວນຂະຫຍາຍ.';
$string['cutoffdatecolon'] = 'ວັນທີຕັດອອກ: {$a}';
$string['cutoffdatefromdatevalidation'] = 'ວັນທີຕັດອອກບໍ່ສາມາດເປັນວັນທີກ່ອນການອະນຸຍາດການສົ່ງ.';
$string['cutoffdatevalidation'] = 'ວັນທີຕັດອອກບໍ່ສາມາດເປັນວັນທີກ່ອນຮອດກຳນົດ.';
$string['defaultlayout'] = 'ກູ້ຄືນໂຄງຮ່າງເລີ່ມຕົ້ນ';
$string['defaultsettings'] = 'ການຕັ້ງຄ່າການມອບໝາຍເລີ່ມຕົ້ນ';
$string['defaultsettings_help'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ກຳນົດຄ່າເລີ່ມຕົ້ນສຳລັບການມອບໝາຍໃໝ່ທັງໝົດ.';
$string['defaultteam'] = 'ກຸ່ມເລີ່ມຕົ້ນ';
$string['deleteallsubmissions'] = 'ລຶບການສົ່ງທັງໝົດ';
$string['description'] = 'ລາຍລະອຽດ';
$string['disabled'] = 'ປິດໃຊ້ງານແລ້ວ';
$string['downloadall'] = 'ດາວໂຫຼດການສົ່ງທັງໝົດ';
$string['downloadasfolders'] = 'ດາວໂຫຼດການສົ່ງໃນໂຟນເດີ';
$string['downloadasfolders_help'] = 'ການສົ່ງການມອບໝາຍອາດຈະຖືກດາວໂຫຼດຢູ່ໃນໂຟນເດີ. ຈາກນັ້ນການສົ່ງແຕ່ລະອັນຈະຖືກຈັດໃສ່ໃນໂຟນເດີແຍກຕ່າງຫາກ, ໂດຍມີໂຄງສ້າງຂອງໂຟນເດີເກັບໄວ້ສໍາລັບທຸກໂຟນເດີຍ່ອຍ, ແລະໄຟລ໌ຕ່າງໆບໍ່ໄດ້ຖືກປ່ຽນຊື່.';
$string['downloadselectedsubmissions'] = 'ດາວໂຫຼດການສົ່ງທີ່ໄດ້ເລືອກ';
$string['duedate'] = 'ຮອດກຳນົດ';
$string['duedate_help'] = 'ນີ້ແມ່ນໃນເວລາການມອບໝາຍຮອດກຳນົດ. ການສົ່ງຈະຍັງຄົງອະນຸຍາດໃຫ້ຫຼັງຈາກວັນທີນີ້, ແຕ່ການມອບໝາຍໃດໆທີ່ສົ່ງຫຼັງຈາກວັນທີນີ້ຈະຖືກໝາຍວ່າລ່າຊ້າ. ຕັ້ງວັນທີ່ຕັດອອກຂອງການມອບໝາຍເພື່ອປ້ອງກັນການສົ່ງຫຼັງຈາກວັນທີທີ່ແນ່ນອນ.';
$string['duedatecolon'] = 'ວັນທີຮອດກຳນົດ: {$a}';
$string['duedatereached'] = 'ວັນທີຮອດກຳນົດຂອງການມອບໝາຍນີ້ຕອນນີ້ແມ່ນຜ່ານແລ້ວ';
$string['duedatevalidation'] = 'ວັນທີ່ຮອດກຳນົດບໍ່ສາມາດເປັນມື້ກ່ອນໜ້າທີ່ອະນຸຍາດການສົ່ງ.';
$string['duplicateoverride'] = 'ການລົບລ້າງຊໍ້າກັນ';
$string['editaction'] = 'ການປະຕິບັດ...';
$string['editattemptfeedback'] = 'ແກ້ໄຂຄະແນນ ແລະ ຄຳຕິຊົມສຳລັບຄວາມພະຍາຍາມເລກທີ {$a}.';
$string['editingpreviousfeedbackwarning'] = 'ການແກ້ໄຂຄຳຕິຊົມສຳລັບຄວາມພະຍາຍາມກ່ອນໜ້າ. ນີ້ແມ່ນຄວາມພະຍາຍາມ {$a->attemptnumber} ຈາກທັງໝົດ {$a->totalattempts}.';
$string['editingstatus'] = 'ກຳລັງແກ້ໄຂສະຖານະ';
$string['editonline'] = 'ແກ້ໄຂອອນລາຍ';
$string['editoverride'] = 'ແກ້ໄຂການລົບລ້າງ';
$string['editsubmission'] = 'ແກ້ໄຂການສົ່ງ';
$string['editsubmission_help'] = 'ທ່ານຍັງສາມາດເຮັດການປ່ຽນແປງການສົ່ງຂອງທ່ານ.';
$string['editsubmissionother'] = 'ແກ້ໄຂການສົ່ງສຳລັບ';
$string['enabled'] = 'ເປີດໃຊ້ງານແລ້ວ';
$string['enabletimelimit'] = 'ເປີດໃຊ້ງານການມອບໝາຍທີ່ມີເວລາກຳນົດ';
$string['enabletimelimit_help'] = 'ຖ້າເປີດໃຊ້ງານ, ທ່ານສາມາດຕັ້ງເວລາຈຳກັດເທິງໜ້າການຕັ້ງຄ່າການມອບໝາຍ.';
$string['errornosubmissions'] = 'ບໍ່ມີການສົ່ງໃຫ້ດາວໂຫຼດ';
$string['errorquickgradingvsadvancedgrading'] = 'ຄະແນນບໍ່ໄດ້ບັນທຶກຍ້ອນວ່າ ໃນປະຈຸບັນການມອບໝາຍນີ້ນຳໃຊ້ການໃຫ້ຄະແນນຂັ້ນສູງ';
$string['errorrecordmodified'] = 'ຄະແນນບໍ່ໄດ້ບັນທຶກຍ້ອນມີບາງຄົນໄດ້ດັດແກ້ໜຶ່ງ ຫຼື ຫຼາຍບັນທຶກຫຼາຍກວ່າໃນປະຈຸບັນເມື່ອທ່ານໄດ້ໂຫຼດໜ້ານີ້.';
$string['eventallsubmissionsdownloaded'] = 'ການສົ່ງທັງໝົດກຳລັງຖືກດາວໂຫຼດ.';
$string['eventassessablesubmitted'] = 'ການສົ່ງໄດ້ຖືກສົ່ງແລ້ວ.';
$string['eventbatchsetmarkerallocationviewed'] = 'ເບິ່ງການຈັດສັນເຄື່ອງໝາຍຊຸດເປັນຊຸດແລ້ວ';
$string['eventbatchsetworkflowstateviewed'] = 'ເບິ່ງສະຖານະການເຮັດວຽກຊຸດເປັນຊຸດແລ້ວ.';
$string['eventextensiongranted'] = 'ສ່ວນຂະຫຍາຍຖືກອະນຸມັດແລ້ວ.';
$string['eventfeedbackupdated'] = 'ປັບປຸງຄຳຕິຊົມແລ້ວ';
$string['eventfeedbackviewed'] = 'ເບິ່ງຄຳຕິຊົມແລ້ວ';
$string['eventgradingformviewed'] = 'ປັບປຸງແບບຟອມຄະແນນ';
$string['eventgradingtableviewed'] = 'ປັບປຸງຕາຕະລາງຄະແນນ';
$string['eventidentitiesrevealed'] = 'ການລະບຸຕົວຕົນໄດ້ຖືກເປີດເຜີຍແລ້ວ.';
$string['eventmarkerupdated'] = 'ເຄື່ອງໝາຍທີ່ໄດ້ຈັດສັນຖືກປັບປຸງແລ້ວ.';
$string['eventoverridecreated'] = 'ສ້າງການລົບລ້າງການມອບໝາຍແລ້ວ';
$string['eventoverridedeleted'] = 'ລຶບການລົບລ້າງການມອບໝາຍແລ້ວ';
$string['eventoverrideupdated'] = 'ປັບປຸງການລົບລ້າງການມອບໝາຍແລ້ວ';
$string['eventremovesubmissionformviewed'] = 'ເບິ່ງການຢືນຢັນການຍົກຍ້າຍການຈັດສົ່ງແລ້ວ.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'ເບິ່ງໜ້າການຢືນຢັນການເປີດເຜີຍການລະບຸຕົວຕົນແລ້ວ.';
$string['eventstatementaccepted'] = 'ຜູ້ໃຊ້ໄດ້ຍອມຮັບຄຳຖະແລງການສົ່ງແລ້ວ.';
$string['eventsubmissionconfirmationformviewed'] = 'ເບິ່ງແບບຟອມການຢືນຢັນການສົ່ງແລ້ວ.';
$string['eventsubmissioncreated'] = 'ສ້າງການສົ່ງແລ້ວ';
$string['eventsubmissionduplicated'] = 'ຜູ້ໃຊ້ເຮັດການສົ່ງຂອງເຂົາເຈົ້າຊ້ຳກັນ.';
$string['eventsubmissionformviewed'] = 'ເບິ່ງແບບຟອມການສົ່ງແລ້ວ.';
$string['eventsubmissiongraded'] = 'ການສົ່ງຖືກໃຫ້ຄະແນນແລ້ວ.';
$string['eventsubmissionlocked'] = 'ການສົ່ງຖືກລັອກສຳລັບຜູ້ໃຊ້ແລ້ວ.';
$string['eventsubmissionstatusupdated'] = 'ສະຖານະການສົ່ງຖືກປັບປຸງແລ້ວ.';
$string['eventsubmissionstatusviewed'] = 'ເບິ່ງສະຖານະການສົ່ງແລ້ວ.';
$string['eventsubmissionunlocked'] = 'ການສົ່ງຖືກລັອກສຳລັບຜູ້ໃຊ້ແລ້ວ.';
$string['eventsubmissionupdated'] = 'ປັບປຸງການສົ່ງແລ້ວ.';
$string['eventsubmissionviewed'] = 'ເບິ່ງການສົ່ງແລ້ວ.';
$string['eventworkflowstateupdated'] = 'ສະຖານະການເຮັດວຽກຖືກປັບປຸງແລ້ວ.';
$string['expandreviewpanel'] = 'ຂະຫຍາຍແຜງການທົບທວນ';
$string['extensionduedate'] = 'ວັນທີຮອດກຳນົດສ່ວນຂະຫຍາຍ';
$string['extensionnotafterduedate'] = 'ວັນທີ່ສ່ວນຂະຫຍາຍຕ້ອງຫຼັງຈາກວັນທີຮອດກຳນົດ';
$string['extensionnotafterfromdate'] = 'ວັນທີ່ສ່ວນຂະຫຍາຍຕ້ອງຫຼັງຈາກວັນທີອະນຸຍາດການສົ່ງ';
$string['feedback'] = 'ຄຳຕິຊົມ';
$string['feedbackavailableanonhtml'] = 'ທ່ານມີຄຳຕິຊົມໃໝ່ກ່ຽວກັບການສົ່ງການມອບໝາຍສຳລັບ \'<i>{$a->assignment}</i>\'<br /><br />
ເຈົ້າສາມາດເຫັນມັນຕິດຕໍ່ທ້າຍໃນ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.';
$string['feedbackavailableanonsmall'] = 'ຄຳຕິຊົມໃໝ່ສຳລັບການມອບໝາຍ {$a->assignment}';
$string['feedbackavailableanontext'] = 'ທ່ານມີຄຳຕິຊົມໃໝ່ກ່ຽວກັບການສົ່ງການມອບໝາຍສຳລັບ \'{$a->assignment}\'

ທ່ານສາມາດເຫັນມັນຕໍ່ທ້າຍໃນການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} ໄດ້ໂພສຄຳຕິຊົມບາງຢ່າງກ່ຽວກັບທ່ານກ່ຽວກັບການສົ່ງການມອບໝາຍສຳລັບ \'<i>{$a->assignment}</i>\'<br /><br />
ທ່ານສາມາດເຫັນມັນຕໍ່ທ້າຍໃນ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.';
$string['feedbackavailablesmall'] = '{$a->username} ໄດ້ໃຫ້ຄຳຕິຊົມສຳລັບການສົ່ງ {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} ໄດ້ໂພສຄຳຕິຊົມບາງຢ່າງກ່ຽວກັບທ່ານກ່ຽວກັບການສົ່ງການມອບໝາຍສຳລັບ \'{$a->assignment}\'

ທ່ານສາມາດເຫັນມັນຕໍ່ທ້າຍໃນການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['feedbackplugin'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['feedbackpluginforgradebook'] = 'ປລັກອິນຄຳຕິຊົມຈະຍູ້ຄຳເຫັນໄປຫາປື້ມຄະແນນ';
$string['feedbackpluginforgradebook_help'] = 'ພຽງແຕ່ໜຶ່ງການມອບໝາຍປລັກອິນຄຳຕິຊົມສາມາດຍູ້ຄຳຕິຊົມໄປຫາປື້ມຄະແນນ.';
$string['feedbackplugins'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['feedbacksettings'] = 'ການຕັ້ງຄ່າຄຳຕິຊົມ';
$string['feedbacktypes'] = 'ປະເພດຄຳຕິຊົມ';
$string['filesubmissions'] = 'ການສົ່ງໄຟລ໌';
$string['filter'] = 'ຕົວກັ່ນຕອງ';
$string['filterdraft'] = 'ສະບັບຮ່າງ';
$string['filtergrantedextension'] = 'ອະນຸມັດສ່ວນຂະຫຍາຍ';
$string['filternone'] = 'ບໍ່ມີຕົວກັ່ນຕອງ';
$string['filternotsubmitted'] = 'ບໍ່ໄດ້ສົ່ງເທື່ອ';
$string['filterrequiregrading'] = 'ຕ້ອງການການໃຫ້ຄະແນນ';
$string['filtersubmitted'] = 'ສົ່ງແລ້ວ';
$string['fixrescalednullgrades'] = 'ການມອບໝາຍນີ້ມີຄະແນນທີ່ຜິດພາດບາງອັນ. ທ່ານສາມາດ <a href="{$a->link}">ແປງຄະແນນເຫຼົ່ານີ້ອັດຕະໂນມັດ</a>. ສິ່ງນີ້ອາດກະທົບເຖິງການລວມລາຍວິຊາ.';
$string['fixrescalednullgradesconfirm'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການແປງຄະແນນທີ່ຜິດພາດ? ຄະແນນທີ່ມີຜົນກະທົບທັງໝົດຈະຖືກຍ້າຍອອກ. ສິ່ງນີ້ອາດກະທົບເຖິງການລວມລາຍວິຊາ.';
$string['fixrescalednullgradesdone'] = 'ແປງຄະແນນແລ້ວ.';
$string['gradeabovemaximum'] = 'ຄະແນນຕ້ອງໜ້ອຍກວ່າ ຫຼື ເທົ່າກັບ {$a}.';
$string['gradebelowzero'] = 'ຄະແນນຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບສູນ.';
$string['gradecanbechanged'] = 'ຄະແນນສາມາດຖືກປ່ຽນແປງ';
$string['gradechangessaveddetail'] = 'ບັນທຶກການປ່ຽນແປງຄະແນນ ແລະ ຄຳຕິຊົມແລ້ວ';
$string['graded'] = 'ໃຫ້ຄະແນນແລ້ວ';
$string['gradedby'] = 'ໃຫ້ຄະແນນແລ້ວໂດຍ';
$string['gradedfollowupsubmit'] = 'ໃຫ້ຄະແນນແລ້ວ - ຕິດຕາມການສົ່ງທີ່ໄດ້ຮັບ';
$string['gradedon'] = 'ໃຫ້ຄະແນນແລ້ວໃນ';
$string['gradeitem:submissions'] = 'ການສົ່ງ';
$string['gradelocked'] = 'ຄະແນນຖືກລັອກ ຫຼື ລົບລ້າງໃນປື້ມຄະແນນ';
$string['gradeoutof'] = 'ຄະແນນຈາກທັງໝົດ {$a}';
$string['gradeoutofhelp'] = 'ຄະແນນ';
$string['gradeoutofhelp_help'] = 'ໃສ່ຄະແນນການສົ່ງຂອງນັກຮຽນທີ່ນີ້. ເຈົ້າອາດຈະລວມເອົາເລກທົດສະນິຍົມ.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} ໄດ້ປັບປຸງການສົ່ງການມອບໝາຍຂອງເຂົາເຈົ້າສຳລັບ <i>\'{$a->assignment}\'  ທີ່ {$a->timeupdated}</i><br /><br />
ມັນແມ່ນ <a href="{$a->url}">ທີ່ມີໃຫ້ເທິງເວັບໄຊທ໌</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} ໄດ້ປັບປຸງການສົ່ງຂອງເຂົາເຈົ້າສຳລັບການມອບໝາຍ {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} ໄດ້ປັບປຸງການສົ່ງການມອບໝາຍຂອງເຂົາເຈົ້າສຳລັບ \'{$a->assignment}\' ທີ່ {$a->timeupdated}

ມັີມີຢູ່ທີ່ນີ້:

    {$a->url}';
$string['gradestudent'] = 'ຄະແນນນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'ຄະແນນ {$a}';
$string['grading'] = 'ການໃຫ້ຄະແນນ';
$string['gradingchangessaved'] = 'ບັນທຶກການປ່ຽນແປງຄະແນນ';
$string['gradingduedate'] = 'ເຕືອນຂ້ອຍເພື່ອໃຫ້ຄະແນນໂດຍ';
$string['gradingduedate_help'] = 'ວັນທີຄາດວ່າການໝາຍການສົ່ງຄວນຈະສໍາເລັດພາຍໃນ. ວັນທີນີ້ຖືກໃຊ້ເພື່ອຈັດລໍາດັບຄວາມສໍາຄັນຂອງການແຈ້ງເຕືອນແຜງໜ້າປັດສໍາລັບຄູສອນ.';
$string['gradingdueduedatevalidation'] = 'ເຕືອນຂ້ອຍເພື່ອໃຫ້ຄະແນນໂດຍວັນທີບໍ່ສາມາດເປັນກ່ອນໜ້າວັນທີຮອດກຳນົດ.';
$string['gradingduefromdatevalidation'] = 'ເຕືອນຂ້ອຍເພື່ອໃຫ້ຄະແນນໂດຍວັນທີບໍ່ສາມາດເປັນກ່ອນໜ້າວັນທີການສົ່ງທີ່ອະນຸຍາດ.';
$string['gradingmethodpreview'] = 'ເກນການໃຫ້ຄະແນນ';
$string['gradingoptions'] = 'ທາງເລືອກ';
$string['gradingstatus'] = 'ສະຖານະການໃຫ້ຄະແນນ';
$string['gradingstudent'] = 'ການໃຫ້ຄະແນນນັກຮຽນ';
$string['gradingsummary'] = 'ສະຫຼຸບການໃຫ້ຄະແນນ';
$string['grantextension'] = 'ສ່ວນຂະຫຍາຍການອະນຸມັດ';
$string['grantextensionforusers'] = 'ສ່ວນຂະຫຍາຍການອະນຸມັດສຳລັບ {$a} ນັກຮຽນ';
$string['groupoverrides'] = 'ລົບລ້າງກຸ່ມ';
$string['groupoverridesdeleted'] = 'ລຶບການລົບລ້າງກຸ່ມ';
$string['groupsnone'] = 'ບໍ່ມີກຸ່ມທີ່ທ່ານສາມາດເຂົ້າຫາ.';
$string['groupsubmissionsettings'] = 'ການຕັ້ງຄ່າການສົ່ງກຸ່ມ';
$string['hiddenuser'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['hidegrader'] = 'ເຊື່ອງການລະບຸຕົວຕົນຜູ້ໃຫ້ຄະແນນຈາກນັກຮຽນ';
$string['hidegrader_help'] = 'ຖ້າເປີດໃຊ້ງານ, ການລະບຸຕົວຕົນນັກຮຽນໃດໜຶ່ງທີ່ໃຫ້ຄະແນນການສົ່ງການມອບໝາຍແມ່ນບໍ່ສະແດງ, ສະນັ້ນ ນັກຮຽນບໍ່ສາມາດເຫັນວ່າໃຜໝາຍວຽກຂອງເຂົາເຈົ້າ.

ກະລຸນາຮັບຊາບວ່າ ການຕັ້ງຄ່ານີ້ບໍ່ມີຜົນກະທົບໃນກ່ອງຄຳເຫັນເທິງໜ້າການໃຫ້ຄະແນນ.';
$string['hideshow'] = 'ເຊື່ອງ/ສະແດງ';
$string['inactiveoverridehelp'] = 'ການລົບລ້າງນີ້ບໍ່ມີການເຄື່ອນໄຫວຍ້ອນວ່າການເຂົ້າຫາຂອງຜູ້ໃຊ້ຫາກິດຈະກຳຖືກຈຳກັດ. ສິ່ງອາດເປັນຍ້ອນກຸ່ມ ຫຼື ໜ້າທີ່ຂອງການມອບໝາຍ, ຂໍ້ຈຳກັດການເຂົ້າຫາອື່ນໆ, ຫຼື ກິດຈະກຳອື່ນໆທີ່ຖືກເຊື່ອງໄວ້.';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ທີ່ໄດ້ມີການມອບໝາຍ';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ອີງຕາມຄວາມຮູ້ທີ່ເລີກເຊີ່ງຂອງນັກຮຽນທີ່ເຂົ້າໃຈໃນກິດຈະກຳການມອບໝາຍ.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ທີ່ໄດ້ມີການມອບໝາຍ';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງດ້ານມັນສະໝອງທີ່ສະເໜີໂດຍກິດຈະກໍາການມອບໝາຍໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເບິ່ງ, ເບິ່ງ, ສົ່ງ, ເບິ່ງຄໍາຕິຊົມ, ຄໍາເຫັນກ່ຽວກັບຄໍາຕິຊົມ, ສົ່ງຄືນຫຼັງຈາກເບິ່ງຄໍາຕິຊົມ)';
$string['indicator:socialbreadth'] = 'ສັງຄົມການມອບໝາຍ';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງທາງສັງຄົມທີ່ນັກຮຽນເຂົ້າໃຈໃນກິດຈະກໍາການມອບໝາຍ.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມການມອບໝາຍ';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາການມອບໝາຍໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຜູ້ດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຜູ້ອື່ນ)';
$string['instructionfiles'] = 'ໄຟລ໌ຄຳແນະນຳ';
$string['introattachments'] = 'ໄຟລ໌ເພີ່ມເຕີມ';
$string['introattachments_help'] = 'ໄຟລ໌ເພີ່ມເຕີມເພື່ອໃຊ້ເຂົ້າໃນວຽກມອບໝາຍເຊັ່ນ: ແມ່ແບບຄຳຕອບອາດຖືກເພີ່ມໃສ່.';
$string['invalidfloatforgrade'] = 'ບໍ່ເຂົ້າໃຈຄະແນນທີ່ໃຫ້ມາ: {$ a}';
$string['invalidgradeforscale'] = 'ຄະແນນທີ່ໃຫ້ມາບໍ່ຖືກຕ້ອງສຳລັບມາດຕາສ່ວນປະຈຸບັນ';
$string['invalidoverrideid'] = 'ລະຫັດປະຈຳຕົວລົບລ້າງບໍ່ຖືກຕ້ອງ';
$string['lastmodifiedgrade'] = 'ການດັດແກ້ຫຼ່າສຸດ (ຄະແນນ)';
$string['lastmodifiedsubmission'] = 'ການດັດແກ້ຫຼ່າສຸດ (ການສົ່ງ)';
$string['latesubmissions'] = 'ການດັດແກ້ຫຼ່າສຸດ';
$string['latesubmissionsaccepted'] = 'ອະນຸຍາດຈົນກວ່າ {$a}';
$string['loading'] = 'ກຳລັງໂຫຼດ...';
$string['locksubmissionforstudent'] = 'ປ້ອງກັນການສົ່ງເພີ່ມເຕີມສຳລັບນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'ລັອກການສົ່ງ';
$string['manageassignfeedbackplugins'] = 'ຈັດການປລັກອິນການມອບໝາຍຄຳຕິຊົມ';
$string['manageassignsubmissionplugins'] = 'ຈັດການປລັກອິນການມອບໝາຍການສົ່ງ';
$string['marker'] = 'ເຄື່ອງໝາຍ';
$string['markerfilter'] = 'ຕົວກັ່ນຕອງເຄື່ອງໝາຍ';
$string['markerfilternomarker'] = 'ບໍ່ມີເຄື່ອງໝາຍ';
$string['markingallocation'] = 'ນຳໃຊ້ການຈັດສັນການໝາຍ';
$string['markingallocation_help'] = 'ຖ້າເປີດໃຊ້ງານນຳກັນດ້ວຍເຄື່ອງໝາຍຂັ້ນຕອນການເຮັດວຽກ, ເຄື່ອງໝາຍສາມາດຈັດສັນໄປຫານັກຮຽນໂດຍສະເພາະ.';
$string['markingworkflow'] = 'ໃຊ້ເຄື່ອງາຍຂັ້ນຕອນການເຮັດວຽກ';
$string['markingworkflow_help'] = 'ຖ້າເປີດນຳໃຊ້, ເຄື່ອງໝາຍຈະຜ່ານໄລຍະຂອງຂັ້ນຕອນການເຮັດວຽກກ່ອນທີ່ຈະປ່ອຍໃຫ້ນັກຮຽນ. ສິ່ງນີ້ອະນຸຍາດໃຫ້ມີການໝາຍຫຼາຍຮອບ ແລະ ອະນຸຍາດໃຫ້ປ່ອຍເຄື່ອງໝາຍໃຫ້ກັບນັກຮຽນທຸກຄົນໃນເວລາດຽວກັນ.';
$string['markingworkflowstate'] = 'ສະຖານະເຄື່ອງໝາຍຂັ້ນຕອນການເຮັດວຽກ';
$string['markingworkflowstate_help'] = 'ສະຖານະການເຮັດວຽກທີ່ເປັນໄປໄດ້ອາດຈະລວມມີ (ອີງຕາມການອະນຸຍາດຂອງທ່ານ):

* ບໍ່ໄດ້ໝາຍໄວ້ - ເຄື່ອງໝາຍຍັງບໍ່ທັນເລີ່ມເທື່ອ
* ກຳລັງໝາຍ - ເຄື່ອງໝາຍໄດ້ເລີ່ມຕົ້ນແຕ່ຍັງບໍ່ທັນແລ້ວເທື່ອ
* ການໝາຍສຳເລັດແລ້ວ - ເຄື່ອງໝາຍໄດ້ ສຳ ເລັດແລ້ວແຕ່ອາດຈະຕ້ອງກັບໄປກວດຄືນ/ກວດແກ້
* ຢູ່ໃນການທົບທວນຄືນ - ປະຈຸບັນເຄື່ອງໝາຍຢູ່ກັບຄູສອນທີ່ຮັບຜິດຊອບສໍາລັບການກວດກາຄຸນນະພາບ
* ກຽມພ້ອມສໍາລັບການປ່ອຍ - ຄູສອນທີ່ຮັບຜິດຊອບພໍໃຈກັບການໝາຍແຕ່ອາດຈະລໍຖ້າກ່ອນທີ່ຈະໃຫ້ນັກຮຽນເຂົ້າເຖິງການໝາຍ
* ປ່ອຍອອກມາ - ນັກຮຽນສາມາດເຂົ້າເຖິງຄະແນນ/ຄຳຕິຊົມ';
$string['markingworkflowstateinmarking'] = 'ກຳລັງໝາຍ';
$string['markingworkflowstateinreview'] = 'ກຳລັງທົບທວນ';
$string['markingworkflowstatenotmarked'] = 'ບໍ່ໄດ້ໝາຍ';
$string['markingworkflowstatereadyforrelease'] = 'ກຽມພ້ອມປ່ອຍ';
$string['markingworkflowstatereadyforreview'] = 'ສຳເລັດການໝາຍ';
$string['markingworkflowstatereleased'] = 'ປ່ອຍແລ້ວ';
$string['maxattempts'] = 'ຄວາມພະຍາຍາມສູງສຸດ';
$string['maxattempts_help'] = 'ຈໍານວນສູງສຸດຂອງຄວາມພະຍາຍາມສົ່ງທີ່ສາມາດເຮັດໄດ້ໂດຍນັກຮຽນ. ຫຼັງຈາກຕົວເລກນີ້ໄດ້ບັນລຸແລ້ວ, ການສົ່ງບໍ່ສາມາດຖືກເປີດຄືນໄດ້ອີກ.';
$string['maxgrade'] = 'ຄະແນນສູງສຸດ';
$string['maxperpage'] = 'ການມອບໝາຍສູງສຸດຕໍ່ໜ້າ';
$string['maxperpage_help'] = 'ຈຳນວນການມອບໝາຍສູງສຸດຂອງນັກຮຽນສາມາດສະແດງໃຫ້ເຫັນຢູ່ໃນໜ້າການໃຫ້ຄະແນນການມອບໝາຍ. ການຕັ້ງຄ່ານີ້ເປັນປະໂຫຍດໃນການປ້ອງກັນການໝົດເວລາສໍາລັບວິຊາທີ່ມີຜູ້ເຂົ້າຮ່ວມເປັນຈໍານວນຫຼາຍ.';
$string['messageprovider:assign_notification'] = 'ແຈ້ງການການມອບໝາຍ';
$string['modulename'] = 'ການມອບໝາຍ';
$string['modulename_help'] = 'ໂມດູນກິດຈະກໍາການມອບໝາຍຊ່ວຍໃຫ້ຄູສອນສາມາດສື່ສານວຽກງານ, ເກັບກໍາວຽກ ແລະ ໃຫ້ຄະແນນ ແລະ ຄໍາຕິຊົມ.

ນັກຮຽນສາມາດສົ່ງເນື້ອໃນດິຈິຕອລ (ໄຟລ໌) ເຊັ່ນ: ເອກະສານທີ່ປະມວນຜົນດ້ວຍຄໍາສັບ, ສະເປຣດຊີດ, ຮູບພາບ, ຫຼື ຄລິບສຽງ ແລະ ວິດີໂອ. ອີກທາງເລືອກໜຶ່ງ, ຫຼືນອກຈາກນັ້ນ, ການມອບໝາຍ ອາດຈະຕ້ອງການໃຫ້ນັກຮຽນພິມຂໍ້ຄວາມໂດຍກົງໃສ່ຕົວແກ້ໄຂຂໍ້ຄວາມ. ການມອບໝາຍວຽກໜຶ່ງຍັງສາມາດຖືກນຳໃຊ້ເພື່ອເຕືອນນັກຮຽນກ່ຽວກັບວຽກ \'ໂລກແຫ່ງຄວາມເປັນຈິງ\' ທີ່ເຂົາເຈົ້າຕ້ອງການໃຫ້ສຳເລັດອອຟລາຍເຊັ່ນ: ວຽກສິລະປະ, ແລະ ດັ່ງນັ້ນບໍ່ຕ້ອງການເນື້ອໃນດິຈິຕອລ. ນັກຮຽນສາມາດສົ່ງວຽກງານສ່ວນບຸກຄົນ ຫຼື ເປັນສະມາຊິກຂອງກຸ່ມ.

ເມື່ອທົບທວນຄືນການມອບໝາຍ, ຄູສອນສາມາດປະກອບຄໍາຄິດເຫັນຄືນໃໝ່ ແລະ ອັບໂຫຼດໄຟລ໌ ເຊັ່ນ: ການສົ່ງເຄື່ອງໝາຍຂອງນັກຮຽນ, ເອກະສານທີ່ມີຄໍາຄິດເຫັນ ຫຼື ຄໍາຄິດເຫັນທີ່ເວົ້າດ້ວຍສຽງ. ການມອບໝາຍວຽກສາມາດໃຫ້ຄະແນນໄດ້ໂດຍໃຊ້ຂະ ໜາດຕົວເລກ ຫຼື ກຳນົດເອງ ຫຼື ວິທີການຈັດອັນດັບຂັ້ນສູງເຊັ່ນ: ບົດເລື່ອງ. ຄະແນນສຸດທ້າຍຖືກບັນທຶກໄວ້ໃນປຶ້ມຮຽນ.';
$string['modulenameplural'] = 'ການມອບໝາຍ';
$string['moreusers'] = '{$a} ເພີ່ມເຕີມ...';
$string['multipleteams'] = 'ສະມາຊິກຂອງຫຼາຍກວ່າໜຶ່ງກຸ່ມ';
$string['multipleteams_desc'] = 'ການມອບໝາຍຮຽກຮ້ອງໃຫ້ມີການຍື່ນສະເໜີເປັນກຸ່ມ. ທ່ານເປັນສະມາຊິກຂອງຫຼາຍກວ່າໜຶ່ງກຸ່ມ. ເພື່ອຈະສາມາດຍື່ນສະເໜີໄດ້ ທ່ານຕ້ອງເປັນສະມາຊິກຂອງກຸ່ມດຽວເທົ່ານັ້ນ. ກະລຸນາຕິດຕໍ່ຫາຄູສອນຂອງທ່ານ ເພື່ອປ່ຽນສະມາຊິກກຸ່ມຂອງທ່ານ.';
$string['multipleteamsgrader'] = 'ສະມາຊິກຂອງຫຼາຍກວ່າໜຶ່ງກຸ່ມ, ສະນັ້ນບໍ່ສາມາດເຮັດການສົ່ງ';
$string['newsubmissions'] = 'ການມອບໝາຍສົ່ງແລ້ວ';
$string['nextuser'] = 'ຜູ້ໃຊ້ຄົນຕໍ່ໄປ';
$string['noattempt'] = 'ບໍ່ມີຄວາມພະຍາຍາມ';
$string['noclose'] = 'ບໍ່ມີວັນທີປິດ';
$string['nofiles'] = 'ບໍ່ມີໄຟລ໌.';
$string['nofilters'] = 'ບໍ່ມີຕົວກັ່ນຕອງ';
$string['nograde'] = 'ບໍ່ມີຄະແນນ.';
$string['nogroupoverrides'] = 'ປະຈຸບັນບໍ່ມີການລົບລ້າງກຸ່ມ.';
$string['nomoresubmissionsaccepted'] = 'ອະນຸຍາດຜູ້ເຂົ້າຮ່ວມທີ່ຖືກອະນຸມັດສ່ວນຂະຫຍາຍເທົ່ານັ້ນ';
$string['none'] = 'ບໍ່ມີ';
$string['noonlinesubmissions'] = 'ການມອບໝາຍນີ້ທ່ານບໍ່ຈຳເປັນຕ້ອງສົ່ງອັນໃດທາງອອນລາຍ';
$string['noopen'] = 'ບໍ່ມີວັນທີເປີດ';
$string['nooverridedata'] = 'ທ່ານຕ້ອງລົບລ້າງຢ່າງໜ້ອຍໜຶ່ງການຕັ້ງຄ່າການມອບໝາຍ.';
$string['nosavebutnext'] = 'ຕໍ່ໄປ';
$string['nosubmission'] = 'ສຳລັບການມອບໝາຍນີ້ບໍ່ມີຫຍັງຕ້ອງສົ່ງ';
$string['nosubmissionyet'] = 'ຍັງບໍ່ໄດ້ເຮັດການສົ່ງເທື່ອ';
$string['noteam'] = 'ບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມໃດໆ';
$string['noteam_desc'] = 'ການມອບໝາຍນີ້ຕ້ອງການການສົ່ງໃນກຸ່ມ. ທ່ານບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມໃດໆ, ສະນັ້ນທ່ານບໍ່ສາມາດສ້າງການສົ່ງ. ກະລຸນາຕິດຕໍ່ຄູສອນຂອງທ່ານເພີມຖືກເພີ່ມເຂົ້າໃນກຸ່ມ.';
$string['noteamgrader'] = 'ບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມໃດໆ, ສະນັ້ນທ່ານບໍ່ສາມາດເຮັດການສົ່ງ.';
$string['notgraded'] = 'ບໍ່ໄດ້ໃຫ້ຄະແນນ';
$string['notgradedyet'] = 'ບໍ່ໄດ້ໃຫ້ຄະແນນເທື່ອ';
$string['notifications'] = 'ການແຈ້ງການ';
$string['nouseroverrides'] = 'ປະຈຸບັນບໍ່ມີການລົບລ້າງຜູ້ໃຊ້.';
$string['nousers'] = 'ບໍ່ມີຜູ້ໃຊ້';
$string['nousersselected'] = 'ບໍ່ມີຜູ້ໃຊ້ໄດ້ເລືອກ';
$string['numberofdraftsubmissions'] = 'ສະບັບຮ່າງ';
$string['numberofparticipants'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['numberofsubmissionsneedgrading'] = 'ຕ້ອງການການໃຫ້ຄະແນນ';
$string['numberofsubmissionsneedgradinglabel'] = 'ຕ້ອງການໃຫ້ຄະແນນ: {$a}';
$string['numberofsubmittedassignments'] = 'ສົ່ງແລ້ວ';
$string['numberofteams'] = 'ກຸ່ມ';
$string['offline'] = 'ບໍ່ຈຳເປັນຕ້ອງສົ່ງທາງອອນລາຍ';
$string['open'] = 'ເປີດ';
$string['opensubmissionexists'] = 'ການຍື່ນມອບໝາຍວຽກທີ່ເປີດຢູ່ແລ້ວ.';
$string['outlinegrade'] = 'ຄະແນນ: {$a}';
$string['outof'] = '{$a->current} ຈາກທັງໝົດ {$a->total}';
$string['overdue'] = 'ການມອບໝາຍເກີນກຳນົດໂດຍ: {$a}';
$string['override'] = 'ລົບລ້າງ';
$string['overridedeletegroupsure'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການລຶບການລົບລ້າງສຳລັບກຸ່ມ {$a}?';
$string['overridedeleteusersure'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການລຶບການລົບລ້າງສຳລັບຜູ້ໃຊ້ {$a}?';
$string['overridegroup'] = 'ລົບລ້າງກຸ່ມ';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'ລົບລ້າງ';
$string['overrideuser'] = 'ລົບລ້າງຜູ້ໃຊ້';
$string['overrideusereventname'] = '{$a->assign} - ລົບລ້າງ';
$string['page-mod-assign-view'] = 'ຊຸດການມອບໝາຍຫຼັກ ແລະ ໜ້າການມອບໝາຍ';
$string['page-mod-assign-x'] = 'ໜ້າຊຸດການມອບໝາຍໃດໆ';
$string['paramtimeremaining'] = '{$a} ທີ່ຍັງເຫຼືອ';
$string['participant'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['pluginadministration'] = 'ການບໍລິຫານການມອບໝາຍ';
$string['pluginname'] = 'ການມອນໝາຍ';
$string['preventsubmissionnotingroup'] = 'ກຸ່ມທີ່ຕ້ອງການເຮັດການສົ່ງ';
$string['preventsubmissionnotingroup_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ທີ່ບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມຈະບໍ່ສາມາດເຮັດການສົ່ງ.';
$string['preventsubmissions'] = 'ປ້ອງກັນຜູ້ໃຊ້ເຮັດການສົ່ງເພີ່ມເຕີມໃດໆໃນການມອບໝາຍນີ້.';
$string['preventsubmissionsshort'] = 'ປ້ອງກັນການປ່ຽນແປງການສົ່ງ';
$string['previous'] = 'ກ່ອນໜ້າ';
$string['previoususer'] = 'ຜູ້ໃຊ້ກ່ອນໜ້າ';
$string['privacy:attemptpath'] = 'ພະຍາຍາມ {$a}';
$string['privacy:blindmarkingidentifier'] = 'ຕົວລະບຸທີ່ໃຊ້ສຳລັບການສົ່ງທີ່ບໍ່ລະບຸຊື່';
$string['privacy:gradepath'] = 'ຄະແນນ';
$string['privacy:metadata:assigndownloadasfolders'] = 'ການຕັ້ງຄ່າຜູ້ໃຊ້ສຳລັບບໍ່ວ່າການສົ່ງຫຼາຍໄຟລ໌ຄວນຖືກດາງໂຫຼດເຂົ້າໃນໂຟເດີຫຼືບໍ່';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'ຂໍ້ມູນຄຳຕິຊົມສຳລັບການມອບໝາຍ.';
$string['privacy:metadata:assignfilter'] = 'ທາງເລືອກຕົວກັ່ນຕອງເຊັ່ນ: \'ສົ່ງແລ້ວ\', \'ບໍ່ໄດ້ສົ່ງ\', \'ຈຳເປັນຕ້ອງໃຫ້ຄະແນນ\', ແລະ \'ອະນຸມັດສ່ວນຂະຫຍາຍ\'';
$string['privacy:metadata:assigngrades'] = 'ເກັນຮັກສາຄະແນນຜູ້ໃຊ້ສຳລັບການມອບໝາຍ';
$string['privacy:metadata:assignmarkerfilter'] = 'ຕົວກັ່ນຕອງສະຫຼຸບການມອບໝາຍໂດຍເຄື່ອງໝາຍທີ່ຖືກມອບໝາຍ';
$string['privacy:metadata:assignmentid'] = 'ລະຫັດປະຈຳຕົວການມອບໝາຍ';
$string['privacy:metadata:assignmessageexplanation'] = 'ຂໍ້ຄວາມຖືກສົ່ງໄປຫານັກຮຽນຜ່ານລະບົບການສົ່ງຂໍ້ຄວາມ.';
$string['privacy:metadata:assignoverrides'] = 'ເກັນຮັກສາຂໍ້ມູນການລົບລ້າງສຳລັບການມອບໝາຍ';
$string['privacy:metadata:assignperpage'] = 'ຈຳນວນການມອບໝາຍທີ່ຖືກສະແດງຕໍ່ໜ້າ.';
$string['privacy:metadata:assignquickgrading'] = 'ການຕັ້ງຄ່າເປັນບໍ່ວ່າຈະເປັນການໃຫ້ຄະແນນດ່ວນໄດ້ຖືກນຳໃຊ້ຫຼືບໍ່.';
$string['privacy:metadata:assignsubmissiondetail'] = 'ເກັບຮັກສາຂໍ້ມູນການສົ່ງຂອງຜູ້ໃຊ້';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'ຂໍ້ມູນການສົ່ງສຳລັບການມອບໝາຍ.';
$string['privacy:metadata:assignuserflags'] = 'ເກັບຮັກສາຂໍ້ມູນເມຕ້າຂອງຜູ້ໃຊ້ເປັນວັນທີສ່ວນຂະຫຍາຍ';
$string['privacy:metadata:assignusermapping'] = 'ການສ້າງແຜນທີ່ສຳລັບການສົ່ງທີ່ບໍ່ລະບຸຊື່';
$string['privacy:metadata:assignworkflowfilter'] = 'ຕົວກັ່ນຕອງໂດຍຂັ້ນຕອນການເຮັດວຽກທີ່ແຕກຕ່າງກັນ.';
$string['privacy:metadata:grade'] = 'ຄະແນນຕົວເລກສໍາລັບການສົ່ງການມອບໝາຍນີ້. ສາມາດຖືກກໍານົດໂດຍມາດຕາສ່ວນ/ຮູບແບບການປັບປຸງຂັ້ນສູງ ແລະ ອື່ນໆ ແຕ່ຈະປ່ຽນກັບຄືນເປັນຈໍານວນຈຸດລອຍຢູ່ສະເໝີ.';
$string['privacy:metadata:grader'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ຂອງບຸກຄົນທີ່ໃຫ້ຄະແນນ.';
$string['privacy:metadata:groupid'] = 'ລະຫັດປະຈຳຕົວກຸ່ມທີ່ຜູ້ໃຊ້ເປັນສະມາຊິກ';
$string['privacy:metadata:latest'] = 'ເຮັດໃຫ້ການສອບຖາມງ່າຍຂຶ້ນຢ່າງຫຼວງຫຼາຍທີ່ຕ້ອງການຮູ້ຂໍ້ມູນກ່ຽວກັບຄວາມພະຍາຍາມຫຼ້າສຸດເທົ່ານັ້ນ.';
$string['privacy:metadata:mailed'] = 'ຜູ້ໃຊ້ຄົນນີ້ໄດ້ຖືກສົ່ງອີເມລຫຼືຍັງ?';
$string['privacy:metadata:timecreated'] = 'ສ້າງເວລາແລ້ວ';
$string['privacy:metadata:timestarted'] = 'ເວລາເລີ່ມຕົ້ນແລ້ວ';
$string['privacy:metadata:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້';
$string['privacy:studentpath'] = 'ການສົ່ງຂອງນັກຮຽນ';
$string['privacy:submissionpath'] = 'ການສົ່ງ';
$string['quickgrading'] = 'ການໃຫ້ຄະແນນດ່ວນ';
$string['quickgrading_help'] = 'ການໃຫ້ຄະແນນດ່ວນ ຊ່ວຍໃຫ້ທ່ານສາມາດມອບໝາຍຄະແນນ (ແລະ ຜົນໄດ້ຮັບ) ໂດຍກົງຢູ່ໃນຕາຕະລາງການສົ່ງ. ການໃຫ້ຄະແນນດ່ວນບໍ່ເຂົ້າກັນໄດ້ກັບການໃຫ້ຄະແນນຂັ້ນສູງ ແລະ ບໍ່ແນະນໍາເມື່ອມີເຄື່ອງໝາຍຫຼາຍອັນ.';
$string['quickgradingchangessaved'] = 'ບັນທຶກຄະແນນທີ່ປ່ຽນແປງແລ້ວ';
$string['quickgradingresult'] = 'ການໃຫ້ຄະແນນດ່ວນ';
$string['recordid'] = 'ຕົວລະບຸ';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} ຫຼັງຈາກວິຊາເລີ່ມຕົ້ນ';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} ກ່ອນວິຊາເລີ່ມຕົ້ນ';
$string['relativedatessubmissiontimeleft'] = 'ຄິດໄລ່ແລ້ວສຳລັບນັກຮຽນແຕ່ລະຄົນ';
$string['removeallgroupoverrides'] = 'ລຶບການລົບລ້າງກຸ່ມທັງໝົດ';
$string['removealluseroverrides'] = 'ລຶບການລົບລ້າງຜູ້ໃຊ້ທັງໝົດ';
$string['removesubmission'] = 'ຍົກຍ້າຍການສົ່ງ';
$string['removesubmissionconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບຂໍ້ມູນການສົ່ງຂອງທ່ານອອກ?';
$string['removesubmissionconfirmforstudent'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບຂໍ້ມູນການສົ່ງສຳລັບ {$a} ອອກ?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການລຶບການສົ່ງສໍາລັບ {$a}? ກະລຸນາຮັບຊາບວ່າ ນີ້ຈະບໍ່ກຳນົດເວລາຂອງນັກຮຽນຄືນໃໝ່. ທ່ານສາມາດໃຫ້ເວລາເພີ່ມເຕີມໂດຍການເພີ່ມເວລາຈຳກັດຜູ້ໃຊ້ແທນ.';
$string['removesubmissionconfirmwithtimelimit'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການລຶບການສົ່ງຂອງທ່ານອອກ? ກະລຸນາຮັບຊາບວ່າ ນີ້ຈະບໍ່ຣີເຊັດກຳນົດເວລາຂອງທ່ານ.';
$string['removesubmissionforstudent'] = 'ຍົກຍ້າຍການສົ່ງອອກສຳລັບນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'ເປີດຄືນໃໝ່ຈົນກວ່າທາງເລືອກຜ່ານບໍ່ເຂົ້າກັນໄດ້ກັບການສົ່ງທີ່ບໍ່ລະບຸຊື່, ເພາະວ່າຄະແນນບໍ່ໄດ້ຖືກເປີດເຜີຍໃຫ້ກັບປຶ້ມຄະແນນຈົນກ່ວາຈະເປີດເຜີຍຕົວຕົນຂອງນັກຮຽນ.';
$string['requireallteammemberssubmit'] = 'ຈຳເປັນຕ້ອງສົ່ງສະມາຊິກກຸ່ມທັງໝົດ';
$string['requireallteammemberssubmit_help'] = 'ຖ້າເປີດນຳໃຊ້, ສະມາຊິກທັງໝົດຂອງກຸ່ມນັກຮຽນຕ້ອງກົດປຸ່ມສົ່ງຂໍ້ມູນ ສຳລັບການມອບໝາຍນີ້ກ່ອນການສົ່ງກຸ່ມຈະຖືກພິຈາລະນາຕາມການສົ່ງ. ຖ້າປິດໃຊ້ງານ, ການສົ່ງຂອງກຸ່ມຈະຖືກພິຈາລະນາສົ່ງໃຫ້ທັນທີທີ່ສະມາຊິກກຸ່ມນັກຮຽນຄົນໃດຄລິກປຸ່ມສົ່ງ.';
$string['requiresubmissionstatement'] = 'ຈຳເປັນໃຫ້ນັກຮຽນນັ້ນຍອມຮັບຄຳຖະແຫຼງການສົ່ງ';
$string['requiresubmissionstatement_help'] = 'ຈຳເປັນໃຫ້ນັກຮຽນນັ້ນຍອມຮັບຄຳຖະແຫຼງການສົ່ງທັງໝົດສຳລັບກາສົ່ງທັງມົດໃຫ້ການມອບໝາຍນີ້.';
$string['revealidentities'] = 'ເປີດເຜີຍຕົວຕົນນັກຮຽນ';
$string['revealidentitiesconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການເປີດເຜີຍຕົວຕົນນັກຮຽນສຳລັບການມອບໝາຍນີ້? ການດຳເນີນງານນີ້ບໍ່ສາມາດຍົກເລີກໄດ້. ເມື່ອໄດ້ເປີດເຜີຍຕົວຕົນຂອງນັກຮຽນແລ້ວ, ເຄື່ອງໝາຍຈະຖືກເປີດເຜີຍໃສ່ປຶ້ມຄະແນນ.';
$string['reverttodefaults'] = 'ປ່ຽນກັບໄປເປັນຄ່າເລີ່ມຕົ້ນຂອງການມອບໝາຍ';
$string['reverttodraft'] = 'ປ່ຽນກັບໄປເປັນສະຖານະສະບັບຮ່າງຂອງການສົ່ງ';
$string['reverttodraftforstudent'] = 'ປ່ຽນກັບໄປເປັນສະບັບຮ່າງຂອງການສົ່ງສໍາລັບນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'ປ່ຽນການສົ່ງໄປເປັນສະບັບຮ່າງ';
$string['reviewed'] = 'ທົບທວນແລ້ວ';
$string['save'] = 'ບັນທຶກ';
$string['saveallquickgradingchanges'] = 'ບັນທຶກການປ່ຽນແປງການໃຫ້ຄະແນນດ່ວນທັງໝົດ';
$string['saveandcontinue'] = 'ບັນທຶກ ແລ້ວສືບຕໍ່';
$string['savechanges'] = 'ບັນທຶກການປ່ຽນແປງ';
$string['savegradingresult'] = 'ຄະແນນ';
$string['savenext'] = 'ບັນທຶກ ແລ້ວສະແດງຕໍ່ໄປ';
$string['saveoverrideandstay'] = 'ບັນທຶກ ແລ້ວໃສ່ການລົບລ້າງອື່ນ';
$string['savingchanges'] = 'ກຳລັງບັນທຶກການປ່ຽນແປງ...';
$string['scale'] = 'ມາດຕາສ່ວນ';
$string['search:activity'] = 'ການມອບໝາຍ - ຂໍ້ມູນກິດຈະກຳ';
$string['selectedusers'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ເລືອກ';
$string['selectlink'] = 'ເລືອກ...';
$string['selectuser'] = 'ເລືອກ {$a}';
$string['sendlatenotifications'] = 'ແຈ້ງໃຫ້ຜູ້ໃຫ້ຄະແນນຊາບກ່ຽວກັບການສົ່ງລ່າຊ້າ';
$string['sendlatenotifications_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຫ້ຄະແນນ (ປົກກະຕິແມ່ນຄູສອນ) ຮັບຂໍ້ຄວາມເມື່ອໃດກໍ່ຕາມທີ່ນັກຮຽນສົ່ງການມອບໝາຍລ່າຊ້າ. ວິທີຂອງຂໍ້ຄວາມສາມາດກຳນົດໄດ້.';
$string['sendnotifications'] = 'ແຈ້ງໃຫ້ຜູ້ໃຫ້ຄະແນນຊາບກ່ຽວກັບການສົ່ງ';
$string['sendnotifications_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຫ້ຄະແນນ (ປົກກະຕິແມ່ນຄູສອນ) ຮັບຂໍ້ຄວາມເມື່ອໃດກໍ່ຕາມທີ່ນັກຮຽນສົ່ງການມອບໝາຍ, ກ່ອນກຳນົດ, ຕົວເວລາ ແລະ ລ່າຊ້າ. ວິທີຂອງຂໍ້ຄວາມສາມາດກຳນົດໄດ້.';
$string['sendstudentnotifications'] = 'ແຈ້ງໃຫ້ນັກຮຽນຊາບ';
$string['sendstudentnotifications_help'] = 'ຕິກກ່ອງນີ້ເພື່ອແຈ້ງການກ່ຽວກັບຄະແນນ ຫຼື ຄຳຕິຊົມທີ່ປັບປຸງໃໝ່. ຖ້າການມອບໝາຍໃຊ້ຂັ້ນຕອນການເຮັດເຄື່ອງໝາຍ, ຫຼື ຄະແນນຖືກເຊື່ອງໄວ້ໃນລາຍງານຜູ້ໃຫ້ຄະແນນ, ຈາກນັ້ນການແຈ້ງເຕືອນຈະບໍ່ຖືກສົ່ງໄປຈົນກວ່າຄະແນນຈະຖືກປ່ອຍອອກມາ.';
$string['sendstudentnotificationsdefault'] = 'ຄ່າເລິ່ມຕົ້ນສຳລັບ "ແຈ້ງໃຫ້ນັກຮຽນຊາບ"';
$string['sendstudentnotificationsdefault_help'] = 'ເມື່ອໃຫ້ຄະແນນນັກຮຽນແຕ່ລະຄົນ, ຄວນໄດ້ເລືອດເອົາ "ແຈ້ງໃຫ້ນັກຮຽນຊາບ" ໂດຍຄ່າເລີ່ມຕົ້ນບໍ?';
$string['sendsubmissionreceipts'] = 'ສົ່ງໃບຮັບການສົ່ງໃຫ້ນັກຮຽນ';
$string['sendsubmissionreceipts_help'] = 'ການສະຫຼັບນີ້ເປີດໃຊ້ງານໃບຮັບການສົ່ງສຳລັບນັກຮຽນ. ນັກຮຽນຈະໄດ້ຮັບການແຈ້ງເຕືອນທຸກໆຄັ້ງທີ່ເຂົາເຈົ້າສົ່ງການມອບໝາຍສຳເລັດ.';
$string['setmarkerallocationforlog'] = 'ຕັ້ງການຈັດສັນການໝາຍ : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'ຕັ້ງການຈັດສັນການໝາຍ';
$string['setmarkingworkflowstate'] = 'ຕັ້ງສະຖານະຂັ້ນຕອນການເຮັດວຽກຂອງການໝາຍ';
$string['setmarkingworkflowstateforlog'] = 'ຕັ້ງສະຖານະຂັ້ນຕອນການເຮັດວຽກຂອງການໝາຍ : (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'ການຕັ້ງຄ່າການມອບໝາຍ';
$string['showrecentsubmissions'] = 'ສະແດງການສົ່ງໃນປະຈຸບັນ';
$string['status'] = 'ສະຖານະ';
$string['studentnotificationworkflowstateerror'] = 'ສະຖານະຂັ້ນຕອນການເຮັດວຽກຂອງການໝາຍຕ້ອງຖືກ \'ປ່ອຍແລ້ວ\' ເພື່ອແຈ້ງໃຫ້ນັກຮຽນຊາບ.';
$string['submission'] = 'ການສົ່ງ';
$string['submissionattachments'] = 'ສະແດງໄຟລ໌ໃນໄລຍະການສົ່ງເທົ່ານັ້ນ';
$string['submissionattachments_help'] = 'ໝາຍຕິກໃສ່ກ່ອງ ເພື່ອສະແດງໄຟລ໌ໃນໜ້າການສົ່ງເທົ່ານັ້ນ. ຖ້າບໍ່ດັ່ງນັ້ນ, ໄຟລ໌ຈະສະແດງຢູ່ໃນທັງສອງໜ້າການມອບໝາຍ ແລະ ໜ້າການສົ່ງ.';
$string['submissioncopiedhtml'] = '<p>ທ່ານໄດ້ເຮັດສຳເນົາຂອງການສົ່ງການມອບໝາຍກ່ອນໜ້າສຳລັບ \'<i>{$a->assignment}</i>\'.</p>
<p>ທ່ານສາມາດເຫັນສະຖານະ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.</p>';
$string['submissioncopiedsmall'] = 'ທ່ານໄດ້ສຳເນົາການສົ່ງການມອບໝາຍກ່ອນໜ້າຂອງທ່ານສຳລັບ {$a->assignment}';
$string['submissioncopiedtext'] = 'ທ່ານໄດ້ສຳເນົາການສົ່ງການມອບໝາຍກ່ອນໜ້າຂອງທ່ານສຳລັບ \'{$a->assignment}\'

ທ່ານສາມາດເຫັນສະຖານະການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['submissiondrafts'] = 'ຈຳເປັນຕ້ອງໃຫ້ນັກຮຽນຄລິກປຸ່ມສົ່ງ';
$string['submissiondrafts_help'] = 'ຖ້າເປີດໃຊ້ງານ, ນັກຮຽນຈະຕ້ອງກົດປຸ່ມສົ່ງ ເພື່ອປະກາດການສົ່ງຂອງເຂົາເຈົ້າເປັນສະບັບສຸດທ້າຍ. ສິ່ງນີ້ອະນຸຍາດໃຫ້ນັກຮຽນເກັບຮັກສາສະບັບຮ່າງຂອງການສົ່ງຂໍ້ມູນຢູ່ໃນລະບົບ. ຖ້າການຕັ້ງຄ່ານີ້ຖືກປ່ຽນຈາກ "ບໍ່" ເປັນ "ແມ່ນ" ຫຼັງຈາກນັກຮຽນໄດ້ສົ່ງໄປແລ້ວ, ການສົ່ງເຫຼົ່ານັ້ນຈະຖືກຖືວ່າເປັນສະບັບສຸດທ້າຍ.';
$string['submissioneditable'] = 'ນັກຮຽນສາມາດແກ້ໄຂການສົ່ງນີ້';
$string['submissionempty'] = 'ບໍ່ມີຫຍັງໄດ້ສົ່ງ';
$string['submissionlog'] = 'ນັກຮຽນt: {$a->fullname}, ສະຖານະ: {$a->status}';
$string['submissionmodified'] = 'ທ່ານມີຂໍ້ມູນການສົ່ງທີ່ມີຢູ່. ກະລຸນາອອກຈາດໜ້ານີ້ ແລ້ວລອງໃໝ່ອີກຄັ້ງ.';
$string['submissionmodifiedgroup'] = 'ການສົ່ງໄດ້ຖືກດັດແກ້ໂດຍໃຜບາງຄົນ. ກະລຸນາອອກຈາດໜ້ານີ້ ແລ້ວລອງໃໝ່ອີກຄັ້ງ.';
$string['submissionnotcopiedinvalidstatus'] = 'ການສົ່ງບໍ່ໄດ້ຖືກສຳເນົາຍ້ອນວ່າມັນຖືກແກ້ໄຂຕັ້ງແຕ່ມັນຖືກເປີດຄືນໃໝ່.';
$string['submissionnoteditable'] = 'ນັກຮຽນບໍ່ສາມາດແກ້ໄຂການສົ່ງນີ້';
$string['submissionnotopen'] = 'ການມອບໝາຍວຽກນີ້ບໍ່ໄດ້ເປີດໃຫ້ຍື່ນສະເໜີ';
$string['submissionnotready'] = 'ການມອບໝາຍນີ້ຍັງບໍ່ພ້ອມທີ່ຈະສົ່ງ:';
$string['submissionplugins'] = 'ປລັກອິນການສົ່ງ';
$string['submissionreceipthtml'] = '<p>ທ່ານໄດ້ສົ່ງການສົ່ງການມອບໝາຍສຳລັບ \'<i>{$a->assignment}</i>\'.</p>
<p>ທ່ານສາມາດເຫັນສະຖານະຂອງ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.</p>';
$string['submissionreceiptotherhtml'] = 'ການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ
\'<i>{$a->assignment}</i>\' ໄດ້ຖືກສົ່ງແລ້ວ.<br /><br />
ທ່ານສາມາດເຫັນສະຖານະຂອງ <a href="{$a->url}">ການສົ່ງການມອບໝາຍ</a>ຂອງທ່ານ.';
$string['submissionreceiptothersmall'] = 'ການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ
{$a->assignment} ໄດ້ຖືກສົ່ງແລ້ວ.';
$string['submissionreceiptothertext'] = 'ການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ
\'{$a->assignment}\' ໄດ້ຖືກສົ່ງແລ້ວ.

ທ່ານສາມາດເຫັນສະຖານະຂອງການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['submissionreceipts'] = 'ສົ່ງໃບຮັບການສົ່ງ';
$string['submissionreceiptsmall'] = 'ທ່ານໄດ້ສົ່ງການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ {$a->assignment}';
$string['submissionreceipttext'] = 'ທ່ານໄດ້ສົ່ງການສົ່ງການມອບໝາຍຂອງທ່ານສຳລັບ \'{$a->assignment}\'

ທ່ານສາມາດເຫັນສະຖານະຂອງການສົ່ງການມອບໝາຍຂອງທ່ານ:

    {$a->url}';
$string['submissionsclosed'] = 'ປິດການສົ່ງແລ້ວ';
$string['submissionsettings'] = 'ການຕັ້ງຄ່າການສົ່ງ';
$string['submissionslocked'] = 'ການມອບໝາຍນີ້ບໍ່ຍອມຮັບການສົ່ງ';
$string['submissionslockedshort'] = 'ບໍ່ອະນຸຍາດໃຫ້ປ່ຽນແປງການສົ່ງ';
$string['submissionstatement'] = 'ຄຳຖະແຫຼງການສົ່ງ';
$string['submissionstatement_help'] = 'ຄຳຖະແຫຼງທີ່ນັກຮຽນທຸກຄົນຕ້ອງຍອມຮັບເພື່ອທີ່ຈະສົ່ງວຽກຂອງເຂົາເຈົ້າ.';
$string['submissionstatementacceptedlog'] = 'ຍອມຮັບຄຳຖະແຫຼງການສົ່ງໂດຍນັກຮຽນ {$a}';
$string['submissionstatementdefault'] = 'ການສົ່ງນີ້ແມ່ນວຽກຂອງຂ້ອຍເອງ, ຍົກເວັ້ນບ່ອນທີ່ຂ້ອຍໄດ້ຮັບຮູ້ການນຳໃຊ້ວຽກຂອງຄົນອື່ນ.';
$string['submissionstatementteamsubmission'] = 'ຄຳຖະແຫຼງການສົ່ງເປັນກຸ່ມ';
$string['submissionstatementteamsubmission_help'] = 'ຄຳຖະແຫຼງທີ່ນັກຮຽນທຸກຄົນຕ້ອງຍອມຮັບເພື່ອທີ່ຈະສົ່ງວຽກຂອງກຸ່ມຂອງເຂົາເຈົ້າ.';
$string['submissionstatementteamsubmissionallsubmit'] = 'ຄຳຖະແຫຼງການສົ່ງເປັນກຸ່ມເມື່ອສະມາຊິກກຸ່ມທັງໝົດສົ່ງ';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'ຄຳຖະແຫຼງທີ່ນັກຮຽນທຸກຄົນຕ້ອງຍອມຮັບເພື່ອທີ່ຈະສົ່ງວຽກໃນນາມສະມາຊິກກຸ່ມຂອງເຂົາເຈົ້າ.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'ການສົ່ງນີ້ແມ່ນວຽກຂອງຂ້ອຍເອງໃນນາມສະມາຊິກກຸ່ມ, ຍົກເວັ້ນບ່ອນທີ່ຂ້ອຍໄດ້ຮັບຮູ້ການນຳໃຊ້ວຽກຂອງຄົນອື່ນ.';
$string['submissionstatementteamsubmissiondefault'] = 'ການສົ່ງນີ້ແມ່ນວຽກຂອງຂອງກຸ່ມ, ຍົກເວັ້ນບ່ອນທີ່ພວກເຮົາໄດ້ຮັບຮູ້ການນຳໃຊ້ວຽກຂອງຄົນອື່ນ.';
$string['submissionstatus'] = 'ສະຖານະການສົ່ງ';
$string['submissionstatus_'] = 'ບໍ່ມີການສົ່ງ';
$string['submissionstatus_draft'] = 'ສະບັບຮ່າງ (ບໍ່ໄດ້ສົ່ງ)';
$string['submissionstatus_marked'] = 'ໃຫ້ຄະແນນແລ້ວ';
$string['submissionstatus_new'] = 'ບໍ່ມີການສົ່ງ';
$string['submissionstatus_reopened'] = 'ເປີດຄືນໃໝ່';
$string['submissionstatus_submitted'] = 'ສົ່ງເພື່ອການໃຫ້ຄະແນນແລ້ວ';
$string['submissionstatusheading'] = 'ສະຖານະການສົ່ງ';
$string['submissionsummary'] = '{$a->status}. ການດັດແກ້ຫຼ່າສຸດໃນ {$a->timemodified}';
$string['submissionteam'] = 'ກຸ່ມ';
$string['submissiontypes'] = 'ປະເພດການສົ່ງ';
$string['submitaction'] = 'ສົ່ງ';
$string['submitassignment'] = 'ສົ່ງການມອບໝາຍ';
$string['submitassignment_help'] = 'ເມື່ອການມອບໝາຍນີ້ຖືກສົ່ງ ທ່ານຈະບໍ່ສາມາດເຮັດການປ່ຽນແປງເພີ່ມເຕີມໃດໆ.';
$string['submitforgrading'] = 'ສົ່ງເພື່ອໃຫ້ຄະແນນ';
$string['submitted'] = 'ສົ່ງແລ້ວ';
$string['submittedearly'] = 'ການມອບໝາຍຖືກສົ່ງ {$a} ກ່ອນກຳນົດ';
$string['submittedlate'] = 'ການມອບໝາຍຖືກສົ່ງ {$a} ລ່າຊ້າ';
$string['submittedlateshort'] = '{$a} ລ່າຊ້າ';
$string['submittedovertime'] = 'ການມອບໝາຍໄດ້ຖືກສົ່ງ {$a} ເກີນການຈຳກັດເວລາ';
$string['submittedundertime'] = 'ການມອບໝາຍໄດ້ຖືກສົ່ງ {$a} ພາຍໃຕ້ການຈຳກັດເວລາ';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['subplugintype_assignfeedback_plural'] = 'ປລັກອິນຄຳຕິຊົມ';
$string['subplugintype_assignsubmission'] = 'ປລັກອິນການສົ່ງ';
$string['subplugintype_assignsubmission_plural'] = 'ປລັກອິນການສົ່ງ';
$string['teamname'] = 'ທີມງານ: {$a}';
$string['teamsubmission'] = 'ນັກຮຽນສົ່ງໃນກຸ່ມ';
$string['teamsubmission_help'] = 'ຖ້າເປີດໃຊ້ງານ, ນັກຮຽນຈະຖືກແບ່ງອອກເປັນກຸ່ມໂດຍອີງຕາມການຕັ້ງກຸ່ມເລີ່ມຕົ້ນ ຫຼື ການຈັດກຸ່ມແບບກໍານົດເອງ. ການສົ່ງກຸ່ມຈະຖືກແບ່ງປັນລະຫວ່າງ ສະມາຊິກກຸ່ມ ແລະ ສະມາຊິກທັງໝົດຂອງກຸ່ມຈະເຫັນການປ່ຽນແປງຂອງແຕ່ລະຄົນຕໍ່ກັບການສົ່ງ.';
$string['teamsubmissiongroupingid'] = 'ການຈັດກຸ່ມສຳລັບກຸ່ມນັກຮຽນ';
$string['teamsubmissiongroupingid_help'] = 'ນີ້ແມ່ນການຈັດກຸ່ມທີ່ການມອບໝາຍຈະໃຊ້ເພື່ອຊອກຫາກຸ່ມສຳລັບກຸ່ມນັກຮຽນ. ຖ້າບໍ່ໄດ້ຕັ້ງ, ຊຸດກຸ່ມເລີ່ມຕົ້ນຈະຖືກນໍາໃຊ້.';
$string['textinstructions'] = 'ຄຳແນະນຳການມອບໝາຍ';
$string['timelimit'] = 'ການຈຳກັດເວລາ';
$string['timelimit_help'] = 'ຖ້າເປີດໃຊ້ງານ, ການຈຳກັດເວລາຈະລະບຸໄວ້ໃນໜ້າວຽກ ແລະ ໂມງນັບຖອຍຫຼັງຈະສະແດງໃນລະຫວ່າງການມອບໝາຍ.';
$string['timelimitnotenabled'] = 'ຈຳກັດເວລາບໍ່ໄດ້ເປີດໃຊ້ງານສຳລັບການມອບໝາຍວຽກ.';
$string['timelimitpassed'] = 'ການຈຳກັດເວລາໄດ້ໝົດເວລາແລ້ວ';
$string['timemodified'] = 'ດັດແກ້ຫຼ້າສຸດ';
$string['timeremaining'] = 'ເວລາທີ່ຍັງເຫຼືອ';
$string['timeremainingcolon'] = 'ເວລາທີ່ຍັງເຫຼືອ: {$a}';
$string['togglezoom'] = 'ພື້ນທີ່ ຂະຫຍາຍເຂົ້າ/ອອກ';
$string['ungroupedusers'] = 'ການຕັ້ງຄ່າ \'ຮຽກຮ້ອງໃຫ້ກຸ່ມຕ້ອງການສົ່ງຂໍ້ມູນ\' ຖືກເປີດໃຊ້ງານ ແລະ ຜູ້ໃຊ້ບາງຄົນບໍ່ໄດ້ເປັນສະມາຊິກຂອງກຸ່ມໃດໜຶ່ງ, ຫຼື ເປັນສະມາຊິກຂອງຫຼາຍກວ່າໜຶ່ງກຸ່ມ, ສະນັ້ນບໍ່ສາມາດເຮັດການສົ່ງໄດ້.';
$string['ungroupedusersoptional'] = 'ເປີດນຳໃຊ້ການຕັ້ງຄ່າ \'ນັກຮຽນສົ່ງເຂົ້າກຸ່ມ\' ແລະ ຜູ້ໃຊ້ບາງຄົນບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມໃດໜຶ່ງ, ຫຼື ເປັນສະມາຊິກຂອງຫຼາຍກວ່າໜຶ່ງກຸ່ມ. ກະລຸນາຮັບຮູ້ວ່ານັກຮຽນເຫຼົ່ານີ້ ຈະສົ່ງເຂົ້າເປັນສະມາຊິກຂອງ \'ກຸ່ມເລີ່ມຕົ້ນ\'.';
$string['unlimitedattempts'] = 'ບໍ່ຈຳກັດ';
$string['unlimitedattemptsallowed'] = 'ອະນຸຍາດຄວາມພະຍາຍາມບໍ່ຈຳກັດ.';
$string['unlimitedpages'] = 'ບໍ່ຈຳກັດ';
$string['unlocksubmissionforstudent'] = 'ອະນຸຍາດການສົ່ງສຳລັບນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'ປົດລັອກການສົ່ງ';
$string['unsavedchanges'] = 'ປ່ຽນແປງບໍ່ໄດ້ບັນທຶກການ';
$string['unsavedchangesquestion'] = 'ມີປ່ຽນແປງບໍ່ໄດ້ບັນທຶກການໃຫ້ຄະແນນ ຫຼື ຄຳຕິຊົມ. ທ່ານຕ້ອງການບັນທຶກການປ່ຽນແປງແລ້ວສືບຕໍ່ຫຼືບໍ?';
$string['updategrade'] = 'ປັບປຸງຄະແນນ';
$string['updatetable'] = 'ບັນທຶກ ແລະ ອັບເດດຕາຕະລາງ';
$string['upgradenotimplemented'] = 'ການຍົກລະດັບບໍ່ໄດ້ຈັດຕັ້ງປະຕິບັດໃນຕາຕະລາງ ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'ຄ່າເລີ່ມຕົ້ນການມອບໝາຍຜູ້ໃຊ້';
$string['userextensiondate'] = 'ສ່ວນຂະຫຍາຍຖືກອະນຸມັດຈົນກວ່າ: {$a}';
$string['usergrade'] = 'ຄະແນນຜູ້ໃຊ້';
$string['useridlistnotcached'] = 'ການປ່ຽນແປງຄະແນນບໍ່ໄດ້ບັນທຶກ, ເນື່ອງຈາກວ່າມັນບໍ່ສາມາດກໍານົດໄດ້ວ່າພວກເຂົາສົ່ງໄປເພື່ອສາເຫດໃດ.';
$string['useroverrides'] = 'ການລົບລ້າງຜູ້ໃຊ້';
$string['useroverridesdeleted'] = 'ລຶບການລົບລ້າງຜູ້ໃຊ້ແລ້ວ';
$string['usersnone'] = 'ບໍ່ມີນັກຮຽນເຂົ້າຫາການມອບໝາຍນີ້.';
$string['usersubmissioncannotberemoved'] = 'ບໍ່ສາມາດຍົກຍ້າຍການສົ່ງຂອງ {$a}';
$string['userswhoneedtosubmit'] = 'ຜູ້ໃຊ້ທີ່ຕ້ອງການສົ່ງ: {$a}';
$string['validmarkingworkflowstates'] = 'ການໝາຍສະຖານະຂັ້ນຕອນການເຮັດວຽກທີ່ຖືກຕ້ອງ';
$string['viewadifferentattempt'] = 'ເບິ່ງຄວາມພະຍາຍາມຕ່າງໆ';
$string['viewbatchmarkingallocation'] = 'ເບິ່ງໜ້າການຈັດສັນເຄື່ອງໝາຍຊຸດຂອງຊຸດ.';
$string['viewbatchsetmarkingworkflowstate'] = 'ເບິ່ງໜ້າສະຖານະຂັ້ນຕອນການເຮັດວຽກເຄື່ອງໝາຍຊຸດຂອງຊຸດ.';
$string['viewfeedback'] = 'ເບິ່ງຄຳຕິຊົມ';
$string['viewfeedbackforuser'] = 'ເບິ່ງຄຳຕິຊົມສຳລັບຜູ້ໃຊ້: {$a}';
$string['viewfull'] = 'ເບິ່ງແບບເຕັມ';
$string['viewfullgradingpage'] = 'ເບິ່ງໜ້າການໃຫ້ຄະແນນແບບເຕັມເພື່ອສະໜອງຄຳຕິຊົມ';
$string['viewgradebook'] = 'ເບິ່ງປື້ມຄະແນນ';
$string['viewgrading'] = 'ເບິ່ງການສົ່ງທັງໝົດ';
$string['viewgradingformforstudent'] = 'ເບິ່ງໜ້າການໃຫ້ຄະແນນສຳລັບນັກຮຽນ: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'ເບິ່ງໜ້າສົ່ງການມອບໝາຍຂອງຕົວເອງ.';
$string['viewownsubmissionstatus'] = 'ເບິ່ງໜ້າສະຖານະການສົ່ງຂອງຕົວເອງ.';
$string['viewrevealidentitiesconfirm'] = 'ເບິ່ງໜ້າຢືນຢັນການເປີດເຜຍຕົວຕົນນັກຮຽນ.';
$string['viewsubmission'] = 'ເບິ່ງການສົ່ງ';
$string['viewsubmissionforuser'] = 'ເບິ່ງການສົ່ງສຳລັບນັກຮຽນ: {$a}';
$string['viewsubmissiongradingtable'] = 'ເບິ່ງການສົ່ງຕາຕະລາງການໃຫ້ຄະແນນ';
$string['viewsummary'] = 'ເບິ່ງການສະຫຼຸບ';
$string['workflowfilter'] = 'ຕົວກັ່ນຕອງຂັ້ນຕອນການເຮັດວຽກ';
$string['xofy'] = '{$a->x} ຂອງ {$a->y}';
