<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'fr', version '4.0'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Couleur de l\'icône d\'activité pour « Administration »';
$string['activityiconcoloradministrationsetting_desc'] = 'La couleur de l\'icône d\'activité pour « Administration »';
$string['activityiconcolorassessmentsetting'] = 'Couleur de l\'icône d\'activité pour « Évaluation »';
$string['activityiconcolorassessmentsetting_desc'] = 'La couleur de l\'icône d\'activité pour « Évaluation »';
$string['activityiconcolorcollaborationsetting'] = 'Couleur de l\'icône d\'activité pour « Collaboration »';
$string['activityiconcolorcollaborationsetting_desc'] = 'La couleur de l\'icône d\'activité pour « Collaboration »';
$string['activityiconcolorcommunicationsetting'] = 'Couleur de l\'icône d\'activité pour « Communication »';
$string['activityiconcolorcommunicationsetting_desc'] = 'La couleur de l\'icône d\'activité pour « Communication »';
$string['activityiconcolorcontentsetting'] = 'Couleur de l\'icône d\'activité pour « Contenu »';
$string['activityiconcolorcontentsetting_desc'] = 'La couleur de l\'icône d\'activité pour «  Contenu »';
$string['activityiconcolorinterfacesetting'] = 'Couleur de l\'icône d\'activité pour « Interface »';
$string['activityiconcolorinterfacesetting_desc'] = 'La couleur de l\'icône d\'activité pour « Interface »';
$string['activityiconcolorsheading'] = 'Couleurs de l\'icône d\'activité';
$string['activitynavigation'] = 'Navigation d\'activité';
$string['activitynavigationsetting'] = 'Éléments de navigation d\'activité';
$string['activitynavigationsetting_desc'] = 'Avec ce paramètre, les éléments permettant de passer à l\'activité / ressource précédente et suivante ainsi que le menu déroulant permettant de passer à une activité / ressource distincte s\'affichent. Des éléments d\'interface utilisateur comme celui-ci existaient déjà sur Boost dans le noyau de Moodle jusqu\'à Moodle 3.11, mais ont été supprimés dans 4.0. Avec Boost Union, vous pouvez les faire revenir.';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistante)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (révisée)';
$string['additionalresourcesheading'] = 'Ressources additionnelles';
$string['additionalresourceslistsetting'] = 'Liste de ressources additionnelles';
$string['additionalresourceslistsetting_desc'] = 'Liste des fichiers qui ont été téléchargés dans la zone de fichiers « Ressources additionnelles ». Vous pouvez utiliser les URL indiquées pour lier les fichiers dans le HTML supplémentaire depuis le CSS dédié ou dans la note de pied de page. Cela est utile partout où vous souhaitez utiliser des fichiers, mais que vous ne pouvez pas en télécharger.';
$string['additionalresourcessetting'] = 'Ressources additionnelles';
$string['additionalresourcessetting_desc'] = 'Avec ce paramètre, vous pouvez déposer des ressources supplémentaires sur le thème. L\'avantage de déposer des fichiers dans cette zone de fichiers est que ces fichiers peuvent être livrés sans vérification si l\'utilisateur est connecté. C\'est aussi pourquoi vous ne devez ajouter que des fichiers non critiques, accessibles par tout le monde sans être protégés par un identifiant valide. Dès que vous avez déposé au moins un fichier dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera l\'URL que vous pouvez utiliser pour référencer un fichier particulier apparaîtra en dessous.';
$string['backgroundimagesheading'] = 'Image d\'arrière plan générale';
$string['backtotop'] = 'Retour au début';
$string['backtotopbuttonsetting'] = 'Bouton de retour au début';
$string['backtotopbuttonsetting_desc'] = 'Avec ce paramètre, un bouton de retour en haut apparaîtra dans le coin inférieur droit de la page dès que l\'utilisateur fait défiler la page. Un bouton comme celui-ci existait déjà sur Boost dans Moodle Core jusqu\'à Moodle 3.11, mais a été supprimé dans 4.0. Avec Boost Union, vous pouvez le ramener.';
$string['blocksgeneralheading'] = 'Blocs généraux';
$string['blockstab'] = 'Blocs';
$string['boost_union:configure'] = 'Pour pouvoir configurer le thème en tant que non-administrateur';
$string['boost_union:viewhintcourseselfenrol'] = 'Pour pouvoir obtenir un indice d\'auto-inscription libre à un cours visible.';
$string['boost_union:viewhintinhiddencourse'] = 'Pour pouvoir obtenir un indice pour un cours caché.';
$string['bootstrapcolordangersetting'] = 'Couleur Bootstrap pour « Danger »';
$string['bootstrapcolordangersetting_desc'] = 'La couleur Bootstrap pour « Danger »';
$string['bootstrapcolorinfosetting'] = 'Couleur Bootstrap pour « Info »';
$string['bootstrapcolorinfosetting_desc'] = 'La couleur Bootstrap pour « Info »';
$string['bootstrapcolorsheading'] = 'Couleurs Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Couleur Bootstrap pour « Succès »';
$string['bootstrapcolorsuccesssetting_desc'] = 'La couleur Bootstrap pour « Succès »';
$string['bootstrapcolorwarningsetting'] = 'Couleur Bootstrap pour « Attention »';
$string['bootstrapcolorwarningsetting_desc'] = 'Couleur Bootstrap pour « Attention »';
$string['bootstrapdangercolor'] = 'Couleur de danger';
$string['bootstrapdarkcolor'] = 'Couleur sombre';
$string['bootstrapinfocolor'] = 'Couleur d\'info';
$string['bootstraplightcolor'] = 'Couleur claire';
$string['bootstrapnone'] = 'Pas de couleur Bootstrap';
$string['bootstrapprimarycolor'] = 'Couleur primaire';
$string['bootstrapsecondarycolor'] = 'Couleur secondaire';
$string['bootstrapsuccesscolor'] = 'Couleur de succès';
$string['bootstrapwarningcolor'] = 'Couleur d\'attention';
$string['brandcolorsheading'] = 'Couleurs de la marque';
$string['brandingtab'] = 'Image de marque';
$string['cachedef_flavours'] = 'Types qui s\'appliquent à un numéro d\'identifiant de catégorie de page donné pour l\'utilisateur actuel';
$string['cachedef_fontawesome'] = 'Fichiers FontAwesome (qui sont téléchargés dans les paramètres de Boost Union)';
$string['choosereadme'] = 'Theme Boost Union est un thème enfant amélioré de Boost fourni par Moodle an Hochschulen e.V.';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Contenu';
$string['configtitlefeel'] = 'Sensation';
$string['configtitleflavours'] = 'Types';
$string['configtitlefunctionality'] = 'Fonctionnalité';
$string['configtitlelook'] = 'Apparence';
$string['contactcontentsetting'] = 'Contenu de la page Contact';
$string['contactcontentsetting_desc'] = 'Ce réglage permet d\'ajouter du contenu en texte enrichi qui sera affiché sur une page de contact (qui n\'est pas la même que la page intégrée Moodle « Contacter l\'assistance du site »).';
$string['contactdisabled'] = 'La page de contact est désactivée pour ce site. Il n\'y a rien à voir ici.';
$string['contactheading'] = 'Contact';
$string['contactlinkpositionboth'] = 'Ajouter à la note de bas de page et à l\'icône de pied de page (point d\'interrogation) un lien vers la page de contact';
$string['contactlinkpositionfooter'] = 'Ajouter à l\'icône du pied de page (point d\'interrogation) un lien vers la page de contact';
$string['contactlinkpositionfootnote'] = 'Ajouter à la note de bas de page un lien vers la page de contact';
$string['contactlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page de contact';
$string['contactlinkpositionsetting'] = 'Position du lien de la page de contact';
$string['contactlinkpositionsetting_desc'] = 'Ce réglage permet de configurer si un lien vers la page de contact doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez en ajouter manuellement vers {$a->url} depuis n\'importe où dans Moodle.';
$string['contactpagetitledefault'] = 'Contact';
$string['contactpagetitlesetting'] = 'Titre de la page Contact';
$string['contactpagetitlesetting_desc'] = 'Ce réglage permet de définir le titre de la page de contact. Ce texte sera également utilisé comme texte de lien vers la page de contact si vous configurez la « Position du lien de la page de contact » en conséquence.';
$string['coursecontentmaxwidthsetting'] = 'Largeur maximale du contenu du cours';
$string['coursecontentmaxwidthsetting_desc'] = 'Avec ce paramètre, vous pouvez remplacer la largeur du contenu par défaut de Moodle sans modifications SCSS manuelles. Par défaut, Moodle utilise une largeur maximale du contenu de cours de 830px. Vous pouvez entrer d\'autres valeurs basées sur les pixels comme 1200px, mais vous pouvez également entrer une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['courseheaderheading'] = 'En-tête du cours';
$string['courseheaderimageenabled'] = 'Afficher l\'image du cours dans l\'en-tête du cours';
$string['courseheaderimageenabled_desc'] = 'Lorsqu\'elle est activée, l\'image du cours (qui peut être déposée dans les paramètres de cours d\'un cours) s\'affiche dans l\'en-tête d\'un cours. Les images des cours y sont affichées en plus de la page « Mes cours » où elles sont toujours affichées.';
$string['courseheaderimagefallback'] = 'Image de remplacement de l\'en-tête du cours';
$string['courseheaderimagefallback_desc'] = 'Une image déposée dans ce réglage sera utilisée comme image de remplacement et s\'affiche dans l\'en-tête du cours si aucune image de cours n\'est déposée dans les paramètres de cours d\'un cours particulier. Si vous ne déposez pas d\'image ici, une image d\'en-tête de cours n\'est affichée dans un cours particulier que si une image de cours est déposée dans les paramètres de cours de ce cours particulier.';
$string['courseheaderimageheight'] = 'Hauteur de l\'image d\'en-tête du cours';
$string['courseheaderimageheight_desc'] = 'Ce réglage permet de contrôler la hauteur de l\'image d\'en-tête du cours présentée.';
$string['courserelatedhintsheading'] = 'Conseils liés au cours';
$string['coursestab'] = 'Cours';
$string['coursetab'] = 'Cours';
$string['customfontsfileurlpersistent'] = 'URL (persistante)';
$string['customfontsfileurlrevisioned'] = 'URL (révisée)';
$string['customfontsheading'] = 'Polices personnalisées';
$string['customfontslistsetting'] = 'Liste des polices personnalisées';
$string['customfontslistsetting_desc'] = 'Il s\'agit de la liste des polices que vous avez téléchargées dans la zone de fichiers des polices personnalisées. Les extraits CSS donnés peuvent être utilisés pour ajouter ces polices à votre SCSS personnalisé. Veuillez noter que vous devrez vous occuper vous-même de la valeur du format de police ainsi que des propriétés CSS font-family, font-style et font-weight pour le moment, car Boost Union n\'est pas encore en mesure d\'analyser les fichiers de police.';
$string['customfontssetting'] = 'Polices personnalisées';
$string['customfontssetting_desc'] = 'Avec ce paramètre, vous pouvez télécharger des polices personnalisées sur le thème. L\'avantage de télécharger des polices dans cette zone de fichiers est que ces polices peuvent être livrées sans vérification si l\'utilisateur est connecté et peuvent être utilisées comme polices installées localement partout sur le site. Dès que vous avez déposé au moins une police dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera des extraits de code CSS que vous pouvez utiliser comme passe-partout pour référencer des polices particulières dans votre SCSS personnalisé, apparaîtra en dessous.';
$string['emailbrandinghtmldemobody'] = '<p>Le corps du courriel commence ici.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Le corps du courriel se termine ici.</p>';
$string['emailbrandinghtmlheading'] = 'Aperçu du courriel HTML';
$string['emailbrandinghtmlintro'] = 'Il s\'agit de l\'aperçu d\'un courriel HTML basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandinghtmlnopreview'] = 'Jusqu\'à présent, les courriels HTML n\'ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['emailbrandinginstruction'] = 'Comment';
$string['emailbrandinginstruction0'] = 'Avec cette fonctionnalité Boost Union, vous pouvez appliquer une image de marque à tous les courriels envoyés par Moodle.';
$string['emailbrandinginstructionli1'] = 'Aller à la <a href="{$a->url}" target="_blank">page des paramètres de personnalisation de la langue</a> pour ouvrir le paquetage de langue <em>{$a->lang}</em> en mode édition.';
$string['emailbrandinginstructionli2'] = 'Rechercher et modifier ces chaînes dans le paquetage de <code>langue theme_boost_union</code> :';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli3'] = 'Enregistrer les modifications apportées au paquetage de langue.';
$string['emailbrandinginstructionli4'] = 'Revenir sur cette page et visualiser les aperçus des courriels ci-dessous.';
$string['emailbrandingintroheading'] = 'Introduction';
$string['emailbrandingintronote'] = 'Remarque : il s\'agit d\'une fonctionnalité avancée qui utilise des solutions de contournement pour fournir des options de personnalisation des courriels. Veuillez suivre attentivement les instructions.';
$string['emailbrandingpitfalls'] = 'Pièges';
$string['emailbrandingpitfalls0'] = 'En utilisant cette fonctionnalité, vous devez être conscient de certains pièges :';
$string['emailbrandingtextdemobody'] = 'Le corps de l\'e-mail commence ici.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Le corps de l\'e-mail se termine ici.';
$string['emailbrandingtextheading'] = 'Aperçu des courriels en texte brut';
$string['emailbrandingtextintro'] = 'Il s\'agit d\'un aperçu d\'un courriel en clair basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandingtextnopreview'] = 'Jusqu\'à présent, les courriels texte n\'ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['enablecontactsetting'] = 'Activer la page de contact';
$string['enablehelpsetting'] = 'Activer la page d\'aide';
$string['enableimprintsetting'] = 'Activer l\'impression';
$string['enablemaintenancesetting'] = 'Activer la page d\'informations sur la maintenance';
$string['error:infobannerdismissnonotdismissible'] = 'La bannière d\'information donnée n\'est pas dissimulable';
$string['error:infobannerdismissnonotvalid'] = 'Le numéro de bannière d\'information donné n\'est pas valide';
$string['faviconheading'] = 'Icône de favori';
$string['faviconsetting'] = 'Icône de favori';
$string['faviconsetting_desc'] = 'Ici, vous pouvez télécharger une image personnalisée (format .ico ou .png) que le navigateur affichera comme icône de favori de votre site Web Moodle. Si aucune icône de favori personnalisée n\'est téléchargée, une icône de favori Moodle standard sera utilisée.';
$string['flavoursappliesto'] = 'Appliquer à';
$string['flavoursapplytocategories'] = 'Appliquer aux catégories de cours';
$string['flavoursapplytocategories_ids'] = 'Catégories de cours';
$string['flavoursapplytocohorts'] = 'Appliquer aux cohortes';
$string['flavoursapplytocohorts_help'] = 'On définit ici si ce type doit être appliqué aux cohortes.';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursbackgroundimage'] = 'Image d\'arrière plan';
$string['flavourscustomcss'] = 'CSS personnalisé';
$string['flavoursdescription'] = 'Description';
$string['flavourslogo'] = 'Logo';
$string['flavourstitle'] = 'Titre';
$string['fontawesomecheck-fa6free-filter-title'] = 'Filtre FontAwesome';
$string['fontawesomefilessetting'] = 'Fichiers FontAwesome';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomeversionsetting'] = 'Version de FontAwesome';
$string['footertab'] = 'Pied de page';
$string['footnoteheading'] = 'Note de pied de page';
$string['footnotesetting'] = 'Note de pied de page';
$string['footnotesetting_desc'] = 'Tout ce que vous ajoutez à cette zone de texte sera affiché à la fin d\'une page, dans le pied de page (pas le pied de page flottant) sur chaque page qui utilise les mises en page « tiroirs », « columns2 » ou « login ». Le contenu de cette zone peut être, par exemple, le copyright, les conditions d\'utilisation ou le nom de votre organisation. <br/> Si vous souhaitez supprimer à nouveau la note de bas de page, videz simplement la zone de texte.';
$string['helpcontentsetting'] = 'Contenu de la page d\'aide';
$string['helpheading'] = 'Aide';
$string['helppagetitledefault'] = 'Aide';
$string['helppagetitlesetting'] = 'Titre de la page d\'aide';
$string['imprintcontentsetting'] = 'Contenu de l\'impression';
$string['imprintcontentsetting_desc'] = 'Dans ce paramètre, vous pouvez ajouter du contenu en texte enrichi qui sera affiché sur la page d\'impression.';
$string['imprintdisabled'] = 'L\'impression est désactivée pour ce site. Il n\'y a rien à voir ici.';
$string['imprintheading'] = 'Impression';
$string['imprintlinkpositionboth'] = 'Ajouter un lien vers la page d\'impression à la note de bas de page et à l\'icône de pied de page (point d\'interrogation)';
$string['imprintlinkpositionfooter'] = 'Ajouter un lien vers la page d\'impression à l\'icône du pied de page (point d\'interrogation)';
$string['imprintlinkpositionfootnote'] = 'Ajouter un lien vers la page d\'impression à la note de bas de page';
$string['imprintlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d\'impression';
$string['imprintlinkpositionsetting'] = 'Position du lien d\'impression';
$string['imprintlinkpositionsetting_desc'] = 'Dans ce paramètre, vous pouvez configurer si un lien vers la page d\'impression doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez ajouter manuellement un lien vers {$a->url} depuis n\'importe où dans Moodle.';
$string['imprintpagetitledefault'] = 'Impression';
$string['imprintpagetitlesetting'] = 'Titre de la page d\'impression';
$string['imprintpagetitlesetting_desc'] = 'Dans ce paramètre, vous pouvez définir le titre de la page d\'impression. Ce texte sera également utilisé comme texte de lien vers la page d\'impression si vous configurez « Position du lien d\'impression » en conséquence.';
$string['infobannerbsclasssetting'] = 'Bannière d\'information n° {$a->no} Classe Bootstrap';
$string['infobannerbsclasssetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner le style Bootstrap avec lequel la bannière d\'informations n° {$a->no} doit être affiché. Si vous choisissez l\'option « Aucune couleur Bootstrap », la bannière d\'informations sera affichée sans aucune couleur Bootstrap particulière, ce qui vous donne la liberté de styliser la bannière vous-même dans l\'éditeur de texte enrichi.';
$string['infobannerclose'] = 'Fermer';
$string['infobannercontentsetting'] = 'Contenu de la bannière d\'information n° {$a->no}';
$string['infobannercontentsetting_desc'] = 'Ici, vous saisissez les informations qui doivent être affichées dans la bannière d\'information n° {$a->no}.';
$string['infobannerdismissconfirm'] = 'Voulez-vous vraiment réinitialiser la visibilité de la bannière d\'information n° {$a->no} et souhaitez-vous la réafficher pour tous les utilisateurs qui l\'ont ignoré ?';
$string['infobannerdismissfail'] = 'La réinitialisation de la visibilité du bandeau d\'information n° {$a->no} a échoué pour au moins un utilisateur';
$string['infobannerdismissiblesetting'] = 'Bannière d\'information n° {$a->no} ignorée';
$string['infobannerdismissiblesetting_desc'] = 'Avec ce paramètre, vous pouvez créer une bannière d\'informations n° {$a->no} ignorée. Si l\'utilisateur clique sur le bouton x dans la bannière d\'informations, la bannière sera masquée de façon permanente pour cet utilisateur. La visibilité n\'est en aucun cas réinitialisée automatiquement, même si vous modifiez le contenu de la bannière d\'information. Si vous souhaitez réinitialiser la visibilité de la bannière d\'informations, cliquez sur le bouton « Réinitialiser la visibilité » ci-dessous.';
$string['infobannerdismissreset'] = 'Réinitialiser la visibilité de la bannière d\'informations ignorée';
$string['infobannerdismissresetbutton'] = 'Réinitialiser la visibilité de la bannière d\'information n° {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilité de la bannière d\'information n° {$a->no} a été réinitialisée';
$string['infobannerenabledsetting'] = 'Activer la bannière d\'information n° {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Avec ce paramètre, vous pouvez activer la bannière d\'information n° {$a->no}.';
$string['infobannerendsetting'] = 'Heure de fin de la bannière d\'information n° {$a->no}';
$string['infobannerendsetting_desc'] = 'Avec ce paramètre, vous pouvez définir jusqu\'à quand la bannière d\'information n° {$a->no} doit être affichée. L\'heure configurée est interprétée comme l\'heure du serveur et non comme l\'heure de l\'utilisateur.';
$string['infobannerheading'] = 'Bannière d\'information n° {$a->no}';
$string['infobannermodeperpetual'] = 'Perpétuelle';
$string['infobannermodesetting'] = 'Mode d\'affichage de la bannière d\'information n° {$a->no}';
$string['infobannermodesetting_desc'] = 'Avec ce paramètre, vous pouvez définir si la bannière d\'information n° {$a->no} doit être une bannière perpétuelle (qui est toujours affichée) ou une bannière à durée contrôlée (qui n\'est affichée que dans l\'intervalle de temps configuré)';
$string['infobannermodetimebased'] = 'Durée contrôlée';
$string['infobannerordersetting'] = 'Position de la bannière d\'information no. {$a->no}';
$string['infobannerordersetting_desc'] = 'Avec ce paramètre, vous définissez la position d\'ordre de la bannière d\'information n° {$a->no}. Par défaut, les bannières d\'informations sont classées de haut en bas comme vous les voyez sur cette page de paramètres ici. Cependant, vous pouvez décider d\'attribuer une autre position avec ce paramètre. Si vous attribuez la même position à deux bannières d\'information ou plus, elles seront à nouveau classées selon l\'ordre indiqué sur cette page de paramètres.';
$string['infobannerpageloginpage'] = 'Page de connexion';
$string['infobannerpagessetting'] = 'Mises en page pour afficher la bannière d\'informations n° {$a->no} en';
$string['infobannerpagessetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner les mises en page sur lesquelles la bannière d\'information n° {$a->no} doit être affichée.';
$string['infobannerstartsetting'] = 'Heure de début de la bannière d\'information n° {$a->no}';
$string['infobannerstartsetting_desc'] = 'Avec ce paramètre, vous pouvez définir à partir de quand le bandeau d\'information n° {$a->no} doit être affiché. L\'heure configurée est interprétée comme l\'heure du serveur et non comme l\'heure de l\'utilisateur.';
$string['infobannertab'] = 'Bannière d\'informations';
$string['javascriptdisabledhint'] = 'Indice JavaScript désactivé';
$string['javascriptdisabledhint_desc'] = 'Avec ce paramètre, un indice apparaîtra en haut de la page Moodle si JavaScript n\'est pas activé. Ceci est particulièrement utile car plusieurs fonctionnalités de Moodle ne fonctionnent pas sans JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript est désactivé dans votre navigateur.<br />De nombreuses fonctionnalités de Moodle ne seront pas utilisables ou sembleront brisées.<br />Veuillez activer JavaScript pour profiter pleinement de l\'expérience Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['loginbackgroundimage'] = 'Images d\'arrière-plan de la page de connexion';
$string['loginbackgroundimage_desc'] = 'Les images à afficher en arrière-plan de la page de connexion. L\'une de ces images sera choisie au hasard et affichée lorsque l\'utilisateur visitera la page de connexion.';
$string['loginbackgroundimagesheading'] = 'Images d\'arrière-plan de la page de connexion';
$string['loginbackgroundimagetextsetting'] = 'Afficher le texte des images d\'arrière-plan de connexion';
$string['loginbackgroundimagetextsetting_desc'] = 'Avec ce paramètre facultatif, vous pouvez ajouter du texte, par exemple un avis de droit d\'auteur sur vos images d\'arrière-plan téléchargées. Ce texte apparaîtra en haut du pied de page sur la page de connexion. Cependant, pour des raisons d\'espace sur l\'écran, il n\'est affiché que sur des tailles d\'écran plus grandes.<br/>
Chaque ligne se compose de l\'identifiant du fichier (le nom du fichier), du texte qui doit être affiché et de la couleur du texte, séparés par un caractère tuyau. Chaque déclaration doit être écrite dans une nouvelle ligne. <br/>
Par exemple :<br/>
background-image-1.jpg|Copyright : CC0|dark<br/>
Comme couleur de texte, vous pouvez utiliser les valeurs « dark » ou « light ».<br />
Vous pouvez déclarer des textes pour une quantité arbitraire de vos images d\'arrière-plan de connexion téléchargées. Les textes seront ajoutés uniquement aux images dont le nom de fichier correspond à l\'identifiant déclaré dans ce paramètre.';
$string['maintenancepagetitledefault'] = 'Maintenance';
$string['maintenancepagetitlesetting'] = 'Titre de la page d\'information de la maintenance';
$string['misctab'] = 'Divers';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['pagetab'] = 'Page';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Préréglages du thème';
$string['privacy:metadata'] = 'Le thème Boost Union ne stocke aucune donnée personnelle sur un utilisateur.';
$string['resourcescachecontrolnote'] = 'Veuillez noter que les fichiers sont envoyés au navigateur avec l\'en-tête « Cache-Control » qui indique au navigateur de mettre le fichier en cache. Si vous êtes certain de ne pas modifier le fichier dans un proche avenir, vous pouvez utiliser l\'URL persistante pour créer un lien vers le fichier. Cependant, si vous envisagez de modifier un fichier mais que vous conservez le même nom de temps en temps, vous devriez plutôt utiliser l\'URL révisée et refaire le lien avec le fichier chaque fois que vous mettez à jour le fichier pour éviter que les navigateurs n\'affichent en cache les versions obsolètes du fichier.';
$string['resourcestab'] = 'Ressources';
$string['scrollspy'] = 'Défilement-espion';
$string['scrollspysetting'] = 'Défilement-espion';
$string['scrollspysetting_desc'] = 'Avec ce paramètre, lors de l\'activation et de la désactivation du mode d\'édition, la position de défilement à l\'endroit où se trouvait l\'utilisateur lors de l\'exécution de la bascule est conservée.';
$string['scssheading'] = 'SCSS brut';
$string['showhintcourseguestaccessgeneral'] = 'Vous consultez actuellement ce cours en tant que <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Pour avoir un accès complet au cours, vous pouvez <a href="{$a->url}">vous inscrire vous-même à ce cours</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l\'en-tête du cours lorsqu\'un utilisateur y accède avec la fonction d\'accès invité. Si le cours propose une auto-inscription active, un lien vers cette page est également présenté à l\'utilisateur.';
$string['showhintcoursehiddengeneral'] = 'Ce cours est actuellement <strong>masqué</strong>. Seuls les enseignants inscrits peuvent accéder à ce cours lorsqu\'il est masqué.';
$string['showhintcoursehiddensetting'] = 'Afficher l\'indice dans les cours masqués';
$string['showhintcoursehiddensetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l\'en-tête du cours tant que la visibilité du cours est masquée. Cela permet d\'identifier l\'état de visibilité d\'un parcours en un coup d\'œil sans avoir à consulter les paramètres du parcours.';
$string['showhintcoursehiddensettingslink'] = 'Vous pouvez modifier la visibilité dans les <a href="{$a->url}">paramètres du cours</a>.';
$string['showhintcourseselfenrolfrom'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à partir du {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée de {$a->from} à {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Si vous ne souhaitez pas qu\'un utilisateur Moodle puisse s\'inscrire librement à ce cours, veuillez restreindre les paramètres d\'auto-inscription.';
$string['showhintcourseselfenrolsetting'] = 'Afficher un indice pour l\'auto-inscription sans clé d\'inscription';
$string['showhintcourseselfenrolsetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l\'en-tête du cours si le cours est visible et qu\'une inscription sans clé d\'inscription est actuellement possible.';
$string['showhintcourseselfenrolsince'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> autorise actuellement l\'auto-inscription sans restriction.';
$string['showhintcourseselfenrolsinceuntil'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> autorise l\'auto-inscription illimitée jusqu\'au {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Ce cours est actuellement visible et l\'<strong>auto-inscription sans clé d\'inscription</strong> est actuellement possible.';
$string['showhintcourseselfenrolstartfuture'] = 'Ce cours est actuellement visible et l\'<strong>auto-inscription sans clé d\'inscription</strong> devrait devenir possible.';
$string['showhintcourseselfenrolunlimited'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à l\'infini.';
$string['showhintcourseselfenroluntil'] = 'L\'instance d\'inscription <strong>{$a->name}</strong> autorise l\'auto-inscription illimitée jusqu\'au {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Afficher l\'indice pour l\'accès invité';
$string['showswitchedroleincoursesetting'] = 'Afficher l\'indice pour le rôle changé';
$string['showswitchedroleincoursesetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l\'en-tête du cours si l\'utilisateur a changé de rôle dans le cours. Par défaut, ces informations ne sont affichées qu\'à côté de l\'avatar de l\'utilisateur dans le menu utilisateur. En activant cette option, vous pouvez également afficher ces informations - ainsi qu\'un lien pour revenir en arrière - dans la page du cours.';
$string['staticpagestab'] = 'Pages statiques';
$string['switchedroleto'] = 'Vous consultez actuellement ce cours avec le rôle : <strong>{$a->role}</strong>';
