<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_lti', language 'af', version '4.0'.
 *
 * @package     qtype_lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Aanvaar';
$string['accept_grades'] = 'Aanvaar punte vanaf die nutsmiddel';
$string['accept_grades_admin'] = 'Aanvaar punte vanaf die nutsmiddel';
$string['accept_grades_admin_help'] = 'Spesifiseer of die nutsmiddelverskaffer punte wat met instansies van hierdie nutsmiddel geassosieer word, kan byvoeg, bywerk, lees en uitwis.

Sommige nutsmiddelverskaffers ondersteun die terugvoer van punte na Moodle gebaseer op aksies wat binne die nutsmiddel gedoen is, wat \'n meer geïntegreerde ervaring skep.';
$string['accept_grades_help'] = 'Spesifiseer of die nutsmiddelverskaffer punte wat met hierdie eksterne nutsmiddelinstansie geassosieer word, kan byvoeg, bywerk, lees en uitwis.

Sommige nutsmiddelverskaffers ondersteun die terugvoer van punte na Moodle gebaseer op aksies wat binne die nutsmiddel gedoen is, wat \'n meer geïntegreerde ervaring skep.

Let daarop dat hierdie verstelling in die nutsmiddelkonfigurasie oorheengeskryf kan word.';
$string['accepted'] = 'Aanvaar';
$string['action'] = 'Aksie';
$string['activate'] = 'Aktiveer';
$string['activatetoadddescription'] = 'Jy sal hierdie nutsmiddel moet aktiveer voordat jy \'n beskrywing kan byvoeg.';
$string['active'] = 'Aktief';
$string['activity'] = 'Aktiwiteit';
$string['addnewapp'] = 'Ontsper eksterne toepassing';
$string['addserver'] = 'Voeg nuwe betroubare bediener by';
$string['addtype'] = 'Voeg voorafingestelde nutsmiddel by';
$string['allow'] = 'Laat toe';
$string['allowinstructorcustom'] = 'Laat onderwysers toe om doelgemaakte parameters by te voeg';
$string['allowsetting'] = 'Laat toe dat nutsmiddel 8K van verstellings in Moodle berg';
$string['always'] = 'Altyd';
$string['autoaddtype'] = 'Voeg nutsmiddel by';
$string['automatic'] = 'Outomaties, gebaseer op nutsmiddel-URL';
$string['baseurl'] = 'Basis-URL/nutsmiddelregistrasienaam';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth-basisstring';
$string['basiclti_endpoint'] = 'LTI lanseereindpunt';
$string['basiclti_in_new_window'] = 'Jou aktiwiteit is in \'n nuwe venster oopgemaak';
$string['basiclti_in_new_window_open'] = 'Maak in nuwe venster oop';
$string['basiclti_parameters'] = 'LTI lanseerparameters';
$string['basicltiactivities'] = 'LRI-aktiwiteite';
$string['basicltifieldset'] = 'Doelgemaakte voorbeeld veldstel';
$string['basicltiintro'] = 'Aktiwiteitbeskrywing';
$string['basicltiname'] = 'Aktiwiteitnaam';
$string['basicltisettings'] = 'Basiese instellings vir leerinteraksie (LTI) verstellings';
$string['cancel'] = 'Kanselleer';
$string['cancelled'] = 'Gekanselleer';
$string['cannot_add'] = 'Jy mag nie \'n nuwe nutsmiddel byvoeg nie.';
$string['cannot_delete'] = 'Jy mag nie hierdie nutsmiddelkonfigurasie uitwis nie.';
$string['cannot_edit'] = 'Jy mag nie hierdie nutsmiddelkonfigurasie wysig nie.';
$string['capabilities'] = 'Vermoëns';
$string['capabilities_help'] = 'Kies die vermoëns wat jy aan die nutsmiddelverskaffer wil bied. Meer as een vermoë kan gekies word.';
$string['capabilitiesrequired'] = 'Hierdie nutsmiddel vereis toegang tot die volgende data om te aktiveer:';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Kliek om voort te gaan</a>';
$string['comment'] = 'Kommentaar';
$string['configpassword'] = 'Verstek afstandsnutsmiddelwagwoord';
$string['configpreferheight'] = 'Verstek verkose hoogte';
$string['configpreferwidget'] = 'Stel widget as verstek laai';
$string['configpreferwidth'] = 'Verstek verkose breedte';
$string['configresourceurl'] = 'Verstek hulpbron-URL';
$string['configtoolurl'] = 'Verstek afstandsnutsmiddel-URL';
$string['configtypes'] = 'Ontsper LTI-toepassings';
$string['configured'] = 'Gekonfigureer';
$string['confirmtoolactivation'] = 'Is jy seker jy wil hierdie nutsmiddel aktiveer?';
$string['contentitem'] = 'Inhoud-Itemboodskap';
$string['contentitem_help'] = 'Indien gekies, sal die opsie \'Kies inhoud\' beskikbaar wees wanneer \'n eksterne nutsmiddel bygevoeg word.';
$string['course_tool_types'] = 'Kursusnutsmiddels';
$string['courseactivitiesorresources'] = 'Kursusaktiwiteite of -hulpbronne';
$string['courseid'] = 'Kursus-ID-nommer';
$string['courseinformation'] = 'Kursusinligting';
$string['courselink'] = 'Gaan na kursus';
$string['coursemisconf'] = 'Kursus is verkeerd opgestel';
$string['createdon'] = 'Geskep op';
$string['curllibrarymissing'] = 'PHP Curl-biblioteek moet geïnstalleer wees om LTI te gebruik';
$string['custom'] = 'Doelgemaakte parameters';
$string['custom_config'] = 'Doelgemaakte nutsmiddelkonfigurasie word gebruik';
$string['custom_help'] = 'Doelgemaakte parameters is verstellings wat deur die nutsmiddelverskaffer gebruik word. Byvoorbeeld: \'n doelgemaakte parameter kan gebruik word om \'n spesifieke hulpbron vanaf die verskaffer te vertoon. Elke parameter behoort op \'n aparte lyn ingevoer te word met \'n formaat van "name=value"; byvoorbeeld "chapter=3".

Dit is veilig om hierdie veld onveranderd te laat tensy dit deur die nutsmiddelverskaffer aangedui word.';
$string['custominstr'] = 'Doelgemaakte paramters';
$string['debuglaunch'] = 'Ontfoutopsie';
$string['debuglaunchoff'] = 'Normale lansering';
$string['debuglaunchon'] = 'Ontfout laai';
$string['default'] = 'Verstek';
$string['default_launch_container'] = 'Verstek lanseerhouer';
$string['default_launch_container_help'] = 'Die lanseerhouer affekteer die vertoon van die nutsmiddel wanneer dit vanaf die kursus gelaai word. Sommige lanseerhouers bied meer vaste skermspasie aan die nutsmiddel, en ander bied \'n meer geïntegreerde gevoel met die Moodle-omgewing.

* **Verstek** - Gebruik die lanseerhouer wat deur die nutsmiddelkonfigurasie gespesifiseer is.
* **Inbed** - Die nutsmiddel word binne die bestaande Moodle-venster vertoon, op \'n soortgelyke manier as die meeste ander Aktiwiteitstipes.
* **Inbed, sonder blokke** - Die nutsmiddel word binne die bestaande Moodle-venster vertoon, met slegs die navigasiekontroles aan die bokant van die bladsy.
* **Nuwe venster** - Die nutsmiddel maak in \'n nuwe venster oop, waar dit al die beskikbare spasie beset.
        Afhangende van die blaaier sal dit in \'n nuwe oortjie of \'n opspringvenster oopmaak..
        Dit is moontlik dat blaaiers die nuwe venster sal verhoed om oop te maak.';
$string['delegate'] = 'Delegeer aan onderwyser';
$string['delete'] = 'Wis uit';
$string['delete_confirmation'] = 'Is jy seker jy wil hierdie voorafgekonfigureerde nutsmiddel uitwis?';
$string['deletetype'] = 'Wis voorafgekonfigureerde nutsmiddel uit';
$string['display_description'] = 'Vertoon aktiwiteitsbeskrywing wanneer gelanseer word';
$string['display_description_help'] = 'Indien gekies, sal die aktiwiteitsbeskrywing (hierbo gespesifiseer) bo die nutsmiddelverskaffer se inhoud vertoon.

Die beskrywing kan gebruik word om addisionele instruksies vir lanseerders van die nutsmiddel te bied, maar dit word nie vereis nie.

Die beskrywing word nooit vertoon wanneer die nutsmiddel se lanseerhouer in \'n nuwe venster is nie.';
$string['display_name'] = 'Vertoon aktiwiteitnaam wanneer lansering plaasvind';
$string['display_name_help'] = 'Indien gekies, sal die aktiwiteitnaam (hierbo gespesifiseer) bo die nutsmiddelverskaffer se inhoud vertoon.

Dit is moontlik dat die nutsmiddelverskaffer ook die titel sal vertoon. Hierdie opsie kan verhoed dat die aktiwiteitstitel twee maal vertoon word.

Die titel word nooit vertoon wanneer die nutsmiddel se lanseerhouer in \'n nuwe venster is nie.';
$string['domain_mismatch'] = 'Nutsmiddel-URL se domein stem nie ooreen met nutsmiddelkonfigurasie nie.';
$string['donot'] = 'Moet nie stuur nie';
$string['donotaccept'] = 'Moet nie aanvaar nie';
$string['donotallow'] = 'Moet nie toelaat nie';
$string['duplicateregurl'] = 'Hierdie registrasie-URL is reeds in gebruik';
$string['editdescription'] = 'Kliek hier om aan hierdie nutsmiddel \'n beskrywing te gee';
$string['edittype'] = 'Wysig voorafgekonfigureerde nutsmiddel';
$string['embed'] = 'Inbed';
$string['embed_no_blocks'] = 'Inbed, sonder blokke';
$string['enableemailnotification'] = 'Stuur kennisgewing-e-posse';
$string['enableemailnotification_help'] = 'Indien ontsper, sal studente e-poskennisgewings ontvang wanneer hul nutsmiddelindienings gemerk word.';
$string['enterkeyandsecret'] = 'Voer jou gebruikersleutel en gedeelde geheim in';
$string['enterkeyandsecret_help'] = 'As jy \'n gebruikersleutel en/of gedeelde geheim ontvang het, voer dit hier in';
$string['enterstemhere'] = 'Voer die Taaktitel, \'n vraag of \'n gedeelte van \'n sin hier in.';
$string['errorbadurl'] = 'URL is nie \'n geldige nutsmiddel-URL of patroon nie.';
$string['errorincorrectconsumerkey'] = 'Gebruikersleutel is verkeerd.';
$string['errorinvaliddata'] = 'Ongeldige data: {$a}';
$string['errorinvalidmediatype'] = 'Ongeldige mediatipe: {$a}';
$string['errorinvalidresponseformat'] = 'Ongeldige Inhoud-Item antwoordformaat.';
$string['errormisconfig'] = 'Verkeerd saamgestelde nutsmiddel. Vra asseblief jou Moodle-administrateur om die konfigurasie van hierdie nutsmiddel reg te maak.';
$string['errortooltypenotfound'] = 'LTI-nutsmiddeltipe is nie gevind nie.';
$string['existing_window'] = 'Bestaande venster';
$string['extensions'] = 'LTI-uitbreidingsdienste';
$string['external_tool_type'] = 'Voorafsaamgestelde nutsmiddel';
$string['external_tool_type_help'] = '* **Outomaties, gebaseer op nutsmiddel-URL** - Die beste nutsmiddelkonfigurasie word outomaties gekies. As die nutsmiddel-URL nie herken word nie, kan dit nodig wees dat die nutsmiddelkonfigurasie per hand ingevoer moet word.
* **\'n Spesifieke voorafsaamgestelde nutsmiddel** - Die nutsmiddelkonfigurasie vir die gespesifiseerde nutsmiddel sal gebruik word wanneer daar met die eksterne nutsmiddelverskaffer gekommunikeer word. As die nutsmiddel-URL blyk om nie aan die nutsmiddelverskaffer te behoort nie, sal \'n waarskuwing vertoon word. Dit is nie altyd nodig om \'n nutsmiddel-URL in te voer nie.
* **Doelgemaakte konfigurasie** - \'n Verbruikersleutel en gedeelde geheim kan per hand ingevoer moet word. Die verbruikersleutel en gedeelde geheim kan by die nutsmiddelverskaffer verkry word. Nie alle nutsmiddels vereis egter \'n verbruikersleutel en gedeelde geheim nie, in welke geval die velde leeg gelaat kan word.

### Voorafsaamgestelde nutsmiddelwysiging

Drie ikone is beskikbaar na die voorafsaamgestelde nutsmiddelaftreklys:

* **Voeg by** - Skep \'n kursusvlaknutsmiddelkonfigurasie. Alle Eksterne nutsmiddelinstansies in hierdie kursus kan die nutsmiddelkonfigurasie gebruik.
* **Wysig** - Kies \'n kursusvlaknutsmiddel vanaf die aftreklys, en kliek dan op hierdie ikoon. Die besonderhede van die nutsmiddelkonfigurasie kan gewysig word.
* **Wis uit** - Verwyder die gekose kursusvlaknutsmiddel.';
$string['external_tool_types'] = 'Voorafsaamgestelde nutsmiddels';
$string['failedtoconnect'] = 'Moodle kon nie met die "{$a}" stelsel kommunikeer nie';
$string['failedtocreatetooltype'] = '\'n Nuwe nutsmiddel kon nie geskep word nie. Kontroleer asseblief die URL en probeer weer.';
$string['failedtodeletetoolproxy'] = 'Nutsmiddelregistrasie kon nie uitgewis word nie. Dit kan nodig wees dat jy "Bestuur eksterne nutsmiddelregistrasies" besoek en dit per hand uitwis.';
$string['filter_basiclti_configlink'] = 'Konfigureer jou verkose werwe en hul wagwoorde';
$string['filter_basiclti_password'] = 'Wagwoord is verpligtend';
$string['filterconfig'] = 'LTI-administrasie';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Gebruik \'n bestaande konfigurasie vir die verkeerd opgestelde instansie';
$string['fixnew'] = 'Nuwe konfigurasie';
$string['fixnewconf'] = 'Definieer \'n nuwe konfigurasie vir die verkeerd opgestelde instansie';
$string['fixold'] = 'Gebruik bestaande';
$string['force_ssl'] = 'Dwing SSL';
$string['force_ssl_help'] = 'Deur hierdie opsie te kies, word alle lanserings na hierdie nutsmiddelverskaffer gedwing om SSL te gebruik.

Daarby sal alle webdiensversoeke van die nutsmiddelverskaffer SSL gebruik.

As hierdie opsie gebruik word, bevestig dat hierdie Moodle-werf en die nutsmiddelverskaffer SSL ondersteun.';
$string['forced_help'] = 'Hierdie verstelling is in \'n kursus- of werfvlaknutsmiddelkonfigurasie gedwing. Jy kan dit nie vanaf hierdie koppelvlak verander nie.';
$string['generalfeedback'] = 'Algemene terugvoer.';
$string['generalfeedback_help'] = 'Dieselfde algemene terugvoer word vertoon, ongeag die antwoord wat gekies is.';
$string['generaltool'] = 'Algemene nutsmiddel';
$string['global_tool_types'] = 'Globale voorafsaamgestelde nutsmiddels';
$string['grading'] = 'Puntroetering';
$string['icon_url'] = 'Ikoon-URL';
$string['icon_url_help'] = 'Die ikoon-URL laat toe dat die ikoon in die kursuslys vir hierdie aktiwiteit vir wysiging vertoon. Eerder as om die verstek
LTI-ikoon te gebruik, kan \'n ikoon wat die spesifieke tipe aktiwiteit aantoon, gespesifiseer word.';
$string['id'] = 'id';
$string['invalidid'] = 'LTI-ID was verkeerd';
$string['launch_in_moodle'] = 'Lanseer nutsmiddel in Moodle';
$string['launch_in_popup'] = 'Lanseer nutsmiddel in \'n opspringvenster';
$string['launch_url'] = 'Nutsmiddel-URL';
$string['launch_url_help'] = 'Die nutsmiddel-URL dui die webadres van die Eksterne Nutsmiddel aan en kan addisionele inligting bevat, soos die hulpbron wat vertoon word.
As jy onseker is wat jy in die nutsmiddel-URL moet invoer, bevestig asseblief met die nutsmiddelverskaffer vir meer inligting.

Jy kan \'n patroon-URL invoer as jy een het, en die res van die vormbesonderhede sal outomaties ingevul word.

As jy \'n voorafsaamgestelde nutsmiddel gekies het, mag jy nie \'n nutsmiddel-URL invoer nie. As die nutsmiddelskakel gebruik word net om in die nutsmiddelverskaffer se stelsel in te lanseer, en nie na \'n spesifieke hulpbron gaan nie, sal dit waarskynlik die geval wees.';
$string['launchinpopup'] = 'Lanseerhouer';
$string['launchinpopup_help'] = 'Die lanseerhouer affekteer die vertoon van die nutsmiddel wanneer dit vanaf die kursus gelaai word. Sommige lanseerhouers bied meer vaste skermspasie aan die nutsmiddel, en ander bied \'n meer geïntegreerde gevoel met die Moodle-omgewing.

* **Verstek** - Gebruik die lanseerhouer wat deur die nutsmiddelkonfigurasie gespesifiseer is.
* **Inbed** - Die nutsmiddel word binne die bestaande Moodle-venster vertoon, op \'n soortgelyke manier as die meeste ander Aktiwiteitstipes.
* **Inbed, sonder blokke** - Die nutsmiddel word binne die bestaande Moodle-venster vertoon, met slegs die navigasiekontroles aan die bokant van die bladsy.
* **Nuwe venster** - Die nutsmiddel maak in \'n nuwe venster oop, waar dit al die beskikbare spasie beset.
        Afhangende van die blaaier sal dit in \'n nuwe oortjie of \'n opspringvenster oopmaak.
        Dit is moontlik dat blaaiers die nuwe venster sal verhoed om oop te maak.';
$string['launchoptions'] = 'Lanseeropsies';
$string['leaveblank'] = 'Laat leeg as jy dit nie benodig nie';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Voeg kursusspesifieke nutsmiddelkonfigurasies by';
$string['lti:adddefaultinstance'] = 'Voeg \'n nieglobaal-gekonfigureerde nutsmiddel by';
$string['lti:addgloballypreconfigedtoolinstance'] = 'Voeg \'n globaal-gekonfigureerde nutsmiddel by';
$string['lti:addinstance'] = 'Voeg nuwe eksterne nutsmiddelaktiwiteite by';
$string['lti:admin'] = 'LTI-qtype Admin';
$string['lti:backupcourse'] = 'LTI-qtype Kursusrugsteun deur Kursus-ID';
$string['lti:grade'] = 'Besigtig punte wat deur eksterne nutsmiddel teruggestuur is';
$string['lti:manage'] = 'Wees \'n Instrukteur wanneer die nutsmiddel gelanseer word';
$string['lti:regradelti'] = 'LTI-qtype Vasvra-hermerk deur Quiz-ID';
$string['lti:requesttooladd'] = 'Versoek-\'n-nutsmiddel word regoor die werf gekonfigureer';
$string['lti:view'] = 'Lanseer eksterne nutsmiddelaktiwiteite';
$string['lti_administration'] = 'Wysig voorafsaamgestelde nutsmiddel';
$string['lti_errormsg'] = 'Die nutsmiddel het die volgende foutboodskap teruggestuur: "{$a}"';
$string['lti_launch_error'] = '\'n Fout het voorgekom tydens die lansering van die eksterne nutsmiddel:';
$string['lti_launch_error_tool_request'] = '<p>
Om \'n versoek in te dien vir \'n administrateur om die nutsmiddelkonfigurasie te voltooi, kliek <a href="{$a->admin_request_url}" target="_top">hier</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Hierdie fout kan die gevolg wees van \'n ontbrekende verbuikersleutel en gedeelde geheim vir die nutsmiddelverskaffer.</p>
<p>As jy \'n verbruikersleutel en gedeelde geheim het, kan jy dit invoer wanneer jy die eksterne nutsmiddelinstansie wysig (maak seker dat gevorderde opsies sigbaar is).</p>
<p>Alternatiewelik kan jy <a href="{$a->course_tool_editor}">\'n kursusvlak-nutsmiddelverskafferkonfigurasie skep</a>.</p>';
$string['lti_tool_request_added'] = 'Nutsmiddelkonfigurasieversoek is suksesvol ingedien. Dit kan nodig wees om \'n administrateur te kontak om die nutsmiddelkonfigurasie te voltooi.';
$string['lti_tool_request_existing'] = '\'n Nutsmiddelkonfigurasie vir die nutsmiddeldomein is reeds ingedien.';
$string['ltisettings'] = 'LTI-verstellings';
$string['ltiunknownserviceapicall'] = 'LTI onbekende diens-API-oproep.';
$string['main_admin'] = 'Algemene hulp';
$string['main_admin_help'] = 'Eksterne nutsmiddels laat Moodle-gebruikers toe om naatloos interaksie te hê met leerhulpbronne wat oor \'n afstand aangebied word. Deur \'n spesiale lanseerprotokol sal die afstandsnutsmiddel toegang tot algemene inligting aangaande die lanserende gebruiker hê. Byvoorbeeld,
die instansienaam, kursus-id, gebruiker-id, en ander inligting, soos die gebruiker se naam of e-posadres.

Nutsmiddels wat op hierdie bladsy gelys word, word in drie kategorieë verdeel:

* **Aktief** - Hierdie nutsmiddelverskaffers is deur \'n administrateur goedgekeur en gekonfigureer. Dit kan vanuit enige kursus op hierdie Moodle-instansie gebruik word. As \'n verbruikersleutel en gedeelde geheim ingevoer word, word \'n vertrouensverhouding tussen hierdie Moodle-instansie en die afstandsnutsmiddel daargestel, wat \'n veilige kommunikasiekanaal verskaf.
* **Hangende** - Hierdie nutsmiddelverskaffers het deur \'n pakketinvoer ingekom, maar is nie deur \'n administrateur gekonfigureer nie.
Onderwysers kan steeds nutsmiddels van hierdie verskaffers gebruik as hulle \'n verbruikersleutel en gedeelde geheim het, of as daar nie so iets vereis word nie.
* **Verwerp** - Hierdie nutsmiddelverskaffers word gemerk as dié wat \'n administrateur nie van plan is om aan die hele Moodle-instansie beskikbaar te maak nie. Onderwysers kan steeds nutsmiddels van hierdie verskaffers gebruik as hulle \'n verbruikersleutel en gedeelde geheim het, of as daar nie so iets vereis word nie.';
$string['manage_external_tools'] = 'Bestuur LTI-Qtype Eksterne nutsmiddels';
$string['manage_tool_proxies'] = 'Bestuur LTI-Qtype eksterne nutsmiddelinstaners';
$string['manage_tools'] = 'Bestuur LTI-Qtype voorafsaamgestelde nutsmiddels';
$string['manuallyaddtype'] = 'Alternatiewelik kan jy <a href="{$a}">\'n nutsmiddel per hand konfigureer</a>.';
$string['maxpoints'] = 'Maks. Punte';
$string['miscellaneous'] = 'Velerlei';
$string['misconfiguredtools'] = 'Nutsmiddelinstansies wat verkeerd opgestel is, is bespeur';
$string['missingparameterserror'] = 'Die bladsy is verkeer opgestel: "{$a}"';
$string['module_class_type'] = 'Moodle Moduletipe';
$string['modulename'] = 'Eksterne nutsmiddel';
$string['modulename_help'] = 'Die eksterne nutsmiddelaktiwiteitmodule stel studente in staat op met leerhulpbronne en aktiwiteite op ander webwerwe interaksie te hê. Byvoorbeeld: \'n eksterne nutsmiddel kan toegang tot \'n nuwe aktiwiteitstipe of leermateriaal van \'n uitgewer bied.

Om \'n eksterne nutsmiddelaktiwiteit te skep, word \'n nutsmiddelverskaffer wat LTI (Leernutsmiddelsinteraksie) ondersteun, vereis. \'n Onderwyser kan \'n eksterne nutsmiddelaktiwiteit skep of gebruik maak van \'n nutsmiddel wat deur die werfadministrateur gekonfigureer is.

Eksterne nutsmiddelaktiwiteite verskil op \'n paar maniere van URL-nutsmiddels:

* Eksterne nutsmiddels is konteksbewus, d.w.s. dit het toegang tot inligting oor die gebruiker wat die nutsmiddel gelanseer het, soos instituut, kursus en naam
* Eksterne nutsmiddels ondersteun die lees, bywerk en uitwis van punte wat met die aktiwiteitsinstansie geassosieer word
* Eksterne nutsmiddelkonfigurasies skep \'n vertrouensverhouding tussen jou werf en die nutsmiddelverskaffer, wat \'n veilige kommunikasiekanaal verskaf';
$string['modulenameplural'] = 'Eksterne nutsmiddels';
$string['modulenamepluralformatted'] = 'LTI-Instansies';
$string['name'] = 'Naam';
$string['never'] = 'Nooit';
$string['new_window'] = 'Nuwe venster';
$string['no_lti_configured'] = 'Daar is geen aktiewe eksterne nutsmiddels gekonfigureer nie.';
$string['no_lti_pending'] = 'Daar is geen hangende eksterne nutsmiddels nie.';
$string['no_lti_rejected'] = 'Daar is geen verwerpte eksterne nutsmiddels nie.';
$string['no_lti_tools'] = 'Daar is geen eksterne nutsmiddels gekonfigureer nie.';
$string['no_tp_accepted'] = 'Daar is geen aanvaarde eksterne nutsmiddelregistrasies nie.';
$string['no_tp_cancelled'] = 'Daar is geen gekanselleerde eksterne nutsmiddelregistrasies nie.';
$string['no_tp_configured'] = 'Daar is geen ongeregistreerde eksterne nutsmiddelregistrasies gekonfigureer nie.';
$string['no_tp_pending'] = 'Daar is geen hangende eksterne nutsmiddelregistrasies nie.';
$string['no_tp_rejected'] = 'Daar is geen verwerpte eksterne nutsmiddelregistrasies nie.';
$string['noattempts'] = 'Geen pogings is op hierdie nutsmiddelinstansie aangewend nie';
$string['noltis'] = 'Daar is geen eksterne nutsmiddelinstansies nie';
$string['noprofileservice'] = 'Profieldiens is nie gevind nie';
$string['noservers'] = 'Geen bedieners gevind nie';
$string['notypes'] = 'Daar is tans geen LTI-nutsmiddels in Moodle opgestel nie. Kliek die Installeer-skakel hierbo om nutsmiddels by te voeg.';
$string['noviewusers'] = 'Geen gebruikers met toestemmings om hierdie nutsmiddel te gebruik, is gevind nie.';
$string['optionalsettings'] = 'Opsionele verstellings';
$string['organization'] = 'Organisasiebesonderhede';
$string['organizationdescr'] = 'Organisasiebeskrywing';
$string['organizationid'] = 'Organisasie-ID';
$string['organizationid_help'] = '\'n Unieke identifiseerder vir hierdie Moodle-instansie. Die DNA-naam van die organisasie word gewoonlik gebruik.

As hierdie veld oopgelaat word, sal die gasheernaam van hierdie Moodle-werf as die verstekwaarde gebruik word.';
$string['organizationurl'] = 'Organisasie-URL';
$string['organizationurl_help'] = 'Die basis-URL van hierdie Moodle-instansie.

As hierdie veld oopgelaat word, sal \'n verstekwaarde gebruik word, gebaseer op die werfkonfigurasie.';
$string['pagesize'] = 'Indienings wat per bladsy vertoon word';
$string['parameter'] = 'Nutsmiddelparameters';
$string['parameter_help'] = 'Nutsmiddelparameters is verstellings wat van die nutsmiddelverskaffer in die aanvaarde nutsmiddelinstaner versoek word.';
$string['password'] = 'Gedeelde geheim';
$string['password_admin'] = 'Gedeelde geheim';
$string['password_admin_help'] = 'Die gedeelde geheim kan as \'n wagwoord beskou word om toegang tot die hulpmiddel te verifieer. Dit behoort saam met die verbruikersleutel deur die hulpmiddelverskaffer verskaf te word.

Hulpmiddels wat nie veilige kommunikasie van Moodle vereis nie en nie addisionele dienste (soos punteverslae) lewer nie, vereis nie noodwendig \'n gedeelde geheim nie.';
$string['password_help'] = 'Vir voorafsaamgestelde hulpmiddels is dit nie nodig om hier \'n gedeelde geheim in te voer nie, aangesien die gedeelde geheim as deel van die konfigurasieproses verskaf sal word.

Hierdie veld behoort ingevoer te word as \'n skakel na \'n hulpmiddelverskaffer geskep word wat nie reeds gekonfigureer is nie.
As die hulpmiddelverskaffer meer as een maal in hierdie kursus gebruik gaan word, is dit \'n goeie idee om \'n kursushulpmiddelkonfigurasie by te voeg.

Die gedeelde geheim kan as wagwoord beskou word om toegang tot die hulpmiddel te valideer. Dit behoort saam met die verbruikersleutel deur die hulpmiddelverskaffer verskaf te word.

Hulpmiddels wat nie veilige kommunikasie van Moodle vereis nie en nie addisionele dienste (soos punteverslae) lewer nie, vereis nie noodwendig \'n gedeelde geheim nie.';
$string['pending'] = 'Hangende';
$string['pluginadministration'] = 'Eksterne hulpmiddeladministrasie';
$string['pluginname'] = 'Eksterne vraagtipe (ETH)';
$string['pluginname_help'] = 'Met Eksterne vraagtipes word vrae of opdragte vanaf ander hulpmiddels in Moodle ingesluit.';
$string['pluginnameadding'] = '\'n Eksterne vraagtipe word bygevoeg';
$string['pluginnameediting'] = '\'n Eksterne vraagtipe word gewysig';
$string['pluginnamesummary'] = 'Met die Eksterne vraagtipe kan \'n mens aan \'n vraag of opdrag wat in \'n ander hulpmiddel geskep is, koppel.';
$string['preferheight'] = 'Verkose hoogte';
$string['preferwidget'] = 'Verkose widgetlansering';
$string['preferwidth'] = 'Verkose breedte';
$string['press_to_submit'] = 'Druk om hierdie aktiwiteit te lanseer';
$string['privacy'] = 'Privaatheid';
$string['privacy:metadata:coursefullname'] = 'Die volnaam van die kursus vanwaar die gebruiker tot die LTI-Verbruiker toegang verkry';
$string['privacy:metadata:courseid'] = 'Die ID van die kursus vanwaar die gebruiker tot die LTI-Verbruiker toegang verkry';
$string['privacy:metadata:courseidnumber'] = 'Die ID-nommer van die kursus vanwaar die gebruiker tot die LTI-Verbruiker toegang verkry';
$string['privacy:metadata:courseshortname'] = 'Die kortnaam van die kursus vanwaar die gebruiker tot die LTI-Verbruiker toegang verkry';
$string['privacy:metadata:createdby'] = 'Die gebruiker wat die rekord geskep het';
$string['privacy:metadata:email'] = 'Die e-posadres van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:externalpurpose'] = 'Die LTI-Verbruiker verskaf gebruikerinligting en -konteks aan die LTI-Hulpmiddelverskaffer.';
$string['privacy:metadata:firstname'] = 'Die noemnaam van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:fullname'] = 'Die volnaam van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:lastname'] = 'Die van van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:role'] = 'Die rol in die kursus vir die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:userid'] = 'Die ID van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:useridnumber'] = 'Die ID-nommer van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['privacy:metadata:username'] = 'Die gebruikersnaam van die gebruiker wat toegang tot die LTI-Verbruiker kry';
$string['quickgrade'] = 'Laat snelmerk toe';
$string['quickgrade_help'] = 'Indien ontsper, kan etlike hulpmiddels op een bladsy gemerk word. Voeg punte en kommentaar by en kliek die "Berg al my terugvoer"-knoppie om alle veranderinge op daardie bladsy te berg.';
$string['redirect'] = 'Jy sal binne \'n paar sekondes herlei word. As dit nie gebeur nie, druk die knoppie.';
$string['register'] = 'Registreer';
$string['register_warning'] = 'Die registrasiebladsy lyk asof dit \'n tyd neem om oop te maak. As dit nie verskyn nie, kontroleer dat jy die korrekte URL in die konfigurasieverstellings ingevoer het. As Moodle https gebruik, verseker dat die hulpmiddel wat jy konfigureer https ondersteun en dat jy https in die URL gebruik.';
$string['registertype'] = 'Konfigureer \'n nuwe eksterne hulpmiddelregistrasie';
$string['registration_options'] = 'Registrasie-opsies';
$string['registrationname'] = 'Hulpmiddelverskaffernaam';
$string['registrationname_help'] = 'Voer die naam van die hulpmiddelverskaffer wat geregistreer word, in.';
$string['registrationurl'] = 'Registrasie-URL';
$string['registrationurl_help'] = 'Die registrasie-URL behoort vanaf die hulpmiddelverskaffer beskikbaar te wees as die plek waarheen registrasieversoeke gestuur behoort te word.';
$string['reject'] = 'Verwerp';
$string['rejected'] = 'Is verwerp';
$string['removerestoredlink'] = 'Verwyder die LTI-hulpmiddel-URL met herstel';
$string['removerestoredlink_help'] = 'Deur hierdie opsie te ontsper sal die Hulpmiddel-URL van elke herstelde vraag verwyder word. Let asseblief daarop dat hierdie opsie nie die hulpmiddelverskafferkonneksie sal verwyder nie.';
$string['resource'] = 'Hulpbron';
$string['resourcekey'] = 'Verbruikersleutel';
$string['resourcekey_admin'] = 'Verbruikersleutel';
$string['resourcekey_admin_help'] = 'Die verbruikersleutel kan as gebruikersnaam geskou word wat gebruik word om toegang tot die hulpmiddel te valideer.
Dit kan deur die hulpmiddelverskaffer gebruik word om die Moodle-werf, vanwaar gebruikers in die hulpmiddel lanseer, uniek te identifiseer.

Die verbruikersleutel moet deur die hulpmiddelverskaffer verskaf word. Die metode van verkryging van \'n verbruikersleutel wissel van een hulpmiddelverskaffer tot die volgende. Dit kan \'n outomatiese proses wees, of dit kan \'n gesprek met die hulpmiddelverskaffer vereis.

Hulpmiddels wat nie veilige kommunikasie van Moodle vereis nie en nie addisionele dienste (soos punteverslae) lewer nie, vereis nie noodwendig \'n hulpbronsleutel nie.';
$string['resourcekey_help'] = 'Vir voorafingestelde hulpmiddels is dit nie nodig om \'n hulpbronsleutel hier in te voer nie, aangesien die verbruikersleutel as deel van die konfigurasieproses verskaf sal word.

Hierdie veld behoort ingevoer te word as \'n skakel na \'n hulpmiddelverskaffer, wat nog nie gekonfigureer is nie, geskep word.
As die hulpmiddelverskaffer meer as een maal in hierdie kursus gebruik gaan word, is dit \'n goeie idee om \'n kursushulpmiddelkonfigurasie by te voeg.

Die verbruikersleutel kan as \'n gebruikernaam beskou word, wat gebruik word om toegang tot die hulpmiddel te valideer.
Dit kan deur die hulpmiddelverskaffer gebruik word om die Moodle-werf vanwaar gebruikers in die hulpmiddel in lanseer, uniek te identifiseer.

Die verbruikersleutel moet deur die hulpmiddelverskaffer verskaf word. Die metode om \'n verbruikersleutel te verkry, verskil van een hulpmiddelverskaffer tot \'n volgende. Dit kan \'n outomatiese proses wees, of dit kan \'n gesprek met die hulpmiddelverskaffer vereis.

Hulpmiddels wat nie veilige kommunikasie met Moodle vereis nie en nie addisionele dienste (soos punteverslae) lewer nie, vereis moontlik nie \'n hulpbronsleutel nie.';
$string['resourceurl'] = 'Hulpbron-URL';
$string['return_to_course'] = 'Kliek <a href="{$a->link}" target="_top">hier</a> om na die kursus terug te keer.';
$string['reviewmode'] = 'In hersieningsmodus';
$string['saveallfeedback'] = 'Berg al my terugvoer';
$string['search:activity'] = 'Eksterne hulpmiddel - aktiwiteitinligting';
$string['secure_icon_url'] = 'Veilige ikoon-URL';
$string['secure_icon_url_help'] = 'Soortgelyk aan die ikoon-URL, maar word gebruik as die gebruiker wat toegang tot Moodle verkry, dit veilig deur SSL doen. Die hoofdoel van hierdie veld is om te verhoed dat die blaaier die gebruiker waarsku as die onderliggende bladsy deur SSL ingegaan is, maar versoek om \'n onveilige prent te vertoon.';
$string['secure_launch_url'] = 'Veilige hulpmiddel-URL';
$string['secure_launch_url_help'] = 'Soortgelyk aan die hulpmiddel-URL, maar word eerder as die hulpmiddel-URL gebruik indien \'n hoë vlak van sekuriteit vereis word. Moodle sal die veilige hulpmiddel-URL eerder as die hulpmiddel-URL gebruik as die Moodle-werf deur SSL ingegaan is, of as die hulpmiddelkonfigurasie gestel is om altyd deur SSL te lanseer.

Die hulpmiddel-URL kan ook na \'n https-adres gestel word om lansering deur SSL te forseer, en hierdie veld kan leeg gelaat word.';
$string['selectcontent'] = 'Kies inhoud';
$string['send'] = 'Stuur';
$string['services'] = 'Dienste';
$string['services_help'] = 'Kies die dienste wat jy aan die hulpmiddelverskaffer wil bied. Meer as een diens kan gekies word.';
$string['setupoptions'] = 'Opstelopsies';
$string['share_email'] = 'Deel lanseerder se e-pos met die hulpmiddel';
$string['share_email_admin'] = 'Deel lanseerder se e-pos met die hulpmiddel';
$string['share_email_admin_help'] = 'Spesifiseer of die e-posadres van die gebruiker wat die hulpmiddel lanseer, met die hulpmiddelverskaffer gedeel gaan word.
Die hulpmiddelverskaffer kan die lanseerder se e-posadresse benodig om te onderskei tussen gebruikers met dieselfde name in die gebruikerskoppelvlak, of om e-posse aan gebruikers te stuur op grond van aksies binne die hulpmiddel.';
$string['share_email_help'] = 'Spesifiseer of die e-posadresse van die gebruiker wat die hulpmiddel lanseer, met die hulpmiddelverskaffer gedeel gaan word.

Die hulpmiddelverskaffer kan die lanseerder se e-posadresse benodig om te onderskei tussen gebruikers met dieselfde naam, of om e-posse aan gebruikers te stuur op grond van aksies binne die hulpmiddel.

Let daarop dat hierdie verstelling in die hulpmiddelkonfigurasie oorheengeskryf kan word.';
$string['share_name'] = 'Deel lanseerder se naam met die hulpmiddel';
$string['share_name_admin'] = 'Deel lanseerder se naam met die hulpmiddel';
$string['share_name_admin_help'] = 'Spesifiseer of die volle naam van die gebruiker wat die hulpmiddel lanseer, met die hulpmiddelverskaffer gedeel behoort te word.
Die hulpmiddelverskaffer kan lanseerders se name benodig om betekenisvolle inligting binne die hulpmiddel te vertoon.';
$string['share_name_help'] = 'Spesifiseer of die volle naam van die gebruiker wat die hulpmiddel lanseer, met die hulpmiddelverskaffer gedeel behoort te word.

Die hulpmiddelverskaffer kan lanseerders se name benodig om betekenisvolle inligting binne die hulpmiddel te vertoon.

Let daarop dat hierdie verstelling in die hulpmiddelkonfigurasie oorheengeskryf kan word.';
$string['share_roster'] = 'Laat toe dat hulpmiddel toegang tot hierdie kursus se rooster het';
$string['share_roster_admin'] = 'Hulpmiddel mag toegang tot kursusrooster hê';
$string['share_roster_admin_help'] = 'Spesifiseer of die hulpmiddel toegang het tot die lys van gebruikers wat in kursusse ingeskryf is waaruit hierdie hulpmiddel gelanseer word.';
$string['share_roster_help'] = 'Spesifiseer of hierdie hulpmiddel toegang het tot die lys van gebruikers wat in hierdie kursus ingeskryf is.

Let daarop dat hierdie verstelling in die hulpmiddelkonfigurasie oorheengeskryf kan word.';
$string['show_in_course_activity_chooser'] = 'Vertoon in aktiwiteitkieser en as voorafingestelde hulpmiddel';
$string['show_in_course_lti1'] = 'Hulpmiddelkonfigurasiegebruik';
$string['show_in_course_lti1_help'] = 'Hierdie hulpmiddel kan in die aktiwiteitkieser vertoon word vir \'n onderwyser om te kies om \'n kursus aan te vul. Alternatiewelik kan dit in die voorafingestelde hulpmiddelaftrekkieslys vertoon word wanneer \'n eksterne hulpmiddel by \'n kursus gevoeg word. \'n Verdere opsie is vir die hulpmiddelkonfigurasie om slegs gebruik te word as die presiese hulpmiddel-URL ingevoer word wanneer \'n eksterne hulpmiddel by \'n kursus gevoeg word.';
$string['show_in_course_lti2'] = 'Hulpmiddelkonfigurasiegebruik';
$string['show_in_course_lti2_help'] = 'Hierdie hulpmiddel kan in die aktiwiteitkieser vertoon word vir \'n onderwyser om te kies om \'n kursus by te voeg, of in die voorafingestelde hulpmiddelaftrekkieslys wanneer \'n eksterne hulpmiddel by \'n kursus gevoeg word.';
$string['show_in_course_no'] = 'Moet nie vertoon nie; gebruik slegs wanneer \'n ooreenstemmende hulpmiddel-URL ingevoer word';
$string['show_in_course_preconfigured'] = 'Vertoon as voorafingestelde hulpmiddel wanneer \'n eksterne hulpmiddel bygevoeg word';
$string['size'] = 'Grootteparamaters';
$string['stem'] = 'Stam';
$string['submission'] = 'Indiening';
$string['submissions'] = 'Indienings';
$string['submissionsfor'] = 'Indienings vir {$a}';
$string['subplugintype_ltiresource'] = 'LTI-dienshulpbron';
$string['subplugintype_ltiresource_plural'] = 'LTI-dienshulpbronne';
$string['subplugintype_ltiservice'] = 'LTI-diens';
$string['subplugintype_ltiservice_plural'] = 'LTI-dienste';
$string['subplugintype_ltisource'] = 'LTI-bron';
$string['subplugintype_ltisource_plural'] = 'LTI-bronne';
$string['successfullycreatedtooltype'] = '\'n Nuwe hulpmiddel is suksesvol geskep!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Hulpmiddelkonfigurasie is suksesvol vanuit die gekose inhoud gehaal.';
$string['tasktitle'] = 'Taaktitel';
$string['toggle_debug_data'] = 'Tokkel ontfoutingdata';
$string['tool_config_not_found'] = 'Hulpmiddelkonfigurasie vir hierdie URL is nie gevind nie.';
$string['tool_settings'] = 'Hulpmiddelverstellings';
$string['tooldescription'] = 'Nutsmiddelbeskrywing';
$string['tooldescription_help'] = 'Die beskrywing van die nutsmiddel wat aan onderwysers in die aktiwiteitlys vertoon sal word.

Dit behoort te beskryf waarvoor die nutsmiddel is en wat dit doen, en enige addisionele inligting wat die onderwyser moet weet.';
$string['toolisbeingused'] = 'Hierdie nutsmiddel word {$a} keer gebruik';
$string['toolisnotbeingused'] = 'Hierdie nutsmiddel is nog nie gebruik nie';
$string['toolproxy'] = 'Eksterne nutsmiddelregistrasies';
$string['toolproxy_help'] = 'Eksterne nutsmiddelregistrasies laat werfadministrateurs van Moodle toe om eksterne nutsmiddels te konfigureer, wat vanaf \'n nutsmiddelinstaner van \'n nutsmiddelverskaffer verkry is, wat  LTI 2.0 ondersteun. \'n Registrasie-URL wat deur die nutsmiddelverskaffer verskaf word, is al wat nodig is om die proses te begin. Die vermoëns en dienste wat aan die nutsmiddelverskaffer gebied word, word gekies wanneer \'n nuwe registrasie gekonfigureer word,

Nutsmiddelregistrasies wat op hierdie bladsy gelys word, word in vier kategorieë verdeel:

* **Gekonfigureer** - Hierdie nutsmiddelregistrasies is opgestel, maar daar is nog nie met die registrasieproses begin nie.
* **Hangende** - Daar is met die registrasieproses vir hierdie nutsmiddelregistrasies begin, maar dit is nie voltooi nie. Maak die verstellings oop en berg dit om dit terug na die \'Gekonfigureer\'-kategorie te skuif.
* **Aanvaar** - Hierdie nutsmiddelregistrasies is goedgekeur; die hulpbronne wat in die nutsmiddelinstaner gespesifiseer is, sal op die voorafopgestelde nutsmiddelsbladsy met \'n aanvanklike status as \'Hangende\' verskyn.
* **Verwerp** - Hierdie nutsmiddelregistrasies is dié wat tydens die registrasieproses verwerp is. Maak die verstellings oop en berg dit om dit terug na die \'Gekonfigureer\'-kategorie te skuif, sodat daar met die registrasieproses begin kan word.';
$string['toolproxyregistration'] = 'Eksterne nutsmiddelregistrasie';
$string['toolregistration'] = 'Eksterne nutsmiddelregistrasie';
$string['toolsetup'] = 'Eksterne nutsmiddelkonfigurasie';
$string['tooltypeadded'] = 'Voorafingestelde nutsmiddel is bygevoeg';
$string['tooltypedeleted'] = 'Voorafingestelde nutsmiddel is uitgewis';
$string['tooltypenotdeleted'] = 'Kon nie voorafingestelde nutsmiddel uitwis nie';
$string['tooltypes'] = 'Nutsmiddels';
$string['tooltypeupdated'] = 'Voorafingestelde nutsmiddels';
$string['toolurl'] = 'Nutsmiddel-URL';
$string['toolurl_help'] = 'Die nutsmiddel-URL word gebruik om nutsmiddel-URL\'e by die korrekte nutsmiddelkonfigurasie te pas. Dit is opsioneel om http(s) as prefiks by die URL te voeg.

Addisioneel word die basis-URL gebruik as nutsmiddel-URL, as \'n nutsmiddel-URL nie in die eksterne nutsmiddelinstansie gespesifiseer is nie.

Byvoorbeeld, \'n basis-URL van *tool.com* sal by die volgende pas:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

\'n Basis-URL van *www.tool.com/quizzes* sal by die volgende pas:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

\'n Basis-URL van *quiz.tool.com* sal by die volgende pas:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

As twee verskillende nutsmiddelkonfigurasies vir dieselfde domein is, sal die mees spesifieke ooreenkoms gebruik word.

Jy kan ook \'n houer-URL invoeg as jy een het, en die details vir die nutsmiddel sal outomaties ingevul word.';
$string['toolurlplaceholder'] = 'Nutsmiddel-URL ...';
$string['typename'] = 'Nutsmiddelnaam';
$string['typename_help'] = 'Die nutsmiddelnaam word gebruik om die nutsmiddelverskaffer binne Moodle te identifiseer. Die naam wat ingevoer is sal aan onderwysers sigbaar wees wanneer eksterne nutsmiddels binne kursusse bygevoeg word.';
$string['types'] = 'Tipes';
$string['unabletocreatetooltype'] = 'Nutsmiddel kon nie geskep word nie';
$string['unabletofindtooltype'] = 'Nutsmiddel vir {$a->id} kon nie gevind word nie';
$string['unknownstate'] = 'Onbekende toestand';
$string['update'] = 'Bywerking';
$string['useraccountinformation'] = 'Gebruikersrekeninginligting';
$string['userpersonalinformation'] = 'Gebruiker se persoonlike inligting';
$string['using_tool_cartridge'] = 'Nutsmiddelhouer word gebruik';
$string['using_tool_configuration'] = 'Nutsmiddelkonfigurasie word gebruik:';
$string['validurl'] = '\'n Geldige URL moet met http(s):// begin';
$string['viewsubmissions'] = 'Besigtig indiening- en punteskerm';
