<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'af', version '4.0'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Aanvaar';
$string['accept_grades'] = 'Aanvaar punte vanuit die hulpmiddel';
$string['accept_grades_admin'] = 'Aanvaar punte vanuit die hulpmiddel';
$string['accept_grades_admin_help'] = 'Spesifiseer of die hulpmiddelverskaffer punte wat met eksemplare van hierdie hulpmiddel geassoseer word, kan byvoeg, bywerk, lees en skrap.

Sommige hulpmiddelverskaffers ondersteun rapportering van punte terug aan Moodle gegrond op aksies wat binne die hulpmiddel geneem is en skep sodoende \'n meer geïntegreerde ervaring.';
$string['accept_grades_help'] = 'Spesifiseer of die hulpmiddelverskaffer punte wat slegs met hierdie eksterne hulpmiddeleksemplaar geassoseer word, kan byvoeg, bywerk, lees en skrap.

Sommige hulpmiddelverskaffers ondersteun rapportering van punte terug aan Moodle gegrond op aksies wat binne die hulpmiddel geneem is en skep sodoende \'n meer geïntegreerde ervaring.

Let daarop dat hierdie instelling oorheers kan word in die hulpmiddelkonfigurasie.';
$string['accepted'] = 'Aanvaar';
$string['action'] = 'Aksie';
$string['activate'] = 'Aktiveer';
$string['activatetoadddescription'] = 'Jy sal eers hierdie hulpmiddel moet aktiveer voordat jy \'n beskrywing kan byvoeg.';
$string['active'] = 'Aktief';
$string['activity'] = 'Aktiwiteit';
$string['add_ltiadv'] = 'Voeg LTI Advantage by';
$string['add_ltilegacy'] = 'Voeg Legacy LTI by';
$string['addnewapp'] = 'Ontsper eksterne toepassing';
$string['addserver'] = 'Voeg nuwe vertroude bediener by';
$string['addtype'] = 'Voeg hulpmiddel by wat vooraf gekonfigureer is';
$string['allow'] = 'Laat toe';
$string['allowsetting'] = 'Laat hulpmiddel toe om 8K van instellings in Moodle te stoor';
$string['always'] = 'Altyd';
$string['autoaddtype'] = 'Voeg hulpmiddel by';
$string['automatic'] = 'Outomaties, gegrond op hulpmiddel se URL';
$string['baseurl'] = 'Basis-URL/hulpmiddel se registrasienaam';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth-basisstring';
$string['basiclti_endpoint'] = 'LTI-laai-eindpunt';
$string['basiclti_in_new_window'] = 'Jou aktiwiteit het \'n nuwe venster geopen';
$string['basiclti_in_new_window_open'] = 'Open \'n nuwe venster';
$string['basiclti_parameters'] = 'LTI-laaiparameters';
$string['basicltiactivities'] = 'LTI-aktiwiteite';
$string['basicltifieldset'] = 'Verpersoonlik voorbeeld van veldinstelling';
$string['basicltiintro'] = 'Aktiwiteitbeskrywing';
$string['basicltiname'] = 'Aktiwiteitnaam';
$string['basicltisettings'] = 'Basiese instellings vir Learning Tool Interoperability (LTI)';
$string['cachedef_keyset'] = 'Cache hulpmiddels se keySet-inligting';
$string['cancel'] = 'Kanselleer';
$string['cancelled'] = 'Gekanselleer';
$string['cannot_delete'] = 'Jy kan nie hierdie hulpmiddelkonfigurasie skrap nie.';
$string['cannot_edit'] = 'Jy kan nie hierdie hulpmiddelkonfigurasie redigeer nie.';
$string['capabilities'] = 'Vermoëns';
$string['capabilities_help'] = 'Kies daardie vermoëns wat jy aan die hulpmiddelverskaffer wil bied. Meer as een vermoë kan gekies word.';
$string['capabilitiesrequired'] = 'Hierdie hulpmiddel benodig toegang tot die volgende data sodat dit geaktiveer kan word:';
$string['cleanaccesstokens'] = 'Verwydering deur eksterne hulpmiddel van toegangsbewyse wat verstryk het';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Klik om voort te gaan</a>';
$string['clientidadmin'] = 'Kliënt-ID';
$string['clientidadmin_help'] = 'Die kliënt-ID is \'n unieke waarde wat gebruik word om \'n hulpmiddel te identifiseer. Dit word outomaties geskep vir elke hulpmiddel wat gebruikmaak van die JWT-sekuriteitsprofiel soos in LTI 1.3 bekendgestel en moet deel wees van die details wat na die hulpmiddelverskaffers aangestuur word sodat hulle die verbinding aan hulle kant kan konfigureer.';
$string['comment'] = 'Kommentaar';
$string['configpassword'] = 'Verstekwagwoord vir afstandshulpmiddel';
$string['configpreferheight'] = 'Verstekvoorkeurhoogte';
$string['configpreferwidget'] = 'Stel hulptuig as versteklaai';
$string['configpreferwidth'] = 'Verstekvoorkeurwydte';
$string['configresourceurl'] = 'Verstekhulpbron-URL';
$string['configtoolurl'] = 'Verstek-URL vir eksterne hulpmiddel';
$string['configtypes'] = 'Aktiveer LTI-toepassings';
$string['configured'] = 'Gekonfigureer';
$string['confirmtoolactivation'] = 'Is jy seker jy wil hierdie hulpmiddel aktiveer?';
$string['contentitem'] = 'Inhoud-Itemboodskap';
$string['contentitem_deeplinking'] = 'Ondersteun Deep Linking (Inhoud-Itemboodskap)';
$string['contentitem_deeplinking_help'] = 'Indien gemerk sal die opsie "Kies inhoud" beskikbaar wees wanneer \'n eksterne hulpmiddel bygevoeg word.';
$string['contentitem_help'] = 'Indien gemerk sal die opsie "Kies inhoud" beskikbaar wees wanneer \'n eksterne hulpmiddel bygevoeg word.';
$string['contentitem_multiple_description'] = 'Die volgende items sal by jou kursus gevoeg word:';
$string['contentitem_multiple_graded'] = 'Bepunte aktiwiteit (Maksimum punt: {$a})';
$string['course_tool_types'] = 'Kursushulpmiddels';
$string['courseactivitiesorresources'] = 'Kursusaktiwiteite of -hulpbronne';
$string['courseid'] = 'Kursus-ID-nommer';
$string['courseinformation'] = 'Kursusinligting';
$string['courselink'] = 'Gaan na kursus';
$string['coursemisconf'] = 'Kursus is verkeerd gekonfigureer';
$string['createdon'] = 'Geskep op';
$string['curllibrarymissing'] = 'PHP cURL-uitbreiding benodig vir eksterne hulpmiddel.';
$string['custom'] = 'Verpersoonlik parameters';
$string['custom_config'] = 'Gebruik pasgemaakte hulpmiddelkonfigurasie';
$string['custom_help'] = 'Verpersoonlikte parameters  is instellings wat deur die hulpbronverskaffer gebruik word. \'n Verpersoonlikte parameter kan, byvoorbeeld, gebruik word om \'n spesifieke hulpbron vanaf die verskaffer te wys. Elke parameter moet op \'n afsonderlike lyn gewys word deur \'n formaat  "naam=waarde" te gebruik, byvoorbeeld "hoofstuk=3".

Dit is veilig om hierdie veld onveranderd te laat tensy anders deur die hulpmiddelverskaffer aangesê.';
$string['custominstr'] = 'Verpersoonlik parameters';
$string['debuglaunch'] = 'Ontfoutingsopsie';
$string['debuglaunchoff'] = 'Normale laai';
$string['debuglaunchon'] = 'Ontfout laai';
$string['default'] = 'Verstek';
$string['default_launch_container'] = 'Versteklaaihouer';
$string['default_launch_container_help'] = 'Die laaihouer het \'n impak op hoe die hulpmiddel wys wanneer dit vanuit die kursus gelaai word. Sommige laaihouers veroorsaak  dat die hulpmiddel \'n groter deel van die skerm beslaan, en ander bied \'n meer geïntegreerde gevoel met die Moodle-omgewing.

* **Verstek** - Gebruik die laaihouer wat deur die hulpmiddelkonfigurasie gespesifiseer is.
* **Ingebed** - Die hulpmiddel word binne die bestaande Moodle-venster gewys, op \'n manier soortgelyk aan die meeste ander aktiwiteitstipes.
* **Ingebed, sonder blokke** - Die hulpmiddel word binne die bestaande Moodle-venster gewys, met slegs die navigasiekontroles bo-aan die blad.
        * **Nuwe venster** - Die hulpmiddel maak oop in \'n nuwe venster wat alle beskikbare spasie opneem.
        Afhangende van die blaaier sal dit in \'n nuwe oortjie of \'n opwipvenster oopmaak.
        Dit is moontlik dat blaaiers kan verhoed dat die nuwe venster oopmaak.';
$string['delegate'] = 'Delegeer na onderwyser';
$string['delegate_tool'] = 'Soos gespesifiseer in "Deep Linking"-omskrywing of Delegeer na onderwyser';
$string['delete'] = 'Skrap';
$string['delete_confirmation'] = 'Is jy seker jy wil hierdie voorafgekonfigureerde hulpmiddel skrap?';
$string['deletetype'] = 'Skrap voorafgekonfigureerde hulpmiddel';
$string['display_description'] = 'Wys aktiwiteitsbeskrywing wanneer oopgemaak';
$string['display_description_help'] = 'Indien geaktiveer sal die aktiwiteitsbeskrywing (hierbo gespesifiseer) bokant die hulpmiddelverskaffer se inhoud gewys word.

Die beskrywing kan gebruik word om addisionele instruksies te gee aan diegene wat die hulpmiddel laai, maar is nie \'n vereiste nie.

Die beskrywing word nooit gewys wanneer die hulpmiddel se laaihouer in \'n nuwe venster is nie.';
$string['display_name'] = 'Wys aktiwiteitsnaam wanneer oopgemaak';
$string['display_name_help'] = 'Indien geaktiveer sal die aktiwiteitnaam (hierbo gespesifiseer) bokant die hulpmiddelverskaffer se inhoud gewys word.

Dit is moontlik dat die hulpmiddelverskaffer ook die titel wys. Hierdie opsie kan verhoed dat die aktiwiteit se titel twee keer gewys word.

Die titel word nooit gewys wanneer die hulpmiddel se laaihouer in \'n nuwe venster is nie.';
$string['domain_mismatch'] = 'Hulpmiddel-URL se domein stem nie ooreen met hulpmiddelkonfigurasie nie';
$string['donot'] = 'Moenie stuur nie';
$string['donotaccept'] = 'Moenie aanvaar nie';
$string['donotallow'] = 'Moenie toelaat nie';
$string['duplicateregurl'] = 'Hierdie registrasie-URL word reeds gebruik';
$string['dynreg_update_btn_new'] = 'Registreer as \'n nuwe eksterne hulpmiddel';
$string['dynreg_update_btn_update'] = 'Werk by';
$string['dynreg_update_name'] = 'Hulpmiddel se naam';
$string['dynreg_update_notools'] = 'Geen hulpmiddels in konteks nie';
$string['dynreg_update_text'] = 'Geen bestaande hulpmiddels is by die registrasie se domein aangeheg nie. Wil jy \'n eksterne hulpmiddel wat reeds geïnstalleer is, bywerk of \'n nuwe eksterne hulpmiddel skep?';
$string['dynreg_update_url'] = 'Basis-URL';
$string['dynreg_update_version'] = 'LTI weergawe';
$string['dynreg_update_warn_dupdomain'] = 'Dit is nie raadsaam om meervoudige eksterne hulpmiddels onder dieselfde domein te hê nie.';
$string['editdescription'] = 'Klik hier om \'n beskrywing vir hierdie hulpmiddel te gee';
$string['edittype'] = 'Redigeer voorafgekonfigureerde hulpmiddel';
$string['embed'] = 'Bed in';
$string['embed_no_blocks'] = 'Bed in, sonder blokke';
$string['enableemailnotification'] = 'Stuur kennisgewing-e-posse';
$string['enableemailnotification_help'] = 'Indien geaktiveer sal studente \'n kennisgewing per e-pos ontvang wanneer hulle hulpmiddelindienings bepunt is.';
$string['enterkeyandsecret'] = 'Tik jou verbruikersleutel en gedeelde geheim in.';
$string['enterkeyandsecret_help'] = 'As \'n verbruikersleutel en/of gedeelde geheim aan jou verskaf is, tik hulle hier in';
$string['errorbadurl'] = 'URL is nie \'n geldige hulpmiddel-URL of -lading nie.';
$string['errorincorrectconsumerkey'] = 'Verbruikersleutel is verkeerd';
$string['errorinvaliddata'] = 'Ongeldige data: {$a}';
$string['errorinvalidmediatype'] = 'Ongeldige mediatipe: {$a}';
$string['errorinvalidresponseformat'] = 'Ongeldige responsformaat vir Inhoud-Item';
$string['errormisconfig'] = 'Hulpmiddel verkeerd gekonfigureer. Vra jou Moodle-administrateur asseblief om die konfigurasie van die hulpmiddel reg te stel.';
$string['errortooltypenotfound'] = 'LTI-hulpmiddeltipe nie gevind nie.';
$string['existing_window'] = 'Bestaande venster';
$string['extensions'] = 'LTI-uitbreidingsdienste';
$string['external_tool_type'] = 'Voorafgekonfigureerde hulpmiddel';
$string['external_tool_type_help'] = '* **Outomaties, gegrond op hulpmiddel-URL** - Die beste hulpmiddelkonfigurasie word outomaties gekies. As die hulpmiddel-URL nie herken word nie, moet details vir hulpmiddelkonfigurasie dalk handmatig ingevoer word.
* **\'n Gespesifiseerde voorafgekonfigureerde hulpmiddel** - Die hulpmiddelkonfigurasie vir die gespesifiseerde hulpmiddel sal gebruik word wanneer daar met die eksterne hulpmiddelverskaffer gekommunikeer word. As die hulpmiddel-URL klaarblyklik nie aan die hulpbronverskaffer behoort nie, sal \'n waarskuwing gewys word. Dit is nie altyd nodig om \'n hulpmiddel-URL in te tik nie.
* **Verpersoonlik konfigurasie** - \'n Verbruikersleutel en gedeelde geheim moet dalk handmatig ingevoer word. Die verbruikersleutel en gedeelde geheim kan vanaf die hulpmiddelverskaffer bekom word. Nie alle hulpmiddels verlang egter \'n verbruikersleutel en gedeelde geheim nie, in welke geval dié velde leeg gelaat kan word.

### Redigering van voorafgekonfigureerde hulpmiddels

Drie ikone is beskikbaar ná die aftrekkieslys vir voorafgekonfigureerde hulpmiddels:

* **Voeg by** - Skep \'n hulpmiddelkonfigurasie op kursusvlak. Alle eksemplare van eksterne hulpmiddels kan hierdie konfigurasie gebruik.
* **Redigeer** - Kies \'n hulpmiddel op kursusvlak vanuit die aftrekkieslys en klik dan op hierdie ikoon. Die details van die hulpmiddelkonfigurasie kan geredigeer word.
* **Skrap** - Verwyder die hulpmiddel op kursusvlak.';
$string['external_tool_types'] = 'Voorafgekonfigureerde hulpmiddels';
$string['failedtoconnect'] = 'Moodle kon nie met die "{$a}"-stelsel kommunikeer nie';
$string['failedtocreatetooltype'] = 'Kon nie \'n nuwe hulpmiddel skep nie. Gaan asseblief die URL na en probeer weer.';
$string['failedtodeletetoolproxy'] = 'Kon nie hulpmiddelregistrasie skrap nie. Jy moet "Bestuur registrasie van eksterne hulpmiddels" besoek en dit handmatig skrap.';
$string['filter_basiclti_configlink'] = 'Konfigureer jou voorkeurwebwerwe en hul wagwoorde';
$string['filter_basiclti_password'] = 'Wagwoord is verpligtend';
$string['filterconfig'] = 'LTI-administrasie';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Gebruik \'n bestaande konfigurasie vir die eksemplaar wat verkeerd gekonfigureer is';
$string['fixnew'] = 'Nuwe konfigurasie';
$string['fixnewconf'] = 'Gebruik \'n nuwe konfigurasie vir die eksemplaar wat verkeerd gekonfigureer is';
$string['fixold'] = 'Gebruik bestaande';
$string['force_ssl'] = 'Forseer SSL';
$string['force_ssl_help'] = 'As hierdie opsie gekies word, moet alles wat vanaf hierdie hulpmiddelverskaffer gelaai word SSL gebruik.

Voorts sal alle webdiensversoeke vanaf die hulpmiddelverskaffer SSL gebruik.

As hierdie opsie gebruik word, bevestig dat hierdie Moodle-webwerf en die hulpmiddelverskaffer SSL ondersteun.';
$string['forced_help'] = 'Hierdie instelling is geforseer vir hulpmiddelkonfigurasie op \'n kursus- of webwerfvlak. Jy kan dit nie via hierdie koppelvlak verander nie.';
$string['generaltool'] = 'Algemene hulpmiddel';
$string['global_tool_types'] = 'Voorafgekonfigureerde hulpmiddels';
$string['grading'] = 'Puntroetering';
$string['icon_url'] = 'Ikoon-URL';
$string['icon_url_help'] = 'Die ikoon-URL maak dit moontlik om die ikoon wat in die kursusinskrywing vir hierdie aktiwiteit gewys word, te redigeer. In plaas daarvan om die verstek-LTI-ikoon te gebruik, kan \'n ikoon gespesifiseer word wat die tipe aktiwiteit uitspel.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gegrond op die kognitiewe diepte wat die student in \'n LTI-aktiwiteit behaal het.';
$string['indicator:cognitivedepthdef'] = 'LTI kognitief';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die kognitiewe betrokkenheid bereik wat deur die LTI-aktiwiteite aangebied word (Vlakke = Nie bekyk nie, Bekyk, Ingedien, Terugvoer bekyk)';
$string['indicator:socialbreadth'] = 'LTI sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gegrond op die sosiale omvang wat deur die student in \'n LTI-aktiwiteit bereik is.';
$string['indicator:socialbreadthdef'] = 'LTI sosiaal';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die sosiale betrokkenheid bereik wat deur die LTI-aktiwiteite aangebied word (Vlakke = Geen deelname nie, Slegs deelnemer, Deelnemer saam met ander)';
$string['initiatelogin'] = 'Inisieer aanmeld-URL';
$string['initiatelogin_help'] = 'Die hulpmiddel-URL waarheen versoeke gestuur moet word om aanmelding te inisieer. Die URL word verlang voordat \'n boodskap suksesvol na die hulpmiddel gestuur kan word.';
$string['invalidid'] = 'LTI-ID was verkeerd';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Tipe openbare sleutel';
$string['keytype_help'] = 'Die magtigingsmetode wat gebruik word om die hulpmiddel te valideer';
$string['keytype_keyset'] = 'keySet-URL';
$string['keytype_rsa'] = 'RSA-sleutel';
$string['launch_in_moodle'] = 'Laai hulpmiddel in Moodle';
$string['launch_in_popup'] = 'Laai hulpmiddel in \'n opwip';
$string['launch_url'] = 'Hulpmiddel-URL';
$string['launch_url_help'] = 'Die hulpmiddel-URl dui die webadres van die eksterne hulpmiddel aan en kan addisionele inligting bevat, soos die hulpbron wat gewys moet word. As jy nie seker is wat as die hulpmiddel-URL ingetik moet word nie, vra die hulpmiddelverskaffer asseblief vir meer inligting.

Jy kan \'n lading-URL intik as jy een het, en die res van die details op die vorm sal outomaties ingevul word.

As jy \'n hulpmiddel gekies het wat vooraf gekonfigureer is, is dit dalk nie nodig om \'n hulpmiddel-URL in te tik nie. As die hulpmiddelskakel bloot gebruik word om die hulpmiddelverskaffer se stelsel te laai, en nie om na \'n spesifieke hulpbron te gaan nie, sal dit waarskynlik die geval wees.';
$string['launchinpopup'] = 'Laaihouer';
$string['launchinpopup_help'] = 'Die laaihouer het \'n impak op hoe die hulpmiddel wys wanneer dit vanuit die kursus gelaai word. Sommige laaihouers veroorsaak  dat die hulpmiddel \'n groter deel van die skerm beslaan, en ander bied \'n meer geïntegreerde gevoel met die Moodle-omgewing.

* **Verstek** - Gebruik die laaihouer wat deur die hulpmiddelkonfigurasie gespesifiseer is.
* **Ingebed** - Die hulpmiddel word binne die bestaande Moodle-venster gewys, op \'n manier soortgelyk aan die meeste ander aktiwiteitstipes.
* **Ingebed, sonder blokke** - Die hulpmiddel word binne die bestaande Moodle-venster gewys, met slegs die navigasiekontroles bo-aan die blad.
* **Nuwe venster** - Die hulpmiddel maak oop in \'n nuwe venster wat alle beskikbare spasie opneem.
        Afhangende van die blaaier sal dit in \'n nuwe oortjie of \'n opwipvenster oopmaak.
        Dit is moontlik dat blaaiers kan verhoed dat die nuwe venster oopmaak.';
$string['launchoptions'] = 'Laai-opsies';
$string['leaveblank'] = 'Moenie invul as jy hulle nie nodig het nie';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Voeg kursusspesifieke hulpbronkonfigurasies by';
$string['lti:addinstance'] = 'Voeg \'n eksterne hulpmiddel by';
$string['lti:addmanualinstance'] = 'Voeg \'n hulpmiddel by wat handmatig gekonfigureer is';
$string['lti:addpreconfiguredinstance'] = 'Voeg \'n hulpmiddel by wat vooraf gekonfigureer is';
$string['lti:admin'] = 'Wees \'n administrateur wanneer die hulpmiddel gelaai word';
$string['lti:grade'] = 'Bekyk punte wat deur die eksterne hulpmiddel opgelewer word';
$string['lti:manage'] = 'Wees \'n instrukteur wanneer die hulpmiddel gelaai word';
$string['lti:requesttooladd'] = 'Versoek \'n hulpmiddel wat vir die hele webwerf gekonfigureer is';
$string['lti:view'] = 'Laai aktiwiteite vir eksterne hulpmiddels';
$string['lti_administration'] = 'Redigeer voorafgekonfigureerde hulpmiddel';
$string['lti_errormsg'] = 'Die hulpmiddel het die volgende foutboodskap teruggestuur: "{$a}"';
$string['lti_launch_error'] = 'Kon nie die eksterne hulpmiddel laai nie:';
$string['lti_launch_error_tool_request'] = '<p>
Om \'n administrateur te versoek om hierdie hulpmiddel se konfigurasie te voltooi, klik <a href="{$a->admin_request_url}" target="_top">hier</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Hierdie fout is dalk weens \'n verbruikersleutel en gedeelde geheim wat vir die hulpmiddelverskaffer ontbreek.</p>
<p>As jy \'n verbruikersleutel en \'n gedeelde geheim het, kan jy dit intik wanneer die eksemplaar van die eksterne hulpmiddel geredigeer word (maak seker dat gevorderde opsies sigbaar is).</p>
<p>So nie, kan jy <a href="{$a->course_tool_editor}"> \'n konfigurasie vir die hulpmiddel op kursusvlak skep</a>.</p>';
$string['lti_tool_request_added'] = 'Versoek vir hulpmiddel se konfigurasie suksesvol ingedien. Jy sal die administrateur dalk moet kontak om die hulpmiddelkonfigurasie af te handel.';
$string['lti_tool_request_existing'] = '\'n Hulpmiddelkonfigurasie vir die hulpmiddeldomein is reeds ingedien.';
$string['ltisettings'] = 'LTI-instellings';
$string['ltiunknownserviceapicall'] = 'API-roep deur onbekende LTI-diens';
$string['ltiversion'] = 'LTI-weergawe';
$string['ltiversion_help'] = 'Die weergawe van LTI wat gebruik word om vir boodskappe en diensversoeke in te teken: LTI 1.0/1.1 en LTI 2.0 gebruik die OAuth 1.0A-sekuriteitsprofiel; LTI 1.3.0 gebruik JWT\'s.';
$string['main_admin'] = 'Algemene hulp';
$string['main_admin_help'] = 'Eksterne hulpmiddels maak dit vir Moodle-gebruikers moontlik om met leerhulpbronne om te gaan wat elders gehuisves word. Via ŉ spesiale laaiprotokol het die afstandshulpmiddel toegang tot algemene inligting oor die gebruiker wat dit laai, byvoorbeeld die instansie se naam, kursus-ID, gebruiker-ID, en ander inligting soos die gebruiker se naam of e-posadres.

Hulpmiddels gelys op hierdie blad, word in drie kategorieë geskei:

* **Aktief** - Hierdie hulpmiddelverskaffers is deur ŉ administrateur goedgekeur en gekonfigureer. Hulle kan vanuit enige kursus op hierdie webwerf gebruik word. Indien ŉ verbruikersleutel en gedeelde geheim ingevoer is, word ŉ vertrouensverhouding tussen hierdie webwerf en afstandshulpmiddels daargestel om sodoende ŉ beveiligde kommunikasiekanaal te skep.
* **Afwagtend** - Hierdie hulpmiddelverskaffers het ingekom via ŉ pakket wat ingetrek is maar hulle is nog nie deur ŉ administrateur gekonfigureer nie. Onderwysers kan nogtans hulpmiddels vanaf hierdie verskaffers gebruik as hulle ŉ verbruikersleutel en gedeelde geheim het, of indien geen verlang word nie.
* **Afgekeur** - Hierdie hulpmiddelverskaffers is gemerk as daardie wat die administrateur glad nie van voorneme is om op die webwerf beskikbaar te stel nie. Onderwysers kan nogtans hulpmiddels vanaf hierdie verskaffers gebruik as hulle ŉ verbruikersleutel en gedeelde geheim het, of indien geen verlang word nie.';
$string['manage_external_tools'] = 'Bestuur hulpmiddels';
$string['manage_tool_proxies'] = 'Bestuur registrasie van eksterne hulpmiddels';
$string['manage_tools'] = 'Bestuur voorafgekonfigureerde hulpmiddels';
$string['manuallyaddtype'] = 'So nie, kan jy <a href="{$a}">\'n hulpmiddel handmatig konfigureer</a>.';
$string['miscellaneous'] = 'Allerlei';
$string['misconfiguredtools'] = 'Eksemplare van hulpmiddels wat verkeerd gekonfigureer is, is bespeur';
$string['missingparameterserror'] = 'Die bladsy is verkeerd gekonfigureer: "{$a}"';
$string['module_class_type'] = 'Moodle-moduletipe';
$string['modulename'] = 'Eksterne hulpmiddel';
$string['modulename_help'] = 'Die module eksterne hulpmiddelaktiwiteite stel studente in staat om betrokke te raak by leerhulpbronne en -aktiwiteite op ander webwerwe. ŉ Eksterne hulpmiddel kan, byvoorbeeld, toegang tot ŉ nuwe tipe aktiwiteit of leermateriaal komende van ŉ uitgewer bied.

Om ŉ eksterne hulpmiddelaktiwiteit te skep, vereis ŉ hulpmiddelverskaffer wat LTI (Learning Tools Interoperability) ondersteun. ŉ Onderwyser kan ŉ eksterne hulpmiddelaktiwiteit skep of gebruikmaak van ŉ hulpmiddel wat deur die webwerf se administrateur gekonfigureer is.

Eksterne hulpmiddelaktiwiteite verskil in verskeie opsigte van URL-hulpbronne:

* Eksterne hulpmiddels is konteksbewus, d.w.s. hulle het toegang tot inligting oor die gebruiker wat die hulpmiddel gelaai het, soos instansie, kursus en naam
* Eksterne hulpmiddels ondersteun die lees, bywerking en skrap van punte wat met die aktiwiteit se eksemplaar geassosieer word
* Die konfigurasie van eksterne hulpmiddels maak dit moontlik om ŉ vertrouensverhouding tussen jou webwerf en die verskaffer van die afstandshulpmiddel daar te stel om sodoende ŉ beveiligde kommunikasiekanaal te skep';
$string['modulenameplural'] = 'Eksterne hulpmiddels';
$string['modulenamepluralformatted'] = 'LTI-eksemplare';
$string['name'] = 'Naam';
$string['never'] = 'Nooit';
$string['new_window'] = 'Nuwe venster';
$string['no_lti_configured'] = 'Geen aktiewe eksterne hulpmiddels is gekonfigureer nie.';
$string['no_lti_pending'] = 'Daar is geen afwagtende eksterne hulpmiddels nie.';
$string['no_lti_rejected'] = 'Daar is geen afgekeurde eksterne hulpmiddels nie.';
$string['no_lti_tools'] = 'Geen eksterne hulpmiddels is gekonfigureer nie.';
$string['no_tp_accepted'] = 'Geen registrasies van eksterne hulpmiddels is aanvaar nie.';
$string['no_tp_cancelled'] = 'Geen registrasies van eksterne hulpmiddels is gekanselleer nie.';
$string['no_tp_configured'] = 'Geen registrasies van ongeregistreerde eksterne hulpmiddels is gekonfigureer nie.';
$string['no_tp_pending'] = 'Geen registrasies van eksterne hulpmiddels is afwagtend nie.';
$string['no_tp_rejected'] = 'Geen registrasies van eksterne hulpmiddels is verwerp nie.';
$string['noattempts'] = 'Geen pogings is vir hierdie hulpmiddel se eksemplare aangewend nie';
$string['noltis'] = 'Geen eksemplare van eksterne hulpmiddels nie';
$string['noprofileservice'] = 'Profieldiens nie gevind nie';
$string['noservers'] = 'Geen bedieners gevind nie';
$string['notypes'] = 'Tans is geen LTI-hulpmiddels in Moodle opgestel nie. Klik op die Installeerskakel hierbo om \'n paar by te voeg.';
$string['noviewusers'] = 'Geen gebruikers met toestemming om hierdie hulpmiddel te gebruik, is gevind nie';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 vereis dat \'n geldige openssl.cnf op jou webbediener gekonfigureer en beskikbaar moet wees. Kontak asseblief die webwerfadministrateur om openssl vir hierdie webwerf te konfigureer en te aktiveer.';
$string['optionalsettings'] = 'Opsionele instellings';
$string['organization'] = 'Organisasiedetails';
$string['organizationdescr'] = 'Organisasiebeskrywing';
$string['organizationid'] = 'Organisasie-ID';
$string['organizationid_default'] = 'Verstek ID vir organisasie';
$string['organizationid_default_help'] = 'Die verstekwaarde wat as organisasie-ID gebruik moet word. Webwerf-ID identifiseer hierdie installasie van Moodle.';
$string['organizationid_help'] = '\'n Unieke identifiseerder vir hierdie Moodle-eksemplaar: In die reël word die DNS-naam van die organisasie gebruik.

As hierdie veld nie ingevul word nie, sal die gasheernaam van hierdie Moodle-webwerf as verstekwaarde gebruik word.';
$string['organizationidguid'] = 'Organisasie-ID';
$string['organizationidguid_help'] = '\'n Unieke identifiseerder vir hierdie Moodle-eksemplaar wat op die hulpmiddel as die platformeksemplaar-GUID afgedruk word.

As hierdie veld nie ingevul word nie, sal die verstekwaarde gebruik word.';
$string['organizationurl'] = 'Organisasie-URL';
$string['organizationurl_help'] = 'Die basis-URL vir hierdie Moodle-eksemplaar.

As die veld leeg is, sal \'n verstekwaarde gebruik word gegrond op die webwerf se konfigurasie.';
$string['pagesize'] = 'Indienings gewys per blad';
$string['parameter'] = 'Hulpmiddelparameters';
$string['parameter_help'] = 'Hulpmiddelparameters is instellings wat die hulpmiddelverskaffer op versoek in die hulpmiddel se volmag moet afdruk.';
$string['password'] = 'Gedeelde geheim';
$string['password_admin'] = 'Gedeelde geheim';
$string['password_admin_help'] = 'Die gedeelde geheim is soortgelyk aan \'n wagwoord wat gebruik word om toegang tot die hulpmiddel te magtig. Dit moet verskaf word tesame met die verbruikersleutel wat deur die hulpmiddelverskaffer voorsien is.

Hulpmiddels wat nie beveiligde kommunikasie vanaf Moodle verlang nie en nie addisionele dienste (soos verslagdoening oor punte) bied nie, kan dalk nie \'n gedeelde geheim verlang nie.';
$string['password_help'] = 'Vir voorafgekonfigureerde hulpmiddels is dit nie nodig om \'n gedeelde geheim hier in te tik nie aangesien die gedeelde geheim as deel van die konfigurasieproses verskaf word.

Hierdie veld moet ingevul word as jy ŉ skakel wil skep met ŉ hulpmiddelverskaffer wat nog nie gekonfigureer is nie. As die hulpmiddelverskaffer telkens in hierdie kursus gebruik gaan word, sou dit raadsaam wees om konfigurasie vir kursushulpmiddels by te voeg.

Die gedeelde geheim is soortgelyk aan \'n wagwoord wat gebruik word om toegang tot die hulpmiddel te magtig. Dit moet verskaf word tesame met die verbruikersleutel wat deur die hulpmiddelverskaffer voorsien is.

Hulpmiddels wat nie beveiligde kommunikasie vanaf Moodle verlang nie en nie addisionele dienste (soos verslagdoening oor punte) bied nie, kan dalk nie \'n gedeelde geheim verlang nie.';
$string['pending'] = 'Afwagtend';
$string['pluginadministration'] = 'Administrasie van eksterne hulpmiddel';
$string['pluginname'] = 'Eksterne hulpmiddel';
$string['preferheight'] = 'Voorkeurhoogte';
$string['preferwidget'] = 'Verkies om hulptuig te laai';
$string['preferwidth'] = 'Voorkeurwydte';
$string['press_to_submit'] = 'Druk om hierdie aktiwiteit te laai';
$string['privacy'] = 'Privaatheid';
$string['privacy:metadata:coursefullname'] = 'Die volle naam van die kursus vanwaar die gebruiker toegang tot LTI Consumer verkry';
$string['privacy:metadata:courseid'] = 'Die ID van die kursus vanwaar die gebruiker toegang tot LTI Consumer verkry';
$string['privacy:metadata:courseidnumber'] = 'Die ID-nommer van die kursus vanwaar die gebruiker toegang tot LTI Consumer verkry';
$string['privacy:metadata:courseshortname'] = 'Die verkorte naam van die kursus vanwaar die gebruiker toegang tot LTI Consumer verkry';
$string['privacy:metadata:createdby'] = 'Die gebruiker wat hierdie rekord geskep het';
$string['privacy:metadata:email'] = 'Die e-posadres van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:externalpurpose'] = 'Die LTI Consumer verskaf gebruikerinligting en konteks aan die LTI Tool Provider.';
$string['privacy:metadata:firstname'] = 'Die voornaam van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:fullname'] = 'Die volle naam van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:lastname'] = 'Die van van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:lti_submission'] = 'LTI-indiening';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Die tydstempel wat aantoon wanneer die indiening gedoen is';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Die tydstempel wat aantoon wanneer die indiening gewysig is';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Die punt van die gebruiker as \'n persentasie';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Die oorspronklike punt van die gebruiker';
$string['privacy:metadata:lti_submission:userid'] = 'Die ID van die gebruiker wat vir die LTI-aktiwiteit ingedien het';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI-instaanbedieners';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Naam van LTI-instaanbediener';
$string['privacy:metadata:lti_types'] = 'LTI-tipes';
$string['privacy:metadata:lti_types:name'] = 'LTI-tipenaam';
$string['privacy:metadata:role'] = 'Die rol in die kursus vir die gebruiker wat toegang tot die LTI Consumer verkry';
$string['privacy:metadata:timecreated'] = 'Die tyd toe die rekord geskep is';
$string['privacy:metadata:timemodified'] = 'Die tyd toe die rekord gewysig is';
$string['privacy:metadata:userid'] = 'Die ID van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:useridnumber'] = 'Die ID-nommer van die gebruiker wat toegang tot LTI Consumer verkry';
$string['privacy:metadata:username'] = 'Die gebruikernaam van die gebruiker wat toegang tot LTI Consumer verkry';
$string['publickey'] = 'Openbare sleutel';
$string['publickey_help'] = 'Die openbare sleutel (in PEM-formaat) wat deur die hulpmiddel verskaf ten einde handtekenings wat deur inkomende boodskappe en diensversoeke verskaf word, te verifieer.';
$string['publickeyset'] = 'Openbare keySet';
$string['publickeyset_help'] = 'Openbare keySet vanaf hierdie webwerf sal die hulpmiddel se openbare sleutel herwin ten einde handtekenings wat deur inkomende boodskappe en diensversoeke verskaf word, te verifieer.';
$string['quickgrade'] = 'Laat blitsige bepunting toe';
$string['quickgrade_help'] = 'Indien geaktiveer, kan veelvoudige hulpmiddels op een blad bepunt word. Voeg punte en kommentaar by en klik dan die “Stoor al my terugvoer”-knoppie om alle veranderings vir daardie blad te stoor.';
$string['redirect'] = 'Jy sal binne \'n paar sekondes aangestuur word. As dit nie gebeur nie, druk die knoppie.';
$string['redirectionuris'] = 'Aanstuur-URI(\'s)';
$string['redirectionuris_help'] = '\'n Lys van URI\'s (een per lyn) wat deur die hulpmiddel gebruik word wanneer magtigingsversoeke gerig word. Ten minste een moet geregistreer wees voordat \'n boodskap suksesvol na die hulpmiddel gestuur kan word.';
$string['register'] = 'Registreer';
$string['register_warning'] = 'Dit wil voorkom asof die registrasieblad \'n wyle vat om oop te maak. As dit nie wys nie, maak seker dat jy die regte URL in die konfigurasie-instellings ingetik het. As Moodle https gebruik, maak seker dat die hulpmiddel wat jy konfigureer https ondersteun en dat jy https in die URL gebruik.';
$string['registertype'] = 'Konfigureer registrasie vir \'n nuwe eksterne hulpmiddel';
$string['registration_options'] = 'Registrasie-opsies';
$string['registrationname'] = 'Hulpmiddelverskaffer se naam';
$string['registrationname_help'] = 'Tik die naam in van die hulpmiddelverskaffer wat geregistreer moet word.';
$string['registrationurl'] = 'Registrasie-URL';
$string['registrationurl_help'] = 'Die registrasie-URL behoort deur die hulpmiddelverskaffer beskikbaar gestel te word as die ligging waarheen registrasieversoeke gestuur moet word.';
$string['reject'] = 'Afgekeur';
$string['rejected'] = 'Afgekeur';
$string['resource'] = 'Hulpbron';
$string['resourcekey'] = 'Verbruikersleutel';
$string['resourcekey_admin'] = 'Verbruikersleutel';
$string['resourcekey_admin_help'] = 'Die gebruikersleutel is soortgelyk aan \'n gebruikernaam wat gebruik word om toegang tot die hulpmiddel te magtig. Dit kan deur die hulpmiddelverskaffer gebruik word om die Moodle-webwerf vanwaar die gebruiker die hulpmiddel laai op ŉ unieke wyse te identifiseer.

Die gebruikersleutel moet deur die hulpbronverskaffer verskaf word. Die metode waarvolgens ŉ verbruikersleutel bekom word, varieer van verskaffer tot verskaffer. Dit kan ŉ geoutomatiseerde proses wees, of dit kan verg dat daar ŉ dialoog met die hulpmiddelverskaffer gevoer word.

Hulpmiddels wat nie beveiligde kommunikasie vanaf Moodle verlang nie en nie addisionele dienste (soos verslagdoening oor punte) bied nie, kan dalk nie \'n hulpmiddelsleutel verlang nie.';
$string['resourcekey_help'] = 'Vir voorafgekonfigureerde hulpmiddels is dit nie nodig om \'n hulpbronsleutel hier in te tik nie aangesien die verbruikersleutel as deel van die konfigurasieproses verskaf word.

Hierdie veld moet ingevul word as jy ŉ skakel wil skep met ŉ hulpmiddelverskaffer wat nog nie gekonfigureer is nie. As die hulpmiddelverskaffer telkens in hierdie kursus gebruik gaan word, sou dit raadsaam wees om konfigurasie vir kursushulpmiddels by te voeg.

Die gebruikersleutel is soortgelyk aan \'n gebruikernaam wat gebruik word om toegang tot die hulpmiddel te magtig. Dit kan deur die hulpmiddelverskaffer gebruik word om die Moodle-webwerf vanwaar die gebruiker die hulpmiddel laai op ŉ unieke wyse te identifiseer.

Die gebruikersleutel moet deur die hulpbronverskaffer verskaf word. Die metode waarvolgens ŉ verbruikersleutel bekom word, varieer van verskaffer tot verskaffer. Dit kan ŉ geoutomatiseerde proses wees, of dit kan verg dat daar ŉ dialoog met die hulpmiddelverskaffer gevoer word.

Hulpmiddels wat nie beveiligde kommunikasie vanaf Moodle verlang nie en nie addisionele dienste (soos verslagdoening oor punte) bied nie, kan dalk nie \'n hulpmiddelsleutel verlang nie.';
$string['resourceurl'] = 'Hulpbron-URL';
$string['return_to_course'] = 'Klik <a href="{$a->link}" target="_top">here</a> om terug te gaan na die kursus.';
$string['saveallfeedback'] = 'Stoor al my terugvoer';
$string['search:activity'] = 'Eksterne hulpmiddel - aktiwiteitsinligting';
$string['secure_icon_url'] = '"Beveiligde ikoon"-URL';
$string['secure_icon_url_help'] = 'Soortgelyk aan die ikoon-URL maar word gebruik wanneer daar op \'n veilige wyse via SSL toegang tot die webwerf bekom word. Hierdie veld het ten doel om te verhoed dat die blaaier \'n waarskuwing oor \'n onbeveiligde beeld wys.';
$string['secure_launch_url'] = '"Beveiligde hulpmiddel"-URL';
$string['secure_launch_url_help'] = 'Soortgelyk aan die hulpmiddel-URL maar word in plaas van die hulpmiddel-URL gebruik as \'n hoë mate van sekuriteit verlang word. Moodle sal die "beveiligde hulpmiddel"-URL in plaas van die hulpmiddel-URL gebruik as toegang tot die Moodle-webwerf via SSL verkry word, of as die hulpmiddel só gekonfigureer is dat dit altyd via SSL moet laai.

Die hulpmiddel-URL kan ook as \'n https-adres gestel word om laai via SSL te forseer, in welke geval hierdie veld leeg gelaat kan word.';
$string['selectcontent'] = 'Kies inhoud';
$string['send'] = 'Stuur';
$string['services'] = 'Dienste';
$string['services_help'] = 'Kies daardie dienste wat jy aan die hulpmiddelverskaffer wil bied. Meer as een diens kan gekies word.';
$string['setupoptions'] = 'Opstellingsopsies';
$string['share_email'] = 'Deel laaier se e-pos met die hulpmiddel';
$string['share_email_admin'] = 'Deel laaier se e-pos met hulpmiddel';
$string['share_email_admin_help'] = 'Spesifiseer of die e-posadres van die gebruiker wat die hulpmiddel laai met die verskaffer van die hulpmiddel gedeel word.
Die verskaffer van die hulpmiddel het dalk laaiers se e-posadresse nodig sodat daar tussen gebruikers met dieselfde naam in die UI onderskei kan word, of om e-posse gegrond op aksies binne die hulpmiddel te versend.';
$string['share_email_help'] = 'Spesifiseer of die e-posadres van die gebruiker wat die hulpmiddel laai met die verskaffer van die hulpmiddel gedeel word.

Die verskaffer van die hulpmiddel het dalk laaiers se e-posadresse nodig sodat daar tussen gebruikers met dieselfde naam in die UI onderskei kan word, of om e-posse gegrond op aksies binne die hulpmiddel te versend.

Let daarop dat hierdie instelling in die hulpmiddel se konfigurasie oorheers kan word.';
$string['share_name'] = 'Deel laaier se naam met die hulpmiddel';
$string['share_name_admin'] = 'Deel laaier se naam met hulpmiddel';
$string['share_name_admin_help'] = 'Spesifiseer of die volle naam van die gebruiker wat die hulpmiddel laai met die verskaffer van die hulpmiddel gedeel word.
Die verskaffer van die hulpmiddel het dalk laaiers se name nodig sodat sinvolle inligting binne die hulpmiddel gewys kan word.';
$string['share_name_help'] = 'Spesifiseer of die volle naam van die gebruiker wat die hulpmiddel laai met die verskaffer van die hulpmiddel gedeel word.

Die verskaffer van die hulpmiddel het dalk laaiers se name nodig sodat sinvolle inligting binne die hulpmiddel gewys kan word.

Let daarop dat hierdie instelling in die hulpmiddel se konfigurasie oorheers kan word.';
$string['share_roster'] = 'Laat die hulpmiddel toe om toegang tot die kursus se rooster te verkry';
$string['share_roster_admin'] = 'Hulpmiddel kan toegang tot kursusrooster verkry';
$string['share_roster_admin_help'] = 'Spesifiseer of die hulpmiddel toegang kan verkry tot die lys van gebruikers wat ingeskryf is vir kursusse vanwaar hierdie hulpmiddel gelaai word.';
$string['share_roster_help'] = 'Spesifiseer of die hulpmiddel toegang kan verkry tot die lys van gebruikers wat vir hierdie kursus ingeskryf is.

Let daarop dat hierdie instelling in die hulpmiddel se konfigurasie oorheers kan word.';
$string['show_in_course_activity_chooser'] = 'Wys in aktiwiteitskieslys en as \'n hulpmiddel wat vooraf gekonfigureer is';
$string['show_in_course_lti1'] = 'Gebruik van hulpmiddelkonfigurasie';
$string['show_in_course_lti1_help'] = 'Hierdie hulpmiddel kan in die aktiwiteitskieslys gewys word sodat ŉ onderwyser kan kies om dit by ŉ kursus te voeg. So nie kan dit in die aftrekkieslys vir voorafgekonfigureerde hulpmiddels gewys word wanneer ŉ eksterne hulpmiddel by die kursus gevoeg word. Nog ŉ opsie is om hulpmiddelkonfigurasie slegs te gebruik wanneer die presiese hulpmiddel-URL ingetik word wanneer ŉ eksterne hulpmiddel by ŉ kursus gevoeg word.';
$string['show_in_course_lti2'] = 'Gebruik van hulpmiddelkonfigurasie';
$string['show_in_course_lti2_help'] = 'Hierdie hulpmiddel kan in die aktiwiteitskieslys gewys word sodat ŉ onderwyser kan kies om dit by ŉ kursus te voeg of in die aftrekkieslys vir voorafgekonfigureerde hulpmiddels wanneer ŉ eksterne hulpmiddel by die kursus gevoeg word.';
$string['show_in_course_no'] = 'Moenie wys nie; gebruik slegs wanneer ooreenstemmende hulpmiddel-URL nie ingetik is nie';
$string['show_in_course_preconfigured'] = 'Wys voorafgekonfigureerde hulpmiddel wanneer \'n eksterne hulpmiddel bygevoeg word';
$string['sitehost'] = 'Webwerf se gasheernaam';
$string['siteid'] = 'Webwerf-ID';
$string['size'] = 'Grootteparameters';
$string['submission'] = 'Indiening';
$string['submissions'] = 'Indienings';
$string['submissionsfor'] = 'Indienings vir {$a}';
$string['subplugintype_ltiresource'] = 'LTI-dienshulpbron';
$string['subplugintype_ltiresource_plural'] = 'LTI-dienshulpbronne';
$string['subplugintype_ltiservice'] = 'LTI-diens';
$string['subplugintype_ltiservice_plural'] = 'LTI-dienste';
$string['subplugintype_ltisource'] = 'LTI-bron';
$string['subplugintype_ltisource_plural'] = 'LTI-bronne';
$string['successfullycreatedtooltype'] = 'Nuwe hulpmiddel suksesvol geskep!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Hulpmiddelkonfigurasie suksesvol gehaal van geselekteerde inhoud.';
$string['toggle_debug_data'] = 'Skakel ontfoutingsdata aan/af';
$string['tool_config_not_found'] = 'Hulpmiddelkonfigurasie nie vir hierdie URL gevind nie.';
$string['tool_settings'] = 'Hulpmiddelinstellings';
$string['tooldescription'] = 'Hulpmiddelbeskrywing';
$string['tooldescription_help'] = 'Die beskrywing van die hulpmiddel wat in die aktiwiteitslys aan onderwysers gewys word.

Dit moet beskryf waarvoor die hulpmiddel bedoel is en wat dit doen, en enige addisionele inligting verskaf waarvan die onderwyser kennis moet neem.';
$string['tooldetailsaccesstokenurl'] = 'Toegangsbewys-URL';
$string['tooldetailsauthrequesturl'] = 'Magtigingsversoek-URL';
$string['tooldetailsclientid'] = 'Kliënt-ID';
$string['tooldetailsdeploymentid'] = 'Ontplooiings-ID';
$string['tooldetailsmailtosubject'] = 'Konfigurasie van LTI-hulpmiddel';
$string['tooldetailsmodalemail'] = 'E-pos';
$string['tooldetailsmodallink'] = 'Bekyk konfigurasiedetails';
$string['tooldetailsmodaltitle'] = 'Hulpmiddel se konfigurasiedetail';
$string['tooldetailsplatformid'] = 'Platform-ID';
$string['tooldetailspublickeyseturl'] = 'Openbare keySet-URL';
$string['toolisbeingused'] = 'Hierdie hulpmiddel word {$a} keer gebruik';
$string['toolisnotbeingused'] = 'Hierdie hulpmiddel is nog nie gebruik nie';
$string['toolproxy'] = 'Registrasie van eksterne hulpmiddels';
$string['toolproxy_help'] = 'Eksternehulpmiddelregistrasies maak dit vir Moodle-webwerfadministrateurs moontlik om eksterne hulpmiddels te konfigureer komende van ŉ hulpmiddelinstaanbediener wat deur ŉ hulpmiddelverskaffer voorsien word en wat LTI 2.0 ondersteun. ŉ Registrasie-URL wat deur die hulpmiddelverskaffer voorsien word, is al wat benodig word om die proses te inisieer. Die vermoëns van en dienste wat deur die hulmiddelverskaffer gebied word, word geselekteer wanneer ŉ nuwe registrasie gekonfigureer word.

Hulpmiddelregistrasies gelys op hierdie blad word in vier kategorieë geskei:

* **Gekonfigureer** - Hierdie hulpmiddelregistrasies is opgestel, maar die registrasieproses het nog nie begin nie.
* **Afwagtend** - Die registrasieproses vir hierdie hulpmiddelregistrasies is begin maar is nog nie voltooi nie. Maak die instellings oop en stoor hulle om die status terug te stel op “Gekonfigureer”.
* **Aanvaar** - Hierdie hulpmiddelregistrasies is goedgekeur; die hulpbronne gespesifiseer in die hulpmiddelinstaanbediener sal op die voorafgekonfigureerde hulpmiddelblad verskyn met ŉ aanvanklike status van “Afwagtend”.
* **Afgekeur** - Hierdie hulpmiddelregistrasies is daardie wat tydens die registrasieproses afgekeur is. Maak die instellings oop en stoor hulle om die status terug te stel op “Gekonfigureer” sodat die registrasieproses herbegin kan word.';
$string['toolproxyregistration'] = 'Registrasie van eksterne hulpmiddels';
$string['toolregistration'] = 'Registrasie van eksterne hulpmiddels';
$string['toolsetup'] = 'Konfigurasie van eksterne hulpmiddels';
$string['tooltypeadded'] = 'Voorafgekonfigureerde hulpmiddel bygevoeg';
$string['tooltypedeleted'] = 'Voorafgekonfigureerde hulpmiddel geskrap';
$string['tooltypenotdeleted'] = 'Kon nie voorafgekonfigureerde hulpmiddel skrap nie';
$string['tooltypes'] = 'Hulpmiddels';
$string['tooltypeupdated'] = 'Voorafgekonfigureerde hulpmiddel bygewerk';
$string['toolurl'] = 'Hulpmiddel-URL';
$string['toolurl_contentitemselectionrequest'] = 'Inhoudseleksie-URL';
$string['toolurl_contentitemselectionrequest_help'] = 'Die inhoudseleksie-URL sal gebruik word om die inhoudseleksieblad vanaf die hulpmiddelverskaffer te laai. As dit leeg is, sal die hulpmiddel-URL gebruik word.';
$string['toolurl_help'] = 'Die hulpmiddel-URL word gebruik om hulpmiddel-URL’e by die korrekte hulpmiddelkonfigurasie te pas. Gebruik van die prefiks http(s) saam met die URL is opsioneel.

Voorts word die basis-URL as die hulpmiddel-URL gebruik as ŉ hulpmiddel-URL nie in die eksterne hulpmiddeleksemplaar gespesifiseer word nie.

Byvoorbeeld, ŉ basis-URL genaamd *tool.com* sal by die volgende pas:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

ŉ Basis-URL genaamd *www.tool.com/quizzes* sal by die volgende pas:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

ŉ Basis-URL genaamd *quiz.tool.com* sal by die volgende pas:
* quiz.tool.com
* quiz.tool.com/take.php?id=10

As twee verskillende hulpmiddelkonfigurasies vir dieselfde domein is, sal die een wat die beste pas gebruik word.

Jy kan ook ŉ ladings-URL intik as jy een het, en die details vir die hulpmiddel sal outomaties ingevul word.';
$string['toolurlplaceholder'] = 'Hulpmiddel-URL...';
$string['typename'] = 'Hulpmiddelnaam';
$string['typename_help'] = 'Die hulpmiddelnaam word gebruik om die hulpmiddelverskaffer binne Moodle te identifiseer. Onderwysers sal die naam wat ingetik is, kan sien wanneer hulle eksterne hulpmiddels binne kursusse byvoeg.';
$string['types'] = 'Tipes';
$string['unabletocreatetooltype'] = 'Kon nie hulpmiddel skep nie';
$string['unabletofindtooltype'] = 'Kon nie hulpmiddel vir {$a->id} vind nie';
$string['unknownstate'] = 'Onbekende status';
$string['update'] = 'Werk by';
$string['useraccountinformation'] = 'Inligting oor gebruikerrekening';
$string['userpersonalinformation'] = 'Gebruiker se persoonlike inligting';
$string['using_tool_cartridge'] = 'Gebruik van hulpmiddellading';
$string['using_tool_configuration'] = 'Gebruik hulpmiddelkonfigurasie:';
$string['validurl'] = '\'n Geldige URL moet begin met  http(s)://';
$string['viewsubmissions'] = 'Bekyk indiening- en bepuntingskerm';
