<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'af', version '4.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Opdrag aktiwiteit aanhangsels';
$string['activitydate:submissionsdue'] = 'Keerdatum:';
$string['activitydate:submissionsopen'] = 'Maak oop:';
$string['activitydate:submissionsopened'] = 'Geopen';
$string['activityeditor'] = 'Aktiwiteit instruksies';
$string['activityeditor_help'] = 'Die aksies wat u wil hê die student vir hierdie opdrag moet voltooi. Dit word slegs op die indieningsblad gewys waar \'n student hul opdrag redigeer en indien.';
$string['activityoverview'] = 'Jy het opdragte wat jou aandag benodig';
$string['addattempt'] = 'Laat nog \'n poging toe';
$string['addnewattempt'] = 'Voeg nog \'n poging by';
$string['addnewattempt_help'] = 'Hierdie skep \'n skoon weergawe vir jou om verder op te werk.';
$string['addnewattemptfromprevious'] = 'Laat nog \'n poging toe op grond van \'n vorige indiening';
$string['addnewattemptfromprevious_help'] = 'Hierdie sal die inhoud van jou vorige indiening in \'n nuwe weergawe gekopieër word, sodat jy verder kan werk hierop.';
$string['addnewgroupoverride'] = 'Voeg \'n groep uitsondering by';
$string['addnewuseroverride'] = 'Voeg gebruiker uitsondering by';
$string['addsubmission'] = 'Voeg \'n indiening by';
$string['addsubmission_help'] = 'Jy het nog nie iets ingehandig nie';
$string['allocatedmarker'] = 'Toegekende merker';
$string['allocatedmarker_help'] = 'Merker wat toegeken is aan hierdie indiening';
$string['allowsubmissions'] = 'Laat die gebruiker toe om voort te gaan met die indiening van hierdie opdrag.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Die opdrag besonderhede en inhandigingsvorm sal beskikbaar wees vanaf <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Laat inhandiging toe vanaf';
$string['allowsubmissionsfromdate_help'] = 'Indien dit geaktiveer is kan studente nie voor hierdie datum indien nie. Indien dit nie geaktiveer is nie kan studente dadelik begin indien.';
$string['allowsubmissionsfromdatesummary'] = 'Hierdie opdrag sal inhandigings aanvaar vanaf <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Laat veranderinge aan inhandigings toe';
$string['alwaysshowdescription'] = 'Wys altyd beskrywing';
$string['alwaysshowdescription_help'] = 'As dit gedeaktiveer is sal die werkopdragbeskrywing hierbo slegs vir studente sigbaar word op die \'Laat indienings vanaf\' datums toe.';
$string['applytoteam'] = 'Pas punte en terugvoering op die hele groep toe';
$string['assign:addinstance'] = 'Voeg \'n nuwe opdrag by';
$string['assign:editothersubmission'] = 'Redigeer \'n ander student se indiening';
$string['assign:exportownsubmission'] = 'Laai eie inhandiging af';
$string['assign:grade'] = 'Merk opdrag';
$string['assign:grantextension'] = 'Vergun uitstel';
$string['assign:manageallocations'] = 'Bestuur toegekende merkers vir hierdie indiening';
$string['assign:managegrades'] = 'Hersien en stel punte vry';
$string['assign:manageoverrides'] = 'Bestuur opdrag uitsonderings';
$string['assign:receivegradernotifications'] = 'Ontvang kennisgewings van inhandigings';
$string['assign:releasegrades'] = 'Stel punte vry';
$string['assign:revealidentities'] = 'Onthul studente se identiteit';
$string['assign:reviewgrades'] = 'Hersien punte';
$string['assign:showhiddengrader'] = 'Sien die identiteit van \'n versteekte merker';
$string['assign:submit'] = 'Indieningstoevoeging';
$string['assign:view'] = 'Beskou opdrag';
$string['assign:viewblinddetails'] = 'Bekyk studente se identiteit wanneer anonieme indienings geaktiveer is';
$string['assign:viewgrades'] = 'Sien punte';
$string['assign:viewownsubmissionsummary'] = 'Bekyk opsomming van eie indiening';
$string['assignfeedback'] = 'Terugvoer uitbreiding';
$string['assignfeedbackpluginname'] = 'Terugvoer uitbreiding';
$string['assignmentisdue'] = 'Opdrag is verskuldig';
$string['assignmentmail'] = '{$a->grader} het terugvoer vir jou opdrag \'{$a->assignment}\' gegee

Die terugvoer word aangeheg by jou ingehandigde opdrag:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} het terugvoer vir jou opdrag \'<i>{$a->assignment}</i>\' gegee.<p>
<p>Die terugvoer word aangeheg by jou ingehandigde opdrag <a href="{$a->url}">assignment submission</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} het terugvoer vir jou opdrag \'{$a->assignment}\' gegee. Die terugvoer word aangeheg saam met jou ingehandigde opdrag.';
$string['assignmentname'] = 'Opdrag naam';
$string['assignmentplugins'] = 'Opdrag uitbreiding';
$string['assignmentsperpage'] = 'Opdragte per bladsy';
$string['assignsubmission'] = 'Indiening uitbreiding';
$string['assignsubmissionpluginname'] = 'Indiening uitbreiding';
$string['assigntimeleft'] = 'Tyd oor';
$string['attemptheading'] = 'Poging {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Vorige pogings';
$string['attemptnumber'] = 'Poging nommer';
$string['attemptreopenmethod'] = 'Addisionele pogings';
$string['attemptreopenmethod_help'] = 'Hierdie instelling bepaal of \'n student addisionele probeerslae vir die opdrag kan aanwend. Die punt en terugvoer word vir elke poging gestoor en kan deur die onderwyser en student bekyk word. Die beskikbare opsies is:

* Nooit - slegs een poging is moontlik.
* Handmatig - addisionele pogings kan deur \'n onderwyser toegelaat word.
* Outomaties totdat slaag - Addisionele pogings word outomaties toegelaat totdat die student die slaagpunt behaal het wat vir hierdie opdrag in die punteboek vasgestel is.';
$string['attemptreopenmethod_manual'] = 'Handmatig';
$string['attemptreopenmethod_none'] = 'Nooit';
$string['attemptreopenmethod_untilpass'] = 'Outomaties totdat slaag';
$string['attemptsettings'] = 'Poging verstellings';
$string['availability'] = 'Beskikbaarheid';
$string['back'] = 'Terug';
$string['backtoassignment'] = 'Terug na opdrag';
$string['batchoperationconfirmaddattempt'] = 'Moet daar nog \'n poging toegelaat word vir die geselekteerde indienings?';
$string['batchoperationconfirmdownloadselected'] = 'Laai geselekteerde indienings af?';
$string['batchoperationconfirmgrantextension'] = 'Vergun \'n verlenging vir al die geselekteerde indienings?';
$string['batchoperationconfirmlock'] = 'Sluit alle geselekteerde indienings?';
$string['batchoperationconfirmremovesubmission'] = 'Verwyder geselekteerde indienings?';
$string['batchoperationconfirmreverttodraft'] = 'Stel die geselekteerde indienings terug tot \'n konsep?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Stel toegewyde merker vir alle geselekteerde indienings?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Stel die werkstroomtoestand vir alle geselekteerde indienings in?';
$string['batchoperationconfirmunlock'] = 'Ontsluit alle geselekteerde indienings?';
$string['batchoperationlock'] = 'sluit indiening';
$string['batchoperationreverttodraft'] = 'stel indienings tot \'n konsep terug';
$string['batchoperationsdescription'] = 'Met geselekteerde...';
$string['batchoperationunlock'] = 'ontsluit indienings';
$string['batchsetallocatedmarker'] = 'Stel geallokeerde merker vir {$a} verkose gebruiker(s).';
$string['batchsetmarkingworkflowstateforusers'] = 'Stel werkstroomtoestand vir {$a} verkose gebruiker(s).';
$string['beginassignment'] = 'Begin opdrag';
$string['blindmarking'] = 'Anonieme indienings';
$string['blindmarking_help'] = 'Anonieme indienings verberg die identiteit van studente vir nasieners. Instellings vir anonieme indienings word gesluit sodra \'n inhandiging gedoen is of \'n punt met betrekking tot hierdie opdrag toegeken is.';
$string['blindmarkingenabledwarning'] = 'Anonieme indienings is vir hierdie aktiwiteit geaktiveer. Punte sal nie by die punteboek gevoeg word alvorens die student se identiteit via die aksiekieslys vir bepunting onthul is nie.';
$string['cachedef_overrides'] = 'Inligting oor gebruiker- en groepoorheersing';
$string['calendardue'] = '{$a} is uitstaande';
$string['calendargradingdue'] = '{$a} is gereed om gemerk te word';
$string['caneditsubmission'] = 'Jy kan jou indiening wysig en indien nadat die tydsbeperking verstryk het, maar dit sal as laat gemerk word.';
$string['changefilters'] = 'Verander die filters';
$string['changeuser'] = 'Verander gebruiker';
$string['choosegradingaction'] = 'Merk aksie';
$string['choosemarker'] = 'Kies...';
$string['chooseoperation'] = 'Kies aksie';
$string['clickexpandreviewpanel'] = 'Kliek om hersienpaneel uit te brei';
$string['collapsegradepanel'] = 'Laat puntepaneel invou';
$string['collapsereviewpanel'] = 'Laat hersieningspaneel invou';
$string['comment'] = 'Kommentaar';
$string['completiondetail:submit'] = 'Doen \'n indiening';
$string['completionsubmit'] = 'Student moet \'n inhandiging doen';
$string['configshowrecentsubmissions'] = 'Almal kan kennisgewings van inhandigings in onlangse aktiwiteitsverslae sien.';
$string['confirmbatchgradingoperation'] = 'Is jy seker jy wil {$a->operation} vir {$a->count} studente?';
$string['confirmstart'] = 'y het {$a} om hierdie opdrag te voltooi. Wanneer jy begin, sal die tydteller begin aftel en kan dit nie onderbreek word nie.';
$string['confirmsubmission'] = 'Is jy seker jy wil jou werk indien om gemerk te word? Jy sal geen verdere veranderings kan maak nie.';
$string['confirmsubmissionheading'] = 'Bevestig inhandiging';
$string['conversionexception'] = 'Kon nie opdrag omskakel nie. Foutboodskap: {$a}.';
$string['couldnotconvertgrade'] = 'Kon nie opdrag se punt omskakel vir gebruiker {$a} nie.';
$string['couldnotconvertsubmission'] = 'Kon nie opdrag inhandiging omskakel vir gebruiker {$a} nie.';
$string['couldnotcreatecoursemodule'] = 'Kon nie kursus module skep nie.';
$string['couldnotcreatenewassignmentinstance'] = 'Kon nie \'n nuwe opdrag skep nie.';
$string['couldnotfindassignmenttoupgrade'] = 'Kon nie \'n ou tipe opdrag vind om op by te werk nie.';
$string['crontask'] = 'Agtergrondprosessering vir opdragmodule';
$string['currentassigngrade'] = 'Teenwoordige opdragpunt';
$string['currentattempt'] = 'Hierdie is poging nommer {$a}.';
$string['currentattemptof'] = 'Hierdie is poging {$a->attemptnumber} ( {$a->maxattempts} pogings word toegelaat ).';
$string['currentgrade'] = 'Huidige punt in die punteboek';
$string['cutoffdate'] = 'Afsny datum';
$string['cutoffdate_help'] = 'Indien verstel, sal die opdrag nie inhandigings na hierdie datum aanvaar sonder \'n verlenging nie.';
$string['cutoffdatecolon'] = 'Sperdatum: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Sperdatum kan nie vroeër wees as die laat opdragte vanaf datum nie.';
$string['cutoffdatevalidation'] = 'Sperdatum kan nie vroeër wees as die verwagte datum nie.';
$string['defaultlayout'] = 'Herstel verstekuitleg';
$string['defaultsettings'] = 'Verstekopdraginstellings';
$string['defaultsettings_help'] = 'Hierdie instellings bepaal die standaardinstellings vir nuwe opdragte';
$string['defaultteam'] = 'Verstek groep';
$string['deleteallsubmissions'] = 'Vee all inhandigings uit';
$string['description'] = 'Beskrywing';
$string['disabled'] = 'Deaktiveer';
$string['downloadall'] = 'Laai alle inhandigings af';
$string['downloadasfolders'] = 'Laai alle inhandigings in leêrs af';
$string['downloadasfolders_help'] = 'Opdragte kan in lêers opgelaai word. Hierna word elke inhandiging in \'n aparte lêer geplaas met \'n die lêerstruktuur van sublêers en lêers word nie herbenoem nie.';
$string['downloadselectedsubmissions'] = 'Laai verkose inhandigings af';
$string['duedate'] = 'Sperdatum';
$string['duedate_help'] = 'Dit is wanneer die opdrag ingehandig moet word. Inhandigings sal steeds na hierdie datum toegelaat word, maar alle opdragte wat na hierdie datum ingedien word, sal as laat gemerk word. Stel \'n afsnydatum van die opdrag in om voorleggings na \'n sekere datum te voorkom.';
$string['duedatecolon'] = 'Sperdatum: {$a}';
$string['duedatereached'] = 'Die sperdatum vir hierdie opdra is reeds verby';
$string['duedatevalidation'] = 'Sperdatum kan nie vroeër wees as die laat inhandings vanaf tyd nie';
$string['duplicateoverride'] = 'Dupliseer oorskryding';
$string['editaction'] = 'Aksies...';
$string['editattemptfeedback'] = 'Redigeer die punt en terugvoer vir poging nommer {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Jy is besig om die terugvoer van \'n vorige poging te redigeer. Hierdie is poging {$a->attemptnumber} van {$a->totalattempts}.';
$string['editingstatus'] = 'Status van redigering';
$string['editonline'] = 'Redigeer aanlyn';
$string['editoverride'] = 'Redigeer oorskryding';
$string['editsubmission'] = 'Verander inhandiging';
$string['editsubmission_help'] = 'Jy kan steeds veranderinge aan jou inhandiging maak';
$string['editsubmissionother'] = 'Redigeer inhandiging vir {$a}';
$string['enabled'] = 'Aktiveer';
$string['enabletimelimit'] = 'Aktiveer tydige opdragte';
$string['enabletimelimit_help'] = 'As dit geaktiveer is, kan u \'n tydsbeperking op die bladsy met opdraginstellings instel.';
$string['errornosubmissions'] = 'Daar is geen inhandigings om af te laai nie';
$string['errorquickgradingvsadvancedgrading'] = 'Die uitslae was nie gestoor nie, omdat die opdrag tans van gevorderde bepunting gebruik maak';
$string['errorrecordmodified'] = 'Die grade is nie gestoor nie omdat iemand onlangs een of meer rekords verander het as toe u die bladsy gelaai het.';
$string['eventallsubmissionsdownloaded'] = 'Alle inhandigings is besig om afgelaai te word.';
$string['eventassessablesubmitted'] = '\'n Inhandiging is ingedien.';
$string['eventbatchsetmarkerallocationviewed'] = 'Groepmerkerinstelling besigtig';
$string['eventbatchsetworkflowstateviewed'] = 'Groep werkstroomtoevoerstatus besigtig.';
$string['eventextensiongranted'] = 'Uitstel is vergun';
$string['eventfeedbackupdated'] = 'Terugvoer is opdateer';
$string['eventfeedbackviewed'] = 'Terugvoer beskou';
$string['eventgradingformviewed'] = 'Merkvorm beskou';
$string['eventgradingtableviewed'] = 'Merktabel beskou';
$string['eventidentitiesrevealed'] = 'Die identiteite is bekend gemaak.';
$string['eventmarkerupdated'] = 'Die geallokeerde merker is opdateer.';
$string['eventoverridecreated'] = 'Opdragoorskryding is geskep';
$string['eventoverridedeleted'] = 'Opdragoorskryding is uitgevee';
$string['eventoverrideupdated'] = 'Opdragoorskryding is opdateer';
$string['eventremovesubmissionformviewed'] = 'Vee opdragbevestiging beskou uit.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Vertoon identiteit bevestiging bladsy beskou.';
$string['eventstatementaccepted'] = 'Die gebruiker het die kennisgewing van die inhandiging aanvaar.';
$string['eventsubmissionconfirmationformviewed'] = 'Inhandiging bevestigingvorm beskou.';
$string['eventsubmissioncreated'] = 'Inhandiging geskep.';
$string['eventsubmissionduplicated'] = 'Die gebruiker het hul inhandiging gedupliseer.';
$string['eventsubmissionformviewed'] = 'Inhandigingsvorm is beskou';
$string['eventsubmissiongraded'] = 'Inhandiging is gemerk.';
$string['eventsubmissionlocked'] = 'Die inhandigings is gesluit vir \'n gebruiker.';
$string['eventsubmissionstatusupdated'] = 'Die inhandigingstatus is opdateer.';
$string['eventsubmissionstatusviewed'] = 'Die inhandigingstatus is beskou.';
$string['eventsubmissionunlocked'] = 'Inhandigings is ontsluit vir \'n gebruiker.';
$string['eventsubmissionupdated'] = 'Inhandiging opdateer';
$string['eventsubmissionviewed'] = 'Inhandiging beskou.';
$string['eventworkflowstateupdated'] = 'Die werkstroomstatus is opdateer.';
$string['expandreviewpanel'] = 'Brei hersieningspaneel uit';
$string['extensionduedate'] = 'Verlengde sperdatum';
$string['extensionnotafterduedate'] = 'Uitsteldatum moet na sperdatum wees';
$string['extensionnotafterfromdate'] = 'Uitsteldatum moet na die laat inhandigings vanaf datum wees';
$string['feedback'] = 'Terugvoer';
$string['feedbackavailableanonhtml'] = 'Jy het nuwe terugvoer vir jou
opdraginhandiging vir \'<i>{$a->assignment}</i>\'<br /><br />
Jy kan dit aan jou <a href="{$a->url}">assignment submission</a> aangeheg vind.';
$string['feedbackavailableanonsmall'] = 'Nuwe terugvoer vir opdrag {$a->assignment}';
$string['feedbackavailableanontext'] = 'Jy het nuwe terugvoer vir jou
opdraginhandiging vir \'{$a->assignment}\'

Jy kan dit aan jou opdraginhandiging aangeheg vind

    {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} het terugvoer gegee op jou
opdraginhandiging vir \'<i>{$a->assignment}</i>\'<br /><br />
Jy kan dit aangeheg vind aan jou <a href="{$a->url}">assignment submission</a>.';
$string['feedbackavailablesmall'] = '{$a->username} het terugvoer gegee vir opdrag {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} het terugvoer gegee op jou
opdrag inhandiging vir \'{$a->assignment}\'

Jy kan dit aangeheg vind aan jou opdrag inhandiging:

    {$a->url}';
$string['feedbackplugin'] = 'Terugvoer inprop';
$string['feedbackpluginforgradebook'] = 'Terugvoer inprop wat kommentaar na punteboek stoot';
$string['feedbackpluginforgradebook_help'] = 'Slegs een opdrag terugvoer inprop kan terugvoer na die punteboek stoot';
$string['feedbackplugins'] = 'Terugvoer inprop';
$string['feedbacksettings'] = 'Terugvoer instellings';
$string['feedbacktypes'] = 'Terugvoer tipes';
$string['filesubmissions'] = 'Lêer inhandiging';
$string['filter'] = 'Filter';
$string['filterdraft'] = 'Konsep';
$string['filtergrantedextension'] = 'Uitstel vergun';
$string['filternone'] = 'Geen filter';
$string['filternotsubmitted'] = 'Geen inhandiging';
$string['filterrequiregrading'] = 'Vereis bepunting';
$string['filtersubmitted'] = 'Ingehandig';
$string['fixrescalednullgrades'] = 'Hierdie opdrag bevat foutiewe punte. Jy kan <a href="{$a->link}">hierdie punte outomaties regmaak</a>. Dit kan kursustotale beïnvloed.';
$string['fixrescalednullgradesconfirm'] = 'Is jy seker jy wil foutiewe punte regmaak? Alle affekteerde punte sal verwyder word. Dit kan kursustotale beïnvloed.';
$string['fixrescalednullgradesdone'] = 'Punte reggestel';
$string['gradeabovemaximum'] = 'Punte moet minder of gelyk aan {$a} wees.';
$string['gradebelowzero'] = 'Punte moet groter as of gelyk aan nul wees.';
$string['gradecanbechanged'] = 'Punt kan verander word';
$string['gradechangessaveddetail'] = 'Die veranderinge aan die punt en terugvoer is gestoor';
$string['graded'] = 'Nagesien';
$string['gradedby'] = 'Nagesien deur';
$string['gradedfollowupsubmit'] = 'Bepunt - opvolgindiening ontvang';
$string['gradedon'] = 'Nagesien op';
$string['gradeitem:submissions'] = 'Inhandigings';
$string['gradelocked'] = 'Hierdie punt is gesluit of oorskryf in die punteboek.';
$string['gradeoutof'] = 'Punt uit {$a}';
$string['gradeoutofhelp'] = 'Punt';
$string['gradeoutofhelp_help'] = 'Voer die punt vir die student se inhandiging hier in. Jy kan desimale insluit.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} het hul opdrag inhandiging opdateer
vir <i>\'{$a->assignment}\' teen {$a->timeupdated}</i><br /><br />
Dit is <a href="{$a->url}">beskikbaar op die webblad</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} het hul inhandiging vir opdrag {$a->assignment} opdateer.';
$string['gradersubmissionupdatedtext'] = '{$a->username} het hul opdrag inhandiging opdateer
vir \'{$a->assignment}\' teen {$a->timeupdated}

Dit is hier beskikbaar:

    {$a->url}';
$string['gradestudent'] = 'Merk student: (id={$a->id}, van={$a->fullname}).';
$string['gradeuser'] = 'Punt {$a}';
$string['grading'] = 'Merk';
$string['gradingchangessaved'] = 'Die puntveranderinge is gestoor';
$string['gradingduedate'] = 'Herinner my om te merk teen';
$string['gradingduedate_help'] = 'Die verwagte datum waarop die indiening van die voorleggings moet voltooi word. Hierdie datum word gebruik om paneelbordkennisgewings vir onderwysers te prioritiseer.';
$string['gradingdueduedatevalidation'] = 'Herinner my om te merk teen \'n bepaalde datum kan die vroeër as die sperdatum wees nie.';
$string['gradingduefromdatevalidation'] = 'Herinner my om te merk teen \'n bepaalde datum kan die vroeër as laat inhandigings toe vanaf wees nie.';
$string['gradingmethodpreview'] = 'Bepuntings kriteria';
$string['gradingoptions'] = 'Opsies';
$string['gradingstatus'] = 'Nasien status';
$string['gradingstudent'] = 'Merk student';
$string['gradingsummary'] = 'Nasien opsomming';
$string['grantextension'] = 'Vergun uitstel';
$string['grantextensionforusers'] = 'Vergun uitstel vir {$a} studente';
$string['groupoverrides'] = 'Groep oorskryding';
$string['groupoverridesdeleted'] = 'Groep oorskryding uitgevee';
$string['groupsnone'] = 'Gee groepe waartoe jy toegang het nie.';
$string['groupsubmissionsettings'] = 'Instellings vir groep inhandiging';
$string['hiddenuser'] = 'Deelnemer';
$string['hidegrader'] = 'Versteek merkeridentiteit van studente';
$string['hidegrader_help'] = 'Indien geaktiveer, word identiteit van gebruiker wat \'n werkopdrag beoordeel versteek, sodat studente nie kan sien wie hul werk gemerk het nie. Let daarop dat hierdie instelling geen invloed het op die opmerkingsblokkie op die merkbladsy nie.';
$string['hideshow'] = 'Versteek/Wys';
$string['inactiveoverridehelp'] = 'Hierdie oorskryding is onaktief omdat die gebruiker se toegang tot die aktiwiteit beperk is. Dit kan te wyte wees aan groep- of roltoewysings, ander toegangsbeperkings of die verborge aktiwiteit.';
$string['indicator:cognitivedepth'] = 'Kognitiewe opdrag';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gebaseer op die kognitiewe diepte wat die student in \'n opdrag bereik het.';
$string['indicator:cognitivedepthdef'] = 'Kognitiewe opdrag';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het hierdie persentasie bereik van die kognitiewe betrokkenheid wat deur die Opdrag-aktiwiteite aangebied word gedurende hierdie ontledingsinterval (Vlakke = Geen aansig, Kyk, Stuur, Bekyk terugvoering, lewer kommentaar op terugvoer, dien weer in nadat hy terugvoer gekyk het)';
$string['indicator:socialbreadth'] = 'Sosiale opdrag';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gebaseer op die sosiale breedte wat die student tydens \'n aktiwiteit bereik.';
$string['indicator:socialbreadthdef'] = 'Sosiale opdrag';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het hierdie persentasie bereik van die sosiale betrokkenheid wat deur die Opdrag-aktiwiteite aangebied word gedurende hierdie ontledingsinterval (Vlakke = Geen deelname, Deelnemer alleen, Deelnemer saam met ander)';
$string['instructionfiles'] = 'Instruksielêers';
$string['introattachments'] = 'Ekstra lêers';
$string['introattachments_help'] = 'Bykomende lêers vir gebruik in die opdrag, soos antwoordsjablone, kan bygevoeg word.';
$string['invalidfloatforgrade'] = 'Die gegewe punt is onverstaanbaar: {$a}';
$string['invalidgradeforscale'] = 'Die gegewe punt is ongeldig vir die teenwoordige skaal';
$string['invalidoverrideid'] = 'Ongeldige oorskrydings id';
$string['lastmodifiedgrade'] = 'Onlang gewysigde (punt)';
$string['lastmodifiedsubmission'] = 'Onlangs gewysigde (inhandiging)';
$string['latesubmissions'] = 'Laat indiendings';
$string['latesubmissionsaccepted'] = 'Toegelaat tot {$a}';
$string['loading'] = 'Besig om te laai...';
$string['locksubmissionforstudent'] = 'Verhoed enige verdere inhandigings vir student: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Sluit inhandigings';
$string['manageassignfeedbackplugins'] = 'Bestuur opdrag terugvoer inproppe';
$string['manageassignsubmissionplugins'] = 'Bestuur opdrag inhandiging inproppe';
$string['marker'] = 'Merker';
$string['markerfilter'] = 'Merkfilter';
$string['markerfilternomarker'] = 'Geen merker';
$string['markingallocation'] = 'Gebruik nasien toekenning';
$string['markingallocation_help'] = 'Indien aktiveer saam met nasien werkstroom, kan merkers aan bepaalde studente toegeken word.';
$string['markingworkflow'] = 'Gebruik nasien werkstroom';
$string['markingworkflow_help'] = 'Indien geaktiveer,  gaan punte deur \'n reeks werkvloeistadiums voordat dit aan studente vrygestel word. Dit maak voorsiening vir veelvuldige nasienrondes en punte word gelyktydig aan alle studente vrygestel.';
$string['markingworkflowstate'] = 'Merkproses status';
$string['markingworkflowstate_help'] = 'Moontlike werkstroomtoestande kan insluit (afhangend van u toestemmings):

* Ongemerk - die merker het nog nie begin nie
* Besig met nasien - die merker het begin, maar is nog nie klaar nie
* Nasien voltooi - die merker is klaar, maar jy moet dalk teruggaan om te kontroleer
* Hersiening - die nasien is nou by die onderwyser wat verantwoordelik is vir kwaliteitskontrole
* Gereed vir vrystelling - die onderwyser wat verantwoordelik is, is tevrede met die nasien, maar kan wag voordat hy/sy die studente toegang tot die nasien gee.
* Vrygestel - die student het toegang tot die punte';
$string['markingworkflowstateinmarking'] = 'Besig om nagesien te word';
$string['markingworkflowstateinreview'] = 'Besig om hersien te word';
$string['markingworkflowstatenotmarked'] = 'Nog nie nagesien nie';
$string['markingworkflowstatereadyforrelease'] = 'Gereed om vry te stel';
$string['markingworkflowstatereadyforreview'] = 'Nasien voltooi';
$string['markingworkflowstatereleased'] = 'Vrygestel';
$string['maxattempts'] = 'Maksimum probeerslae';
$string['maxattempts_help'] = 'Die maksimum aantal inhandigings-pogings wat deur \'n student gedoen kan word. Nadat hierdie getal bereik is, kan word indienings gesluit.';
$string['maxgrade'] = 'Maksimum punt';
$string['maxperpage'] = 'Maksimum opdragte per bladsy';
$string['maxperpage_help'] = 'Die maksimum aantal opdragte wat \'n leerder kan toon op die ranglys vir opdragte. Hierdie instelling is handig om tydsoorskrydings vir kursusse met \'n groot aantal deelnemers te voorkom.';
$string['messageprovider:assign_notification'] = 'Opdrag kennisgewings';
$string['modulename'] = 'Opdrag';
$string['modulename_help'] = 'Die opdrag aktiwiteit laat \'n onderwyser toe om take op te stel, werk in te neem en punte en terugvoer daarvoor te gee.

Studente kan enige digitale inhoud (lêers) soos woordverwerkte dokumente, sigblaaie, beelde of klank- en videogrepe indien. Andersins, of daarbenewens, kan die opdrag vereis dat studente teks direk in die teksblokkie moet tik. \'n Opdrag kan ook gebruik word om studente te herinner aan werklike opdragte soos kunswerk wat hulle aflyn moet voltooi, en dus geen digitale inhoud benodig nie. Studente kan afsonderlik binne groepsverband werk indien.

Onderwysers kan terugvoerkommentaar lewer en lêers oplaai, soos gemerkte studente-voorleggings, dokumente met kommentaar of gesproke klankterugvoer. Opdragte kan nagesien word volgens \'n numeriese of persoonlike skaal of \'n gevorderde graderingsmetode soos \'n rubriek. Finale punte word in die punteboek aangeteken.';
$string['modulenameplural'] = 'Opdragte';
$string['moreusers'] = '{$a} meer...';
$string['multipleteams'] = 'Deelnemer van meer as een groep';
$string['multipleteams_desc'] = 'Hierdie opdrag vereis indienings in groepe. Jy is \'n deelnemer van meer as een groep. Om toegelaat te word om in te dien mag jy slegs aan een groep behoort. Kontak asb. jou onderwyser om jou deelname aan groepe te verander.';
$string['multipleteamsgrader'] = 'Lede van meer as een groep, dus nie in staat om inhandiging te maak nie.';
$string['newsubmissions'] = 'Opdrag ingedien';
$string['nextuser'] = 'Volgende gebruiker';
$string['noattempt'] = 'Geen probeerslag';
$string['noclose'] = 'Geen sluitingsdatum';
$string['nofiles'] = 'Geen lêers.';
$string['nofilters'] = 'Geen filter';
$string['nograde'] = 'Geen punt.';
$string['nogroupoverrides'] = 'Daar is tans geen groep oorskrydings nie.';
$string['nomoresubmissionsaccepted'] = 'Word slegs toegelaat vir deelnemers wat uitstel ontvang het';
$string['none'] = 'Geen';
$string['noonlinesubmissions'] = 'Hierdie opdrag verwag nie van jou om enige iets aanlyn in te dien nie';
$string['noopen'] = 'Geen oop datum';
$string['nooverridedata'] = 'Jy moet ten minste een van die opdraginstellings ignoreer.';
$string['nosavebutnext'] = 'Volgende';
$string['nosubmission'] = 'Nog niks is ingedien vir hierdie opdrag nie';
$string['nosubmissionyet'] = 'Geen inhandigings is nog gemaak nie';
$string['noteam'] = 'Nie \'n deelnemer van \'n groep nie';
$string['noteam_desc'] = 'Hierdie opdrag vereis indienings in groepe. Jy is nie \'n deelnemer in \'n groep nie en daarom word jy nie toegelaat om in te dien nie. Kontak asb. jou onderwyser om jou deel te maak van \'n groep.';
$string['noteamgrader'] = 'Nie \'n lid van enige groep nie, dus nie in staat om \'n inhandiging te maak nie.';
$string['notgraded'] = 'Nog nie nagesien nie';
$string['notgradedyet'] = 'Nog nie gemerk nie';
$string['notifications'] = 'Kennisgewings';
$string['nouseroverrides'] = 'Daar is tans geen gebruikers oortredings nie.';
$string['nousers'] = 'Geen gebruikers';
$string['nousersselected'] = 'Geen gebruikers verkies nie';
$string['numberofdraftsubmissions'] = 'Konsepte';
$string['numberofparticipants'] = 'Deelnemers';
$string['numberofsubmissionsneedgrading'] = 'Moet nagesien word';
$string['numberofsubmissionsneedgradinglabel'] = 'Benodig gradering: {$a}';
$string['numberofsubmittedassignments'] = 'Ingehandig';
$string['numberofteams'] = 'Groepe';
$string['offline'] = 'Geen aanlyn inhandings vereis nie';
$string['open'] = 'Oop';
$string['opensubmissionexists'] = 'Oop opdrag inhandiging bestaan reeds.';
$string['outlinegrade'] = 'Punt: {$a}';
$string['outof'] = '{$a->current} vanuit {$a->total}';
$string['overdue'] = 'Opdrag is agterstallig deur: {$a}';
$string['override'] = 'Oorskryding';
$string['overridedeletegroupsure'] = 'Is jy seke jy wil die oorskryding vir groep {$a} uitvee?';
$string['overridedeleteusersure'] = 'Is jy seke jy wil die oorskryding vir gebruiker {$a} uitvee?';
$string['overridegroup'] = 'Groep oorskryding';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Oorskryding';
$string['overrideuser'] = 'Oorskry gebruiker';
$string['overrideusereventname'] = '{$a->assign} - Oorskryding';
$string['page-mod-assign-view'] = 'Opdragmodule hoof- en inhandigingsbladsy';
$string['page-mod-assign-x'] = 'Enige opdragmodulebladsy';
$string['paramtimeremaining'] = '{$a} oorblywend';
$string['participant'] = 'Deelnemer';
$string['pluginadministration'] = 'Opdrag administrasie';
$string['pluginname'] = 'Opdrag';
$string['preventsubmissionnotingroup'] = 'Vereis dat groep \'n inhandiging maak';
$string['preventsubmissionnotingroup_help'] = 'Indien aktiveer, sal gebruikers wat nie lede van \'n groep is nie, nie in staat wees om inhandigings te maak nie.';
$string['preventsubmissions'] = 'Verhoed die gebruiker om enige verdere veranderinge aan die opdrag aan te bring.';
$string['preventsubmissionsshort'] = 'Verhoed veranderinge aan inhandiging';
$string['previous'] = 'Vorige';
$string['previoususer'] = 'Vorige gebruiker';
$string['privacy:attemptpath'] = 'poging {$a}';
$string['privacy:blindmarkingidentifier'] = 'Die geïdentifiseerde gebruiker vir anonieme inhandigings';
$string['privacy:gradepath'] = 'punt';
$string['privacy:metadata:assigndownloadasfolders'] = '\'n Gebruikersvoorkeur of veelvuldige lêer inhandigings in vouers afgelaai moet word';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Terugvoerdata vir opdrag';
$string['privacy:metadata:assignfilter'] = 'Filtreer opsies soos \'Ingehandig\', \'Uitstaande\', \'Vereis nasien\' en \'Uitstel vergun\'';
$string['privacy:metadata:assigngrades'] = 'Stoor gebruikerpunte vir die opdrag';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtreer die opdrag opsomming deur die toegekende merker.';
$string['privacy:metadata:assignmentid'] = 'Opdrag ID';
$string['privacy:metadata:assignmessageexplanation'] = 'Boodskappe word aan studente gestuur deur die boodskap stelsel.';
$string['privacy:metadata:assignoverrides'] = 'Stoor oorskryding informasie vir die opdrag';
$string['privacy:metadata:assignperpage'] = 'Aantal opdragte gewys per bladsy.';
$string['privacy:metadata:assignquickgrading'] = 'Voorkeur of spoednasien gebruik word of nie.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Stoor gebruikersinhandiging informasie';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Inhandigingsdata vir die opdrag.';
$string['privacy:metadata:assignuserflags'] = 'Stoor gebruikers meta data soos uitsteldatums';
$string['privacy:metadata:assignusermapping'] = 'Kartering van anonieme inhandigings';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtreer deur verskillende werkstroomfases.';
$string['privacy:metadata:grade'] = 'Die syferpunt vir hierdie opdrag. Kan bepaal word deur skale/gevorderde nasiening ens. ,maar sal altyd weer na \'n drywende punt omgeskakel word.';
$string['privacy:metadata:grader'] = 'Die gebruikers ID van die nasienpersoon';
$string['privacy:metadata:groupid'] = 'Groep ID waarvan die gebruiker \'n lid is.';
$string['privacy:metadata:latest'] = 'Vereenvoudig die navrae deur alleenlik informasie oor die nuutste poging te verkry';
$string['privacy:metadata:mailed'] = 'Is die gebruiker al ge-e-pos?';
$string['privacy:metadata:timecreated'] = 'Tyd geskep';
$string['privacy:metadata:timestarted'] = 'Die begin tyd';
$string['privacy:metadata:userid'] = 'ID van gebruiker';
$string['privacy:studentpath'] = 'studentinhandiging';
$string['privacy:submissionpath'] = 'inhandiging';
$string['quickgrading'] = 'Spoedmerk';
$string['quickgrading_help'] = 'Met spoedmerk kan jy punte (en uitkomste) direk in die indieningstabel toeken. Spoedmerk is nie versoenbaar met gevorderde nasiening nie en word nie aanbeveel as daar veelvoudige nasieners is nie.';
$string['quickgradingchangessaved'] = 'Die punt verandering is gestoor';
$string['quickgradingresult'] = 'Spoedmerk';
$string['recordid'] = 'Identifiseerder';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} na kursus begin';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} voor kursus begin';
$string['relativedatessubmissiontimeleft'] = 'Bereken vir elke student';
$string['removeallgroupoverrides'] = 'Vee alle groepoorskrydings uit';
$string['removealluseroverrides'] = 'Vee alle gebruikeroorskrydings uit';
$string['removesubmission'] = 'Vee inhandiging uit';
$string['removesubmissionconfirm'] = 'Is jy seker jy wil jou inhandiging verwyder?';
$string['removesubmissionconfirmforstudent'] = 'Is jy seker jy wil die inhandiging vir {$a} verwyder?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Is jy seker jy wil die voorlegging vir {$a} verwyder? Let daarop dat dit nie die student se tydsbeperking sal herstel nie. U kan meer tyd gee deur \'n tydsbeperking by te voeg wat die gebruiker oorheers.';
$string['removesubmissionconfirmwithtimelimit'] = 'Is jy seker jy wil jou voorlegging verwyder? Let daarop dat dit nie u tydsbeperking sal herstel nie.';
$string['removesubmissionforstudent'] = 'Verwyder inhanding vir student: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Heropen totdat slaag-opsie is nie versoenbaar met anonieme voorleggings nie, omdat die punte eers in die puntestaat bekend gemaak word voordat die student se identiteit bekend gemaak word.';
$string['requireallteammemberssubmit'] = 'Vereis dat alle groepslede indien';
$string['requireallteammemberssubmit_help'] = 'Indien geaktiveer, moet alle lede van die studentegroep die opdrag se handig in knoppie klik voor die groepinhandiging as ingedien beskou word. Indien gedeaktiveer, sal die groep inhandiging as ingehandig beskou word sodra enige groepslid van die studentegroep die handig in knoppie klik.';
$string['requiresubmissionstatement'] = 'Vereis dat studente die inhandigingstelling aanvaar';
$string['requiresubmissionstatement_help'] = 'Vereis dat studente die inhandigingstelling vir alle inhandigings vir hierdie opdrag aanvaar';
$string['revealidentities'] = 'Maak studenteidentiteite bekend';
$string['revealidentitiesconfirm'] = 'Is jy seker dat jy studenteidentiteite vir die opdrag wil bekend maak? Hierdie werk kan nie ontdoen word nie. Nadat die student se identiteit bekend gemaak is, word die punte in die puntestaat vrygestel.';
$string['reverttodefaults'] = 'Stel terug na opdrag verstekinstellings';
$string['reverttodraft'] = 'Stel die indiening terug na konsepstatus';
$string['reverttodraftforstudent'] = 'Stel inhandiging terug na konsep vir student: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Stel inhandiging terug tot \'n konsep';
$string['reviewed'] = 'Hersien';
$string['save'] = 'Stoor';
$string['saveallquickgradingchanges'] = 'Stoor alle spoedmerk veranderinge';
$string['saveandcontinue'] = 'Stoor en volgende';
$string['savechanges'] = 'Stoor veranderinge';
$string['savegradingresult'] = 'Nasien';
$string['savenext'] = 'Stoor en wys volgende';
$string['saveoverrideandstay'] = 'Stoor en voer nog \'n oorskryding in';
$string['savingchanges'] = 'Stoor veranderinge...';
$string['scale'] = 'Skaal';
$string['search:activity'] = 'Opdrag - aktiwiteit informasie';
$string['selectedusers'] = 'Verkose gebruikers';
$string['selectlink'] = 'Kies...';
$string['selectuser'] = 'Kies {$a}';
$string['sendlatenotifications'] = 'Stel merkers in kennis van laat inhandigings';
$string['sendlatenotifications_help'] = 'Indien aktiveer, ontvang merkers (gewoonlik onderwysers) \'n boodskap waneerookal \'n student \'n opdrag laat indien. Boodskapopsies is aanpasbaar.';
$string['sendnotifications'] = 'Stel merkers in kennis van inhandigings';
$string['sendnotifications_help'] = 'Indien aktiveer, kry merkers (gewoonlik onderwysers) \'n boodskap elke keer as \'n student \'n opdrag vroeg, betyds en laat indien. Boodskapopsies is aanpasbaar.';
$string['sendstudentnotifications'] = 'Stel student in kennis';
$string['sendstudentnotifications_help'] = 'Merk hierdie blokkie om \'n kennisgewing oor die opgedateerde graad of terugvoer te stuur. As die opdrag \'n nasienwerkstroom gebruik, of die grade in die graderverslag versteek is, sal die kennisgewing nie gestuur word voordat die punt vrygestel is nie.';
$string['sendstudentnotificationsdefault'] = 'Standaard vir \'Stel student in kennis\'';
$string['sendstudentnotificationsdefault_help'] = 'Wanneer elke student gemerk word, moet \'Stel student in kennis\' by verstek gemerk word?';
$string['sendsubmissionreceipts'] = 'Stuur ontvangsbewyse aan studente';
$string['sendsubmissionreceipts_help'] = 'Hierdie skakelaar maak die ontvangsbewyse vir studente moontlik. Studente sal elke keer as hulle \'n opdrag suksesvol indien, \'n kennisgewing ontvang.';
$string['setmarkerallocationforlog'] = 'Stel merktoekenning : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Stel toegekende merker';
$string['setmarkingworkflowstate'] = 'Stel nasienwerkstroom status';
$string['setmarkingworkflowstateforlog'] = 'Stel nasienwerkstroom status : (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Opdrag instellings';
$string['showrecentsubmissions'] = 'Wys onlangse inhandigings';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Nasienwerkstroomstatus moet "Vrygestel" wees vir studentekennisgewings.';
$string['submission'] = 'Inhandiging';
$string['submissionattachments'] = 'Wys slegs lêers tydens indiening';
$string['submissionattachments_help'] = 'Merk die kassie om slegs lêers op die indieningsblad te wys. Andersins sal lêers op beide die opdrag- en indieningsbladsye vertoon word.';
$string['submissioncopiedhtml'] = '<p>Jy het \'n kopie van jou vorige
opdraginhandigings vir \'<i>{$a->assignment}</i>\'.</p>
<p>Jy kan die status van jou <a href="{$a->url}">opdrag inhandiging sien</a>.</p>';
$string['submissioncopiedsmall'] = 'Jy het jou vorige werkopdrag vir {$a->assignment} gekopieër';
$string['submissioncopiedtext'] = 'Jy het \'n kopie van jou vorige
opdrag inhandiging vir  \'{$a->assignment}\' gemaak

Jy kan die status van jou opdrag inhandiging sien:

    {$a->url}';
$string['submissiondrafts'] = 'Vereis dat studente die handig in knoppie klik';
$string['submissiondrafts_help'] = 'Indien geaktiveer, moet studente op \'n stuurknoppie klik om hul inhandiging as finaal te verklaar. Dit stel studente in staat om \'n konsepweergawe van die voorlegging op die stelsel te hou. As hierdie instelling verander word van "Nee" na "Ja" nadat studente reeds ingedien het, sal die voorleggings as finaal beskou word.';
$string['submissioneditable'] = 'Die student kan hul eie inhandiging verander';
$string['submissionempty'] = 'Niks was ingedien nie';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Jy het bestaande inhandigingdata. Verlaat hierdie bladsy en probeer weer.';
$string['submissionmodifiedgroup'] = 'Die inhandiging is deur iemand anders aangepas. Verlaat hierdie bladsy en probeer weer.';
$string['submissionnotcopiedinvalidstatus'] = 'Hierdie opdag was nie gekopieër nie, omdat dit geredigeer was sedert dit oopgemaak is.';
$string['submissionnoteditable'] = 'Die student kan nie hierdie inhandiging verander nie';
$string['submissionnotopen'] = 'Hierdie opdrag is nie oop vir indiennings nie';
$string['submissionnotready'] = 'Die opdrag is nie gereed om ingehandig te word nie:';
$string['submissionplugins'] = 'Inhandiging inproppe';
$string['submissionreceipthtml'] = '<p>Jy het \'n opdrag inhandiging vir \'<i>{$a->assignment}</i>\' ingedien.</p>
<p>Jy kan die status van jou <a href="{$a->url}">opdrag inhandiging sien</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Jou opdrag inhandiging vir
\'<i>{$a->assignment}</i>\' is ingedien.<br /><br />
Jy kan die status van jou <a href="{$a->url}">opdrag inhandiging sien</a>.';
$string['submissionreceiptothersmall'] = 'Jou opdrag inhandiging vir {$a->assignment} is ingedien.';
$string['submissionreceiptothertext'] = 'Jou opdrag inhandiging vir
\'{$a->assignment}\' is ingedien.

Jy kan die status van jou opdraginhandiging sien:

    {$a->url}';
$string['submissionreceipts'] = 'Stuur ontvangsbewyse';
$string['submissionreceiptsmall'] = 'Jy het jou opdrag inhandiging vir {$a->assignment} ingedien';
$string['submissionreceipttext'] = 'Jy het \'n
opdrag inhandiging vir \'{$a->assignment}\' ingedien

Jy kan die status van jou opdrag inhandiging sien:

    {$a->url}';
$string['submissionsclosed'] = 'Inhandiging gesluit';
$string['submissionsettings'] = 'Inhandiging instellings';
$string['submissionslocked'] = 'Hierdie opdrag aanvaar nie inhandigings nie';
$string['submissionslockedshort'] = 'Inhandigingsveranderinge word nie toegelaat nie';
$string['submissionstatement'] = 'Inhandigingsstelling';
$string['submissionstatement_help'] = '\'n Stelling wat elke student moet aanvaar voordat hul werk kan inhandig';
$string['submissionstatementacceptedlog'] = 'Inhandigingsstelling aanvaar deur gebruiker {$a}';
$string['submissionstatementdefault'] = 'Hierdie inhandiging is my eie werk, behalwe waar ek aan die werk van ander mense erkenning gegee het.';
$string['submissionstatementteamsubmission'] = 'Groep inhandigingsstelling';
$string['submissionstatementteamsubmission_help'] = 'Stelling wat elke student moet aanvaar voordat hul werk in groepsverband kan indien';
$string['submissionstatementteamsubmissionallsubmit'] = 'Groepinhandigingsstelling waar alle groepslede indien';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Stelling wat elke student moet aanvaar voordat hul werk binne \'n groep kan indien.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Hierdie inhandiging is my eie werk as groepslid, behalwe waar ek aan ander se werk erkenning gegee het.';
$string['submissionstatementteamsubmissiondefault'] = 'Hierdie inhandiging is die werk van my groep, behalwe waar ek erkenning vir die gebruik van ander mense se werk gegee het.';
$string['submissionstatus'] = 'Inhandiging status';
$string['submissionstatus_'] = 'Geen inhandiging';
$string['submissionstatus_draft'] = 'Konsep (nog nie ingedien nie)';
$string['submissionstatus_marked'] = 'Nagesien';
$string['submissionstatus_new'] = 'Geen inhandiging';
$string['submissionstatus_reopened'] = 'Weer oopgemaak';
$string['submissionstatus_submitted'] = 'Ingedien om nagesien te word';
$string['submissionstatusheading'] = 'Indiening status';
$string['submissionsummary'] = '{$a->status}. Laaste gewysig op {$a->timemodified}';
$string['submissionteam'] = 'Groep';
$string['submissiontypes'] = 'Inhandigingstipes';
$string['submitaction'] = 'Handig in';
$string['submitassignment'] = 'Handig opdrag in';
$string['submitassignment_help'] = 'Sodra hierdie opdrag ingehandig is gaan jy nie meer veranderinge kan maak nie.';
$string['submitforgrading'] = 'Handig vir nasien in';
$string['submitted'] = 'Ingehandig';
$string['submittedearly'] = 'Opdrag was {$a} vroeg ingedien';
$string['submittedlate'] = 'Opdrag was {$a} laat ingedien';
$string['submittedlateshort'] = '{$a} laat';
$string['submittedovertime'] = 'Werkopdrag is {$a} oor die tydsbeperking ingedien';
$string['submittedundertime'] = 'Werkopdrag is {$a} onder die tydsbeperking ingedien';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Terugvoer inproppe';
$string['subplugintype_assignfeedback_plural'] = 'Terugvoer inproppe';
$string['subplugintype_assignsubmission'] = 'Inhandiging inproppe';
$string['subplugintype_assignsubmission_plural'] = 'Inhandiging inproppe';
$string['teamname'] = 'Span: {$a}';
$string['teamsubmission'] = 'Student dien in groep in';
$string['teamsubmission_help'] = 'Indien geaktiveer, sal studente in groepe verdeel word op grond van die standaardgroepgroepe of \'n aangepaste groepering. \'n Groepvoorlegging word onder groeplede gedeel en alle lede van die groep sal mekaar se veranderinge aan die voorlegging sien';
$string['teamsubmissiongroupingid'] = 'Groepering vir studentegroepe';
$string['teamsubmissiongroupingid_help'] = 'Dit is die groepering wat die opdrag sal gebruik om groepe vir studentegroepe te vind. As dit nie ingestel is nie, sal standaardgroepe gebruik word.';
$string['textinstructions'] = 'Opdraginstruksies';
$string['timelimit'] = 'Tydsbeperking';
$string['timelimit_help'] = 'If enabled, the time limit is stated on the assignment page and a countdown timer is displayed during the assignment.';
$string['timelimitnotenabled'] = 'Tydsbeperking is nie vir opdrag geaktiveer nie.';
$string['timelimitpassed'] = 'Die tydsbeperking het verstryk';
$string['timemodified'] = 'Laaste verander';
$string['timeremaining'] = 'Oorblywende tyd';
$string['timeremainingcolon'] = 'Oorblywende tyd: {$a}';
$string['togglezoom'] = 'Zoom in/uit by streek';
$string['ungroupedusers'] = 'Die instelling \'Vereis groepe om \'n inhandiging te maak\' is geaktiveer en sommige gebruikers is of nie deel van \'n groep nie, of is deel van meer as een groep. Hierdie gebruikers gaan nie die opdrag kan inhandig nie.';
$string['ungroupedusersoptional'] = 'Die instelling \'Studente dien in in groepe\' is geaktiveer en sommige gebruikers is nie deel van \'n groep nie, of is deel van meer as een groep. Let asb. daarop dat hierdie studente hul opdragte gaan indien as deelnemer van die \'Verstek groep\'.';
$string['unlimitedattempts'] = 'Onbeperk';
$string['unlimitedattemptsallowed'] = 'Onbeperkte pogings toegelaat.';
$string['unlimitedpages'] = 'Onbeperk';
$string['unlocksubmissionforstudent'] = 'Laat inhandigings vir student toe: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Ontsluit inhandigings';
$string['unsavedchanges'] = 'Ongestoorde veranderinge';
$string['unsavedchangesquestion'] = 'Daar is ongestoorde veranderinge aan jou punte en terugvoer aangebring. Wil jy die veranderinge stoor en voortgaan?';
$string['updategrade'] = 'Punt opdateer';
$string['updatetable'] = 'Stoor en dateer tabel op';
$string['upgradenotimplemented'] = 'Opgradering nie implementeer nie ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Gebruiker opdrag verstek';
$string['userextensiondate'] = 'Uitstel vergun tot: {$a}';
$string['usergrade'] = 'Gebruikerpunt';
$string['useridlistnotcached'] = 'Die puntveranderinge is NIE gestoor nie, aangesien dit nie moontlik was om te bepaal vir watter inhandinging dit bedoel was nie.';
$string['useroverrides'] = 'Gebruikersoorskrydings';
$string['useroverridesdeleted'] = 'Gebruikersoorskrydings uitgevee';
$string['usersnone'] = 'Geen studente het toegang tot hierdie opdrag nie.';
$string['usersubmissioncannotberemoved'] = 'Die inhandiging vir {$a} kan nie verwyder word nie.';
$string['userswhoneedtosubmit'] = 'Gebruiker wat nog moet indien: {$a}';
$string['validmarkingworkflowstates'] = 'Geldige nasienwerkstroomstatus';
$string['viewadifferentattempt'] = 'Wys \'n ander poging';
$string['viewbatchmarkingallocation'] = 'Beskou groepstel nasientoekenning bladsy.';
$string['viewbatchsetmarkingworkflowstate'] = 'Beskou groepstel nasienwerkvloeistatus bladsy.';
$string['viewfeedback'] = 'Beskou terugvoer';
$string['viewfeedbackforuser'] = 'Wys terugvoer vir gebruiker: {$a}';
$string['viewfull'] = 'Wys volle';
$string['viewfullgradingpage'] = 'Maak die volle nasienbladsy oop om terugvoer te gee';
$string['viewgradebook'] = 'Beskou punteboek';
$string['viewgrading'] = 'Sien alle inhandigings';
$string['viewgradingformforstudent'] = 'Wys nasienbladsy vir student: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Beskou eie handig opdrag in bladsy.';
$string['viewownsubmissionstatus'] = 'Beskou eie inhandiging status bladsy.';
$string['viewrevealidentitiesconfirm'] = 'Beskou maak studenteidentiteite oop bevestigingsbladsy.';
$string['viewsubmission'] = 'Besigtig inhandiging';
$string['viewsubmissionforuser'] = 'Beskou inhandiging vir gebruiker: {$a}';
$string['viewsubmissiongradingtable'] = 'Beskou inhandigingnasientabel.';
$string['viewsummary'] = 'Beskou opsomming';
$string['workflowfilter'] = 'Werkstroomfilter';
$string['xofy'] = '{$a->x} of {$a->y}';
