<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'no', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Feil ved lasting av bloggoppføringer';
$string['addon.blog.showonlyyourentries'] = 'Vis bare dine oppføringer';
$string['addon.calendar.calendarevent'] = 'Kalenderbegivenhet';
$string['addon.calendar.calendarevents'] = 'Kalenderhendelser';
$string['addon.calendar.calendarreminders'] = 'Kalenderpåminnelse';
$string['addon.calendar.currentmonth'] = 'Gjeldende måned';
$string['addon.calendar.defaultnotificationtime'] = 'Standard varslingstid';
$string['addon.calendar.errorloadevent'] = 'Feil ved lasting av hendelse';
$string['addon.calendar.errorloadevents'] = 'Feil ved lasting av hendelser';
$string['addon.calendar.noevents'] = 'Det er ingen hendelser';
$string['addon.calendar.reminders'] = 'Påminnelser';
$string['addon.calendar.setnewreminder'] = 'Angi ny påminnelse';
$string['addon.competency.errornocompetenciesfound'] = 'Ingen kompetansemål funnet';
$string['addon.competency.nocompetencies'] = 'Ingen kompetansemål';
$string['addon.coursecompletion.complete'] = 'Fullfør';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kunne ikke laste kursets avslutningsrapport. Prøv igjen senere.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurer enheter';
$string['addon.messages.contactlistempty'] = 'Kontaktlisten er tom';
$string['addon.messages.contactname'] = 'Navn på kontakt';
$string['addon.messages.deletemessage'] = 'Slett melding';
$string['addon.messages.deletemessageconfirmation'] = 'Er du sikker på at du vil slette denne meldingen? Den blir bare slettet fra meldingsloggen din og kan fremdeles vises av brukeren som sendte eller mottok meldingen.';
$string['addon.messages.errordeletemessage'] = 'Feil ved sletting av melding';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Feil ved henting av kontakter fra server';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Feil ved henting av diskusjoner fra server';
$string['addon.messages.errorwhileretrievingmessages'] = 'Feil ved henting av meldinger fra server';
$string['addon.messages.errorwhileretrievingusers'] = 'Feil under henting av brukere fra serveren.';
$string['addon.messages.messagenotsent'] = 'Meldingen ble ikke sendt. Prøv igjen senere';
$string['addon.messages.newmessages'] = 'Nye meldinger';
$string['addon.messages.nousersfound'] = 'Ingen brukere funnet';
$string['addon.messages.showdeletemessages'] = 'Vis slettede meldinger';
$string['addon.messages.type_blocked'] = 'Blokkert';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Søkeresultat';
$string['addon.messages.type_strangers'] = 'Andre';
$string['addon.messages.useentertosenddescdesktop'] = 'Hvis deaktivert, kan du bruke Ctrl+Enter for å sende meldingen.';
$string['addon.messages.useentertosenddescmac'] = 'Hvis deaktivert, kan du bruke Ctrl+Enter for å sende meldingen.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kunne ikke sende meldingen(e) til samtale {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kunne ikke sende melding(er) til {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Bekreft betingelsene';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Du kan ikke redigere et bidrag fordi vi ikke kunne hente betingelsene fra siden';
$string['addon.mod_assign.cannotgradefromapp'] = 'Noen karaktermetoder er ikke støttet av appen og kan ikke endres';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Du kan ikke foreta en innlevering i appen fordi innsendingserklæringen ikke kunne hentes fra nettstedet.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Du kan ikke legge til eller endre bidrag i appen fordi noen plugins ikke støtter redigering:';
$string['addon.mod_assign.errorshowinginformation'] = 'Innleveringsinformasjonen kan ikke vises.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Denne tilbakemeldingen er ikke støttet av appen og vil derfor kunne mangle informasjon.';
$string['addon.mod_assign.gradenotsynced'] = 'Karakter ikke synkronisert';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deltakere som ikke har innlevert noe vises ikke.';
$string['addon.mod_assign.submissionnotsupported'] = 'Denne innleveringen er ikke støttet i appen og vil muligens ikke vise all informasjonen.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'brukerkarakter';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Karakteren på innleveringen ble endret på portalen.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Brukerinnleveringen ble endret på portalen.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Feil under tilkobling til chatten.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Feil under henting av chattedata.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Feil under henting av chat-brukere.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Feil ved henting av melding fra server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Melding kunne ikke sendes.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Du må være på nett for å sende meldinger.';
$string['addon.mod_chat.nosessionsfound'] = 'Ingen økter funnet';
$string['addon.mod_chat.showincompletesessions'] = 'Vis ufullstendige økter';
$string['addon.mod_choice.errorgetchoice'] = 'Feil ved henting av gallup-data.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% av brukerne velger dette alternativet: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Resultatene viser ikke din siste respons. Synkroniser for å oppdatere dem.';
$string['addon.mod_data.edittagsnotsupported'] = 'Beklager, redigering av tagger støttes ikke av appen.';
$string['addon.mod_data.errorapproving'] = 'Feil ved godkjenning eller underkjenning av oppføring.';
$string['addon.mod_data.errordeleting'] = 'Feil ved sletting av oppføring';
$string['addon.mod_data.gettinglocation'] = 'Hent posisjon';
$string['addon.mod_data.locationnotenabled'] = 'Posisjon er ikke aktivert';
$string['addon.mod_data.locationpermissiondenied'] = 'Tillatelse til å få tilgang til posisjonen din er nektet.';
$string['addon.mod_data.mylocation'] = 'Min posisjon';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Beklager, men søk via tagger støttes ikke i appen.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Tilbakemelding med CAPTCHA kan ikke fullføres offline, eller hvis den ikke er konfigurert, eller hvis serveren er nede.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Denne tilbakemeldingen er lagret for å bli sendt inn senere.';
$string['addon.mod_folder.emptyfilelist'] = 'Det er ingen filer å vise.';
$string['addon.mod_forum.errorgetforum'] = 'Feil ved henting av forumdata';
$string['addon.mod_forum.errorgetgroups'] = 'Feil ved henting av gruppeinnstillinger.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kunne ikke opprette nye diskusjoner i alle grupper';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Det er foreløpig ingen diskusjonsemner i dette forumet.';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskusjoner';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} svar';
$string['addon.mod_forum.refreshposts'] = 'Oppdater innlegg';
$string['addon.mod_glossary.browsemode'] = 'Bla i oppføringer';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetisk';
$string['addon.mod_glossary.byauthor'] = 'Gruppér etter forfatter';
$string['addon.mod_glossary.bycategory'] = 'Gruppér etter kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Nyeste først';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Nylig oppdatert';
$string['addon.mod_glossary.bysearch'] = 'Søk';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan ikke redigere oppføring';
$string['addon.mod_glossary.entriestobesynced'] = 'Oppføringer som skal synkroniseres';
$string['addon.mod_glossary.entrypendingapproval'] = 'Denne oppføringen venter på godkjenning';
$string['addon.mod_glossary.errorloadingentries'] = 'Feil ved lasting av oppføringer.';
$string['addon.mod_glossary.errorloadingentry'] = 'Feil ved lasting av oppføringen.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Feil ved lasting av ordliste';
$string['addon.mod_glossary.noentriesfound'] = 'Ingen oppføringer funnet';
$string['addon.mod_glossary.searchquery'] = 'Søkeord';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Last ned H5P-fil';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Feil ved henting av H5P aktivitetsdata';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P-pakken er ikke lastet ned. Du må laste den ned først for å kunne bruke den.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P-pakken er endret siden forrige nedlasting. Du må laste den ned på nytt for å kunne bruke den.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Du må være online for å vise H5P-pakken.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Vis forsøk {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Vis beskrivelse';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Denne leksjonen inneholder et hopp til en tilfeldig innholdsside. Det kan ikke forsøkes i appen før den er startet i en nettleser.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dette forsøket kan ikke lenger vurderes fordi et annet forsøk er fullført.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dette forsøket ble avsluttet uten nett.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Et offline-forsøk ble synkronisert. Vil du vurdere det?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Forsøket ble avsluttet på portalen.';
$string['addon.mod_lti.errorgetlti'] = 'Feil ved henting av moduldata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Startadressen er ikke gyldig.';
$string['addon.mod_lti.launchactivity'] = 'Start aktiviteten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Feil ved lasting av sideinnholdet.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Du kan prøve denne quizen i appen, men du må sende inn forsøket i nettleseren av følgende årsaker:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Dette quizforsøket kan ikke sendes inn av følgende grunner:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Dette forsøket har ikke blitt synkronisert siden {{$a}}. Hvis du har fortsatt dette forsøket på en annen enhet siden den gang, kan du miste data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Det oppstod en feil under lagring av svarene. Er du sikker på at du vil forlate quizen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi spørsmålstypen ikke støttes av appen:';
$string['addon.mod_quiz.errordownloading'] = 'Feil ved nedlasting av nødvendige data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Feil ved innhenting av forsøksdata.';
$string['addon.mod_quiz.errorgetquestions'] = 'Feil ved henting av spørsmål.';
$string['addon.mod_quiz.errorgetquiz'] = 'Feil ved henting av Quiz-data.';
$string['addon.mod_quiz.errorparsequestions'] = 'Det oppstod en feil under lesing av spørsmålene. Vennligst prøv denne quizen i en nettleser i stedet.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi den bare inneholder spørsmåltyper som ikke støttes av appen:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi den har tilgangsregler som ikke støttes av appen:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Det oppstod en feil under lagring av forsøksdataene.';
$string['addon.mod_quiz.finishnotsynced'] = 'Fullført, men ikke synkronisert';
$string['addon.mod_quiz.opentoc'] = 'Åpne navigasjonsvindu';
$string['addon.mod_quiz.warningattemptfinished'] = 'Frakoblet forsøk kastes ettersom det var fullført på portalen eller ikke ble funnet.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Noen frakoblede svar ble kastet fordi spørsmålene ble endret online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Forsøk ble ufullstendig fordi noen frakoblede svar ble vraket. Gjennomgå svarene dine, og send deretter forsøket på nytt.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Denne quizen inneholder spørsmålstyper som ikke støttes av appen:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Feil under innlasting.';
$string['addon.mod_resource.openthefile'] = 'Åpne fila';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Karakteren kunne ikke beregnes.';
$string['addon.mod_scorm.dataattemptshown'] = 'Disse dataene tilhører forsøksnummeret {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Det oppsto en feil under opprettelsen av et nytt frakoblet forsøk. Vennligst prøv på nytt.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Feil ved nedlasting av SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Feil ved henting av SCORM-data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Beklager, applikasjonen støtter bare SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Nedlastingen av SCORM-pakker er deaktivert. Kontakt nettstedsadministratoren.';
$string['addon.mod_scorm.errornovalidsco'] = 'Denne SCORM-pakken har ikke en synlig SCO å laste inn.';
$string['addon.mod_scorm.errorpackagefile'] = 'Beklager, applikasjonen støtter bare ZIP-pakker.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Det oppsto en feil under synkroniseringen. Vennligst prøv på nytt.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dette forsøket har data som ikke er synkronisert.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dette forsøket kan ikke sendes fordi du overskred maksimalt antall forsøk.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Denne SCORM-pakken lastes ikke ned. Den lastes ned automatisk når du åpner den.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Denne SCORM-pakken er endret siden forrige nedlasting. Den lastes ned automatisk når du åpner den.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Noen frakoblede data fra forsøk {{number}} er forkastet fordi de ikke kunne telles som et nytt forsøk.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Noen forsøk kunne ikke synkroniseres med portalen fordi det siste online-forsøket ennå ikke er fullført. Fullfør på portalen først.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Beklager, det oppsto et problem med å sende undersøkelsen. Vennligst prøv på nytt.';
$string['addon.mod_survey.errorgetsurvey'] = 'Feil ved henting av undersøkelsesdata.';
$string['addon.mod_survey.results'] = 'Resultater';
$string['addon.mod_url.accessurl'] = 'Åpne URL';
$string['addon.mod_url.pointingtourl'] = 'URL som ressursen peker til.';
$string['addon.mod_wiki.errorloadingpage'] = 'En feil oppstod under lasting av siden.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Denne Wikien har ikke noe innhold ennå.';
$string['addon.mod_wiki.gowikihome'] = 'Gå til Wikiens førsteside';
$string['addon.mod_wiki.subwiki'] = 'Sub-Wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Tittel kan ikke være blank';
$string['addon.mod_wiki.viewpage'] = 'Vis side';
$string['addon.mod_wiki.wikipage'] = 'Wikiside';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Vurderingsstrategi {{$a}} støttes ikke';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Du må skrive inn en tittel';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Innleveringen er endret på portalen.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Vurderingen ble endret på portalen.';
$string['addon.notes.warningnotenotsent'] = 'Kunne ikke legge til notat(er) på kurs {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Feil ved henting av varsler.';
$string['addon.notifications.notifications'] = 'Varsler';
$string['addon.notifications.playsound'] = 'Spill lyd';
$string['addon.notifications.therearentnotificationsyet'] = 'Det er ingen varsler.';
$string['addon.storagemanager.deletecourse'] = 'Fjern alle kursdata';
$string['addon.storagemanager.deletecourses'] = 'Fjern alle kursdata';
$string['addon.storagemanager.deletedatafrom'] = 'Fjern data fra {{name}}';
$string['addon.storagemanager.info'] = 'Filer som er lagret på enheten din, gjør at appen fungerer raskere og gjør at appen kan brukes offline. Du kan trygt fjerne filer hvis du trenger å frigjøre lagringsplass.';
$string['addon.storagemanager.managestorage'] = 'Administrere lagring';
$string['addon.storagemanager.storageused'] = 'Fillagring brukt:';
$string['appstoredescription'] = 'Denne offisielle mobilapplikasjonen for Moodle vil BARE virke hvis Moodle-siden er satt opp for å tillate det. Ta kontakt med din Moodleadministrator hvis du har problemer med å koble til.

Hvis Moodle-sidener riktig konfigurert kan du bruke appen til å:

- Bla igjennom kursinnhold, til og med når du er offline.
- Få varsler om meldinger og andre hendelser
- Raskt finne og kontakte andre på kurset
- Laste opp bilder, lyd, videoer og andre filer fra mobilen din
- Se karakterer
- og mer!

Se http://docs.moodle.org/en/Mobile_app for nyeste informasjon.

Vi setter stor pris på gode tilbakemeldinger om funksjonalitet så langt, og dine forslag til hva annet du ønsker at appen skal kunne gjøre.

Appen krever følgende tillatelser:
Lydopptak - For opptak og opplasting av lyd til Moodle
Lese og endre innholdet på minnekortet ditt - Innhold lastes ned til minnekortet slik at du har tilgang når du ikke er på nett
Tilgang til nettverk - For å kunne koble til Moodle-siden og sjekke om du er tilkoblet eller ikke, og for å kunne koble over til "offline mode"
Kjøre ved oppstart - For å sikre at du får varsler når appen kjører i bakgrunnen
Forhindre dvaleomdus - Foer å sikre at du alltid kan motta varsler';
$string['core.browser'] = 'Nettleser';
$string['core.cannotconnect'] = 'Kan ikke koble til';
$string['core.cannotdownloadfiles'] = 'Nedlasting av filer er deaktivert. Kontakt portaladministratoren.';
$string['core.cannotopeninapp'] = 'Denne filen fungerer kanskje ikke som forventet på denne enheten. Vil du åpne den uansett?';
$string['core.cannotopeninappdownload'] = 'Denne filen fungerer kanskje ikke som forventet på denne enheten. Vil du laste den ned uansett?';
$string['core.captureaudio'] = 'Spill inn lyd';
$string['core.capturedimage'] = 'Bilde tatt.';
$string['core.captureimage'] = 'Ta bilde';
$string['core.capturevideo'] = 'Ta opp video';
$string['core.clearsearch'] = 'Nullstill søk';
$string['core.clearstoreddata'] = 'Fjern lagring {{$a}}';
$string['core.clicktoseefull'] = 'Klikk for å se hele innholdet.';
$string['core.comments.commentsnotworking'] = 'Kommentarer kan ikke hentes';
$string['core.comments.warningcommentsnotsent'] = 'Kunne ikke synkronisere kommentarer.  {{error}}';
$string['core.confirmcanceledit'] = 'Er du sikker på at du vil forlate siden? Du vil miste alle endringer.';
$string['core.confirmgotabroot'] = 'Er du sikker på at du vil gå tilbake til {{name}}?';
$string['core.confirmgotabrootdefault'] = 'Er du sikker på at du vil gå til startsiden i den nåværende fanen?';
$string['core.confirmleaveunknownchanges'] = 'Er du sikker på at du vil forlate denne siden? Hvis du har endringer som ikke er lagret, vil de gå tapt.';
$string['core.confirmloss'] = 'Er du sikker? Du vil miste alle endringer.';
$string['core.confirmopeninbrowser'] = 'Vil du åpne den i nettleser?';
$string['core.contenteditingsynced'] = 'Innholdet du redigerer er synkronisert.';
$string['core.contentlinks.chooseaccount'] = 'Velg konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Velg en konto å åpne lenken med';
$string['core.contentlinks.confirmurlothersite'] = 'Denne lenken tilhører et annet nettsted. Vil du åpne den?';
$string['core.contentlinks.errornoactions'] = 'Fant ikke en handling å utføre med denne lenken.';
$string['core.contentlinks.errornosites'] = 'Fant ikke noe nettsted for å håndtere denne lenken.';
$string['core.contentlinks.errorredirectothersite'] = 'Viderekoblings-URL-en kan ikke peke til et annet nettsted.';
$string['core.copiedtoclipboard'] = 'Tekst kopiert til utklippstavlen';
$string['core.copytoclipboard'] = 'Kopier til utklippstavlen';
$string['core.course.activitydisabled'] = 'Organisasjonen din har deaktivert denne aktiviteten i mobilappen.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Organisasjonen din installerte en modul som ikke støttes ennå.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Organisasjonens Moodle-installasjon må oppdateres.';
$string['core.course.allsections'] = 'Alle seksjoner';
$string['core.course.askadmintosupport'] = 'Kontakt portaladministratoren og fortell dem at du vil bruke denne aktiviteten med Moodle Mobile-appen.';
$string['core.course.availablespace'] = 'Du har for øyeblikket omtrent {{available}} ledig plass.';
$string['core.course.cannotdeletewhiledownloading'] = 'Filer kan ikke slettes mens aktiviteten lastes ned. Vent til nedlastingen er ferdig.';
$string['core.course.confirmdeletemodulefiles'] = 'Er du sikker på at du vil slette disse filene?';
$string['core.course.confirmdeletestoreddata'] = 'Er du sikker på at du vil slette de lagrede dataene?';
$string['core.course.confirmdownload'] = 'Du er i ferd med å laste ned {{size}}. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmdownloadunknownsize'] = 'Det var ikke mulig å beregne størrelsen på nedlastingen. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmdownloadzerosize'] = 'Du er i ferd med å begynne å laste ned. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmlimiteddownload'] = 'Du er for øyeblikket ikke koblet til Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Du er i ferd med å laste ned <strong> minst </strong> {{size}}. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.contents'] = 'Innhold';
$string['core.course.couldnotloadsectioncontent'] = 'Kunne ikke laste inn seksjonsinnholdet. Prøv igjen senere.';
$string['core.course.couldnotloadsections'] = 'Kunne ikke laste seksjonene. Prøv igjen senere.';
$string['core.course.errordownloadingcourse'] = 'Feil ved nedlasting av kurs.';
$string['core.course.errordownloadingsection'] = 'Feil ved nedlasting av seksjonen.';
$string['core.course.errorgetmodule'] = 'Feil ved henting av aktivitetsdata.';
$string['core.course.insufficientavailablequota'] = 'Enheten din kunne ikke tildele plass til å lagre denne nedlastingen. Det kan være holdt igjen plass til app- og systemoppdateringer. Tøm litt lagringsplass først.';
$string['core.course.insufficientavailablespace'] = 'Du prøver å laste ned {{size}}. Dette gir enheten din ikke nok plass til å fungere normalt. Tøm litt lagringsplass først.';
$string['core.course.manualcompletionnotsynced'] = 'Manuell fullføring er ikke synkronisert.';
$string['core.course.nocontentavailable'] = 'Ingen innhold tilgjengelig for øyeblikket.';
$string['core.course.refreshcourse'] = 'Oppfrisk kurs';
$string['core.course.useactivityonbrowser'] = 'Du kan fortsatt bruke den ved hjelp av enhetens nettleser.';
$string['core.course.warningmanualcompletionmodified'] = 'Den manuelle fullføringen av en aktivitet ble endret på nettstedet.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Noen frakoblede manuelle gjennomføringer av kurset \'{{name}}\' er slettet. {{error}}';
$string['core.coursenogroups'] = 'Du er ikke medlem av noen gruppe på dette kurset.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorier dypere enn nivå {{$a}} kan ikke hentes.';
$string['core.courses.confirmselfenrol'] = 'Er du sikker på at du vil melde deg på dette kurset?';
$string['core.courses.downloadcourses'] = 'Last ned kurs';
$string['core.courses.enrolme'] = 'Meld meg på';
$string['core.courses.errorloadcategories'] = 'Det oppsto en feil under innlasting av kategorier.';
$string['core.courses.errorloadcourses'] = 'Det oppsto en feil under innlasting av kurs.';
$string['core.courses.errorloadplugins'] = 'Moduler som kreves av dette kurset kunne ikke lastes inn riktig. Last inn appen på nytt for å prøve igjen.';
$string['core.courses.errorsearching'] = 'Det oppsto en feil under søket.';
$string['core.courses.errorselfenrol'] = 'Det oppstod en feil under egenpåmeldingen.';
$string['core.courses.filtermycourses'] = 'Filtrér mine kurs';
$string['core.courses.notenrollable'] = 'Du kan ikke melde deg på dette kurset.';
$string['core.courses.password'] = 'Påmeldingsnøkkel';
$string['core.courses.searchcoursesadvice'] = 'Du kan bruke kurssøk-knappen for å finne kurs du kan få tilgang til som gjest eller hvor kan melde deg selv på kurs som tillater det.';
$string['core.courses.selfenrolment'] = 'Egenpåmelding';
$string['core.courses.totalcoursesearchresults'] = 'Totalt antall kurs: {{$a}}';
$string['core.currentdevice'] = 'Gjeldende enhet';
$string['core.datastoredoffline'] = 'Data lagret på enheten fordi de ikke kunne sendes. Det sendes automatisk senere.';
$string['core.deletedoffline'] = 'Slettet uten nett';
$string['core.deleting'] = 'Sletter';
$string['core.desktop'] = 'Skriveboirdet';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Kast';
$string['core.dismiss'] = 'Avvis';
$string['core.downloaded'] = 'Lasted ned';
$string['core.downloading'] = 'Laster ned';
$string['core.editor.hidetoolbar'] = 'Skjul verktøylinje';
$string['core.editor.toggle'] = 'Bytt editor';
$string['core.emptysplit'] = 'Denne siden vises tom hvis venstre panel er tomt eller lastes inn.';
$string['core.errorchangecompletion'] = 'Det oppsto en feil under endring av fullføringsstatus. Vennligst prøv på nytt.';
$string['core.errordeletefile'] = 'Feil ved sletting av filen. Vennligst prøv på nytt.';
$string['core.errordownloading'] = 'Feil ved nedlasting av filen.';
$string['core.errordownloadingsomefiles'] = 'Feil ved nedlasting av filer. Noen filer kan mangle.';
$string['core.errorfileexistssamename'] = 'En fil med dette navnet eksisterer allerede.';
$string['core.errorinvalidform'] = 'Skjemaet inneholder ugyldige data. Kontroller at alle obligatoriske felt er fylt ut og at dataene er gyldige.';
$string['core.errorinvalidresponse'] = 'Ugyldig respons mottatt. Kontakt portaladministratoren din hvis feilen vedvarer.';
$string['core.errorloadingcontent'] = 'Feil ved lasting av innhold.';
$string['core.errorofflinedisabled'] = 'Frakoblet surfing er deaktivert på nettstedet ditt. Du må være koblet til internett for å bruke appen.';
$string['core.erroropenfilenoapp'] = 'Feil ved åpning av fil: ingen app funnet for å åpne denne typen fil.';
$string['core.erroropenfilenoextension'] = 'Feil ved åpning av fil: Filen har ikke filtype.';
$string['core.erroropenpopup'] = 'Denne aktiviteten prøver å åpne en popup. Dette støttes ikke i appen.';
$string['core.errorrenamefile'] = 'Feil under navneendring til filen. Vennligst prøv på nytt.';
$string['core.errorsomedatanotdownloaded'] = 'Hvis du lastet ned denne aktiviteten, må du merke deg at noen data ikke lastes ned under nedlastingsprosessen av hensyn til ytelse og databruk.';
$string['core.errorsync'] = 'Det oppsto en feil under synkroniseringen. Vennligst prøv på nytt.';
$string['core.errorsyncblocked'] = 'Denne {{$a}} kan ikke synkroniseres akkurat nå på grunn av en pågående prosess. Prøv igjen senere. Hvis problemet vedvarer, kan du prøve å starte appen på nytt.';
$string['core.errorurlschemeinvalidscheme'] = 'Denne URL-adressen er ment å brukes i en annen app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL-en til dette nettstedet kan ikke åpnes i denne appen.';
$string['core.filenameexist'] = 'Filnavnet eksisterer allerede: {{$a}}';
$string['core.fileuploader.audio'] = 'Lyd';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Du er i ferd med å laste opp {{size}}. Er du sikker på at du vil fortsette?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Det var ikke mulig å beregne størrelsen på opplastingen. Er du sikker på at du vil fortsette?';
$string['core.fileuploader.errorcapturingaudio'] = 'Feil ved opptak av lyd.';
$string['core.fileuploader.errorcapturingimage'] = 'Feil ved opptak av bilde.';
$string['core.fileuploader.errorcapturingvideo'] = 'Feil ved opptak av video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Feil ved henting av bilde fra album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Du må være på nett for å kunne laste opp filer.';
$string['core.fileuploader.errornoapp'] = 'Du har ikke installert en app for å utføre denne handlingen.';
$string['core.fileuploader.errorreadingfile'] = 'Feil ved lesing av fil.';
$string['core.fileuploader.errorwhileuploading'] = 'Det oppstod en feil under filopplastingen.';
$string['core.fileuploader.file'] = 'Fil';
$string['core.fileuploader.fileuploaded'] = 'Filen ble lastet opp.';
$string['core.fileuploader.maxbytesfile'] = 'Filen {{$a.file}} er for stor. Maksimal størrelse du kan laste opp er {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Leser fil';
$string['core.fileuploader.readingfileperc'] = 'Leser fil: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Velg en fil';
$string['core.fileuploader.uploadafile'] = 'Last opp en fil';
$string['core.fileuploader.uploading'] = 'Laster opp';
$string['core.fileuploader.uploadingperc'] = 'Laster opp:  {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Feil ved innhenting av brukerens e-post. Kontroller tilkoblingen din, og prøv på nytt.';
$string['core.h5p.offlinedisabled'] = 'Portalen tillater ikke nedlasting av H5P-pakker.';
$string['core.h5p.play'] = 'Spill av H5P';
$string['core.hasdatatosync'] = 'Denne {{$a}} har frakoblede data som skal synkroniseres.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Bilde';
$string['core.imageviewer'] = 'Bildeviser';
$string['core.lastdownloaded'] = 'Sist lastet ned';
$string['core.lastsync'] = 'Sist synkronisert';
$string['core.loadmore'] = 'Last mer';
$string['core.login.authenticating'] = 'Autentiserer';
$string['core.login.changepasswordbutton'] = 'Åpne siden for endring av passord';
$string['core.login.changepasswordhelp'] = 'Hvis du har problemer med å endre passordet, kan du kontakte portaladministratoren. "Portaladministratorer" er personene som administrerer Moodle på skolen / universitetet / firmaet eller organisasjonen din. Hvis du ikke vet hvordan du kontakter dem, kan du kontakte lærerne / instruktørene dine.';
$string['core.login.changepasswordinstructions'] = 'Du kan ikke endre passordet ditt i appen. Klikk på følgende knapp for å åpne nettstedet i en nettleser for å endre passordet ditt. Ta hensyn til at du må lukke nettleseren etter at du har endret passordet, da du ikke blir omdirigert til appen.';
$string['core.login.changepasswordlogoutinstructions'] = 'Hvis du ønsker å bytte portal eller logge av, kan du klikke på følgende knapp:';
$string['core.login.changepasswordreconnectinstructions'] = 'Klikk på følgende knapp for å koble til portalen på nytt. (Ta hensyn til at hvis du ikke endret passordet ditt, bør du gå tilbake til forrige skjermbilde).';
$string['core.login.confirmdeletesite'] = 'Er du sikker på at du vil slette portalen {{sitename}}?';
$string['core.login.connect'] = 'Koble!';
$string['core.login.connecttomoodle'] = 'Koble til Moodle';
$string['core.login.connecttomoodleapp'] = 'Du prøver å koble til et vanlig Moodle-nettsted. Last ned den offisielle Moodle-appen for å få tilgang til denne portalen.';
$string['core.login.connecttoworkplaceapp'] = 'Du prøver å koble til en Moodle Workplace-portal. Last ned Moodle Workplace-appen for å få tilgang til denne portalen.';
$string['core.login.contactyouradministrator'] = 'Kontakt portaladministratoren din for ytterligere hjelp.';
$string['core.login.contactyouradministratorissue'] = 'Be portaladministratoren din om å sjekke følgende problem: {{$a}}';
$string['core.login.credentialsdescription'] = 'Vennligst oppgi brukernavn og passord for å logge inn.';
$string['core.login.emailconfirmsentnoemail'] = '<p> En e-post er nå sendt til adressen din. </p> <p> Den inneholder enkle instruksjoner for å fullføre registreringen. </p> <p> Hvis du fortsetter å ha problemer, kan du kontakte nettstedsadministratoren. </p>';
$string['core.login.emailnotmatch'] = 'E-poster stemmer ikke overens';
$string['core.login.erroraccesscontrolalloworigin'] = 'Den opprinnelige samtalen du prøver å utføre, er avvist. Vennligst sjekk https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Det oppstod en feil under sletting av dette nettstedet. Vær så snill, prøv på nytt.';
$string['core.login.errorexampleurl'] = 'URL-en https://campus.example.edu er bare et eksempel på en URL, det er ikke et reelt nettsted. <strong> Bruk nettadressen til skolen eller organisasjonens nettsted. </strong>';
$string['core.login.errorqrnoscheme'] = 'Denne URL-en er ikke gyldig.';
$string['core.login.errorupdatesite'] = 'Det oppstod en feil under oppdatering av portalens token.';
$string['core.login.faqcannotconnectanswer'] = 'Vennligst kontakt din portaladministrator';
$string['core.login.faqcannotconnectquestion'] = 'Jeg har skrevet min portaladresse korrekt, men kan fremdeles ikke koble til.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Har du skrevet navnet riktig? Det er også mulig at portalen din ikke er inkludert i vår katalogen for offentlige nettsteder. Hvis du fortsatt ikke finner den, vennligst skriv inn nettadressen din i stedet.';
$string['core.login.faqcannotfindmysitequestion'] = 'Jeg kan ikke finne portalen min.';
$string['core.login.faqsetupsiteanswer'] = 'Gå til {{$link}} for å sjekke de forskjellige alternativene du har for å lage din egen Moodle-portal.';
$string['core.login.faqsetupsitelinktitle'] = 'Kom i gang.';
$string['core.login.faqsetupsitequestion'] = 'Jeg ønsker å sette opp min egen Moodle-portal.';
$string['core.login.faqtestappanswer'] = 'For å teste appen på et Moodle Demo-nettsted, skriv "lærer" eller "student" i "Ditt nettsted" -feltet og klikk på "Koble til portalen din" -knappen.';
$string['core.login.faqtestappquestion'] = 'Jeg ønsker bare å teste appen, hva kan jeg gjøre?';
$string['core.login.faqwhatisurlanswer'] = '<p> Hver organisasjon har sin egen unike adresse eller URL for Moodle-portalen. For å finne adressen: </p> <ol> <li> Åpne en nettleser og gå til Moodle-portalens påloggingsside. </li> <li> Øverst på siden, i adressefeltet, vil du se URL-en til Moodle-portalen din, f.eks "campus.example.edu". <br> {{$image}} </li> <li> Kopier adressen (ikke kopier / logg inn og hva som kommer etter), lim den inn i Moodle-appen og klikk deretter "Koble til" til portalen din "</li> <li> Nå kan du logge på nettstedet ditt ved hjelp av brukernavn og passord. </li>';
$string['core.login.faqwhatisurlquestion'] = 'Hva er min portal-adresse? Hvordan kan jeg finne URL-en til min portal?';
$string['core.login.faqwhereisqrcode'] = 'Hvor kan jeg finne QR-koden?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p> Hvis organisasjonen din har aktivert den, finner du en QR-kode på nettstedet nederst på brukerprofilsiden din. </p> {{$image}}';
$string['core.login.findyoursite'] = 'Finn din portal';
$string['core.login.helpmelogin'] = '<p> Det er mange tusen Moodle-portaler rundt om i verden. Denne appen kan bare koble til Moodle-portaler som har aktivert tilgang til mobilapper spesifikt. </p> <p> Hvis du ikke kan koble til Moodle-portalen ditt, må du kontakte nettstedsadministratoren din og be dem om å lese <a href = "http://docs.moodle.org/en/Mobile_app" target = "_blank"> http://docs.moodle.org/en/Mobile_app </a> </p> <p> For å teste appen i en Moodle-demo-portal, skriv <i> lærer </i> eller <i> student </i> i <i> Portaladresse </i> -feltet og klikk på <b> Koble til-knappen </b>. </p >';
$string['core.login.invalidaccount'] = 'Vennligst sjekk påloggingsinformasjonen din eller be din portaladministrator om å sjekke portalkonfigurasjonen.';
$string['core.login.invalidmoodleversion'] = '<p>Invalid Moodle site version. The Moodle app only supports Moodle systems {{$a}} onwards.</p>
<p>You can contact your site administrators and ask them to update their Moodle system.</p>
<p>"Site Administrators" are the people who manages the Moodle at your school/university/company or learning organisation. If you don\'t know how to contact them, please contact your teachers/trainers.</p>';
$string['core.settings.about'] = 'Om';
$string['core.user.contact'] = 'Kontakt';
