<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'chat', language 'no', version '4.0'.
 *
 * @package     chat
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har en forestående nettprat';
$string['ajax'] = 'Versjon med Ajax';
$string['autoscroll'] = 'Rull skjermbildet automatisk';
$string['beep'] = 'tut';
$string['bubble'] = 'Boble';
$string['cantlogin'] = 'Kunne ikke logge inn i praterommet!';
$string['chat:addinstance'] = 'Legg til ny nettprat';
$string['chat:chat'] = 'Snakk i praterom';
$string['chat:deletelog'] = 'Slett nettpratloggene';
$string['chat:exportparticipatedsession'] = 'Eksporter prateøkten du deltok i';
$string['chat:exportsession'] = 'Eksporter en prateøkt';
$string['chat:readlog'] = 'Vis nettpratloggene';
$string['chat:talk'] = 'Delta i en nettprat';
$string['chat:view'] = 'Vis chatteaktivitet';
$string['chatintro'] = 'Beskrivelse';
$string['chatname'] = 'Navnet på dette praterommet';
$string['chatreport'] = 'Prateøkter';
$string['chattime'] = 'Neste prat (dato og klokkeslett)';
$string['compact'] = 'Kompakt';
$string['composemessage'] = 'Skriv en melding';
$string['configmethod'] = 'AJAX-chatmetoden gir et AJAX-basert chatgrensesnitt som regelmessig kontakter serveren for oppdateringer. Den normale chat-metoden innebærer at kunder regelmessig kontakter serveren for oppdateringer. Det krever ingen konfigurasjon og fungerer overalt, men kan skape en stor belastning på serveren hvis mange brukere chatter. Å bruke en servertjeneste krever shell-tilgang til Unix, men det resulterer i et raskt skalerbart chat-miljø.';
$string['confignormalupdatemode'] = 'Prateromoppdateringer fungerer fint med <em>Keep-Alive</em> funksjonen i HTTP 1.1, men belaster serveren en god del. En mer avansert metode er å bruke <em>Stream</em> -metoden for å oppdatere den enkelte bruker. Bruk av <em>Stream</em> skalerer mye bedre (tilsvarende chatd-metoden), men støttes kanskje ikke av serveren din.';
$string['configoldping'] = 'Etter hvor lang tid uten å høre fra en bruker skal vi regne han som borte (i sekunder)? Dette er kun en øvre grense, da frakoblinger som oftest merkes veldig fort. Lave verdier er mer krevende for serveren. Hvis du bruker den vanlige metoden, <strong>never</strong> sett denne lavere enn 2 * chat_refresh_room.';
$string['configrefreshroom'] = 'Hvor ofte skal praterommet i seg selv oppdateres (i sekunder). Settes denne lavt virker rommet raskere, men det kan føre til større belastning for serveren når det er mange som prater.';
$string['configrefreshuserlist'] = 'Hvor ofte skal listen over brukere oppdateres (i sekunder)?';
$string['configserverhost'] = 'Vertsnavnet på serveren hvor servertjenesten befinner seg.';
$string['configserverip'] = 'Den numeriske IP-adressen som samsvarer med vertsnavnet over.';
$string['configservermax'] = 'Maks antall samtidige';
$string['configserverport'] = 'Portnummer på serveren for denne tjenesten';
$string['coursetheme'] = 'Kursdesign';
$string['crontask'] = 'Bakgrunnsprosessering for chat-modulen';
$string['currentchats'] = 'Aktive prateøkter';
$string['currentusers'] = 'Nåværende brukere';
$string['deletesession'] = 'Slett denne runden';
$string['deletesessionsure'] = 'Er du sikker på at du vil slette denne praterunden?';
$string['donotusechattime'] = 'Ikke publiser noen tidspunkter for nettprat';
$string['enterchat'] = 'Klikk her for å ta del i nettpraten nå';
$string['entermessage'] = 'Skriv inn din melding';
$string['errornousers'] = 'Fant ingen brukere.';
$string['eventmessagesent'] = 'Melding sent';
$string['eventsessionsviewed'] = 'Åpnede sesjoner';
$string['explaingeneralconfig'] = 'Disse innstillingene er <strong>alltid</strong> aktive.';
$string['explainmethoddaemon'] = 'Disse innstillingene har bare effekt hvis \'Chat servertjeneste\' er valgt som chat-metode.';
$string['explainmethodnormal'] = 'Disse innstillingene har bare effekt hvis Normal er valgt som chat-metode.';
$string['generalconfig'] = 'generelt oppsett';
$string['idle'] = 'Uvirksom';
$string['indicator:cognitivedepth'] = 'Kognitiv prat';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en Chat-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Chat-ferdigheter';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av Chat-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send inn, Se tilbakemelding, Kommenter på tilbakemelding)';
$string['indicator:socialbreadth'] = 'Sosial prat';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en Chat-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Chat-basert sosial aktivitet';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av Chat-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene, deltaker med andre)';
$string['inputarea'] = 'Skriv her';
$string['invalidid'] = 'Fant ikke dette praterommet!';
$string['list_all_sessions'] = 'Vis alle økter.';
$string['list_complete_sessions'] = 'Vis bare avsluttede økter.';
$string['listing_all_sessions'] = 'Viser alle øktene.';
$string['messagebeepseveryone'] = '{$a} tuter til alle!';
$string['messagebeepsyou'] = '{$a} har tutet på deg';
$string['messageenter'] = '{$a} har akkurat kommet';
$string['messageexit'] = '{$a} har forlatt denne nettpraten';
$string['messages'] = 'Beskjeder';
$string['messageyoubeep'] = 'Du pep {$a}';
$string['method'] = 'Nettpratmetode';
$string['methodajax'] = 'AJAX';
$string['methoddaemon'] = 'Chatservertjeneste';
$string['methodnormal'] = 'Normal';
$string['modulename'] = 'Nettprat';
$string['modulename_help'] = 'Nettpratmodulen gjør det mulig for deltakerne å ha tekstbaserte, sanntidssynkrone diskusjoner via Internett.

Nettpraten kan være en engangsaktivitet eller den kan repeteres samme tid hver dag eller hver uke. Prateøkter lagres og kan gjøres tilgjengelig for alle eller så kan tilgjengeligheten begrenses til de brukere med mulighet å se loggede nettpratøkter.

Nettprat er spesielt nyttig når gruppen som prater, ikke har mulighet til å møtes ansikt til ansikt. For eksempel:

* Regelmessige møter mellom studenter som samarbeider på nettbaserte kurs for å gjøre det mulig for dem å dele sine erfaringer med andre i det samme kurset som er på et annet sted
* En student som i en periode ikke har mulighet til å komme på samling i egen person kan prate med læreren for å komme à jour med studiene.
* Studenter som er ute i praksis, kan komme sammen for å diskutere sine erfaringer med hverandre og læreren.
* Barn kan bruke nettprat hjemme om kvelden som en kontrollert introduksjon til sosiale nettverk.
* En økt med spørsmål og svar med en foredragsholder som befinner seg på et annet sted.
* Økter som fokuserer på forberedelser til prøver, der læreren eller andre studenter stiller et utvalg spørsmål.';
$string['modulenameplural'] = 'Praterom';
$string['neverdeletemessages'] = 'Slett aldri meldinger';
$string['nextchattime'] = 'Neste chattetid:';
$string['nextsession'] = 'Neste avtalte prat';
$string['no_complete_sessions_found'] = 'Fant ingen avsluttede økter.';
$string['nochat'] = 'Fant ingen nettprat';
$string['noguests'] = 'Denne nettpraten er ikke åpen for gjester';
$string['nomessages'] = 'Ingen beskjeder ennå';
$string['nopermissiontoseethechatlog'] = 'Du har ikke tillatelse til å se nettpratloggene.';
$string['normalkeepalive'] = 'Hold i live';
$string['normalstream'] = 'Strøm';
$string['noscheduledsession'] = 'Ingen oppsatt økt';
$string['notallowenter'] = 'Du har ikke tillatelse til å delta i denne nettpraten.';
$string['notlogged'] = 'Du er ikke logget inn!';
$string['oldping'] = 'Kobler ut pga. tidsavbrudd';
$string['page-mod-chat-x'] = 'Alle sider i nettpratmodulen';
$string['pastchats'] = 'Tidligere prateøkter';
$string['pastsessions'] = 'Tidligere sesjoner';
$string['pluginadministration'] = 'Administrasjon av nettprat';
$string['pluginname'] = 'Nettprat';
$string['privacy:metadata:chat_messages_current'] = 'Nåværende chattesesjon. Datane er midlertidige og vil slettes når sesjonen er ferdig.';
$string['privacy:metadata:chat_users'] = 'Sporer hvilke brukere som oppholder seg i chatterommene.';
$string['privacy:metadata:chat_users:firstping'] = 'Tidspunkt for første tilgang til chatterommet';
$string['privacy:metadata:chat_users:ip'] = 'Brukers IP';
$string['privacy:metadata:chat_users:lang'] = 'Brukers språk';
$string['privacy:metadata:chat_users:lastmessageping'] = 'Tidsunktet for siste melding i dette chatterommet';
$string['privacy:metadata:chat_users:lastping'] = 'Tidspunkt for siste tilgang til chatterom';
$string['privacy:metadata:chat_users:userid'] = 'BrukerID\'en';
$string['privacy:metadata:chat_users:version'] = 'Hvordan brukeren fikk tilgang til chatten (sockets/basic/ajax/header_js)';
$string['privacy:metadata:messages'] = 'Logger for sendte meldinger under en chattesesjon';
$string['privacy:metadata:messages:issystem'] = 'Om meldingen er en systemgenerert melding';
$string['privacy:metadata:messages:message'] = 'Meldingen';
$string['privacy:metadata:messages:timestamp'] = 'Tidspunktet for når meldingen ble sendt.';
$string['privacy:metadata:messages:userid'] = 'BrukerID\'en til forfatteren av meldingen';
$string['refreshroom'] = 'Oppfrisk rom';
$string['refreshuserlist'] = 'Oppfrisk brukerlista';
$string['removemessages'] = 'Fjern alle beskjeder';
$string['repeatdaily'] = 'Til samme tid hver dag';
$string['repeatnone'] = 'Ingen gjentakelser – publiser bare det angitte tidspunktet';
$string['repeattimes'] = 'Gjenta nettpratrunder';
$string['repeatweekly'] = 'Til samme tid hver uke';
$string['saidto'] = 'sa til';
$string['savemessages'] = 'Lagre gamle praterunder';
$string['search:activity'] = 'Chat - aktivitetsinformasjon';
$string['seesession'] = 'Se denne runden';
$string['send'] = 'Send';
$string['sending'] = 'Sender';
$string['serverhost'] = 'Servernavn';
$string['serverip'] = 'Server-IP';
$string['servermax'] = 'Maks antall brukere';
$string['serverport'] = 'Serverport';
$string['sessions'] = 'Prateøkter';
$string['sessionstart'] = 'Prateøkten vil starte:  {$a->date}, ({$a->fromnow} fra nå)';
$string['sessionstartsin'] = 'Neste pratøkt starter {$a} fra nå.';
$string['strftimemessage'] = '%H:%M';
$string['studentseereports'] = 'Alle kan se tidligere praterunder';
$string['studentseereports_help'] = 'Dersom Nei vil bare brukere med mod/chat:readlog rettigheten kunne lese pratelogger.';
$string['talk'] = 'Snakk';
$string['updatemethod'] = 'Oppdateringsmetode';
$string['updaterate'] = 'Oppdateringsfrekvens:';
$string['userlist'] = 'Brukerliste';
$string['usingchat'] = 'Bruker nettprat';
$string['usingchat_help'] = '<p>
Modulen  chat inneholder noen få funksjoner for å gjøre chattingen litt
triveligere.
</p>
<dl>
<dt><b>Smilefjes: </b>Alle smilefjes (smilies) du kan skrive andre steder i Moodle, kan du også skrive
her. De blir vist som et bilde, f.eks.  :-) = <img src="pix/s/smiley.gif"> </dt>

<dt> </dt>

<dt><b>Lenker: </b>Internettadresser forvandles automatisk til klikkbare lenker. </dt>

<dt> </dt>

<dt><b>Å uttrykke følelser: </b>Du kan starte en linje med "/me" eller ":" for å uttrykke følelser. Hvis du
heter f.eks. Lasse og skriver  ":ler"
eller "/me ler!" så kommer alle til å se "Lasse ler!" i chatten. </dt>

<dt> </dt>

<dt><b>Pipelyd: </b>Du kan sende en lyd til andre ved å klikke på lenken "Tuut" ved siden av navnet
på den du vil pipe til. Du kan også gi lydsignal til alle ved å skrive "beep
all". </dt>

<dt> </dt>

<dt><b>HTML: </b>Om du kan noen HTML-koder, kan du bruke det i teksten til f.eks. å legge til
bilder, spille av lyd eller lage tekst med ulike skrifttyper, farger og
størrelser.</dt>
</dl>';
$string['viewreport'] = 'Vis tidligere prateøkter';
