<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'cs', version '4.0'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Dosažení známky';
$string['achievingpassinggrade'] = 'Dosažení prospěchu';
$string['activities'] = 'Činnosti';
$string['activitiescompleted'] = 'Splněné činnosti';
$string['activitiescompletednote'] = '<b>Poznámka:</b> Aby se aktivita objevila v tomto seznamu, musí mít nastavené podmínky splnění v sekci <i>Plnění činností</i>.';
$string['activitieslabel'] = 'Činnosti / Materiály';
$string['activityaggregation'] = 'Podmínka vyžaduje';
$string['activityaggregation_all'] = 'Všechny vybrané činnosti musí být dokončeny';
$string['activityaggregation_any'] = 'Jakákoli z vybraných činností musí být dokončena';
$string['activitycompletion'] = 'Plnění činností';
$string['activitycompletionupdated'] = 'Změny byly uloženy';
$string['activitygradenotrequired'] = 'Není vyžadováno známkování';
$string['activitygradetopassnotset'] = 'Tato aktivita nemá platnou sadu známek k úspěšnému absolvování. Lze jej nastavit v sekci Grade v nastavení aktivity.';
$string['affectedactivities'] = 'Změny ovlivní následující činnosti/materiály <b>{$a}</b>';
$string['aggregationmethod'] = 'Způsob vyhodnocení podmínek';
$string['all'] = 'Splnění všech podmínek';
$string['any'] = 'Splnění jakékoli podmínky';
$string['approval'] = 'Schválení';
$string['areyousureoverridecompletion'] = 'Opravdu chcete přepsat aktuální stav činnosti tohoto uživatele a označit jej "{$a}"?';
$string['badautocompletion'] = 'Když zvolíte automatické splnění, musíte také povolit alespoň jednu z podmínek níže.';
$string['badcompletiongradeitemnumber'] = 'Vyžadovat známku pro <b> {$a} </b> nelze povolit, protože není povoleno hodnocení podle {$a}.';
$string['bulkactivitycompletion'] = 'Hromadná úprava plnění činností';
$string['bulkactivitydetail'] = 'Vyberte činnosti, které chcete hromadně upravovat.';
$string['bulkcompletiontracking'] = 'Sledování plnění';
$string['bulkcompletiontracking_help'] = '<strong>Nic:</strong> Nezobrazovat splnění činnosti

<strong>Ručně:</strong> Studenti mohou ručně označit činnost jako splněnou

<strong>S podmínkami:</strong> Zobraz činnost jako splněnou, pokud jsou splněny podmínky';
$string['checkactivity'] = 'Zaškrtávací políčko činnosti / materiálu: {$ a}';
$string['checkall'] = 'Vyberte nebo zrušte volbu všech činností a zdrojových materiálů';
$string['checkallsection'] = 'Vyberte nebo zrušte volbu všech činností a zdrojových materiálů v následujících sekcích: {$a}';
$string['completeactivity'] = 'Dokončit aktivitu';
$string['completed'] = 'Splněno';
$string['completedunlocked'] = 'Možnosti splnění odemčeny';
$string['completedunlockedtext'] = 'Po uložení změn dojde ke smazání stavu splnění činností pro všechny studenty. Nechcete-li toto provést, neukládejte formulář.';
$string['completedwarning'] = 'Možnosti splnění uzamčeny';
$string['completedwarningtext'] = 'Tuto činnost již úspěšně splnili někteří studenti ({$a}). Změna možností splnění smaže jejich stav a může způsobit zmatek. Proto byly tyto možnosti uzamčeny a neměly by být odemčeny, pokud to není nezbytně nutné.';
$string['completion'] = 'Sledování plnění';
$string['completion-alt-auto-enabled'] = 'Systém označí položku jako splněnou na základě stavených podmínek: {$a}';
$string['completion-alt-auto-fail'] = 'Dokončeno: {$a} (nebylo dosaženo požadované známky)';
$string['completion-alt-auto-n'] = 'Nedokončeno: {$a}';
$string['completion-alt-auto-n-override'] = 'Nedokončeno: {$a->modname} (nastaveno {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Dokončeno: {$a} (bylo dosaženo požadované známky)';
$string['completion-alt-auto-y'] = 'Dokončeno: {$a}';
$string['completion-alt-auto-y-override'] = 'Dokončeno: {$a->modname} (nastaveno {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Studenti mohou sami označit položku jako splněnou: {$a}';
$string['completion-alt-manual-n'] = 'Nedokončeno: {$a}. Výběrem označíte jako dokončeno.';
$string['completion-alt-manual-n-override'] = 'Nedokončeno: {$a->modname} (nastaveno {$a->overrideuser}). Výběrem označíte  jako dokončeno.';
$string['completion-alt-manual-y'] = 'Dokončeno: {$a}. Výběrem označíte jako nedokončeno.';
$string['completion-alt-manual-y-override'] = 'Dokončeno: {$a->modname} (nastaveno {$a->overrideuser}). Výběrem označíte  jako nedokončeno.';
$string['completion-fail'] = 'Splněno (nedosažena požadovaná známka)';
$string['completion-n'] = 'Nesplněno';
$string['completion-n-override'] = 'Nedokončeno  (nastaveno {$a})';
$string['completion-pass'] = 'Splněno (dosažena požadovaná známka)';
$string['completion-y'] = 'Splněno';
$string['completion-y-override'] = 'Dokončeno  (nastaveno {$a})';
$string['completion_automatic'] = 'Zobraz činnost jako splněnou, pokud jsou splněny podmínky';
$string['completion_help'] = 'Pokud je povoleno, sledování dokončení činnosti se provádí ručně nebo automaticky  v závislosti na nastavených podmínkách. V případě potřeby lze nastavit více podmínek. Pokud ano, bude aktivita považována za dokončenou, pouze pokud jsou splněny VŠECHNY podmínky.';
$string['completion_manual'] = 'Studenti mohou ručně označit činnost jako splněnou';
$string['completion_none'] = 'Nezobrazuj splnění činnosti';
$string['completionactivitydefault'] = 'Použít výchozí nastavení pro danou činnost';
$string['completiondefault'] = 'Výchozí sledování plnění';
$string['completiondisabled'] = 'Zakázáno, nezobrazovat v nastavení činností';
$string['completionduration'] = 'Zápis';
$string['completionenabled'] = 'Povoleno, vizte další nastavení v editovacím formuláři činností';
$string['completionexpected'] = 'Očekávat splnění do';
$string['completionexpected_help'] = 'Toto nastavení určuje orientační datum očekávaného splnění činnosti.  Když se datum blíží, aktivita je uvedena v bloku Časová osa na Nástěnce.';
$string['completionexpecteddesc'] = 'Splnění očekáváno do {$a}';
$string['completionexpectedfor'] = '{$a->instancename} by mělo být dokončeno';
$string['completionicons'] = 'Pole pro označení splnění';
$string['completionicons_help'] = 'Zaškrtávací políčko vedle názvu činnosti ukazuje, zda je daná činnost splněná.

Pokud je políčko orámováno tečkami, bude zaškrtnuto automaticky poté, co splníte všechny podmínky pro splnění, které nadefinoval váš vyučující.

Pokud je políčko orámováno nepřerušovaně, můžete na něj kliknout k ručnímu označení činnosti jako splněné. (Pokud změníte názor, opětovné kliknutí pak vrací stav zpět).';
$string['completionmenuitem'] = 'Absolvování';
$string['completionnotenabled'] = 'Sledování plnění není povoleno';
$string['completionnotenabledforcourse'] = 'Sledování plnění není v tomto kurzu povoleno';
$string['completionnotenabledforsite'] = 'Sledování plnění není na těchto stránkách povoleno';
$string['completionondate'] = 'Datum';
$string['completionondatevalue'] = 'Datum, do kdy bude kurz označen jako splněný';
$string['completionpassgrade'] = 'Vyžadovat splnění požadované známky';
$string['completionpassgrade_desc'] = 'K dokončení této aktivity musí student získat požadovanou známku';
$string['completionpassgrade_help'] = 'Je-li povoleno, je aktivita považována za dokončenou, když student získá požadovanou známku.';
$string['completionsettingslocked'] = 'Možnosti splnění uzamčeny';
$string['completionupdated'] = 'Aktualizováno splnění činnosti <b>{$a}</b>';
$string['completionusegrade'] = 'Požadovat známku';
$string['completionusegrade_desc'] = 'Student musí obdržet nějakou známku pro splnění této činnosti';
$string['completionusegrade_help'] = 'Zda má být činnost považována za splněnou poté, co student obdrží známku. Ikona úspěšného či neúspěšného splnění je zobrazena, pokud je nastavena potřebná známka.';
$string['completionview'] = 'Požadovat zobrazení';
$string['completionview_desc'] = 'Student si musí zobrazit tuto činnost pro její splnění';
$string['configcompletiondefault'] = 'Výchozí nastavení pro sledování plnění při vytváření nových činností.';
$string['configenablecompletion'] = 'Pokud je povoleno, mohou být nastaveny podmínky dokončení kurzu a aktivity. Doporučujeme nastavit podmínky dokončení aktivity tak, aby se smysluplná data zobrazovala uživatelům v přehledu jejich kurzu na Nástěnce.';
$string['confirmselfcompletion'] = 'Potvrdit absolvování kurzu';
$string['courseaggregation'] = 'Podmínka vyžaduje';
$string['courseaggregation_all'] = 'Všechny vybrané kurzy musí být absolvovány';
$string['courseaggregation_any'] = 'Jakýkoli z vybraných kurzů musí být absolvován';
$string['coursealreadycompleted'] = 'Tento kurz jste již absolvovali';
$string['coursecomplete'] = 'Absolvování kurzu';
$string['coursecompleted'] = 'Absolvovaný kurz';
$string['coursecompletedmessage'] = '<p> Gratulujeme !</p> <p> Právě jste absolvovali kurz:  <a href="{$a->courselink}">{$a->coursename}</a>.</p>';
$string['coursecompletion'] = 'Absolvování kurzu';
$string['coursecompletioncondition'] = 'Podmínka: {$a}';
$string['coursecompletionnavigation'] = 'Terciární navigace absolvování kurzu';
$string['coursegrade'] = 'Známka kurzu';
$string['coursesavailable'] = 'Dostupné kurzy';
$string['coursesavailableexplaination'] = '<b>Poznámka:</b> Aby se kurz objevil v tomto seznamu, musí v něm být nadefinovány podmínky jeho absolvování.';
$string['criteria'] = 'Podmínky';
$string['criteriagroup'] = 'Skupina podmínek';
$string['criteriarequiredall'] = 'Všechny podmínky musí být splněny';
$string['criteriarequiredany'] = 'Jakákoli z podmínek musí být splněna';
$string['csvdownload'] = 'Stáhnout v CSV formátu (UTF-8)';
$string['datepassed'] = 'Datum splnění';
$string['days'] = 'Dnů';
$string['daysoftotal'] = '{$a->days} ze {$a->total}';
$string['defaultcompletion'] = 'Výchozí splnění činnosti';
$string['defaultcompletionupdated'] = 'Změny byly uloženy';
$string['deletecompletiondata'] = 'Odstranit data o plnění činností';
$string['dependencies'] = 'Závislosti';
$string['dependenciescompleted'] = 'Splnění jiných kurzů';
$string['detail_desc:receivegrade'] = 'Získat nějakou známku';
$string['detail_desc:receivepassgrade'] = 'Získat požadovanou známku';
$string['detail_desc:view'] = 'Zobrazit';
$string['done'] = 'Hotovo';
$string['editcoursecompletionsettings'] = 'Nastavení podmínek absolvování kurzu';
$string['enablecompletion'] = 'Povolit sledování plnění';
$string['enablecompletion_help'] = 'Pokud je zapnuto, nezapomeňte nastavit sledování plnění na stránce Absolvování kurzu a/nebo v nastavení jednotlivých činností kurzu. Je doporučeno mít povoleno, aby byla v přehledu kurzů na Nástěnce zobrazena smysluplná data.';
$string['enrolmentduration'] = 'Doba zápisu';
$string['enrolmentdurationlength'] = 'Uživatel musí zůstat zapsán po dobu';
$string['err_noactivities'] = 'Sledování informací o plnění není povoleno pro žádnou činnost, takže nelze nic zobrazit. Můžete upravit nastavení nějaké činnosti v kurzu a zapnout sledování plnění.';
$string['err_nocourses'] = 'Sledování informací o absolvování kurzu není povoleno pro žádné jiné kurzy, takže nelze nic zobrazit. Můžete upravit nastavení nějakého kurzu a zapnout možnost jeho absolvování.';
$string['err_nograde'] = 'Tento kurz nemá nastavenu potřebnou známku. Pro použití tohoto typu kriteria musíte nejprve nadefinovat potřebnou známku pro jeho absolvování.';
$string['err_noroles'] = 'V tomto kurzu nebyly nalezeny žádné uživatelské role s pravomocí "moodle/course:markcomplete".';
$string['err_nousers'] = 'V tomto kurzu nejsou žádní studenti nebo skupiny, jimž by bylo možno zobrazit informace o plnění činností a absolvování kurzu.  (Informace o dokončení se zobrazí pouze pro uživatele s funkcí „Zobrazovat se ve zprávách o dokončení“. Tato funkce je povolena pouze pro výchozí roli studenta, takže pokud nejsou studenti, zobrazí se tato zpráva.)';
$string['err_settingslocked'] = 'Jeden nebo více studentů má již splněny dané podmínky, proto bylo nastavení uzamčeno. Odemknutí nastavení odstraní uživatelská data a může uživatele zmást.';
$string['err_system'] = 'Došlo k interní chybě v systému sledování plnění činností a absolvování kurzu. Správci systému mohou zapnout zobrazování ladících informací pro získání detailního popisu chyby.';
$string['eventcoursecompleted'] = 'Kurz absolvován';
$string['eventcoursecompletionupdated'] = 'Aktualizováno nastavení absolvování kurzu';
$string['eventcoursemodulecompletionupdated'] = 'Aktualizováno nastavení splnění činnosti kurzu';
$string['eventdefaultcompletionupdated'] = 'Výchozí nastavení splnění činnosti kurzů bylo aktualizováno';
$string['excelcsvdownload'] = 'Stáhnout ve formátu CSV (kompatibilní s Excelem)';
$string['failed'] = 'Neúspěšné';
$string['fraction'] = 'Zlomek';
$string['graderequired'] = 'Požadovaná známka kurzu';
$string['gradexrequired'] = 'Požadováno {$a}';
$string['hiddenrules'] = 'Některá nastavení specifická pro <b>{$a}</b> jsou skrytá. Chcete-li je zobrazit, zrušte výběr dalších činností';
$string['inprogress'] = 'Probíhá';
$string['manual'] = 'Ručně';
$string['manualcompletionby'] = 'Označení absolvování kurzu jiným uživatelem';
$string['manualcompletionbynote'] = '<b>Poznámka:</b> Aby se role objevila v tomto seznamu, musí mít přiděleno oprávnění <i>Ručně označovat absolvování kurzu</i> (moodle/course:markcomplete).';
$string['manualselfcompletion'] = 'Označení absolvování kurzu samotným studentem';
$string['manualselfcompletionnote'] = '<b>Poznámka:</b> Pokud je tato podmínka povolena, je zároveň potřeba do kurzu přidat blok s názvem <i>Potvrzení absolvování</i>.';
$string['markcomplete'] = 'Označit jako splněné';
$string['markedcompleteby'] = '{$a} musí označit jako splněné';
$string['markingyourselfcomplete'] = 'Student sám musí označit jako splněné';
$string['modifybulkactions'] = 'Upravte akce, které chcete hromadně upravovat';
$string['moredetails'] = 'Více podrobností';
$string['nocriteriaset'] = 'Nebyly nastaveny podmínky pro absolvování tohoto kurzu';
$string['nogradeitem'] = 'Požadovat známky nemůže být pro <b>{$a}</b> povoleno, protože zde nejsou známky k dispozici.';
$string['notcompleted'] = 'Nesplněno';
$string['notenroled'] = 'Nejste zapsáni v tomto kurzu';
$string['nottracked'] = 'Momentálně neprobíhá zaznamenávání vašeho postupu tímto kurzem';
$string['notyetstarted'] = 'Zatím nezačalo';
$string['overallaggregation'] = 'Požadavky na absolvování';
$string['overallaggregation_all'] = 'Kurz je dokončen, když jsou splněny všechny podmínky';
$string['overallaggregation_any'] = 'Kurz je dokončen, když je splněna jakákoli z podmínek';
$string['pending'] = 'Čeká';
$string['periodpostenrolment'] = 'Období po zápisu';
$string['privacy:metadata:completionstate'] = 'Pokud byla činnost dokončena';
$string['privacy:metadata:course'] = 'Identifikátor kurzu';
$string['privacy:metadata:coursecompletedsummary'] = 'Uloží informace o uživatelích, kteří splnili kritéria v kurzu';
$string['privacy:metadata:coursemoduleid'] = 'ID aktivity';
$string['privacy:metadata:coursemodulesummary'] = 'Uloží údaje o dokončení aktivity uživatele';
$string['privacy:metadata:coursesummary'] = 'Uloží údaje o dokončení kurzu uživatele.';
$string['privacy:metadata:gradefinal'] = 'Konečná známka získaná pro absolvování kurzu';
$string['privacy:metadata:overrideby'] = 'ID uživatele osoby, která anulovala dokončení aktivity';
$string['privacy:metadata:reaggregate'] = 'Pokud bylo dokončení kurzu znovu agregováno.';
$string['privacy:metadata:timecompleted'] = 'Čas dokončení kurzu.';
$string['privacy:metadata:timeenrolled'] = 'Čas zápisu uživatele do kurzu';
$string['privacy:metadata:timemodified'] = 'Čas dokončení úpravy aktivity';
$string['privacy:metadata:timestarted'] = 'Čas zahájení kurzu.';
$string['privacy:metadata:unenroled'] = 'Zda byl uživatel vyškrtnut z kurzu';
$string['privacy:metadata:userid'] = 'Uživatelské jméno osoby s údaji o ukončení kurzu a aktivity';
$string['privacy:metadata:viewed'] = 'Pokud byla aktivita zobrazena';
$string['progress'] = 'Pokrok studenta';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Pokrok: {$a->complete} z {$a->total}';
$string['recognitionofpriorlearning'] = 'Uznání předchozího studia';
$string['remainingenroledfortime'] = 'Zůstávají zapsaní v určitém časovém intervalu';
$string['remainingenroleduntildate'] = 'Zůstávají zapsaní do určitého data';
$string['reportpage'] = 'Uživatelé {$a->from} až {$a->to} z {$a->total} celkem.';
$string['requiredcriteria'] = 'Vyžadované podmínky';
$string['resetactivities'] = 'Vyčistěte všechny zvolené činnosti a zdrojové materiály';
$string['restoringcompletiondata'] = 'Zapisují se údaje o plnění';
$string['roleaggregation'] = 'Podmínka vyžaduje';
$string['roleaggregation_all'] = 'Všechny vybrané role musí označit kurz jako absolvovaný';
$string['roleaggregation_any'] = 'Jakákoli z vybraných rolí musí označit kurz jako absolvovaný';
$string['roleidnotfound'] = 'Role s identifikátorem {$a} nebyla nalezena';
$string['saved'] = 'Uloženo';
$string['seedetails'] = 'Podrobnosti';
$string['select'] = 'Vybrat';
$string['self'] = 'Sám uživatel';
$string['selfcompletion'] = 'Absolvování kurzu';
$string['showcompletionconditions'] = 'Zobrazit podmínky dokončení aktivity';
$string['showcompletionconditions_help'] = 'Podmínky dokončení aktivity se vždy zobrazují na stránce aktivity. Toto nastavení určuje, zda jsou podmínky dokončení aktivity také zobrazeny pod každou aktivitou na stránce kurzu.';
$string['showinguser'] = 'Zobrazený uživatel';
$string['todo'] = 'Úkol';
$string['unenrolingfromcourse'] = 'Vyškrtnutí z kurzu';
$string['unenrolment'] = 'Vyškrtnutí z kurzu';
$string['unit'] = 'Jednotka';
$string['unlockcompletion'] = 'Odemknout nastavení plnění';
$string['unlockcompletiondelete'] = 'Odemknou nastavení plnění a odstranit data uživatelů o plnění činností';
$string['updateactivities'] = 'Aktualizovat stav splněných činností';
$string['usealternateselector'] = 'Použít alternativní výběr kurzu';
$string['usernotenroled'] = 'Uživatel není zapsán v tomto kurzu';
$string['viewcoursereport'] = 'Zobrazit přehled kurzu';
$string['viewingactivity'] = 'Zobrazení {$a}';
$string['withconditions'] = 'S podmínkami';
$string['writingcompletiondata'] = 'Zapisují se údaje o plnění';
$string['xdays'] = '{$a} dní';
$string['yourprogress'] = 'Váš pokrok';
