<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'ro', version '4.0'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Adăugare rol nou';
$string['addrole'] = 'Adaugă un nou rol';
$string['advancedoverride'] = 'Suprascriere avansată a rolului';
$string['allow'] = 'Permite';
$string['allowassign'] = 'Permite asocierea de roluri';
$string['allowed'] = 'Permis';
$string['allowoverride'] = 'Permite suprascrierea rolurilor';
$string['allowroletoassign'] = 'Permiteți utilizatorilor cu rolul {$a->fromrole} să atribuie rolul {$a->targetrole}';
$string['allowroletooverride'] = 'Permiteți utilizatorilor cu rolul {$a->fromrole} să suprascrie rolul {$a->targetrole}';
$string['allowroletoswitch'] = 'Permiteți utilizatorilor cu rolul {$a->fromrole} să treacă la rolul {$a->targetrole}';
$string['allowroletoview'] = 'Permite utilizatorilor cu rolul {$a->fromrole} să vizualizeze rolul {$a->targetrole}';
$string['allowswitch'] = 'Permite schimbarea rolurilor';
$string['allowview'] = 'Permiteți rolului să vizualizeze';
$string['allsiteusers'] = 'Toți utilizatorii sit-ului';
$string['analytics:listinsights'] = 'Listează statistici';
$string['analytics:listowninsights'] = 'Enumerați propriile informații statistice';
$string['analytics:managemodels'] = 'Gestionați modelele';
$string['archetype'] = 'Arhetip rol';
$string['archetype_help'] = 'Rolul arhetip determină permisiunile atunci când un rol este resetat la valorile implicite .Determină, de asemenea, noi permisiuni ale rolului atunci când site-ul este actualizat.';
$string['archetypecoursecreator'] = 'ARHETIP: Creator curs';
$string['archetypeeditingteacher'] = 'ARHETIP: Profesor (editare)';
$string['archetypefrontpage'] = 'ARHETIP: Utilizatori autentificați pe pagina principală';
$string['archetypeguest'] = 'ARHETIP: Vizitator';
$string['archetypemanager'] = 'ARHETIP: Administrator';
$string['archetypestudent'] = 'ARHETIP: Student';
$string['archetypeteacher'] = 'ARHETIP: Profesor (fără editare)';
$string['archetypeuser'] = 'ARHETIP: Utilizator autentificat';
$string['assignanotherrole'] = 'Alocare alt rol';
$string['assignedroles'] = 'Roluri alocate';
$string['assignerror'] = 'A apărut o eroare în timp ce se asigna rolul {$a->role} utilizatorului {$a->user}.';
$string['assignglobalroles'] = 'Asociază roluri de sistem';
$string['assignmentcontext'] = 'Context temă';
$string['assignmentoptions'] = 'Opțiuni temă';
$string['assignrole'] = 'Alocare rol';
$string['assignrolenameincontext'] = 'Alocare rol  \'{$a->role}\' în {$a->context}';
$string['assignroles'] = 'Asociază roluri';
$string['assignroles_help'] = 'Prin asignarea unui rol unui utilizator într-un context, îi oferiți persmiunile conținute de acel rol pentru contextul actual și toate celelalte inferioare. De exemplu, dacă un user este asignat cu rolul de student la un curs, va avea, de asemenea, rolul de student pentru toate activitățile și block-urile din curs.';
$string['assignrolesin'] = 'Asociază roluri în {$a}';
$string['assignrolesrelativetothisuser'] = 'Asignează roluri  acestui utilizator';
$string['backtoallroles'] = 'Înapoi la lista cu toate rolurile';
$string['backup:anonymise'] = 'Anonimizează datele utilizatorului la backup';
$string['backup:backupactivity'] = 'Activități de backup';
$string['backup:backupcourse'] = 'Backup cursuri';
$string['backup:backupsection'] = 'Backup secțiuni';
$string['backup:backuptargetimport'] = 'Backup pentru import';
$string['backup:configure'] = 'Configurare opțiuni backup';
$string['backup:downloadfile'] = 'Descărcare fișiere din zona de backup';
$string['backup:userinfo'] = 'Creează o copie de rezervă pentru informaţiile despre utilizator';
$string['badges:awardbadge'] = 'Acordă ecuson utilizatorului';
$string['badges:configurecriteria'] = 'Configurează/editează criteriile pentru câștigarea unui ecuson';
$string['badges:configuredetails'] = 'Configurare/editare detalii ecuson';
$string['badges:configuremessages'] = 'Configurează mesajele ecusoanelor';
$string['badges:createbadge'] = 'Creează/multiplică ecusoane';
$string['badges:deletebadge'] = 'Șterge ecusoane';
$string['badges:earnbadge'] = 'Câștigă ecusoane';
$string['badges:manageglobalsettings'] = 'Administrează setările generale ale etichetelor';
$string['badges:manageownbadges'] = 'Vizualizează și gestionează ecusoanele proprii obținute';
$string['badges:revokebadge'] = 'Revocă ecusonul unui utilizator';
$string['badges:viewawarded'] = 'Vezi utilizatorii care au câștigat un anume ecuson fără a putea să acorde un ecuson';
$string['badges:viewbadges'] = 'Vezi ecusoanele disponibile fără a le câștiga';
$string['badges:viewotherbadges'] = 'Vezi ecusoanele publice din profilurile altor utilizatori';
$string['block:edit'] = 'Editare setările unui block';
$string['block:view'] = 'Vezi block';
$string['blog:create'] = 'Creare articol nou';
$string['blog:manageentries'] = 'Modificare și gestionare articole';
$string['blog:manageexternal'] = 'Editează și gestionează bloguri externe';
$string['blog:search'] = 'Căutare postări blog';
$string['blog:view'] = 'Vizualizare articole blog';
$string['blog:viewdrafts'] = 'Vizualizare ciorne blog';
$string['calendar:manageentries'] = 'Administrare articole calendar';
$string['calendar:managegroupentries'] = 'Administrare articole calendar pentru grup';
$string['calendar:manageownentries'] = 'Administrare articole calendar în nume propriu';
$string['capabilities'] = 'Capacităţi';
$string['capability'] = 'Capacitate';
$string['category:create'] = 'Creare categori';
$string['category:delete'] = 'Ștergere categori';
$string['category:manage'] = 'Administrare categorii';
$string['category:update'] = 'Actualizează categorii';
$string['category:viewcourselist'] = 'Vedeți categoria de curs și cursurile din cadrul acesteia';
$string['category:viewhiddencategories'] = 'Afişează categorii ascunse';
$string['category:visibility'] = 'Afişează categorii ascunse';
$string['checkglobalpermissions'] = 'Verificare permisiuni sistem';
$string['checkpermissions'] = 'Verificare permisiuni';
$string['checkpermissionsin'] = 'Verificare permisiuni în {$a}';
$string['checksystempermissionsfor'] = 'Verificare permisiuni sistem pentru {$a->fullname}';
$string['checkuserspermissionshere'] = 'Verificare permisiuni pentru {$a->fullname} în {$a->contextlevel}';
$string['chooseroletoassign'] = 'Te rog alege un rol de alocat';
$string['cohort:assign'] = 'Adăugare și ștergere membrii cohortă';
$string['cohort:manage'] = 'Creare, ștergere și mutare cohorte';
$string['cohort:view'] = 'Vizualizare cohorte la nivel de site';
$string['comment:delete'] = 'Ștergere comentarii';
$string['comment:post'] = 'Postare comentarii';
$string['comment:view'] = 'Vezi comentariile';
$string['competency:competencygrade'] = 'Setați evaluările de competență';
$string['competency:competencymanage'] = 'Administrarea cadrelor de competență';
$string['competency:competencyview'] = 'Vizualizarea cadrelor de competență';
$string['competency:coursecompetencyconfigure'] = 'Configurează setările competențelor cursului';
$string['competency:coursecompetencygradable'] = 'Primiți note de competență';
$string['competency:coursecompetencymanage'] = 'Administrarea competențelor cursului';
$string['competency:coursecompetencyview'] = 'Vezi competențele cursului';
$string['competency:evidencedelete'] = 'Ștergeți dovezile';
$string['competency:plancomment'] = 'Comentați la un plan de învățare';
$string['competency:plancommentown'] = 'Comentați la propriul plan de învățare';
$string['competency:planmanage'] = 'Administrați planurile de învățare';
$string['competency:planmanagedraft'] = 'Administrați draft-urile planurilor de învățare';
$string['competency:planmanageown'] = 'Administrați planurile de învățare proprii';
$string['competency:planmanageowndraft'] = 'Administrați propriile draft-uri ale planurilor de învățare';
$string['competency:planrequestreview'] = 'Solicitați analiza unui plan de învățare';
$string['competency:planrequestreviewown'] = 'Solicitați analiza propriului plan de învățare';
$string['competency:planreview'] = 'Analizați un plan de învățare';
$string['competency:planview'] = 'Vezi toate planurile de învățare';
$string['competency:planviewdraft'] = 'Vezi draft-ul planurilor de învățare';
$string['competency:planviewown'] = 'Vezi planurile de învățare proprii';
$string['competency:planviewowndraft'] = 'Vezi propriul draft al planurilor de învățare';
$string['competency:templatemanage'] = 'Administrați șabloanele planului de învățare';
$string['competency:templateview'] = 'Vezi șabloanele planului de învățare';
$string['competency:usercompetencycomment'] = 'Comentați la competența unui utilizator';
$string['competency:usercompetencycommentown'] = 'Solicitați analiza competenței unui utilizator';
$string['competency:usercompetencyrequestreview'] = 'Solicitați revizuirea competenței utilizatorului';
$string['competency:usercompetencyrequestreviewown'] = 'Solicitați revizuirea competenței propriului utilizator';
$string['competency:usercompetencyreview'] = 'Analizați competența unui utilizator';
$string['competency:usercompetencyview'] = 'Vizualizați competența unui utilizator';
$string['competency:userevidencemanage'] = 'Gestionați dovezile învățării anterioare';
$string['competency:userevidencemanageown'] = 'Gestionați propriile dovezi ale învățării anterioare';
$string['competency:userevidenceview'] = 'Vizualizați dovezi ale învățării anterioare a unui utilizator';
$string['confirmaddadmin'] = 'Sunteți sigur(ă) că doriți să adăugați utilizatorul <strong>{$a}</strong> ca nou admin al site-ului?';
$string['confirmdeladmin'] = 'Sunteți sigur(ă) că doriți să eliminați utilizatorul <strong>{$a}</strong> din lista de admini ai site-ului ?';
$string['confirmroleprevent'] = 'Sunteți sigur(ă) că doriți să eliminați <strong>"{$a->role}"</strong> din lista rolurilor permise pentru capabilitatea "{$a->cap}" în contextul "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Sunteți sigur(ă) că doriți să eliminați <strong>"{$a->role}"</strong> din lista rolurilor interzise pentru capabilitatea "{$a->cap}" în contextul "{$a->context}"?';
$string['confirmunassign'] = 'Sunteți sigur că  doriți să îi retrageți acest rol utilizatorului?';
$string['confirmunassignno'] = 'Anulare';
$string['confirmunassigntitle'] = 'Confirmare schimbare rol';
$string['confirmunassignyes'] = 'Scoatere';
$string['contentbank:access'] = 'Accesează banca de conținut';
$string['contentbank:deleteanycontent'] = 'Șterge orice conținut din banca de conținut';
$string['contentbank:deleteowncontent'] = 'Șterge conținut din propria bancă de conținut';
$string['contentbank:downloadcontent'] = 'Descarcă conținut din banca de conținut';
$string['contentbank:manageanycontent'] = 'Gestionați orice conținut din banca de conținut';
$string['contentbank:manageowncontent'] = 'Gestionați conținutul din propria bancă de conținut';
$string['contentbank:upload'] = 'Încarcă conținut nou în banca de conținut';
$string['contentbank:useeditor'] = 'Creează sau editează conținut utilizând un editor de tipuri de conținut';
$string['contentbank:viewunlistedcontent'] = 'Vezi conținutul neafișat din banca de conținut';
$string['context'] = 'Context';
$string['contextrolenotallowed'] = 'Rol <b>{$a}</b> nu e permis în acest context.';
$string['course:activityvisibility'] = 'Ascunde/afişează activităţi';
$string['course:bulkmessaging'] = 'Trimite un mesaj la mai multe persoane';
$string['course:changecategory'] = 'Schimbă categoria cursului';
$string['course:changefullname'] = 'Modificare nume curs';
$string['course:changeidnumber'] = 'Schimbă nr ID al cursului';
$string['course:changelockedcustomfields'] = 'Schimbă câmpurile personalizate blocate';
$string['course:changeshortname'] = 'Schimbă numele prescurtat al cursului';
$string['course:changesummary'] = 'Schimbă rezumat curs';
$string['course:configurecustomfields'] = 'Configurează câmpuri personalizate';
$string['course:configuredownloadcontent'] = 'Configurează descărcarea conținutului cursului';
$string['course:create'] = 'Creare cursuri';
$string['course:creategroupconversations'] = 'Creați conversații de grup';
$string['course:delete'] = 'Ștergere cursuri';
$string['course:downloadcoursecontent'] = 'Descarcă conținutul cursului';
$string['course:enrolconfig'] = 'Configurați exemplele de înrolare în cursuri';
$string['course:enrolreview'] = 'Revizuire înscrieri curs';
$string['course:ignoreavailabilityrestrictions'] = 'Ignorați restricțiile de disponibilitate';
$string['course:ignorefilesizelimits'] = 'Utilizați fișiere mai mari decât orice restricții de mărime a fișierului';
$string['course:isincompletionreports'] = 'De a fi afișate pe rapoartele de completare';
$string['course:manageactivities'] = 'Administrare activităţi';
$string['course:managefiles'] = 'Administrare fişiere';
$string['course:managegrades'] = 'Administrare note';
$string['course:managegroups'] = 'Administrare grupuri';
$string['course:managescales'] = 'Administrare scări';
$string['course:markcomplete'] = 'Setați utilzatorii ca fiind complet în finalizarea cursului';
$string['course:movesections'] = 'Mută secțiuni';
$string['course:overridecompletion'] = 'Anulați starea de finalizare a activității';
$string['course:recommendactivity'] = 'Recomandați activități în selectorul de activități';
$string['course:renameroles'] = 'Redenumiți rolurile';
$string['course:request'] = 'Solicitare cursuri noi';
$string['course:reset'] = 'Resetare curs';
$string['course:reviewotherusers'] = 'Examinați alți utilizatori';
$string['course:sectionvisibility'] = 'Controlează vizibilitate secţiune';
$string['course:setcurrentsection'] = 'Setează secţinea curentă';
$string['course:setforcedlanguage'] = 'Limba de curs forțată';
$string['course:tag'] = 'Schimbați tag-urile cursului';
$string['course:togglecompletion'] = 'Setați manual activitățile ca fiind completate';
$string['course:update'] = 'Actualizează setări curs';
$string['course:useremail'] = 'Activează/dezactivează adresă de email';
$string['course:view'] = 'Vezi cursuri fără participarea';
$string['course:viewcoursegrades'] = 'Afişează note cursuri';
$string['course:viewhiddenactivities'] = 'Afişează activităţi ascunse';
$string['course:viewhiddencourses'] = 'Afişează cursuri ascunse';
$string['course:viewhiddensections'] = 'Afişează secţiuni ascunse';
$string['course:viewhiddenuserfields'] = 'Afişează câmpuri utilizator ascunse';
$string['course:viewparticipants'] = 'Afişează participanţi';
$string['course:viewscales'] = 'Afişează scări';
$string['course:viewsuspendedusers'] = 'Vizualizare utilizatori suspendați';
$string['course:visibility'] = 'Ascunde/afişează cursuri';
$string['createrolebycopying'] = 'Creare rol nou prin copierea {$a}';
$string['createthisrole'] = 'Creare rol';
$string['currentcontext'] = 'Context curent';
$string['currentrole'] = 'Rol curent';
$string['customroledescription'] = 'Descriere particularizată';
$string['customroledescription_help'] = 'Descrierile rolurilor standard sunt localizate în mod automat în cazul în care descrierea personalizată este necompletată.';
$string['customrolename'] = 'Personalizează numele complet';
$string['customrolename_help'] = 'Numele rolurilor standard sunt localizate în mod automat în cazul în care numele particularizat este necompletat. Trebuie să furnizați un nume complet pentru toate rolurile personalizate.';
$string['defaultrole'] = 'Rol implicit';
$string['defaultx'] = 'Implicit: {$a}';
$string['defineroles'] = 'Definește roluri';
$string['deletecourseoverrides'] = 'Ștergere toate suprascrierile din curs';
$string['deletelocalroles'] = 'Şterge toate rolurile atribuite la nivel local';
$string['deleterolesure'] = 'Sunteţi sigur(ă) că doriţi ştergerea rolului "{$a->name} ({$a->shortname})"?</p><p>În prezent acest rol este deţinut de {$a->count} utilizatori.';
$string['deletexrole'] = 'Ștergere rol  {$a}';
$string['duplicaterole'] = 'Duplică rolul';
$string['duplicaterolesure'] = '<p>Sunteţi sigur că doriţi duplicarea rolului "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Editare rol {$a}';
$string['editrole'] = 'Modifică rol';
$string['editxrole'] = 'Editare rol {$a}';
$string['errorbadrolename'] = 'Nume rol incorect';
$string['errorbadroleshortname'] = 'Nume scurt rol incorect';
$string['errorexistsrolename'] = 'Există deja un rol cu acest nume';
$string['errorexistsroleshortname'] = 'Există deja un rol cu acest nume';
$string['errorroleshortnametoolong'] = 'Numele prescurtat nu trebuie să depășească 100 de caractere';
$string['eventcapabilityassigned'] = 'Capabilitate asignată';
$string['eventcapabilityunassigned'] = 'Capacitate neatribuită';
$string['eventroleallowassignupdated'] = 'Permite atribuirea rolului';
$string['eventroleallowoverrideupdated'] = 'Permite suprascrierea rolului';
$string['eventroleallowswitchupdated'] = 'Permite comutarea rolului';
$string['eventroleallowviewupdated'] = 'Permiteți vizualizarea rolului';
$string['eventroleassigned'] = 'Rol asignat';
$string['eventrolecapabilitiesupdated'] = 'Capabilitățile rolului actualizate';
$string['eventroledeleted'] = 'Rol șters';
$string['eventroleunassigned'] = 'Rol neatribuit';
$string['eventroleupdated'] = 'Rol actualizat';
$string['existingadmins'] = 'Administratori site în prezent';
$string['existingusers'] = '{$a} utilizatori existenţi';
$string['explanation'] = 'Explicație';
$string['export'] = 'Export';
$string['extusers'] = 'Utilizatori existenți';
$string['extusersmatching'] = 'Utilizatori existenți care se potrivesc cu \'{$a}\'';
$string['filter:manage'] = 'Administrare setări filtru local';
$string['frontpageuser'] = 'Utilizator autentificat pe pagina principală';
$string['frontpageuserdescription'] = 'Toți utilizatorii autentificați pe prima pagină a cursului.';
$string['globalrole'] = 'Rol de sistem';
$string['globalroleswarning'] = 'Avertisment: toate rolurile pe care le atribuiți de pe această pagină se vor aplica utilizatorilor din întregul sistem, inclusiv site-ul de pornire și toate cursurile.';
$string['gotoassignroles'] = 'Mergi la rolurile asignate pentru acest {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Mergi la sistemul de asignare a rolurilor';
$string['grade:edit'] = 'Modifică note';
$string['grade:export'] = 'Exportă note';
$string['grade:hide'] = 'Ascunde/Afişează note sau elemente';
$string['grade:import'] = 'Importă note';
$string['grade:lock'] = 'Blochează note sau elemente';
$string['grade:manage'] = 'Administrare elemente note';
$string['grade:managegradingforms'] = 'Administrează metodele avansate de notare';
$string['grade:manageletters'] = 'Administrează note sub formă de litere';
$string['grade:manageoutcomes'] = 'Administrare note finale';
$string['grade:managesharedforms'] = 'Administrați notarea avansată din șabloane';
$string['grade:override'] = 'Anulează note';
$string['grade:sharegradingforms'] = 'Distribuiți formularul complex de notare sub formă de șablon';
$string['grade:unlock'] = 'Deblochează note sau elemente';
$string['grade:view'] = 'Vizualizare note proprii';
$string['grade:viewall'] = 'Vizualizare note ale altor utilizatori';
$string['grade:viewhidden'] = 'Vezi notele ascunse ale utilizatorului';
$string['h5p:deploy'] = 'Implementați conținut H5P';
$string['h5p:setdisplayoptions'] = 'Setați opțiunile de afișare H5P';
$string['h5p:updatelibraries'] = 'Gestionați tipurile de conținut H5P';
$string['highlightedcellsshowdefault'] = 'Permisiunile evidențiate în tabelul de mai jos sunt valorile implicite pentru arhetipul de rol selectat în prezent mai sus.';
$string['highlightedcellsshowinherit'] = 'Celulele evidențiate din tabelul de mai jos afișează permisiunea (dacă există), care va fi moștenită. În afară de capabilitățile a căror permisiune doriți să o modificați, ar trebui să setați moștenirea completă.';
$string['inactiveformorethan'] = 'inactiv timp de mai mult de {$a->timeperiod}';
$string['ingroup'] = 'în grupul "{$a->group}"';
$string['inherit'] = 'Moștenește';
$string['invalidpresetfile'] = 'Fișier de definire a rolului nevalid';
$string['legacy:admin'] = 'ROL MOŞTENIT: Administrator';
$string['legacy:coursecreator'] = 'ROL MOŞTENIT: Creator curs';
$string['legacy:editingteacher'] = 'ROL MOŞTENIT: Profesor (modificare)';
$string['legacy:guest'] = 'ROL MOŞTENIT: Vizitator';
$string['legacy:student'] = 'ROL MOŞTENIT: Cursant';
$string['legacy:teacher'] = 'ROL MOŞTENIT: Profesor (fără drept de modificare)';
$string['legacy:user'] = 'ROL MOŞTENIT: Utilizator autentificat';
$string['legacytype'] = 'Tip rol moştenit';
$string['listallroles'] = 'Listează toate rolurile';
$string['localroles'] = 'Roluri atribuite local';
$string['mainadmin'] = 'Administrator principal';
$string['mainadminset'] = 'Stabilire administrator principal';
$string['manageadmins'] = 'Gestionare administratori site';
$string['manager'] = 'Administrator';
$string['managerdescription'] = 'Managerii pot accesa cursurile și le pot modifica, de obicei nu participă la cursuri.';
$string['manageroles'] = 'Administrează roluri';
$string['maybeassignedin'] = 'Tipurile de context unde acest rol poate fi asignat';
$string['morethan'] = 'Mai mult de {$a}';
$string['multipleroles'] = 'Roluri multiple';
$string['my:configsyspages'] = 'Configurați sabloanele sistemului pentru paginile Dashboard';
$string['my:manageblocks'] = 'Gestionați blocurile de pagina tabloului de bord';
$string['neededroles'] = 'Roluri cu permisiune';
$string['nocapabilitiesincontext'] = 'În acest context nu este disponibilă nicio permisiune';
$string['noneinthisx'] = 'Nimic în acest {$a}';
$string['noneinthisxmatching'] = 'Niciun utilizator găsit \'{$a->search}\'  în acest {$a->contexttype}';
$string['norole'] = 'Fără rol';
$string['noroleassignments'] = 'Acest utilizator nu are niciun rol asignat în acest site.';
$string['noroles'] = 'Nu există roluri';
$string['notabletoassignroleshere'] = 'Atribuirea de roluri în acest context nu a fost activată de către administrator.';
$string['notabletooverrideroleshere'] = 'Nu aveți permisiunea să suprascrieți niciun rol aici';
$string['notes:manage'] = 'Administrează notițe';
$string['notes:view'] = 'Vezi notițe';
$string['notset'] = 'Nu a fost setat';
$string['novisibleroles'] = 'Fără roluri';
$string['overrideanotherrole'] = 'Suprascriere alt rol';
$string['overridecontext'] = 'Suprascriere context';
$string['overridepermissions'] = 'Suprascrie permisiuni';
$string['overridepermissions_help'] = 'Suprascrierea permisiunea activează capabilitățile selectate pentru a fi permise sau prevenite într-un anumit context.';
$string['overridepermissionsforrole'] = 'Suprascrie permisiunea pentru rolul \'{$a->role}\' în {$a->context}';
$string['overridepermissionsin'] = 'Suprascrie permisiuni în {$a}';
$string['overrideroles'] = 'Suprascrie roluri';
$string['overriderolesin'] = 'Suprascrie roluri în {$a}';
$string['overrides'] = 'Suprascrie';
$string['overridesbycontext'] = 'Suprascrieri (prin context)';
$string['payment:manageaccounts'] = 'Administrează conturile';
$string['payment:viewpayments'] = 'Vezi plățile';
$string['permission'] = 'Permisiune';
$string['permission_help'] = 'Permisiunile sunt setări ale capabilităților. Există 4 opțiuni:

* Nu este setat
* Permis - Se acordă permisiunea pentru capabilitate
* Nepermis - Permisiunea este eliminată din capabilitate, chiar dacă este permisă într-un context mai larg
* Interzisă - Permisiunea este complet blocată si nu poate fi suprascrisă în orice context inferior (mai specific)';
$string['permissions'] = 'Permisiuni';
$string['permissionsforuser'] = 'Permisiuni pentru utilizatorul {$a}';
$string['permissionsincontext'] = 'Permisiuni în {$a}';
$string['portfolio:export'] = 'Export către portofolii';
$string['potentialusers'] = '{$a} utilizatori potenţiali';
$string['potusers'] = 'Utilizatori potențiali';
$string['potusersmatching'] = 'Potențiali utilizatori care corespund \'{$a}\'';
$string['prevent'] = 'Împiedică';
$string['privacy:metadata:preference:showadvanced'] = 'Acționați butonul de comutare a modului avansat.';
$string['privacy:metadata:role_assignments'] = 'Atribuiri de roluri';
$string['privacy:metadata:role_assignments:component'] = 'Plugin responsabil pentru atribuirea rolurilor, gol când este atribuit manual.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID-ul instanței de înscriere / autentificare responsabilă cu această atribuire de roluri';
$string['privacy:metadata:role_assignments:modifierid'] = 'Identificatorul utilizatorului care a creat sau a modificat atribuirea rolului';
$string['privacy:metadata:role_assignments:roleid'] = 'ID-ul rolului';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Acest tabel stochează rolurile atribuite în fiecare context.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Data la care a fost creată sau modificată atribuirea rolului.';
$string['privacy:metadata:role_assignments:userid'] = 'Id-ul utilizatorului';
$string['privacy:metadata:role_capabilities'] = 'Capacități de rol';
$string['privacy:metadata:role_capabilities:capability'] = 'Denumirea capabilității.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Identificatorul utilizatorului care a creat sau a modificat capabilitatea';
$string['privacy:metadata:role_capabilities:permission'] = 'Permisiunea pentru o capacitate: moșteni, permite, preveni sau interzice.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID-ul rolului';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Capacitățile și capacitățile de suprascriere pentru un anumit rol într-un anumit context';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Data la care a fost creată sau modificată capacitatea.';
$string['privacy:metadata:role_cohortroles'] = 'Roluri de cohortă';
$string['prohibit'] = 'Interzice';
$string['prohibitedroles'] = 'Interzis';
$string['question:add'] = 'Adaugă întrebări noi';
$string['question:commentall'] = 'Comentați la toate întrebările';
$string['question:commentmine'] = 'Comentați la propriile dumneavoastră întrebări';
$string['question:config'] = 'Configurează tipuri întrebări';
$string['question:editall'] = 'Modifică toate întrebările';
$string['question:editmine'] = 'Modifică propriile întrebări';
$string['question:flag'] = 'Evidențierea întrebărilor în timp ce se oferă răspuns';
$string['question:managecategory'] = 'Editează categorii întrebări';
$string['question:moveall'] = 'Mută toate întrebările';
$string['question:movemine'] = 'Mută doar întrebările proprii';
$string['question:tagall'] = 'Etichetați toate întrebările';
$string['question:tagmine'] = 'Etichetați-vă propriile întrebări';
$string['question:useall'] = 'Foloseşte toate întrebările';
$string['question:usemine'] = 'Foloseşte întrebările proprii';
$string['question:viewall'] = 'Afişează toate întrebările';
$string['question:viewmine'] = 'Afişează toate întrebările proprii';
$string['rating:rate'] = 'Adaugare evaluări la elementele';
$string['rating:view'] = 'Vezi nota totală primită';
$string['rating:viewall'] = 'Vezi toate rating-urile primite';
$string['rating:viewany'] = 'Vezi toate notele primite de toți cursanții';
$string['reportbuilder:edit'] = 'Editează-ți propriile rapoarte personalizate';
$string['reportbuilder:editall'] = 'Editează toate rapoartele personalizate';
$string['reportbuilder:scheduleviewas'] = 'Programați rapoartele să fie vizualizate ca alți utilizatori';
$string['reportbuilder:view'] = 'Vezi rapoartele personalizate';
$string['resetrole'] = 'Resetare';
$string['resettingrole'] = 'Resetează rol \'{$a}\'';
$string['restore:configure'] = 'Configurare opțiuni restaurare';
$string['restore:createuser'] = 'Creare utilizatori la restaurare';
$string['restore:restoreactivity'] = 'Restaurare activități';
$string['restore:restorecourse'] = 'Restaurare cursuri';
$string['restore:restoresection'] = 'Restaurare secțiuni';
$string['restore:restoretargetimport'] = 'Restaurați din fișierele direcționate ca import';
$string['restore:rolldates'] = 'Permite trecerea datele de configurare a activității la restaurare';
$string['restore:uploadfile'] = 'Încărcați fișiere în zona de backup';
$string['restore:userinfo'] = 'Restaurare date utilizator';
$string['restore:viewautomatedfilearea'] = 'Restabiliți cursurile din copiile de rezervă automate';
$string['risks'] = 'Riscuri';
$string['role:assign'] = 'Atribuie roluri utilizatorilor';
$string['role:manage'] = 'Creează şi administrează roluri';
$string['role:override'] = 'Anulează permisiuni pentru alţii';
$string['role:review'] = 'Revizuirea permisiunii pentru alții';
$string['role:safeoverride'] = 'Suprascrieți permisiunle de securitate pentu alții';
$string['role:switchroles'] = 'Trecere la alte roluri';
$string['roleallowheader'] = 'Permite rol:';
$string['roleallowinfo'] = 'Selectează un rol pentru a fi adăugat pe lista rolurilor permise în context"{$a->context}", capability "{$a->cap}":';
$string['roleassignments'] = 'Atribuire roluri';
$string['roledefinitions'] = 'Definiții rol';
$string['rolefullname'] = 'Nume';
$string['roleincontext'] = '{$a->role} în {$a->context}';
$string['roleprohibitheader'] = 'Interzicere rol';
$string['roleprohibitinfo'] = 'Selectează un rol pentru a fi adăugat pe lista rolurilor interzise în context "{$a->context}", capability "{$a->cap}":';
$string['rolerepreset'] = 'Utilizați rolul presetat';
$string['roleresetdefaults'] = 'Implicite';
$string['roleresetrole'] = 'Utilizează rol sau arhetip';
$string['rolerisks'] = 'Riscuri ale rolurilor';
$string['roles'] = 'Roluri';
$string['roles_help'] = 'Un rol este o colecție de permisiuni definite pentru întregul sistem pe care le puteți atribui anumitor utilizatori în contexte specifice.';
$string['roleselect'] = 'Selectare rol';
$string['rolesforuser'] = 'Rol pentru utilizator {$a}';
$string['roleshortname'] = 'Nume prescurtat';
$string['roleshortname_help'] = 'Numele scurt al rolului este un identificator de rol de nivel scăzut în care sunt permise numai caracterele alfanumerice ASCII.';
$string['roletoassign'] = 'Rol de atribuit';
$string['roletooverride'] = 'Rolul care este anulat';
$string['safeoverridenotice'] = 'Notă: Capabilitățile cu riscuri mai mari sunt blocate deoarece vă este permis să suprascrieți doar capabilitățile sigure.';
$string['search:query'] = 'Căutare globală în site';
$string['selectanotheruser'] = 'Selectare alt utilizator';
$string['selectauser'] = 'Selectare utilizator';
$string['selectrole'] = 'Selectaţi un rol';
$string['showallroles'] = 'Afişează toate rolurile';
$string['showthisuserspermissions'] = 'Arată permisiunile acestui utilizator';
$string['site:accessallgroups'] = 'Accesează toate grupurile';
$string['site:approvecourse'] = 'Aprobă crearea de cursuri';
$string['site:backup'] = 'Creează copii de siguranţă cursuri';
$string['site:config'] = 'Schimbă configurare site';
$string['site:configview'] = 'Vizualizați arborele de administrare a site-ului (dar nu toate paginile din acesta)';
$string['site:deleteanymessage'] = 'Șterge orice mesaje de pe site';
$string['site:deleteownmessage'] = 'Șterge mesajele trimise de și către utilizator';
$string['site:doanything'] = 'Are permisiunea de a efectua orice operaţiune';
$string['site:doclinks'] = 'Afişează link-uri spre documente offsite';
$string['site:forcelanguage'] = 'Suprascrie limba cursului';
$string['site:import'] = 'Importare alte cursuri în curs';
$string['site:maintenanceaccess'] = 'Accesați site-ul în timp ce se află în modul de mentenanță';
$string['site:manageallmessaging'] = 'Adaugă, elimină, blochează sau deblochează contacte de la oricare utilizator';
$string['site:manageblocks'] = 'Administrare block-uri pe o pagină';
$string['site:managecontextlocks'] = 'Gestionați blocarea contextelor';
$string['site:messageanyuser'] = 'Evitați preferințele de confidențialitate ale utilizatorilor pentru a trimite mesaje oricărui utilizator';
$string['site:mnetloginfromremote'] = 'Autentificare printr-o aplicație de la distanță prin MNet';
$string['site:mnetlogintoremote'] = 'Trecere la o aplicație la distanță prin MNet';
$string['site:readallmessages'] = 'Citeşte toate mesajele din cadrul sitului';
$string['site:restore'] = 'Restaurează cursuri';
$string['site:senderrormessage'] = 'Trimiteți un mesaj utilizatorului de asistență din pagina de eroare';
$string['site:sendmessage'] = 'Trimite mesaje oricărui utilizator';
$string['site:trustcontent'] = 'Conţinutul trimis este de încredere';
$string['site:uploadusers'] = 'Încarcă utilizatori noi din fişier';
$string['site:viewanonymousevents'] = 'Vedeți evenimente anonime în rapoarte';
$string['site:viewfullnames'] = 'Vizualizează întotdeauna numele complete ale utilizatorilor';
$string['site:viewparticipants'] = 'Afişează participanţi';
$string['site:viewreports'] = 'Afişează rapoarte';
$string['site:viewuseridentity'] = 'Vezi identitatea completă a utilizatorului în liste';
$string['siteadministrators'] = 'Administratori site';
$string['tag:edit'] = 'Modifică etichete existente';
$string['tag:editblocks'] = 'Modifică blocuri în tags pages';
$string['tag:flag'] = 'Etichete flag ca fiind necorespunzător';
$string['tag:manage'] = 'Administrare toate etichetele';
$string['thisnewrole'] = 'Acest rol nou';
$string['thisusersroles'] = 'Rolurile asignate ale acestui utilizator';
$string['unassignarole'] = 'Revocare rol {$a}';
$string['unassignconfirm'] = 'Sunteți sigur(ă) că doriți să retrageți "{$a->role}"  rolul utilizatorului "{$a->user}"?';
$string['unassignerror'] = 'Eroare la eliminarea rolului {$a->role} de la utilizatorul {$a->user}.';
$string['user:changeownpassword'] = 'Schimbă parola proprie';
$string['user:create'] = 'Creează utilizatori';
$string['user:delete'] = 'Şterge utilizatori';
$string['user:editmessageprofile'] = 'Editare profil utilizator de corespondență';
$string['user:editownmessageprofile'] = 'Editare profil propriu de corespondență';
$string['user:editownprofile'] = 'Modificare profil utilizator propriu';
$string['user:editprofile'] = 'Modificare profil utilizator';
$string['user:ignoreuserquota'] = 'Ignorați limita normei utilizatorului';
$string['user:loginas'] = 'Logare în conturile altor utilizatori';
$string['user:manageblocks'] = 'Administrare blocuri ale altor utilizatori de pe profilul utilizatorului';
$string['user:manageownblocks'] = 'Administrare blocuri de pe propriul profil public';
$string['user:manageownfiles'] = 'Administrare fișiere din zona proprie de fișiere personale';
$string['user:managesyspages'] = 'Configurați pagina de layout-ul implicit pentru profile de utilizator publice';
$string['user:readuserblogs'] = 'Vizualizați toate blogurile urilizatorilor';
$string['user:readuserposts'] = 'Vizualizarea intervenţiilor pe forum ale tuturor utilizatorilor';
$string['user:update'] = 'Actualizare profile utilizatori';
$string['user:viewalldetails'] = 'Vizualizare informații complete despre utilizator';
$string['user:viewdetails'] = 'Vizualizare profile utilizatori';
$string['user:viewhiddendetails'] = 'Vezi informaţii ascunse despre utilizatori';
$string['user:viewlastip'] = 'Vezi ultima adresă ip a utilizatorului';
$string['user:viewuseractivitiesreport'] = 'Vizualizează rapoarte despre activitatea utilizatorilor';
$string['user:viewusergrades'] = 'Vizualizează note utilizator';
$string['usersfrom'] = 'Utilizatorii de la {$a}';
$string['usersfrommatching'] = 'Utilizatorii din {$a->contextname} se potrivesc \'{$a->search}\'';
$string['usersinthisx'] = 'Utilizatori în acest {$a}';
$string['usersinthisxmatching'] = 'Utilizatorii din acest {$a->contexttype} se potrivesc \'{$a->search}\'';
$string['userswithrole'] = 'Toţi utilizatorii cărora le-a fost atribuit un rol';
$string['userswiththisrole'] = 'Utilizatori cu rol';
$string['useshowadvancedtochange'] = 'Folosiți \'Arată avansat\' pentru modificare';
$string['viewingdefinitionofrolex'] = 'Vizualizare definiție rol  \'{$a}\'';
$string['viewrole'] = 'Vizualizează detalii roluri';
$string['webservice:createmobiletoken'] = 'Creare jeton serviciu web pentru acces mobil';
$string['webservice:createtoken'] = 'Creare jeton serviciu web';
$string['webservice:managealltokens'] = 'Gestionați token-urile de servicii web ale tuturor utilizatorilor';
$string['whydoesuserhavecap'] = 'De ce are {$a->fullname} are capacitatea de {$a->capability}, în contextul {$a->context}?';
$string['whydoesusernothavecap'] = 'De ce are {$a->fullname} nu are capacitatea de {$a->capability}, în contextul {$a->context}?';
$string['xroleassignments'] = 'Cerințele rolului lui {$a}';
$string['xuserswiththerole'] = 'Utilizatori cu rolul "{$a->role}"';
