<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ro', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Navighează prin toate cursurile';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Nu te-ai înscris încă la niciun curs.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Navighează mai jos prin toate cursurile disponibile și începe învățarea.';
$string['addon.block_myoverview.noresult'] = 'Căutarea ta nu se potrivește cu vreun curs.';
$string['addon.block_myoverview.noresultdescription'] = 'Încearcă să ajustezi filtrele sau navighează mai jos prin toate cursurile.';
$string['addon.blog.errorloadentries'] = 'Eroare la încărcarea articolelor din blog.';
$string['addon.blog.showonlyyourentries'] = 'Arată doar articolele tale';
$string['addon.calendar.calendarevent'] = 'Eveniment calendar';
$string['addon.calendar.calendarevents'] = 'Evenimente calendar';
$string['addon.calendar.calendarreminders'] = 'Mementouri calendar';
$string['addon.calendar.currentmonth'] = 'Luna curentă';
$string['addon.calendar.defaultnotificationtime'] = 'Timp implicit de notificare';
$string['addon.calendar.errorloadevent'] = 'Eroare la încărcarea evenimentului.';
$string['addon.calendar.errorloadevents'] = 'Eroare la încărcarea evenimentelor.';
$string['addon.calendar.noevents'] = 'Nu sunt evenimente';
$string['addon.calendar.reminders'] = 'Mementouri';
$string['addon.calendar.setnewreminder'] = 'Setează un memento nou';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} înainte';
$string['addon.competency.errornocompetenciesfound'] = 'Nu s-au găsit competențe';
$string['addon.competency.nocompetencies'] = 'Fără competențe';
$string['addon.coursecompletion.complete'] = 'Terminat';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nu am putut încărca raportul îndeplinirii cursului. Te rog să încerci mai târziu.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurează dispozitive';
$string['addon.messages.contactlistempty'] = 'Lista de contacte este goală';
$string['addon.messages.contactname'] = 'Nume contact';
$string['addon.messages.deletemessage'] = 'Șterge mesaj';
$string['addon.messages.deletemessageconfirmation'] = 'Ești sigur că vrei să ștergi acest mesaj? Va fi șters doar din istoricul mesajelor tale, dar va fi încă vizibil de persoana care l-a trimis sau l-a primit.';
$string['addon.messages.errordeletemessage'] = 'Eroare în timpul ștergerii mesajului.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'A apărut o eroare la obținerea contactelor din server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'A apărut o eroare la obținerea conversațiilor din server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'A apărut o eroare la obținerea mesajelor din server.';
$string['addon.messages.errorwhileretrievingusers'] = 'A apărut o eroare la obținerea utilizatorilor din server.';
$string['addon.messages.messagenotsent'] = 'Mesajul nu a fost expediat. Te rog să încerci mai târziu.';
$string['addon.messages.newmessages'] = 'Mesaje noi';
$string['addon.messages.nousersfound'] = 'Nu au fost găsiți utilizatori';
$string['addon.messages.showdeletemessages'] = 'Arată mesajele șterse';
$string['addon.messages.type_blocked'] = 'Blocat';
$string['addon.messages.type_offline'] = 'Deconectat';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Caută rezultate';
$string['addon.messages.type_strangers'] = 'Alții';
$string['addon.messages.useentertosenddescdesktop'] = 'Dacă este dezactivat, poți apăsa Ctrl+Enter pentru a trimite mesajul.';
$string['addon.messages.useentertosenddescmac'] = 'Dacă este dezactivat, poți apăsa Ctrl+Enter pentru a trimite mesajul.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nu am putut trimite mesajul (mesajele) către conversația {{user}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nu am putut trimite mesajul (mesajele) către utilizatorul {{user}}. {{error}}';
$string['addon.mod_assign.cannotgradefromapp'] = 'Anumite metode de notare nu sunt încă acceptate de aplicație și nu pot fi modificate.';
$string['addon.mod_assign.duedateno'] = 'Fără dată limită';
$string['addon.mod_assign.gradenotsynced'] = 'Nivel nesincronizat';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Sunt {{count}} ciorne.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Sunt {{count}} participanți.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Sunt {{count}} expedieri care necesită clasificare.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Sunt {{count}} însărcinări expediate.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Sunt {{count}} echipe.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nota utilizatorului';
$string['addon.mod_chat.confirmloss'] = 'Sunteți sigur? Discuția se poate pierde.';
$string['addon.mod_chat.errorwhileconnecting'] = 'A apărut o eroare la conectarea în Camera de discuții.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'A apărut o eroare la primirea de informații din Camera de discuții.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'A apărut o eroare la obținerea listei cu utilizatorii din Camera de discuții.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'A apărut o eroare la primirea mesajelor de pe server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'A apărut o eroare la trimiterea mesajului.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Trebuie să fiți online pentru a trimite mesaje';
$string['addon.mod_chat.nosessionsfound'] = 'Nu s-au găsit sesiuni';
$string['addon.mod_chat.showincompletesessions'] = 'Afișează sesiunile incomplete';
$string['addon.mod_choice.errorgetchoice'] = 'Eroare în obținerea de date pentru alegere';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% dintre utilizatori au ales varianta: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ultimul tău răspuns trebuie să fie sincronizat înainte de a fi inclus în rezultate.';
$string['addon.mod_data.edittagsnotsupported'] = 'Ne pare rău, editarea etichetelor nu este acceptată în aplicație.';
$string['addon.mod_data.errorapproving'] = 'Eroare la aprobarea sau neaprobarea articolului.';
$string['addon.mod_data.errordeleting'] = 'Eroare la ștergerea articolului.';
$string['addon.mod_data.gettinglocation'] = 'Se obține locația';
$string['addon.mod_data.locationnotenabled'] = 'Locația nu este activată';
$string['addon.mod_data.locationpermissiondenied'] = 'Permisiunea de a accesa locația dumneavoastră a fost respinsă.';
$string['addon.mod_data.mylocation'] = 'Locația mea';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Sunt {{count}} răspunsuri trimise.';
$string['addon.mod_feedback.questionscountdescription'] = 'Există {{count}} întrebări';
$string['addon.mod_folder.emptyfilelist'] = 'Nu există fișiere de afișat.';
$string['addon.mod_forum.errorgetforum'] = 'A apărut o eroare la obținerea datelor despre forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Eroare la obținerea setărilor pentru grup.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nu se pot crea discuții noi în niciun grup.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Nu există încă discuții în acest forum.';
$string['addon.mod_forum.group'] = 'Grup';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discuții';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} răspunsuri';
$string['addon.mod_forum.postingroup'] = 'Se postează în grupul "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Reîmprospătează postările';
$string['addon.mod_glossary.browsemode'] = 'Navighează printre articole';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetic';
$string['addon.mod_glossary.byauthor'] = 'Grupați după autor';
$string['addon.mod_glossary.bycategory'] = 'Grupare după categorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Cele mai noi sunt afișate primele';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Actualizări recente';
$string['addon.mod_glossary.bysearch'] = 'Căutare';
$string['addon.mod_glossary.cannoteditentry'] = 'Nu se poate edita articolul';
$string['addon.mod_glossary.entriestobesynced'] = 'Articole care urmează să fie sincronizate';
$string['addon.mod_glossary.entrypendingapproval'] = 'Acest articol asteaptă aprobare.';
$string['addon.mod_glossary.errorloadingentries'] = 'A apărut o eroare la încărcarea articolelor.';
$string['addon.mod_glossary.errorloadingentry'] = 'A apărut o eroare la încărcarea articolului.';
$string['addon.mod_glossary.errorloadingglossary'] = 'A apărut o eroare la încărcarea glosarului.';
$string['addon.mod_glossary.noentriesfound'] = 'Nu au fost găsite articole.';
$string['addon.mod_glossary.searchquery'] = 'Căutare';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descarcă fișierul H5P';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Pachetul H5P nu este descărcat. Trebuie să-l descarci pentru a-l putea folosi.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Trebuie să fiți online pentru a vedea pachetul H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Vezi încercarea {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Afișează descrierea';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lti.errorgetlti'] = 'A apărut o eroare la încărcarea modulului de date.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'URLul lansat nu este valid.';
$string['addon.mod_lti.launchactivity'] = 'Lansează activitatea';
$string['addon.mod_page.errorwhileloadingthepage'] = 'A apărut o eroare la încărcarea conținutului paginii.';
$string['addon.mod_quiz.finishnotsynced'] = 'Încheiat, dar nesincronizat';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Testul conține întrebări care nu sunt acceptate de aplicație:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'A apărut o eroare la încărcarea conținutului.';
$string['addon.mod_resource.openthefile'] = 'Deschide';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nota nu a putut fi calculată.';
$string['addon.mod_scorm.dataattemptshown'] = 'Aceste date aparțin încercării cu numărul {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'A apărut o eroare la crearea încercării offline. Încercați din nou!';
$string['addon.mod_scorm.errordownloadscorm'] = 'Eroare la descărcarea SCORM cu numele: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Eroare la obținerea de date pentru acest SCORM';
$string['addon.mod_scorm.errorinvalidversion'] = 'Această aplicație suporta doar versiunea de SCORM 1.2';
$string['addon.mod_scorm.errornotdownloadable'] = 'Descărcarea pachetelor SCORM este dezactivată pe acest site. Contactați administratorul siteului.';
$string['addon.mod_scorm.errornovalidsco'] = 'Acest SCORM nu are un SCO vizibil pentru a fi încărcat.';
$string['addon.mod_scorm.errorpackagefile'] = 'Această aplicație suportă doar fișiere de tip ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'A apărut o eroare la sincronizare. Vă rugăm să reîncercați.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Această încercare conține date care nu au fost sincronizate.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Această încercare nu poate fi trimisă deoarece a fost depășit numărul maxim de încercări.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Acest SCORM nu a fost descărcat. Va fi descărcat automat când îl veți deschide.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Acest SCORM a fost modificat de la ultima descărcare. Va fi redescărcat automat când îl veți deschide.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Unele date ale încercării offline cu numărul {{number}} au fost șterse deoarece nu s-au putut constitui într-o nouă încercare.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Această încercare nu poate fi sincronizată cu siteul pentru că ultima încercare efectuată nu a fost finalizată. Vă rugăm să o finalizați.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'A apărut o eroare la trimiterea sondajului. Vă rugăm să reîncercați.';
$string['addon.mod_survey.errorgetsurvey'] = 'A apărut o eroare la primirea datelor sondajului.';
$string['addon.mod_survey.results'] = 'Rezultate';
$string['addon.mod_url.accessurl'] = 'Accesați adresa URL';
$string['addon.mod_url.pointingtourl'] = 'Adresa URL a acestei resurse duce la';
$string['addon.mod_wiki.errorloadingpage'] = 'A apărut o eroare la încărcarea paginii.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Acest wiki nu are conținut încă.';
$string['addon.mod_wiki.gowikihome'] = 'Mergeți la prima pagină wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titlul nu poate fi necompletat';
$string['addon.mod_wiki.viewpage'] = 'Vezi pagina';
$string['addon.mod_wiki.wikipage'] = 'Pagină wiki';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Trebuie să inserați un titlu';
$string['addon.notes.warningnotenotsent'] = 'Nu s-au putut adăuga notițe la curs {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Permite notificări';
$string['addon.notifications.errorgetnotifications'] = 'A apărut o eroare la primirea notificărilor.';
$string['addon.notifications.notifications'] = 'Notificări';
$string['addon.notifications.playsound'] = 'Redă sunet';
$string['addon.notifications.therearentnotificationsyet'] = 'Nu există notificări';
$string['addon.notifications.typeofnotification'] = 'Tip de notificare';
$string['addon.privatefiles.couldnotloadfiles'] = 'Lista de fișiere nu a putut fi încărcată.';
$string['addon.privatefiles.emptyfilelist'] = 'Nu există fișiere de modificat.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Din păcate, în prezent, nu este posibil să încărcați fișiere pe site.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Șterge toate datele descărcate de pe site?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Ștergi datele descărcate din toare cursurile?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Șterge toate datele descărcate din \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Descărcări ale cursului';
$string['addon.storagemanager.deleteallsitedata'] = 'Șterge toate datele descărcate din site';
$string['addon.storagemanager.deletecourses'] = 'Ștergeți toate datele descărcate din toate cursurile';
$string['addon.storagemanager.deletedata'] = 'Ștergeți datele descărcate';
$string['addon.storagemanager.deletedatafrom'] = 'Șterge toate datele descărcate din \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Cursuri descărcate';
$string['addon.storagemanager.downloads'] = 'Descărcări';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Eroare la ștergerea datelor descărcate.';
$string['addon.storagemanager.totalspaceusage'] = 'Spațiul total folosit';
$string['appstoredescription'] = 'NOTĂ: Aceasta este aplicația oficială Moodle pentru dispozitivele mobile și va funcționa numai cu siteurile Moodle care sunt setate să o accepte. Va rugăm să contactați administratorul siteului dacă aveți probleme la conectare.

Dacă siteul Moodle a fost configurat corect, veți putea utiliza această aplicație pentru a:

- accesa cursurile dumneavoastră chiar și în mod offline;
- primi notificări instant cu privire la mesajele primite sau alte tipuri de evenimente;
- găsi rapid și a contacta alți participanți la curs;
- încărca imagini, fișiere audio, video sau de alte tipuri, direct de pe dispozitivul mobil;
- vedea notele obținute;
- și multe altele!

Vă rugă șa verificați http://docs.moodle.org/en/Mobile_app pentru ultimile noutăți.

Vom aprecia recenziile cu privire la funcționalitatea aplicației precum și cu propuneri pentru viitoare funcționalități!

Aplicația necesită următoarele permisiuni:
Înregistrare audio - pentru înregistrarea fișierelor audio încărcate pe platforma Moodle
Citirea și modificarea conținutului memoriei SD - Fișierele descărcate prin aplicație vor fi stocate pe cardul de memorie pentru a putea fi consultate de dumneavoastră în mod offline
Acces la rețea - Pentru a se putea conecta la siteul dumneavoastră Moodle și pentru a vă verifica statusul pentru a trece în mod offline la nevoie (daca nu sunteți conectat la internet)
Rulare la pornire - Pentru a putea primi notificări chiar dacă aplicația rulează în fundal
Împiedicarea telefonului să intre în modul sleep - Pentru a putea primi notificări push în orice moment';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Fișier Google Drive';
$string['core.calculating'] = 'Se calculează';
$string['core.cannotconnect'] = 'Nu se poate conecta la site';
$string['core.cannotdownloadfiles'] = 'Descărcarea de fișiere este dezactivată. Contactați administratorul siteului.';
$string['core.cannotinstallapk'] = 'Nu se poate instala .apk files';
$string['core.capturedimage'] = 'Poză făcută.';
$string['core.captureimage'] = 'Fă poză';
$string['core.clearsearch'] = 'Ștergeți căutările';
$string['core.clicktoseefull'] = 'Apăsați pentru a vedea întregul conținut';
$string['core.comments.warningcommentsnotsent'] = 'Nu se pot sincroniza comentariile. {{error}}';
$string['core.confirmloss'] = 'Ești sigur? Toate modificările se vor pierde.';
$string['core.confirmopeninbrowser'] = 'Doriți să deschideți într-un browser web?';
$string['core.connectionlost'] = 'S-a pierdut conexiunea la site';
$string['core.contenteditingsynced'] = 'Conținutul pe care îl editezi a fost sincronizat.';
$string['core.contentlinks.chooseaccount'] = 'Alegeți contul';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Alegeți contul pentru a putea deschide linkul.';
$string['core.contentlinks.confirmurlothersite'] = 'Acest link aparține unui alt site. Doriți să îl deschideți?';
$string['core.contentlinks.errornoactions'] = 'Nu a fost găsită o aplicație pentru a deschide acest link.';
$string['core.contentlinks.errornosites'] = 'Nu a fost găsit niciun site pentru acest link.';
$string['core.copiedtoclipboard'] = 'Text copiat în clipboard';
$string['core.copytoclipboard'] = 'Copiază în clipboard';
$string['core.course.allsections'] = 'Toate secțiunile';
$string['core.course.availablespace'] = 'În prezent aveți aproximativ {{available}} spațiu liber.';
$string['core.course.confirmdeletemodulefiles'] = 'Ești sigur că vrei să ștergi aceste fișiere?';
$string['core.course.confirmdeletestoreddata'] = 'Ești sigur(ă) că vrei să ștergi toate datele stocate?';
$string['core.course.confirmdownload'] = 'Porniți o descărcare de {{size}}. Sunteți sigur ca doriți să continuați?';
$string['core.course.confirmdownloadunknownsize'] = 'Nu se poate calcula dimensiunea fișierului pe care vrei să îl descarci.{{availableSpace}} Ești sigur că vrei să continui?';
$string['core.course.confirmdownloadzerosize'] = 'Urmează să începeți';
$string['core.course.confirmlimiteddownload'] = 'Nu sunteți conectat acum la Wi-Fi.';
$string['core.course.contents'] = 'Conținuturi';
$string['core.course.couldnotloadsectioncontent'] = 'Nu se poate încărca conținutul secțiunii. Te rugăm să încerci mai târziu.';
$string['core.course.couldnotloadsections'] = 'Nu se pot încărca secțiunile. Te rugăm să încerci mai târziu.';
$string['core.course.downloadcoursesprogressdescription'] = 'Se descarcă cursuri: descărcate {{count}} din {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Se descarcă secțiunea: descărcată {{count}} din {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Eroare la descărcarea cursului.';
$string['core.course.errordownloadingsection'] = 'A apărut o eroare la descărcarea secțiunii.';
$string['core.course.errorgetmodule'] = 'A apărut o eroare la preluarea modului de date.';
$string['core.course.lastaccessedactivity'] = 'Ultima activitate accesată';
$string['core.course.nextactivity'] = 'Următoarea activitate';
$string['core.course.nextactivitynotfound'] = 'Următoarea activitate nu a fost găsită. Este posibil să fi fost ascunsă sau ștearsă.';
$string['core.course.nocontentavailable'] = 'Pentru moment nu există conținut disponibil.';
$string['core.course.previousactivity'] = 'Activitate anterioară';
$string['core.course.previousactivitynotfound'] = 'Activitatea anterioară nu a fost găsită. Este posibil să fi fost ascunsă sau ștearsă.';
$string['core.course.refreshcourse'] = 'Actualizează cursul';
$string['core.course.useactivityonbrowser'] = 'Se poate folosi în continuare utilizând browser-ul web al dispozitivului tău.';
$string['core.coursenogroups'] = 'Nu sunteți membru al niciunui grup din acest curs.';
$string['core.courses.completeenrolmentbrowser'] = 'Completează înscrierea în browser';
$string['core.courses.confirmselfenrol'] = 'Sunteți sigur/ă că doriți să vă înregistrați la acest curs?';
$string['core.courses.downloadcourses'] = 'Descarcă toate cursurile';
$string['core.courses.enrolme'] = 'Înregistrează-mă';
$string['core.courses.errorloadcategories'] = 'A apărut o eroare în timp ce se încărcau categoriile.';
$string['core.courses.errorloadcourses'] = 'A apărut o eroare la încărcarea cursurilor.';
$string['core.courses.errorsearching'] = 'A apărut o eroare în procesul de căutare.';
$string['core.courses.errorselfenrol'] = 'A apărut o eroare în procesul de auto-înregistrare.';
$string['core.courses.filtermycourses'] = 'Filtrează cursurile mele';
$string['core.courses.notenrollable'] = 'Nu vă puteți auto-înregistra la acest curs.';
$string['core.courses.otherenrolments'] = 'Alte înscrieri';
$string['core.courses.password'] = 'Cheie de înregistrare';
$string['core.courses.refreshcourses'] = 'Actualizează cursuri';
$string['core.courses.searchcoursesadvice'] = 'Puteți folosi butonul pentru căutarea cursurilor pentru a căuta și accesa ca vizitator sau pentru a vă auto-înregistra la acele cursuri care permit aceste opțiuni.';
$string['core.courses.selfenrolment'] = 'Auto-înregistrare';
$string['core.courses.showonlyenrolled'] = 'Afișează doar cursurile mele';
$string['core.courses.totalcoursesearchresults'] = 'Totalul cursurilor: {{$a}}';
$string['core.currentdevice'] = 'Dispozitivul actual';
$string['core.deleting'] = 'Se șterge';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'LL-ZZ-AAAA';
$string['core.dfdayweekmonth'] = 'zzz, Z LLL';
$string['core.dflastweekdate'] = 'zzz';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Renunță';
$string['core.dontshowagain'] = 'Nu mai afișa din nou.';
$string['core.downloaded'] = 'Descărcat';
$string['core.downloading'] = 'Se descarcă';
$string['core.editor.hidetoolbar'] = 'Ascunde bara de instrumente';
$string['core.endingtime'] = 'Ora de încheiere: {{$a}}';
$string['core.errorchangecompletion'] = 'A apărut o eroare în timpul schimbării nivelului de finallizare. Încearcă din nou!';
$string['core.errorcode'] = 'Cod eroare: {{errorCode}}';
$string['core.errordeletefile'] = 'Eroare la ștergeerea fișierului. Vă rugăm să încercați mai târziu.';
$string['core.errordetailshide'] = 'Ascunde informațiile despre eroare';
$string['core.errordetailsshow'] = 'Afișează informațiile despre eroare';
$string['core.errordownloading'] = 'A apărut o eroare la descărcarea fișierului.';
$string['core.errordownloadingsomefiles'] = 'A apărut o eroare la descărcarea fișierelor modulului. Unele fișiere pot lipsi.';
$string['core.errorfileexistssamename'] = 'Un fișier cu această denunire există deja.';
$string['core.errorinvalidresponse'] = 'Răspuns nevalid primit. Contactați administratorul siteului dacă această eroare persistă.';
$string['core.errorloadingcontent'] = 'Eroare la încărcarea conținutului.';
$string['core.erroropenfilenoapp'] = 'A apărut o eroare la deschiderea fișierului: nu s-a găsit nicio aplicație pentru a deschide acest tip de fișier.';
$string['core.erroropenfilenoextension'] = 'A apărut o eroare la deschiderea fișierului: acest fișier nu are o extensie.';
$string['core.erroropenpopup'] = 'Această activitate încearcă să deschidă o fereastră popup. Acest lucru nu este permis în aplicație.';
$string['core.errorrenamefile'] = 'Eroare la redenumirea fișierului. Vă rugăm să încercați  mai târziu.';
$string['core.errorsitesupport'] = 'Dacă problema persistă, contactați administratorul platformei.';
$string['core.errorsomedatanotdownloaded'] = 'Dac';
$string['core.errorsomethingwrong'] = 'Ceva nu a funcționat. Te rugăm să încerci din nou.';
$string['core.errorsync'] = 'A apărut o eroare în timpul sincronizării. Te rugăm să încerci din nou.';
$string['core.filenameexist'] = 'Denumirea fișierului există deja: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'Sunteți pe cale să încărcați {{size}}. Sunteți sigur ca doriți să continuați?';
$string['core.fileuploader.errorcapturingaudio'] = 'Eroare la înregistrarea audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Eroare la realizarea capturii foto.';
$string['core.fileuploader.errorcapturingvideo'] = 'Eroare la înregistrarea video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Eroare la obținerea imaginii din album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Pentru a putea încărca fișiere trebuie să online.';
$string['core.fileuploader.errornoapp'] = 'Nu aveți instalată o aplicație dedicată realizării acestei operațiuni.';
$string['core.fileuploader.errorreadingfile'] = 'Eroare la citirea fișierului.';
$string['core.fileuploader.errorwhileuploading'] = 'A apărut o eroare în timpul încărcării fișierului.';
$string['core.fileuploader.file'] = 'Fișier';
$string['core.fileuploader.fileuploaded'] = 'Fișierul a fost încărcat cu succes.';
$string['core.fileuploader.maxbytesfile'] = 'Fișierul {{$a.file}} este prea mare. Dimensiunea maximă pe care o puteți încărca este {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Albume foto';
$string['core.fileuploader.readingfile'] = 'Se citește fișierul';
$string['core.fileuploader.readingfileperc'] = 'Se citește fișierul: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Selectează un fișier';
$string['core.fileuploader.uploadafile'] = 'Încărcați un fișier';
$string['core.fileuploader.uploading'] = 'Se încarcă';
$string['core.fileuploader.uploadingperc'] = 'Se încarcă: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Mergi la {{$a}}';
$string['core.h5p.offlinedisabled'] = 'Acest site nu permite descărcarea pachetelor H5P.';
$string['core.h5p.play'] = 'Afișați H5P';
$string['core.hasdatatosync'] = 'Acest {{$a}} are date offline de sincronizat.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Acest conținut nu poate fi vizualizat?';
$string['core.image'] = 'Imagine';
$string['core.imageviewer'] = 'Vizualizator pentru imagini';
$string['core.lastdownloaded'] = 'Ultima descărcare';
$string['core.lastsync'] = 'Ultima sincronizare';
$string['core.loadmore'] = 'Încarcă mai mult';
$string['core.login.authenticating'] = 'Autentificare';
$string['core.login.changepasswordbutton'] = 'Schimbă parola';
$string['core.login.changepasswordreconnectinstructions'] = 'Dacă nu ți-ai schimbat corect parola, ți se va cere să o faci din nou.';
$string['core.login.changepasswordsupportsubject'] = 'Am nevoie de suport pentru schimbarea parolei';
$string['core.login.confirmdeletesite'] = 'Sunteți sigur că doriți sa ștergeți contul de pe site-ul {{sitename}}?';
$string['core.login.connect'] = 'Conectare!';
$string['core.login.connecttomoodle'] = 'Conectare la Moodle';
$string['core.login.contactyouradministrator'] = 'În continuare, contactează administratorul site-ului pentru suport.';
$string['core.login.contactyouradministratorissue'] = 'Te rugăm să contactezi administratorul site-ului pentru a verifica următoarea problemă: {{$a}}';
$string['core.login.credentialsdescription'] = 'Va rugăm să  introduceți userul și parola dumneavoastră pentru a vă conecta';
$string['core.login.credentialssupportsubject'] = 'Este nevoie de ajutor la logare';
$string['core.login.emailconfirmsentnoemail'] = '<p>Un email ar fi trebuit să fie trimis la adresa ta.</p><p>Conține instrucțiuni simple pentru a-ți finaliza înregistrarea.</p>';
$string['core.login.emailnotmatch'] = 'Email-urile nu corespund';
$string['core.login.erroraccesscontrolalloworigin'] = 'Operațiune Cross-Origin pe care încercați să o efectuați a fost respinsă. Verificați la https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'A apărut o eroare în timpul ștergerii acestui cont. Vă rugăm să încercați din nou!';
$string['core.login.errorupdatesite'] = 'A apărut o eroare în timpul actualizării tokenului pentru acest site.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recuperarea parolei tale';
$string['core.login.exceededloginattemptssupportsubject'] = 'Nu mă pot loga';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Nu îmi pot reseta parola';
$string['core.login.faqcannotconnectanswer'] = 'Te rugăm, contactează administratorul site-ului tău.';
$string['core.login.faqcannotconnectquestion'] = 'Am tastat corect adresa site-ului meu, dar tot nu mă pot conecta.';
$string['core.login.faqcannotfindmysitequestion'] = 'Nu pot să găsesc site-ul meu.';
$string['core.login.faqsetupsitelinktitle'] = 'Începe.';
$string['core.login.faqwhereisqrcode'] = 'Unde pot să găsesc codul QR?';
$string['core.login.invalidaccount'] = 'Vă rugă să verificați datele de conectare sau rugați administratorul siteului sa verifice configurația site-ului.';
$string['core.login.invalidmoodleversion'] = 'Versiunea Moodle este invalidă. Versiunea minimă este 2.4';
$string['core.login.invalidsite'] = 'Adresa URL este invalidă.';
$string['core.login.invalidvaluemax'] = 'Valoarea maximă este {{$a}}';
$string['core.login.invalidvaluemin'] = 'Valoarea minimă este  {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Verificarea Moodle Mobile Additional Features a returnat un răspuns neașteptat. Veți fi autentificat folosind serviciul standard.';
$string['core.login.loginbutton'] = 'Logat!';
$string['core.login.logininsiterequired'] = 'Trebuie sa vă logați pe site într-un browser.';
$string['core.login.mobileservicesnotenabled'] = 'Serviciile mobile nu sunt activate pe site-ul dumneavoastră. Vă rugăm să contactați administratorul site-ului dacă considerați necesară activarea accesului mobil.';
$string['core.login.notloggedin'] = 'Trebuie să fii logat.';
$string['core.login.onboardingcreatemanagecourses'] = 'Creează-ți și administrează-ți cursurile';
$string['core.login.onboardingimaneducator'] = 'Sunt un profesor';
$string['core.login.onboardingwelcome'] = 'Bine ai venit la Moodle App!';
$string['core.login.or'] = 'SAU';
$string['core.login.passwordrequired'] = 'Este necesară introducerea parolei';
$string['core.login.recaptchaincorrect'] = 'Răspunsul la întrebarea de securitate este incorect.';
$string['core.login.reconnect'] = 'Reconectare';
$string['core.login.reconnectdescription'] = 'Tokenul dumneavoastră de autentificare este invalid sau a expirat, trebuie să vă reconectați pe site.';
$string['core.login.reconnectssodescription'] = 'Tokenul dumneavoastră de autentificare este invalid sau a expirat, trebuie să vă reconectați pe site. Logați-vă folosind un browser.';
$string['core.login.reconnecttosite'] = 'Reconectați-vă la site';
$string['core.login.removeaccount'] = 'Șterge cont';
$string['core.login.searchby'] = 'Caută după:';
$string['core.login.selectsite'] = 'Vă rugăm să selectați contul dumneavoastră:';
$string['core.login.signupplugindisabled'] = '{{$a}} nu este activat';
$string['core.login.siteaddress'] = 'Site-ul tău';
$string['core.login.sitebadgedescription'] = 'Există {{count}} notificări necitite.';
$string['core.login.siteinmaintenance'] = 'Site-ul dumneavoastră se află în mentananță';
$string['core.login.sitenotallowed'] = 'Acest site nu mai este disponibil.';
$string['core.login.siteurl'] = 'Adresă URL';
$string['core.login.siteurlrequired'] = 'Este necesară adresa URL a site-ului, de exemplu <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Tot nu vă puteți conecta?';
$string['core.login.toggleremove'] = 'Editează lista de conturi';
$string['core.login.usernamerequired'] = 'Este necesar numele de utilizator';
$string['core.login.visitchangepassword'] = 'Vrei să accesezi site-ul pentru a schimba parola?';
$string['core.login.webservicesnotenabled'] = 'Serviciile web nu sunt activate pe site.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Te poți conecta în continuare la site prin nume de utilizator și parolă.';
$string['core.login.yourenteredsite'] = 'Conectează-te la site-ul tău';
$string['core.lostconnection'] = 'Token-ul pentru autentificare nu este valid sau a expirat; trebuie să te reconectezi!';
$string['core.mainmenu.changesite'] = 'Schimbă site-ul';
$string['core.mainmenu.switchaccount'] = 'Schimbă contul';
$string['core.mainmenu.usermenutourdescription'] = 'Locul unde îți verifici notele, îți modifici setările sau te loghezi în alt cont.';
$string['core.mainmenu.website'] = 'Website';
$string['core.needhelp'] = 'Ai nevoie de ajutor?';
$string['core.networkerroriframemsg'] = 'Acest conținut nu este disponibil offline. Te rugăm să te conectezi la internet și să încerci din nou.';
$string['core.networkerrormsg'] = 'A apărut o problemă la conectarea pe site. Te rugăm să verifici conexiunea și să încerci din nou.';
$string['core.nooptionavailable'] = 'Nicio opțiune disponibilă';
$string['core.nopasswordchangeforced'] = 'Nu poți continua fără a-ți schimba parola.';
$string['core.nopermissionerror'] = 'Ne pare rău, dar nu ai permisiunea pentru această acțiune';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Nu a fost trimis';
$string['core.nummore'] = 'mai mult {{$a}}';
$string['core.openfile'] = 'Deshide fișier';
$string['core.openfullimage'] = 'Apasă aici pentru a vizualiza imaginea la dimensiunea întreagă';
$string['core.openinbrowser'] = 'Deschide în browser';
$string['core.openmodinbrowser'] = 'Deschide {{$a}} în browser';
$string['core.opensecurityquestion'] = 'Deschide întrebarea de securitate';
$string['core.opensettings'] = 'Deschide setările';
$string['core.openwith'] = 'Deschide cu...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Afișează';
$string['core.pulltorefresh'] = 'Trage în jos pentru actualizare';
$string['core.qrscanner'] = 'Scanner QR';
$string['core.question.cannotdeterminestatus'] = 'Nu se poate determina status-ul';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Site-ul tău nu pemite încă atașarea de fișiere la răspunsuri.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Site-ul tău încă nu acceptă editarea fișierelor încorporate.';
$string['core.question.errorquestionnotsupported'] = 'Acest tip de întrebare nu este acceptată de aplicație: {{$a}}.';
$string['core.question.questionmessage'] = 'Întrebare {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Vei fi redirecționat către site.';
$string['core.reminders.atthetime'] = 'La ora evenimentului';
$string['core.reminders.reminderset'] = 'Reminder setat pentru {{$a}}';
$string['core.reminders.reminderunset'] = 'Reminder șters';
$string['core.reminders.setareminder'] = 'Setază un reminder';
$string['core.reminders.setareminderfor'] = 'Setează un reminder pentru "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Setează reminder';
$string['core.reminders.value'] = 'Valoare';
$string['core.removefiles'] = 'Șterge fișierele {{$a}}';
$string['core.requireduserdatamissing'] = 'Acest utilizator are unele date de profil obligatorii necompletate. Completați aceste date pe site și încercați din nou.<br>{{$a}}';
$string['core.resume'] = 'Reia';
$string['core.retry'] = 'Încearcă din nou';
$string['core.scanqr'] = 'Scanează codul  QR';
$string['core.searching'] = 'Căutare';
$string['core.settings.about'] = 'Despre';
$string['core.settings.appsettings'] = 'Setări aplicație';
$string['core.settings.appversion'] = 'Versiune aplicație';
$string['core.settings.changelanguage'] = 'Schimbă în {{$a}}';
$string['core.settings.changelanguagealert'] = 'Schimbarea limbii va reporni aplicația.';
$string['core.settings.colorscheme-dark'] = 'Închis';
$string['core.settings.colorscheme-light'] = 'Deschis';
$string['core.settings.connecttosync'] = 'Dispozitivul tău este offline. Conectează-te la internet pentru a sincroniza site-urile.';
$string['core.settings.cordovadevicemodel'] = 'Modelul Cordova Device';
$string['core.settings.cordovadeviceosversion'] = 'Versiunea OS a Cordova Device';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Cordova Device';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova Device';
$string['core.settings.cordovaversion'] = 'Versiunea Cordova';
$string['core.settings.deletesitefiles'] = 'Sunteți sigur/ă ca doriți să ștergeți fișierele descărcate de pe siteul \'{{sitename}}\'? Nu veți putea folosi aplicația în modul offline.';
$string['core.settings.deletesitefilestitle'] = 'Șterge fișierele de pe site';
$string['core.settings.developeroptions'] = 'Opțiuni pentru dezvoltator';
$string['core.settings.deviceinfo'] = 'Informații despre dispozitiv';
$string['core.settings.deviceos'] = 'Sistemul de operare al dispozitivului';
$string['core.settings.displayformat'] = 'Dimensiunea ecranului';
$string['core.settings.enabledownloadsection'] = 'Activați secțiunile pentru descărcare';
$string['core.settings.enablerichtexteditor'] = 'Activați editorul text';
$string['core.settings.enablesyncwifi'] = 'Permiteți sincronizarea doar pe o conexiune Wi-Fi';
$string['core.settings.errordeletesitefiles'] = 'A apărut o eroare la ștergerea fișierelor de pe site.';
$string['core.settings.errorsyncsite'] = 'A apărut o eroare la sincronizarea datelor de pe site, verificați conexiunea la internet și încercați din nou.';
$string['core.settings.estimatedfreespace'] = 'Spațiu liber estimat';
$string['core.settings.filesystemroot'] = 'Rădăcina sistemului de fișiere';
$string['core.settings.fontsize'] = 'Mărimea textului';
$string['core.settings.helpusimprove'] = 'Ajută-ne să îmbunătățim această aplicație';
$string['core.settings.localnotifavailable'] = 'Notificările locale sunt disponibile';
$string['core.settings.locationhref'] = 'URL';
$string['core.settings.logintosync'] = 'Loghează-te pentru a sincroniza';
$string['core.settings.navigatorlanguage'] = 'Limba navigatorului';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Starea conexiunii la Internet';
$string['core.settings.opensourcelicenses'] = 'Licențe Open Source';
$string['core.settings.privacypolicy'] = 'Politica de confidențialitate';
$string['core.settings.reportinbackground'] = 'Erorile se raportează automat';
$string['core.settings.showdownloadoptions'] = 'Afișează opțiunile de descărcare';
$string['core.settings.sitesyncfailed'] = 'Sincronizarea site-ului a eșuat';
$string['core.settings.spaceusage'] = 'Spațiu utilizat';
$string['core.settings.synchronization'] = 'Sincronizare';
$string['core.settings.synchronizenow'] = 'Sincronizează acum';
$string['core.settings.syncsettings'] = 'Setările sincronizării';
$string['core.settings.wificonnection'] = 'Conexiune WiFi';
$string['core.settings.youradev'] = 'Ești dezvoltator acum';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Alege un cont în care să stochezi fișiere.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Există deja un fișier cu acest nume. Vrei să înlocuiești fișierul existent sau să îl redenumești în"{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Nu există site-uri stocate. Te rugăm să adaugi un site înainte de a partaja un fișier prin aplicație.';
$string['core.sharedfiles.nosharedfiles'] = 'Nu există fișiere partajate stocate pe acest site.';
$string['core.sharedfiles.rename'] = 'Redenumire';
$string['core.sharedfiles.replace'] = 'Înlocuire';
$string['core.sharedfiles.sharedfiles'] = 'Fișiere partajate';
$string['core.sitenotfound'] = 'Site-ul nu a fost găsit.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Ne pare rău...';
$string['core.start'] = 'Începe';
$string['core.startingtime'] = 'Ora de începere: {{$a}}';
$string['core.storingfiles'] = 'Se stochează fișiere';
$string['core.tablet'] = 'Tabletă';
$string['core.tag.tagareabadgedescription'] = 'Există {{count}} itemi.';
$string['core.thereisdatatosync'] = 'Există {{$a}} offline de sincronizat.';
$string['core.tryagain'] = 'Încercați din nou';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'A apărut o eroare neașteptată. Închideți și redeschideți aplicația pentru a încerca din nou';
$string['core.unicodenotsupported'] = 'Unele emoji nu sunt acceptate pe acest site și vor fi șterse când se trimite mesajul';
$string['core.unknown'] = 'Necunoscut';
$string['core.unzipping'] = 'Dezarhivare';
$string['core.updaterequired'] = 'Este necesară actualizarea aplicației';
$string['core.updaterequireddesc'] = 'Te rugăm să îți actualizezi aplicația la versiunea {{$a}}';
$string['core.user.completeprofile'] = 'Completați profilul';
$string['core.user.completeprofilenotice'] = 'Înainte de a continua, te rugăm să completezi câmpurile obligatorii din profilul tău de utilizator.';
$string['core.user.completeprofilereconnectinstructions'] = 'Dacă nu ți-ai completat corect profilul, ți se va cere să completezi din nou.';
$string['core.user.completeprofilesupportsubject'] = 'Am nevoie de ajutor la completarea profilului';
$string['core.user.completeyourprofile'] = 'Completează-ți profilul';
$string['core.user.contact'] = 'Contact';
$string['core.user.detailsnotavailable'] = 'Detaliile acestui utilizator nu îți sunt disponibile.';
$string['core.user.errorloaduser'] = 'Eroare la încărcarea utilizatorului.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.support'] = 'Contactează asistența de pe site';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Utilizator cu identificatorul {{id}}';
$string['core.usernologin'] = 'Autentificarea a fost anulată pentru acest cont';
$string['core.viewcode'] = 'Vizualizare cod';
$string['core.vieweditor'] = 'Vizualizare editor';
$string['core.viewembeddedcontent'] = 'Vizualizare conținut încorporat';
$string['core.wanttochangesite'] = 'Dorești să accesezi alt site sau să te deloghezi?';
$string['core.warningofflinedatadeleted'] = 'Date offline din {{component}} \'{{name}}\' au fost șterse. {{error}}';
$string['core.whoops'] = 'Oops!';
$string['core.whyisthishappening'] = 'De ce se întâmplă asta?';
$string['core.wsfunctionnotavailable'] = 'Această funcție Web nu este disponibilă.';
$string['core.youreoffline'] = 'Dispozitivul tău este offline';
$string['core.youreonline'] = 'Dispozitivul tău este din nou online';
$string['core.zoomin'] = 'Zoom in';
$string['core.zoomout'] = 'Zoom out';
$string['freemium.autologoutclosingtheapp'] = 'Imediat după ce închizi aplicația';
$string['freemium.autologoutdefault'] = 'Implicit';
$string['freemium.autologouttitle'] = 'Delogare utomată de pe acest dispozitiv';
$string['freemium.biometriclogin'] = 'Logare biometrică';
$string['freemium.biometriclogindescription'] = 'Pune degetul în cititorul de amprente.';
$string['freemium.biometricloginenablefaceid'] = 'Activează FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Activează Fingerprint';
$string['freemium.biometricloginenabletouchid'] = 'Activează TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Autentificare cu FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Autentificare cu Fingerprint';
$string['freemium.biometricloginloginwithtouchid'] = 'Autentificare cu TouchID';
$string['freemium.biometricloginskip'] = 'Omite momentan';
$string['freemium.biometricloginturnoff'] = 'Poți activa și dezactiva oricând această funcție din setări.';
$string['freemium.biometricloginwithfingerorface'] = 'Utilizează logarea biometrică prin amprenta digitală sau prin recunoaștere facială.';
$string['freemium.change'] = 'Modifică';
$string['freemium.downloadmainapplicationrequired'] = 'Puteți să vă conectați pe site doar folosind aplicația dedicată.';
$string['freemium.feature_coursesdownload'] = 'Cursuri descărcate';
$string['freemium.feature_qrlogin'] = 'Autentificare prin cod QR';
$string['freemium.feature_sitelogo'] = 'Logo-ul site-ului';
$string['freemium.notallowed'] = 'Nu este permis';
$string['freemium.nottoday'] = 'Nu astăzi';
$string['freemium.qrlogindisabled'] = 'Autentificarea în aplicație utilizând un cod QR nu este acceptată în platformă:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Codul QR a expirat. Te rugăm să actualizezi pagina cu codul QR și să o scanezi din nou.';
$string['freemium.ratetheapp'] = 'Îți place aplicația noastră?';
$string['freemium.ratetheapp_feedbackko'] = 'Spune ce nu a funcționat';
$string['freemium.ratetheapp_feedbackmessage'] = 'Feedback-ul tău va fi anonim';
$string['freemium.ratetheapp_feedbackok'] = 'Trimite feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Scrie ceva aici';
$string['freemium.ratetheapp_feedbacksent'] = 'Mulțumim! Feedback-ul a fost trimis cu succes';
$string['freemium.ratetheapp_sendtostore'] = 'Ai un moment să evaluezi aplicația noastra? Ne ajuți astfel la îmbunătățirea ei.';
$string['freemium.remindmelater'] = 'Amintește-mi mai târziu!';
$string['freemium.settingsoptions_autologout'] = 'Logare automată';
$string['freemium.settingsoptionsfacial'] = 'Activează logarea prin recunoaștere facială';
$string['freemium.settingsoptionsfingerprint'] = 'Activează logarea cu amprentă';
$string['freemium.subscription'] = 'Abonare pe site';
$string['freemium.subscriptiondetails'] = 'Detalii despre subscripție';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Tema ta particularizată nu este aplicată';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Logo-ul site-ului tău nu este aplicat';
$string['freemium.subscriptionfeature_limited'] = 'Limitat la {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Nelimitat';
$string['freemium.subscriptionplan'] = 'Plan de abonament';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'expirat';
$string['freemium.subscriptionplan_free'] = 'Gratis';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Actualizează-ți planul';
$string['freemium.subscriptionplan_validuntil'] = 'valid până la {{ date }}';
$string['freemium.subscriptionplanlearnmore'] = 'Află mai multe';
$string['freemium.upsell_renewexpired'] = 'Abonamentul a expirat';
$string['freemium.upsell_renewexpiring'] = 'Abonamentul tău va expira în {{ days }} zile';
$string['freemium.upsell_renewtitle'] = 'Reînnoiește-ți abonamentul';
$string['freemium.upsell_upgradefreeaccept'] = 'Actualizează';
$string['freemium.upsell_upgradefreemessage'] = 'În prezent aveți planul gratis de abonament, faceți upgrade pentru a debloca mai multe opțiuni.';
$string['freemium.upsell_upgradefreepostpone'] = 'Mai târziu';
$string['freemium.upsell_upgradefreetitle'] = 'Actualizează-ți planul';
$string['pluginname'] = 'Șiruri de caractere de limbă pentru aplicația Moodle App';
$string['privacy_metadata'] = 'Acest plugin nu stochează date despre utilizatori.';
