<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'sl', version '4.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Dejanje';
$string['activityoverview'] = 'Čakajo vas vprašalniki z rokom do:';
$string['additionalinfo'] = 'Dodatne informacije';
$string['additionalinfo_help'] = 'Besedilo se prikaže na vrhu prve strani vprašalnika (npr.: navodila, informacije ipd.).';
$string['addnewquestion'] = 'Dodajanje vprašanja {$a}';
$string['addnewsection'] = 'Dodaj nov odsek';
$string['addquestion'] = 'Dodaj vprašanje...';
$string['addquestions'] = 'Dodaj vprašanja';
$string['addquestiontosection'] = 'Dodaj vprašanje v odsek';
$string['addselqtype'] = 'Dodaj izbrano vrsto vprašanja';
$string['alignment'] = 'Razvrstitev izbirnih gumbov';
$string['alignment_help'] = 'Izberi razvrstitev gumbov: navpična (privzeto) ali vodoravna.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Vse';
$string['alreadyfilled'] = 'Ta vprašalnik ste že izpolnili{$a}. Hvala.';
$string['andaveragevalues'] = 'in povprečne vrednosti';
$string['anonymous'] = 'Anonimen';
$string['answer'] = 'Odgovor';
$string['answergiven'] = 'Odgovor je bil podan';
$string['answernotgiven'] = 'Odgovor ni bil podan';
$string['answerquestions'] = 'Odgovorite na vprašanja ...';
$string['answers'] = 'Odgovori';
$string['attempted'] = 'Ta vprašalnik je bil oddan';
$string['attemptstillinprogress'] = 'V teku. Shranjeno:';
$string['autonumbering'] = 'Samodejno številčenje';
$string['autonumbering_help'] = 'Samodejno številčenje vprašanj in strani. Če uporabljate razvejanja vprašanja je bolje, da številčenjen izklopite.';
$string['autonumberno'] = 'Ne oštevilči vprašanj in strani';
$string['autonumberpages'] = 'Oštevilči strani';
$string['autonumberpagesandquestions'] = 'Oštevilči strani in vprašanja';
$string['autonumberquestions'] = 'Oštevilči vprašanja';
$string['average'] = 'Povprečje';
$string['averageposition'] = 'Povprečno mesto';
$string['averagerank'] = 'Povprečna razvrstitev';
$string['bodytext'] = 'Besedilo';
$string['boxesnbexact'] = 'točno toliko polj: {$a}.';
$string['boxesnbmax'] = 'največ toliko polj: {$a}.';
$string['boxesnbmin'] = 'vsaj toliko polj: {$a}.';
$string['boxesnbreq'] = 'Pri tem vprašanju morate obkljukati';
$string['by'] = 'od';
$string['cannotviewpublicresponses'] = 'Ogled odgovorov na ta javno dostopen vprašalnik ni mogoč.';
$string['chart:bipolar'] = 'Dvopolne vrstice';
$string['chart:hbar'] = 'Stolpčni grafikon';
$string['chart:radar'] = 'Radarski grafikon';
$string['chart:rose'] = 'Polarni grafikon';
$string['chart:type'] = 'Vrsta grafikona';
$string['chart:type_help'] = 'Izberite vrsto grafikona, s katerim želite prikazati te odzive';
$string['chart:vprogress'] = 'Navpičen prikaz napredka';
$string['checkallradiobuttons'] = 'Obkljukajte naslednje <strong>{$a}</strong> izbirne gumbe!';
$string['checkboxes'] = 'Potrditvena polja';
$string['checkboxes_help'] = 'V vsako vrstico vnesite po eno možnost, da bo uporabnik lahko zbral enega ali več odgovorov.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nekaj prelomov strani je vnesenih na naslednja mesta:';
$string['checkbreaksok'] = 'Besedilo vsebuje vse potrebne prelome strani!';
$string['checkbreaksremoved'] = 'Odstrani toliko odvečnih prelomov strani: {$a}.';
$string['checknotstarted'] = 'Izberite še ni začeto';
$string['checkstarted'] = 'Izberite začeto';
$string['clicktoswitch'] = '(klikni za spremembo)';
$string['closed'] = 'Vprašalnik se je zaprl na naslednji datum: {$a}. Hvala.';
$string['closedate'] = 'Uporabi datum zaprtja';
$string['closeson'] = 'Vprašalnik se zapre {$a}';
$string['completionsubmit'] = 'Udeleženec mora oddati ta vprašalnik, da ga zaključi';
$string['condition'] = 'Pogoj';
$string['confalts'] = '- OR - <br />Potrditvena stran';
$string['configmaxsections'] = 'Največje število odsekov z odzivi';
$string['configusergraph'] = 'Prikaži grafikone z odzivi na osebnostni test';
$string['configusergraphlong'] = 'Uporabi knjižnico <a href="http://www.rgraph.net/">Rgraph</a> za prikaz grafikonov z odzivi na osebnostni test.';
$string['confirmdelallresp'] = 'Ste prepričani, da želite izbrisati vse odzive na ta vprašalnik?';
$string['confirmdelchildren'] = 'Če izbrišete ta odgovor, boste izbrisali tudi naslednje podrejene odgovore:';
$string['confirmdeletesection'] = 'Ste prepričani, da želite izbrisati odsek z odzivi »{$a}«?';
$string['confirmdelgroupresp'] = 'Ste prepričani, da želite izbrisati vse odgovore na {$a}?';
$string['confirmdelquestion'] = 'Ste prepričani, da želite izbrisati vprašanje na položaju {$a}?';
$string['confirmdelquestionresps'] = 'S tem boste izbrisali tudi naslednje število odgovorov na to vprašanje: {$a}.';
$string['confirmdelresp'] = 'Ste prepričani, da želite izbrisati odgovor by&nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Ste prepričani, da želite odstraniti vprašanje »{$a->qname}« iz odseka »{$a->sname}«?';
$string['confpage'] = 'Besedilo naslova';
$string['confpage_help'] = 'Naslov (odebeljeno) in besedilo "Potrditvene" strani,ki se prikažeta, potem ko uporabnik izpolni vprašalnik. (Če je URL naveden, ima prednost pred potrditvenim besedilom.) Če pustite to polje prazno, se po izpolnitvi vprašalnika prikaže privzeto sporočilo: Hvala, ker ste izpolnili ta vprašalnik.';
$string['confpagedesc'] = 'Naslov (odebeljeno) in besedilo &quot;Potrditvene&quot; strani,ki se prikažeta, potem ko uporabnik izpolni vprašalnik. (Če je URL naveden, ima prednost pred potrditvenim besedilom.)';
$string['contentoptions'] = 'Nastavitve vsebine';
$string['couldnotcreatenewsurvey'] = 'Ustvarjanje nove ankete ni bilo uspešno!';
$string['couldnotdelresp'] = 'Brisanje odgovora ni bilo uspešno';
$string['createcontent'] = 'Nastavitve vsebine';
$string['createcontent_help'] = 'Izberite eno možnost. Privzeta je "Ustvari novo".';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Ustvari novo';
$string['crontask'] = 'Čiščenje vprašalnika';
$string['date'] = 'Datum';
$string['date_help'] = 'Uporabite to vrsto vprašanja, če pričakujete, da bo odgovor nanj datum v pravilni obliki.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Datum zapišite v obliki dan/mesec/leto, na primer 14. marec 1945:&nbsp; <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Izbriši VSE odgovore';
$string['deletecurrentquestion'] = 'Izbriši vprašanje {$a}';
$string['deletedallgroupresp'] = 'Vsi odgovori v skupini {$a} so bili izbrisani';
$string['deletedallresp'] = 'Odgovori na vprašalnik so izbrisani';
$string['deletedisabled'] = 'Elementa ni bilo mogoče izbrisati';
$string['deletedresp'] = 'Izbriši odgovor';
$string['deleteresp'] = 'Izbriši ta odgovor';
$string['deletesection'] = 'Izbriši ta odsek';
$string['deletingresp'] = 'Brišem odgovor';
$string['dependencies'] = 'Odvisnosti';
$string['dependquestion'] = 'Nadrejeno vprašanje';
$string['dependquestion_help'] = 'Lahko izberete nadrejeno vprašanje in možnosti odgovorov nanj. Podrejeno vprašanje bo prikazano
 udeležencu samo v primeru, če je izbral nadrejeno vprašanje in odgovor.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Udeleženec ni odgovoril na vprašanje';
$string['directwarnings'] = 'Elementi, ki so neposredno odvisni od tega vprašanja, bodo odstranjeni. To bo vplivalo na:';
$string['displaymethod'] = 'Način prikaza vprašanja ni določen.';
$string['download'] = 'Prenesi';
$string['downloadtextformat'] = 'Prenesi v formatu CSV';
$string['downloadtextformat_help'] = 'S to funkcijo lahko shranite vse odzive na vprašalnik v obliki besedilne datoteke (CSV).
 To datoteko lahko potem uvozite v program za preglednice (npr. MS Excel ali Open Office Calc) ali v statistični paket za nadaljnjo obdelavo podatkov.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['dropdown'] = 'Spustno polje';
$string['dropdown_help'] = 'Spustno polje nima nobenih prednosti pred izbirnimi gumbi
, razen mogoče pri več odgovorih, saj zasede manj prostora na zaslonu kot izbirni gumbi.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Uredi';
$string['editingfeedback'] = 'Urejanje nastavitev odziva';
$string['editingquestionnaire'] = 'Urejanje nastavitev vprašalnika';
$string['editquestion'] = 'Urejanje vprašanja {$a}';
$string['email'] = 'E-pošta';
$string['errnewname'] = 'To ime je žal že zasedeno. Izberite drugo ime.';
$string['erroropening'] = 'Napaka pri odpiranju vprašalnika.';
$string['errortable'] = 'Napaka: pokvarjena sistemska tabela.';
$string['essaybox'] = 'Opisno polje';
$string['essaybox_help'] = 'Pri tem vprašanju se bo prikazalo polje z x številom stolpcev (ali širino polja) in y številom vrstic v polju (ali s številom vrstic besedila).

Če pustite obe števili x in y nastavljeni na privzeto vrednost 0 (ali če ju nastavite na 0), se bo prikazal Moodlov urejevalnik HTML
 standardne višine in širine (če je na voljo za kontekst predmeta/uporabnika in za profil uporabnika).';
$string['event_all_responses_deleted'] = 'Vsi odgovori so izbrisani';
$string['event_all_responses_saved_as_text'] = 'Vsi odgovori so shranjeni v obliki besedila';
$string['event_all_responses_viewed'] = 'Poročilo o vseh odgovorih ogledano';
$string['event_individual_responses_viewed'] = 'Poročilo o posameznih odgovorih ogledano';
$string['event_non_respondents_viewed'] = 'Neodgovorjeni';
$string['event_previewed'] = 'Vprašalnik predogledan';
$string['event_question_created'] = 'Vprašanje je ustvarjeno';
$string['event_question_deleted'] = 'Vprašanje je izbrisano';
$string['event_response_deleted'] = 'Posamezni odgovor je izbrisan';
$string['event_resumed'] = 'Nadaljevan poskus';
$string['event_saved'] = 'Odgovori so shranjeni';
$string['event_submitted'] = 'Oddani odgovori';
$string['feedback'] = 'Odziv';
$string['feedback_help'] = 'Pomoč z odzivi';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Dodaj toliko polj z odzivi: {no}';
$string['feedbackbysection'] = 'Odziv iz odsekov';
$string['feedbackdefaultlabel'] = '[Nov odsek]';
$string['feedbackeditingglobal'] = 'Urejanje splošnih odzivov na vprašalnik';
$string['feedbackeditingmessages'] = 'Urejanje sporočil o odzivu na vprašalnik';
$string['feedbackeditingsections'] = 'Urejanje odsekov z odzivi na vprašalnik';
$string['feedbackeditmessages'] = 'Shrani nastavitve odsekov in uredi sporočila o odzivih';
$string['feedbackeditsections'] = 'Shrani nastavitve in uredi odseke z odzivi';
$string['feedbackerrorboundaryformat'] = 'Mejne vrednosti rezultatov odzivov morajo biti v odstotkih ali številčne vrednosti. Vrednost, ki ste jo vnesli k mejni vrednosti {$a} ni bila prepoznana.';
$string['feedbackerrorboundaryoutofrange'] = 'Mejna vrednost rezultatov odzivov mora biti med 0 % in 100 %. Vrednost, ki ste jo vnesli k mejni vrednosti {$a}, je izven ustreznega območja vrednosti.';
$string['feedbackerrorjunkinboundary'] = 'Izpolniti morate polja z mejnimi vrednostmi rezultatov odzivov tako, da ne pustite praznih mest.';
$string['feedbackerrorjunkinfeedback'] = 'Polja za odziv morate izpolniti brez praznin.';
$string['feedbackerrororder'] = 'Mejne vrednosti rezultatov odzivov morajo biti razvrščene od najvišjih do najnižjih. Vrednost, ki ste jo vnesli k mejni vrednost {$a} ni v pravilnem vrstnem redu.';
$string['feedbackglobal'] = 'Splošni odziv';
$string['feedbackglobalheading'] = 'Naslov splošnega odziva';
$string['feedbackglobalmessages'] = 'Sporočila o splošnem odzivu';
$string['feedbackhdr'] = 'Odzivi';
$string['feedbackheading'] = 'Naslov odzivov';
$string['feedbackheading_help'] = 'V polju za naslov odziva lahko uporabite dve spremenljivki: $scorepercent in $oppositescorepercent.';
$string['feedbackmessages'] = 'Sporočila z odseka: {$a}';
$string['feedbacknextsection'] = 'Naslednji odsek: {$a}';
$string['feedbacknone'] = 'Ni sporočil o odzivu';
$string['feedbacknotes'] = 'Ocene odzivov';
$string['feedbacknotes_help'] = 'Besedilo, ki ga boste vnesli sem, bo prikazano prejemnikom na koncu poročila z odzivi';
$string['feedbackoptions'] = 'Možnosti odzivov';
$string['feedbackoptions_help'] = 'Možnosti odzivov so na voljo, če vaš vprašalnik vsebuje naslednje vrste in nastavitve vprašanj:
izbirni gumbi; spustno polje; Da/Ne ali ocena (navadna ali Osgoodov semantični diferencial). Ta vprašanja morate označiti kot obvezna, polje z imenom vprašanja NE sme biti prazno in ponujeni odgovori morajo vsebovati vrednost.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'To vprašanje je del odseka z odzivi [{$a}]';
$string['feedbackremovesection'] = 'Če boste odstranili to vprašanje, boste povsem odstranili odsek z odzivi [{$a}]';
$string['feedbackreport'] = 'Poročilo o odzivih';
$string['feedbackscore'] = 'Rezultat odzivov';
$string['feedbackscoreboundary'] = 'Mejna vrednost rezultatov odzivov';
$string['feedbackscores'] = 'Prikaži rezultate';
$string['feedbackscores_help'] = 'Prikaži tabelo rezultatov odzivov';
$string['feedbacksection'] = 'Odsek';
$string['feedbacksectionheading'] = 'Naslov odseka: {$a}';
$string['feedbacksectionheadingmissing'] = 'Temu odseku z odzivi morate določiti naslov!';
$string['feedbacksectionheadingtext'] = 'Naslov';
$string['feedbacksectionlabel'] = 'Oznaka';
$string['feedbacksectionlabel_help'] = 'Ta oznaka bo uporabljena v grafikonih/diagramih. Naj bo čim krajša!';
$string['feedbacksectionquestions'] = 'Vprašanja pri odseku: {$a}';
$string['feedbacksections'] = 'Odseki z odzivi';
$string['feedbacksectionsselect'] = 'Odseki';
$string['feedbacksectionsselect_help'] = 'Svoja vprašanja napišite v te odseke';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Nastavitve odziva so shranjene';
$string['feedbacktype'] = 'Vrsta odziva';
$string['field'] = 'Vprašanje {$a}';
$string['fieldlength'] = 'Dolžina vnosnega polja';
$string['fieldlength_help'] = 'Za vrsto vprašanja **Besedilno polje**, vnesite **Vnos velikosti polja** in **Največja dolžina besedila** besedila, ki ga vnese
vprašanec.

Privzete vrednosti so 20 znakov za širino Vnosa polja in 25 znakov za največjo dolžino vnesenega besedila.';
$string['finished'] = 'Odgovorili ste na vsa vprašanja!';
$string['firstrespondent'] = 'Prvi anketiranec';
$string['formateditor'] = 'Urejevalnik HTML';
$string['formatplain'] = 'Navadno besedilo';
$string['grade'] = 'Ocenjevanje odgovorov';
$string['gradesdeleted'] = 'Ocena odgovorov iz vprašalnika izbrisana';
$string['headingtext'] = 'Besedilo naslova';
$string['horizontal'] = 'Vodoravno';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Vključite izbirne kode';
$string['includechoicetext'] = 'Vključite izbirno besedilo';
$string['includeincomplete'] = 'Vključite nepopolne odgovore';
$string['incorrectcourseid'] = 'ID predmeta je napačen';
$string['incorrectmodule'] = 'ID modula predmeta je napačen';
$string['incorrectquestionnaire'] = 'Vprašalnik ni pravilen';
$string['indirectwarnings'] = 'Ta seznam prikazuje posredno odvisna vprašanja in preostale odvisnosti za neposredno odvisna vprašanja:';
$string['invalidresponse'] = 'Določen je neveljaven odgovor.';
$string['invalidresponserecord'] = 'Določen je neveljaven zapis odgovora.';
$string['invalidsectionid'] = 'Določen je neveljaven odsek z odzivi.';
$string['invalidsurveyid'] = 'ID vprašalnika je neveljaven.';
$string['kindofratescale'] = 'Vrsta merilne lestvice';
$string['kindofratescale_help'] = 'Kliknite z desno tipko miške na spodnjo povezavo »Dodatna pomoč«.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Zadnji anketiranec';
$string['length'] = 'Dolžina';
$string['managequestions'] = 'Upravljanje vprašanj';
$string['managequestions_help'] = 'V odseku »Upravljanje vprašanj« na strani »Urejanje vprašanj« lahko upravljate z vprašanji iz vprašalnika na različne načine.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obvezno - Vsem tem odvisnostim mora biti ugojeno.';
$string['maxdigitsallowed'] = 'Največje dovoljeno število cifer';
$string['maxdigitsallowed_help'] = 'Uporabite **Največje dovoljeno število cifer**, da določite omejitev števila cifer pri odgovorih, ki zahtevajo številčne vrednosti. Pri tem upoštevajte,
da tudi decimalna vejica šteje kot en znak!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Največje število vsiljenih odgovorov';
$string['maxforcedresponses_help'] = 'Uporabite te parametre, da od anketiranca zahtevate, da obkljuka najmanjše število **Min.** in največje število **Max.** potrditvenih polj. Da
vsilite točno določeno število obkljukanih potrditvenih polj, nastavite **Min.** in **Max.** na enako vrednost. Če želite vsiliti samo najmanjše ali največje število polj, samo pustite drugo
vrednost nastavljeno na privzeto vrednost **0**. Če nastavite **Min.** ali **Max.** na katere koli druge vrednosti kot na privzeto vrednost **0**, se bo prikazalo opozorilo, če
anketiranec ne bo upošteval vaših omejitev. Seveda morate jasno obvestiti anketiranca o teh omejitvah, bodisi v splošnih navodilih
vprašalnika ali znotraj vprašanj, za katera veljajo te omejitve.';
$string['maxtextlength'] = 'Največja dolžina besedila';
$string['maxtextlength_help'] = 'Za tip vprašanja Besedilno polje, vnesite Vnos velikosti polja in Največjo dolžino besedila, ki ga lahko vnese vprašanec.
Privzete vrednosti so 20 znakov za širino Vnosa polja in 25 znakov za največjo dolžino vnesenega besedila.';
$string['messageprovider:message'] = 'Opomnik vprašalnika';
$string['messageprovider:notification'] = 'Oddaja vprašalnika';
$string['minforcedresponses'] = 'Najmanj prisilnih odzivov';
$string['minforcedresponses_help'] = 'Uporabite te parametre, da od anketiranca zahtevate, da obkljuka najmanjše število **Min.** in največje število **Max.** potrditvenih polj. Da
vsilite točno določeno število obkljukanih potrditvenih polj, nastavite **Min.** in **Max.** na enako vrednost. Če želite vsiliti samo najmanjše ali največje število polj, samo pustite drugo
vrednost nastavljeno na privzeto vrednost **0**. Če nastavite **Min.** ali **Max.** na katere koli druge vrednosti kot na privzeto vrednost **0**, se bo prikazalo opozorilo, če
anketiranec ne bo upošteval vaših omejitev. Seveda morate jasno obvestiti anketiranca o teh omejitvah, bodisi v splošnih navodilih
vprašalnika ali znotraj vprašanj, za katera veljajo te omejitve.';
$string['misconfigured'] = 'Predmet ni pravilno konfiguriran';
$string['missingname'] = 'Vprašanja {$a} se ne da vključiti v ta odsek z odzivi, saj ni poimenovano.';
$string['missingnameandrequired'] = 'Vprašanja {$a} se ne da vključiti v ta odsek z odzivi, saj ni poimenovano in ni bilo obvezno.';
$string['missingquestion'] = 'Prosimo, da odgovorite na zahtevano vprašanje';
$string['missingquestions'] = 'Prosimo, da odgovorite na zahtevana vprašanja';
$string['missingrequired'] = 'Vprašanja {$a} se ne da vključiti v ta odsek z odzivi, saj ni bilo obvezno.';
$string['modulename'] = 'Vprašalnik';
$string['modulename_help'] = 'S tem modulom vprašalnika lahko ustvarite ankete, s katerimi lahko z različnimi vrstami vprašanj zbirate podatke od uporabnikov.';
$string['modulenameplural'] = 'Vprašalniki';
$string['movedisabled'] = 'Tega elementa ni mogoče premakniti';
$string['myresponses'] = 'Vsi vaši odgovori';
$string['myresponsetitle'] = 'Vaši odgovori ({$a})';
$string['myresults'] = 'Vaši rezultati';
$string['name'] = 'Ime';
$string['navigate'] = 'Dovoli razvejana vprašanja';
$string['navigate_help'] = 'Omogoči da se lahko vprašanja Da/Ne in izbirna vprašanja razvejajo na podvprašanja v odvisnosti od podanih odgovorov.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Pojdi na odsek z odzivi';
$string['next'] = 'Naslednji';
$string['nextpage'] = 'Naslednja stran';
$string['nlines'] = 'Št. vrstic: {$a}';
$string['noanswer'] = 'Ni odgovora';
$string['noattempts'] = 'Ni bilo poskusov reševanja tega vprašalnika';
$string['nodata'] = 'Ni objavljenih podatkov.';
$string['noduplicates'] = 'Brez podvojenih izbir';
$string['noduplicateschoiceserror'] = 'Pri možnosti »Brez podvojenih izbir« morate vnesti vsaj dva možna odgovora!';
$string['non_respondents'] = 'Uporabniki, ki še niso odgovorili na vprašalnik';
$string['noneinuse'] = 'V tem vprašalniku ni nobenega vprašanja.';
$string['nopublicsurveys'] = 'Ni javnih vprašalnikov.';
$string['noresponsedata'] = 'Za to vprašanje ni odgovorov.';
$string['noresponses'] = 'Ni odgovorov';
$string['normal'] = 'Navadno';
$string['not_started'] = 'še ni začeto';
$string['notanumber'] = '<strong>{$a}</strong> ni zapisan v ustrezni obliki zapisa števila.';
$string['notapplicable'] = 'Ni na voljo';
$string['notapplicablecolumn'] = 'Stolpec »Ni na voljo«';
$string['notavail'] = 'Ta vprašalnik ni več na voljo. Prosite svojega učitelja, naj ga izbriše.';
$string['noteligible'] = 'Niste upravičeni do izpolnjevanja tega vprašalnika.';
$string['notemplatesurveys'] = 'Ni predlog vprašalnikov.';
$string['notenoughscaleitems'] = 'Vnesti morate najmanj 2 števili stopenj lestvice!';
$string['notificationfull'] = 'Popolna oddaja';
$string['notifications'] = 'Pošlji obvestila o oddaji';
$string['notifications_help'] = 'Ko je oddan prispevek, obvesti vloge z možnostjo »mod/questionnaire:submissionnotification«.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Samo obvestilo';
$string['notopen'] = 'Vprašalnik se bo odprl šele na ta datum: {$a}.';
$string['notrequired'] = 'Odgovor ni potreben';
$string['notset'] = 'ni nastavljeno';
$string['nousersselected'] = 'Ni izbranih uporabnikov';
$string['num'] = '#';
$string['numattemptsmade'] = 'Št. poskusov reševanja vprašalnika: {$a}';
$string['numberfloat'] = 'Številka, ki ste jo vpisali <strong>{$a->number}</strong> je preoblikovana/zaokrožena <strong>{$a->precision}</strong> z decimalko.';
$string['numberofdecimaldigits'] = 'Število decimalnih mest';
$string['numberofdecimaldigits_help'] = 'Uporabite **Število decimalnih mest**, da določite obliko zapisa povprečne vrednosti, ki bo izračunana in prikazana na strani poročila o vprašalniku.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Število elementov v merilu';
$string['numberscaleitems_help'] = 'Število elementov v merilu je *število elementov*, ki jo uporabite na merilni lestvici. Navadno bi uporabili vrednost od 3 do 5. Privzeta vrednost: **5**.';
$string['numeric'] = 'Številski';
$string['numeric_help'] = 'Uporabite to vrsto vprašanja, če pričakujete, da bo odgovor nanj število v pravilni obliki.';
$string['of'] = 'od';
$string['opendate'] = 'Uporabi datum odprtja';
$string['option'] = 'možnost {$a}';
$string['optional'] = 'Neobvezno - izpolnjena mora biti vsaj ena od teh odvisnosti.';
$string['optionalname'] = 'Ime vprašanja';
$string['optionalname_help'] = 'Ime vprašanja se uporabi le takrat, ko izvozite odgovore v CSV/Excel obliki.
 Če nikoli ne izvozite v CSV obliki, se ne rabite ukvarjati z Imeni vprašanj.
 Če nameravate pogosto izvažati podatke vprašalnika v CSV obliki, potem imate dve možnosti poimenovanja vprašanj.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OR -';
$string['order_ascending'] = 'Naraščajoče';
$string['order_default'] = 'Ogled privzete razvrstitve';
$string['order_descending'] = 'Padajoče';
$string['orderresponses'] = 'Zahtevajte odgovore';
$string['orderresponses_help'] = 'Ob prikazovanju Vseh odgovorov lahko zahtevate možnosti s številom odgovorov (Povprečni stolpec) za naslednje
 4 vrste vprašanj.

* posamezne možnosti radijskega gumba
* posamezne možnosti spustnega seznama
* več možnosti (potrditvena polja)
* ocenjevalna vprašanja (vključno z lestvicami Likert).

Ko pridete na spletno stran Vsi odgovori, so vsi odgovori privzeto razvrščeni v vrstnem redu možnih odgovorov, kot jih je vnesel ustvarjalec vprašalnika.
 Lahko jih razporedite po naraščajočem ali padajočem vrstnem redu.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Drugo:';
$string['otherempty'] = 'Če izberete to možnosti, morate vnesti nekaj besedila v besedilno polje!';
$string['overviewnumresplog'] = 'odgovori';
$string['overviewnumresplog1'] = 'odgovor';
$string['overviewnumrespvw'] = 'odgovori';
$string['overviewnumrespvw1'] = 'odgovor';
$string['owner'] = 'Lastnik';
$string['page'] = 'Stran';
$string['pageof'] = 'Stran {$a->page} od {$a->totpages}';
$string['parent'] = 'Nadrejeni';
$string['participant'] = 'Sodelujoči';
$string['pleasecomplete'] = 'Prosim izpolnite to možnost.';
$string['pluginadministration'] = 'Administracija vprašalnika';
$string['pluginname'] = 'Vprašalnik';
$string['position'] = 'pozicija';
$string['possibleanswers'] = 'Možni odgovori';
$string['posteddata'] = 'Dosežena stran z objavljenimi podatki:';
$string['preview_label'] = 'Predogled';
$string['preview_questionnaire'] = 'Predogled vprašalnika';
$string['previewing'] = 'Predogled vprašalnika';
$string['previous'] = 'Prejšnji';
$string['previouspage'] = 'Prejšnja stran';
$string['print'] = 'Tiskaj ta odgovor';
$string['printblank'] = 'Natisni prazen';
$string['printblanktooltip'] = 'Odpre se tiskalniku prijazno okno s praznim vprašalnikom';
$string['printtooltip'] = 'Odpre odgovor v oknu za tiskanje';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Odgovor na vprašanje izbirnega tipa.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID zabeleženih možnosti za ta odgovor.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Odgovor na vprašanje z enim izbirnim odgovorom.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID zabeleženih možnosti za ta odgovor.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response'] = 'Odgovor v teku ali oddan';
$string['privacy:metadata:questionnaire_response:complete'] = 'Stanje zaključenih odgovorov.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Ocena za ta odgovor.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Časovni žig za najnovejši shranjen odgovor.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID uporabnika za ta odgovor.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Logičen (ja/ne) odgovor na vprašanje.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Natančen logičen odgovor.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_date'] = 'Odgovor na vprašanje z datumom.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Natančen datum odgovora.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_other'] = 'Besedilni odgovor \'drugo\'.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID zabeleženih možnosti za ta odgovor.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Natančen odgovor v obliki besedila.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Odgovor na razvščevalno vprašanje.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID zabeleženih možnosti za ta odgovor.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Natančna vrsta odgovora.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_text'] = 'Odgovor na vprašanje odprtega tipa.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID zabeleženih odgovorov za ta odgovor.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Natančen odgovor v obliki besedila.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID zabeleženih vprašalnikov za ta odgovor.';
$string['private'] = 'Zasebni';
$string['public'] = 'Javni';
$string['publiccopy'] = 'Kopija:';
$string['publicoriginal'] = 'Izvirnik:';
$string['qtype'] = 'Vrsta';
$string['qtype_help'] = 'Izberite, ali bo udeležencem dovoljeno odgovoriti enkratno, dnevno, tedensko, mesečno ali neomejeno krat.';
$string['qtypedaily'] = 'odgovarjaj dnevno';
$string['qtypemonthly'] = 'odgovarjaj mesečno';
$string['qtypeonce'] = 'odgovori enkrat';
$string['qtypeunlimited'] = 'odgovori večkrat';
$string['qtypeweekly'] = 'odgovori tedensko';
$string['questionnaire:addinstance'] = 'Dodaj nov vprašalnik';
$string['questionnaire:copysurveys'] = 'Kopiraj predložne in zasebne vprašalnike';
$string['questionnaire:createpublic'] = 'Ustvari javne vprašalnike';
$string['questionnaire:createtemplates'] = 'Ustvari predloge vprašalnikov';
$string['questionnaire:deleteresponses'] = 'Izbriši katerikoli odgovor';
$string['questionnaire:downloadresponses'] = 'Prenesi odgovore v datoteki CSV';
$string['questionnaire:editquestions'] = 'Ustvari in uredi vprašanja za vprašalnik';
$string['questionnaire:manage'] = 'Ustvari in uredi vprašalnike';
$string['questionnaire:message'] = 'Pošlji sporočilo udeležencem, ki še niso odgovorili';
$string['questionnaire:preview'] = 'Predogled vprašalnikov';
$string['questionnaire:printblank'] = 'Natisni prazen vprašalnik';
$string['questionnaire:readallresponseanytime'] = 'Preberi vse odgovore kadarkoli';
$string['questionnaire:readallresponses'] = 'Preberi povzetke odgovorov, zadeva za čas odprtja';
$string['questionnaire:readownresponses'] = 'Preberi lastne odgovore';
$string['questionnaire:submissionnotification'] = 'Prejmi obvestila za vsako oddajo';
$string['questionnaire:submit'] = 'Dokončaj in oddaj vprašalnik';
$string['questionnaire:view'] = 'Poglej vprašalnik';
$string['questionnaire:viewsingleresponse'] = 'Poglej izpolnjene posamezne odgovore';
$string['questionnaireadministration'] = 'Administracija vprašalnika';
$string['questionnairecloses'] = 'Zaprtje vprašalnika';
$string['questionnaireopens'] = 'Vprašalnik se odpre';
$string['questionnairereport'] = 'Poročilo o vprašalniku';
$string['questionnum'] = 'Vprašanje #';
$string['questions'] = 'Vprašanja';
$string['questionsinsection'] = 'Vprašanja v tem odseku:';
$string['questiontypes'] = 'Vrste vprašanj';
$string['questiontypes_help'] = 'Glej Moodle dokumentacijo spodaj';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Izbirni gumbi';
$string['radiobuttons_help'] = 'Pri tej vrsti vprašanja mora udeleženec izbrati eno izmed ponujenih možnosti.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Vrsta';
$string['ratescale'] = 'Stopenjsko (lestvica 1..5)';
$string['ratescale_help'] = 'Glej Moodle dokumentacijo spodaj';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Vrsta vprašalnika';
$string['realm_help'] = 'Na voljo so tri vrste vprašalnikov:
* Zasebni - pripada predmetu, v katerem ga ustvarite
* Vzorčni - lahko ga urejate in kopirate
* Javni - lahko ga uporabite tudi pri drugih predmetih';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL, kamor je uporabnik preusmerjen po izpolnitvi vprašalnika.';
$string['remove'] = 'Izbriši';
$string['removeallquestionnaireattempts'] = 'Izbriši vse odgovore na vprašalnik';
$string['removenotinuse'] = 'Včasih je bil ta vprašalnik odvisen od Javnega vprašalnika, ki je bil izbrisan.
Ne more se ga več uporabljati in mora biti izbrisan.';
$string['required'] = 'Odgovor je potreben';
$string['required_help'] = 'Če izbereš ***Da***, bo zahtevan odgovor na vprašanje, tj.
udeleženec ne bo mogel oddati vprašalnika
dokler ne odgovori na vprašanje.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Manjkal je zahtevan dejavnik.';
$string['reset'] = 'Ponastavi';
$string['respeligiblerepl'] = '(zamenjane s pomembnejšimi vlogami)';
$string['respondent'] = 'Odgovarjal';
$string['respondenteligibleall'] = 'vse';
$string['respondenteligiblestudents'] = 'samo udeleženci';
$string['respondenteligibleteachers'] = 'samo učitelji';
$string['respondents'] = 'Anketiranci';
$string['respondenttype'] = 'Način anketiranja';
$string['respondenttype_help'] = 'Anketa je lahko anonimna ali pa je identiteta anketiranca lahko razkrita.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonimen';
$string['respondenttypefullname'] = 'z imenom';
$string['response'] = 'Odgovor';
$string['responsefieldlines'] = 'Vnos velikosti polja';
$string['responseformat'] = 'Oblika odgovora';
$string['responseoptions'] = 'Možnosti odgovorov';
$string['responses'] = 'Odgovori';
$string['responseview'] = 'Udeleženci lahko vidijo odgovore';
$string['responseview_help'] = 'Določite lahko, kdo lahko vidi vse odgovore na oddane vprašalnike.';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Vedno';
$string['responseviewstudentsnever'] = 'Nikoli';
$string['responseviewstudentswhenanswered'] = '... ko odgovorijo na vprašalnik';
$string['responseviewstudentswhenclosed'] = '... ko je vprašalnik zaprt';
$string['restrictedtoteacher'] = 'Te funkcije lahko uporabljajo samo profesorji, ki lahko urejajo!';
$string['resume'] = 'Shrani/Prikliči odgovore';
$string['resume_help'] = 'Udeleženci lahko shranijo svoje odgovore preden oddajo vprašalnik in na nedokončan vprašalnik odgovarjajo kasneje.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Nadaljuj z vprašalnikom';
$string['return'] = 'Nazaj';
$string['save'] = 'Shrani';
$string['saveasnew'] = 'Shrani kot novo vprašanje';
$string['savedbutnotsubmitted'] = 'Ta vprašalnik je bil shranjen, vendar ne še oddan.';
$string['savedprogress'] = 'Vaš napredek je shranjen. Lahko se vrnete kadarkoli, da izpolnite ta vprašalnik.';
$string['saveeditedquestion'] = 'Shrani vprašanje {$a}';
$string['savesettings'] = 'Shrani nastavitve';
$string['search:activity'] = 'Vprašalnik - informacije o dejavnosti';
$string['search:question'] = 'Vprašalnik - vprašanja';
$string['section'] = 'Opis';
$string['sectionbreak'] = '----- prelom strani -----';
$string['sectionbreak_help'] = '----- prelom strani -----';
$string['sectionsnotset'] = 'Izbrati morate najmanj ENO vprašanje na razdelek!<br />Section(s) not selected: {$a}';
$string['sectiontext'] = 'Oznaka';
$string['sectiontext_help'] = 'To ni vprašanje, ampak (kratko) besedilo, ki je prikazano, da uvede serijo vprašanj.';
$string['selecttheme'] = 'Izberite temo (css) za vprašalnik.';
$string['send'] = 'Pošlji';
$string['send_message'] = 'Pošlji sporočilo izbranim uporabnikom';
$string['send_message_to'] = 'Pošlji sporočilo:';
$string['sendemail'] = 'Pošlji e-pošto';
$string['sendemail_help'] = 'Pošlje kopijo vsakega oddanega vprašalnika na navedene naslove. Če vnašate več naslovov, jih ločite z vejico.';
$string['set'] = 'nastavi';
$string['settings'] = 'Nastavitve';
$string['settingssaved'] = 'Nastavitve so shranjene';
$string['show_nonrespondents'] = 'Neodgovorjeni';
$string['started'] = 'začeto';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Zadeva';
$string['submissionnotificationhtmlanon'] = 'Nova <a href=«{$a->submissionurl}«>oddaja</a> za "{$a->name}" vprašalnik.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> ima novo <a href=«{$a->submissionurl}«>oddajo</a> za "{$a->name}" vprašalnik pri predmetu "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nova oddaja vprašalnika';
$string['submissionnotificationtextanon'] = 'Nova oddaja ({$a->submissionurl}) za "{$a->name}" vprašalnik.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) ima novo oddajo ({$a->submissionurl}) za"{$a->name}" vprašalnik pri predmetu "{$a->coursename}".';
$string['submitoptions'] = 'Nastavitve oddaje';
$string['submitpreview'] = 'Oddaj predogled';
$string['submitpreviewcorrect'] = 'Ta oddaja bi bila sprejeta kot pravino izpolnjena.';
$string['submitsurvey'] = 'Oddaj vprašalnik';
$string['submitted'] = 'Oddano:';
$string['subtitle'] = 'Podnaslov';
$string['subtitle_help'] = 'Podnaslov vprašalnika se pojavi pod naslovom le na prvi strani.';
$string['summary'] = 'Povzetek';
$string['surveynotexists'] = 'vprašalnik ne obstaja.';
$string['surveyowner'] = 'Če želite izvesti ta postopek, morate biti lastnik vprašalnika.';
$string['surveyresponse'] = 'Odgovor na vprašalnik';
$string['template'] = 'Predloga';
$string['templatenotviewable'] = 'Predloženi vprašalniki so zdaj vidni.';
$string['text'] = 'Besedilo vprašanja';
$string['textareacolumns'] = 'Stolpci besedilnega polja';
$string['textareacolumns_help'] = 'To vprašanje bo prikazalo prazno besedilno polje z **x** *Stolpci besedilnega polja* (ali polje *širina*) in **y** *Vrstice besedilnega polja* (število besedilnih
*vrstic*).
Če želite pustiti x in y v njuni privzeti **0** vrednosti (ali če ju nastavite na **0**), se bo Moodlov urejevalnik HTML prikazal v privzeti višini in širini (če
je na voljo za kontekst predmeta/uporabnika &amp; profil uporabnika).';
$string['textarearows'] = 'Vrstice besedilnega polja';
$string['textbox'] = 'Besedilno polje';
$string['textbox_help'] = 'Za tip vprašanja Besedilno polje, vnesite Vnos velikosti polja in Največjo dolžino besedila, ki ga lahko vnese vprašanec.
Privzete vrednosti so 20 znakov za širino Vnosa polja in 25 znakov za največjo dolžino vnesenega besedila.';
$string['textdownloadoptions'] = 'Možnosti za prenos CSV-ja';
$string['thank_head'] = 'Hvala, ker ste izpolnili ta vprašalnik.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'ta mesec';
$string['thisresponse'] = 'Ta odgovor';
$string['thisweek'] = 'ta teden';
$string['thousands'] = 'Ne uporabite ločila tisočic.';
$string['title'] = 'Naslov';
$string['title_help'] = 'Naslov tega vprašalnika se pojavi na vrhu vsake strani. Privzeto je naslov nastavljen na ime vprašalnika, vendar to lahko spremenite.';
$string['today'] = 'danes';
$string['total'] = 'Skupaj';
$string['totalofnumbers'] = 'Skupno število vnesenih števil';
$string['totalresponses'] = 'Skupno število odgovorov na vprašanje';
$string['type'] = 'Vrsta vprašanja';
$string['undefinedquestiontype'] = 'Nedefinirana vrsta vprašanja!';
$string['unknown'] = 'Neznano';
$string['unknownaction'] = 'Opredeljen neznan ukaz za vprašalnik...';
$string['url'] = 'Potrditveni URL';
$string['url_help'] = 'URL, kamor je uporabnik preusmerjen po izpolnitvi vprašalnika.';
$string['useprivate'] = 'Kopiraj obstoječo';
$string['usepublic'] = 'Uporabi javno';
$string['usetemplate'] = 'Uporabi predlogo';
$string['vertical'] = 'Navpičen';
$string['view'] = 'Ogled';
$string['viewallresponses'] = 'Preglej vse odgovore';
$string['viewallresponses_help'] = 'Če je vprašalnik nastavljen na **Način skupine**: *Vidne skupine* ali je nastavljen na *Ločene skupine* in ima trenutni uporabnik
 dostop do *moodle/site:accessallgroups* (v trenutnem kontekstu) in so bile skupine določene za trenutni predmet,
 potem ima uporabnik dostop do spustnega menija skupin. Spustni meni omogoča uporabniku »filtrirati« odgovore na vprašalnik skupin.
 Če je nastavitev **Način skupine**: *Ločene skupine*, potem bodo lahko uporabniki, ki nimajo dostopa do
 *moodle/site:accessallgroups* (ponavadi študenti ali profesorji, ki ne urejajo itd.), videli samo odgovore skupine, h kateri pripadajo.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Seznam odgovorov';
$string['viewindividualresponse'] = 'Posamezni odgovori';
$string['viewindividualresponse_help'] = 'Na seznamu spodaj kliknite na imena udeležencev, da vidite njihove odgovore.';
$string['viewresponses'] = 'Vsi odgovori ({$a})';
$string['viewyourresponses'] = 'Vaši odgovori - ogled {$a}';
$string['warning'] = 'Opozorilo, najdena napaka.';
$string['wronganswers'] = 'Nekaj je narobe z vašimi odgovori (poglej spodaj)';
$string['wrongdateformat'] = 'Vnesen datum: <strong>{$a}</strong> ne ustreza obliki, prikazani v primeru.';
$string['wrongdaterange'] = 'NAPAKA! Leto mora biti nastavljeno v razponu med 1902 in 2037.';
$string['wrongformat'] = 'Nekaj je narobe z vašim odgovorom na vprašanje:&nbsp;';
$string['wrongformats'] = 'Nekaj je narobe z vašim odgovorom na vprašanje:&nbsp;';
$string['yesno'] = 'Da/Ne';
$string['yesno_help'] = 'Preprosto Da/Ne vprašanje';
$string['yourresponse'] = 'Vaš odgovor';
$string['yourresponses'] = 'Vaši odgovori';
