<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'it', version '4.0'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Aggiungi';
$string['addarandomquestion'] = 'domande casuali';
$string['addarandomquestion_help'] = 'Moodle aggiunge una selezione casuale di domande a scelta multipla (o domande a scelta multipla tutto o niente) all\'attuale gruppo di quiz offline. È possibile impostare il numero di domande aggiunte. Le domande vengono scelte dalla categoria di domande corrente (e, se selezionata, dalle sue sottocategorie).';
$string['addarandomselectedquestion'] = 'Aggiungi una domanda selezionata casualmente ...';
$string['addlist'] = 'Aggiungi elenco';
$string['addnewpagesafterselected'] = 'Aggiungi un salto pagina dopo le domande selezionate';
$string['addnewquestion'] = 'una nuova domanda';
$string['addnewquestionsqbank'] = 'Aggiungi domande alla categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Aggiungi personalizzazione utente';
$string['addpagebreak'] = 'Aggiungi salto di pagina';
$string['addpagehere'] = 'Aggiungi pagina qui';
$string['addparts'] = 'Aggiungi partecipanti';
$string['addquestionfrombankatend'] = 'Aggiungi alla fine pescando dal deposito domande';
$string['addquestionfrombanktopage'] = 'Aggiungi dal deposito delle domande alla pagina {$a}';
$string['addrandom'] = 'Aggiungi casualmente {$a} domande a scelta multipla';
$string['addrandomfromcategory'] = 'domande casuali';
$string['addrandomquestion'] = 'domande casuali';
$string['addrandomquestiontoofflinequiz'] = 'Aggiunta di domande al quiz offline {$a->name} (group {$a->group})';
$string['addrandomquestiontopage'] = 'Aggiungi domanda casuale alla pagina {$a}';
$string['addtoofflinequiz'] = 'Aggiungi al quiz offline';
$string['addtoqueue'] = 'Aggiungi alla coda';
$string['allinone'] = 'Illimitato';
$string['alllists'] = 'Tutti gli elenchi';
$string['allornothing'] = 'Tutto o niente';
$string['allresults'] = 'Visualizza tutti i risultati';
$string['allstudents'] = 'Visualizza tutti gli studenti';
$string['alwaysavailable'] = 'Sempre disponibile';
$string['analysis'] = 'Analisi dell\'oggetto';
$string['answerform'] = 'Modulo per le risposte';
$string['answerformforgroup'] = 'Modulo di risposta per il gruppo {$a}';
$string['answerforms'] = 'Moduli per le risposte';
$string['answerpdfxy'] = 'Modulo per le risposte ({$a}->maxquestions domande/ {$a}->maxanswers opzioni)';
$string['areyousureremoveselected'] = 'Sei sicuro di rimuovere tutte le domande selezionate?';
$string['attemptexists'] = 'Esiste un tentativo';
$string['attemptsexist'] = 'Non è più possibile aggiungere o rimuovere domande.';
$string['attemptsnum'] = 'Risultati: {$a}';
$string['attemptsonly'] = 'Visualizza solo studenti con risultati';
$string['attendances'] = 'Presenze';
$string['basicideasofofflinequiz'] = 'Idee di base per la creazione di quiz offline';
$string['blackwhitethreshold'] = 'Soglia bianco/nero';
$string['bulksavegrades'] = 'Salva voti';
$string['calibratescanner'] = 'Calibra scanner';
$string['cannoteditafterattempts'] = 'Non è possibile aggiungere o rimuovere domande perché ci sono già risultati completi. ({$a})';
$string['category'] = 'Categoria';
$string['changed'] = 'Il risultato è stato modificato.';
$string['changeevaluationmode'] = 'Cambia il modo in cui viene effettuata la valutazione. Possibile solo se consentito dall\'amministratore.';
$string['checkparts'] = 'Contrassegna i partecipanti selezionati come presenti';
$string['checkuserid'] = 'Controlla gruppo/ID utente';
$string['chooseagroup'] = 'Seleziona un gruppo';
$string['closebeforeopen'] = 'Impossibile aggiornare il quiz offline. Hai specificato una data di chiusura antecedente a quella di apertura.';
$string['closestudentview'] = 'Chiudi vista studente';
$string['closewindow'] = 'Chiudi finestra';
$string['cmmissing'] = 'Manca il modulo del corso per il quiz offline con ID {$a}';
$string['configblackwhitethreshold'] = 'Imposta la soglia per la conversione bianco/nero tra 1 e 99 - Più alto è il valore e maggiormente bianco dovrà essere il pixel importato per essere riconosciuto come bianco. Qualsiasi altro valore non comporta nessuna conversione bianco/nero.';
$string['configdecimalplaces'] = 'Numero di cifre che devono essere visualizzate dopo il punto decimale durante la visualizzazione dei voti per il quiz offline.';
$string['configdisableimgnewlines'] = 'Disabilita le nuove righe prima e dopo le immagini nei fogli delle domande in pdf. Attenzione: questo potrebbe causare problemi di formattazione.';
$string['configexperimentalevaluation'] = 'Valutazione sperimentale dei fogli di risposta';
$string['configexperimentalevaluationdesc'] = 'NON USARE IN UN SITO DI PRODUZIONE! Questa opzione viene utilizzata per i test alfa del nuovo algoritmo di valutazione. Se questa opzione è impostata su Sì, è possibile attivarla nelle opzioni dell\'istanza quiz offline. Sconsigliamo vivamente di utilizzare questa opzione. Non esiste alcun supporto per i dati persi a causa dell\'attivazione di questa opzione.';
$string['configintro'] = 'I valori impostati qui vengono utilizzati come valori predefiniti per le impostazioni di nuovi quiz offline.';
$string['configkeepfilesfordays'] = 'Determina per quanti giorni i file di immagine caricati vengono conservati nell\'archivio temporaneo. Durante questo periodo i file di immagine sono disponibili nel report di amministrazione del quiz offline.';
$string['configonlylocalcategories'] = 'Non sono consentite categorie di domande condivise.';
$string['configpapergray'] = 'valore del bianco della carta, che viene utilizzato per la valutazione dei fogli di risposta';
$string['configshuffleanswers'] = 'Risposte mescolate';
$string['configshufflequestions'] = 'Se si abilita questa opzione, l\'ordine delle domande nei gruppi di quiz offline verrà mescolato casualmente ogni volta che si ricrea l\'anteprima nella scheda "Crea moduli".';
$string['configshufflewithin'] = 'Se si abilita questa opzione, le parti che compongono le singole domande verranno mescolate casualmente quando vengono creati i moduli di domanda e risposta.';
$string['configuseridentification'] = 'Una formula per descrivere l\'identificazione dell\'utente. Questa formula è utilizzata per assegnare i moduli di risposta agli utenti del sistema. La parte destra dell\'equazione deve corrispondere a un campo della tabella utenti di Moodle.';
$string['confirmremovequestion'] = 'Sei sicuro di voler rimuovere questa domanda {$a}?';
$string['copy'] = 'Copia';
$string['copyright'] = '<strong>Attenzione: i testi in questa pagina sono solo per tua personale informazione. Come qualsiasi altro testo, queste domande sono soggette a restrizioni sul copyright. Non ti è permesso copiarli o mostrarli ad altre persone!</strong>';
$string['copyselectedtogroup'] = 'Aggiungi le domande selezionate al gruppo: {$a}';
$string['copytogroup'] = 'Aggiungi tutte le domande al gruppo: {$a}';
$string['correct'] = 'corretto';
$string['correcterror'] = 'risolvi';
$string['correctforgroup'] = 'Risposte corrette per il gruppo {$a}';
$string['correctionform'] = 'Correzione';
$string['correctionforms'] = 'Moduli per la correzione';
$string['correctionoptionsheading'] = 'Opzioni di correzione';
$string['correctupdated'] = 'Modulo di correzione aggiornato per il gruppo {$a}.';
$string['couldnotgrab'] = 'Impossibile acquisire l\'immagine {$a}';
$string['couldnotregister'] = 'Impossibile registrare l\'utente {$a}';
$string['createcategoryandaddrandomquestion'] = 'Crea una categoria e aggiungi una domanda casuale';
$string['createlistfirst'] = 'Aggiungi partecipanti';
$string['createofflinequiz'] = 'Crea moduli';
$string['createpartpdferror'] = 'Non è stato possibile creare il modulo PDF per l\'elenco dei partecipanti {$a}. L\'elenco potrebbe essere vuoto.';
$string['createpdf'] = 'Modulo';
$string['createpdferror'] = 'Non è stato possibile creare il modulo per il gruppo {$a}. Forse non ci sono domande nel gruppo.';
$string['createpdffirst'] = 'Crea prima l\'elenco PDF';
$string['createpdfforms'] = 'Crea moduli';
$string['createpdfs'] = 'Download moduli';
$string['createpdfsparticipants'] = 'Moduli PDF per l\'elenco dei partecipanti';
$string['createquestionandadd'] = 'Crea una nuova domanda e aggiungila al quiz.';
$string['createquiz'] = 'Crea moduli';
$string['csvfile'] = 'File CSV';
$string['csvformat'] = 'File di testo con valori separati da virgola (CSV)';
$string['csvplus1format'] = 'File di testo con dati non elaborati (CSV)';
$string['csvpluspointsformat'] = 'File di testo con punti (CSV)';
$string['darkgray'] = 'Grigio scuro';
$string['datanotsaved'] = 'Impossibile salvare le impostazioni';
$string['decimalplaces'] = 'Decimali';
$string['decimalplaces_help'] = 'Numero di cifre che devono essere visualizzate dopo il punto decimale durante la visualizzazione dei voti per il quiz offline.';
$string['deletelistcheck'] = 'Vuoi veramente eliminare la lista selezionata e tutti i suoi partecipanti?';
$string['deletepagecheck'] = 'Vuoi veramente eliminare le pagine selezionate?';
$string['deletepagesafterselected'] = 'Rimuovi le interruzioni di pagina dopo le pagine selezionate';
$string['deletepartcheck'] = 'Vuoi veramente eliminare i partecipanti selezionati?';
$string['deleteparticipantslist'] = 'Elimina lista dei partecipanti';
$string['deletepdfs'] = 'Elimina documenti';
$string['deleteresultcheck'] = 'Vuoi veramente eliminare i risultati selezionati?';
$string['deleteselectedpart'] = 'Elimina i partecipanti selezionati';
$string['deleteselectedresults'] = 'Elimina i risultati selezionati';
$string['deletethislist'] = 'Elimina questa lista';
$string['deleteupdatepdf'] = 'Elimina e aggiorna i moduli PDF';
$string['difficultytitle'] = 'Difficoltà';
$string['difficultytitlea'] = 'Difficoltà A';
$string['difficultytitleb'] = 'Difficoltà B';
$string['difficultytitlediff'] = 'Differenza';
$string['disableimgnewlines'] = 'Disabilita il ritorno a capo prima e dopo le immagini';
$string['disableimgnewlines_help'] = 'Questa opzione disabilita il ritorno a capo prima e dopo le immagini nei fogli delle domande in PDF. Questo potrebbe introdurre problemi di formattazione.';
$string['displayoptions'] = 'Mostra opzioni';
$string['done'] = 'fatto';
$string['downloadallzip'] = 'Scarica tutti i file come ZIP';
$string['downloadpartpdf'] = 'Scarica file PDF per la lista \'{$a}\'';
$string['downloadpdfs'] = 'Scarica documenti';
$string['downloadresultsas'] = 'Scarica i risultati come:';
$string['dragtoafter'] = 'Dopo {$a}';
$string['dragtostart'] = 'All\'inizio';
$string['editgroupquestions'] = 'Modifica domande del gruppo';
$string['editgroups'] = 'Modifica Gruppi Offline';
$string['editingofflinequiz'] = 'Modifica domande del gruppo';
$string['editingofflinequiz_help'] = 'Quando si crea un quiz offline, i concetti principali sono:
<ul><li> Il quiz offline, contiene domande in una o più pagine</li>
<li>Il deposito domande, che archivia copie di tutte le domande organizzate in categorie</li></ul>';
$string['editingofflinequizx'] = 'Modifica quiz offline: {$a}';
$string['editlist'] = 'Modifica lista';
$string['editlists'] = 'Modifica liste';
$string['editmaxmark'] = 'Modifica voto massimo';
$string['editofflinequiz'] = 'Modifica quiz offline';
$string['editofflinesettings'] = 'Modifica impostazioni offline';
$string['editorder'] = 'Modifica ordine';
$string['editparticipants'] = 'Modifica partecipanti';
$string['editquestion'] = 'Modifica domanda';
$string['editquestions'] = 'Modifica domande';
$string['editscannedform'] = 'Modifica modulo acquisito con lo scanner';
$string['editthislist'] = 'Modifica questa lista';
$string['emptygroups'] = 'Alcuni gruppi del quiz offline sono vuoti. Per favore aggiungi qualche domanda.';
$string['enroluser'] = 'Iscrivi utente';
$string['erroraccessingreport'] = 'Non ti è permesso visualizzare questo report.';
$string['errorreport'] = 'Report degli errori di importazione';
$string['eventattemptdeleted'] = 'Eliminato tentativo del quiz offline';
$string['eventattemptpreviewstarted'] = 'Avviata anteprima del tentativo del quiz offline';
$string['eventattemptreviewed'] = 'Revisionato tentativo del quiz offline';
$string['eventattemptsummaryviewed'] = 'Visualizzato sommario del tentativo del quiz offline';
$string['eventattemptviewed'] = 'Visualizzato tentativo del quiz offline';
$string['eventdocscreated'] = 'Creato moduli delle domande e delle risposte del quiz offline';
$string['eventdocsdeleted'] = 'Eliminato moduli delle domande e delle risposte del quiz offline';
$string['eventeditpageviewed'] = 'Visualizzato pagina di modifica del quiz offline';
$string['eventofflinequizattemptsubmitted'] = 'Sottomesso tentativo del quiz offline';
$string['eventoverridecreated'] = 'Creato personalizzazione del quiz offline';
$string['eventoverridedeleted'] = 'Eliminato personalizzazione del quiz offline';
$string['eventoverrideupdated'] = 'Aggiornato personalizzazione del quiz offline';
$string['eventparticipantmarked'] = 'Valutato manualmente partecipante del quiz offline';
$string['eventquestionmanuallygraded'] = 'Valutato manualmente una domanda';
$string['eventreportviewed'] = 'Visualizzato report del quiz offline';
$string['eventresultsregraded'] = 'Rivalutato risultati del quiz offline';
$string['everythingon'] = 'abilitato';
$string['excelformat'] = 'Foglio di calcolo Excel (XLSX)';
$string['experimentalevaluation'] = 'Valutazione sperimentale dei fogli di risposta';
$string['experimentalevaluation_help'] = 'Valutazione sperimentale dei fogli di risposta';
$string['fileformat'] = 'Formato per i fogli delle domande';
$string['fileformat_help'] = 'Seleziona il formato dei fogli delle domande che vuoi tra PDF, DOCX o TEX. I moduli di risposta e i fogli di correzione saranno sempre generati in formato PDF';
$string['fileprefixanswer'] = 'modulo_risposte';
$string['fileprefixcorrection'] = 'modulo_correzione';
$string['fileprefixform'] = 'modulo_domande';
$string['fileprefixparticipants'] = 'lista_partecipanti';
$string['filesizetolarge'] = 'Alcune delle tue immagini sono molto larghe. Le dimensioni verranno ridimensionate durante l\'interpretazione. Per favore effettua le scansioni con risoluzione tra i 200 e 300 dpi e in modalità bianco e nero. Questo velocizzerà l\'interpretazione la prossima volta.';
$string['filterbytags'] = 'Filtra per tag...';
$string['fontsize'] = 'Dimensione font';
$string['forautoanalysis'] = 'Per le analisi automatiche';
$string['formforcorrection'] = 'Modulo di correzione per il gruppo {$a}';
$string['formforgroup'] = 'Modulo delle domande per il gruppo {$a}';
$string['formforgroupdocx'] = 'Modulo delle domande per il gruppo {$a} (DOCX)';
$string['formforgrouplatex'] = 'Modulo delle domande per il gruppo {$a} (LATEX)';
$string['formsexist'] = 'Moduli già creati.';
$string['formsexistx'] = 'Moduli già creati (<a href="{$a}">Scarica moduli</a>)';
$string['formsheetsettings'] = 'Impostazioni moduli';
$string['formspreview'] = 'Anteprima dei moduli';
$string['formwarning'] = 'Non è stato definito il modulo delle risposte. Per favore contatta il tuo amministratore.';
$string['fromquestionbank'] = 'dal deposito domande';
$string['functiondisabledbysecuremode'] = 'Quella funzionalità è attualmente disabilitata';
$string['generalfeedback'] = 'Feedback generale';
$string['generalfeedback_help'] = 'Il feedback generale è un testo che viene mostrato dopo che una domanda è stata tentata. Diversamente dal feedback specifico di una domanda che dipende dalla risposta data, è sempre mostrato lo stesso feedback generale.';
$string['generatepdfform'] = 'Genera modulo PDF';
$string['grade'] = 'Valutazione';
$string['gradedon'] = 'Valutato il';
$string['gradedscannedform'] = 'Scansione del modulo con le valutazioni';
$string['gradeiszero'] = 'Nota: il voto massimo per questo quiz offline è 0 punti!';
$string['gradeswarning'] = 'I voti delle domande devono essere numeri!';
$string['gradewarning'] = 'Il voto della domanda deve essere un numero!';
$string['gradingofflinequiz'] = 'Valutazioni';
$string['gradingofflinequizx'] = 'Valutazioni: {$a}';
$string['gradingoptionsheading'] = 'Opzioni di valutazione';
$string['greeniscross'] = 'conteggiato come una croce';
$string['group'] = 'Gruppo';
$string['groupoutofrange'] = 'Il gruppo era fuori dal limite ed è stato sostituito con il gruppo A.';
$string['hasresult'] = 'Esiste un risultato';
$string['hotspotdeletiontask'] = 'Eliminazione degli hotspot';
$string['html'] = 'HTML';
$string['idnumber'] = 'Codice identificativo';
$string['imagefile'] = 'File immagine';
$string['imagenotfound'] = 'File immagine: {$a} non trovato!';
$string['imagenotjpg'] = 'Immagine non jpg o png: {$a}';
$string['imagickwarning'] = 'Imagemagick non presente: chiedi al tuo amministratore di sistema di installare la libreria imagemagick e di controllare il percorso per l\'eseguibile convert nelle impostazioni del filtro Notazione TeX. Non puoi importare i file TIF senza imagemagick!';
$string['import'] = 'Importa';
$string['importedon'] = 'Importato il';
$string['importerror11'] = 'Esiste un altro risultato';
$string['importerror12'] = 'Utente non registrato';
$string['importerror13'] = 'Nessun dato del gruppo';
$string['importerror14'] = 'Non è possibile importare';
$string['importerror15'] = 'Segno non certo';
$string['importerror16'] = 'Errore di pagina';
$string['importerror17'] = 'Pagine incomplete';
$string['importerror21'] = 'Non è possibile importare';
$string['importerror22'] = 'Segno non certo';
$string['importerror23'] = 'Utente non nella lista';
$string['importerror24'] = 'Lista non rilevata';
$string['importforms'] = 'Importa moduli di risposta';
$string['importfromto'] = 'Importazione da {$a->from} a {$a->to} di {$a->total} in totale.';
$string['importisfinished'] = 'L\'mportazione per il quiz offline {$a} è terminata.';
$string['importlinkresults'] = 'Link ai risultati: {$a}';
$string['importlinkverify'] = 'Link alla verifica: {$a}';
$string['importmailsubject'] = 'notifica importazione quiz offline';
$string['importnew'] = 'Importa';
$string['importnew_help'] = '<p>Puoi importare singoli file immagine di scansioni o diversi file immagine di scansioni in un archivio ZIP. Il modulo quiz offline elaborerà i file immagine in background.
I nomi dei file non sono rilevanti ma non devono contenere caratteri speciali come umlaut. Le immagini devono essere GIF, PNG o TIF. Si raccomanda una risoluzione tra i 200 e i 300 dpi.</p>';
$string['importnumberexisting'] = 'Numero di moduli doppi: {$a}';
$string['importnumberpages'] = 'Numero di pagine importate correttamente: {$a}';
$string['importnumberresults'] = 'Numero di importazioni: {$a}';
$string['importnumberverify'] = 'Numero di moduli che necessitano di verifica: {$a}';
$string['importtimefinish'] = 'Processo terminato: {$a}';
$string['importtimestart'] = 'Processo avviato: {$a}';
$string['inconsistentdata'] = 'Dati inconsistenti: {$a}';
$string['info'] = 'Informazioni';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'I segni non certi devono essere corretti manualmente';
$string['insecuremarkingsforquestion'] = 'I segni non certi devono essere corretti manualmente per domanda';
$string['insertnumber'] = 'Per favore inserisci il corretto codice identificativo contrassegnato dal rettangolo blu.';
$string['instruction1'] = 'Questo modulo risposte verrà scansionato automaticamente. Per favore non piegare o macchiare. Usa una penna nera o blu per segnare i campi:';
$string['instruction2'] = 'Solo i segni puliti possono essere interpretati correttamente! Se vuoi correggere una risposta, riempi completamente il quadratino con il colore. Questo campo verrà interpretato come un quadratino vuoto:';
$string['instruction3'] = 'I quadratini corretti non possono essere segnati nuovamente. Per favore non scrivere niente fuori dai quadratini.';
$string['introduction'] = 'Introduzione';
$string['invalidformula'] = 'Formula di identificazione utente non valida. La formula deve aver il formato <prefisso>[<#numeri>]<suffisso>=<campo-db&>.';
$string['invalidnumberofdigits'] = 'Numero di cifre utilizzate non valido. Sono permesse da 1 a 9 cifre.';
$string['invaliduserfield'] = 'Campo della tabella user utilizzato non valido.';
$string['invigilator'] = 'Sorvegliante';
$string['ischecked'] = 'La partecipazione è controllata';
$string['isnotchecked'] = 'La partecipazione non è controllata';
$string['itemdata'] = 'Elemento dati';
$string['keepfilesfordays'] = 'Conserva i file per giorni';
$string['letter'] = 'Lettera';
$string['lightgray'] = 'Grigio chiaro';
$string['linktoscannedform'] = 'Visualizza modulo scansionato';
$string['listnotdetected'] = 'Non è possibile rilevare il codice a barre per la lista!';
$string['logdeleted'] = 'Elemento log {$a} eliminato';
$string['logourl'] = 'URL Logo';
$string['logourldesc'] = 'URL del file immagine che è mostrato nell\'angolo in alto a destra dei moduli risposte, ad esempio <b>http://www.tuosito.tld/mylogo.png</b> o <b>../percorso/del/tuo/logo.png</b>. La dimensione massima permessa è 520x140 pixel. I moduli di risposta non possono essere valutati se l\'immagine eccede la dimensione massima!';
$string['lowertrigger'] = 'Secondo limite inferiore';
$string['lowertriggerzero'] = 'Il secondo limite inferiore è zero';
$string['lowerwarning'] = 'Primo limite inferiore';
$string['lowerwarningzero'] = 'Il primo limite inferiore è zero';
$string['marginwarning'] = 'Per favore stampa i file PDF seguenti senza margini addizionali!<br />Evita di distribuire fotocopie agli studenti.';
$string['marks'] = 'Punteggi';
$string['matrikel'] = 'numero studente';
$string['maxgradewarning'] = 'Il voto massimo deve essere un numero!';
$string['maxmark'] = 'Punteggio massimo';
$string['membersinplist'] = '{$a->count} partecipanti in <a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'File immagine mancante';
$string['missingitemdata'] = 'Risposte mancanti per l\'utente {$a}';
$string['missinglogdata'] = 'Dati log mancanti per il risultato esistente.';
$string['missingquestion'] = 'Questa domanda non sembra esistere più';
$string['missinguserid'] = 'Codice identificativo utente mancante! Non è possibile leggere il codice a barre!';
$string['modulename'] = 'Quiz Offline';
$string['modulename_help'] = 'Questo modulo permette al docente di progettare quiz offline contenti domande a risposta multipla.
Queste domande sono mantenute nel deposito domande di Moodle e possono essere riutilizzate nel corso e anche tra diversi corsi.
I quiz offline possono essere scaricati come file PDF, DOCX o LaTeX.
Gli studenti segnano le loro risposte sui fogli dei moduli di risposta. I fogli dei moduli di risposta sono scansionati e le risposte importate nel sistema.';
$string['modulenameplural'] = 'Quiz offline';
$string['moodleprocessing'] = 'Lascia che sia Moodle ad elaborare i dati';
$string['movecorners'] = 'Modificare prima le posizioni dei contrassegni degli angoli. Usa il drag and drop.';
$string['moveselectedonpage'] = 'Sposta le domande selezionate alla pagina: {$a}';
$string['multianswersforsingle'] = 'Risposte multiple per una domanda a scelta singola.';
$string['multichoice'] = 'Scelta multipla';
$string['multipleanswers'] = 'Scegli come minimo una risposta.';
$string['name'] = 'Nome del quiz offline';
$string['neededcorrection'] = '<strong>Attenzione: alcuni dei tuoi segni richiedono la correzione manuale. Dai un\'occhiata ai quadrati rossi nell\'immagine seguente.
<br />Questo implica l\'intervento manuale di un docente e ritarda la pubblicazione dei risultati del quiz offline!</strong>';
$string['newgrade'] = 'Valutato';
$string['newpage'] = 'Nuova pagina';
$string['noattemptexists'] = 'Non esiste risultato';
$string['noattempts'] = 'Nessun risultato importato!';
$string['noattemptsonly'] = 'Mostra solamente gli studenti senza risultati';
$string['nocourse'] = 'Manca il corso con id {$a->course} a cui appartiene il quiz offline con id {$a->offlinequiz}.';
$string['nogradesseelater'] = 'Questo quiz non è stato ancora valutato per {$a}. I risultati verranno pubblicati qui.';
$string['nogroupdata'] = 'Dati gruppo non presenti per l\'utente {$a}';
$string['nomcquestions'] = 'Non ci sono domande a risposta multipla nel gruppo {$a}!';
$string['noofflinequiz'] = 'Non c\'è un quiz offline con id {$a}!';
$string['nopages'] = 'Nessuna pagina importata';
$string['noparticipantsfound'] = 'Non sono stati trovati partecipanti';
$string['nopdfscreated'] = 'Nessun documento creato!';
$string['noquestions'] = 'Alcuni gruppi di quiz offline sono vuoti. Per favore aggiungi qualche domanda.';
$string['noquestionselected'] = 'Nessuna domanda selezionata!';
$string['noquestionsfound'] = 'Non ci sono domande nel gruppo {$a}!';
$string['noquestionsonpage'] = 'Pagina vuota';
$string['noresults'] = 'Non ci sono risultati.';
$string['noreview'] = 'Non ti è permesso effettuare la revisione di questo quiz offline';
$string['noscannedpage'] = 'Non ci sono pagine scansionate con id {$a}!';
$string['notagselected'] = 'Nessun tag selezionato';
$string['nothingtodo'] = 'Non c\'è niente da fare!';
$string['notxtfile'] = 'Nessun file TXT';
$string['notyetgraded'] = 'Non ancora valutato';
$string['nozipfile'] = 'Nessun file ZIP';
$string['numattempts'] = 'Numero di risultati importati: {$a}';
$string['numattemptsqueue'] = '{$a} moduli di risposta aggiunti alla coda. Un\'email verrà spedita al tuo indirizzo al termine dell\'elaborazione.';
$string['numattemptsverify'] = 'Moduli scansionati in attesa di correzione: {$a}';
$string['numberformat'] = 'Il valore deve essere un numero di {$a} cifre!';
$string['numbergroups'] = 'Numero di gruppi';
$string['numpages'] = '{$a} pagine importate';
$string['numquestionsx'] = 'Domande: {$a}';
$string['numusersadded'] = '{$a} partecipanti aggiunti';
$string['odsformat'] = 'Foglio di calcolo OpenDocument (ODS)';
$string['offlineimplementationfor'] = 'Implementazione Offline per';
$string['offlinequiz:addinstance'] = 'Aggiungi un quiz offline';
$string['offlinequiz:attempt'] = 'Tentativi quiz';
$string['offlinequiz:changeevaluationmode'] = 'Rende possibile il cambio di metodo di valutazione. ATTENZIONE: DA NON UTILIZZARE SU SISTEMI IN PRODUZIONE!';
$string['offlinequiz:createofflinequiz'] = 'Crea moduli del quiz offline';
$string['offlinequiz:deleteattempts'] = 'Elimina i risultati del quiz offline';
$string['offlinequiz:grade'] = 'Valuta manualmente i quiz offline';
$string['offlinequiz:manage'] = 'Gestisci quiz offline';
$string['offlinequiz:preview'] = 'Anteprima quiz offline';
$string['offlinequiz:view'] = 'Visualizza informazioni quiz offline';
$string['offlinequiz:viewreports'] = 'Visualizza report quiz offline';
$string['offlinequizcloses'] = 'Il quiz offline si chiude';
$string['offlinequizcloseson'] = 'La revisione per questo quiz offline si chiuderà il {$a}';
$string['offlinequizisclosed'] = 'Quiz offline chiuso';
$string['offlinequizisclosedwillopen'] = 'Quiz offline chiuso (si apre {$a})';
$string['offlinequizisopen'] = 'Questo quiz offline è aperto';
$string['offlinequizisopenwillclose'] = 'Quiz offline aperto (si chiude {$a})';
$string['offlinequizopenedon'] = 'Questo quiz offline è stato aperto il {$a}';
$string['offlinequizopens'] = 'Quiz offline aperto';
$string['offlinequizsettings'] = 'Impostazioni offline';
$string['offlinequizwillopen'] = 'Quiz offline apre il {$a}';
$string['oneclickenrol'] = 'Iscrizione con 1-Click';
$string['oneclickenroldesc'] = 'Se questa opzione è attivata i docenti hanno la possibilità di iscrivere gli utenti con un click mentre correggono i moduli di risposta (errore "Utente non è nel corso").';
$string['oneclickrole'] = 'Ruolo per iscrizione con 1-Click';
$string['oneclickroledesc'] = 'Scegli il ruolo utilizzato per le iscrizioni con 1-Click. Possono essere selezionati solo i ruoli con archetipo "studente".';
$string['onlylocalcategories'] = 'Solo categorie di domande locali';
$string['orderandpaging'] = 'Ordine e paginazione';
$string['orderandpaging_help'] = 'I numeri 10, 20, 30, ... opposti a ogni domanda indicano l\'ordine delle domande. I numeri si incrementano di passi da 10 per lasciare spazio per inserire domande aggiuntive. Per riordinare le domande, modifica i numeri e poi clicca sul pulsante "Riordina domande".

Per aggiungere interruzioni di pagina dopo una particolare domanda, seleziona la spunta vicino alla domande e poi clicca sul pulsante "Aggiungi interruzione di pagina dopo le domande selezionate".

Per distribuire le domande nelle pagine, clicca il pulsante Rimpagina e seleziona il numero di domande per pagina desiderate.';
$string['orderingofflinequiz'] = 'Ordine e paginazione';
$string['otherresultexists'] = 'Esistono già risultati diversi per {$a}, importazione ignorata! Prima elimina il risultato.';
$string['outof'] = '{$a->grade} su un massimo di  {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback complessivo';
$string['overview'] = 'Panoramica';
$string['overviewdownload_help'] = 'Panoramica download';
$string['page-mod-offlinequiz-edit'] = 'Pagina di modifica del quiz offline';
$string['page-mod-offlinequiz-x'] = 'Qualunque pagina del quiz offline';
$string['pagecorrected'] = 'Importato il foglio corretto della lista dei partecipanti';
$string['pageevaluationtask'] = 'Foglio di valutazione delle risposte per il modulo quiz offline';
$string['pageimported'] = 'Importato foglio della lista dei partecipanti';
$string['pagenotdetected'] = 'Non è possibile rilevare il codice a barre della pagina!';
$string['pagenumberimported'] = 'Importato il foglio {$a} della lista dei partecipanti.';
$string['pagenumberupdate'] = 'Aggiornamento numero di pagina';
$string['pagesizeparts'] = 'Partecipanti mostrati per pagina:';
$string['papergray'] = 'Valore del bianco della carta';
$string['papergray_help'] = 'Se le parti bianche dei tuoi moduli di risposta scansionati sono molto scure puoi correggere questo impostando questo valore a grigio scuro.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">{$a->count} partecipanti selezionati senza risultato</a>';
$string['partcheckedwithresult'] = '{$a} partecipanti selezionati con risultato';
$string['partial'] = 'parziale';
$string['participants'] = 'Partecipanti';
$string['participants_help'] = '<p>Le liste dei partecipanti sono progettate per grandi quiz offline con molti partecipanti. Aiutano il docente a controllare quali studenti hanno partecipato al quiz e se tutti i risultati sono stati importati correttamente.
Puoi aggiungere utenti a liste differenti. Ogni lista può, per esempio, contenere i partecipanti in una particolare aula. I partecipanti possono essere membri di un speciale gruppo. Uno strumento di registrazione del gruppo può essere usato per creare questi gruppi.
Le liste dei partecipanti possono essere scaricate come documenti PDF, stampati e segnato con croci esattamente i moduli di risposta dei quiz offline.
Successivamente potranno essere caricati e gli studenti segnati saranno segnati nel database come presenti.
Per favore evitate macchie sui codici a barre perché vengono usati per identificare gli studenti.</p>';
$string['participantsinlists'] = 'Partecipanti nelle liste';
$string['participantslist'] = 'Lista dei partecipanti';
$string['participantslists'] = 'Partecipanti';
$string['partimportnew'] = 'Caricamento liste dei partecipanti';
$string['partimportnew_help'] = '<p>
In questo tab puoi caricare la lista compilata dei partecipanti. Puoi caricare singoli file immagine di scansioni o diversi file immagine di scansioni in un archivio ZIP. Il modulo quiz offline elaborerà i file immagine in background. I nomi dei file non sono rilevanti ma non devono contenere caratteri speciali come umlaut. Le immagini devono essere GIF, PNG o TIF. Si raccomanda una risoluzione tra i 200 e i 300 dpi.</p>';
$string['partuncheckedwithoutresult'] = '{$a} partecipanti non selezionati senza risultato.';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">{$a->count} partecipanti non selezionati con risultato</a>';
$string['pdfdeletedforgroup'] = 'Eliminato modulo per il gruppo {$a}';
$string['pdfintro'] = 'Informazioni aggiuntive';
$string['pdfintro_help'] = 'Queste informazioni saranno stampate sulla prima pagina del foglio domande e dovrebbero contenere le informazioni generali a proposito di come compilare il modulo risposte.';
$string['pdfintrotext'] = '<b>Come devo segnare correttamente?</b><br />Questo modulo di risposta verrà scansionato automaticamente. Per favore non piegare o macchiare. Utilizza una penna nera o blu per segnare i campi. Se vuoi correggere una risposta, riempi completamente il quadratino con il colore. Questo campo verrà interpretato come un quadratino vuoto.<br />';
$string['pdfintrotoolarge'] = 'L\'introduzione è troppo lunga (max 2000 caratteri).';
$string['pdfscreated'] = 'I moduli PDF sono stati creati';
$string['pdfsdeletedforgroup'] = 'Eliminato il modulo per il gruppo {$a}';
$string['pearlywhite'] = 'Bianco perla';
$string['pluginadministration'] = 'Amministrazione quiz offline';
$string['pluginname'] = 'Quiz Offline';
$string['point'] = 'punto';
$string['present'] = 'presente';
$string['preventsamequestion'] = 'Prevenire l\'utilizzo multiplo della stessa domanda in gruppi differenti';
$string['preview'] = 'Anteprima';
$string['previewforgroup'] = 'Anteprima per il gruppo {$a}';
$string['previewquestion'] = 'Anteprima domanda';
$string['printstudycodefield'] = 'Stampa il campo codice del corso di studio sul foglio domande';
$string['printstudycodefield_help'] = 'Se selezionato, il campo codice del corso di studio sarà stampato sulla prima pagina del foglio domande.';
$string['privacy:data_folder_name'] = 'Dati quiz offline';
$string['privacy:metadata:core_files'] = 'Il quiz offline utilizza le API File per archiviare i fogli domande, i fogli risposte e i fogli correzioni generati come anche i fogli risposte compilati.';
$string['privacy:metadata:core_question'] = 'Il quiz offline utilizza le question API per salvare le domande per i quiz.';
$string['privacy:metadata:mod_quiz'] = 'Il quiz offline utilizza le quiz API per salvare i risultati dei quiz.';
$string['privacy:metadata:offlinequiz'] = 'La tabella offlinequiz salva ogni informazione relativa a un\'istanza di quiz offline.';
$string['privacy:metadata:offlinequiz:course'] = 'La colonna \'course\' nella tabella offlinequiz salva in quale corso questo quiz offline è presente.';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'Il numero di posti decimali da calcolare per le valutazioni.';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'Deve disabilitare il ritorno a capo prima e dopo le immagini.';
$string['privacy:metadata:offlinequiz:docscreated'] = 'Se i documenti sono stati creati questo campo è impostato a 1 altrimenti a 0.';
$string['privacy:metadata:offlinequiz:fileformat'] = 'Il formato file che è utilizzato per stampare i fogli domande, 0 per pdf, 1 per docx, 2 per LaTeX.';
$string['privacy:metadata:offlinequiz:fontsize'] = 'La dimensione del font nei fogli domande.';
$string['privacy:metadata:offlinequiz:grade'] = 'Il voto mostra la quantità massima di punti ottenibili in questo quiz offline.';
$string['privacy:metadata:offlinequiz:id_digits'] = 'Salva la quantità di cifre che ha il codice identificativo quando i fogli di risposta sono creati. Questo è necessario per la retro compatibilità se la quantità è stata aumenta tra la creazione e l\'importazione dei fogli di risposta.';
$string['privacy:metadata:offlinequiz:introformat'] = 'Questo campo non è utilizzato.';
$string['privacy:metadata:offlinequiz:name'] = 'La colonna \'name\' salva il nome del quiz offline.';
$string['privacy:metadata:offlinequiz:numgroups'] = 'La quantità di gruppi che questo quiz offline ha.';
$string['privacy:metadata:offlinequiz:papergray'] = 'Il valore del bianco di questo quiz offline';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'Le informazioni addizionali che sono inserite all\'inizio dei fogli delle domande.';
$string['privacy:metadata:offlinequiz_choices'] = 'Questa tabella contiene le informazioni di tutte le croci per tutte le pagine scansionate. Le informazioni sono necessarie per creare successivamente i risultati basati sulle croci.';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'Il numero della scelta per questa domanda.';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'La pagina scansionata relativa alla scelta.';
$string['privacy:metadata:offlinequiz_choices:slotnumber'] = 'Lo slot delle domande di questa scelta.';
$string['privacy:metadata:offlinequiz_choices:value'] = 'La scelta è considerata cancellata? 0 per no, 1 per si, -1 per incerto.';
$string['privacy:metadata:offlinequiz_group_questions'] = 'La tabella salva tutte le domande per ogni gruppo del quiz offline.';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'La quantità massima di punti ottenibili per questa domanda.';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'Il gruppo del quiz offline a cui è relativo questo gruppo di domande.';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'L\'id del quiz offline a cui è relativo questo gruppo di domande.';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'La pagina nella quale questa domanda è stampata nei fogli di risposta.';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'La posizione in questo quiz offline.';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'L\'id della domanda selezionata.';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'Lo slot della domanda nel quiz.';
$string['privacy:metadata:offlinequiz_groups'] = 'Tabella per i gruppi che prendono parte ai quiz offline.';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'Il nome del file che è stato utilizzato per salvare il file delle risposte.';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'Il nome del file che è stato utilizzato per salvare il file delle correzioni.';
$string['privacy:metadata:offlinequiz_groups:number'] = 'Il numero del gruppo per questo quiz offline, 1 per il gruppo A, 2 per il gruppo B, e così via.';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'La quantità di pagine su cui deve stampare i fogli delle risposte.';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'L\'ID del quiz offline a cui appartiene questo gruppo del quiz offline.';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'Il nome del file che è stato utilizzato per salvare il file delle domande';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'La somma di tutte le valutazioni per tutte le domande in questo gruppo.';
$string['privacy:metadata:offlinequiz_hotspots'] = 'Questa tabella salva tutte le posizioni dei riquadri e se sono stati valutati correttamente';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'Se l\'hotspot è analizzato correttamente.';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'Tipo di hotspot, es.u%number per hotspot utente, a-0-0 per domanda 1 risposta 1, e così via.';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'Pagina scansionata in cui c\'è l\'hotspot';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'Tempo dell\'ultimo aggiornamento per questo hotspot.';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'Il valore x dell\'hotspot.';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'Il valore y dell\'hotspot.';
$string['privacy:metadata:offlinequiz_p_choices'] = 'Questa tabella salva tutte le croci per le liste dei partecipanti.';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'La pagina scansionata a cui è relativa questa scelta.';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'Lo userid a cui è relativa questa scelta.';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'Se la croce è riempita o no (0 per non riempita, 1 per riempita, -1 per insicuro).';
$string['privacy:metadata:offlinequiz_page_corners'] = 'Questa tabella salva tutti gli angoli per ogni pagina scansionata per valutarla più velocemente alla prossima valutazione o correzione';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'Le informazioni se questo angolo è in alto o in basso e a destra o a sinistra.';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'La pagina scansionata in cui si trova questo angolo.';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'Il valore x dell\'angolo.';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'Il valore y dell\'angolo.';
$string['privacy:metadata:offlinequiz_participants'] = 'La tabella dei partecipanti salva se l\'utente ha preso parte al quiz offline o no.';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'L\'informazione se questo utente è stato marcato nella lista dei partecipanti.';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'L\'id della lista nella quale è questo partecipante.';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'Lo userid dell\'utente.';
$string['questionanalysis'] = 'Analisi della difficoltà';
$string['questionanalysistitle'] = 'Tabella delle analisi della difficoltà';
$string['questionbankcontents'] = 'Contenuto del deposito delle domande';
$string['questionforms'] = 'Moduli domande';
$string['questioninfoanswers'] = 'Numero di risposte corrette';
$string['questioninfocorrectanswer'] = 'risposta corretta';
$string['questioninfocorrectanswers'] = 'risposte corrette';
$string['questioninfonone'] = 'Niente';
$string['questioninfoqtype'] = 'Tipo di domanda';
$string['questionname'] = 'Nome domanda';
$string['questionpage'] = 'Pagina';
$string['questionsheet'] = 'Foglio domande';
$string['questionsin'] = 'Domande in';
$string['questionsingroup'] = 'Domande nel gruppo';
$string['questionsinthisofflinequiz'] = 'Domande in questo quiz offline';
$string['questiontextisempty'] = '[testo della domanda vuoto]';
$string['quizdate'] = 'Data del quiz offline';
$string['quizopenclose'] = 'Date di apertura e chiusura';
$string['quizopenclose_help'] = 'Gli studenti possono vedere i loro tentativi solo dopo la data di apertura e prima della data di chiusura.';
$string['quizquestions'] = 'Domande quiz';
$string['randomfromexistingcategory'] = 'Domande casuali da una categoria esistente';
$string['randomnumber'] = 'Numero di domande casuali';
$string['randomquestionusinganewcategory'] = 'Domande casuali utilizzando una nuova categoria';
$string['readjust'] = 'Risistemare';
$string['reallydeletepdfs'] = 'Vuoi veramente eliminare i file dei moduli?';
$string['reallydeleteupdatepdf'] = 'Vuoi veramente eliminare e aggiornare la lista dei partecipanti?';
$string['recreatepdfs'] = 'Ricrea PDF';
$string['recurse'] = 'Includi anche domande dalle sottocategorie';
$string['rediswrong'] = 'croce sbagliata o croce mancante';
$string['refreshpreview'] = 'Aggiorna anteprima';
$string['regrade'] = 'Rivaluta';
$string['regradedisplayexplanation'] = '<b>Attenzione:</b> La rivalutazione non cambia i voti che sono stati sovrascritti manualmente!';
$string['regradinginfo'] = 'Se cambi il punteggio per una domanda, devi rivalutare il quiz offline per aggiornare i risultati dei partecipanti.';
$string['regradingquiz'] = 'Rivalutazione';
$string['regradingresult'] = 'Rivalutazione risultato per l\'utente {$a}';
$string['reloadpreview'] = 'Ricarica anteprima';
$string['reloadquestionlist'] = 'Ricarica lista domande';
$string['remove'] = 'Rimuovi';
$string['removeemptypage'] = 'Rimuovi pagina vuota';
$string['removepagebreak'] = 'Rimuovi interruzione di pagina';
$string['removeselected'] = 'Rimuovi selezionati';
$string['reordergroupquestions'] = 'Riordina domande del gruppo';
$string['reorderquestions'] = 'Riordina domande';
$string['reordertool'] = 'Mostra strumento di ordinamento';
$string['repaginate'] = 'Rimpagina con {$a} domande per pagina';
$string['repaginatecommand'] = 'Rimpagina';
$string['repaginatenow'] = 'Rimpagina ora';
$string['reportends'] = 'La revisione dei risultati termina';
$string['reportoverview'] = 'Panoramica';
$string['reportstarts'] = 'La revisione dei risultati inizia';
$string['resetofflinequizzes'] = 'Reset dei dati del quiz offline';
$string['resultexists'] = 'Esiste già lo stesso risultato per {$a}, importazione ignorata';
$string['resultimport'] = 'Risultati importazione';
$string['results'] = 'Risultati';
$string['review'] = 'Revisione';
$string['reviewbefore'] = 'Permetti revisione mentre il quiz offline è aperto';
$string['reviewclosed'] = 'Dopo che il quiz offline è chiuso';
$string['reviewcloses'] = 'La revisione si chiude';
$string['reviewimmediately'] = 'Subito dopo il tentativo';
$string['reviewincludes'] = 'La revisione deve includere';
$string['reviewofresult'] = 'Revisione dei risultati';
$string['reviewopens'] = 'La revisione si apre';
$string['reviewoptions'] = 'Gli studenti possono vedere';
$string['reviewoptions_help'] = 'Con queste opzioni ti è possibile controllare cosa possono vedere gli studenti dopo che i risultati sono stati importati.
Puoi definire anche il momento di apertura e di chiusura del report dei risultati.<br />
Il significato delle spunte è:
<ul>
<li><b>Il tentativo</b> Il testo delle domande e delle risposte verrà mostrato agli studenti. Vedranno quale risposta hanno scelto, ma non verrà indicata la risposta corretta.</li>
<li><b>Se corretto</b> Questa opzione può essere attivata solo se l\'opzione "Il tentativo"  è attivata. Se attivata, lo studente può vedere se la risposte scelte sono corrette (sfondo verde) o sbagliate (sfondo rosso).</li>
<li><b>Punteggio</b> Sono mostrati il gruppo (es. B), i punti (valutazione numerica, totale dei punti per le domande, valutazione percentuale, es. 40/80 (50)) e il voto (es. 50 su un massimo di 100). In aggiunta, se è selezionato "Il tentativo", sono mostrati i punti ottenuti e il punteggio massimo per ogni domanda.</li>
<li><b>Feedback specifico</b> Feedback che dipendono da quale risposta ha dato lo studente.</li>
<li><b>Feedback generale</b> I Feedback generali sono mostrati allo studente dopo che i risultati sono stati importati. Diversamente dal feedback specifico, che dipende dal tipo di domanda e da quale risposta ha dato lo studente, lo stesso feedback generale è mostrato
 tutti gli studenti.<br/> Puoi usare il feedback generale per dare agli studenti una spiegazione completa della risposta e volendo un link a maggiori informazioni che possono utilizzare se non hanno capito le domande.</li>
<li><b>Risposta corretta</b> Viene mostrato quali risposte sono corrette o sbagliate. Questa opzione è attiva solo se l\'opzione "Il tentativo" è selezionata.</li>
<li><b>Modulo scansionato</b> Vengono mostrati i moduli risposte scansionati. Le scelte fatte sono segnate con quadrati verdi.</li>
<li><b>Scansione del modulo con le valutazioni</b> Vengono mostrati i moduli risposte scansionati. Le scelte fatte sono segnate con quadrati verdi. Sono evidenziati i segni sbagliati e i segni mancanti. In aggiunta una tabella mostra il punteggio massimo e i punti ottenuti per ogni domanda.</li>
</ul>';
$string['reviewoptionsheading'] = 'Opzioni di revisione';
$string['rimport'] = 'Carica/Correggi';
$string['rotate'] = 'Ruota';
$string['rotatingsheet'] = 'Il foglio è ruotato...';
$string['save'] = 'Salva';
$string['saveandshow'] = 'Salva e mostra cambiamenti allo student';
$string['savescannersettings'] = 'Salva impostazioni scanner';
$string['scannedform'] = 'Modulo scansionato';
$string['scannerformfortype'] = 'Modulo per il tipo {$a}';
$string['scanneroptions'] = 'Impostazioni scanner';
$string['scannerpdfs'] = 'Moduli vuoti';
$string['scannerpdfstext'] = 'Scarica i seguenti moduli vuoti se vuoi utilizzare il software del tuo scanner.';
$string['scanningoptionsheading'] = 'Opzioni di scansione';
$string['score'] = 'Punteggio';
$string['search:activity'] = 'Informazioni attività - Quiz offline';
$string['select'] = 'Seleziona';
$string['selectagroup'] = 'Seleziona un gruppo';
$string['selectall'] = 'Seleziona tutto';
$string['selectcategory'] = 'Seleziona categoria';
$string['selectdifferentgroup'] = 'Per favore seleziona un gruppo diverso!';
$string['selectedattempts'] = 'Tentativi selezionati...';
$string['selectformat'] = 'Seleziona formato...';
$string['selectgroup'] = 'Seleziona gruppo';
$string['selectlist'] = 'Per favore seleziona una lista o prova a risistemare il foglio:';
$string['selectmultipletoolbar'] = 'Seleziona la barra degli strumenti multipla';
$string['selectnone'] = 'Deseleziona tutto';
$string['selectpage'] = 'Per favore seleziona il numero di pagina o prova a risistemare il foglio:';
$string['selectquestiontype'] = '-- Seleziona il tipo di domanda --';
$string['showallparts'] = 'Mostra tutti i {$a} partecipanti';
$string['showcopyright'] = 'Mostra la dichiarazione sul copyright';
$string['showcopyrightdesc'] = 'Se abiliti questa opzione, verrà visualizzata la dichiarazione sul copyright nella pagina di revisione dei risultati dello studente.';
$string['showgrades'] = 'Stampa valutazione domande';
$string['showgrades_help'] = 'Questa opzione definisce se i voti massimi delle domande del quiz offline devono essere stampati sul foglio delle domande.';
$string['showmissingattemptonly'] = 'Mostra tutti i partecipanti selezionati senza risultati';
$string['showmissingcheckonly'] = 'Mostra tutti i partecipanti non selezionati con risultati';
$string['shownumpartsperpage'] = 'Mostra {$a} partecipanti per pagina';
$string['showquestioninfo'] = 'Stampa le informazioni sulle risposte';
$string['showquestioninfo_help'] = 'Con questa opzione puoi controllare quali informazioni aggiuntive sulla domanda vengono stampate sul foglio delle domande.
Puoi scegliere uno di questi:
<ul>
<li> Niente
<li> Tipo di domanda - verrà stampato a seconda del tipo di domanda a scelta singola, a scelta multipla, a scelta multipla tutto o niente
<li> Numero di risposte corrette - verrà stampato il numero di risposte corrette
</ul>';
$string['showstudentview'] = 'Mostra vista dello studente';
$string['showtutorial'] = 'Mostra un tutorial del quiz offline agli studenti.';
$string['showtutorial_help'] = 'Questa opzione determina se gli studenti possono vedere un tutorial sui fondamenti dei quiz offline.
Il tutorial fornisce informazioni su come gestire i diversi tipi di documenti nei quiz offline. In una parte interattiva imparano a spuntare correttamente il loro codice identificativo.<br />
<b>Nota:</b><br />
Se imposti questa opzione su "Sì" ma nascondi il quiz offline, il link al tutorial non sarà visibile. In questo caso puoi aggiungere un link al tutorial nella pagina del corso.';
$string['showtutorialdescription'] = 'Puoi aggiungere un link al tutorial nella pagina del corso usando il seguente URL:';
$string['shuffleanswers'] = 'Mescola risposte';
$string['shufflequestions'] = 'Mescola domande';
$string['shufflequestionsanswers'] = 'Mescola domande e risposte';
$string['shufflequestionsselected'] = 'Sono state impostate le domande mescolate, quindi alcune azioni relative alle pagine non sono disponibili. Per modificare l\'opzione delle domande mescolate, {$a}.';
$string['shufflewithin'] = 'Mescola all\'interno delle domande';
$string['shufflewithin_help'] = 'Se abilitato, le parti che compongono ciascuna domanda verranno mescolate casualmente ogni volta che si preme il pulsante di ricarica nell\'anteprima del modulo. NOTA: questa impostazione si applica solo alle domande in cui è attivata l\'opzione di mescolamento.';
$string['signature'] = 'Firma';
$string['singlechoice'] = 'Scelta singola';
$string['standard'] = 'Standard';
$string['starttutorial'] = 'Avvia il tutorial sull\'esame';
$string['statistics'] = 'Statistica';
$string['statisticsplural'] = 'Statistiche';
$string['statsoverview'] = 'Panoramica statistiche';
$string['studycode'] = 'Codice del corso di studio';
$string['temporaryfiledeletiontask'] = 'Elimina file temporanei';
$string['theattempt'] = 'Il tentativo';
$string['timesup'] = 'Tempo scaduto!';
$string['totalmarksx'] = 'Totale punti: {$a}';
$string['totalpointsx'] = 'Totale dei punti: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totale di {$a} domande nella categoria.';
$string['trigger'] = 'limite inferiore/superiore';
$string['tutorial'] = 'Tutorial per i quiz offline';
$string['type'] = 'Tipo';
$string['uncheckparts'] = 'Segna il partecipanti selezionati come assenti';
$string['updatedsumgrades'] = 'La somma di tutti i voti del gruppo {$a->letter} è stata ricalcolata in {$a->grade}.';
$string['upgradingfilenames'] = 'Aggiornamento dei nomi dei file dei documenti: quiz offline {$a->done}/{$a->outof} (ID quiz offline {$a->info})';
$string['upgradingilogs'] = 'Aggiornamento delle pagine scansionate: pagina scansionata {$a->done}/{$a->outof} (ID quiz offline {$a->info})';
$string['upgradingofflinequizattempts'] = 'Aggiornamento dei tentativi del quiz offline: quiz offline {$a->done}/{$a->outof} (ID quiz offline {$a->info})';
$string['upload'] = 'Carica/Correggi';
$string['uploadpart'] = 'Carica/Correggi lista dei partecipanti';
$string['uppertrigger'] = 'Secondo limite superiore';
$string['uppertriggerzero'] = 'Il secondo limite superiore è zero';
$string['upperwarning'] = 'Primo limite superiore';
$string['upperwarningzero'] = 'Il primo limite superiore è zero';
$string['useradded'] = 'Aggiunto utente {$a}';
$string['userdoesnotexist'] = 'L\'utente {$a} non esiste nel sistema';
$string['useridentification'] = 'Identificazione utente';
$string['useridviolation'] = 'Trovati utenti multipli';
$string['userimported'] = 'L\'utente {$a} è stato importato e valutato';
$string['usernotincourse'] = 'L\'utente {$a} non è nel corso.';
$string['usernotinlist'] = 'Utente non registrato nella lista!';
$string['usernotregistered'] = 'L\'utente {$a} non è registrato nel corso';
$string['userpageimported'] = 'Singola pagina importata per l\'utente {$a}';
$string['valuezero'] = 'Il valore non deve essere zero';
$string['viewresults'] = 'Visualizza risultati';
$string['white'] = 'Bianco';
$string['withselected'] = 'Con i selezionati...';
$string['zerogradewarning'] = 'Attenzione: il voto del tuo quiz offline è 0.0!';
$string['zipfile'] = 'File ZIP';
$string['zipok'] = 'File ZIP importato';
