<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'es_mx', version '4.0'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Acciones';
$string['addedandupdatedpp'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedps'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizó {$a->%old} antigua.';
$string['addedandupdatedsp'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedss'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizó {$a->%old} antigua.';
$string['addednewlibraries'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P.';
$string['addednewlibrary'] = 'Se añadió {$a->%new} nueva biblioteca H5P.';
$string['additionallicenseinfo'] = 'Cualquier información adicional acerca de la licencia';
$string['atto_h5p'] = 'Botón para insertar H5P';
$string['atto_h5p_description'] = 'El Botón para insertar H5P en el editor Atto  le permite al usuario insertar contenido H5P, ya sea al ingresar una URL , o al incrustar código, o al subir un archivo H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentarios del autor';
$string['authorcommentsdescription'] = 'Comentarios para el editor del contenido. (Este texto no será publicado como parte de la información de copyright)';
$string['authorname'] = 'Nombre del autor';
$string['authorrole'] = 'Rol del autor';
$string['by'] = 'por';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribución (CC BY)';
$string['ccattributionnc'] = 'Licencia de Atribución-No-Comercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Licencia de Atribución-No-Comercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Licencia de Atribución-No-Comercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Licencia de Atribución-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Licencia de Atribución-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Dedicación del Dominio Público (CC0)';
$string['changedby'] = 'Cambiado por';
$string['changedescription'] = 'Descripción del cambio';
$string['changelog'] = 'Bitácora de cambios';
$string['changeplaceholder'] = 'Foto recortada, texto cambiado, etc.';
$string['close'] = 'Cerrar';
$string['confirmdialogbody'] = 'Por favor confirme que desea proseguir. Esta acción no puede deshacerse.';
$string['confirmdialogheader'] = 'Confirmar acción';
$string['confirmlabel'] = 'Confirmar';
$string['connectionLost'] = 'Conexión perdida. Los resultados serán almacenados y enviados cuando la conexión sea restablecida.';
$string['connectionReestablished'] = 'Conexión restablecida';
$string['contentCopied'] = 'El contenido es copiado al portapapeles';
$string['contentchanged'] = 'Este contenido ha cambiado desde la última vez que Usted lo utilizó.';
$string['contentinuse'] = 'Este contenido puede estar en uso en otros lugares.';
$string['contenttype'] = 'Tipo de contenido';
$string['copyright'] = 'Derechos de uso';
$string['copyrightinfo'] = 'Información del Copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Ver información de copyright para este contenido.';
$string['couldNotParseJSONFromZip'] = 'No se puede procesar JSON del paquete: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'No se puede leer del paquete: {$a->%fileName}';
$string['creativecommons'] = 'Creative Commons';
$string['date'] = 'Fecha';
$string['deletelibraryconfirm'] = '<p>¿Está seguro de querer eliminar la versión <em>\'{$a->version}\'</em> de la biblioteca <em>\'{$a->name}\'</em>? Esto quitará la biblioteca y todo sus usos..</p><p>Esta operación no puede deshacerse.</p>';
$string['deletelibraryversion'] = 'Eliminar versión';
$string['deleting'] = 'Eliminando una biblioteca';
$string['description'] = 'Descripción';
$string['disablefullscreen'] = 'Deshabilitar pantalla completa';
$string['download'] = 'Descargar';
$string['downloadtitle'] = 'Descargar este contenido como un archivo H5P.';
$string['editcontent'] = 'Editar contenido H5P';
$string['editor'] = 'Editor';
$string['embed'] = 'Incrustar';
$string['embedtitle'] = 'Ver el contenido incrustado para este comentario';
$string['error:emptycontentid'] = 'La URL dada es incorrecta o usted no puede editar este archivo.';
$string['eventh5pdeleted'] = 'H5P eliminado';
$string['eventh5pviewed'] = 'Contenido H5P visto';
$string['feature'] = 'Característica';
$string['fetchtypesfailure'] = 'No se pudo obtener información sobre los tipos de contenido H5P disponibles. Falla en la conexión al repositorio H5P.';
$string['fileExceedsMaxSize'] = 'Uno de los archivos dentro del paquete excede el tamaño máximo de archivo permitido. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Filtro para Mostrar H5P';
$string['filter_displayh5p_description'] = 'El Filtro para Mostrar H5P convierte URLs a contenido H5P incrustado.';
$string['fullscreen'] = 'Pantalla completa';
$string['gpl'] = 'Licencia Pública General v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Archivo H5P no encontrado';
$string['h5pinvalidurl'] = 'URL de contenido H5P inválida';
$string['h5plibraryhandler'] = 'Manejador de estructura H5P';
$string['h5plibraryhandler_help'] = 'La estructura H5P usada para mostrar cualquier contenido H5P. Se recomienda la versión más reciente.';
$string['h5pmanage'] = 'Gestionar tipos de contenido H5P';
$string['h5poverview'] = 'Vista general H5P';
$string['h5ppackage'] = 'Tipo de contenido H5P';
$string['h5ppackage_help'] = 'Un tipo de contenido H5P es un archivo con  extensión H5P o ZIP que contiene todas las bibliotecas requeridas para mostrar el contenido.';
$string['h5pprivatefile'] = 'El contenido H5P no puede ser mostrado porque Usted no tiene acceso al archivo .h5p.';
$string['h5psettings'] = 'Configuraciones de H5P';
$string['h5ptitle'] = 'Visitar H5P.org para revisar más contenido.';
$string['hideadvanced'] = 'Ocultar avanzadas';
$string['installedcontentlibraries'] = 'Bibliotecas H5P instaladas';
$string['installedcontenttypes'] = 'Tipos de contenido H5P instalado';
$string['installedh5p'] = 'H5P instalado';
$string['invalidcontextid'] = 'Archivo H5P no encontrado (contextid inválido)';
$string['invalidfile'] = 'Archivo "{$a->%filename}" no permitido. Solamente están permitidos archivos con las extensiones siguientes: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Archivo inválido de idioma {$a->%file} en biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Archivo inválido de idioma {$a->%languageFile} ha sido incluido en la biblioteca {$a->%name}';
$string['invalidlibrarydata'] = 'Datos inválidos proporcionados para {$a->%property} en {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Datos inválidos proporcionados para {$a->%property} en {$a->%library}. Booleano esperado.';
$string['invalidlibraryname'] = 'Nombre inválido de biblioteca: {$a->%name}';
$string['invalidlibrarynamed'] = 'La biblioteca H5P{$a->%library} usada en el contenido no es válida';
$string['invalidlibraryoption'] = 'Opción ilegal {$a->%option} en {$a->%library}';
$string['invalidlibraryproperty'] = 'No se puede leer la propiedad {$a->%property} en {$a->%library}';
$string['invalidmainjson'] = 'Falta un archivo principal h5p.json';
$string['invalidmultiselectoption'] = 'Opción seleccionada inválida en multi-selección.';
$string['invalidpackage'] = 'Tipo de contenido H5P inválido';
$string['invalidselectoption'] = 'Opción seleccionada inválida en selección.';
$string['invalidsemanticsjson'] = 'Archivo semantics.json inválido ha sido incluido en la biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Error interno H5P: tipo de contenido desconocido "{$a->@type}" en semántica. ¡Quitando contenido!';
$string['invalidstring'] = 'La cadena de caracteres proporcionada no es válida de acuerdo a regexp en semántica. (valor: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['librariesmanagerdescription'] = '<p>H5P le permite a los usuarios crear contenido interactivo al proporcionar un rango de tipos de contenido.</p><p>Para asegurar que solamente sean usados tipos de contenido confiables en su sitio, Usted necesita <i>una de dos</i></p><ul><li>Subir tipos de contenido H5P desde h5p.org <i>o</i></li><li> Habilitar el trabajo agendado \'Descargar tipos de contenido disponible H5P desde h5p.org</li></ul><p>Tenga en cuenta que los usuarios solamente podrán usar los tipos de contenido H5P que estén instalados en su sitio.</p>';
$string['librarydirectoryerror'] = 'El nombre del directorio de la biblioteca debe coincidir con machineName o machineName-majorVersion.minorVersion (de library.json). (Directorio: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licencia';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0)  Dedicación del Dominio Público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérico';
$string['licenseCC20'] = '2.0 Genérico';
$string['licenseCC25'] = '2.5 Genérico';
$string['licenseCC30'] = '3.0 No Portado';
$string['licenseCC40'] = '4.0 Internacional';
$string['licenseGPL'] = 'Licencia Pública general';
$string['licenseV1'] = 'Versión 1';
$string['licenseV2'] = 'Versión 2';
$string['licenseV3'] = 'Versión 3';
$string['licensee'] = 'Licenciatario';
$string['licenseextras'] = 'Extras de Licencia';
$string['licenseversion'] = 'Versión de Licencia';
$string['lockh5pdeploy'] = 'Este contenido H5P no puede ser accesado porque está siendo desplegado. Por favor inténtelo nuevamente más tarde.';
$string['mainlibrarydisabled'] = 'Este archivo no puede ser mostrado porque su tipo de contenido está deshabilitado. Por favor póngase en contacto con el administrador y pídale que habilite el tipo de contenido.';
$string['missingcontentfolder'] = 'Falta una carpeta de contenido válida';
$string['missingcoreversion'] = 'El sistema no pudo instalar el componente {$a->%component} del paquete, ya que necesita una versión más nueva del plugin H5P. Este sitio actualmente está ejecutando la versión {$a->%current}, mientras que la versión requerida es {$a->%required} o mayor. Por favor actualize y después inténtelo nuevamente.';
$string['missingdependency'] = 'Falta dependencia {$a->@dep} requerida por {$a->@lib}.';
$string['missinglibrary'] = 'Falta biblioteca requerida {$a->@library}';
$string['missinglibraryfile'] = 'El archivo "{$a->%file}" falta de la biblioteca : "{$a->%name}"';
$string['missinglibraryjson'] = 'No se pudo encontrar el archivo library.json con formato json válido para biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'La propiedad requerida {$a->%property} está faltando de {$a->%library}';
$string['missingmbstring'] = 'La extensión PHP mbstring no está cargada. H5P la necesita para funcionar adecuadamente.';
$string['missinguploadpermissions'] = 'Tenga en cuenta que las bibliotecas podrían existir en el archivo que Usted subió, pero Usted no tiene permitido subir nuevas bibliotecas. Por favor póngase en contacto con su administrador.';
$string['nocopyright'] = 'Sin información de copyright disponible para este contenido.';
$string['noextension'] = 'El archivo que Usted subió no es un Paquete HTML5 válido (no tiene la extensión de archivo .h5p.)';
$string['noh5plibhandlerdefined'] = 'No hay ningún manejador de estructura H5P instalado, por lo que el contenido H5P no puede ser mostrado.';
$string['nojson'] = 'El archivo principal h5p.json no es válido';
$string['nopermissiontodeploy'] = 'Este archivo no puede ser mostrado porque ha sido subido por un usuario sin la capacidad requerida para desplegar contenido H5P.';
$string['nopermissiontoedit'] = 'Usted no tiene permiso para editar contenido H5P.';
$string['notrustablefile'] = 'Este archivo no puede ser mostrado porque ha sido subido por un usuario sin la capacidad para actualizar tipos de contenido H5P. Por favor póngase en contacto con su administrador para pedirle que sea instalado el tipo de contenido.';
$string['nounzip'] = 'El archivo que Usted subió no es un Paquete HTML5 válido (No es posible descomprimirlo)';
$string['offlineDialogBody'] = 'No pudimos enviar información acerca de su finalización de este trabajo. Por favor revise su conexión de internet.';
$string['offlineDialogHeader'] = 'Se perdió su conexión al servidor';
$string['offlineDialogRetryButtonLabel'] = 'Reintentar ahora';
$string['offlineDialogRetryMessage'] = 'Reintentando en :num....';
$string['offlineSuccessfulSubmit'] = 'Resultados enviados exitosamente.';
$string['originator'] = 'Originador';
$string['pd'] = 'Dominio Público';
$string['pddl'] = 'Dedicación y Licencia del Dominio Público';
$string['pdm'] = 'Marca de Dominio Público (PDM)';
$string['pluginname'] = 'Paquete H5P';
$string['privacy:metadata'] = 'El subsistema H5P no almacena ningún dato personal.';
$string['resizescript'] = 'Incluya este script en su sitio web si desea ajuste de tamaño dinámico del contenido incrustado.';
$string['resubmitScores'] = 'Intentando enviar resultados guardados.';
$string['reuse'] = 'Reutilizar';
$string['reuseContent'] = 'Reutilizar Contenido';
$string['reuseDescription'] = 'Reutilizar este contenido.';
$string['showadvanced'] = 'Mostrar avanzadas';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';
$string['size'] = 'Tamaño';
$string['source'] = 'Orígen';
$string['startingover'] = 'Usted estará re-comenzando.';
$string['status'] = 'Estatus';
$string['sublevel'] = 'Subnivel';
$string['task_h5p'] = 'Trabajo agendado H5P';
$string['task_h5p_description'] = 'El Trabajo agendado H5P descarga tipos de contenido H5P desde h5p.org.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['undisclosed'] = 'No revelado';
$string['unpackedFilesExceedsMaxSize'] = 'El tamaño total de los archivos descomprimidos excede el tamaño máximo permitido. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Actualizó  {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Actualizó  {$a->%old} biblioteca H5P.';
$string['uploadlibraries'] = 'Subir tipos de contenido H5P';
$string['uploadsuccess'] = 'Tipos de contenido H5P subidos exitosamente';
$string['wrongversion'] = 'La versión de la biblioteca H5P {$a->%machineName} usada en este contenido no es válida. El contenido contiene {$a->%contentLibrary}, pero debería de ser {$a->%semanticsLibrary}.';
$string['year'] = 'Año';
$string['years'] = 'Año(s)';
$string['yearsfrom'] = 'Años (desde)';
$string['yearsto'] = 'Años (hasta)';
