<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'hu', version '3.10'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TEENDŐ';
$string['activityisscheduledfordeletion'] = 'Tevékenység törlése folyamatban...';
$string['agedigitalconsentmapinvalidage'] = 'A(z) "{$a}" értéke miatt érvénytelen az életkor.';
$string['agedigitalconsentmapinvalidcomma'] = 'A(z) "{$a}" egynél több vagy nulla elválasztó vesszőt tartalmaz.';
$string['agedigitalconsentmapinvalidcountry'] = 'A(z) "{$a}" értéke miatt érvénytelen az ország.';
$string['agedigitalconsentmapinvaliddefault'] = 'Hiányzik az alapbeállítás szerinti érték (*).';
$string['agelocationverificationdisabled'] = 'Életkor és hely ellenőrzése kikapcsolva';
$string['alreadyloggedin'] = 'Már {$a} felhasználóként belépett, mielőtt másik felhasználóként belép, ki kell lépnie.';
$string['authnotexisting'] = 'A hitelesítési segédprogram nem létezik.';
$string['backupcontainexternal'] = 'A biztonsági mentést tartalmazó állományban külső Moodle hálózati gazdagépek szerepelnek, melyek helyileg nincsenek konfigurálva.';
$string['backuptablefail'] = 'A biztonsági mentés táblázatait nem lehetett megfelelően beállítani!';
$string['blockcannotconfig'] = 'A blokk nem támogatja a globális konfigurációt';
$string['blockcannotinistantiate'] = 'Gond van a blokkobjektum elindítása körül';
$string['blockcannotread'] = 'A blockid= {$a} részére nem olvashatók adatok';
$string['blockdoesnotexist'] = 'A blokk nem létezik';
$string['blockdoesnotexistonpage'] = 'Ez a blokk  (id={$a->instanceid}) nem létezik ezen az oldalon ({$a->url}).';
$string['blocknameconflict'] = 'Elnevezések ütközése: a(z) {$a}[0] blokk címe azonos a létező {$a}[1] blokkéval!';
$string['callbackrejectcomment'] = 'A modul nem engedi a megjegyzés hozzáadását.';
$string['cannotaddcoursemodule'] = 'Az új kurzuskategória-modul hozzáadása nem sikerült.';
$string['cannotaddcoursemoduletosection'] = 'Az új kurzuskategória-modul adott részhez való hozzáadása nem sikerült.';
$string['cannotaddmodule'] = 'A(z) {$a} modult nem lehetett hozzáadni a modullistához!';
$string['cannotaddnewmodule'] = 'A(z) {$a} új moduljának a hozzáadása nem sikerült.';
$string['cannotaddrss'] = 'RSS-hírek frissítéséhez nincs engedélye';
$string['cannotaddthisblocktype'] = 'Az oldalhoz nem adhat hozzá {$a} blokkot.';
$string['cannotassignrole'] = 'A kurzusban nem lehet szerepet hozzárendelni';
$string['cannotassignrolehere'] = 'Ezt a szerepet (id = {$a->roleid}) ebben a környezetben ({$a->context}) nem rendelheti hozzá.';
$string['cannotassignselfasparent'] = 'Önmaga szülőként nem rendelhető hozzá!';
$string['cannotcallscript'] = 'Ez a kód így nem futtatható';
$string['cannotcallusgetselecteduser'] = 'Ha a multiselect igaz, a user_selector::get_selected_user eljárást nem hívhatja meg.';
$string['cannotcreatebackupdir'] = 'A biztonsági mentés adatainak mappáját nem lehetett létrehozni. A portál rendszergazdájának helyre kell hoznia az állományokhoz tartozó engedélyeket';
$string['cannotcreatecategory'] = 'A kategória beszúrása nem történt meg';
$string['cannotcreatedboninstall'] = '<p>Az adatbázis nem hozható létre.</p> <p>A megadott adatbázis nem létezik, a felhasználó pedig nem jogosult létrehozni egyet.</p> <p>A portál rendszergazdájának ellenőrizni kell az adatbázis-beállításokat.</p>';
$string['cannotcreategroup'] = 'Hiba a csoport létrehozása közben';
$string['cannotcreatelangbase'] = 'Hiba: Nem hozható létre az alapnyelvi könyvtár';
$string['cannotcreatelangdir'] = 'Nem hozható létre a lang könyvtár.';
$string['cannotcreateorfindstructs'] = 'Hiba a kurzus részstruktúráinak keresése vagy létrehozása közben';
$string['cannotcreatepopupwin'] = 'Definiálatlan elem – az előugró ablak nem hozható létre.';
$string['cannotcreatesitedir'] = 'A portálmappát nem lehetett létrehozni. A portál rendszergazdájának helyre kell hoznia az állományokhoz tartozó engedélyeket';
$string['cannotcreatetempdir'] = 'Nem hozható létre a temp könyvtár.';
$string['cannotcreateuploaddir'] = 'A feltöltési mappát nem lehetett létrehozni. A portál rendszergazdájának helyre kell hoznia az állományokhoz tartozó engedélyeket';
$string['cannotcustomisefiltersblockuser'] = 'Felhasználó- és blokk-környezetben nem módosíthatja a szűrőbeállításokat.';
$string['cannotdeletebackupids'] = 'Az előző biztonsági mentés azonosítóit nem lehetett törölni.';
$string['cannotdeletecategorycourse'] = 'A(z) \'{$a}\' kurzus törlése nem sikerült.';
$string['cannotdeletecategoryquestions'] = 'A(z) \'{$a}\' kategóriából nem sikerült a kérdések törlése.';
$string['cannotdeletecourse'] = 'Ezt a kurzust nem törölheti';
$string['cannotdeletecustomfield'] = 'Hiba egyéni mezőadatok törlése közben';
$string['cannotdeletedir'] = 'Nem törölhető ({$a})';
$string['cannotdeletefile'] = 'Az állomány nem törölhető';
$string['cannotdeleterole'] = '{$a} miatt nem törölhető';
$string['cannotdeleterolewithid'] = 'A(z) {$a} azonosítójú szerepet nem lehetett törölni';
$string['cannotdeletethisrole'] = 'Nem törölheti a szerepet, mert azt a rendszer használja, illetve mert ez az utolsó rendszergazdai szerep.';
$string['cannotdisableformat'] = 'Az alapformátum nem iktatható ki.';
$string['cannotdownloadcomponents'] = 'Az összetevőket nem lehet letölteni.';
$string['cannotdownloadlanguageupdatelist'] = 'A nyelvi frissítések listáját nem lehet letölteni a download.moodle.org helyről';
$string['cannotdownloadzipfile'] = 'A tömörített állományt nem lehet letölteni.';
$string['cannoteditcomment'] = 'Ezt a megjegyzést Ön nem szerkesztheti';
$string['cannoteditcommentexpired'] = 'Ezt nem szerkesztheti. Lejárt az idő!';
$string['cannoteditpostorblog'] = 'Nem közölhet vagy szerkeszthet blogüzeneteket!';
$string['cannoteditsiteform'] = 'Ezzel az űrlappal ezt a portálkurzust nem lehet szerkeszteni';
$string['cannotedituserpreferences'] = 'A felhasználó beállítások nem szerkeszthetők';
$string['cannotedityourprofile'] = 'Saját profilt nem szerkeszthet';
$string['cannotexecduringupgrade'] = 'Verziófrissítés alatt nem hajtható végre.';
$string['cannotfindcategory'] = 'A(z) {$a} azonosítójú adatbázisból származó kategóriarekord nem található';
$string['cannotfindcomponent'] = 'Nincs meg az összetevő.';
$string['cannotfindcontext'] = 'Nincs meg a környezet';
$string['cannotfindcourse'] = 'A kurzus nem található';
$string['cannotfinddocs'] = 'A(z) "{$a}" nyelvi dokumentumok nem találhatók';
$string['cannotfindgradeitem'] = 'Nincs meg a grade_item.';
$string['cannotfindgroup'] = 'Nincs meg a csoport';
$string['cannotfindhelp'] = 'A(z) "{$a}" nyelvi súgóállományok nem találhatók';
$string['cannotfindinfo'] = 'Nincs meg az infó ehhez: "{$a}"';
$string['cannotfindlang'] = 'A(z) "{$a}" nyelvi csomag nem található';
$string['cannotfindteacher'] = 'Nincs meg a tanár.';
$string['cannotfinduser'] = 'Nincs "{$a}" nevű felhasználó';
$string['cannotgeoplugin'] = 'A geoPlugin szerverre  https://www.geoplugin.com címen nem lehet rácsatlakozni, ellenőrizze a proxy beállításait vagy telepítse a MaxMind GeoLite City adatállományt.';
$string['cannotgetblock'] = 'Az adatbázisból nem lehetett kinyerni blokkokat';
$string['cannotgetcats'] = 'Hiba a kategóriarekord elérése közben';
$string['cannotgetdata'] = 'Az adatokat nem lehet elérni.';
$string['cannotgradeuser'] = 'A felhasználó nem pontozható';
$string['cannothaveparentcate'] = 'A kurzuskategóriának nem lehet felettes kategóriája!';
$string['cannotimport'] = 'Hiba importálás közben';
$string['cannotimportformat'] = 'Ezt a formátumot még nem lehet importálni!';
$string['cannotimportgrade'] = 'Hiba pont importálása közben';
$string['cannotinsertgrade'] = 'Az osztályozási tételt kurzus-azonosító nélkül nem lehet beszúrni!';
$string['cannotinsertrate'] = 'Nem lehetett frissíteni egy új értékelést ({$a}[0] = {$a}[1])';
$string['cannotinsertrecord'] = 'Nem lehetett az új {$a} rekordazonosítót beszúrni';
$string['cannotmailconfirm'] = 'Hiba a jelszómódosítást megerősítő e-mail küldése közben';
$string['cannotmanualctrack'] = 'A tevékenységgel nem lehet kézi teljesítés-ellenőrzést végezni.';
$string['cannotmapfield'] = 'Illesztési ütközés történt, két mező ugyanazon {$a} osztályozási tételhez illeszkedik';
$string['cannotmarktopic'] = 'A téma ezen kurzushoz nem jelölhető meg';
$string['cannotmigratedatacomments'] = 'Az adatmodul megjegyzéseit nem lehet áthelyezni';
$string['cannotmodulename'] = 'A modul neve a változat navigálása során nem érhető el.';
$string['cannotmoduletype'] = 'A modul típusa a változat navigálása során nem érhető el.';
$string['cannotmovecategory'] = 'A kategóriát nem lehet áthelyezni';
$string['cannotmovecourses'] = 'A kurzusok a kategóriából nem helyezhetők át egy másikba.';
$string['cannotmoverolewithid'] = 'A(z) {$a} azonosítójú szerepet nem lehet áthelyezni';
$string['cannotopencsv'] = 'A csv-állomány nem nyitható meg';
$string['cannotopenfile'] = 'Az állomány nem nyitható meg ({$a})';
$string['cannotopenforwrit'] = 'A(z) {$a} nem nyitható meg írásra';
$string['cannotopentemplate'] = 'A sablonállomány ({$a}) nem nyitható meg';
$string['cannotopenzip'] = 'A tömörített állomány nem nyitható meg, feltehetőleg 64 bites rendszeren fellépő kiterjesztési hiba miatt.';
$string['cannotoverridebaserole'] = 'Az alapszerephez tartozó képességeket nem lehet felülírni';
$string['cannotoverriderolehere'] = 'Ezt a szerepet (id = {$a->roleid}) ebben a környezetben ({$a->context}) nem írhatja felül.';
$string['cannotreadfile'] = 'Az állomány nem olvasható ({$a})';
$string['cannotreadtmpfile'] = 'Az ideiglenes állomány nem olvasható';
$string['cannotreaduploadfile'] = 'A feltöltött állomány nem olvasható';
$string['cannotremovefrommeta'] = 'A kiválasztott kurzust nem lehet a metakurzusból eltávolítani!';
$string['cannotreprocessgrades'] = '{$a} tevékenységhez nem sikerült újból feldolgozni az osztályzatokat.';
$string['cannotresetguestpwd'] = 'A vendég jelszavát nem állíthatja vissza';
$string['cannotresetmail'] = 'Hiba a jelszó visszaállítása és Önnek való elküldése közben';
$string['cannotresetthisrole'] = 'A szerepet nem lehet visszaállítani.';
$string['cannotrestore'] = 'Hiba történt, a helyreállítást nem lehetett végrehajtani';
$string['cannotrestoreadminorcreator'] = 'Új kurzusba való helyreállításhoz kurzuskészítőnek vagy rendszergazdának kell lennie!';
$string['cannotrestoreadminoredit'] = 'A kiválasztott kurzusba való helyreállításhoz szerkesztő tanárnak vagy rendszergazdának kell lennie!';
$string['cannotsaveagreement'] = 'Beleegyezését nem lehetett elmenteni:';
$string['cannotsaveblock'] = 'Hiba a blokk konfigurációjának mentése során';
$string['cannotsavecomment'] = 'A megjegyzést nem lehet elmenteni.';
$string['cannotsavedata'] = 'Az adatokat nem lehet elmenteni.';
$string['cannotsavefile'] = 'A(z) "{$a}" állományt nem lehet elmenteni.';
$string['cannotsavemd5file'] = 'Az md5 állományt nem lehet elmenteni.';
$string['cannotsavezipfile'] = 'A tömörített állományt nem lehet elmenteni.';
$string['cannotservefile'] = 'Az állomány nem szolgálható ki - szerver-beállítási hiba.';
$string['cannotsetparentforcatoritem'] = 'A kategória vagy kurzustétel felettes eleme nem állítható be!';
$string['cannotsetpassword'] = 'Nem állítható be a felhasználói jelszó!';
$string['cannotsetprefgrade'] = 'Ezen pontozási kategória esetén az összesített nézet nem állítható be {$a} értékre';
$string['cannotsettheme'] = 'Nem állítható be a stílus!';
$string['cannotsetupblock'] = 'A blokk táblázatait nem lehetett megfelelően beállítani!';
$string['cannotsetupcapformod'] = '{$a} esetén nem lehetett a képességeket beállítani';
$string['cannotsetupcapforplugin'] = '{$a} esetén nem lehetett képességeket beállítani';
$string['cannotshowhidecoursesincategory'] = 'A(z) {$a} kategóriában lévő kurzusok nem jeleníthetők meg/rejthetők el.';
$string['cannotsignup'] = 'Nem hozhat létre új fiókot, mert már mint {$a} bejelentkezett.';
$string['cannotunassigncap'] = 'A(z) {$a}[1] szerep régi {$a}[0] képessége nem törölhető';
$string['cannotunassignrolefrom'] = 'A felhasználóról nem választható le a(z) {$a} szerepazonosító';
$string['cannotunzipfile'] = 'A tömörített állományt nem lehet kicsomagolni.';
$string['cannotupdatemod'] = 'A(z) {$a} frissítése nem sikerült';
$string['cannotupdatepasswordonextauth'] = 'Nem sikerült frissíteni a jelszót a külső auth: {$a} esetén. További részleteket talál a szervernaplókban.';
$string['cannotupdateprofile'] = 'Hiba a felhasználói rekord frissítése közben';
$string['cannotupdaterecord'] = 'Nem lehetett a(z) {$a} rekordazonosítót frissíteni';
$string['cannotupdaterss'] = 'Nem sikerült frissíteni az RSS-t!';
$string['cannotupdatesubcourse'] = 'Egy alkurzust nem sikerült frissíteni!';
$string['cannotupdateusermsgpref'] = 'A felhasználói üzenet-beállítások frissítése nem sikerült';
$string['cannotupdateuseronexauth'] = 'A felhasználói adatok frissítése a külső {$a} hitelesítéssel nem sikerült. A részleteket lásd a szervernaplókban.';
$string['cannotuploadfile'] = 'Hiba feltöltött állomány feldolgozása közben';
$string['cannotuseadmin'] = 'Az oldal használatához rendszergazdának kell lennie.';
$string['cannotuseadminadminorteacher'] = 'Az oldal használatához rendszergazdának vagy tanárnak kell lennie.';
$string['cannotusepage'] = 'Ezt az oldalt csak tanárok és rendszergazdák használhatják.';
$string['cannotusepage2'] = 'Ezt az oldat Ön nem használhatja';
$string['cannotviewcategory'] = 'A kurzuslista megtekintéséhez nincs engedélye.';
$string['cannotviewprofile'] = 'Ezen felhasználó profilját Ön nem tekintheti meg.';
$string['cannotviewreport'] = 'A jelentést nem tekintheti meg.';
$string['cannotwritefile'] = 'Nem lehet az állományba írni ({$a})';
$string['categoryerror'] = 'Kategóriahiba';
$string['categoryidnumbertaken'] = 'Az azonosítószámot egy másik kategória használja.';
$string['categorynamerequired'] = 'Adjon meg kategórianevet.';
$string['categorytoolong'] = 'A kategória neve túl hosszú';
$string['commentmisconf'] = 'A megjegyzéshez tartozó azonosító rosszul van konfigurálva';
$string['componentisuptodate'] = 'Az összetevő a legfrissebb.';
$string['confirmationnotenabled'] = 'A portálon a felhasználói jóváhagyás nincs bekapcsolva';
$string['confirmsesskeybad'] = 'Sajnos a használati kulcsát ezen tevékenység végrehajtásához nem sikerült megerősíteni. Ez a biztonsági intézkedés megelőzi, hogy az Ön nevében valaki fontos funkciókat hajtson végre akár véletlenül, akár rosszat akarva. Ellenőrizze, hogy valóban ezt kívánja-e tenni.';
$string['contenttypenotfound'] = '\'{$a}\' típusú tartalombank nem létezik vagy nem ismerhető föl.';
$string['couldnotassignrole'] = 'Súlyos, meghatározatlan hiba történt szerepének kijelölése során';
$string['couldnotupdatenoexistinguser'] = 'A felhasználó frissítése nem sikerült - nincs ilyen felhasználó.';
$string['couldnotverifyagedigitalconsent'] = 'Hiba a hozzájárulás digitális korának ellenőrzése közben.<br />Forduljon a rendszergazdához.';
$string['countriesphpempty'] = 'Hiba: a countries.php a(z) {$a} nyelvi csomagban üres vagy hiányzik.';
$string['coursedoesnotbelongtocategory'] = 'A kurzus nem ebbe a kategóriába tartozik.';
$string['courseformatnotfound'] = 'A(z) \'{$a}\' kurzusforma nem létezik vagy nem ismerhető föl.';
$string['coursegroupunknown'] = 'A(z) {$a} csoportnak megfelelő kurzus nincs megadva';
$string['courseidnotfound'] = 'A kurzus-azonosító nem létezik.';
$string['courseidnumbertaken'] = 'A(z) ({$a}) azonosítószámot már egy másik kurzus használja.';
$string['coursemisconf'] = 'A kurzus hibásan van konfigurálva';
$string['courserequestdisabled'] = 'A kurzuskérést a rendszergazda kikapcsolta.';
$string['csvcolumnduplicates'] = 'Ismétlődő oszlopok fordulnak elő.';
$string['csvemptyfile'] = 'A CSV-állomány üres.';
$string['csvfewcolumns'] = 'Kevés az oszlop, ellenőrizze a határoló beállításait.';
$string['csvfileerror'] = 'Hiba a CSV-állomány formátumával. Ellenőrizze, egyezik-e a fejlécek és oszlopok száma, és helyes-e az elválasztó és az állomány kódolása: {$a}';
$string['csvinvalidcols'] = '<b>Érvénytelen CSV-állomány:</b> Az első sorban legyenek "Header Fields" (fejlécmezők), típusa pedig legyen <br />"Expanded Fields/Comma Separated" (kibővített mezők/vesszővel elválasztott)<br />vagy<br /> "Expanded Fields with CAVV Result Code/Comma Separated" (CAVV-eredménykódos kibővített mezők/vesszővel elválasztott)';
$string['csvinvalidcolsnum'] = 'Érvénytelen CSV-állomány – egy-egy sor 49 vagy 70 mezőt tartalmazhat';
$string['csvloaderror'] = 'Hiba a CSV-állomány betöltése közben: {$a}';
$string['csvnodata'] = 'Érvénytelen CSV-állomány. A  CSV-állománynak vannak fejlécei, de nem tartalmaz adatokat.';
$string['csvweirdcolumns'] = 'Érvénytelen formájú CSV-állomány – az oszlopszám nem állandó!';
$string['dbconnectionfailed'] = '<p>Hiba: az adatbázishoz kapcsolódás nem sikerült</p>
<p>Lehet, hogy az adatbázis túlterhelt vagy más okból nem működik megfelelően.</p> <p>A portál rendszergazdájának ellenőriznie kell azt is, hogy a config.php állományban az adatbázis részleteit megfelelően adták-e meg.</p>{$a}';
$string['dbdriverproblem'] = '<p>Hiba: gond van az adatbázis-meghajtóval</p> <p>A portál rendszergazdájának ellenőriznie kell a szerver konfigurációját</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Súlyos gond van az adatbázissal.<br /><br />Értesítse a rendszergazdát.';
$string['dbsessionhandlerproblem'] = 'Az adatbázis beállítása nem sikerült. Értesítse a rendszergazdát.';
$string['dbsessionmysqlpacketsize'] = 'Súlyos gond van a folyamattal. Értesítse a rendszergazdát. A hibát feltehetőleg a MySQL max_allowed_packet beállításának alacsony értéke okozza.';
$string['dbupdatefailed'] = 'Az adatbázis frissítése nem sikerült';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nem módosítható. Összefügg ezzel: {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Hiba a DDL sql végrehajtása közben';
$string['ddlfieldalreadyexists'] = 'A(z) "{$a}" mező már létezik';
$string['ddlfieldnotexist'] = 'A(z) "{$a->tablename}" táblázat "{$a->fieldname}" mezője nem létezik';
$string['ddltablealreadyexists'] = 'A(z) "{$a}" táblázat már létezik';
$string['ddltablenotexist'] = 'A(z) "{$a}" táblázat nem létezik';
$string['ddlunknownerror'] = 'Ismeretlen hiba a DDL-könyvtárral kapcsolatosan';
$string['ddlxmlfileerror'] = 'Hibák vannak az XML adatbázis-állományban';
$string['ddsequenceerror'] = 'A(z) "{$a}" tábla meghatározása hibás; csak egy automatikus oszlop lehet, és azt kulcsként kell megadni.';
$string['destinationcmnotexit'] = 'A célkurzusmodul nem létezik';
$string['detectedbrokenplugin'] = 'A(z) "{$a}" segédprogram hibás vagy régi, az eljárás nem folytatható.';
$string['dmlexceptiononinstall'] = '<p>Adatbázishiba történt [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Hiba az SQL-lekérdezés feldolgozása közben';
$string['dmlreadexception'] = 'Hiba az adatbázis olvasása közben.';
$string['dmltransactionexception'] = 'Hiba az adatbázis-művelet során';
$string['dmlwriteexception'] = 'Hiba az adatbázis írása közben.';
$string['downgradedcore'] = 'HIBA!!! A használt kód RÉGEBBI, mint az ezen adatbázisok létrehozásához használt verzió.';
$string['downloadedfilecheckfailed'] = 'A letöltött állomány ellenőrzése nem sikerült.';
$string['duplicatefieldname'] = 'Ismétlődő "{$a}" mezőnév';
$string['duplicatenosupport'] = '"{$a->modname}" tevékenység nem másolható, mert a {$a->modtype} modul nem támogatja a biztonsági mentést és visszaállítást.';
$string['duplicateparaminsql'] = 'HIBA: dupla paraméternév a lekérdezésben!';
$string['duplicaterolename'] = 'Ezen a néven már létezik szerep!';
$string['duplicateroleshortname'] = 'Ezen a rövid néven már létezik szerep!';
$string['duplicateusername'] = 'Ismétlődő felhasználónév - a rekord kihagyva';
$string['emailfail'] = 'Az e-mail sikertelen';
$string['enddatebeforestartdate'] = 'A kurzus vége nem lehet korábban, mint a kezdete.';
$string['error'] = 'Hiba történt';
$string['error_question_answers_missing_in_db'] = 'A kérdések-feleletek adatbázistáblában nincs "{$a->answer}" szerint megfelelő válasz. Ez a(z) {$a->filequestionid} azonosítójú biztonsági mentésben lévő kérdés helyreállítása közben fordult elő az adatbázis {$a->dbquestionid} azonosítójú meglévő kérdésével való egyeztetés közben.';
$string['errorcleaningdirectory'] = 'Hiba a(z) "{$a}" könyvtár kitakarítása során';
$string['errorcopyingfiles'] = 'Hiba az állományok másolása közben';
$string['errorcreatingdirectory'] = 'Hiba a(z) "{$a}" könyvtár létrehozása közben';
$string['errorcreatingfile'] = 'Hiba a(z) "{$a}" állomány létrehozása közben';
$string['errorcreatingrole'] = 'Hiba a szerep létrehozása közben.';
$string['errorfetchingrssfeed'] = 'Hiba az RSS-hír elérése közben';
$string['erroronline'] = 'Hiba a(z) {$a} sorban';
$string['erroroutput'] = 'Hibás kimenet miatt az automatikus átirányítás kikapcsolva.';
$string['errorparsingxml'] = 'XML-feldolgozási hiba: {$a->errorstring} a {$a->errorline} sorban a {$a->errorchar} karakternél';
$string['errorprocessingarchive'] = 'Hiba az archivált állomány feldolgozása közben';
$string['errorreadingfile'] = 'Hiba a(z) "{$a}" állomány olvasása közben';
$string['errorsavingrequest'] = 'Kérésének mentése közben hiba történt.';
$string['errorsettinguserpref'] = 'A felhasználói beállítás közben hiba történt.';
$string['errorunzippingfiles'] = 'Hiba az állományok kicsomagolása közben';
$string['expiredkey'] = 'Lejárt kulcs';
$string['externalauthpassworderror'] = 'Nem üres jelszó külső hitelesítéshez';
$string['externalfilenolocation'] = 'A külső állománynak nincs elérési útvonala';
$string['failtoloadblocks'] = 'Az adatbázisban egy vagy több blokk van regisztrálva, de betöltésük nem sikerült!';
$string['fieldrequired'] = 'A(z) "{$a}" mező kitöltendő';
$string['fileexists'] = 'Az állomány létezik';
$string['filemismatch'] = 'Nem egyező másodlagos állománynevek. A(z) "{$a}[0]" állománynak {$a[1]}{$a[2]}.php-nek kell lennie';
$string['filenotfound'] = 'A kért állomány nem található';
$string['filenotreadable'] = 'Az állomány nem olvasható.';
$string['filterdoesnothavelocalconfig'] = 'A(z) {$a} szűrő nem engedélyez helybeni beállítást.';
$string['filternotactive'] = 'A(z) {$a} szűrő jelenleg nincs bekapcsolva';
$string['filternotenabled'] = 'A szűrő nincs bekapcsolva!';
$string['filternotinstalled'] = 'A(z) {$a} szűrő jelenleg nincs telepítve';
$string['forumblockingtoomanyposts'] = 'Túllépte a fórumra beállított üzenetek számát.';
$string['functionalityremoved'] = 'Törölt funkciót próbál elérni.';
$string['generalexceptionmessage'] = 'Kivétel - {$a}';
$string['gradecantregrade'] = 'Hiba történt az osztályzat kiszámítása közben: {$a}';
$string['gradepubdisable'] = 'A pont közzététele kikapcsolva';
$string['gradesneedregrading'] = 'A kurzusosztályzatokat újra kell számolni.';
$string['groupalready'] = 'A felhasználó már a(z) {$a} csoport tagja';
$string['groupexistforcourse'] = 'A(z) "{$a}" csoport már létrejött ehhez a kurzushoz';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: a kurzus esetén a(z) "{$a->name}" nevű, "{$a->idnumber}" számú csoport már létezik.';
$string['grouphasidnumber'] = 'A(z) "{$a}" csoportnak azonosítószáma van, melyet esetleg egy külső rendszer automatikusan hozott létre. A csoport eltávolítására Ön nem jogosult.';
$string['groupinghasidnumber'] = 'A(z) "{$a}" csoportosításnak azonosítószáma van, melyet esetleg egy külső rendszer automatikusan hozott létre. A csoportosítás eltávolítására Ön nem jogosult.';
$string['groupingnotaddederror'] = '"{$a}" csoportosítás nincs hozzáadva';
$string['groupnotaddederror'] = 'A(z) "{$a}" csoport hozzáadása nem történt meg';
$string['groupnotaddedtogroupingerror'] = '"{$a->groupname}" csoport "{$a->groupingname}" csoportosításhoz nincs hozzáadva';
$string['groupunknown'] = 'A(z) {$a} csoport nem kapcsolódik konkrét kurzushoz';
$string['groupusernotmember'] = 'A felhasználó nem tagja a csoportnak.';
$string['guestcantaccessprofiles'] = 'Vendégek nem érik el a felhasználói profilokat. A folytatáshoz jelentkezzen be teljes felhasználói fiókadatokkal.';
$string['guestnocomment'] = 'Vendégek nem tehetnek közzé megjegyzéseket!';
$string['guestnoeditprofile'] = 'Vendégek nem szerkeszthetik profiljukat';
$string['guestnoeditprofileother'] = 'A vendég felhasználói profilja nem szerkeszthető';
$string['guestnorate'] = 'Vendégek nem értékelhetnek bejegyzéseket.';
$string['guestsarenotallowed'] = 'Vendégeknek erre nincs lehetőségük.';
$string['hackdetected'] = 'Hekkertámadás történt!';
$string['hashpoolproblem'] = 'Hibás nyomtatási {$a} állománytartalom.';
$string['headersent'] = 'A fejlécek elküldése már megtörtént';
$string['idnumbertaken'] = 'Az azonosítószámot egy másik kurzus használja';
$string['idnumbertoolong'] = 'Az azonosítószám túl hosszú';
$string['importformatnotimplement'] = 'Ezen formátum importálása még nem készült el!';
$string['incorrectext'] = 'Az állomány kiterjesztése hibás.';
$string['inplaceeditableerror'] = 'Hiba a frissítő feldolgozó meghívása közben';
$string['installproblem'] = 'Általában nincs lehetőség a telepítés során előforduló hibák kiküszöbölésére, előfordulhat, hogy új adatbázist kell létrehoznia vagy egy másik adatbázis-előtagot kell használnia, ha újra akarja futtatni a telepítést.';
$string['internalauthpassworderror'] = 'Nincs jelszó vagy érvénytelen jelszómegadás a belső hitelesítéshez';
$string['invalidaccess'] = 'Az oldal elérése hibásan történt';
$string['invalidaccessparameter'] = 'Érvénytelen hozzáférési paraméter.';
$string['invalidaction'] = 'Érvénytelen tevékenységparaméter.';
$string['invalidactivityid'] = 'Érvénytelen tevékenységazonosító';
$string['invalidadminsettingname'] = 'Érvénytelen rendszergazdai beállítás ({$a})';
$string['invalidargorconf'] = 'Nincsenek megadva érvényes argumentumok vagy hibás a szerver beállítása';
$string['invalidarguments'] = 'Nincsenek megadva érvényes argumentumok';
$string['invalidblockinstance'] = 'Blokk érvénytelen előfordulása {$a} esetén';
$string['invalidbulkenrolop'] = 'Érvénytelen egyesített beiratkoztatási műveletet kért';
$string['invalidcategory'] = 'Hibás kategória!';
$string['invalidcategoryid'] = 'Hibás kategóriaazonosító!';
$string['invalidcomment'] = 'Érvénytelen megjegyzés';
$string['invalidcommentarea'] = 'Érvénytelen terület a megjegyzéshez';
$string['invalidcommentid'] = 'Érvénytelen azonosító a megjegyzéshez';
$string['invalidcommentitemid'] = 'Érvénytelen azonosító az adott megjegyzési tételhez';
$string['invalidcommentparam'] = 'Érvénytelen megjegyzés-paraméterek';
$string['invalidcomponent'] = 'Érvénytelen összetevőnév';
$string['invalidconfirmdata'] = 'Érvénytelen megerősítő adatok';
$string['invalidcontentid'] = 'Érvénytelen tartalomazonosító';
$string['invalidcontext'] = 'Érvénytelen környezet';
$string['invalidcountrycode'] = 'Érvénytelen országkód: {$a}';
$string['invalidcourse'] = 'Érvénytelen kurzus';
$string['invalidcourseformat'] = 'Érvénytelen kurzusforma';
$string['invalidcourseid'] = 'Érvénytelen kurzus-azonosítót próbál használni';
$string['invalidcourselevel'] = 'Hibás környezetszint';
$string['invalidcoursemodule'] = 'Érvénytelen kurzusmodul-azonosító';
$string['invalidcoursenameshort'] = 'Érvénytelen rövid kurzusnév';
$string['invaliddata'] = 'Érvénytelenek a leadott adatok';
$string['invaliddatarootpermissions'] = 'Érvénytelen jogosultságok könyvtár létrehozása közben. További részletekért kapcsolja be a hibaelemzést.';
$string['invaliddevicetype'] = 'Érvénytelen eszköztípus';
$string['invalidelementid'] = 'Hibás elemazonosító!';
$string['invalidentry'] = 'Ez a bejegyzés nem érvényes!';
$string['invalidevent'] = 'Érvénytelen esemény';
$string['invalidfieldname'] = 'A(z) "{$a}" érvénytelen állománynév';
$string['invalidfiletype'] = 'A(z) "{$a}" érvénytelen állománytípus';
$string['invalidformatpara'] = 'A kiválasztott paraméter formátuma hibás';
$string['invalidformdata'] = 'Hibás űrlapadatok';
$string['invalidfunction'] = 'Hibás függvény';
$string['invalidgradeitemid'] = 'Hibás az osztályozási tétel azonosítója';
$string['invalidgroupid'] = 'Hibás csoportazonosító van megadva!';
$string['invalidipformat'] = 'Érvénytelen formájú IP-cím';
$string['invaliditemid'] = 'Hibás tételazonosító!';
$string['invalidkey'] = 'Hibás kulcs';
$string['invalidlanguagecode'] = 'Érvénytelen nyelvkód: {$a}';
$string['invalidlegacy'] = 'Hibás régi szerepmeghatározás {$a} típus esetén';
$string['invalidmd5'] = 'Az ellenőrző változó hibás volt – próbálkozzék ismét';
$string['invalidmode'] = 'Érvénytelen mód ({$a})';
$string['invalidmodule'] = 'Érvénytelen modul';
$string['invalidmoduleid'] = 'Érvénytelen modulazonosító: {$a}';
$string['invalidmodulename'] = 'Érvénytelen modulnév: {$a}';
$string['invalidnum'] = 'Érvénytelen numerikus érték';
$string['invalidnumkey'] = 'A(z) $conditions tömb nem tartalmazhat numerikus kulcsokat, javítsa a kódot!';
$string['invalidoutcome'] = 'Hibás eredményazonosító';
$string['invalidpagesize'] = 'Érvénytelen oldalméret';
$string['invalidpasswordpolicy'] = 'Érvénytelen jelszómegadás';
$string['invalidpaymentmethod'] = 'Érvénytelen fizetési mód: {$a}';
$string['invalidqueryparam'] = 'HIBA: hibás számú lekérdezési paraméter. A(z) {$a->expected} helyett {$a->actual}.';
$string['invalidratingarea'] = 'Érvénytelen értékelési terület';
$string['invalidrecord'] = 'A(z) {$a} adatbázistábla nem tartalmaz adatrekordot.';
$string['invalidrecordunknown'] = 'Az adatbázis nem tartalmaz adatrekordot.';
$string['invalidrequest'] = 'Érvénytelen kérés';
$string['invalidrole'] = 'Érvénytelen szerep';
$string['invalidroleid'] = 'Érvénytelen szerepazonosító';
$string['invalidscaleid'] = 'Hibás skálaazonosító!';
$string['invalidsection'] = 'A kurzusmodulrekord érvénytelen szakaszt tartalmaz.';
$string['invalidsesskey'] = 'Időtartama feltehetőleg lejárt. Jelentkezzen be újra!';
$string['invalidshortname'] = 'Érvénytelen rövid kurzusnév';
$string['invalidsourcefield'] = 'A piszkozat forrásmezője érvénytelen';
$string['invalidstatedetected'] = 'Valamilyen gond támadt: {$a}. Általában ez nem fordulhat elő.';
$string['invalidurl'] = 'Érvénytelen URL';
$string['invaliduser'] = 'Érvénytelen felhasználó';
$string['invaliduserdata'] = 'Érvénytelen felhasználói adat: {$a}';
$string['invaliduserfield'] = 'Érvénytelen felhasználói mező: {$a}';
$string['invaliduserid'] = 'Érvénytelen felhasználóazonosító';
$string['invalidusername'] = 'A felhasználónévben érvénytelen karakterek szerepelnek.';
$string['invalidusernameblank'] = 'A felhasználónév nem lehet üres';
$string['invalidxmlfile'] = 'A(z) "{$a}" érvénytelen XML-állomány';
$string['iplookupfailed'] = 'Ezen {$a} IP-címhez nem található földrajzi információ.';
$string['iplookupprivate'] = 'Nem jeleníthető meg a magán-IP-cím keresése';
$string['ipmismatch'] = 'A kliens IP-címe nem egyezik';
$string['listcantmovedown'] = 'A tétel nem vihető lejjebb, mert az utolsó.';
$string['listcantmoveleft'] = 'A tétel nem vihető balra, nincs felette lévő tétel.';
$string['listcantmoveright'] = 'A tétel nem vihető jobbra, nem rendelhető egy másik alá. Vigye másik tétel alá, ahol jobbra mozgathatja.';
$string['listcantmoveup'] = 'A tétel nem vihető feljebb, mert legfelül van.';
$string['listnochildren'] = 'A tételnek nincsenek alárendelt elemei.';
$string['listnoitem'] = 'A tétel nem található.';
$string['listnopeers'] = 'A tételnek nincsenek mellérendelt elemei.';
$string['listupdatefail'] = 'A listahierarchia szerkesztése közben az adatbázis-művelet végrehajtása nem sikerült.';
$string['logfilenotavailable'] = 'Nincsenek elérhető naplók';
$string['loginasnoenrol'] = 'A beiratkozást és a kiiratkozást nem használhatja a kurzus "Belépés mint" folyamata közben.';
$string['loginasonecourse'] = 'Ebbe a kurzusba nem léphet be. <br />Mielőtt bármely egyéb kurzusba belép, be kell fejeznie a "Belépés mint" folyamatot.';
$string['maxareabytes'] = 'Az állomány tárolásához nincs elegendő hely.';
$string['maxbytesfile'] = 'A(z)  {$a->file} állomány túl nagy. A feltölthető maximális méret  {$a->size}.';
$string['maxdraftitemids'] = 'Feltöltését a sok fájl feltöltését követően korlátoztuk. Próbálkozzon később!';
$string['messageundeliveredbynotificationsettings'] = 'Az üzenetet nem lehetett elküldeni, mert egy rendszergazda kikapcsolta a felhasználók közötti személyes üzeneteket (az értesítési beállításokban).';
$string['messagingdisable'] = 'Ezen a portálon az üzenetküldés ki van kapcsolva';
$string['mimetexisnotexist'] = 'Rendszere nincs beállítva a mimeTeX futtatásához. Be kell szereznie a C nyelvű forráskódot a <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a> címről, a futtatható kódot pedig a moodle/filter/tex/ könyvtárba kell tennie.';
$string['mimetexnotexecutable'] = 'A testre szabott mimetex nem futtatható!';
$string['missing_moodle_backup_xml_file'] = 'A biztonsági mentésből hiányzik a(z) {$a} XML-állomány.';
$string['missingfield'] = 'A(z) "{$a}" mező hiányzik.';
$string['missingkeyinsql'] = 'HIBA: a lekérdezésben nincs "{$a}" paraméter.';
$string['missingparam'] = 'Egy paraméter ({$a}) hiányzott';
$string['missingparameter'] = 'Hiányzik egy paraméter';
$string['missingrequiredfield'] = 'Egy szükséges mező hiányzik.';
$string['missinguseranditemid'] = 'Hiányzik a felhasználó és a tétel azonosítója';
$string['missingvarname'] = 'Hiányzik a változónév!';
$string['mixedtypesqlparam'] = 'HIBA: a lekérdezésben vegyes sql-paraméterek vannak!';
$string['mnetdisable'] = 'Az MNET ki van kapcsolva';
$string['mnetlocal'] = 'Távoli MNET-felhasználók helyben nem jelentkezhetnek be';
$string['moduledisable'] = 'Ez a modul ({$a}) az adott kurzus esetén ki van kapcsolva';
$string['moduledoesnotexist'] = 'A modul nem létezik';
$string['moduleinstancedoesnotexist'] = 'A modul példánya nem létezik';
$string['modulemissingcode'] = 'A(z) {$a} modulból hiányzik a funkció végrehajtásához szükséges programkód.';
$string['movecatcontentstoroot'] = 'A kategóriatartalmat nem helyezheti át a gyökérkönyvtárba. Helyezze át egy meglévő kategóriába!';
$string['movecatcontentstoselected'] = 'A kategóriatartalmak egy részét nem lehet áthelyezni a kiválasztott kategóriába.';
$string['movecategorynotpossible'] = 'A(z)  \'{$a}\' kategória nem helyezhető át a kiválasztott kategóriába.';
$string['movecategoryownparent'] = 'A(z)  \'{$a}\' kategória nem lehet önmaga fölött álló kategória';
$string['movecategoryparentconflict'] = 'A(z)  \'{$a}\' kategória nem lehet önmaga alkategóriáinak alkategóriája';
$string['mssqlrcsmodemissing'] = 'Az adatbázis nem a várt READ_COMMITTED_SNAPSHOT üzemmódot használja, ami különösen nagy versenyzésű forgatókönyvek esetén hibás eredményhez vezethet. Kapcsolja be a helyes viselkedés érdekében. További részletek: <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration">Moodle Docs</a>.';
$string['multiplerecordsfound'] = 'Több rekord fordul elő, csak egy használata lehetséges.';
$string['multiplerestorenotallow'] = 'Többszörös helyreállítás végrehajtása nem engedélyezett!';
$string['mustbeloggedin'] = 'Ehhez be kell jelentkeznie.';
$string['mustbeteacher'] = 'Az oldal megtekintéséhez tanárnak kell lennie';
$string['myisamproblem'] = 'Az adatbázistáblák MyISAM adatbázismotort használnak, ajánlatos ACID-nak megfelelő, tranzakciókat teljesen támogató motort (pl. InnoDB) használni.';
$string['needcopy'] = 'Először ki kell másolnia valamit!';
$string['needcoursecategroyid'] = 'Vagy kurzus-azonosítót, vagy kategóriát kell megadnia';
$string['needphpext'] = 'A telepített PHP-változathoz szüksége van {$a}-támogatásra';
$string['noadmins'] = 'Nincsenek rendszergazdák!';
$string['noblocks'] = 'Nincsenek blokkok!';
$string['nocapabilitytousethisservice'] = 'A felhasználó nem rendelkezik a szolgáltatáshoz szükséges jogosultsággal.';
$string['nocategorydelete'] = 'A \'{$a}\' kategória nem törölhető!';
$string['nocontext'] = 'Az adott kurzus nem érvényes környezet';
$string['nodata'] = 'Nincs adat.';
$string['noexistingcategory'] = 'Nincs kategória';
$string['nofile'] = 'Nincs megadva állomány.';
$string['nofiltersenabled'] = 'Nincs bekapcsolva szűrő.';
$string['nofolder'] = 'A szükséges könyvtár nem létezik.';
$string['noformdesc'] = 'Ehhez a tevékenységhez nincs formslib űrlapleíró állomány.';
$string['noguest'] = 'Itt nincsenek vendégek!';
$string['noinstances'] = 'A(z) {$a} nem fordul elő ebben a kurzusban!';
$string['nologinas'] = 'Ilyen felhasználóként nem léphet be';
$string['nonmeaningfulcontent'] = 'Nem értelmezhető tartalom';
$string['noparticipants'] = 'A kurzushoz nincsenek résztvevők!';
$string['noparticipatorycms'] = 'Önnek nincs jelentendő résztvevői kurzusmodulja.';
$string['nopermissions'] = 'Ehhez ({$a}) jelenleg nincs engedélye.';
$string['nopermissiontocomment'] = 'Nem adhat hozzá megjegyzéseket.';
$string['nopermissiontodelentry'] = 'A megjegyzést nem törölheti!';
$string['nopermissiontoeditcomment'] = 'Mások megjegyzéseit nem szerkesztheti.';
$string['nopermissiontohide'] = 'Nincs engedélye az elrejtéshez!';
$string['nopermissiontoimportact'] = 'Nincs engedélye arra, hogy a kurzusba tevékenységeket importáljon';
$string['nopermissiontolock'] = 'Nincs engedélye a zárolásra!';
$string['nopermissiontomanagegroup'] = 'Nincs engedélye csoportok kezeléséhez';
$string['nopermissiontorate'] = 'Tételek értékelése nincs engedélyezve!';
$string['nopermissiontoshow'] = 'Nincs engedélye a megtekintéséhez!';
$string['nopermissiontounlock'] = 'Nincs engedélye a feloldáshoz!';
$string['nopermissiontoupdatecalendar'] = 'A naptáresemény frissítéséhez nincs engedélye.';
$string['nopermissiontoviewgrades'] = 'Az osztályzatok nem láthatók.';
$string['nopermissiontoviewletergrade'] = 'Betűpontozás megtekintése nincs engedélyezve';
$string['nopermissiontoviewpage'] = 'Ön nem nézheti meg ezt az oldalt.';
$string['nosite'] = 'Nincs felső szintű kurzus!';
$string['nositeid'] = 'Nincs portálazonosító';
$string['nostartdatenoenddate'] = 'A kurzus vége csak akkor adható meg, ha van beállítva kurzus kezdete.';
$string['nostatstodisplay'] = 'Nincsenek megjelenítendő adatok.';
$string['notallowedtoupdateprefremotely'] = 'Ezt a felhasználói beállítást távolról nem frissítheti.';
$string['notavailable'] = 'Jelenleg nem elérhető';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Ön nem tagja annak a kurzuscsoportnak';
$string['notownerofkey'] = 'Ez a kulcs nem az Öné';
$string['nousers'] = 'Nincs ilyen felhasználó!';
$string['oauth1accesstoken'] = 'OAuth 1.0 hiba: nem kaptuk meg a hozzáférési jelet.';
$string['oauth1requesttoken'] = 'OAuth 1.0 hiba: nem kaptuk meg a kérelmi jelet - lehet, hogy a szolgáltatás ideiglenesen szünetel.';
$string['oauth2refreshtokenerror'] = 'Az OAuth 2 vezérjel nem frissíthető. HTTP állapota a távoli végponthoz: {$a}';
$string['onlyadmins'] = 'Csak rendszergazdák jogosultak erre';
$string['onlyeditingteachers'] = 'Csak szerkesztő tanárok jogosultak erre';
$string['onlyeditown'] = 'Csak saját adatait szerkesztheti';
$string['orderidnotfound'] = 'A(z) {$a} rendelés-azonosító nem található';
$string['pagenotexist'] = '<p>Váratlan hiba történt, miközben egy nem létező oldalt próbált megtekinteni:</p>{$a}';
$string['pagenotexisttitle'] = '404-es hiba: Nem található a fájl.';
$string['pathdoesnotstartslash'] = 'Nincsenek megadva érvényes argumentumok, az útvonal nem perjellel kezdődik!';
$string['pleasereport'] = 'Ha van rá ideje, tudassa velünk, mit próbált végrehajtani, amikor a hiba bekövetkezett:';
$string['pluginrequirementsnotmet'] = 'A(z) "{$a->pluginname}" ({$a->pluginversion}) segédprogramot nem lehetett telepíteni. Ehhez a Moodle újabb verziójára van szükség (Ön jelenleg a(z) {$a->currentmoodle} verziót használja, a(z) {$a->requiremoodle} verzióra van szüksége).';
$string['pluginunsupported'] = 'A(z) "{$a->pluginname}" {$a->pluginversion} verziója nem támogatja a Moodle {$a->moodleversion} verziójának a használatát. A segédprogram leírásában olvassa el, melyek a támogatott verziók.';
$string['prefixcannotbeempty'] = '<p>Hiba: az adatbázis táblázatának előtagja nem lehet üres ({$a})</p> <p>A portál rendszergazdájának el kell hárítania ezt a problémát.</p>';
$string['prefixtoolong'] = '<p>Hiba: az adatbázis táblázatának előtagja túl hosszú ({$a->dbfamily})</p> <p>A portál rendszergazdájának el kell hárítania ezt a problémát. A táblázatának előtagjának maximális hossza {$a->dbfamily} esetén {$a->maxlength} karakter.</p>';
$string['privatefilesupload'] = 'Már nem lehet közvetlenül magánállományok területére feltölteni. Töltse fel egy vázlatos területre, majd helyezze át az állományokat core_user::add_user_private_files paraméterrel.';
$string['processingstops'] = 'A feldolgozás itt véget ér. A többi adatot a rendszer figyelmen kívül hagyja.';
$string['protected_cc_not_supported'] = 'Védett tartalmak használatát a rendszer nem támogatja.';
$string['querystringcannotbeempty'] = 'A lekérdezés szövege nem lehet üres';
$string['redirecterrordetected'] = 'Nem támogatott átirányítás történt, a programfutás leállítva.';
$string['refoundto'] = 'Visszatéríthető {$a} számára';
$string['refoundtoorigi'] = 'Visszatérítve az eredeti összegig: {$a}';
$string['registrationdisabled'] = 'A portálon a regisztráció ki van kapcsolva';
$string['remotedownloaderror'] = 'Az összetevőt nem lehet szerverére letölteni, ellenőrizze a proxy beállításait. Ajánlatos a PHP cURL-bővítmény használata. A(z) <a href="{$a->url}">{$a->url}</a> állományt töltse le kézzel, másolja át szerverén a(z) "{$a->dest}" célkönyvtárba, és csomagolja ki ott.';
$string['remotedownloadnotallowed'] = 'Az összetevőket nem lehet szerverére letölteni(az allow_url_fopen ki van kapcsolva). A(z) <a href="{$a->url}">{$a->url}</a> állományt töltse le kézzel, másolja át szerverén a(z) "{$a->dest}" célkönyvtárba, és csomagolja ki ott.';
$string['reportnotavailable'] = 'Ez a jelentéstípus csak a portálkurzus számára érhető el';
$string['requirecorrectaccess'] = 'Érvénytelen URL vagy port';
$string['requireloginerror'] = 'A kurzus vagy a tevékenység nem érhető el.';
$string['restore_path_element_missingmethod'] = 'Hiányzik a(z) {$a} helyreállítási metódus. Ezt egy fejlesztő határozza meg.';
$string['restore_path_element_noobject'] = 'A(z) {$a} helyreállítási objektum nem objektum.';
$string['restorechecksumfailed'] = 'A folyamatban tárolt helyreállítási információval gondok vannak. Ellenőrizze a PHP memóriájának / az adatbázis  csomagjának a méreteit. A helyreállítás leállítva.';
$string['restrictedcontextexception'] = 'A külső függvény végrehajtása ellentétes a környezeti korlátozással.';
$string['restricteduser'] = 'Jelenlegi "$a" fiókjával ezt nem teheti meg.';
$string['reverseproxyabused'] = 'Fordított proxy be van kapcsolva, a szerver közvetlenül nem érhető el. <br />Értesítse a rendszergazdát.';
$string['rpcerror'] = 'MNET-kapcsolata sikertelen. Küldje el ezt a hibaüzenetet a rendszergazdának: {$a}.';
$string['scheduledbackupsdisabled'] = 'A szerver rendszergazdája kikapcsolta az ütemezett biztonsági mentést';
$string['secretalreadyused'] = 'A módosult jelszó megerősítési hivatkozását már használták, a jelszó nem módosult.';
$string['sectionnotexist'] = 'A szakasz nem létezik';
$string['sendmessage'] = 'Üzenet küldése';
$string['sendmessagesent'] = 'Köszönjük visszajelzését ezzel kapcsolatban:<br>{$a}';
$string['serverconnection'] = 'Hiba a szerverhez csatlakozás közben';
$string['servicedonotexist'] = 'A szolgáltatás nem létezik.';
$string['sessioncookiesdisable'] = 'A require_key_login() használata hibás – az eseménysütiket ki kell kapcsolni!';
$string['sessiondiskfull'] = 'A folyamat partíciója betelt. Jelenleg nem jelentkezhet be. Értesítse a szerver rendszergazdáját.';
$string['sessionerroruser'] = 'Ideje lejárt. Lépjen be újra.';
$string['sessionerroruser2'] = 'Belépését érintő szerverhiba történt. Kérjük, lépjen be újra vagy indítsa újra a böngészőt.';
$string['sessionexpired'] = 'A munkamenet lejárt';
$string['sessionhandlerproblem'] = 'Hibásan beállított folyamatkezelő';
$string['sessionipnomatch'] = 'Úgy tűnik, IP-száma az utolsó belépés óta megváltozott. Ez a biztonsági intézkedés megelőzi, hogy belépése alatt kifürkésszék az azonosítóját. A felhasználók általában nem kaphatnak ilyen üzenetet. Segítségért forduljon a portál rendszergazdájához.';
$string['sessionipnomatch2'] = 'IP-címe módosult első belépése óta. Ez a biztonsági megoldás megakadályozza, hogy behatolók megszerezzék adatait, miközben bejelentkezik a portálra. Akkor találkozhat ezzel a hibával, ha vezeték nélküli hálózatot használ vagy különféle hálózatok között barangol. Segítségért forduljon a portál rendszergazdájához.
Folytatáshoz az F5 megnyomásával frissítse az oldalt.';
$string['sessionwaiterr'] = 'Időtúllépés folyamatlezárásra várakozás közben.
Várjon, amíg aktuális kérései befejeződnek, és próbálja meg később.';
$string['shortnametaken'] = 'A rövid címet már egy másik kurzus  ({$a}) használja.';
$string['sitepolicynotagreed'] = 'A portál házirendje nincs egyeztetve: <a href="{$a}">Kattintson ide a portál házirendjének megnyitásához.</a>';
$string['socksnotsupported'] = 'A SOCKS5 proxy használatát a PHP4 nem támogatja';
$string['spellcheckernotconf'] = 'A helyesírás-ellenőrző nincs beállítva';
$string['sslonlyaccess'] = 'Biztonsági okokból csak https-csatlakozásra van mód.';
$string['statscatchupmode'] = 'A statisztika jelenleg készülőfélben van. Eddig {$a->daysdone} nap feldolgozására került sor és {$a->dayspending} nap van még hátra. Térjen vissza rövidesen!';
$string['statsdisable'] = 'A statisztika nincs bekapcsolva';
$string['statsnodata'] = 'A kurzus és az időtartam ezen párosításához nincsenek adatok.';
$string['storedfilecannotcreatefile'] = 'A helyi készletfájl nem hozható létre. Ellenőrizze a fő adatkönyvtárban az engedélyeket és a rendelkezésre álló lemezterületet.';
$string['storedfilecannotcreatefiledirs'] = 'Nem hozhatók létre a nyomtatáshoz helyi könyvtárak, ellenőrizze az adatok gyökérkönyvtárában az engedélyeket.';
$string['storedfilecannotread'] = 'Az állomány nem olvasható, mert vagy nem létezik, vagy gond van az engedélyekkel.';
$string['storedfilecannotreadfile'] = '\'{$a}\' állomány nem olvasható. Vagy nem létezik, vagy gond van az engedéllyel.';
$string['storedfilenotcreated'] = 'Nem hozható létre a(z) "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}" állomány.';
$string['storedfileproblem'] = 'Ismeretlen kivételhiba a helyi állományok kapcsán ({$a}).';
$string['tagdisabled'] = 'A címkék ki vannak kapcsolva!';
$string['tagnotfound'] = 'A megadott címke nem található az adatbázisban';
$string['targetdatabasenotempty'] = 'A céladatbázis nem üres. Biztonsági okokból az átvitel megszakítva.';
$string['textconditionsnotallowed'] = 'Szövegoszlopok feltételeinek összehasonlítása nem megengedett. Lekérdezésében használja az sql_compare_text() utasítást.';
$string['themenotinstall'] = 'A stílus nincs telepítve';
$string['tokengenerationfailed'] = 'Nem hozható létre új jel.';
$string['transactionvoid'] = 'Az ügylet nem érvényteleníthető, mert már érvénytelenítve van';
$string['unenrolerror'] = 'Hiba történt a személy kiiratkoztatása közben';
$string['unicodeupgradeerror'] = 'Adatbázisa nincs még unikódban, a Moodle ezen változata pedig nem képes azt unikódba áttenni. Először frissítsen a Moodle 1.7.x változatára és hajtsa végre az unikódba való átalakítást az adminisztrációs oldalon. Ezután átválthat a Moodle $a változatára.';
$string['unknowaction'] = 'Ismeretlen lépés!';
$string['unknowcategory'] = 'Ismeretlen kategória!';
$string['unknowcontext'] = 'Ismeretlen környezet ({$a}) a get_child_contexts esetén!';
$string['unknowformat'] = 'Ismeretlen forma ({$a})';
$string['unknownbackupexporterror'] = 'Ismeretlen hiba az adatok importálásra való előkészítése közben';
$string['unknownblockregion'] = 'Az oldalon a(z) {$a} blokkterület  nem ismerhető fel.';
$string['unknowncontext'] = 'Ismeretlen környezet.';
$string['unknowncourse'] = 'Ismeretlen "{$a}" nevű kurzus.';
$string['unknowncourseidnumber'] = 'Ismeretlen "{$a}" kurzus-azonosító';
$string['unknowncourserequest'] = 'Ismeretlen kurzuskérés.';
$string['unknowncoursesection'] = 'Ismeretlen kurzusszakasz "{$a}" kurzus esetén';
$string['unknownevent'] = 'Ismeretlen esemény';
$string['unknownfiletype'] = 'Ismeretlen szűrőtípus.';
$string['unknowngroup'] = 'Ismeretlen "{$a}" csoport';
$string['unknownhelp'] = 'Ismeretlen {$a} súgótéma';
$string['unknownjsinrequirejs'] = 'Nem található a JS {$a} könyvtár.';
$string['unknownmodulename'] = 'Ismeretlen modulnév az űrlaphoz.';
$string['unknownrole'] = 'Ismeretlen "{$a}" szerep';
$string['unknownsortcolumn'] = 'Ismeretlen {$a} leválogatási oszlop.';
$string['unknownuseraction'] = 'A felhasználó lépése nem értelmezhető.';
$string['unknownuserselector'] = 'Ismeretlen felhasználó-választó';
$string['unknoworder'] = 'Ismeretlen sorrend';
$string['unknowparamtype'] = 'Ismeretlen paramétertípus: {$a}.';
$string['unknowquestiontype'] = 'Nem támogatott {$a} kérdéstípus';
$string['unknowuploadaction'] = 'Hiba: ismeretlen feltöltési lépés ({$a})';
$string['unspecifycourseid'] = 'Kurzus-azonosítót, rövid nevet vagy azonosítószámot kell megadnia';
$string['unsupportedevent'] = 'Nem támogatott eseménytípus';
$string['unsupportedstate'] = 'Nem támogatott befejezési állapot.';
$string['unsupportedwebserver'] = 'A webszerver szoftverét {$a}) nem támogatjuk.';
$string['upgraderequires19'] = 'Hiba: szerverére a Moodle új változatát telepítették, az előző változatról való frissítést a rendszer nem támogatja.<br />Frissítsen a legújabb 1.9.x változatra. Az eredeti állományok újbóli telepítésével visszatérhet az előző változathoz is.';
$string['upgraderunning'] = 'A portál frissítése folyamatban, próbálkozzék később.';
$string['urlnotdefinerss'] = 'Az URL nincs megadva az RSS-hírhez';
$string['useradmineditadmin'] = 'Más rendszergazdák fiókjait csak rendszergazdák módosíthatják.';
$string['useradminodelete'] = 'Rendszergazdák fiókjai nem törölhetők.';
$string['userautherror'] = 'Ismeretlen hitelesítési segédprogram.';
$string['userauthunsupported'] = 'A hitelesítési segédprogram használata itt nem lehetséges.';
$string['useremailduplicate'] = 'Ismétlődő cím';
$string['usermustbemnet'] = 'Az MNET hozzáférés-vezérlési listához tartozó felhasználóknak távoli MNET-felhasználóknak kell lenni';
$string['usernamelowercase'] = 'A felhasználónév kisbetűs legyen.';
$string['usernotaddederror'] = 'A felhasználó hozzáadására nem került sor  - hiba.';
$string['usernotaddedregistered'] = 'A felhasználó nem lett hozzáadva - már regisztrálva van.';
$string['usernotavailable'] = 'Ezen felhasználó adatait Ön nem érheti el.';
$string['usernotdeletedadmin'] = 'A felhasználó nem lett törölve: rendszergazdák fiókjai nem törölhetők.';
$string['usernotdeleteddeleted'] = 'Ezt a felhasználót már törölték.';
$string['usernotdeletederror'] = 'A felhasználó nem lett törölve - hiba.';
$string['usernotdeletedmissing'] = 'A felhasználó nem lett törölve - nincs meg a felhasználónév.';
$string['usernotdeletedoff'] = 'A felhasználó nem lett törölve – a törlés nem engedélyezett.';
$string['usernotfullysetup'] = 'A felhasználó beállítása még nincs kész';
$string['usernotincourse'] = 'A felhasználó nem vette fel ezt a kurzust!';
$string['usernotrenamedadmin'] = 'Rendszergazda-fiókokat nem lehet átnevezni.';
$string['usernotrenamedexists'] = 'A felhasználó átnevezése elmaradt - az új felhasználónevet már használják.';
$string['usernotrenamedmissing'] = 'A felhasználó átnevezése elmaradt - a régi felhasználónév nem található.';
$string['usernotrenamedoff'] = 'A felhasználó átnevezése elmaradt – az átnevezés nem engedélyezett.';
$string['usernotupdatedadmin'] = 'Rendszergazda-fiókok nem frissíthetők.';
$string['usernotupdatederror'] = 'A felhasználó nem lett frissítve - hiba';
$string['usernotupdatednotexists'] = 'A felhasználó nem lett frissítve – nem létezik.';
$string['userquotalimit'] = 'Elérte állománykorlátját.';
$string['userselectortoomany'] = 'A user_selector-hoz több felhasználó tartozik, jóllehet, a multiselect értéke hamis.';
$string['verifyagedigitalconsentnotpossible'] = 'A hozzájárulás digitális korának ellenőrzése most nem lehetséges.';
$string['wrongcall'] = 'A programkód meghívása hibás';
$string['wrongcontextid'] = 'A környezetazonosító hibás volt  (nem található)';
$string['wrongdestpath'] = 'Hibás célútvonal.';
$string['wrongroleid'] = 'Hibás szerepazonosító';
$string['wrongsourcebase'] = 'Hibás forrás-URL.';
$string['wrongusernamepassword'] = 'Hibás felhasználó/jelszó';
$string['wrongzipfilename'] = 'Hibás a tömörített állomány neve.';
$string['wscouldnotcreateecoursenopermission'] = 'WS - A kurzus létrehozása nem sikerült. - Nincs hozzá engedély.';
$string['wwwrootmismatch'] = 'Hibás hozzáférés, a szerver csak "{$a}" címen keresztül érhető el.<br />Értesítse a rendszergazdát.';
$string['wwwrootslash'] = 'A $CFG->wwwroot hibája a config.php-ben, lezáró perjelet nem tartalmazhat.<br />Értesítse a rendszergazdát.';
$string['xmldberror'] = 'XMLDB-hiba!';
$string['youcannotdeletecategory'] = 'A(z) \'{$a}\' kategóriát nem törölheti, mert a tartalmat nem törölheti, és nem is helyezheti át.';
