<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'nl', version '3.10'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Acties voor de beoordeel-interface';
$string['actionsforpost'] = 'Acties voor bericht';
$string['activityoverview'] = 'Er zijn nieuwe forumberichten';
$string['addanewdiscussion'] = 'Voeg een nieuw discussieonderwerp toe';
$string['addanewquestion'] = 'Voeg een nieuwe vraag toe';
$string['addanewtopic'] = 'Voeg een nieuw onderwerp toe';
$string['addtofavourites'] = 'Markeer deze discussie als favoriet';
$string['advancedsearch'] = 'Uitgebreid zoeken';
$string['alldiscussions'] = 'Alle discussies';
$string['allforums'] = 'Alle forums';
$string['allowdiscussions'] = 'Mag een {$a} berichten posten?';
$string['allowsallsubscribe'] = 'In dit forum kan iedereen kiezen om e-mail er van te krijgen of niet';
$string['allowsdiscussions'] = 'In dit forum mag iedereen precies één discussie starten.';
$string['allsubscribe'] = 'Ik wil mail van alle forums';
$string['allunsubscribe'] = 'Ik wil van geen enkel forum mail';
$string['allusers'] = 'Alle gebruikers';
$string['alreadyfirstpost'] = 'Dit is al het eerste bericht in de discussie';
$string['anyfile'] = 'Een bestand';
$string['areaattachment'] = 'Bijlagen';
$string['areapost'] = 'Berichten';
$string['attachment'] = 'Bijlage';
$string['attachment_help'] = 'Je kunt optioneel één of meer bestanden als bijlage bij een forumbericht voegen. Als je een afbeelding toevoegt, dan zal die onder het bericht getoond worden.';
$string['attachmentname'] = 'Bijlage {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Je kunt bijlagen niet exporteren zonder post ID';
$string['attachments'] = 'Bijlagen';
$string['attachmentswordcount'] = 'Bijlagen en aantal woorden';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} privé antwoorden op {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} antwoordt op {$a->author}';
$string['availability'] = 'Beschikbaarheid';
$string['blockafter'] = 'Maximaal aantal berichten voor blokkeren';
$string['blockafter_help'] = 'Deze instelling specificeert het maximale aantal berichten dat een gebruiker kan posten in een zekere tijdsspanne. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben geen limiet.';
$string['blockperiod'] = 'Blokkeertijd';
$string['blockperiod_help'] = 'Leerlingen kunnen geblokkeerd worden voor het versturen van berichten als ze meer dan een bepaald aantal berichten sturen in een gegeven tijdslimiet. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben geen limiet.';
$string['blockperioddisabled'] = 'Niet blokkeren';
$string['blogforum'] = 'Standaardforum, getoond in blogstijl';
$string['bynameondate'] = 'door  {$a->name}  - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Volgstatus van forum voor gebruiker';
$string['calendardue'] = '{$a} moet klaar zijn';
$string['cancelreply'] = 'Annuleer antwoord';
$string['cannotadd'] = 'Kon de discussie niet toevoegen aan dit forum';
$string['cannotadddiscussion'] = 'Om discussies aan dit forum te kunnen toevoegen, moet je lid zijn van deze groep';
$string['cannotadddiscussionall'] = 'Je hebt het recht niet om een nieuw discussieonderwerp te starten voor alle deelnemers.';
$string['cannotadddiscussiongroup'] = 'Je kunt geen discussie maken omdat je geen lid bent van een groep.';
$string['cannotaddsubscriber'] = 'Kon gebruiker met ID {$a} niet inschrijven voor het ontvangen van e-mail van dit forum!';
$string['cannotaddteacherforumto'] = 'Kon het geconverteerde leraarsforum niet toevoegen aan sectie 0 van de cursus';
$string['cannotcreatediscussion'] = 'Kon geen nieuwe discussie starten';
$string['cannotcreateinstanceforteacher'] = 'Kon geen nieuwe cursusmodule maken voor het leraarsforum';
$string['cannotdeletediscussioninsinglediscussion'] = 'Je kunt het eerste bericht van een enkele discussie niet verwijderen';
$string['cannotdeletepost'] = 'Je kunt dit bericht niet verwijderen!';
$string['cannoteditposts'] = 'Je kunt een bericht van andere gebruikers niet wijzigen!';
$string['cannotexportforum'] = 'Je kunt dit forum niet exporteren';
$string['cannotfavourite'] = 'Sorry, maar je hebt niet de toestemming om discussies te starten.';
$string['cannotfinddiscussion'] = 'Kon die discussie in dit forum niet vinden';
$string['cannotfindfirstpost'] = 'Kon het eerste bericht van dit forum niet vinden';
$string['cannotfindorcreateforum'] = 'Kon geen mededelingenforum maken of vinden voor deze site';
$string['cannotfindparentpost'] = 'Kon top ouder van bericht {$a} niet vinden';
$string['cannotmovefromsingleforum'] = 'Kan de discussie van een eenvoudig enkele discussieforum niet verplaatsen';
$string['cannotmovenotvisible'] = 'Forum niet zichtbaar';
$string['cannotmovetonotexist'] = 'Je kunt dat forum niet verplaatsen - het bestaat niet!';
$string['cannotmovetonotfound'] = 'Doelforum niet gevonden in deze cursus';
$string['cannotmovetosingleforum'] = 'Kan discussie niet verplaatsen naar een één discussie forum';
$string['cannotpindiscussions'] = 'Sorry, je hebt geen toestemming om discussies te pinnen.';
$string['cannotpurgecachedrss'] = 'Kon de RSS-feeds in de cache voor de bron en/of bestemmingsforums niet verwijderen - controleer je bestandsrechten';
$string['cannotremovesubscriber'] = 'Kon gebruiker met ID {$a} niet uitschrijven voor het ontvangen van e-mail van dit forum!';
$string['cannotreply'] = 'Je kunt dit bericht niet beantwoorden';
$string['cannotsplit'] = 'Discussies van dit forum kunnen niet gesplitst worden';
$string['cannotsubscribe'] = 'Je moet lid van een groep zijn om e-mail van dit forum te kunnen ontvangen.';
$string['cannottrack'] = 'Kon het volgen van dit forum niet stoppen';
$string['cannotunsubscribe'] = 'Kon er niet voor zorgen dat je van dit forum geen mail meer ontvangt.';
$string['cannotupdatepost'] = 'Je kunt dit bericht niet updaten';
$string['cannotviewpostyet'] = 'Je kunt de vragen van andere leerlingen in deze discussie nog niet lezen, omdat je zelf nog niets gepost hebt';
$string['cannotviewusersposts'] = 'Deze gebruiker heeft geen berichten gepost die jij kunt zien';
$string['cleanreadtime'] = 'Markeer oude berichten als gelezen';
$string['clicktofavourite'] = 'Je hebt deze discussie niet als favoriet gemarkeerd. Klik om als favoriet te markeren.';
$string['clicktolockdiscussion'] = 'Klik om deze discussie te vergrendelen';
$string['clicktosubscribe'] = 'Je bent niet ingeschreven op deze discussie. Klik om in te schrijven.';
$string['clicktounfavourite'] = 'Jij hebt deze discussie als favoriet gemarkeerd. Klik om te verwijderen.';
$string['clicktounlockdiscussion'] = 'Klik om deze discussie te ontgrendelen';
$string['clicktounsubscribe'] = 'Je bent ingeschreven op deze discussie. Klik om uit te schrijven.';
$string['close'] = 'Sluiten';
$string['closegrader'] = 'Beoordeler sluiten';
$string['completiondiscussions'] = 'Leerling moet discussies starten:';
$string['completiondiscussionsdesc'] = 'Leerling moet minstens {$a} discussie(s) maken';
$string['completiondiscussionsgroup'] = 'Discussies vereist';
$string['completiondiscussionshelp'] = 'discussies vereist om te voltooien';
$string['completionposts'] = 'Leerling moet discussies starten of beantwoorden:';
$string['completionpostsdesc'] = 'Leerling moet minstens {$a} discussie(s) of antwoord(en) posten';
$string['completionpostsgroup'] = 'Berichten vereist';
$string['completionpostshelp'] = 'discussies of antwoorden vereist voor voltooien';
$string['completionreplies'] = 'Leerling moet antwoorden posten:';
$string['completionrepliesdesc'] = 'Leerling moet minstens {$a} antwoord(en) posten';
$string['completionrepliesgroup'] = 'Antwoorden vereist';
$string['completionreplieshelp'] = 'antwoorden vereist voor voltooien';
$string['configcleanreadtime'] = 'Het uur van de dag waarop oude berichten van de \'gelezen\'-tabel moeten verwijderd worden.';
$string['configdigestmailtime'] = 'Gebruikers die ervoor kiezen dat de e-mails hun als samenvatting toegezonden worden, zullen dagelijks een e-mail ontvangen. Deze instelling controleert op welk moment van de dag deze dagelijkse mail verzonden wordt (de mail wordt verstuurd door de cron die volgt op het uur dat hier gekozen wordt)';
$string['configdisplaymode'] = 'De standaardmanier voor het weergeven van discussies als er geen methode is ingesteld.';
$string['configenablerssfeeds'] = 'Met deze instelling kun je de mogelijkheid voor het maken van RSS-feeds inschakelen voor alle forums. Je zult wel nog voor elk forum afzonderlijk het maken van de RSS-feeds moeten  inschakelen.';
$string['configenabletimedposts'] = 'Zet op \'Ja\' als je een tijdvak wil tonen wanneer je een nieuwe discussie start.';
$string['configlongpost'] = 'Elk bericht dat langer is dan deze waarde (HTML-code niet inbegrepen) wordt als lang beschouwd.';
$string['configmanydiscussions'] = 'Maximale aantal discussies van een forum die per pagina getoond worden';
$string['configmaxattachments'] = 'Standaard maximale aantal bijlagen per bericht';
$string['configmaxbytes'] = 'Standaard maximale grootte voor alle forumbijlagen op deze site (afhankelijk van vaklimieten en andere lokale instellingen)';
$string['configoldpostdays'] = 'Aantal dagen waarna elk bericht als gelezen moet beschouwd worden.';
$string['configreplytouser'] = 'Wil je dat de e-mail van een bericht op het forum het e-mailadres van de verstuurder bevat, zodat de ontvangers eventueel ook persoonlijk kunnen antwoorden, eerder dan via het forum? Zelfs als je hier \'Ja\' instelt, kunnen gebruikers ervoor kiezen hun e-mailadres privé te houden via hun profielpagina';
$string['configrssarticlesdefault'] = 'Indien RSS-feeds zijn ingeschakeld, dan stelt deze instelling het aantal artikels in (discussies of berichten)';
$string['configrsstypedefault'] = 'Indien RSS-feeds zijn ingeschakeld, dan stelt deze instelling de standaard activiteit in.';
$string['configshortpost'] = 'Elk bericht dat korter is dan deze waarde (HTML-code niet inbegrepen) wordt als kort beschouwd.';
$string['configsubscriptiontype'] = 'Standaardinstellingen voor inschrijvingsmodus.';
$string['configtrackingtype'] = 'Standaardinstelling voor het opvolgen van lezen.';
$string['configtrackreadposts'] = 'Zet op \'ja\' als je gelezen/ongelezen wil bijhouden voor elke gebruiker.';
$string['configusermarksread'] = 'Indien \'ja\' moet de lezer de berichten manueel als gelezen markeren. Indien \'nee\' wordt het bericht als gelezen gemarkeerd wanneer het geopend werd.';
$string['confirmsubscribe'] = 'Wil je echt inschrijven op forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Wil je berichten ontvangen van discussie \'{$a->discussion}\' in forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Wil je echt uitschrijven van forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Wil je geen berichten meer ontvangen van discussie \'{$a->discussion}\' in forum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Door een onbekende fout was het niet mogelijk om je bericht toe te voegen .';
$string['couldnotdeletereplies'] = 'Helaas, dit kan niet worden verwijderd omdat er al op geantwoord is.';
$string['couldnotupdate'] = 'Kon je bericht niet bijwerken door een onbekende fout.';
$string['created'] = 'Gemaakt';
$string['crontask'] = 'Forum-mails en onderhoudstaken';
$string['cutoffdate'] = 'Afsluitdatum';
$string['cutoffdate_help'] = 'Indien ingesteld, accepteert het forum geen berichten na deze datum.';
$string['cutoffdatereached'] = 'Dit forum is gesloten omdat de afsluitdatum voorbij is. Je kunt hier niet langer posten.';
$string['cutoffdatevalidation'] = 'Afsluitdatum kan niet voor einddatum zijn.';
$string['delete'] = 'Verwijder';
$string['deleteddiscussion'] = 'De discussie is verwijderd';
$string['deletedpost'] = 'Het bericht  is verwijderd';
$string['deletedposts'] = 'Deze berichten werden verwijderd';
$string['deleteduser'] = 'Verwijderde gebruiker';
$string['deletesure'] = 'Weet je zeker dat je dit bericht wilt verwijderen?';
$string['deletesureplural'] = 'Weet je zeker dat je dit bericht en alle antwoorden erop wil verwijderen? ({$a} berichten)';
$string['digestmailheader'] = 'Dit is je dagelijkse samenvattende e-mail met de nieuwe berichten van de forums van {$a->sitename}. Als je jouw voorkeurinstellingen voor de e-maildienst van de forums wil wijzigen, ga dan naar {$a->userprefs}.';
$string['digestmailpost'] = 'Wijzig je voorkeuren voor de samenvattende e-mail van forums';
$string['digestmailpostlink'] = 'Wijzig je instellingen voor forumsamenvattingen: {$a}';
$string['digestmailprefs'] = 'Jouw gebruikersprofiel';
$string['digestmailsubject'] = 'Dagelijkse forumsamenvatting van {$a}';
$string['digestmailtime'] = 'Uur om e-mail met berichtenoverzicht te versturen';
$string['digestsentusers'] = 'E-mail met berichtenoverzicht met succes naar {$a} gebruikers gestuurd.';
$string['disallowsubscribe'] = 'Inschrijven niet toegelaten';
$string['disallowsubscribeteacher'] = 'Inschrijven niet toegelaten (behalve voor leraren)';
$string['disallowsubscription'] = 'Inschrijving';
$string['disallowsubscription_help'] = 'Dit forum is geconfigureerd zodat je niet kan inschrijven op discussies.';
$string['discussion'] = 'Discussie';
$string['discussionlistsortbycreatedasc'] = 'Sorteer op aanmaakdatum in oplopende volgorde.';
$string['discussionlistsortbycreateddesc'] = 'Sorteer op aanmaakdatum in aflopende volgorde';
$string['discussionlistsortbydiscussionasc'] = 'Sorteer op discussienaam in oplopende volgorde';
$string['discussionlistsortbydiscussiondesc'] = 'Sorteer op discussienaam in aflopende volgorde';
$string['discussionlistsortbygroupasc'] = 'Sorteer op groep in oplopende volgorde';
$string['discussionlistsortbygroupdesc'] = 'Sorteer op groep in aflopende volgorde';
$string['discussionlistsortbylastpostasc'] = 'Sorteer op aanmaakdatum van het laatste bericht in oplopende volgorde';
$string['discussionlistsortbylastpostdesc'] = 'Sorteer op aanmaakdatum van het laatste bericht in aflopende volgorde';
$string['discussionlistsortbyrepliesasc'] = 'Sorteer op het aantal antwoorden in oplopende volgorde';
$string['discussionlistsortbyrepliesdesc'] = 'Sorteer op het aantal antwoorden in aflopende volgorde';
$string['discussionlistsortbystarterasc'] = 'Sorteer op discussie startersnaam in oplopende volgorde';
$string['discussionlistsortbystarterdesc'] = 'Sorteer op discussie startnaam in aflopende volgorde';
$string['discussionlocked'] = 'Deze discussie is geblokkeerd, zodat u niet meer kan antwoorden.';
$string['discussionlockingdisabled'] = 'Discussies niet blokkeren';
$string['discussionlockingheader'] = 'Discussies blokkeren';
$string['discussionmoved'] = 'Deze discussie is verplaatst naar \'{$a}\'.';
$string['discussionmovedpost'] = 'Deze discussie is verplaatst naar <a href="{$a->discusshref}">deze plaats</a> in het forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Discussienaam';
$string['discussionnownotsubscribed'] = '{$a->name} zal GEEN melding ontvangen over nieuwe berichten in \'{$a->discussion}\' van \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} zal meldingen krijgen van nieuwe berichten in \'{$a->discussion}\' van \'{$a->forum}\'';
$string['discussionpin'] = 'Vastpinnen';
$string['discussionpinned'] = 'Vastgepind';
$string['discussionpinned_help'] = 'Vastgepinde discussies zullen bovenaan het forum verschijnen';
$string['discussions'] = 'Discussies';
$string['discussionsplit'] = 'Discussie is gesplitst';
$string['discussionsstartedby'] = 'Discussies die door {$a} zijn gestart';
$string['discussionsstartedbyrecent'] = 'Discussies die recentelijk door {$a} zijn gestart';
$string['discussionsstartedbyuserincourse'] = 'Discussies, gestart door {$a->fullname} in {$a->coursename}';
$string['discussionstartedby'] = 'Discussie gestart door {$a}';
$string['discussionsubscribed'] = 'Je bent nu geabonneerd op deze discussie.';
$string['discussionsubscribestart'] = 'Stuur me meldingen van nieuwe berichten in deze discussie';
$string['discussionsubscribestop'] = 'Ik wil geen meldingen over nieuwe berichten in deze discussie';
$string['discussionsubscription'] = 'Inschrijving discussie';
$string['discussionsubscription_help'] = 'Inschrijven op een discussie betekent dat je meldingen zult krijgen over nieuwe berichten in deze discussie';
$string['discussionunpin'] = 'Pin losmaken';
$string['discussionunsubscribed'] = 'Je bent nu afgemeld voor deze discussie.';
$string['discussthistopic'] = 'Draag bij aan de discussie';
$string['discusstopicname'] = 'Bespreek het onderwerp: {$a}';
$string['displayend'] = 'Toon einde';
$string['displayend_help'] = '<p>Je kunt kiezen of je forumbericht pas vanaf een bepaalde datum getoond wordt, tot een bepaalde datum getoond wordt of gedurende een bepaalde periode getoond wordt.</p>

<p>Deselecteer de gewenste schakelopties om een start en/of einddatum te kunnen kiezen.</p>

<p>Merk op dat gebruikers met beheerrechten de berichten ook kunnen zien voor en na de zichtbare periode.</p>';
$string['displayenddate'] = 'Toon einde: {$a}.';
$string['displaymode'] = 'Toon modus';
$string['displayperiod'] = 'Toon periode';
$string['displaystart'] = 'Toon start';
$string['displaystart_help'] = '<p>Je kunt kiezen of je forumbericht pas vanaf een bepaalde datum getoond wordt, tot een bepaalde datum getoond wordt of gedurende een bepaalde periode getoond wordt.</p>

<p>Deselecteer de gewenste schakelopties om een start en/of einddatum te kunnen kiezen.</p>

<p>Merk op dat gebruikers met beheerrechten de berichten ook kunnen zien voor en na de zichtbare periode.</p>';
$string['displaystartdate'] = 'Toon start: {$a}.';
$string['displaywordcount'] = 'Toon woorden tellen';
$string['displaywordcount_help'] = 'Deze instelling bepaalt of het aantal woorden voor elk bericht getoond moet worden of niet.';
$string['duedate'] = 'Uiterste inleverdatum';
$string['duedate_help'] = 'Dit is het moment waarvoor berichten op het forum verwacht worden. Hoewel deze datum in de kalender wordt weergegeven als de vervaldatum voor het forum, blijft het posten na deze datum nog steeds toegestaan. Stel een datum voor het afsluiten van het forum in om te voorkomen dat berichten na een bepaalde datum op het forum worden geplaatst.';
$string['duedatetodisplayincalendar'] = 'Vervaldatum om in devkalender te tonen';
$string['eachuserforum'] = 'Iedereen voegt één discussie toe';
$string['edit'] = 'Wijzig';
$string['editedby'] = 'Bewerkt door {$a->name} - oorspronkelijk bericht van {$a->date}';
$string['editedpostupdated'] = '{$a}\'s bericht is aangepast';
$string['editing'] = 'Wijzigen';
$string['emaildigestcompleteshort'] = 'Volledige berichten';
$string['emaildigestdefault'] = 'Standaard ({$a})';
$string['emaildigestoffshort'] = 'Geen berichtenoverzicht';
$string['emaildigestsubjectsshort'] = 'Enkel onderwerpen';
$string['emaildigesttype'] = 'Opties berichtenoverzicht';
$string['emaildigesttype_help'] = 'Het type melding dat je zult krijgen voor elk forum.

* Standaard - volg de instelling voor samenvattende mail in je gebruikersprofiel. Als je je profiel aanpast, zal dat hier ook wijzigen;
* Geen samenvattende e-mail - je zult één e-mail krijgen per forumbericht;
* Samenvattende e-mail - volledige berichten - je krijgt één samenvattende e-mail per dag met daarin de volledige inhoud van elk forumbericht;
* Samenvattende e-mail - enkel onderwerpen - je krijgt één samenvattende e-mail per dag met daarin enkel het onderwerp van elk forumbericht.';
$string['emptymessage'] = 'Er was iets mis met je bericht. Misschien heb je het leeg gelaten of was de bijlage te groot. Je wijzigingen zijn NIET bewaard.';
$string['errorcannotlock'] = 'Je bent niet gemachtigd om discussies te sluiten.';
$string['erroremptymessage'] = 'Bericht kan niet leeg zijn';
$string['erroremptysubject'] = 'Onderwerp kan niet leeg zijn';
$string['errorenrolmentrequired'] = 'Je moet aangemeld zijn in deze cursus om de inhoud te zien';
$string['errorwhiledelete'] = 'Er is een fout opgetreden bij het verwijderen van een record';
$string['eventassessableuploaded'] = 'Er is inhoud gepost';
$string['eventcoursesearched'] = 'Cursus doorzocht';
$string['eventdiscussioncreated'] = 'Discussie gemaakt';
$string['eventdiscussiondeleted'] = 'Discussie verwijderd';
$string['eventdiscussionmoved'] = 'Discussie verplaatst';
$string['eventdiscussionpinned'] = 'Discussie vastgepind';
$string['eventdiscussionsubscriptioncreated'] = 'Ingeschreven op de discussie';
$string['eventdiscussionsubscriptiondeleted'] = 'Inschrijving op de discussie verwijderd';
$string['eventdiscussionunpinned'] = 'Discussie pin losgemaakt';
$string['eventdiscussionupdated'] = 'Discussie aangepast';
$string['eventdiscussionviewed'] = 'Discussie bekeken';
$string['eventpostcreated'] = 'Bericht gemaakt';
$string['eventpostdeleted'] = 'Bericht verwijderd';
$string['eventpostupdated'] = 'Bericht aangepast';
$string['eventreadtrackingdisabled'] = 'Opvolgen uitgeschakeld';
$string['eventreadtrackingenabled'] = 'Opvolgen ingeschakeld';
$string['eventsubscribersviewed'] = 'Geabonneerden bekeken';
$string['eventsubscriptioncreated'] = 'Abonnement gemaakt';
$string['eventsubscriptiondeleted'] = 'Abonnement verwijderd';
$string['eventuserreportviewed'] = 'Gebruikersrapport bekeken';
$string['everyonecanchoose'] = 'Iedereen kan kiezen om al dan niet e-mail van dit forum te ontvangen';
$string['everyonecannowchoose'] = 'Iedereen kan er voor kiezen om e-mail van dit forum te ontvangen';
$string['everyoneisnowsubscribed'] = 'Iedereen ontvangt nu e-mail van dit forum';
$string['everyoneissubscribed'] = 'Iedereen ontvangt e-mail van dit forum';
$string['existingsubscribers'] = 'Krijgen al e-mail van dit forum';
$string['export'] = 'Exporteren';
$string['exportattachmentname'] = 'Bijlage {$a} exporteren naar portfolio';
$string['exportdiscussion'] = 'Exporteer hele discussie naar portfolio';
$string['exporthumandates'] = 'Leesbare datums';
$string['exporthumandates_help'] = 'Selecteer deze optie als je wil dat datums geëxporteerd worden in een door mensen leesbaar formaat of als unix timestamp (aantal seconden sinds 1970)';
$string['exportoptions'] = 'Exporteer opties';
$string['exportstriphtml'] = 'Verwijder HTML';
$string['exportstriphtml_help'] = 'Selecteer deze optie als je wil dat HTML-tags zoals p en br verwijderd worden uit het forum-bericht.';
$string['favourites'] = 'Favoriet';
$string['favouriteupdated'] = 'Uw favoriet-optie is bijgewerkt.';
$string['firstpost'] = 'Eerste bericht';
$string['forcedreadtracking'] = 'Sta \'verplicht forum volgen\' toe';
$string['forcedreadtracking_desc'] = 'Maakt het mogelijk om forums in te stellen op verplicht lezen opvolgen. Dat zal resulteren in verminderde performantie voor sommige gebruikers, vooral dan in cursussen met veel forums en veel berichten. Wanneer je dit uitschakelt, zal elk forum dat voorheen op verplicht stond als optioneel behandeld worden.';
$string['forcesubscribed'] = 'Iedereen krijgt verplicht e-mail van dit forum';
$string['forcesubscribed_help'] = 'Dit forum is ingesteld zodat je niet kan uitschrijven van discussies';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Voeg een nieuw forum toe';
$string['forum:addnews'] = 'Voeg mededelingen toe';
$string['forum:addquestion'] = 'Voeg vraag toe';
$string['forum:allowforcesubscribe'] = 'Inschrijven op forum verplichten toestaan';
$string['forum:canoverridecutoff'] = 'Berichten in forums plaatsen na de sluitingsdatum';
$string['forum:canoverridediscussionlock'] = 'Antwoorden op gesloten discussies';
$string['forum:canposttomygroups'] = 'Een bericht sturen naar alle groepen waar je toegang toe hebt';
$string['forum:cantogglefavourite'] = 'Markeer discussies als favoriet';
$string['forum:createattachment'] = 'Bijlage toevoegen';
$string['forum:deleteanypost'] = 'Gelijk welk bericht verwijderen (altijd)';
$string['forum:deleteownpost'] = 'Eigen berichten verwijderen (binnen bepaalde tijd)';
$string['forum:editanypost'] = 'Gelijk welk bericht bewerken';
$string['forum:exportdiscussion'] = 'Exporteer de hele discussie';
$string['forum:exportforum'] = 'Forum exporteren';
$string['forum:exportownpost'] = 'Exporteer je eigen bericht';
$string['forum:exportpost'] = 'Exporteer bericht';
$string['forum:grade'] = 'Beoordeel forum';
$string['forum:managesubscriptions'] = 'Beheer abonnementen';
$string['forum:movediscussions'] = 'Discussies verplaatsen';
$string['forum:pindiscussions'] = 'Discussies vastpinnen';
$string['forum:postprivatereply'] = 'Beantwoord privé aan berichten';
$string['forum:postwithoutthrottling'] = 'Vrijgesteld van beperkingen om te posten';
$string['forum:rate'] = 'Berichten beoordelen';
$string['forum:readprivatereplies'] = 'Bekijk privé-antwoorden';
$string['forum:replynews'] = 'Beantwoord mededelingen';
$string['forum:replypost'] = 'Berichten beantwoorden';
$string['forum:splitdiscussions'] = 'Discussies splitsen';
$string['forum:startdiscussion'] = 'Nieuwe discussies starten';
$string['forum:viewallratings'] = 'Bekijk de ruwe gegevens van de beoordelingen.';
$string['forum:viewanyrating'] = 'Bekijk alle totaalbeoordelingen';
$string['forum:viewdiscussion'] = 'Discussies bekijken';
$string['forum:viewhiddentimedposts'] = 'Verborgen berichten bekijken';
$string['forum:viewqandawithoutposting'] = 'Altijd Vraag en Antwoord berichten bekijken';
$string['forum:viewrating'] = 'Bekijk jouw algemene beoordeling';
$string['forum:viewsubscribers'] = 'Bekijk wie e-mail ontvangt';
$string['forumauthorhidden'] = 'Auteur (verborgen)';
$string['forumblockingalmosttoomanyposts'] = 'Je nadert de berichtenlimiet. Je hebt {$a->numposts} berichten in de afgelopen {$a->blockperiod} gepost en de limiet is {$a->blockafter} berichten.';
$string['forumbodydeleted'] = 'De inhoud van dit forumbericht is verwijderd en kan niet meer getoond worden.';
$string['forumbodyhidden'] = 'Dit bericht is nu verborgen, waarschijnlijk omdat  je hebt zelf nog niets gepost hebt in deze discussie en de notificatie van je bericht nog niet verzonden is. Een andere mogelijkheid is dat de huidige tijd niet in de periode valt die ingesteld is om dit bericht te tonen.';
$string['forumgrader'] = 'Forumbeoordelaar';
$string['forumgradingnavigation'] = 'Forum beoordelen navigatie';
$string['forumgradingpanel'] = 'Forum beoordelingspaneel';
$string['forumintro'] = 'Beschrijving';
$string['forumname'] = 'Naam van het forum';
$string['forumposts'] = 'Forumberichten';
$string['forums'] = 'Forums';
$string['forumsubjectdeleted'] = 'Dit forumbericht is verwijderd';
$string['forumsubjecthidden'] = 'Onderwerp (verborgen)';
$string['forumtracked'] = 'Volgen ongelezen post ingeschakeld';
$string['forumtrackednot'] = 'Volgen ongelezen post uitgeschakeld';
$string['forumtype'] = 'Soort forum';
$string['forumtype_help'] = 'Er zijn 5 forumtypes

* Eén eenvoudige discussie - Eén enkel discussie-onderwerp waarop iedereen kan antwoorden (kan niet gebruikt worden met gescheiden groepen)
* Iedereen voegt één discussie toe - Elke leerling kan juist één nieuw discussieonderwerp posten, waarop iedereen dan kan antwoorden
* Vraag- en antwoordforum - Leerlingen moeten eerst hun bericht posten voor ze de berichten van anderen kunnen zien
* Standaardforum getoond in blog-stijl - een open forum waar iedereen een nieuwe discussie kan starten en waar de onderwerpen getoond worden op één pagina met \'Discussieer over dit onderwerp\' -links
* Standaardforum voor algemeen gebruik - Een open forum waar iedereen op elk moment een nieuwe discussie kan starten';
$string['generalforum'] = 'Standaardforum voor algemeen gebruik';
$string['generalforums'] = 'Algemene forums';
$string['grade_forum_header'] = 'Volledig forum beoordelen';
$string['grade_forum_name'] = 'Hele forum';
$string['grade_forum_title'] = 'Cijfer';
$string['grade_rating_name'] = 'Beoordeling';
$string['graded'] = 'Beoordeeld';
$string['gradedby'] = 'Beoordeeld door';
$string['gradeforrating'] = 'Cijfer voor beoordeling: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Cijfer voor beoordeling verborgen';
$string['gradeforwholeforum'] = 'Cijfer voor forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Cijfer voor forum verborgen';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = 'Beoordeling voor {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Volledige forumbeoordeling voor {$a->name}';
$string['grades:gradesavedfor'] = 'Cijfer bewaard voor  {$a->fullname}';
$string['grades:gradesavefailed'] = 'Kon cijfer voor {$a->fullname} niet bewaren: {$a->error}';
$string['gradeusers'] = 'Beoordeel gebruikers';
$string['grading'] = 'Beoordelen';
$string['gradingstatus'] = 'Beoordelingsstatus:';
$string['hiddenforumpost'] = 'Verborgen forumbericht';
$string['hidegraderpanel'] = 'Verberg beoordelingspaneel';
$string['hidepreviousrepliescount'] = 'Verberg eerdere antwoorden ({$a})';
$string['hideusersearch'] = 'Verberg gebruiker zoeken';
$string['indexoutoftotal'] = '{$a->index} van {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de door de leerling bereikte cognitieve diepte in een Forum activiteit.';
$string['indicator:cognitivedepthdef'] = 'Forum cognitief';
$string['indicator:cognitivedepthdef_help'] = 'De deelnemer heeft dit percentage van de cognitieve betrokkenheid van de forumactiviteiten tijdens dit analyse-interval bereikt (Niveaus = Geen weergave, Bekijken, Verzenden, Feedback bekijken, Reageren op feedback, Opnieuw verzenden na het bekijken van feedback)';
$string['indicator:socialbreadth'] = 'Forum sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de door de leerling behaalde sociale breedte in een Forum activiteit.';
$string['indicator:socialbreadthdef'] = 'Forum sociaal';
$string['indicator:socialbreadthdef_help'] = 'De deelnemer heeft dit percentage van de sociale betrokkenheid van de forumactiviteiten tijdens dit analyse-interval bereikt (Niveaus = geen deelname, alleen deelnemer, deelnemer met anderen)';
$string['inforum'] = 'in {$a}';
$string['inpagereplysubject'] = 'Re: {$a}';
$string['inreplyto'] = 'Als antwoord op {$a}';
$string['introblog'] = 'De berichten in dit forum zijn automatisch naar hier gekopieerd van blogs van gebruikers in deze cursus omdat deze blogs niet langer beschikbaar zijn';
$string['intronews'] = 'Algemeen nieuws en aankondigingen';
$string['introsocial'] = 'Een open forum om te chatten over wat je maar wilt';
$string['introteacher'] = 'Een forum alleen bestemd voor discussies en aantekeningen van leraren';
$string['invalidaccess'] = 'Deze pagina is niet correct opgevraagd';
$string['invaliddigestsetting'] = 'Er is een ongeldige voorkeur voor berichtenoverzicht opgegeven';
$string['invaliddiscussionid'] = 'Discussie ID was fout of bestaat niet meer';
$string['invalidforcesubscribe'] = 'Ongeldige inschrijving verplicht modus';
$string['invalidforumid'] = 'Forum ID was fout';
$string['invalidparentpostid'] = 'Ouder bericht ID was fout';
$string['invalidpostid'] = 'Post ID {$a} was fout';
$string['lastpost'] = 'Laatste bericht';
$string['learningforums'] = 'Leerforums';
$string['lockdiscussion'] = 'Vergrendel deze discussie';
$string['lockdiscussionafter'] = 'Blokkeer discussies na een periode zonder activiteit';
$string['lockdiscussionafter_help'] = 'Discussies kunnen automatisch worden geblokkeerd nadat een bepaalde tijd is verstreken sinds het laatste antwoord.
Gebruikers met de mogelijkheid om te antwoorden op gesloten discussies kunnen een discussie ontgrendelen door een antwoord te plaatsen.';
$string['locked'] = 'Vergrendeld';
$string['lockupdated'] = 'De vergrendelingsoptie is bijgewerkt.';
$string['longpost'] = 'Lang bericht';
$string['mailnow'] = 'Verstuur meldingen over dit forumbericht zonder vertraging voor bewerken';
$string['managesubscriptionsoff'] = 'Beëindig het beheren van inschrijvingen';
$string['managesubscriptionson'] = 'Beheer abonnementen';
$string['manydiscussions'] = 'Discussies per pagina';
$string['markalldread'] = 'Markeer alle berichten in deze discussie als gelezen';
$string['markallread'] = 'Markeer alle berichten in dit forum als gelezen';
$string['markasread'] = 'Markeer als gelezen';
$string['markasreadonnotification'] = 'Wanneer forumberichten verstuurd worden';
$string['markasreadonnotification_help'] = 'Wanneer je een melding krijgt van een forumbericht kun je er voor kiezen om dit bericht als gelezen te markeren.';
$string['markasreadonnotificationno'] = 'Het bericht niet als gelezen markeren';
$string['markasreadonnotificationyes'] = 'Het bericht als gelezen markeren';
$string['markread'] = 'Markeer als gelezen';
$string['markreadbutton'] = 'Markeer als<br />gelezen';
$string['markunread'] = 'Markeer als ongelezen';
$string['markunreadbutton'] = 'Markeer als<br />ongelezen';
$string['maxattachments'] = 'Maximale aantal bijlagen';
$string['maxattachments_help'] = 'Deze instelling bepaalt het maximale aantal bestanden dat als bijlage bij een forumbericht mag gevoegd worden.';
$string['maxattachmentsize'] = 'Maximale grootte van bijlagen';
$string['maxattachmentsize_help'] = 'Deze instelling bepaalt de maximale grootte van bestanden die als bijlage bij een forumbericht gevoegd kunnen worden.';
$string['maxtimehaspassed'] = 'Helaas is de maximale tijd voor het wijzigen van dit bericht ({$a}) verstreken!';
$string['message'] = 'Bericht';
$string['messageinboundattachmentdisallowed'] = 'Kon je antwoord niet posten, omdat er een bijlage in zit en het forum staat geen bijlages toe.';
$string['messageinboundfilecountexceeded'] = 'Kon je antwoord niet posten omdat er meer dan het maximale aantal bijlages voor dit forum bevat  {$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Kon je antwoord niet posten omdat de grootte van de bijlage  ({$a->filesize}) groter is dan de maximale grootte die toegestaan is in het forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Kon je antwoord niet posten omdat het forum niet beschikbaar is.';
$string['messageinboundnopostforum'] = 'Kon je antwoord niet posten omdat je geen rechten hebt om de posten in het forum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Kon je antwoord niet posten omdat je het maximale aantal berichten voor dit forum overschreden hebt.';
$string['messageprovider:digests'] = 'Ingeschreven op berichtenoverzicht voor forum';
$string['messageprovider:posts'] = 'Ingeschreven op forum voor berichten';
$string['missingsearchterms'] = 'Volgende zoektermen komen alleen in de HTML-opmaak van deze boodschap voor:';
$string['modeflatnewestfirst'] = 'Laat de antwoorden in één lijst zien, met de nieuwste eerst';
$string['modeflatoldestfirst'] = 'Laat de antwoorden in één lijst zien, met de oudste eerst';
$string['modenested'] = 'Laat de antwoorden \'genest\' zien';
$string['modenestedv2'] = 'Antwoorden weergeven in experimentele geneste vorm';
$string['modethreaded'] = 'Laat de antwoorden in hun \'draden\' zien';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Met de activiteit Forum kunnen deelnemers asynchrone discussies voeren over een lange tijdsperiode.

Er zijn verschillende forumtypes om uit te kiezen, zoals standaard forum, waarbij iedereen een nieuwe discussie kan starten, een forum waarbij elke leerling slechts één discussie kan starten, of een vraag en antwoordforum, waar leerlingen eerst moeten posten, voor ze de berichten van andere leerlingen kunnen zien. Een leraar kan toestaan bestanden als bijlage bij een bericht te laten voegen. Als dit afbeeldingen zijn, worden deze getoond in het bericht.

Deelnemers kunnen zich inschrijven op een forum, zodat ze meldingen krijgen van nieuwe forumberichten. Een leraar kan die inschrijvingsmodus op optioneel, verplicht of automatisch zetten of het inschrijven volledig blokkeren. Indien nodig kunnen leerlingen geblokkeerd worden als ze meer dan een bepaald aantal berichten posten per tijdsperiode; dit kan verhinderen dat sommigen de discussie domineren.

Forumberichten kunnen beoordeeld worden door leraren of door leerlingen (peer-evaluatie). De beoordelingen kunnen samengeteld worden om een eindbeoordeling voor het forum te verkrijgen, die dan in de cijferlijst opgenomen wordt.

Fora kunnen voor veel zaken gebruikt worden, zoals

* een sociale ruimte waar leerlingen elkaar kunnen leren kennen
* voor cursusmededelingen (door gebruik te maken van een nieuwsforum met verplicht ontvangen van meldingen)
* om de inhoud van de cursus of leesmateriaal te bespreken
* om online verder te gaan over een onderwerp dat aan bod kwam tijdens een klasgebeuren
* voor discussies tussen leraren (in een verborgen forum)
* als helpcentrum waar leraren en leerlingen advies kunnen geven
* als één-op-één ondersteuningszone voor een privé leraar-leerling communicatie (door een forum met groepen te gebruiken met 1 leerling per groep)
* voor uitbreidingsoefeningen, met uitdagende denkoefeningen waar leerlingen kunnen over nadenken, discussiëren en oplossingen voorstellen.';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'meer';
$string['movedmarker'] = '(Verplaatst)';
$string['movethisdiscussionlabel'] = 'Verplaats de huidige discussie naar het opgegeven forum';
$string['movethisdiscussionto'] = 'Verplaats deze discussie naar ...';
$string['mustprovidediscussionorpost'] = 'Je moet ofwel een discussie ID of een bericht ID geven om te exporteren';
$string['myprofileotherdis'] = 'Forumdiscussies';
$string['myprofileowndis'] = 'Mijn forumdiscussies';
$string['myprofileownpost'] = 'Mijn forumberichten';
$string['namenews'] = 'Mededelingen';
$string['namenews_help'] = 'Het forum "Mededelingen" is een speciaal forum dat automatisch aangemaakt wordt in elke cursus en op de startpagina van de site. Het is een plaats voor algemene mededelingen. Je kunt er zo maar één per cursus hebben. Enkel leraren en beheerders kunnen posten in dit forum. Leerlingen kunnen er niet op antwoorden. Het "Laatste mededelingen"-blok toont de recente mededelingen.';
$string['namesocial'] = 'Sociaal forum';
$string['nameteacher'] = 'Forum voor leraren';
$string['newforumposts'] = 'Nieuwe forumberichten';
$string['nextdiscussiona'] = 'Volgende discussie: {$a}';
$string['nextuser'] = 'Bewaar wijzigingen en ga naar de volgende gebruiker';
$string['noattachments'] = 'Er zijn geen bijlagen bij dit bericht';
$string['nodiscussions'] = 'Er zijn nog geen discussies in dit forum';
$string['nodiscussionsstartedby'] = '{$a} heeft nog geen discussies gestart';
$string['nodiscussionsstartedbyyou'] = 'Je hebt nog geen discussies gestart';
$string['noguestpost'] = 'Sorry, gasten mogen geen berichten posten';
$string['noguestsubscribe'] = 'Sorry, maar gasten mogen niet inschrijven.';
$string['noguesttracking'] = 'Sorry, gasten kunnen de instellingen voor het volgen van forumberichten niet wijzigen.';
$string['nomorepostscontaining'] = 'Er zijn geen berichten met \'{$a}\' meer gevonden';
$string['nonews'] = 'Er zijn nog geen mededelingen.';
$string['noonecansubscribenow'] = 'Inschrijven is nu niet toegelaten';
$string['nopermissiontosubscribe'] = 'Je hebt het recht niet te zien wie e-mail van dit forum ontvangt';
$string['nopermissiontoview'] = 'Je mag dit bericht niet zien';
$string['nopostforum'] = 'Sorry, je mag geen berichten posten in dit forum';
$string['noposts'] = 'Geen berichten';
$string['nopostsmadebyuser'] = '{$a} heeft geen berichten gepost';
$string['nopostsmadebyyou'] = 'Je hebt geen berichten gepost';
$string['noquestions'] = 'Er zijn nog geen vragen in dit forum';
$string['nosubscribers'] = 'Niemand krijgt e-mail van dit forum';
$string['notexists'] = 'Discussie bestaat niet meer';
$string['notgraded'] = 'Niet beoordeeld';
$string['nothingnew'] = 'Niets nieuw voor {$a}';
$string['notingroup'] = 'Sorry, je moet bij een groep horen om dit forum te kunnen zien.';
$string['notinstalled'] = 'De forummodule is niet geïnstalleerd';
$string['notlocked'] = 'Vergrendel';
$string['notpartofdiscussion'] = 'Dit bericht is geen deel van een discussie!';
$string['notrackforum'] = 'Schakel volgen van ongelezen berichten uit';
$string['notsubscribed'] = 'Inschrijven';
$string['nousersmatch'] = 'Geen gebruiker(s) gevonden voor opgegeven criteria';
$string['noviewdiscussionspermission'] = 'Je mag de discussies in dit forum niet zien';
$string['nowallsubscribed'] = 'Je krijgt e-mail van alle forums in {$a}.';
$string['nowallunsubscribed'] = 'Je krijgt van geen enkel forum in {$a} e-mail.';
$string['nowgradinguser'] = 'Nu {$a} beoordelen';
$string['nownotsubscribed'] = '{$a->name} zal GEEN meldingen over nieuwe forumberichten in  \'{$a->forum}\' ontvangen';
$string['nownottracking'] = '{$a->name} volgt niet langer het forum \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} zal meldingen ontvangen over nieuwe forumberichtingen in \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} volgt nu het forum \'{$a->forum}\'.';
$string['numberofreplies'] = 'Aantal antwoorden: {$a}';
$string['numposts'] = '{$a} berichten';
$string['olderdiscussions'] = 'Oudere discussies';
$string['oldertopics'] = 'Oudere onderwerpen';
$string['oldpostdays'] = 'Gelezen na aantal dagen';
$string['overviewnumpostssince'] = '{$a} berichten sinds je laatste login';
$string['overviewnumunread'] = '{$a} in totaal niet gelezen';
$string['page-mod-forum-discuss'] = 'Forum module discussiedraad pagina';
$string['page-mod-forum-view'] = 'Forummodule hoofdpagina';
$string['page-mod-forum-x'] = 'Elke forummodule pagina';
$string['parent'] = 'Toon discussiestart';
$string['parentofthispost'] = 'Discussiestart van dit bericht';
$string['permalink'] = 'Permanente link';
$string['permanentlinktoparentpost'] = 'Permanente link naar het bovenliggende bericht';
$string['permanentlinktopost'] = 'Permanente link naar dit bericht';
$string['pindiscussion'] = 'Discussie pinnen';
$string['pinupdated'] = 'De pin-optie is aangepast.';
$string['pluginadministration'] = 'Forumbeheer';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Je bericht is gepost.</p><p> Je hebt {$a} de tijd om dit bericht te wijzigen als je nog iets wilt veranderen.</p>';
$string['postaddedsuccess'] = 'Je bericht werd toegevoegd.';
$string['postaddedtimeleft'] = 'Je hebt {$a} om het te bewerken als je nog wijzigingen wil aanbrengen.';
$string['postbymailsuccess'] = 'Je antwoord  "{$a->subject}" is gepost op {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Je antwoord <a href="{$a->discussionurl}">{$a->subject}</a> is gepost.';
$string['postbyuser'] = '{$a->post} door {$a->user}';
$string['postincontext'] = 'Bekijk dit bericht in zijn context';
$string['postisprivatereply'] = 'Dit is een privé-antwoord. Het is niet zichtbaar voor andere deelnemers.';
$string['postmailinfolink'] = 'Dit is een kopie van een bericht, gepost in {$a->coursename}.

Klik op volgende link om te antwoorden: {$a->replylink}';
$string['postmailnow'] = '<p>Dit bericht zal onmiddellijk verstuurd worden naar iedereen die e-mail van dit forum wil.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Vooral Separate Knowing';
$string['postrating2'] = 'Separate en Connected Knowing';
$string['postrating3'] = 'Vooral Connected Knowing';
$string['posts'] = 'Berichten';
$string['postsfrom'] = 'Berichten van';
$string['postsmadebyuser'] = 'Berichten gepost door {$a}';
$string['postsmadebyuserincourse'] = 'Berichten gepost door {$a->fullname} in {$a->coursename}';
$string['poststo'] = 'Berichten naar';
$string['posttoforum'] = 'Plaats op het forum';
$string['posttomygroups'] = 'Stuur een kopie naar alle groepen';
$string['posttomygroups_help'] = 'Stuurt een kopie van dit bericht naar alle groepen waar je toegang toe hebt. Deelnemers in groepen waar je geen toegang toe hebt, zullen dit bericht niet zien.';
$string['postupdated'] = 'Je bericht is bijgewerkt';
$string['potentialsubscribers'] = 'Deelnemers van de cursus die nog geen e-mail van dit forum krijgen';
$string['prevdiscussiona'] = 'Vorige discussie: {$a}';
$string['previoususer'] = 'Bewaar wijzigingen en ga naar de vorige gebruiker';
$string['privacy:digesttypenone'] = 'We hebben geen gegevens over het gekozen berichtenoverzichtstype voor dit forum.';
$string['privacy:digesttypepreference'] = 'Je hebt ervoor gekozen om het volgende berichtenoverzicht voor forumberichten te ontvangen: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'U hebt de volgende abonnementvoorkeur voor dit forum gekozen: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Het forum maakt gebruik van het rating-subsysteem om de beoordeling van berichten te ondersteunen.';
$string['privacy:metadata:core_tag'] = 'Het forum maakt gebruik van het tag-subsysteem om het taggen van berichten te ondersteunen.';
$string['privacy:metadata:forum_digests'] = 'Informatie over de voorkeur voor berichtenoverzicht voor elk forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Het forum waarop geabonneerd is.';
$string['privacy:metadata:forum_digests:maildigest'] = 'De voorkeur voor berichtenoverzicht';
$string['privacy:metadata:forum_digests:userid'] = 'De ID van de gebruiker met de voorkeur voor berichtenoverzicht';
$string['privacy:metadata:forum_discussion_subs'] = 'Informatie over de abonnementen op individuele forumdiscussies';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID van de discussie waarop is geabonneerd.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'De starttijd van het abonnement.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'De ID van de gebruiker met het discussieabonnement.';
$string['privacy:metadata:forum_discussions'] = 'Informatie over de individuele forumdiscussies die een gebruiker heeft gemaakt';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - wat slaat dit veld op';
$string['privacy:metadata:forum_discussions:name'] = 'De naam van de discussie, zoals gekozen door de auteur.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Het tijdstip waarop de discussie laatst gewijzigd werd.';
$string['privacy:metadata:forum_discussions:userid'] = 'De ID van de gebruiker die de discussie heeft gemaakt';
$string['privacy:metadata:forum_discussions:usermodified'] = 'De ID van de gebruiker die de discussie voor het laatst op een of andere manier heeft gewijzigd.';
$string['privacy:metadata:forum_grades'] = 'Beoordelingsgegevens voor het forum';
$string['privacy:metadata:forum_grades:forum'] = 'Het beoordeelde forum';
$string['privacy:metadata:forum_grades:grade'] = 'Toegekende beoordeling';
$string['privacy:metadata:forum_grades:userid'] = 'De beoordeelde gebruiker';
$string['privacy:metadata:forum_posts'] = 'Informatie over de voorkeuren voor berichtenoverzicht voor elk forum.';
$string['privacy:metadata:forum_posts:created'] = 'De tijd dat het bericht is gemaakt.';
$string['privacy:metadata:forum_posts:discussion'] = 'De discussie waar het bericht in zit.';
$string['privacy:metadata:forum_posts:message'] = 'Het bericht van het forumbericht.';
$string['privacy:metadata:forum_posts:modified'] = 'Het tijdstip waarop het bericht voor het laatst is gewijzigd.';
$string['privacy:metadata:forum_posts:parent'] = 'Het bovenliggende bericht waarop is gereageerd.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'De ID van de gebruiker naar wie dit antwoord is verzonden.';
$string['privacy:metadata:forum_posts:subject'] = 'Het onderwerp van de forumbericht.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Het bericht van het forumbericht.';
$string['privacy:metadata:forum_posts:userid'] = 'De ID van de gebruiker die de forumbericht heeft geschreven.';
$string['privacy:metadata:forum_queue'] = 'Tijdelijk logboek van berichten die als berichtenoverzicht worden gemaild';
$string['privacy:metadata:forum_queue:discussionid'] = 'Forum discussie ID';
$string['privacy:metadata:forum_queue:postid'] = 'Forum bericht ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'De gewijzigde tijd van het originele bericht';
$string['privacy:metadata:forum_queue:userid'] = 'Gebruiker die op de hoogte moet worden gesteld van het bericht';
$string['privacy:metadata:forum_read'] = 'Informatie over welke berichten door de gebruiker zijn gelezen.';
$string['privacy:metadata:forum_read:discussionid'] = 'De discussie waar het bericht in zit.';
$string['privacy:metadata:forum_read:firstread'] = 'De eerste keer dat het bericht werd gelezen.';
$string['privacy:metadata:forum_read:lastread'] = 'De meest recente tijd dat het bericht is gelezen.';
$string['privacy:metadata:forum_read:postid'] = 'Het bericht dat is gelezen.';
$string['privacy:metadata:forum_read:userid'] = 'De ID van de gebruiker waarmee deze record verband houdt.';
$string['privacy:metadata:forum_subscriptions'] = 'Informatie over de forums waarop de gebruiker zich heeft geabonneerd.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Het forum waarop is geabonneerd.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'De ID van de gebruiker waarop dit forumabonnement betrekking heeft.';
$string['privacy:metadata:forum_track_prefs'] = 'Informatie over welke forums de gebruiker heeft gekozen om het bericht te volgen leest voor.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Het forum dat leestracking heeft ingeschakeld.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'De ID van de gebruiker waarop deze voorkeur voor forumtracking betrekking heeft.';
$string['privacy:metadata:preference:autosubscribe'] = 'Of u zich wilt abonneren op discussies wanneer u reageert op berichten in deze discussies.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'De gewenste sorteervolgorde van de discussielijst';
$string['privacy:metadata:preference:maildigest'] = 'De voorkeur voor de e-mail met berichtenoverzicht voor de hele site';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Of u forumberichten wilt markeren als gelezen wanneer u ze als berichten ontvangt.';
$string['privacy:metadata:preference:trackforums'] = 'Of het lezen van leesregels moet worden ingeschakeld.';
$string['privacy:postwasread'] = 'Dit bericht is voor het eerst gelezen op {$a->firstread} en meest recent gelezen op {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Je hebt ervoor gekozen om niet bij te houden welke berichten je op dit forum hebt gelezen.';
$string['privacy:request:delete:discussion:name'] = 'Verwijderen op verzoek van de auteur';
$string['privacy:request:delete:post:message'] = 'De inhoud van dit bericht is verwijderd op verzoek van de auteur.';
$string['privacy:request:delete:post:subject'] = 'Verwijderen op verzoek van de auteur';
$string['privacy:subscribedtoforum'] = 'U bent geabonneerd op dit forum.';
$string['privatereply'] = 'Beantwoord privé';
$string['privatereply_help'] = 'Een privé-antwoord kan alleen worden bekeken door de auteur van het bericht waarop wordt geantwoord en alle gebruikers met de mogelijkheid om privé-antwoorden te bekijken.';
$string['processingdigest'] = 'E-mail met berichtenoverzicht aan het verwerken voor gebruiker {$a}';
$string['processingpost'] = 'Bericht {$a} aan het verwerken';
$string['prune'] = 'Splits discussie';
$string['prunedpost'] = 'Er is een nieuwe discussie gestart met dat bericht';
$string['pruneheading'] = 'Splits deze discussie en begin met dit bericht een nieuwe discussie';
$string['qandaforum'] = 'Vraag- en antwoordforum';
$string['qandanotify'] = 'Dit is een vraag- en antwoordforum. Om de andere antwoorden op deze vraag te kunnen zien, moet je eerst je eigen antwoord posten.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Lees de rest van deze discussie';
$string['removeallforumtags'] = 'Verwijder alle forum-tags';
$string['removefromfavourites'] = 'Discussie niet meer favoriet';
$string['replies'] = 'Antwoorden';
$string['repliesmany'] = '{$a} antwoorden tot nu toe';
$string['repliesone'] = '{$a} antwoord tot nu toe';
$string['reply'] = 'Antwoord';
$string['reply_handler'] = 'Beantwoord berichten via e-mail';
$string['reply_handler_name'] = 'Beantwoord forumberichten';
$string['replyauthorself'] = '{$a} (Jij)';
$string['replyforum'] = 'Antwoord op het forum';
$string['replyingtoauthor'] = 'Antwoord op {$a} ...';
$string['replyplaceholder'] = 'Schrijf je antwoord ...';
$string['replytopostbyemail'] = 'Je kan dit via e-mail beantwoorden.';
$string['replytouser'] = 'Gebruik e-mailadres in antwoord';
$string['resetdigests'] = 'Verwijder alle individuele voorkeuren voor berichtenoverzicht voor forum';
$string['resetforums'] = 'Verwijder berichten van';
$string['resetforumsall'] = 'Verwijder alle berichten';
$string['resetsubscriptions'] = 'Laat niemand nog e-mail van dit forum ontvangen';
$string['resettrackprefs'] = 'Verwijder alle voorkeuren voor berichtenopvolging';
$string['rssarticles'] = 'Aantal recente RSS artikels';
$string['rssarticles_help'] = '<p>Met deze instelling kun je kiezen hoeveel artikels je in de RSS-feed wil zetten.</p>

<p>Een getal tussen 5 en 20 zou goed moeten zijn voor de meeste forums. Verhoog het getal als het forum erg veel gebruikt wordt.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS-feed van discussies';
$string['rsssubscriberssposts'] = 'RSS-feed van berichten';
$string['rsstype'] = 'RSS-feed voor deze activiteit';
$string['rsstype_help'] = '<p>Met deze optie kun je een RSS-feed maken van dit forum.</p>
<p>Je kunt kiezen tussen twee forumtypes:</p>
<ul>
<li><b>Discussies:</b> Als je deze instelling gebruikt, dan zal de RSS-feed nieuwe discussies met hun eerste bericht bevatten.</li>
<li><b>Berichten:</b> Als je deze instelling gebruikt, dan zal de RSS-feed elk nieuw bericht van dit forum bevatten.</li>
</ul>';
$string['rsstypedefault'] = 'RSS feed type';
$string['search'] = 'Zoek';
$string['search:activity'] = 'Forum - activiteitsinformatie';
$string['search:post'] = 'Forum - berichten';
$string['searchdatefrom'] = 'Berichten nieuwer dan dit';
$string['searchdateto'] = 'Berichten ouder dan dit';
$string['searchforumintro'] = 'Geef zoekwoorden in één of meer van volgende velden:';
$string['searchforums'] = 'Zoeken in forums';
$string['searchfullwords'] = 'Deze woorden moeten als volledige woorden voorkomen';
$string['searchnotwords'] = 'Deze woorden mogen NIET voorkomen';
$string['searcholderposts'] = 'Doorzoek oudere berichten...';
$string['searchphrase'] = 'Dit zinsdeel moet exact voorkomen in het bericht';
$string['searchresults'] = 'Zoekresultaten';
$string['searchsubject'] = 'Deze woorden moeten in het onderwerp staan';
$string['searchtags'] = 'Is getagged met';
$string['searchuser'] = 'Dit is de naam van de auteur';
$string['searchuserid'] = 'Dit is de Moodle ID van de auteur';
$string['searchusers'] = 'Zoek gebruikers';
$string['searchwhichforums'] = 'Kies in welke forums je wil zoeken';
$string['searchwords'] = 'Deze woorden mogen overal in het bericht voorkomen';
$string['seeallposts'] = 'Bekijk alle berichten die deze gebruiker gepost heeft.';
$string['sendstudentnotificationsdefault'] = 'Standaardinstelling voor "Leerlingen informeren"';
$string['sendstudentnotificationsdefault_help'] = 'Stel de standaardwaarde in voor het selectievakje "Leerlingen informeren" op het beoordelingsformulier.';
$string['sendstudentnotificationsno'] = 'Nee';
$string['sendstudentnotificationsyes'] = 'Ja, stuur een bericht naar de leerling';
$string['settings'] = 'instellingen';
$string['shortpost'] = 'Kort bericht';
$string['showgraderpanel'] = 'Toon beoordelingspaneel';
$string['showingcountoftotaldiscussions'] = 'Lijst met discussies. Toont {$a->count} van {$a->total} discussies.';
$string['showmoreusers'] = 'Laat meer gebruikers zien';
$string['showpreviousrepliescount'] = 'Eerdere antwoorden weergeven ({$a})';
$string['showsubscribers'] = 'Toon / wijzig wie e-mail van dit forum krijgt';
$string['showusersearch'] = 'Toon gebruiker zoeken';
$string['singleforum'] = 'Eén eenvoudige discussie';
$string['smallmessage'] = '{$a->user} heeft gepost in {$a->forumname}';
$string['smallmessagedigest'] = 'Forum berichtenoverzicht bevat {$a} berichten';
$string['starredonly'] = 'Zoek alleen in discussies met ster';
$string['startedby'] = 'Begonnen door';
$string['subject'] = 'Onderwerp';
$string['subscribe'] = 'Ik wil e-mail van dit forum';
$string['subscribeall'] = 'Laat alle deelnemers van deze cursus e-mail van dit forum ontvangen';
$string['subscribed'] = 'Je krijgt e-mail';
$string['subscribediscussion'] = 'Meldingen krijgen van deze discussie';
$string['subscribeenrolledonly'] = 'Enkel aangemelde gebruikers mogen inschrijven op een forum om meldingen over nieuwe forumberichten te ontvangen';
$string['subscribenone'] = 'Laat niemand van deze cursus e-mail van dit forum ontvangen';
$string['subscribers'] = 'Krijgen e-mail';
$string['subscriberstowithcount'] = 'Krijgen e-mail van "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Stuur me een melding wanneer iemand een bericht op dit forum plaatst';
$string['subscribestop'] = 'Ik wil geen meldingen van inzendingen op dit forum ontvangen';
$string['subscription'] = 'E-mail krijgen';
$string['subscription_help'] = 'Als je op een forum ingeschreven bent, dan betekent dat dat je meldingen van nieuwe forumberichten zult krijgen. Gewoonlijk kun je kiezen of je ingeschreven bent of niet. Soms is inschrijven verplicht, zodat iedereen meldingen ontvangt.';
$string['subscriptionandtracking'] = 'E-mail krijgen en opvolgen';
$string['subscriptionauto'] = 'Initieel inschrijven';
$string['subscriptiondisabled'] = 'Inschrijven uitgeschakeld';
$string['subscriptionforced'] = 'Verplicht inschrijven';
$string['subscriptionmode'] = 'Inschrijvingsmodus';
$string['subscriptionmode_help'] = 'Wanneer een persoon een abonnement heeft op een forum, dan betekent dit dat hij notificaties zal krijgen van elk bericht in dat forum.

Er zijn vier mogelijke manieren om te abonneren op een forum:

* Optioneeel - Deelnemers kunnen kiezen of ze ingeschreven willen zijn
* Verplicht - Iedereen is ingeschreven en kan niet uitschrijven
* Initieel - Iedereen is initieel ingeschreven, maar kan zich elk moment terug uitschrijven
* Uitgeschakeld - Inschrijven is niet toegestaan

Merk op: wijzigingen van deze instellingen zijn enkel van toepassing op gebruikers die zich na de wijziging in de cursus inschrijven, niet voor bestaande gebruikers.';
$string['subscriptionoptional'] = 'Optioneel inschrijven';
$string['subscriptions'] = 'Deze deelnemers krijgen e-mail';
$string['tagarea_forum_posts'] = 'Forumberichten';
$string['tagsdeleted'] = 'Forum-tags zijn verwijderd';
$string['thisforumhasduedate'] = 'De vervaldatum voor het plaatsen van berichten op dit forum is {$a}.';
$string['thisforumisdue'] = 'De vervaldatum voor het plaatsen van berichten op dit forum was {$a}.';
$string['thisforumisthrottled'] = 'Dit forum heeft een limiet op het aantal berichten dat je kan posten in een bepaalde periode - deze is nu ingesteld op {$a->blockafter} bericht(en) in {$a->blockperiod}';
$string['timed'] = 'Timed';
$string['timeddiscussion'] = 'Getimede discussie';
$string['timedhidden'] = 'Getimede status: verborgen voor leerlingen';
$string['timedposts'] = 'Getimed bericht';
$string['timedvisible'] = 'Getimede status: Zichtbaar voor alle gebruikers';
$string['timestartenderror'] = 'De datum van het einde kan niet voor de startdatum zijn.';
$string['togglediscussionmenu'] = 'Discussiemenu in-/uitschakelen';
$string['togglefullscreen'] = 'Volledig scherm in-/uitschakelen';
$string['togglesettingsdrawer'] = 'Schakel instellingenpaneel';
$string['trackforum'] = 'Volg ongelezen berichten op';
$string['tracking'] = 'Volgen';
$string['trackingoff'] = 'Uit';
$string['trackingon'] = 'Verplicht';
$string['trackingoptional'] = 'Optioneel';
$string['trackingtype'] = 'Lezen van dit forum opvolgen';
$string['trackingtype_help'] = 'Als \'Volgen forum\' is ingeschakeld, dan kunnen gebruikers makkelijk zien welke berichten ze gelezen hebben en welke berichten niet door het oplichten van nieuwe berichten.

Indien deze instelling als optioneel is gezet, dan kunnen deelnemers het volgen inschakelen of uitschakelen via een link in het beheerblok. (Gebruikers moeten ook forum volgen inschakelen in hun forum voorkeuren.)

Als \'Forum opvolgen verplicht\' ingeschakeld is in het site-beheer, dan is er nog een optie mogelijk - verplicht. Dit betekent dat het opvolgen altijd aan is, ongeacht de forumvoorkeuren van de gebruiker.';
$string['trackreadposts_header'] = 'Forum opvolgen';
$string['unlockdiscussion'] = 'Ontgrendel deze discussie';
$string['unpindiscussion'] = 'Discussie niet meer gepind';
$string['unread'] = 'Niet gelezen';
$string['unreadpost'] = 'Ongelezen bericht';
$string['unreadposts'] = 'Niet gelezen berichten';
$string['unreadpostsnumber'] = '{$a} ongelezen berichten';
$string['unreadpostsone'] = '1 ongelezen bericht';
$string['unsubscribe'] = 'Ik wil van dit forum geen e-mail meer ontvangen';
$string['unsubscribeall'] = 'Van geen enkel forum nog e-mail ontvangen';
$string['unsubscribeallconfirm'] = 'je ontvangt nu e-mail van {$a->forums} en van {$a->discussions} discussies. Wil je echt van geen enkel forum of discussies nog e-mail ontvangen en het automatisch ontvangen van e-mail van forums en discussies uitschakelen?';
$string['unsubscribeallconfirmdiscussions'] = 'Je bent ingeschreven op {$a->discussions} discussies. Wil je je echt uitschrijven van alle discussies en het automatisch inschrijven op discussies uitschakelen?';
$string['unsubscribeallconfirmforums'] = 'Je bent ingeschreven op {$a->forums} forums. Wil je je echt uitschrijven van alle forums en het automatisch inschrijven op forums uitschakelen?';
$string['unsubscribealldone'] = 'Alle optionele foruminschrijvingen zijn verwijderd. Je zult nog wel meldingen krijgen van verplichte foruminschrijvingen. Om meldingen van forumberichten te configureren ga je naar Berichten in Mijn profielinstelligen.';
$string['unsubscribeallempty'] = 'Je krijgt van geen enkel forum meldingen. Als je van deze site geen enkel bericht wil ontvangen, ga dan naar Berichten in Mijn profielinstellingen.';
$string['unsubscribed'] = 'Je zult geen mail meer ontvangen';
$string['unsubscribediscussion'] = 'Uitschrijven uit deze discussie';
$string['unsubscribediscussionlink'] = 'Schrijf je uit van volgende discussie: {$a}';
$string['unsubscribelink'] = 'Schrijf je uit van volgend forum: {$a}';
$string['unsubscribeshort'] = 'Ik wil geen mail meer';
$string['useexperimentalui'] = 'Gebruik experimentele geneste discussieweergave';
$string['usermarksread'] = 'Manueel bericht als gelezen aanduiden';
$string['usernavigation'] = 'Gebruikersnavigatie';
$string['usersforumposts'] = 'Forumberichten van de gebruiker';
$string['viewalldiscussions'] = 'Bekijk alle discussies';
$string['viewconversation'] = 'Bekijk discussie';
$string['viewgrades'] = 'Bekijk beoordelingen';
$string['viewparentpost'] = 'Toon bovenliggend bericht';
$string['viewthediscussion'] = 'Bekijk discussie';
$string['warnafter'] = 'Waarschuw bij maximale aantal berichten bereikt';
$string['warnafter_help'] = 'Leerlingen kunnen gewaarschuwd worden wanneer ze het maximale aantal toegestane berichten bereiken in een bepaalde periode. Deze instelling specificeert na hoeveel berichten ze gewaarschuwd worden. Gebruikers met de mogelijkheid mod/forum:postwithoutthrottling hebben deze limiet niet.';
$string['warnformorepost'] = 'Waarschuwing: er is meer dan één discussie in dit forum. De meest recente discussie wordt gebruikt';
$string['yournewquestion'] = 'Je nieuwe vraag';
$string['yournewtopic'] = 'Je nieuwe discussieonderwerp';
$string['yourreply'] = 'Jouw antwoord';
