<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_clean', language 'sr_lt', version '3.10'.
 *
 * @package     theme_clean
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Clean</h2>
<p><img class="img-polaroid" src="clean/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>O grafičkoj temi</h3>
<p>Clean je modifikovana Moodle bootstrap tema koja je stilove i metode vizuelizacije nasledila od svoje matične teme.
</p>
<h3>Matična tema</h3>
<p>Ova tema se zasniva na Bootstrap theme, koja je kreirana za Moodle 2.5. Kreiranje teme su pomogli:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Zasluge za temu (autori teme)</h3>
<p>Autori: Bas Brands, David Scotson, Mary Evans<br>
Kontakt: bas@sonsbeekmedia.nl<br>
Veb sajt: <a href="http://www.basbrands.nl">www.basbrands.nl</a>
</p>
<h3>Prijavite grešku:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>Više informacija</h3>
<p><a href="clean/README.txt">Kako da kopirate i prilagodite ovu temu.</a></p>
</div></div>';
$string['configtitle'] = 'Clean';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'CSS pravila koja dodate u ovo polje za tekst odraziće se na izgled svih stranica, što olakšava prilagođavanje ove teme.';
$string['footnote'] = 'Podnožje';
$string['footnotedesc'] = 'Sadržaj koji dodate u ovo polje za tekst biće prikazan u podnožju svake stranice vašeg Moodle sajta.';
$string['invert'] = 'Invertovana navigaciona traka';
$string['invertdesc'] = 'Ovo razmenjuje boje teksta i pozadine navigacione trake na vrhu stranice između crne i bele.';
$string['logo'] = 'Logotip';
$string['logodesc'] = 'Logo se prikazuje samo u zaglavlju naslovne stranice i stranice za prijavu na sistemu.<br /> Ako je visina vašeg logotipa veća od 75 piksela dodajte div.logo {height: 100px;} u donje polje za prilagođeni CSS, uz korekciju visine spram vašeg logotipa ukoliko je visina različita od 100px. Ako logo nije ovde dodat, biće korišćen logo iz podešavanja \'Izgled > Logotipi\'.';
$string['pluginname'] = 'Clean';
$string['privacy:metadata'] = 'Tema Clean ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['sitelogo'] = 'Logo sajta';
$string['sitename'] = 'Prikaži naziv sajta uz mali logo';
$string['sitenamedesc'] = 'Ako nije postavljen mali logo naziv sajta se uvek prikazuje u navigacionoj liniji. Ako pak jeste, možete se prikazati sa nazivom sajta ili bez njega.';
$string['smalllogo'] = 'Mali logo';
$string['smalllogodesc'] = 'Mali logo se prikazuje u navigacionoj traci. Ako postoji logo zaglavlja za naslovnu stranicu i stranicu za prijavu na sistem, mali logo se na tim stranicama ne prikazuje. Ako logo nije ovde dodat, biće korišćen kompaktan logo iz podešavanja \'Izgled > Logotipi\'.';
