<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'ja', version '3.10'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['add'] = 'エントリを追加する';
$string['addcomment'] = 'コメントを追加する';
$string['addentries'] = 'エントリを追加する';
$string['addtemplate'] = '追加用テンプレート';
$string['advancedsearch'] = '高度な検索';
$string['allowcomments'] = 'エントリへのコメントを許可する';
$string['alttext'] = '代替テキスト';
$string['approvalstatus'] = '承認ステータス';
$string['approve'] = '承認';
$string['approved'] = '承認日時';
$string['areacontent'] = 'フィールド';
$string['ascending'] = '昇順';
$string['asearchtemplate'] = '高度な検索テンプレート';
$string['atmaxentry'] = 'あなたは許可されたエントリの最大数を入力しました!';
$string['authorfirstname'] = '著者の名';
$string['authorlastname'] = '著者の姓';
$string['autogenallforms'] = 'すべてのデフォルトテンプレートを生成する';
$string['autolinkurl'] = 'URLにオートリンクする';
$string['availablefromdate'] = '開始日時';
$string['availabletags'] = '利用可能なタグ';
$string['availabletags_help'] = 'タグはエントリが編集または閲覧される時にフィールドや他のアイテムと置換されるテンプレート内の入れ物です。

フィールドは次のようなフォーマットとなります: [fieldname]]。他のタグすべては次のようなフォーマットとなります:  ##sometag##

現在のテンプレートでは「利用可能なタグ」一覧にあるタグのみ使用することができます。';
$string['availabletodate'] = '終了日時';
$string['availabletodatevalidation'] = '終了日時を開始日時の前にすることはできません。';
$string['blank'] = 'ブランク';
$string['buttons'] = '操作';
$string['bynameondate'] = '{$a->date} - {$a->name} の投稿';
$string['calendarend'] = '「{$a}」終了';
$string['calendarstart'] = '「{$a}」開始';
$string['cancel'] = 'キャンセル';
$string['cannotaccesspresentsother'] = 'あなたは他のユーザのプリセットへのアクセスを許可されていません。';
$string['cannotadd'] = 'エントリを追加できません!';
$string['cannotdeletepreset'] = 'プリセットの削除中にエラーが発生しました!';
$string['cannotoverwritepreset'] = 'プリセットの上書き中にエラーが発生しました。';
$string['cannotunziptopreset'] = 'プリセットディレクトリにZIPファイルを展開できません。';
$string['checkbox'] = 'チェックボックス';
$string['chooseexportfields'] = 'あなたがエクスポートしたいフィールドを選択してください。';
$string['chooseexportformat'] = 'あなたがエクスポートしたいフォーマットを選択してください。';
$string['chooseorupload'] = 'ファイルを選択する';
$string['closebeforeopen'] = 'あなたは開始日の前に終了日を指定しました。';
$string['columns'] = 'カラム';
$string['comment'] = 'コメント';
$string['commentdeleted'] = 'コメントが削除されました。';
$string['commentempty'] = 'コメントが空です。';
$string['comments'] = 'コメント';
$string['commentsaved'] = 'コメントが保存されました。';
$string['commentsn'] = '{$a} コメント';
$string['commentsoff'] = 'コメント機能は有効にされていません。';
$string['completionentries'] = '必須エントリ';
$string['completionentriescount'] = 'エントリ数';
$string['completionentriesdesc'] = '最少必須エントリ数 : {$a}';
$string['configenablerssfeeds'] = 'ここではすべてのデータベースに関するRSSフィードを有効にします。さらにあなたはそれぞれのデータベースのRSSフィード設定を手動で有効にする必要があります。';
$string['confirmdeletefield'] = 'あなたはこのフィールドを削除しようとしています。よろしいですか?';
$string['confirmdeleterecord'] = '本当にこのエントリを削除してもよろしいですか?';
$string['confirmdeleterecords'] = '本当にこれらのエントリを削除してもよろしいですか?';
$string['csstemplate'] = 'CSSテンプレート';
$string['csvfailed'] = 'CSVファイルから生データを読み込めません。';
$string['csvfile'] = 'CSVファイル';
$string['csvimport'] = 'CSVファイルインポート';
$string['csvimport_help'] = 'エントリは最初の行にフィールド名の一覧そして1行あたり1レコードを含むテキストファイルによってインポートすることができます。';
$string['csvwithselecteddelimiter'] = '<abbr title="カンマ区切り">CSV</abbr>';
$string['data:addinstance'] = '新しいデータベースを追加する';
$string['data:approve'] = 'エントリを承認または承認済みエントリを取り消す';
$string['data:comment'] = 'コメントを書く';
$string['data:exportallentries'] = 'すべてのデータベースエントリをエクスポートする';
$string['data:exportentry'] = 'データベースエントリをエクスポートする';
$string['data:exportownentry'] = '自分のデータベースエントリをエクスポートする';
$string['data:exportuserinfo'] = 'ユーザ情報をエクスポートする';
$string['data:managecomments'] = 'コメントを管理する';
$string['data:manageentries'] = 'エントリを管理する';
$string['data:managetemplates'] = 'テンプレートを管理する';
$string['data:manageuserpresets'] = 'すべてのテンプレートプリセットを管理する';
$string['data:rate'] = 'エントリを評価する';
$string['data:readentry'] = 'エントリを読む';
$string['data:view'] = 'データベース活動を表示する';
$string['data:viewallratings'] = '個別のユーザから与えられた実評価すべてを表示する';
$string['data:viewalluserpresets'] = 'すべてのユーザのプリセットを表示する';
$string['data:viewanyrating'] = 'すべてのユーザが受けた評価合計を表示する';
$string['data:viewentry'] = 'エントリを表示する';
$string['data:viewrating'] = 'あなたが受けた評価合計を表示する';
$string['data:writeentry'] = 'エントリを書く';
$string['date'] = '日付';
$string['dateentered'] = '入力日時';
$string['defaultfielddelimiter'] = '(デフォルト: カンマ)';
$string['defaultfieldenclosure'] = '(デフォルト: なし)';
$string['defaultsortfield'] = 'デフォルトのフィールド並べ替え順';
$string['delcheck'] = 'バルク削除チェックボックス';
$string['delete'] = '削除';
$string['deleteallentries'] = 'すべてのエントリを削除する';
$string['deletecomment'] = '本当にこのコメントを削除してもよろしいですか?';
$string['deleted'] = '削除されました。';
$string['deletefield'] = '既存のフィールドを削除します。';
$string['deletenotenrolled'] = '登録されていないユーザのエントリを削除する';
$string['deletewarning'] = '本当にこのプリセットを削除してもよろしいですか?';
$string['descending'] = '降順';
$string['directorynotapreset'] = '{$a->directory} はプリセットではありません。不明のファイル: {$a->missing_files}';
$string['disapprove'] = '承認を取り消す';
$string['download'] = 'ダウンロード';
$string['edit'] = '編集';
$string['editcomment'] = 'コメントを編集する';
$string['editentry'] = 'エントリを編集する';
$string['editordisable'] = 'エディタを無効にする';
$string['editorenable'] = 'エディタを有効にする';
$string['emptyadd'] = '追加用テンプレートが空です。デフォルトフォームを生成しています ...';
$string['emptyaddform'] = 'あなたはどのフィールドにも入力していません!';
$string['enabletemplateeditorcheck'] = '本当にエディタを有効にしてもよろしいですか? テンプレート保存時にコンテンツが変更されてしまうことになります。';
$string['entries'] = 'エントリ';
$string['entrieslefttoadd'] = 'この活動を完了するにはさらに {$a->entriesleft} 件以上のエントリを追加してください。';
$string['entrieslefttoaddtoview'] = '他の参加者のエントリを閲覧するにはさらに {$a->entrieslefttoview} 件以上のエントリを追加してください。';
$string['entry'] = 'エントリ';
$string['entrysaved'] = 'あなたのエントリが保存されました。';
$string['errormustbeteacher'] = 'このページを使用するにはあなたは教師である必要があります!';
$string['errormustsupplyvalue'] = 'あなたはここで値を提供する必要があります。';
$string['errorpresetexists'] = '選択された名称のプリセットはすでに存在します。';
$string['eventfieldcreated'] = 'フィールドが作成されました。';
$string['eventfielddeleted'] = 'フィールドが削除されました。';
$string['eventfieldupdated'] = 'フィールドが更新されました。';
$string['eventrecordcreated'] = 'レコードが作成されました。';
$string['eventrecorddeleted'] = 'レコードが削除されました。';
$string['eventrecordupdated'] = 'レコードが更新されました。';
$string['eventtemplateupdated'] = 'テンプレートが更新されました。';
$string['eventtemplateviewed'] = 'テンプレートが閲覧されました。';
$string['example'] = 'データベースモジュール例';
$string['excel'] = 'Excel';
$string['expired'] = '申し訳ございません、この活動は {$a} に終了して利用することはできません。';
$string['export'] = 'エクスポート';
$string['exportaszip'] = 'ZIPファイルとしてエクスポートする';
$string['exportaszip_help'] = 'ZIPファイルとしてエクスポートする機能ではあなたはテンプレートおよびフィールドをダウンロードするためのプリセットZIPとして保存することができます。その後、ZIPファイルを別のコースにインポートすることができます。';
$string['exportedtozip'] = 'ZIPファイルとして一時的にエクスポートしました ...';
$string['exportentries'] = 'エントリをエクスポートする';
$string['exportformat'] = 'エクスポートフォーマット';
$string['exportoptions'] = 'エクスポートオプション';
$string['exportownentries'] = 'あなたのエントリのみエクスポートしますか? ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'プリセットの削除中にエラーが発生しました!';
$string['fieldadded'] = 'フィールドが追加されました。';
$string['fieldallowautolink'] = 'オートリンクを許可する';
$string['fielddeleted'] = 'フィールドが削除されました。';
$string['fielddelimiter'] = 'フィールドデリミタ';
$string['fielddescription'] = 'フィールド説明';
$string['fieldenclosure'] = 'フィールド囲み文字';
$string['fieldheight'] = '高さ';
$string['fieldheightlistview'] = '一覧表示の高さ';
$string['fieldheightsingleview'] = '個別表示の高さ';
$string['fieldids'] = 'フィールドID';
$string['fieldmappings'] = 'フィールドマッピング';
$string['fieldmappings_help'] = 'このメニューでは既存のデータベースのデータを保持することができます。フィールドのデータを保持するにはそのフィールドをデータが表示されることになる新しいフィールドにマップする必要があります。どのフィールドでも空白のまましてデータをコピーしないこともできます。新しいフィールドにマップされない古いフィールドおよび関連するすべてのデータは削除されます。

あなたは同じタイプのフィールドのみマップできます。そのため、それぞれのドロップダウンメニューには他のフィールドも表示される場合があります。古いフィールドを2個以上の新しいフィールドにマップしないよう気をつけてください。';
$string['fieldname'] = 'フィールド名';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'あなたのファイル内の次のフィールドは不明なフィールドです: {$a}';
$string['fieldoptions'] = 'オプション (1行あたり1つ)';
$string['fields'] = 'フィールド';
$string['fieldupdated'] = 'フィールドが更新されました。';
$string['fieldwidth'] = '幅';
$string['fieldwidthlistview'] = '一覧表示の幅';
$string['fieldwidthsingleview'] = '個別表示の幅';
$string['file'] = 'ファイル';
$string['fileencoding'] = 'エンコーディング';
$string['filesnotgenerated'] = 'すべてのファイルは生成されませんでした: {$a}';
$string['filtername'] = 'データベースオートリンク';
$string['footer'] = 'フッタ';
$string['forcelinkname'] = '強制リンク名';
$string['foundnorecords'] = 'レコードが見つかりませんでした (<a href="{$a->reseturl}">フィルタをリセットする</a>)';
$string['foundrecords'] = '{$a->num}/{$a->max} 件のレコードが見つかりました (<a href="{$a->reseturl}">フィルタをリセットする</a>)';
$string['fromfile'] = 'ZIPファイルからインポートする';
$string['fromfile_help'] = 'ZIPファイルからインポートする機能ではあなたはテンプレートおよびフィールドのプリセットのZIPを閲覧およびアップロードすることができます。';
$string['generateerror'] = 'すべてのファイルは生成されませんでした!';
$string['header'] = 'ヘッダ';
$string['headeraddtemplate'] = 'エントリ追加および編集用のインターフェース定義';
$string['headerasearchtemplate'] = '高度な検索のインターフェース定義';
$string['headercsstemplate'] = '他のテンプレート用のローカルCSSスタイル定義';
$string['headerjstemplate'] = '一覧、個別またはテンプレート追加での要素の表示を操作するカスタムJavaScript定義';
$string['headerlisttemplate'] = '一覧表示用のインターフェース定義';
$string['headerrsstemplate'] = 'RSSフィードエントリのアピアランス定義';
$string['headersingletemplate'] = '個別表示用の閲覧インターフェース定義';
$string['importentries'] = 'エントリをインポートする';
$string['importsuccess'] = 'プリセットが正常に適用されました。';
$string['includeapproval'] = '承認ステータスを含む';
$string['includetags'] = 'タグを含む';
$string['includetime'] = '追加/修正時間を含む';
$string['includeuserdetails'] = 'ユーザ詳細を含む';
$string['indicator:cognitivedepth'] = 'データベース認知的';
$string['indicator:cognitivedepth_help'] = 'この指標はデータベース活動で学生が到達した認識深度に基づきます。';
$string['indicator:cognitivedepthdef'] = 'データベース認知的';
$string['indicator:cognitivedepthdef_help'] = 'この分析間隔中、参加者がデータベース活動から提供された認知的関与のこのパーセンテージに到達しました (レベル = 閲覧なし, 閲覧, 送信)。';
$string['indicator:socialbreadth'] = 'データベース社会的';
$string['indicator:socialbreadth_help'] = 'この指標はデータベース活動で学生が到達した社会的広がりに基づきます。';
$string['indicator:socialbreadthdef'] = 'データベース社会的';
$string['indicator:socialbreadthdef_help'] = 'この分析間隔中、参加者がデータベース活動から提供された社会的関与のこのパーセンテージに到達しました (レベル = 参加なし, 個人で参加)。';
$string['insufficiententries'] = 'このデータベースを閲覧するにはさらにエントリが必要です。';
$string['intro'] = '説明';
$string['invalidaccess'] = 'このページは正しくアクセスされていません。';
$string['invalidfieldid'] = 'フィールドIDが正しくありません。';
$string['invalidfieldname'] = 'このフィールドに別の名称を選択してください。';
$string['invalidfieldtype'] = 'フィールドタイプが正しくありません。';
$string['invalidid'] = 'データIDが正しくありません。';
$string['invalidpreset'] = '{$a} はプリセットではありません。';
$string['invalidrecord'] = 'レコードが正しくありません。';
$string['invalidurl'] = 'あなたが入力したURLは正しくありません。';
$string['jstemplate'] = 'JavaScriptテンプレート';
$string['latitude'] = '経度';
$string['latlong'] = '緯度/経度';
$string['latlongboth'] = '緯度および経度の両方とも必須です。';
$string['latlongdownloadallhint'] = 'すべてのエントリのリンクをKMLとしてダウンロードする';
$string['latlongkmllabelling'] = 'KMLファイル (Google Earth) でのラベルのつけ方';
$string['latlonglinkservicesdisplayed'] = '表示するLink-outサービス';
$string['latlongotherfields'] = '他のフィールド';
$string['list'] = '一覧表示';
$string['listtemplate'] = '一覧表示用テンプレート';
$string['longitude'] = '経度';
$string['manageapproved'] = '承認済みエントリの編集を許可する';
$string['manageapproved_help'] = 'この設定を無効にした場合、認証済みエントリは追加したオーナーにより編集および削除することはできません。この設定は「承認必要」が有効にされない限り影響を及ぼしません。';
$string['mapexistingfield'] = '{$a} にマップする';
$string['mapnewfield'] = '新しいフィールドを作成する';
$string['mappingwarning'] = '新しいフィールドにマップされない古いフィールドは喪失します。古いフィールドのすべてのデータは削除されます。';
$string['maxentries'] = '最大エントリ数';
$string['maxentries_help'] = '参加者がこのデータベースに登録できる最大エントリ数です。';
$string['maxsize'] = '最大サイズ';
$string['menu'] = 'メニュー';
$string['menuchoose'] = '選択 ...';
$string['missingdata'] = 'フィールドクラスにはデータIDまたはオブジェクトを提供してください。';
$string['missingfield'] = 'プログラマエラー: フィールドクラスを定義するにはあなたはフィールドおよびデータを指定する必要があります。';
$string['modulename'] = 'データベース';
$string['modulename_help'] = 'データベース活動モジュールにおいて参加者は一連のエントリ (例 レコード) を作成、管理および検索することができます。エントリの構造は多くのフィールドとして教師により定義されます。フィールドタイプにはチェックボックス、ラジオボタン、ドロップダウンメニュー、テキストエリア、URL、写真およびアップロードファイルを含みます。

一覧表示、閲覧またはデータベースエントリの編集時の視覚レイアウト情報はデーターベーステンプレートによりコントロールされます。データベース活動はコース間においてプリセットとして共有することができます。教師はデータベースエントリをインポートおよびエクスポートすることもできます。

データベースオートリンクフィルタが有効にされた場合、コース内に単語またはフレーズが表示された時点で自動的にデータベースとリンクされます。

教師はエントリへのコメントを許可することができます。エントリは教師または学生 (ピア評価) により評価できるようにすることもできます。評価は合計された後に最終評価として評定表に記録させることができます。

データベース活動には以下のように多くの使用方法があります:

* ウェブリンク、書籍、書評、論文書誌等の共同収集作業用として
* 学生による写真、ポスター、ウェブサイトまたは詩の展示用またはピアコメントまたはピアレビュー用として';
$string['modulenameplural'] = 'データベース';
$string['more'] = '詳細';
$string['moreurl'] = 'URL詳細';
$string['movezipfailed'] = 'ZIPファイルを移動できません。';
$string['multientry'] = '繰り返しエントリ';
$string['multimenu'] = 'メニュー (複数選択)';
$string['multipletags'] = '重複タグが見つかりました! テンプレートは保存されませんでした。';
$string['newentry'] = '新しいエントリ';
$string['newfield'] = '新しいフィールドを作成する';
$string['newfield_help'] = 'フィールドにはデータを入力することができます。データベース活動内のそれぞれのエントリには参加者が年月日をドロップダウンメニューから選択できる日付フィールド、イメージをアップロードできる画像フィールド、1つまたはそれ以上のオプションを選択できるチェックボックスフィールドのように複数タイプのフィールドを配置できます。

それぞれのフィールドには固有のフィールド名を設定してください。フィールド説明は任意です。';
$string['noaccess'] = 'あなたはこのページにアクセスできません。';
$string['nodefinedfields'] = '新しいプリセットにフィールドが定義されていません!';
$string['nofieldcontent'] = 'フィールドコンテンツが見つかりませんでした。';
$string['nofieldindatabase'] = 'このデータベースにはフィールドが定義されていません。';
$string['nolisttemplate'] = 'テンプレート一覧はまだ定義されていません。';
$string['nomatch'] = '該当するエントリが見つかりませんでした!';
$string['nomaximum'] = '最大数なし';
$string['norecords'] = 'データベースにエントリはありません。';
$string['nosingletemplate'] = '単一テンプレートはまだ定義されていません。';
$string['notapproved'] = 'エントリはまだ承認されていません。';
$string['notinjectivemap'] = 'エントリを追加できるマップではありません。';
$string['notopenyet'] = '申し訳ございません、この活動は {$a} まで利用できません。';
$string['number'] = '数値';
$string['numberrssarticles'] = 'RSSフィードエントリ';
$string['numnotapproved'] = '保留';
$string['numrecords'] = '{$a} エントリ';
$string['ods'] = '<abbr title="OpenDocumentスプレッドシート">ODS</abbr> &nbsp;(OpenOffice)';
$string['openafterclose'] = 'あなたは終了日の後に開始日を指定しました。';
$string['optionaldescription'] = '短い説明 (任意)';
$string['optionalfilename'] = 'ファイル名 (任意)';
$string['other'] = 'その他';
$string['overrwritedesc'] = 'すでに存在する場合、プリセットを上書きする';
$string['overwrite'] = '上書き';
$string['overwritesettings'] = '現在の設定を上書きする';
$string['page-mod-data-x'] = 'すべてのデータベース活動ページ';
$string['pagesize'] = '1ページあたりのエントリ数';
$string['participants'] = '参加者';
$string['picture'] = '画像';
$string['pleaseaddsome'] = '始めるには下で新しいフィールドを追加するか<a href="{$a}">定義済みフィールドセットを選択</a>してください。';
$string['pluginadministration'] = 'データベース活動管理';
$string['pluginname'] = 'データベース';
$string['portfolionotfile'] = 'ファイル (csvおよびLeap2Aのみ) ではなくポートフォリオにエクスポートする';
$string['presetinfo'] = 'プリセットとして保存することによりこのテンプレートが公開されます。他のユーザはこのテンプレートを自分のデータベースで使用することができます。';
$string['presets'] = 'プリセット';
$string['privacy:metadata:commentpurpose'] = 'データベースレコードのコメントです。';
$string['privacy:metadata:data_content'] = 'データベース活動モジュールでは1つの回答が1つのフィールドを示します。';
$string['privacy:metadata:data_content:content'] = 'コンテンツです。';
$string['privacy:metadata:data_content:content1'] = '追加コンテンツ1です。';
$string['privacy:metadata:data_content:content2'] = '追加コンテンツ2です。';
$string['privacy:metadata:data_content:content3'] = '追加コンテンツ3です。';
$string['privacy:metadata:data_content:content4'] = '追加コンテンツ4です。';
$string['privacy:metadata:data_content:fieldid'] = 'フィールド定義IDです。';
$string['privacy:metadata:data_records'] = 'データベース活動モジュールのレコードを示します。';
$string['privacy:metadata:data_records:approved'] = '承認ステータスです。';
$string['privacy:metadata:data_records:groupid'] = 'グループです。';
$string['privacy:metadata:data_records:timecreated'] = 'レコードが作成された日時です。';
$string['privacy:metadata:data_records:timemodified'] = 'レコードが最後に修正された日時です。';
$string['privacy:metadata:data_records:userid'] = 'レコードを作成したユーザです。';
$string['privacy:metadata:datafieldnpluginsummary'] = 'データベース活動モジュールのフィールです。';
$string['privacy:metadata:filepurpose'] = 'データベースレコードに添付されたファイルです。';
$string['privacy:metadata:ratingpurpose'] = 'データベースレコードの評価です。';
$string['privacy:metadata:tagpurpose'] = 'データベースレコードのタグです。';
$string['radiobutton'] = 'ラジオボタン';
$string['recordapproved'] = 'エントリが承認されました。';
$string['recorddeleted'] = 'エントリが削除されました。';
$string['recorddisapproved'] = 'エントリ未承認';
$string['recordsnotsaved'] = 'エントリは保存されませんでした。アップロードファイルのフォーマットを確認してください。';
$string['recordssaved'] = 'エントリが保存されました。';
$string['removealldatatags'] = 'すべてのデータベースタグを削除する';
$string['requireapproval'] = '要承認';
$string['requireapproval_help'] = 'この設定を有効にした場合、すべての人が閲覧できる前に教師からエントリの承認を受ける必要があります。';
$string['required'] = '必須';
$string['requiredentries'] = '完了のための必須エントリ数 (旧)';
$string['requiredentries_help'] = 'この設定を有効にした場合、完了に必要なエントリ数の最初にメッセージが表示されます。この設定は活動完了に関連付けられないことに留意してください。
活動完了にエントリを必要とする場合、新しい活動完了設定「必須エントリ」を使用してください。この設定を完全に削除する場合、「なし」に設定して変更を保存してください。
代わりに活動完了セクションの必須エントリ数フィールドを使用してください。';
$string['requiredentriestoview'] = '閲覧前に必要な入力エントリ数';
$string['requiredentriestoview_help'] = 'このデータベースエントリの閲覧が許可されるまでに参加者が登録する必要のある入力エントリ数です。

注意: 閲覧前にエントリが必要な場合、データベースオートリンクフィルタを無効にしてください。データベースオートリンクフィルタではユーザにより必要な入力エントリ数が送信されたかどうか判定することができません。';
$string['requiredentrieswarning'] = 'この設定は活動完了設定「必須エントリ」と置換されました。';
$string['requiredfield'] = '必須フィールド';
$string['resetsettings'] = 'フィルタをリセットする';
$string['resettemplate'] = 'テンプレートをリセットする';
$string['resizingimages'] = 'イメージサムネイルのリサイズ...';
$string['rows'] = '行';
$string['rssglobaldisabled'] = '使用不可、サイト詳細設定をご覧ください。';
$string['rsstemplate'] = 'RSSテンプレート';
$string['rsstitletemplate'] = 'RSSタイトルテンプレート';
$string['rsstype'] = 'この活動のRSSフィード';
$string['save'] = '保存';
$string['saveandadd'] = '保存して次を追加する';
$string['saveandview'] = '保存して表示する';
$string['saveaspreset'] = 'プリセットとして保存する';
$string['saveaspreset_help'] = 'プリセットとして保存する機能ではサイトの誰でも利用できるようプリセットおよびフィールドを公開します (あなたは保存したプリセットをいつでもプリセット一覧から削除することができます)。';
$string['savesettings'] = '設定を保存する';
$string['savesuccess'] = '正常に保存されました。あなたのプリセットはサイト全体で利用できます。';
$string['savetemplate'] = 'テンプレートを保存する';
$string['search'] = '検索';
$string['search:activity'] = 'データベース - 活動情報';
$string['search:entry'] = 'データベース - エントリ';
$string['selectedrequired'] = '選択したすべてを含む';
$string['selectexportoptions'] = 'エクスポートオプションを選択する';
$string['selectfields'] = 'フィールドを選択する';
$string['showall'] = 'すべてのエントリを表示する';
$string['single'] = '個別表示';
$string['singletemplate'] = '個別表示用テンプレート';
$string['subplugintype_datafield'] = 'データベースフィールドタイプ';
$string['subplugintype_datafield_plural'] = 'データベースフィールドタイプ';
$string['subplugintype_datapreset'] = 'プリセット';
$string['subplugintype_datapreset_plural'] = 'プリセット';
$string['tagarea_data_records'] = 'データレコード';
$string['tags'] = 'タグ';
$string['tagsdeleted'] = 'データベースタグが削除されました。';
$string['teachersandstudents'] = '{$a->teachers} および {$a->students}';
$string['templates'] = 'テンプレート';
$string['templatesaved'] = 'テンプレートが保存されました。';
$string['text'] = 'テキスト';
$string['textarea'] = 'テキストエリア';
$string['timeadded'] = '追加日時';
$string['timemodified'] = '修正日時';
$string['todatabase'] = '>> データベース';
$string['type'] = 'フィールドタイプ';
$string['undefinedprocessactionmethod'] = 'アクション「 {$a} 」を処理するためのアクションメソッドがData_Presetに定義されていません。';
$string['unsupportedexport'] = '({$a->fieldtype}) をエクスポートできません。';
$string['unsupportedfields'] = '未サポートフィールド';
$string['unsupportedfieldslist'] = '次のフィールドはエクスポートできません:';
$string['updatefield'] = '既存のフィールドを更新します。';
$string['uploadfile'] = 'ファイルをアップロードする';
$string['uploadrecords'] = 'ファイルからエントリをアップロードする';
$string['uploadrecords_help'] = 'テキストファイルによりエントリをアップロードすることができます。ファイルのフォーマットは以下のとおりです:

* それぞれの行には1レコードを含みます。
* それぞれのレコードはカンマ (または他のデリミタ) で区切られた一連のデータです。
* 最初のレコードにはファイル内の残りのレコードを定義するフィールド名一覧を含みます。

フィールド囲み文字はレコード内のフィールドを囲む文字です。通常、設定する必要はありません。';
$string['url'] = 'URL';
$string['usedate'] = '検索に含む';
$string['usestandard'] = 'プリセットを使用する';
$string['usestandard_help'] = 'サイト全体でプリセットを使用できるようにするにはリストよりプリセットを選択してください (あなたが「プリセットとして保存する」を使用してライブラリに保存したプリセットは削除することもできます)。';
$string['viewfromdate'] = '閲覧開始日時';
$string['viewtodate'] = '閲覧終了日時';
$string['viewtodatevalidation'] = '閲覧終了日時を閲覧開始日時の前にすることはできません。';
$string['wrongdataid'] = '無効なデータIDが提供されました。';
