<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'no', version '3.10'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['addedandupdatedpp'] = 'La til {$a->%new} nye H5P bibliotek og oppdaterte {$a->%old} gamle.';
$string['addedandupdatedps'] = 'La til {$a->%new} nye H5P bibliotek og oppdaterte {$a->%old} gammelt.';
$string['addedandupdatedsp'] = 'La til {$a->%new} nytt H5P bibliotek og oppdaterte {$a->%old} gamle.';
$string['addedandupdatedss'] = 'La til {$a->%new} nytt H5P bibliotek og oppdaterte {$a->%old} gammelt.';
$string['addednewlibraries'] = 'La til {$a->%new} nye H5P bibliotek.';
$string['addednewlibrary'] = 'La til {$a->%new} nytt H5P bibliotek.';
$string['additionallicenseinfo'] = 'Mer informasjon om lisensen';
$string['atto_h5p'] = 'Sett inn H5P-knapp';
$string['atto_h5p_description'] = 'Knappen "Sett inn H5P" i Atto-editoren lar brukere sette inn H5P-innhold ved å legge inn en URL, innbyggingskode eller laste opp en H5P-fil.';
$string['author'] = 'Forfatter';
$string['authorcomments'] = 'Forfatterkommentarer';
$string['authorcommentsdescription'] = 'Kommentarer fra innholdets forfatter. (Denne teksten vil ikkepubliseres som en del av opphavsrettinformasjonen.)';
$string['authorname'] = 'Forfatters navn';
$string['authorrole'] = 'Forfatters rolle';
$string['by'] = 'av';
$string['cancellabel'] = 'Avbryt';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changedby'] = 'Endret av';
$string['changedescription'] = 'Endringsbeskrivelse';
$string['changelog'] = 'Endringslogg';
$string['changeplaceholder'] = 'Foto beskåret, tekst endret, etc.';
$string['close'] = 'Lukk';
$string['confirmdialogbody'] = 'Vennligst bekreft at du ønsker å fortsette. Denne handlingen kan ikke angr';
$string['confirmdialogheader'] = 'Bekreft handling';
$string['confirmlabel'] = 'Bekreft';
$string['connectionLost'] = 'Tilkobling tapt. Resultatene blir lagret og sendt når forbindelsen er gjenopprettet.';
$string['connectionReestablished'] = 'Tilkoblingen gjenopprettet.';
$string['contentCopied'] = 'Innhold kopiert til utklippstavla';
$string['contentchanged'] = 'Innholdet har blitt endret siden sist visning.';
$string['contenttype'] = 'Innholdstype';
$string['copyright'] = 'Bruksrettigheter';
$string['copyrightinfo'] = 'Opphavsrettinformasjon';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Vis informasjon om opphavsrett for innholdet.';
$string['couldNotParseJSONFromZip'] = 'Kan ikke analysere JSON fra pakken: {$a ->%fileName}';
$string['couldNotReadFileFromZip'] = 'Kan ikke lese fil fra pakken: {$a ->%fileName}';
$string['creativecommons'] = 'Creative Commons';
$string['date'] = 'Dato';
$string['deletelibraryconfirm'] = '<p>Er du sikker på at du ønsker å slette versjon <em>\'{$a->version}\'</em> fra biblioteket <em>\'{$a->name}\'</em>? Dette vil fjerne biblioteket all dets bruk.</p><p>Dette kan ikke angres.</p>';
$string['deletelibraryversion'] = 'Slett versjon';
$string['deleting'] = 'Sletter et bibliotek';
$string['description'] = 'Beskrivelse';
$string['disablefullscreen'] = 'Deaktiver fullskjerm';
$string['download'] = 'Last ned';
$string['downloadtitle'] = 'Last ned dette innholdet som en H5P-fil.';
$string['editor'] = 'Redaktør';
$string['embed'] = 'Bygg inn';
$string['embedtitle'] = 'Vis innbyggingskoden for dette innholde';
$string['eventh5pdeleted'] = 'H5P slettet';
$string['eventh5pviewed'] = 'H5P innhold vist';
$string['feature'] = 'Funksjoner';
$string['fetchtypesfailure'] = 'Kunne ikke finne noen informasjon om tilgjengelige H5P innholdstyper. Kunne ikke koble til H5P filområde.';
$string['fileExceedsMaxSize'] = 'En av filene inni pakken er større en maks tillatt filstørrelse. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Vis H5P filter';
$string['filter_displayh5p_description'] = 'Vis H5P filteret konverterer URLer til innebygd H5P innhold.';
$string['fullscreen'] = 'Fullskjerm';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5pfilenotfound'] = 'H5P-fil ikke funnet';
$string['h5pinvalidurl'] = 'Ugyldig H5P innholdsURL';
$string['h5plibraryhandler'] = 'H5P rammeverkhåndterer';
$string['h5plibraryhandler_help'] = 'H5P rammeverket som brukes til å vise H5P-innhold. Nyeste versjon er anbefalt.';
$string['h5pmanage'] = 'Administrer H5P innholdstyper';
$string['h5poverview'] = 'H5P oversikt';
$string['h5ppackage'] = 'H5P innholdstype';
$string['h5ppackage_help'] = 'En H5P innholdstype er en fil med endelsen H5P eller Zip som innehodler alle påkrevde bibliotek for å vise innholdet.';
$string['h5pprivatefile'] = 'H5P-innholdet kan ikke vises siden du ikke har tilgang til .h5p-filen.';
$string['h5psettings'] = 'H5P innstillinger';
$string['h5ptitle'] = 'Besøk h5p.org for å sjekke ut mer innhold.';
$string['hideadvanced'] = 'Skjul avansert';
$string['installedcontentlibraries'] = 'Installerte H5P bibliotek';
$string['installedcontenttypes'] = 'Installerte H5P innholdstyper';
$string['installedh5p'] = 'Installert H5P';
$string['invalidcontextid'] = 'H5P-fil ikke funnet (ugyldig kontekstid)';
$string['invalidfile'] = 'Filen "{$a ->% filename}" er ikke tillatt. Bare filer med følgende utvidelser er tillatt: {$a ->%files-allowed}.';
$string['invalidlanguagefile'] = 'Ugyldig språkfil {$a->%file} i bibliotek {$a->%library}';
$string['invalidlanguagefile2'] = 'Ugyldig språkfil {$a->%languageFile} har blitt inkludert i biblioteket {$a->%name}';
$string['invalidlibrarydata'] = 'Ugyldig data for {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ugyldig data oppgitt for {$a->%property} i {$a->%library}. Boolsk verdi forventet.';
$string['invalidlibraryname'] = 'Ugyldig biblioteknavn: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P biblioteket {$a->%library} brukt i innholdet er ikke gldig';
$string['invalidlibraryoption'] = 'Ugylidg valg {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan ikke lese egenskapen {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'Det mangler en gyldig h5p.json hovedfil';
$string['invalidmultiselectoption'] = 'Ugyldig valg i flervalg.';
$string['invalidpackage'] = 'Ugyldig H5P innholdstype';
$string['invalidselectoption'] = 'Ugyldig valg.';
$string['invalidsemanticsjson'] = 'Ugyldig semantics.json file har blitt inkludert i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'H5P intern feil: ukjent innholdstype "{$a -> @type}" i semantikk. Fjerner innhold!';
$string['invalidstring'] = 'Forutsatt streng er ikke gyldig i henhold til regexp i semantikk. (verdi: "{$a ->%value}", regexp: "{$a ->%regexp}")';
$string['librariesmanagerdescription'] = '<p> H5P gjør det mulig for brukere å lage interaktivt innhold ved å tilby en rekke innholdstyper. </p> <p> For å sikre at bare pålitelige H5P-innholdstyper brukes på portalen ditt, må du <i> enten </i> </p><ul> <li> Last opp H5P-innholdstyper fra h5p.org <i> eller</i></li> <li> Aktiver cron-oppgaven \'Last ned tilgjengelige H5P-innholdstyper fra h5p.org </li> > </ul> <p> Merk at brukere bare vil kunne bruke H5P-innholdstypene som er installert på portalen din. </p>';
$string['librarydirectoryerror'] = 'Bibliotekets mappenavn må samsvare med machineName eller machineName-majorVersion.minorVersion (fra library.json). (Mappe: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion}';
$string['license'] = 'Lisens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) dedikasjon til offentlig domene';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generisk';
$string['licenseCC20'] = '2.0 Generisk';
$string['licenseCC25'] = '2.5 Generisk';
$string['licenseCC30'] = '3.0 Uportert';
$string['licenseCC40'] = '4.0 Internasjonalt';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Versjon 1';
$string['licenseV2'] = 'Versjon 2';
$string['licenseV3'] = 'Versjon 3';
$string['licensee'] = 'Lisensholder';
$string['licenseextras'] = 'Lisens tillegg';
$string['licenseversion'] = 'Lisensversjon';
$string['lockh5pdeploy'] = 'H5P-innholdet er ikke tilgjengelig fordi det lastes opp. Vennligst prøv igjen senere.';
$string['missingcontentfolder'] = 'En gyldig innholdsmappe mangler';
$string['missingcoreversion'] = 'Systemet klarte ikke å installere {$a ->%component} komponenten fra pakken, da det krever en nyere versjon av H5P-modulen. Dette nettstedet kjører for øyeblikket versjon {$a ->%current}, mens den nødvendige versjonen er {$a ->%required} eller høyere. Oppgrader og prøv igjen.';
$string['missingdependency'] = 'Manglende avhengighet {$a->@dep} kreves av {$a->@lib}.';
$string['missinglibrary'] = 'Mangler obligatorisk bibliotek {$a->@library}';
$string['missinglibraryfile'] = 'Filae "{$a->%file}" mangler fra biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Fant ikke library.json fila i gyldig format for biblioteket {$a->%name}';
$string['missinglibraryproperty'] = 'Den obligatoriske egenskapen  {$a->%property} mangler fra{$a->%library}';
$string['missingmbstring'] = '"mbstring" PHP-utvidelsen er ikke lastet inn. "mbstring" kreves at H5P fungerer som den skal.';
$string['missinguploadpermissions'] = 'Merk at bibliotekene kan eksistere i filen du lastet opp, men du har ikke lov til å laste opp nye biblioteker. Kontakt administratoren din.';
$string['nocopyright'] = 'Ingen opphavsrettinformasjon tilgjengelige for dette innholdet.';
$string['noextension'] = 'Filen du lastet opp er ikke en gyldig HTML5-pakke. (Den har ikke .h5p-filendelsen.)';
$string['noh5plibhandlerdefined'] = 'Det er ikke installert noen H5P-rammeverkhåndterer og H5P innhold kan ikke vises.';
$string['nojson'] = 'H5p.json-hovedfilen er ikke gyldig';
$string['nopermissiontodeploy'] = 'Denne filen kan ikke vises fordi den er lastet opp av en bruker uten den nødvendige rettigheten til å distribuere H5P-innhold.';
$string['nopermissiontoedit'] = 'Du har ikke tillatelser til å redigere H5P innhold.';
$string['notrustablefile'] = 'Denne filen kan ikke vises fordi den er lastet opp av en bruker uten mulighet til å oppdatere H5P-innholdstyper. Kontakt administratoren din for å be om innholdstypen som skal installeres.';
$string['nounzip'] = 'Filen du lastet opp er ikke en gyldig HTML5-pakke. (Det er ikke mulig å pakke den ut.)';
$string['offlineDialogBody'] = 'Vi kunne ikke sende informasjon om hvordan du fullførte denne oppgaven. Vennligst sjekk internettforbindelsen din.';
$string['offlineDialogHeader'] = 'Forbindelsen din til serveren gikk tapt';
$string['offlineDialogRetryButtonLabel'] = 'Prøv på nytt nå';
$string['offlineDialogRetryMessage'] = 'Prøv på nytt :num ....';
$string['offlineSuccessfulSubmit'] = 'Resultater sendt.';
$string['originator'] = 'Opphavsmann';
$string['pd'] = 'Offentlig domene';
$string['pddl'] = 'Dedikasjon og lisens for offentlig domene';
$string['pdm'] = 'Offentlig domene merke (PDM)';
$string['pluginname'] = 'H5P Pakke';
$string['privacy:metadata'] = 'H5P-undersystemet lagrer ingen personopplysninger.';
$string['resizescript'] = 'Inkluder dette ksriptet på nettsiden din om du ønsker dynamisk størrelse på det innebygde inn';
$string['resubmitScores'] = 'Forsøker å levere lagrede resultater.';
$string['reuse'] = 'Bruk på nytt';
$string['reuseContent'] = 'Bruk innhold på nytt';
$string['reuseDescription'] = 'Bruk dette innholdet på nytt.';
$string['showadvanced'] = 'Vis avansert';
$string['showless'] = 'Vis mindre';
$string['showmore'] = 'Vis mer';
$string['size'] = 'Størrelse';
$string['source'] = 'Kilde';
$string['startingover'] = 'Du må starte på nytt';
$string['status'] = 'Status';
$string['sublevel'] = 'Undernivå';
$string['task_h5p'] = 'H5P cronjobb';
$string['task_h5p_description'] = 'H5P cronjobben laster ned H5P innholdstyper fra h5p.org';
$string['thumbnail'] = 'Thumbnail';
$string['title'] = 'Tittel';
$string['undisclosed'] = 'Ikke oppgitt';
$string['unpackedFilesExceedsMaxSize'] = 'Den totale størrelsen på de utpakkede filene overstiger den maksimale tillatte størrelsen. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Oppdaterte {$a->%old} H5P bibliotek.';
$string['updatedlibrary'] = 'Oppdaterte {$a->%old} H5P bibliotek.';
$string['uploadlibraries'] = 'Last opp H5P innholdstype';
$string['uploadsuccess'] = 'Vellykket opplasting av H5P innholdstyper';
$string['wrongversion'] = 'Versjonen av H5P-biblioteket {$a ->% machineName} som er brukt i dette innholdet, er ikke gyldig. Innhold inneholder {$a ->%contentLibrary}, men det skal være {$a ->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
$string['yearsfrom'] = 'År (fra)';
$string['yearsto'] = 'År (til)';
