<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'el', version '3.10'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ενέργεια';
$string['addanotherhint'] = 'Προσθήκη μιας ακόμα υπόδειξης';
$string['addcategory'] = 'Προσθήκη κατηγορίας';
$string['addmorechoiceblanks'] = 'Κενά πεδία για {no} ακόμα επιλογές';
$string['adminreport'] = 'Αναφορά πιθανών προβλημάτων στην βάση δεδομένων ερωτήσεων σας.';
$string['advancedsearchoptions'] = 'Επιλογές αναζήτησης';
$string['alltries'] = 'Όλες οι προσπάθειες';
$string['answer'] = 'Απάντηση';
$string['answers'] = 'Απαντήσεις';
$string['answersaved'] = 'Η απάντηση αποθηκεύτηκε';
$string['attemptfinished'] = 'Η προσπάθεια ολοκληρώθηκε';
$string['attemptfinishedsubmitting'] = 'Η προσπάθεια ολοκληρώθηκε με την υποβολή:';
$string['attemptoptions'] = 'Επιλογές προσπάθειας';
$string['availableq'] = 'Διαθέσιμο;';
$string['badbase'] = 'Λάθος βάση προτού **: {$a}**';
$string['behaviour'] = 'Συμπεριφορά';
$string['behaviourbeingused'] = 'Συμπεριφορά που χρησιμοποιείται: {$a}';
$string['broken'] = 'Αυτός είναι ένας «χαλασμένος σύνδεσμος», δείχνει σε ένα αρχείο που δεν υπάρχει.';
$string['byandon'] = 'από <em>{$a->user}</em> στις <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Αποτυχία αντιγραφής αρχείου αντιγράφου ασφαλείας';
$string['cannotcreate'] = 'Αποτυχία δημιουργίας νέας καταχώρησης στον πίνακα question_attempts';
$string['cannotcreatepath'] = 'Αδυναμία δημιουργίας διαδρομής: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Δεν μπορείτε να διαγράψετε τη συμπεριφορά «{$a}». Χρησιμοποιείται από τις προσπάθειες ερωτήσεων.';
$string['cannotdeletecate'] = 'Δεν μπορείτε να διαγράψετε αυτή την κατηγορία καθώς είναι η προεπιλεγμένη κατηγορία για αυτό το πλαίσιο.';
$string['cannotdeleteneededbehaviour'] = 'Δεν είναι δυνατή η διαγραφή της συμπεριφοράς ερωτήματος «{$a}». Υπάρχουν άλλες συμπεριφορές που βασίζονται σε αυτή.';
$string['cannotdeleteqtypeinuse'] = 'Δεν μπορείτε να διαγράψετε τον τύπο ερώτησης «{$a}». Υπάρχουν ερωτήσεις αυτού του τύπου στην τράπεζα ερωτήσεων.';
$string['cannotdeleteqtypeneeded'] = 'Δεν μπορείτε να διαγράψετε τον τύπο ερώτησης «{$a}». Υπάρχουν εγκατεστημένοι τύποι ερωτήσεων που βασίζονται σε αυτόν.';
$string['cannotdeletetopcat'] = 'Οι ανώτατες κατηγορίες δεν μπορούν να διαγραφούν.';
$string['cannotedittopcat'] = 'Οι ανώτατες κατηγορίες δεν μπορούν να τροποποιηθούν.';
$string['cannotenable'] = 'Ο τύπος ερώτησης {$a} δεν μπορεί να δημιουργηθεί απευθείας.';
$string['cannotenablebehaviour'] = 'Η συμπεριφορά ερωτήματος {$a} δεν μπορεί να χρησιμοποιηθεί άμεσα. Είναι μόνο για εσωτερική χρήση.';
$string['cannotfindcate'] = 'Αποτυχία εύρεσης εγγραφής κατηγορίας';
$string['cannotfindquestionfile'] = 'Αποτυχία εύρεσης αρχείου δεδομένων ερώτησης στο zip';
$string['cannotgetdsfordependent'] = 'Αδυναμία λήψης του ορισμένου συνόλου δεδομένων για μια ερώτηση εξαρτώμενη από σύνολο δεδομένων! (ερώτηση: {$a->id}, στοιχείο συνόλου δεδομένων: {$a->item})';
$string['cannotgetdsforquestion'] = 'Αδυναμία λήψης του ορισμένου συνόλου δεδομένων για μια υπολογισμένη ερώτηση! (ερώτηση: {$a})';
$string['cannothidequestion'] = 'Αποτυχία απόκρυψης της ερώτησης';
$string['cannotimportformat'] = 'Λυπόμαστε, η εισαγωγή αυτής της μορφής δεν είναι ακόμα υλοποιημένη!';
$string['cannotinsertquestion'] = 'Αποτυχία εισαγωγής νέας ερώτησης!';
$string['cannotinsertquestioncatecontext'] = 'Δεν ήταν δυνατή η εισαγωγή της νέας κατηγορίας ερωτήσεων {$a->cat} λόγω λανθασμένου αναγνωριστικού πλαισίου {$a->ctx}';
$string['cannotloadquestion'] = 'Αποτυχία φόρτωσης ερώτησης';
$string['cannotmovequestion'] = 'Δεν μπορείτε να χρησιμοποιήσετε αυτό το σενάριο για να μετακινήσετε ερωτήσεις που έχουν αρχεία συσχετισμένα με αυτές από διαφορετικές περιοχές.';
$string['cannotopenforwriting'] = 'Αδυναμία ανοίγματος για εγγραφή: {$a}';
$string['cannotpreview'] = 'Δεν μπορείτε να δείτε την προεπισκόπηση για αυτές τις ερωτήσεις!';
$string['cannotread'] = 'Αδυναμία ανάγνωσης εισαγόμενου αρχείου (ή το αρχείο είναι κενό)';
$string['cannotretrieveqcat'] = 'Αποτυχία εύρεσης της κατηγορίας ερωτήσεων';
$string['cannotunhidequestion'] = 'Αποτυχία επανεμφάνισης της ερώτησης.';
$string['cannotunzip'] = 'Αποτυχία αποσυμπίεσης του αρχείου.';
$string['cannotwriteto'] = 'Αδυναμία εγγραφής των εξαγόμενων ερωτήσεων στο {$a}';
$string['categories'] = 'Κατηγορίες';
$string['category'] = 'Κατηγορία';
$string['categorycurrent'] = 'Τρέχουσα κατηγορία';
$string['categorycurrentuse'] = 'Χρήση αυτής της κατηγορίας';
$string['categorydoesnotexist'] = 'Αυτή η κατηγορία δεν υπάρχει';
$string['categoryinfo'] = 'Πληροφορίες κατηγορίας';
$string['categorymove'] = 'Η κατηγορία «{$a->name}» περιλαμβάνει {$a->count} ερωτήσεις (κάποιες μπορεί να είναι παλιές, κρυμμένες, ερωτήσεις που χρησιμοποιούνται ακόμα σε υπάρχοντα κουίζ). Παρακαλούμε, επιλέξτε άλλη κατηγορία για να τις μετακινήσετε.';
$string['categorymoveto'] = 'Αποθήκευση στην κατηγορία';
$string['categorynamecantbeblank'] = 'Το όνομα κατηγορίας δεν μπορεί να είναι κενό.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Αλλαγή επιλογών';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Η κατηγορία «{$a->name}»</a> στο μάθημα «{$a->coursename}» θα έχει την κατάσταση διαμοιρασμού του αλλαγμένη από <strong>«{$a->changefrom}» σε «{$a->changeto}»</strong>.';
$string['check'] = 'Έλεγχος';
$string['chooseqtypetoadd'] = 'Επιλέξτε έναν τύπο ερώτησης για να προσθέσετε';
$string['clearwrongparts'] = 'Καθαρισμός λανθασμένων αποκρίσεων';
$string['clickflag'] = 'Σημαιοδότηση ερώτησης';
$string['clicktoflag'] = 'Σημαιοδότηση ερώτησης για μελλοντική αναφορά';
$string['clicktounflag'] = 'Αφαίρεση σημαιοδότησης';
$string['clickunflag'] = 'Αφαίρεση σημαιοδότησης';
$string['closepreview'] = 'Κλείσιμο προεπισκόπησης';
$string['combinedfeedback'] = 'Συνδυασμένη ανατροφοδότηση';
$string['comment'] = 'Σχόλιο';
$string['commented'] = 'Σχολιάστηκε: {$a}';
$string['commentormark'] = 'Κάντε σχόλιο ή παρακάμψτε το βαθμό';
$string['comments'] = 'Σχόλια';
$string['commentx'] = 'Σχόλιο: {$a}';
$string['complete'] = 'Ολοκλήρωση';
$string['contexterror'] = 'Δεν θα έπρεπε να έχετε έρθει εδώ εάν δεν μετακινείτε μια κατηγορία σε ένα άλλο πλαίσιο.';
$string['copy'] = 'Αντιγραφή από {$a} και αλλαγή συνδέσμων.';
$string['correct'] = 'Σωστό';
$string['correctfeedback'] = 'Για κάθε σωστή απόκριση';
$string['correctfeedbackdefault'] = 'Η απάντησή σας είναι σωστή';
$string['created'] = 'Δημιουργήθηκε';
$string['createdby'] = 'Δημιουργήθηκε από';
$string['createdmodifiedheader'] = 'Δημιουργήθηκε / τελευταία αποθήκευση';
$string['createnewquestion'] = 'Δημιουργία νέας ερώτησης ...';
$string['cwrqpfs'] = 'Τυχαίες ερωτήσεις με επιλογή ερωτήσεων από υποκατηγορίες.';
$string['cwrqpfsinfo'] = '<p>Κατά την αναβάθμιση στο Moodle 1.9 θα διαχωρίσουμε τις κατηγορίες ερωτήσεων σε διαφορετικά πλαίσια. Κάποιες κατηγορίες ερωτήσεων και ερωτήσεις στον ιστότοπό σας θα πρέπει να αλλάξουν την κατάσταση διαμοιρασμού τους. Αυτό είναι απαραίτητο για την σπάνια περίπτωση όπου μια η περισσότερες «τυχαίες» ερωτήσεις σε ένα κουίζ είναι ρυθμισμένες να επιλέγουν από ένα μίγμα διαμοιραζόμενων και μη διαμοιραζόμενων κατηγοριών (όπως είναι η περίπτωση αυτού του ιστοτόπου). Αυτό συμβαίνει όταν μια «τυχαία» ερώτηση είναι ρυθμισμένη να επιλέγει από υποκατηγορίες και μια ή περισσότερες υποκατηγορίες έχουν διαφορετική κατάσταση διαμοιρασμού από την γονική κατηγορία στην οποία η τυχαία ερώτηση δημιουργήθηκε.</p><p>Οι ακόλουθες κατηγορίες ερωτήσεων, από τις οποίες οι «τυχαίες» ερωτήσεις σε γονικές κατηγορίες επιλέγουν ερωτήσεις, θα αλλάξουν την κατάσταση διαμοιρασμού τους στην ίδια με αυτή της κατηγορίας που έχει την «τυχαία» ερώτηση κατά την αναβάθμιση σε Moodle 1.9. Οι ακόλουθες κατηγορίες θα αλλάξουν την κατάσταση διαμοιρασμού τους. Οι ερωτήσεις που επηρεάζονται θα συνεχίσουν να δουλεύουν σε όλα τα υπάρχοντα κουίζ μέχρι να τις αφαιρέσετε από αυτά τα κουίζ.</p>';
$string['cwrqpfsnoprob'] = 'Καμία κατηγορία ερωτήσεων στον ιστότοπό σας δεν επηρεάζεται από το πρόβλημα «Τυχαίες ερωτήσεις με επιλογή ερωτήσεων από υποκατηγορίες».';
$string['decimalplacesingrades'] = 'Θέσεις δεκαδικών στους βαθμούς';
$string['defaultfor'] = 'Προεπιλογή για {$a}';
$string['defaultinfofor'] = 'Η προεπιλεγμένη κατηγορία για ερωτήσεις διαμοιρασμένες στο πλαίσιο «{$a}».';
$string['defaultmark'] = 'Προεπιλεγμένη βαθμολογία';
$string['defaultmarkmustbepositive'] = 'Η προεπιλεγμένη βαθμολογία πρέπει να είναι θετική.';
$string['deletecoursecategorywithquestions'] = 'Υπάρχουν ερωτήσεις στην τράπεζα ερωτήσεων συσχετισμένες με αυτή την κατηγορία μαθήματος. Εάν συνεχίσετε, θα διαγραφούν. Πιθανώς να θέλετε να τις μετακινήσετε πρώτα, χρησιμοποιώντας την διεπαφή της τράπεζας ερωτήσεων.';
$string['deletequestioncheck'] = 'Είστε απολύτως βέβαιοι ότι θέλετε να διαγραφεί η ερώτηση «{$a}»;';
$string['deletequestionscheck'] = '<p>Είστε απολύτως σίγουροι ότι θέλετε να διαγράψετε τις ακόλουθες ερωτήσεις;</p>
<p>{$a}</p>';
$string['deletingbehaviour'] = 'Διαγραφή συμπεριφοράς ερώτησης «{$a}»...';
$string['deletingqtype'] = 'Διαγραφή τύπου ερώτησης «{$a}»...';
$string['didnotmatchanyanswer'] = '[Δεν αντιστοιχήθηκε με καμία απάντηση]';
$string['disabled'] = 'Απενεργοποιημένη';
$string['displayoptions'] = 'Ρυθμίσεις προβολής';
$string['disterror'] = 'Η διανομή {$a} δημιούργησε προβλήματα';
$string['donothing'] = 'Μην αντιγράφετε η μετακινείτε αρχεία ή πραγματοποιείτε αλλαγή συνδέσμων.';
$string['editcategories'] = 'Επεξεργασία κατηγοριών';
$string['editcategories_help'] = 'Αντί να διατηρούνται όλες σε μια μεγάλη λίστα, οι ερωτήσεις μπορούν να τακτοποιούνται σε κατηγορίες και υποκατηγορίες.

Κάθε κατηγορία έχει ένα πλαίσιο που καθορίζει που μπορούν να χρησιμοποιηθούν οι ερωτήσεις της κατηγορίας:

* Πλαίσιο δραστηριότητας - Ερωτήσεις διαθέσιμες μόνο στο άρθρωμα δραστηριότητας
* Πλαίσιο μαθήματος - Ερωτήσεις διαθέσιμες σε όλα τα αρθρώματα δραστηριοτήτων στο μάθημα
* Πλαίσιο κατηγορίας μαθήματος - Ερωτήσεις διαθέσιμες σε όλα τα αρθρώματα δραστηριοτήτων και τα μαθήματα της κατηγορίας.
* Πλαίσιο συστήματος - Ερωτήσεις διαθέσιμες σε όλα τα μαθήματα και τις δραστηριότητες στον ιστότοπο

Οι κατηγορίες χρησιμοποιούνται επίσης για τυχαίες ερωτήσεις, καθώς οι ερωτήσεις αυτές επιλέγονται από μια τυχαία κατηγορία.';
$string['editcategories_link'] = 'ερώτηση/κατηγορία';
$string['editcategory'] = 'Επεξεργασία κατηγορίας';
$string['editingcategory'] = 'Επεξεργασία μιας κατηγορίας';
$string['editingquestion'] = 'Επεξεργασία μιας ερώτησης';
$string['editquestion'] = 'Επεξεργασία ερώτησης';
$string['editquestions'] = 'Επεξεργασία ερωτήσεων';
$string['editthiscategory'] = 'Επεξεργασία κατηγορίας';
$string['emptyxml'] = 'Άγνωστο σφάλμα  -  Κενό imsmanifest.xml';
$string['enabled'] = 'Ενεργοποιημένο';
$string['erroraccessingcontext'] = 'Αδυναμία πρόσβασης στο πλαίσιο';
$string['errordeletingquestionsfromcategory'] = 'Σφάλμα κατά τη διαγραφή των ερωτήσεων από την κατηγορία {$a}.';
$string['errorduringpost'] = 'Σφάλμα κατά την μετά-επεξεργασία!';
$string['errorduringpre'] = 'Σφάλμα κατά την προ-επεξεργασία!';
$string['errorduringproc'] = 'Σφάλμα κατά την επεξεργασία!';
$string['errorduringregrade'] = 'Αποτυχία επαναβαθμολόγησης της ερώτησης {$a->qid}, μετάβαση στην κατάσταση {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Σφάλμα: αποτυχία αντιγραφής του αρχείου {$a}.';
$string['errorfilecannotbemoved'] = 'Σφάλμα: αποτυχία μετακίνησης του αρχείου {$a}.';
$string['errorfileschanged'] = 'Σφάλμα: αρχεία συνδεδεμένα με ερωτήσεις έχουν τροποποιηθεί από τότε που εμφανίστηκε η φόρμα.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Η ερώτηση «{$a}» εμφανίζεται πάνω από μια φορά με διαφορετικούς συντελεστές βαρύτητας σε διαφορετικά σημεία του τεστ. Αυτό δεν υποστηρίζεται προς το παρόν από την αναφορά στατιστικών και μπορεί να κάνει τα στατιστικά για αυτή την ερώτηση αναξιόπιστα.';
$string['errormanualgradeoutofrange'] = 'Ο βαθμός {$a->grade} δεν είναι μεταξύ 0 και {$a->maxgrade} για την ερώτηση {$a->name}. Το σκορ και το σχόλιο δεν έχουν αποθηκευθεί.';
$string['errormovingquestions'] = 'Σφάλμα κατά την μετακίνηση ερωτήσεων με αναγνωριστικά {$a}.';
$string['errorpostprocess'] = 'Σφάλμα κατά την μετα-επεξεργασία!';
$string['errorpreprocess'] = 'Σφάλμα κατά την προ-επεξεργασία!';
$string['errorprocess'] = 'Σφάλμα κατά την επεξεργασία!';
$string['errorprocessingresponses'] = 'Συνέβη ένα σφάλμα κατά την επεξεργασία των αποκρίσεών σας. ({$a}). Κάντε κλικ στο κουμπί «Συνέχεια» για να επιστρέψετε στη σελίδα στην οποία βρισκόσασταν και δοκιμάστε ξανά.';
$string['errorsavingcomment'] = 'Σφάλμα αποθήκευσης του σχόλιου για την ερώτηση {$a->name} στην βάση δεδομένων.';
$string['errorsavingflags'] = 'Σφάλμα κατά την αποθήκευση της κατάστασης της σημαιοδότησης.';
$string['errorupdatingattempt'] = 'Σφάλμα ενημέρωσης της προσπάθειας {$a->id} στην βάση δεδομένων.';
$string['eventquestioncategorycreated'] = 'Η κατηγορία ερωτήσεων δημιουργήθηκε';
$string['eventquestioncategorydeleted'] = 'Η κατηγορία ερώτησης διαγράφηκε';
$string['eventquestioncategorymoved'] = 'Η κατηγορία ερώτησης μετακινήθηκε';
$string['eventquestioncategoryupdated'] = 'Η κατηγορία ερώτησης ενημερώθηκε';
$string['eventquestioncategoryviewed'] = 'Η κατηγορία ερώτησης προβλήθηκε';
$string['eventquestioncreated'] = 'Η ερώτηση δημιουργήθηκε';
$string['eventquestiondeleted'] = 'Η ερώτηση διαγράφηκε';
$string['eventquestionmoved'] = 'Η ερώτηση μετακινήθηκε';
$string['eventquestionsexported'] = 'Ερωτήσεις που εξήχθησαν';
$string['eventquestionsimported'] = 'Ερωτήσεις που έχουν εισαχθεί';
$string['eventquestionupdated'] = 'Η ερώτηση ενημερώθηκε';
$string['eventquestionviewed'] = 'Η ερώτηση προβλήθηκε';
$string['export'] = 'Εξαγωγή';
$string['exportasxml'] = 'Εξαγωγή ως Moodle XML';
$string['exportcategory'] = 'Εξαγωγή κατηγορίας';
$string['exportcategory_help'] = 'Αυτή η ρύθμιση καθορίζει την κατηγορία από την οποία θα αντληθούν οι εξαγόμενες ερωτήσεις.

Ορισμένες μορφές εισαγωγής, όπως το GIFT και το Moodle XML, επιτρέπουν την συμπερίληψη δεδομένων κατηγορίας και πλαισίου στο αρχείο εξαγωγής, επιτρέποντάς τους (προαιρετικά) να επαναδημιουργηθούν κατά την εισαγωγή. Εάν απαιτείται, πρέπει να επιλεγούν τα κατάλληλα πλαίσια ελέγχου.';
$string['exporterror'] = 'Σφάλματα συνέβησαν κατά την εξαγωγή!';
$string['exportfilename'] = 'ερωτήσεις';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Λήψη αυτής της ερώτησης σε μορφότυπο Moodle XML';
$string['exportquestions'] = 'Εξαγωγή ερωτήσεων σε αρχείο';
$string['exportquestions_help'] = 'Αυτή η λειτουργία επιτρέπει την εξαγωγή μιας πλήρους κατηγορίας (και όλων των υποκατηγοριών) ερωτήσεων σε αρχείο. Έχετε υπόψη ότι, ανάλογα με την επιλεγμένη μορφή αρχείου, ενδέχεται να μην είναι εφικτή η εξαγωγή ορισμένων δεδομένων ερωτήσεων και συγκεκριμένων τύπων ερωτήσεων.';
$string['exportquestions_link'] = 'ερώτηση/εξαγωγή';
$string['feedback'] = 'Ανατροφοδότηση';
$string['filecantmovefrom'] = 'Τα αρχεία ερωτήσεων δεν μπορούν να μεταφερθούν διότι δεν έχετε δικαίωμα διαγραφής αρχείων στην θέση από την οποία προσπαθείτε να μεταφέρετε αρχεία.';
$string['filecantmoveto'] = 'Τα αρχεία ερωτήσεων δεν μπορούν να μεταφερθούν διότι δεν έχετε δικαίωμα προσθήκης αρχείων στην θέση στην οποία προσπαθείτε να μεταφέρετε αρχεία.';
$string['fileformat'] = 'Μορφότυπος αρχείου';
$string['filesareacourse'] = 'η περιοχή αρχείων μαθήματος';
$string['filesareasite'] = 'η περιοχή αρχείων του ιστοτόπου';
$string['filestomove'] = 'Μετακίνηση / αντιγραφή αρχείων σε {$a};';
$string['fillincorrect'] = 'Συμπληρώστε με σωστές αποκρίσεις';
$string['filterbytags'] = 'Φιλτράρισμα κατά ετικέτες...';
$string['firsttry'] = 'Πρώτη προσπάθεια';
$string['flagged'] = 'Σημαιοδοτημένη';
$string['flagthisquestion'] = 'Σημαιοδότηση αυτής της ερώτησης';
$string['formquestionnotinids'] = 'Η φόρμα περιείχε μια ερώτηση που δεν βρίσκεται στον πίνακα questionids (με τα ονόματα των ερωτήσεων)';
$string['fractionsnomax'] = 'Μια από τις απαντήσεις θα πρέπει να έχει σκορ 100% ώστε να είναι δυνατόν να λάβετε την πλήρη βαθμολογία για αυτή την ερώτηση.';
$string['generalfeedback'] = 'Γενική ανατροφοδότηση';
$string['generalfeedback_help'] = 'Η γενική ανατροφοδότηση εμφανίζεται στον μαθητή αφού ολοκληρώσει την ερώτηση. Αντίθετα από την ανατροφοδότηση ερώτησης, που εξαρτάται από τον τύπο της ερώτησης και τι απόκριση έδωσε ο μαθητής, εδώ το ίδιο κείμενο γενικής ανατροφοδότησης εμφανίζεται σε όλους τους μαθητές. Μπορείτε να χρησιμοποιήσετε την γενική ανατροφοδότηση για να δώσετε στους μαθητές μια πλήρως δουλεμένη απάντηση και ίσως ένα σύνδεσμο προς περισσότερες πληροφορίες που μπορούν να χρησιμοποιήσουν αν δεν καταλάβουν τις ερωτήσεις.';
$string['getcategoryfromfile'] = 'Λήψη κατηγορίας από αρχείο';
$string['getcontextfromfile'] = 'Λήψη πλαισίου από αρχείο';
$string['hintn'] = 'Υπόδειξη {no}';
$string['hintnoptions'] = 'Επιλογές υπόδειξης {no}';
$string['hinttext'] = 'Κείμενο υπόδειξης';
$string['howquestionsbehave'] = 'Πώς συμπεριφέρονται οι ερωτήσεις';
$string['howquestionsbehave_help'] = 'Οι μαθητές μπορούν να αλληλεπιδράσουν με τις ερωτήσεις στο κουίζ με διάφορους ποικίλους τρόπους. Για παράδειγμα, μπορεί να επιθυμείτε οι μαθητές να δώσουν απάντηση σε κάθε ερώτηση και μετά να υποβάλουν ολόκληρο το κουίζ, πριν οτιδήποτε βαθμολογηθεί ή πριν πάρουν οποιαδήποτε ανατροφοδότηση. Αυτή είναι η κατάσταση λειτουργίας «Αναβαλλόμενη ανατροφοδότηση». Εναλλακτικά, μπορεί να επιθυμείτε οι μαθητές να υποβάλουν κάθε ερώτηση μόλις την απαντήσουν ώστε να πάρουν άμεση ανατροφοδότηση, και αν δεν απαντήσουν σωστά αμέσως να ξαναπροσπαθήσουν για λιγότερους βαθμούς. Αυτή είναι η κατάσταση λειτουργίας «Διαδραστική με πολλές προσπάθειες». Αυτές είναι πιθανά οι δύο πιο χρησιμοποιούμενες καταστάσεις λειτουργίας.';
$string['howquestionsbehave_link'] = 'ερώτηση/συμπεριφορά';
$string['idnumber'] = 'Αναγνωριστικός αριθμός';
$string['idnumber_help'] = 'Εάν χρησιμοποιείται, ο αναγνωριστικός αριθμός πρέπει να είναι μοναδικός μέσα σε κάθε κατηγορία ερωτήσεων. Το πεδίο αυτό παρέχει έναν άλλο τρόπο προσδιορισμού μιας ερώτησης και είναι μερικές φορές χρήσιμο, αλλά συνήθως μπορεί να αφεθεί κενό.';
$string['ignorebroken'] = 'Αγνόηση χαλασμένων συνδέσμων';
$string['import'] = 'Εισαγωγή';
$string['importcategory'] = 'Κατηγορία εισαγωγής';
$string['importcategory_help'] = 'Αυτή η ρύθμιση καθορίζει την κατηγορία στην οποία θα προστεθούν οι ερωτήσεις που έχουν εισαχθεί.

Ορισμένες μορφές εισαγωγής, όπως το GIFT και το Moodle XML, ενδέχεται να περιλαμβάνουν δεδομένα κατηγορίας και περιβάλλοντος στο αρχείο εισαγωγής. Για να χρησιμοποιήσετε αυτά τα δεδομένα, αντί για την επιλεγμένη κατηγορία, θα πρέπει να επιλέξετε τα κατάλληλα πλαίσια ελέγχου. Εάν δεν υπάρχουν οι κατηγορίες που έχουν καθοριστεί στο αρχείο εισαγωγής, θα δημιουργηθούν.';
$string['importerror'] = 'Παρουσιάστηκε σφάλμα κατά την επεξεργασία εισαγωγής';
$string['importerrorquestion'] = 'Σφάλμα κατά την εισαγωγή ερώτησης';
$string['importfromcoursefiles'] = '... ή επιλέξτε ένα αρχείο μαθήματος για εισαγωγή.';
$string['importfromupload'] = 'Επιλέξτε ένα αρχείο για ανέβασμα ...';
$string['importingquestions'] = 'Εισαγωγή ερωτημάτων {$a} από αρχείο';
$string['importparseerror'] = 'Παρουσιάστηκε σφάλμα(τα) κατά την ανάλυση του αρχείου εισαγωγής. Δεν έχουν εισαχθεί ερωτήσεις. Για να εισαγάγετε τυχόν καλές ερωτήσεις, προσπαθήστε ξανά να ορίζοντας τη ρύθμιση «Διακοπή σε περίπτωση σφάλματος» σε «Όχι».';
$string['importquestions'] = 'Εισαγωγή ερωτήσεων από αρχείο';
$string['importquestions_help'] = 'Αυτή η λειτουργία επιτρέπει την εισαγωγή ερωτήσεων σε διάφορες μορφές μέσω αρχείου κειμένου. Σημειώστε ότι το αρχείο πρέπει να χρησιμοποιεί κωδικοποίηση UTF-8.';
$string['importquestions_link'] = 'ερώτηση/εισαγωγή';
$string['importwrongfiletype'] = 'Ο τύπος του αρχείου που επιλέξατε ({$a->actualtype}) δεν αντιστοιχεί στον τύπο που αναμένεται από αυτόν τον μορφότυπο εισαγωγής ({$a->expectedtype}).';
$string['impossiblechar'] = 'Ο λάθος χαρακτήρας {$a} εντοπίστηκε σαν χαρακτήρας παρένθεσης';
$string['includesubcategories'] = 'Εμφάνιση επίσης των ερωτήσεων από τις υποκατηγορίες';
$string['incorrect'] = 'Λανθασμένη';
$string['incorrectfeedback'] = 'Για κάθε λανθασμένη απόκριση';
$string['incorrectfeedbackdefault'] = 'Η απάντησή σας είναι λανθασμένη.';
$string['information'] = 'Πληροφορίες';
$string['invalidanswer'] = 'Ημιτελής απάντηση';
$string['invalidarg'] = 'Δόθηκαν μη έγκυρα ορίσματα ή ο εξυπηρετητής έχει λανθασμένες ρυθμίσεις';
$string['invalidcategoryidforparent'] = 'Μη έγκυρο αναγνωριστικό κατηγορίας για γονέα!';
$string['invalidcategoryidtomove'] = 'Μη έγκυρο αναγνωριστικό κατηγορίας για μετακίνηση!';
$string['invalidconfirm'] = 'Η συμβολοσειρά επιβεβαίωσης ήταν λανθασμένη';
$string['invalidcontextinhasanyquestions'] = 'Μη έγκυρο πλαίσιο περάστηκε στο question_context_has_any_questions.';
$string['invalidgrade'] = 'Οι βαθμοί ({$a}) δεν ταιριάζουν με τις επιλογές βαθμού - η ερώτηση έχει παραλειφθεί.';
$string['invalidpenalty'] = 'Μη έγκυρη ποινή';
$string['invalidwizardpage'] = 'Ορίστηκε λανθασμένη ή καθόλου σελίδα αυτόματου οδηγού!';
$string['lastmodifiedby'] = 'Τελευταία τροποποίηση από';
$string['lasttry'] = 'Τελευταία προσπάθεια';
$string['linkedfiledoesntexist'] = 'Το συνδεδεμένο αρχείο {$a} δεν υπάρχει';
$string['makechildof'] = 'Ορισμός ως παιδί του «{$a}»';
$string['makecopy'] = 'Δημιουργία αντιγράφου';
$string['maketoplevelitem'] = 'Μετακίνηση στο ανώτατο επίπεδο';
$string['manualgradeinvalidformat'] = 'Αυτός δεν είναι ένας έγκυρος αριθμός.';
$string['manualgradeoutofrange'] = 'Αυτός ο βαθμός είναι εκτός των ορίων του έγκυρου διαστήματος.';
$string['manuallygraded'] = 'Βαθμολογήθηκε χειροκίνητα {$a->mark} με σχόλιο: {$a->comment}';
$string['mark'] = 'Βαθμός';
$string['markedoutof'] = 'Βαθμολογήθηκε στα';
$string['markedoutofmax'] = 'Βαθμολογήθηκε στα {$a}';
$string['markoutofmax'] = 'Βαθμολογήθηκε {$a->mark} στα {$a->max}';
$string['marks'] = 'Βαθμοί';
$string['matchgrades'] = 'Αντιστοίχιση βαθμών';
$string['matchgrades_help'] = 'Οι εισαγόμενοι βαθμοί πρέπει να ταιριάζουν με έναν (βαθμό) από τους σταθερούς πίνακες έγκυρων βαθμών - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (επίσης αρνητικές τιμές).

Εάν όχι, υπάρχουν δύο επιλογές:

* Σφάλμα αν ο βαθμός δεν υπάρχει στη λίστα - Εάν μια ερώτηση περιέχει βαθμούς που δεν βρίσκονται στη λίστα εμφανίζεται ένα σφάλμα και αυτή η ερώτηση δεν θα εισαχθεί
* Πλησιέστερος βαθμός αν δεν υπάρχει στη λίστα - Αν διαπιστωθεί ότι ο βαθμός δεν ταιριάζει με καμιά τιμή στη λίστα, ο βαθμός αλλάζει στην πλησιέστερη τιμή που ταιριάζει στη λίστα';
$string['matchgradeserror'] = 'Σφάλμα αν ο βαθμός δεν υπάρχει στη λίστα';
$string['matchgradesnearest'] = 'Πλησιέστερος βαθμός αν δεν υπάρχει στη λίστα';
$string['missingcourseorcmid'] = 'Χρειάζεται να δοθεί το courseid ή το cmid στο print_question.';
$string['missingcourseorcmidtolink'] = 'Χρειάζεται να δοθεί το courseid ή το cmid στο get_question_edit_link.';
$string['missingimportantcode'] = 'Από αυτόν τον τύπο ερώτησης λείπει σημαντικός κώδικας: {$a}.';
$string['missingoption'] = 'Από την ερώτηση συμπλήρωσης κενών «{$a}» λείπουν οι επιλογές της';
$string['modified'] = 'Τελευταία αποθήκευση';
$string['move'] = 'Μετακίνηση από {$a} και αλλαγή συνδέσμων.';
$string['movecategory'] = 'Μετακίνηση κατηγορίας';
$string['movedquestionsandcategories'] = 'Μετακινήθηκαν οι ερωτήσεις και οι κατηγορίες ερωτήσεων από το {$a->oldplace} στο {$a->newplace}.';
$string['movelinksonly'] = 'Απλή αλλαγή του σημείου που δείχνουν οι σύνδεσμοι, χωρίς μετακίνηση ή αντιγραφή των αρχείων.';
$string['moveq'] = 'Μετακίνηση ερώτησης/-ήσεων';
$string['moveqtoanothercontext'] = 'Μετακίνηση ερώτησης σε άλλο πλαίσιο.';
$string['moveto'] = 'Μετακίνηση σε >>';
$string['movingcategory'] = 'Μετακίνηση κατηγορίας...';
$string['movingcategoryandfiles'] = 'Είστε σίγουροι ότι θέλετε να μετακινήσετε την κατηγορία {$a->name} και όλες τις υπο-κατηγορίες στο πλαίσιο για «{$a->contextto}»;<br /> Εντοπίσαμε {$a->urlcount} αρχεία συνδεδεμένα με ερωτήσεις στο {$a->fromareaname}. Θέλετε να τα αντιγράψετε ή να τα μετακινήσετε στο {$a->toareaname};';
$string['movingcategorynofiles'] = 'Είστε σίγουροι ότι θέλετε να μετακινήσετε την κατηγορία «{$a->name}» και όλες τις κατηγορίες-παιδιά στο πλαίσιο για «{$a->contextto}»;';
$string['movingquestions'] = 'Μετακίνηση ερωτήσεων και οποιωνδήποτε αρχείων';
$string['movingquestionsandfiles'] = 'Είστε σίγουροι ότι θέλετε να μετακινήσετε την ερώτηση(εις) {$a->questions} στο πλαίσιο για <strong>«{$a->tocontext}»</strong>;<br /> Εντοπίσαμε <strong>{$a->urlcount} αρχεία</strong> συνδεδεμένα με αυτή την ερώτηση(εις) στο {$a->fromareaname}. Θέλετε να τα αντιγράψετε ή να τα μετακινήσετε στο {$a->toareaname};';
$string['movingquestionsnofiles'] = 'Είστε σίγουροι ότι θέλετε να μετακινήσετε την ερώτηση(εις) {$a->questions} στο πλαίσιο για <strong>«{$a->tocontext}»</strong>;<br /> Δεν υπάρχουν <strong>αρχεία</strong> συνδεδεμένα με αυτήν την ερώτηση/-εις στο {$a->fromareaname}.';
$string['needtochoosecat'] = 'Πρέπει να επιλέξετε μια κατηγορία για να μετακινήσετε αυτή την ερώτηση ή πατήστε «άκυρο».';
$string['nocate'] = 'Δεν υπάρχει αυτή η κατηγορία {$a}!';
$string['nopermissionadd'] = 'Δεν έχετε δικαίωμα να προσθέσετε ερωτήσεις εδώ.';
$string['nopermissionmove'] = 'Δεν έχετε δικαίωμα να μετακινήσετε ερωτήσεις από εδώ. Πρέπει να αποθηκεύσετε την ερώτηση σε αυτή την κατηγορία ή να την σώσετε σαν νέα ερώτηση.';
$string['noprobs'] = 'Δεν βρέθηκαν προβλήματα στην βάση δεδομένων με τις ερωτήσεις σας.';
$string['noquestions'] = 'Δεν βρέθηκαν ερωτήσεις που θα μπορούσαν να εξαχθούν. Βεβαιωθείτε ότι έχετε επιλέξει μια κατηγορία για εξαγωγή που περιέχει ερωτήσεις.';
$string['noquestionsinfile'] = 'Δεν υπάρχουν ερωτήσεις στο εισαγόμενο αρχείο';
$string['noresponse'] = '[Καμία απόκριση]';
$string['notagfiltersapplied'] = 'Δεν εφαρμόστηκαν φίλτρα ετικέτας';
$string['notanswered'] = 'Δεν απαντήθηκε';
$string['notchanged'] = 'Δεν άλλαξε από την τελευταία προσπάθεια';
$string['notenoughanswers'] = 'Αυτός ο τύπος ερώτησης απαιτεί τουλάχιστον {$a} απαντήσεις';
$string['notenoughdatatoeditaquestion'] = 'Δεν ορίστηκε ούτε ένα αναγνωριστικό ερώτησης, ούτε ένα αναγνωριστικό κατηγορίας και τύπος ερώτησης.';
$string['notenoughdatatomovequestions'] = 'Πρέπει να παρέχετε τα αναγνωριστικά των ερωτήσεων που θέλετε να μετακινήσετε.';
$string['notflagged'] = 'Μη σημαιοδοτημένη';
$string['notgraded'] = 'Χωρίς βαθμό';
$string['notshown'] = 'Δεν προβλήθηκε';
$string['notyetanswered'] = 'Δεν έχει απαντηθεί ακόμα';
$string['notyourpreview'] = 'Αυτή η προεπισκόπηση δεν σας ανήκει';
$string['novirtualquestiontype'] = 'Χωρίς εικονικό τύπο ερώτησης για τον τύπο ερώτησης {$a}';
$string['numqas'] = 'Αριθμός προσπαθειών ερωτήσεων';
$string['numquestions'] = 'Αριθμός ερωτήσεων';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} κρυμμένες)';
$string['options'] = 'Επιλογές';
$string['page-question-category'] = 'Σελίδα κατηγορίας ερωτήσεων';
$string['page-question-edit'] = 'Σελίδα επεξεργασίας ερωτήσεων';
$string['page-question-export'] = 'Σελίδα εξαγωγής ερωτήσεων';
$string['page-question-import'] = 'Σελίδα εισαγωγής ερωτήσεων';
$string['page-question-x'] = 'Οποιαδήποτε σελίδα ερωτήσεων';
$string['parent'] = 'Γονέας';
$string['parentcategory'] = 'Γονική κατηγορία';
$string['parentcategory_help'] = 'Η γονική κατηγορία είναι εκείνη στην οποία θα τοποθετηθεί η νέα κατηγορία. «Top» σημαίνει ότι αυτή η κατηγορία δεν περιλαμβάνεται σε καμία άλλη κατηγορία. Τα πλαίσια κατηγοριών εμφανίζονται με έντονα γράμματα. Πρέπει να υπάρχει τουλάχιστον μία κατηγορία σε κάθε πλαίσιο.';
$string['parentcategory_link'] = 'ερώτηση/κατηγορία';
$string['parenthesisinproperclose'] = 'Η παρένθεση πριν το ** δεν είναι σωστά κλεισμένη στο {$a}**';
$string['parenthesisinproperstart'] = 'Η παρένθεση πριν ** δεν είναι σωστά ανοιγμένη στο {$a}**';
$string['parsingquestions'] = 'Ανάλυση ερωτήσεων από αρχείο εισαγωγής.';
$string['partiallycorrect'] = 'Μερικώς σωστή';
$string['partiallycorrectfeedback'] = 'Για κάθε μερικώς σωστή απόκριση';
$string['partiallycorrectfeedbackdefault'] = 'Η απάντηση είναι μερικώς σωστή.';
$string['penaltyfactor'] = 'Παράγοντας ποινής';
$string['penaltyfactor_help'] = 'Μπορείτε να ορίσετε ένα κλάσμα του πλήρους σκορ κάθε ερώτησης που θα αφαιρείται για κάθε λάθος απάντηση. Η δυνατότητα αυτή έχει νόημα μόνο αν το κουίζ είναι ρυθμισμένο να λειτουργεί σε προσαρμοστικό περιβάλλον, επιτρέποντας στους μαθητές να κάνουν επαναλαμβανόμενες προσπάθειες σε κάθε ερώτηση. Ο συντελεστής ποινής πρέπει να είναι αριθμός ανάμεσα στο 0 και στο 1. Συντελεστής 1 σημαίνει ότι ο μαθητής πρέπει να απαντήσει σωστά στην πρώτη απόκριση για να κερδίσει τους βαθμούς της ερώτησης. Συντελεστής 0 σημαίνει ότι ο μαθητής μπορεί να δοκιμάσει όσες φορές θέλει μέχρι να βρει τη σωστή απάντηση, οπότε θα πάρει και τη μέγιστη δυνατή βαθμολογία.';
$string['penaltyforeachincorrecttry'] = 'Ποινή για κάθε λανθασμένη προσπάθεια';
$string['penaltyforeachincorrecttry_help'] = 'Όταν εκτελείτε τις ερωτήσεις σας χρησιμοποιώντας την συμπεριφορά «Διαδραστική με πολλαπλές προσπάθειες» ή την τακτική «Προσαρμοστική λειτουργία», έτσι ώστε ο μαθητής να επιτρέπεται να κάνει αρκετές προσπάθειες για να βρει την σωστή απάντηση, τότε αυτή η επιλογή ελέγχει το πόσο τιμωρείται για κάθε λανθασμένη προσπάθεια.

Η ποινή είναι μια αναλογία (ένα ποσοστό) του συνολικού βαθμού της ερώτησης. Έτσι αν η ερώτηση αξίζει τρεις βαθμούς και η ποινή είναι 0.3333333, τότε ο μαθητής θα σκοράρει 3 αν απαντήσει την ερώτηση σωστά με την πρώτη προσπάθεια, 2 αν την απαντήσει σωστά στη δεύτερη προσπάθεια και 1 αν την απαντήσει σωστά στην τρίτη προσπάθεια.

Για κάποιες ερωτήσεις με πολλά σκέλη, αυτή η λογική βαθμολόγησης εφαρμόζεται χωριστά σε κάθε σκέλος της ερώτησης. Οι λεπτομέρειες εξαρτώνται από τον τύπο ερωτήματος και μπορεί να είναι περίπλοκες, αλλά η αρχή είναι να δώσουμε στους μαθητές αναγνώριση/έπαινο για τις γνώσεις που έχουν επιδείξει, όσο το δυνατόν πιο δίκαια.';
$string['permissionedit'] = 'Επεξεργασία αυτής της ερώτησης';
$string['permissionmove'] = 'Μετακίνηση αυτής της ερώτησης';
$string['permissionsaveasnew'] = 'Αποθήκευση αυτής σαν μια νέα ερώτηση';
$string['permissionto'] = 'Έχετε δικαίωμα να :';
$string['previewquestion'] = 'Προεπισκόπηση ερώτησης: {$a}';
$string['privacy:metadata:database:question'] = 'Οι λεπτομέρειες για μία συγκεκριμένη ερώτηση.';
$string['privacy:metadata:database:question:createdby'] = 'Το άτομο που δημιούργησε την ερώτηση.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Η γενική ανατροφοδότηση για αυτήν την ερώτηση.';
$string['privacy:metadata:database:question:modifiedby'] = 'Το άτομο που ενημέρωσε τελευταίο την ερώτηση.';
$string['privacy:metadata:database:question:name'] = 'Το όνομα της ερώτησης.';
$string['privacy:metadata:database:question:questiontext'] = 'Το κείμενο ερώτησης.';
$string['privacy:metadata:database:question:timecreated'] = 'Η ημερομηνία και η ώρα δημιουργίας αυτής της ερώτησης.';
$string['privacy:metadata:database:question:timemodified'] = 'Η ημερομηνία και η ώρα ενημέρωσης αυτής της ερώτησης.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Τα βήματα προσπάθειας ερωτήσεων ενδέχεται να έχουν επιπρόσθετα δεδομένα ειδικά/συγκεκριμένα για κάθε βήμα. Τα δεδομένα αποθηκεύονται στον πίνακα step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Το όνομα του στοιχείου δεδομένων.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Η αξία του στοιχείου δεδομένων.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Κάθε προσπάθεια ερωτήσεων έχει έναν αριθμό βημάτων που δείχνουν τις διάφορες φάσεις από την αρχή έως την ολοκλήρωση της βαθμολόγησης. Αυτός ο πίνακας αποθηκεύει τις πληροφορίες για κάθε ένα από αυτά τα βήματα.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Ο βαθμός που απονεμήθηκε σε αυτήν την προσπάθεια ερώτησης κλιμακώθηκε σε μια τιμή πέραν του 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Η κατάσταση αυτού του βήματος προσπάθειας της ερώτησης στο τέλος της μετάβασης βήματος.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Η ημερομηνία και η ώρα που ξεκίνησε αυτή η μετάβαση βήματος.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Ο χρήστης που πραγματοποίησε τη μετάβαση βήματος.';
$string['privacy:metadata:database:question_attempts'] = 'Οι πληροφορίες σχετικά με μια προσπάθεια μιας συγκεκριμένης ερώτησης.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Μια ένδειξη ότι ο χρήστης έχει σημαιοδοτήσει αυτή την ερώτηση κατά την προσπάθεια.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Μια περίληψη της απόκρισης στην ερώτηση.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Πότε ενημερώθηκε η προσπάθεια ερώτησης.';
$string['privacy:metadata:link:qbehaviour'] = 'Το υποσύστημα Ερώτησης κάνει χρήση του τύπου πρόσθετου «Συμπεριφορές Ερώτησης».';
$string['privacy:metadata:link:qformat'] = 'Το υποσύστημα Ερώτησης κάνει χρήση του τύπου πρόσθετου «Μορφότυποι εισαγωγής/εξαγωγής ερωτήσεων» για την εισαγωγή και την εξαγωγή ερωτήσεων σε διαφορετικούς μορφότυπους.';
$string['privacy:metadata:link:qtype'] = 'Το υποσύστημα Ερώτηση αλληλεπιδρά με το πρόσθετο «Τύποι ερωτήσεων» που περιέχει τους διαφορετικούς τύπους ερωτήσεων.';
$string['published'] = 'διαμοιραζόμενη';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Η ερώτηση «{$a->name}» ({$a->qtype})</a> είναι σε αυτή την κατηγορία ερωτήσεων αλλά χρησιμοποιείται επίσης στο <a href="{$a->qurl}">κουίζ «{$a->quizname}»</a> σε άλλο μάθημα ({$a->coursename}).';
$string['questionbank'] = 'Τράπεζα ερωτήσεων';
$string['questionbehaviouradminsetting'] = 'Ρυθμίσεις συμπεριφοράς ερώτησης';
$string['questionbehavioursdisabled'] = 'Συμπεριφορές ερώτησης προς απενεργοποίηση';
$string['questionbehavioursdisabledexplained'] = 'Εισαγωγή μιας λίστας συμπεριφορών χωρισμένων με κόμμα, οι οποίες δεν θέλετε να εμφανίζονται στο πτυσσόμενο μενού';
$string['questionbehavioursorder'] = 'Σειρά συμπεριφορών ερώτησης';
$string['questionbehavioursorderexplained'] = 'Εισαγωγή μιας λίστας συμπεριφορών χωρισμένων με κόμμα, στην σειρά με την οποία θέλετε να εμφανίζονται στο πτυσσόμενο μενού';
$string['questioncategory'] = 'Κατηγορία ερωτήσεων';
$string['questioncatsfor'] = 'Κατηγορίες ερωτήσεων για «{$a}»';
$string['questiondoesnotexist'] = 'Αυτή η ερώτηση δεν υπάρχει';
$string['questionformtagheader'] = '{$a} ετικέτες';
$string['questionidmismatch'] = 'Αναντιστοιχία αναγνωριστικών ερωτήσεων';
$string['questionname'] = 'Όνομα ερώτησης';
$string['questionnamecopy'] = '{$a} (αντίγραφο)';
$string['questionno'] = 'Ερώτηση {$a}';
$string['questionpreviewdefaults'] = 'Προεπιλογές προεπισκόπησης ερωτήσεων';
$string['questionpreviewdefaults_desc'] = 'Αυτές οι προεπιλογές χρησιμοποιούνται κατά την πρώτη προεπισκόπηση από ένα χρήστη μιας ερώτησης της τράπεζας ερωτήσεων. Μόλις ένας χρήστης κάνει προεπισκόπηση μιας ερώτησης, οι προσωπικές του προτιμήσεις αποθηκεύονται ως προτιμήσεις χρήστη.';
$string['questions'] = 'Ερωτήσεις';
$string['questionsaveerror'] = 'Σφάλματα συνέβησαν κατά την αποθήκευση της ερώτησης - ({$a})';
$string['questionsinuse'] = '(* Ερωτήσεις που επισημαίνονται με αστερίσκο χρησιμοποιούνται ήδη κάπου, για παράδειγμα σε κάποιο κουίζ. Συνεπώς, αν προχωρήσετε, αυτές οι ερωτήσεις δεν θα διαγραφούν πραγματικά, απλά θα κρύβονται.)';
$string['questionsmovedto'] = 'Ερωτήσεις οι οποίες χρησιμοποιούνται ακόμα μετακινήθηκαν στο «{$a}» στην γονική κατηγορία μαθήματος.';
$string['questionsrescuedfrom'] = 'Οι ερωτήσεις αποθηκεύτηκαν από το πλαίσιο {$a}.';
$string['questionsrescuedfrominfo'] = 'Αυτές οι ερωτήσεις (κάποιες από τις οποίες μπορεί να είναι κρυμμένες) αποθηκεύτηκαν όταν το πλαίσιο {$a} διαγράφηκε επειδή χρησιμοποιούνται ακόμα από ορισμένα κουίζ ή άλλες δραστηριότητες.';
$string['questiontags'] = 'Ετικέτες ερώτησης';
$string['questiontext'] = 'Κείμενο ερώτησης';
$string['questiontype'] = 'Τύπος ερώτησης';
$string['questionuse'] = 'Χρήση ερώτησης σε αυτή τη δραστηριότητα';
$string['questionvariant'] = 'Παραλλαγή ερώτησης';
$string['questionx'] = 'Ερώτηση {$a}';
$string['requiresgrading'] = 'Απαιτεί βαθμολόγηση';
$string['responsehistory'] = 'Ιστορικό απόκρισης';
$string['restart'] = 'Επανέναρξη';
$string['restartwiththeseoptions'] = 'Επανέναρξη με αυτές τις επιλογές';
$string['restoremultipletopcats'] = 'Το αρχείο αντιγράφου ασφαλείας περιέχει περισσότερες από μία κατηγορίες ερωτήσεων ανωτάτου επιπέδου για το πλαίσιο {$a}.';
$string['reviewresponse'] = 'Εξέταση απόκρισης';
$string['rightanswer'] = 'Σωστή απάντηση';
$string['rightanswer_help'] = 'Μια αυτόματα δημιουργημένη περίληψη της σωστής απόκρισης. Αυτή μπορεί να είναι περιορισμένη, οπότε ίσως να θέλετε να το ξανασκεφτείτε και να εξηγήσετε την σωστή απάντηση στη γενική ανατροφοδότηση για την ερώτηση καλύτερα, και να απενεργοποιήσετε αυτή την επιλογή.';
$string['save'] = 'Αποθήκευση';
$string['savechangesandcontinueediting'] = 'Αποθήκευση αλλαγών και συνέχεια επεξεργασίας';
$string['saved'] = 'Αποθήκευση: {$a}';
$string['saveflags'] = 'Αποθήκευση της κατάστασης των σημαιοδοτήσεων';
$string['selectacategory'] = 'Επιλογή μιας κατηγορίας:';
$string['selectaqtypefordescription'] = 'Επιλέξτε ένα τύπο ερώτησης για να δείτε την περιγραφή του.';
$string['selectcategoryabove'] = 'Επιλέξτε μια κατηγορία παραπάνω';
$string['selectquestionsforbulk'] = 'Επιλέξτε ερωτήσεις για μαζικές ενέργειες';
$string['settingsformultipletries'] = 'Πολλαπλές προσπάθειες';
$string['shareincontext'] = 'Διαμοιρασμός στο πλαίσιο για {$a}';
$string['showhidden'] = 'Εμφάνιση επίσης και των παλιών ερωτήσεων';
$string['showmarkandmax'] = 'Εμφάνιση βαθμού και μέγιστου';
$string['showmaxmarkonly'] = 'Εμφάνιση μέγιστου βαθμού μόνο';
$string['shown'] = 'Προβλήθηκε';
$string['shownumpartscorrect'] = 'Εμφάνιση του αριθμού των σωστών αποκρίσεων';
$string['shownumpartscorrectwhenfinished'] = 'Εμφάνιση του αριθμού των σωστών αποκρίσεων από τη στιγμή που η ερώτηση τελείωσε';
$string['showquestiontext'] = 'Εμφάνιση του κειμένου της ερώτησης στην λίστα ερωτήσεων';
$string['specificfeedback'] = 'Ειδική ανατροφοδότηση';
$string['specificfeedback_help'] = 'Ανατροφοδότηση που εξαρτάται από το τι απόκριση έδωσε ο μαθητής.';
$string['started'] = 'Ξεκίνησε';
$string['state'] = 'Κατάσταση';
$string['step'] = 'Βήμα';
$string['steps'] = 'Βήματα';
$string['stoponerror'] = 'Διακοπή σε περίπτωση σφάλματος';
$string['stoponerror_help'] = 'Αυτή η ρύθμιση καθορίζει εάν η διαδικασία εισαγωγής θα σταματά μόλις ανιχνευτεί κάποιο σφάλμα, με αποτέλεσμα να μην εισαχθούν καθόλου ερωτήσεις, ή εάν θα αγνοούνται μόνο όσες ερωτήσεις περιέχουν σφάλματα και οι υπόλοιπες έγκυρες ερωτήσεις θα εισάγονται.';
$string['submissionoutofsequence'] = 'Πρόσβαση εκτός καθορισμένης σειράς. Παρακαλούμε, μην κάνετε κλικ στο πλήκτρο επιστροφής σε προηγούμενη σελίδα όταν εργάζεστε σε ερωτήσεις σε ένα κουίζ.';
$string['submissionoutofsequencefriendlymessage'] = 'Έχετε εισαγάγει δεδομένα εκτός της κανονικής ακολουθίας. Αυτό μπορεί να συμβεί αν χρησιμοποιείτε τα κουμπιά «Πίσω» ή «Εμπρός» του περιηγητή σας. Παρακαλούμε μην τα χρησιμοποιήσετε κατά τη διάρκεια της δοκιμασίας. Μπορεί επίσης να συμβεί αν κάνετε κλικ σε κάτι κατά τη φόρτωση μιας σελίδας. Κάντε κλικ στο κουμπί <strong>«Συνέχεια»</strong> για να συνεχίσετε.';
$string['submit'] = 'Υποβολή';
$string['submitandfinish'] = 'Υποβολή και τερματισμός';
$string['submitted'] = 'Υποβολή: {$a}';
$string['tagarea_question'] = 'Ερωτήσεις';
$string['technicalinfo'] = 'Τεχνικές πληροφορίες';
$string['technicalinfo_help'] = 'Αυτές οι τεχνικές πληροφορίες είναι πιθανώς χρήσιμες μόνο για προγραμματιστές που εργάζονται σε νέους τύπους ερωτήσεων. Μπορεί επίσης να σας βοηθήσει όταν επιχειρείτε να διαγνώσετε προβλήματα με ερωτήσεις.';
$string['technicalinfomaxfraction'] = 'Μέγιστο κλάσμα: {$a}';
$string['technicalinfominfraction'] = 'Ελάχιστο κλάσμα: {$a}';
$string['technicalinfoquestionsummary'] = 'Περίληψη ερώτησης: {$a}';
$string['technicalinforesponsesummary'] = 'Περίληψη απόκρισης: {$a}';
$string['technicalinforightsummary'] = 'Σύνοψη σωστής απάντησης: {$a}';
$string['technicalinfostate'] = 'Κατάσταση ερώτησης: {$a}';
$string['technicalinfovariant'] = 'Παραλλαγή ερώτησης: {$a}';
$string['tofilecategory'] = 'Εγγραφή κατηγορίας σε αρχείο';
$string['tofilecontext'] = 'Εγγραφή πλαισίου σε αρχείο';
$string['topfor'] = 'Κορυφή για {$a}';
$string['uninstallbehaviour'] = 'Απεγκατάσταση αυτής της συμπεριφοράς ερώτησης.';
$string['uninstallqtype'] = 'Απεγκατάσταση αυτού του τύπου ερώτησης.';
$string['unknown'] = 'Άγνωστο';
$string['unknownbehaviour'] = 'Άγνωστη συμπεριφορά: {$a}.';
$string['unknownorunhandledtype'] = 'Άγνωστος ή μη διαχειρίσιμος τύπος ερωτήματος: {$a}';
$string['unknownquestion'] = 'Άγνωστη ερώτηση: {$a}.';
$string['unknownquestioncatregory'] = 'Άγνωστη κατηγορία ερωτήσεων: {$a}.';
$string['unknownquestiontype'] = 'Άγνωστος τύπος ερώτησης: {$a}.';
$string['unknowntolerance'] = 'Άγνωστος τύπος ανοχής {$a}';
$string['unpublished'] = 'κατάργηση διαμοιρασμού';
$string['unusedcategorydeleted'] = 'Αυτή η κατηγορία έχει διαγραφεί γιατί, μετά τη διαγραφή του μαθήματος, οι ερωτήσεις της δεν χρησιμοποιούνται άλλο.';
$string['updatedisplayoptions'] = 'Ενημέρωση επιλογών εμφάνιση';
$string['upgradeproblemcategoryloop'] = 'Εντοπίστηκε πρόβλημα κατά την αναβάθμιση των κατηγοριών ερωτήσεων. Υπάρχει ένας βρόχος στο δέντρο των κατηγοριών. Τα επηρεαζόμενα αναγνωριστικά κατηγοριών είναι {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Αποτυχία ενημέρωσης της κατηγορίας ερώτησης {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Εντοπίστηκε πρόβλημα κατά την αναβάθμιση των κατηγοριών ερωτήσεων. Η κατηγορία {$a->id} αναφέρεται στον γονέα {$a->parent}, που δεν υπάρχει. Αλλάχθηκε ο γονέας για τη διόρθωση του προβλήματος.';
$string['whethercorrect'] = 'Αν είναι σωστό';
$string['whethercorrect_help'] = 'Αυτό καλύπτει τόσο την περιγραφή κειμένου «σωστή», «εν μέρει σωστή» ή «εσφαλμένη» και κάθε έγχρωμη φωτο-επισήμανση που μεταφέρει τις ίδιες πληροφορίες.';
$string['whichtries'] = 'Ποιές προσπάθειες';
$string['withselected'] = 'Με την επιλεγμένη';
$string['wrongprefix'] = 'Λανθασμένα μορφοποιημένο πρόθεμα ονόματος {$a}';
$string['xoutofmax'] = '{$a->mark} στα {$a->max}';
$string['yougotnright'] = 'Έχετε επιλέξει σωστά {$a->num}.';
$string['youmustselectaqtype'] = 'Πρέπει να επιλέξετε τύπο ερωτήματος.';
$string['yourfileshoulddownload'] = 'Το αρχείο εξαγωγής σας θα πρέπει να ξεκινήσει να λαμβάνεται σύντομα. Εάν όχι, παρακαλούμε <a href="{$a}">κάντε κλικ εδώ</a>.';
