<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forumng', language 'el', version '3.10'.
 *
 * @package     forumng
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanewdiscussion'] = 'Ξεκινήστε μια νέα συζήτηση';
$string['advancedsearch'] = 'Προχωρημένη αναζήτηση';
$string['alert_condition1'] = 'Είναι ενοχλητικό';
$string['alert_condition2'] = 'Είναι παρενόχληση';
$string['alert_condition3'] = 'Περιέχει άσεμνο περιεχόμενο όπως πορνογραφία';
$string['alert_condition4'] = 'Είναι λίβελος ή δυσφημιστικό';
$string['alert_condition5'] = 'Παραβιάζει δικαιώματα πνευματικής ιδιοκτησίας';
$string['alert_condition6'] = 'Είναι αντικανονικό για κάποιον άλλο λόγο';
$string['alert_conditionmore'] = 'Άλλες πληροφορίες (προαιρετικό)';
$string['alert_emailappendix'] = 'Λαμβάνετε αυτό το μήνυμα ηλε.ταχυδρομείου διότι η διεύθυνσή σας ηλε.ταχυδρομείου χρησιμοποιήθηκε στο ForumNG για αναφορά απαράδεκτου μηνύματος ηλε.ταχυδρομείου.';
$string['alert_emailpreface'] = 'Μια ανάρτηση φόρουμ έχει αναφερθεί από τον/την {$a->fullname} ({$a->username},
{$a->email}) {$a->url}';
$string['alert_feedback'] = 'Η αναφορά σας στάλθηκε με επιτυχία. Ένα μέλος του προσωπικού θα διερευνήσει αυτό το θέμα.';
$string['alert_info'] = 'Η λειτουργία «Αναφορά» μπορεί να στείλει αυτήν την ανάρτηση σε ένα μέλος του προσωπικού που θα την διερευνήσει. <strong>Παρακαλούμε, χρησιμοποιήστε αυτήν την λειτουργία μόνο αν πιστεύετε ότι η ανάρτηση παραβιάζει κάποιον κανόνα</strong>.';
$string['alert_intro'] = 'Μπορείτε να χρησιμοποιήσετε τον σύνδεσμο αναφοράς ανάρτησης αν χρειάζεται να στείλετε κάποια ανάρτηση αυτού του φόρουμ για να την εξετάσει κάποιος συντονιστής.';
$string['alert_link'] = 'Αναφορά ανάρτησης';
$string['alert_linktitle'] = 'Αναφορά ανάρτησης ως απαράδεκτης';
$string['alert_notcurrentpost'] = 'Αυτή η ανάρτηση έχει ήδη διαγραφεί.';
$string['alert_note'] = 'Παρακαλούμε σημειώστε: Αυτό το μήνυμα ηλε.ταχυδρομείου έχει ήδη σταλεί στον/στην {$a}';
$string['alert_pagename'] = 'Αναφορά μιας ανάρτησης ως απαράδεκτης';
$string['alert_reasons'] = 'Λόγοι αναφοράς ανάρτησης';
$string['alert_reporterdetail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['alert_reporterinfo'] = '<strong>Λεπτομέρειες του αναφέροντος</strong>:';
$string['alert_submit'] = 'Αποστολή αναφοράς';
$string['alert_turnedoff'] = 'Η λειτουργία συναγερμικής ειδοποίησης δεν είναι διαθέσιμη.';
$string['allowsubscribe'] = 'Να επιτρέπεται στους χρήστες να εγγράφονται';
$string['allsubscribe'] = 'Εγγραφή σε όλα τα φόρουμ.';
$string['allunsubscribe'] = 'Απεγγραφή από όλα τα φόρουμ.';
$string['alt_discussion_deleted'] = 'Διεγραμμένη συζήτηση';
$string['alt_discussion_locked'] = 'Η συζήτηση είναι μόνο για ανάγνωση';
$string['alt_discussion_moderator'] = 'Στη συζήτηση υπάρχει συντονιστής';
$string['alt_discussion_sticky'] = 'Η συζήτηση αυτή πάντα εμφανίζεται στο επάνω μέρος της λίστας';
$string['alt_discussion_timeout'] = 'Μη ορατό αυτή τη στιγμή στους χρήστες (χρονικό όριο)';
$string['anonymousmoderator'] = 'Ανώνυμος συντονιστής';
$string['asmoderator'] = 'Ανάρτηση ως;';
$string['asmoderator_anon'] = 'Εμφάνιση εαυτού ως Συντονιστής (απόκρυψη ονόματος από τους μαθητές)';
$string['asmoderator_post'] = 'Τυπική ανάρτηση';
$string['asmoderator_self'] = 'Εμφάνιση εαυτού ως Συντονιστής';
$string['attachment'] = 'Συνημμένο';
$string['attachmentmaxbytes'] = 'Μέγιστο μέγεθος συνημμένου';
$string['attachmentnum'] = 'Συνημμένο {$a}';
$string['attachments'] = 'Συνημμένα';
$string['author'] = 'συγγραφέας: &lsquo;{$a}&rsquo;';
$string['authorname'] = 'Όνομα συγγραφέα';
$string['autolockedmessage'] = 'Η συζήτηση αυτή έχει κλείσει αυτόματα καθώς ο μέγιστος χρόνος που επιτρέπεται να είναι ανοικτή έχει περάσει.';
$string['automaticallylock'] = 'Αυτόματο κλείδωμα';
$string['averagerating'] = 'Μέση αξιολόγηση: {$a->avg} (από {$a->num})';
$string['beforeenddate'] = 'Αυτό το φόρουμ κλείνει για νέες αναρτήσεις στις {$a}.';
$string['beforeenddatecapable'] = 'Αυτό το φόρουμ κλείνει για νέες αναρτήσεις μαθητών στις {$a}.';
$string['choosefile'] = '1. Επιλογή αρχείου';
$string['clearflag'] = 'Αφαίρεση σημαιοδότησης';
$string['clicktoadd'] = '2. Πρόσθεσή του';
$string['collapseall'] = 'Σύμπτυξη όλων των αναρτήσεων';
$string['completiondiscussions'] = 'Ο χρήστης πρέπει να δημιουργήσει συζητήσεις:';
$string['completiondiscussionsgroup'] = 'Απαίτηση συζητήσεων';
$string['completionposts'] = 'Ο χρήστης πρέπει να αναρτήσει συζητήσεις ή απαντήσεις';
$string['completionpostsgroup'] = 'Απαίτηση αναρτήσεων';
$string['completionreplies'] = 'Ο χρήστης πρέπει να αναρτήσει απαντήσεις:';
$string['completionrepliesgroup'] = 'Απαίτηση απαντήσεων';
$string['configdiscussionsperpage'] = 'Μέγιστος αριθμός εμφανιζόμενων συζητήσεων ανά σελίδα σε ένα φόρουμ';
$string['configfeeditems'] = 'Αριθμός πρόσφατων μηνυμάτων που συμπεριλαμβάνονται σε μια τροφοδοσία.';
$string['configfeedtype'] = 'Επιλογή των πληροφοριών προς συμπερίληψη σε όλες τις τροφοδοσίες RSS για φόρουμ.';
$string['confighousekeepingstophour'] = 'Η αρχειοθέτηση εργασιών θα σταματά αυτή την ώρα.';
$string['configreplytouser'] = 'Όταν μια ανάρτηση φόρουμ αποστέλλεται με ηλε.ταχυδρομείο, να περιέχει τη διεύθυνση του αποστολέα, ώστε οι παραλήπτες να μπορούν να απαντήσουν προσωπικά και όχι μόνο μέσω του φόρουμ; Ακόμα και αν οριστεί σε «Ναι» οι χρήστες μπορούν να επιλέξουν μέσα από το προφίλ τους να αποκρύπτουν την διεύθυνση ηλε.ταχυδρομείου τους.';
$string['configreportunacceptable'] = 'Αυτή η διεύθυνση ηλε.ταχυδρομείου χρησιμοποιείται για αναφορά προσβλητικών αναρτήσεων από το ForumNG σε επίπεδο ιστοτόπου. Αν αυτή η διεύθυνση αφεθεί κενή, τότε η λειτουργία συναγερμικών ειδοποιήσεων θα απενεργοποιηθεί εκτός αν έχει ενεργοποιηθεί σε επίπεδο φόρουμ.';
$string['configtrackreadposts'] = 'Ορίστε το σε «Ναι» αν θέλετε να παρακολουθείται η ανάγνωση ή η μη ανάγνωση για κάθε χρήστη.';
$string['confirmdeletediscuss'] = 'Διαγραφή συζήτησης';
$string['confirmselection'] = 'Επιβεβαίωση επιλογής';
$string['confirmundelete'] = 'Σίγουρα θέλετε επαναφορά από διαγραφή αυτής της ανάρτησης;';
$string['convert_newforum'] = 'νέο φόρουμ';
$string['convert_process_show'] = 'Το φόρουμ γίνεται ορατό...';
$string['convert_process_state_done'] = 'έγινε.';
$string['convert_title'] = 'Μετατροπή του/των φόρουμ';
$string['copytoself'] = 'Αποστολή αντιγράφου σε εσάς';
$string['currentpost'] = 'Τρέχουσα έκδοση ανάρτησης';
$string['date_asc'] = 'παλαιότερα πρώτα';
$string['date_desc'] = 'πρόσφατα πρώτα';
$string['daterangefrom'] = 'Εύρος ημερομηνίας Από';
$string['daterangemismatch'] = 'Η Ημερομηνία έως είναι πριν την Ημερομηνία από.';
$string['daterangeto'] = 'Εύρος ημερομηνίας Μέχρι';
$string['delete'] = 'Διαγραφή<span class=\'accesshide\'> ανάρτησης {$a}</span>';
$string['deleteandemail'] = 'Διαγραφή και μήνυμα ηλε.ταχυδρομείου προς συγγραφέα';
$string['deleteattachments'] = 'Διαγραφή υπαρχόντων συνημμένων';
$string['deletedbyauthor'] = 'Αυτή η ανάρτηση διαγράφηκε από τον συγγραφέα στο {$a}.';
$string['deletedbymoderator'] = 'Αυτή η ανάρτηση διαγράφηκε από έναν συντονιστή στο {$a}.';
$string['deletedforumpost'] = 'Η ανάρτησή σας διαγράφηκε';
$string['deletedpost'] = 'Διαγραφή ανάρτησης.';
$string['deletedraft'] = 'Διαγραφή προσχεδίου ανάρτησης';
$string['deleteemailpostbutton'] = 'Διαγραφή και αποστολή μηνύματος ηλε.ταχυδρομείου';
$string['deletepermanently'] = 'Διαγραφή μόνιμα';
$string['deletepost'] = 'Διαγραφή ανάρτησης: {$a}';
$string['deletepostbutton'] = 'Διαγραφή';
$string['digestmailheader'] = 'Αυτή είναι η ημερήσια σύνοψη νέων αναρτήσεων από τα φόρουμ του ιστοτόπου {$a->sitename}. Για να αλλάξετε τις ρυθμίσεις ηλε.ταχυδρομείου του φόρουμ, επισκεφθείτε τη σελίδα {$a->userprefs}.';
$string['digestmailprefs'] = 'το προφίλ χρήστη σας';
$string['digestmailsubject'] = '{$a}: σύνοψη φόρουμ';
$string['discussion'] = 'Συζήτηση';
$string['discussionoptions'] = 'Επιλογές συζήτησης';
$string['discussions'] = 'Συζητήσεις';
$string['discussionsperpage'] = 'Συζητήσεις ανά σελίδα';
$string['discussionsunread'] = 'Συζητήσεις (μη αναγνωσμένες)';
$string['discussiontags'] = 'Ετικέτες συζήτησης';
$string['displayperiod'] = 'Περίοδος εμφάνισης';
$string['displayperiod_help'] = 'Μπορείτε να κρύψετε τη συζήτηση αυτή από τους μαθητές μέχρι ή μετά από κάποια συγκεκριμένη ημερομηνία.

Όσο είναι σε απόκρυψη, οι μαθητές δεν βλέπουν καθόλου τη συζήτηση. Για συντονιστές, φαίνεται στην λίστα συζητήσεων σε γκρι χρώμα και με ένα εικονίδιο ρολογιού.';
$string['draft'] = 'Προσχέδιο';
$string['draft_inreplyto'] = '(απάντηση σε {$a})';
$string['draft_newdiscussion'] = '(νέα συζήτηση)';
$string['drafts'] = 'Μη ολοκληρωμένα προσχέδια';
$string['edit'] = 'Επεξεργασία<span class=\'accesshide\'> ανάρτησης {$a}</span>';
$string['edit_locked'] = 'Αυτή η συζήτηση είναι αυτή τη στιγμή κλειδωμένη.';
$string['edit_notlocked'] = 'Αυτή η συζήτηση δεν είναι αυτή τη στιγμή κλειδωμένη.';
$string['edit_rootpost'] = 'Αυτή η ενέργεια δεν μπορεί να εφαρμοστεί σε μια ανάρτηση που ξεκινά μια συζήτηση.';
$string['edit_timeout'] = 'Δεν επιτρέπεται πλέον να επεξεργαστείτε αυτήν την ανάρτηση. Ο επιτρεπόμενος χρόνος επεξεργασίας έχει τελειώσει.';
$string['edit_wronggroup'] = 'Δεν μπορείτε να κάνετε αλλαγές σε αναρτήσεις εκτός της ομάδας σας.';
$string['editbyother'] = 'Πραγματοποιήθηκε επεξεργασία από τον/την {$a->name} στις {$a->date}';
$string['editbyself'] = 'Πραγματοποιήθηκε επεξεργασία από τον συγγραφέα στις {$a->date}';
$string['editdiscussionoptions'] = 'Επεξεργασία επιλογών συζήτησης: {$a}';
$string['editedforumpost'] = 'Στην ανάρτησή σας έχει γίνει επεξεργασία';
$string['editpost'] = 'Επεξεργασία ανάρτησης: {$a}';
$string['emailafter'] = 'Αποστολή ηλε.ταχυδρομείου μετά από καθυστέρηση';
$string['emailauthor'] = 'Αποστολή μηνύματος ηλε.ταχυδρομείου στον συγγραφέα';
$string['emailerror'] = 'Παρουσιάστηκε σφάλμα κατά την αποστολή του ηλε.ταχυδρομείου';
$string['emailmessage'] = 'Μήνυμα';
$string['enableadvanced'] = 'Ενεργοποίηση προχωρημένων λειτουργιών';
$string['enablelimit'] = 'Περιορισμός αναρτήσεων χρήστη';
$string['enableratings'] = 'Να επιτρέπεται η αξιολόγηση των αναρτήσεων';
$string['enabletagging'] = 'Ενεργοποίηση ετικετών συζήτησης';
$string['error_cannotchangediscussionsubscription'] = 'Δεν επιτρέπεται να εγγραφείτε, ή να απεγγραφείτε, από αυτή τη συζήτηση.';
$string['error_cannotchangegroupsubscription'] = 'Δεν επιτρέπεται να εγγραφείτε, ή να απεγγραφείτε, από την επιλεγμένη ομάδα σας.';
$string['error_cannotchangesubscription'] = 'Δεν επιτρέπεται να εγγραφείτε, ή να απεγγραφείτε, από αυτό το φόρουμ.';
$string['error_cannotmanagediscussion'] = 'Δεν έχετε δικαίωμα να διαχειριστείτε αυτή τη συζήτηση.';
$string['error_cannotmarkread'] = 'Δεν σας επιτρέπεται η επισήμανση συζητήσεων ως αναγνωσμένων σε αυτό το φόρουμ.';
$string['error_cannotsubscribetogroup'] = 'Δεν σας επιτρέπεται η εγγραφή στην επιλεγμένη σας ομάδα.';
$string['error_cannotunsubscribefromgroup'] = 'Δεν σας επιτρέπεται να διαγραφείτε από την επιλεγμένη ομάδα σας.';
$string['error_cannotviewdiscussion'] = 'Δεν έχετε δικαίωμα να δείτε αυτήν τη συζήτηση.';
$string['error_draftnotfound'] = 'Αδυναμία εύρεσης του πρόχειρου μηνύματος. Το πρόχειρο ενδέχεται να έχει ήδη αναρτηθεί ή διαγραφεί.';
$string['error_feedlogin'] = 'Σφάλμα κατά την ολοκλήρωση της σύνδεσης χρήστη';
$string['error_invalidsubscriptionrequest'] = 'Το αίτημα εγγραφής σας δεν είναι έγκυρο.';
$string['error_markreadparams'] = 'Λανθασμένες παράμετροι: απαιτείται είτε id είτε d.';
$string['error_nopermission'] = 'Δεν σας επιτρέπεται να εκτελέσετε αυτό το αίτημα.';
$string['error_notwhensharing'] = 'Αυτή η επιλογή δεν είναι διαθέσιμη κατά την κοινή χρήση του φόρουμ.';
$string['error_portfoliosave'] = 'Παρουσιάστηκε σφάλμα κατά την αποθήκευση αυτών των δεδομένων στο MyStuff.';
$string['error_ratingrequired'] = 'Η βαθμολόγηση επιλέχθηκε να βασίζεται σε αξιολογήσεις, αλλά οι αξιολογήσειςδεν είναι ενεργοποιημένες';
$string['error_ratingthreshold'] = 'Το (ελάχιστο) όριο αξιολογήσεων πρέπει να είναι θετικός αριθμός.';
$string['event:discussioncreated'] = 'Προσθήκη συζήτησης';
$string['event:discussiondeleted'] = 'Διαγραφή συζήτησης';
$string['event:discussionlocked'] = 'Κλείδωμα συζήτησης';
$string['event:discussionmerged'] = 'Συγχώνευση συζήτησης';
$string['event:discussionundeleted'] = 'Επαναφορά συζήτησης από διαγραμμένα';
$string['event:discussionunlocked'] = 'Ξεκλείδωμα συζήτησης';
$string['event:discussionviewed'] = 'Εμφάνιση συζήτησης';
$string['event:postcreated'] = 'Προσθήκη απάντησης';
$string['event:postdeleted'] = 'Διαγραφή ανάρτησης';
$string['event:postreported'] = 'Αναφορά ανάρτησης';
$string['event:postsplit'] = 'Διαχωρισμός ανάρτησης';
$string['event:postupdated'] = 'Επεξεργασία ανάρτησης';
$string['event:subscriptioncreated'] = 'Η εγγραφή δημιουργήθηκε';
$string['event:subscriptiondeleted'] = 'Η εγγραφή διαγράφηκε';
$string['existingattachments'] = 'Υπάρχοντα συνημμένα';
$string['expand'] = 'Ανάπτυξη<span class=\'accesshide\'> ανάρτησης {$a}</span>';
$string['expand_text'] = 'Ανάπτυξη ανάρτησης';
$string['expandall'] = 'Ανάπτυξη όλων των αναρτήσεων';
$string['exportword'] = 'Εξαγωγή στο Word';
$string['externaldashboardadd'] = 'Προσθήκη φόρουμ στο ταμπλό';
$string['externaldashboardremove'] = 'Κατάργηση φόρουμ από το ταμπλό';
$string['feed_nopermission'] = 'Δεν έχετε άδεια πρόσβασης σε αυτήν την τροφοδοσία.';
$string['feed_notavailable'] = 'Αυτή η τροφοδοσία δεν είναι διαθέσιμη.';
$string['feeditems'] = 'Πρόσφατα στοιχεία στις τροφοδοσίες';
$string['feeds'] = 'Τροφοδοσίες';
$string['feedtype'] = 'Περιεχόμενο τροφοδοσιών';
$string['feedtype_all_posts'] = 'Περιέχει όλες τις αναρτήσεις';
$string['feedtype_discussions'] = 'Περιέχει μόνο συζητήσεις';
$string['feedtype_none'] = 'Η τροφοδοσία απενεργοποιήθηκε';
$string['filterdiscussions'] = 'Προβολή συζητήσεων με ετικέτα';
$string['flaggeddiscussions'] = 'Σημαιοδοτημένες συζητήσεις';
$string['flaggeddiscussionslink'] = '{$a} σημαιοδοτημένες συζητήσεις';
$string['flaggedposts'] = 'Σημαιοδοτημένες αναρτήσεις';
$string['flaggedpostslink'] = '{$a} σημαιοδοτημένες αναρτήσεις';
$string['flagoff'] = 'Μη σημαιοδοτημένη';
$string['flagon'] = 'Έχετε σημαιοδοτήσει αυτή την ανάρτηση';
$string['flagpost'] = 'Σημαιοδότηση ανάρτησης';
$string['forbidattachments'] = 'Δεν επιτρέπονται συνημμένα';
$string['forcesubscribe'] = 'Επιβολή σε όλους να είναι (και να παραμείνουν) εγγεγραμμένοι';
$string['forum'] = 'Φόρουμ';
$string['forumintro'] = 'Εισαγωγή του φόρουμ (εμφανίζεται πάνω από τη λίστα συζητήσεων)';
$string['forumname'] = 'Όνομα φόρουμ';
$string['forumng:addinstance'] = 'Προσθήκη νέου ΦόρουμNG';
$string['forumng:addtag'] = 'Να επιτρέπεται στο χρήστη να ορίσει ετικέτες για μια συζήτηση';
$string['forumng:copydiscussion'] = 'Αντιγραφή συζήτησης';
$string['forumng:createattachment'] = 'Δημιουργία συνημμένων';
$string['forumng:deleteanypost'] = 'Διαγραφή όλων των αναρτήσεων';
$string['forumng:editanypost'] = 'Επεξεργασία οποιασδήποτε ανάρτησης';
$string['forumng:forwardposts'] = 'Προώθηση αναρτήσεων';
$string['forumng:grade'] = 'Βαθμολόγηση αναρτήσεων';
$string['forumng:ignorepostlimits'] = 'Παράβλεψη ορίων καταμέτρησης αναρτήσεων';
$string['forumng:managediscussions'] = 'Διαχείριση επιλογών συζήτησης';
$string['forumng:managesubscriptions'] = 'Διαχείριση εγγραφών';
$string['forumng:movediscussions'] = 'Μετακίνηση συζητήσεων';
$string['forumng:postanon'] = 'Αναρτήστε ως ανώνυμος συντονιστής';
$string['forumng:postasmoderator'] = 'Προσδιορίστε τον εαυτό σας ως συντονιστή στις αναρτήσεις';
$string['forumng:rate'] = 'Βαθμολόγηση αναρτήσεων';
$string['forumng:replypost'] = 'Απαντήσεις σε αναρτήσεις';
$string['forumng:setimportant'] = 'Επισήμανση αναρτήσεων ως σημαντικών';
$string['forumng:splitdiscussions'] = 'Διαχωρισμός συζητήσεων';
$string['forumng:startdiscussion'] = 'Έναρξη νέας συζήτησης';
$string['forumng:view'] = 'Εμφάνιση φόρουμ';
$string['forumng:viewallposts'] = 'Προβολή κρυφών και διαγραμμένων αναρτήσεων';
$string['forumng:viewallratings'] = 'Προβολή όλων των ανεπεξέργαστων βαθμολογιών που δίνονται από μεμονωμένα άτομα';
$string['forumng:viewanyrating'] = 'Δείτε οποιεσδήποτε αξιολογήσεις';
$string['forumng:viewdiscussion'] = 'Εμφάνιση συζητήσεων';
$string['forumng:viewrating'] = 'Δείτε αξιολογήσεις των δικών σας αναρτήσεων';
$string['forumng:viewreadinfo'] = 'Δείτε ποιός έχει διαβάσει μια ανάρτηση';
$string['forumng:viewsubscribers'] = 'Εμφάνιση εγγεγραμμένων';
$string['forums'] = 'Φόρουμ';
$string['forumsubscription'] = 'Εγγραφή σε φόρουμ';
$string['forumtype'] = 'Τύπος φόρουμ';
$string['from'] = 'από: {$a}';
$string['grade'] = 'Βαθμός';
$string['grading'] = 'Βαθμός';
$string['grading_none'] = 'Κανένας βαθμός';
$string['grading_sum'] = 'Άθροισμα αξιολογήσεων';
$string['gradingscale'] = 'Κλίμακα βαθμολόγησης';
$string['group'] = 'Ομάδα';
$string['hasunreadposts'] = '(Μη αναγνωσμένες αναρτήσεις)';
$string['history'] = 'Ιστορικό';
$string['historypage'] = 'Ιστορικό: {$a}';
$string['housekeepingstarthour'] = 'Ώρα έναρξης αρχειοθέτησης';
$string['housekeepingstophour'] = 'Ώρα λήξης αρχειοθέτησης';
$string['important'] = 'Σημαντική ανάρτηση';
$string['inappropriatedateortime'] = 'Η ημερομηνία από δεν μπορεί να είναι μετά από τη σημερινή.';
$string['includepost'] = 'Συμπερίληψη ανάρτησης';
$string['initialsubscribe'] = 'Αυτόματη εγγραφή όλων';
$string['inreplyto'] = 'Σε απάντηση στο';
$string['invalidforum'] = 'Αυτό το φόρουμ δεν υπάρχει πλέον';
$string['js_clicktoclearrating'] = 'Κάντε κλικ για να διαγραφεί η αξιολόγησή σας.';
$string['js_nopublicrating'] = 'Μη αξιολογημένο ακόμη.';
$string['js_nouserrating'] = 'Μη αξιολογημένο από σας.';
$string['js_nratings'] = '(# αξιολογήσεις)';
$string['js_nratings1'] = '(1 αξιολόγηση)';
$string['js_outof'] = '(Στα #.)';
$string['js_publicrating'] = 'Μέση αξιολόγηση: #.';
$string['js_userrating'] = 'Η αξιολόγησή σας: #.';
$string['jumpnext'] = 'Επόμενο μη αναγνωσμένο';
$string['jumpparent'] = 'Γονέας';
$string['jumpprevious'] = 'Προηγούμενο μη αναγνωσμένο';
$string['jumppreviousboth'] = 'προηγούμενο';
$string['jumpto'] = 'Μεταπήδηση σε:';
$string['lastpost'] = 'Τελευταία ανάρτηση';
$string['limitposts'] = 'Περιορισμός αναρτήσεων';
$string['lockedtitle'] = 'Η συζήτηση αυτή έχει πλέον κλείσει';
$string['mailnow'] = 'Αποστολή ηλε.ταχυδρομείου σύντομα';
$string['managepostalerts'] = 'Διαχείριση επαγρυπνήσεων αναρτήσεων που αναφέρθηκαν';
$string['markdiscussionread'] = 'Επισήμανση όλων των αναρτήσεων σε αυτήν τη συζήτηση ως αναγνωσμένων.';
$string['message'] = 'Μήνυμα';
$string['moderator'] = 'Συντονιστής';
$string['modulename'] = 'ΦόρουμNG';
$string['modulename_help'] = 'Το ΦόρουμNG αντικαθιστά το τυπικό φόρουμ Moodle με τα περισσότερα χαρακτηριστικά του συν κάποια επιπρόσθετα και μια πιο δυναμική διεπαφή χρήστη.

NG σημαίνει «Next Generation» (Νέα Γενιά).';
$string['modulenameplural'] = 'ΦόρουμNG';
$string['newdiscussion'] = 'Νέα συζήτηση';
$string['nextresults'] = 'Εύρεση περισσότερων αποτελεσμάτων';
$string['nodiscussions'] = 'Δεν υπάρχει ακόμη καμία συζήτηση σε αυτό το φόρουμ.';
$string['notext'] = '(κανένα κείμενο)';
$string['nothingtodisplay'] = '<h3>Τίποτα προς εμφάνιση</h3>';
$string['numberofdiscussion'] = 'συζήτηση {$a}';
$string['numberofdiscussions'] = '{$a} συζητήσεις';
$string['numeric_asc'] = 'χαμηλότερο πρώτο';
$string['numeric_desc'] = 'υψηλότερο πρώτο';
$string['numposts'] = '{$a} ανάρτηση/-εις';
$string['olderversions'] = 'Παλαιότερες εκδόσεις (οι πιο πρόσφατες πρώτα)';
$string['onemonth'] = '1 μήνας';
$string['optionalsubject'] = 'Αλλαγή θέματος συζήτησης (προαιρετικά)';
$string['partialsubscribed'] = 'Μερική';
$string['pastediscussion'] = 'Επικόλληση συζήτησης';
$string['pastediscussion_cancel'] = 'Ακύρωση επικόλλησης';
$string['pastediscussions'] = 'Επικόλληση συζητήσεων';
$string['post'] = 'Ανάρτηση';
$string['postby'] = '(από {$a})';
$string['postdiscussion'] = 'Ανάρτηση συζήτησης';
$string['postedasmoderator'] = 'Ανάρτηση ως συντονιστής';
$string['postinfo_deleted'] = 'διαγράφηκε';
$string['postinfo_unread'] = 'μη αναγνωσμένο';
$string['postingfrom'] = 'Αναρτήσεις επιτρέπονται μόνο από';
$string['postinguntil'] = 'Αναρτήσεις επιτρέπονται μόνο μέχρι';
$string['postnum'] = 'Ανάρτηση {$a->num}';
$string['postnumreply'] = 'Ανάρτηση {$a->num}{$a->info} σε απάντηση στην {$a->parent}';
$string['postreply'] = 'Ανάρτηση απάντησης';
$string['posts'] = 'Αναρτήσεις';
$string['postsper'] = 'αναρτήσεις ανά';
$string['previousresults'] = 'Επιστροφή στα αποτελέσματα {$a}';
$string['rate'] = 'Αξιολόγηση';
$string['rate_nopermission'] = 'Δεν έχετε δικαίωμα να αξιολογήσετε αυτή την ανάρτηση ({$a}).';
$string['ratingfrom'] = 'Αξιολόγηση μόνο αναρτήσεων από';
$string['ratings'] = 'Αξιολογήσεις';
$string['ratingthreshold'] = 'Απαιτούμενες αξιολογήσεις';
$string['ratinguntil'] = 'Αξιολόγηση μόνο αναρτήσεων μέχρι';
$string['readafterdays'] = 'Να θεωρούνται αναγνωσμένα μετά από τόσες ημέρες';
$string['remove'] = 'Διαγραφή';
$string['removeolddiscussions'] = 'Διαχείριση παλιών συζητήσεων';
$string['removeolddiscussionsafter'] = 'Διαχείριση παλιών συζητήσεων μετά από';
$string['removeolddiscussionsdefault'] = 'Ποτέ διαγραφή';
$string['replies'] = 'Απαντήσεις';
$string['reply'] = 'Απάντηση<span class=\'accesshide\'> στην ανάρτηση {$a}</span>';
$string['reply_missing'] = 'Δεν μπορείτε να απαντήσετε διότι το σύστημα δεν μπορεί να βρει την ανάρτηση.';
$string['reply_nopermission'] = 'Δεν έχετε δικαίωμα να απαντήσετε εδώ.';
$string['reply_notcurrentpost'] = 'Δεν μπορείτε να απαντήσετε σε διαγραμμένες αναρτήσεις ή προηγούμενες εκδόσεις αναρτήσεων.';
$string['reply_postquota'] = 'Δεν μπορείτε να απαντήσετε σε αναρτήσεις αυτή τη στιγμή επειδή έχετε φτάσει το όριο δημοσίευσης.';
$string['reply_readonly'] = 'Αυτό το φόρουμ αυτή τη στιγμή είναι μόνο για ανάγνωση, οπότε δεν μπορούν να προστεθούν νέες απαντήσεις.';
$string['reply_typelimit'] = 'Λόγω του τύπου αυτού του φόρουμ, δεν επιτρέπεται προς το παρόν να απαντήσετε σε αυτήν την ανάρτηση.';
$string['reply_wronggroup'] = 'Δεν μπορείτε να απαντήσετε σε δημοσιεύσεις σε αυτήν τη συζήτηση επειδή δεν είστε στη σωστή ομάδα.';
$string['replytopost'] = 'Απάντηση στην ανάρτηση: {$a}';
$string['replytouser'] = 'Χρήση διεύθυνσης ηλε.ταχυδρομείου στην απάντηση';
$string['reportingemail'] = 'Διεύθυνση ηλε.ταχυδρομείου για αναφορά προσβλητικών αναρτήσεων';
$string['reportunacceptable'] = 'Διεύθυνση ηλε.ταχυδρομείου για αναφορά προσβλητικών αναρτήσεων';
$string['saveallratings'] = 'Αποθήκευση όλων των αξιολογήσεων';
$string['savedposts_all'] = '{$a}';
$string['savedposts_all_tag'] = 'Συζήτηση φόρουμ';
$string['savedposts_one'] = '{$a->name}: {$a->subject}';
$string['savedposts_one_tag'] = 'Ανάρτηση φόρουμ';
$string['savedposts_selected'] = '{$a} (επιλεγμένες αναρτήσεις)';
$string['savedposts_selected_tag'] = 'Αναρτήσεις φόρουμ';
$string['savedraft'] = 'Αποθήκευση ως προχείρου';
$string['savefailtitle'] = 'Η αποθήκευση της ανάρτησης απέτυχε';
$string['savetoportfolio'] = 'Αποθήκευση στο MyStuff';
$string['search:activity'] = 'ForumNG - πληροφορίες δραστηριότητας';
$string['search:post'] = 'ForumNG - αναρτήσεις';
$string['searchallforums'] = 'Αναζήτηση σε όλα τα φόρουμ';
$string['searchresults'] = 'Αποτελέσματα αναζήτησης: <strong>{$a}</strong>';
$string['searchthisforum'] = 'Αναζήτηση σε αυτό το φόρουμ';
$string['searchthisforumlink'] = 'Αναζήτηση σε αυτό το φόρουμ';
$string['searchtime'] = 'Χρόνος αναζήτησης: {$a} s';
$string['selectedposts'] = 'Επιλεγμένες αναρτήσεις';
$string['selectlabel'] = 'Επιλογή ανάρτησης {$a}';
$string['selectorall'] = 'Θέλετε να συμπεριληφθεί ολόκληρη η συζήτηση, ή μόνο επιλεγμένες αναρτήσεις;';
$string['selectoralldisc'] = 'Εμφανίζονται όλες οι συζητήσεις';
$string['selectorselectdisc'] = 'Επιλογή συζήτησης';
$string['selectorselecteddisc'] = 'Επιλεγμένες συζητήσεις';
$string['sendanddelete'] = 'Αποστολή και διαγραφή';
$string['set'] = 'Σημαιοδότηση';
$string['setflag'] = 'Σημαιοδότηση αυτής της ανάρτησης για μελλοντική αναφορά';
$string['setforumtags'] = 'Ορισμός ετικετών για το φόρουμ';
$string['setimportant'] = 'Επισήμανση αναρτήσεων ως σημαντικών';
$string['settag_label'] = 'Ορισμός';
$string['settags'] = 'Ορισμός ετικετών συζήτησης';
$string['shared'] = 'Να επιτρέπεται ο διαμοιρασμός του φόρουμ';
$string['sharedviewinfolist'] = 'Συμπεριλαμβάνεται στο ακόλουθο: {$a}.';
$string['sharedviewinfonone'] = 'Δεν συμπεριλαμβάνεται αυτή τη στιγμή σε κανένα άλλο μάθημα.';
$string['sharedviewinfooriginal'] = '<strong>Αυτό το φόρουμ διαμοιράζεται</strong> με το όνομα
<strong>{$a}</strong> για χρήση σε άλλα μαθήματα.';
$string['sharing'] = 'Διαμοιρασμός φόρουμ';
$string['show_all'] = 'Εμφάνιση όλων';
$string['showidnumber'] = 'Εμφάνιση αναγνωριστικών αριθμών';
$string['showusername'] = 'Εμφάνιση ονόματος χρηστών';
$string['sortby'] = 'Ταξινόμηση κατά {$a}';
$string['subject'] = 'Θέμα';
$string['subscribe'] = 'Εγγραφείτε σε αυτό το φόρουμ';
$string['subscribe_already'] = 'Έχετε ήδη εγγραφεί.';
$string['subscribe_already_group'] = 'Έχετε ήδη εγγραφεί σε αυτή την ομάδα.';
$string['subscribe_confirm'] = 'Έχετε εγγραφεί.';
$string['subscribe_confirm_group'] = 'Έχετε εγγραφεί στην ομάδα.';
$string['subscribed'] = 'Με εγγραφή';
$string['subscribeddiscussionall'] = 'Όλες';
$string['subscribediscussion'] = 'Εγγραφή στη συζήτηση';
$string['subscribedthisgroup'] = 'Αυτή η ομάδα';
$string['subscribegroup'] = 'Εγγραφή στο φόρουμ αυτής της ομάδας';
$string['subscribelong'] = 'Εγγραφή σε ολόκληρο το φόρουμ';
$string['subscribers'] = 'Εγγεγραμμένοι';
$string['subscribers_nopermission'] = 'Δεν έχετε δικαίωμα να δείτε την λίστα εγγεγραμμένων.';
$string['subscribeshort'] = 'Εγγραφή σε φόρουμ';
$string['subscribestart'] = 'Στείλτε μου με ηλε.ταχυδρομείο αντίγραφα των αναρτήσεων αυτού του φόρουμ';
$string['subscribestate_discussionsubscribed'] = 'Λαμβάνετε μηνύματα από αυτή την συζήτηση μέσω ηλε.ταχυδρομείου στο {$a}.';
$string['subscribestate_forced'] = '(Αυτό το φόρουμ δεν σας επιτρέπει κατάργηση εγγραφής.)';
$string['subscribestate_info'] = 'Οι προτιμήσεις σας ηλε.ταχυδρομείου{$a}:';
$string['subscribestate_info_link'] = 'αλλαγή';
$string['subscribestate_not_permitted'] = 'Αυτό το φόρουμ δεν επιτρέπει εγγραφή μέσω ηλε.ταχυδρομείου.';
$string['subscription'] = 'Εγγραφή μέσω ηλε.ταχυδρομείου';
$string['subscription_forced'] = 'Επιβολή εγγραφής σε όλους';
$string['subscription_initially_subscribed'] = 'Αρχικά είναι εγγεγραμμένοι όλοι';
$string['subscription_not_permitted'] = 'Δεν επιτρέπεται εγγραφή';
$string['subscription_permitted'] = 'Οποιοσδήποτε μπορεί να επιλέξει να εγγραφεί';
$string['subscriptions'] = 'Εγγραφές';
$string['switchto_simple_link'] = 'Εναλλαγή σε απλή εμφάνιση.';
$string['switchto_standard_link'] = 'Εναλλαγή σε τυπική εμφάνιση.';
$string['tagarea_forumng'] = 'Δραστηριότητα ForumNG';
$string['tagarea_forumng_discussions'] = 'Συζητήσεις ForumNG';
$string['tagarea_groups'] = 'Ομάδες δραστηριοτήτων ForumNG';
$string['tagcollection_forumng_discussions'] = 'Συζητήσεις ForumNG';
$string['tagcollection_forumng_group_set'] = 'Ομάδα δραστηριότητας ForumNG';
$string['tagcollection_forumng_set'] = 'Δραστηριότητα ForumNG';
$string['tagging'] = 'Ετικέτες';
