<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'el', version '3.10'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Επίτευξη βαθμού';
$string['activities'] = 'Δραστηριότητες';
$string['activitiescompleted'] = 'Ολοκλήρωση δραστηριότητας';
$string['activitiescompletednote'] = 'Σημείωση: Θα πρέπει να οριστεί η ολοκλήρωση δραστηριότητας για να εμφανιστεί μια δραστηριότητα στην παραπάνω λίστα.';
$string['activitieslabel'] = 'Δραστηριότητες / πόροι';
$string['activityaggregation'] = 'Απαίτηση συνθήκης';
$string['activityaggregation_all'] = 'ΟΛΕΣ οι επιλεγμένες δραστηριότητες που πρέπει να ολοκληρωθούν';
$string['activityaggregation_any'] = 'ΟΠΟΙΕΣΔΗΠΟΤΕ επιλεγμένες δραστηριότητες πρέπει να ολοκληρωθούν';
$string['activitycompletion'] = 'Ολοκλήρωση δραστηριοτήτων';
$string['activitycompletionupdated'] = 'Οι αλλαγές αποθηκεύτηκαν';
$string['activitygradenotrequired'] = 'Δεν απαιτείται βαθμός';
$string['affectedactivities'] = 'Οι αλλαγές θα επηρεάσουν τις ακόλουθες δραστηριότητες ή πόρους <b>{$a}</b>:';
$string['aggregationmethod'] = 'Μέθοδος συνάθροισης';
$string['all'] = 'Όλα';
$string['any'] = 'Κάθε';
$string['approval'] = 'Αποδοχή';
$string['areyousureoverridecompletion'] = 'Είστε βέβαιοι ότι θέλετε να παρακάμψετε την τρέχουσα κατάσταση ολοκλήρωσης αυτής της δραστηριότητας για αυτόν τον χρήστη και να την επισημάνετε ως «{$a}»;';
$string['badautocompletion'] = 'Εάν επιλέξετε αυτόματη ολοκλήρωση, πρέπει να επιλέξετε επίσης και τουλάχιστον ένα προαπαιτούμενο (παρακάτω).';
$string['badcompletiongradeitemnumber'] = 'Δεν μπορεί να ενεργοποιηθεί η απαίτηση βαθμολόγησης για <b>{$a}</b> διότι δεν είναι ενεργοποιημένη η βαθμολόγηση από {$a}.';
$string['bulkactivitycompletion'] = 'Μαζική επεξεργασία ολοκλήρωσης δραστηριοτήτων';
$string['bulkactivitydetail'] = 'Επιλέξτε τις δραστηριότητες που θέλετε να επεξεργαστείτε μαζικά.';
$string['bulkcompletiontracking'] = 'Παρακολούθηση ολοκλήρωσης';
$string['bulkcompletiontracking_help'] = '<strong>Καμία:</strong> Να μην φαίνεται η ολοκλήρωση της δραστηριότητας

<strong>Χειροκίνητα:</strong> Οι μαθητές μπορούν να επισημάνουν χειροκίνητα τη δραστηριότητα ως ολοκληρωμένη

<strong>Με προϋποθέσεις:</strong> Εμφάνιση της δραστηριότητας ως ολοκληρωμένης όταν πληρούνται κάποιες προϋποθέσεις';
$string['checkactivity'] = 'Πλαίσιο ελέγχου για δραστηριότητα/πόρο: {$a}';
$string['checkall'] = 'Επιλογή ή αποεπιλογή όλων των δραστηριοτήτων και πόρων';
$string['checkallsection'] = 'Επιλογή ή αποεπιλογή όλων των δραστηριοτήτων και πόρων στο παρακάτω τμήμα: {$a}';
$string['completed'] = 'Ολοκληρωμένο';
$string['completedunlocked'] = 'Οι επιλογές ολοκλήρωσης ξεκλειδώθηκαν';
$string['completedunlockedtext'] = 'Όταν αποθηκεύσετε τις αλλαγές σας, οι ρυθμίσεις ολοκλήρωσης όλων των χρηστών θα διαγραφούν. Αν δεν θέλετε κάτι τέτοιο, μην υποβάλλετε αυτή τη φόρμα.';
$string['completedwarning'] = 'Οι επιλογές ολοκλήρωσης κλειδώθηκαν';
$string['completedwarningtext'] = 'Αυτή η δραστηριότητα έχει ήδη επισημανθεί ως ολοκληρωμένη για {$a} συμμετέχοντες. Η αλλαγή των επιλογών ολοκλήρωσης θα διαγράψει την κατάσταση ολοκλήρωσής τους και μπορεί να προκαλέσει σύγχυση. Έτσι, οι επιλογές έχουν κλειδωθεί και δεν θα πρέπει να ξεκλειδωθούν εκτός αν είναι απολύτως απαραίτητο.';
$string['completion'] = 'Παρακολούθηση ολοκλήρωσης';
$string['completion-alt-auto-enabled'] = 'Το σύστημα επισημαίνει αυτόματα, το στοιχείο αυτό ως ολοκληρωμένο, υπό συνθήκες: {$a}';
$string['completion-alt-auto-fail'] = 'Ολοκληρωμένο: {$a} (με βαθμό κάτω της βάσης)';
$string['completion-alt-auto-n'] = 'Μη ολοκληρωμένο: {$a}';
$string['completion-alt-auto-n-override'] = 'Δεν ολοκληρώθηκε: {$a->modname} (καθορίστηκε από τον/την {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Ολοκληρωμένο: {$a} (με βαθμό άνω της βάσης)';
$string['completion-alt-auto-y'] = 'Ολοκληρωμένο: {$a}';
$string['completion-alt-auto-y-override'] = 'Ολοκληρώθηκε: {$a->modname} (καθορίστηκε από τον/την {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Κάθε μαθητής μπορεί να επισημάνει το στοιχείο αυτό ως ολοκληρωμένο χειροκίνητα: {$a}';
$string['completion-alt-manual-n'] = 'Δεν ολοκληρώθηκε: {$a}. Επιλέξτε για επισήμανση ολοκλήρωσης.';
$string['completion-alt-manual-n-override'] = 'Δεν ολοκληρώθηκε: {$a->modname} (καθορίστηκε από τον/την {$a->overrideuser}). Επιλέξτε για να την επισημάνετε ως ολοκληρωμένη.';
$string['completion-alt-manual-y'] = 'Ολοκληρώθηκε: {$a}. Επιλέξτε για επισήμανση μη ολοκλήρωσης.';
$string['completion-alt-manual-y-override'] = 'Ολοκληρώθηκε: {$a->modname} (καθορίστηκε από τον/την {$a->overrideuser}). Δεν ολοκληρώθηκε: {$a->modname} (καθορίστηκε από τον/την {$a->overrideuser}). Επιλέξτε για να την επισημάνετε ως μη ολοκληρωμένη.';
$string['completion-fail'] = 'Ολοκληρωμένο (με βαθμό κάτω της βάσης)';
$string['completion-n'] = 'Δεν ολοκληρώθηκε';
$string['completion-n-override'] = 'Δεν ολοκληρώθηκε (τέθηκε από τον/την {$a})';
$string['completion-pass'] = 'Ολοκληρωμένο (με βαθμό άνω της βάσης)';
$string['completion-y'] = 'Ολοκληρωμένο';
$string['completion-y-override'] = 'Ολοκληρώθηκε (τέθηκε από {$a})';
$string['completion_automatic'] = 'Η δραστηριότητα σημειώνεται ολοκληρωμένη όταν ικανοποιηθούν κάποιες συνθήκες';
$string['completion_help'] = 'Εάν ενεργοποιηθεί, η ολοκλήρωση δραστηριότητας παρακολουθείται, είτε με το χέρι είτε αυτόματα, με βάση συγκεκριμένες συνθήκες. Μπορούν να ρυθμιστούν πολλαπλές συνθήκες αν είναι επιθυμητό. Αν ναι, η δραστηριότητα θα θεωρείται ολοκληρωμένη μόνο όταν καλύπτονται όλες οι συνθήκες. Μια επισήμανση (σημαδάκι &#10004;) δίπλα στο όνομα της δραστηριότητας στη σελίδα του μαθήματος δείχνει πότε έχει ολοκληρωθεί η δραστηριότητα.';
$string['completion_link'] = 'δραστηριότητα/ολοκλήρωση';
$string['completion_manual'] = 'Οι μαθητές μπορούν να επισημάνουν χειροκίνητα τη δραστηριότητα ως ολοκληρωμένη';
$string['completion_none'] = 'Να μην φαίνεται η ολοκλήρωση της δραστηριότητας';
$string['completionactivitydefault'] = 'Χρήση προεπιλογής δραστηριότητας';
$string['completiondefault'] = 'Προεπιλεγμένη παρακολούθηση ολοκλήρωσης';
$string['completiondisabled'] = 'Απενεργοποιημένο, δε συμπεριλαμβάνεται στις ρυθμίσεις των δραστηριοτήτων';
$string['completionduration'] = 'Εγγραφή';
$string['completionenabled'] = 'Ενεργοποιημένο, έλεγχος μέσω των ρυθμίσεων ολοκλήρωσης και δραστηριότητας';
$string['completionexpected'] = 'Αναμένεται ολοκλήρωση στις';
$string['completionexpected_help'] = 'Αυτή η ρύθμιση καθορίζει την ημερομηνία κατά την οποία αναμένεται να ολοκληρωθεί η δραστηριότητα.';
$string['completionexpecteddesc'] = 'Η ολοκλήρωση αναμένεται στις {$a}';
$string['completionexpectedfor'] = '(Το στιγμιότυπο) {$a->instancename} πρέπει να ολοκληρωθεί';
$string['completionicons'] = 'Πλαίσια ελέγχου ολοκλήρωσης';
$string['completionicons_help'] = 'Ένα σημαδάκι ν (&#10004;) στο τετραγωνίδιο δίπλα σε ένα όνομα δραστηριότητας μπορεί να χρησιμοποιηθεί για να δείχνει πότε η δραστηριότητα είναι ολοκληρωμένη. Εάν εμφανιστεί ένα τετραγωνίδιο με διάστικτα περιγράμματα, θα εμφανιστεί αυτόματα ένα σημαδάκι &#10004; στο τετραγωνίδιο όταν ολοκληρώσετε τη δραστηριότητα σύμφωνα με τις προϋποθέσεις που ορίζει ο διδάσκων. Εάν εμφανιστεί ένα τετραγωνίδιο με ένα συμπαγές περίγραμμα, μπορείτε να κάνετε κλικ σε αυτό για να επιλέξετε το τετραγωνίδιο όταν εσείς νομίζετε ότι έχετε ολοκληρώσει τη δραστηριότητα. (Κάνοντας κλικ σε αυτό ξανά, αφαιρείται πάλι το &#10004;, αν αλλάξετε γνώμη.)';
$string['completionmenuitem'] = 'Ολοκλήρωση';
$string['completionnotenabled'] = 'Η ολοκλήρωση δεν είναι ενεργοποιημένη';
$string['completionnotenabledforcourse'] = 'Η ολοκλήρωση δεν είναι ενεργοποιημένη για αυτό το μάθημα';
$string['completionnotenabledforsite'] = 'Η ολοκλήρωση δεν είναι ενεργοποιημένη για αυτό τον ιστότοπο';
$string['completionondate'] = 'Ημερομηνία';
$string['completionondatevalue'] = 'Ημερομηνία κατά την οποία το μάθημα θα επισημανθεί ως ολοκληρωμένο';
$string['completionsettingslocked'] = 'Οι ρυθμίσεις ολοκλήρωσης είναι κλειδωμένες';
$string['completionupdated'] = 'Ενημερώθηκε η ολοκλήρωση της δραστηριότητας <b>{$a}</b>';
$string['completionusegrade'] = 'Απαιτείται βαθμός';
$string['completionusegrade_desc'] = 'Ο μαθητής πρέπει να λάβει βαθμό για να ολοκληρώσει τη δραστηριότητα';
$string['completionusegrade_help'] = 'Αν ενεργοποιηθεί, η δραστηριότητα θεωρείται ολοκληρωμένη όταν ένας μαθητής λαμβάνει μια βαθμολογία. Τα εικονίδια επιτυχίας και αποτυχίας μπορούν να εμφανίζονται εάν έχει οριστεί βαθμός επιτυχίας για τη δραστηριότητα.';
$string['completionview'] = 'Απαιτείται προβολή';
$string['completionview_desc'] = 'Ο μαθητής πρέπει να δει τη δραστηριότητα για να την ολοκληρώσει';
$string['configcompletiondefault'] = 'Η προεπιλεγμένη ρύθμιση για την παρακολούθηση ολοκλήρωσης κατά τη δημιουργία νέων δραστηριοτήτων.';
$string['configenablecompletion'] = 'Εάν ενεργοποιηθεί, σας επιτρέπει να ορίσετε συνθήκες ολοκλήρωσης μαθημάτων και δραστηριοτήτων. Ο καθορισμός συνθηκών ολοκλήρωσης δραστηριοτήτων συνιστάται, ώστε να εμφανίζονται σημαντικά δεδομένα για τους χρήστες στην επισκόπηση μαθημάτων τους στο Ταμπλό.';
$string['confirmselfcompletion'] = 'Επιβεβαίωση ολοκλήρωσης από τον ίδιο';
$string['courseaggregation'] = 'Απαίτηση συνθήκης';
$string['courseaggregation_all'] = 'ΟΛΑ τα επιλεγμένα μαθήματα να ολοκληρωθούν';
$string['courseaggregation_any'] = 'ΟΠΟΙΑΔΗΠΟΤΕ από τα επιλεγμένα μαθήματα να ολοκληρωθούν';
$string['coursealreadycompleted'] = 'Έχετε ήδη ολοκληρώσει αυτό το μάθημα';
$string['coursecomplete'] = 'Το μάθημα ολοκληρώθηκε';
$string['coursecompleted'] = 'Το μάθημα ολοκληρώθηκε';
$string['coursecompletedmessage'] = '<p>Συγχαρητήρια!</p><p>Έχετε ολοκληρώσει το μάθημα <a href="{$a->courselink}">{$a->coursename}</a>.</p>';
$string['coursecompletion'] = 'Ολοκλήρωση μαθήματος';
$string['coursecompletioncondition'] = 'Συνθήκη: {$a}';
$string['coursegrade'] = 'Βαθμός μαθήματος';
$string['coursesavailable'] = 'Διαθέσιμα μαθήματα';
$string['coursesavailableexplaination'] = 'Σημείωση: Πρέπει να οριστούν οι συνθήκες ολοκλήρωσης μαθήματος για να εμφανιστεί ένα μάθημα στην παραπάνω λίστα.';
$string['criteria'] = 'Κριτήρια';
$string['criteriagroup'] = 'Ομάδα κριτηρίων';
$string['criteriarequiredall'] = 'Όλα τα παρακάτω κριτήρια είναι απαραίτητα';
$string['criteriarequiredany'] = 'Τα παρακάτω κριτήρια είναι απαραίτητα';
$string['csvdownload'] = 'Λήψη σε μορφότυπο υπολογιστικού φύλλου (UTF-8 .csv)';
$string['datepassed'] = 'Ημερομηνία προβιβασμού';
$string['days'] = 'Ημέρες';
$string['daysoftotal'] = '{$a->days} από {$a->total}';
$string['defaultcompletion'] = 'Προεπιλεγμένη ολοκλήρωση δραστηριότητας';
$string['defaultcompletionupdated'] = 'Οι αλλαγές αποθηκεύτηκαν';
$string['deletecompletiondata'] = 'Διαγραφή δεδομένων ολοκλήρωσης';
$string['dependencies'] = 'Εξαρτήσεις';
$string['dependenciescompleted'] = 'Ολοκλήρωση';
$string['editcoursecompletionsettings'] = 'Επεξεργασία ρυθμίσεων ολοκλήρωσης μαθημάτων';
$string['enablecompletion'] = 'Ενεργοποίηση παρακολούθησης ολοκλήρωσης';
$string['enablecompletion_help'] = 'Αν ενεργοποιηθεί, οι συνθήκες ολοκλήρωσης δραστηριότητας μπορούν να οριστούν στις ρυθμίσεις δραστηριότητας και/ή μπορεί να οριστούν οι συνθήκες ολοκλήρωσης μαθήματος. Συνιστάται να ενεργοποιηθεί, ώστε να εμφανίζονται χρήσιμα δεδομένα στην επισκόπηση μαθημάτων στο Ταμπλό.';
$string['enrolmentduration'] = 'Διάρκεια εγγραφής';
$string['enrolmentdurationlength'] = 'Ο χρήστης πρέπει να παραμείνει εγγεγραμμένος για';
$string['err_noactivities'] = 'Δεν έχουν ενεργοποιηθεί οι πληροφορίες ολοκλήρωσης για καμία δραστηριότητα, οπότε δεν μπορεί να εμφανιστεί τίποτα. Μπορείτε να ενεργοποιήσετε τις πληροφορίες ολοκλήρωσης τροποποιώντας τις ρυθμίσεις μιας δραστηριότητας.';
$string['err_nocourses'] = 'Η ολοκλήρωση μαθήματος δεν είναι ενεργοποιημένη για άλλα μαθήματα, επομένως κανένα από αυτά δεν μπορεί να εμφανιστεί. Μπορείτε να ενεργοποιήσετε την ολοκλήρωση μαθήματος στις ρυθμίσεις μαθήματος.';
$string['err_nograde'] = 'Δεν έχει οριστεί βαθμός βάσης για αυτό το μάθημα. Για να ενεργοποιήσετε αυτόν τον τύπο κριτηρίων, θα πρέπει να εισάγετε ένα βαθμό βάσης για αυτό το μάθημα.';
$string['err_noroles'] = 'Δεν υπάρχουν ρόλοι με δυνατότητα moodle/course:markcomplete σε αυτό το μάθημα.';
$string['err_nousers'] = 'Δεν υπάρχουν χρήστες σε αυτό το μάθημα ή ομάδα για τους οποίους εμφανίζονται πληροφορίες ολοκλήρωσης. (Πληροφορίες ολοκλήρωσης εμφανίζονται μόνο για τους χρήστες με την δυνατότητα «Εμφάνιση στις αναφορές ολοκλήρωσης». Η δυνατότητα επιτρέπεται για τον προεπιλεγμένο ρόλο του μαθητή μόνο, οπότε αν δεν υπάρχουν μαθητές, θα δείτε αυτό το μήνυμα.)';
$string['err_settingslocked'] = 'Ένας ή περισσότεροι μαθητές έχουν ήδη ολοκληρώσει ένα κριτήριο, οπότε οι ρυθμίσεις έχουν κλειδωθεί. Το ξεκλείδωμα των ρυθμίσεων των κριτηρίων ολοκλήρωσης θα διαγράψει τυχόν υπάρχοντα δεδομένα χρήστη και μπορεί να προκαλέσει σύγχυση.';
$string['err_system'] = 'Σφάλμα κατά τη χρήση του συστήματος παρακολούθησης ολοκλήρωσης.';
$string['eventcoursecompleted'] = 'Το μάθημα ολοκληρώθηκε';
$string['eventcoursecompletionupdated'] = 'Ενημέρωση ολοκλήρωσης μαθήματος';
$string['eventcoursemodulecompletionupdated'] = 'Η ολοκλήρωση της δραστηριότητας μαθήματος ενημερώθηκε';
$string['eventdefaultcompletionupdated'] = 'Η προεπιλογή για την ολοκλήρωση της δραστηριότητας μαθημάτων ενημερώθηκε';
$string['excelcsvdownload'] = 'Λήψη σε αρχείο CSV (συμβατό με Microsoft Excel)';
$string['fraction'] = 'Κλάσμα';
$string['graderequired'] = 'Απαιτούμενος βαθμός μαθήματος';
$string['gradexrequired'] = 'Απαιτείται {$a}';
$string['hiddenrules'] = 'Ορισμένες ρυθμίσεις συγκεκριμένες για το <b>{$a}</b> έχουν κρυφτεί. Για να τις προβάλετε αποεπιλέξτε τις άλλες δραστηριότητες';
$string['inprogress'] = 'Σε εξέλιξη';
$string['manual'] = 'Χειροκίνητα';
$string['manualcompletionby'] = 'Χειροκίνητη ολοκλήρωση από άλλους';
$string['manualcompletionbynote'] = 'Σημείωση: Πρέπει να επιτρέπεται η δυνατότητα moodle/course:markcomplete για να εμφανιστεί ένας ρόλος στη λίστα.';
$string['manualselfcompletion'] = 'Χειροκίνητη αυτο-ολοκλήρωση';
$string['manualselfcompletionnote'] = 'Σημείωση: Το μπλοκ αυτο-ολοκλήρωσης θα πρέπει να προστεθεί στο μάθημα αν είναι ενεργοποιημένη η χειροκίνητη αυτο-ολοκλήρωση.';
$string['markcomplete'] = 'Επισήμανση ολοκλήρωσης';
$string['markedcompleteby'] = 'Επισήμανση ολοκλήρωσης από {$a}';
$string['markingyourselfcomplete'] = 'Επισήμανση αυτο-ολοκλήρωσης';
$string['modifybulkactions'] = 'Τροποποίηση των ενεργειών που θέλετε να επεξεργαστείτε μαζικά';
$string['moredetails'] = 'Περισσότερες λεπτομέρειες';
$string['nocriteriaset'] = 'Δεν έχουν οριστεί κριτήρια ολοκλήρωσης για αυτό το μάθημα';
$string['nogradeitem'] = 'Η υποχρεωτικότητα βαθμού δεν μπορεί να ενεργοποιηθεί για <b>{$a}</b> επειδή η δραστηριότητα δεν βαθμολογείται.';
$string['notcompleted'] = 'Δεν ολοκληρώθηκε';
$string['notenroled'] = 'Δεν είσαι εγγεγραμμένος σε αυτό το μάθημα';
$string['nottracked'] = 'Δεν παρακολουθείται, επί του παρόντος, η ολοκλήρωση αυτού του μαθήματος';
$string['notyetstarted'] = 'Δεν έχει ξεκινήσει ακόμα';
$string['overallaggregation'] = 'Απαιτήσεις ολοκλήρωσης';
$string['overallaggregation_all'] = 'Το μάθημα είναι ολοκληρωμένο όταν ΟΛΕΣ οι συνθήκες καλύπτονται';
$string['overallaggregation_any'] = 'Το μάθημα είναι ολοκληρωμένο όταν ΟΠΟΙΑΔΗΠΟΤΕ από τις συνθήκες καλύπτονται';
$string['pending'] = 'Σε εκκρεμότητα';
$string['periodpostenrolment'] = 'Περίοδος μετά την εγγραφή';
$string['privacy:metadata:completionstate'] = 'Εάν η δραστηριότητα έχει ολοκληρωθεί';
$string['privacy:metadata:course'] = 'Ένα αναγνωριστικό μαθήματος.';
$string['privacy:metadata:coursecompletedsummary'] = 'Αποθηκεύει πληροφορίες σχετικά με τους χρήστες που έχουν ολοκληρώσει τα κριτήρια σε ένα μάθημα';
$string['privacy:metadata:coursemoduleid'] = 'Το αναγνωριστικό της δραστηριότητας';
$string['privacy:metadata:coursemodulesummary'] = 'Αποθηκεύει δεδομένα ολοκλήρωσης δραστηριότητας για έναν χρήστη';
$string['privacy:metadata:coursesummary'] = 'Αποθηκεύει τα δεδομένα ολοκλήρωσης μαθήματος για έναν χρήστη.';
$string['privacy:metadata:gradefinal'] = 'Τελική βαθμολογία που έλαβε για την ολοκλήρωση του μαθήματος';
$string['privacy:metadata:overrideby'] = 'Το αναγνωριστικό χρήστη του ατόμου που παρέκαμψε την ολοκλήρωση της δραστηριότητας';
$string['privacy:metadata:reaggregate'] = 'Εάν έγινε επανάληψη συνάθροισης της ολοκλήρωσης του μαθήματος.';
$string['privacy:metadata:timecompleted'] = 'Πότε ολοκληρώθηκε το μάθημα.';
$string['privacy:metadata:timeenrolled'] = 'Πότε εγγράφηκε ο χρήστης στο μάθημα';
$string['privacy:metadata:timemodified'] = 'Πότε τροποποιήθηκε η ολοκλήρωση της δραστηριότητας';
$string['privacy:metadata:timestarted'] = 'Πότε ξεκίνησε το μάθημα.';
$string['privacy:metadata:unenroled'] = 'Αν έχει γίνει ακύρωση της εγγραφής του χρήστη στο μάθημα';
$string['privacy:metadata:userid'] = 'Το αναγνωριστικό χρήστη του ατόμου με (τα) δεδομένα ολοκλήρωσης μαθημάτων και δραστηριότητας';
$string['privacy:metadata:viewed'] = 'Αν η δραστηριότητα προβλήθηκε';
$string['progress'] = 'Πρόοδος μαθητών';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Πρόοδος: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'Αναγνώριση προηγούμενης εκπαίδευσης';
$string['remainingenroledfortime'] = 'Παραμένουν εγγεγραμμένοι για συγκεκριμένο χρονικό διάστημα';
$string['remainingenroleduntildate'] = 'Παραμένουν εγγεγραμμένοι μέχρι μια καθορισμένη ημερομηνία';
$string['reportpage'] = 'Εμφάνιση χρηστών {$a->from} έως {$a->to} από {$a->total}.';
$string['requiredcriteria'] = 'Απαιτούμενα κριτήρια';
$string['resetactivities'] = 'Διαγράψτε όλες τις επιλεγμένες δραστηριότητες και πόρους';
$string['restoringcompletiondata'] = 'Ανάκτηση δεδομένων ολοκλήρωσης';
$string['roleaggregation'] = 'Απαίτηση συνθήκης';
$string['roleaggregation_all'] = 'ΟΛΟΙ οι επιλεγμένοι ρόλοι για επισήμανση πότε καλύπτεται η συνθήκη';
$string['roleaggregation_any'] = 'ΟΠΟΙΟΣΔΗΠΟΤΕ από τους επιλεγμένους ρόλους για επισήμανση πότε καλύπτεται η συνθήκη';
$string['roleidnotfound'] = 'Αδυναμία εύρεσης αναγνωριστικού ρόλου {$a}';
$string['saved'] = 'Αποθηκεύτηκαν';
$string['seedetails'] = 'Δείτε λεπτομέρειες';
$string['select'] = 'Επιλογή';
$string['self'] = 'Ο ίδιος';
$string['selfcompletion'] = 'Αυτο-ολοκλήρωση';
$string['showinguser'] = 'Εμφάνιση χρήστη';
$string['unenrolingfromcourse'] = 'Ακύρωση εγγραφής σε μάθημα';
$string['unenrolment'] = 'Ακύρωση εγγραφής';
$string['unit'] = 'Μονάδα';
$string['unlockcompletion'] = 'Ξεκλείδωμα επιλογών ολοκλήρωσης';
$string['unlockcompletiondelete'] = 'Ξεκλείδωμα επιλογών ολοκλήρωσης και διαγραφή δεδομένων ολοκλήρωσης χρήστη';
$string['updateactivities'] = 'Ενημέρωση της κατάστασης ολοκλήρωσης των δραστηριοτήτων που ελέγχθηκαν';
$string['usealternateselector'] = 'Χρήση εναλλακτικού επιλογέα μαθήματος';
$string['usernotenroled'] = 'Ο χρήστης δεν είναι εγγεγραμμένος σε αυτό το μάθημα';
$string['viewcoursereport'] = 'Εμφάνιση αναφοράς μαθήματος';
$string['viewingactivity'] = 'Εμφάνιση {$a}';
$string['withconditions'] = 'Υπό συνθήκες';
$string['writingcompletiondata'] = 'Αποθήκευση δεδομένων ολοκλήρωσης';
$string['xdays'] = '{$a} ημέρες';
$string['yourprogress'] = 'Η πρόοδός σου';
