<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ar', version '3.10'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'على وشك التنصيب';
$string['accept'] = 'اقبل';
$string['action'] = 'الإجراء';
$string['actionchoice'] = 'ماذا تريد أن تفعل بالملف \'{$a}\'؟';
$string['actions'] = 'الإجراءات';
$string['actionsfor'] = 'إجراءات {$a}';
$string['actionsmenu'] = 'قائمة الإجراءات';
$string['active'] = 'نشط';
$string['activeusers'] = 'المستخدمون النشطون';
$string['activities'] = 'النشاطات';
$string['activities_help'] = 'نشاطات، كالمنتديات، الامتحانات القصيرة، والتعريفات (wikis) تمكن من إضافة محتوى تفاعلي للمقرر.';
$string['activity'] = 'نشاط';
$string['activityclipboard'] = 'يجري نقل هذا النشاط: {$a}';
$string['activityiscurrentlyhidden'] = 'عذراً، هذا النشاط ُمُخفى.';
$string['activitymodule'] = 'وحدة النشاط';
$string['activitymodules'] = 'وحدات النشاط';
$string['activityreport'] = 'تقرير النشاط';
$string['activityreports'] = 'تقارير النشاط';
$string['activityselect'] = 'اختر نقل هذا النشاط إلى مكانٍ آخر';
$string['activitysince'] = 'نشاط منذ {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'نشاط مقابل كل مستخدِم';
$string['add'] = 'إضافة';
$string['addactivity'] = 'أضف نشاطاً';
$string['addactivitytosection'] = 'أضف نشاطاً للزاوية \'{$a}\'';
$string['addadmin'] = 'أضف مشرفاً';
$string['addblock'] = 'أضف كتلة';
$string['addcomment'] = 'أضف تعليقاً...';
$string['addcountertousername'] = 'أنشئ حساب مستخدم بإضافة رقم لاسم المستخدم';
$string['addcreator'] = 'أضف منشئ مقرر';
$string['adddots'] = 'أضفـ...';
$string['added'] = 'أٌضِيف {$a}';
$string['addedtogroup'] = 'أٌضِيف للمجموعة "{$a}"';
$string['addedtogroupnot'] = 'لم تتم إضِافته للمجموعة "{$a}"';
$string['addedtogroupnotenrolled'] = 'لم تتم إضِافته للمجموعة "{$a}"، كونه غير مُسَجّل في المقرر الدراسي';
$string['addfilehere'] = 'اضف ملف(ات) هنا';
$string['addinganew'] = 'إضافة {$a} جديد(ة)';
$string['addinganewto'] = 'إضافة {$a->what} جديد إلى {$a->to}';
$string['addingdatatoexisting'] = 'أضافة بيانات للموجود';
$string['additionalnames'] = 'الأسماء الإضافية';
$string['addlinkhere'] = 'اضف رابطاً هنا';
$string['addnew'] = 'إضافة {$a} جديد';
$string['addnewcategory'] = 'إضافة تصنيف جديد';
$string['addnewcourse'] = 'إضافة مقرر دراسي جديد';
$string['addnewuser'] = 'إضافة مستخدم جديد';
$string['addnousersrecip'] = 'أضف المستخدمين الذين لم يطلعوا على {$a} إلى قائمة المستلمين';
$string['addpagehere'] = 'أضف نصاَ هنا';
$string['addresource'] = 'أضف مورد ...';
$string['addresourceoractivity'] = 'أضف نشاطاً أو مورداً';
$string['addresourcetosection'] = 'أضف مورداَ إلى الشعبة \'{$a}\'';
$string['address'] = 'العنوان';
$string['addsections'] = 'أضف شُعباَ';
$string['addstudent'] = 'أضف طالباً';
$string['addsubcategory'] = 'إضافة فئة فرعية';
$string['addteacher'] = 'أضف مدرساً';
$string['admin'] = 'مشرف';
$string['adminhelpaddnewuser'] = 'لإنشاء حساب مستخدم جديد يدويًا';
$string['adminhelpassignadmins'] = 'المشرفين بإمكانهم فعل كل شيء والتجول في كل مكان على الموقع';
$string['adminhelpassigncreators'] = 'يمكن لمنشئي المقررات الدراسية إنشاء مقررات جديدة';
$string['adminhelpassignsiteroles'] = 'أعط أدوار الموقع المُعرّفة لمستخدمين مخصصين';
$string['adminhelpassignstudents'] = 'اذهب إلى مقرر دراسي واضف الطلاب من خلال قائمة المشرف';
$string['adminhelpauthentication'] = 'يمكنك استخدام حسابات المستخدمين الداخليين أو قواعد البيانات الخارجية';
$string['adminhelpbackup'] = 'أضبط عمليات النسخ الاحتياطي الآلي وجدوله الزمني';
$string['adminhelpconfiguration'] = 'أضبط كيف يبدو الموقع وطريقة عمله';
$string['adminhelpconfigvariables'] = 'إضبط المتغيرات التي تؤثر على عمل الموقع بشكل عام';
$string['adminhelpcourses'] = 'عرِّف المقررات الدراسية والفئات وخصص الأشخاص لها ، ودقق المقررات الدراسية اللتي هي قيد الانتظار';
$string['adminhelpeditorsettings'] = 'حدد الإعدادات الأساسية لمحرر HTML';
$string['adminhelpedituser'] = 'تصفح حسابات المستخدمين وعدل أي منها';
$string['adminhelpenvironment'] = 'تحقق من كيفية مناسبة خادمك  لمتطلبات التثبيت الحالية والمستقبلية';
$string['adminhelpfailurelogs'] = 'تصفّحْ سجلاتَ محاولات الدخول الفاشلة';
$string['adminhelplanguage'] = 'لمراجعة وتحرير حزمة اللغة الحالية';
$string['adminhelplogs'] = 'استعراض سجلات جميع الأنشطة بالموقع';
$string['adminhelpmanageblocks'] = 'ادر الكتل المثبته وإعداداتها';
$string['adminhelpmanagedatabase'] = '(الوصول المباشر إلى قاعدة البيانات كن حذر!)';
$string['adminhelpmanagefilters'] = 'اختر منقحات النص والإعدادات ذات الصلة';
$string['adminhelpmanagemodules'] = 'إدارة الوحدات المنصبة وإعداداتها';
$string['adminhelpmanageroles'] = 'إنشاء وتعريف الأدوار التي يمكن تطبيقها على المستخدمين';
$string['adminhelpmymoodle'] = 'اعداد كتل مودل للمستخدمين';
$string['adminhelpreports'] = 'تقاير على مستوى الموقع';
$string['adminhelpsitefiles'] = 'لنشر الملفات العامة أو لتحميل نسخ إحتياطية من الخارج';
$string['adminhelpsitesettings'] = 'عرف مظهر الصفحة الاساسية للموقع';
$string['adminhelpstickyblocks'] = 'اعداد كتل مودل العامه';
$string['adminhelpthemes'] = 'إختر كيفية ظهور العناصر المكونة للموقع (الالوان، الخطوط....)';
$string['adminhelpuploadusers'] = 'استيراد حساب مستخدم جديد من ملف نصي';
$string['adminhelpusers'] = 'عرف مستخدمي موقعك وأعد طريقة التوثيق';
$string['adminhelpxmldbeditor'] = 'الواجه التي عن طريقها يمكن تحرير ملفات XMLDB. للمطورون فقط.';
$string['administration'] = 'الإدارة';
$string['administrationsite'] = 'إدارة الموقع';
$string['administrator'] = 'مدير';
$string['administratordescription'] = 'عادة يتسطيع المدارئ القيام بتنفيذ أي إجراء على الموقع في جميع المقررات الدراسية';
$string['administrators'] = 'مدراء';
$string['administratorsall'] = 'كل المدراء';
$string['administratorsandteachers'] = 'المدراء والمعلمون';
$string['advanced'] = 'متقدم';
$string['advancedfilter'] = 'بحث متقدم';
$string['advancedsettings'] = 'إعدادات متقدمة';
$string['afterresource'] = 'بعد المصدر "{$a}"';
$string['aftersection'] = 'بعد الجزء "{$a}"';
$string['again'] = 'مرة أخرى';
$string['agelocationverification'] = 'التحقق من العمر والمكان';
$string['aimid'] = 'تعريف AIM';
$string['ajaxuse'] = 'AJAX و Javascript';
$string['all'] = 'الكل';
$string['allactions'] = 'كل الإجراءات';
$string['allactivities'] = 'جميع الانشطة';
$string['allcategories'] = 'كافة التصنيفات';
$string['allchanges'] = 'كل التغييرات';
$string['alldays'] = 'كل الأيام';
$string['allfiles'] = 'كل الملفات';
$string['allgroups'] = 'كل المجموعات';
$string['alllogs'] = 'كل الوقوعات';
$string['allmods'] = 'كل {$a}';
$string['allow'] = 'إسمح';
$string['allowinternal'] = 'السماح بالطرق الداخلية';
$string['allownone'] = 'عدم السماح';
$string['allownot'] = 'لا تسمح';
$string['allowstealthmodules'] = 'السماح بالنشاطات المخفية';
$string['allowstealthmodules_help'] = 'عند تمكينها، سيكون بالإمكان جعل النشاطات موجودة ولكن غير ظاهرة ضمن مقاطع مرئية في صفحات المقررات الدراسية. في هذه الحالة، ينبغي وضع روابط للنشاطات المخفية في مكان آخر، مثلاً من مورد الصفحة. النشاطات المخفية ستظل مدرجة في سجل التقديرات وفي التقارير الأخرى.';
$string['allparticipants'] = 'كل المشاركين';
$string['allteachers'] = 'كل المعلمون';
$string['alphanumerical'] = 'لا يقبل إلا حروفا هجائية أو أرقاما أو - أو .';
$string['alreadyconfirmed'] = 'تم تأكيد التسجيل بالفعل';
$string['alternatename'] = 'الاسم البديل';
$string['always'] = 'دائماً';
$string['and'] = '{$a->one} واحد و{$a->two} أثنين';
$string['answer'] = 'الإجابة';
$string['any'] = 'أي';
$string['appearance'] = 'المظهر';
$string['approve'] = 'موافق عليه';
$string['areyousure'] = 'هل انت متأكد؟';
$string['areyousuretorestorethis'] = 'هل ترغب في المواصله؟';
$string['areyousuretorestorethisinfo'] = 'لاحقاً في هذا الإجراء ستخير لإضافة هذه النسخة الاحتياطية إلى مقرر دراسي موجود أو إنشاء مقرر دراسي جديد';
$string['asc'] = 'تصاعدي';
$string['assessment'] = 'تقييم';
$string['assignadmins'] = 'عين مدراء';
$string['assigncreators'] = 'عين منشئون';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'إسناد أدوار على مستوى الموقع';
$string['authenticateduser'] = 'المستخدم المصادق عليه';
$string['authenticateduserdescription'] = 'كل المستخدمين المتواجدين حالياً.';
$string['authentication'] = 'المصادقة';
$string['authenticationplugins'] = 'ملاحق المصادقة';
$string['autosubscribe'] = 'تسجيل آلى في المنتدى';
$string['autosubscribeno'] = 'لا: لا تقم بتسجيلي تلقائياً في المنتديات';
$string['autosubscribeyes'] = 'نعم: عند قيامي بالنشر، قم بتسجيلي في مناقشة المنتدى';
$string['availability'] = 'متاح';
$string['availablecourses'] = 'المقررات الدراسية المتاحة';
$string['back'] = 'العودة';
$string['backto'] = 'عودة إلى {$a}';
$string['backtocourselisting'] = 'عودة إلى قائمة المقررات الدراسية';
$string['backtohome'] = 'عودة إلى الصفحة الرئيسية للموقع';
$string['backtopageyouwereon'] = 'عودة إلى الصفحة التي كنت فيها';
$string['backup'] = 'حفظ إحتياطي';
$string['backupactivehelp'] = 'إختر تفعيل أو عدم تفعيل الحفظ الاحتياطي التلقائي.';
$string['backupadhocpending'] = 'مهمة النسخ الإحتياطي للمقرر معلّقة حالياً';
$string['backupcancelled'] = 'تم إلغاء الحفظ الاحتياطي';
$string['backupcoursefileshelp'] = 'تمكين هذه الخاصية سيسمح بإضافة ملفات المقرر الدراسي إلى الحفظ الاحتياطي التلقائي';
$string['backupdate'] = 'تاريخ النسخة الإحتياطية';
$string['backupdatenew'] = '{$a->TAG} الآن {$a->weekday}، {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} كان {$a->weekday}، {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'تفاصيل النسخة الإحتياطية';
$string['backuperrorinvaliddestination'] = 'مجلد الحفظ الاحتياطي غير موجود أو لا يمكن الكتابة فيه.';
$string['backupexecuteathelp'] = 'إختر وقت تشغيل الحفظ الاحتياطي التلقائي.';
$string['backupfailed'] = 'بعض مقرراتك الدراسية لم يتم حفظها';
$string['backupfilename'] = 'حفظ_إحتياطي';
$string['backupfinished'] = 'تم إكمال الحفظ الاحتياطي بنجاح';
$string['backupfromthissite'] = 'تم الانتهاء من النسخ الاحتياطي لهذا الموقع';
$string['backupgradebookhistoryhelp'] = 'عند التفعيل، سيتم تضمين ماضي سجل التقديرات في الحفظ الاحتياطي التلقائي. لاحظ أنه يجب ألا يتم إلغاء تفعيل ماضي سجل التقديرات في إعدادات الموقع (disablegradehistory) لكي يعمل هذا بشكل صحيح';
$string['backupincludemoduleshelp'] = 'حدد رغبتك بشأن إضافة وحدات المقرر الدراسي مع أو بدون معلومات المستخدمين في الحفظ الاحتياطي التلقائي';
$string['backupincludemoduleuserdatahelp'] = 'إختر إذا ما كنت تريد تضمين بيانات المستخدمين في الوحدات في الحفظ الاحتياطي التلقائي.';
$string['backuplogdetailed'] = 'سجل تنفيذي مفصل';
$string['backuploglaststatus'] = 'آخر سجل وقوعات للتنفيذ';
$string['backupmissinguserinfoperms'] = 'ملاحظة: هذه النسخة الاحتياطية لا تحوي أي بيانات مستخدمين. لن يتم تضمين نشاطات ورشات العمل والتدريبات في النسخة الاحتياطية، وذلك لأن هذه الوحدة غير متوافقة مع هذا النوع من النسخ الاحتياطي.';
$string['backupnext'] = 'الحفظ الاحتياطي القادم';
$string['backupnonisowarning'] = 'تحذير: هذه النسخة الإحتياطية عائدة إلى إصدار قديم من مودل (ما قبل 1.6) والتي لا تدعم ترميز يونيكود unicode. أي نصوص موجودة في هذه النسخة الاحتياطية بترميز غير ISO-8859-1 قد تصير معطوبة إذا حاولت استعادتها لهذا الإصدار من مودل. لمزيد من المعلومات حول استعادة هذه النسخة الاحتياطية بشكل صحيح انظر <a href="https://docs.moodle.org/en/Backup_FAQ">الأسئلة الشائعة حول النسخ الإحتياطي</a>';
$string['backupnotyetrun'] = 'الحفظ الاحتياطي التلقائي المعلق';
$string['backuporiginalname'] = 'Backup name';
$string['backuproleassignments'] = 'الحفظ الاحتياطي لتعيينات الأدوار الخاصة بهذه الأدوار';
$string['backupsavetohelp'] = 'المسار الكامل للمجلد الذي تريد أن تحفظ فيه ملفات الحفظ الاحتياطي';
$string['backupsitefileshelp'] = 'عند التفعيل سيتم تضمين ملفات الموقع المستعملة في المقررات الدراسية في الحفظ الاحتياطي التلقائي';
$string['backuptakealook'] = 'يرجى إلقاء نظرة على سجلات الحفظ الاحتياطي الخاصة بك في:
 {$a}';
$string['backupuserfileshelp'] = 'إختر ما إذا كنت ترغب بتضمين ملفات المستخدمين (مثل: صورهم الشخصية) في الحفظ الاحتياطي التلقائي';
$string['backupversion'] = 'إصدار النسخة الإحتياطية';
$string['badges'] = 'الشارات';
$string['block'] = 'كتلة';
$string['blockconfiga'] = 'يتم إعداد كتلة الـ {$a}';
$string['blockconfigbad'] = 'لم يتم تطبيق هذه الكتلة بشكل صحيح لهذا لا يمكن توفير واجهة للإعدادات.';
$string['blocks'] = 'الكتل';
$string['blocksaddedit'] = 'إضافة/تحرير الكتل';
$string['blockseditoff'] = 'تعطيل تحرير الكتل';
$string['blocksediton'] = 'تمكين تحرير الكتل';
$string['blocksetup'] = 'إعداد جداول الكتلة';
$string['blocksuccess'] = '{$a}  تم إعداد الجداول بشكل صحيح';
$string['brief'] = 'موجز';
$string['bulkactions'] = 'إجراءات بالجملة';
$string['bulkactionselect'] = 'إختيار إجراءات {$a} بالجملة';
$string['bulkmovecoursessuccess'] = 'تم نقل {$a->courses} من المقررات الدراسية بنجاح إلى {$a->category}';
$string['bycourseorder'] = 'حسب ترتيب المقرر الدراسي';
$string['byname'] = 'بواسطة {$a}';
$string['bypassed'] = 'مرور';
$string['cachecontrols'] = 'التحكم في الخبأ';
$string['calltofeedback'] = 'منشئ هذا البرنامج يرغب بمعرفة رأيك فيه.';
$string['calltofeedback_give'] = 'أعط رأيك عن هذا البرنامج';
$string['calltofeedback_remind'] = 'قم بتذكيري لاحقاً';
$string['cancel'] = 'إلغاء';
$string['cancelled'] = 'تم الإلغاء';
$string['categories'] = 'تصنيفات المقررات الدراسية';
$string['categoriesandcourses'] = 'المقررات وتصنيفاتها';
$string['category'] = 'التصنيف';
$string['categoryadded'] = 'تمت إضافة التصنيف \'{$a}\'';
$string['categorybulkaction'] = 'الاجراءات الجماعية لتصنيفات معينة';
$string['categorycontents'] = 'الفئات الفرعية والمقررات الدراسية';
$string['categorycurrentcontents'] = 'محتويات {$a}';
$string['categorydeleted'] = 'تم حذف التصنيف \'{$a}\'';
$string['categoryduplicate'] = 'اسم التصنيف \'{$a}\' موجود مسبقاً!';
$string['categoryhidden'] = '(مخفي)';
$string['categorymodifiedcancel'] = 'تم تعديل التصنيف! الرجاء التراجع والمحاولة مرة أخرى.';
$string['categoryname'] = 'اسم التصنيف';
$string['categorysubcategoryof'] = '{$a->category} - تصنيف فرعي من {$a->parentcategory}';
$string['categoryupdated'] = 'تم تحديث التصنيف \'{$a}\'';
$string['changedpassword'] = 'تم تغيير كلمة المرور';
$string['changepassword'] = 'تغيير كلمة المرور';
$string['changesmadereallygoaway'] = 'لقد أجريت تغييرات. هل أنت متأكد من رغبتك بالمغادرة من هنا وفقدان تغييراتك؟';
$string['changessaved'] = 'تم حفظ التغييرات';
$string['check'] = 'تحقق';
$string['checkall'] = 'إختر الكل';
$string['checkingbackup'] = 'التحقق من النسخة الإحتياطية';
$string['checkingcourse'] = 'التحقق من مقرر دراسي';
$string['checkingforbbexport'] = 'التحقق من تصدير  BlackBoard';
$string['checkinginstances'] = 'التحقق من حالات';
$string['checkingsections'] = 'التحقق من المقاطع';
$string['checklanguage'] = 'تأكد اللغة';
$string['checknone'] = 'لا تختر شيئاً';
$string['checks'] = 'الفحوص';
$string['checksok'] = 'كل الفحوصات \'{$a}\' ناجحة';
$string['childcoursenotfound'] = 'لم يتم العثور على مقرر دراسي فرعي';
$string['childcourses'] = 'مقررات دراسية فرعية';
$string['choose'] = 'إختر';
$string['choosecourse'] = 'اختر مقرر دراسي';
$string['choosedots'] = 'إختر...';
$string['chooselivelogs'] = 'أو شاهد النشاط الحالي';
$string['chooselogs'] = 'إختر سجلات الوقوعات التي تريد رؤيتها';
$string['choosereportfilter'] = 'اختر منقح للتقرير';
$string['choosetheme'] = 'إختر المظهر';
$string['chooseuser'] = 'إختر مستخدماً';
$string['city'] = 'المدينة/البلدة';
$string['cleaningtempdata'] = 'نظف المعلومات المؤقتة';
$string['clear'] = 'مسح';
$string['clearsearch'] = 'إخلاء إدخالات البحث';
$string['clickhelpiconformoreinfo'] = '... يتبع ... انقر على أيقونة المساعدة لقراءة المقال كاملاً';
$string['clickhere'] = 'اختر هنا';
$string['clicktochangeinbrackets'] = '{$a} (انقر للتغيير)';
$string['clicktohideshow'] = 'انقر للطي أو التوسيع';
$string['closebuttontitle'] = 'اغلاق';
$string['closewindow'] = 'أغلق هذه النافذة';
$string['collapse'] = 'طي';
$string['collapseall'] = 'طي الكل';
$string['collapsecategory'] = 'طي {$a}';
$string['commentincontext'] = 'بحث عن هذا التعليق في السياق';
$string['comments'] = 'التعليقات';
$string['commentscount'] = 'التعليقات ({$a})';
$string['commentsnotenabled'] = 'خاصية التعليقات غير ممكنة';
$string['commentsrequirelogin'] = 'لا بد لك من تسجيل الدخول لمعاينة التعليقات.';
$string['comparelanguage'] = 'قارن وعدل اللغة الحالية';
$string['complete'] = 'كامل';
$string['completereport'] = 'تقرير كامل';
$string['configuration'] = 'إعدادات الموقع';
$string['confirm'] = 'التأكيد';
$string['confirmcheckfull'] = 'هل أنت متأكد تمامًا من رغبتك في تأكيد {$a} ؟';
$string['confirmcoursemove'] = 'هل أنت متأكد من رغبتك في نقل هذا المقرر ({$a->course}) إلى هذا التصنيف ({$a->category})؟';
$string['confirmdeletesection'] = 'هل أنت متأكد تماماً أنك تريد حذف"{$a}"  وجميع الأنشطة التي يتضمنها؟';
$string['confirmed'] = 'تم تأكيد تسجيلك';
$string['confirmednot'] = 'لم يتم تأكيد تسجيلك بعد. يرجى التحقق من صندوق البريد الخاص بك للحصول على رسالة تأكيد بالبريد الالكتروني.';
$string['considereddigitalminor'] = 'أنت أصغر من أن تنشئ حسابًا على هذا الموقع.';
$string['content'] = 'المحتوى';
$string['contentbank'] = 'بنك المحتوى';
$string['contentexport_aboutthiscourse'] = 'ملخص المقرر الدراسي';
$string['contentexport_coursesummary'] = 'هذا الملف هو جزء من المحتوى المنزل من <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'هذا الملف هو جزء من المحتوى المنزل من <a href="{$a->courselink}">{$a->coursename}</a> من قِبَل {$a->userfullname} بتاريخ {$a->date}.';
$string['contentexport_modulesummary'] = 'هذه الصفحة هي جزء من المحتوى المنزل من <a href="{$a->modulelink}">{$a->modulename}</a> بتاريخ {$a->date}. لاحظ أن بعض المحتوى وأي ملفات أكبر من {$a->maxfilesize} لم يتم تنزيلها.';
$string['contentexport_viewfilename'] = 'معاينة الملف {$a}';
$string['continue'] = 'استمر';
$string['continuetocourse'] = 'أنقر هناء للدخول إلى مقررك الدراسي';
$string['convertingwikitomarkdown'] = 'تحويل ويكي (Wiki) إلى مارك داون (Markdown)';
$string['cookiesenabled'] = 'ينبغي تمكين ملفات تعريف الارتباط في متصفحك';
$string['cookiesenabled_help'] = 'يستعمل الموقع نوعين من ملفات تعريف الارتباط:

الأساسي منها هو ما يتعلق بجلسة العمل الحالية، عادة ما تدعى MoodleSession.
للحفاظ على استمرارية دخولك إلى مودل والتنقل ما بين من صفحاته، يجب
عليك السماح لمتصفحك بحفظ ملفات تعريف الارتباط هذه عبر إعداداته. عند الخروج من
مودل أو إغلاقك للمتصفح ستحذف هذه الملفات (من متصفحك ومن المخدم).

النوع الآخر من ملفات تعريف الارتباط هي فقط لإعطاء نوع من الراحة للمستخدمين، وعادة ما تدعى MOODLEID أو تسمية مشابهة. مهامه تتلخص بتذكر اسم المستخدم وكلمة المرور من خلال متصفحك. هذا يعني أنه كلما رغبت في الدخول إلى مودل ستجد اسم المستخدم وكلمة المرور محفوظة في متصفحك. من الآمن لك رفض، أوعدم تمكين هذا النوع من ملفات تعريف الارتباط - قد تحتاج عندها إلى إعادة كتابة اسم المستخدم وكلمة المرور عند دخولك إلى مودل كل مرة.';
$string['cookiesenabledonlysession'] = 'ينبغي تمكين ملفات تعريف الارتباط في متصفحك';
$string['cookiesenabledonlysession_help'] = 'يستعمل هذا الموقع ملف تعريف ارتباط لجلسة واحدة، يُطلق عليه عادةً MoodleSession. ينبغي أن تسمح لملف تعريف الارتباط هذا في المستعرض الخاص بك لتوفير الاستمرارية والبقاء مسجلًا لدخولك عند تصفح الموقع. عندما تقوم بتسجيل الخروج أو إغلاق المتصفح، يتم إتلاف ملف تعريف الارتباط هذا (في المستعرض والمخدم).';
$string['cookiesnotenabled'] = 'لسوء الحظ، ملفات تعريف الارتباط غير مُمَكَّنة في متصفحك';
$string['copy'] = 'نسخ';
$string['copyasnoun'] = 'نسخ';
$string['copycourse'] = 'نسخ المقرر الدراسي';
$string['copyingcoursefiles'] = 'نسخ ملفات مقرر دراسي';
$string['copyingsitefiles'] = 'يتم نسخ ملفات الموقع المستخدمة في مقرر دراسي';
$string['copyinguserfiles'] = 'نسخ ملفات المستخدم';
$string['copyingzipfile'] = 'نسخ ملف مضغوط';
$string['copyrightnotice'] = 'تنويه الحقوق الفكرية';
$string['coresystem'] = 'النظام';
$string['cost'] = 'القيمة';
$string['costdefault'] = 'الكلفة الافتراضية';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'الدولة';
$string['course'] = 'المقرر الدراسي';
$string['courseadministration'] = 'إدارة المقرر الدراسي';
$string['courseapprovedemail'] = 'لقد تمت الموافقة على المقرر الدراسي،{$a->name} ،الذي قمت بطلبه، وقد تم تعيينك،{$a->teacher} . للوصول لمقررك الدراسي الجديد أذهب إلى {$a->url}';
$string['courseapprovedemail2'] = 'تمت الموافقة على المقرر الدراسي {$a->name}، الذي طلبته. للوصول إليه، إذهب إلى {$a->url}';
$string['courseapprovedfailed'] = 'فشل حفظ المقرر الدراسي كمقرر تمت الموافقة عليه!';
$string['courseapprovedsubject'] = 'تمت الموافقة على مقررك الدراسي!';
$string['courseavailable'] = 'هذاالمقرر الدراسي متوفر للطلاب';
$string['courseavailablenot'] = 'هذاالمقرر الدراسي غير متوفر للطلاب';
$string['coursebackup'] = 'الحفظ الاحتياطي للمقرر';
$string['coursebulkaction'] = 'الا جراءات الجماعية لمقررات معينة';
$string['coursecategories'] = 'أصناف مقرر دراسي';
$string['coursecategory'] = 'تصنف المقرر الدراسي';
$string['coursecategory_help'] = 'هذا الإعداد يحدد التصنيف الذي سيظهر فيه المقرر في قائمة المقررات الدراسية.';
$string['coursecategorydeleted'] = 'تم حذف تصنيف المقرر الدراسي {$a}';
$string['coursecatmanagement'] = 'إدارة المقررات الدراسية والتصنيفات';
$string['coursecompletion'] = 'إكمال المقرر الدراسي';
$string['coursecompletions'] = 'إكمال المقررات الدراسية';
$string['coursecreators'] = 'منشئ المقرر الدراسي';
$string['coursecreatorsdescription'] = 'منشئو المقررات الدراسية يمكنهم إنشاء مقررات جديدة.';
$string['coursedeleted'] = 'تم حذف المقرر الدراسي {$a}';
$string['coursedetails'] = 'تفاصيل المقررات الدراسية';
$string['coursedisplay'] = 'مخطط المقرر الدراسي';
$string['coursedisplay_help'] = 'يحدد هذا الإعداد ما إذا كان يتم عرض جميع محتويات المقرر الدراسي في صفحة واحدة أو يتم تقسيمه على عدة صفحات.';
$string['coursedisplay_multi'] = 'أظهر مقطعاً واحداً في الصفحة';
$string['coursedisplay_single'] = 'أظهر كل المقاطع في صفحة واحدة';
$string['courseduration'] = 'مدة المقرر الدراسي';
$string['courseduration_desc'] = 'تُستعمل المدة الزمنية للمقرر لحساب التاريخ الافتراضي لانتهائه. هذا التاريخ يستعمل لتقرير ما إذا كان يجب عرض المقرر ضمن قائمه مقررات الطالب. كذلك يمكن استخدامه في تقارير خاصة. مع ذلك، يستطيع المستخدم الوصول إلى المقرر حتى بعد تاريخ انتهائه.';
$string['courseenddateenabled'] = 'تاريخ انتهاء المقرر الدراسي مُمَكَّن تلقائياً';
$string['courseenddateenabled_desc'] = 'هذا الإعداد يحدد فيما إذا كان سيتم تفعيل تاريخ الانتهاء بشكل افتراضي للمقررات الجديدة وتحديده بتاريخ محتسب على أساس مدة المقرر الزمنية.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'ملفات مقرر سالف';
$string['coursefilesedit'] = 'تحرير ملفات المقرر الدراسي القديمة';
$string['coursefileswarning'] = 'ملفات المقرر الدراسي متقادمة';
$string['coursefileswarning_help'] = 'ملفات المقرر الدراسي تم التخلي عنها منذ مودل 2.0، الرجاء استعمال مستودعات خارجية بدلاً منها قدر المستطاع.';
$string['courseformatdata'] = 'بيانات تنسيق المقرر الدراسي';
$string['courseformatoptions'] = 'خيارات التنسيق لـ {$a}';
$string['courseformats'] = 'تنسيقات المقررات الدراسية';
$string['courseformatudpate'] = 'تحديث التنسيق';
$string['coursegrades'] = 'درجات  مقرر دراسي';
$string['coursehelpcategory'] = 'يضع المقرر الدراسي في قائمة المقررات الدراسية ويصبح من الأسهل على الطلاب إيجادها.';
$string['coursehelpforce'] = 'فرض نمط المجموعات على كل النشاطات.';
$string['coursehelpformat'] = 'ستظهر صفحة المقرر الرئيسية بهذا التنسيق';
$string['coursehelphiddensections'] = 'كيف سيتم عرض المقاطع المخفية من المقرر الدراسي على الطلاب.';
$string['coursehelpmaximumupload'] = 'حدد الحجم الأقصى للملف الذي يمكن رفعه في هذا المقرر الدراسي، محدداً بإعدادات الحد الأقصى لرفع الملفات في الموقع.';
$string['coursehelpnewsitemsnumber'] = 'عدد الإعلانات التي تظهر في كتلة الإعلانات الأخيرة في صفحة المقرر الدراسي. عند جعله صفراً، لن يتم إنشاء منتدى الإعلانات.';
$string['coursehelpnumberweeks'] = 'عدد الأقسام في المقرر (ينطبق على بعض تنسيقات المقررات فقط).';
$string['coursehelpshowgrades'] = 'تمكين عرض سجل التقديرات. هذا لا يمنع عرض العلامات ضمن النشاطات المنفردة.';
$string['coursehidden'] = 'هذا المقرر الدراسي غير متاح للطلاب حالياً';
$string['courseinfo'] = 'معلومات المقرر الدراسي';
$string['courselegacyfiles'] = 'ملفات مقرر سالف';
$string['courselegacyfiles_help'] = 'توفر مساحة ملفات المقرر الدراسي بعض التوافق الرجعي مع مودل 1.9 وما قبله. جميع الملفات في هذه المساحة متاحة دائماً لجميع المشاركين في المقرر الدراسي (سواءً وضعت روابط إليها أم لا) كما أنه لا مجال لمعرفة أين يستعمل أيٌ من هذه الملفات في مودل.

إذا كنت ستستعمل هذه المساحة لتخزين ملفات المقرر الدراسي، فقد تعرض نفسك لمجموعة من مسائل الأمان والخصوصية، وكذلك تواجه فقدان الملفات عند الحفظ الاحتياطي، مستوردات المقرر، وفي أي وقت يتم فيه مشاركة المحتوى أو إعادة استعماله. لهذا فإنه يوصى بعدم استعمال هذه المساحة إلا إذا كنت حقاً تعرف ماذا تفعل.';
$string['courselegacyfilesofcourse'] = 'ملفات المقرر القديمة: {$a}';
$string['coursenotaccessible'] = 'لا يسمح بدخول العموم لهذا المقرر الدراسي';
$string['courseoverview'] = 'استعراض المقرر الدراسي';
$string['courseoverviewfiles'] = 'صورة المقرر الدراسي';
$string['courseoverviewfiles_help'] = 'يتم عرض صورة المقرر في لوحة استعراض المقررات الدراسية ضمن لوحة التحكم. قد يتم تمكين أنواع إضافية من الملفات المقبولة وأكثر من ملف واحد من قبل مشرف الموقع. إذا كان الأمر كذلك، سيتم عرض هذه الملفات بجوار ملخص المقرر في صفحة قائمة المقررات الدراسية.';
$string['courseoverviewfilesext'] = 'إمتدادات ملفات صور المقرر الدراسي';
$string['courseoverviewfileslimit'] = 'محدد عدد ملفات صور المقررات الدراسية';
$string['courseoverviewgraph'] = 'الرسم البياني لاستعراض المقرر الدراسي';
$string['coursepreferences'] = 'تفضيلات المقرر الدراسي';
$string['courseprofiles'] = 'الملفات الشخصية في المقررات الدراسية';
$string['coursereasonforrejecting'] = 'أسباب رفضك لهذا الطلب';
$string['coursereasonforrejectingemail'] = 'سوف يتم إرسال هذا إلى صاحب الطلب';
$string['coursereject'] = 'أرفض طلب مقرر دراسي';
$string['courserejected'] = 'تم رفض المقرر الدارسي، وتم إشعار صاحب الطلب';
$string['courserejectemail'] = 'عذراً، لقد تم رفض المقرر الدراسي الذي قمت بطلبه، وذلك للأسباب التالية:

{$a}';
$string['courserejectreason'] = 'لخّصْ أسبابَكَ لرَفْض هذا المقرر الدراسي';
$string['courserejectsubject'] = 'لقد تم رفض طلبلك للحصول على مقرر دراسي';
$string['coursereport'] = 'تقرير المقرر';
$string['coursereports'] = 'تقارير مقرر دراسي';
$string['courserequest'] = 'طلب المقرر الدراسي';
$string['courserequestdetails'] = 'تفاصيل المقرر الذي تطلبه';
$string['courserequestfailed'] = 'لسبب ما، لم يتم حفظ طلبك للمقرر الدراسي';
$string['courserequestintro'] = 'أستخدم هذا النموذج لطلب إنشاء مقرر دراسي لك. <br /> الرجاء تعبئة جميع الحقول ليتسنى لمدير الموقع فهم الاسباب الداعية لحاجتك لهذا المقرر الدراسي';
$string['courserequestreason'] = 'اسباب طلب هذا المقرر الدراسي';
$string['courserequestsuccess'] = 'تم حفظ طلبك للمقرر بنجاح. سيتم إعلامك عبر البريد الالكتروني فيما إذا تمت الموافقة عليه.';
$string['courserequestsupport'] = 'معلومات داعمة تساعد المشرف في تقييم هذا الطلب';
$string['courserequestwarning'] = 'المستخدم الذي يطلب هذا المقرر الدراسي سيتم تسجيله  تلقائياً وتعيينه بدور {$a}.';
$string['courserestore'] = 'إسترجاع  مقرر دراسي';
$string['courses'] = 'المقررات الدراسية';
$string['coursesearch'] = 'ابحث المقررات';
$string['coursesearch_help'] = 'يمكنك البحث عن كلمات متعددة في آن واحد كما يمكن تضييق نطاق البحث على النحو الآتي:

* الكلمة - أبحث عما يحاكي هذه الكلمة ضمن النص.
* +الكلمة - فقط الكلمات المُطابقة تماماً سيُبحث عنها.
* -الكلمة - إقصاء النتائج التي تحتوي على هذه الكلمة.

ملاحظة: لا تضع فراغاً ما بين علامتي + أو - والكلمة اللاحقة لهما';
$string['coursesectionsummaries'] = 'ملخصات مقاطع المقرر الدراسي';
$string['coursesectiontitle'] = 'المقرر: {$a->course}، {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'الإعدادات الافتراضية للمقررات الدراسية';
$string['coursesmovedout'] = 'تم نقل المقرر الدراسي من {$a}';
$string['coursespending'] = 'مقررات بانتظار الموافقة';
$string['coursestart'] = 'بدء مقرر دراسي';
$string['coursesummary'] = 'ملخص المقرر الدراسي';
$string['coursesummary_help'] = 'ملخص المقرر يتم عرضه في قائمة المقررات الدراسية. عند البحث، يتم النظر في نصوص ملخصات المقررات الدراسية فضلاً عن أسمائها.';
$string['coursetitle'] = 'المقرر: {$a->course}';
$string['courseupdates'] = 'تحديثات المقررات الدراسية';
$string['coursevisibility'] = 'إظهار المقرر الدراسي';
$string['coursevisibility_help'] = 'هذا الإعداد يحدد ما إذا كان المقرر سيظهر في قائمة المقررات الدراسية وما إذا كان الطلاب يمكنهم الوصول إليها. إذا تم اختيار إخفاء المقرر، فسوف يقتصر الوصول إلى المقرر على المستخدمين الذين لديهم القدرة على استعراض المقررات الدراسية المخفية (مثل المدرسين).';
$string['create'] = 'إنشاء';
$string['createaccount'] = 'إنشاء حساب مشترك الجديد';
$string['createcategory'] = 'إنشاء التصنيف';
$string['createfolder'] = 'إنشاء مجلد في {$a}';
$string['createnew'] = 'إنشاء جديد';
$string['createnewcategory'] = 'إنشاء تصنيف جديد';
$string['createnewcourse'] = 'إنشاء مقرر دراسي جديد';
$string['createnewsubcategory'] = 'إنشاء تصنيف فرعي جديد';
$string['createsubcategoryof'] = 'إنشاء تصنيف فرعي من {$a}';
$string['createuser'] = 'إنشاء مستخدم';
$string['createuserandpass'] = 'إختر اسم المستخدم وكلمة المرور للدخول بهما فيما بعد';
$string['createziparchive'] = 'إنشاء أرشيف مضغوط';
$string['creatingblocks'] = 'يجري إنشاء كتلة';
$string['creatingblocksroles'] = 'تكوين مهام وتعديلات أدوار على مستوى الكتل';
$string['creatingblogsinfo'] = 'معلومات إنشاء المدونات';
$string['creatingcategoriesandquestions'] = 'إنشاء تصنيفات واسئلة';
$string['creatingcoursemodules'] = 'إنشاء وحدة مقرر دراسي';
$string['creatingcourseroles'] = 'تكوين مهام وتعديلات أدوار على مستوى المقرر';
$string['creatingevents'] = 'إنشاء الأحداث';
$string['creatinggradebook'] = 'إنشاء سجل درجات';
$string['creatinggroupings'] = 'إنشاء تجميعات';
$string['creatinggroupingsgroups'] = 'إضافة المجموعات إلى التجمعات';
$string['creatinggroups'] = 'إنشاء مجموعات';
$string['creatinglogentries'] = 'إنشاء مداخل سجلات';
$string['creatingmessagesinfo'] = 'إنشاء معلومات الرسائل';
$string['creatingmodroles'] = 'تكوين مهام وتعديلات أدوار على مستوى الوحدة';
$string['creatingnewcourse'] = 'إنشاء مقرر  دراسي جديد';
$string['creatingrolesdefinitions'] = 'إنشاء تعاريف الأدوار';
$string['creatingscales'] = 'إنشاء مقاييس';
$string['creatingsections'] = 'إنشاء مقاطع';
$string['creatingtemporarystructures'] = 'إنشاء هياكل مؤقتة';
$string['creatinguserroles'] = 'تكوين مهام وتعديلات أدوار على مستوى المستخدم';
$string['creatingusers'] = 'إنشاء مستخدمين';
$string['creatingxmlfile'] = 'إنشاء ملف XML';
$string['currency'] = 'عملة';
$string['currentcourse'] = 'المقرر الحالي';
$string['currentcourseadding'] = 'إضافة معلومات للمقرر الدراسي الحالي';
$string['currentcoursedeleting'] = 'حذف المقرر الدراسي الحالي أولاً';
$string['currentlanguage'] = 'اللغة الحالية';
$string['currentlocaltime'] = 'التوقيت المحلي الحالي';
$string['currentpicture'] = 'الصورة الحالية';
$string['currentrelease'] = 'معلومات الإصدار الحالي';
$string['currentversion'] = 'الاصدار الحالي';
$string['databasechecking'] = 'تحديث قاعدة بيانات مودل من الإصدار {$a->oldversion} إلى {$a->newversion}';
$string['databaseperformance'] = 'أداء قاعدة البيانات';
$string['databasesetup'] = 'تنصيب قاعدة البيانات';
$string['databasesuccess'] = 'تم تحديث قاعدة البيانات بنجاح';
$string['databaseupgradebackups'] = 'النسخ الإحتياطي للإصدرا الآن {$a}';
$string['databaseupgradeblocks'] = 'إصدار الكتل الان هو {$a}';
$string['databaseupgradegroups'] = 'إصدار المجموعات الان هو {$a}';
$string['databaseupgradelocal'] = 'تخصيص أصدار قاعدة البيانات المحليه الآن {$a}';
$string['databaseupgrades'] = 'تحديث قاعدة البيانات';
$string['dataformats'] = 'تنسيق البيانات';
$string['date'] = 'تاريخ';
$string['datechanged'] = 'تم تغير التاريخ';
$string['datemostrecentfirst'] = 'التاريخ - الاحدث أولاً';
$string['datemostrecentlast'] = 'التاريخ - الاحدث أخراً';
$string['day'] = 'يوم';
$string['days'] = 'أيام';
$string['decodinginternallinks'] = 'تشفير الروابط الداخلية';
$string['default'] = 'الافتراضي';
$string['defaultcompetencescale'] = 'المقياس الافتراضي للكفاءة';
$string['defaultcompetencescaledesc'] = 'مقياس التصنيف الثنائي والذي لا يقدم معلومات إضافية أبعد عما إذا كان شخص ما قد أثبت كفاءة أم لا.';
$string['defaultcompetencescalenotproficient'] = 'غير مؤهل بعد';
$string['defaultcompetencescaleproficient'] = 'مؤهل';
$string['defaultcoursestudent'] = 'طالب';
$string['defaultcoursestudentdescription'] = 'لدى الطلاب عادة امتيازات أقل في المقرر.';
$string['defaultcoursestudents'] = 'الطلاب';
$string['defaultcoursesummary'] = 'اكتب فقرة مختصرة تشرح فيها موضوع المقرر الدراسي';
$string['defaultcourseteacher'] = 'معلم';
$string['defaultcourseteacherdescription'] = 'يمكن للمدرس القيام بأي شيء بالمقرر، من تعديل النشاطات وإعطاء علامات للطلاب.';
$string['defaultcourseteachers'] = 'معلمون';
$string['defaulteditor'] = 'المحرر الافتراضي';
$string['defaulthomepageuser'] = 'الصفحة الرئيسية';
$string['defaulthomepageuser_help'] = 'صفحتك الرئيسية هي أول رابط في التصفح.';
$string['delete'] = 'حذف';
$string['deleteablock'] = 'حذف كتلة';
$string['deleteall'] = 'حذف الكل';
$string['deleteallcannotundo'] = 'حذف الكل - لا يمكن التراجع عنه';
$string['deleteallcomments'] = 'حذف جميع التعليقات';
$string['deleteallratings'] = 'حذف كل التقييمات';
$string['deletecategory'] = 'حذف التصنيف: {$a}';
$string['deletecategorycheck'] = 'هل انت متأكدللقيام بحذف هذا الصنف تماما<b>\'{$a}\'</b>?<br /> كل المقررات دراسية ستنقل ألى الصنف الرئيس لو وجد صنف رئيس، أو إلى منوعات.';
$string['deletecategorycheck2'] = 'إذا حذفت هذه التصنيف، سيكون عليك تحديد ماذا ستفعل بالمقررات الدراسية والتصنيفات الفرعية المحتواة بها.';
$string['deletecategoryempty'] = 'هذا التصنيف فارغ';
$string['deletecheck'] = 'حذف {$a} ؟';
$string['deletecheckfiles'] = 'هل أنت متأكد تمام القيام بعملية حذف هذه الملفات';
$string['deletecheckfull'] = 'هل أنت متأكد تماماً من رغبتك في حذف المستخدم {$a}، شاملاً ذلك انضماماته، نشاطاته وبياناته الأخرى؟';
$string['deletechecktype'] = 'هل أنت متأكد من رغبتك في حذف هذا {$a->type}؟';
$string['deletechecktypename'] = 'هل أنت متأكد من رغبتك في حذف هذا {$a->type} "{$a->name}"؟';
$string['deletecheckwarning'] = 'أنت على وشك حذف هذه الملفات';
$string['deletecommentbyon'] = 'أزل الملاحظة المضافة من قبل {$a->user} في {$a->time}';
$string['deletecompletely'] = 'حذف كامل';
$string['deletecourse'] = 'حذف مقرر دراسي';
$string['deletecoursecheck'] = 'هل أنت متأكدأنك تريد حذف هذا المقرر الدراسي بكل ما يحتويه من بيانات؟';
$string['deleted'] = 'تم الحذف';
$string['deletedactivity'] = 'تم الحذف {$a}';
$string['deletedcourse'] = '{$a} تم حذفه بالكامل';
$string['deletednot'] = 'تعذر الحذف {$a} !';
$string['deletepicture'] = 'حذف';
$string['deletesection'] = 'إحذف المقطع';
$string['deleteselected'] = 'حذف المختار';
$string['deleteselectedkey'] = 'حذف المفتاح المحدد';
$string['deletingcourse'] = 'حذف {$a}';
$string['deletingexistingcoursedata'] = 'حذف معلومات المقرر الدراسي الموجودة';
$string['deletingolddata'] = 'حذف معلومات القديمة';
$string['department'] = 'القسم';
$string['deprecatedeventname'] = '{$a} (لم تعد مستخدمه)';
$string['desc'] = 'تنازلي';
$string['description'] = 'الوصف';
$string['descriptiona'] = 'الوصف : {$a}';
$string['deselectall'] = 'إلغاء تحديد الكل';
$string['deselectnos'] = 'إلغاء إختيار كل ما هو \'لا\'';
$string['detailedless'] = 'تفاصيل أقل';
$string['detailedmore'] = 'تفاصيل أكثر';
$string['details'] = 'التفاصيل';
$string['digitalminor'] = 'قاصر رقمي';
$string['digitalminor_desc'] = 'الرجاء اطلب من الوالد / ولي الأمر الاتصال بـ :';
$string['directory'] = 'دليل';
$string['disable'] = 'تعطيل';
$string['disabledcomments'] = 'تم إيقاف التعليقات';
$string['dismissnotification'] = 'تجاهل هذا الإشعار';
$string['displayingfirst'] = 'فقط الاول {$a->count} {$a->things} سيعرض';
$string['displayingrecords'] = 'عرض {$a} السجلات';
$string['displayingusers'] = 'عرض المستخدمين {$a->start} إلى {$a->end}';
$string['displayonpage'] = 'العرض في الصفحة';
$string['dndcourse'] = 'يمكنك سحب وإفلات هذا المقرر لتغيير ترتيبه أو لنقله إلى تصنيف آخر.';
$string['dndenabled_inbox'] = 'تستطيع سحب وإفلات الملفات هنا لإضافتها';
$string['dndnotsupported'] = 'الرفع بالسحب والإفلات غير مدعوم';
$string['dndnotsupported_help'] = 'متصفحك لا يدعم رفع الملفات عبر السحب والإفلات. هذه الميزة متوفرة في كل النسخ الحديثة من كروم وفيرفوكس وسفاري وانترنت اكسبلورر، الإصدار 10 أو أعلى';
$string['dndnotsupported_insentence'] = 'السحب والإفلات غير ممكن';
$string['dnduploadwithoutcontent'] = 'لم يتم اختيار ملف صالح';
$string['dndworkingfile'] = 'قم بسحب وإفلات الملفات الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkingfilelink'] = 'قم بسحب وإفلات الملفات أو الروابط الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkingfiletext'] = 'قم بسحب وإفلات الملفات أو النصوص الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkingfiletextlink'] = 'قم بسحب وإفلات الملفات، الروابط أو النصوص الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkinglink'] = 'قم بسحب وإفلات الروابط الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkingtext'] = 'قم بسحب وإفلات النصوص الى مقاطع المقرر الدراسي ليتم رفعها';
$string['dndworkingtextlink'] = 'قم بسحب وإفلات الروابط أو النصوص الى مقاطع المقرر الدراسي ليتم رفعها';
$string['documentation'] = 'توثيقات مودل';
$string['dontsortcategories'] = 'لا تقم بفرز الاصناف';
$string['dontsortcourses'] = 'لا تقم بفرز المقررات';
$string['down'] = 'أسفل';
$string['download'] = 'التنزيل';
$string['downloadall'] = 'تنزيل الكل';
$string['downloadexcel'] = 'التنزيل بصيغة Excel';
$string['downloadfile'] = 'تنزيل الملف';
$string['downloadods'] = 'التنزيل بصيغة ODS';
$string['downloadtext'] = 'التنزيل بصيغة نص';
$string['doyouagree'] = 'هل قمت بقراءة هذه الشروط واستيعابها؟';
$string['droptoupload'] = 'أفلت الملفات هنا لرفعها';
$string['duplicate'] = 'نسخ مطابق';
$string['duplicatedmodule'] = '(نسخة) {$a}';
$string['edhelpaspellpath'] = 'لاستعمال المدقق الإملائي ضمن المحرر، ينبغي أن يكون الإصدار <strong>aspell 0.50</strong> أو أحدث منصب في المخدم الخاص بك. كما ينبغي عليك تحديد المسار الصحيح للوصول إلى ملفات تنفيذ aspell. في الغالب المسار يكون في أنظمة يونكس/لينكس هو <strong>/usr/bin/aspell</strong>، ولكن من المحتمل أن يكون غير ذلك.';
$string['edhelpbgcolor'] = 'عرف لون خلفية المحرر.<br /> القيم المتعارف عليها على سبيل المثال هي:  #ffffff للون الأبيض.';
$string['edhelpcleanword'] = 'هذا الإعداد لتفعيل أو تعطيل مرشح التنسيق الخاص بماكرو سوف وررد.';
$string['edhelpenablespelling'] = 'تمكين أو تعطل التدقيق الأملائي. عند التمكين <strong>aspell</strong> ينبغي أن يكون منصبًا في المخدم. القيمة الثانية هي <strong>القاموس الافتراضي</strong>. سيتم استعمال هذه القيمة إذا لم يكن لدى aspell قاموس للغة الخاصة بالمستخدمين.';
$string['edhelpfontfamily'] = 'خاصية عائلة الخطوط هي عبارة عن قائمة تحتوي على أسماء عائلة (أو/و) أسماء عامة للخطوط. أسماء عوائل الخطوط يجب ان يفصل بينها بفاصلة (,)';
$string['edhelpfontlist'] = 'عرف الخطوط المستخدمة في مسدلة خطوط المحرر';
$string['edhelpfontsize'] = 'حجم الخط الأفتراطي يحدد حجم الخط.<br />Valid القيم على سبيل المثال : medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'تحرير';
$string['edita'] = 'تحرير {$a}';
$string['editcategorysettings'] = 'تحرير إعدادات التصنيف';
$string['editcategorythis'] = 'تحرير هذه التصنيف';
$string['editcoursesettings'] = 'تحرير إعدادات المقرر الدراسي';
$string['editfiles'] = 'حرر الملفات';
$string['editgroupprofile'] = 'تحرير سمات المجموعة';
$string['editinga'] = 'تحرير {$a}';
$string['editingteachershort'] = 'محرر';
$string['editlock'] = 'لا يمكن تحرير هذه القيمة!';
$string['editmyprofile'] = 'تحرير الملف الشخصي';
$string['editorbgcolor'] = 'لون الخلفية';
$string['editorcleanonpaste'] = 'نظف ميكرو سوف وررد تش تي إم أل عند اللصق';
$string['editorcommonsettings'] = 'الاعدادات المتعارف عليها';
$string['editordefaultfont'] = 'الخط الافتراضي';
$string['editorenablespelling'] = 'مكن المدقق الأملائي';
$string['editorfontlist'] = 'قائمة الخطوط';
$string['editorfontsize'] = 'حجم الخط الافتراضي';
$string['editorpreferences'] = 'تفضيلات المحرر';
$string['editorresettodefaults'] = 'إعادة التعيين إلى القيم الافتراضية';
$string['editorsettings'] = 'إعدادات المحرر';
$string['editorshortcutkeys'] = 'مفاتيح اختصارات المحرر';
$string['editsection'] = 'تحرير المقطع';
$string['editsectionname'] = 'تعديل اسم المقطع';
$string['editsettings'] = 'تغيير الإعدادات';
$string['editsummary'] = 'تحرير الملخص';
$string['editthisactivity'] = 'تعديل هذا النشاط';
$string['editthiscategory'] = 'تحرير هذا الصنف';
$string['edittitle'] = 'تحرير العنوان';
$string['edittitleinstructions'] = 'استخدم التراجع للإلغاء، قم بالإدخل عند الانتهاء';
$string['edituser'] = 'تحرير حسابات المستخدمين';
$string['edulevel'] = 'كل الأحداث';
$string['edulevel_help'] = '* التعليم - الإجراءات التي يقوم بها المعلم، على سبيل المثال، تحديث الموارد
* المشاركة - الإجراءات التي يقوم بها الطالب، على سبيل المثال، كتابة منشور في المنتدى
* أخرى - الإجراءات التي يقوم بها المستخدم ذو دور مختلف عن  المعلم أو الطالب';
$string['edulevelother'] = 'أخرى';
$string['edulevelparticipating'] = 'المشاركة';
$string['edulevelteacher'] = 'التعليم';
$string['email'] = 'عنوان البريد الإلكتروني';
$string['emailactive'] = 'تم تفعيل البريد الإلكتروني';
$string['emailagain'] = 'إعادة إدخال البريد الإلكتروني للتأكيد ';
$string['emailalreadysent'] = 'قد تم بالفعل إرسال بريد إلكتروني لإعادة تعيين كلمة المرور. تفقد بريدك الالكتروني من فضلك.';
$string['emailcharset'] = 'أحرف البريد الإلكتروني';
$string['emailconfirm'] = 'قم بتأكيد اشتراكك';
$string['emailconfirmation'] = 'مرحبًا،

تم طلب حساب جديد في \'{$a->sitename}\'
باستعمال عنوانك البريدي.

لتأكيد حسابك الجديد، يرجى الانتقال إلى عنوان الويب الآتي:

{$a->link}

في معظم برامج البريد، ينبغي أن يظهر هذا كرابط أزرق اللون
يمكنك النقر عليه. إذا لم ذلك متأتِّياً، قم بنسخ العنوان
ولصقه في شريط العنوان أعلى نافذة المتصفح.

إذا كنت بحاجة إلى مساعدة، يرجى الاتصال بمسؤول الموقع،
{$a->admin}';
$string['emailconfirmationresend'] = 'اعد إرسال رسالة التأكيد الإلكترونية';
$string['emailconfirmationsubject'] = '{$a} تأكيد الحساب:';
$string['emailconfirmsent'] = '<p>تم إرسال بريد إلى <b>{$a}</b></p>
   <p>والذي يحتوي على إرشادات سهلة تعينك على إتمام التسجيل</p>
   <p>إذا استمرت المشاكل اتصل بمدير هذا الموقع</p>';
$string['emailconfirmsentfailure'] = 'لم يتم إرسال رسالة التأكيد الإلكترونية';
$string['emailconfirmsentsuccess'] = 'تم إرسال رسالة التأكيد الالكترونية بنجاح';
$string['emaildigest'] = 'نوع ملخص البريد';
$string['emaildigest_help'] = 'هذا يمثل الإعداد الافتراضي للملخص اليومي الذي ستستعمله المنتديات.

* بلا تلخيص - ستتلقى رسالة بريد واحدة لكل منشور في المنتدى.
* ملخص - منشورات كاملة - ستتلقى ملخص بريدي يومي واحد يضم المحتوى الكامل لجميع منشورات المنتدى.
* ملخص - المواضيع فقط - ستتلقى ستتلقى ملخص بريدي يومي واحد يضم فقط موضوع كل منشور في المنتدى.

يمكنك أيضاً إختيار إعدادات مختلفة لكل منتدى إن كنت ترغب في ذلك.';
$string['emaildigestcomplete'] = 'كامل (بريد الكتروني يومي بكامل المنشورات)';
$string['emaildigestoff'] = 'بلا تلخيص (بريد الكتروني واحد لكل منشور في المنتدى)';
$string['emaildigestsubjects'] = 'المواضيع (بريد الكتروني يومي بالمواضيع فقط)';
$string['emaildisable'] = 'عنوان هذا البريد الإلكتروني معطل';
$string['emaildisableclick'] = 'أنقر هناء لتعطيل إرسال أي بريد إلكتروني لهذا العنوان';
$string['emaildisplay'] = 'عرض البريد';
$string['emaildisplay_help'] = 'سيتمكن المستخدمون ذوو الأفضلية (مثل المعلمين والمشرفين) دائماً من رؤية عنوان بريدك الالكتروني.';
$string['emaildisplaycourse'] = 'إسمح فقط لباقي المشاركين في المقرر الدراسي برؤية عنواني البريدي';
$string['emaildisplayno'] = 'إخفاء عنوان بريدي الالكتروني عن المستخدمين من غير ذوي الأفضلية';
$string['emaildisplayyes'] = 'إظهار عنواني البريدي للكل';
$string['emailenable'] = 'عنوان هذا البريد الإلكتروني ممكن';
$string['emailenableclick'] = 'أنقر هناء للإعادة تمكين إرسال البريد إلكتروني لهذا العنوان';
$string['emailexists'] = 'هذا العنوان البريدي موجود بالفعل.';
$string['emailexistshintlink'] = 'أسترجع اسم المستخدم المنسي أو كلمة السر المنسية';
$string['emailexistssignuphint'] = 'ربما أنك أنشأت حسابا من قبل؟ {$a}';
$string['emailformat'] = 'تنسيق البريد';
$string['emailmustbereal'] = 'لابد أن يكون عنوان بريدك الإلكتروني حقيقيا';
$string['emailnotallowed'] = 'عناوين البريد الإلكتروني لهذه المجالات لا يسمح بها ({$a})';
$string['emailnotfound'] = 'لم يتم العثور على عنوان بريد الإلكتروني في قاعدة البيانات';
$string['emailonlyallowed'] = 'هذا البريد الإلكتروني ليس من العناوين المصرح لها({$a})';
$string['emailpasswordchangeinfo'] = 'مرحبًا {$a->firstname}،

شخص ما (ربما أنت) طلب كلمة سر جديدة لحسابك في \'{$a->sitename}\'.

لتغيير كلمة السر، قم بزيارة الرابط التالي:

{$a->link}

في معظم برامج البريد، ينبغي أن يظهر هذا كرابط أزرق اللون
يمكنك النقر عليه. إذا لم ذلك متأتِّياً، قم بنسخ العنوان ولصقه
في شريط العنوان أعلى نافذة المتصفح.

إذا كنت بحاجة إلى مساعدة، يرجى الاتصال بمسؤول الموقع،
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'مرحباً {$a->firstname}،

شخص ما (ربما أنت) طلب كلمة مرور جديدة لحسابك في \'{$a->sitename}\'.

للأسف حسابك على هذا الموقع معطل، ولذلك لا يمكن إعادة تعيين كلمة المرور. الرجاء التواصل مع مشرف الموقع {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'مرحباً {$a->firstname}،

شخص ما (ربما أنت) طلب كلمة مرور جديدة لحسابك في \'{$a->sitename}\'.

للأسف لا يمكن إعادة تعيين كلمات المرور في هذا الموقع. الرجاء التواصل مع مشرف الموقع {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: معلومات تغير كلمة المرور';
$string['emailpasswordconfirmation'] = 'مرحباً {$a->firstname}،

شخص ما (ربما أنت) طلب كلمة مرور جديدة لحسابك في
\'{$a->sitename}\'.

لتأكيد العملية والحصول على كلمة المرور الجديدة مرسلةً لك عن طريق البريد الإلكتروني، إذهب إلى العنوان الآتي:

{$a->link}

في معظم برامج البريد الالكتروني، هذا العنوان يُتوقع ظهوره بشكل رابط
أزرق اللون يمكن النقر عليه. إن كان ذلك غير متأتٍّ،
قم بنسخ العنوان كاملاً ولصقه في شريط العنوان أعلى نافذة المتصفح.

في حالة إحتياجك للمساعدة، لطفاً، تواصل مع مشرف الموقع،
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: تأكيد تغيير كلمة المرور';
$string['emailpasswordconfirmmaybesent'] = '<p>إن صحَّ ما أعطيته من اسم المستخدم أو عنوان فريد للبريد الالكتروني، فيفترض أن تذهب إليك رسالة الآن.</p>
<p>الرسالة تتضمن تعليمات سهلة للتأكيد وإكمال تغييرك لكلمة المرور. إن كانت الصعوبات مستمرة، تواصل رجاءً مع المشرف على الموقع.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> لا يوجد عنوان بريد إلكتروني لحساب المستخدم الذي حددته. </p>
   <p> يرجى الاتصال بمسؤول الموقع. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> تفاصيل المستخدم التي قمت بإدخالها ، ليست لأي من حسابات المستخدمين  الموجودة. </p>
   <p> يرجى التحقق من المعلومات التي قمت بإدخالها، ثم حاول مرة أخرى.
إذا كنت لا تزال تواجه صعوبة، يرجى الاتصال بمسؤول الموقع.</p>';
$string['emailpasswordconfirmsent'] = 'من المفترض انه قد تم إرسال بريد إلكتروني إلى عنوان بريدك الإلكتروني<b>{$a}</b>
<br />يحتوي على تعليمات سهلة لتأكيد وإنهاء تغير كلمة السر
إذا كنت لا تزال تواجه صعوبة، يرجى الاتصال بمدير الموقع
{$a}';
$string['emailpasswordsent'] = 'شكراً لتأكيد تغيير كلمة المرور.
تم إرسال رسالة تحتوي على كلمة المرور الجديدة إلى عنوان بريدك الالكتروني<br /><b>{$a->email}</b>.<br />
كلمة المرور الجديدة تم إنشاؤها تلقائياً - ربما ترغب في
<a href="{$a->link}">تغيير كلمة مرورك</a> إلى شيء أقرب إلى ذاكرتك.';
$string['emailresetconfirmation'] = 'مرحبًا {$a->firstname}،

تم طلب إعادة تعيين كلمة المرور الخاصة بحسابك \'{$a->username}\'
في {$a->sitename}.

لتأكيد هذا الطلب، وتعيين كلمة مرور جديدة لحسابك، يرجى
الذهاب إلى عنوان الويب:

{$a->link}
(هذا الرابط صالح لـ {$a->resetminutes} دقيقة من وقت تقديم الطلب)

إذا لم تقم بطلب إعادة تعيين كلمة المرور، لا حاجة لأي إجراء آخر.

إذا كنت بحاجة إلى مساعدة، يرجى الاتصال بمسؤول الموقع،
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}:طلب إعادة تعيين كلمة المرور';
$string['emailresetconfirmsent'] = 'تم إرسال رسالة بريد إلكتروني إلى عنوانك <b>{$a}</b>.
<br />الرسالة تحتوي على تعليمات سهلة لتأكيد واستكمال عملية تغيير كلمة المرور.
إذا كنت لا تزال تواجه صعوبة، اتصل بمسؤول الموقع.';
$string['emailstop'] = 'أوقف التنبيهات';
$string['emailtoprivatefiles'] = 'يمكنك أيضًا إرسال ملفات بالبريد الإلكتروني كمرفقات مباشرة إلى مساحة ملفاتك الخاصة. ما عليك سوى إرفاق ملفاتك برسالة بريد إلكتروني وإرسالها إلى {$a}';
$string['emailtoprivatefilesdenied'] = 'قام مسؤول الموقع بتعطيل خيار رفع الملفات الخاصة بك.';
$string['emailvia'] = '{$a->name} (من خلال {$a->siteshortname})';
$string['emojicategoryactivities'] = 'أنشطة الرموز التعبيرية';
$string['emojicategoryanimalsnature'] = 'الحيوانات والطبيعة';
$string['emojicategoryflags'] = 'الأعلام';
$string['emojicategoryfooddrink'] = 'الطعام والشراب';
$string['emojicategoryobjects'] = 'الأشياء';
$string['emojicategoryrecent'] = 'حديث';
$string['emojicategorysmileyspeople'] = 'الابتسامات والناس';
$string['emojicategorysymbols'] = 'الرموز';
$string['emojicategorytravelplaces'] = 'السفر والأماكن';
$string['emptydragdropregion'] = 'منطقة فارغة';
$string['enable'] = 'تمكين';
$string['encryptedcode'] = 'رمز مشفر';
$string['enddate'] = 'تاريخ إنتهاء المقرر الدراسي';
$string['enddate_help'] = 'يتم استعمال تاريخ انتهاء المقرر لتحديد ما إذا كان ينبغي تضمينه في قائمة المقررات الدراسية الخاصة بالمستخدم. عند تجاوز تاريخ الانتهاء، لن يتم إدراج المقرر في قائمة التنقل بل يتم إدراجه تحت تبويب المقررات الدراسية الماضية ضمن مستعرض المقررات الدراسية. يمكن أيضاً استعمال تاريخ انتهاء المقرر من قبل التقارير المخصصة. لا يزال بإمكان المستخدمين الدخول إلى المقرر بعد تاريخ الانتهاء؛ وبعبارة أخرى فإن التاريخ لا يقيد الوصول.';
$string['english'] = 'الإنجليزية';
$string['enrolmentmethods'] = 'طرق الانضمام';
$string['entercourse'] = 'أنقر للدخول إلى هذا المقرر الدراسي';
$string['enteremail'] = 'أدخل عنوان بريدك الإلكتروني';
$string['enteremailaddress'] = 'أدخل عنوان بريدك الإلكتروني لتصلك عليه رسالة باسم المستخدم وكلمة المرور.';
$string['enterusername'] = 'أدخل اسم المستخدم';
$string['entries'] = 'مدخلات';
$string['error'] = 'خطأ';
$string['errorcreatingactivity'] = 'غير قادر على إنشاء مثيل من النشاط  \'{$a}\'';
$string['errorfiletoobig'] = 'حجم الملف تجاوز الحد الأقصى المسموح به وهو {$a} بايت';
$string['errornouploadrepo'] = 'لا يوجد مستودع لرفع الملفات مُفعَّل في هذا الموقع';
$string['errorwhenconfirming'] = 'لم تتم عملية التأكيد بعد وذلك لحصول خطأ ما. لوأنك نقرت على رابط مُرسل لعنوان بريدك الإلكتروني لنقلك إلى هنا، تأكد من أنك نقرت على العنوان كاملا، يمكنك نسخ ولصق العنوان للقيام بعملية النقل إلى الموقع بشكل أفضل';
$string['eventcommentcreated'] = 'تعليق تم إنشاؤه';
$string['eventcommentdeleted'] = 'تعليق تم حذفه';
$string['eventcommentsviewed'] = 'تعليقات تمت معاينتها';
$string['eventconfiglogcreated'] = 'سجل تهيئة تم إنشاؤه';
$string['eventcontentviewed'] = 'محتوى تمت معاينته';
$string['eventcoursebackupcreated'] = 'نسخة احتياطية لمقرر دراسي تم إنشاؤها';
$string['eventcoursecategorycreated'] = 'تصنيف تم إنشاؤه';
$string['eventcoursecategorydeleted'] = 'تصنيف تم حذفه';
$string['eventcoursecategoryupdated'] = 'تصنيف تم تحديثه';
$string['eventcoursecategoryviewed'] = 'تصنيف تمت معاينته';
$string['eventcoursecontentdeleted'] = 'محتوى مقرر دراسي تم حذفه';
$string['eventcoursecreated'] = 'مقرر دراسي تم إنشاؤه';
$string['eventcoursedeleted'] = 'مقرر دراسي تم حذفه';
$string['eventcourseinformationviewed'] = 'ملخص مقرر تمت معاينته';
$string['eventcoursemodulecreated'] = 'وحدة مقرر دراسي تم إنشاؤها';
$string['eventcoursemoduledeleted'] = 'وحدة مقرر دراسي تم حذفها';
$string['eventcoursemoduleinstancelistviewed'] = 'قائمة عيِّنات وحدات المقررات الدراسية تمت معاينتها';
$string['eventcoursemoduleupdated'] = 'وحدة مقرر دراسي تم تحديثها';
$string['eventcoursemoduleviewed'] = 'وحدة مقرر دراسي تمت معاينتها';
$string['eventcourseresetended'] = 'عملية إعادة تعيين مقرر دراسي انتهت';
$string['eventcourseresetstarted'] = 'عملية إعادة تعيين مقرر دراسي تم بدؤها';
$string['eventcourserestored'] = 'مقرر دراسي تم استرجاعه';
$string['eventcoursesectioncreated'] = 'مقطع مقرر دراسي تم إنشاؤه';
$string['eventcoursesectiondeleted'] = 'مقطع مقرر دراسي تم حذفه';
$string['eventcoursesectionupdated'] = 'مقطع مقرر دراسي تم تحديثه';
$string['eventcoursessearched'] = 'مقررات دراسية تم البحث فيها';
$string['eventcourseupdated'] = 'مقرر دراسي تم تحديثه';
$string['eventcourseuserreportviewed'] = 'تقرير مُستخدم في مقرر دراسي تمت معاينته';
$string['eventcourseviewed'] = 'مقرر دراسي تمت معاينته';
$string['eventdashboardreset'] = 'لوحة تحكم تمت إعادة تعيينها';
$string['eventdashboardsreset'] = 'صفحات دفات قيادة تمت إعادة تعيينها';
$string['eventdashboardviewed'] = 'لوحة تحكم تمت معاينتها';
$string['eventdatabasetextfieldcontentreplaced'] = 'البحث والاستبدال في عموم قاعدة البيانات';
$string['eventemailfailed'] = 'بريد الكتروني فشل إرساله';
$string['eventname'] = 'اسم الحدث';
$string['eventrecentactivityviewed'] = 'نشاطات أخيرة تمت معاينتها';
$string['eventsearchindexed'] = 'بيانات البحث تمت فهرستها';
$string['eventsearchresultsviewed'] = 'نتائج بحث تمت معاينتها';
$string['eventunknownlogged'] = 'حدث غير معروف';
$string['eventusercreated'] = 'مُستخدم تم إنشاؤه';
$string['eventuserdeleted'] = 'مُستخدم تم حذفه';
$string['eventuserfeedbackgiven'] = 'رابط إفادة نُقِر عليه';
$string['eventuserfeedbackremind'] = 'رابط التذكير بتقديم تعقيب لاحقاً تم النقر عليه';
$string['eventuserinfocategorycreated'] = 'فئة حقل الملف الشخصي للمستخدم تم إنشاؤها';
$string['eventuserinfocategorydeleted'] = 'فئة حقل الملف الشخصي للمستخدم تم حذفها';
$string['eventuserinfocategoryupdated'] = 'فئة حقل الملف الشخصي للمستخدم تم تحديثها';
$string['eventuserinfofieldcreated'] = 'حقل ملف شخصي للمستخدم تم إنشاؤه';
$string['eventuserinfofielddeleted'] = 'حقل ملف شخصي للمستخدم تم حذفه';
$string['eventuserinfofieldupdated'] = 'حقل ملف شخصي للمستخدم تم تحديثه';
$string['eventuserlistviewed'] = 'قائمة مُستخدمين تمت معاينتها';
$string['eventuserloggedout'] = 'مستخدم سجَّل خروجه';
$string['eventuserpasswordpolicyfailed'] = 'كلمة مرور مستخدم خالفت سياسة وضع كلمات المرور';
$string['eventuserpasswordupdated'] = 'كلمة مرور مستخدم تم تحديثها';
$string['eventuserprofileviewed'] = 'ملف شخصي لمُستخدم تمت معاينته';
$string['eventuserupdated'] = 'مُستخدم تم تحديثه';
$string['everybody'] = 'الكل';
$string['executeat'] = 'التنفيذ عند';
$string['existing'] = 'موجود';
$string['existingadmins'] = 'المدراء الموجودون';
$string['existingcourse'] = 'المقررات الدراسية الموجودة';
$string['existingcourseadding'] = 'إضافة معلومات لمقرر دراسي موجود';
$string['existingcoursedeleting'] = 'حذف معلومات من مقرر دراسي موجود';
$string['existingcreators'] = 'منشئون المقرر الدراسي الموجودين';
$string['existingstudents'] = 'الطلاب المسجلون';
$string['existingteachers'] = 'المعلمون الموجودون';
$string['expand'] = 'توسيع';
$string['expandall'] = 'توسيع الكل';
$string['expandcategory'] = 'توسيع {$a}';
$string['explanation'] = 'شرح / تفسير';
$string['explanationdigitalminor'] = 'هذه المعلومات مطلوبة لتحديد ما إذا كان عمرك يتجاوز سن الموافقة الرقمي. وهو العمر الذي يمكن فيه للفرد الموافقة على بنود وشروط تخزين ومعالجة بياناته قانونياً.';
$string['extendperiod'] = 'الفترة الممددة';
$string['extendsession'] = 'تمديد الجلسة';
$string['failedloginattempts'] = '{$a->attempts} محاولات الدخول الفاشلة منذ أخر زيارة لك';
$string['favourites'] = 'المُمَيزة';
$string['feedback'] = 'الإفادة';
$string['file'] = 'الملف';
$string['fileexists'] = 'يوجد حالياً ملف باسم {$a}';
$string['filemissing'] = '{$a} غير موجود';
$string['filereaderror'] = 'لايمكن قراءة الملف \'{$a}\' رجاءا تأكد أنه ملف حقيقي وليس مجلدا.';
$string['files'] = 'ملفات';
$string['filesanduploads'] = 'الملفات والمرفوعات';
$string['filesfolders'] = 'ملفات / مجلدات';
$string['fileuploadwithcontent'] = 'ينبغي أن لا يتضمن رفع الملفات أي من معاملات المحتوى';
$string['filloutallfields'] = 'يرجى ملء كل الخانات في هذا النموذج';
$string['filter'] = 'ترشيح';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'المنقحات';
$string['findmorecourses'] = 'ابحث عن مقررات دراسية إضافية...';
$string['first'] = 'أولاً';
$string['firstaccess'] = 'أول دخول';
$string['firstname'] = 'الاسم الأول';
$string['firstnamephonetic'] = 'الاسم الأول - لفظيًا';
$string['firstpage'] = 'الصفحة الأولى';
$string['firstsiteaccess'] = 'أول دخول للموقع';
$string['firsttime'] = 'هل هذه هي المرة الأولى لك؟';
$string['folder'] = 'المجلد';
$string['folderclosed'] = 'مجلد مغلق';
$string['folderopened'] = 'مجلد مفتوج';
$string['followingoptional'] = 'البنود التالية اختيارية';
$string['followingrequired'] = 'البنود التالية مطلوبة';
$string['for'] = 'إلى';
$string['force'] = 'فرض';
$string['forcelanguage'] = 'فرض اللغة';
$string['forceno'] = 'بلا فرض';
$string['forcepasswordchange'] = 'فرض تغيير كلمة المرور';
$string['forcepasswordchange_help'] = 'إذا تم اختيار علامة المربع هذه ، فسيتم مطالبة المستخدمين بتغيير كلمة المرور الخاصة بهم عند محاولة الدخول القادمة';
$string['forcepasswordchangecheckfull'] = 'هل أنت متأكد تماماً من رغبتك بفرض تغيير كلمة مرور {$a} ؟';
$string['forcepasswordchangenot'] = 'تعذر فرض تغيير كلمة مرور {$a}';
$string['forcepasswordchangenotice'] = 'يجب عليك تغير كلمة المرور ليتسنى لك الاستمرار';
$string['forcepasswordresetfailurenotice'] = 'كلمة مرورك الحالية لم تعد متوافقة مع سياسة وضع كلمات المرور. لطفاً، تواصل مع مشرف مودل لطلب المساعدة.
   {$a}';
$string['forcepasswordresetnotice'] = 'كلمة مرورك الحالية لم تعد متوافقة مع سياسة وضع كلمات المرور. عليك تعيين كلمة مرور جديدة للمتابعة.
   {$a}';
$string['forcetheme'] = 'فرض المظهر';
$string['forgotaccount'] = 'هل فقدت كلمة المرور؟';
$string['forgotten'] = 'هل نسيت اسم المستخدم أو كلمة المرور؟';
$string['forgottenduplicate'] = 'البريد الالكتروني مشترك في أكثر من حساب، يرجى إدخال اسم المستخدم بدلاً منه';
$string['forgotteninvalidurl'] = 'رابط عنوان إعادة تعيين كلمة المرورغير صحيح';
$string['format'] = 'التنسيق';
$string['format_help'] = 'تنسيق المساق يحدد تخطيط صفحته.

* تنسيق النشاط الواحد - لعرض نشاط أو مورد واحد (مثل الاختبار أو حزمة سكورم) في صفحة المساق
* التنسيق الاجتماعي - يتم عرض منتدى في صفحة المساق
* التنسيق حسب المواضيع - تنظّم صفحة المساق في مقاطع حسب المواضيع.
* التنسيق الأسبوعي - تنظّم صفحة المساق في مقاطع أسبوعية، بحيث يبدأ الأسبوع الأول في تاريخ بدء المساق';
$string['formathtml'] = 'تنسيق HTML';
$string['formatmarkdown'] = 'تنسيق Markdown';
$string['formatplain'] = 'تنسيق النص العادي';
$string['formattext'] = 'تنسيق مودل التلقائي';
$string['forumpreferences'] = 'تفضيلات المنتدى';
$string['framesetinfo'] = 'يحتوي هذا المستند المحاط بإطار على:';
$string['from'] = 'من';
$string['frontpagecategorycombo'] = 'قائمة منسدلة';
$string['frontpagecategorynames'] = 'قائمة التصنيفات';
$string['frontpagecourselist'] = 'قائمة المقررات الدراسية';
$string['frontpagecoursesearch'] = 'مربع البحث في المقررات الدراسية';
$string['frontpagedescription'] = 'ملخص الصفحة الأمامية';
$string['frontpagedescriptionhelp'] = 'يمكن عرض هذا الوصف في الصفحة الأمامية للموقع باستعمال كتلة ملخص المقرر/الموقع.';
$string['frontpageenrolledcourselist'] = 'المقررات الدراسية المُسجلة';
$string['frontpageformat'] = 'تنسيق الصفحة الأولى';
$string['frontpageformatloggedin'] = 'تنسيق الصفحة الأولى بعد الدخول';
$string['frontpagenews'] = 'الإعلانات';
$string['frontpagesettings'] = 'إعدادات الصفحة الأولى';
$string['fulllistofcourses'] = 'كل المقررات الدراسية';
$string['fullname'] = 'ًالاسم كاملا';
$string['fullnamecourse'] = 'الاسم الكامل للمقرر الدراسي';
$string['fullnamecourse_help'] = 'يتم عرض الاسم الكامل للمقرر أعلى كل صفحة فيه وكذلك في قائمة المقررات الدراسية.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'الاسم كاملا';
$string['fullprofile'] = 'ملف السيرة الذاتية';
$string['fullsitename'] = 'اسم الموقع كاملاً';
$string['functiondisabled'] = 'تلك الوظيفة غير ممكنة حاليا';
$string['general'] = 'عام';
$string['geolocation'] = 'خط الطول - خط العرض';
$string['gettheselogs'] = 'أحضر تلك السجلات';
$string['go'] = 'إذهب';
$string['gpl'] = 'الحقوق الفكرية (C) 1999 ولاحقاً Martin Dougiamas (https://moodle.com)

هذا البرنامج مجاني؛ يمكنك إعادة توزيعه و/أو تعديله طبقاً لشروط رخصة الجمهور العامة GNU General Public License التي أصدرتها مؤسسة البرامج المجانية Free Software Foundation سواء الإصدار الثاني منها أو أي إصدار لاحق ترتئيه.

هذا البرنامج موزع على أمل الإفادة منه، ولكن من دون أي ضمانات، ولو ضمنياً، على ملائمته لغرض معين أو قابليته للتسويق.

لمزيد من المعلومات، راجع صفحة رخصة مودل:
https://docs.moodle.org/dev/License';
$string['gpl3'] = 'الحقوق الفكرية (C) 1999 ولاحقاً Martin Dougiamas (https://moodle.com)

هذا البرنامج مجاني؛ يمكنك إعادة توزيعه و/أو تعديله طبقاً لشروط رخصة الجمهور العامة GNU General Public License التي أصدرتها مؤسسة البرامج المجانية Free Software Foundation سواء الإصدار الثاني منها أو أي إصدار لاحق ترتئيه.

هذا البرنامج موزع على أمل الإفادة منه، ولكن من دون أي ضمانات، ولو ضمنياً، على ملائمته لغرض معين أو قابليته للتسويق.

لمزيد من المعلومات، راجع صفحة رخصة مودل:
https://docs.moodle.org/dev/License';
$string['gpllicense'] = 'رخصة GPL';
$string['grade'] = 'العلامة';
$string['grades'] = 'العلامات';
$string['gravatarenabled'] = 'تم تمكين <a href="https://www.gravatar.com/">Gravatar</a> على هذا الموقع . إذا لم ترفع لك صورة تعريفية فيه فإن مودل سيحاول أن يتخير لك صورة تعريفية من Gravatar.';
$string['group'] = 'مجموعة';
$string['groupadd'] = 'إضافة مجموعة جديدة';
$string['groupaddusers'] = 'أضف المختار إلى المجموعة';
$string['groupfor'] = 'للمجموعة';
$string['groupinfo'] = 'معلومات عن المجموعة المختارة';
$string['groupinfoedit'] = 'حرر إعدادات المجموعة';
$string['groupinfomembers'] = 'معلومات عن الأعضاء المختارين';
$string['groupinfopeople'] = 'معلومات عن الناس المختارين';
$string['groupmembers'] = 'أعضاء المجموعة';
$string['groupmemberssee'] = 'معاينة أعضاء المجموعة';
$string['groupmembersselected'] = 'أعضاء المجموعة المختارة';
$string['groupmode'] = 'حالة المجموعة';
$string['groupmodeforce'] = 'أجبر حالة المجموعة';
$string['groupmy'] = 'مجموعتي';
$string['groupnonmembers'] = 'الناس لا ينتمو للمجموعة';
$string['groupnotamember'] = 'عذراً، أنت لست عضواً في تلك المجموعة';
$string['grouprandomassign'] = 'تعيين عشوئي لكل المجموعات';
$string['groupremove'] = 'حذف المجموعة المختارة';
$string['groupremovemembers'] = 'حذف الاعضاء المختارين';
$string['groups'] = 'المجموعات';
$string['groupsnone'] = 'بلا مجموعات';
$string['groupsseparate'] = 'مجموعات منفصلة';
$string['groupsvisible'] = 'مجموعات ظاهرة';
$string['guest'] = 'ضيف';
$string['guestdescription'] = 'صلاحيات الضيوف محدودة ولا يمكن لهم إضافة أي نص في أي مكان.';
$string['guestskey'] = 'السماح للضيوف الذين لديهم المفتاح';
$string['guestsno'] = 'لا تسمح بدخول الضيوف إلى';
$string['guestsnotallowed'] = 'عذراً، \'{$a}\' لا يسمح للضيوف بالدخول';
$string['guestsyes'] = 'السماح للضيوف بدون المفتاح';
$string['guestuser'] = 'مستخدم ضيف';
$string['guestuserinfo'] = 'هذا حساب مستخدم خاص يمسح له بالدخول إلى بعض المقررات الدراسية بغرض القراءة فقط.';
$string['help'] = 'مساعدة';
$string['helpprefix2'] = 'مساعدة {$a}';
$string['helpwiththis'] = 'المساعدة في هذا';
$string['hiddenassign'] = 'وظيفة مخفية';
$string['hiddenfromstudents'] = 'مخفي عن الطلاب';
$string['hiddenoncoursepage'] = 'متاح لكن غير ظاهر في صفحة المقرر الدراسي';
$string['hiddensections'] = 'المقاطع المخفية';
$string['hiddensections_help'] = 'يحدد هذا الإعداد ما إذا كان يتم عرض الأقسام الخفية للطلاب في شكل مصغر (كمثال إذا استخدم المقرر الدراسي التنسيق الأسبوعي فيخفي بعض الأسابيع للإشارة إلى أيام العطل) أو تكون مخفية تماماً';
$string['hiddensectionscollapsed'] = 'المقاطع المخفية تظهر بشكل مطوي';
$string['hiddensectionsinvisible'] = 'المقاطع المخفية غير مرئية تماماً';
$string['hiddenwithbrackets'] = '(مخفي)';
$string['hide'] = 'إخفاء';
$string['hideadvancedsettings'] = 'إخفاء الإعدادات المتقدمة';
$string['hidechartdata'] = 'إخفاء بيانات الرسم البياني';
$string['hidefromstudents'] = 'مخفي عن الطلاب';
$string['hideoncoursepage'] = 'متاح لكن غير ظاهر على صفحة المقرر الدراسي';
$string['hidepicture'] = 'إخفاء الصورة';
$string['hidepopoverwindow'] = 'إخفاء النافذة المنبثقة';
$string['hidesection'] = 'إخفاء المقطع {$a}';
$string['hidesettings'] = 'إخفاء الإعدادات';
$string['hideshowblocks'] = 'إظهار أو إخفاء الكتل';
$string['highlight'] = 'تسليط الضوء';
$string['highlightoff'] = 'احذف تسليط الضوء';
$string['hits'] = 'نتائج';
$string['hitsoncourse'] = 'حالة وصول إلى {$a->coursename} من قِبَل {$a->username}';
$string['hitsoncoursetoday'] = 'نتائج اليوم في  {$a->coursename} بواسطة {$a->username}';
$string['home'] = 'الصفحة الرئيسية';
$string['hour'] = 'ساعة';
$string['hours'] = 'ساعات';
$string['howtomakethemes'] = 'كيف تصمم قوالب جديدة';
$string['htmleditor'] = 'استعمل محرر HTML';
$string['htmleditoravailable'] = 'محرر Richtext متاح';
$string['htmleditordisabled'] = 'لقد قمت بإلغاء محرر Richtext في خيارات المستخدم';
$string['htmleditordisabledadmin'] = 'قام مدير الموقع بإلغاء محرر Richtext على الموقع';
$string['htmleditordisabledbrowser'] = 'محرر Richtext غير متاح لأنك لا تستخدم IE 5.5 أو أعلى';
$string['htmlfilesonly'] = 'ملفات HTML فقط';
$string['htmlformat'] = 'تنسيق HTML الجيد';
$string['icon'] = 'رمز';
$string['icqnumber'] = 'رقم ICQ';
$string['idnumber'] = 'رقم المُعرَّف';
$string['idnumbercourse'] = 'مُعرَّف المقرر الدراسي';
$string['idnumbercourse_help'] = 'مُعرَّف المقرر يستعمل فقط للمقارنة مع مقررات أنظمة خارجية ولا يُعرض في أي مكان آخر ضمن الموقع. إن كان للمقرر ترميز رسمي، يمكن إدخاله هنا، وإلا يمكن ترك هذا الحقل فارغاً.';
$string['idnumbercoursecategory'] = 'مُعرَّف التصنيف';
$string['idnumbercoursecategory_help'] = 'معرّف التصنيف يستخدم فقط عند مطابقة التصنيف مع أنظمة خارجية ولا يعرض في أي مكان آخر في الموقع. إن كان للتصنيف معرِّف رسمي يمكنك إدخاله، وإلا فيجب أن تترك هذا الحقل فارغاً';
$string['idnumbergroup'] = 'رقم مُعرَّف المجموعة';
$string['idnumbergroup_help'] = 'معرّف المجموعة يستخدم فقط عند مطابقة المجموعة مع أنظمة خارجية ولا يعرض في أي مكان آخر في الموقع. إن كان للمجموعة معرِّف رسمي يمكنك إدخاله، وإلا فيجب أن تترك هذا الحقل فارغاً.';
$string['idnumbergrouping'] = 'رقم مُعرَّف التجميع';
$string['idnumbergrouping_help'] = 'معرّف التجميع  يستخدم فقط عند مطابقة التجميع مع أنظمة خارجية ولا يعرض في أي مكان آخر في الموقع. إن كان للتجميع معرِّف رسمي يمكنك إدخاله، وإلا فيجب أن تترك هذا الحقل فارغاً.';
$string['idnumbermod'] = 'رقم المُعرَّف';
$string['idnumbermod_help'] = 'تعيين رقم المُعرّف يمثل طريقة لتمييز النشاطات والموارد لأغراض متعددة، منها حساب الدرجات أو تخصيص التقارير. بخلاف ذلك، يمكن ترك حقل رقم المُعرَّف فارغاً.
بالنسبة إلى النشاطات القابلة لمنح العلامات، يمكن أيضاً وضع أرقام المُعرَّف في سجل التقديرات مع أنها تكون قابلة للتعديل حصراً من صفحة الإعدادات الخاصة بتلك النشاطات.';
$string['idnumbertaken'] = 'هذا المعرف تم تسجيله من قبل';
$string['imagealt'] = 'وصف الصورة';
$string['import'] = 'استيراد';
$string['importdata'] = 'استيراد بيانات مقرر دراسي';
$string['importdataexported'] = 'تم تصدير بيانات من المقرر الدراسي \'from\' بنجاح.<br /> أستمر في الأستيراد إلى مقررك الدراسي \'to\'';
$string['importdatafinished'] = 'إكتمل الإستيراد! الذهاب إلى مقررك الدراسي';
$string['importdatafrom'] = 'جِد مقرر لاستيراد البيانات منه:';
$string['inactive'] = 'غير نشط';
$string['include'] = 'تضمين';
$string['includeallusers'] = 'تضمين كل المستخدمين';
$string['includecoursefiles'] = 'تضمين ملفات المقررات الدراسية';
$string['includecourseusers'] = 'تضمين مستخدمي المقرر الدراسي';
$string['included'] = 'متضمَّن';
$string['includelogentries'] = 'تضمين مداخل سجلات الوقوعات';
$string['includemodules'] = 'تضمين الوحدات';
$string['includemoduleuserdata'] = 'تضمين وحدت بيانات المستخدم';
$string['includeneededusers'] = 'تضمين المستخدمين المطلوبين';
$string['includenoneusers'] = 'أضف غير المستخدمين';
$string['includeroleassignments'] = 'تضمين مهام الأدوار';
$string['includesitefiles'] = 'تضمين ملفات الموقع المستخدمة في هذا المقرر';
$string['includeuserfiles'] = 'تضمين ملفات المستخدمين';
$string['increasesections'] = 'زد عدد المقاطع';
$string['indicator:accessesafterend'] = 'الوصول للمقرر بعد تاريخ انتهائه';
$string['indicator:accessesafterend_help'] = 'هذ المؤشر يعكس ما إذا قام الطالب بالوصول إلى المقرر الدراسي بعد تاريخ انتهائه.';
$string['indicator:accessesbeforestart'] = 'الوصول إلى المقرر الدراسي قبل تاريخ بدئه';
$string['indicator:accessesbeforestart_help'] = 'هذ المؤشر يعكس ما إذا قام الطالب بالوصول إلى المقرر الدراسي قبل تاريخ بدئه';
$string['indicator:activitiesdue'] = 'النشاطات المستحقة';
$string['indicator:activitiesdue_help'] = 'المستخدم لديه أنشطة واجبة.';
$string['indicator:anycourseaccess'] = 'أيّ وصول للمقرر';
$string['indicator:anycourseaccess_help'] = 'يعكس هذا المؤشر وصول المستخدم إلى أيّ مقرر التحق به.';
$string['indicator:anywrite'] = 'أي إجراء كتابي';
$string['indicator:anywrite_help'] = 'هذ المؤشر يمثل أي إجراء كتابي (تسليمي) قام به الطالب.';
$string['indicator:anywriteincourse'] = 'أي إجراء كتابي في المقرر الدراسي';
$string['indicator:anywriteincourse_help'] = 'هذا يشير إلى أي اجراء (ارسال) تمت بواسطة الطالب في أي نشاط بالمقرر.';
$string['indicator:completeduserprofile'] = 'ملف المستخدم مكتمل';
$string['indicator:completeduserprofile_help'] = 'هذا يشير إلى أن الطالب أكمل ملفه الشخصي.';
$string['indicator:completeduserprofiledef'] = 'اكتمال ملف تعريف المستخدم';
$string['indicator:completeduserprofiledef_help'] = 'تمت الموافقة على سياسات الموقع وقام المستخدم بملء الحقول التالية: المؤسسة، القسم، العنوان، المدينة، البلد، الرابط.';
$string['indicator:completionenabled'] = 'تتبع الإكمال مُمَكَّن';
$string['indicator:completionenabled_help'] = 'هذا يشير إلى أن تتبع الاكتمال قد تم تفعيله بهذا المقرر';
$string['indicator:nostudent'] = 'انضمامات الطلاب';
$string['indicator:nostudent_help'] = 'يعكس هذا المؤشر مدى توفر الطلاب في المادة.';
$string['indicator:noteacher'] = 'توفر المعلم';
$string['indicator:noteacher_help'] = 'يعكس هذا المؤشر مدى توفر المعلمين في المادة.';
$string['indicator:potentialcognitive'] = 'العمق المعرفي المتوقع للمقرر';
$string['indicator:potentialcognitive_help'] = 'هذا المؤشر مبني على العمق المعرفي المتوقع الذي يمكن الوصول إليه من قبل طالب يشارك في نشاطات المقرر الدراسي';
$string['indicator:potentialcognitivedef'] = 'العمق المعرفي المتوقع للمقرر';
$string['indicator:potentialcognitivedef_help'] = 'الدرجة التي يقدم بها المقرر الدراسي المشاركة المعرفية "العميقة"، على سبيل المثال تقديم العمل للتعليقات، فرصة مراجعة أعمال الآخرين، وفرصة تنقيح العمل وإعادة إرساله.';
$string['indicator:potentialsocial'] = 'التوسع الاجتماعي المتوقع للمقرر';
$string['indicator:potentialsocial_help'] = 'هذا المؤشر مبني على التوسع الاجتماعي المتوقع والذي يمكن الوصول إليه من قبل طالب يشارك في نشاطات المقرر الدراسي.';
$string['indicator:potentialsocialdef'] = 'التوسع الاجتماعي المتوقع للمقرر';
$string['indicator:potentialsocialdef_help'] = 'الدرجة التي يبلغها المقرر الدراسي من المشاركة الاجتماعية "الواسعة"، التفاعل مع المشاركين الآخرين، ومع مجتمع المشاركين خارج الصف.';
$string['indicator:readactions'] = 'مقدار إجراءات القراءة';
$string['indicator:readactions_help'] = 'هذا المؤشر يبين عدد مرات القراءة (المشاهدة) التي قام بها الطالب';
$string['indicator:userforumstracking'] = 'المستخدم يتتبع المنتديات';
$string['indicator:userforumstracking_help'] = 'هذا المؤشر يمثل ما إذا قام الطالب بتمكين ميزة تتبع القراءة في المنتديات.';
$string['info'] = 'المعلومات';
$string['institution'] = 'المؤسسة';
$string['instudentview'] = 'حسب ما يظهر للطالب';
$string['interests'] = 'الاهتمامات';
$string['interestslist'] = 'قائمة الاهتمامات';
$string['interestslist_help'] = 'أدخل اهتماماتك واحداً تلو الآخر. سيتم عرضها كوسوم في صفحتك الشخصية.';
$string['invalidemail'] = 'عنوان البريد الإلكتروني غير صحيح';
$string['invalidlogin'] = 'خطأ في اسم المستخدم أو كلمة المرور، يرجى إعادة المحاولة.';
$string['invalidusername'] = 'يمكن لاسم المستخدم أن يتضمن فقط أرقاماً أو حروفاً لاتينية أبجديةً صغيرةً، شُرطاً تحتانية (_)، واصلات (-)، نقطاً (.)، أوعلامة (@).';
$string['invalidusernameupload'] = 'اسم مستخدم غير صحيح';
$string['ip_address'] = 'عنوان IP';
$string['jump'] = 'أقفز';
$string['jumpto'] = 'الانتقال إلى...';
$string['keep'] = 'احفظ';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'اتجاه اللغة من الشمال إلى اليمين';
$string['langrtl'] = 'اتجاه اللغة من اليمين إلى الشمال';
$string['language'] = 'اللغة';
$string['languagegood'] = 'لا توجد كلمات غير مترجمة';
$string['last'] = 'الأخير';
$string['lastaccess'] = 'آخردخول';
$string['lastcourseaccess'] = 'آخر دخول إلى المقرر الدراسي';
$string['lastedited'] = 'آخر تعديل';
$string['lastip'] = 'آخر عنوان IP';
$string['lastlogin'] = 'آخر تسجيل دخول';
$string['lastmodified'] = 'آخر تعديل';
$string['lastname'] = 'الاسم الأخير';
$string['lastnamephonetic'] = 'اللقب - اللفظي';
$string['lastpage'] = 'الصفحة الأخيرة';
$string['lastsiteaccess'] = 'آخر دخول للموقع';
$string['lastyear'] = 'العام الماضي';
$string['latestlanguagepack'] = 'تحقق من أخر حزمة لغة متوفر في moodle.org';
$string['layouttable'] = 'الجدول المخطط';
$string['leavetokeep'] = 'للاحتفاظ بكلمة المرور الحالية لا تدخل شيئا هنا';
$string['legacylogginginuse'] = 'هذا الموقع حاليا يُفعِّل الكتابة إلى مخزن سجل إرثي /قديم. الكتابة إلى هذا المخزن سيتم إهمالها. يرجى الكتابة إلى مخزن السجل المعتمد مثل "المعياري" أو "الخارجي".';
$string['legacythemeinuse'] = 'يتم عرض هذا الموقع لك في الوضع التوافقي بسبب أن متصفح الإنترنت لديك قديم جدا';
$string['license'] = 'الرخصة';
$string['licenses'] = 'الرخص';
$string['liketologin'] = 'هل ترغب في الدخول الآن بحساب مستخدم كامل';
$string['list'] = 'قائمة';
$string['listfiles'] = 'قائمة الملفات في {$a}';
$string['listofallpeople'] = 'قائمة بجميع الأشخاص';
$string['listofcourses'] = 'قائمة المقررات الدراسية';
$string['loading'] = 'يتم التحميل';
$string['loadinghelp'] = 'جارٍ التحميل...';
$string['local'] = 'محلّي';
$string['localplugins'] = 'الملاحق المحليّة';
$string['localpluginsmanage'] = 'إدارة الملاحق المحليّة';
$string['location'] = 'الموقع';
$string['locktimeout'] = 'انتهت مهلة العملية في أثناء انتظار التأمين .';
$string['log_excel_date_format'] = 'سنه شهر يوم ساعة:دقائق';
$string['loggedinas'] = 'تم دخولك بصفة {$a}';
$string['loggedinasguest'] = 'أنت الآن تدخل بصفة ضيف';
$string['loggedinnot'] = 'لم يتم دخولك.';
$string['login'] = 'تسجيل الدخول';
$string['login_failure_logs'] = 'سجلات محاولات الدخول الفاشلة';
$string['loginactivity'] = 'نشاط تسجيل الدخول';
$string['loginalready'] = 'لقد تم دخولك مسبقاً';
$string['loginas'] = 'الدخول بصفة';
$string['loginaspasswordexplain'] = '<p> يتطلب منك ادخال كلمة المرور الخاصة للتمكن من استخدام هذه الخاصية.<br /> في حالة عدم معرفتك لكلمة المرور، قم بطلبها من مدير الموقع.</p>';
$string['loginguest'] = 'الدخول بصفة ضيف';
$string['loginsite'] = 'الدخول إلى الموقع';
$string['loginsteps'] = 'للوصول الكامل لهذا الموقع, عليك أن تنشئ حساباً.';
$string['loginstepsnone'] = '<p>مرحبا!</p>
<p>للوصول الكامل إلى المقررات الدراسية ستحتاج إلى إنشاء حساب جديد لنفسك.</p>
<p>كل ما ينبغي عليك القيام به هو وضع اسم مستخدم وكلمة مرور واستخدامهما في النموذج الموجود بهذه الصفحة!</p><p>إذا كان اسم المستخدم قد استعمله شخص آخر مسبقاً، جرب مرة أخرى اسماً غيره.</p>';
$string['loginto'] = 'الدخول إلى {$a}';
$string['logoof'] = 'شعار {$a}';
$string['logout'] = 'تسجيل الخروج';
$string['logoutconfirm'] = 'هل في نيتك فعلاً تسجيل الخروج؟';
$string['logs'] = 'سجلات الوقوعات';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">المزيد</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">المزيد</a> ]';
$string['lookback'] = 'أنظر إلى الخلف';
$string['mailadmins'] = 'أحط المدراء';
$string['mailstudents'] = 'أحط الطلاب';
$string['mailteachers'] = 'أحط المعلمون';
$string['maincoursepage'] = 'صفحة المقرر الدراسي الرئيسية';
$string['makeafolder'] = 'إنشاء مجلد';
$string['makeavailable'] = 'اجعله متاح';
$string['makeeditable'] = 'إذا جعلت \'{$a}\' قابلا للتعديل من خلال عملية مزود الإنترنت (مثال apache) ثم تستطيع تعديل هذا الملف مباشرة من خلال هذه الصفحة';
$string['makethismyhome'] = 'إجعل هذه صفحتي الرئيسية';
$string['makeunavailable'] = 'عدم إتاحته';
$string['manageblocks'] = 'الكتل';
$string['managecategorythis'] = 'إدارة هذا التصنيف';
$string['managecontentbanktypes'] = 'إدارة أنواع المحتوى';
$string['managecourses'] = 'إدارة المقررات الدراسية';
$string['managedatabase'] = 'قاعدة البيانات';
$string['managedataformats'] = 'إدارة تنسيقات البيانات';
$string['manageeditorfiles'] = 'إدارة الملفات التي يستخدمها المحرر';
$string['managefilters'] = 'المنقحات';
$string['managemodules'] = 'وحدات';
$string['manageroles'] = 'الأدوار والصلاحيات';
$string['markallread'] = 'أشر على الكل بمقروء';
$string['markedthistopic'] = 'الموضوع المُضاء هو الموضوع الحالي';
$string['markthistopic'] = 'ميز هذا الموضوع بعلامة كالموضوع الحالي';
$string['matchingsearchandrole'] = 'مطابقة \'{$a->search}\' و {$a->role}';
$string['maxareabytesreached'] = 'الملف (أو الحجم الإجمالي من عدة ملفات) أكبر من المساحة المتبقية في هذه المنطقة.';
$string['maxfilesize'] = 'الحجم الأقصى للملفات الجديدة: {$a}';
$string['maxfilesreached'] = 'يُسمح لك بإرفاق {$a} من الملفات كحد أقصى مع هذا العنصر';
$string['maximumchars'] = 'الحد الأقصى {$a} من الحروف';
$string['maximumgrade'] = 'الدرجة القصوى';
$string['maximumgradex'] = 'العلامة الكبرى: {$a}';
$string['maximumshort'] = 'الحد الأقصى';
$string['maximumupload'] = 'الحجم الأقصى للرفع';
$string['maximumupload_help'] = 'يحدِّد هذا الإعداد أكبر حجم من الملفات التي يمكن تحميلها على صفحة المقرر الدراسي، وهذا الحجم مقيَّد أيضاً بإعدادت المشرف (الأدمن) لحجم الملفات المسوح بها على مستوى الموقع . وتشمل وحدات النشاط أيضا تحديد للحد الأقصى لحجم تحميل الملفات لمزيد من التقييد.';
$string['maxnumberweeks'] = 'أقصى عدد من المقاطع';
$string['maxnumberweeks_desc'] = 'الحد الأقصى للقيمة في القائمة المنسدلة لعدد الأقسام (ينطبق على تنسيقات مادة محددة فقط).';
$string['maxnumcoursesincombo'] = 'تصفح <a href="{$a->link}">{$a->numberofcourses}المقررات الدراسية</a>.';
$string['maxsectionslimit'] = 'لا يمكن إنشاء مقطع جديد لأن ذلك سيتجاوز الحد الأقصى لعدد المقاطع المسموح بها لهذ المقرر الدراسي ({$a}).';
$string['maxsize'] = 'الحد الأقصى: {$a}';
$string['maxsizeandareasize'] = 'الحجم الأقصى للملفات الجديدة: {$a->size}, الحد العام: {$a->areasize}';
$string['maxsizeandattachments'] = 'أقصى حجم للملف: {$a->size}، الحد الأقصى لعدد الملفات: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'أقصى حجم للملف: {$a->size}، الحد الأقصى لعدد الملفات: {$a->attachments}، الحد الأقصى للحجم الكلي: {$a->areasize}';
$string['memberincourse'] = 'أعضاء المقرر الدراسي';
$string['messagebody'] = 'متن الرسالة';
$string['messagedselectedusers'] = 'تم إرسال الرسالة القصيرة إلى المستخدمين المحددين، وتمت إعادة تعيين قائمة المستلمين.';
$string['messagedselectedusersfailed'] = 'وقع خطأ ما في أثناء مراسلة المستخدمين المختارين. ربما استلم بعضهم الرسالة.';
$string['messageprovider:asyncbackupnotification'] = 'إشعارات الحفظ/الاستعادة اللامتزامنة';
$string['messageprovider:availableupdate'] = 'إشعارات التحديثات المتاحة';
$string['messageprovider:backup'] = 'إشعارات النسخ الاحتياطي';
$string['messageprovider:badgecreatornotice'] = 'إشعارات مُنشئ الشارة';
$string['messageprovider:badgerecipientnotice'] = 'إشعارات متلقي الشارة';
$string['messageprovider:competencyplancomment'] = 'نشر تعليق على خطة التعلم';
$string['messageprovider:competencyusercompcomment'] = 'تعليق منشور على الكفاءات';
$string['messageprovider:coursecompleted'] = 'تم إكمال المقرر الدراسي';
$string['messageprovider:courserequestapproved'] = 'إشعار الموافقة على طلب إنشاء المقرر الدراسي';
$string['messageprovider:courserequested'] = 'إشعار طلب إنشاء المقرر الدراسي';
$string['messageprovider:courserequestrejected'] = 'إشعار رفض طلب إنشاء المقرر الدراسي';
$string['messageprovider:errors'] = 'أخطاء هامة في الموقع';
$string['messageprovider:errors_help'] = 'توجد أخطاء هامة لا بد أن يعلم بها المشرف.';
$string['messageprovider:gradenotifications'] = 'إشعارات العلامات';
$string['messageprovider:infected'] = 'إشعارات فشل مضاد الفيروسات';
$string['messageprovider:insights'] = 'المدخلات المنتجة باستخدام نماذج التنبؤ';
$string['messageprovider:instantmessage'] = 'الرسائل الشخصية بين المستخدمين';
$string['messageprovider:instantmessage_help'] = 'هذا المقطع مسؤول عن تهيئة ما يحدث للرسائل التي يتم إرسالها إليك مباشرة من مستخدمين آخرين في هذا الموقع.';
$string['messageprovider:messagecontactrequests'] = 'إشعار إلتماسات المراسلة';
$string['messageprovider:notices'] = 'إشعارات حول مشكلات صغيرة';
$string['messageprovider:notices_help'] = '.هذه إشعارات قد يكون من المهم لمشرف الموقع (الأدمن) مُشاهدتها';
$string['messageselect'] = 'إختر هذا المستخدم كمستلم بريد الكتروني';
$string['messageselectadd'] = 'إرسال رسالة';
$string['middlename'] = 'الاسم الأوسط';
$string['migratinggrades'] = 'تهجير العلامات';
$string['min'] = 'دقيقة';
$string['mins'] = 'دقائق';
$string['minute'] = 'دقيقة';
$string['minutes'] = 'دقائق';
$string['miscellaneous'] = 'متنوع';
$string['missingcategory'] = 'لابد من اختيار صنف';
$string['missingdescription'] = 'الوصف  لم يحدده';
$string['missingemail'] = 'ينقصه عنوان البريد الالكتروني';
$string['missingfirstname'] = 'الاسم الأول  لم يتم تحدده';
$string['missingfromdisk'] = 'غير موجود على القرص';
$string['missingfullname'] = 'لم يتم إدخال الاسم الكامل';
$string['missinglastname'] = 'لم يتم إدخال الاسم الأخير';
$string['missingname'] = 'الاسم مفقود';
$string['missingnewpassword'] = 'لم يتم إدخال كلمة المرور الجديدة';
$string['missingpassword'] = 'لم يتم إدخال كلمة المرور';
$string['missingrecaptchachallengefield'] = 'اختبار reCAPTCHA فشِل، أعد المحاولة.';
$string['missingreqreason'] = 'لم يتم تحديد السبب';
$string['missingshortname'] = 'لم يتم إدخال الاسم المختصر';
$string['missingshortsitename'] = 'لم يتم إدخال اسم الموقع المختصر';
$string['missingsitedescription'] = 'لم يتم إدخال وصف الموقع';
$string['missingsitename'] = 'لم يتم إدخال اسم الموقع';
$string['missingstrings'] = 'ابحث عن كلمات أو عبارات غير مترجمة';
$string['missingstudent'] = 'لابد من اختيار شيء';
$string['missingsummary'] = 'الملخص مفقود';
$string['missingteacher'] = 'لابد من اختيار شيء';
$string['missingurl'] = 'مؤشر الموقع مفقود';
$string['missingusername'] = 'اسم المستخدم مفقود';
$string['moddoesnotsupporttype'] = 'الوحدة {$a->modname} لاتدعم الملفات المرفوعه من نوع {$a->type}';
$string['modhide'] = 'إخفاء';
$string['modified'] = 'تم التعديل';
$string['modshow'] = 'عرض';
$string['moduleintro'] = 'الوصف';
$string['modulesetup'] = 'تنصيب جداول الوحدة النمطية';
$string['modulesuccess'] = '{$a} تم تنصيب الجداول بشكل صحيح';
$string['modulesused'] = 'الوحدات المُستخدمة';
$string['modvisible'] = 'متاح';
$string['modvisible_help'] = 'إذا تم ضبط الإتاحة على \'الإظهار على صفحة المقرر الدراسي\'، فسيكون النشاط أو المورد متاحاً للطلاب (مع مراعاة قيود الوصول التي قد تكون مستعملة أيضاً).

إذا تم ضبط الإتاحة على \'مخفي عن الطلاب\'، فسيكون النشاط أو المورد متاحاً فقط للمستخدمين الذين لديهم صلاحية رؤية الأنشطة المخفية (إفتراضياً، المستخدمون الذين لديهم دور المعلم أو المعلم الذي بلا صلاحية التحرير).';
$string['modvisiblehiddensection'] = 'متاح';
$string['modvisiblehiddensection_help'] = 'إذا تم ضبط الإتاحة على \'مخفي عن الطلاب\'، فسيكون النشاط أو المورد متاحاً فقط للمستخدمين الذين لديهم صلاحية رؤية الأنشطة المخفية (إفتراضياً، المستخدمون الذين لديهم دور المعلم أو المعلم الذي بلا صلاحية التحرير).

إذا كان المقرر الدراسي يحوي العديد من الأنشطة أو الموارد، فيمكن تبسيط صفحته عن طريق ضبط الإتاحة على \'متاح لكن غير ظاهر على صفحة المقرر\'. في هذه الحالة يجب توفير رابط للوصول إلى النشاط أو المورد من مكان آخر، مثلاً من مورد الصفحة. مع ذلك، سيظل النشاط مدرجاً في سجل التقديرات والتقارير الأخرى.';
$string['modvisiblewithstealth'] = 'متاح';
$string['modvisiblewithstealth_help'] = 'إذا تم ضبط الإتاحة على \'الإظهار في صفحة المقرر الدراسي\'، فسيكون النشاط أو المورد متاحاً للطلاب (مع مراعاة قيود الوصول التي قد تكون مستعملة أيضاً).

إذا تم ضبط الإتاحة على \'مخفي عن الطلاب\'، فسيكون النشاط أو المورد متاحاً فقط للمستخدمين الذين لديهم صلاحية رؤية الأنشطة المخفية (إفتراضياً، المستخدمون الذين لديهم دور المعلم أو المعلم الذي بلا صلاحية التحرير).

إذا كان المقرر يحوي العديد من الأنشطة أو الموارد، فيمكن تبسيط صفحته عن طريق ضبط الإتاحة على \'متاح لكن غير ظاهر على صفحة المقرر\'. في هذه الحالة يجب توفير رابط للوصول إلى النشاط أو المورد من مكان آخر، مثلاً من مورد الصفحة. مع ذلك، سيظل النشاط مدرجاً في سجل التقديرات والتقارير الأخرى.';
$string['month'] = 'شهر';
$string['months'] = 'شهور';
$string['moodledocs'] = 'وثائق مودل';
$string['moodledocslink'] = 'المساعدة والتوثيقات';
$string['moodlelogo'] = 'شعار مودل';
$string['moodlerelease'] = 'إصدار مودل';
$string['moodleversion'] = 'إصدار مودل';
$string['more'] = 'المزيد';
$string['morehelp'] = 'المزيد من المساعدة';
$string['morehelpaboutmodule'] = 'مساعدة إضافية عن النشاط {$a}';
$string['moreinfo'] = 'المزيد من المعلومات';
$string['moreinformation'] = 'مزيد من المعلومات عن هذا الخطأ';
$string['morenavigationlinks'] = 'المزيد ...';
$string['moreprofileinfoneeded'] = 'من فضلك أخبرنا المزيد عن نفسك';
$string['mostrecently'] = 'الأحدث';
$string['move'] = 'نقل';
$string['movecategoriessuccess'] = 'تم بنجاح نقل {$a->count} من التصنيفات إلى التصنيف \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'تم بنجاح نقل {$a->count} من التصنيفات إلى المستوى الأعلى';
$string['movecategorycontentto'] = 'نقل إلى';
$string['movecategorysuccess'] = 'تم بنجاح نقل التصنيف \'{$a->moved}\' إلى التصنيف \'{$a->to}\'';
$string['movecategoryto'] = 'نقل التصنيف إلى:';
$string['movecategorytotopsuccess'] = 'تم بنجاح نقل التصنيف \'{$a->moved}\' إلى المستوى الأعلى';
$string['movecontent'] = 'نقل {$a}';
$string['movecontentafter'] = 'بعد "{$a}"';
$string['movecontentstoanothercategory'] = 'انقل المحتويات إلى تصنيف آخر';
$string['movecontenttothetop'] = 'إلى أعلى القائمة';
$string['movecoursemodule'] = 'انقل المصدر';
$string['movecoursesection'] = 'أنقل المقطع';
$string['movecourseto'] = 'نقل المقرر الدراسي إلى:';
$string['movedown'] = 'أنقل إلى أسفل';
$string['movefilestohere'] = 'أنقل الملفات إلى هنا';
$string['movefull'] = 'أنقل {$a} إلى هذا الموقع';
$string['movehere'] = 'أنقل إلى هنا';
$string['moveleft'] = 'أنقل إلى اليمين';
$string['moveright'] = 'أنقل إلى اليسار';
$string['movesection'] = 'أنقل المقطع {$a}';
$string['moveselectedcategoriesto'] = 'انقل التصنيفات المُختارة إلى';
$string['moveselectedcoursesto'] = 'أنقل المقررات الدراسية المختارة إلى...';
$string['movetoanotherfolder'] = 'نقل إلى مجلد آخر';
$string['moveup'] = 'الانتقال إلى أعلى';
$string['msnid'] = 'تعريف MSN';
$string['mustchangepassword'] = 'كلمة المرور الجديدة يجب أن تختلف عن الكلمة الحالية';
$string['mustconfirm'] = 'عليك تأكيد حسابك';
$string['mycourses'] = 'مقرراتي الدراسية';
$string['myfiles'] = 'ملفاتي الخاصة';
$string['myfilesmanage'] = 'إدارة ملفاتي الخاصة';
$string['myhome'] = 'لوحة التحكم';
$string['mymoodledashboard'] = 'لوحتي على مودل';
$string['myprofile'] = 'ملفي الشخصي';
$string['name'] = 'الاسم';
$string['namedfiletoolarge'] = 'الملف \'{$a->filename}\' كبير جداً ولا يمكن رفعه';
$string['nameforlink'] = 'ماذا تريد تسمية هذا الرابط؟';
$string['nameforpage'] = 'الاسم';
$string['navigation'] = 'التصفح';
$string['needed'] = 'مطلوب';
$string['networkdropped'] = 'اكتشفنا أنَّ اتصالك  بالإنترنت لا يمكن الاعتماد عليه أوأنه مُتقطع .
<br />يرجى الانتباه بأن التغييرات قد لا يتم حفظها  بشكل صحيح حتى يتحسن الاتصال.';
$string['never'] = 'مطلقاً';
$string['neverdeletelogs'] = 'لا تحذف السجلات مطلقاً';
$string['new'] = 'جديد';
$string['newaccount'] = 'حساب مشترك جديد';
$string['newactivityname'] = 'اسم جديد للنشاط {$a}';
$string['newcourse'] = 'مقرر دراسي جديد';
$string['newpassword'] = 'كلمة المرور الجديدة';
$string['newpassword_help'] = '.أدخل كلمة مرور جديدة أو اترك الحقل فارغاً للحفاظ على كلمة المرور الحالية';
$string['newpasswordfromlost'] = 'مُلاحظة:</strong> سيتم أرسال <strong> كلمة مرورك الحالية</strong> ضمن رسالتين البريد الإلكتروني الخاصة بمعالجة إسترجاع كلمات المرور. تأكد من أستلام كلمة مررورك الجديدة قبل الإِسْتِمْرار بهذه الشاشة.';
$string['newpasswordtext'] = 'مرحبا {$a->firstname},

تم إعادة ضبط كلمة المرور الخاصة باشتراكك وتم تخصيص كلمة مرور جديدة مؤقتة.

معلومات الدخول الحالية الخاصة بك الآن:

اسم المستخدم: {$a->username}
كلمة المرور: {$a->newpassword}

يرجى الانتقال إلى هذه الصفحة لتغيير كلمة المرور:
 {$a->link}

في معظم برامج البريد، ينبغي أن يظهر هذا كرابط أزرق اللون
يمكنك النقر عليه. إذا لم ذلك متأتِّياً، قم بنسخ العنوان ولصقه
في شريط العنوان أعلى نافذة المتصفح.

تحيات من مدير \'{$a->sitename}\'،

{$a->signoff}';
$string['newpicture'] = 'صورة شخصية جديدة';
$string['newpicture_help'] = 'لإضافة صورة جديدة، استعرض واختر صورةً (بصيغة JPG أو PNG) ثم انقر "تحديث الملف الشخصي". الصورة سَتُقْصُّ إلى  مربّع بحجم 100 × 100 بكسل.';
$string['newpictureusernotsetup'] = 'الصورة الشخصية يمكن إضافتها بمجرد حفظ كل معلومات الملف الشخصي المطلوبة.';
$string['newsectionname'] = 'اسم جديد للمقطع {$a}';
$string['newsitem'] = 'بند إخباري';
$string['newsitems'] = 'الإعلانات';
$string['newsitemsnumber'] = 'عدد الإعلانات';
$string['newsitemsnumber_help'] = 'منتدى الإعلانات هو منتدى خاص يتم إنشاؤه تلقائياً للمقرر، فيه الاشتراك مفروض. فقط المستخدمون الذين يتمتعون بالصلاحيات المناسبة (المعلمون بطبيعة الحال) يمكنهم النشر فيه.

هذا الإعداد يحدد عدد ما يظهر في كتلة آخر الإعلانات من فقرات للطلاب.

في حال عدم الرغبة باستعمال منتدى الإعلانات، ينبغي ضبط هذا الإعداد على الصفر.';
$string['newuser'] = 'مستخدم جديد';
$string['newusernewpasswordsubj'] = 'حساب مستخدم جديد';
$string['newusernewpasswordtext'] = 'مرحباً {$a->firstname}،

لقد تم إنشاء حساب جديد لك في \'{$a->sitename}\'
وتم اصدار كلمة مرور مؤقتة جديدة لك.

معلومات دخولك إلي الموقع حالياً هي:
    اسم المستخدم: {$a->username}
   كلمة المرور: {$a->newpassword}
                (سيكون مطلوباً منك تغيير كلمة المرور عند دخولك إلي الموقع للمرة الأولى)

لتبدأ باستعمال \'{$a->sitename}\'، قم بالدخول عبر
          {$a->link}

في معظم برامجَ البريد الالكتروني، يَظْهر الرابط باللون الأزرق
ويمكنك مجرد النقر عليه. إذا لم يكن ذلك مُتأتِّياً، فقم بنسخه
ولصقه في شريط العنوان الموجود في أعلى نافذةِ متصفحِ الانترنت.

مدير موقع \'{$a->sitename}\' يرحب بك،
{$a->signoff}';
$string['newusers'] = 'المستخدمون الجدد';
$string['newwindow'] = 'نافذة جديدة';
$string['next'] = 'التالي';
$string['nextpage'] = 'الصفحة التالية';
$string['nextsection'] = 'القسم التالي';
$string['no'] = 'لا';
$string['noblockstoaddhere'] = 'لا توجد كتل يمكنك إضافتها إلى هذه الصفحة';
$string['nobody'] = 'لا أحد';
$string['nochange'] = 'لا يوجد أي تغير';
$string['nocomments'] = 'لا توجد تعليقات';
$string['nocourses'] = 'لا توجد مقررات دراسية';
$string['nocoursesfound'] = 'لا يوجد مقرر دراسي يحتوي على هذه الكلمات  \'{$a}\'';
$string['nocoursestarttime'] = 'المقرر الدراسي ليس له تاريخ بداية.';
$string['nocoursesyet'] = 'لا توجد مقررات دراسية لهذه الفئة';
$string['nodstpresets'] = 'لم يقم مدير الموقع بتمكين دعم التوقيت الصيفي';
$string['nofilesselected'] = 'لم يتم اختيار ملفات للقيام بعملية الأسترجاع';
$string['nofilesyet'] = 'لم يتم رفع أي ملف إلى مقررك بعد';
$string['nofiltersapplied'] = 'لم يتم تطبيق المرشحات';
$string['nograde'] = 'لا توجد درجة';
$string['nohelpforactivityorresource'] = 'لا يوجد حالياً أي مساعدة مرتبطة مع هذا المصدر أو النشاط';
$string['noimagesyet'] = 'لم يتم تحميل أي صورة للمقرر الدراسي الخاص بك';
$string['nologsfound'] = 'لم يتم العثور على سجلات';
$string['nomatchingusers'] = 'لا يوجد مستخدمون يطابقون \'{$a}\'';
$string['nomorecourses'] = 'لا يوجد المزيد من المقررات الدراسية المماثلة';
$string['nomoreidnumber'] = 'لتفادي التعارض لا تستخدم رقم تعريف';
$string['none'] = 'بلا';
$string['noneditingteacher'] = 'معلم بلا صلاحية التحرير';
$string['noneditingteacherdescription'] = 'المعلمون غير المحررين يمكنهم التدريس في المقررات الدراسية وإعطاء علامات للطلاب، لكن لا يمكنهم تعديل الأنشطة';
$string['nonstandard'] = 'لا قياسي';
$string['nopendingcourses'] = 'لا توجد مقررات دراسية تنتظر الموافقة عليها';
$string['nopotentialadmins'] = 'لا يوجد مدراء محتملون';
$string['nopotentialcreators'] = 'لا يوجد منشئوا مقرر دراسي محتملون';
$string['nopotentialstudents'] = 'لا يوجد طلاب محتملون';
$string['nopotentialteachers'] = 'لا يوجد معلمون محتملون';
$string['norecentactivity'] = 'لا يوجد إي انشطة حديثة';
$string['noreplybouncemessage'] = 'لقد قمت بالإجابة على عنوان بريد إلكتروني لا يستقبل إجابات. لو كنت ترغب في الإجابة على مشاركة في منتدى، الرجاء استخدم {$a} المنتديات للإجابة.

التالي هو محتوى بريدك الإلكتروني';
$string['noreplybouncesubject'] = '{$a} - بريد الإلكتروني معاد';
$string['noreplyname'] = 'لا ترسل رد على هذا البريد الإلكتروني';
$string['noresetrecord'] = 'لا يوجد سجل لهذا الطلب لإعادة التعيين. يرجى بدء طلب جديد لإعادة تعيين كلمة المرور.';
$string['noresults'] = 'لا توجد نتائج';
$string['normal'] = 'عادي';
$string['normalfilter'] = 'بحث عادي';
$string['nosite'] = 'لم يتم العثور على مقرر دراسي على مستوى الموقع';
$string['nostudentsfound'] = 'لم يتم العثور على {$a}';
$string['nostudentsingroup'] = 'لا يوجد طلاب في هذه المجموعة بعد';
$string['nostudentsyet'] = 'ليس هناك طلاب منضمون إلى هذا المقرر الدراسي.';
$string['nosuchemail'] = 'لا يوجد مثل هذا العنوان البريدي';
$string['notavailable'] = 'غير متوفر';
$string['notavailablecourse'] = '{$a} غير مُتاح';
$string['noteachersyet'] = 'لا يوجد معلمون لهذا المقرر الدراسي';
$string['noteachingupcomingcourses'] = 'المقررات الدراسية القادمة هي بلا معلمين أو طلاب';
$string['notenrolled'] = '{$a} غير مسجل في هذا المقرر الدراسي';
$string['notenrolledprofile'] = 'هذا الملف الشخصي غير متاح ﻷن هذا المستخدم غير منضم إلى هذا المقرر الدراسي.';
$string['noteusercannotrolldatesoncontext'] = '<strong>ملاحظة:</strong> لقد تم تعطيل إمكانية إعادة التواريخ عند استعادة الحفظ الاحتياطي هذا بسبب افتقارك للصلاحيات المطلوبة.';
$string['noteuserschangednonetocourse'] = 'ملاحظة: يتطلب إستراجاع مستخدمي المقرر الدراسي عند أعدت بيانت المستخدم (في الأنشطة، الملفات أو الرسائل). تم تغير هذا الاعداد لك';
$string['nothingnew'] = 'لا يوجد إي انشطة حديثة';
$string['nothingtodisplay'] = 'لا شيء لعرضه';
$string['notice'] = 'إشعار';
$string['noticenewerbackup'] = 'الملف الاحتياطي هذا تم إنشاؤه بمودل {$a->backuprelease} ({$a->backupversion}) وذلك الإصدار هو أحدث من الإصدار المنصب لديك الآن {$a->backuprelease} ({$a->backupversion}). هذا قد يسبب بعض التعارضات لأن توافق ملفات الحفظ الاحتياطي مع الإصدارات السابقة أمر لا يمكن ضمانه.';
$string['notifications'] = 'الإشعارات';
$string['notifyloginfailuresmessage'] = '{$a->time}, انترنت بروتوكول: {$a->ip}, مستخدم: {$a->info}, اسم المستخدم الكامل: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'تستطيع رؤية هذه السجلات في {$a}';
$string['notifyloginfailuresmessagestart'] = 'هذه قائمة بمحاولات الدخول الفاشلة إلى {$a} منذ آخر إشعار لك';
$string['notifyloginfailuressubject'] = '{$a}:: اشعار محاولات الدخول الفاشلة.';
$string['notincluded'] = 'غير متضمَّن';
$string['notingroup'] = 'عذراً، ينبغي عليك أن تكون عضواً في مجموعة لتتمكن من معاينة هذه الصفحة.';
$string['notpublic'] = 'ليس للعامة';
$string['nousersfound'] = 'لا يوجد مستخدمون';
$string['nousersmatching'] = 'لم يعثر على \'{$a}\' مستخدمين مماثلين';
$string['nousersyet'] = 'ليس هناك مستخدمون حتى الآن';
$string['novalidcourses'] = 'لا توجد مقررات دراسية صالحة ليتم عرضها';
$string['now'] = 'الآن';
$string['numattempts'] = '{$a} محاولات الدخول الخاطئة';
$string['numberofcourses'] = 'عدد المقررات';
$string['numberweeks'] = 'عدد المقاطع';
$string['numday'] = '{$a} يوم';
$string['numdays'] = '{$a} يوم/أيام';
$string['numhours'] = '{$a} ساعات';
$string['numletters'] = '{$a} أحرف';
$string['numminutes'] = '{$a} دقائق';
$string['nummonth'] = '{$a} شهر';
$string['nummonths'] = '{$a} أشهر';
$string['numseconds'] = '{$a} ثواني';
$string['numviews'] = '{$a} من المعاينات';
$string['numweek'] = '{$a} أسبوع';
$string['numweeks'] = '{$a} أسابيع';
$string['numwords'] = '{$a} كلمات';
$string['numyear'] = '{$a} سنة';
$string['numyears'] = '{$a} سنوات';
$string['ok'] = 'تم';
$string['oldpassword'] = 'كلمة المرور الحالية';
$string['olduserdirectory'] = 'هذا دليلُ المستخدمين القديمِ، ولَمْ يَعُدْ مطلوب. تستطيع أنْ تَحْذفُه بسلامة. لقد نُسِختْ الملفات التي كان يحتويها إلى دليلِ المستخدمين جديدِ.';
$string['optional'] = 'اختياري';
$string['options'] = 'خيارات';
$string['order'] = 'ترتيب';
$string['originalpath'] = 'المسار الأصلي';
$string['orphanedactivitiesinsectionno'] = 'أنشطة يتيمة (قسم {$a})';
$string['other'] = 'أخرى';
$string['outline'] = 'ملخص';
$string['outlinereport'] = 'تقرير خطوط عريضة';
$string['page'] = 'صفحة';
$string['pagea'] = 'صفحة {$a}';
$string['pagedcontentnavigation'] = 'التنقل بين الصفحات';
$string['pagedcontentnavigationactiveitem'] = 'الصفحة الحالية، صفحة {$a}';
$string['pagedcontentnavigationitem'] = 'الانتقال إلى صفحة {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'أظهر {$a} من العناصر في كل صفحة';
$string['pageheaderconfigablock'] = 'إعداد كتلة في  {$a->fullname}';
$string['pagepath'] = 'مسار الصفحة';
$string['pageshouldredirect'] = 'هذه الصفحة ينبغي أن تنتقل تلقائياً لصفحة أخرى. إذا لم يحدث شيء، فمن فضلك استخدم وصلة الاستمرار أدناه';
$string['parentcategory'] = 'التصنيف الأعلى';
$string['parentcoursenotfound'] = 'لم يتم العثور على مقرر دراسي أساسي';
$string['parentfolder'] = 'مجلد أساسي';
$string['participants'] = 'المشاركون';
$string['participantscount'] = 'عدد المشاركين: {$a}';
$string['participantslist'] = 'قائمة المشاركين';
$string['participationratio'] = 'نسبة المشاركة';
$string['participationreport'] = 'تقرير المشاركة';
$string['password'] = 'كلمة المرور';
$string['passwordchanged'] = 'تم تغيير كلمة المرور';
$string['passwordconfirmchange'] = 'تأكيد تغير كلمة المرور';
$string['passwordextlink'] = 'الرابط التالي سيساعدك على استرجاع كلمة مرورك المفقودة. كما سيقوم بإخراجك من مودل';
$string['passwordforgotten'] = 'كلمة المرور المنسية';
$string['passwordforgotteninstructions'] = 'ينبغي أولاً العثور على معلوماتك في قاعدة بيانات المستخدمين. رجاءً أدخل <strong>إما</strong> اسم المستخدم الخاص بك أو عنوان بريدك الالكتروني الذي سجلت به في المربع المناسب. ليس هناك داعٍ لإدخال كليهما.';
$string['passwordforgotteninstructions2'] = 'لإعادة تعيين كلمة المرور، أدخل اسم المستخدم أو البريد الإلكتروني الخاص بك في الأسفل. ستتم مراسلتك من قبل الموقع في حال إيجادك في قاعدة البيانات، مع تعليمات عن كيفية الدخول مجددًا.';
$string['passwordnohelp'] = 'لا يوجد مساعدة للحصول على كلمة مرورك. الرجاء الاتصال بمدير الموقع';
$string['passwordpolicynomatch'] = 'كلمة مرورك لم تعد متوافقة مع سياسة وضع كلمات المرور.
   {$a}';
$string['passwordrecovery'] = 'نعم، ساعدني على الدخول';
$string['passwordsdiffer'] = 'كلمات المرور لا تتطابق';
$string['passwordsent'] = 'تم إرسال كلمة المرور';
$string['passwordsenttext'] = '<p>تم إرسال رسالة إلى العنوان {$a->email}.</p>
   <p><b>يرجى البحث في البريد عن كلمة المرور</b></p>
   <p>تم إصدار كلمة مرور جديدة، وربما رغبت في
   < a href="{$a->link}">في تغييرها إلى شيء أبسط من ذلك حتى يسهل تذكرها</a>.</p>';
$string['passwordset'] = 'تم تعيين كلمة المرور الخاصة بك.';
$string['path'] = 'مسار';
$string['pathnotexists'] = 'المسار غير موجود في الخادم';
$string['pathslasherror'] = 'لا يمكن انهاء المسار بعلامة مائلة!!';
$string['paymentinstant'] = 'استخدم الزر التالي لدفع الرسوم التسجيل خلال دقائق.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> ينتظر</small>)';
$string['paymentrequired'] = 'هذا المقرر الدراسي غير مجاني ، لذا يجب دفع القيمة للدخول.';
$string['payments'] = 'أقساط مالية';
$string['paymentsorry'] = 'شكراً لقيامك بدفع المبلغ المطلوب! ولكن لسوء الحظ لم يتم حتى الآن إنهاء إجراءات الخاصة بتسجيلك، لذا لن تتمكن من الدخول إلى المقرر الدراسي "{$a->fullname}". الرجاءً حاولْ الدخول بعد بضعة ثواني، في حالة عدم تمكن من الدخول بعد عدة محاولات الرجاءً إحاطة{$a->teacher} معلّم أَو مدير الموقعَ.';
$string['paymentthanks'] = 'شكراً لقيامك بدفع المبلغ المالي! لقد تم تسجيلك في المقرر الدراسي: :<br /> "{$a}"';
$string['pendingrequests'] = 'طلبات تتنظر الموافقة';
$string['percents'] = '{$a}%';
$string['periodending'] = 'تنتهي الفترة ({$a})';
$string['perpage'] = 'في كل صفحة';
$string['perpagea'] = 'لكل صفحة: {$a}';
$string['personal'] = 'شخصي';
$string['personalprofile'] = 'السيرة الذاتية';
$string['phone'] = 'الهاتف';
$string['phone1'] = 'الهاتف';
$string['phone2'] = 'الهاتف المحمول';
$string['phpinfo'] = 'معلومات PHP';
$string['pictureof'] = 'صورة {$a}';
$string['pictureofuser'] = 'صورة المستخدم';
$string['pleaseclose'] = 'الرجاء إغلاق هذه النافذة الآن.';
$string['pleasesearchmore'] = 'من فضلك قم بالمزيد من البحث';
$string['pleaseusesearch'] = 'رجاءً استخدم البحث';
$string['plugin'] = 'الملحق';
$string['plugincheck'] = 'فحص الملاحق';
$string['plugindeletefiles'] = 'كُلّ البيانات المرتبطة بالملحق \'{a$->name}\' تم حذفها مِنْ قاعدةِ البيانات. لمَنع الملحق من إعادة تنصيب نفسه تلقائياً، يَجِبُ أَنْ تَحْذفَ هذا المجلد الآن مِنْ مخدمِكَ: {$a->directory}';
$string['pluginsetup'] = 'أعداد جداول التوصيلات';
$string['policyaccept'] = 'لقد فهمت وأوافق';
$string['policyagree'] = 'يجب الموافقة على هذه الشروط للإستمرار في إستخدام الموقع. هل أنت موافق؟';
$string['policyagreement'] = 'إتفاقية سياسة الموقع';
$string['policyagreementclick'] = 'رابط إلى اتفاقية سياسة الموقع';
$string['popup'] = 'منبثقة';
$string['popupwindow'] = 'فتح الملف في نافذة جديدة';
$string['popupwindowname'] = 'النافذة المنبثقة';
$string['post'] = 'نشر';
$string['posts'] = 'المنشورات';
$string['potentialadmins'] = 'مدراء محتملون';
$string['potentialcreators'] = 'منشئون مقرر دراسي محتملون';
$string['potentialstudents'] = 'طلاب محتملون';
$string['potentialteachers'] = 'معلمون محتملون';
$string['preferences'] = 'التفضيلات';
$string['preferredlanguage'] = 'اللغة المفضلة';
$string['preferredtheme'] = 'السمة المفضلة';
$string['preprocessingbackupfile'] = 'ملف النسخ الاحتياطي للتجهيز';
$string['prev'] = 'السابق';
$string['preview'] = 'معاينة';
$string['previeworchoose'] = 'اختر الشكل المناسب  ليظهر الموقع به';
$string['previous'] = 'السابق';
$string['previouslyselectedusers'] = 'المستخدمون المختارون سابقاً غير المطابقين لـ \'{$a}\'';
$string['previouspage'] = 'الصفحة السابقة';
$string['previoussection'] = 'الجزء السابق';
$string['primaryadminsetup'] = 'إعداد حساب مديرالموقع';
$string['privacy:metadata:config_log'] = 'سجل توثيق تعديلات الإعدادات';
$string['privacy:metadata:config_log:name'] = 'تغييرات تسمية الإعداد';
$string['privacy:metadata:config_log:oldvalue'] = 'القيمة السابقة لهذا الإعداد';
$string['privacy:metadata:config_log:plugin'] = 'الملحق المغَيَّر';
$string['privacy:metadata:config_log:timemodified'] = 'وقت إجراء التعديل';
$string['privacy:metadata:config_log:userid'] = 'المستخدم الذي أجرى التعديل';
$string['privacy:metadata:config_log:value'] = 'القيمة الجديدة لهذا الإعداد';
$string['privacy:metadata:events_queue'] = 'طابور أحداث المستخدم التي بصدد المعالجة';
$string['privacy:metadata:events_queue:eventdata'] = 'البيانات المخزونة في الحدث';
$string['privacy:metadata:events_queue:stackdump'] = 'أي من تبعات المكدس المرتبطة بهذا الحدث';
$string['privacy:metadata:events_queue:timecreated'] = 'وقت إنشاء هذا الحدث';
$string['privacy:metadata:events_queue:userid'] = 'معرَّف المستخدم المرتبط بهذا الحدث';
$string['privacy:metadata:log'] = 'مجموعة من الأحداث السابقة';
$string['privacy:metadata:log:action'] = 'وصف الإجراء';
$string['privacy:metadata:log:cmid'] = 'المفتاح الأساسي لوحدة المقرر الدراسي';
$string['privacy:metadata:log:course'] = 'المقرر الدراسي';
$string['privacy:metadata:log:info'] = 'معلومات إضافية';
$string['privacy:metadata:log:ip'] = 'عنوان IP المستعمل وقت وقوع الحدث';
$string['privacy:metadata:log:module'] = 'الوحدة';
$string['privacy:metadata:log:time'] = 'وقت اتخاذ الإجراء';
$string['privacy:metadata:log:url'] = 'عنوان الرابط المتعلق بالحدث';
$string['privacy:metadata:log:userid'] = 'معرَّف المستخدم الذي نفذ الإجراء';
$string['privacy:metadata:oauth2_refresh_token'] = 'ترميز التنشيط المستعمل في اتصالات OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'مُعرَّف المُصدر العائد له الترميز';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'مُعرَّف المستخدم العائد له الترميز';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'وقت إنشاء الترميز';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'وقت آخر تحديث للترميز';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'ترميز التنشيط للنطاقات والمستخدم المعنيين';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'مُعرَّف المستخدم العائد له الترميز';
$string['privacy:metadata:task_adhoc'] = 'حالة المهام المخصصة';
$string['privacy:metadata:task_adhoc:component'] = 'المكون المالك للمهمة';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'أقرب وقت لتشغيل هذه المهمة';
$string['privacy:metadata:task_adhoc:userid'] = 'المستخدم الذي له أن يشغل المهمة بمثابة';
$string['privacy:metadata:task_log'] = 'مخرجات التوثيق لسجل التوثيق';
$string['privacy:metadata:task_log:component'] = 'المُكون المالك للمهمة';
$string['privacy:metadata:task_log:userid'] = 'المستخدم الذي تعود إليه المهمة';
$string['privacy:metadata:upgrade_log'] = 'سجل توثيق الترقية';
$string['privacy:metadata:upgrade_log:backtrace'] = 'أي تتبع خلفي مرتبط بخطوة الترقية هذه';
$string['privacy:metadata:upgrade_log:details'] = 'معلومات إضافية ذات صلة بالترقية';
$string['privacy:metadata:upgrade_log:info'] = 'المعلومات الرئيسية لخطوة الترقية هذه';
$string['privacy:metadata:upgrade_log:plugin'] = 'الملحق الذي تمت ترقيته';
$string['privacy:metadata:upgrade_log:targetversion'] = 'النسخة الجديدة المزمع الترقية إليها';
$string['privacy:metadata:upgrade_log:timemodified'] = 'الوقت الذي وقعت فيه الترقية';
$string['privacy:metadata:upgrade_log:type'] = 'نوعية مُدخَل سجل التوثيق';
$string['privacy:metadata:upgrade_log:userid'] = 'المستخدم الذي نفذ الترقية';
$string['privacy:metadata:upgrade_log:version'] = 'النسخة القديمة للملحق';
$string['private_files_handler'] = 'خزِّن مُرفقات البريد الإلكتروني في منطقة تخزين الملفات الخاصة بالمستخدم.';
$string['private_files_handler_name'] = 'إرسال بالبريد الإلكتروني إلى الملفات الخاصة';
$string['privatefiles'] = 'الملفات الخاصة';
$string['privatefilesmanage'] = 'إدارة الملفات الخاصة';
$string['proceed'] = 'تمت معالجته';
$string['profile'] = 'الملف الشخصي';
$string['profilenotshown'] = 'لن يتم إظهار وصف الملف الشخصي هذا حتى ينضم صاحبه إلى مقرر واحد على الأقل.';
$string['publicprofile'] = 'ملف شخصي علني';
$string['publicsitefileswarning'] = 'ملاحظة: سيتمكن أي شخص من الوصول إلى الملفات الموجودة هنا';
$string['publicsitefileswarning2'] = 'المُلاحظة: جميع الملفاتُ المحفوظة هنا يمكِن الدخول مِن قِبل أي شخص يعرف (أَو يُمْكِنُ أَنْ يخمن) العنوان. للأسباب أمنية، نوصي  بحذف جميع ملفات النسخ الاحتياطي بعد عملية استعادتها.';
$string['publicsitefileswarning3'] = 'المُلاحظة: جميع الملفاتُ المحفوظة هنا يمكِن الدخول مِن قِبل أي شخص يعرف (أَو يُمْكِنُ أَنْ يخمن) العنوان. للأسباب أمنية، بحذف جميع ملفات النسخ الاحتياطي يجب حفظها في مجلد أمن وخاص بالنسخ الاحتياطي.';
$string['question'] = 'السؤال';
$string['questionsinthequestionbank'] = 'الاسئلة الموجودة في بنك الاسئلة';
$string['queued'] = 'ضمن الطابور';
$string['quotausage'] = 'حتى الآن قد استخدمت {$a->used} من ال {$a->total} المسموحه';
$string['readinginfofrombackup'] = 'قراءة المعلومات من النسخة الإحتياطية';
$string['readme'] = 'إقرأني';
$string['recentactivity'] = 'آخر نشاط';
$string['recentactivityreport'] = 'تقرير كامل للنشاط الحالي';
$string['recipientslist'] = 'قائمة المستلمون';
$string['recommended'] = 'موصى به';
$string['recreatedcategory'] = 'التصنيف المعاد إنشاؤه {$a}';
$string['redirect'] = 'إعادة توجيه';
$string['reducesections'] = 'قلل عدد المقاطع';
$string['refresh'] = 'تحديث';
$string['refreshingevents'] = 'تحديث الأحداث';
$string['registration'] = 'تسجيل مودل';
$string['registrationcontact'] = 'اتصال من العموم';
$string['registrationcontactno'] = 'لا، لا أريد أن يتم الاتصال بي من قبل الآخرين';
$string['registrationcontactyes'] = 'نعم، زود مستخدمي moodle بنموذج للأتصال بي';
$string['registrationemail'] = 'إشعارات البريد الإلكتروني';
$string['registrationinfo'] = '<p>هذه الصفحة تسمح لك بتسجيل موقعك مع moodle.org. التسجيل مجاني.
الهدف الرئيس من التسجيل هو إضافتك إلى قائمة البريد الالكتروني لتزويدك بالإشعارات الهامة مثل قضايا الأمان والإصدارات الجديدة لمودل.</p>
<p>إفتراضياً، معلوماتك ستبقى خاصة، ولن تباع أو تسلم إلى جهة أخرى. السبب الرئيس من تجميع هذه البيانات هو لأغراض الدعم الفني والمساعدة في بناء صورة إحصائية عن جمهور مودل بشكل عام.</p>
<p>بناءً على رغبتك، يمكنك السماح بنشر اسم موقعك ودولتك في القائمة العامة لمواقع مودل.</p>
<p>كل التسجلات الجديدة يجري التأكد منها يدوياً قبل إضافتها إلى القائمة، ولكن بمجرد إضافتك يمكنك تحديث بيانات تسجيلك (وسجلك ضمن القائمة العامة) عبر إعادة إرسال هذا النوذج في أي وقت.</p>';
$string['registrationinfotitle'] = 'معلومات التسجيل';
$string['registrationno'] = 'لا، ليست لديَّ الرغبة بتلقي أي رسائل الكترونية';
$string['registrationsend'] = 'أرسل معلومات التسجيل إلى moodle.org';
$string['registrationyes'] = 'نعم، أشعرني بإصدارات مودل الجديدة، تنبيهات الأمان، والأخبار الهامة الأخرى';
$string['reject'] = 'أرفض';
$string['rejectdots'] = 'أرفض .......';
$string['relativedatesmode'] = 'نمط التواريخ النسبية';
$string['relativedatesmode_help'] = 'إعرض تواريخ المقررات الدراسية أو النشاطات بشكل مقاس نسبة إلى تاريخ بدء المستخدم بالمقرر.

تاريخ بدء المستخدم بالمقرر سيكون هو نفسه تاريخ الانضمام إليه، ما لم يكن هذا التاريخ سابقاً لتاريخ بدء المقرر، وعندها سيعتبر هو نفسه تاريخ بدء المقرر.

تحذير: هذه الميزة تجريبية وقد لا تدعمها كل النشاطات حالياً. بمجرد إنشاء المقرر، لا يعود هذا الإعداد قابلاً للتعديل.';
$string['relativedatesmode_warning'] = '<strong>تحذير:</strong> نمط التواريخ النسبية لا يمكن تغييره بمجرد إنشاء المقرر الدراسي.';
$string['reload'] = 'إعادة التحميل';
$string['remoteappuser'] = 'بعيد {$a} مستخدم';
$string['remove'] = 'إزالة';
$string['removeadmin'] = 'استبعاد مدير';
$string['removecreator'] = 'إزالة منشئ المقرر الدراسي';
$string['removestudent'] = 'استبعاد طالب';
$string['removeteacher'] = 'استبعاد معلم';
$string['rename'] = 'تغيير الاسم';
$string['renamefileto'] = 'تغيير الاسم <b>{$a}</b> إلي';
$string['report'] = 'تقرير';
$string['reports'] = 'التقارير';
$string['repositories'] = 'مستودعات';
$string['requestcourse'] = 'أطلب مقرراً دراسياً';
$string['requestedby'] = 'تم الطلب بواسطة';
$string['requestedcourses'] = 'المقررات المطلوبة';
$string['requestreason'] = 'سبب طلب المقرر الدراسي';
$string['requests'] = 'الإلتماسات';
$string['required'] = 'مفروض';
$string['requirespayment'] = 'هذا المقرر الدراسي يتطلب الدفع المالي قبل الاشتراك فيه';
$string['resendemail'] = 'إعادة إرسال البريد الالكتروني';
$string['reset'] = 'إعادة التعيين';
$string['resetcomponent'] = 'مكوّن';
$string['resetcourse'] = 'إعادة تعيين المقرر الدراسي';
$string['resetinfo'] = 'هذه الصفحةِ تَسْمحُ لك بإفراغ المقرر الدراسي من بيانات المستخدمين، في حين تَحتفظُ بالنشاطاتِ والإعدادات الأخرى. رجاءً كُنْ حَذراً، فبمجرد إخْتياَرك للعناصر أدناه والقيام بتسليم هذه الصفحة سيتم حْذفُ بيانات المستخدمين التي حددتها نهائياً!';
$string['resetnotimplemented'] = 'إعادة التعيين لا تشمل';
$string['resetrecordexpired'] = 'مرَّ على رابط إعادة تعيين كلمة المرور الذي أدخلته أكثر من {$a}  دقيقة وقد انتهت صلاحيته. الرجاء بدء عملية تعيين كلمة المرور جديدة';
$string['resetstartdate'] = 'إعادة تعيين تاريخ البدء';
$string['resetstatus'] = 'الوضع الراهن';
$string['resettable'] = 'إعادة تعيين تفضيلات الجدول';
$string['resettask'] = 'مهمة';
$string['resettodefaults'] = 'إعادة التعيين إلى الوضع الافتراضي';
$string['resortcourses'] = 'ترتيب المقررات الدراسية';
$string['resortsubcategoriesby'] = 'رتب التصنيفات الفرعية حسب  {$a} تصاعدياً';
$string['resortsubcategoriesbyreverse'] = 'رتب التصنيفات الفرعية حسب  {$a} تنازلياً';
$string['resource'] = 'المورد';
$string['resourcedisplayauto'] = 'تلقائي';
$string['resourcedisplaydownload'] = 'فرض التنزيل';
$string['resourcedisplayembed'] = 'تضمين';
$string['resourcedisplayframe'] = 'في إطار';
$string['resourcedisplaynew'] = 'نافذة جديدة';
$string['resourcedisplayopen'] = 'فتح';
$string['resourcedisplaypopup'] = 'في نافذة منبثقة';
$string['resources'] = 'الموارد';
$string['resources_help'] = 'أنواع الموارد تُمكنك من إدراج أي نوع من محتوى الويب تقريبًا في المقرر الدراسي.';
$string['restore'] = 'إسترجاع';
$string['restorecancelled'] = 'إسترجاع ما تم إلغائه';
$string['restorecannotassignroles'] = 'عملية الاسترجاع تحتاج لتعيين ادوار وانت لا تملك الصلاحية للقيام بذلك';
$string['restorecannotcreateorassignroles'] = 'عملية الاسترجاع تحتاج إنشاء أو لتعيين ادوار وانت لا تملك الصلاحية للقيام بذلك';
$string['restorecannotcreateuser'] = 'عملية الاسترجاع تتطلب إنشاء حساب مستخدم \'{$a}\' من ملف الحفظ الاحتياطي وليست لديك الصلاحية للقيام بذلك';
$string['restorecannotoverrideperms'] = 'الاستعادة تحتاج تخطي الصلاحيات، وأنت ليس لديك صلاحية لتقوم بذلك';
$string['restorecoursenow'] = 'استرجع هذا المقرر الدراسي الآن!';
$string['restoredaccount'] = 'الحساب المسترجع';
$string['restoredaccountinfo'] = 'لقد تم استيراد هذا الحساب من مخدم آخر وكلمة المرور قد فُقدت. لوضع كلمة مرور جديد بواسطة البريد الالكتروني، يرجى النقر على "استمر"';
$string['restorefinished'] = 'الاسترجاع تم بنجاح';
$string['restoremnethostidmismatch'] = 'هوية مستضيف MNet \'{$a}\' غير مطابقة لمستضبف المحلي MNet للمستخدم';
$string['restoreto'] = 'أسترجع إلي';
$string['restoretositeadding'] = 'تحذير: أنتَ على وشك الاستعادة إلى صفحة الموقع الرئيسية، مضيفاً البيانات إليها!';
$string['restoretositedeleting'] = 'تحذير: أنتَ على وشك الاستعادة إلى صفحة الموقع الرئيسية، حاذفاً البيانات منها أولاً!';
$string['restoreuserconflict'] = 'ستحدث تضاربات لو تمت محاولة استعادة المستخدم \'{$a}\' من ملف النسخة الاحتياطية';
$string['restoreuserinfofailed'] = 'لقد تم إقاف عملية الاسترجاع وذلك لعدم وجود صلاحية لديك لإسترجاع بيانات مستخدم';
$string['restoreusersprecheck'] = 'فحص بيانات المستخدم';
$string['restoreusersprecheckerror'] = 'تم الكشف عن بعض الأخطاء أثناء فحص بيانات المستخدمين';
$string['restricted'] = 'متحكم فيه';
$string['resultsfound'] = 'تم العثور على {$a} نتيجة';
$string['retry'] = 'إعادة المحاولة';
$string['returningtosite'] = 'هل أنت مشترك بالفعل؟ الدخول من هنا';
$string['returntooriginaluser'] = 'عودة إلى {$a}';
$string['revert'] = 'عكس';
$string['role'] = 'الدور';
$string['roleassignments'] = 'تعيينات الأدوار';
$string['rolemappings'] = 'تخطيط الأدوار';
$string['rolerenaming'] = 'إعادة تسمية الدور';
$string['rolerenaming_help'] = 'هذا الإعداد يَسْمحُ بتغيير أسماء الأدوارِ المعدلة والمستعملة في المقرر. سيتغير اسم الدور فقط - صلاحية الدورِ لن تتأثر. أسماء الدورِ الجديدةِ ستظهر على صفحةِ مشاركي المقرر وفي أماكن أخرى ضمن المقرر. اسم الدورِ الجديدِ سيُعرض أيضاً كجزء مِنْ قائمة المقررات الدراسية، إذا كان هذا الدور المعدل هو أحد الأدوار التي اختارها مشرف الموقع لإدارة المقرر.';
$string['roles'] = 'الأدوار';
$string['rss'] = 'خدمة تغذية المعلومات';
$string['rssarticles'] = 'عدد مقالات خدمة تغذية المعلومات الحالية';
$string['rsserror'] = 'خطأ عند قراءة بيانات خدمة تغذية الأخبار';
$string['rsserrorauth'] = 'لايحتوي رابط خدمة التغذية عن بُعد على مفتاح توثيق صحيح';
$string['rsserrorguest'] = 'تستعملُ هذه التغذية دخول الضيفِ للوصول إلى البياناتِ، لكن الضيفَ ليس لدية الصلاحية لقِراءة البياناتِ. قم بزيارة الموقعَ الأصليَ لهذه التغذيةِ كمستخدم واحصل على رابط خدمة التغذية عن بُعد من الموقع الأصلي.';
$string['rsskeyshelp'] = '<p>لضمان الأمان والخصوصية، تحتوي روابط خدمة مغذيات الأخبار على ترميز خاص لتمييز المستخدم مالك الوصلة. هذا يمنع المستخدمين الآخرين من الوصول إلى مناطق في الموقع لا صلاحيات لهم بدخولها.</p><p> يتم توليد هذا الترميز بشكل تلقائي عند أول مرة يتم فيها الوصول إلى المنطقة التي ستولد روابط مغذيات الأخبار. إن كنت تظن أن ترميزك الخاص قد تمت سرقته، يمكنك المطالبة بواحد جديد عبر النقر على زر إعادة التعيين. الرجاء ملاحظة أن روابط خدمة مغذيات الأخبار الحالية الخاصة بك ستصير غير فعالة.</p>';
$string['rsstype'] = 'خدمة تغذية المعلومات لهذا النشاط';
$string['save'] = 'احفظ';
$string['saveandnext'] = 'احفظ ثم أظهر التالي';
$string['savechanges'] = 'حفظ التغييرات';
$string['savechangesanddisplay'] = 'حفظ ومعاينة';
$string['savechangesandreturn'] = 'حفظ وعودة';
$string['savechangesandreturntocourse'] = 'حفظ وعودة إلى المقرر الدراسي';
$string['savecomment'] = 'حفظ التعليق';
$string['savedat'] = 'تم الحفظ في:';
$string['savepreferences'] = 'حفظ التفضيلات';
$string['saveto'] = 'حفظ إلى';
$string['scale'] = 'المقياس';
$string['scale_help'] = 'يقدم المِقياس طريقة للتَقييم أَو منح الدرجات على الأداءِ في النشاطِ. هو مُعَرَّفُ بقائمة مرتبة مِن القِيَمِ، تتَرَاوُح مِن السلبيِ إلى الإيجابي، مفصولة عناصرها بفواصل، على سبيل المثال "مخَيب للآمال، لَيسَ جيداً بما فيه الكفاية، متوسط، جيد، جيد جداً، ممتاز!"';
$string['scales'] = 'المقاييس';
$string['scalescustom'] = 'المقاييس المخصصة';
$string['scalescustomcreate'] = 'إضافة مقياس جديد';
$string['scalescustomno'] = 'لم يتم إنشاء مقاييس مصممة شخصياُ بعد';
$string['scalesstandard'] = 'المقاييس القياسية';
$string['scalestandard'] = 'مقياس قياسي';
$string['scalestandard_help'] = 'المقياس القياسي متاح على مستوى الموقع لكل المقررات الدراسية';
$string['scalestip'] = 'لإنشاء مقاييس مخصصة، استخدم رابط ’مقاييس’من قائمة إدارة المقرر الدراسي';
$string['scalestip2'] = 'لإنشاء مقاييس مخصصة، إختر رابط العلامات في قائمةِ إدارةِ المقرر الدراسي، ثمّ اختر تحرير المقاييس.';
$string['schedule'] = 'موعد';
$string['screenshot'] = 'لقطة الشاشة';
$string['search'] = 'بحث';
$string['search_help'] = 'للبحث الأساسي المكون مِنْ كلمة واحدة أو كلماتِ أكثرِ أينما تواجدت في النص، فقط أدخل الكلمات مفصولة بمسافة بينها. يتم استعمال كل الكلمات التي تزيد عن حرفين.

للبحث المتقدّمِ، اضْغط زر البحث بدون طِباعة أيّ شيء في مربع البحث للوصول إلى نموذج البحث المتقدم.';
$string['searchactivities'] = 'البحث عن النشاطات عبر أسمائها أو أوصافها';
$string['searchagain'] = 'البحث مرة أخرى';
$string['searchbyemail'] = 'البحث بعنوان البريد الإلكتروني';
$string['searchbyusername'] = 'البحث باسم المستخدم';
$string['searchcoursecategories'] = 'البحث في التصنيفات';
$string['searchcourses'] = 'البحث في المقررات الدراسية';
$string['searchoptions'] = 'خيارات البحث';
$string['searchresults'] = 'نتائج البحث';
$string['sec'] = 'ثانية';
$string['seconds'] = 'ثواني';
$string['secondsleft'] = '{$a} ثواني';
$string['secondstotime172800'] = 'يومين';
$string['secondstotime259200'] = 'ثلاثة أيام';
$string['secondstotime345600'] = 'أربعة أيام';
$string['secondstotime432000'] = 'خمسة أيام';
$string['secondstotime518400'] = 'ستة أيام';
$string['secondstotime604800'] = 'أسبوع واحد';
$string['secondstotime86400'] = 'يوم واحد';
$string['secretalreadyused'] = 'لقد تم استعمال رابط تغيير كلمة المرور مسبقاً، لم يتم تغيير كلمة المرور.';
$string['secs'] = 'ثواني';
$string['section'] = 'قسم';
$string['sectionactionnotsupported'] = 'إجراء المقطع "{$a}" غير مدعوم هنا';
$string['sectionname'] = 'اسم المقطع';
$string['sections'] = 'المقاطع';
$string['seealsostats'] = 'طالع أيضاً : الإحصائيات';
$string['selctauser'] = 'حدَّد المُستخدم';
$string['select'] = 'إختر';
$string['selectacategory'] = 'الرجاء اختيار التصنيف';
$string['selectacountry'] = 'إختر البلد';
$string['selectacourse'] = 'إختر المقرر الدراسي';
$string['selectacoursesite'] = 'إختر المقرر الدراسي أو الموقع';
$string['selectagroup'] = 'إختر المجموعة';
$string['selectall'] = 'إختر الكل';
$string['selectallusersonpage'] = 'تحديد كل المستخدمين في هذه الصفحة';
$string['selectalluserswithcount'] = 'تحديد كل المستخدمين {$a}';
$string['selectamodule'] = 'الرجاء اختيار وحدة نشاط';
$string['selectanaction'] = 'إختر الإجراء';
$string['selectanoptions'] = 'حدد اختياراً';
$string['selectaregion'] = 'إختر المنطقة';
$string['selectcategorysort'] = 'ما هي التصنيفات التي تريد ترتيبها';
$string['selectcategorysortby'] = 'إختر الطريقة التي تريدها  لترتيب التصنيفات';
$string['selectcoursesortby'] = 'إختر الطريقة التي تريدها لترتيب المقررات الدراسية';
$string['selectdefault'] = 'عيِّن  الخيار الافتراضي';
$string['selectedcategories'] = 'إختر التصنيفات';
$string['selectedfile'] = 'الملف المحدد';
$string['selectednowmove'] = '{$a} ملف محدد للنقل. إذهب الآن إلى المكان المرغوب النقل إليه وأنقر على "أنقل الملفات إلى هنا"';
$string['selectfiles'] = 'حدِّد الملفات';
$string['selectitem'] = 'إختر \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'تحديد النشاط أو المصدر لعرض التعليمات المُساعدة الخاصة به.

انقر نقراً مزدوجاً على اسم النشاط أو المصدر لإضافته بسرعة.';
$string['selectnos'] = 'إختر كل ما هو \'لا\'';
$string['selectperiod'] = 'إختر الفترة';
$string['senddetails'] = 'أرسل بياناتي بالبريد الإلكتروني';
$string['separate'] = 'مُنفصل';
$string['separateandconnected'] = 'طرق منفصلة ومتصلة للمعرفة';
$string['separateandconnectedinfo'] = 'المِقياس مستند على نظريةِ المعرفة المنفصلةِ والمُرتَبِطةِ. تَصِفُ هذه النظريةِ طريقين مختلفينِ يُمْكِنُ من خلالهما أَنْ نُقيّمَ ونَتعلّمَ عن الأشياءِ التي نَراها ونَسْمعُها. <ul><li> <strong>المتعلم المنفصل</strong> يَبْقى موضوعياً قدر الإمكان بدون تَضْمين المشاعرِ والعواطفِ. عند المُناقشة مَع الآخرين، يُحْبّونَ الدِفَاع عن أفكارِهم الخاصةِ، مستعملين المنطق لإيجاد نقاط الضعف في أفكارِ الخصوم. </li><li><strong>المتعلم المرتبط</strong> أكثر حسّاسية نحو الآخرينِ. هم ماهرون في التعاطفِ معهم ويَمِيلونَ إلى الاستماع وطرح الأسئلةِ حتى يَشْعُروا بأنّهم يُمْكِنُ أَنْ يتواصلوا و "يَفْهموا الأشياءَ مِنْ وجهةِ نظرهم". يَتعلّمونَ عبر مُحَاوَلَة مشاركة التجاربَ التي قادت إلى المعرفةِ والتي يجدونها عند الآخرين.</li></ul>.';
$string['servererror'] = 'حدث خطأ أثناء الاتصال مع الخادم';
$string['serverlocaltime'] = 'التوقيت المحلي للخادم';
$string['sessionforceclean'] = 'كإجراء أمان إحترازي، تم تعطيل نصوص المستخدم البرمجية المولدة ضمن هذه الجلسة.';
$string['sessiontimeoutsoon'] = 'جلسة عملك على وشك الانتهاء. هل تريد تمديدها؟';
$string['setcategorytheme'] = 'تحديد سمة/قالب التصنيف';
$string['setpassword'] = 'تعيين كلمة المرور';
$string['setpasswordinstructions'] = 'الرجاء إدخال كلمة سر جديد أدناه ثم احفظ التغييرات';
$string['settings'] = 'الإعدادات';
$string['shortname'] = 'الاسم المختصر';
$string['shortnamecollisionwarning'] = '[*] = الاسم المختصر هذا مستعمل سلفاً من قبل مقرر دراسي آخر وسيتطلب الأمر تغييره عند الموافقة';
$string['shortnamecourse'] = 'الاسم المختصر للمقرر';
$string['shortnamecourse_help'] = 'الاسم المختصر للمقرر يتم عرضه في أدوات التنقل ويستعمل في سطر الموضوع الخاص برسائل البريد الالكتروني المتعلقة به.';
$string['shortnametaken'] = 'الاسم المختصر مستعمل سلفاً في مقرر دراسي آخر ({$a})';
$string['shortnameuser'] = 'اسم المستخدم القصير';
$string['shortsitename'] = 'اسم الموقع مختصراً (كلمة واحدة على سبيل المثال)';
$string['show'] = 'عرض';
$string['showactions'] = 'إظهار الإجراءات';
$string['showadvancededitor'] = 'متقدم';
$string['showadvancedsettings'] = 'عرض الاعدادات المتقدمة';
$string['showall'] = 'عرض الكل {$a}';
$string['showallcourses'] = 'إظهار كل المقررات الدراسية';
$string['showallusers'] = 'إظهار كل المستخدمين';
$string['showblockcourse'] = 'أظهر قائمة المقررات الدراسية التي تحتوي على الكتلة';
$string['showcategory'] = 'عرض {$a}';
$string['showchartdata'] = 'إظهار بيانات الرسم البياني';
$string['showcomments'] = 'عرض/إخفاء التعليقات';
$string['showcommentsnonjs'] = 'إظهار التعليقات';
$string['showdescription'] = 'إعرض الوصف في صفحة المقرر الدراسي';
$string['showdescription_help'] = 'عند تمكينه، سيتم عرض الوصف أعلاه في صفحة المقرر الدراسي أسفل الرابط المؤدي إلى النشاط أو المورد';
$string['showgrades'] = 'أظهر سجل التقديرات للطلاب';
$string['showgrades_help'] = 'العديد من نشاطات المقرر الدراسي تمكنك من وضع علامات. هذا الإعداد يقرر فيما لو كان للطالب إمكانية معاينة قائمة بكل علاماته في المقرر الدراسي عبر رابط العلامات في قائمة التنقل أو كتلة إدارة المقرر الدراسي';
$string['showingacourses'] = 'يتم إظهار كل المقررات الدراسية وعددها {$a}';
$string['showingxofycourses'] = 'عرض المقررات الدراسية من {$a->start} إلى {$a->end}  من مقررات {$a->total}';
$string['showlistofcourses'] = 'أظهر قائمة المقررات الدراسية';
$string['showmodulecourse'] = 'أظهر قائمة المقررات الدراسية التي تحتوي على النشاط';
$string['showoncoursepage'] = 'الإظهار في صفحة المقرر الدراسي';
$string['showonly'] = 'عرض فقط';
$string['showperpage'] = 'أظهر {$a} في الصفحة الواحدة';
$string['showpopoverwindow'] = 'أظهر النافذة منبثقةً';
$string['showrecent'] = 'اعرض النشاط الحالي';
$string['showreports'] = 'أظهر تقارير النشاط';
$string['showreports_help'] = 'تقارير النشاطِ متوفرة لكُلّ مشارك وهي ستُظهر أنشطة الطلبة في المقرر الدراسي. بالإضافة إلى قوائم بمساهماتِهم، مثل منشوراتهم في المنتدى أَو تسليمهم للواجبات، كما تَتضمّنُ هذه تقاريرِ سجلاتِ الوقوعات. هذا الإعداد يحدد ما إذا كان الطلبة يستطيعون معاينة التقارير الخاصةِ بأنشطتهم عن طريق صفحةِ ملفهم الشخصي.';
$string['showsettings'] = 'عرض الإعدادات';
$string['showtheselogs'] = 'إظهار تلك السجلات';
$string['showthishelpinlanguage'] = 'إعرض هذه المساعدة باللغة: {$a}';
$string['sidepanel'] = 'واجهة جانبية';
$string['signoutofotherservices'] = 'تسجيل خروج شامل';
$string['signoutofotherservices_help'] = 'في حالة الاختيار، سيتم تسجيل خروج شامل من كافة الاجهزة والنظم التي تستخدم خدمات الويب بما في ذلك التطبيقات المحمولة';
$string['since'] = 'منذ';
$string['sincelast'] = 'منذ أخر دخول';
$string['site'] = 'الموقع';
$string['sitedefault'] = 'الوضع الافتراضي للموقع';
$string['sitedefaultspecified'] = 'إفتراضي الموقع ({$a})';
$string['siteerrors'] = 'أخطاء الموقع';
$string['sitefiles'] = 'ملفات الموقع';
$string['sitefilesused'] = 'ملفات الموقع المستخدمة في هذا المقرر';
$string['sitehome'] = 'الصفحة الرئيسية للموقع';
$string['sitelegacyfiles'] = 'ملفات الموقع السابقة';
$string['sitelogs'] = 'سجلات وقوعات الموقع';
$string['sitenews'] = 'إعلانات الموقع';
$string['sitepages'] = 'صفحات الموقع';
$string['sitepartlist'] = 'ليست لديك الصلاحيات المطلوبة لمعاينة قائمة المشتركين';
$string['sitepartlist0'] = 'لمعاينة قائمة المشتركين يجب عليك أن تكون أحد المعلمين في الموقع';
$string['sitepartlist1'] = 'لمعاينة قائمة المشتركين يجب عليك أن تكون أحد المعلمين في الموقع';
$string['sites'] = 'المواقع';
$string['sitesection'] = 'تضمين مقطع الموضوع';
$string['sitesettings'] = 'إعدادات الصفحة الرئيسية';
$string['siteteachers'] = 'معلمين الموقع';
$string['size'] = 'الحجم';
$string['sizeb'] = 'بايت';
$string['sizegb'] = '&nbsp;غيغا بايت';
$string['sizekb'] = '&nbsp;كيلو بايت';
$string['sizemb'] = '&nbsp;ميغا بايت';
$string['sizepb'] = '&nbsp;بيتا بايت';
$string['sizetb'] = '&nbsp;تيرا بايت';
$string['skipped'] = 'تم التخطي';
$string['skiptocategorylisting'] = 'انتقل إلى قوائم التصنيف';
$string['skiptocoursedetails'] = 'تخطى إلى المعلومات المُفصلة للمقرر';
$string['skiptocourselisting'] = 'انتقل إلى قوائم المقرر الدراسي';
$string['skypeid'] = 'مُعرَّف Skype';
$string['socialheadline'] = 'المنتدى الاجتماعي - آخر الموضوعات';
$string['someallowguest'] = 'بعض المقررات الدراسية تسمح بوجود الضيوف';
$string['someerrorswerefound'] = 'بعض المعلومات فُقدت أو غير صحيحة، لذا يرجى النظر تاليه للحصول على مزيد من التفاصيل.';
$string['sort'] = 'فرز';
$string['sortby'] = 'الفرز حسب';
$string['sortbyx'] = 'الترتيب حسب {$a} تصاعدياً';
$string['sortbyxreverse'] = 'الترتيب حسب {$a} تنازلياً';
$string['sorting'] = 'ترتيب';
$string['sourcerole'] = 'دور المصدر';
$string['specifyname'] = 'يجب عليك تحديد اسم';
$string['standard'] = 'قياسي';
$string['starpending'] = '([*]= مقرر ينتظر الموافقة)';
$string['startdate'] = 'تاريخ بدء المقرر الدراسي';
$string['startdate_help'] = 'هذا الإعداد يحدد بداية أول أسبوع للمقرر في التنسيق الأسبوعي، ويحدد أيضاً أبكر تاريخ تتاح فيه سجلات وقوعات النشاطات في المقرر الدراسي. إذا تمت إعادة تعيين المقرر الدراسي وتغيَّر تاريخ بدايته، فكل التواريخ ضمنه سيتم تغييرها نسبة إلى تاريخ بدايته الجديد.';
$string['startingfrom'] = 'ابتداءً من';
$string['startsignup'] = 'إنشاء اشتراك جديد';
$string['state'] = 'ولاية / مقاطعة';
$string['statistics'] = 'الإحصائيات';
$string['statisticsgraph'] = 'رسم بياني إحصائي';
$string['stats'] = 'الإحصائيات';
$string['statslogins'] = 'تسجيلات الدخول';
$string['statsmodedetailed'] = 'عرض (مستخدم) مفصل';
$string['statsmodegeneral'] = 'معاينة عامة';
$string['statsnodata'] = 'لا يوجد بيانات حول هذا المقرر في تلك الفترة الزمنية';
$string['statsnodatauser'] = 'لا يوجد بيانات للمزيج المقرر الدراسي، المستخدم، والفترة الزمنية';
$string['statsoff'] = 'ًالاحصائيات غير مُفعَّلة حاليا';
$string['statsreads'] = 'معاينات';
$string['statsreport1'] = 'تسجيلات الدخول';
$string['statsreport10'] = 'نشاط مستخدم';
$string['statsreport11'] = 'المقررات الدراسية الأكثر نشاطاً';
$string['statsreport12'] = 'المقررات الدراسية الأكثر نشاطاً (موزون)';
$string['statsreport13'] = 'المقررات الدراسية الأكثر من حيث المشاركات (الانضمامات)';
$string['statsreport14'] = 'المقررات الدراسية ذات المساهمات الأكثر (منشورات/معاينات)';
$string['statsreport2'] = 'معاينة (كل الادوار)';
$string['statsreport3'] = 'المنشورات (كل الادوار)';
$string['statsreport4'] = 'كل النشاطات (كل الأدوار)';
$string['statsreport5'] = 'كل النشاطات (معاينات ومشاركات)';
$string['statsreport7'] = 'نشاط المستخدمين (معاينات ومشاركات)';
$string['statsreport8'] = 'كل نشاطات المستخدمين';
$string['statsreport9'] = 'تسجيلات الدخول (مقررات الموقع)';
$string['statsreportactivity'] = 'كل النشاط (كل الادوار)';
$string['statsreportactivitybyrole'] = 'جميع الأنشطة ( معاينات ومشاركات)';
$string['statsreportforuser'] = 'لـ';
$string['statsreportlogins'] = 'دخول';
$string['statsreportreads'] = 'معاينة (كل الادوار)';
$string['statsreporttype'] = 'نوع التقرير';
$string['statsreportwrites'] = 'مشاركات (كل الادوار)';
$string['statsstudentactivity'] = 'نشاط طالب';
$string['statsstudentreads'] = 'معاينة الطالب';
$string['statsstudentwrites'] = 'مشاركات الطالب';
$string['statsteacheractivity'] = 'نشاط معلم';
$string['statsteacherreads'] = 'معاينة معلم';
$string['statsteacherwrites'] = 'مشاركات المعلم';
$string['statstimeperiod'] = 'الفترة الزمنية - آخر:';
$string['statsuniquelogins'] = 'دخول مميز';
$string['statsuseractivity'] = 'جميع الأنشطه';
$string['statsuserlogins'] = 'تسجيلات الدخول';
$string['statsuserreads'] = 'معاينات';
$string['statsuserwrites'] = 'المنشورات';
$string['statswrites'] = 'المنشورات';
$string['status'] = 'الحالة';
$string['statuscritical'] = 'حرِج';
$string['statuserror'] = 'خطأ';
$string['statusinfo'] = 'معلومة';
$string['statusna'] = 'غير متاح';
$string['statusok'] = 'تمام';
$string['statuswarning'] = 'تحذير';
$string['stringsnotset'] = 'لم يتم تعريف الإعدادات التالية في {$a}';
$string['studentnotallowed'] = 'عذرا! لا يمكنك الدخول على هذه المقرر الدراسي بصفة \'{$a}\'';
$string['students'] = 'طلاب';
$string['studentsandteachers'] = 'طلاب ومعلمون';
$string['subcategories'] = 'التصنيفات الفرعية';
$string['subcategory'] = 'التصنيف الفرعي';
$string['subcategoryof'] = 'التصنيف الفرعي لـ  {$a}';
$string['submit'] = 'تسليم';
$string['success'] = 'ناجحة';
$string['successduration'] = 'نجاح ({$a} ثوان)';
$string['summary'] = 'الملخص';
$string['summary_help'] = 'إنّ فكرةَ الملخص هي توفير نَص قصير لتَهْيِئة الطلابِ للأنشطة ضمن الموضوعِ أَو الأسبوعِ. سيظهر نص الملخص في صفحةِ المقرر الدراسي تحت اسمِ المقطع.';
$string['summaryof'] = 'ملخص لـ  {$a}';
$string['supplyinfo'] = 'الرجاء إدخال تفاصيل أكثر';
$string['suspended'] = 'موقوف';
$string['suspendedusers'] = 'المُستخدمون الموقوفون';
$string['switchdevicedefault'] = 'التبديل إلى المظهر القياسي';
$string['switchdevicerecommended'] = 'انتقل إلى السمة الموصى بها والتي تتماشى مع جهازك';
$string['switchrolereturn'] = 'العودة إلى دوري الطبيعي';
$string['switchroleto'] = 'تحويل الدور إلى';
$string['switchroleto_help'] = 'إختر دور المستخدم لتأخذ فكرة عما يشاهده شخص ما بهذا الدور في ذلك المقرر الدراسي.

الرجاء ملاحظة أن هذه المعاينة قد لا تكون مثالية (<a href="https://docs.moodle.org/en/Switch_roles">أنظر التفاصيل والبدائل</a>).';
$string['tag'] = 'علامة';
$string['tagalready'] = 'هذة العلامة موجودة مسبقاً';
$string['tagmanagement'] = 'إضافة/حذف وسوم';
$string['tags'] = 'الوسوم';
$string['targetrole'] = 'الدور المستهدف';
$string['teacheronly'] = 'من أجل {$a} فقط';
$string['teacherroles'] = '{$a} أدوار';
$string['teachers'] = 'معلمون';
$string['textediting'] = 'محرر النصوص';
$string['textediting_help'] = 'إذا تم اختيار  محرر HTML مثل محرر Atto أو محرر TinyMCE، ستحتوي مناطق إدخال النص على شريط أدوات يحتوي على أزرار لإضافة المحتوى بسهولة.

إذا تم اختيار \'منطقة نص عادي\'، فسيكون بالإمكان إختيار التنسيق لمناطق الإدخال النصي مثل HTML أو Markdown.

قائمة برامج تحرير النصوص المتاحة يحددها المشرف على الموقع.';
$string['texteditor'] = 'استخدم نماذج الإنترنت القياسية';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'تنسيق نص عادي';
$string['thanks'] = 'ًشكرا';
$string['theme'] = 'الشكل';
$string['themes'] = 'المظاهر';
$string['themesaved'] = 'تم حفظ الشكل/القالب الجديد';
$string['therearecourses'] = 'توجد {a$} من المقررات الدراسية';
$string['thereareno'] = 'لا يوجد أي {$a} في هذا المقرر';
$string['thiscategory'] = 'هذا التصنيف';
$string['thiscategorycontains'] = 'هذا التصنيف يتضمن';
$string['time'] = 'الوقت';
$string['timecreatedcourse'] = 'تم إنشاء وقت المقرر الدراسي';
$string['timesplitting:deciles'] = 'العُشر الأخير';
$string['timesplitting:deciles_help'] = 'فترة التحليل هذه تقسم المقرر الدراسي إلى أعشار (10 أجزاء متساوية)، بحيث يكون كل تنبؤ مستنداً فقط إلى الجزء السابق منها.';
$string['timesplitting:decilesaccum'] = 'كل الأعشار السابقة';
$string['timesplitting:decilesaccum_help'] = 'فترة التحليل هذه تقسم المقرر الدراسي إلى أعشار (10 أجزاء متساوية)، بحيث يكون كل تنبؤ مستنداً إلى البيانات المجمعة من الأعشار السابقة.';
$string['timesplitting:nosplitting'] = 'لا تحديد للوقت';
$string['timesplitting:nosplitting_help'] = 'لم يتم تعريف فترة التحليل لهذا النموذج.';
$string['timesplitting:onemonthafterstart'] = 'شهر واحد بعد البدء';
$string['timesplitting:onemonthafterstart_help'] = 'فترة التحليل هذه تولد التنبؤ بعد شهر واحد من بدء ما يمكن تحليله.';
$string['timesplitting:oneweekafterstart'] = 'أسبوع واحد بعد البدء';
$string['timesplitting:oneweekafterstart_help'] = 'فترة التحليل هذه تولد التنبؤ بعد أسبوع واحد من بدء ما يمكن تحليله.';
$string['timesplitting:past3days'] = 'الأيام الثلاثة الماضية';
$string['timesplitting:past3days_help'] = 'فترة التحليل هذه تولد التنبؤ كل ثلاثة أيام. حسابات المؤشرات ستكون مبنية على الأيام الثلاثة الماضية.';
$string['timesplitting:pastmonth'] = 'الشهر الماضي';
$string['timesplitting:pastmonth_help'] = 'فترة التحليل هذه تولد التنبؤ كل شهر. حسابات المؤشرات ستكون مبنية على الشهر الماضي.';
$string['timesplitting:pastweek'] = 'الأسبوع الماضي';
$string['timesplitting:pastweek_help'] = 'فترة التحليل هذه تولد التنبؤ كل أسبوع. حسابات المؤشرات ستكون مبنية على الأسبوع الماضي.';
$string['timesplitting:quarters'] = 'ربع السنة الأخير';
$string['timesplitting:quarters_help'] = 'فترة التحليل هذه تقسم المقرر الدراسي إلى أرباع (4 أجزاء متساوية)، بحيث يكون كل تنبؤ مستنداً فقط إلى الربع السابق منها.';
$string['timesplitting:quartersaccum'] = 'كل الأرباع السابقة';
$string['timesplitting:quartersaccum_help'] = 'فترة التحليل هذه تقسم المقرر الدراسي إلى أرباع (4 أجزاء متساوية)، بحيث يكون كل تنبؤ مستنداً إلى البيانات المجمعة من كل الأرباع السابقة.';
$string['timesplitting:singlerange'] = 'من البدء حتى المنتهى';
$string['timesplitting:singlerange_help'] = 'فترة التحليل هذه تعتبر كامل المقرر الدراسي امتداداً واحداً.';
$string['timesplitting:tenpercentafterstart'] = '10% بعد البدء';
$string['timesplitting:tenpercentafterstart_help'] = 'فترة التحليل هذه تولد التنبؤ بعد إكمال ما نسبته 10 بالمئة من المقرر الدراسي.';
$string['timesplitting:upcoming3days'] = 'الأيام الثلاثة القادمة';
$string['timesplitting:upcoming3days_help'] = 'فترة التحليل هذه تولد التنبؤ كل ثلاثة أيام. حسابات المؤشرات ستكون مبنية على الأيام الثلاثة القادمة.';
$string['timesplitting:upcomingfortnight'] = 'الخمسة عشر يوماً القادمة';
$string['timesplitting:upcomingfortnight_help'] = 'فترة التحليل هذه تولد التنبؤ كل خمسة عشر يوماً. حسابات المؤشرات ستكون مبنية على الأيام الخمسة عشر القادمة.';
$string['timesplitting:upcomingweek'] = 'الأسبوع القادم';
$string['timesplitting:upcomingweek_help'] = 'فترة التحليل هذه تولد التنبؤ كل أسبوع. حسابات المؤشرات ستكون مبنية على االأسبوع القادم.';
$string['timezone'] = 'المنطقة الزمنية';
$string['to'] = 'إلى';
$string['tocontent'] = 'إلى العنصر "{$a}"';
$string['tocreatenewaccount'] = 'تخطى لتنشيء حسابًا جديدًا';
$string['today'] = 'اليوم';
$string['todaylogs'] = 'سجلات وقوعات اليوم';
$string['toeveryone'] = 'للجميع';
$string['toggleemojipicker'] = 'تبديل منتقي الرموز التعبيرية';
$string['togglesearch'] = 'تبديل إدخال البحث';
$string['toomanybounces'] = 'ذلك البريد الإلكتروني تسبب في الكثير من الرسائل المعادة <b>يجب</b> تغييره للإستمرار';
$string['toomanytags'] = 'هذا البحث تضمن علامات أكثر من اللازم: سيتم تجاهل بعضها';
$string['toomanytoshow'] = 'عدد المستخدمين يفوق قدرات العرض';
$string['toomanyusersmatchsearch'] = 'عدد كبير من المستخدمين ({$a->count}) يطابق \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'عدد المستخدمين ({$a}) أكثر مما يمكن عرضه';
$string['toonly'] = 'إلى {$a} فقط';
$string['top'] = 'الأعلى';
$string['topic'] = 'موضوع';
$string['topichide'] = 'أخفاء هذا الموضوع من {$a}';
$string['topicoutline'] = 'مخطط الموضوع';
$string['topicshow'] = 'عرض هذا الموضوع إلى {$a}';
$string['toplevelcategory'] = 'التصنيف الأعلى';
$string['total'] = 'مجموع';
$string['totopofsection'] = 'إلى الأعلى من المقطع "{$a}"';
$string['trackforums'] = 'تتبع المنتدى';
$string['trackforumsno'] = 'لا: لا تتعقب المنشورات التي رأيتُها';
$string['trackforumsyes'] = 'نعم: أبرز المنشورات الجديد لي';
$string['trysearching'] = 'حاول البحث';
$string['turneditingoff'] = 'إيقاف التحرير';
$string['turneditingon'] = 'تشغيل التحرير';
$string['unauthorisedlogin'] = 'الحساب المُرتبط بااسم المُستخدم "{$a}" لايتوفر على هذا الموقع';
$string['undecided'] = 'غير مُحدَّد';
$string['unfinished'] = 'لم ينتهي بعد';
$string['unknowncategory'] = 'تصنيف غير معروف';
$string['unknownerror'] = 'خطأ مجهول المصدر';
$string['unknownuser'] = 'مستخدم مجهول';
$string['unlimited'] = 'بلا حدود';
$string['unpacking'] = 'فك الحزمة {$a}';
$string['unsafepassword'] = 'كلمة مرور غير آمنة - جرب أخرى';
$string['untilcomplete'] = 'حتى يكتمل';
$string['unusedaccounts'] = 'الحسابات التي لا تستخدم لأكثر من {$a} يوما يتم إلغاء اشتراكها آليا';
$string['unzip'] = 'فك الضغط';
$string['unzippingbackup'] = 'فك ضغط النسخة الإحتياطية';
$string['up'] = 'أعلى';
$string['update'] = 'تحديث';
$string['updated'] = 'تم تحديث {$a}';
$string['updatemymoodleoff'] = 'التوقف عن تخصيص هذه الصفحة';
$string['updatemymoodleon'] = 'تخصيص هذه الصفحة';
$string['updatemyprofile'] = 'تحديث الملف الشخصي';
$string['updatesevery'] = 'يتم التحديث كل {$a} ثانيه';
$string['updatethis'] = 'حدث هذا {$a}';
$string['updatethiscourse'] = 'حدث هذا المنهج الدراسي';
$string['updatinga'] = 'تحديث {$a}';
$string['updatingain'] = 'تحديث {$a->what}  في {$a->in}';
$string['upload'] = 'الرفع';
$string['uploadafile'] = 'رفع الملف';
$string['uploadcantwrite'] = 'لم يتمكن من كتابة الملفات للقرص';
$string['uploadedfile'] = 'تم رفع الملف بنجاح';
$string['uploadedfileto'] = 'تم تحميل {$a->file} إلى {$a->directory}';
$string['uploadedfiletoobig'] = 'عذرًا، لكن هذا الملف كبير جدًا (حد الحجم هو {$a} بايت)';
$string['uploadextension'] = 'تم إيقاف رفع الملف من قبل أحد إمتدادات PHP';
$string['uploadfailednotrecovering'] = 'لقد فشل تحميل ملفك وذلك لوجود مشكلة في أحد الملفات، {$a->name}. <br /> هناء سجل المشاكل: <br />{$a->problem}<br /> لم يتم حلها.';
$string['uploadfilelog'] = 'سجل وقوعات رفع الملف {$a}';
$string['uploadformlimit'] = 'الملف المرفوع {$a} تجاوز الحد الاعلى للحجم المسموح به في النموذج';
$string['uploadlabel'] = 'العنوان:';
$string['uploadlimitwithsize'] = 'أقصى حد للرفع في {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'رفع ملف جديد';
$string['uploadnofilefound'] = 'لم يعثر على أي ملف، هل تأكدت من اختيارك لملف للقيام بتحمله.';
$string['uploadnotallowed'] = 'رفع الملفات غير مسموح به';
$string['uploadnotempdir'] = 'لا يمكن إيجاد المُجلد المؤقت';
$string['uploadoldfilesdeleted'] = 'تم حذف الملفات القديمة الخاصة بك.';
$string['uploadpartialfile'] = 'تم رفع جزء من الملف فقط';
$string['uploadproblem'] = 'حدت مشكلة غير معروفة خلال رفع الملف \'{$a}\' (ربما حجم الملف كبير جداً؟)';
$string['uploadrenamedchars'] = 'تم تغير مسمى الملف من {$a->oldname} إلى {$a->newname} وذلك لعدم التوافق المسميات.';
$string['uploadrenamedcollision'] = 'تم تغير مسمى الملف من {$a->oldname} إلى {$a->newname} وذلك لوجد تعارض مع اسم الملف.';
$string['uploadserverlimit'] = 'الملف المحمل تجاوز الحد الاعلى للحجم المسموح به من خلال الخادم.';
$string['uploadthisfile'] = 'إرفع هذا الملف';
$string['url'] = 'عنوان الرابط';
$string['used'] = 'مستخدم';
$string['usedinnplaces'] = 'استخدم في {$a}';
$string['user'] = 'مستخدم';
$string['useraccount'] = 'حساب المستخدم';
$string['useractivity'] = 'نشاط';
$string['userconfirmed'] = 'تم تأكيد {$a}';
$string['userdata'] = 'بيانات المستخدم';
$string['userdeleted'] = 'تم حذف اشتراك هذا المستخدم';
$string['userdescription'] = 'الوصف';
$string['userdescription_help'] = 'هذا المربع يتيح لك إدخال بعض المعلومات عنك والتي سيتم عرضها على الآخرين في صفحة حسابك.';
$string['userdetails'] = 'تفاصيل المستخدم';
$string['userfiles'] = 'ملفات المستخدم';
$string['userfilterplaceholder'] = 'إبحث باستعمال كلمة مفتاحية أو إختر مرشحاً';
$string['userlist'] = 'قائمة المستخدمين';
$string['usermenu'] = 'قائمة المُستخدم';
$string['username'] = 'اسم المستخدم';
$string['usernameemail'] = 'اسم المُستخدم/البريد الإلكتروني';
$string['usernameemailmatch'] = 'اسم المستخدم وعنوان البريد الإلكتروني لا ينتميان لنفس المستخدم';
$string['usernameexists'] = 'اسم المستخدم موجود بالفعل، إختر اسماً آخر';
$string['usernamelowercase'] = 'المسوح به هو الحروف الصغيرة  فقط';
$string['usernamenotfound'] = 'لم يتم العثور على اسم المستخدم في قاعدة البيانات';
$string['usernameoremail'] = 'أدخل اسم المستخدم كاملاً أو عنوان البريد الإلكتروني';
$string['usernotconfirmed'] = 'لم يتمكن من تأكيد {$a}';
$string['userpic'] = 'صورة مستخدم';
$string['userpreferences'] = 'خيارات المستخدم';
$string['users'] = 'المستخدمون';
$string['userselectorautoselectunique'] = 'إذا طابق مستخدم واحد فقط معايير البحث، إختره تلقائياً';
$string['userselectorpreserveselected'] = 'أبقِ المستخدمين المحددين، حتى لو لم يعودوا مطابقين لمعايير البحث';
$string['userselectorsearchanywhere'] = 'مطابقة نص البحث في أي مكان من الحقول المعروضة';
$string['usersnew'] = 'المستخدمون الجدد';
$string['usersnoaccesssince'] = 'غير النشطين لإكثر من';
$string['userswithfiles'] = 'مستخدمون لديهم ملفات';
$string['useruploadtype'] = 'نوع تحميل المستخدم: {$a}';
$string['userzones'] = 'نطاق المستخدم';
$string['usetheme'] = 'استعمل المظهر';
$string['usingexistingcourse'] = 'استخدام المقرر الدراسي الموجود';
$string['valuealreadyused'] = 'لقد تم استعمال هذه القيمة مسبقًا.';
$string['version'] = 'الإصدار';
$string['view'] = 'معاينة';
$string['viewallcourses'] = 'عرض كافة المقررات الدراسية';
$string['viewallcoursescategories'] = 'عرض كافة المقررات الدراسية والتصنيفات';
$string['viewallsubcategories'] = 'عرض كافة التصنيفات المنبثقة';
$string['viewfileinpopup'] = 'عرض الملف في قائمة منبثقة';
$string['viewing'] = 'مشاهدة';
$string['viewmore'] = 'شاهد المزيد';
$string['viewprofile'] = 'عرض الحساب';
$string['views'] = 'المعاينات';
$string['viewsolution'] = 'معاينة الحل';
$string['visible'] = 'مرئي';
$string['visible_help'] = 'هذا الخيار يحدد ما إذا كان المقرر ظاهراً ضمن قائمة المقررات الدراسية. باستثناء المعلمين والمشرفين، لن يُسمح للمستخدمين بدخول المقرر.';
$string['visibletostudents'] = 'مرئي لـ {$a}';
$string['warning'] = 'تحذير';
$string['warningdeleteresource'] = 'تحذير: هناك مورد يستخدم {$a}. هل تريد تحديث المورد؟';
$string['webpage'] = 'صفحة الويب';
$string['week'] = 'أسبوع';
$string['weekhide'] = 'أخفاء هذا الأسبوع من {$a}';
$string['weeklyoutline'] = 'مخطط أسبوعي';
$string['weeks'] = 'أسابيع';
$string['weekshow'] = 'عرض هذا الأسبوع لـ {$a}';
$string['welcometocourse'] = 'مرحبا في {$a}';
$string['welcometocoursetext'] = 'مرحبا في {$a->coursename}!

من الأشياء التي يجب أن تفعلها بداية، هي أن تقوم بتعديل صفحة حسابك حتى نعرف المزيد عنك:

 {$a->profileurl}';
$string['whatforlink'] = 'ما الذي تريد فعله بهذا الرابط ؟';
$string['whatforpage'] = 'ما الذي تريد فعله بهذا النص ؟';
$string['whatisyourage'] = 'كم عمرك؟';
$string['whattocallzip'] = 'ماذا تريد تسمية الملف المضغوط؟';
$string['whattodo'] = 'ماذا تريد ان تفعل';
$string['wheredoyoulive'] = 'في أي بلد عشت؟';
$string['whyisthisrequired'] = 'ما لزوم هذا؟';
$string['windowclosing'] = 'هذه النافذة ينبغي أن تُغلق تلقائياً. فإن لم يحدث ذلك، فمن فضلك أغلقها الآن.';
$string['withchosenfiles'] = 'مع الملفات المختارة';
$string['withdisablednote'] = '{$a} (مُعطَّل)';
$string['withoutuserdata'] = 'من غير معلومات المستخدم';
$string['withselectedusers'] = 'مع المستخدمين المحددين...';
$string['withuserdata'] = 'بمعلومات مستخدم';
$string['wordforstudent'] = 'يشار إلى الطالب بكلمة';
$string['wordforstudenteg'] = 'مثلا: الطالب، المشترك، الدارس، إلخ';
$string['wordforstudents'] = 'يشار إلى الطلاب بكلمة';
$string['wordforstudentseg'] = 'مثلا: الطلاب، المشاركون، الدارسون، إلخ';
$string['wordforteacher'] = 'يشار إلى المدرس بكلمة';
$string['wordforteachereg'] = 'مثلا: المدرس، المحاضر، المعلم، إلخ';
$string['wordforteachers'] = 'يشار إلى المعلمين';
$string['wordforteacherseg'] = 'مثلا: المدرسون، المحاضرون، المعلمون، إلخ';
$string['writingblogsinfo'] = 'أكتب معلومات المدونة';
$string['writingcategoriesandquestions'] = 'القيام بكتابة الأصناف والاسئله';
$string['writingcoursedata'] = 'القيام بكتابة معلومات المقرر الدراسي';
$string['writingeventsinfo'] = 'القيام بكتابة معلومات الاحداث';
$string['writinggeneralinfo'] = 'القيام بكتابة المعلومات العامة';
$string['writinggradebookinfo'] = 'كتابة معلومات سجل الدرجات';
$string['writinggroupingsgroupsinfo'] = 'يتم كتابة معلومات تجميع المجموعات';
$string['writinggroupingsinfo'] = 'القيام بكتابة معلومات الشُعب (المجموعات)';
$string['writinggroupsinfo'] = 'القيام بكتابة معلومات مجموعات';
$string['writingheader'] = 'القيام بكتابة راس الصفحة';
$string['writingloginfo'] = 'القيام بكتابة معلومات السجلات';
$string['writingmessagesinfo'] = 'كتابة معلومات الرسائل';
$string['writingmoduleinfo'] = 'القيام بكتابة معلومات الوحدات';
$string['writingscalesinfo'] = 'القيام بكتابة معلومات المقاييس';
$string['writinguserinfo'] = 'القيام بكتابة معلومات المستخدمين';
$string['wrongpassword'] = 'كلمة المرور غير صحيحة بالنسبة لاسم المستخدم';
$string['yahooid'] = 'تعريف Yahoo';
$string['year'] = 'سنة';
$string['years'] = 'سنوات';
$string['yes'] = 'نعم';
$string['youareabouttocreatezip'] = 'أنت تنوى على إنشاء ملف مضغوط يحتوي على';
$string['youaregoingtorestorefrom'] = 'أنت تنوى على بداية عملية استرجاع لى';
$string['youhaveupcomingactivitiesdue'] = 'لديك نشاطات قادمة مستحقة';
$string['youhaveupcomingactivitiesdueinfo'] = 'مرحباً {$a}؛

<br/><br/>لديك نشاطات قادمة مستحقة:';
$string['youneedtoenrol'] = 'للقيام بهذا العمل يجب أن تكون مسجلاً في المقرر الدراسي';
$string['yourlastlogin'] = 'آخر دخول لك كان';
$string['yourself'] = 'أنت نفسك';
$string['yourteacher'] = 'صلته بك {$a}';
$string['yourwordforx'] = 'تسميتك الخاصة لـ \'{$a}\'';
$string['zippingbackup'] = 'ضغط النسخة الاحتياطيه';
