<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'es_mx', version '3.10'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Usted tiene futuras sesiones de Bigbluebuttonbn';
$string['bbbduetimeoverstartingtime'] = 'La hora en que termina esta actividad debe ser posterior a la hora en que empieza';
$string['bbbdurationwarning'] = 'La duración máxima para esta sesión es de  %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sesión está siendo grabada desde el inicio.';
$string['bbbrecordwarning'] = 'Esta sesión se puede grabar.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Agregar una nueva actividad/sala bigbluebuttonbn';
$string['bigbluebuttonbn:join'] = 'Ingresar a una reunión bigbluebuttonbn';
$string['bigbluebuttonbn:managerecordings'] = 'Gestionar grabaciones bigbluebuttonbn';
$string['bigbluebuttonbn:meeting'] = 'Crear instancias con capacidades de reunión en vivo';
$string['bigbluebuttonbn:recording'] = 'Crear instancias con capacidades de grabación';
$string['bigbluebuttonbn:view'] = 'Ver una sala/actividad';
$string['calendarstarts'] = '{$a} está agendado para';
$string['completionattendance'] = 'El estudiante debe asistir a la reunión para:';
$string['completionattendancedesc'] = 'El estudiante debe asistir a la reunión y permanecer en la sesión por al menos {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requerir asistencia';
$string['completionattendancegroup_help'] = 'El asistir a la sesión por (n) minutos es necesario para la finalización';
$string['completionengagementchats'] = 'Eventos del chat';
$string['completionengagementdesc'] = 'Los estudiantes deben participar en actividades durante la reunión';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementgroup'] = 'Requerir participación activa';
$string['completionengagementgroup_help'] = 'La participación activa durante la sesión es necesaria para la finalización';
$string['completionengagementpollvotes'] = 'Encuestar votos';
$string['completionengagementraisehand'] = 'Eventos de levantar mano';
$string['completionengagementtalks'] = 'Eventos de hablar';
$string['completionengagementtalktime'] = 'Tiempo de hablar';
$string['completionupdatestate'] = 'Estado de actualización de finalización';
$string['completionvalidatestate'] = 'Validar finalización';
$string['completionvalidatestatetriggered'] = 'Validar finalización ha sido disparado';
$string['config_clienttype'] = 'Configuración para tipo de "Cliente Web"';
$string['config_clienttype_default'] = 'Tipo de Cliente Web por defecto';
$string['config_clienttype_default_description'] = 'Elegir entre el cliente clásico de Adobe flash o el nuevo de HTML5.';
$string['config_clienttype_description'] = 'Esta configuración habilita/deshabilita la elección del Cliente Web para cada sala.';
$string['config_clienttype_editable'] = 'La elección de Cliente web puede ser editada';
$string['config_clienttype_editable_description'] = 'Esta opción habilita la elección del Cliente Web (AdobeFlash/HTML5) del formato de edición de la sala.';
$string['config_default_messages'] = 'Mensajes predeterminados';
$string['config_default_messages_description'] = 'Configurar mensajes predeterminados para actividades';
$string['config_disablecam_default'] = 'Deshabiilitar cámara habilitado por defecto';
$string['config_disablecam_default_description'] = 'Si se habilita, las cámaras web serán deshabilitadas';
$string['config_disablecam_editable'] = 'Deshabilitar cámaras puede ser editado';
$string['config_disablecam_editable_description'] = 'Deshabilitar cámara por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablemic_default'] = 'Deshabilitar micrófonos habilitado por defecto';
$string['config_disablemic_default_description'] = 'Si se habilita, los micrófonos pueden ser deshabilitados.';
$string['config_disablemic_editable'] = 'Deshabilitar micrófonos puede ser editado';
$string['config_disablemic_editable_description'] = 'Deshabilitar micrófono por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablenote_default'] = 'Deshabilitar anotaciones compartidas por defecto';
$string['config_disablenote_default_description'] = 'Si se habilita, las anotaciones compartidas serán deshabilitadas.';
$string['config_disablenote_editable'] = 'Deshabilitar anotaciones compartidas puede ser editado';
$string['config_disablenote_editable_description'] = 'Deshabilitar anotaciones compartidas por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disableprivatechat_default'] = 'Deshabilitar chat privado habilitado por defecto';
$string['config_disableprivatechat_default_description'] = 'Si se habilita, el chat privado será deshabilitado.';
$string['config_disableprivatechat_editable'] = 'Deshabilitar chat privado puede ser editado';
$string['config_disableprivatechat_editable_description'] = 'Deshabilitar chat privado por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablepublicchat_default'] = 'Deshabilitar chat público habilitado de forma predeterminada';
$string['config_disablepublicchat_default_description'] = 'Si se habilita, el chat público será deshabilitado.';
$string['config_disablepublicchat_editable'] = 'Deshabilitar chat público puede ser editado';
$string['config_disablepublicchat_editable_description'] = 'Deshabilitar chat público por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_experimental_features'] = 'Configuración para características experimentales';
$string['config_experimental_features_description'] = 'Configuración para características experimentales.';
$string['config_extended_capabilities'] = 'Configuración para capacidades externas';
$string['config_extended_capabilities_description'] = 'La configuración para capacidades extendidas cuando el servidor BigBlueButton las ofrece.';
$string['config_general'] = 'Configuración general';
$string['config_general_description'] = 'Estas configuraciones son usadas <b>siempre</b>';
$string['config_hideuserlist_default'] = 'Ocultar lista de usuarios habilitado de forma predeterminada';
$string['config_hideuserlist_default_description'] = 'Si se habilita, la lista de usuarios de la sesión puede ser ocultada.';
$string['config_hideuserlist_editable'] = 'Ocultar lista de usuarios puede ser editado';
$string['config_hideuserlist_editable_description'] = 'Ocultar lista de usuarios por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_importrecordings'] = 'Configuración para característica de "Importar grabaciones"';
$string['config_importrecordings_description'] = 'Estas configuraciones son específicas de la característica';
$string['config_importrecordings_enabled'] = 'Importación de grabaciones habilitada';
$string['config_importrecordings_enabled_description'] = 'Cuando están habilitados esto  y la característica de grabaciones, es posible importar grabaciones desde cursos diferentes hacia una actividad.';
$string['config_importrecordings_from_deleted_enabled'] = 'Impotación de grabaciones desde actividades eliminadas habilitada';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Cuando esta característica y la de importar grabación están habilitadas, es posible importar grabaciones desde actividades que ya no están en el curso.';
$string['config_lockedlayout_default'] = 'Diseño bloqueado habilitado por defecto';
$string['config_lockedlayout_default_description'] = 'Si se habilita, el diseño de la sesión será bloqueado.';
$string['config_lockedlayout_editable'] = 'Diseño bloqueado puede ser editado';
$string['config_lockedlayout_editable_description'] = 'Dideño bloqueado por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_lockonjoin_default'] = 'Ignorar bloqueo al unirse habilitado por defecto';
$string['config_lockonjoin_default_description'] = 'Si se habilita, las configuraciones de bloqueo serán ignoradas. La configuración del bloqueo debe estar habilitada para que esto aplique.';
$string['config_lockonjoin_editable'] = 'Ignorar bloqueo al unirse puede ser editado';
$string['config_lockonjoin_editable_description'] = 'Ignorar bloqueo al unirse por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_lockonjoinconfigurable_default'] = 'Bloquear configuración habilitado por defecto';
$string['config_lockonjoinconfigurable_default_description'] = 'Si se habilita, las configuraciones de bloqueo de sesión pueden ser habilitadas o deshabilitadas desde el control de arriba.';
$string['config_lockonjoinconfigurable_editable'] = 'Bloquear configuración puede ser editado';
$string['config_lockonjoinconfigurable_editable_description'] = 'Bloquear configuración por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_locksettings'] = 'Configuraciones de bloqueo';
$string['config_locksettings_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario al bloquear configuraciones, y también definen valores predeterminados para estas opciones.';
$string['config_meetingevents_enabled'] = 'Registrar eventos en vivo';
$string['config_meetingevents_enabled_description'] = 'Habilitar el plugin para aceptar y procesar eventos en vivo después de que termine la sesión. (Esta característica debe estar habilitada para "Finalización de actividad" y solamente funcionará si el servidor BigBlueButton es capaz de procesar scripts post_events).';
$string['config_muteonstart'] = 'Configuración para característica de "Mudo al iniciar"';
$string['config_muteonstart_default'] = 'Mudo al iniciar habilitado por defecto';
$string['config_muteonstart_default_description'] = 'Si se habilita la sesión será enmudecida al iniciar.';
$string['config_muteonstart_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores predeterminados para estas opciones.';
$string['config_muteonstart_editable'] = 'Mudo al iniciar puede ser editado';
$string['config_muteonstart_editable_description'] = 'Mudo al iniciar por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_participant'] = 'Configuración del participante';
$string['config_participant_description'] = 'Estas configuraciones definen el rol por defecto para participantes en una conferencia.';
$string['config_participant_moderator_default'] = 'Moderador por defecto';
$string['config_participant_moderator_default_description'] = 'Esta regla es usada por defecto cuando es añadida una nueva sala.';
$string['config_presentation_default'] = 'Archivo predeterminado para la característica de "Pre-cargar presentación"';
$string['config_presentation_default_description'] = 'Esta configuración le permite seleccionar un archivo a usar como predeterminado en todas las instancias BBB si está habilitado "Pre-cargar presentación".';
$string['config_preuploadpresentation'] = 'Configuración para característica de "Pre-subir presentación"';
$string['config_preuploadpresentation_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del usuario y también definen valores para estas opciones. Esta característica solamente funciona si el servidor Moodle está accesible para BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Pre-subiendo editable presentación';
$string['config_preuploadpresentation_editable_description'] = 'La característica de pre-subir presentación es editable  en la Interfaz del Usuario cuando la sala o la conferencia es añadida o actualizada.';
$string['config_recording'] = 'Configuración para característica de "Grabar reunión"';
$string['config_recording_all_from_start_default'] = 'Grabar todo desde el principio';
$string['config_recording_all_from_start_default_description'] = 'Si se habilita la reunión grabará para iniciar';
$string['config_recording_all_from_start_editable'] = 'Grabar todo desde el principio puede ser editado';
$string['config_recording_all_from_start_editable_description'] = 'Si se activa la interfaz incluye una opción para la característica de habilitar y deshabilitar la grabación de todo desde el inicio.';
$string['config_recording_default'] = 'Característica de grabación habilitada por defecto';
$string['config_recording_default_description'] = 'Si se habilita, las sesiones creadas en BigBlueButton tendrán capacidades de grabación.';
$string['config_recording_description'] = 'Estas confguraciones son específicas de la característica';
$string['config_recording_editable'] = 'La característica de grabación puede ser editada';
$string['config_recording_editable_description'] = 'Si se selecciona, la interfaz incluye una opción para habilitar y deshabilitar la característica de grabación.';
$string['config_recording_hide_button_default'] = 'Ocultar botón de grabación';
$string['config_recording_hide_button_default_description'] = 'Si se activa el botón para grabar estará oculto';
$string['config_recording_hide_button_editable'] = 'El ocultar botón de grabación puede ser editado';
$string['config_recording_hide_button_editable_description'] = 'Si se activa la interfaz incluye una opción para la habilitar y deshabilitar la característica de ocultar el botón de grabación.';
$string['config_recording_icons_enabled'] = 'Íconos para gestión de grabación';
$string['config_recording_icons_enabled_description'] = 'Cuando se habilita, el panel de gestión de grabación muestra íconos para las acciones de publicar/des-publicar y eliminar.';
$string['config_recordingready_enabled'] = 'Enviar notificaciones cuando la grabación esté lista';
$string['config_recordingready_enabled_description'] = 'Habilitar el plugin para enviar notificaciones cuando la grabación está lista. (solamente funcionará si está habilitado el script post_publish_recording_ready_callback en el servidor BigBlueButton)';
$string['config_recordings'] = 'Configuración para característica de "Mostrar grabaciones"';
$string['config_recordings_deleted_default'] = 'Habilitar por defecto el incluir grabaciones de actividades eliminadas';
$string['config_recordings_deleted_default_description'] = 'Si se habilita, la tabla de grabaciones incluirá las grabaciones pertenecientes a actividades eliminadas (si las hubiera).';
$string['config_recordings_deleted_editable'] = 'Puede ser editada la característica de incluir grabaciones de actividades eliminadas';
$string['config_recordings_deleted_editable_description'] = 'Incluir por defecto grabaciones de actividades eliminadas puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_recordings_description'] = 'Estas configuraciones son específicas de la característica';
$string['config_recordings_general'] = 'Mostrar configuraciones de grabación';
$string['config_recordings_general_description'] = 'Estas configuraciones son usadas solamente al mostrar grabaciones';
$string['config_recordings_html_default'] = 'Interfaz del Usuario como HTML está habilitada por defecto';
$string['config_recordings_html_default_description'] = 'Si se habilita, la tabla de grabaciones es mostrada en HTML simple por defecto.';
$string['config_recordings_html_editable'] = 'Puede ser editada Interfaz del Usuario como característica HTML';
$string['config_recordings_html_editable_description'] = 'Interfaz del Usuario como valor HTML puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_recordings_imported_default'] = 'Mostrar solamente enlaces importados habilitado por defecto';
$string['config_recordings_imported_default_description'] = 'Si se habilita, la tabla de grabación incluirá solamente los enlaces importados a grabaciones.';
$string['config_recordings_imported_editable'] = 'Puede ser editada la característica de mostrar solamente enlaces importados';
$string['config_recordings_imported_editable_description'] = 'Mostrar  por defecto solamente enlaces importados puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_recordings_preview_default'] = 'Vista previa está habilitada por defecto';
$string['config_recordings_preview_default_description'] = 'Si se habilita, la tabla incluye una vista previa de la presentación.';
$string['config_recordings_preview_editable'] = 'La característica de vista previa puede ser editada';
$string['config_recordings_preview_editable_description'] = 'La característica de vista previa puede ser editada cuando la instancia es añadida o actualizada.';
$string['config_recordings_sortorder'] = 'Ordenar las grabaciones en orden ascendente';
$string['config_recordings_sortorder_description'] = 'Por defecto las grabaciones son mostradas en orden descendiente. Cuando se activa serán ordenadas en orden ascendente.';
$string['config_recordings_validate_url'] = 'Validar URL';
$string['config_recordings_validate_url_description'] = 'Si se selecciona, la URL para reproducir será validada antes de que el usuario acceda a ella.';
$string['config_scheduled'] = 'Configuración para "Sesiones agendadas"';
$string['config_scheduled_description'] = 'Estas configuraciones definen algunos de los comportamientos por defecto para las sesiones agendadas.';
$string['config_scheduled_duration_compensation'] = 'Tiempo compensatorio (minutos)';
$string['config_scheduled_duration_compensation_description'] = 'Minutos añadidos al cierre agendado al calcular la duración.';
$string['config_scheduled_duration_enabled'] = 'Calcular duración habilitada';
$string['config_scheduled_duration_enabled_description'] = 'La duración de una sesión agendada es calaculada basándose en las horas de apertura y cierre.';
$string['config_scheduled_pre_opening'] = 'Accesible antes de la hora de apertura (minutos)';
$string['config_scheduled_pre_opening_description'] = 'El tiempo en minutos para que la sesión sea accesible antes de que sea la hora de apertura agendada.';
$string['config_sendnotifications'] = 'Configuración para característica de "Enviar notificaciones"';
$string['config_sendnotifications_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del usuario y también definen valores para estas opciones.';
$string['config_sendnotifications_enabled'] = 'Enviar notificaciones habilitado';
$string['config_sendnotifications_enabled_description'] = 'Si se habilita, la interfaz del usuario para editar la actividad incluye una opción para enviar unanotificación cuando la actividad es añadida o actualizada.';
$string['config_server_url'] = 'URL del servidor BigBlueButton';
$string['config_server_url_description'] = 'La URL de su servidor BigBlueButton debe terminar en  /bigbluebutton/. (Esta URL por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_shared_secret'] = 'Clave secreta de BigBlueButton';
$string['config_shared_secret_description'] = 'La sal de seguridad de su servidor BigBlueButton. (esta sal por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_uidelegation_enabled'] = 'Delegación de Interfaz del Usuario está habilitada';
$string['config_uidelegation_enabled_description'] = 'Estas configuraciones habilitan o deshabilitan la delegación de la Interfaz del Usuario al servidor BigBlueButton.';
$string['config_userlimit'] = 'Configuraciones para característica de "Límite de usuario"';
$string['config_userlimit_default'] = 'Límite de usuario habilitado por defecto';
$string['config_userlimit_default_description'] = 'El número de usuarios permitidos en una sesión por defecto cuando es añadida una sala o conferencia nueva. Si el número se configura a 0, no se establece límite.';
$string['config_userlimit_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores por defecto para estas opciones.';
$string['config_userlimit_editable'] = 'La característica de límite de usuarios puede ser editada';
$string['config_userlimit_editable_description'] = 'El valor del límite de usuarios por defecto puede ser editado cuando la sala o conferencia es añadida o actualizada.';
$string['config_voicebridge'] = 'Configuración para característica de "Puente vocal"';
$string['config_voicebridge_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del usuario y también definen valores por defecto para estas opciones.';
$string['config_voicebridge_editable'] = 'Puente vocal de conferencia puede ser editado';
$string['config_voicebridge_editable_description'] = 'El número de puente de voz de conferencia puede ser asignado permanentemente a una conferencia de sala. Cuando es asignado, el número no puede ser usado por ninguna otra sala o conferencia.';
$string['config_waitformoderator'] = 'Configuración para característica de "Esperar al moderador"';
$string['config_waitformoderator_cache_ttl'] = 'TTL (segundos) de caché de Esperar a moderador';
$string['config_waitformoderator_cache_ttl_description'] = 'Para soportar una carga fuerte de clientes, este plugin hace uso de una caché. Este parámetro define el tiempo que se conservará la caché antes de que la siguiente solicitud sea enviada al servidor BigBlueButton.';
$string['config_waitformoderator_default'] = 'Esperar a un moderador habilitado por defecto';
$string['config_waitformoderator_default_description'] = 'La característica de esperar a un moderador está habilitada por defecto cuando es añadida una nueva sala o conferencia.';
$string['config_waitformoderator_description'] = 'Estas configuraciones son específicas de la característica';
$string['config_waitformoderator_editable'] = 'La característica de esperar a un moderador puede ser editada';
$string['config_waitformoderator_editable_description'] = 'El valor por defecto para esperar a un moderador puede ser editado  cuando es añadida o actualizada la sala o conferencia.';
$string['config_waitformoderator_ping_interval'] = 'Ping (segundos) de esperar al moderador';
$string['config_waitformoderator_ping_interval_description'] = 'Cuando está habilitada la característica de esperar a un moderador, el cliente ejecuta (https://es.wikipedia.org/wiki/Ping pings ) para el estatus de la sesión cada cierto [número] de segundos. Este parámetro define el intervalo para que se hagan solicitudes al servidor Moodle.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN está haciendo uso de config.php con una variable global que ha quedado en desuso. Por favor convierta el archivo, ya que no será soportado en versiones futuras';
$string['config_warning_curl_not_installed'] = 'Esta función requiere que la extensión CURL para php  se encuentre instalada y habilitada. La configuración de estos parameteros será posible solo si esta condición se cumple.';
$string['config_welcome_default'] = 'Mensaje predeterminado de BienVenida';
$string['config_welcome_default_description'] = 'Remplaza el mensaje predeterminado configurado para el servidor BigBlueButton. El mensaje puede incluir las palabras clave  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) que serán sustituidas automáticamentey, y también etiquetas HTML como <b>...</b> or <i></i>';
$string['config_welcome_editable'] = 'El mensaje de BienVenida es editable por profesores';
$string['config_welcome_editable_description'] = 'El mensaje de BienVenida puede ser editado cuando la instancia es añadida o actualizada';
$string['email_body_notification_meeting_by'] = 'por';
$string['email_body_notification_meeting_description'] = 'Descripción';
$string['email_body_notification_meeting_details'] = 'Detalles';
$string['email_body_notification_meeting_end_date'] = 'Fecha de Fin';
$string['email_body_notification_meeting_has_been'] = 'ha sido';
$string['email_body_notification_meeting_start_date'] = 'Fecha de Inicio';
$string['email_body_notification_meeting_title'] = 'Título';
$string['email_body_recording_ready_for'] = 'Grabación de';
$string['email_body_recording_ready_is_ready'] = 'está lista';
$string['email_footer_sent_by'] = 'Este mensaje automático de notificación fue enviado por';
$string['email_footer_sent_from'] = 'desde el curso';
$string['ends_at'] = 'Termina';
$string['event_activity_created'] = 'Actividad creada';
$string['event_activity_deleted'] = 'Actividad eliminada';
$string['event_activity_updated'] = 'Actividad actualizada';
$string['event_activity_viewed'] = 'Actividad visualizada';
$string['event_live_session'] = 'Evento de sesión en vivo';
$string['event_meeting_created'] = 'Reunión creada';
$string['event_meeting_ended'] = 'Se ha finalizado la sesión de forma forzada';
$string['event_meeting_joined'] = 'Ingreso a reunión';
$string['event_meeting_left'] = 'Salida de reunión';
$string['event_recording_deleted'] = 'Grabación eliminada';
$string['event_recording_edited'] = 'Grabación editada';
$string['event_recording_imported'] = 'Grabación importada';
$string['event_recording_protected'] = 'Grabación protegida';
$string['event_recording_published'] = 'Grabación publicada';
$string['event_recording_unprotected'] = 'Grabación desprotegida';
$string['event_recording_unpublished'] = 'Grabación oculta';
$string['event_recording_viewed'] = 'Grabación vista';
$string['general_error_not_allowed_to_create_instances'] = 'El usuario no tiene permitido el crear cualquier tipo de instancias.';
$string['general_error_unable_connect'] = 'No se pudo conectar. Por favor verifique la URL del servidor BigBlueButtton y que el servidor BigBlueButton esté operando.';
$string['index_confirm_end'] = '¿Quiere entrar a la clase virtual?';
$string['index_disabled'] = 'deshabilitada';
$string['index_enabled'] = 'habilitada';
$string['index_ending'] = 'Terminando el salón de la clase virtual... por favor espere';
$string['index_error_bbtn'] = 'ID de BigBlueButton {$a} es incorrecta';
$string['index_error_checksum'] = 'Hubo un error de la suma de comprobación. Asegúrese de haber ingresado la sal correcta.';
$string['index_error_forciblyended'] = 'No se pudo ingresar a esta sesión debido a que fue terminada manualmente.';
$string['index_error_noinstances'] = 'No hay instancias de bigbluebutton';
$string['index_error_unable_display'] = 'No se pueden mostrar las sessiones. Por favor revise la URL del servidor BigBlueButtton  y que el servidor BigBlueButton esté operando.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Acciones';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Grabación';
$string['index_heading_users'] = 'Usuarios';
$string['index_heading_viewer'] = 'Observadores';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitival alcanzada por el estudiante en una actividad BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad BigBlueButton.';
$string['instance_type_default'] = 'Sala/Actividad con grabaciones';
$string['instance_type_recording_only'] = 'Grabaciones solamente';
$string['instance_type_room_only'] = 'Sala/Actividad solamente';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_clienttype'] = 'Tecnología Cliente Web';
$string['mod_form_block_clienttype_flash'] = 'Cliente basado en tecnología Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Cliente basado en tecnología HTML5';
$string['mod_form_block_general'] = 'Configuraciones generales';
$string['mod_form_block_participants'] = 'Rol asigado durante sesión en vivo';
$string['mod_form_block_presentation'] = 'Contenido de la Presentación';
$string['mod_form_block_presentation_default'] = 'Contenido predeterminado de presentación';
$string['mod_form_block_record'] = 'Configuraciones de grabación';
$string['mod_form_block_recordings'] = 'Vista para Grabación';
$string['mod_form_block_room'] = 'Configuraciones de Actividad/Sala';
$string['mod_form_block_schedule'] = 'Agenda para sesión';
$string['mod_form_field_block_clienttype'] = 'Tecnología del Cliente Web';
$string['mod_form_field_closingtime'] = 'Accesso cerrado';
$string['mod_form_field_conference_name'] = 'Nombre de Conferencia';
$string['mod_form_field_disablecam'] = 'Deshabilitar cámaras web';
$string['mod_form_field_disablemic'] = 'Deshabilitar micrófonos';
$string['mod_form_field_disablenote'] = 'Deshabilitar anotaciones compartidas';
$string['mod_form_field_disableprivatechat'] = 'Deshabilitar chat privado';
$string['mod_form_field_disablepublicchat'] = 'Deshabilitar chat público';
$string['mod_form_field_duration'] = 'Duración';
$string['mod_form_field_duration_help'] = 'Fijar la duración para una sesión establecerá el tiempo máximo para mantener activa una sesión antes de que termine la grabación';
$string['mod_form_field_hideuserlist'] = 'Ocultar lista de usuarios';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instancia';
$string['mod_form_field_instanceprofiles_help'] = 'Seleccionar el tipo para la instancia de BigBlueButton.';
$string['mod_form_field_intro'] = 'Descripción';
$string['mod_form_field_intro_help'] = 'Una breve descripción de la sala o conferencia';
$string['mod_form_field_lockedlayout'] = 'Bloquear diseño de la sala';
$string['mod_form_field_lockonjoin'] = 'Ignorar configuraciones de bloqueo';
$string['mod_form_field_lockonjoinconfigurable'] = 'Permitir ignorar configuraciones de bloqueo';
$string['mod_form_field_muteonstart'] = 'Mudo al iniciar';
$string['mod_form_field_name'] = 'Nombre de salón de clase virtual';
$string['mod_form_field_nosettings'] = 'No pueden editarse configuraciones';
$string['mod_form_field_notification'] = 'Notificar este cambio a usuarios inscritos';
$string['mod_form_field_notification_created_help'] = 'Enviarles una notificación a todos los usuarios inscritos para hacerles saber que esta actividad ha sido creada';
$string['mod_form_field_notification_help'] = 'Enviarles una notificación a los usuarios inscritos para hacerles saber que esta actividad ha sido añadida o actualizada';
$string['mod_form_field_notification_modified_help'] = 'Enviarles una notificación a los usuarios inscritos para hacerles saber que esta actividad ha sido actualizada';
$string['mod_form_field_notification_msg_at'] = 'en';
$string['mod_form_field_notification_msg_created'] = 'añadida';
$string['mod_form_field_notification_msg_modified'] = 'actualizada';
$string['mod_form_field_openingtime'] = 'Acceso abierto';
$string['mod_form_field_participant_add'] = 'Añadir asignación';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Observador';
$string['mod_form_field_participant_list'] = 'Lista de asignación';
$string['mod_form_field_participant_list_action_add'] = 'Agregar';
$string['mod_form_field_participant_list_action_remove'] = 'Eliminar';
$string['mod_form_field_participant_list_text_as'] = 'se une a la sesión como';
$string['mod_form_field_participant_list_type_all'] = 'Todos los usuarios inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Propietario';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Usuario';
$string['mod_form_field_record'] = 'La sesión puede grabarse';
$string['mod_form_field_recordallfromstart'] = 'Grabar todo desde el principio';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botón de grabar';
$string['mod_form_field_recordings_deleted'] = 'Incluir grabaciones de actividades eliminadas';
$string['mod_form_field_recordings_html'] = 'Mostrar la tabla en HTML simple';
$string['mod_form_field_recordings_imported'] = 'Mostrar solamente enlaces importados';
$string['mod_form_field_recordings_preview'] = 'Mostrar vista previa de grabación';
$string['mod_form_field_room_name'] = 'Nombre de la sala';
$string['mod_form_field_userlimit'] = 'Límite de usuarios';
$string['mod_form_field_userlimit_help'] = 'Número máximo de usuarios permitidos en una reunión. Si el límite se configura a 0 el número de usuarios será ilimitado.';
$string['mod_form_field_voicebridge'] = 'Puente de voz [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Error de formato. Debe de ingresar un número entre 1 y 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número de la conferencia que los participantes pueden teclear para unirse a la conferencia de voz usando marcación. Debe escribirse un número entre 1 y 9999. Si el valor fuera 0 el número de puente-de-voz estático (static voicebridge) será ignorado y se generará un número aleatorio por BigBlueButton. Un número 7 precederá a los cuatro dígitos tecleados';
$string['mod_form_field_voicebridge_notunique_error'] = 'No es un valor único. Este número está siendo usado por otra sala o conferencia.';
$string['mod_form_field_wait'] = 'Esperar al moderaror';
$string['mod_form_field_wait_help'] = 'Los espectadores deben de esperar hasta que un moderador ingrese a la sesión antes de que ellos puedan hacer lo mismo';
$string['mod_form_field_welcome'] = 'Mensaje de bienvenida';
$string['mod_form_field_welcome_default'] = '¡<br>Bienvenido a  <b>%%CONFNAME%%</b>!<br><br>Para ayuda sobre el uso de BigBlueButton vea estos cortos <a href="event:http://www.bigbluebutton.org/content/videos"><u>tutorial videos</u></a>.<br><br>Para unir el puente de audio elija el ícono del teléfono (superior central). <b>Por favor use audífonos para evitar causarles ruidos de fondo a los demás.</b>';
$string['mod_form_field_welcome_help'] = 'Remplace el mensaje predeterminado puesto por el servidor BigBlueButton. El mensaje puede incluir las siguientes palabras clave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) que serán sustituidas automáticamente, y también marcas HTML tales como  &lt;b>...&lt;/b>, &lt;br />, &lt;u>&lt;/u> or &lt;i>&lt;/i>';
$string['mod_form_locksettings'] = 'Configuraciones de bloqueo';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton le permite crear dentro de Moodle enlaces hacia aulas en línea en tiempo real con salas que emplean BigBlueButton, un sistema de código abierto para conferencias web para la educación a distancia.

Usando BigBlueButton usted puede especificar el título, descripción, fecha del calendario (que le proporciona un rango de fechas para unirse a la sesión), grupos, y detalles acerca de la grabación de la sesión en línea.';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Administración de BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para crear y unirse a sesiones BigBlueButton, necesitan intercambiarse datos del usuario con el servidor.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'El nombre completo del usuario que accede al servidor BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'La userid del usuario que accede al servidor BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Almacena la configuración para la sala o actividad que define las características y el comportamiento general de la sesión BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Una lista de reglas que definen el rol con el que vivirán los usuarios en el evento en vivo. Una ID del usuario puede ser almacenada, ya que los permisos pueden ser otorgados por rol o por usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Almacena eventos disparados al usar el plugin.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'El tipo de evento disparado por el usuario';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'La ID de la reunión a la que tuvo acceso el usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Puede incluir información extra relacionada con la reunión o la grabación afectada por el evento.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'La hora a la cual fue creada la bitácora.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'La ID del usuario que disparó el evento.';
$string['removedevents'] = 'Eventos eliminados';
$string['removedlogs'] = 'Bitácoras personalizadas eliminadas';
$string['removedrecordings'] = 'Grabaciones eliminadas';
$string['removedtags'] = 'Marcas eliminadas';
$string['resetevents'] = 'Eliminar eventos';
$string['resetlogs'] = 'Eliminar bitácoras personalizadas';
$string['resetlogs_help'] = 'Eliminar las bitácoras causara la pérdida de referencias a grabaciones';
$string['resetrecordings'] = 'Eliminar grabaciones';
$string['resetrecordings_help'] = 'Eliminar las grabaciones las hará inaccesibles desde cualquier lugar y no puede deshacerse';
$string['resettags'] = 'Eliminar marcas';
$string['search:activity'] = 'BigBlueButton - información de actividad';
$string['search:tags'] = 'BigBlueButton - información de marcas';
$string['sendnotification'] = 'Enviar notificación';
$string['started_at'] = 'Inició';
$string['starts_at'] = 'inicia';
$string['view_conference_action_end'] = 'Final de sesión';
$string['view_conference_action_join'] = 'Ingresar a sesión';
$string['view_error_action_not_completed'] = 'La acción no pudo ser completada';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondió con errores. {$a}';
$string['view_error_create'] = 'El servidor BigBlueButton ha respondido con un mensaje de error, la sesión no pudo ser creada.';
$string['view_error_current_state_not_found'] = 'El estado actual no fue encontrado. La grabación podría haber sido eliminada o podría ser que el servidor BigBlueButton no sea compatible con la acción realizada.';
$string['view_error_import_no_courses'] = 'No hay cursos para buscarles grabaciones';
$string['view_error_import_no_recordings'] = 'No hay grabaciones para importar en este curso.';
$string['view_error_invalid_session'] = 'La sesión ha caducado. Regresar a la página principal de la actividad.';
$string['view_error_max_concurrent'] = 'El máximo número de reuniones concurrentes permitido ha sido alcanzado.';
$string['view_error_meeting_not_running'] = 'Algo salió mal; la reunión no está corriendo.';
$string['view_error_no_group'] = 'Todavía no hay grupos configurados. Por favor haga los grupos antes de intentar unirse a la reunión.';
$string['view_error_no_group_student'] = 'Usted todavía no se ha inscrito a un grupo. Por favor póngase en contacto con su Profesor o el Administrador.';
$string['view_error_no_group_teacher'] = 'Todavía no se han configurado grupos. Por favor haga los grupos o póngase en contacto con el Administrador.';
$string['view_error_unable_join'] = 'No se pudo conectar al servidor BigBlueButton. Por favor revise la URL del servidor BigBlueButton y revise que el servidor BigBlueButton esté operando.';
$string['view_error_unable_join_student'] = 'No se pudo conectar al servidor BigBlueButton. Por favor póngase en contacto con su Profesor o Administrador.';
$string['view_error_unable_join_teacher'] = 'No se pudo conectar al servidor BigBlueButton. Por favor póngase en contacto con el Administrador.';
$string['view_error_url_missing_parameters'] = 'Hay parámetros que faltan en esta URL';
$string['view_error_userlimit_reached'] = 'El número de usuarios permitidos en una reunión ha sido alcanzado';
$string['view_groups_nogroups_warning'] = 'La sala fue configurada para usar grupos, pero el curso no tiene grupos definidos.';
$string['view_groups_notenrolled_warning'] = 'La sala fue configurada para usar grupos, pero Usted no está inscrito en ninguno de ellos.';
$string['view_groups_selection'] = 'Seleccione el grupo al que quiere unirse y confirme la acción.';
$string['view_groups_selection_join'] = 'Ingresar';
$string['view_groups_selection_warning'] = 'Hay una sala de conferencia para cada grupo y Usted tiene acceso a más de una. Asegúrese de seleccionar la sala correcta.';
$string['view_login_moderator'] = 'Ingresar como moderador...';
$string['view_login_viewer'] = 'Ingresar como observador...';
$string['view_message_and'] = 'y';
$string['view_message_conference_has_ended'] = 'Esta conferencia ha terminado.';
$string['view_message_conference_in_progress'] = 'Esta conferencia está en progreso';
$string['view_message_conference_not_started'] = 'Esta conferencia todavía no ha empezado.';
$string['view_message_conference_room_ready'] = 'Esta sala de conferencia está lista . Puede ingresar a la sesión en este instante.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando a que se una un moderador.';
$string['view_message_finished'] = 'Esta actividad se acabó';
$string['view_message_has_joined'] = 'se ha unido';
$string['view_message_have_joined'] = 'se han unido';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'La característica de importar enlaces de grabaciones está deshabilitada en este servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'No hay grabaciones para mostrar.';
$string['view_message_notavailableyet'] = 'Esta sesión todavía no está disponible.';
$string['view_message_recordings_disabled'] = 'Las grabaciones fueron deshabilitadas en este servidor. Las instancias BigBlueButton solamente  para grabaciones no pueden ser usadas .';
$string['view_message_room_closed'] = 'Esta sala está cerrada.';
$string['view_message_room_open'] = 'Esta sala está abierta.';
$string['view_message_room_ready'] = 'Esta sala está lista.';
$string['view_message_session_for'] = 'la sesión para';
$string['view_message_session_has_user'] = 'Hay';
$string['view_message_session_has_users'] = 'Hay';
$string['view_message_session_no_users'] = 'No hay usuarios en esta sesión';
$string['view_message_session_running_for'] = 'Esta sesión ha estado activa por';
$string['view_message_session_started_at'] = 'Esta sesión inició a las';
$string['view_message_tab_close'] = 'Esta pestaña/ventana debe cerrarse manualmente';
$string['view_message_times'] = 'veces';
$string['view_message_user'] = 'usuario';
$string['view_message_users'] = 'usuarios';
$string['view_message_viewer'] = 'espectador';
$string['view_message_viewers'] = 'espectadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instancia está posibilitada para trabajar en grupos pero la App mobile no tiene apoyo para esto. Por favor ábrala en un equipo (computadora) de escritorio si desea usar el apoyo para grupos.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Usted excedió 45 segundos en esta página, por favor vuelva a cargar la página para unirse correctamente a ala reunión.';
$string['view_noguests'] = 'El módulo BigBlueButton no está abierto para invitados';
$string['view_nojoin'] = 'Usted no tiene un rol que le permita unirse a esta sesión.';
$string['view_recording'] = 'grabación';
$string['view_recording_actionbar'] = 'Barra de herramientas';
$string['view_recording_activity'] = 'Actividad';
$string['view_recording_button_import'] = 'Importar enlaces de grabación';
$string['view_recording_button_return'] = 'Regresar';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'fecha';
$string['view_recording_delete_confirmation'] = '¿Está seguro de eliminar esta  {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación es eliminada, esos enlaces también serán eliminados';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace que fue importado en un diferente curso o actividad. Si la grabación es eliminada, ese enlace también será eliminado';
$string['view_recording_description'] = 'Descripción';
$string['view_recording_duration'] = 'Duración';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'La URL para este formato de grabación es inalcanzable.';
$string['view_recording_format_notes'] = 'Notas';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentación';
$string['view_recording_format_screenshare'] = 'Screenshare';
$string['view_recording_format_statistics'] = 'Estadísticas';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = '¿Está Usted seguro de importar esta grabación?';
$string['view_recording_length'] = 'Tiempo';
$string['view_recording_link_warning'] = 'Este es un enlace que apunta hacia una grabación que fue creada en un curso o una actividad diferente';
$string['view_recording_list_action_delete'] = 'Eliminando';
$string['view_recording_list_action_edit'] = 'Actualizando';
$string['view_recording_list_action_play'] = 'Reproducir';
$string['view_recording_list_action_process'] = 'Procesando';
$string['view_recording_list_action_protect'] = 'Protegiendo';
$string['view_recording_list_action_publish'] = 'Publicando';
$string['view_recording_list_action_unprotect'] = 'Des-protegiendo';
$string['view_recording_list_action_unpublish'] = 'Des-publicando';
$string['view_recording_list_action_update'] = 'Actualizando';
$string['view_recording_list_actionbar'] = 'Barra de Herramientas';
$string['view_recording_list_actionbar_delete'] = 'Eliminar';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Hacerla privada';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unprotect'] = 'Hacerla pública';
$string['view_recording_list_actionbar_unpublish'] = 'Ocultar';
$string['view_recording_list_activity'] = 'Actividad';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Fecha';
$string['view_recording_list_description'] = 'Descripción';
$string['view_recording_list_duration'] = 'Duración';
$string['view_recording_list_recording'] = 'Grabando';
$string['view_recording_meeting'] = 'Reunión';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Configurar valores para grabación';
$string['view_recording_name'] = 'Nombre';
$string['view_recording_playback'] = 'Reproducir';
$string['view_recording_preview'] = 'Vista previa';
$string['view_recording_preview_help'] = 'Pasar ratón sobre de una imagen para verla a tamaño completo';
$string['view_recording_publish_link_deleted'] = 'Este enlacee no puede ser re-publicado porque la grabación misma no existe en el servidor BigBlueButton actual. El enlace debería de ser eliminado.';
$string['view_recording_publish_link_not_published'] = 'Este enlace no puede ser re-publicado porque la grabación misma está des-publicada';
$string['view_recording_recording'] = 'Grabación';
$string['view_recording_tags'] = 'Marcas';
$string['view_recording_unprotect_link_deleted'] = 'Este enlace no puede ser des-protegido porque la grabación misma no existe en el servidor BigBlueButton actual. El enlace debería de ser eliminado.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Este enlace no puede ser des-protegido porque la grabación misma está protegida';
$string['view_recording_unpublish_confirmation'] = '¿Está seguro de des-publicar esta {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación es des-publicada, esos enlaces también serán des-publicados';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que fue importado en un diferente cursos o actividad. Si la grabación es des-publicada, ese enlace también será des-publicado';
$string['view_recording_yui_first'] = 'Primero';
$string['view_recording_yui_go'] = 'Ir';
$string['view_recording_yui_last'] = 'Último';
$string['view_recording_yui_next'] = 'Siguiente';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Filas';
$string['view_recording_yui_show_all'] = 'Mostrar todo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Archivo de presentación';
$string['view_section_title_recordings'] = 'Grabaciones';
$string['view_warning_default_server'] = 'Este servidor Moodle está haciendo uso del servidor de pruebas de BigBlueButton que viene pre-configurado por defecto. Debería de ser remplazado para sitios en producción.';
