<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'cs', version '3.10'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Přidat požadavek';
$string['after10min'] = 'Po 10 minutách od začátku akce';
$string['after12h'] = 'Po 12 hodinách od začátku akce';
$string['after1d'] = 'Po 1 dnu od začátku akce';
$string['after1h'] = 'Po 1 hodině od začátku akce';
$string['after1w'] = 'Po 1 týdnu od začátku akce';
$string['after2d'] = 'Po 2 dnech od zahájení akce';
$string['after2h'] = 'Po 2 hodinách od začátku akce';
$string['after2w'] = 'Po 2 týdnech od zahájení akce';
$string['after30min'] = 'Po 30 minutách od začátku akce';
$string['after3w'] = 'Po 3 týdnech od zahájení akce';
$string['after4h'] = 'Po 4 hodinách od začátku akce';
$string['after4w'] = 'Po 4 týdnech od zahájení akce';
$string['after5min'] = 'Po 5 minutách od začátku akce';
$string['after6h'] = 'Po 6 hodinách od začátku akce';
$string['alreadybooked'] = 'Již jste rezervováni';
$string['alreadyoverbooked'] = 'Již jste v pořadníku';
$string['atstart'] = 'Na začátku akce';
$string['autohide'] = 'Seznam rezervací se automaticky skryje';
$string['availablerequests'] = 'Volná místa';
$string['by'] = 'podle';
$string['bydate'] = 'Datum události';
$string['byname'] = 'Jméno';
$string['bysection'] = 'Téma/týden';
$string['cancelledon'] = 'Zrušeno';
$string['cancellersmail'] = 'Jste zrušeni od \'{$a->reservation}\'. rezervace';
$string['cancellersmailhtml'] = 'Jste zrušeni od <em>{$a->reservation}</em>. rezervace';
$string['clashesreport'] = 'Přehled kolizí';
$string['cleanview'] = 'Zobrazit pouze aktuální rezervované';
$string['close'] = 'zavřít';
$string['closed'] = 'Zavřeno';
$string['config'] = 'Nastavení rezervace';
$string['configautohide'] = 'To definuje, kdy musí být rezervace skryty ze seznamu rezervací (mod/reservation/index.php). To by mohlo být užitečné, pokud se použije s veřejnými seznamy, aby se zobrazil vyčištěný seznam.';
$string['configlocations'] = 'Spravujte standardní umístění pro rezervace na tomto webu';
$string['configmanualusers'] = 'To definuje, jaký seznam uživatelů se zobrazí v rozevírací nabídce sloužící k ruční rezervaci uživatelů.';
$string['configmaxoverbook'] = 'To definuje maximální procento nadměrné rezervace u rezervací.';
$string['configmaxrequests'] = 'Definujte limit rozevírací nabídky na stránce úprav rezervace';
$string['confignotifies'] = 'Toto nastavení definuje, která upozornění musí být odeslána';
$string['configoverbookstep'] = 'To definuje procentuální zrnitost nadměrné rezervace. Menší krok, větší zrnitost';
$string['configpubliclists'] = 'Toto definuje, zda jsou seznamy rezervací veřejné (prohlížené bez přihlášení) nebo ne.';
$string['configsortby'] = 'To definuje, jak je seřazen seznam rezervací.';
$string['configsublimits'] = 'Definujte počet řádků pravidel sublimitů na stránce úprav rezervace';
$string['connectedto'] = 'Rezervace připojena k';
$string['description'] = 'Popis';
$string['downloadas'] = 'Výchozí formát pro stažení';
$string['duration10h'] = '10 hodin';
$string['duration10min'] = '10 minut';
$string['duration11h'] = '11 hodin';
$string['duration12h'] = '12 hodin';
$string['duration15min'] = '15 minut';
$string['duration20min'] = '20 minut';
$string['duration2h'] = '2 hodiny';
$string['duration30min'] = '30 minut';
$string['duration3h'] = '3 hodiny';
$string['duration45min'] = '45 minut';
$string['duration4h'] = '4 hodiny';
$string['duration5h'] = '5 hodin';
$string['duration5min'] = '5 minut';
$string['duration60min'] = '60 minut';
$string['duration6h'] = '6 hodin';
$string['duration7h'] = '7 hodin';
$string['duration8h'] = '8 hodin';
$string['duration90min'] = '90 minut';
$string['duration9h'] = '9 hodin';
$string['enablenote'] = 'Povolit poznámku uživatelů';
$string['equal'] = 'rovná se';
$string['err_sublimitsgreater'] = 'Součet sublimitů je větší než maximální povolený požadavek';
$string['err_timeendlower'] = 'Datum ukončení události je stanoveno před datem zahájení';
$string['err_timeopengreater'] = 'Datum zahájení rezervace je nastaveno po datu ukončení';
$string['eventsettings'] = 'Nastavení události';
$string['explainconfig'] = 'Správci zde mohou definovat globální nastavení rezervačního modulu';
$string['fields'] = 'Zobrazená pole';
$string['fullview'] = 'Zobrazit také smazané rezervace';
$string['gradedmail'] = '{$a->teacher} zveřejnil zpětnou vazbu k vašemu
rezervace \'{$a->reservation}\'

Můžete to vidět zde:

    {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} zveřejnil zpětnou vazbu k vašemu
rezervace \'<i>{$a->reservation}</i>\'<br /><br />
Můžeš to vidět <a href=\\"{$a->url}\\">here</a>.';
$string['justbooked'] = 'Jste rezervováni jako: {$a}';
$string['justoverbooked'] = 'Jste rezervovaní jako: {$a}';
$string['linenumber'] = '#';
$string['location'] = 'Místo';
$string['locations'] = 'Správa míst';
$string['locationslist'] = 'Seznam lokalit';
$string['mail'] = 'Rezervace \'{$a->reservation}\' byla zavřena.

Seznam rezervací si můžete stáhnout z:

    {$a->url}';
$string['manage'] = 'Spravovat';
$string['manualusers'] = 'Ruční rezerva ukázat uživatelům';
$string['maxoverbook'] = 'Max procento nadměrné rezervace';
$string['maxrequest'] = 'Max. počet rezervací';
$string['modulename'] = 'Rezervace';
$string['modulenameplural'] = 'Rezervace';
$string['newlocation'] = 'Nové umístění';
$string['nolimit'] = 'Žádný limit rezervace';
$string['nomorerequest'] = 'Už nejsou k dispozici žádná místa';
$string['nooverbook'] = 'Žádná nadměrná rezervace';
$string['noparent'] = 'None';
$string['noreservations'] = 'Žádná rezervace k zobrazení';
$string['note'] = 'Poznámka';
$string['noteachers'] = 'Žádní dostupní učitelé';
$string['notequal'] = 'nerovná se';
$string['noterequired'] = 'Vyžaduje se poznámka, před rezervací prosím zadejte zde.';
$string['notgraded'] = 'Neznámkovaný';
$string['notopened'] = 'Není otevřeno';
$string['notreserved'] = 'Není vyhrazeno';
$string['novalues'] = 'Pro toto pole nejsou k dispozici žádné hodnoty';
$string['number'] = 'Číslo rezervace';
$string['optional'] = 'Volitelný';
$string['otherlocation'] = 'Zadat jiné umístění';
$string['overbook'] = 'Nadměrná rezervace';
$string['overbookonly'] = 'K dispozici jsou pouze místa k rezervaci';
$string['overbookstep'] = 'Krok nadměrné rezervace';
$string['overview'] = 'Přehled';
$string['pluginadministration'] = 'Správa rezervací';
$string['pluginname'] = 'Reservace';
$string['requestoverview'] = 'Přehled požadavků';
$string['requests'] = 'Žádosti';
$string['required'] = 'Požadované';
$string['reservation:addinstance'] = 'Přidat novou rezervaci';
$string['reservation:downloadrequests'] = 'Může stáhnout seznam požadavků';
$string['reservation:grade'] = 'Může přiřadit známku';
$string['reservation:manage'] = 'Může spravovat rezervaci';
$string['reservation:manualdelete'] = 'Může mazat požadavky ostatních uživatelů';
$string['reservation:manualreserve'] = 'Může odeslat požadavek pro ostatní uživatele';
$string['reservation:reserve'] = 'Může podávat vlastní žádosti';
$string['reservation:uploadreservations'] = 'Může nahrávat rezervace';
$string['reservation:view'] = 'Může zobrazit rezervaci';
$string['reservation:viewnote'] = 'Může zobrazit poznámku s požadavky';
$string['reservation:viewrequest'] = 'Může zobrazit seznam požadavků';
$string['reservationcancelled'] = 'Rezervace zrušena';
$string['reservationclosed'] = 'Rezervace uzavřena';
$string['reservationdenied'] = 'Rezervace není povolena';
$string['reservationnotopened'] = 'Rezervace dosud nebyla otevřena';
$string['reservations'] = 'Rezervace';
$string['reservationsettings'] = 'Nastavení rezervace';
$string['reserve'] = 'Rezervovat';
$string['reservecancel'] = 'Zrušit rezervaci';
$string['reserved'] = 'Reserved';
$string['reservedon'] = 'Rezervováno dne';
$string['reservedonconnected'] = 'Již jste rezervováni pro připojenou rezervaci: {$a}';
$string['reserversmail'] = 'Jste vyhrazeni pro \'{$a->reservation}\' rezervaci.';
$string['reserversmailhtml'] = 'Jste vyhrazeni pro <em>{$a->reservation}</em> rezervace.';
$string['resetreservation'] = 'Odeberte všechny rezervace';
$string['save'] = 'Uložit známku';
$string['search:activity'] = 'Rezervace - informace o činnosti';
$string['selectvalue'] = 'Vyberte jednu z dostupných hodnot';
$string['showrequest'] = 'Uživatelé mohou zobrazit seznam požadavků';
$string['showuserrequest'] = 'Uživatelé mohou prohlížet';
$string['sortby'] = 'Seznamy rezervací seřazené podle';
$string['sublimit'] = 'Částečný limit {$a}';
$string['sublimitrules'] = 'Pravidla pro dílčí limity';
$string['sublimits'] = 'Omezení dílčí rezervace';
$string['timeclose'] = 'Rezervace končí dne';
$string['timeend'] = 'Datum ukončení';
$string['timeopen'] = 'Rezervace začíná dne';
$string['timestart'] = 'Datum začátku';
$string['upload'] = 'Nahrávání rezervací';
$string['useralreadybooked'] = 'Uživatel již rezervován';
$string['with'] = 's';
$string['withselected'] = 'S vybraným ...';
$string['yourgrade'] = 'Vaše hodnocení této rezervace je: {$a->grade}/{$a->maxgrade}';
$string['yournote'] = 'Vaše poznámka:';
$string['yourscale'] = 'Vaše hodnocení této rezervace je: {$a}';
