<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'pt_br', version '3.10'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'a ser instalado';
$string['accept'] = 'Aceitar';
$string['action'] = 'Ação';
$string['actionchoice'] = 'O que você quer fazer com o arquivo \'{$a}\'?';
$string['actions'] = 'Ações';
$string['actionsfor'] = 'Ações para {$a}';
$string['actionsmenu'] = 'Menu de ações';
$string['active'] = 'Ativo';
$string['activeusers'] = 'Usuários ativos';
$string['activities'] = 'Atividades';
$string['activities_help'] = 'Atividades, como fóruns, questionários e wikis, permitem que conteúdo interativo seja adicionado ao curso.';
$string['activity'] = 'Atividade';
$string['activityclipboard'] = 'Movendo esta atividade: {$a}';
$string['activityiscurrentlyhidden'] = 'Desculpe, no momento esta atividade está oculta';
$string['activitymodule'] = 'Módulo de atividades';
$string['activitymodules'] = 'Módulos de atividade';
$string['activityreport'] = 'Relatório de atividade';
$string['activityreports'] = 'Relatórios de atividades';
$string['activityselect'] = 'Selecione esta atividade para movê-la para outro local';
$string['activitysince'] = 'Atividade desde {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Atividade por usuário';
$string['add'] = 'Adicionar';
$string['addactivity'] = 'Adicionar uma atividade...';
$string['addactivitytosection'] = 'Adicionar uma atividade na seção \'{$a}\'';
$string['addadmin'] = 'Adicionar administrador';
$string['addblock'] = 'Adicionar um bloco';
$string['addcomment'] = 'Adicionar um comentário...';
$string['addcountertousername'] = 'Criar usuário adicionando número na identificação de usuário';
$string['addcreator'] = 'Adicionar criador de curso';
$string['adddots'] = 'Adicionar...';
$string['added'] = 'Adicionou {$a}';
$string['addedtogroup'] = 'Adicionado ao grupo "{$a}"';
$string['addedtogroupnot'] = 'Não adicionado ao grupo "{$a}"';
$string['addedtogroupnotenrolled'] = 'Não adicionado ao grupo "{$a}", porque não está inscrito no curso';
$string['addfilehere'] = 'Adicionar arquivo(s) aqui';
$string['addinganew'] = 'Adicionando um novo {$a}';
$string['addinganewto'] = 'Adicionando um novo {$a->what} em {$a->to}';
$string['addingdatatoexisting'] = 'Adicionando dados a existente';
$string['additionalnames'] = 'Nomes adicionais';
$string['addlinkhere'] = 'Adicionar link aqui';
$string['addnew'] = 'Adicionar um novo {$a}';
$string['addnewcategory'] = 'Adicionar nova categoria';
$string['addnewcourse'] = 'Adicionar um novo curso';
$string['addnewuser'] = 'Adicionar um novo usuário';
$string['addnousersrecip'] = 'Adicionar usuários que não acessaram {$a} à lista de destinatários';
$string['addpagehere'] = 'Adicionar texto aqui';
$string['addresource'] = 'Adicionar um recurso...';
$string['addresourceoractivity'] = 'Adicionar uma atividade ou recurso';
$string['addresourcetosection'] = 'Adicionar um recurso na seção \'{$a}\'';
$string['address'] = 'Endereço';
$string['addsections'] = 'Adicionar seções';
$string['addstudent'] = 'Adicionar estudante';
$string['addsubcategory'] = 'Adicionar uma subcategoria';
$string['addteacher'] = 'Adicionar professor';
$string['admin'] = 'Administrador';
$string['adminhelpaddnewuser'] = 'Criar uma nova conta de usuário manualmente';
$string['adminhelpassignadmins'] = 'Administradores podem fazer qualquer coisa e ir a qualquer parte do site';
$string['adminhelpassigncreators'] = 'Criadores de curso podem criar novos cursos';
$string['adminhelpassignsiteroles'] = 'Aplicar papéis definidos do site para usuários específicos';
$string['adminhelpassignstudents'] = 'Entrar em um curso e adicionar estudantes pelo menu de administração';
$string['adminhelpauthentication'] = 'Você pode usar contas internas de usuários ou de bancos de dados externos';
$string['adminhelpbackup'] = 'Configurar backups automáticos e seus cronogramas';
$string['adminhelpconfiguration'] = 'Configurar a aparência e funcionamento do site';
$string['adminhelpconfigvariables'] = 'Configurar variáveis que afetam operações gerais do site';
$string['adminhelpcourses'] = 'Definir cursos e categorias e designar participantes a eles, editar cursos perndentes';
$string['adminhelpeditorsettings'] = 'Definir configurações básicas para o editor HTML';
$string['adminhelpedituser'] = 'Navegar na lista de contas de usuários e editar qualquer um deles';
$string['adminhelpenvironment'] = 'Controlar a compatibilidade do seu servidor com com os pré-requisitos de instalação atuais e futuros';
$string['adminhelpfailurelogs'] = 'Consultar os logs de erros de login';
$string['adminhelplanguage'] = 'Verificar e editar o pacote de idioma atual';
$string['adminhelplogs'] = 'Consultar os logs de todas as atividades neste site';
$string['adminhelpmanageblocks'] = 'Gerenciar os blocos instalados e suas configurações';
$string['adminhelpmanagedatabase'] = 'Acessar o banco de dados diretamente (seja cuidadoso!)';
$string['adminhelpmanagefilters'] = 'Escolher filtros de texto e configurações relacionadas';
$string['adminhelpmanagemodules'] = 'Gerenciar os módulos instalados e suas configurações';
$string['adminhelpmanageroles'] = 'Criar e definir papéis que possam ser atribuídos aos usuários';
$string['adminhelpmymoodle'] = 'Configurar os blocos Meu Moodle para os usuários';
$string['adminhelpreports'] = 'Relatórios a nível de site';
$string['adminhelpsitefiles'] = 'Para publicar arquivos em geral ou carregar backups externos';
$string['adminhelpsitesettings'] = 'Definir o visual da página inicial do site';
$string['adminhelpstickyblocks'] = 'Configurar os blocos adesivos no nível do Moodle';
$string['adminhelpthemes'] = 'Escolher o visual do site (cores, fontes etc.)';
$string['adminhelpuploadusers'] = 'Importar novas contas de usuários de um arquivo de texto';
$string['adminhelpusers'] = 'Definir os seus usuários e configurar autenticação';
$string['adminhelpxmldbeditor'] = 'Interface para editar os arquivos XMLDB. Somente para desenvolvedores.';
$string['administration'] = 'Administração';
$string['administrationsite'] = 'Administração do site';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Administradores geralmente podem fazer tudo no site, em todos os cursos.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos os administradores';
$string['administratorsandteachers'] = 'Administradores e professores';
$string['advanced'] = 'Avançado';
$string['advancedfilter'] = 'Busca avançada';
$string['advancedsettings'] = 'Configurações avançadas';
$string['afterresource'] = 'Depois do recurso "{$a}"';
$string['aftersection'] = 'Depois da seção "{$a}"';
$string['again'] = 'novamente';
$string['agelocationverification'] = 'Verificação de idade e localização';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX e Javascript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas as ações';
$string['allactivities'] = 'Todas as atividades';
$string['allcategories'] = 'Todas as categorias';
$string['allchanges'] = 'Todas as mudanças';
$string['alldays'] = 'Todos os dias';
$string['allfiles'] = 'Todos os arquivos';
$string['allgroups'] = 'Todos os grupos';
$string['alllogs'] = 'Todos os registros';
$string['allmods'] = 'Todos os {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir métodos internos também';
$string['allownone'] = 'Não permitir nenhum';
$string['allownot'] = 'Não permitir';
$string['allowstealthmodules'] = 'Permitir atividades secretas';
$string['allowstealthmodules_help'] = 'Se ativado, atividades podem ficar disponíveis mas não mostradas em seções visíveis da página do curso. Se assim for, links para atividades ocultas devem ser provisionados de algum outro lugar, como de um recurso do tipo página. Atividades ocultas ainda são listadas no livro de notas e outros relatórios.';
$string['allparticipants'] = 'Todos os participantes';
$string['allteachers'] = 'Todos os professores';
$string['alphanumerical'] = 'Pode conter apenas caracteres alfanuméricos, hífen (-) ou ponto final (.)';
$string['alreadyconfirmed'] = 'O cadastro já foi confirmado';
$string['alternatename'] = 'Nome alternativo';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} e {$a->two}';
$string['answer'] = 'Resposta';
$string['any'] = 'Qualquer';
$string['appearance'] = 'Aparência';
$string['approve'] = 'Aprovar';
$string['areyousure'] = 'Você tem certeza?';
$string['areyousuretorestorethis'] = 'Você quer continuar?';
$string['areyousuretorestorethisinfo'] = 'Mais tarde neste processo você terá a opção de adicionar este backup a um curso existente ou criar um curso completamente novo.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Avaliação';
$string['assignadmins'] = 'Designar administradores';
$string['assigncreators'] = 'Designar criadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Atribuir papéis no contexto do site';
$string['authenticateduser'] = 'Usuário autenticado';
$string['authenticateduserdescription'] = 'Todos os usuários logados.';
$string['authentication'] = 'Autenticação';
$string['authenticationplugins'] = 'Plugins de autenticação';
$string['autosubscribe'] = 'Assinatura de fórum automática';
$string['autosubscribeno'] = 'Não: não quero ser assinante dos fóruns automaticamente';
$string['autosubscribeyes'] = 'Sim: quando eu envio mensagens a um fórum, quero ser automaticamente assinante';
$string['availability'] = 'Disponibilidade';
$string['availablecourses'] = 'Cursos disponíveis';
$string['back'] = 'Voltar';
$string['backto'] = 'Voltar para {$a}';
$string['backtocourselisting'] = 'Voltar para a lista de cursos';
$string['backtohome'] = 'Voltar para a página inicial do site';
$string['backtopageyouwereon'] = 'Voltar para a página em que você estava';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Escolher entre fazer ou não backups automáticos.';
$string['backupadhocpending'] = 'Tarefa ad hoc de backup do curso pendente';
$string['backupcancelled'] = 'Backup cancelado';
$string['backupcoursefileshelp'] = 'Se ativado então os arquivos do curso serão incluidos nos backups automáticos';
$string['backupdate'] = 'Data do backup';
$string['backupdatenew'] = '  {$a->TAG} agora é {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalhes do backup';
$string['backuperrorinvaliddestination'] = 'A pasta de destino de backup não existe ou não é gravável.';
$string['backupexecuteathelp'] = 'Indicar o horário em que o backup deve iniciar.';
$string['backupfailed'] = 'Alguns dos seus cursos não foram salvos!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup concluído com sucesso';
$string['backupfromthissite'] = 'O backup foi feito neste site?';
$string['backupgradebookhistoryhelp'] = 'Se habilitado, o histórico do livro de notas será incluído nos backups automáticos. Note que o histórico de notas não deve estar desabilitado nas configurações do servidor (disablegradehistory) para que isto funcione.';
$string['backupincludemoduleshelp'] = 'Escolha se você quer incluir os módulos do curso nos backups automáticos com ou sem os dados dos usuários.';
$string['backupincludemoduleuserdatahelp'] = 'Escolha se você quer incluir os dados de usuário dos módulos nos backups automáticos.';
$string['backuplogdetailed'] = 'Relatório detalhado de execução';
$string['backuploglaststatus'] = 'Log da última execução';
$string['backupmissinguserinfoperms'] = 'Nota: este backup não contém dados de usuários. As atividades Exercício e Laboratório de Avaliação não serão incluídas no backup, pois estes módulos não são compatíveis com esse tipo de backup.';
$string['backupnext'] = 'Próximo backup';
$string['backupnonisowarning'] = 'Atenção: este backup é de um sistema com versão de Moodle anterior à 1.6 (não Unicode). Se este backup contém textos que não são ISO-8859-1, eles podem ser CORROMPIDOS se você tentar restaurar eles para esta versão do Moodle, que é Unicode. Consulte <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> para mais informações sobre como recuperar este backup corretamente.';
$string['backupnotyetrun'] = 'Backup automatizado pendente';
$string['backuporiginalname'] = 'Nome do backup';
$string['backuproleassignments'] = 'Fazer backup de atribuições de papéis para esses papéis';
$string['backupsavetohelp'] = 'Caminho completo para o diretório onde você quer salvar os arquivos de backup';
$string['backupsitefileshelp'] = 'Se habilitado os arquivos do site usados nos cursos serão incluídos automaticamente nos backups';
$string['backuptakealook'] = 'Por favor, dê uma olhada nos seus registros de backup em: {$a}';
$string['backupuserfileshelp'] = 'Escolha se os arquivos dos usuários (ex. imagens dos perfis) devem ser incluídos em backups automáticos';
$string['backupversion'] = 'Versão do backup';
$string['badges'] = 'Emblemas';
$string['block'] = 'Bloco';
$string['blockconfiga'] = 'Configurando um bloco {$a}';
$string['blockconfigbad'] = 'Este bloco não foi implementado corretamente e não pode prover uma interface de configuração.';
$string['blocks'] = 'Blocos';
$string['blocksaddedit'] = 'Adicionar/Editar blocos';
$string['blockseditoff'] = 'Desabilitar edição de blocos';
$string['blocksediton'] = 'Habilitar edição de blocos';
$string['blocksetup'] = 'Configurando tabelas do bloco';
$string['blocksuccess'] = '{$a} tabelas foram configuradas corretamente';
$string['brief'] = 'Resumo';
$string['bulkactions'] = 'Ações em lote';
$string['bulkactionselect'] = '{$a} seleção de ações em lote';
$string['bulkmovecoursessuccess'] = 'Os {$a->courses} cursos foram movidos para {$a->category} com sucesso';
$string['bycourseorder'] = 'Por ordem dos cursos';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Ignorado';
$string['cachecontrols'] = 'Controles de cache';
$string['calltofeedback'] = 'Os criadores deste software gostariam do seu feedback.';
$string['calltofeedback_give'] = 'Dê um feedback sobre este software';
$string['calltofeedback_remind'] = 'Lembre-me mais tarde';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorias de Cursos';
$string['categoriesandcourses'] = 'Categorias e Cursos';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'A categoria \'{$a}\' foi adicionada';
$string['categorybulkaction'] = 'Ações em lote para categorias selecionadas';
$string['categorycontents'] = 'Subcategorias e cursos';
$string['categorycurrentcontents'] = 'Conteúdos de {$a}';
$string['categorydeleted'] = 'A categoria \'{$a}\' foi removida';
$string['categoryduplicate'] = 'A categoria \'{$a}\' já existe!';
$string['categoryhidden'] = '(oculta)';
$string['categorymodifiedcancel'] = 'Categoria modificada! Por favor, cancele e tente novamente.';
$string['categoryname'] = 'Nome da categoria';
$string['categorysubcategoryof'] = '{$a->category} - sub-categoria de {$a->parentcategory}';
$string['categoryupdated'] = 'Categoria {$a} atualizada';
$string['changedpassword'] = 'Senha modificada';
$string['changepassword'] = 'Mudar a senha';
$string['changesmadereallygoaway'] = 'Você fez alterações. Está certo de que quer sair e abandonar suas alterações?';
$string['changessaved'] = 'Mudanças gravadas';
$string['check'] = 'Verificar';
$string['checkall'] = 'Selecionar todos';
$string['checkingbackup'] = 'Verificando o backup';
$string['checkingcourse'] = 'Verificando o curso';
$string['checkingforbbexport'] = 'Verificando exportação BlackBoard';
$string['checkinginstances'] = 'Verificando exemplares';
$string['checkingsections'] = 'Verificando seções';
$string['checklanguage'] = 'Verificar idiomas';
$string['checknone'] = 'Não controlar nenhum';
$string['checks'] = 'Checagens';
$string['checksok'] = 'Todas checagens \'{$a}\' OK';
$string['childcoursenotfound'] = 'Curso afiliado não encontrado!';
$string['childcourses'] = 'Cursos afiliados';
$string['choose'] = 'Escolher';
$string['choosecourse'] = 'Escolha um curso';
$string['choosedots'] = 'Escolher...';
$string['chooselivelogs'] = 'Ou veja a atividade corrente';
$string['chooselogs'] = 'Escolha os dados que você quer ver';
$string['choosereportfilter'] = 'Escolha um filtro para o relatório';
$string['choosetheme'] = 'Escolher o tema';
$string['chooseuser'] = 'Escolher um usuário';
$string['city'] = 'Cidade/Município';
$string['cleaningtempdata'] = 'Limpando dados temporários';
$string['clear'] = 'Limpar';
$string['clearsearch'] = 'Limpar campo de pesquisa.';
$string['clickhelpiconformoreinfo'] = '... continua ... Clique no ícone da ajuda para ler o artigo completo';
$string['clickhere'] = 'Clique aqui ...';
$string['clicktochangeinbrackets'] = '{$a} (Clique para modificar)';
$string['clicktohideshow'] = 'Clique para expandir ou contrair';
$string['closebuttontitle'] = 'Fechar';
$string['closewindow'] = 'Fechar esta janela';
$string['collapse'] = 'Contrair';
$string['collapseall'] = 'Contrair tudo';
$string['collapsecategory'] = 'Colapsar {$a}';
$string['commentincontext'] = 'Encontrar este comentário no contexto';
$string['comments'] = 'Comentários';
$string['commentscount'] = 'Comentários ({$a})';
$string['commentsnotenabled'] = 'Recurso de comentários não está habilitado';
$string['commentsrequirelogin'] = 'Você precisa fazer o login para ler os comentários.';
$string['comparelanguage'] = 'Compare e edite o idioma em uso';
$string['complete'] = 'Concluído';
$string['completereport'] = 'Relatório completo';
$string['configuration'] = 'Configuração';
$string['confirm'] = 'Confirmar';
$string['confirmcheckfull'] = 'Tem certeza que quer confirmar {$a}?';
$string['confirmcoursemove'] = 'Tem certeza de que deseja mover este curso ({$a->course}) para esta categoria ({$a->category})?';
$string['confirmdeletesection'] = 'Você tem certeza absoluta de que deseja excluir completamente "{$a}" e todas as atividades que ele contém?';
$string['confirmed'] = 'O seu cadastro foi confirmado';
$string['confirmednot'] = 'O seu cadastro ainda não foi confirmado. Por favor, verifique a sua caixa de entrada pelo e-mail de confirmação.';
$string['considereddigitalminor'] = 'Você é muito jovem para criar uma conta neste site.';
$string['content'] = 'Conteúdo';
$string['contentbank'] = 'Banco de conteúdo';
$string['contentexport_aboutthiscourse'] = 'Sumário do curso';
$string['contentexport_coursesummary'] = 'Este arquivo faz parte do conteúdo baixado de <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Este arquivo faz parte do conteúdo descarregado de <a href="{$a->courselink}">{$a->coursename}</a> por {$a->userfullname} em {$a->date}';
$string['contentexport_modulesummary'] = 'Este arquivo faz parte do conteúdo baixado de <a href="{$a->modulelink}">{$a->modulename}</a> em {$a->date}. Observe que parte do conteúdo e quaisquer arquivos maiores que {$a->maxfilesize} não são baixados.';
$string['contentexport_viewfilename'] = 'Visualizar o arquivo {$a}';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Clique aqui para entrar no curso';
$string['convertingwikitomarkdown'] = 'Convertendo wiki para Markdown';
$string['cookiesenabled'] = 'O uso de Cookies deve ser permitido no seu navegador';
$string['cookiesenabled_help'] = 'Dois cookies são utilizados por este site:

O essencial é o cookie da sessão, geralmente chamado MoodleSession. Você deve permitir este cookie no seu navegador para prover continuidade e permanecer logado enquanto navega pelo site. Quando você fizer o sair ou fechar o navegador este cookie é destruído (no seu navegador e no servidor).

O outro cookie é puramente por conveniência, geralmente chamado de algo como MOODLEID. Ele apenas lembra sua identificação no navegador. Isso significa que quando você retornar a este site, o campo identificação do usuário na página de autenticação será automaticamente preenchido para você. É seguro recusar este cookie - você apenas terá que redigitar o sua identificação toda vez que você autenticar.';
$string['cookiesenabledonlysession'] = 'O uso de Cookies deve ser permitido no seu navegador';
$string['cookiesenabledonlysession_help'] = 'Este site usa um cookie de sessão, geralmente chamado MoodleSession. Você deve permitir que este cookie no seu navegador forneça continuidade e permaneça logado ao navegar pelo site. Quando você sai ou fecha o navegador, esse cookie é destruído (no seu navegador e no servidor).';
$string['cookiesnotenabled'] = 'Infelizmente os Cookies não estão habilitados no seu navegador';
$string['copy'] = 'copiar';
$string['copyasnoun'] = 'copiar';
$string['copycourse'] = 'Copiar curso';
$string['copyingcoursefiles'] = 'Copiando arquivos do curso';
$string['copyingsitefiles'] = 'Copiando arquivos do site usados no curso';
$string['copyinguserfiles'] = 'Copiando arquivos de usuários';
$string['copyingzipfile'] = 'Copiando arquivo zip';
$string['copyrightnotice'] = 'Nota sobre os Direitos Autorais';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Custo';
$string['costdefault'] = 'Custo padrão';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Curso';
$string['courseadministration'] = 'Administração do curso';
$string['courseapprovedemail'] = 'O seu pedido de aceitação no curso {$a->name} foi aprovado e você foi designado como {$a->teacher}. Para acessar o seu curso vá à página {$a->url}';
$string['courseapprovedemail2'] = 'Seu curso solicitado, {$a->name}, foi aprovado. Para acessar seu novo curso, vá para {$a->url}';
$string['courseapprovedfailed'] = 'Não foi possível salvar o curso como aprovado!';
$string['courseapprovedsubject'] = 'O seu curso foi aprovado!';
$string['courseavailable'] = 'Este curso pode ser acessado pelos participantes';
$string['courseavailablenot'] = 'Este curso não pode ser acessado pelos participantes';
$string['coursebackup'] = 'Backup do curso';
$string['coursebulkaction'] = 'Ações em lote para cursos selecionados';
$string['coursecategories'] = 'Categorias de curso';
$string['coursecategory'] = 'Categoria do curso';
$string['coursecategory_help'] = '<p>Algumas categorias de curso devem ter sido definidas previamente pelo administrador do sistema.</p>

<p>Por exemplo: "Ciências", "Economia", "Saúde Pública", etc.</p>

<p>Escolha a categoria mais adequada ao seu curso.
   A categoria escolhida determina a posição do seu curso
   na lista de cursos para que os estudantes o encontrem
   com facilidade.</p>';
$string['coursecategorydeleted'] = 'Apagada categoria de cursos {$a}';
$string['coursecatmanagement'] = 'Gerenciamento de curso e categoria';
$string['coursecompletion'] = 'Conclusão do curso';
$string['coursecompletions'] = 'Conclusões  do curso';
$string['coursecreators'] = 'Criador de cursos';
$string['coursecreatorsdescription'] = 'Criadores de cursos podem criar novos cursos e agir como professores.';
$string['coursedeleted'] = 'O curso {$a} foi excluído';
$string['coursedetails'] = 'Detalhes do curso';
$string['coursedisplay'] = 'Layout do curso';
$string['coursedisplay_help'] = 'Esta definição determina se o curso inteiro é exibido em uma página ou dividida em várias páginas.';
$string['coursedisplay_multi'] = 'Mostrar um tópico por página';
$string['coursedisplay_single'] = 'Mostrar todos os tópicos em uma página';
$string['courseduration'] = 'Duração do curso';
$string['courseduration_desc'] = 'A duração do curso é utilizada para calcular a data de término padrão do curso. A data de término do curso é utilizada somente para relatórios. Usuários ainda podem entrar no curso após a data de término.';
$string['courseenddateenabled'] = 'Data de término do curso habilitada por padrão';
$string['courseenddateenabled_desc'] = 'Esta configuração determina se a data de término do curso será habilitada por padrão para novos cursos e definida para a data calculada da duração do curso.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Arquivos de curso legados';
$string['coursefilesedit'] = 'Editar arquivos de cursos antigos';
$string['coursefileswarning'] = 'Arquivos de curso estão obsoletos';
$string['coursefileswarning_help'] = 'Arquivos do curso estão obsoletos a partir do Moodle 2.0, por favor utilize repositórios externos.';
$string['courseformatdata'] = 'Informação sobre o formato do curso';
$string['courseformatoptions'] = 'Opções de formatação para {$a}';
$string['courseformats'] = 'Formatos de curso';
$string['courseformatudpate'] = 'Atualizar formato';
$string['coursegrades'] = 'Notas';
$string['coursehelpcategory'] = 'Posicione o curso na listagem de cursos de forma que seja mais fácil para os estudantes encontrá-lo.';
$string['coursehelpforce'] = 'Forçar o modo de grupo para cada atividade no curso.';
$string['coursehelpformat'] = 'A página principal do curso será mostrada neste formato.';
$string['coursehelphiddensections'] = 'Como as seções escondidas no curso serão mostradas aos estudantes.';
$string['coursehelpmaximumupload'] = 'Define o tamanho máximo dos arquivos que podem ser enviados para este curso, limitado pela configuração do site.';
$string['coursehelpnewsitemsnumber'] = 'Número de avisos recentes que aparecem no bloco de avisos mais recente na página do curso. Se definido como zero, o fórum de avisos não será criado.';
$string['coursehelpnumberweeks'] = 'Número de seções no curso (aplica-se a apenas certos formatos de curso).';
$string['coursehelpshowgrades'] = 'Habilita a exibição do livro de notas. Isso não impede que as notas sejam exibidas individualmente nas atividades.';
$string['coursehidden'] = 'Este curso está indisponível para estudantes';
$string['courseinfo'] = 'Informações do curso';
$string['courselegacyfiles'] = 'Arquivos de curso legados';
$string['courselegacyfiles_help'] = 'A área de arquivos do curso oferece alguma compatibilidade com o Moodle 1.9 e versões anteriores. Todos os arquivos nesta área são acessíveis a todos os participantes do curso (se você fizer links para eles ou não) e não há maneira de saber onde qualquer um desses arquivos estão sendo usados no Moodle.

Se você usar esse espaço para armazenar arquivos do curso, você pode se expor a uma série de riscos de privacidade e segurança, bem como tendo arquivos perdidos em backups e importações de curso e quaisquer conteúdos podem ser compartilhados ou reutilizados a qualquer momento. Por isso, é recomendável que você não use esta área a menos que você realmente saiba o que está fazendo.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Arquivos legados do curso: {$a}';
$string['coursenotaccessible'] = 'Este curso não permite acesso público (usuários não inscritos)';
$string['courseoverview'] = 'Descrição do curso';
$string['courseoverviewfiles'] = 'Imagem do curso';
$string['courseoverviewfiles_help'] = 'A imagem do curso é mostrada no resumo do curso no Painel. Outros tipos de arquivos aceitos e a opção de mais de um arquivo podem ser habilitados pelo administrador do site. Se for o caso, estes arquivos serão mostrados próximos ao sumário de curso na página de lista de cursos';
$string['courseoverviewfilesext'] = 'Extensões de arquivo da imagem do curso';
$string['courseoverviewfileslimit'] = 'Limite de arquivos para imagem do curso';
$string['courseoverviewgraph'] = 'Gráfico de visão geral do curso';
$string['coursepreferences'] = 'Preferências do curso';
$string['courseprofiles'] = 'Cursos inscritos';
$string['coursereasonforrejecting'] = 'Seus motivos para rejeitar esta solicitação';
$string['coursereasonforrejectingemail'] = 'Isto será enviado por email para o solicitante';
$string['coursereject'] = 'Rejeitar o pedido de aprovação de curso';
$string['courserejected'] = 'O curso foi rejeitado e o requerente foi notificado.';
$string['courserejectemail'] = 'Infelizmente o seu pedido de abertura de curso não foi aceito. Esta é a razão indicada:
{$a}';
$string['courserejectreason'] = 'Descreva as razões para rejeitar este curso<br />(uma cópia será mandada por email ao autor do pedido)';
$string['courserejectsubject'] = 'O seu curso não foi aceito';
$string['coursereport'] = 'Relatório do curso';
$string['coursereports'] = 'Relatórios do curso';
$string['courserequest'] = 'Solicitação de curso';
$string['courserequestdetails'] = 'Detalhes do curso solicitado';
$string['courserequestfailed'] = 'Por alguma razão, sua solicitação de curso não pôde ser realizada.';
$string['courserequestintro'] = 'Use este formulário para solicitar a criação de um novo curso.<br /> Forneça o maior número de informações possível<br />para que os administradores possam entender e aceitar o seu pedido.';
$string['courserequestreason'] = 'Razões para abrir este curso';
$string['courserequestsuccess'] = 'Sua solicitação de curso foi realizada com sucesso. Será enviado um email para você informando se sua solicitação foi aprovada.';
$string['courserequestsupport'] = 'Informações adicionais para ajudar o administrador a avaliar esta solicitação';
$string['courserequestwarning'] = 'O usuário que solicitar matrícula neste curso assumirá automaticamente o papel "{$a}".';
$string['courserestore'] = 'Restauração de curso';
$string['courses'] = 'Cursos';
$string['coursesearch'] = 'Pesquisar cursos';
$string['coursesearch_help'] = 'Você pode pesquisar por várias palavras ao mesmo tempo e pode refinar sua busca da seguinte forma:

* palavra - encontra qualquer ocorrência dessa palavra no texto
* +palavra - apenas palavras correspondentes idênticas serão encontradas.
* -palavra - não inclui resultados que contenham essa palavra.';
$string['coursesectionsummaries'] = 'Sumários da seção de curso';
$string['coursesectiontitle'] = 'Curso: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Configurações padrão dos cursos';
$string['coursesmovedout'] = 'Cursos movidos fora de {$a}';
$string['coursespending'] = 'Cursos com aprovação pendente';
$string['coursestart'] = 'Início do curso';
$string['coursesummary'] = 'Sumário do curso';
$string['coursesummary_help'] = 'A descrição do curso é exibida na lista de cursos. A busca de cursos inclui também os textos da descrição, além dos nomes dos cursos.';
$string['coursetitle'] = 'Curso: {$a->course}';
$string['courseupdates'] = 'Atualizações do curso';
$string['coursevisibility'] = 'Visibilidade do curso';
$string['coursevisibility_help'] = 'Esta configuração determina se o curso aparece na lista de cursos e quando os estudantes podem acessá-lo. Se definida como Ocultar, então o acesso é restrito a usuários com permissão de ver cursos ocultos (como professores).';
$string['create'] = 'Criar';
$string['createaccount'] = 'Criar minha conta';
$string['createcategory'] = 'Criar categoria';
$string['createfolder'] = 'Criar diretório em {$a}';
$string['createnew'] = 'Criar novo';
$string['createnewcategory'] = 'Criar nova categoria';
$string['createnewcourse'] = 'Criar novo curso';
$string['createnewsubcategory'] = 'Criar nova subcategoria';
$string['createsubcategoryof'] = 'Criar subcategoria de {$a}';
$string['createuser'] = 'Criar usuário';
$string['createuserandpass'] = 'Escolha seu usuário e senha';
$string['createziparchive'] = 'Criar um arquivo ZIP';
$string['creatingblocks'] = 'Criando blocos';
$string['creatingblocksroles'] = 'Criando atribuições de papéis e sobreposições no nível de bloco';
$string['creatingblogsinfo'] = 'Criando informação dos blogs';
$string['creatingcategoriesandquestions'] = 'Criando categorias e questões';
$string['creatingcoursemodules'] = 'Criando módulos do curso';
$string['creatingcourseroles'] = 'Criando atribuições de papéis e sobreposições no nível de curso';
$string['creatingevents'] = 'Criando eventos';
$string['creatinggradebook'] = 'Criando livro de notas';
$string['creatinggroupings'] = 'Criando grupos';
$string['creatinggroupingsgroups'] = 'Adicionando grupos nos grupamentos';
$string['creatinggroups'] = 'Criando grupos';
$string['creatinglogentries'] = 'Criando logs';
$string['creatingmessagesinfo'] = 'Criando info das mensagens';
$string['creatingmodroles'] = 'Criando atribuições de papéis e sobreposições no nível de módulo';
$string['creatingnewcourse'] = 'Criando um novo curso';
$string['creatingrolesdefinitions'] = 'Criando definições de papéis';
$string['creatingscales'] = 'Criando escalas';
$string['creatingsections'] = 'Criando seções';
$string['creatingtemporarystructures'] = 'Criando estruturas temporárias';
$string['creatinguserroles'] = 'Criando atribuições de papéis e sobreposições no nível de usuário';
$string['creatingusers'] = 'Criando usuários';
$string['creatingxmlfile'] = 'Criando file XML';
$string['currency'] = 'Moeda';
$string['currentcourse'] = 'Curso atual';
$string['currentcourseadding'] = 'Curso corrente, adicionando dados a ele';
$string['currentcoursedeleting'] = 'Curso corrente, após excluir seus dados';
$string['currentlanguage'] = 'Idioma em uso';
$string['currentlocaltime'] = 'Hora local';
$string['currentpicture'] = 'Imagem atual';
$string['currentrelease'] = 'Informação sobre a versão atual';
$string['currentversion'] = 'Versão atual';
$string['databasechecking'] = 'Atualizando a base de dados do Moodle, da versão {$a->oldversion} para a versão {$a->newversion}';
$string['databaseperformance'] = 'Desempenho da base de dados';
$string['databasesetup'] = 'Configurando a base de dados';
$string['databasesuccess'] = 'A base de dados foi atualizada com sucesso';
$string['databaseupgradebackups'] = 'Versão de backup {$a}';
$string['databaseupgradeblocks'] = 'Versão de Blocos {$a}';
$string['databaseupgradegroups'] = 'Versão de grupos {$a}';
$string['databaseupgradelocal'] = 'A versão atual das personalizações da base de de dados é {$a}';
$string['databaseupgrades'] = 'Fazendo o upgrade da base de dados';
$string['dataformats'] = 'Formatos de dados';
$string['date'] = 'Data';
$string['datechanged'] = 'Data alterada';
$string['datemostrecentfirst'] = 'Data mais recente primeiro';
$string['datemostrecentlast'] = 'Data mais recente por último';
$string['day'] = 'dia';
$string['days'] = 'dias';
$string['decodinginternallinks'] = 'Decodificando links internos';
$string['default'] = 'Padrão';
$string['defaultcompetencescale'] = 'Escala de competência padrão';
$string['defaultcompetencescaledesc'] = 'Uma escala de classificação binária que fornece somente a informação se alguém demonstrou proficiência ou não.';
$string['defaultcompetencescalenotproficient'] = 'Ainda não tem a competência';
$string['defaultcompetencescaleproficient'] = 'Tem a competência';
$string['defaultcoursestudent'] = 'Estudante';
$string['defaultcoursestudentdescription'] = 'Estudantes geralmente tem menos privilégios em um curso.';
$string['defaultcoursestudents'] = 'Estudantes';
$string['defaultcoursesummary'] = 'Escreva um parágrafo conciso e interessante para descrever o curso';
$string['defaultcourseteacher'] = 'Professor';
$string['defaultcourseteacherdescription'] = 'Professores podem fazer tudo em um curso, alterar atividades e avaliar.';
$string['defaultcourseteachers'] = 'Professores';
$string['defaulteditor'] = 'Editor padrão';
$string['defaulthomepageuser'] = 'Página inicial';
$string['defaulthomepageuser_help'] = 'Sua página inicial é o primeiro link na navegação.';
$string['delete'] = 'Excluir';
$string['deleteablock'] = 'Excluir um bloco';
$string['deleteall'] = 'Excluir todos';
$string['deleteallcannotundo'] = 'Excluir todos - não pode ser desfeito';
$string['deleteallcomments'] = 'Excluir todos os comentários';
$string['deleteallratings'] = 'Excluir todas as pontuações';
$string['deletecategory'] = 'Excluir categoria: {$a}';
$string['deletecategorycheck'] = 'Você tem certeza que deseja excluir definitivamente esta categoria <b>\'{$a}\'</b>?<br />Os cursos serão transferidos para a categoria superior, se presente, ou para a categoria padrão';
$string['deletecategorycheck2'] = 'Se você excluir esta categoria, escolha o que fazer com seus cursos e subcategorias.';
$string['deletecategoryempty'] = 'Esta categoria está vazia.';
$string['deletecheck'] = 'Excluir {$a} ?';
$string['deletecheckfiles'] = 'Você tem certeza que deseja excluir definitivamente estes arquivos?';
$string['deletecheckfull'] = 'Você tem certeza que deseja excluir definitivamente o usuário {$a}, incluindo as suas inscrições, atividade e todos os dados do usuário?';
$string['deletechecktype'] = 'Você tem certeza que quer apagar este {$a->type}?';
$string['deletechecktypename'] = 'Você tem certeza que quer apagar o {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Você vai excluir estes arquivos';
$string['deletecommentbyon'] = 'Excluír o comentário publicado por {$a->user} em {$a->time}';
$string['deletecompletely'] = 'Excluir completamente';
$string['deletecourse'] = 'Excluir um curso';
$string['deletecoursecheck'] = 'Tem certeza que quer excluir completamente este curso e todos os seus dados?';
$string['deleted'] = 'Excluído';
$string['deletedactivity'] = '{$a} excluída';
$string['deletedcourse'] = '{$a} foi totalmente excluído';
$string['deletednot'] = 'Não foi possível excluir {$a} !';
$string['deletepicture'] = 'Excluir';
$string['deletesection'] = 'Excluir tópico';
$string['deleteselected'] = 'Excluir selecionados';
$string['deleteselectedkey'] = 'Excluir chave selecionada';
$string['deletingcourse'] = 'Cancelando {$a}';
$string['deletingexistingcoursedata'] = 'Cancelando dados do curso';
$string['deletingolddata'] = 'Cancelando dados antigos';
$string['department'] = 'Departamento';
$string['deprecatedeventname'] = '{$a} (não mais em uso)';
$string['desc'] = 'Decrescente';
$string['description'] = 'Descrição';
$string['descriptiona'] = 'Descrição: {$a}';
$string['deselectall'] = 'Desmarcar todas as seleções';
$string['deselectnos'] = 'Desmarcar todos os \'Não\'';
$string['detailedless'] = 'Menos detalhes';
$string['detailedmore'] = 'Mais detalhes';
$string['details'] = 'Detalhes';
$string['digitalminor'] = 'Menor digital';
$string['digitalminor_desc'] = 'Por favor peça para seus pais/responsáveis contatarem:';
$string['directory'] = 'Diretório';
$string['disable'] = 'Desabilitar';
$string['disabledcomments'] = 'Comentários estão desativados';
$string['dismissnotification'] = 'Ignorar essa notificação';
$string['displayingfirst'] = 'Só as primeiras {$a->count} {$a->things} são visualizadas';
$string['displayingrecords'] = 'Mostrando {$a} registros';
$string['displayingusers'] = 'Mostrando usuários {$a->start} a {$a->end}';
$string['displayonpage'] = 'Mostrar na página';
$string['dndcourse'] = 'Você pode arrastar e soltar este curso para alterar a sua classificação ou para movê-lo para outra categoria.';
$string['dndenabled_inbox'] = 'Você pode arrastar e soltar arquivos aqui para adicioná-los.';
$string['dndnotsupported'] = 'Upload arrastando e soltando não suportado';
$string['dndnotsupported_help'] = 'Seu navegador não suporta upload arrastando e soltando . Esta funcionalidade está disponível em todas as versões recentes do Chrome, Mozilla Firefox e Safari, assim como no Internet Explorer v10 e superior.';
$string['dndnotsupported_insentence'] = 'Upload arrastando e soltando não suportado';
$string['dnduploadwithoutcontent'] = 'Este envio não possui conteúdo';
$string['dndworkingfile'] = 'Arraste e solte arquivos nas seções do curso para enviá-os';
$string['dndworkingfilelink'] = 'Arraste e solte arquivos ou links nas seções do curso para enviá-los';
$string['dndworkingfiletext'] = 'Arraste e solte arquivos ou texto nas seções do curso para enviá-los';
$string['dndworkingfiletextlink'] = 'Arraste e solte arquivos, textos ou links nas seções do curso para enviá-los';
$string['dndworkinglink'] = 'Arraste e solte links nas seções do curso para enviá-los';
$string['dndworkingtext'] = 'Arraste e solte textos nas seções do curso para enviá-los';
$string['dndworkingtextlink'] = 'Arraste e solte texto ou links nas seções do curso para enviá-los';
$string['documentation'] = 'Documentação do Moodle';
$string['dontsortcategories'] = 'Não ordenar categorias';
$string['dontsortcourses'] = 'Não ordenar cursos';
$string['down'] = 'para baixo';
$string['download'] = 'Download';
$string['downloadall'] = 'Download de tudo';
$string['downloadexcel'] = 'Download em formato Excel';
$string['downloadfile'] = 'Download do arquivo';
$string['downloadods'] = 'Download em formato ODS';
$string['downloadtext'] = 'Download em formato text';
$string['doyouagree'] = 'Você leu e entendeu estas cláusulas?';
$string['droptoupload'] = 'Solte arquivos aqui para eniviar';
$string['duplicate'] = 'Duplicar';
$string['duplicatedmodule'] = '{$a} (copiado)';
$string['edhelpaspellpath'] = 'Para usar o corretor ortográfico no editor, você DEVE ter <strong>aspell 0.50</strong> ou posterior instalado em seu servidor, e você deve especificar o caminho correto de acesso ao arquivo binário do aspell. Nos sistemas Unix/Linux, este caminho é normalmente <strong>/usr/bin/aspell</strong>, mas pode ser diferente.';
$string['edhelpbgcolor'] = 'Definir cor da área de edição.<br />Exemplo de valôres válidos: #ffffff ou white';
$string['edhelpcleanword'] = 'Esta opção ativa ou desativa o filtro de código específico de Word.';
$string['edhelpenablespelling'] = 'Ativar ou desativar o controle ortográfico. Para a ativação é necessário que o <strong>aspell</strong> esteja instalado no servidor.';
$string['edhelpfontfamily'] = 'A propriedade de font-family é uma lista de nomes de famílias de fontes e/ou nomes genéricos de fontes. Estes nomes devem ser separados por vírgulas.';
$string['edhelpfontlist'] = 'Definir as fontes indicadas nos menus dropdown do editor.';
$string['edhelpfontsize'] = 'O tamanho padrão das fontes.<br />Exemplos de valores válidos: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Editar opções da categoria';
$string['editcategorythis'] = 'Editar categoria';
$string['editcoursesettings'] = 'Editar configurações do curso';
$string['editfiles'] = 'Editar arquivos';
$string['editgroupprofile'] = 'Editar perfil do grupo';
$string['editinga'] = 'Editando um {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Este valor não pode ser editado!';
$string['editmyprofile'] = 'Modificar perfil';
$string['editorbgcolor'] = 'Cor de fundo';
$string['editorcleanonpaste'] = 'Limpar html do Word quando colar';
$string['editorcommonsettings'] = 'Configurações padrão';
$string['editordefaultfont'] = 'Fonte padrão';
$string['editorenablespelling'] = 'Ativar controle ortográfico';
$string['editorfontlist'] = 'Lista de fontes';
$string['editorfontsize'] = 'Tamanho padrão de fontes';
$string['editorpreferences'] = 'Preferências do editor';
$string['editorresettodefaults'] = 'Restabelecer valores padrão';
$string['editorsettings'] = 'Configurações do editor';
$string['editorshortcutkeys'] = 'Teclas de atalho do editor';
$string['editsection'] = 'Editar seção';
$string['editsectionname'] = 'Editar nome da seção';
$string['editsettings'] = 'Editar configurações';
$string['editsummary'] = 'Editar sumário';
$string['editthisactivity'] = 'Editar esta atividade';
$string['editthiscategory'] = 'Editar esta categoria';
$string['edittitle'] = 'Editar título';
$string['edittitleinstructions'] = 'Esc para cancelar, Enter quando acabar';
$string['edituser'] = 'Editar contas de usuários';
$string['edulevel'] = 'Todos os eventos';
$string['edulevel_help'] = '* Ensinar - ações executadas por um professor, por exemplo, atualizar um recurso
* Participar - ações realizadas por um estudante, por exemplo, postar em um fórum
* Outros - ações executadas por um usuário com um papel que não seja professor ou estudante';
$string['edulevelother'] = 'Outro';
$string['edulevelparticipating'] = 'Participar';
$string['edulevelteacher'] = 'Ensino';
$string['email'] = 'Endereço de email';
$string['emailactive'] = 'Email ativado';
$string['emailagain'] = 'Confirmar endereço de e-mail';
$string['emailalreadysent'] = 'Um e-mail para redefinição de senha já foi enviado. Por favor, verifique seu e-mail.';
$string['emailcharset'] = 'Email charset';
$string['emailconfirm'] = 'Confirmar seu registro';
$string['emailconfirmation'] = 'Oi,

Uma nova conta foi criada em \'{$a->sitename}\' usando seu endereço de email.

Para confirmar sua nova conta acesse o seguinte endereço:

{$a->link}

Na maioria do programas de Email isso deve aparecer como um link azul que você pode simplesmente clicar. Se isto não funcionar, você pode copiar este link e colar na barra de endereços do seu navegador.

Se você precisar de ajuda, por favor contate o administrador do site, {$a->admin}';
$string['emailconfirmationresend'] = 'Reenviar e-mail de confirmação';
$string['emailconfirmationsubject'] = '{$a}: confirmação de conta';
$string['emailconfirmsent'] = '<p>Uma mensagem foi enviada para o seu endereço <b>{$a}</b></p><p>Esta mensagem contém instruções para completar o seu cadastro.</p><p>Se você encontrar dificuldades contate o administrador.</p>';
$string['emailconfirmsentfailure'] = 'O email de confirmação não foi enviado';
$string['emailconfirmsentsuccess'] = 'E-mail de confirmação enviado com sucesso';
$string['emaildigest'] = 'Tipo de resumo de email';
$string['emaildigest_help'] = 'Essa é a configuração de resumo diário que os fóruns usarão por padrão.

* Sem resumo - você receberá um e-mail por post no fórum;
* Resumo - mensagens completas - você receberá um e-mail de resumo por dia contendo o conteúdo completo de cada post no fórum;
* Resumo - apenas assuntos - você receberá um e-mail de resumo por dia contendo apenas o assunto de cada post no fórum.

Você também pode escolher uma configuração diferente para cada fórum, se você quiser.';
$string['emaildigestcomplete'] = 'Completo (um email diário com as mensagens completas dos fóruns)';
$string['emaildigestoff'] = 'Sem resumo (um email para cada mensagem do fórum)';
$string['emaildigestsubjects'] = 'Assuntos (um email diário, apenas com os assuntos das mensagens)';
$string['emaildisable'] = 'Este endereço de email não está ativado';
$string['emaildisableclick'] = 'Clique aqui para desabilitar o envio de emails para este endereço';
$string['emaildisplay'] = 'Mostrar endereço de email';
$string['emaildisplay_help'] = 'Usuários privilegiados (como professores e gerentes) sempre poderão ver seu endereço de e-mail.';
$string['emaildisplaycourse'] = 'Apenas os participantes do curso podem ver o meu endereço de email';
$string['emaildisplayno'] = 'Ocultar o meu endereço de email de usuários sem privilégio';
$string['emaildisplayyes'] = 'Permitir que todos vejam o meu endereço de email';
$string['emailenable'] = 'Este endereço de email está ativado';
$string['emailenableclick'] = 'Clique aqui para habilitar novamente o envio de email para este endereço';
$string['emailexists'] = 'Este endereço de email já foi registrado.';
$string['emailexistshintlink'] = 'Recuperar o nome de usuário ou a senha esquecidos';
$string['emailexistssignuphint'] = 'Talvez você já criou uma conta anteriormente? {$a}';
$string['emailformat'] = 'Formato de email';
$string['emailmustbereal'] = 'Aviso: o seu endereço de email  deve ser verdadeiro';
$string['emailnotallowed'] = 'Endereços de email destes domínios não são aceitos ({$a})';
$string['emailnotfound'] = 'O endereço email não foi encontrado na base de dados';
$string['emailonlyallowed'] = 'Este endereço de email não é permitido ({$a})';
$string['emailpasswordchangeinfo'] = 'Olá {$a->firstname},

Alguém (provavelmente você) pediu uma nova senha para a sua conta de usuário em \'{$a->sitename}\'.

Para modificar a sua senha visite o seguinte endereço:

{$a->link}

Na maioria do programas de Email este é um link azul que você pode ativar clicando em cima. Se isto não funcionar, você pode copiar este link na barra de endereços do seu navegador.

Se você precisar de ajuda, por favor contate o administrador do site,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Olá {$a->firstname},

Alguém (provavelmente você) solicitou uma nova senha para sua conta em \'{$a->sitename}\'.

Infelizmente, sua conta neste site está desativada, portanto, a senha não pode ser redefinida. Entre em contato com o administrador do site {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Olá {$a->firstname},

Alguém (provavelmente você) solicitou uma nova senha para sua conta em \'{$a->sitename}\'.

Infelizmente as senhas não podem ser modificadas neste site, por favor contate o administrador {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Modificar informação da senha';
$string['emailpasswordconfirmation'] = '{$a->firstname},

Alguém (provavelmente você) pediu para mudar a senha da sua conta em \'{$a->sitename}\'.

Para confirmar este pedido e receber a nova senha via Email, vá ao seguinte endereço web:

{$a->link}

Na maioria do programas de Email este é um link azul que você pode ativar clicando em cima.

Se isto não funcionar, você pode copiar este link na barra de endereços do seu navegador.

Se você precisar de ajuda, por favor contate o administrador do site,

{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Confirmação de alteração de senha';
$string['emailpasswordconfirmmaybesent'] = '<p>Se o nome de usuário ou o email estiverem corretos, um email deve ter sido enviado a você.</p>
<p>Este email contém instruções simples para confirmar e completar a alteração de senha.
Em caso de dificuldades, contate o administrador do site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> A conta de usuário que você especificou não tem um endereço de e-mail registrado. </p><p> Por favor, contate o administrador do site. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> O detalhe de usuário fornecido não identifica uma conta de usuário existente. </p><p> Por favor, verifique as informações digitadas, em seguida, tente novamente. Se você continuar a ter dificuldades, por favor, contate o administrador do site. </p>';
$string['emailpasswordconfirmsent'] = '<p>Um email será enviado para o seu endereço: <b>{$a}</b>.</p> <p>Siga as instruções contidas no email para completar a mundança de senha. Em caso de dificuldades contate o administrador do site.</p><p>Caso você não veja este email na sua caixa de entrada, por favor, procure por ele na pasta de lixo eletrônico.</p>';
$string['emailpasswordsent'] = '<p>Um Email com a sua nova senha foi enviada ao seguinte endereço: <b>{$a->email}</b>.</p>
<p>A nova senha foi criada automaticamente. Se você quiser, é possível <a href={$a->link}>mudar a senha</a>.</p>';
$string['emailresetconfirmation'] = 'Oi {$a->firstname},

Um pedido de redefinição de senha foi solicitada para a sua conta \'{$a->username}\' no site {$a->sitename}.

Para confirmar este pedido e definir uma nova senha para sua conta, por favor, acesse o seguinte link:

{$a->link}
(Este link é válido por {$a->resetminutes} minutos a partir do momento que esta redefinição foi solicitada)

Se esta redefinição de senha não foi solicitada por você, ignore este e-mail.

Se precisar de ajuda, entre em contato com o administrador,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: pedido de redefinição de senha';
$string['emailresetconfirmsent'] = 'Uma mensagem foi enviada para o email de <b>{$a}.</b> <br /> Ele contém instruções fáceis para confirmar e completar esta alteração de senha. Se você continuar a ter dificuldades, contate o administrador do site.';
$string['emailstop'] = 'Desabilitar notificações';
$string['emailtoprivatefiles'] = 'Você também pode enviar um e-mail com arquivos anexos direto para o seus arquivos privados. Basta anexar seus arquivos a um e-mail e enviá-lo para {$a}';
$string['emailtoprivatefilesdenied'] = 'O administrador desabilitou a opção de fazer upload de seus próprios arquivos privados.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Atividades';
$string['emojicategoryanimalsnature'] = 'Animais e natureza';
$string['emojicategoryflags'] = 'Bandeiras';
$string['emojicategoryfooddrink'] = 'Comidas e bebidas';
$string['emojicategoryobjects'] = 'Objetos';
$string['emojicategoryrecent'] = 'Recente';
$string['emojicategorysmileyspeople'] = 'Smileys e pessoas';
$string['emojicategorysymbols'] = 'Símbolos';
$string['emojicategorytravelplaces'] = 'Viagens e lugares';
$string['emptydragdropregion'] = 'região vazia';
$string['enable'] = 'Habilitar';
$string['encryptedcode'] = 'Código criptografado';
$string['enddate'] = 'Data de término do curso';
$string['enddate_help'] = 'A data de término do curso é usada para determinar se um curso deve ser incluído na lista de curso do usuário. Quando a data de término tiver passado, o curso já não é mais listado na navegação e é listado como finalizado no resumo de cursos. A data de término do curso também pode ser usada para relatórios customizados. Usuários ainda podem acessar o curso depois da data de término; em outras palavras, a data não restringe o acesso.';
$string['english'] = 'Inglês';
$string['enrolmentmethods'] = 'Métodos de inscrição';
$string['entercourse'] = 'Clique para entrar neste curso';
$string['enteremail'] = 'Insira seu endereço de e-mail';
$string['enteremailaddress'] = 'Escreva o seu endereço de email para reconfigurar a sua senha e recebê-la via correio eletrônico.';
$string['enterusername'] = 'Insira sua identificação de usuário';
$string['entries'] = 'Items';
$string['error'] = 'Erro';
$string['errorcreatingactivity'] = 'Não foi possível criar uma instância da atividade \'{$a}\'';
$string['errorfiletoobig'] = 'O arquivo era maior que o limite de {$a} bytes';
$string['errornouploadrepo'] = 'Não há repositório de upload habilitado para este site';
$string['errorwhenconfirming'] = 'Não foi possível completar a confirmação.
Se você chegou aqui a partir de um link em um email, pode ser que a linha de endereço do link tenha sido alterada pelo programa de correio eletrônico. Neste caso, tente copiar o link inteiro e colocar na barra de endereços de um navegador para que o percurso seja reconstruído de modo correto.';
$string['eventcommentcreated'] = 'Comentário criado';
$string['eventcommentdeleted'] = 'Comentário excluído';
$string['eventcommentsviewed'] = 'Comentários vistos';
$string['eventconfiglogcreated'] = 'Log de configuração criado';
$string['eventcontentviewed'] = 'Conteúdo visualizado';
$string['eventcoursebackupcreated'] = 'Backup do curso criado';
$string['eventcoursecategorycreated'] = 'Categoria criada';
$string['eventcoursecategorydeleted'] = 'Categoria deletada';
$string['eventcoursecategoryupdated'] = 'Categoria atualizada';
$string['eventcoursecategoryviewed'] = 'Categoria visualizada';
$string['eventcoursecontentdeleted'] = 'Conteúdo do curso deletado';
$string['eventcoursecreated'] = 'Curso criado';
$string['eventcoursedeleted'] = 'Curso deletado';
$string['eventcourseinformationviewed'] = 'Sumário do curso visualizado';
$string['eventcoursemodulecreated'] = 'Módulo de curso criado';
$string['eventcoursemoduledeleted'] = 'Módulo de curso excluído';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista de instâncias de módulos de cursos visualizados';
$string['eventcoursemoduleupdated'] = 'Módulo de curso atualizado';
$string['eventcoursemoduleviewed'] = 'Módulo do curso visualizado';
$string['eventcourseresetended'] = 'Redefinição curso terminou';
$string['eventcourseresetstarted'] = 'Redefinição curso começou';
$string['eventcourserestored'] = 'Curso restaurado';
$string['eventcoursesectioncreated'] = 'Seção do curso criada';
$string['eventcoursesectiondeleted'] = 'Seção do curso excluída';
$string['eventcoursesectionupdated'] = 'Tópico de curso atualizado';
$string['eventcoursessearched'] = 'Cursos pesquisados';
$string['eventcourseupdated'] = 'Curso atualizado';
$string['eventcourseuserreportviewed'] = 'Relatório de um utilizador do curso visualizado';
$string['eventcourseviewed'] = 'Curso visto';
$string['eventdashboardreset'] = 'Reiniciar painel';
$string['eventdashboardsreset'] = 'Reiniciar painéis';
$string['eventdashboardviewed'] = 'Painel visualizado';
$string['eventdatabasetextfieldcontentreplaced'] = 'Pesquisa e substituição global do banco de dados';
$string['eventemailfailed'] = 'Falha ao enviar email';
$string['eventname'] = 'Nome do evento';
$string['eventrecentactivityviewed'] = 'Atividade recente visualizado';
$string['eventsearchindexed'] = 'Pesquisar nos dados indexados';
$string['eventsearchresultsviewed'] = 'Resultados de pesquisa visualizados';
$string['eventunknownlogged'] = 'Evento desconhecido';
$string['eventusercreated'] = 'Usuário criado';
$string['eventuserdeleted'] = 'Usuário apagado';
$string['eventuserfeedbackgiven'] = 'Link de feedback clicado';
$string['eventuserfeedbackremind'] = 'Lembrar-me depois de clicar no link de feedback';
$string['eventuserinfocategorycreated'] = 'Categoria de campo de perfil de usuário criada';
$string['eventuserinfocategorydeleted'] = 'Categoria de campo de perfil de usuário excluída';
$string['eventuserinfocategoryupdated'] = 'Categoria de campo de perfil de usuário atualizada';
$string['eventuserinfofieldcreated'] = 'Campo de perfil de usuário criado';
$string['eventuserinfofielddeleted'] = 'Campo de perfil de usuário excluído';
$string['eventuserinfofieldupdated'] = 'Campo de perfil de usuário atualizado';
$string['eventuserlistviewed'] = 'Lista de usuários vistos';
$string['eventuserloggedout'] = 'Usuário deslogou';
$string['eventuserpasswordpolicyfailed'] = 'A senha do usuário não atende à política de senhas.';
$string['eventuserpasswordupdated'] = 'Senha de usuário atualizada';
$string['eventuserprofileviewed'] = 'Perfil do usuário visto';
$string['eventuserupdated'] = 'Usuário atualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Executar em';
$string['existing'] = 'Atuais';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Cursos existentes';
$string['existingcourseadding'] = 'Curso existente, adicionando dados a ele';
$string['existingcoursedeleting'] = 'Curso existente, após excluir seus dados';
$string['existingcreators'] = 'Criadores de cursos existentes';
$string['existingstudents'] = 'Participantes inscritos';
$string['existingteachers'] = 'Professores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir tudo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicação';
$string['explanationdigitalminor'] = 'Essas informações são necessárias para determinar se sua idade é superior a idade digital de consentimento. Essa é a idade em que um indivíduo pode consentir que os termos e condições e seus dados sejam legalmente armazenados e processados.';
$string['extendperiod'] = 'Período estendido';
$string['extendsession'] = 'Prolongar a sessão';
$string['failedloginattempts'] = '{$a->attempts} erros de login desde o seu último acesso';
$string['favourites'] = 'Favoritos';
$string['feedback'] = 'Feedback';
$string['file'] = 'Arquivo';
$string['fileexists'] = 'Já existe um arquivo chamado {$a}';
$string['filemissing'] = '{$a} está faltando';
$string['filereaderror'] = 'Não é possível ler o arquivo {$a}. Por favor, verifique se é realmente um arquivo e não uma pasta.';
$string['files'] = 'Arquivos';
$string['filesanduploads'] = 'Arquivos e uploads';
$string['filesfolders'] = 'Arquivos/diretórios';
$string['fileuploadwithcontent'] = 'Envios de arquivo não podem incluir o parâmetro conteúdo';
$string['filloutallfields'] = 'Por favor, preencha todos os campos do formulário';
$string['filter'] = 'Filtrar';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'Filtros';
$string['findmorecourses'] = 'Buscar mais cursos...';
$string['first'] = 'Primeiro';
$string['firstaccess'] = 'Primeiro acesso';
$string['firstname'] = 'Nome';
$string['firstnamephonetic'] = 'Nome - fonético';
$string['firstpage'] = 'Primeira página';
$string['firstsiteaccess'] = 'Primeiro acesso ao site';
$string['firsttime'] = 'Esta é a sua primeira vez aqui?';
$string['folder'] = 'Pasta';
$string['folderclosed'] = 'Pasta fechada';
$string['folderopened'] = 'Pasta aberta';
$string['followingoptional'] = 'Os seguintes dados são opcionais';
$string['followingrequired'] = 'Os seguintes dados são obrigatórios';
$string['for'] = 'Para';
$string['force'] = 'Forçar';
$string['forcelanguage'] = 'Forçar idioma';
$string['forceno'] = 'Não forçar';
$string['forcepasswordchange'] = 'Forçar mudança de senha';
$string['forcepasswordchange_help'] = 'Avisa o usuário que deve modificar a password no próximo acesso ao site.';
$string['forcepasswordchangecheckfull'] = 'Você tem absoluta certeza que você quer forçar uma troca de senha para {$a} ?';
$string['forcepasswordchangenot'] = 'Não foi possível forçar a mudança de senha para {$a}';
$string['forcepasswordchangenotice'] = 'Você tem que mudar a senha antes de continuar';
$string['forcepasswordresetfailurenotice'] = 'Sua senha atual não atende mais à política de senhas adotada. Por favor, entre em contato com o administrador do Moodle para suporte.
   {$a}';
$string['forcepasswordresetnotice'] = 'Sua senha atual não atende mais à política de senhas adotada, você deve redefinir sua senha para acessar.
   {$a}';
$string['forcetheme'] = 'Forçar tema';
$string['forgotaccount'] = 'Perdeu a senha?';
$string['forgotten'] = 'Esqueceu o seu usuário ou senha?';
$string['forgottenduplicate'] = 'Este endereço email é compartilhado por diversas contas, por favor insira o "usuário"';
$string['forgotteninvalidurl'] = 'URL para reconfiguração de senha inválida';
$string['format'] = 'Formato';
$string['format_help'] = 'O formato de curso determina o layout da página do curso.

* Formato de atividade única - Para mostrar apenas uma atividade ou recurso (como um Quiz ou um pacote SCORM) na página do curso
* Formato social - Um fórum é mostrado na página do curso
* Formato tópicos - A página do curso é organizada em seções de tópicos
* Formato semanal - A página do curso é organizada em seções semanais, com a primeira semana começando na data de início do curso';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato MARKDOWN';
$string['formatplain'] = 'Formato TEXT';
$string['formattext'] = 'Formato  Automático';
$string['forumpreferences'] = 'Preferências do fórum';
$string['framesetinfo'] = 'Este documento frameset contém:';
$string['from'] = 'De';
$string['frontpagecategorycombo'] = 'Menu Drop-down';
$string['frontpagecategorynames'] = 'Lista de categorias';
$string['frontpagecourselist'] = 'Lista de cursos';
$string['frontpagecoursesearch'] = 'Caixa de pesquisa do curso';
$string['frontpagedescription'] = 'Descrição da página principal';
$string['frontpagedescriptionhelp'] = 'Esta descrição pode ser mostrada na página principal utilizando o bloco descrição de curso/site.';
$string['frontpageenrolledcourselist'] = 'Cursos inscritos';
$string['frontpageformat'] = 'Formato da página inicial';
$string['frontpageformatloggedin'] = 'Formato da página inicial depois do login';
$string['frontpagenews'] = 'Avisos';
$string['frontpagesettings'] = 'Configurações da página inicial';
$string['fulllistofcourses'] = 'Todos os cursos';
$string['fullname'] = 'Nome completo';
$string['fullnamecourse'] = 'Nome completo do curso';
$string['fullnamecourse_help'] = 'O nome completo do curso é apresentado no topo de cada página do curso e na lista de cursos.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nome completo';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nome completo do site';
$string['functiondisabled'] = 'Esta funcionalidade está desabilitada';
$string['general'] = 'Geral';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Obter estes logs';
$string['go'] = 'Ok';
$string['gpl'] = 'Copyright (C) 1999 em diante Martin Dougiamas (http://moodle.com)

Este programa é um software livre; você pode redistribuí-lo e/ou modificá-lo sob os termos da GNU General Public License como publicado pela Free Software Foundation; tanto na versão 2 da Licença, ou (a seu critério) qualquer versão posterior.

Este programa é distribuído na esperança que possa ser útil,
mas SEM QUALQUER GARANTIA; sem mesmo a garantia implícita de COMERCIALIZAÇÃO ou ADEQUAÇÃO PARA UM DETERMINADO PROPÓSITO.

Veja a página de informações sobre a licença do Moodle para detalhes completos em:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 em diante Martin Dougiamas (http://moodle.com)

Este programa é um software livre; você pode redistribuí-lo e/ou modificá-lo sob os termos da GNU General Public License como publicado pela Free Software Foundation; tanto na versão 3 da Licença, ou (a seu critério) qualquer versão posterior.

Este programa é distribuído na esperança que possa ser útil,
mas SEM QUALQUER GARANTIA; sem mesmo a garantia implícita de COMERCIALIZAÇÃO ou ADEQUAÇÃO PARA UM DETERMINADO PROPÓSITO.

Veja a página de informações sobre a licença do Moodle para detalhes completos em:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'Licença GPL';
$string['grade'] = 'Nota';
$string['grades'] = 'Notas';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> foi habilitado neste site. Se você não enviar uma imagem de perfil, o Moodle tentará carregar uma imagem de perfil para você a partir do Gravatar.';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Adicionar novo grupo';
$string['groupaddusers'] = 'Adicionar grupo selecionado';
$string['groupfor'] = 'por grupo';
$string['groupinfo'] = 'Informações sobre o grupo selecionado';
$string['groupinfoedit'] = 'Editar configurações de grupos';
$string['groupinfomembers'] = 'Info sobre membros selecionados';
$string['groupinfopeople'] = 'Info sobre pessoas selecionadas';
$string['groupmembers'] = 'Membros dos grupos';
$string['groupmemberssee'] = 'Ver participantes do grupo';
$string['groupmembersselected'] = 'Membros do grupo selecionado';
$string['groupmode'] = 'Tipo de Grupo';
$string['groupmodeforce'] = 'Forçar tipo de grupo';
$string['groupmy'] = 'Meu grupo';
$string['groupnonmembers'] = 'Pessoas que não estão em grupos';
$string['groupnotamember'] = 'Sinto muito, você não é participante deste grupo';
$string['grouprandomassign'] = 'Designar todos a grupos aleatoriamente';
$string['groupremove'] = 'Remover grupo selecionado';
$string['groupremovemembers'] = 'Remover membros selecionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'Nenhum grupo';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visíveis';
$string['guest'] = 'Visitante';
$string['guestdescription'] = 'Visitantes tem privilégios mínimos e não podem publicar textos.';
$string['guestskey'] = 'Permitir o acesso a visitantes que conhecem o código de inscrição';
$string['guestsno'] = 'Não permitir o acesso de visitantes';
$string['guestsnotallowed'] = 'Sinto muito, não é permitida a entrada de visitantes em \'{$a}\'.';
$string['guestsyes'] = 'Permitir o acesso de visitantes, mesmo sem o código de inscrição';
$string['guestuser'] = 'Usuário visitante';
$string['guestuserinfo'] = 'Este é um tipo de usuário especial que tem acesso a alguns curso com permissão limitada à leitura.';
$string['help'] = 'Ajuda';
$string['helpprefix2'] = 'Ajuda com {$a}';
$string['helpwiththis'] = 'Ajudar';
$string['hiddenassign'] = 'Atribuição oculta';
$string['hiddenfromstudents'] = 'Oculto para estudantes';
$string['hiddenoncoursepage'] = 'Disponível mas não mostrado na página do curso';
$string['hiddensections'] = 'Seções escondidas';
$string['hiddensections_help'] = '<P>Estas opções permitem que você decida como seções ocultas no seu curso serão exibidas para os estudantes.</p>

<p>A opção padrão define que as seções aparecerão aos estudantes com a área das atividades contraída e com a cor da seção alterada. A seção é visualizada mas os conteúdos da seção ficam ocultos. Isto pode ser útil em cursos com o formato semanal, para indicar semanas de férias, por exemplo.
</p>

<p>Se você escolher a outra opção, "seções ocultas são completamente invisíveis", as seções não serão visualizadas enquanto forem marcadas como ocultas.
</p>';
$string['hiddensectionscollapsed'] = 'Seções escondidas são mostradas contraídas';
$string['hiddensectionsinvisible'] = 'Seções escondidas são completamente invisíveis';
$string['hiddenwithbrackets'] = '(invisível)';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar configurações avançadas';
$string['hidechartdata'] = 'Ocultar dados do gráfico';
$string['hidefromstudents'] = 'Ocultar dos estudantes';
$string['hideoncoursepage'] = 'Disponibilizar mas não mostrar na página do curso';
$string['hidepicture'] = 'Ocultar imagem';
$string['hidepopoverwindow'] = 'Ocultar janela popover';
$string['hidesection'] = 'Ocultar seção {$a}';
$string['hidesettings'] = 'Ocultar configurações';
$string['hideshowblocks'] = 'Esconder ou mostrar blocos';
$string['highlight'] = 'Realçar';
$string['highlightoff'] = 'Remover realce';
$string['hits'] = 'Hits';
$string['hitsoncourse'] = 'Hits em {$a->coursename} por {$a->username}';
$string['hitsoncoursetoday'] = 'Hits de hoje em {$a->coursename} por {$a->username}';
$string['home'] = 'Página inicial';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Como criar novos temas';
$string['htmleditor'] = 'Usar editor HTML';
$string['htmleditoravailable'] = 'O editor de HTML está disponível';
$string['htmleditordisabled'] = 'Você desabilitou o editor de HTML na página de edição de perfil do usuário';
$string['htmleditordisabledadmin'] = 'O administrador desabilitou o uso do editor de HTML neste site';
$string['htmleditordisabledbrowser'] = 'O editor de HTML não está disponível porque seu navegador não é compatível com o mesmo.';
$string['htmlfilesonly'] = 'Apenas arquivos HTML';
$string['htmlformat'] = 'Formato  HTML';
$string['icon'] = 'Ícone';
$string['icqnumber'] = 'Número de ICQ';
$string['idnumber'] = 'Número de identificação';
$string['idnumbercourse'] = 'Número de identificação do curso';
$string['idnumbercourse_help'] = '<P>O ID de um curso é usado apenas nos processos de comunicação com sistemas externos - não é visualizado na interface do curso.  Se você tem um código oficial de identificação do curso, utilize-o para preencher este campo. Em caso contrário, deixe o campo vazio.
</p>';
$string['idnumbercoursecategory'] = 'Número ID da categoria';
$string['idnumbercoursecategory_help'] = 'O número ID de uma categoria de curso é utilizado apenas quando comparando a categoria com sistemas externos e não é exibido em nenhum local no site. Caso a categoria possua um código oficial isto pode ser inserido, caso contrário o campo pode ser deixado em branco.';
$string['idnumbergroup'] = 'ID interno do grupo';
$string['idnumbergroup_help'] = 'O ID interno de um grupo é usado somente quando for necessário relacioná-lo com sistemas externos, não sendo exibido em nenhum lugar. Em geral este campo pode ser deixado em branco.';
$string['idnumbergrouping'] = 'ID interno do agrupamento';
$string['idnumbergrouping_help'] = 'O ID interno de um agrupamento é usado somente quando for necessário relacioná-lo com sistemas externos, não sendo exibido em nenhum lugar. Em geral este campo pode ser deixado em branco.';
$string['idnumbermod'] = 'Número de identificação do módulo';
$string['idnumbermod_help'] = 'Definir um número de ID ajuda a identificar a atividade ou recursos para propósitos como cálculo de notas ou relatórios customizados. Caso contrário pode ficar em branco.

Para atividades avaliativas, o número de ID pode ser definido no livro de notas, porém só pode ser editado na página de configurações da atividade.';
$string['idnumbertaken'] = 'Este número de identificação já está sendo usado';
$string['imagealt'] = 'Descrição da imagem';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar dados do curso';
$string['importdataexported'] = 'Os dados do curso de origem foram exportados com sucesso.<br />
Continue com a importação dos dados no curso de destino.';
$string['importdatafinished'] = 'Importação concluída! Siga para o seu curso';
$string['importdatafrom'] = 'Buscar um curso para importar os seus dados:';
$string['inactive'] = 'Inativo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir todos os usuários';
$string['includecoursefiles'] = 'Incluir os arquivos dos cursos';
$string['includecourseusers'] = 'Incluir os usuários dos cursos';
$string['included'] = 'Incluídos';
$string['includelogentries'] = 'Incluir registros de log';
$string['includemodules'] = 'Incluir módulos';
$string['includemoduleuserdata'] = 'Incluir dados dos usuários do módulo';
$string['includeneededusers'] = 'Incluir usuários necessários';
$string['includenoneusers'] = 'Não incluir usuários';
$string['includeroleassignments'] = 'Incluir atribuições de papéis';
$string['includesitefiles'] = 'Incluir arquivos do site usados neste curso';
$string['includeuserfiles'] = 'Incluir arquivos de usuário';
$string['increasesections'] = 'Aumentar o número de tópicos';
$string['indicator:accessesafterend'] = 'Curso acessado depois da data de término';
$string['indicator:accessesafterend_help'] = 'Este indicador reflete se o estudante acessou o curso depois da data de fim do curso.';
$string['indicator:accessesbeforestart'] = 'Curso acessado antes da data de início';
$string['indicator:accessesbeforestart_help'] = 'Este indicador reflete se o estudante acessou o curso antes da data de início do curso.';
$string['indicator:activitiesdue'] = 'Atividades agendadas';
$string['indicator:activitiesdue_help'] = 'O usuário possui atividades agendadas.';
$string['indicator:anycourseaccess'] = 'Qualquer acesso ao curso';
$string['indicator:anycourseaccess_help'] = 'Este indicador reflete o acesso a qualquer curso que o usuário está inscrito.';
$string['indicator:anywrite'] = 'Qualquer ação de escrita';
$string['indicator:anywrite_help'] = 'Este indicador representa qualquer ação de escrita (envio) realizada pelo estudante.';
$string['indicator:anywriteincourse'] = 'Qualquer ação de escrita no curso';
$string['indicator:anywriteincourse_help'] = 'Este indicador representa qualquer ação de escrita (envio) realizada pelo estudante em qualquer atividade do curso.';
$string['indicator:completeduserprofile'] = 'O perfil do usuário está completo';
$string['indicator:completeduserprofile_help'] = 'Este indicador representa que o estudante completou o seu perfil.';
$string['indicator:completeduserprofiledef'] = 'Perfil de usuário concluído';
$string['indicator:completeduserprofiledef_help'] = 'As políticas do site foram acordadas e o usuário preencheu os seguintes campos: Instituição, Departamento, Endereço, Cidade, País, URL.';
$string['indicator:completionenabled'] = 'Acompanhamento de conclusão habilitado';
$string['indicator:completionenabled_help'] = 'Este indicador representa que o acompanhamento de conclusão foi habilitado para este curso.';
$string['indicator:nostudent'] = 'Inscrições de estudantes';
$string['indicator:nostudent_help'] = 'Este indicador reflete que a disponibilidade de estudantes no curso';
$string['indicator:noteacher'] = 'Disponibilidade de professores';
$string['indicator:noteacher_help'] = 'Este indicador reflete a disponibilidade de professores no curso.';
$string['indicator:potentialcognitive'] = 'Profundidade do potencial cognitivo do curso';
$string['indicator:potentialcognitive_help'] = 'Este indicador é baseado no potencial da profundidade cognitiva que pode ser alcançada por um estudante participando das atividades do curso.';
$string['indicator:potentialcognitivedef'] = 'Potencial amplitude cognitiva do curso';
$string['indicator:potentialcognitivedef_help'] = 'O grau em que o curso oferece um envolvimento cognitivo "profundo", por exemplo, envio de trabalho para feedback, a oportunidade de revisar o trabalho de outras pessoas e a oportunidade de revisar e reenviar o trabalho.';
$string['indicator:potentialsocial'] = 'Potencial amplitude social do curso';
$string['indicator:potentialsocial_help'] = 'Este indicador é baseado no potencial da amplitude social que pode ser alcançada por um estudante participando das atividades do curso.';
$string['indicator:potentialsocialdef'] = 'Potencial amplitude social do curso';
$string['indicator:potentialsocialdef_help'] = 'O grau em que o curso oferece um envolvimento social "amplo", interagindo com outros participantes e com a comunidade alvo fora da sala de aula.';
$string['indicator:readactions'] = 'Quantidade de ações de leitura';
$string['indicator:readactions_help'] = 'Este indicador representa a quantidade de ações de leitura (visualização) feitas pelo estudante.';
$string['indicator:userforumstracking'] = 'O usuário está monitorando fóruns';
$string['indicator:userforumstracking_help'] = 'Este indicador revela se o estudante tem ou não o monitoramento ativado nos fóruns.';
$string['info'] = 'Informação';
$string['institution'] = 'Instituição';
$string['instudentview'] = 'na visão do estudante';
$string['interests'] = 'Interesses';
$string['interestslist'] = 'Lista de interesses';
$string['interestslist_help'] = 'Digite seus interesses, um por um, que será, então, exibido em sua página de perfil como tags.';
$string['invalidemail'] = 'Endereço de email inválido';
$string['invalidlogin'] = 'Nome de usuário ou senha errados. Por favor tente outra vez.';
$string['invalidusername'] = 'O nome de usuário pode conter apenas caracteres minúsculos alfanuméricos (letras e números), sublinhado (_), hífen (-), ponto (.) ou símbolo arroba (@).';
$string['invalidusernameupload'] = 'Identificação de usuário inválida';
$string['ip_address'] = 'endereço IP';
$string['jump'] = 'Seguir';
$string['jumpto'] = 'Seguir para...';
$string['keep'] = 'Manter';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Leitura da esquerda para a direita';
$string['langrtl'] = 'Leitura da direita para a esquerda';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Os arquivos deste idioma estão atualizados!  : -)';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acesso';
$string['lastcourseaccess'] = 'Último acesso ao curso';
$string['lastedited'] = 'Última edição';
$string['lastip'] = 'Último endereço de IP';
$string['lastlogin'] = 'Último acesso';
$string['lastmodified'] = 'Última atualização';
$string['lastname'] = 'Sobrenome';
$string['lastnamephonetic'] = 'Sobrenome - fonético';
$string['lastpage'] = 'Última página';
$string['lastsiteaccess'] = 'Último acesso ao site';
$string['lastyear'] = 'Ano passado';
$string['latestlanguagepack'] = 'Procure os últimos arquivos deste idioma em moodle.org';
$string['layouttable'] = 'Tabela de layout';
$string['leavetokeep'] = 'Deixe o espaço em branco para manter a senha atual';
$string['legacylogginginuse'] = 'Este site atualmente tem a escrita no armazenamento de log legado habilitado. A escrita neste armazenamento de log será descontinuada. Por favor, escreva em um sistema de log suportado, como "padrão" ou "externo".';
$string['legacythemeinuse'] = 'Este site está sendo exibido em modo de compatibilidade porque o seu navegador é muito antigo.';
$string['license'] = 'Licença';
$string['licenses'] = 'Licenças';
$string['liketologin'] = 'Você quer entrar agora fazendo o login com uma conta de usuário?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de arquivos em {$a}';
$string['listofallpeople'] = 'Lista de todas as pessoas';
$string['listofcourses'] = 'Lista de cursos';
$string['loading'] = 'Carregando';
$string['loadinghelp'] = 'Carregando...';
$string['local'] = 'Local';
$string['localplugins'] = 'Plugins locais';
$string['localpluginsmanage'] = 'Gerenciar plugins locais';
$string['location'] = 'Localização';
$string['locktimeout'] = 'A operação esgotou o tempo de espera por um "lock".';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Você acessou como {$a}';
$string['loggedinasguest'] = 'Você acessou como visitante';
$string['loggedinnot'] = 'Você ainda não se identificou.';
$string['login'] = 'Acessar';
$string['login_failure_logs'] = 'Relatório dos erros de identificação (login)';
$string['loginactivity'] = 'Atividade de login';
$string['loginalready'] = 'Você já se identificou';
$string['loginas'] = 'Acessar como';
$string['loginaspasswordexplain'] = '<p>Você tem que usar uma senha especial dada pelo administrador para "acessar como" antes de fazer isto.</p>';
$string['loginguest'] = 'Acessar como visitante';
$string['loginsite'] = 'Acesso ao site';
$string['loginsteps'] = 'Para ter acesso completo a este site, você primeiro precisa criar uma conta.';
$string['loginstepsnone'] = '<p>Olá!</p> <p>Para o acesso aos cursos você precisa ser cadastrado como usuário do site.</p><p>Para fazer isto, basta completar o formulário desta página escolhendo um usuário e uma senha que você queira usar.</p><p>Se alguém já tiver escolhido o mesmo usuário, você vai tentar novamente escolhendo um usuário diferente.</p>';
$string['loginto'] = 'Acesso a {$a}';
$string['logoof'] = '{a} logo';
$string['logout'] = 'Sair';
$string['logoutconfirm'] = 'Você quer realmente fazer o logout?';
$string['logs'] = 'Logs';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mais</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mais</a> ]';
$string['lookback'] = 'Ver últimos';
$string['mailadmins'] = 'Informar administradores';
$string['mailstudents'] = 'Informar estudantes';
$string['mailteachers'] = 'Informar professores';
$string['maincoursepage'] = 'Página principal do curso';
$string['makeafolder'] = 'Criar diretório';
$string['makeavailable'] = 'Disponibilizar';
$string['makeeditable'] = 'Se for permitido que \'{$a}\' seja editado pelo processo de servidor de rede (es. apache), será possível editar este arquivo usando esta página.';
$string['makethismyhome'] = 'Tornar esta página a minha página inicial';
$string['makeunavailable'] = 'Indisponibilizar';
$string['manageblocks'] = 'Blocos';
$string['managecategorythis'] = 'Gerenciar esta categoria';
$string['managecontentbanktypes'] = 'Gerenciar tipos de conteúdo';
$string['managecourses'] = 'Gerenciar cursos';
$string['managedatabase'] = 'Base de Dados';
$string['managedataformats'] = 'Gerenciar formatos de dados';
$string['manageeditorfiles'] = 'Gerenciar arquivos usados pelo editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Módulos';
$string['manageroles'] = 'Papéis e permissões';
$string['markallread'] = 'Marcar tudo como lido';
$string['markedthistopic'] = 'Este tópico está marcado como tópico corrente';
$string['markthistopic'] = 'Marque este tópico como o tópico corrente';
$string['matchingsearchandrole'] = 'Encontrando \'{$a->search}\' e {$a->role}';
$string['maxareabytesreached'] = 'O arquivo (ou o tamanho total de vários arquivos) é maior do que o espaço restante nesta área.';
$string['maxfilesize'] = 'Tamanho máximo para novos arquivos: {$a}';
$string['maxfilesreached'] = 'Você pode anexar um máximo de {$a} arquivo(s) a este item';
$string['maximumchars'] = 'Máximo de {$a} caracteres';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradex'] = 'Nota máxima: {$a}';
$string['maximumshort'] = 'Máximo';
$string['maximumupload'] = 'Tamanho máximo de upload';
$string['maximumupload_help'] = '<P>Estas opções definem o tamanho máximo dos documentos que os estudantes deste curso podem enviar ao servidor, dentro dos limites globais estabelecidos pelo administrador do site.</p>

<P>É possível definir outros critérios de restrição do tamanho dos documentos na configuração de cada atividade.</p>';
$string['maxnumberweeks'] = 'Número máximo de seções';
$string['maxnumberweeks_desc'] = 'O valor máximo no menu "número de seções" (aplicável apenas a alguns formatos de curso).';
$string['maxnumcoursesincombo'] = 'Navegar em <a href="{$a->link}">{$a->numberofcourses} cursos</a>.';
$string['maxsectionslimit'] = 'Não é possível criar uma nova seção, pois ela pode exceder o número máximo de seções permitidas para este curso ({$a}).';
$string['maxsize'] = 'Tamanho máximo: {$a}';
$string['maxsizeandareasize'] = 'Tamanho máximo para novos arquivos:  {$a->size}, geral: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamanho máximo para arquivos: {$a->size}, número máximo de anexos: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'O tamanho máximo de cada arquivo: {$a->size}, número máximo de arquivos: {$a->attachments}, tamanho máximo total: {$a->areasize}';
$string['memberincourse'] = 'Participantes';
$string['messagebody'] = 'Texto da mensagem';
$string['messagedselectedusers'] = 'A mensagem foi enviada para os usuários selecionados e a lista de destinatários foi esvaziada.';
$string['messagedselectedusersfailed'] = 'Erro durante o envio de mensagens aos usuários selecionados. Alguns podem ter recebido a mensagem.';
$string['messageprovider:asyncbackupnotification'] = 'Notificações de backup/restauração assíncronas';
$string['messageprovider:availableupdate'] = 'Notificações de atualização disponível';
$string['messageprovider:backup'] = 'Notificações de backup';
$string['messageprovider:badgecreatornotice'] = 'Notificações para criadores de emblemas';
$string['messageprovider:badgerecipientnotice'] = 'Notificações para destinatários de emblemas';
$string['messageprovider:competencyplancomment'] = 'Comentário postado em um plano de aprendizagem';
$string['messageprovider:competencyusercompcomment'] = 'Comentário postado em uma competência';
$string['messageprovider:coursecompleted'] = 'Curso concluído';
$string['messageprovider:courserequestapproved'] = 'Notificação de pedido de aprovação de criação de curso';
$string['messageprovider:courserequested'] = 'Notificação de pedido de criação de curso';
$string['messageprovider:courserequestrejected'] = 'Notificação de rejeição de pedido de criação de curso';
$string['messageprovider:errors'] = 'Erros importantes com o site';
$string['messageprovider:errors_help'] = 'Este são error importantes que um administrador precisa conhecer.';
$string['messageprovider:gradenotifications'] = 'Notificações de notas';
$string['messageprovider:infected'] = 'Notificações de falha de antivírus.';
$string['messageprovider:insights'] = 'Insights gerados por modelos de previsão';
$string['messageprovider:instantmessage'] = 'Mensagens pessoais entre usuários';
$string['messageprovider:instantmessage_help'] = 'Esta seção configura o que acontece com as mensagens que são enviadas para você diretamente de outros usuários deste site.';
$string['messageprovider:messagecontactrequests'] = 'Notificação de solicitações de contato de mensagem';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Estes são avisos de que um administrador possa estar interessado em ver.';
$string['messageselect'] = 'Selecionar este usuário como destinatário da mensagem';
$string['messageselectadd'] = 'Enviar uma mensagem';
$string['middlename'] = 'Nome do meio';
$string['migratinggrades'] = 'Migrando notas';
$string['min'] = 'minuto';
$string['mins'] = 'minutos';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Miscelânea';
$string['missingcategory'] = 'Você precisa escolher uma categoria';
$string['missingdescription'] = 'Está faltando a descrição';
$string['missingemail'] = 'Está faltando o endereço de email';
$string['missingfirstname'] = 'Está faltando o primeiro nome';
$string['missingfromdisk'] = 'Está faltando no disco';
$string['missingfullname'] = 'Está faltando o nome completo';
$string['missinglastname'] = 'Está faltando o sobrenome';
$string['missingname'] = 'Está faltando o nome';
$string['missingnewpassword'] = 'Está faltando a nova senha';
$string['missingpassword'] = 'Está faltando a senha';
$string['missingrecaptchachallengefield'] = 'O reCAPTCHA falhou, tente novamente.';
$string['missingreqreason'] = 'Está faltando o motivo';
$string['missingshortname'] = 'Está faltando o nome breve';
$string['missingshortsitename'] = 'Está faltando o nome breve do site';
$string['missingsitedescription'] = 'Está faltando a descrição do site';
$string['missingsitename'] = 'Está faltando o nome do site';
$string['missingstrings'] = 'Verificar se existem palavras ou frases não traduzidas';
$string['missingstudent'] = 'Você tem que escolher algo';
$string['missingsummary'] = 'Está faltando o sumário';
$string['missingteacher'] = 'Você deve escolher algo';
$string['missingurl'] = 'Está faltando a URL';
$string['missingusername'] = 'Está faltando a identificação de usuário';
$string['moddoesnotsupporttype'] = 'Módulo {$a->modname} não suporta uploads do tipo {$a->type}';
$string['modhide'] = 'Ocultar';
$string['modified'] = 'Modificado';
$string['modshow'] = 'Mostrar';
$string['moduleintro'] = 'Descrição';
$string['modulesetup'] = 'Configurando as tabelas de módulo';
$string['modulesuccess'] = '{$a} tabelas foram configuradas corretamente';
$string['modulesused'] = 'Módulos usados';
$string['modvisible'] = 'Disponibilidade';
$string['modvisible_help'] = 'Se a disponibilidade estiver definida como "Mostrar na página do curso", a atividade ou recurso está disponível para estudantes (sujeito a restrições de acesso que podem ser definidas).

Se a disponibilidade estiver definida como "Ocultar dos estudantes\', a atividade ou recurso só estará disponível para os usuários com permissão para visualizar atividades ocultas (por padrão, usuários com o papel de professor ou professor não-editor)';
$string['modvisiblehiddensection'] = 'Disponibilidade';
$string['modvisiblehiddensection_help'] = 'Se a disponibilidade estiver definida como \'Ocultar dos estudantes\', a atividade ou recurso só estará disponível para usuários com permissão para visualizar atividades ocultas (por padrão, usuários com a função de professor ou professor não editor).

Se o curso tiver muitas atividades ou recursos, a página do curso pode ser simplificada, definindo a disponibilidade para \'Disponibilizar mas não mostrar na página do curso\'. Neste caso, um link para a atividade ou recurso deve ser disponibilizado em outro lugar, como um recurso da página. A atividade ainda será listada no livro de notas e outros relatórios.';
$string['modvisiblewithstealth'] = 'Disponibilidade';
$string['modvisiblewithstealth_help'] = 'Se a disponibilidade estiver definida como \'Mostrar na página do curso\', a atividade ou recurso está disponível para estudantes (sujeito a restrições de acesso que podem ser definidas).

Se a disponibilidade estiver definida como \'Ocultar dos estudantes\', a atividade ou recurso só estará disponível para usuários com permissão para visualizar atividades ocultas (por padrão, usuários com a função de professor ou professor não editor).

Se o curso tiver muitas atividades ou recursos, a página do curso pode ser simplificada, definindo a disponibilidade para \'Disponibilizar mas não mostrar na página do curso\'. Neste caso, um link para a atividade ou recurso deve ser disponibilizado em outro lugar, como um recurso da página. A atividade ainda será listada no livro de notas e outros relatórios.';
$string['month'] = 'Mês';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Ajuda e documentação';
$string['moodlelogo'] = 'Logotipo Moodle';
$string['moodlerelease'] = 'Moodle release';
$string['moodleversion'] = 'Versão do Moodle';
$string['more'] = 'mais';
$string['morehelp'] = 'Mais ajuda';
$string['morehelpaboutmodule'] = 'Mais ajuda sobre a atividade {$a}';
$string['moreinfo'] = 'Mais informações';
$string['moreinformation'] = 'Outras informações sobre este erro';
$string['morenavigationlinks'] = 'Mais...';
$string['moreprofileinfoneeded'] = 'Por favor diga algo mais sobre você.';
$string['mostrecently'] = 'mais recente';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Movida com sucesso {$a->count} categorias para a categoria \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Movidas {$a->count} categorias para o nível superior';
$string['movecategorycontentto'] = 'Mover para';
$string['movecategorysuccess'] = 'Movida com sucesso a categoria \'{$a->moved}\'  para a categoria \'{$a->to}\'';
$string['movecategoryto'] = 'Mova a categoria para:';
$string['movecategorytotopsuccess'] = 'Movida a categoria \'{$a->moved}\' para o nível superior';
$string['movecontent'] = 'Mover {$a}';
$string['movecontentafter'] = 'Depois de "{$a}"';
$string['movecontentstoanothercategory'] = 'Mover conteúdos para outra categoria';
$string['movecontenttothetop'] = 'Para o topo da lista';
$string['movecoursemodule'] = 'Mover recurso';
$string['movecoursesection'] = 'Mover seção';
$string['movecourseto'] = 'Mova o curso para:';
$string['movedown'] = 'Mover para baixo';
$string['movefilestohere'] = 'Mover os arquivos para cá';
$string['movefull'] = 'Mover {$a} para este lugar';
$string['movehere'] = 'Mover para cá';
$string['moveleft'] = 'Mover para a esquerda';
$string['moveright'] = 'Mover para a direita';
$string['movesection'] = 'Mover seção {$a}';
$string['moveselectedcategoriesto'] = 'Mova categorias selecionadas para';
$string['moveselectedcoursesto'] = 'Mover cursos selecionados para...';
$string['movetoanotherfolder'] = 'Mover para outra pasta';
$string['moveup'] = 'Mover para cima';
$string['msnid'] = 'ID MSN';
$string['mustchangepassword'] = 'A nova senha deve ser diferente da senha atual';
$string['mustconfirm'] = 'Você precisa confirmar sua conta';
$string['mycourses'] = 'Meus cursos';
$string['myfiles'] = 'Meus arquivos privados';
$string['myfilesmanage'] = 'Gerenciar meus arquivos privados';
$string['myhome'] = 'Painel';
$string['mymoodledashboard'] = 'Painel do meu Moodle';
$string['myprofile'] = 'Meu perfil';
$string['name'] = 'Nome';
$string['namedfiletoolarge'] = 'O arquivo \'{$a->filename}\' é muito grande e não pode ser carregado';
$string['nameforlink'] = 'Como você quer chamar este link?';
$string['nameforpage'] = 'Nome';
$string['navigation'] = 'Navegação';
$string['needed'] = 'Necessário';
$string['networkdropped'] = 'Nós detectamos que sua conexão com a internet não é confiável ou foi interrompida.<br/>
Por favor, tenha esteja ciente que algumas mudanças podem não ser devidamente gravadas até que a sua conexão melhore.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca apague os logs';
$string['new'] = 'Novo';
$string['newaccount'] = 'Nova conta';
$string['newactivityname'] = 'Novo nome para a atividade {$a}';
$string['newcourse'] = 'Novo curso';
$string['newpassword'] = 'Nova senha';
$string['newpassword_help'] = 'Deixar em branco para manter a senha atual.';
$string['newpasswordfromlost'] = '<strong>AVISO:</strong> A sua <strong>senha atual</strong> será enviada no <strong>segundo</strong> dos dois emails emitidos neste processo de recuperação de senha. Certifique-se que você recebeu a senha substituta antes de continuar.';
$string['newpasswordtext'] = 'Olá {$a->firstname},

A senha de sua conta em \'{$a->sitename}\' foi redefinida e você recebeu uma senha provisória:

Seus dados atuais para login são agora:
nome de usuário: {$a->username}
senha: {$a->newpassword}

Por favor visite a seguinte página para modificar sua senha:
{$a->link}

Na maior parte dos programas de email a frase anterior aparece como um link azul que você pode clicar. Se este não é o seu caso, copie o endereço para a barra de endereços do seu navegador.

Saudações do administrador do \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nova imagem';
$string['newpicture_help'] = 'Para adicionar uma nova imagem, navegue e selecione uma imagem (em formato JPG ou PNG), então clique em "Atualizar perfil". A imagem será cortada como um quadrado e redimensionada para 100x100 pixels.';
$string['newpictureusernotsetup'] = 'Uma imagem do perfil só pode ser adicionada quando todas as informações de perfil necessárias tiverem sido salvas.';
$string['newsectionname'] = 'Novo nome para a sessão {$a}';
$string['newsitem'] = 'Notícia';
$string['newsitems'] = 'avisos';
$string['newsitemsnumber'] = 'Número de avisos';
$string['newsitemsnumber_help'] = 'O fórum de avisos é um fórum especial que é criado automaticamente no curso, por padrão tem a assinatura obrigatória e somente os usuários com permissões apropriadas (por padrão professores) podem postar nele.

Esta configuração determina quantos anúncios recentes aparecem no bloco de anúncios recentes.

Se um fórum de anúncios não for necessário no curso, essa configuração deve ser definida como zero.';
$string['newuser'] = 'Novo usuário';
$string['newusernewpasswordsubj'] = 'Nova conta de usuário';
$string['newusernewpasswordtext'] = 'Oi {$a->firstname},

Uma nova conta foi criada para você em  \'{$a->sitename}\'.

Os seus dados atuais para o login são:
usuário: {$a->username}
senha: {$a->newpassword}
(a primeira vez que você fizer o login será necessário alterar a senha)

Para começar a utilizar o \'{$a->sitename}\', faça o login em {$a->link}

Na maior parte dos programas de email a frase anterior aparece como um link azul que você pode clicar. Se este não é o seu caso, copie o endereço para a barra de endereços do seu navegador.

Saudações do administrador do \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Novos usuários';
$string['newwindow'] = 'Nova janela';
$string['next'] = 'Próximo';
$string['nextpage'] = 'Próxima página';
$string['nextsection'] = 'Próxima seção';
$string['no'] = 'Não';
$string['noblockstoaddhere'] = 'Não existem blocos que você pode incluir nesta página.';
$string['nobody'] = 'Ninguém';
$string['nochange'] = 'Nenhuma mudança';
$string['nocomments'] = 'Nenhum comentário';
$string['nocourses'] = 'Nenhum curso';
$string['nocoursesfound'] = 'Nenhum curso encontrado com as palavras \'{$a}\'';
$string['nocoursestarttime'] = 'Este curso não possui uma data de início.';
$string['nocoursesyet'] = 'Nenhum curso nesta categoria';
$string['nodstpresets'] = 'O administrador não habilitou o suporte ao horário de verão.';
$string['nofilesselected'] = 'Nenhum arquivo foi selecionado para o restauração';
$string['nofilesyet'] = 'Nenhum arquivo foi enviado ao seu curso ainda';
$string['nofiltersapplied'] = 'Não foram aplicados filtros';
$string['nograde'] = 'Nenhuma nota';
$string['nohelpforactivityorresource'] = 'Não há atualmente nenhuma ajuda associada a este recurso ou atividade';
$string['noimagesyet'] = 'Nenhuma imagem foi enviada ao seu curso ainda';
$string['nologsfound'] = 'Não foi encontrado nenhum log';
$string['nomatchingusers'] = 'Nenhum usuário encontrado \'{$a}\'';
$string['nomorecourses'] = 'Não foi encontrado nenhum outro curso compatível';
$string['nomoreidnumber'] = 'Não está usando um ID para evitar incompatibilidades';
$string['none'] = 'Nenhum';
$string['noneditingteacher'] = 'Moderador';
$string['noneditingteacherdescription'] = 'Moderadores podem interagir e avaliar mas não podem modificar as atividades.';
$string['nonstandard'] = 'Não é padrão';
$string['nopendingcourses'] = 'Não há pedido de aprovação de curso pendente';
$string['nopotentialadmins'] = 'Nenhum potencial administrador';
$string['nopotentialcreators'] = 'Nenhum potencial criador de cursos';
$string['nopotentialstudents'] = 'Nenhum potencial estudante';
$string['nopotentialteachers'] = 'Nenhum potencial professor';
$string['norecentactivity'] = 'Nenhuma atividade recente';
$string['noreplybouncemessage'] = 'Você respondeu a um endereço no-reply. Se você estava tentando responder a uma mensagem de um fórum, por favor responda usando o fórum {$a}.

Abaixo está o conteúdo do seu e-mail:';
$string['noreplybouncesubject'] = '{$a} - mensagem devolvida.';
$string['noreplyname'] = 'Não responda a esta mensagem.';
$string['noresetrecord'] = 'Não há nenhum registro de que foi realizado pedido de redefinição. Por favor iniciar um novo pedido de redefinição de senha.';
$string['noresults'] = 'Nenhum resultado';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Busca normal';
$string['nosite'] = 'Não foi encontrado o curso a nível de site';
$string['nostudentsfound'] = 'Nenhum {$a} encontrado';
$string['nostudentsingroup'] = 'Nenhum estudante neste grupo ainda';
$string['nostudentsyet'] = 'Não há nenhum estudante inscrito neste curso.';
$string['nosuchemail'] = 'Este endereço de email não foi encontrado';
$string['notavailable'] = 'Não disponível';
$string['notavailablecourse'] = '{$a} não está disponível';
$string['noteachersyet'] = 'Este curso ainda não tem professores';
$string['noteachingupcomingcourses'] = 'Próximos cursos não têm professores ou estudantes';
$string['notenrolled'] = '{$a} não está inscrito neste curso.';
$string['notenrolledprofile'] = 'Este perfil não é disponível porque este usuário não está inscrito neste curso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Atenção:</strong> A habilidade de rolar datas quando restaurando backup foi desabilitada pois você não tem as permissões necessárias.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> É necessário fazer a restauração dos usuários do curso quando se faz a restauração dos dados do usuário (em atividades, arquivos ou mensagens). Esta configuração foi mudada para você.';
$string['nothingnew'] = 'Nenhuma atividade recente';
$string['nothingtodisplay'] = 'Nada a ser mostrado';
$string['notice'] = 'Notar';
$string['noticenewerbackup'] = 'Este arquivo de backup foi criado com Moodle {$a->backuprelease} ({$a->backupversion}) e é mais recente que a versão {$a->serverrelease} ({$a->serverversion}) atualmente instalada. A compatibilidade retroativa não pode ser garantida. É possível que ocorram conflitos e inconsistências.';
$string['notifications'] = 'Avisos';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Usuário: {$a->info}, Nome completo: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Você pode ver estes logs em {$a}';
$string['notifyloginfailuresmessagestart'] = 'Esta é uma lista dos erros de login em {$a} desde a última notificação.';
$string['notifyloginfailuressubject'] = '{$a} :: avisos de erro de login';
$string['notincluded'] = 'Não incluído';
$string['notingroup'] = 'Desculpe, mas você precisa ser participante de um grupo para ver esta página.';
$string['notpublic'] = 'Não é público!';
$string['nousersfound'] = 'Nenhum usuário encontrado';
$string['nousersmatching'] = 'Nenhum usuário correspondente a \'{$a}\' foi encontrado';
$string['nousersyet'] = 'Nenhum usuário';
$string['novalidcourses'] = 'Não há cursos válidos a serem mostrados';
$string['now'] = 'agora';
$string['numattempts'] = '{$a} erros de login';
$string['numberofcourses'] = 'Número de cursos';
$string['numberweeks'] = 'Número de seções';
$string['numday'] = '{$a} dia';
$string['numdays'] = '{$a} dias';
$string['numhours'] = '{$a} horas';
$string['numletters'] = '{$a} letras';
$string['numminutes'] = '{$a} minutos';
$string['nummonth'] = '{$a} mês';
$string['nummonths'] = '{$a} meses';
$string['numseconds'] = '{$a} segundos';
$string['numviews'] = '{$a} visitas';
$string['numweek'] = '{$a} semana';
$string['numweeks'] = '{$a} semanas';
$string['numwords'] = '{$a} palavras';
$string['numyear'] = '{$a} ano';
$string['numyears'] = '{$a} anos';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Senha atual';
$string['olduserdirectory'] = 'Este é o velho diretório de usuários. Você pode excluir este diretório pois os arquivos foram copiados no novo diretório de usuários.';
$string['optional'] = 'opcional';
$string['options'] = 'Opções';
$string['order'] = 'Ordem';
$string['originalpath'] = 'Caminho original';
$string['orphanedactivitiesinsectionno'] = 'Atividades órfãs (seção {$a})';
$string['other'] = 'Outro';
$string['outline'] = 'Outline';
$string['outlinereport'] = 'Relatório de outline';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pagedcontentnavigation'] = 'Navegação de paginação';
$string['pagedcontentnavigationactiveitem'] = 'Página atual, página {$a}';
$string['pagedcontentnavigationitem'] = 'Ir para a página {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Mostrar {$a} itens por página';
$string['pageheaderconfigablock'] = 'Configurando um bloco em {$a->fullname}';
$string['pagepath'] = 'Caminho da página';
$string['pageshouldredirect'] = 'Esta página deveria ser redirecionada automaticamente. Se nada acontecer, por favor clique no link continuar abaixo.';
$string['parentcategory'] = 'Categoria mãe';
$string['parentcoursenotfound'] = 'Curso-pai não encontrado!';
$string['parentfolder'] = 'Diretório pai';
$string['participants'] = 'Participantes';
$string['participantscount'] = 'Número de participantes: {$a}';
$string['participantslist'] = 'Lista de participantes';
$string['participationratio'] = 'Índice de Participação';
$string['participationreport'] = 'Relatório de participação';
$string['password'] = 'Senha';
$string['passwordchanged'] = 'A senha foi alterada';
$string['passwordconfirmchange'] = 'Confirme a mudança de senha';
$string['passwordextlink'] = 'Siga este link para recuperar a senha perdida.';
$string['passwordforgotten'] = 'Senha esquecida';
$string['passwordforgotteninstructions'] = 'Os seus dados devem ser encontrados na base de dados. Por favor, digite <strong>somente</strong> seu usuário ou endereço de email registrado na caixa apropriada. Não há necessidade de introduzir ambos.';
$string['passwordforgotteninstructions2'] = 'Para redefinir sua senha, preencha seu usuário ou seu email abaixo. Se sua conta for encontrada no banco de dados, um email será enviado para seu endereço de email, com as instruções sobre como restabelecer seu acesso.';
$string['passwordnohelp'] = 'Não existem instruções de ajuda para recuperar esta senha. Por favor contate o administrador.';
$string['passwordpolicynomatch'] = 'Sua senha atual não atende mais à política de senhas adotada.
   {$a}';
$string['passwordrecovery'] = 'Sim, preciso de ajuda para acessar';
$string['passwordsdiffer'] = 'Estas senhas não são iguais';
$string['passwordsent'] = 'A senha foi enviada';
$string['passwordsenttext'] = 'Uma mensagem contendo a sua nova senha foi enviada ao endereço {$a->email}.
<p>A senha nova foi gerada automaticamente mas é possível <a href="{$a->link}">modificá-la</a> se você quiser.</p>';
$string['passwordset'] = 'Sua senha foi definida.';
$string['path'] = 'Caminho';
$string['pathnotexists'] = 'O percurso não existe no seu servidor!';
$string['pathslasherror'] = 'O percurso não pode terminar com um slash!!';
$string['paymentinstant'] = 'Clique o botão abaixo para efetuar o pagamento e fazer a sua inscrição em poucos minutos!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendente</small>)';
$string['paymentrequired'] = 'Este curso requer o pagamento da taxa de inscrição antes do acesso.';
$string['payments'] = 'Pagamentos';
$string['paymentsorry'] = 'Infelizmente o seu pagamento ainda está sendo processado e você ainda não pode acessar o curso "{$a->fullname}".
Espere alguns minutos antes de tentar um novo acesso. Se você continuar a ter problemas para acessar o curso, contate {$a->teacher} ou o administrador do site.';
$string['paymentthanks'] = 'Pagamento concluído! Agora você já está inscrito no seguinte curso:<br />"{$a}"';
$string['pendingrequests'] = 'Solicitações pendentes';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Período termina em ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Pessoal';
$string['personalprofile'] = 'Perfil pessoal';
$string['phone'] = 'Fone';
$string['phone1'] = 'Fone';
$string['phone2'] = 'Telefone celular';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Imagem de {$a}';
$string['pictureofuser'] = 'Imagem do usuário';
$string['pleaseclose'] = 'Feche esta janela agora.';
$string['pleasesearchmore'] = 'Por favor procure um pouco mais';
$string['pleaseusesearch'] = 'Por favor utilize a busca';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Verificação de plugins';
$string['plugindeletefiles'] = 'Todos os dados associados ao plugin \'{$a->name}\' foram excluídos do banco de dados. Para evitar a re-instalação automática do plugin, você precisa remover este diretório do seu servidor: {$a->directory}';
$string['pluginsetup'] = 'Configurando tabelas dos plugins';
$string['policyaccept'] = 'Eu compreendo e concordo';
$string['policyagree'] = 'Para utilizar este site você precisa aceitar o acordo sobre a política de uso do site. Você aceita os termos deste acordo?';
$string['policyagreement'] = 'Acordo de política do site';
$string['policyagreementclick'] = 'Link para o acordo de política do site';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Abra o arquivo em uma nova janela';
$string['popupwindowname'] = 'Janela popup';
$string['post'] = 'Mensagem';
$string['posts'] = 'Mensagens';
$string['potentialadmins'] = 'Potenciais administradores';
$string['potentialcreators'] = 'Potenciais criadores de cursos';
$string['potentialstudents'] = 'Potenciais participantes';
$string['potentialteachers'] = 'Potenciais professores';
$string['preferences'] = 'Preferências';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Pré-processando arquivo de backup';
$string['prev'] = 'Anterior';
$string['preview'] = 'Pré visualizar';
$string['previeworchoose'] = 'Visualize ou escolha um tema';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Usuários selecionados anteriormente não correspondem a \'{$a}\'';
$string['previouspage'] = 'Página anterior';
$string['previoussection'] = 'Seção anterior';
$string['primaryadminsetup'] = 'Configurar conta de administrador';
$string['privacy:metadata:config_log'] = 'O log da configuração muda.';
$string['privacy:metadata:config_log:name'] = 'O nome da configuração muda.';
$string['privacy:metadata:config_log:oldvalue'] = 'O valor anterior desta configuração.';
$string['privacy:metadata:config_log:plugin'] = 'O plugin modificado.';
$string['privacy:metadata:config_log:timemodified'] = 'A hora em que a mudança foi feita.';
$string['privacy:metadata:config_log:userid'] = 'O usuário que fez a alteração.';
$string['privacy:metadata:config_log:value'] = 'O novo valor para esta configuração.';
$string['privacy:metadata:events_queue'] = 'A fila de eventos do usuário aguardando para serem processados.';
$string['privacy:metadata:events_queue:eventdata'] = 'Os dados armazenados no evento.';
$string['privacy:metadata:events_queue:stackdump'] = 'Qualquer stacktrace associado a este evento.';
$string['privacy:metadata:events_queue:timecreated'] = 'A hora em que esse evento foi criado.';
$string['privacy:metadata:events_queue:userid'] = 'O ID do usuário relacionado com este evento';
$string['privacy:metadata:log'] = 'Uma coleção de eventos passados';
$string['privacy:metadata:log:action'] = 'Uma descrição da ação';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'curso';
$string['privacy:metadata:log:info'] = 'Informação adicional';
$string['privacy:metadata:log:ip'] = 'O endereço IP usado no momento do evento';
$string['privacy:metadata:log:module'] = 'módulo';
$string['privacy:metadata:log:time'] = 'O momento em que a ação aconteceu';
$string['privacy:metadata:log:url'] = 'O URL relacionado ao evento';
$string['privacy:metadata:log:userid'] = 'O ID do usuário que executou a ação';
$string['privacy:metadata:oauth2_refresh_token'] = 'Token de atualização usado na comunicação OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'O ID do emissor ao qual o token corresponde';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'O ID do usuário a quem o token corresponde';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'O momento quando o token foi criado';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'A hora em que o token foi atualizado pela última vez';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'O token de atualização para os respectivos escopos e usuário';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'O ID do usuário a quem o token corresponde';
$string['privacy:metadata:task_adhoc'] = 'O status de tarefas ad hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'O componente que possui a tarefa.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'O primeiro horário para executar essa tarefa.';
$string['privacy:metadata:task_adhoc:userid'] = 'O usuário para executar a tarefa como.';
$string['privacy:metadata:task_log'] = 'Log de saída para um log';
$string['privacy:metadata:task_log:component'] = 'O componente que possui a tarefa.';
$string['privacy:metadata:task_log:userid'] = 'O usuário ao qual a tarefa pertencia.';
$string['privacy:metadata:upgrade_log'] = 'O log de atualização.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Qualquer backtrace associado a esta etapa da atualização.';
$string['privacy:metadata:upgrade_log:details'] = 'Informações extras sobre a atualização.';
$string['privacy:metadata:upgrade_log:info'] = 'As principais informações para este passo da atualização.';
$string['privacy:metadata:upgrade_log:plugin'] = 'O plugin que foi atualizado.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'A nova versão para atualizar.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'A hora em que a atualização ocorreu.';
$string['privacy:metadata:upgrade_log:type'] = 'O tipo de entrada de log.';
$string['privacy:metadata:upgrade_log:userid'] = 'O usuário que executou a atualização.';
$string['privacy:metadata:upgrade_log:version'] = 'A versão antiga do plugin.';
$string['private_files_handler'] = 'Armazenar anexos a um e-mail no espaço de armazenamento de arquivos privados do usuário.';
$string['private_files_handler_name'] = 'E-mail para arquivos privados';
$string['privatefiles'] = 'Arquivos privados';
$string['privatefilesmanage'] = 'Gerenciar arquivos privados';
$string['proceed'] = 'Continuar';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descrição de perfil não será mostrada até que esta pessoa seja inscrita em pelo menos um curso.';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Atenção: os documentos arquivados aqui podem ser acessados por qualquer pessoa';
$string['publicsitefileswarning2'] = 'Atenção: Os documentos arquivados aqui podem ser acessador por qualquer pessoa que saiba (ou que possa adivinhar) a URL. Por razões de segurança, é recomendado que quaisquer arquivos de backup sejam excluídos imediatamente após restaurados.';
$string['publicsitefileswarning3'] = 'Atenção: Os documentos arquivados aqui podem ser acessador por qualquer pessoa que saiba (ou que possa adivinhar) a URL.<br/>Por razões de segurança, arquivos de backup devem ser salvos apenas no diretório seguro backupdata.';
$string['question'] = 'Questão';
$string['questionsinthequestionbank'] = 'Questões no banco de questões';
$string['queued'] = 'Na fila';
$string['quotausage'] = 'Você utilizou {$a->used} de seu limite de {$a->total}.';
$string['readinginfofrombackup'] = 'Lendo informações do backup';
$string['readme'] = 'LEIA-ME';
$string['recentactivity'] = 'Atividade recente';
$string['recentactivityreport'] = 'Relatório completo da atividade recente..';
$string['recipientslist'] = 'Lista de destinatários';
$string['recommended'] = 'Recomendado';
$string['recreatedcategory'] = 'Recriar categoria {$a}';
$string['redirect'] = 'Redirecionar';
$string['reducesections'] = 'Reduzir o número de tópicos';
$string['refresh'] = 'Atualizar';
$string['refreshingevents'] = 'Atualizando eventos';
$string['registration'] = 'Registro do Moodle';
$string['registrationcontact'] = 'Contato do público';
$string['registrationcontactno'] = 'Não, eu não quero ser contatado por outras pessoas';
$string['registrationcontactyes'] = 'Sim, forneça um formulário para que outros Moodlers entrem em contato comigo';
$string['registrationemail'] = 'Avisos via Email';
$string['registrationinfo'] = '<p>Nesta página você pode registrar o seu site Moodle em moodle.org. O registro é gratuito.</p>
O maior benefício será a sua inclusão em uma mailing list limitada a mensagens importantes, como avisos de segurança e novas versões de Moodle.
<p>Os seus dados não serão públicos e nunca serão vendidos ou compartilhados. Estes dados só serão utilizados para fins de elaboração de estatísticas relativas à comunidade Moodle.</p>
<p>Se você quiser, o nome do seu site, o país e a URL serão incluídos à lista de sites Moodle.</p>
<p>Todos os registros são controlados manualmente antes que você seja incluído na lista. Você poderá atualizar os seus dados no futuro utilizando este mesmo formulário.</p>';
$string['registrationinfotitle'] = 'Informação de inscrição';
$string['registrationno'] = 'Não, não quero receber emails do Moodle HQ';
$string['registrationsend'] = 'Mande a informação de registro para moodle.org';
$string['registrationyes'] = 'Sim, avise-me sobre novos lançamentos do Moodle, alertas de segurança e outras notícias importantes';
$string['reject'] = 'Rejeitar';
$string['rejectdots'] = 'Rejeitar...';
$string['relativedatesmode'] = 'Modo de datas relativas';
$string['relativedatesmode_help'] = 'Exibir as datas do curso ou da atividade em relação a data de início do usuário no curso.

A data de início do curso do usuário será a data de início da inscrição, a menos que tenha sido inscrito antes do início do curso. Nesse caso, a data de início será a data de início do curso.

AVISO: Esse é um recurso experimental e nem todas as atividades são compatíveis. Após a criação do curso, essa configuração do curso não poderá mais ser alterada.';
$string['relativedatesmode_warning'] = '<strong>Aviso:</strong> O modo de datas relativas não pode ser alterado depois que o curso for criado.';
$string['reload'] = 'Recarregar';
$string['remoteappuser'] = 'Usuário remoto {$a}';
$string['remove'] = 'Remover';
$string['removeadmin'] = 'Remover administrador';
$string['removecreator'] = 'Remover criador de curso';
$string['removestudent'] = 'Remover participante';
$string['removeteacher'] = 'Remover professor';
$string['rename'] = 'Renomear';
$string['renamefileto'] = 'Renomear <b>{$a}</b> para';
$string['report'] = 'Relatório';
$string['reports'] = 'Relatórios';
$string['repositories'] = 'Repositórios';
$string['requestcourse'] = 'Solicitar um curso';
$string['requestedby'] = 'Requerido por';
$string['requestedcourses'] = 'Cursos solicitados';
$string['requestreason'] = 'Razão para a criação do curso';
$string['requests'] = 'Solicitações';
$string['required'] = 'Necessários';
$string['requirespayment'] = 'O acesso a este curso só é possível após o pagamento da taxa de inscrição';
$string['resendemail'] = 'Reenviar email';
$string['reset'] = 'Reconfigurar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reconfigurar curso';
$string['resetinfo'] = 'Esta página permite que você esvazie os dados de um curso ou de um usuário, sem excluir as atividades e outras configurações. Por favor lembre-se que fazendo isto estes dados serão excluídos para sempre!';
$string['resetnotimplemented'] = 'Reconfiguração não implementada';
$string['resetrecordexpired'] = 'O link de redefinição de senha que você usou tem mais do que {$a} minutos e expirou. Por favor iniciar uma nova redefinição de senha.';
$string['resetstartdate'] = 'Reconfigurar data de início';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Redefinir as preferências da tabela';
$string['resettask'] = 'Tarefa';
$string['resettodefaults'] = 'Usar padrão';
$string['resortcourses'] = 'Ordenar cursos';
$string['resortsubcategoriesby'] = 'Ordenar subcategorias por {$a} em ordem crescente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar subcategorias por {$a} em ordem decrescente';
$string['resource'] = 'Recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forçar o download';
$string['resourcedisplayembed'] = 'Incorporar';
$string['resourcedisplayframe'] = 'Em um frame';
$string['resourcedisplaynew'] = 'Nova janela';
$string['resourcedisplayopen'] = 'Abrir';
$string['resourcedisplaypopup'] = 'Em uma janela pop-up';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Tipos de recursos permitem a inclusão de praticamente qualquer tipo de conteúdo web no curso.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Restauração cancelada';
$string['restorecannotassignroles'] = 'A restauração precisa atribuir funções e você não tem permissão para fazê-lo';
$string['restorecannotcreateorassignroles'] = 'A restauração precisa criar ou atribuir funções e você não tem permissão para fazê-lo';
$string['restorecannotcreateuser'] = 'A restauração precisa criar o usuário "{$a}" a partir do arquivo de backup mas você não tem permissão para fazê-lo';
$string['restorecannotoverrideperms'] = 'A restauração precisa sobrescrever permissões e você não tem permissão para fazê-lo';
$string['restorecoursenow'] = 'Fazer restauração deste curso agora!';
$string['restoredaccount'] = 'Conta restaurada';
$string['restoredaccountinfo'] = 'Esta conta foi importada de outro servidor e a senha foi perdida. Para definir uma nova senha por email, por favor clique em "Continuar"';
$string['restorefinished'] = 'A restauração foi concluída com sucesso';
$string['restoremnethostidmismatch'] = 'A id de destino MNet do usuário \'{$a}\' não corresponde a ID local do MNet.';
$string['restoreto'] = 'Restaurar em';
$string['restoretositeadding'] = 'Atenção: Você está prestes a restaurar na página principal do site, adicionando dados!';
$string['restoretositedeleting'] = 'Atenção: Você está prestes a restaurar na página principal do site, removendo os dados dela antes!';
$string['restoreuserconflict'] = 'Tentar restaurar o usuário "{$a}" do arquivo de backup causará conflito';
$string['restoreuserinfofailed'] = 'O processo de restauração parou pois você não tem permissão de restaurar dados de usuários.';
$string['restoreusersprecheck'] = 'Verificando dados do usuário';
$string['restoreusersprecheckerror'] = 'Alguns problemas foram detectados quando verificando dados do usuário';
$string['restricted'] = 'Restrito';
$string['resultsfound'] = '{$a} resultados encontrados';
$string['retry'] = 'Tentar novamente';
$string['returningtosite'] = 'Retornando a este site?';
$string['returntooriginaluser'] = 'Retornar para {$a}';
$string['revert'] = 'Reverter alterações';
$string['role'] = 'Papel';
$string['roleassignments'] = 'Atribuições de papel';
$string['rolemappings'] = 'Mapeamento de papéis';
$string['rolerenaming'] = 'Renomear papel';
$string['rolerenaming_help'] = 'Esta configuração permite alterar os nomes dos papéis exibidos no curso. Apenas o nome exibido é alterado - permissões do papel não são afetadas. Novos nomes de papéis aparecerão na página de participantes do curso e em outros lugares dentro do curso. Se o papel renomeado é um que o administrador tenha selecionado como um papel de gerente de curso, o nome do novo papel também será exibido na listagem de cursos.';
$string['roles'] = 'Papéis';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artigos recentes no RSS';
$string['rsserror'] = 'Erro de leitura dos dados do RSS';
$string['rsserrorauth'] = 'Seu link RSS não contém um token válido de autenticação.';
$string['rsserrorguest'] = 'Este feed utiliza o acesso de visitante para acessar os dados, porém o visitante não tem permissão para visualizar os dados. Visite o local original de que este feed vem (URL) como um usuário válido para obter um novo link RSS.';
$string['rsskeyshelp'] = '<p>Para garantir segurança e privacidade, as URLs dos RSS feeds contêm um token que identifica a qual usuário pertencem. Isto previne que outros usuários acessem, via RSS feed, áreas do Moodle que eles não deveriam acessar.</p>
<p>Este token é criado automaticamente na primeira vez que você acessa uma área do Moodle que atualiza o RSS. Se você acha que o token do seu RSS foi comprometido de alguma maneira você pode requisitar um novo clicando  no link Resetar. Por favor, note que suas URL atuais para RSS feeds se tornarão inválidas.</p>';
$string['rsstype'] = 'Alimentador RSS desta atividade';
$string['save'] = 'Salvar';
$string['saveandnext'] = 'Salvar e mostrar o próximo';
$string['savechanges'] = 'Salvar mudanças';
$string['savechangesanddisplay'] = 'Salvar e mostrar';
$string['savechangesandreturn'] = 'Salvar e voltar';
$string['savechangesandreturntocourse'] = 'Salvar e voltar ao curso';
$string['savecomment'] = 'Salvar comentário';
$string['savedat'] = 'Salvado em:';
$string['savepreferences'] = 'Salvar preferências';
$string['saveto'] = 'Salvar em';
$string['scale'] = 'Escala';
$string['scale_help'] = '<p>Os professores podem criar novas escalas e critérios de avaliação a serem utilizados nas atividades do curso.</p>

<p>O título de uma escala deve ser uma frase que a identifique com precisão porquê o título aparece como ítem do menú de seleção  do tipo de escala de avaliação. Este título também é usado como link à página de ajuda correspondente.</p>

<p>Uma escala é definida por uma lista de valores ordenada, do mais negativo ao mais positivo, separados por vírgulas. Por exemplo:</p>

<p class="indent"><i>
   Insuficiente, Sofrível,Bom,Ótimo,Excelente
</i></p>

<p>As escalas devem incluir uma boa descrição dos critérios e de como deve ser utilizada. Esta descrição é visualizada nas páginas de ajuda correspondentes.</p>

<p>O administrador do site pode definir algumas escalas como "Standard" para que elas sejam disponíveis em todos os cursos.</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Adicionar nova escala';
$string['scalescustomno'] = 'Nenhuma escala personalizada';
$string['scalesstandard'] = 'Escalas predefinidas';
$string['scalestandard'] = 'Escala padrão';
$string['scalestandard_help'] = '<p>Uma escala padrão fica disponível a nível do site, para todos os cursos.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Para criar escalas personalizadas, use o botão "escalas" no painel de administração do curso';
$string['scalestip2'] = 'Para criar escalas personalizadas, clique no link Notas no menu de administração do curso, depois escolha Editar, Escalas.';
$string['schedule'] = 'Programação';
$string['screenshot'] = 'Captura de tela';
$string['search'] = 'Buscar';
$string['search_help'] = 'Para a busca básica por uma ou mais palavras em qualquer parte do texto, simplesmente digite-as separadas por espaços. Todas as palavras com mais de dois caracteres serão usadas.

Para busca avançada, pressione o botão de busca sem digitar nada na caixa de busca para acessar o formulário de busca avançada.';
$string['searchactivities'] = 'Pesquisar atividades por nome ou descrição';
$string['searchagain'] = 'Buscar novamente';
$string['searchbyemail'] = 'Buscar pelo endereço de email';
$string['searchbyusername'] = 'Buscar por identificação de usuário';
$string['searchcoursecategories'] = 'Categorias de pesquisa';
$string['searchcourses'] = 'Buscar cursos';
$string['searchoptions'] = 'Opções de busca';
$string['searchresults'] = 'Resultados da busca';
$string['sec'] = 'segundo';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segundos';
$string['secondstotime172800'] = '2 dias';
$string['secondstotime259200'] = '3 dias';
$string['secondstotime345600'] = '4 dias';
$string['secondstotime432000'] = '5 dias';
$string['secondstotime518400'] = '6 dias';
$string['secondstotime604800'] = '1 semana';
$string['secondstotime86400'] = '1 dia';
$string['secretalreadyused'] = 'O link para confirmação de senha já foi utilizado, a senha não foi modificada.';
$string['secs'] = 'segundos';
$string['section'] = 'Seção';
$string['sectionactionnotsupported'] = 'Ação na seção "{$a}" não é suportada';
$string['sectionname'] = 'Nome da seção';
$string['sections'] = 'Seções';
$string['seealsostats'] = 'Ver também: estatísticas';
$string['selctauser'] = 'Selecione um usuário';
$string['select'] = 'Selecionar';
$string['selectacategory'] = 'Por favor seleccione uma categoria';
$string['selectacountry'] = 'Selecione um país';
$string['selectacourse'] = 'Selecione um curso';
$string['selectacoursesite'] = 'Selecio';
$string['selectagroup'] = 'Selecione um grupo';
$string['selectall'] = 'Selecionar tudo';
$string['selectallusersonpage'] = 'Selecione todos os usuários nesta página';
$string['selectalluserswithcount'] = 'Selecione todos os {$a} usuários';
$string['selectamodule'] = 'Selecionar um módulo de atividade';
$string['selectanaction'] = 'Selecione uma ação';
$string['selectanoptions'] = 'Selecione uma opção';
$string['selectaregion'] = 'Selecione a região';
$string['selectcategorysort'] = 'Quais categorias você gostaria de ordenar?';
$string['selectcategorysortby'] = 'Selecione como você gostaria de ordenar as categorias';
$string['selectcoursesortby'] = 'Selecione como você gostaria de ordenar os cursos';
$string['selectdefault'] = 'Selecionar padrão';
$string['selectedcategories'] = 'Categorias selecionadas';
$string['selectedfile'] = 'Arquivo selecionado';
$string['selectednowmove'] = '{$a} arquivos selecionados.Abra a pasta para onde você quer mover os arquivos e clique no botão \'Mover os arquivos para cá\'';
$string['selectfiles'] = 'Selecionar arquivos';
$string['selectitem'] = 'Selecione \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Selecione uma atividade ou recurso para exibir a sua ajuda.

Dê um duplo clique no nome de uma atividade ou recurso para adicioná-lo rapidamente.';
$string['selectnos'] = 'Selecionar todos os \'Não\'';
$string['selectperiod'] = 'Selecionar período';
$string['senddetails'] = 'Enviar meus dados via email';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Formas de saber: conectada e destacada';
$string['separateandconnectedinfo'] = 'A escala baseada na teoria de conhecimento separado e conectado. Esta teoria descreve duas maneiras diferentes de avaliar e aprender sobre as coisas que vemos e ouvimos.<ul><li><strong>Conhecedores separados</strong> permanecem o mais objetivo possível sem incluir sentimentos e emoções. Em uma discussão com outras pessoas, eles gostam de defender suas próprias ideias, usando lógica para encontrar furos nas ideias de seus oponentes.</li><li><strong>Conhecedores conectados</strong> são mais sensíveis com as outras pessoas. Eles são habilidosos em empatia e preferem ouvir e questionar até que sintam que podem conectar e "entender as coisas do seu ponto de vista". Eles aprendem pela tentativa de compartilhar as experiências que levam ao conhecimento que eles encontram nas outras pessoas.</li></ul>';
$string['servererror'] = 'Um erro ocorreu durante a comunicação com o servidor';
$string['serverlocaltime'] = 'Hora local do servidor';
$string['sessionforceclean'] = 'Por uma precaução de segurança, scripts gerados pelo usuário foram desabilitados nesta sessão';
$string['sessiontimeoutsoon'] = 'Sua sessão está prestes a expirar. Deseja prolongar sua sessão atual?';
$string['setcategorytheme'] = 'Definir tema para a categoria';
$string['setpassword'] = 'Definir senha';
$string['setpasswordinstructions'] = 'Digite sua nova senha abaixo e salve as alterações.';
$string['settings'] = 'Configurações';
$string['shortname'] = 'Nome breve';
$string['shortnamecollisionwarning'] = '[*] = Este nome breve já é utilizado por outro curso e deverá ser mudado depois da aprovação';
$string['shortnamecourse'] = 'Nome breve do curso';
$string['shortnamecourse_help'] = '<P>Muitas instituições adotam um nome breve ou código para identificar um curso, algo como
   BP102 ou COMMS.  Se o seu curso não corresponde a um nome breve real, crie um. Este
   nome breve será usado em alguns lugares onde a utilização do nome completo não é apropriada
   (por exemplo: na descrição do assunto das mensagens de email).</P>';
$string['shortnametaken'] = 'Este nome breve já é usado no curso ({$a})';
$string['shortnameuser'] = 'Nome breve do usuário';
$string['shortsitename'] = 'Nome breve do site';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Mostrar ações';
$string['showadvancededitor'] = 'Avançado';
$string['showadvancedsettings'] = 'Mostrar configurações avançadas';
$string['showall'] = 'Mostrar todos os {$a}';
$string['showallcourses'] = 'Mostrar todos os cursos';
$string['showallusers'] = 'Mostrar todos os usuários';
$string['showblockcourse'] = 'Mostrar lista de cursos que contém o bloco';
$string['showcategory'] = 'Mostrar {$a}';
$string['showchartdata'] = 'Mostrar dados do gráfico';
$string['showcomments'] = 'Mostrar/esconder comentários';
$string['showcommentsnonjs'] = 'Mostrar comentários';
$string['showdescription'] = 'Exibir descrição na página do curso';
$string['showdescription_help'] = 'Caso ativada, a descrição acima será exibida na página do curso logo abaixo do link para a atividade ou recurso.';
$string['showgrades'] = 'Mostrar livro de notas aos estudantes';
$string['showgrades_help'] = 'Muitas atividades no curso permitem que as notas sejam definidas. Esta configuração determina se um estudante pode ver uma lista de todas as suas notas no curso através do link Notas da gaveta ou do bloco de navegação.';
$string['showingacourses'] = 'Mostrando todos os {$a} cursos';
$string['showingxofycourses'] = 'Mostrando cursos de {$a->start} até {$a->end} de um total de {$a->total} cursos';
$string['showlistofcourses'] = 'Mostrar  a lista dos cursos';
$string['showmodulecourse'] = 'Mostrar lista de cursos que contém a atividade';
$string['showoncoursepage'] = 'Mostrar na página do curso';
$string['showonly'] = 'Mostrar só';
$string['showperpage'] = 'Mostrar {$a} por página';
$string['showpopoverwindow'] = 'Mostrar janela popover';
$string['showrecent'] = 'Mostrar a atividade recente';
$string['showreports'] = 'Mostrar relatório das atividades';
$string['showreports_help'] = 'Relatórios de atividade estão disponíveis para cada participante, mostrando a sua atividade no curso, bem como listagens das suas contribuições, tais como mensagens do fórum ou submissões de tarefas. Esses relatórios também incluem logs de acesso. Esta configuração determina se um estudante pode ver os seus próprios relatórios de atividade através da sua página de perfil.';
$string['showsettings'] = 'Mostrar configurações';
$string['showtheselogs'] = 'Mostrar estes logs';
$string['showthishelpinlanguage'] = 'Mostrar esta ajuda no idioma: {$a}';
$string['sidepanel'] = 'Painel lateral';
$string['signoutofotherservices'] = 'Sair de todas as sessões';
$string['signoutofotherservices_help'] = 'Se marcado, a conta será encerrada a partir de todos os dispositivos e sistemas que utilizam "web services", como apps para dispositivos móveis.';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde o último login';
$string['site'] = 'Site';
$string['sitedefault'] = 'Padrão do site';
$string['sitedefaultspecified'] = 'Padrão do site ({$a})';
$string['siteerrors'] = 'Erros do site';
$string['sitefiles'] = 'Arquivos do site';
$string['sitefilesused'] = 'Arquivos do site usados neste curso';
$string['sitehome'] = 'Página inicial do site';
$string['sitelegacyfiles'] = 'Arquivos de site legados';
$string['sitelogs'] = 'Logs do site';
$string['sitenews'] = 'Avisos do site';
$string['sitepages'] = 'Páginas do site';
$string['sitepartlist'] = 'Você não tem autorização para ver a lista dos participantes';
$string['sitepartlist0'] = 'Você deve ser um professor do site para ter a permissão de consultar a lista dos participantes';
$string['sitepartlist1'] = 'Você deve ser um professor para ter a permissão de consultar a lista dos participantes';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Incluir uma seção para tópicos';
$string['sitesettings'] = 'Estrutura do site';
$string['siteteachers'] = 'Professores do site';
$string['size'] = 'Tamanho';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Saltado';
$string['skiptocategorylisting'] = 'Saltar para as listas de categorias';
$string['skiptocoursedetails'] = 'Saltar para as informações detalhadas do curso';
$string['skiptocourselisting'] = 'Saltar para a lista de cursos';
$string['skypeid'] = 'ID Skype';
$string['socialheadline'] = 'Forum social -  tópicos mais recentes';
$string['someallowguest'] = 'Alguns cursos podem permitir o acesso a visitantes';
$string['someerrorswerefound'] = 'Alguma informação está faltando ou está incorreta. Veja os detalhes abaixo.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por {$a} em ordem crescente';
$string['sortbyxreverse'] = 'Ordenar por {$a} em ordem decrescente';
$string['sorting'] = 'Ordenando';
$string['sourcerole'] = 'Papel fonte';
$string['specifyname'] = 'É necessário especificar um nome.';
$string['standard'] = 'Padrão';
$string['starpending'] = '([*] = aprovação de curso pendente)';
$string['startdate'] = 'Data de início do curso';
$string['startdate_help'] = 'Esta configuração determina o início da primeira semana para um curso em formato semanal. Também determina a data inicial em que os logs das atividades do curso estarão disponíveis. Se o curso é redefinido e a data de início do curso alterado, todas as datas do curso serão movidos em relação à nova data de início.';
$string['startingfrom'] = 'Iniciando em';
$string['startsignup'] = 'Criar uma conta';
$string['state'] = 'Estado';
$string['statistics'] = 'Estatísticas';
$string['statisticsgraph'] = 'Gráfico de estatísticas';
$string['stats'] = 'Estatísticas';
$string['statslogins'] = 'Logins';
$string['statsmodedetailed'] = 'Vista Detalhada';
$string['statsmodegeneral'] = 'Vista Geral';
$string['statsnodata'] = 'Nenhum dado disponível usando esta combinação de curso e período.';
$string['statsnodatauser'] = 'Nenhuma data disponível usando esta combinação de curso, usuário e período';
$string['statsoff'] = 'As estatísticas não estão habilitadas';
$string['statsreads'] = 'Visitas';
$string['statsreport1'] = 'Logins';
$string['statsreport10'] = 'Atividade do usuário';
$string['statsreport11'] = 'Cursos mais ativos';
$string['statsreport12'] = 'Cursos mais ativos (ponderado)';
$string['statsreport13'] = 'Cursos mais participados (inscrições)';
$string['statsreport14'] = 'Cursos com mais participação (acessos/mensagens)';
$string['statsreport2'] = 'Visualizações (todos os papéis)';
$string['statsreport3'] = 'Posts (todos os papéis)';
$string['statsreport4'] = 'Toda atividade (todos os papéis)';
$string['statsreport5'] = 'Toda atividade (visualizações e posts)';
$string['statsreport7'] = 'Atividade do usuário (acessos e mensagens)';
$string['statsreport8'] = 'Todas as atividades do usuário';
$string['statsreport9'] = 'Logins (curso principal)';
$string['statsreportactivity'] = 'Toda atividade (todos os papéis)';
$string['statsreportactivitybyrole'] = 'Todas as atividades (visitas e mensagens)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Logins';
$string['statsreportreads'] = 'Visualizações (todos os papéis)';
$string['statsreporttype'] = 'Tipo de relatório';
$string['statsreportwrites'] = 'Posts (todos os papéis)';
$string['statsstudentactivity'] = 'Atividades dos estudantes';
$string['statsstudentreads'] = 'Acessos dos estudantes';
$string['statsstudentwrites'] = 'Mensagens dos estudantes';
$string['statsteacheractivity'] = 'Atividades dos docentes';
$string['statsteacherreads'] = 'Acessos dos docentes';
$string['statsteacherwrites'] = 'Mensagens dos docentes';
$string['statstimeperiod'] = 'Período - último:';
$string['statsuniquelogins'] = 'Logins únicos';
$string['statsuseractivity'] = 'Todas as atividades';
$string['statsuserlogins'] = 'Logins';
$string['statsuserreads'] = 'Acessos';
$string['statsuserwrites'] = 'Mensagens';
$string['statswrites'] = 'Mensagens';
$string['status'] = 'Status';
$string['statuscritical'] = 'Crítico';
$string['statuserror'] = 'Erro';
$string['statusinfo'] = 'Informação';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statuswarning'] = 'Aviso';
$string['stringsnotset'] = 'As seguintes expressões não são definidas em {$a}';
$string['studentnotallowed'] = 'Sinto muito, mas você não pode entrar neste curso como \'{$a}\'';
$string['students'] = 'Estudantes';
$string['studentsandteachers'] = 'Estudantes e professores';
$string['subcategories'] = 'Subcategorias';
$string['subcategory'] = 'Sub-categoria';
$string['subcategoryof'] = 'Subcategoria de {$a}';
$string['submit'] = 'Enviar';
$string['success'] = 'Sucesso';
$string['successduration'] = 'Sucesso ({$a} seconds)';
$string['summary'] = 'Sumário';
$string['summary_help'] = '<p>Um suário é um texto breve que apresenta aos estudantes as atividades da tópico/semana.</p>
<p>Cada sumário deve ser curto para que a página do curso não fique muito longa.</p>
<p>Se você achar necessário escrever um texto mais longo, adicione este texto ao Tópico como material (por exemplo: a primeira atividade poderia ser uma página web com o seguinte título: <b>Introdução ao Tópico</b>).</p>';
$string['summaryof'] = 'Sumário de {$a}';
$string['supplyinfo'] = 'Mais detalhes';
$string['suspended'] = 'Suspenso';
$string['suspendedusers'] = 'Usuários suspensos';
$string['switchdevicedefault'] = 'Mudar para o tema padrão';
$string['switchdevicerecommended'] = 'Mudar para o tema recomendado para o seu dispositivo';
$string['switchrolereturn'] = 'Retornar ao meu papel normal';
$string['switchroleto'] = 'Mudar papel para...';
$string['switchroleto_help'] = 'Escolha um papel para ter uma ideia de como usuários com este papel verão este curso.

Por favor, note que poderá não ser uma visualização perfeita (<a href="https://docs.moodle.org/en/Switch_roles">Ver detalhes e alternativas</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Esta tag já existe';
$string['tagmanagement'] = 'Adicionar/excluir tags...';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Papel alvo';
$string['teacheronly'] = 'só para o {$a}';
$string['teacherroles'] = 'Papéis {$a}';
$string['teachers'] = 'Professores';
$string['textediting'] = 'Editor de texto';
$string['textediting_help'] = 'Se um editor de HTML, como Atto ou TinyMCE, é selecionado, as áreas de entrada de texto terão uma barra de ferramentas com botões para facilmente adicionar conteúdo.

Se \'área de texto simples\' é selecionado, um formato para áreas de entrada de texto como HTML ou Markdown pode ser escolhido.

A lista de editores de texto disponíveis é determinada pelo administrador do site.';
$string['texteditor'] = 'Use formulários web';
$string['textellipsis'] = 'Student enrolments';
$string['textformat'] = 'Formato texto';
$string['thanks'] = 'Obrigado';
$string['theme'] = 'Tema';
$string['themes'] = 'Temas';
$string['themesaved'] = 'O novo tema foi registrado';
$string['therearecourses'] = 'Há {$a} cursos';
$string['thereareno'] = 'Não há {$a} neste curso';
$string['thiscategory'] = 'Esta categoria';
$string['thiscategorycontains'] = 'Esta categoria contém';
$string['time'] = 'Hora';
$string['timecreatedcourse'] = 'Data/hora de criação do curso';
$string['timesplitting:deciles'] = 'Último décimo';
$string['timesplitting:deciles_help'] = 'Esse intervalo de análise divide o curso em décimos (10 partes iguais), sendo cada previsão baseada apenas nos dados do décimo anterior mais recente.';
$string['timesplitting:decilesaccum'] = 'Todos os décimos anteriores';
$string['timesplitting:decilesaccum_help'] = 'Esse intervalo de análise divide o curso em décimos (10 partes iguais), sendo cada previsão baseada nos dados de todos os décimos anteriores.';
$string['timesplitting:nosplitting'] = 'Sem limite de tempo';
$string['timesplitting:nosplitting_help'] = 'Nenhum intervalo de análise está definido para este modelo.';
$string['timesplitting:onemonthafterstart'] = 'Um mês após o início';
$string['timesplitting:onemonthafterstart_help'] = 'Este intervalo de análise gera uma previsão de 1 mês após o início de análise.';
$string['timesplitting:oneweekafterstart'] = 'Uma semana após o início';
$string['timesplitting:oneweekafterstart_help'] = 'Este intervalo de análise gera uma previsão de 1 semana após o início de análise.';
$string['timesplitting:past3days'] = 'Últimos 3 dias';
$string['timesplitting:past3days_help'] = 'Este intervalo de análise gera uma previsão a cada 3 dias. Os cálculos de indicadores serão baseados nos últimos 3 dias.';
$string['timesplitting:pastmonth'] = 'Último mês';
$string['timesplitting:pastmonth_help'] = 'Este intervalo de análise gera uma previsão a cada mês. Os cálculos de indicadores serão baseados no último mês.';
$string['timesplitting:pastweek'] = 'Última semana';
$string['timesplitting:pastweek_help'] = 'Este intervalo de análise gera uma previsão a cada semana. Os cálculos de indicadores serão baseados na última semana.';
$string['timesplitting:quarters'] = 'Último trimestre';
$string['timesplitting:quarters_help'] = 'Esse método de divisão de tempo divide o curso em trimestres (4 partes iguais), sendo cada previsão baseada apenas nos dados do trimestre anterior mais recente.';
$string['timesplitting:quartersaccum'] = 'Todos trimestres anteriores';
$string['timesplitting:quartersaccum_help'] = 'Esse método de divisão de tempo divide o curso em trimestres (4 partes iguais), sendo cada previsão baseada nos dados de todos os trimestres anteriores.';
$string['timesplitting:singlerange'] = 'Do início ao fim';
$string['timesplitting:singlerange_help'] = 'Esse intervalo de análise considera o curso inteiro como um único período.';
$string['timesplitting:tenpercentafterstart'] = '10% depois de começar';
$string['timesplitting:tenpercentafterstart_help'] = 'Esse intervalo de análise gera uma previsão após a conclusão de 10% do curso.';
$string['timesplitting:upcoming3days'] = 'Próximos 3 dias';
$string['timesplitting:upcoming3days_help'] = 'Esse intervalo de análise gera previsões a cada 3 dias. Os cálculos dos indicadores serão baseados nos próximos 3 dias.';
$string['timesplitting:upcomingfortnight'] = 'Próxima quinzena';
$string['timesplitting:upcomingfortnight_help'] = 'Esse intervalo de análise gera previsões a cada quinzena. Os cálculos dos indicadores serão baseados na próxima quinzena.';
$string['timesplitting:upcomingweek'] = 'Próxima semana';
$string['timesplitting:upcomingweek_help'] = 'Esse intervalo de análise gera previsões a cada semana. Os cálculos dos indicadores serão baseados na próxima semana.';
$string['timezone'] = 'Zona de fuso horário';
$string['to'] = 'a';
$string['tocontent'] = 'Para o item "{$a}"';
$string['tocreatenewaccount'] = 'Avançar para criar nova conta';
$string['today'] = 'Hoje';
$string['todaylogs'] = 'Logs de hoje';
$string['toeveryone'] = 'para todos';
$string['toggleemojipicker'] = 'Alternar seletor de emoji';
$string['togglesearch'] = 'Alternar entrada de pesquisa';
$string['toomanybounces'] = 'Este endereço de email deu origem a muitos erros de aceitação. Você tem que mudá-lo para continuar.';
$string['toomanytags'] = 'Esta pesquisa incluiu muitas tags; algumas deverão ser ignoradas.';
$string['toomanytoshow'] = 'Há demasiados usuários para mostrar.';
$string['toomanyusersmatchsearch'] = 'Muitos usuários ({$a->count}) resultantes da pesquisa \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Muitos usuários ({$a}) para exibir';
$string['toonly'] = 'apenas para {$a}';
$string['top'] = 'Início';
$string['topic'] = 'Tópico';
$string['topichide'] = 'Esconda este tópico de {$a}';
$string['topicoutline'] = 'Programação';
$string['topicshow'] = 'Mostre este tópico a {$a}';
$string['toplevelcategory'] = 'Categoria de nível superior';
$string['total'] = 'Total';
$string['totopofsection'] = 'Para o topo da seção "{$a}"';
$string['trackforums'] = 'Monitoramento do fórum';
$string['trackforumsno'] = 'Não, não marque as mensagens que eu já li';
$string['trackforumsyes'] = 'Sim: ponha em evidência as novas mensagens';
$string['trysearching'] = 'Como alternativa, tente fazer uma busca.';
$string['turneditingoff'] = 'Desativar edição';
$string['turneditingon'] = 'Ativar edição';
$string['unauthorisedlogin'] = 'A conta de usuário "{$a}" não está disponível neste site';
$string['undecided'] = 'Indeciso';
$string['unfinished'] = 'Inacabado';
$string['unknowncategory'] = 'Categoria desconhecida';
$string['unknownerror'] = 'Erro desconhecido';
$string['unknownuser'] = 'Usuário desconhecido';
$string['unlimited'] = 'Ilimitado';
$string['unpacking'] = 'Unpacking {$a}';
$string['unsafepassword'] = 'Esta senha não é segura - escolha outra';
$string['untilcomplete'] = 'Até completar';
$string['unusedaccounts'] = 'A inscrição de usuários é cancelada automaticamente se a conta não for usada num período de {$a} dias consecutivos';
$string['unzip'] = 'Descompactar';
$string['unzippingbackup'] = 'Descompactando backup';
$string['up'] = 'Para cima';
$string['update'] = 'Atualizar';
$string['updated'] = 'Atualizado {$a}';
$string['updatemymoodleoff'] = 'Parar de personalizar esta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Atualizar perfil';
$string['updatesevery'] = 'Atualizações a cada {$a} segundos';
$string['updatethis'] = 'Atualizar {$a}';
$string['updatethiscourse'] = 'Atualizar este curso';
$string['updatinga'] = 'Atualizando: {$a}';
$string['updatingain'] = 'Atualizando um {$a->what} em {$a->in}';
$string['upload'] = 'Enviar';
$string['uploadafile'] = 'Enviar um arquivo';
$string['uploadcantwrite'] = 'Não foi possível escrever o arquivo no disco';
$string['uploadedfile'] = 'Arquivo enviado com sucesso';
$string['uploadedfileto'] = 'Enviado {$a->file} a {$a->directory}';
$string['uploadedfiletoobig'] = 'Sinto muito, este arquivo é grande demais, o limite é de {$a} bytes';
$string['uploadextension'] = 'Envio de arquivo bloqueado por uma extensão PHP';
$string['uploadfailednotrecovering'] = 'O seu envio de arquivo ao servidor não foi possível por causa de um problema com um dos arquivos: {$a->name}.<br />Este é o log do problema::<br />{$a->problem}<br />Sem recuperação.';
$string['uploadfilelog'] = 'Relatório de envio do arquivo: {$a}';
$string['uploadformlimit'] = 'O tamanho do arquivo {$a} é superior ao limite autorizado neste formulário';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = 'Limite de upload para {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Enviar um novo arquivo';
$string['uploadnofilefound'] = 'Nenhum arquivo foi encontrado - você tem certeza que selecionou um arquivo para enviar?';
$string['uploadnotallowed'] = 'Não é permitido enviar arquivos';
$string['uploadnotempdir'] = 'Diretório temporário ausente';
$string['uploadoldfilesdeleted'] = 'Os velhos arquivos da sua área de arquivos enviados foram excluídos';
$string['uploadpartialfile'] = 'O arquivo foi carregado apenas parcialmente';
$string['uploadproblem'] = 'Ocorreu um problema desconhecido ao enviar o arquivo \'{$a}\' (era muito grande?)';
$string['uploadrenamedchars'] = 'O arquivo foi renomeado de {$a->oldname} para {$a->newname} porque continha caracteres não válidos.';
$string['uploadrenamedcollision'] = 'O arquivo foi renomeado de {$a->oldname} para {$a->newname} pois havia um conflito de nomes de arquivos.';
$string['uploadserverlimit'] = 'O tamanho do arquivo é superior ao limite autorizado pelo servidor';
$string['uploadthisfile'] = 'Enviar arquivo selecionado';
$string['url'] = 'URL';
$string['used'] = 'Usado';
$string['usedinnplaces'] = 'Usado em {$a} lugares';
$string['user'] = 'Usuário';
$string['useraccount'] = 'Conta de usuário';
$string['useractivity'] = 'Atividade';
$string['userconfirmed'] = 'Confirmado {$a}';
$string['userdata'] = 'Dados do usuário';
$string['userdeleted'] = 'Esta conta de usuário foi cancelada';
$string['userdescription'] = 'Descrição';
$string['userdescription_help'] = 'Esta caixa permite que você insira algum texto sobre você mesmo que será exibido em sua página de perfil de usuário para que outras pessoas vejam.';
$string['userdetails'] = 'Detalhes do usuário';
$string['userfiles'] = 'Arquivos do usuário';
$string['userfilterplaceholder'] = 'Pesquise por palavra-chave ou selecione um filtro';
$string['userlist'] = 'Lista de usuários';
$string['usermenu'] = 'Menu do usuário';
$string['username'] = 'Identificação de usuário';
$string['usernameemail'] = 'Identificação / email';
$string['usernameemailmatch'] = 'A identificação de usuário e o email não correspondem ao mesmo usuário';
$string['usernameexists'] = 'Esta identificação de usuário já existe. Escolha outra.';
$string['usernamelowercase'] = 'Apenas letras minúsculas são permitidas';
$string['usernamenotfound'] = 'A identificação de usuário não foi encontrada na base de dados';
$string['usernameoremail'] = 'Insira a identificação de usuário ou endereço de e-mail';
$string['usernotconfirmed'] = 'Não foi possível confirmar {$a}';
$string['userpic'] = 'Foto do usuário';
$string['userpreferences'] = 'Preferências do usuário';
$string['users'] = 'Usuários';
$string['userselectorautoselectunique'] = 'Se somente um usuário corresponder aos critérios da busca, selecione-o automaticamente';
$string['userselectorpreserveselected'] = 'Manter os usuários selecionados, mesmo que eles já não correspondam à busca';
$string['userselectorsearchanywhere'] = 'Encontrar o texto da busca em qualquer lugar nos campos exibidos';
$string['usersnew'] = 'Novos usuários';
$string['usersnoaccesssince'] = 'Inativo por mais de';
$string['userswithfiles'] = 'Usuários com arquivos';
$string['useruploadtype'] = 'Tipo de upload de usuário: {$a}';
$string['userzones'] = 'Zonas';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando curso existente';
$string['valuealreadyused'] = 'Este valor já foi utilizado.';
$string['version'] = 'Versão';
$string['view'] = 'Ver';
$string['viewallcourses'] = 'Ver todos os cursos';
$string['viewallcoursescategories'] = 'Ver todos os cursos e categorias';
$string['viewallsubcategories'] = 'Ver todas as subcategorias';
$string['viewfileinpopup'] = 'Ver arquivo em uma janela pop-up';
$string['viewing'] = 'Visualizando:';
$string['viewmore'] = 'Ver mais';
$string['viewprofile'] = 'Ver perfil';
$string['views'] = 'Visualizações';
$string['viewsolution'] = 'ver solução';
$string['visible'] = 'Visível';
$string['visible_help'] = 'Esta configuração determina se o curso aparece na lista de cursos. Além de professores e administradores, os demais usuários não têm permissão para entrar no curso.';
$string['visibletostudents'] = 'Visível a {$a}';
$string['warning'] = 'Aviso';
$string['warningdeleteresource'] = 'Atenção: {$a} é citado em um recurso. Você quer atualizar este recurso?';
$string['webpage'] = 'Página web';
$string['week'] = 'Semana';
$string['weekhide'] = 'Esconda esta semana de {$a}';
$string['weeklyoutline'] = 'Agenda do Curso';
$string['weeks'] = 'semanas';
$string['weekshow'] = 'Mostre esta semana a {$a}';
$string['welcometocourse'] = 'Bem-vindo ao curso {$a}';
$string['welcometocoursetext'] = 'Bem vindo ao curso {$a->coursename}!

Se você ainda não fez, você deve editar o seu Perfil de Usuário para que possamos conhecer você melhor:

{$a->profileurl}';
$string['whatforlink'] = 'O que você quer fazer com o link?';
$string['whatforpage'] = 'O que você quer fazer com o texto?';
$string['whatisyourage'] = 'Qual é a sua idade?';
$string['whattocallzip'] = 'Que nome você quer dar ao arquivo Zip?';
$string['whattodo'] = 'O que fazer';
$string['wheredoyoulive'] = 'Em qual país você vive?';
$string['whyisthisrequired'] = 'Por que isso é necessário?';
$string['windowclosing'] = 'Esta janela deverá ser fechada automaticamente. Senão, feche-a agora.';
$string['withchosenfiles'] = 'Com arquivos escolhidos';
$string['withdisablednote'] = '{$a} (desativado)';
$string['withoutuserdata'] = 'sem dados de usuário';
$string['withselectedusers'] = 'Com usuários selecionados...';
$string['withuserdata'] = 'com dados de usuário';
$string['wordforstudent'] = 'Sua palavra para Estudante';
$string['wordforstudenteg'] = 'ex . Estudante, Participante etc';
$string['wordforstudents'] = 'Sua palavra para Estudantes';
$string['wordforstudentseg'] = 'ex . Estudantes, Participantes etc';
$string['wordforteacher'] = 'Sua palavra para Professor';
$string['wordforteachereg'] = 'ex. Professor, Tutor, Facilitador etc';
$string['wordforteachers'] = 'Sua palavra para os Professores';
$string['wordforteacherseg'] = 'ex Professores, Tutores, Facilitadores etc';
$string['writingblogsinfo'] = 'Escrevendo informações sobre os blogs';
$string['writingcategoriesandquestions'] = 'Escrevendo categorias e questões';
$string['writingcoursedata'] = 'Escrevendo dados do curso';
$string['writingeventsinfo'] = 'Escrevendo informações dos eventos';
$string['writinggeneralinfo'] = 'Escrevendo informações gerais';
$string['writinggradebookinfo'] = 'Escrevendo informações do livro de notas';
$string['writinggroupingsgroupsinfo'] = 'Escrevendo informações sobre grupamentos';
$string['writinggroupingsinfo'] = 'Escrevendo informações dos grupos';
$string['writinggroupsinfo'] = 'Escrevendo informações dos grupos';
$string['writingheader'] = 'Escrevendo cabeçalho';
$string['writingloginfo'] = 'Escrevendo logs';
$string['writingmessagesinfo'] = 'Escrevendo info das mensagens pessoais';
$string['writingmoduleinfo'] = 'Escrevendo info dos módulos';
$string['writingscalesinfo'] = 'Escrevendo info das escalas';
$string['writinguserinfo'] = 'Escrevendo info dos usuários';
$string['wrongpassword'] = 'Senha incorreta para este usuário';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'ano';
$string['years'] = 'anos';
$string['yes'] = 'Sim';
$string['youareabouttocreatezip'] = 'Você está prestes a criar um arquivo Zip contendo';
$string['youaregoingtorestorefrom'] = 'Você está prestes a iniciar o processo de restauração de';
$string['youhaveupcomingactivitiesdue'] = 'Você possui atividades próximas.';
$string['youhaveupcomingactivitiesdueinfo'] = 'Oi {$a},

<br/><br/>Você tem atividades programadas para:';
$string['youneedtoenrol'] = 'Para realizar esta ação você precisa estar inscrito neste curso.';
$string['yourlastlogin'] = 'Seu último acesso foi em';
$string['yourself'] = 'Você Mesmo';
$string['yourteacher'] = 'seu {$a}';
$string['yourwordforx'] = 'Sua palavra para \'{$a}\'';
$string['zippingbackup'] = 'Compactando o backup';
