<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'eu', version '3.10'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'EGITEKOAK';
$string['activityisscheduledfordeletion'] = 'Jarduera-ezabaketa martxan da...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" ez da balio baliagarria adinerako.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}"(e)k koma banatzaile bat baino gehiago edo gutxiago dauka.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" ez da herrialde-kode baliozkoa.';
$string['agedigitalconsentmapinvaliddefault'] = 'Lehenetsitako (*) balioa falta da.';
$string['agelocationverificationdisabled'] = 'Adina eta kokapenaren egiaztapena desgaituta dago.';
$string['alreadyloggedin'] = 'Dagoeneko {$a} gisa identifikatuta zaude, beste erabiltzaile bat bezala identifikatzeko aurretik irten behar zara.';
$string['authnotexisting'] = 'Autorizazio-plugina ez da existitzen';
$string['backupcontainexternal'] = 'Segurtasun-fitxategi honek lokalean konfiguratuta ez dauden kanpoko Moodle sarerako ostalariak ditu.';
$string['backuptablefail'] = 'Segurtasun-kopiaren taulak EZ dira ondo sortu!';
$string['blockcannotconfig'] = 'Bloke honek ez ditu ezarpen orokorrak onartzen';
$string['blockcannotinistantiate'] = 'Arazoa bloke-objektuaren instantzia egitean';
$string['blockcannotread'] = 'Ondorengo bloke id-tik ezin da daturik irakurri= {$a}';
$string['blockdoesnotexist'] = 'Bloke hau ez da existitzen';
$string['blockdoesnotexistonpage'] = 'Bloke hau (id={$a->instanceid}) ez da existitzen orri honetan: ({$a->url}).';
$string['blocknameconflict'] = 'Izenen arteko gatazka: {$a->name} blokeak dagoeneko baden beste bloke honen izenburu bera du: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Moduluak ez du iruzkin hau onartzen.';
$string['cannotaddcoursemodule'] = 'Ezin da ikastaro-modulu berria gehitu';
$string['cannotaddcoursemoduletosection'] = 'Ezin da ikastaro-modulu berria gehitu atal honetan';
$string['cannotaddmodule'] = '{$a} modulua ezin da gehitu modulu-zerrendara!';
$string['cannotaddnewmodule'] = 'Ezin da modulu berria gehitu {$a} -rako';
$string['cannotaddrss'] = 'Ez duzu baimenik RSS jarioak gehitzeko';
$string['cannotaddthisblocktype'] = 'Ezin duzu {$a} blokea gehitu orri honetan.';
$string['cannotassignrole'] = 'Ezin da ikastaroan rola ezarri';
$string['cannotassignrolehere'] = 'Ez duzu baimenik rol hau (id = {$a->roleid}) esleitzeko testuinguru honetan ({$a->context})';
$string['cannotassignselfasparent'] = 'Ezin da berau ezarri goragoko gisa!';
$string['cannotcallscript'] = 'Ezin duzu script hau horrela deitu';
$string['cannotcallusgetselecteduser'] = 'Ezin duzu user_selector::get_selected_user deitu aukera anitzekoa egia bada.';
$string['cannotcreatebackupdir'] = 'Ezin da backupdata karpeta sortu. Guneko kudeatzaileak fitxategien baimenak ezarri behar ditu';
$string['cannotcreatecategory'] = 'Kategoria ez da txertatu';
$string['cannotcreatedboninstall'] = '<p>Ezin da datu-basea sortu.</p>
<p>Zehaztutako datu-basea ez da existitzen eta adierazitako erabiltzaileak ez du baimenik datu-basea sortzeko.</p>
<p>Guneko kudeatzaileak datu-basearen konfigurazioa egiaztatu behar du.</p>';
$string['cannotcreategroup'] = 'Errorea taldea sortzean';
$string['cannotcreatelangbase'] = 'Errorea: ezin izan da oinarrizko hizkuntza-direktorioa sortu';
$string['cannotcreatelangdir'] = 'Ezin da hizkuntza-direktorioa sortu';
$string['cannotcreateorfindstructs'] = 'Errorea ikastaro honetarako atal-egitura bilatzean edo sortzean';
$string['cannotcreatepopupwin'] = 'Definitu gabeko elementua - ezin da sortu pop-up leihorik';
$string['cannotcreatesitedir'] = 'Ezin da guneko karpetarik sortu. Guneko kudetzaileak ezarri behar ditu fitxategirako baimenak';
$string['cannotcreatetempdir'] = 'Ezin da temp direktorioa sortu';
$string['cannotcreateuploaddir'] = 'Ezin da jaitsitakoetarako karpetarik sortu. Guneko kudetzaileak ezarri behar ditu fitxategirako baimenak';
$string['cannotcustomisefiltersblockuser'] = 'Ezin duzu ezarpen-iragazkirik pertsonalizatu erabiltzaileen edo blokeen testuinguruetan.';
$string['cannotdeletebackupids'] = 'Ezin izan dira aurreko segurtasun-kopien IDak ezabatu';
$string['cannotdeletecategorycourse'] = '\'{$a}\' ikastaroaren ezabaketak huts egin du.';
$string['cannotdeletecategoryquestions'] = 'Ezin dira galderak ezabatu \'{$a}\' kategoriatik';
$string['cannotdeletecourse'] = 'Ez duzu ikastaro hau ezabatzeko baimenik';
$string['cannotdeletecustomfield'] = 'Errorea pertsonalizatutako eremuen datuak ezabatzean';
$string['cannotdeletedir'] = 'Ezin da ezabatu ({$a})';
$string['cannotdeletefile'] = 'Ezin da ezabatu fitxategi hau';
$string['cannotdeleterole'] = 'Ezin da ezabatu, zeren {$a}';
$string['cannotdeleterolewithid'] = 'Ezin da {$a} ID-a duen rola ezabatu';
$string['cannotdeletethisrole'] = 'Ezin duzu rola hau ezabatu sistemak erabiltzen duelako edo kudeatzailearen gaitasunak dituen azkena delako.';
$string['cannotdisableformat'] = 'Formatu lehenetsia ezin da desgaitu.';
$string['cannotdownloadcomponents'] = 'Ezin dira osagaiak jaitsi';
$string['cannotdownloadlanguageupdatelist'] = 'Ezin da download.moodle.org-tik eguneratzeko hizkuntza-zerrenda jaitsi';
$string['cannotdownloadzipfile'] = 'Ezin da ZIP fitxategia jaitsi';
$string['cannoteditcomment'] = 'Iruzkin hau ez da zurea eta ezin duzu editatu!';
$string['cannoteditcommentexpired'] = 'Ezin duzu hau editatu. Denbora amaitu egin da!';
$string['cannoteditpostorblog'] = 'Ezin duzu mezurik bidali edo bloga editatu';
$string['cannoteditsiteform'] = 'Ezin duzu guneko ikastaroa editatu formulario hau erabilita';
$string['cannotedituserpreferences'] = 'Ezin dira erabiltzale honen hobespenak editatu';
$string['cannotedityourprofile'] = 'Sentitzen dugu, ezin duzu zure profila editatu';
$string['cannotexecduringupgrade'] = 'Ezin izango da exekutatu eguneratzea egiten den bitartean';
$string['cannotfindcategory'] = 'Ezin da  datu-basearen kategoriaren erregistroa aurkitu  ID-ren bidez - {$a}';
$string['cannotfindcomponent'] = 'Ezin da osagaia aurkitu';
$string['cannotfindcontext'] = 'Ezin da testuingurua aurkitu';
$string['cannotfindcourse'] = 'Ezin da ikastaroa aurkitu';
$string['cannotfinddocs'] = 'Ezin dira "{$a}" hizkuntzaren docs fitxategiak aurkitu';
$string['cannotfindgradeitem'] = 'Ezin da grade_item aurkitu';
$string['cannotfindgroup'] = 'Ezin da taldea aurkitu';
$string['cannotfindhelp'] = 'Ezin dira "{$a}" hizkuntzaren laguntza-fitxategiak aurkitu';
$string['cannotfindinfo'] = 'Ezin da ondokoarentzako informaziorik aurkitu: "{$a}"';
$string['cannotfindlang'] = 'Ezin da "{$a}" hizkuntza-paketea aurkitu!';
$string['cannotfindteacher'] = 'Ezin da irakaslea aurkitu';
$string['cannotfinduser'] = 'Ezin da "{$a}" erabiltzaile-izena aurkitu';
$string['cannotgeoplugin'] = 'Ezin da geoPlugin-en  zerbitzarira konektatu (https://www.geoplugin.com). Mesedez, egiaztatu proxy-aren ezarpenak edo instalatu ezazu MaxMind GeoLite City-ren datu-fitxategia.';
$string['cannotgetblock'] = 'Ezin da blokerik berreskuratu datu-basetik';
$string['cannotgetcats'] = 'Ezin da lortu kategoria-erregistrorik';
$string['cannotgetdata'] = 'Ezin da daturik lortu';
$string['cannotgradeuser'] = 'Ezin da erabiltzaile hau kalifikatu';
$string['cannothaveparentcate'] = 'Ikastaro-kategoriak ezin du goragokorik izan!';
$string['cannotimport'] = 'Errorea inportatzean';
$string['cannotimportformat'] = 'Sentitzen dugu, formatu hau inportatzea ez dago oraindik indarrean!';
$string['cannotimportgrade'] = 'Errorea kalifikazioak inportatzean';
$string['cannotinsertgrade'] = 'Ezin da kalifikazio-elementurik txertatu ikastaroaren ID-rik gabe!';
$string['cannotinsertrate'] = 'Ezin da beste kalifikazio bat txertatu ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Ezin da {$a} ID-a duen erregistro berria txertatu';
$string['cannotmailconfirm'] = 'Errorea pasahitza aldatzeko berresteko e-maila bidaltzean';
$string['cannotmanualctrack'] = 'Jarduerak ez du eskuz osatutzat emateko jarraipenik';
$string['cannotmapfield'] = 'Parekatze kolisioa aurkitu da - bi eremuk kalifikazio-elementu berarekin parekatuta daude {$a}';
$string['cannotmarktopic'] = 'Ezin da gai hau markatu ikastaro honetan';
$string['cannotmigratedatacomments'] = 'Ezin dira iruzkinak migratu datuen modulutik';
$string['cannotmodulename'] = 'Ezin da modulu-izena lortu nabigazioa eraikitzean';
$string['cannotmoduletype'] = 'Ezin da modulu mota lortu nabigazioa eraikitzean';
$string['cannotmovecategory'] = 'Ezin da kategoria mugitu';
$string['cannotmovecourses'] = 'Ezin dira ikastaroak daudeneko kategoriatik beste batera mugitu.';
$string['cannotmoverolewithid'] = 'Ezin da {$a} ID-a duen rola mugitu';
$string['cannotopencsv'] = 'Ezin da CSV fitxategia zabaldu';
$string['cannotopenfile'] = 'Ezin da fitxategia zabaldu ({$a})';
$string['cannotopenforwrit'] = 'Ezin da zabaldu idazteko: {$a}';
$string['cannotopentemplate'] = 'Ezin da txantiloi-fitxategia zabaldu ({$a})';
$string['cannotopenzip'] = 'Ezin da zip fitxategia zabaldu, ziur aski 64 bit-eko sistema eragileko zip hedapenean dagoen arazo bat dela-eta.';
$string['cannotoverridebaserole'] = 'Ezin dira oinarrizko rolaren gaitasunak baliogabetu';
$string['cannotoverriderolehere'] = 'Ez duzu (id = {$a->roleid}) rola  ({$a->context}) testuinguruan baliogabetzeko baimenik';
$string['cannotreadfile'] = 'Ezin da fitxategia irakurri ({$a})';
$string['cannotreadtmpfile'] = 'Errorea aldi baterako fitxategia irakurtzean';
$string['cannotreaduploadfile'] = 'Ezin da jaitsitako fitxategia irakurri';
$string['cannotremovefrommeta'] = 'Ezin da aukeratutako ikastaroa meta-ikastaro honetatik kendu!';
$string['cannotreprocessgrades'] = 'Ezin izan dira jarduera honen graduak berriz prozesatu {$a}';
$string['cannotresetguestpwd'] = 'Ezin duzu bisitarien pasahitza berrabiarazi';
$string['cannotresetmail'] = 'Errorea pasahitza berrezartzean eta zuri bidaltzean';
$string['cannotresetthisrole'] = 'Ezin da rol hau berrabiarazi';
$string['cannotrestore'] = 'Errorea gertatu da eta ezin izan guztiz berreskuratu!';
$string['cannotrestoreadminorcreator'] = 'Ikastaro-sortzailea edo kudeatzailea izan behar duzu ikastaro bat berreskuratu ahal izateko!';
$string['cannotrestoreadminoredit'] = 'Edizio baimena duen irakaslea edo kudeatzailea izan behar duzu aukeratutako ikastaroa berrabiarazteko!';
$string['cannotsaveagreement'] = 'Ezin da zure akordioa gorde';
$string['cannotsaveblock'] = 'Errorea blokearen ezarpenak gordetzean';
$string['cannotsavecomment'] = 'Ezin da iruzkina gorde';
$string['cannotsavedata'] = 'Ezin dira datuak gorde';
$string['cannotsavefile'] = 'Ezin da "{$a}" fitxategia gorde!';
$string['cannotsavemd5file'] = 'Ezin da Md5 fitxategia gorde';
$string['cannotsavezipfile'] = 'Ezin da ZIP fitxategia gorde';
$string['cannotservefile'] = 'Ezin da fitxategia erakutsi zerbitzariaren konfigurazio-arazo bat dela-eta.';
$string['cannotsetparentforcatoritem'] = 'Ezin da ezarri goragokorik kategoria edo ikastaro-elementurako!';
$string['cannotsetpassword'] = 'Ezin da ezarri erabiltzaile-pasahitzik!';
$string['cannotsetprefgrade'] = 'Ezin izan da aggregationview hobespena {$a}(e)ra ezarri kalifikazio-kategoria honetan';
$string['cannotsettheme'] = 'Ezin da azala ezarri!';
$string['cannotsetupblock'] = 'Blokeen taulak EZ dira ondo sortu!';
$string['cannotsetupcapformod'] = 'Ezin dira gaitasunak esleitu honentzat: {$a}';
$string['cannotsetupcapforplugin'] = 'Ezin dira gaitasunak esleitu honentzat: {$a}';
$string['cannotshowhidecoursesincategory'] = 'Ezin dira ikastaroak erakutsi/ezkutatu {$a} kategorian.';
$string['cannotsignup'] = 'Ezin duzu konturik sortu dagoeneko saioa hasi duzulako {$a} gisa.';
$string['cannotunassigncap'] = 'Ezin izan zaio {$a->role} rolari zaharkitutako {$a->cap} gaitasuna kendu.';
$string['cannotunassignrolefrom'] = 'Ezin zaio erabiltzaie honi {$a} ID-a duen rola kendu';
$string['cannotunzipfile'] = 'Ezin da fitxategia deskonprimatu';
$string['cannotupdatemod'] = 'Ezin da {$a} eguneratu';
$string['cannotupdatepasswordonextauth'] = 'Errorea gertatu da kanpoko autentifikazio-sisteman pasahitza eguneratzean: {$a}. Ikusi zerbitzariko erregistroak xehetasun gehiagorako.';
$string['cannotupdateprofile'] = 'Errorea erabiltzailearen erregistroa eguneratzean';
$string['cannotupdaterecord'] = 'Ezin da eguneratu {$a} ID-a duen erregistroa';
$string['cannotupdaterss'] = 'Ezin da RSS jarioa eguneratu';
$string['cannotupdatesubcourse'] = 'Ezin da beheragoko ikastaroa eguneratu!';
$string['cannotupdateusermsgpref'] = 'Ezin dira erabiltzailearen mezularitza-hobespenak eguneratu';
$string['cannotupdateuseronexauth'] = 'Ezin izan dira erabiltzailearen datuak eguneratu kanpoko autentifikazioan: {$a}. Ikusi zerbitzariaren erregistroak xehetasun gehiagotarako.';
$string['cannotuploadfile'] = 'Errorea eguneratutako fitxategia prozesatzean';
$string['cannotuseadmin'] = 'Kudeatzailea izan behar duzu orri hau erabili ahal izateko';
$string['cannotuseadminadminorteacher'] = 'Kudeatzailea edo irakaslea izan behar duzu orri hau erabili ahal izateko';
$string['cannotusepage'] = 'Irakasleek edo kudeatzaileek baino ezin dute orri hau erabili';
$string['cannotusepage2'] = 'Sentitzen dugu, ezin duzu orri hau erabili';
$string['cannotviewcategory'] = 'Ez duzu baimenik ikastaro-zerrenda hau ikusteko.';
$string['cannotviewprofile'] = 'Ezin duzu erabiltzaile honen profila ikusi';
$string['cannotviewreport'] = 'Ezin duzu txosten hau ikusi';
$string['cannotwritefile'] = 'Ezin da fitxategian idatzi ({$a})';
$string['categoryerror'] = 'Kategoria-errorea';
$string['categoryidnumbertaken'] = 'ID zenbakia dagoeneko erabilita dago beste kategoria batean';
$string['categorynamerequired'] = 'Kategoria-izena derrigorrezkoa da';
$string['categorytoolong'] = 'Kategoriaren izena luzeegia';
$string['commentmisconf'] = 'Iruzkinaren IDa gaizki konfiguratuta dago';
$string['componentisuptodate'] = 'Osagaia eguneratu da';
$string['confirmationnotenabled'] = 'Erabiltzaileen berrespena ez dago gaituta gune honetan.';
$string['confirmsesskeybad'] = 'Sentitzen dugu, baina ekintza hau egiteko zure saio-pasahitza ezin izan da baieztatu. Segurtasun-ezaugarri honek zure izenean, ustekabean edo fede txarrez, eginkizun garrantzitsuen exekutatzea saihesten du. Eginkizun hori exekutatu nahi duzula ziur izan, mesedez.';
$string['contenttypenotfound'] = '\'{$a}\' eduki-banku mota ez da existitzen edo ezezaguna da.';
$string['couldnotassignrole'] = 'Zuri rol bat ezartzean zehaztu gabeko arazo larria gertatu da.';
$string['couldnotupdatenoexistinguser'] = 'Ezin da eguneratu erabitlzailea - erabitlzailea ez dago';
$string['couldnotverifyagedigitalconsent'] = 'Errorea gertatu da onespen-adin digitala egiaztatzean.<br />Mesedez, jarri harremanetan kudeatzailearekin.';
$string['countriesphpempty'] = 'Errorea: {$a} hizkuntza-paketeko countries.php fitxategia hutsik edo galduta dago';
$string['coursedoesnotbelongtocategory'] = 'Ikastaroa ez da kategoria honetakoa';
$string['courseformatnotfound'] = '\'{$a}\' ikastaro-formatua ez da existitzen edo ezezaguna da.';
$string['coursegroupunknown'] = '{$a} taldeari dagokion ikastaroa ez da zehaztu';
$string['courseidnotfound'] = 'Ikastaroaren IDa ez da existitzen.';
$string['courseidnumbertaken'] = 'ID zenbakia dagoeneko erabilita dago beste ikastaro batean  ({$a})';
$string['coursemisconf'] = 'Ikastaroa gaizki konfiguratuta dago';
$string['courserequestdisabled'] = 'Sentitzen dugu, baina ikastaro-eskariak egiteko modua kudeatzaileak desgaitu du.';
$string['csvcolumnduplicates'] = 'Bikoiztutako zutabeak aurkitu dira';
$string['csvemptyfile'] = 'CSV fitxategia hutsik dago';
$string['csvfewcolumns'] = 'Ez dago zutabe nahikorik, mesedez egiazta ezazu bereizlearen ezarpena';
$string['csvfileerror'] = 'Arazoren bat dago CSV fitxategiaren formatuarekin. Egiaztatu ezazu mesedez zutabe-izenburu eta zutabe kopuruak bat datozela eta zutabe-bereizlea zein fitxategiaren kodifikazioa egokiak direla. {$a}';
$string['csvinvalidcols'] = '<b>CSV fitxategi baliogabea:</b> Lehen errenkadak "Header Fields" izan behar du eta fitxategiak <br />"Expanded Fields/Comma Separated"<br />edo<br /> "Expanded Fields with CAVV Result Code/Comma Separated" motakoa izan behar du';
$string['csvinvalidcolsnum'] = 'CSV fitxategi ezegokia - lerro bakoitzak 49 edo 70 eremu izan behar ditu';
$string['csvloaderror'] = 'Errorea gertatu da CVS fitxategia igotzean: {$a}';
$string['csvnodata'] = 'CSV fitxategi baliogabea - CSV fitxategiak zutabe-izenburuak ditu baina ez dauka daturik';
$string['csvweirdcolumns'] = 'CSV fitxategi-formatuak ez du balio - zutabe-kopurua ez da beti bat!';
$string['dbconnectionfailed'] = '<p>Errorea: Datu-baseko konexioak huts egin du</p>
<p>Baliteke datu-basea gainkargatuta egotea edo bestela ez dabil ondo.</p>
<p>Guneko kudeatzaileak datu-basearen xehetasunak config.php fitxategian ondo xehaztuta daudela konprobatu beharko luke.</p>';
$string['dbdriverproblem'] = '<p>Errorea: datu-baseko kontrolatzailean arazoa antzeman da</p>
<p>Guneko kudeatzaileak zerbitzariaren konfigurazioa egiaztatu beharko luke</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Datu-basean arazo larria gertatu da.<br /><br />Mesedez, jakinarazi zerbitzariaren kudeatzaileari.';
$string['dbsessionhandlerproblem'] = 'Datu-baseko saioaren konfigurazioak huts egin du. Mesedez jakinarazi zerbitzariaren kudeatzaileari.';
$string['dbsessionmysqlpacketsize'] = 'Saioan errore larria atzeman da. Mesedez, jakinarazi guneko kudeatzaileari; errore hau max_allowed_packet  MySQL ezarpenean balio handiegia ezarri delako gertatuko zen ziurrenik.';
$string['dbupdatefailed'] = 'Datu-basearen eguneratzeak huts egin du';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" ezin da aldatu. Mendekotasuna aurkitu da honekiko: {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Errorea DDL sql exekutatzean';
$string['ddlfieldalreadyexists'] = '"{$a}" eremua badago dagoeneko';
$string['ddlfieldnotexist'] = '"{$a->fieldname}" eremua ez da "{$a->tablename}" taulan existitzen';
$string['ddltablealreadyexists'] = 'Bada dagoeneko "{$a}" taula';
$string['ddltablenotexist'] = '"{$a}" taula ez da existitzen';
$string['ddlunknownerror'] = 'DDL liburutegiaren errore ezezaguna';
$string['ddlxmlfileerror'] = 'XML datu-base fitxategiak erroreak ditu';
$string['ddsequenceerror'] = '"{$a}" taularen definizioa ez da egokia; zutabe automatiko bakarra egon daiteke eta gako gisa definituta egon behar da.';
$string['destinationcmnotexit'] = 'Helmuga-ikastaroaren modulua ez da existitzen';
$string['detectedbrokenplugin'] = '"{$a}" plugina ez dago ondo edo zaharkituta dago. Sentitzen dugu baina ezin duzu aurrera egin.';
$string['dmlexceptiononinstall'] = '<p>Datu-basearen errorea gertatu da [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Errorea SQL kontsulta aztertzean';
$string['dmlreadexception'] = 'Errorea datu-basetik irakurtzean';
$string['dmltransactionexception'] = 'Errorea datu-basearekiko transakzioan';
$string['dmlwriteexception'] = 'Errorea datu-basean idaztean';
$string['downgradedcore'] = 'ERROREA! Erabiltzen ari zaren kodea ZAHARRAGOA da datu-base hauek eraiki zituen bertsioa baino.';
$string['downloadedfilecheckfailed'] = 'Jaitsitako fitxategiaren egiaztatzeak huts egin du.';
$string['duplicatefieldname'] = '"{$a}" eremuaren izen bikoiztua atzeman da';
$string['duplicatenosupport'] = '\'{$a->modname}\' jarduera ezin da bikoiztu {$a->modtype} moduluak ez duelako segurtasun-kopia eta berreskuratzea onartzen.';
$string['duplicateparaminsql'] = 'ERROREA: parametro bikoiztua kontsultan';
$string['duplicaterolename'] = 'Dagoeneko bada izen hori duen rola!';
$string['duplicateroleshortname'] = 'Dagoeneko bada izen labur hori duen rola!';
$string['duplicateusername'] = 'Bikoiztutako erabiltzaile-izena - erregistroa alde batera utzi da';
$string['emailfail'] = 'E-mail bidaltzeak huts egin du';
$string['enddatebeforestartdate'] = 'Ikastaroaren amaiera-data hasiera-data baino beranduago izan behar da.';
$string['error'] = 'Errorea gertatu da';
$string['error_question_answers_missing_in_db'] = 'Ezin izan da "{$a->answer}"-(r)ekin bat datorren erantzunik aurkitu datu-baseko question_answers taulan. Hau  {$a->filequestionid} IDa duen galdera segurtasun-kopiatik berreskuratzean gertatu da, {$a->dbquestionid} IDa duen datu-basean existitzen den galderarekin lotu dena.';
$string['errorcleaningdirectory'] = 'Errorea gertatu da "{$a}" direktorioa garbitzean';
$string['errorcopyingfiles'] = 'Errorea fitxategiak kopiatzean';
$string['errorcreatingdirectory'] = 'Errorea "{$a}" direktorioa sortzean';
$string['errorcreatingfile'] = 'Errorea "{$a}" fitxategia sortzean';
$string['errorcreatingrole'] = 'Errorea rola sortzean';
$string['errorfetchingrssfeed'] = 'Errorea RSS jarioa lortzean.';
$string['erroronline'] = 'Errorea {$a} lerroan';
$string['erroroutput'] = 'Irteeran erroreak daude, eta ondorioz berbideratze automatikoa desgaituko da.';
$string['errorparsingxml'] = 'Errorea XMLa aztertzean: {$a->errorstring} {$a->errorline} lerroan,  {$a->errorchar} karakterea';
$string['errorprocessingarchive'] = 'Errorea artxibo-fitxategia prozesatzean';
$string['errorreadingfile'] = 'Errorea "{$a}" fitxategia irakurtzean';
$string['errorsavingrequest'] = 'Errorea gertatu da zure eskaria gordetzean.';
$string['errorsettinguserpref'] = 'Errorea erabiltzailearen hobespenak ezartzean';
$string['errorunzippingfiles'] = 'Errorea fitxategiak deskonprimatzean';
$string['expiredkey'] = 'Iraungitako giltza';
$string['externalauthpassworderror'] = 'Hutsik ez dagoen pasahitza kanpoko autentifikaziorako.';
$string['externalfilenolocation'] = 'Kanpo-fitxategiak ez du kokapen-biderik';
$string['failtoloadblocks'] = 'Bloke bat edo bat baino gehiago erregistratuta daude datu-basean baina guztiek egin dute kale kargatzean!';
$string['fieldrequired'] = '"{$a}" derrigorrezko eremua da';
$string['fileexists'] = 'Fitxategia dagoeneko badago';
$string['filemismatch'] = 'Sistemakoa ez den fitxategia ez dator bat. "{$a->current}" fitxategia {$a->file} izan beharko litzateke';
$string['filenotfound'] = 'Sentitzen dugu, baina eskatutako fitxategia ezin izan dugu aurkitu';
$string['filenotreadable'] = 'Fitxategia ez da irakurtzeko modukoa';
$string['filterdoesnothavelocalconfig'] = '{$a} iragazkiak ez du lokaleko konfigurazioa baimentzen.';
$string['filternotactive'] = '{$a} iragazkia ez dago une honetan indarrean';
$string['filternotenabled'] = 'Iragazkia ez dago gaituta!';
$string['filternotinstalled'] = '{$a} iragazkia ez dago une honetan instalatuta';
$string['forumblockingtoomanyposts'] = 'Foro honetara bidalitako mezu-kopuruaren atalasea gainditu duzu';
$string['functionalityremoved'] = 'Ezabatu den funtzionalitate batera sartzen saiatzen ari zara.';
$string['generalexceptionmessage'] = 'Salbuespena - {$a}';
$string['gradecantregrade'] = 'Errorea gertatu da kalifikazioa kalkulatu bitartean: {$a}';
$string['gradepubdisable'] = 'Kalifikazioak argitaratzea desgaituta dago';
$string['gradesneedregrading'] = 'Ikastaroko kalifikazioak berriz kalkulatu behar dira';
$string['groupalready'] = 'Erabiltzailea oraindik da {$a} taldeko partaidea';
$string['groupexistforcourse'] = 'Ikastaro honetan dagoeneko bada "{$a}" taldea';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: "{$a->idnumber}" ID zenbakia duen "{$a->name}" taldea dagoeneko ikastaro honetan existitzen da.';
$string['grouphasidnumber'] = '"{$a}" taldeak ID zenbakia dauka eta agian kanpoko sistema batean sortu da. Ez duzu talde hau ezabatzeko baimenik.';
$string['groupinghasidnumber'] = '"{$a}" talde-multzoak ID zenbakia dauka eta agian kanpoko sistema batean sortu da. Ez duzu talde-multzo hau ezabatzeko baimenik.';
$string['groupingnotaddederror'] = '"{$a}" talde-multzoa ez da gehitu';
$string['groupnotaddederror'] = '"{$a}" taldea ez da gehitu';
$string['groupnotaddedtogroupingerror'] = '"{$a->groupname}" taldea ez da  "{$a->groupingname}" talde-multzora gehitu';
$string['groupunknown'] = '{$a} taldea ez da inongo ikastarokoa';
$string['groupusernotmember'] = 'Erabiltzailea ez da talde honetako kidea';
$string['guestcantaccessprofiles'] = 'Bisitariek ez dute erabiltzaile-profiletarako sarbiderik. Zure kontuarekin sartu zaitez aurrera egiteko.';
$string['guestnocomment'] = 'Bisitariek ez dute mezuen iruzkinak egiteko baimenik';
$string['guestnoeditprofile'] = 'Erabiltzaile bisitariek ezin dute beren profila editatu.';
$string['guestnoeditprofileother'] = 'Ezinezkoa da bisitarien profila editatzea.';
$string['guestnorate'] = 'Bisitariek ez dute sarrerak kalifikatzeko baimenik';
$string['guestsarenotallowed'] = 'Bisitari-rola ez dago honetarako baimenduta';
$string['hackdetected'] = 'Hack-en erasoa atzeman da!';
$string['hashpoolproblem'] = 'Fitxategi-gunearen edukia ez da egokia {$a}';
$string['headersent'] = 'Goiburuak dagoeneko bidali dira';
$string['idnumbertaken'] = 'ID zenbakia dagoeneko erabiltzen ari da';
$string['idnumbertoolong'] = 'ID zenbakia luzeegia da';
$string['importformatnotimplement'] = 'Sentitzen dugu, formatu hau inportatzea ez dago oraindik';
$string['incorrectext'] = 'Fitxategiaren luzapena ezegokia da';
$string['inplaceeditableerror'] = 'Errorea eguneratze-prozesatzaileari deitzean';
$string['installproblem'] = 'Normalean ezinezkoa izaten da instalazioan gertatutako erroreetatik berreskuratzea, baliteke datu-base berri bat sortu behar izatea edo datu-base aurrizki ezberdin bat erabiltzea instalatzen berriz saiatzeko.';
$string['internalauthpassworderror'] = 'Pasahitza falta da edo pasahitz-politika ez da baliagaria barne-autentifikaziorako';
$string['invalidaccess'] = 'Orri honetarako sarbidea ez da zuzena izan';
$string['invalidaccessparameter'] = 'Sarbiderako parametro baliogabea';
$string['invalidaction'] = 'Ekintzarako parametro baliogabea';
$string['invalidactivityid'] = 'Jardueraren ID baliogabea';
$string['invalidadminsettingname'] = 'Kudeatzaile ezarpen baliogabea ({$a})';
$string['invalidargorconf'] = 'Ez dira beharrezko argumentuak eman edo zerbitzaria ez dago ondo konfiguratuta';
$string['invalidarguments'] = 'Ez dago emandako argumentu baliagarririk';
$string['invalidblockinstance'] = 'Blokearen instantzia ez da baliagarria honentzat: {$a}';
$string['invalidbulkenrolop'] = 'Matrikulazio masiboko eragiketa baliogabea eskatu da.';
$string['invalidcategory'] = 'Kategoria ezegokia!';
$string['invalidcategoryid'] = 'Kategoriaren ID ezegokia!';
$string['invalidcomment'] = 'Iruzkina ez da egokia';
$string['invalidcommentarea'] = 'Iruzkinen eremua ez da baliagarria';
$string['invalidcommentid'] = 'Iruzkinaren ID baliogabea';
$string['invalidcommentitemid'] = 'Iruzkinaren item ID baliogabea';
$string['invalidcommentparam'] = 'Iruzkinaren parametro baliogabeak';
$string['invalidcomponent'] = 'Osagaiaren izen baliogabea';
$string['invalidconfirmdata'] = 'Datuen egiaztapen baliogabea';
$string['invalidcontentid'] = 'Edukiaren ID baliogabea';
$string['invalidcontext'] = 'Testuinguru baliogabea';
$string['invalidcountrycode'] = 'Herrialde-kode baliogabea: {$a}';
$string['invalidcourse'] = 'Ikastaro baliogabea';
$string['invalidcourseformat'] = 'Ikastaro-formatu baliogabea';
$string['invalidcourseid'] = 'Ikastaroaren ID baliogabea ari zara erabiltzen';
$string['invalidcourselevel'] = 'Testuinguru-maila ez da egokia';
$string['invalidcoursemodule'] = 'Ikastaro-moduluaren ID-a baliogabea da';
$string['invalidcoursenameshort'] = 'Ikastaroaren izen laburra baliogabea da';
$string['invaliddata'] = 'Bidalitako data ez da egokia';
$string['invaliddatarootpermissions'] = 'Baimen baliogabeak antzeman dira direktorioa sortzen saiatzean. Gaitu arazketa xehetasun gehiago lortzeko.';
$string['invaliddevicetype'] = 'Gailu mota baliogabea';
$string['invalidelementid'] = 'Elementuaren ID ezegokia!';
$string['invalidentry'] = 'Hau ez da sarrera baliagarria!';
$string['invalidevent'] = 'Ekitaldi baliogabea';
$string['invalidfieldname'] = '"{$a}"  ez da izen baliagarria eremu honetarako';
$string['invalidfiletype'] = '"{$a}" ez da fitxategi mota baliagarria';
$string['invalidformatpara'] = 'Formatua ez da egokia parametroa aukeratzeko';
$string['invalidformdata'] = 'Datu-formularioa ez da egokia';
$string['invalidfunction'] = 'Funtzioa ez da egokia';
$string['invalidgradeitemid'] = 'Kalifikazio-elementuaren ID ezegokia';
$string['invalidgroupid'] = 'Taldearen ID ezegokia zehaztu da';
$string['invalidipformat'] = 'IP helbide-formatu honek ez du balio';
$string['invaliditemid'] = 'Elementuaren IDa ezegokia';
$string['invalidkey'] = 'Giltza ez da zuzena';
$string['invalidlanguagecode'] = 'Hizkuntza-kode baliogabea: {$a}';
$string['invalidlegacy'] = 'Zaharkitutako rol definizio ezegokia mota honentzat: {$a}';
$string['invalidmd5'] = 'Kontrolerako aldagaia gaizki zegoen - saiatu berriz ere';
$string['invalidmode'] = 'Modu baliogabea ({$a})';
$string['invalidmodule'] = 'Modulu baliogabea';
$string['invalidmoduleid'] = 'Moduluaren ID baliogabea: {$a}';
$string['invalidmodulename'] = 'Moduluaren izen baliogabea: {$a}';
$string['invalidnum'] = 'Zenbakizko balio ezegokia';
$string['invalidnumkey'] = 'Baliteke $conditions array-ak zenbakizkoak ez diren giltzak izatea. Konpondu ezazu kodea mesedez!';
$string['invalidoutcome'] = 'Ikaste-emaitzaren ID ezegokia';
$string['invalidpagesize'] = 'Orriaren tamaina baliogabea';
$string['invalidpasswordpolicy'] = 'Pasahitzen politika baliogabea';
$string['invalidpaymentmethod'] = 'Ordainketa-metodo baliogabea: {$a}';
$string['invalidqueryparam'] = 'ERROREA: kontsultaren parametro kopuru ezegokia. {$a->expected} espero ziren eta {$a->actual} eskuratu dira.';
$string['invalidratingarea'] = 'Kalifikazioen eremua ez da baliagarria';
$string['invalidrecord'] = 'Ezin da datuen erregistroa aurkitu datu-basearen {$a} taulan.';
$string['invalidrecordunknown'] = 'Ezin da datuen erregistroa aurkitu datu-basean.';
$string['invalidrequest'] = 'Eskari baliogabea';
$string['invalidrole'] = 'Rol baliogabea';
$string['invalidroleid'] = 'Rolaren ID baliogabea';
$string['invalidscaleid'] = 'Eskalaren IDa ezegokia';
$string['invalidsection'] = 'Ikastaro moduluaren erregistroak atal baliogabea dauka';
$string['invalidsesskey'] = 'Badirudi zure saioa iraungi dela. Mesedez, sar zaitez berriz.';
$string['invalidshortname'] = 'Ikastaroaren izen labur baliogabea';
$string['invalidsourcefield'] = 'Zirriborro-fitxategiaren jatorrizko eremua ez da baliozkoa';
$string['invalidstatedetected'] = 'Zerbait gaizki joan da: {$a}. Honek ez luke normalean gertatu behar.';
$string['invalidurl'] = 'URL baliogabea';
$string['invaliduser'] = 'Erabiltzaile baliogabea';
$string['invaliduserdata'] = 'Erabiltzaile-datu baliogabea: {$a}';
$string['invaliduserfield'] = 'Erabiltzailearen eremu baliogabea: {$a}';
$string['invaliduserid'] = 'Erabiltzailearen ID baliogabea';
$string['invalidusername'] = 'Emandako erabiltze-izenak karaktere baliogabeak ditu';
$string['invalidusernameblank'] = 'Erabiltzailearen izena ezin da hutsik utzi';
$string['invalidxmlfile'] = '"{$a}" ez da XML fitxategi baliagarria.';
$string['iplookupfailed'] = 'Ezin da {$a} IP helbidearen kokapenari buruzko informaziorik aurkitu';
$string['iplookupprivate'] = 'Ezin da IP helbide pribatuen informaziorik aurkitu';
$string['ipmismatch'] = 'Bezeroaren IP helbidea ez dator bat';
$string['listcantmovedown'] = 'Elementua behera mugitzeak huts egin du, zerrendako azkena delako.';
$string['listcantmoveleft'] = 'Elementua ezkerrera mugitzeak huts egin du, ez dagoelako goragoko elementurik';
$string['listcantmoveright'] = 'Errorea elementua eskuinera eramatean, ez baitago beste bat horren beheragokoa izan dadin. Mugitu ezazu hau beste baten azpira eta horrela eskuinera eraman ahal izango duzu.';
$string['listcantmoveup'] = 'Errorea elementua gora eramatean, hau baita bere mailakoen arteko lehena.';
$string['listnochildren'] = 'Ez dago aurkitutako elementuaren beheragokorik';
$string['listnoitem'] = 'Ez da elementua aurkitu';
$string['listnopeers'] = 'Ez dago aurkitutako elementuaren maila berekorik';
$string['listupdatefail'] = 'Errorea DB eragiketan zerrendaren ierarkia editatzean';
$string['logfilenotavailable'] = 'Agerraldiak ez daude eskuragarri';
$string['loginasnoenrol'] = 'Ezin duzu matrikulatu edo desmatrikulatu "Honela sartu" saio bat erabiltzen ari zarenean.';
$string['loginasonecourse'] = 'Ezin zara ikastaro honetan sartu.<br />"Aukeratu beste rol bat" saioa amaitu behar duzu beste edozein ikastarotan sartzeko';
$string['maxareabytes'] = 'Fitxategia eremu honetan geratzen den espazioa baino handiagoa da.';
$string['maxbytesfile'] = '{$a->file} fitxategia handiegia da. Igo dezakezun gehinezko tamaina  {$a->size} da.';
$string['maxdraftitemids'] = 'Fitxategi-igoera behin-behinean mugatu zaizu fitxategien bolumen handia igo duzulako. Itxaron ezazu eta ondoren saiatu zaitez berriro.';
$string['messageundeliveredbynotificationsettings'] = 'Mezua ezin izan da bidali guneko kudeatzaileak pertsonen arteko mezularitza desgaitu duelako (Jakinarazpenen ezarpenetan).';
$string['messagingdisable'] = 'Mezularitza desgaituta dago gune honetan';
$string['mimetexisnotexist'] = 'Zure sistema ez dago mimeTeX exekutatzeko konfiguratuta. <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> helbidetik C iturburua eskuratu behar duzu, berau konpilatu eta exekutagarria zure guneko /filter/tex/ direktorioan jarri beharko zenuke.';
$string['mimetexnotexecutable'] = 'mimetex pertsonalizatua ez da exekutagarria!';
$string['missing_moodle_backup_xml_file'] = 'Segurtasun-kopian XML fitxategia falta da: {$a}';
$string['missingfield'] = '"{$a}" eremua falta da';
$string['missingkeyinsql'] = 'ERROREA: kontsultan "{$a}" parametroa falta da';
$string['missingparam'] = 'Behar den ({$a}) parametroa falta da';
$string['missingparameter'] = 'Parametroa falta da';
$string['missingrequiredfield'] = 'Beharrezko eremuren bat falta da.';
$string['missinguseranditemid'] = 'userid eta itemid falta dira';
$string['missingvarname'] = 'Behar den aldagai baten izena falta da!';
$string['mixedtypesqlparam'] = 'ERROREA: SQL kontsultako parametro motak nahastuta daude!!';
$string['mnetdisable'] = 'MNET desgaituta dago';
$string['mnetlocal'] = 'Urrutiko MNET erabiltzaileek ezin dute saioa modu lokalean hasi';
$string['moduledisable'] = 'Modulu hau ({$a}) desgaituta dago ikastaro jakin honetarako';
$string['moduledoesnotexist'] = 'Modulu hau ez da existitzen';
$string['moduleinstancedoesnotexist'] = 'Modulu honen erregistroa ez da existitzen';
$string['modulemissingcode'] = '{$a} moduluak ez dauka funtzio hau aurrera eramateko beharrezko kodea.';
$string['movecatcontentstoroot'] = 'Kategoriaren edukiak jatorrizkora mugitzea ez dago baimenduta. Edukiak existitzen den kategoria batera mugitu behar dituzu!';
$string['movecatcontentstoselected'] = 'Kategoriako edukietako batzuk ezin dira aukeratutako kategoriara mugitu.';
$string['movecategorynotpossible'] = 'Ezin duzu \'{$a}\' kategoria mugitu aukeratutako kategoriara.';
$string['movecategoryownparent'] = 'Ezin da \'{$a}\' kategoria goragoko kategoria gisa ezarri.';
$string['movecategoryparentconflict'] = 'Ezin da \'{$a}\' kategoria bere baitako azpikategoria bateko azpikategoria gisa ezarri.';
$string['mssqlrcsmodemissing'] = 'Datu-basea ez da espero zen READ_COMMITTED_SNAPSHOT modua erabiltzen ari, eta honek emaitza baliogabeetara eraman dezake, batez ere konkurrentzia altuko inguruneetan. Mesedez gaitu ezazu jokaera egokia izateko. Informazio gehiagorako, ikusi dokumentazioko  <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">MSSQL PHPrako instalatzen</a> atala.';
$string['multiplerecordsfound'] = 'Erregistro anitz aurkitu dira, eta erregistro bakarra espero zen.';
$string['multiplerestorenotallow'] = 'Ez dira berreskuratze exekuzio anitzak baimentzen!';
$string['mustbeloggedin'] = 'Saioa hasi behar duzu hori egiteko';
$string['mustbeteacher'] = 'Irakaslea izan behar duzu orri hau ikusteko';
$string['myisamproblem'] = 'Datu-baseko taulek MyISAM datu-base motorra erabiltzen ari dira, ACIDekin bat datorren motorra erabiltzea gomendatzen da InnoDBren moduko transakzioen sostengu osoa izateko.';
$string['needcopy'] = 'Lehenengo zerbait kopiatu behar duzu!';
$string['needcoursecategroyid'] = 'Ikastaro guztien IDa edo kategoria zehaztu behar da';
$string['needphpext'] = '{$a}-rako sostengua gehitu behar duzu zure PHP instalazioan';
$string['noadmins'] = 'Ez dago kudeatzailerik!';
$string['noblocks'] = 'Ez da blokerik aurkitu!';
$string['nocapabilitytousethisservice'] = 'Erabiltzaileak ez du gaitasunik zerbitzu hau erabiltzeko';
$string['nocategorydelete'] = '\'{$a}\' kategoria ezin da ezabatu!';
$string['nocontext'] = 'Sentitzen dugu, ikastaro hau ez da testuinguru baliagarria';
$string['nodata'] = 'Daturik ez';
$string['noexistingcategory'] = 'Ez dago kategoriarik';
$string['nofile'] = 'Ez da fitxategia zehaztu';
$string['nofiltersenabled'] = 'Iragazkiak ez daude gaituta.';
$string['nofolder'] = 'Eskatutako direktorioa ez da existitzen';
$string['noformdesc'] = 'Ez da aurkitu jarduera honentzako formslib formularioaren deskribapen-fitxategia.';
$string['noguest'] = 'Hemen bisitaririk ez!';
$string['noinstances'] = 'Ikastaro honetan ez da {$a} azaltzen.';
$string['nologinas'] = 'Ez duzu baimenik beste erabiltzaile bat bezala sartzeko';
$string['nonmeaningfulcontent'] = 'Eduki esaguratsurik ez';
$string['noparticipants'] = 'Ez da partaiderik aurkitu ikastaro honetarako';
$string['noparticipatorycms'] = 'Sentitzen dugu, baina ez duzu ikastaroez informatzeko partaidetza-modulurik';
$string['nopermissions'] = 'Sentitzen dugu, baina oraingoz ez duzu hori egiteko baimenik ({$a}).';
$string['nopermissiontocomment'] = 'Ezin duzu iruzkinik gehitu';
$string['nopermissiontodelentry'] = 'Ezin duzu iruzkin hau ezabatu!';
$string['nopermissiontoeditcomment'] = 'Ezin dituzu beste pertsonen iruzkinak editatu!';
$string['nopermissiontohide'] = 'Ez duzu ezkutatzeko baimenik!';
$string['nopermissiontoimportact'] = 'Ez dituzu jarduerak ikastaro honetara inportatzeko behar diren baimenak';
$string['nopermissiontolock'] = 'Ez duzu blokeatzeko baimenik!';
$string['nopermissiontomanagegroup'] = 'Ez dituzu taldeak kudeatzeko behar diren baimenak';
$string['nopermissiontorate'] = 'Elementuak kalifikatzea ez dago baimenduta!';
$string['nopermissiontoshow'] = 'Ez duzu hau erakusteko baimenik!';
$string['nopermissiontounlock'] = 'Ez duzu desblokeatzeko baimenik!';
$string['nopermissiontoupdatecalendar'] = 'Sentitzen dugu, baina ez duzu egutegiko ekitaldia eguneratzeko baimenik.';
$string['nopermissiontoviewgrades'] = 'Ezin da kalifikaziorik ikusi.';
$string['nopermissiontoviewletergrade'] = 'Letra-kalifikazioak ikusteko baimena galduta.';
$string['nopermissiontoviewpage'] = 'Ez duzu orri hau begiratzeko baimenik.';
$string['nosite'] = 'Ezin da maila altuagoko ikastarorik aurkitu';
$string['nositeid'] = 'Guneko ID-rik ez';
$string['nostartdatenoenddate'] = 'Ikastaro baten amaiera-data ezartzeko hasiera-data ere ezarri behar da.';
$string['nostatstodisplay'] = 'Sentitzen dugu, baina ez dago erakusteko daturik';
$string['notallowedtoupdateprefremotely'] = 'Ez duzu baimenik erabiltzaile-hobespen hau urrutitik eguneratzeko';
$string['notavailable'] = 'Ez dago eskuragarri une honetan';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Ez zara ikastaro-talde honetako kide';
$string['notownerofkey'] = 'Ez zara giltza honen jabe';
$string['nousers'] = 'Ez dago erabiltzaile hau!';
$string['oauth1accesstoken'] = 'OAuth 1.0 errorea: Ez dugu sarbide-tokena eskuratu.';
$string['oauth1requesttoken'] = 'OAuth 1.0 errorea: Ez dugu eskera-tokena eskuratu - baliteke zerbitzuaren hornitzailea behin behinean jausita egotea.';
$string['oauth2refreshtokenerror'] = 'Ezin izan da OAuth 2 tokena berriztu. Urruneko amaiera-puntuaren HTTP egoera: {$a}';
$string['onlyadmins'] = 'Kudeatzaileek baino ezin dute hori egin.';
$string['onlyeditingteachers'] = 'Edizio-baimena duten irakasleek baino ezin dute hori egin.';
$string['onlyeditown'] = 'Zeure informazioa baino ezin duzu editatu';
$string['orderidnotfound'] = '{$a} ordenatze-IDa ez da aurkitu';
$string['pagenotexist'] = '<p>Ezohiko errore bat gertatu da ez dagoen orri batera sartzeko saiakera egitean:</p>{$a}';
$string['pagenotexisttitle'] = '404 Errorea: Fitxategia ez da aurkitu';
$string['pathdoesnotstartslash'] = 'Ez dira baliozko argumentuak eman, bidea ez da barra batekin hasten!';
$string['pleasereport'] = 'Denbora baduzu, errorea gertatu zenean zertan saiatzen ari zinen jakinaraz iezaguzu, mesedez:';
$string['pluginrequirementsnotmet'] = '"{$a->pluginname}" ({$a->pluginversion}) plugina ezin izan da instalatu. Moodleren bertsio berriagoa behar duzu (zure bertsioa {$a->currentmoodle} da, eta plugin-ak behar duena {$a->requiremoodle} da)';
$string['pluginunsupported'] = '"{$a->pluginname}" pluginak {$a->pluginversion} ez du onartzen Moodleko bertsio hau {$a->moodleversion}. Begiratu ezazu pluginaren informazioa onartzen den bertsioa aurkitzeko.';
$string['prefixcannotbeempty'] = '<p>Errorea: datu-basearen taularen aurrizkia ezin da hutsik egon ({$a})</p> <p>Guneko kudeatzaileak arazo hau konpondu behar du.</p>';
$string['prefixtoolong'] = '<p>Errorea: data-baseko taulen aurrizkia luzeegia da ({$a->dbfamily})</p>
<p>Guneko kudeatzaileak arazoa konpondu behar du. {$a->dbfamily} datu-baseetan tauletako aurrizkien gehienezko luzera {$a->maxlength} karakterekoa da.</p>';
$string['privatefilesupload'] = 'Erabiltzailaren gune pribatura fitxategiak zuzenean igotzea ez da dagoeneko onartzen. Fitxategiak zirriborro-gunera igo eta ondoren core_user::add_user_private_files erremintarekin mugitu itzazu';
$string['processingstops'] = 'Prozesamendua hemen geratu da. Gainontzeko erregistroak ez dira kontuan hartu.';
$string['protected_cc_not_supported'] = 'Babestutako cartridge-ak ez dira onartzen.';
$string['querystringcannotbeempty'] = 'Kontsultaren katea ezin da hutsik egon.';
$string['redirecterrordetected'] = 'Onartzen ez den berbideraketa atzeman da, script-aren exekuzioa amaitu da';
$string['refoundto'] = 'Ezin zaio {$a}(e)ri dirua itzuli';
$string['refoundtoorigi'] = 'Jatorrizko diru-kopurua itzuli zaio: {$a}';
$string['registrationdisabled'] = 'Erregistroa desgaituta dago gune honetan';
$string['remotedownloaderror'] = '<p>Errorea osagaia zure zerbitzarian jaistean, mesedez egiaztatu proxy-ezarpenak, PHP cURL hedapena erabat gomendatzen da.</p>
<p> <a href="{$a->url}">{$a->url}</a> fitxategia eskuz jaitsi beharko zenuke, zure zerbitzariko "{$a->dest}"-ra kopiatu eta bertan deskonprimatu.</p>';
$string['remotedownloadnotallowed'] = 'Osagaiak ezin dira zure zerbitzarira jaitsi (allow_url_fopen ez dago aktibatuta).<br /><br /><a href="{$a->url}">{$a->url}</a> fitxategia eskuz jaitsi eta "{$a->dest}" kokapenean kopiatu behar duzu.';
$string['reportnotavailable'] = 'Txosten mota hau guneko ikastarorako baino ez dago eskuragarri';
$string['requirecorrectaccess'] = 'URLa edo ataka ez dira baliagarriak.';
$string['requireloginerror'] = 'Ez dago ikastaro edo jarduerarako sarbiderik';
$string['restore_path_element_missingmethod'] = '{$a} berreskuratze-metodoa falta da. Garatzaile batek definitu behar du.';
$string['restore_path_element_noobject'] = '{$a} berreskuratze-objektua ez da objektu bat.';
$string['restorechecksumfailed'] = 'Arazoren bat gertatu da zure saioan gordetako informazioa berreskuratzean. Mesedez egiaztatu zure PHP memoria/datu-base paketeen tamainaren mugak. Berreskuratzea geratu da.';
$string['restrictedcontextexception'] = 'Sentitzen dugu, kanpo-funtzioen exekuzioak testuinguruko baldintzak urratzen ditu.';
$string['restricteduser'] = 'Sentitzen dugu, baina zure kontuak, "{$a}", ezin du holakorik egin.';
$string['reverseproxyabused'] = 'Alderantzizko proxy-a gaituta dago, eta beraz ezin da zerbitzarirako sarbide zuzenik egon.<br />Mesedez jarri harremanetan zerbitzariko kudeatzailearekin.';
$string['rpcerror'] = 'Ups! Zure MNET komunikazioak huts egin du! Hau da errore-mezua zure kudeatzaileari igor diezaiozun: {$a}';
$string['scheduledbackupsdisabled'] = 'Guneko kudeatzaileak programatutako segurtasun-kopiak desgaitu ditu';
$string['secretalreadyused'] = 'Pasahitza aldatzeko berrespen-esteka erabilia izan da dagoeneko, pasahitza ez da aldatu';
$string['sectionnotexist'] = 'Atal hau ez da existitzen';
$string['sendmessage'] = 'Bidali mezua';
$string['sendmessagesent'] = 'Eskerrik asko honi buruzko zure feedbackagatik:<br>{$a}';
$string['serverconnection'] = 'Errorea zerbitzariarekin konektatzean';
$string['servicedonotexist'] = 'Zerbitzua ez da existitzen';
$string['sessioncookiesdisable'] = 'require_key_login() funtzioaren erabilera ezegokia - saioaren cookie-ak desgaituta egon behar dira!';
$string['sessiondiskfull'] = 'Saioen partizioa beteta dago. Une honetan ezin zara sartu. Mesedez kudeatzaileari jakinarazi.';
$string['sessionerroruser'] = 'Saioaren denbora tartea amaitu da. Sar zaitez berriro, mesedez.';
$string['sessionerroruser2'] = 'Zure saioari eragiten dion zerbitzari-errorea antzeman da. Berriz sartu edo nabigatzailea berrabiarazi, mesedez.';
$string['sessionexpired'] = 'Saioa iraungi da';
$string['sessionhandlerproblem'] = 'Saioaren kudeatzailea gaizki konfiguratuta dago';
$string['sessionipnomatch'] = 'Sentitzen dugu, baina lehenengo sarreratik zure IPa aldatu dela dirudi. Ziurtasun neurri honen arrazoia crackerrek gune honetan zauden bitartean zure nortasuna ez lapurtzean datza. Erabiltzaile arruntek ez lukete mezu hau ikusi beharko. Beraz, gunearen kudeatzaileari laguntza eskatu.';
$string['sessionipnomatch2'] = '<p>Sentitzen dugu, baina sartu zarenetik zure IP helbidea aldatu dela dirudi. Segurtasun-ezaugarri honek gunean zauden bitartean cracker batek zure identitatea lapurtzea eragozten du. Errore hau ikusi dezakezu haririk gabeko sareak erabiltzen badituzu eta leku batetik bestera mugitzen ari bazara. Mesdez galdetu guneko kudeatzaileari laguntza gehiago eskuratzeko.</p>
<p>Jarraitu nahi baduzu mesedez sakatu F5 tekla orri hau freskatzeko.</p>';
$string['sessionwaiterr'] = 'Saioaren blokeoaren zai egoteko denbora amaitu da.<br />Itxaron zure oraingo eskaera amaitu arte eta berriz saiatu zaitez.';
$string['shortnametaken'] = 'Izan laburra dagoeneko beste ikastaro batean erabili da ({$a})';
$string['sitepolicynotagreed'] = 'Ez duzu guneko politika onartu: <a href="{$a}">Egin klik hemen guneko politika irekitzeko.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxya ez da onartzen PHP4-n';
$string['spellcheckernotconf'] = 'Zuzentzaile ortografikoa ez dago konfiguratuta';
$string['sslonlyaccess'] = 'Segurtasun-arrazoiak direla-eta, https konexioak baino ez daude baimenduta, sentitzen dugu.';
$string['statscatchupmode'] = 'Estatistika une honetan \'catchup\' moduan dago. Orain arte {$a->daysdone} egun prozesatu dira eta {$a->dayspending} prozesatzeko daude. Mesedez, egiaztatu beranduago berriz.';
$string['statsdisable'] = 'Estatistikak ez daude gaituta.';
$string['statsnodata'] = 'Ez dago daturik ikastaro eta denbora-tarte konbinazio horretarako';
$string['storedfilecannotcreatefile'] = 'Ezin izan da sortu fitxategien gune lokaleko fitxategia. Egiaztatu mesedez datuen jatorriko karpetaren baimenak eta diskoaren espazio erabilgarria.';
$string['storedfilecannotcreatefiledirs'] = 'Ezin dira sortu fitxategien gune lokaleko karpetak. Egiaztatu mesedez datuen jatorriko karpetako baimenak.';
$string['storedfilecannotread'] = 'Ezin da fitxategia irakurri. Fitxategia ez dago edo baimen arazoak daude.';
$string['storedfilecannotreadfile'] = 'Ezin da \'{$a}\' fitxategia irakurri. Fitxategia ez da existitzen edo baimenekin arazoren bat dago.';
$string['storedfilenotcreated'] = 'Ezin da fitxategia sortu {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Fitxategi lokalekin lotutako salbuespen ezezaguna ({$a})';
$string['tagdisabled'] = 'Etiketak desgaituta daude!';
$string['tagnotfound'] = 'Ez da aurkitu zehaztutako etiketa datu-basean';
$string['targetdatabasenotempty'] = 'Helburuko datu-basea ez dago hutsik. Transferentzia bertan behera utzi da segurtasun-arrazoiengatik.';
$string['textconditionsnotallowed'] = 'Testuzko zutabeen baldintzen konparaketak ez daude baimenduta. Erabili mesedez sql_compare_text() zure kontsultetan.';
$string['themenotinstall'] = 'Azal hau ez dago instalatuta!';
$string['tokengenerationfailed'] = 'Ezin da token berria sortu.';
$string['transactionvoid'] = 'Transakzioa ezin da deuseztatu dagoeneko deuseztatuta dagoelako';
$string['unenrolerror'] = 'Errorea gertatu da pertsona hau desmatrikulatzean';
$string['unicodeupgradeerror'] = 'Sentitzen dugu baina zure datu-basea oraindik ez dago Unicoden eta Moodleren bertsio honek ezin du zure datu-basea Unicodera migratu. Mesedez, eguneratu Moodle 1.7.x-era eta egin Unicoderako migrazioa Kudeaketa orritik. Hori eginda, Moodle {$a}-rako migrazioa egin ahal izango duzu.';
$string['unknowaction'] = 'Ekintza ezezaguna!';
$string['unknowcategory'] = 'Kategoria ezezaguna!';
$string['unknowcontext'] = 'Hau ({$a}) testuinguru ezezaguna da get_child_contexts-en!';
$string['unknowformat'] = 'Formatu ezezaguna ({$a})';
$string['unknownbackupexporterror'] = 'Errore ezezaguna inportatzeko informazioa prestatzean';
$string['unknownblockregion'] = '\'{$a}\' bloke-eremua ez da onartzen orri honetan.';
$string['unknowncontext'] = 'Hau testuinguru ezezaguna da.';
$string['unknowncourse'] = 'Ez dago "{$a}" izeneko ikastarorik';
$string['unknowncourseidnumber'] = 'Ikastaroaren ID ezezaguna: "{$a}"';
$string['unknowncourserequest'] = 'Ikastaro-eskari ezezaguna';
$string['unknowncoursesection'] = 'Ikastaro-atal ezezaguna "{$a}" ikastaroan';
$string['unknownevent'] = 'Ekitaldi ezezaguna';
$string['unknownfiletype'] = 'Errorea: iragazki mota ezezaguna';
$string['unknowngroup'] = '"{$a}" talde ezezaguna';
$string['unknownhelp'] = '{$a} laguntza-gaia ezezaguna';
$string['unknownjsinrequirejs'] = 'Ezin da {$a} JavaScript liburutegia aurkitu.';
$string['unknownmodulename'] = 'Moduluaren izena ezezaguna da formulariorako';
$string['unknownrole'] = '"{$a}" rol ezezaguna';
$string['unknownsortcolumn'] = 'Ordenatze-zutabe ezezaguna {$a}';
$string['unknownuseraction'] = 'Sentitzen dugu, baina erabiltzailearen ekintza hau ez dugu ulertzen.';
$string['unknownuserselector'] = 'Erabiltzaile-hautatzaile ezezaguna';
$string['unknoworder'] = 'Ordena ezezaguna';
$string['unknowparamtype'] = 'Parametro mota ezezaguna: {$a}';
$string['unknowquestiontype'] = '{$a} galdera mota onartezina';
$string['unknowuploadaction'] = 'Errorea: igoera-ekintza ezezaguna ({$a})';
$string['unspecifycourseid'] = 'Ikastaroaren ID-a, izen laburra edo ID zenbakia zehaztu behar da.';
$string['unsupportedevent'] = 'Onartzen ez den ekitaldi mota';
$string['unsupportedstate'] = 'Onartzen ez den osatze-egoera';
$string['unsupportedwebserver'] = 'Web zerbitzariaren softwarea ({$a}) ez da onartzen, sentitzen dugu.';
$string['upgraderequires19'] = 'Errorea: Moodleren bertsio berriaren kodea instalatu da zerbitzarian eta tamalez ez da onartzen aurreko bertsiotiko eguneraketa.<br />Mesedez, eguneratu lehenik 1.9.x bertsio berrienera. Aurreko bertsiora ere itzul zaitezke jatorrizko fitxategiak berriz instalatuta.';
$string['upgraderunning'] = 'Gunea eguneratzen ari da. Mesedez, saiatu zaitez beranduago.';
$string['urlnotdefinerss'] = 'RSS jariorako URLa ez dago definituta';
$string['useradmineditadmin'] = 'Soilik kudeatzaileek alda ditzakete beste kudeatzaileen kontuak';
$string['useradminodelete'] = 'Kudeatzaileen kontuak ezin dira ezabatu.';
$string['userautherror'] = 'Autentifikazio-plugin ezezaguna';
$string['userauthunsupported'] = 'Auth plugina ez da hemen onartzen';
$string['useremailduplicate'] = 'Bikoiztutako helbidea';
$string['usermustbemnet'] = 'MNET sarbide-kontrolerako zerrendako erabiltzaileak urruneko MNET-eko erabiltzaileak izan behar dira';
$string['usernamelowercase'] = 'Erabiltzailearen izena letra xehez idatzi behar da';
$string['usernotaddederror'] = 'Erabiltzailea ez da gehitu - errorea';
$string['usernotaddedregistered'] = 'Erabiltzailea ez da gehitu - dagoeneko existitzen da';
$string['usernotavailable'] = 'Ezin dituzu erabiltzaile honen xehetasunak ikusi';
$string['usernotdeletedadmin'] = 'Erabiltzailea ez da ezabatu kudeatzaileen kontuak ezin direlako ezabatu.';
$string['usernotdeleteddeleted'] = 'Erabiltzaile hau ezabatua izan da dagoeneko.';
$string['usernotdeletederror'] = 'Ez da erabiltzailea ezabatu - errorea';
$string['usernotdeletedmissing'] = 'Ez da erabiltzailea ezabatu - ez da erabiltzaile-izena aurkitu';
$string['usernotdeletedoff'] = 'Ez da erabiltzailea ezabatu - ezabatzea ez dago baimenduta';
$string['usernotfullysetup'] = 'Erabiltzailea ez dago guztiz prest';
$string['usernotincourse'] = 'Erabiltzaile hau ez dago ikastaro honetan!';
$string['usernotrenamedadmin'] = 'Ezin dira kudeatzailearen kontuen izena aldatu';
$string['usernotrenamedexists'] = 'Ez da erabiltzailearen izena aldatu - erabiltzaile-izen berria dagoeneko erabilia dago.';
$string['usernotrenamedmissing'] = 'Ez da erabiltzailearen izena aldatu - erabiltzailearen aurreko izena ez da aurkitu.';
$string['usernotrenamedoff'] = 'Ez da erabiltzailearen izena aldatu - berrizendatzea ez dago baimenduta';
$string['usernotupdatedadmin'] = 'Ezin dira kudeatzailearen kontuak eguneratu';
$string['usernotupdatederror'] = 'Ez da erabiltzailea eguneratu - errorea';
$string['usernotupdatednotexists'] = 'Ez da erabiltzailea eguneratu - ez da existitzen';
$string['userquotalimit'] = 'Fitxategietarako gehienezko kuotara irsitsi zara.';
$string['userselectortoomany'] = 'user_selector-ek aukeratutako erabiltzaile bat baino gehiago dauzka, nahiz eta multiselect false izan.';
$string['verifyagedigitalconsentnotpossible'] = 'Sentitzen dugu, une honetan ez da posible onespen-adin digitala egiaztapena.';
$string['wrongcall'] = 'Script hau gaizki deitu da';
$string['wrongcontextid'] = 'Testuinguru ID-a ez da egokia (ezin da aurkitu)';
$string['wrongdestpath'] = 'Helmuga-bide desegokia';
$string['wrongroleid'] = 'Rolaren ID ezegokia!';
$string['wrongsourcebase'] = 'URL iturriaren oinarri akastuna';
$string['wrongusernamepassword'] = 'Erabiltzaile/pasahitz ezezaguna';
$string['wrongzipfilename'] = 'ZIP fitxategiaren izen desegokia';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Ezin da sortu ikastaroa - Ez duzu baimenik';
$string['wwwrootmismatch'] = 'Sarbide ezegokia antzeman da, zerbitzari honetara soilik "{$a}" bidez sartu daiteke, sentitzen dugu.<br />Jakinarazi mesedez zerbitzariko kudeatzaileari.';
$string['wwwrootslash'] = 'config.php fitxategian ezegokia den $CFG->wwwroot parametroa antzeman da, ezin du amaieran barrarik izan.<br />Jakinarazi mesedez zerbitzariko kudeatzaileari.';
$string['xmldberror'] = 'XMLDB errorea!';
$string['youcannotdeletecategory'] = 'Ezin da \'{$a}\' kategoria ezabatu zeren edukia ezin baita ezabatu, ezta beste toki batera mugitu ere.';
