<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'ar', version '3.10'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'إجراءات واجهة المقيِّم';
$string['actionsforpost'] = 'إجراءات النشر';
$string['activityoverview'] = 'هناك منشورات جديدة في المنتدى';
$string['addanewdiscussion'] = 'إضافة موضوع جديد للمناقشة';
$string['addanewquestion'] = 'إضافة سؤال جديد';
$string['addanewtopic'] = 'إضافة موضوع جديد';
$string['addtofavourites'] = 'إبدأ هذه المناقشة';
$string['advancedsearch'] = 'بحث متقدم';
$string['alldiscussions'] = 'كل المناقشات';
$string['allforums'] = 'جميع المنتديات';
$string['allowdiscussions'] = 'هل يستطع  الطالب  بإرسال مقالة إلى هذا المنتدى؟';
$string['allowsallsubscribe'] = 'يسمح هذا المنتدي للجميع اختيار إما الاشتراك أم لا';
$string['allowsdiscussions'] = 'هذا المنتدى يسمح لكل مستخدم أن يبدأ موضوعاً واحداً للنقاش.';
$string['allsubscribe'] = 'اشترك في كل المنتديات';
$string['allunsubscribe'] = 'إلغي الاشتراك في كل المنتديات';
$string['allusers'] = 'كل المستخدمين';
$string['alreadyfirstpost'] = 'هذه هي المشاركة الأولى في المناقشة';
$string['anyfile'] = 'أي ملف';
$string['areaattachment'] = 'مرفقات';
$string['areapost'] = 'رسائل';
$string['attachment'] = 'ملف مرفق';
$string['attachment_help'] = 'يمكنك اختيارياً إرفاق ملف واحد أو أكثر بالمنشور في المنتدى. إذا أرفقت صورة، سيتم عرضها بعد النص.';
$string['attachmentname'] = 'المرفق {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'لا يمكنك تصدير المرفقات بدون مُعرَّف المنشور';
$string['attachments'] = 'مرفقات';
$string['attachmentswordcount'] = 'المرفقات وعدد الكلمات';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} يرد بشكل خاص على {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} يرد على {$a->author}';
$string['availability'] = 'التوقيتات';
$string['blockafter'] = 'عتبة النشر للمنع';
$string['blockafter_help'] = 'هذا الإعداد يحدد العدد الأقصى لمنشورات الطلاب في المنتدى خلال فترة زمنية محددة. المستخدمون الذين يتمتعون بالإمكانية mod/forum:postwithoutthrottling هم معفون من عتبة النشر.';
$string['blockperiod'] = 'الفترة الزمنية للمنع';
$string['blockperiod_help'] = 'يمكن منع الطلاب من النشر إذا وصلت منشوراتهم في المنتدى إلى عدد محدد ضمن فترة زمنية معينة. المستخدمون الذين يتمتعون بالإمكانية mod/forum:postwithoutthrottling هم معفون من عتبة النشر.';
$string['blockperioddisabled'] = 'لا تمنع';
$string['blogforum'] = 'منتدى قياسي يظهر بشكل مدونة';
$string['bynameondate'] = 'بواسطة {$a->date} -  {$a->name}';
$string['cachedef_forum_is_tracked'] = 'حالة تعقب المنتدى للمستخدم';
$string['calendardue'] = '{$a} قد استحق';
$string['cancelreply'] = 'إلغاء الرد';
$string['cannotadd'] = 'تعذرت إضافة المناقشة في هذا المنتدى';
$string['cannotadddiscussion'] = 'إضافة مناقشات إلى هذا المنتدى يتطلب عضوية مجموعات.';
$string['cannotadddiscussionall'] = 'ليس لديك صلاحيات إضافة موضوع مناقشة جديد لكل المشاركين.';
$string['cannotadddiscussiongroup'] = 'لا يمكنك إنشاء مناقشة لأنك لست عضواً في أي مجموعة.';
$string['cannotaddsubscriber'] = 'تعذرت إضافة المشترك ذي المُعرَّف {$a} إلى هذا المنتدى!';
$string['cannotaddteacherforumto'] = 'تعذرت إضافة عينة منتدى المُعلِّم المحولة إلى المقطع 0 في المقرر الدراسي';
$string['cannotcreatediscussion'] = 'تعذر إنشاء مناقشة جديدة';
$string['cannotcreateinstanceforteacher'] = 'تعذر إنشاء عينة مقرر دراسي جديد لمنتدى المعلم';
$string['cannotdeletediscussioninsinglediscussion'] = 'لا يمكنك حذف المنشور الأول في مناقشة منفردة';
$string['cannotdeletepost'] = 'لا يمكنك حذف هذا المنشور!';
$string['cannoteditposts'] = 'لا يمكنك تحرير منشورات الآخرين!';
$string['cannotexportforum'] = 'لا يمكنك تصدير هذا المنتدى';
$string['cannotfavourite'] = 'عذراً، ولكنك لا تمتلك الصلاحية لتعليم المناقشات بنجمة.';
$string['cannotfinddiscussion'] = 'تعذر العثور على المناقشة في هذا المنتدى';
$string['cannotfindfirstpost'] = 'تعذر العثور على المنشور الأول في هذا المنتدى';
$string['cannotfindorcreateforum'] = 'تعذر العثور على منتدى الإعلانات الرئيسي أو إنشائه في الموقع';
$string['cannotfindparentpost'] = 'تعذر العثور على المنشور ذي الرتبة الأعلى للمنشور {$a}';
$string['cannotmovefromsingleforum'] = 'لا يمكن نقل المناقشة من منتدى بسيط ذي مناقشة منفردة';
$string['cannotmovenotvisible'] = 'المنتدى غير مرئي';
$string['cannotmovetonotexist'] = 'لا يمكنك الانتقال إلى ذلك المنتدى - إنه غير موجود!';
$string['cannotmovetonotfound'] = 'تعذر العثور على المنتدى المقصود في هذا المقرر الدراسي.';
$string['cannotmovetosingleforum'] = 'لا يمكن نقل المناقشة إلى منتدى بسيط ذي مناقشة منفردة';
$string['cannotpindiscussions'] = 'عذراً، ليست لديك الصلاحية لتثبيت المناقشات.';
$string['cannotpurgecachedrss'] = 'تعذر تطهير المغذيات المخبأة لخدمة الأخبار لمنتدى أو منتديات المصدر و/أو المقصد - تحقق من ملفك المسمى permissionsforums';
$string['cannotremovesubscriber'] = 'تعذرت إزالة المشترك ذي المُعرَّف {$a} من هذا المنتدى!';
$string['cannotreply'] = 'لا يمكنك الرد على هذا المنشور';
$string['cannotsplit'] = 'لا يمكن تقسيم المناقشات في هذا المنتدى';
$string['cannotsubscribe'] = 'عذراً، ولكنك ينبغي أن تكون عضواً في مجموعة لتشترك.';
$string['cannottrack'] = 'تعذر إيقاف تعقب ذلك المنتدى';
$string['cannotunsubscribe'] = 'تعذر إلغاء اشتراكك في ذلك المنتدى';
$string['cannotupdatepost'] = 'لا يمكنك تعديل هذا المنشور';
$string['cannotviewpostyet'] = 'لانك لم تقم بالمشاركة في هذا المنتدى لذا لا تستطيع قراءة أسئلة الطلاب الآخرين';
$string['cannotviewusersposts'] = 'لا توجد مواضيع نشرها هذا المستخدم ويمكنك مشاهدتها.';
$string['cleanreadtime'] = 'إعتبر المناقشات القديمة مقروءة';
$string['clicktofavourite'] = 'لم تقم بتعليم هذه المناقشة بنجمة. أنقر لوضع النجمة عليها.';
$string['clicktolockdiscussion'] = 'أنقر لتأمين هذه المناقشة';
$string['clicktosubscribe'] = 'لستَ مشتركاً في هذه المناقشة. أنقر للاشتراك.';
$string['clicktounfavourite'] = 'لقد وضعت نجمة على هذه المناقشة. أنقر لإزالتها.';
$string['clicktounlockdiscussion'] = 'أنقر لإلغاء تأمين هذه المناقشة';
$string['clicktounsubscribe'] = 'أنت مشترك في هذه المناقشة. أنقر لإلغاء الاشتراك.';
$string['close'] = 'أغلق';
$string['closegrader'] = 'أغلق المقيِّم';
$string['completiondiscussions'] = 'ينبغي على الطلبة إنشاء مناقشات:';
$string['completiondiscussionsdesc'] = 'ينبغي على الطالب إنشاء {$a} مناقشة/مناقشات على الأقل';
$string['completiondiscussionsgroup'] = 'يتطلب مناقشات';
$string['completiondiscussionshelp'] = 'يتطلب إكتمال المناقشات';
$string['completionposts'] = 'ينبغي على الطلبة نشر المناقشات أو الرد عليها:';
$string['completionpostsdesc'] = 'ينبغي على الطالب إنشاء {$a} مناقشة/مناقشات أو رد/ردود على الأقل';
$string['completionpostsgroup'] = 'يتطلب منشورات';
$string['completionpostshelp'] = 'يتطلب إكتمال المناقشات أو الردود';
$string['completionreplies'] = 'الطلاب يجب عليهم الرد';
$string['completionrepliesdesc'] = 'ينبغي على الطالب إنشاء {$a} رد/ردود على الأقل';
$string['completionrepliesgroup'] = 'يتطلب الرد';
$string['completionreplieshelp'] = 'يتطلب إكتمال الردود';
$string['configcleanreadtime'] = 'أي ساعة في اليوم سيتم تنظيف المشاركات القديمة من جدول المشاركات المقروءة';
$string['configdigestmailtime'] = 'الناس الذين يَختارونَ أَنْ يَكُونَ استقبالهم لرسائل البريد الالكتروني بشكلٍ ملخّصٍ ستتم مراسلتهم بالملخص يومياً. هذا الإعداد يتحكم بالموعد الذي سَيُرسلُ خلاله البريد اليومي (الجولة القادمة لمشغل الوظائف الدورية سيتم خلالها تنفيذ ذلك الإرسال).';
$string['configdisplaymode'] = 'نمط العرض الافتراضي للمناقشات إذا لم يتم اختيار أحدها.';
$string['configenablerssfeeds'] = 'هذا سيمكن خدمة تغذية المعلومات لكل المنتديات. ستحتاج القيام بتفعيل خدمة تغذية المعلومات يدوياً من خلال إعدادات مل منتدى.';
$string['configenabletimedposts'] = 'أضبطه على \'نعم\' إذا أردت السماح بتحديد فترات العرض عند نشر مناقشة جديدة في المنتدى.';
$string['configlongpost'] = 'أي منشور يزيد عن هذا الحد (مقاساً بالحروف غير المتضمنة لرموز HTML) يعتبر طويلاً. المنشورات المعروضة في الصفحة الأمامية للموقع، صفحات المقررات الدراسية ذات النمط الاجتماعي، أو الملفات الشخصية للمستخدمين يتم تقصيرها إلى فاصل طبيعي في موضع ما بين قيمتي forum_shortpost و forum_longpost.';
$string['configmanydiscussions'] = 'الحد الأقصى لعدد للمناقشات المعروضة في الصفحة الواحد للمنتدى';
$string['configmaxattachments'] = 'أقصى عدد من المرفقات إفتراضياً يُسمح به لكل منشور.';
$string['configmaxbytes'] = 'الحجم الافتراضي الاقصى لجميع مرفقات المنتدى في هذا الموقع (عرضة لمحددات المقرر الدراسي وبعض الإعدادات الإخرى)';
$string['configoldpostdays'] = 'عدد الأيام الماضية التي يمكن بعدها اعتبار المنشورات القديمة مقروءة.';
$string['configreplytouser'] = 'هل ينبغي تضمين عنوان البريد الإلكتروني الخاص بالمشارك في المنتدى عند إرسال المشاركة بالبريد الالكتروني؟ هذا سيسمح لمتلقي الرسالة بالرد على صاحب المشاركة شخصياً عبر البريد الالكتروني بدلاً من استعمال المنتدى. حتى لو تم ضبطه على \'نعم\'، يستطيع المستخدمون من خلال الخيارات المتاحة في ملفهم الشخصي جعل عناوين بريدهم سرية.';
$string['configrssarticlesdefault'] = 'إذا كانت خدمة مغذيات الأخبار مُمَكَّنة، فهذا الإعداد يحدد العدد الافتراضي للمقالات (إما مناقشات أو منشورات).';
$string['configrsstypedefault'] = 'إذا كانت خدمة مغذيات الأخبار مُمَكَّنة، فهذا الإعداد يحدد نوع النشاط الافتراضي.';
$string['configshortpost'] = 'أي مقالة تحث هذا الحد (بدون إضافة HTML)  تعتبر قصيره';
$string['configsubscriptiontype'] = 'الإعداد الافتراضي لنمط الاشتراك.';
$string['configtrackingtype'] = 'الإعداد الافتراضي لتعقب القراءة.';
$string['configtrackreadposts'] = 'إختر \'نعم\' إذا كنت تريد متابعة ما تمت قراءته أو عدم قراءته لكل مستخدم.';
$string['configusermarksread'] = 'لو تم اختيار "نعم" لا بد على كل مستخدم القيام بتأشير كل مشاركة على أنهاتم قرائتها.
لو تم اختيار "لا" ستعتبر المشاركة مقروءه بمجر معاينتها.';
$string['confirmsubscribe'] = 'هل ترغب حقاً بالاشتراك في المنتدى \'{$a}\'؟';
$string['confirmsubscribediscussion'] = 'هل ترغب حقاً بالاشتراك في المناقشة \'{$a->discussion}\' في المنتدى \'{$a->forum}\'؟';
$string['confirmunsubscribe'] = 'هل ترغب حقاً بإلغاء الاشتراك في المنتدى \'{$a}\'؟';
$string['confirmunsubscribediscussion'] = 'هل ترغب حقاً بإلغاء الاشتراك في المناقشة \'{$a->discussion}\' في المنتدى \'{$a->forum}\'؟';
$string['couldnotadd'] = 'تعذر إرسال مقالة نتيجة خطأ غير معروف';
$string['couldnotdeletereplies'] = 'عذراً، ذلك لا يمكن حذفه لأن الناس قد استجابت له سلفاً';
$string['couldnotupdate'] = 'تعذر تعديل مقالك نتيجة خطأ غير معروف';
$string['created'] = 'تم إنشاؤها';
$string['crontask'] = 'أعمال مراسلات المنتدى وصيانته';
$string['cutoffdate'] = 'تاريخ التوقف';
$string['cutoffdate_help'] = 'عند ضبطه، لن يتقبل المنتدى أي منشورات بعد هذا التاريخ.';
$string['cutoffdatereached'] = 'تم الوصول إلى تاريخ التوقف عن النشر في هذا المنتدى، لذلك يتعذر عليك النشر فيه.';
$string['cutoffdatevalidation'] = 'تاريخ التوقف لا يمكن أن يكون سابقاً لتاريخ الاستحقاق.';
$string['delete'] = 'حذف';
$string['deleteddiscussion'] = 'تم حذف موضوع النقاش';
$string['deletedpost'] = 'تم حذف هذه المقالة';
$string['deletedposts'] = 'هذه المشاركات تم حذفها';
$string['deleteduser'] = 'مستخدم محذوف';
$string['deletesure'] = 'هل أنت متأكد من رغبتك في حذف هذا المنشور؟';
$string['deletesureplural'] = 'هل أنت متأكد من رغبتك في حذف هذا المنشور وكل ردوده؟ ({$a} رد)';
$string['digestmailheader'] = 'هذا موجزك اليومي للمنشورات الجديدة من منتديات {$a->sitename}. لتغيير تفضيلاتك البريدية المتعلقة بالمنتديات، إذهب إلى {$a->userprefs}.';
$string['digestmailpost'] = 'تغيير تفضيلاتك البريدية المتعلقة بالمنتديات';
$string['digestmailpostlink'] = 'تغيير تفضيلاتك البريدية المتعلقة بالمنتديات: {$a}';
$string['digestmailprefs'] = 'ملفك الشخصي';
$string['digestmailsubject'] = '{$a} ملخص منتدى';
$string['digestmailtime'] = 'ساعة إرسال رسائل البريد الإلكتروني الموجز للمناقشات';
$string['digestsentusers'] = 'الملخصات ارسلت بنجاح بالبريد الإلكتروني إلى {$a} المستخدمين';
$string['disallowsubscribe'] = 'لا يسمح بالأشتراك';
$string['disallowsubscribeteacher'] = 'لا يسمح بالأشتراك (ما عدا المعلمون)';
$string['disallowsubscription'] = 'الاشتراك';
$string['disallowsubscription_help'] = 'تمت تهيئة هذا المنتدى بحيث لا يمكنك الاشتراك في مناقشاته.';
$string['discussion'] = 'المناقشة';
$string['discussionlistsortbycreatedasc'] = 'الفرز حسب تاريخ الإنشاء تصاعدياً';
$string['discussionlistsortbycreateddesc'] = 'الفرز حسب تاريخ الإنشاء تنازلياً';
$string['discussionlistsortbydiscussionasc'] = 'الفرز حسب تسمية المناقشة تصاعدياً';
$string['discussionlistsortbydiscussiondesc'] = 'الفرز حسب تسمية المناقشة تنازلياً';
$string['discussionlistsortbygroupasc'] = 'الفرز حسب المجموعة تصاعدياً';
$string['discussionlistsortbygroupdesc'] = 'الفرز حسب المجموعة تنازلياً';
$string['discussionlistsortbylastpostasc'] = 'الفرز حسب تاريخ الإنشاء لآخر منشور تصاعدياً';
$string['discussionlistsortbylastpostdesc'] = 'الفرز حسب تاريخ الإنشاء لآخر منشور تنازلياً';
$string['discussionlistsortbyrepliesasc'] = 'الفرز حسب عدد الردود تصاعدياً';
$string['discussionlistsortbyrepliesdesc'] = 'الفرز حسب عدد الردود تنازلياً';
$string['discussionlistsortbystarterasc'] = 'الفرز حسب اسم بادئ المناقشة تصاعدياً';
$string['discussionlistsortbystarterdesc'] = 'الفرز حسب اسم بادئ المناقشة تنازلياً';
$string['discussionlocked'] = 'تم تأمين هذه المناقشة لذلك لم يعد بإمكانك الرد عليها.';
$string['discussionlockingdisabled'] = 'لا تقم بتأمين المناقشات';
$string['discussionlockingheader'] = 'إقفال المناقشة';
$string['discussionmoved'] = 'تم نقل هذه المناقشة إلى \'{$a}\'.';
$string['discussionmovedpost'] = 'لقد تم نقل هذه المناقشة إلى <a href="{$a->discusshref}">هنا</a> في المنتدى <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'اسم المناقشة';
$string['discussionnownotsubscribed'] = '{$a->name} لن يتم إبلاغه بشأن المنشورات الجديدة في \'{$a->discussion}\' من \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} سيتم إبلاغه بشأن المنشورات الجديدة في \'{$a->discussion}\' من \'{$a->forum}\'';
$string['discussionpin'] = 'تثبيت';
$string['discussionpinned'] = 'مثبتة';
$string['discussionpinned_help'] = 'المناقشات المثبتة ستظهر في أعلى المنتدى';
$string['discussions'] = 'مناقشات';
$string['discussionsplit'] = 'تم تقسيم المناقشة';
$string['discussionsstartedby'] = 'المناقشات التي بدأها {$a}';
$string['discussionsstartedbyrecent'] = 'المناقشات التي بدأها {$a} مؤخرًا';
$string['discussionsstartedbyuserincourse'] = 'المناقشات المبدوءة من قِبَل {$a->fullname} في {$a->coursename}';
$string['discussionstartedby'] = 'المناقشات المبدوءة من قِبَل {$a}';
$string['discussionsubscribed'] = 'أنت الآن مشترك في هذه المناقشة.';
$string['discussionsubscribestart'] = 'أرسل لي إشعارات بشأن المنشورات الجديدة في هذه المناقشة';
$string['discussionsubscribestop'] = 'لا أريد أن يتم إشعاري بشأن المنشورات الجديدة في هذه المناقشة';
$string['discussionsubscription'] = 'الاشتراك في المناقشة';
$string['discussionsubscription_help'] = 'الاشتراك في مناقشة معناه أنك ستتلقى إشعارات بشأن المنشورات الجديدة فيها.';
$string['discussionunpin'] = 'إلغاء التثبيت';
$string['discussionunsubscribed'] = 'أنت الآن غير مشترك في هذه المناقشة.';
$string['discussthistopic'] = 'ناقش هذا الموضوع';
$string['discusstopicname'] = 'ناقش الموضوع: {$a}';
$string['displayend'] = 'نهاية العرض';
$string['displayend_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي إخفاء منشور المنتدى بعد تاريخ معين. لاحظ أن المشرفين يمكنهم دائماً معاينة منشورات المنتدى.';
$string['displayenddate'] = 'نهاية العرض: {$a}.';
$string['displaymode'] = 'نمط العرض';
$string['displayperiod'] = 'فترة العرض';
$string['displaystart'] = 'اعرض البداية';
$string['displaystart_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي إظهار منشور المنتدى بدءاً من تاريخ معين. لاحظ أن المشرفين يمكنهم دائماً معاينة منشورات المنتدى.';
$string['displaystartdate'] = 'بدء العرض: {$a}.';
$string['displaywordcount'] = 'إعرض عدد الكلمات';
$string['displaywordcount_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي عرض عدد الكلمات لكل منشور في المنتدى أم لا.';
$string['duedate'] = 'تاريخ الاستحقاق';
$string['duedate_help'] = 'هذا هو التاريخ الذي يكون فيه النشر في المنتدى مستحقاً. رغم أن هذا التاريخ سيتم عرضه في التقويم بمثابة يوم الاستحقاق للمنتدى، إلا أن النشر سيبقى مسموحاً به بعده. حدد تاريخ التوقف لمنع النشر في المنتدى بعد تاريخ معين.';
$string['duedatetodisplayincalendar'] = 'تاريخ الاستحقاق الذي سيعرضه التقويم';
$string['eachuserforum'] = 'كل مستخدم يطرح مناقشة واحدة';
$string['edit'] = 'تحرير';
$string['editedby'] = 'تم تحريره من قبل {$a->name} - التسليم الأصلي في {$a->date}';
$string['editedpostupdated'] = 'تم تحديث منشور {$a}';
$string['editing'] = 'تحرير';
$string['emaildigestcompleteshort'] = 'منشورات كاملة';
$string['emaildigestdefault'] = 'الافتراضي ({$a})';
$string['emaildigestoffshort'] = 'بلا إيجاز';
$string['emaildigestsubjectsshort'] = 'المواضيع فقط';
$string['emaildigesttype'] = 'خيارات موجز رسالة البريد';
$string['emaildigesttype_help'] = 'نوع الإشعار الذي ستتلقاه لكل منتدى.

* الافتراضي - إتبع إعداد الإيجاز الموجود في ملفك الشخصي. إذا قمت بتغييره في ملفك الشخصي، فالتغييرات ستنعكس هنا أيضاً؛
* بلا إيجاز - ستتلقى رسالة لكل منشور في المنتدى؛
* إيجاز - منشورات كاملة - ستتلقى رسالة إيجاز واحدة يومياً تتضمن المحتويات الكاملة لكل منشور في المنتدى؛
إيجاز - المواضيع فقط - ستتلقى رسالة إيجاز واحدة يومياً تتضمن فقط مواضيع كل منشور في المنتدى.';
$string['emptymessage'] = 'ثمة خطأ في منشورك. ربما تركته فارغاً أو أن حجم الملف المرفق أكبر من اللازم. لم يتم حفظ تغييراتك.';
$string['errorcannotlock'] = 'ليست لديك الصلاحية لتأمين المناقشات.';
$string['erroremptymessage'] = 'رسالة المنشور لا يمكن أن تكون فارغة';
$string['erroremptysubject'] = 'موضوع المنشور لا يمكن أن يكون فارغاً';
$string['errorenrolmentrequired'] = 'ينبغي أن تكون منضماً إلى هذا المقرر الدراسي للوصول إلى هذا المحتوى';
$string['errorwhiledelete'] = 'وقع خطأ عند حذف السجل.';
$string['eventassessableuploaded'] = 'تم نشر بعض المحتوى';
$string['eventcoursesearched'] = 'مقرر دراسي تم البحث فيه';
$string['eventdiscussioncreated'] = 'مناقشة تم إنشاؤها';
$string['eventdiscussiondeleted'] = 'مناقشة تم حذفها';
$string['eventdiscussionmoved'] = 'مناقشة تم نقلها';
$string['eventdiscussionpinned'] = 'مناقشة تم تثبيتها';
$string['eventdiscussionsubscriptioncreated'] = 'اشتراك في مناقشة تم إنشاؤه';
$string['eventdiscussionsubscriptiondeleted'] = 'اشتراك في مناقشة تم حذفه';
$string['eventdiscussionunpinned'] = 'مناقشة تم إلغاء تثبيتها';
$string['eventdiscussionupdated'] = 'مناقشة تم تحديثها';
$string['eventdiscussionviewed'] = 'مناقشة تمت معاينتها';
$string['eventpostcreated'] = 'منشور تم إنشاؤه';
$string['eventpostdeleted'] = 'منشور تم حذفه';
$string['eventpostupdated'] = 'منشور تم تحديثه';
$string['eventreadtrackingdisabled'] = 'تعقب قراءة تم تعطيله';
$string['eventreadtrackingenabled'] = 'تعقب قراءة تم تمكينه';
$string['eventsubscribersviewed'] = 'مشتركون تمت معاينتهم';
$string['eventsubscriptioncreated'] = 'اشتراك تم إنشاؤه';
$string['eventsubscriptiondeleted'] = 'اشتراك تم حذفه';
$string['eventuserreportviewed'] = 'تقرير مستخدم تمت معاينته';
$string['everyonecanchoose'] = 'الجميع يمكنه الاختيار ليصبح مشتركا';
$string['everyonecannowchoose'] = 'كل شخص يمكنه الاختيار ليصبح مشتركا';
$string['everyoneisnowsubscribed'] = 'كل الاشخاص مشتركون في هذا المنتدى';
$string['everyoneissubscribed'] = 'الجميع مشترك في هذه المناقشة';
$string['existingsubscribers'] = 'المشاركين الموجودين';
$string['export'] = 'تصدير';
$string['exportattachmentname'] = 'تصدير المرفق {$a} إلى المحفظة';
$string['exportdiscussion'] = 'تصدير كل المناقشة إلى المحفظة';
$string['exporthumandates'] = 'تواريخ قابلة للقراءة';
$string['exporthumandates_help'] = 'فيما إذا كان ينبغي تصدير التواريخ بشكل قابل للقراءة أو بشكل طابع زمني (سلسلة رقمية).';
$string['exportoptions'] = 'خيارات التصدير';
$string['exportstriphtml'] = 'إزالة HTML';
$string['exportstriphtml_help'] = 'فيما إذا كان ينبغي إزالة وسوم HTML من رسائل منشورات المنتدى، مثل p و br.';
$string['favourites'] = 'مُعَلَّمة بنجمة';
$string['favouriteupdated'] = 'تم تحديث خيارك بشأن التعليم بالنجوم.';
$string['firstpost'] = 'أول منشور';
$string['forcedreadtracking'] = 'إسمح بفرض تعقب القراءة';
$string['forcedreadtracking_desc'] = 'إسمح للمنتديات بأن تفرض تعقب القراءة. هذا سيقلل مستوى الأداء لدى بعض المستخدمين، وبخاصة في المقررات الدراسية ذات العدد الكبير من المنتديات والمنشورات. عند إيقافه، كل المنتديات التي تم فيها فرض التعقب سابقاً ستعامل على أنه أمر إختياري.';
$string['forcesubscribed'] = 'هذا المنتدى يجبر الكل للأشتراك';
$string['forcesubscribed_help'] = 'هذا المنتدى تمت تهيئته بشكل لا يسمح لك بإلغاء الاشتراك في المناقشات.';
$string['forum'] = 'منتدى';
$string['forum:addinstance'] = 'إضافة منتدى جديد';
$string['forum:addnews'] = 'إضافة إعلانات';
$string['forum:addquestion'] = 'إضافة سؤال';
$string['forum:allowforcesubscribe'] = 'السماح بفرض الاشتراك';
$string['forum:canoverridecutoff'] = 'النشر في المنتديات بعد تاريخ التوقف فيها';
$string['forum:canoverridediscussionlock'] = 'الرد على المناقشات المؤمنة';
$string['forum:canposttomygroups'] = 'النشر إلى كل المجموعات التي يمكن الوصول إليها';
$string['forum:cantogglefavourite'] = 'تعليم المناقشات بنجمة';
$string['forum:createattachment'] = 'إنشاء المرفقات';
$string['forum:deleteanypost'] = 'حذف أي منشورات (في أي وقت)';
$string['forum:deleteownpost'] = 'حذف مشاركاته (ضمن الموعد النهائي)';
$string['forum:editanypost'] = 'تحرير أي منشور';
$string['forum:exportdiscussion'] = 'تصدير المناقشة بأكملها';
$string['forum:exportforum'] = 'تصدير المنتدى';
$string['forum:exportownpost'] = 'تصدير منشوراته';
$string['forum:exportpost'] = 'تصدير المنشور';
$string['forum:grade'] = 'تقييم المنتدى';
$string['forum:managesubscriptions'] = 'إدارة المشتركين';
$string['forum:movediscussions'] = 'نقل المناقشات';
$string['forum:pindiscussions'] = 'تثبيت المناقشات';
$string['forum:postprivatereply'] = 'الرد بشكل خاص على المنشورات';
$string['forum:postwithoutthrottling'] = 'الاستثناء من عتبة النشر';
$string['forum:rate'] = 'تقييم المنشورات';
$string['forum:readprivatereplies'] = 'معاينة الردود الخاصة';
$string['forum:replynews'] = 'الرد على الإعلانات';
$string['forum:replypost'] = 'الرد على المنشورات';
$string['forum:splitdiscussions'] = 'فصل المناقشات';
$string['forum:startdiscussion'] = 'بدء مناقشات جديدة';
$string['forum:viewallratings'] = 'معاينة كل التقييمات الخام الممنوحة من قبل الأفراد';
$string['forum:viewanyrating'] = 'معاينة إجمالي التقييمات التي تلقاها أي شخص';
$string['forum:viewdiscussion'] = 'معاينة المناقشات';
$string['forum:viewhiddentimedposts'] = 'معاينة المنشورات ذات توقيتات الإخفاء';
$string['forum:viewqandawithoutposting'] = 'رؤية منشورات السؤال والأجابة (س وج) دائماً';
$string['forum:viewrating'] = 'معاينة إجمالي التقييم الذي تلقاه';
$string['forum:viewsubscribers'] = 'معاينة المشتركين';
$string['forumauthorhidden'] = 'الكاتب (غير مرئي)';
$string['forumblockingalmosttoomanyposts'] = 'أنت تقترب من عتبة النشر. لقد وضعت منشورات {$a->numposts} مرة/مرات في آخر {$a->blockperiod} والحد المسموح به هو {$a->blockafter} منشور/منشورات.';
$string['forumbodydeleted'] = 'محتوى منشور المنتدى هذا قد تمت إزالته ولم يعد بالإمكان الوصول إليه.';
$string['forumbodyhidden'] = 'هذا المنشور مخفي حاليًا، غالبًا لأنك بحاجة إلى أن تنشر شيئاً في المناقشة أولاً، وينبغي إرسال إشعارات المنشور. إحتمالية أخرى هي أن الوقت الحالي ليس ضمن الفترة المخصصة لعرض هذا المنشور.';
$string['forumgrader'] = 'مقيِّم المنتدى';
$string['forumgradingnavigation'] = 'التنقل في تقييم المنتدى';
$string['forumgradingpanel'] = 'لوحة تقييم المنتدى';
$string['forumintro'] = 'الوصف';
$string['forumname'] = 'اسم المنتدى';
$string['forumposts'] = 'منشورات المنتدى';
$string['forums'] = 'المنتديات';
$string['forumsubjectdeleted'] = 'منشور المنتدى هذا قد تمت إزالته';
$string['forumsubjecthidden'] = 'الموضوع (غير مرئي)';
$string['forumtracked'] = 'يتم تعقب المنشورات التي لم تُقرأ بعد';
$string['forumtrackednot'] = 'لا يتم متابعة المشاركات غير المقروءة';
$string['forumtype'] = 'نوع المنتدى';
$string['forumtype_help'] = 'توجد خمسة أنواع من المنتديات:

* نقاش واحد بسيط - موضوع مناقشة واحد يمكن لأي شخص أن يرد عليه (لا يمكن استعماله مع المجموعات المنفصلة)
* كل شخص يطرح نقاشاً واحداً - يمكن لكل طالب طرح موضوع مناقشة واحد فقط، يمكن لأي أحد بعدها الرد عليه
* منتدى سؤال وجواب - ينبغي على الطلاب طرح آرائهم أولاً قبل أن يتمكنوا من رؤية منشورات باقي الطلاب
* منتدى قياسي يظهر بشكل مدونة - منتدى مفتوح يستطيع فيه أي شخص أن يبدأ موضوعاً جديداً في أي وقت، ويتم عرض مواضيع المناقشات في صفحة واحدة مع روابط "ناقش هذا الموضوع"
* منتدى قياسي للاستعمال العام - منتدى مفتوح يستطيع فيه أي شخص أن يبدأ موضوعاً جديداً في أي وقت';
$string['generalforum'] = 'منتدى نموذجي للاستخدام العام';
$string['generalforums'] = 'منتديات عامة';
$string['grade_forum_header'] = 'تقييم كل المنتدى';
$string['grade_forum_name'] = 'كل المنتدى';
$string['grade_forum_title'] = 'العلامة';
$string['grade_rating_name'] = 'التقييم';
$string['graded'] = 'مقيَّم';
$string['gradedby'] = 'مقيَّم من قبل';
$string['gradeforrating'] = 'العلامة على التقييم: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'العلامة على التقييم مخفية';
$string['gradeforwholeforum'] = 'العلامة على المنتدى: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'العلامة على المنتدى مخفية';
$string['gradeitem:forum'] = 'المنتدى';
$string['gradeitemnameforrating'] = 'علامة التقييم لـ {$a->name}';
$string['gradeitemnameforwholeforum'] = 'كل المنتدى لـ {$a->name}';
$string['grades:gradesavedfor'] = 'تم حفظ العلامة لـ {$a->fullname}';
$string['grades:gradesavefailed'] = 'تعذر حفظ العلامة لـ {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'تقييم المستخدمين';
$string['grading'] = 'منح العلامة';
$string['gradingstatus'] = 'حالة العلامة:';
$string['hiddenforumpost'] = 'منشور منتدى مخفي';
$string['hidegraderpanel'] = 'إخفِ لوحة المقيِّم';
$string['hidepreviousrepliescount'] = 'أخفِ الإجابات السابقة ({$a})';
$string['hideusersearch'] = 'إخفِ بحث المستخدم';
$string['indexoutoftotal'] = '{$a->index} من أصل {$a->total}';
$string['indicator:cognitivedepth'] = 'المنتدى معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط المنتدى.';
$string['indicator:cognitivedepthdef'] = 'المنتدى معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات المنتدى خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم، معاينة الرد، التعليق على الرد، معاودة التقديم بعد معاينة الرد)';
$string['indicator:socialbreadth'] = 'المنتدى إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط المنتدى.';
$string['indicator:socialbreadthdef'] = 'المنتدى إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات المنتدى خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً، المشاركة مع الآخرين)';
$string['inforum'] = 'في  {$a}';
$string['inpagereplysubject'] = 'رد: {$a}';
$string['inreplyto'] = 'رداً على {$a}';
$string['introblog'] = 'المنشورات في هذا المنتدى تم نسخها تلقائياً من مدونات المستخدمين في هذا المقرر الدراسي لأن تلك المشاركات لم تعد متاحة';
$string['intronews'] = 'أخبار عامة وإعلانات';
$string['introsocial'] = 'منتدى مفتوح للحوار حول كل ما تريد';
$string['introteacher'] = 'منتدى الملاحظات والنقاش الخاص بالمعلم فقط';
$string['invalidaccess'] = 'لم يتم الوصول إلى هذه الصفحة بشكل صحيح';
$string['invaliddigestsetting'] = 'لقد تم إعطاء إعداد غير صحيح لإيجاز رسالة البريد';
$string['invaliddiscussionid'] = 'مُعرَّف المناقشة لم يكن صحيحاً أو لم يعد موجوداً';
$string['invalidforcesubscribe'] = 'نمط فرض الاشتراك غير صحيح';
$string['invalidforumid'] = 'مُعرَّف المنتدى لم يكن صحيحاً';
$string['invalidparentpostid'] = 'مُعرَّف المنشور ذي الرتبة الأعلى لم يكن صحيحاً';
$string['invalidpostid'] = 'مُعرَّف المنشور غير صحيح - {$a}';
$string['lastpost'] = 'آخر منشور';
$string['learningforums'] = 'منتديات التعلّم';
$string['lockdiscussion'] = 'تأمين هذه المناقشة';
$string['lockdiscussionafter'] = 'تأمين المناقشات بعد فترة من الفتور';
$string['lockdiscussionafter_help'] = 'يمكن تأمين المناقشات تلقائياً بعد انقضاء وقت معين على آخر رد فيها.

المستخدمون الذين لديهم صلاحية الرد على المناقشات المؤمنة، يمكنهم إلغاء تأمين المناقشة عبر الرد عليها.';
$string['locked'] = 'مؤمنة';
$string['lockupdated'] = 'تم تحديث خيار التأمين';
$string['longpost'] = 'منشور طويل';
$string['mailnow'] = 'أرسل إشعارات عن منشورات المنتدى بدون تأخير مهلة التحرير';
$string['managesubscriptionsoff'] = 'إنهاء إدارة الاشتراكات';
$string['managesubscriptionson'] = 'إدارة المشتركين';
$string['manydiscussions'] = 'المناقشات في الصفحة الواحدة';
$string['markalldread'] = 'تأشير كل المنشورات في هذه المناقشة على أنها مقروءة';
$string['markallread'] = 'قم باعتبار كل منشورات هذا المنتدى مقروءة.';
$string['markasread'] = 'ضع علامة بأنه مقروء';
$string['markasreadonnotification'] = 'عند إرسال إشعارات منشورات المنتدى';
$string['markasreadonnotification_help'] = 'عند إبلاغك بشأن منشور في منتدى، يمكنك إختيار فيما إذا كان ينبغي وضع علامة عليه بأنه مقروء، لأغراض تعقب المنتدى.';
$string['markasreadonnotificationno'] = 'لا تضع علامة على المنشور بأنه مقروء';
$string['markasreadonnotificationyes'] = 'ضع علامة على المنشور بأنه مقروء';
$string['markread'] = 'قم بتأشير على أنه تم قرائته';
$string['markreadbutton'] = 'قم بتأشير <br />على أنه تم قرائته';
$string['markunread'] = 'ضع علامة بأنه غير مقروء';
$string['markunreadbutton'] = 'ضع علامة<br />بأنه غير مقروء';
$string['maxattachments'] = 'العدد الأقصى للمرفقات';
$string['maxattachments_help'] = 'هذا الإعداد يحدد أقصى عدد من الملفات التي يمكن إرفاقها بمنشور في منتدى.';
$string['maxattachmentsize'] = 'الحد الاقصى لحجم المرفقات';
$string['maxattachmentsize_help'] = 'في هذا الخيار يتم تحديد أقصى حجم للملف المسموح بإرفاقه مع منشور في المنتدى.';
$string['maxtimehaspassed'] = 'عفوا! فإن الحد الأقصى من الوقت للتعديل في هذا المقال ({$a}) قد نفد!';
$string['message'] = 'الرسالة';
$string['messageinboundattachmentdisallowed'] = 'تعذر نشر ردك، نظراً لكونه يتضمن مرفقاً والمنتدى لا يسمح بالمرفقات.';
$string['messageinboundfilecountexceeded'] = 'تعذر نشر ردك، نظراً لكونه يتضمن عدداً من المرفقات يفوق العدد الأقصى المسموح به هناك والبالغ ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'تعذر نشر ردك، نظراً لكون إجمالي حجم المرفقات ({$a->filesize}) يفوق الحجم الأقصى المسموح به هناك والبالغ ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'تعذر نشر ردك، نظراً لكون المنتدى غير متاح حالياً.';
$string['messageinboundnopostforum'] = 'تعذر نشر ردك، نظراً لكونك لا تمتلك صلاحية النشر في المنتدى {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'تعذر نشر ردك. لقد تجاوزت عتبة النشر المحددة في هذا المنتدى.';
$string['messageprovider:digests'] = 'إيجازات المنتديات المشتَرَك فيها';
$string['messageprovider:posts'] = 'منشورات المنتديات المشتَرَك فيها';
$string['missingsearchterms'] = 'مصطلحات البحث التالية تتواجد فقط في مُعلَّمات لغة HTML لهذه الرسالة:';
$string['modeflatnewestfirst'] = 'عرض الردود حسب الأحدث';
$string['modeflatoldestfirst'] = 'عرض الردود حسب الأقدم';
$string['modenested'] = 'عرض الردود بشكل متداخل';
$string['modenestedv2'] = 'إعرض الردود بشكل متداخل (تجريبي)';
$string['modethreaded'] = 'عرض عناوين الردود';
$string['modulename'] = 'منتدى';
$string['modulename_help'] = 'تُمكن وحدة نشاط المنتدى المشاركين من إجراء مناقشات غير متزامنة، أي المناقشات التي تجري على مدى فترة طويلة من الزمن.

هناك عدة أنواع من المنتديات يمكن الاختيار من بينها، مثل المنتدى القياسي حيث يمكن لأي شخص أن يبدأ مناقشة جديدة في أي وقت؛ أو منتدى يمكن فيه لكل طالب أن ينشر مناقشة واحدة فقط؛ أو منتدى سؤال وجواب، حيث ينبغي على الطلبة إضافة المنشور قبل أن يكونوا قادرين على استعراض منشورات الطلاب الآخرين. يمكن للمعلم السماح بإرفاق الملفات بمنشورات المنتدى. الصور المرفقة تُعرض مع منشورات المنتدى.

يمكن للمشاركين الاشتراك في المنتدى لتلقي الإشعارات بشأن منشوراته الجديدة. يمكن للمعلم تحديد طريقة الاشتراك في المنتدى  لتكون اختيارية، مفروضة أو تلقائية، أو حتى منع الاشتراك تماماً. إذا لزم الأمر، يمكن حظر الطلاب من نشر أكثر من عدد معين من المنشورات خلال فترة زمنية معينة؛ هذا يمكن أن يمنع الأفراد من الهيمنة على المناقشات.

يمكن تقييم منشورات المنتدى من قبل المعلمين أو الطلاب (تقييم النظراء). يمكن تجميع التقييمات للخروج منها بالعلامة النهائية التي يتم تسجيلها في سجل التقديرات.

للمنتديات  العديد من الاستعمالات، مثل:

* فضاء اجتماعي للطلاب للتعرف على بعضهم البعض
* وضع إعلانات المقرر الدراسي (باستعمال منتدى الأخبار ذي الاشتراك المفروض)
* مناقشة محتوى المقرر أو مواد القراءة
* متابعة النقاش على الانترنت لقضية سبق وأن أثيرت في جلسة حوار وجهاً لوجه.
* مناقشات خاصة بالمعلمين فقط (باستعمال منتدى مخفي)
* مركز للمساعدة حيث يمكن للمحاضرين والطلاب إعطاء المشورة
* منطقة دعم واحد لواحد للاتصالات الخاصة بين الطالب والمعلم (باستعمال منتدى ذي مجموعات منفصلة مع جعل كل طالب في مجموعة)
* الأنشطة التعزيزية، على سبيل المثال \'ألعاب التفكير\' للطلاب من أجل التفكير واقتراح الحلول';
$string['modulenameplural'] = 'منتديات';
$string['more'] = 'المزيد';
$string['movedmarker'] = '(منقول)';
$string['movethisdiscussionlabel'] = 'أنقل المناقشة الحالية إلى المنتدى المحدد';
$string['movethisdiscussionto'] = 'أنقل هذه المناقشة إلى ...';
$string['mustprovidediscussionorpost'] = 'عليك إعطاء إما مُعرَّف المناقشة أو مُعرَّف المنشور لغرض التصدير.';
$string['myprofileotherdis'] = 'مناقشات المنتدى';
$string['myprofileowndis'] = 'مناقشاتي في المنتدى';
$string['myprofileownpost'] = 'منشوراتي في المنتدى';
$string['namenews'] = 'الإعلانات';
$string['namenews_help'] = 'منتدى الإعلانات في المقرر الدراسي هو منتدى خاص لأغراض الإعلان ويتم إنشاؤه تلقائياً عند إنشاء المقرر. يمكن للمقرر أن يحتوي على منتدى إعلانات واحد فقط. المعلمون والمشرفون فقط يمكنهم نشر الإعلانات. كتلة "آخر الإعلانات" ستعرض آخر منشورات هذا المنتدى.';
$string['namesocial'] = 'منتدى اجتماعي';
$string['nameteacher'] = 'منتدى المعلم';
$string['newforumposts'] = 'المنشورات الجديدة في المنتدى';
$string['nextdiscussiona'] = 'المناقشة التالية: {$a}';
$string['nextuser'] = 'إحفظ التغييرات وانتقل إلى المستخدم التالي';
$string['noattachments'] = 'لا توجد مرفقات لهذا المنشور';
$string['nodiscussions'] = 'لا يوجد موضوع للمناقشة بعد في هذا المنتدى';
$string['nodiscussionsstartedby'] = '{$a} لم يبدأ بأي مناقشة';
$string['nodiscussionsstartedbyyou'] = 'أنتَ لم تبدأ بأي مناقشات بعد';
$string['noguestpost'] = 'عذراً، غير مسموح للضيوف بوضع المنشورات.';
$string['noguestsubscribe'] = 'عذراً، غير مسموح للضيوف بالاشتراك.';
$string['noguesttracking'] = 'عذراً! لا يسمح للضيوف تفعيل خيارات المتابعة';
$string['nomorepostscontaining'] = 'لاتوجد مشاركات إضافية تحتوي على \' {$a}\' تم اكتشافها';
$string['nonews'] = 'لم تُنشر أي إعلانات بعد.';
$string['noonecansubscribenow'] = 'الاشتراكات غير مسموحة الآن';
$string['nopermissiontosubscribe'] = 'ليست لديك صلاحية معاينة مشتركي المنتدى';
$string['nopermissiontoview'] = 'ليست لديك صلاحية معاينة هذا المنشور';
$string['nopostforum'] = 'عذراً، ليس مسموحاً لك بالنشر في هذا المنتدى';
$string['noposts'] = 'لا توجد منشورات';
$string['nopostsmadebyuser'] = 'لم يقدم {$a} أي منشورات';
$string['nopostsmadebyyou'] = 'لم تقدم أي منشورات';
$string['noquestions'] = 'لا توجد أسئلة في هذا المنتدى حتى الان';
$string['nosubscribers'] = 'لا يوجد مشتركون بعد في هذا المنتدى';
$string['notexists'] = 'المناقشة لم يعد لها وجود';
$string['notgraded'] = 'لم تُمنح علامة';
$string['nothingnew'] = 'لا جديد لـ {$a}';
$string['notingroup'] = 'عذرا، يجب ان تكون من ضمن المجموعة لمعاينة هذا المنتدى.';
$string['notinstalled'] = 'وحدة المنتدى غير منصبة';
$string['notlocked'] = 'تأمين';
$string['notpartofdiscussion'] = 'هذا المنشور ليس جزءاً من مناقشة!';
$string['notrackforum'] = 'لا تتابع الرسائل غير المقروءة';
$string['notsubscribed'] = 'إشترك';
$string['nousersmatch'] = 'تعذر العثور على أي مستخدم حسب المعيار المعطى';
$string['noviewdiscussionspermission'] = 'ليس لديك الصلاحية لمعاينة المناقشات في هذا المنتدى';
$string['nowallsubscribed'] = 'أنت الآن مشترك في كل منتديات {$a}.';
$string['nowallunsubscribed'] = 'أنت الآن غير مشترك في كل منتديات {$a}.';
$string['nowgradinguser'] = 'يجري الآن منح علامة {$a}';
$string['nownotsubscribed'] = '{$a->name} لن يتم إشعاره بشأن المنشورات الجديدة في \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} لم يعد يتعقب \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} سيتم إشعاره بشأن المنشورات الجديدة في \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} الآن يتابع\'{$a->forum}\'';
$string['numberofreplies'] = 'عدد الردود: {$a}';
$string['numposts'] = '{$a} مقالات';
$string['olderdiscussions'] = 'المناقشات الأقدم';
$string['oldertopics'] = 'موضوعات قديمة';
$string['oldpostdays'] = 'مقروءة بعد أيام';
$string['overviewnumpostssince'] = '{$a} منشور/منشورات منذ آخر دخول';
$string['overviewnumunread'] = '{$a} إجمالي غير المقروء';
$string['page-mod-forum-discuss'] = 'صفحة مسلك مناقشة وحدة المنتدى';
$string['page-mod-forum-view'] = 'الصفحة الرئيسية لوحدة المنتدى';
$string['page-mod-forum-x'] = 'أي صفحة لوحدة المنتدى';
$string['parent'] = 'أظهر الأعلى رتبة';
$string['parentofthispost'] = 'اصل المقال';
$string['permalink'] = 'الرابط الدائم';
$string['permanentlinktoparentpost'] = 'الرابط الدائم إلى المنشور ذي الرتبة الأعلى';
$string['permanentlinktopost'] = 'الرابط الدائم إلى المنشور';
$string['pindiscussion'] = 'قم بتثبيت هذه المناقشة';
$string['pinupdated'] = 'تم تحديث خيار التثبيت.';
$string['pluginadministration'] = 'إدارة المنتدى';
$string['pluginname'] = 'منتدى';
$string['postadded'] = '<p>تمت إضافة مقالتك بنجاح>.</p> <p>لديك {$a} للتحرير إن كنت تريد عمل أي تعديلات.</p>';
$string['postaddedsuccess'] = 'تمت إضافة مقالتك بنجاح.';
$string['postaddedtimeleft'] = 'لديك {$a} للتحرير إن كنت تريد عمل أي تعديلات.';
$string['postbymailsuccess'] = 'ردك عن "{$a->subject}" تم نشره بنجاح: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'ردك <a href="{$a->discussionurl}">{$a->subject}</a> تم نشره بنجاح.';
$string['postbyuser'] = '{$a->post} من قِبَل {$a->user}';
$string['postincontext'] = 'شاهد هذا المقال في السياق';
$string['postisprivatereply'] = 'هذا رد خاص. هو مرئي لك فقط ولمن لديك إمكانية معاينة الردود الخاصة، مثل المعلمين والمدراء.';
$string['postmailinfo'] = 'هذه نسخة من رسالة نشرت في {$a}.';
$string['postmailinfolink'] = 'هذه نسخة من الرسالة المنشورة في {$a->coursename}.

للرد، أنقر على هذا الرابط: {$a->replylink}';
$string['postmailnow'] = '<p>سيتم حالاً إرسال هذا المنشور بريدياً إلى كل مشتركي المنتدى.</p>';
$string['postmailreply'] = 'للرد، أنقر على هذا الرابط: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'غالباً تعلُّم منفصل';
$string['postrating2'] = 'منفصل ومتصل';
$string['postrating3'] = 'غالباً تعلُّم متصل';
$string['posts'] = 'المنشورات';
$string['postsfrom'] = 'المنشورات من';
$string['postsmadebyuser'] = 'المواضيع التي نشرها {$a}';
$string['postsmadebyuserincourse'] = 'المواضيع التي نشرها {$a->fullname} في {$a->coursename}';
$string['poststo'] = 'المنشورات إلى';
$string['posttoforum'] = 'أضف المنشور للمنتدى';
$string['posttomygroups'] = 'أنشر نسخة إلى كل المجموعات';
$string['posttomygroups_help'] = 'يقوم بنشر نسخة من هذه الرسالة إلى كل المجموعات التي بإمكانك الوصول إليها. المشاركون في المجموعات التي لا يمكنك الوصول إليها لن يشاهدوا هذا المنشور.';
$string['postupdated'] = 'تم تحديث مقالك المرسل';
$string['potentialsubscribers'] = 'المشتركون المحتملون';
$string['prevdiscussiona'] = 'المناقشة السابقة: {$a}';
$string['previoususer'] = 'إحفظ التغييرات وانتقل إلى المستخدم السابق';
$string['privacy:digesttypenone'] = 'لا نحتفظ بأي بيانات تتعلق بنوع الإيجاز المفضل لهذا المنتدى.';
$string['privacy:digesttypepreference'] = 'لقد اخترتَ تلقي هذا النوع من إيجاز المنتدى: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'لقد اخترتَ هذا التفضيل من الاشتراك في المناقشات لهذا المنتدى: "{$a->preference}".';
$string['privacy:metadata:core_rating'] = 'إن المنتدى يستعمل نظام التقييم الفرعي لدعم تقييم المنشورات.';
$string['privacy:metadata:core_tag'] = 'إن المنتدى يستعمل نظام الوسوم الفرعي لدعم وضع الوسوم في المنشورات';
$string['privacy:metadata:forum_digests'] = 'معلومات عن تفضيلات الإيجاز لكل منتدى';
$string['privacy:metadata:forum_digests:forum'] = 'المنتدى المشترَك فيه';
$string['privacy:metadata:forum_digests:maildigest'] = 'تفضيل الإيجاز';
$string['privacy:metadata:forum_digests:userid'] = 'مُعرَّف المستخدم ذي تفضيل الإيجاز';
$string['privacy:metadata:forum_discussion_subs'] = 'معلومات عن الاشتراكات في مناقشات المنتدى الفردية';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'مُعرَّف المناقشة التي تم الاشتراك فيها';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'وقت بدء الاشتراك';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'مُعرَّف المستخدم ذي اشتراك المناقشة';
$string['privacy:metadata:forum_discussions'] = 'معلومات عن مناقشات المنتدى الفردية التي أنشأها المستخدم';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - ماذا يخزن هذا الحقل';
$string['privacy:metadata:forum_discussions:name'] = 'اسم المناقشة، كما اختاره المؤلف';
$string['privacy:metadata:forum_discussions:timemodified'] = 'وقت آخر تعديل في المناقشة';
$string['privacy:metadata:forum_discussions:userid'] = 'مُعرَّف المستخدم الذي أنشأ المناقشة';
$string['privacy:metadata:forum_discussions:usermodified'] = 'مُعرَّف المستخدم الأخير الذي عدَّل المناقشة بطريقة ما';
$string['privacy:metadata:forum_grades'] = 'بيانات العلامة للمنتدى';
$string['privacy:metadata:forum_grades:forum'] = 'المنتدى الذي تم تقييمه';
$string['privacy:metadata:forum_grades:grade'] = 'العلامة الممنوحة';
$string['privacy:metadata:forum_grades:userid'] = 'المستخدم الذي تم منحه العلامة';
$string['privacy:metadata:forum_posts'] = 'معلومات عن تفضيلات الإيجاز لكل منتدى';
$string['privacy:metadata:forum_posts:created'] = 'وقت إنشاء المنشور';
$string['privacy:metadata:forum_posts:discussion'] = 'المناقشة التي فيها المنشور';
$string['privacy:metadata:forum_posts:message'] = 'رسالة منشور المنتدى';
$string['privacy:metadata:forum_posts:modified'] = 'وقت آخر تعديل في المنشور';
$string['privacy:metadata:forum_posts:parent'] = 'المنشور ذو الرتبة الأعلى الذي تم الرد عليه';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'مُعرَّف المستخدم الذي تم إرسال هذا الرد إليه';
$string['privacy:metadata:forum_posts:subject'] = 'موضوع منشور المنتدى';
$string['privacy:metadata:forum_posts:totalscore'] = 'رسالة منشور المنتدى';
$string['privacy:metadata:forum_posts:userid'] = 'مُعرَّف المستخدم الذي ألَّف منشور المنتدى';
$string['privacy:metadata:forum_queue'] = 'السجل المؤقت للمنشورات التي سيتم إرسالها بريدياً بشكل موجز';
$string['privacy:metadata:forum_queue:discussionid'] = 'مُعرَّف مناقشة المنتدى';
$string['privacy:metadata:forum_queue:postid'] = 'مُعرَّف منشور المنتدى';
$string['privacy:metadata:forum_queue:timemodified'] = 'وقت تعديل المنشور الأصلي';
$string['privacy:metadata:forum_queue:userid'] = 'المستخدم الذي ينبغي إشعاره بشأن المنشور';
$string['privacy:metadata:forum_read'] = 'معلومات عن أي من المنشورات تمت قراءتها من قبل المستخدم';
$string['privacy:metadata:forum_read:discussionid'] = 'المناقشة التي يوجد فيها المنشور';
$string['privacy:metadata:forum_read:firstread'] = 'وقت أول قراءة للمنشور';
$string['privacy:metadata:forum_read:lastread'] = 'وقت أحدث قراءة للمنشور';
$string['privacy:metadata:forum_read:postid'] = 'المنشور الذي تمت قراءته';
$string['privacy:metadata:forum_read:userid'] = 'مُعرَّف المستخدم العائد له هذا السجل';
$string['privacy:metadata:forum_subscriptions'] = 'معلومات عن أي من المنتديات التي اشترك فيها المستخدم';
$string['privacy:metadata:forum_subscriptions:forum'] = 'المنتدى المشترَك فيه';
$string['privacy:metadata:forum_subscriptions:userid'] = 'مُعرَّف المستخدم العائد له الاشتراك في هذا المنتدى';
$string['privacy:metadata:forum_track_prefs'] = 'معلومات عن أي من المنتديات التي اختار فيها المستخدم تعقب قراءة المنشورات';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'المنتدى الذي تم فيه تمكين تعقب القراءة';
$string['privacy:metadata:forum_track_prefs:userid'] = 'مُعرَّف المستخدم العائد له تفضيل تعقب القراءة في هذا المنتدى';
$string['privacy:metadata:preference:autosubscribe'] = 'فيما إذا كان ينبغي الاشتراك في المناقشات عند الرد على المنشورات فيها';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'اتجاه الفرز المفضل لقائمة المناقشات';
$string['privacy:metadata:preference:maildigest'] = 'تفضيل إيجاز البريد على مستوى عموم الموقع';
$string['privacy:metadata:preference:markasreadonnotification'] = 'فيما إذا كان ينبغي اعتبار منشورات المنتدى مقروءة عند تلقيها بشكل رسائل';
$string['privacy:metadata:preference:trackforums'] = 'فيما إذا كان ينبغي تفعيل تعقب القراءة';
$string['privacy:postwasread'] = 'هذا المنشور تمت قراءته لأول مرة في {$a->firstread} وأحدث قراءة كانت في {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'لقد اخترت عدم تعقب قراءة المنشورات في هذا المنتدى.';
$string['privacy:request:delete:discussion:name'] = 'الحذف عند طلب المؤلف';
$string['privacy:request:delete:post:message'] = 'لقد تم حذف محتوى هذا المنشور بناءً على طلب مؤلفه.';
$string['privacy:request:delete:post:subject'] = 'الحذف عند طلب المؤلف';
$string['privacy:subscribedtoforum'] = 'أنت مشترك في هذا المنتدى.';
$string['privatereply'] = 'الرد بشكل خاص';
$string['privatereply_help'] = 'يمكن معاينة الرد الخاص من قبل مؤلف المنشور الموجه إليه الرد حصراً، مع أي مستخدمين لديهم صلاحية معاينة الردود الخاصة.';
$string['processingdigest'] = 'معالجة الموجز البريدي للمستخدم {$a}';
$string['processingpost'] = 'معالجة الرسالة {$a}';
$string['prune'] = 'إقسم';
$string['prunedpost'] = 'تم إنشاء مناقشة جديدة لذلك المنشور';
$string['pruneheading'] = 'إقسم المناقشة وانقل هذا المنشور إلى مناقشة جديدة';
$string['qandaforum'] = 'منتدى سؤال وجواب';
$string['qandanotify'] = 'هذا منتدى سؤال وجواب. لمعاينة مشاركات الآخرين فيه، ينبغي عليك المشاركة بإجابتك على الأسئلة أولاً';
$string['re'] = 'رد:';
$string['readtherest'] = 'قراءة باقي الموضوع';
$string['removeallforumtags'] = 'إزالة كل وسوم المنتدى';
$string['removefromfavourites'] = 'إرفع النجمة عن هذه المناقشة';
$string['replies'] = 'الردود';
$string['repliesmany'] = '{$a} الردود حتى الآن';
$string['repliesone'] = '{$a} رد حتى الان';
$string['reply'] = 'رد';
$string['reply_handler'] = 'الرد على منشورات المنتدى عبر البريد الالكتروني';
$string['reply_handler_name'] = 'الرد على منشورات المنتدى';
$string['replyauthorself'] = '{$a} (أنتَ)';
$string['replyforum'] = 'رد على المنتدى';
$string['replyingtoauthor'] = 'رداً على {$a}...';
$string['replyplaceholder'] = 'أكتب ردك...';
$string['replytopostbyemail'] = 'يمكنك الرد عليها عبر البريد الالكتروني.';
$string['replytouser'] = 'استخدم عنوان البريد الإلكتروني في الرد';
$string['resetdigests'] = 'حذف كل تفضيلات إيجاز المنتدى على مستوى المستخدمين';
$string['resetforums'] = 'حذف المنشورات من';
$string['resetforumsall'] = 'حذف جميع المنشورات';
$string['resetsubscriptions'] = 'حذف كل اشتراكات المنتدى';
$string['resettrackprefs'] = 'حذف كل تفضيلات تعقب المنتدى';
$string['rssarticles'] = 'عدد المقالات الأخيرة في خدمة مغذي الأخبار';
$string['rssarticles_help'] = 'هذا الإعداد يحدد عدد المقالات (إما مناقشات أو منشورات) المطلوب تضمينها في خدمة مغذي الأخبار. تتراوح القيم المقبولة عادة ما بين 5 و20.';
$string['rsssubscriberssdiscussions'] = 'مغذي الأخبار للمناقشات';
$string['rsssubscriberssposts'] = 'خدمة مغذي الأخبار للمنشورات';
$string['rsstype'] = 'خدمة مغذي الأخبار لهذا النشاط';
$string['rsstype_help'] = 'لتمكين خدمة مغذي الأخبار لهذا النشاط، إختر إما المناقشات أو المنشورات المراد تضمينها في المغذي.';
$string['rsstypedefault'] = 'نوع خدمة مغذي الأخبار';
$string['search'] = 'بحث';
$string['search:activity'] = 'المنتدى - معلومات النشاط';
$string['search:post'] = 'المنتدى - المنشورات';
$string['searchdatefrom'] = 'المنشور ينبغي أن يكون أحدث من';
$string['searchdateto'] = 'المنشور ينبغي أن يكون أقدم من';
$string['searchforumintro'] = 'الرجاء إدخال معطيات البحث في حقل واحد أو أكثر من الحقول الآتية:';
$string['searchforums'] = 'البحث في المنتديات';
$string['searchfullwords'] = 'هذه الكلمات لا بد ان تظهر ككلمات كاملة';
$string['searchnotwords'] = 'لا تقم بتضمين هذه الكلمات';
$string['searcholderposts'] = 'البحث عن مشاركات قديمة';
$string['searchphrase'] = 'هذه الجملة بالضبط ينبغي أن تتواجد في المنشور';
$string['searchresults'] = 'نتائج البحث';
$string['searchsubject'] = 'ينبغي أن تكون هذه الكلمات ضمن الموضوع';
$string['searchtags'] = 'موسومة بـ';
$string['searchuser'] = 'لابد من مطابقة هذا الاسم مع اسم الكاتب';
$string['searchuserid'] = 'مُعرَّف مودل للمؤلف';
$string['searchusers'] = 'إبحث عن المستخدمين';
$string['searchwhichforums'] = 'إختر المنتديات التي سيتم البحث فيها';
$string['searchwords'] = 'يمكن لهذه الكلمات الظهور في أي جزء من المنشور';
$string['seeallposts'] = 'مشاهدة كل منشورات هذا المستخدم';
$string['sendstudentnotificationsdefault'] = 'الإعداد الافتراضي لـ "إشعار الطلاب"';
$string['sendstudentnotificationsdefault_help'] = 'حدد القيمة الافتراضية لخانة التأشير "إشعار الطلاب" في نموذج التقييم.';
$string['sendstudentnotificationsno'] = 'لا';
$string['sendstudentnotificationsyes'] = 'نعم، أرسل إشعاراً إلى الطلاب';
$string['settings'] = 'الإعدادات';
$string['shortpost'] = 'منشور قصير';
$string['showgraderpanel'] = 'أظهر لوحة المقيِّم';
$string['showingcountoftotaldiscussions'] = 'قائمة المناقشات. يتم إظهار {$a->count} من {$a->total} مناقشة/مناقشات.';
$string['showmoreusers'] = 'أظهر المزيد من المستخدمين';
$string['showpreviousrepliescount'] = 'أظهر الردود السابقة ({$a})';
$string['showsubscribers'] = 'إظهار/تحرير المشتركين الحاليين';
$string['showusersearch'] = 'أظهر البحث عن المستخدمين';
$string['singleforum'] = 'نقاش واحد بسيط';
$string['smallmessage'] = 'نُشر في {$a->forumname} بواسطة {$a->user}';
$string['smallmessagedigest'] = 'موجز المنتدى يضم {$a} رسالة/رسائل.';
$string['starredonly'] = 'إبحث في المناقشات المعلمة بنجمة فقط';
$string['startedby'] = 'بدأه';
$string['subject'] = 'الموضوع';
$string['subscribe'] = 'اشترك في هذا المنتدى';
$string['subscribeall'] = 'اشرك الكل في هذا المنتدى';
$string['subscribed'] = 'تم الاشتراك';
$string['subscribediscussion'] = 'إشترك في هذه المناقشة';
$string['subscribeenrolledonly'] = 'عذراً، المستخدمون المنضمون فقط يسمح لهم بالاشتراك في إشعارات منشورات المنتدى.';
$string['subscribenone'] = 'ألغِ اشتراك الكل في هذا المنتدى';
$string['subscribers'] = 'المشتركون';
$string['subscriberstowithcount'] = 'المشتركون في "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'أرسل لي إشعارات عن المنشورات الجديدة في هذا المنتدى';
$string['subscribestop'] = 'لا أرغب بالحصول على إشعارات عن المنشورات الجديدة في هذا المنتدى';
$string['subscription'] = 'اشتراك';
$string['subscription_help'] = 'إذا كنت مشتركاً في منتدى فهذا معناه تلقيك لإشعارات بشأن المنشورات الجديدة فيه. عادة، لك حرية اختيار الاشتراك من عدمه، لكن أحياناً قد يكون الاشتراك مفروضاً في منتدى معين ليتلقى الجميع إشعارات منه.';
$string['subscriptionandtracking'] = 'الاشتراك والتعقب';
$string['subscriptionauto'] = 'إشتراك تلقائي';
$string['subscriptiondisabled'] = 'إشتراك معطَّل';
$string['subscriptionforced'] = 'إشتراك مفروض';
$string['subscriptionmode'] = 'حالة الاشتراك';
$string['subscriptionmode_help'] = 'عندما يشترك مشارك ما في منتدى، هذا يعني تلقيه إشعارات بشأن المنشورات فيه. هناك أربعة خيارات لنمط الاشتراك:

* اشتراك اختياري - يمكن للمشاركين الاختيار فيما إذا كانوا راغبين بالاشتراك
* اشتراك مفروض - الجميع مشتركون، ولا يمكن لهم الانسحاب
* اشتراك تلقائي - الجميع مشتركون مبدئياً، ولكن يمكنهم الانسحاب في أي وقت
* الاشتراك معطل - الاشتراكات غير مسموح بها';
$string['subscriptionoptional'] = 'اشتراك اختياري';
$string['subscriptions'] = 'اشتراكات';
$string['tagarea_forum_posts'] = 'منشورات المنتدى';
$string['tagsdeleted'] = 'وسوم المنتدى قد تم حذفها';
$string['thisforumhasduedate'] = 'تاريخ استحقاق النشر في هذا المنتدى هو {$a}.';
$string['thisforumisdue'] = 'تاريخ استحقاق النشر في هذا المنتدى كان {$a}.';
$string['thisforumisthrottled'] = 'هذا المنتدى لديه حد لعدد المنشورات التي يمكنك طرحها خلال فترة زمنية معينة - هذا الحد حالياً هو {$a->blockafter} منشور في {$a->blockperiod}';
$string['timed'] = 'موقوت';
$string['timeddiscussion'] = 'مناقشة موقوتة';
$string['timedhidden'] = 'حالة موقوتة: مخفي عن الطلاب';
$string['timedposts'] = 'المنشورات الموقوتة';
$string['timedvisible'] = 'حالة موقوتة: مرئي لكل المستخدمين';
$string['timestartenderror'] = 'تاريخ انتهاء العرض لا يمكن أن يكون سابقاً لتاريخ البدء';
$string['togglediscussionmenu'] = 'تبديل قائمة المناقشة';
$string['togglefullscreen'] = 'تبديل ملء الشاشة';
$string['togglesettingsdrawer'] = 'تبديل دُرج الإعدادات';
$string['trackforum'] = 'تعقب المنشورات غير المقروءة';
$string['tracking'] = 'تابع';
$string['trackingoff'] = 'مغلق';
$string['trackingon'] = 'مفروض';
$string['trackingoptional'] = 'إختياري';
$string['trackingtype'] = 'تعقب القراءة';
$string['trackingtype_help'] = 'تعقب القراءة يسهل على المشاركين التعرف على المنشورات التي لم يشاهدوها بعد عبر إبراز تلك المنشورات لهم.

إذا تم جعله إختيارياً، يمكن للمشاركين التخيَُر ما بين تفعيل تعقب القراءة أو تعطيله عبر رابط يظهر لهم في قائمة الإجراءات أو كتلة الإدارة اعتماداً على النمط المستعمل في الموقع. (على المستخدمين أيضاً تمكين تعقب القراءة في تفضيلاتهم الشخصية).

إذا تم تفعيل \'إسمح بفرض تعقب القراءة\' في إدارة الموقع، فعندها سيظهر خيار إضافي، وهو الفرض. هذا معناه أن التعقب مفعل دائماً بغض النظر عن التفضيل الشخصي للمستخدم.';
$string['trackreadposts_header'] = 'تعقب المنتدى';
$string['unlockdiscussion'] = 'إلغاء تأمين هذه المناقشة';
$string['unpindiscussion'] = 'إلغاء تثبيت هذه المناقشة';
$string['unread'] = 'غير مقروءة';
$string['unreadpost'] = 'منشور غير مقروء';
$string['unreadposts'] = 'منشورات غير مقروءة';
$string['unreadpostsnumber'] = '{$a} منشور/منشورات غير مقروءة';
$string['unreadpostsone'] = 'منشور واحد غير مقروء';
$string['unsubscribe'] = 'إلغاء الاشتراك في هذا المنتدى';
$string['unsubscribeall'] = 'إلغاء الاشتراك في كل المنتديات';
$string['unsubscribeallconfirm'] = 'أنت حالياً مشترك في {$a->forums} منتدى/منتديات، و {$a->discussions} مناقشة/مناقشات. هل ترغب حقاً في إلغاء اشتراكك فيها جميعاً مع تعطيل الاشتراك التلقائي في المناقشات؟';
$string['unsubscribeallconfirmdiscussions'] = 'أنت حالياً مشترك في {$a->discussions} مناقشة/مناقشات. هل ترغب حقاً في إلغاء اشتراكك فيها جميعاً مع تعطيل الاشتراك التلقائي في المناقشات؟';
$string['unsubscribeallconfirmforums'] = 'أنت حالياً مشترك في {$a->forums} منتدى/منتديات. هل ترغب حقاً في إلغاء اشتراكك فيها جميعاً مع تعطيل الاشتراك التلقائي في المناقشات؟';
$string['unsubscribealldone'] = 'تمت إزالة كل الاشتراكات الاختيارية في المنتديات. ستستمر في تلقي الإشعارات من المنتديات ذات الاشتراكات المفروضة. لإدارة إشعارات المنتديات، إذهب إلى باب المراسلة في إعدادات ملفك الشخصي.';
$string['unsubscribeallempty'] = 'أنت غير مشترك في أي منتدى. لتعطيل كل إشعارات هذا المخدم، إذهب إلى باب المراسلة في إعدادات ملفك الشخصي.';
$string['unsubscribed'] = 'إلغاء الاشتراك';
$string['unsubscribediscussion'] = 'إلغاء الاشتراك في هذه المناقشة';
$string['unsubscribediscussionlink'] = 'إلغاء الاشتراك في هذه المناقشة: {$a}';
$string['unsubscribelink'] = 'إلغاء الاشتراك في هذا المنتدى: {$a}';
$string['unsubscribeshort'] = 'ألغِ الاشتراك';
$string['useexperimentalui'] = 'استعمل طريقة المعاينة المتداخلة للمناقشات (تجريبية)';
$string['usermarksread'] = 'تأشير قراءة الرسالة يدوياً';
$string['usernavigation'] = 'تنقل المستخدم';
$string['usersforumposts'] = 'منشورات المستخدم في المنتدى';
$string['viewalldiscussions'] = 'معاينة كل المناقشات';
$string['viewconversation'] = 'معاينة المناقشة';
$string['viewgrades'] = 'عرض التقديرات';
$string['viewparentpost'] = 'معاينة المنشور ذي الرتبة الأعلى';
$string['viewthediscussion'] = 'معاينة المناقشة';
$string['warnafter'] = 'عتبة النشر لغرض التحذير';
$string['warnafter_help'] = 'يجب أن يتم تنبيه الطالب إلى العدد المحدد المسموح به من المنشورات في هذا المنتدى خلال فترة زمنية محددة. هذا الإعداد يحدد عدد المنشورات التي يقدمونها قبل أن يُرسل إليهم التنبيه. المستخدمون الذين يتمتعون بالإمكانية mod/forum:postwithoutthrottling هم معفون من عتبة النشر.';
$string['warnformorepost'] = 'تحذير! هناك أكثر من مناقشة واحدة في هذا المنتدى - يجري استعمال أحدثها';
$string['yournewquestion'] = 'سؤالك الجديد';
$string['yournewtopic'] = 'موضوع مناقشتك الجديد';
$string['yourreply'] = 'ردك';
