<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'cs', version '3.10'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresa';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Vložit/upravit záložku (kotvu)';
$string['advanced:backcolor_desc'] = 'Barva pozadí';
$string['advanced:block'] = 'Formát';
$string['advanced:blockquote'] = 'Bloková citace';
$string['advanced:blockquote_desc'] = 'Bloková citace';
$string['advanced:bold_desc'] = 'Tučné (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Vložit / odebrat seznam s odrážkami';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Vložit speciální znak';
$string['advanced:cleanup_desc'] = 'Vyčistit kód';
$string['advanced:clipboard_msg'] = 'Funkce kopírovat/vyjmout/vložit nejsou podporované v prohlížečích Mozilla a Firefox.
Chcete více informací o tomto problému?';
$string['advanced:code'] = 'Kód';
$string['advanced:code_desc'] = 'Upravit HTML zdroj';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopírovat';
$string['advanced:custom1_desc'] = 'Libovolný popisek';
$string['advanced:cut_desc'] = 'Vyjmout';
$string['advanced:dd'] = 'Popis definice';
$string['advanced:div'] = 'Oddíl';
$string['advanced:dt'] = 'Termín definice';
$string['advanced:font_size'] = 'Velikost písma';
$string['advanced:fontdefault'] = 'Písmo';
$string['advanced:forecolor_desc'] = 'Barva textu';
$string['advanced:h1'] = 'Nadpis 1';
$string['advanced:h2'] = 'Nadpis 2';
$string['advanced:h3'] = 'Nadpis 3';
$string['advanced:h4'] = 'Nadpis 4';
$string['advanced:h5'] = 'Nadpis 5';
$string['advanced:h6'] = 'Nadpis 6';
$string['advanced:help_desc'] = 'Nápověda';
$string['advanced:help_shortcut'] = 'Pro panel nástrojů stiskněte kombinaci kláves ALT-F10. Pro nápovědu stiskněte kombinace kláves ALT-0';
$string['advanced:hr_desc'] = 'Vložit vodorovný oddělovač';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Vložit/upravit obrázek';
$string['advanced:image_props_desc'] = 'Vlastnosti obrázku';
$string['advanced:indent_desc'] = 'Zvětšit odsazení';
$string['advanced:italic_desc'] = 'Kurzíva (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Zarovnat na střed';
$string['advanced:justifyfull_desc'] = 'Zarovnat do bloku';
$string['advanced:justifyleft_desc'] = 'Zarovnat doleva';
$string['advanced:justifyright_desc'] = 'Zarovnat doprava';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Vložit/upravit odkaz';
$string['advanced:more_colors'] = 'Další barvy';
$string['advanced:newdocument'] = 'Jste si opravdu jisti, že chcete odstranit veškerý obsah?';
$string['advanced:newdocument_desc'] = 'Nový dokument';
$string['advanced:numlist_desc'] = 'Vložit / odebrat číslovaný seznam';
$string['advanced:outdent_desc'] = 'Zmenšit odsazení';
$string['advanced:paragraph'] = 'Odstavec';
$string['advanced:paste_desc'] = 'Vložit';
$string['advanced:path'] = 'Cesta';
$string['advanced:pre'] = 'Předformátováno';
$string['advanced:redo_desc'] = 'Znovu (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Odstranit formátování';
$string['advanced:rich_text_area'] = 'Pole textu';
$string['advanced:samp'] = 'Ukázka kódu';
$string['advanced:shortcuts_desc'] = 'Pomoc pro přístupnost';
$string['advanced:striketrough_desc'] = 'Přeškrtnuté';
$string['advanced:style_select'] = 'Styly';
$string['advanced:sub_desc'] = 'Dolní index';
$string['advanced:sup_desc'] = 'Horní index';
$string['advanced:toolbar'] = 'Panel nástrojů';
$string['advanced:toolbar_focus'] = 'Přechod na lištu nástrojů - Alt+Q, přechod do editoru - Alt-Z, přechod na cestu prvků - Alt-X';
$string['advanced:underline_desc'] = 'Podtržené (Ctrl+U)';
$string['advanced:undo_desc'] = 'Zpět (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Odebrat odkaz';
$string['advanced:visualaid_desc'] = 'Zobrazit/skrýt pomocné linky/skryté prvky';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O programu';
$string['advanced_dlg:about_help'] = 'Nápověda';
$string['advanced_dlg:about_license'] = 'Licence';
$string['advanced_dlg:about_loaded'] = 'Načtené zásuvné moduly';
$string['advanced_dlg:about_plugin'] = 'Zásuvný modul';
$string['advanced_dlg:about_plugins'] = 'Zásuvné moduly';
$string['advanced_dlg:about_title'] = 'O TinyMCE';
$string['advanced_dlg:about_version'] = 'Verze';
$string['advanced_dlg:accessibility_help'] = 'Pomoc pro přístupnost';
$string['advanced_dlg:accessibility_usage_title'] = 'Obecné použití';
$string['advanced_dlg:anchor_invalid'] = 'Zadejte prosím platný název kotvy.';
$string['advanced_dlg:anchor_name'] = 'Název záložky';
$string['advanced_dlg:anchor_title'] = 'Vložit/upravit záložku (kotvu)';
$string['advanced_dlg:charmap_title'] = 'Vybrat speciální znak';
$string['advanced_dlg:charmap_usage'] = 'Pro navigaci použijte levou nebo pravou šipku.';
$string['advanced_dlg:code_title'] = 'Editor HTML';
$string['advanced_dlg:code_wordwrap'] = 'Zalamování řádků';
$string['advanced_dlg:colorpicker_color'] = 'Vybraná barva:';
$string['advanced_dlg:colorpicker_name'] = 'Název:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Názvy';
$string['advanced_dlg:colorpicker_named_title'] = 'Pojmenované barvy';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta barev';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Kapátko';
$string['advanced_dlg:colorpicker_picker_title'] = 'Kapátko';
$string['advanced_dlg:colorpicker_title'] = 'Výběr barvy';
$string['advanced_dlg:image_align'] = 'Zarovnání';
$string['advanced_dlg:image_align_baseline'] = 'Na základnu';
$string['advanced_dlg:image_align_bottom'] = 'Dolů';
$string['advanced_dlg:image_align_left'] = 'Vlevo';
$string['advanced_dlg:image_align_middle'] = 'Na střed řádku';
$string['advanced_dlg:image_align_right'] = 'Vpravo';
$string['advanced_dlg:image_align_textbottom'] = 'Se spodkem řádku';
$string['advanced_dlg:image_align_texttop'] = 'S vrchem řádku';
$string['advanced_dlg:image_align_top'] = 'Nahoru';
$string['advanced_dlg:image_alt'] = 'Popis obrázku';
$string['advanced_dlg:image_border'] = 'Rámeček';
$string['advanced_dlg:image_dimensions'] = 'Rozměry';
$string['advanced_dlg:image_hspace'] = 'Horizontální odsazení';
$string['advanced_dlg:image_list'] = 'Seznam obrázků';
$string['advanced_dlg:image_src'] = 'URL obrázku';
$string['advanced_dlg:image_title'] = 'Vložit/upravit obrázek';
$string['advanced_dlg:image_vspace'] = 'Vertikální odsazení';
$string['advanced_dlg:invalid_color_value'] = 'Neplatná hodnota barvy';
$string['advanced_dlg:link_is_email'] = 'Zadané URL vypadá jako e-mailová adresa, chcete doplnit povinný mailto:prefix ?';
$string['advanced_dlg:link_is_external'] = 'Zadané URL vypadá jako externí odkaz, chcete doplnit povinný http://prefix ?';
$string['advanced_dlg:link_list'] = 'Seznam odkazů';
$string['advanced_dlg:link_target'] = 'Cíl';
$string['advanced_dlg:link_target_blank'] = 'Otevřít odkaz v novém okně';
$string['advanced_dlg:link_target_same'] = 'Otevřít odkaz ve stejném okně';
$string['advanced_dlg:link_title'] = 'Vložit/upravit odkaz';
$string['advanced_dlg:link_titlefield'] = 'Titulek';
$string['advanced_dlg:link_url'] = 'URL odkazu';
$string['advhr:advhr_desc'] = 'Vložit vodorovný oddělovač';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normální';
$string['advhr_dlg:noshade'] = 'Bez stínu';
$string['advhr_dlg:size'] = 'Výška';
$string['advhr_dlg:width'] = 'Šířka';
$string['advhr_dlg:widthunits'] = 'Jednotky';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '20';
$string['advimage:image_desc'] = 'Vložit/upravit obrázek';
$string['advimage_dlg:align'] = 'Zarovnání';
$string['advimage_dlg:align_baseline'] = 'Na základnu';
$string['advimage_dlg:align_bottom'] = 'Dolů';
$string['advimage_dlg:align_left'] = 'Vlevo';
$string['advimage_dlg:align_middle'] = 'Na střed řádku';
$string['advimage_dlg:align_right'] = 'Vpravo';
$string['advimage_dlg:align_textbottom'] = 'Se spodkem řádku';
$string['advimage_dlg:align_texttop'] = 'S vrchem řádku';
$string['advimage_dlg:align_top'] = 'Nahoru';
$string['advimage_dlg:alt'] = 'Popis obrázku';
$string['advimage_dlg:alt_image'] = 'Alternativní obrázek';
$string['advimage_dlg:border'] = 'Rámeček';
$string['advimage_dlg:classes'] = 'Třídy';
$string['advimage_dlg:constrain_proportions'] = 'Zachovat proporce';
$string['advimage_dlg:dialog_title'] = 'Vložit/upravit obrázek';
$string['advimage_dlg:dimensions'] = 'Rozměry';
$string['advimage_dlg:example_img'] = 'Příklad obrázku';
$string['advimage_dlg:general'] = 'Obecné parametry';
$string['advimage_dlg:height'] = 'Výška';
$string['advimage_dlg:hspace'] = 'Horizontální odsazení';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Seznam obrázků';
$string['advimage_dlg:langcode'] = 'Kód jazyka';
$string['advimage_dlg:langdir'] = 'Směr textu';
$string['advimage_dlg:list'] = 'Seznam obrázků';
$string['advimage_dlg:long_desc'] = 'Dlouhý popis';
$string['advimage_dlg:ltr'] = 'Zleva doprava';
$string['advimage_dlg:map'] = 'Obrázková mapa';
$string['advimage_dlg:misc'] = 'Různé';
$string['advimage_dlg:missing_alt'] = 'Skutečně chcete pokračovat bez vloženého popisu obrázku? Bez popisu může být obrázek nepřístupný uživatelům se zrakovým postižením, uživatelům textových prohlížečů nebo uživatelům, kteří mají vypnuto zobrazování obrázků.';
$string['advimage_dlg:mouseout'] = 'Po odjetí myši...';
$string['advimage_dlg:mouseover'] = 'Při najetí myši...';
$string['advimage_dlg:preview'] = 'Náhled';
$string['advimage_dlg:rtl'] = 'Zprava doleva';
$string['advimage_dlg:src'] = 'URL obrázku';
$string['advimage_dlg:style'] = 'Styl';
$string['advimage_dlg:swap_image'] = 'Přepnout obrázek';
$string['advimage_dlg:tab_advanced'] = 'Rozšířené';
$string['advimage_dlg:tab_appearance'] = 'Vzhled';
$string['advimage_dlg:tab_general'] = 'Obecné';
$string['advimage_dlg:title'] = 'Titulek';
$string['advimage_dlg:vspace'] = 'Vertikální odsazení';
$string['advimage_dlg:width'] = 'Šířka';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Vložit/upravit odkaz';
$string['advlink_dlg:accesskey'] = 'Klávesová zkratka';
$string['advlink_dlg:advanced_props'] = 'Rozšířené parametry';
$string['advlink_dlg:advanced_tab'] = 'Rozšířené';
$string['advlink_dlg:anchor_names'] = 'Záložka';
$string['advlink_dlg:classes'] = 'Třídy';
$string['advlink_dlg:encoding'] = 'Kódování';
$string['advlink_dlg:event_props'] = 'Události';
$string['advlink_dlg:events_tab'] = 'Události';
$string['advlink_dlg:general_props'] = 'Obecné parametry';
$string['advlink_dlg:general_tab'] = 'Obecné';
$string['advlink_dlg:height'] = 'Výška';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Zadané URL vypadá jako e-mailová adresa, chcete doplnit povinný mailto:prefix ?';
$string['advlink_dlg:is_external'] = 'Zadané URL vypadá jako externí odkaz, chcete doplnit povinný http://prefix ?';
$string['advlink_dlg:langcode'] = 'Kód jazyka';
$string['advlink_dlg:langdir'] = 'Směr textu';
$string['advlink_dlg:link_list'] = 'Seznam odkazů';
$string['advlink_dlg:list'] = 'Seznam odkazů';
$string['advlink_dlg:ltr'] = 'Zleva doprava';
$string['advlink_dlg:mime'] = 'MIME typ';
$string['advlink_dlg:popup'] = 'Javascriptové okno';
$string['advlink_dlg:popup_dependent'] = 'Závislost (pouze Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Zobrazit pole s adresou';
$string['advlink_dlg:popup_menubar'] = 'Zobrazit nabídku';
$string['advlink_dlg:popup_name'] = 'Název okna';
$string['advlink_dlg:popup_opts'] = 'Možnosti';
$string['advlink_dlg:popup_position'] = 'Umístění (X/Y)';
$string['advlink_dlg:popup_props'] = 'Vlastnosti vyskakovacího okna';
$string['advlink_dlg:popup_resizable'] = 'Umožnit změnu velikosti';
$string['advlink_dlg:popup_return'] = 'Vložit \'return false';
$string['advlink_dlg:popup_scrollbars'] = 'Zobrazit posuvníky';
$string['advlink_dlg:popup_size'] = 'Velikost';
$string['advlink_dlg:popup_statusbar'] = 'Zobrazit stavový řádek';
$string['advlink_dlg:popup_tab'] = 'Vyskakovací okno';
$string['advlink_dlg:popup_toolbar'] = 'Zobrazit nástrojovou lištu';
$string['advlink_dlg:popup_url'] = 'URL vyskakovacího okna';
$string['advlink_dlg:rel'] = 'Vztah stránky k cíli';
$string['advlink_dlg:rev'] = 'Vztah cíle ke stránce';
$string['advlink_dlg:rtl'] = 'Zprava doleva';
$string['advlink_dlg:style'] = 'Styl';
$string['advlink_dlg:tabindex'] = 'Pořadí pro tabulátor';
$string['advlink_dlg:target'] = 'Cíl';
$string['advlink_dlg:target_blank'] = 'Otevřít v novém okně/rámu';
$string['advlink_dlg:target_langcode'] = 'Jazyk cíle';
$string['advlink_dlg:target_name'] = 'Název cíle';
$string['advlink_dlg:target_parent'] = 'Otevřít v nadřazeném okně/rámu';
$string['advlink_dlg:target_same'] = 'Otevřít v tomto okně/rámu';
$string['advlink_dlg:target_top'] = 'Otevřít v hlavním okně/rámu (nahradit všechny rámy)';
$string['advlink_dlg:title'] = 'Vložit/upravit odkaz';
$string['advlink_dlg:titlefield'] = 'Titulek';
$string['advlink_dlg:url'] = 'URL odkazu';
$string['advlink_dlg:width'] = 'Šířka';
$string['advlist:circle'] = 'Kolečko';
$string['advlist:def'] = 'Výchozí';
$string['advlist:disc'] = 'Puntík';
$string['advlist:lower_alpha'] = 'Malá písmena';
$string['advlist:lower_greek'] = 'Malá řecká písmena';
$string['advlist:lower_roman'] = 'Malé římské číslice';
$string['advlist:square'] = 'Čtvereček';
$string['advlist:types'] = 'Typ';
$string['advlist:upper_alpha'] = 'Velká písmena';
$string['advlist:upper_roman'] = 'Velké římské číslice';
$string['aria:rich_text_area'] = 'Rich text pole';
$string['autosave:restore_content'] = 'Obnovit automaticky uložený obsah';
$string['autosave:unload_msg'] = 'Provedené změny mohou být ztraceny, jestliže opustíte tuto stránku.';
$string['autosave:warning_message'] = 'Pokud obnovíte uložený obsah, ztratíte tím veškerý obsah, který je právě v okně editoru.

Opravdu chcete obnovit uložený obsah?';
$string['availablebuttons'] = 'Dostupná tlačítka';
$string['colors:000000'] = 'Černá';
$string['colors:000080'] = 'Tmavomodrá';
$string['colors:0000FF'] = 'Modrá';
$string['colors:003300'] = 'Tmavozelená';
$string['colors:003366'] = 'Tmavě azurová';
$string['colors:008000'] = 'Zelená';
$string['colors:008080'] = 'Tmavě modrozelená';
$string['colors:00CCFF'] = 'Blankytně modrá';
$string['colors:00FF00'] = 'Limetkově zelená';
$string['colors:00FFFF'] = 'Modrozelená';
$string['colors:333300'] = '';
$string['colors:333333'] = 'Tmavě šedá';
$string['colors:333399'] = 'Indigová modř';
$string['colors:3366FF'] = 'Královská modrá';
$string['colors:339966'] = 'Azurově zelená';
$string['colors:33CCCC'] = 'Tyrkysová';
$string['colors:666699'] = 'Šedomodrá';
$string['colors:800000'] = 'Tmavě červená';
$string['colors:800080'] = 'Nachová';
$string['colors:808000'] = 'Olivová';
$string['colors:808080'] = 'Šedá';
$string['colors:993300'] = 'Pomerančově oranžová';
$string['colors:993366'] = 'Hnědá';
$string['colors:999999'] = 'Středně šedá';
$string['colors:99CC00'] = 'Žlutozelená';
$string['colors:99CCFF'] = 'Světle modrá';
$string['colors:C0C0C0'] = 'Stříbrná';
$string['colors:CC99FF'] = 'Švestková';
$string['colors:CCFFCC'] = 'Světle zelená';
$string['colors:CCFFFF'] = 'Světle azurová';
$string['colors:FF0000'] = 'Červená';
$string['colors:FF00FF'] = 'Červenorudá';
$string['colors:FF6600'] = 'Oranžová';
$string['colors:FF9900'] = 'Žlutá';
$string['colors:FF99CC'] = 'Růžová';
$string['colors:FFCC00'] = 'Zlatá';
$string['colors:FFCC99'] = 'Broskvová';
$string['colors:FFFF00'] = 'Žlutá';
$string['colors:FFFF99'] = 'Světle žlutá';
$string['colors:FFFFFF'] = 'Bílá';
$string['common:apply'] = 'Použít';
$string['common:browse'] = 'Procházet';
$string['common:cancel'] = 'Storno';
$string['common:class_name'] = 'Třída';
$string['common:clipboard_msg'] = 'Funkce kopírovat/vyjmout/vložit nejsou podporované v prohlížečích Mozilla a Firefox.
Chcete více informací o tomto problému?';
$string['common:clipboard_no_support'] = 'Tato funkce není vaším prohlížečem podporována. Použijte místo toho klávesové zkratky.';
$string['common:close'] = 'Zavřít';
$string['common:edit_confirm'] = 'Chcete použít WYSIWYG mód pro tento text?';
$string['common:insert'] = 'Vložit';
$string['common:invalid_data'] = 'Chyba: Byly zadány neplatné hodnoty a tyto byly označeny červeně.';
$string['common:invalid_data_min'] = '';
$string['common:invalid_data_number'] = '{#field} musí být číslo';
$string['common:invalid_data_size'] = '{#field} musí být číslo nebo procento';
$string['common:more_colors'] = 'Další barvy';
$string['common:not_set'] = '- Nenastaveno -';
$string['common:popup_blocked'] = 'Omlouváme se, ale blokování vyskakovacích oken neumožnilo otevřít okno, které poskytuje funkčnost aplikace. Pro plné využití možností aplikace musíte vypnout blokování vyskakovacích oken pro tento web.';
$string['common:update'] = 'Aktualizovat';
$string['common:value'] = '(hodnota)';
$string['contextmenu:align'] = 'Zarovnání';
$string['contextmenu:center'] = 'Na střed';
$string['contextmenu:full'] = 'Do bloku';
$string['contextmenu:left'] = 'Doleva';
$string['contextmenu:right'] = 'Doprava';
$string['customconfig'] = 'Vlastní konfigurace';
$string['customconfig_desc'] = 'Vlastní pokročilá konfigurace TinyMCE ve formátu JSON, například: {"možnost1" : "hodnota1", "možnost2" : "hodnota2"}. Jakékoliv možnosti zde specifikované převáží nad standardními nastaveními a nastaveními doplňků.';
$string['customtoolbar'] = 'Panel nástrojů editoru';
$string['customtoolbar_desc'] = 'Každý řádek obsahuje seznam názvů tlačítek oddělený čárkami, použijte "wrap" jako oddělovač skupiny, prázdné řádky jsou ignorovány. Viz <a href="{$a}" target="_blank"> {$a} </a> seznam standardních tlačítek TinyMCE. <br /> První řádek se zobrazí vždy a  viditelnost druhého a třetího panelu nástrojů lze zapínat a vypínat.';
$string['directionality:ltr_desc'] = 'Směr zleva doprava';
$string['directionality:rtl_desc'] = 'Směr zprava doleva';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emotikony';
$string['emotions_dlg:cool'] = 'Úžasný';
$string['emotions_dlg:cry'] = 'Plačící';
$string['emotions_dlg:desc'] = 'Emotikony';
$string['emotions_dlg:embarassed'] = 'Rozpačitý';
$string['emotions_dlg:foot_in_mouth'] = 'Šlápnul vedle';
$string['emotions_dlg:frown'] = 'Zamračený';
$string['emotions_dlg:innocent'] = 'Nevinný';
$string['emotions_dlg:kiss'] = 'Líbající';
$string['emotions_dlg:laughing'] = 'Smějící se';
$string['emotions_dlg:money_mouth'] = 'Je na prachy';
$string['emotions_dlg:sealed'] = 'Mlčící';
$string['emotions_dlg:smile'] = 'Usmívající se';
$string['emotions_dlg:surprised'] = 'Překvapený';
$string['emotions_dlg:title'] = 'Vložit emotikonu';
$string['emotions_dlg:tongue_out'] = 'S vyplazeným jazykem';
$string['emotions_dlg:undecided'] = 'Nerozhodný';
$string['emotions_dlg:usage'] = 'Pro navigaci použijte levou nebo pravou šipku.';
$string['emotions_dlg:wink'] = 'Mrkající';
$string['emotions_dlg:yell'] = 'Křičící';
$string['fontselectlist'] = 'Seznam dostupných fontů';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '110';
$string['fullpage:desc'] = 'Vlastnosti dokumentu';
$string['fullpage_dlg:active_color'] = 'Barva aktivního odkazu';
$string['fullpage_dlg:add'] = 'Přidat nový element';
$string['fullpage_dlg:add_base'] = 'Vložit základní umístění';
$string['fullpage_dlg:add_comment'] = 'Vložit komentář';
$string['fullpage_dlg:add_link'] = 'Vložit nezobrazovaný odkaz';
$string['fullpage_dlg:add_meta'] = 'Vložit meta informace';
$string['fullpage_dlg:add_script'] = 'Vložit skript';
$string['fullpage_dlg:add_style'] = 'Vložit styl';
$string['fullpage_dlg:add_title'] = 'Vložit titulek';
$string['fullpage_dlg:advanced_props'] = 'Rozšířené parametry';
$string['fullpage_dlg:advanced_tab'] = 'Rozšířené';
$string['fullpage_dlg:appearance_bgprops'] = 'Vlastnosti pozadí';
$string['fullpage_dlg:appearance_linkprops'] = 'Vlastnosti odkazů';
$string['fullpage_dlg:appearance_marginprops'] = 'Okraje těla dokumentu';
$string['fullpage_dlg:appearance_style'] = 'Vlastnosti stylů';
$string['fullpage_dlg:appearance_tab'] = 'Vzhled';
$string['fullpage_dlg:appearance_textprops'] = 'Vlastnosti textu';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Základní umístění';
$string['fullpage_dlg:bgcolor'] = 'Barva pozadí';
$string['fullpage_dlg:bgimage'] = 'Obrázek pozadí';
$string['fullpage_dlg:bottom_margin'] = 'Spodní okraj';
$string['fullpage_dlg:charset'] = 'Znaková sada';
$string['fullpage_dlg:comment_element'] = 'Komentář';
$string['fullpage_dlg:content'] = 'Obsah';
$string['fullpage_dlg:copyright'] = 'Autorská práva';
$string['fullpage_dlg:defer'] = 'Odložit (defer)';
$string['fullpage_dlg:doctypes'] = 'Typ dokumentu';
$string['fullpage_dlg:encoding'] = 'Kódování';
$string['fullpage_dlg:font_face'] = 'Typ písma';
$string['fullpage_dlg:font_size'] = 'Velikost písma';
$string['fullpage_dlg:fontface'] = 'Typ písma';
$string['fullpage_dlg:fontsize'] = 'Velikost písma';
$string['fullpage_dlg:general_props'] = 'Obecné parametry';
$string['fullpage_dlg:head_elements'] = 'Hlavičky';
$string['fullpage_dlg:hover_color'] = 'Barva zvoleného odkazu';
$string['fullpage_dlg:href'] = 'Soubor/URL';
$string['fullpage_dlg:hreflang'] = 'Jazyk odkazu';
$string['fullpage_dlg:info'] = 'Informace';
$string['fullpage_dlg:langcode'] = 'Kód jazyka';
$string['fullpage_dlg:langdir'] = 'Směr textu';
$string['fullpage_dlg:langprops'] = 'Jazyk a kódování';
$string['fullpage_dlg:language'] = 'Jazyk';
$string['fullpage_dlg:left_margin'] = 'Levý okraj';
$string['fullpage_dlg:link_color'] = 'Barva odkazu';
$string['fullpage_dlg:link_element'] = 'Nezobrazovaný odkaz';
$string['fullpage_dlg:ltr'] = 'Zleva doprava';
$string['fullpage_dlg:media'] = 'Média';
$string['fullpage_dlg:meta_description'] = 'Popis';
$string['fullpage_dlg:meta_element'] = 'Meta informace';
$string['fullpage_dlg:meta_index_follow'] = 'Indexovat a sledovat odkazy';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexovat a nesledovat odkazy';
$string['fullpage_dlg:meta_keywords'] = 'Klíčová slova';
$string['fullpage_dlg:meta_noindex_follow'] = 'Neindexovat, ale sledovat odkazy';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Neindexovat a nesledovat odkazy';
$string['fullpage_dlg:meta_props'] = 'Meta informace';
$string['fullpage_dlg:meta_robots'] = 'Roboti';
$string['fullpage_dlg:meta_tab'] = 'Obecné';
$string['fullpage_dlg:meta_title'] = 'Titulek';
$string['fullpage_dlg:movedown'] = 'Přesuň označený element níž';
$string['fullpage_dlg:moveup'] = 'Přesuň označený element výš';
$string['fullpage_dlg:name'] = 'Název';
$string['fullpage_dlg:properties'] = 'Vlastnosti';
$string['fullpage_dlg:rel'] = 'Vztah stránky k cíli';
$string['fullpage_dlg:remove'] = 'Odebrat označený element';
$string['fullpage_dlg:rev'] = 'Vztah cíle ke stránce';
$string['fullpage_dlg:right_margin'] = 'Pravý okraj';
$string['fullpage_dlg:rtl'] = 'Zprava doleva';
$string['fullpage_dlg:script_element'] = 'Skript';
$string['fullpage_dlg:src'] = 'Zdroj';
$string['fullpage_dlg:style'] = 'Styl';
$string['fullpage_dlg:style_element'] = 'Styl';
$string['fullpage_dlg:stylesheet'] = 'Stylopis';
$string['fullpage_dlg:target'] = 'Cíl';
$string['fullpage_dlg:text_color'] = 'Barva textu';
$string['fullpage_dlg:textcolor'] = 'Barva';
$string['fullpage_dlg:title'] = 'Vlastnosti dokumentu';
$string['fullpage_dlg:title_element'] = 'Titulek';
$string['fullpage_dlg:top_margin'] = 'Horní okraj';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Hodnota';
$string['fullpage_dlg:visited_color'] = 'Barva navštíveného odkazu';
$string['fullpage_dlg:xml_pi'] = 'XML deklarace';
$string['fullscreen:desc'] = 'Přepnout na celostránkové zobrazení';
$string['iespell:download'] = 'Slovník ieSpell nebyl detekován. Chcete ho nainstalovat?';
$string['iespell:iespell_desc'] = 'Spustit kontrolu pravopisu';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y';
$string['insertdatetime:day_long'] = 'Neděle,Pondělí,Úterý,Středa,Čtvrtek,Pátek,Sobota,Neděle';
$string['insertdatetime:day_short'] = 'Ne,Po,Út,St,Čt,Pá,So,Ne';
$string['insertdatetime:insertdate_desc'] = 'Vložit datum';
$string['insertdatetime:inserttime_desc'] = 'Vložit čas';
$string['insertdatetime:months_long'] = 'Leden,Únor,Březen,Duben,Květen,Červen,Červenec,Srpen,Září,Říjen,Listopad,Prosinec';
$string['insertdatetime:months_short'] = 'Led,Úno,Bře,Dub,Kvě,Čer,Čvc,Srp,Zář,Říj,Lis,Pro';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Přepnout na absolutní pozicování';
$string['layer:backward_desc'] = 'Přesunout dozadu';
$string['layer:content'] = 'Nová vrstva...';
$string['layer:forward_desc'] = 'Přesunout dopředu';
$string['layer:insertlayer_desc'] = 'Vložit novou vrstvu';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '130';
$string['media:desc'] = 'Vložit/upravit média';
$string['media:edit'] = 'Upravit média';
$string['media_dlg:advanced'] = 'Rozšířené';
$string['media_dlg:align'] = 'Zarovnání';
$string['media_dlg:align_bottom'] = 'Dolů';
$string['media_dlg:align_bottom_left'] = 'Dolů vlevo';
$string['media_dlg:align_bottom_right'] = 'Dolů vpravo';
$string['media_dlg:align_center'] = 'Na střed';
$string['media_dlg:align_left'] = 'Vlevo';
$string['media_dlg:align_right'] = 'Vpravo';
$string['media_dlg:align_top'] = 'Nahoru';
$string['media_dlg:align_top_left'] = 'Nahoru vlevo';
$string['media_dlg:align_top_right'] = 'Nahoru vpravo';
$string['media_dlg:altsource1'] = 'Alternativní zdroj 1';
$string['media_dlg:altsource2'] = 'Alternativní zdroj 2';
$string['media_dlg:audio'] = 'HTML5 audio';
$string['media_dlg:autogotourl'] = 'Automatický přechod na URL';
$string['media_dlg:autohref'] = 'Automatické načtení';
$string['media_dlg:autostart'] = 'Automatické spuštění';
$string['media_dlg:balance'] = 'Vyvážení';
$string['media_dlg:base'] = 'Základní složka';
$string['media_dlg:baseurl'] = 'Základní URL';
$string['media_dlg:bgcolor'] = 'Pozadí';
$string['media_dlg:cache'] = 'Mezipaměť (vyrovnávací paměť)';
$string['media_dlg:captioningid'] = 'ID popisku média';
$string['media_dlg:center'] = 'Na střed';
$string['media_dlg:class_name'] = 'Třída';
$string['media_dlg:console'] = 'Konzola';
$string['media_dlg:constrain_proportions'] = 'Zachovat proporce';
$string['media_dlg:controller'] = 'Ovládací panel';
$string['media_dlg:controls'] = 'Ovládací panel';
$string['media_dlg:correction'] = 'Bez korekcí';
$string['media_dlg:currentmarker'] = 'Aktuální záložka';
$string['media_dlg:currentposition'] = 'Aktuální pozice';
$string['media_dlg:defaultframe'] = 'Výchozí snímek';
$string['media_dlg:embedded_audio_options'] = 'Možnosti vloženého audia';
$string['media_dlg:embeddedaudio'] = 'Vložené audio';
$string['media_dlg:enabled'] = 'Povolit ovládací panel';
$string['media_dlg:enablejavascript'] = 'Povolit Javascript';
$string['media_dlg:endtime'] = 'Čas ukončení';
$string['media_dlg:file'] = 'Soubor/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Možnosti Flashe';
$string['media_dlg:flashvars'] = 'Parametry (Flashvars)';
$string['media_dlg:fullscreen'] = 'Celá obrazovka';
$string['media_dlg:general'] = 'Obecné';
$string['media_dlg:hidden'] = 'Skrýt';
$string['media_dlg:href'] = 'Odkaz';
$string['media_dlg:hspace'] = 'Horizontální odsazení';
$string['media_dlg:html5_audio_options'] = 'Možnosti audia';
$string['media_dlg:html5_video_options'] = 'Možnosti videa HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Stav obrazu';
$string['media_dlg:invokeurls'] = 'Požadovat URL';
$string['media_dlg:kioskmode'] = 'Zakázat ukládání';
$string['media_dlg:list'] = 'Seznam';
$string['media_dlg:liveconnect'] = 'Spustit Javu (SWLiveConnect)';
$string['media_dlg:loop'] = 'Opakování';
$string['media_dlg:maintainaspect'] = 'Zachovat poměr stran';
$string['media_dlg:menu'] = 'Zobrazit nabídku';
$string['media_dlg:mute'] = 'Ztlumit';
$string['media_dlg:name'] = 'Název';
$string['media_dlg:nojava'] = 'Nespoutět Javu';
$string['media_dlg:numloop'] = 'Počet opakování';
$string['media_dlg:play'] = 'Automatické přehrávání';
$string['media_dlg:playcount'] = 'Počet přehrání';
$string['media_dlg:playeveryframe'] = 'Přehrát každý snímek';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Přednačtení';
$string['media_dlg:preload'] = 'Načíst dopředu';
$string['media_dlg:preload_auto'] = 'Ať rozhodne prohlížeč uživatele';
$string['media_dlg:preload_metadata'] = 'Metadata videa načíst dopředu';
$string['media_dlg:preload_none'] = 'Nenačítat dopředu';
$string['media_dlg:preview'] = 'Náhled';
$string['media_dlg:progress'] = 'Průběh';
$string['media_dlg:qt_options'] = 'Možnosti Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Streamované rtsp zdroje mohou být přidány do pole \'Soubor/URL streamu pro QT\' na záložce \'Rozšířené\'.
Můžete také přidat nestreamovanou verzi do pole zdroje.';
$string['media_dlg:qtsrc'] = 'QT zdroj';
$string['media_dlg:qtsrcchokespeed'] = 'Snížení rychlosti';
$string['media_dlg:quality'] = 'Kvalita';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Relativní rychlost';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Možnosti přehrávače Real media';
$string['media_dlg:salign'] = 'Zarovnání okna';
$string['media_dlg:scale'] = 'Poměr';
$string['media_dlg:scriptcallbacks'] = 'Skripty zpětných volání';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Možnosti Shockwave';
$string['media_dlg:shuffle'] = 'Náhodně';
$string['media_dlg:size'] = 'Rozměry';
$string['media_dlg:sound'] = 'Zvuk';
$string['media_dlg:source'] = 'Zdroj';
$string['media_dlg:starttime'] = 'Počáteční čas';
$string['media_dlg:stretchtofit'] = 'Roztáhnout do okna';
$string['media_dlg:swstretchhalign'] = 'Zarovnání horiz. roztažení';
$string['media_dlg:swstretchstyle'] = 'Styl roztažení';
$string['media_dlg:swstretchvalign'] = 'Zarovnání vert. roztažení';
$string['media_dlg:target'] = 'Cíl';
$string['media_dlg:targetcache'] = 'Cílová mezipaměť';
$string['media_dlg:title'] = 'Vložit/upravit vkládaná média';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'Režim ovládacího panelu';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Hlasitost';
$string['media_dlg:vspace'] = 'Vertikální odsazení';
$string['media_dlg:windowlessvideo'] = 'Video bez okna';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'Režim okna';
$string['media_dlg:wmp_options'] = 'Možnosti přehrávače Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Vložit nedělitelnou mezeru';
$string['pagebreak:desc'] = 'Vložit konec stránky';
$string['paste:paste_text_desc'] = 'Vložit jako prostý text';
$string['paste:paste_word_desc'] = 'Vložit z Wordu';
$string['paste:plaintext_mode'] = 'Funkce vložit je nyní v režimu prostý text. Opětovné kliknutí přepne tuto funkci zpět do normálního režimu. Po vložení se vrátíte zpět do normálního režimu.';
$string['paste:plaintext_mode_stick'] = 'Funkce vložit je nyní v režimu prostý text. Opětovné kliknutí přepne tuto funkci zpět do normálního režimu.';
$string['paste:selectall_desc'] = 'Vybrat vše';
$string['paste_dlg:text_linebreaks'] = 'Zachovat zalamování řádků';
$string['paste_dlg:text_title'] = 'Použijte CTRL+V pro vložení textu do okna.';
$string['paste_dlg:word_title'] = 'Použijte CTRL+V pro vložení textu do okna.';
$string['pluginname'] = 'TinyMCE HTML editor';
$string['preview:preview_desc'] = 'Náhled';
$string['print:print_desc'] = 'Tisk';
$string['privacy:metadata'] = 'Modul TinyMCE HTML editor neukládá žádné osobní údaje.';
$string['save:cancel_desc'] = 'Zrušit všechny změny';
$string['save:save_desc'] = 'Uložit';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Najít/nahradit';
$string['searchreplace:search_desc'] = 'Najít';
$string['searchreplace_dlg:allreplaced'] = 'Všechny výskyty byly nahrazeny.';
$string['searchreplace_dlg:direction'] = 'Směr';
$string['searchreplace_dlg:down'] = 'Dolů';
$string['searchreplace_dlg:findnext'] = 'Najít další';
$string['searchreplace_dlg:findwhat'] = 'Co hledat';
$string['searchreplace_dlg:mcase'] = 'Rozlišovat velikost';
$string['searchreplace_dlg:notfound'] = 'Hledání bylo dokončeno. Hledaný text nebyl nalezen.';
$string['searchreplace_dlg:replace'] = 'Nahradit';
$string['searchreplace_dlg:replace_title'] = 'Najít/nahradit';
$string['searchreplace_dlg:replaceall'] = 'Nahradit vše';
$string['searchreplace_dlg:replacewith'] = 'Čím nahradit';
$string['searchreplace_dlg:search_title'] = 'Najít';
$string['searchreplace_dlg:searchnext_desc'] = 'Najít další';
$string['searchreplace_dlg:up'] = 'Nahoru';
$string['settings'] = 'Obecná nastavení';
$string['simple:bold_desc'] = 'Tučné (Ctrl+B)';
$string['simple:bullist_desc'] = 'Vložit / odstranit seznam s odrážkami';
$string['simple:cleanup_desc'] = 'Vyčistit kód';
$string['simple:italic_desc'] = 'Kurzíva (Ctrl+I)';
$string['simple:numlist_desc'] = 'Vložit / odstranit číslovaný seznam';
$string['simple:redo_desc'] = 'Znovu (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Přeškrtnuté';
$string['simple:underline_desc'] = 'Podtržené (Ctrl+U)';
$string['simple:undo_desc'] = 'Zpět (Ctrl+Z)';
$string['spellchecker:desc'] = 'Přepnout kontrolu pravopisu';
$string['spellchecker:ignore_word'] = 'Ignorovat slovo';
$string['spellchecker:ignore_words'] = 'Ignorovat vše';
$string['spellchecker:langs'] = 'Jazyky';
$string['spellchecker:learn_word'] = 'Přidat do slovníku';
$string['spellchecker:menu'] = 'Nastavení kontroly pravopisu';
$string['spellchecker:no_mpell'] = 'Nebyly nalezeny žádné chyby.';
$string['spellchecker:no_sug'] = 'Žádná nápověda';
$string['spellchecker:sug'] = 'Nápověda';
$string['spellchecker:wait'] = 'Čekejte prosím...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '25';
$string['style:desc'] = 'Upravit CSS styl';
$string['style_dlg:apply'] = 'Použít';
$string['style_dlg:background'] = 'Pozadí';
$string['style_dlg:background_attachment'] = 'Rolování';
$string['style_dlg:background_color'] = 'Barva pozadí';
$string['style_dlg:background_hpos'] = 'Horizontální umístění';
$string['style_dlg:background_image'] = 'Obrázek pozadí';
$string['style_dlg:background_repeat'] = 'Opakování';
$string['style_dlg:background_tab'] = 'Pozadí';
$string['style_dlg:background_vpos'] = 'Vertikální umístění';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Blokové zobrazení';
$string['style_dlg:block_letterspacing'] = 'Rozestup znaků';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Zarovnání textu';
$string['style_dlg:block_text_indent'] = 'Odsazení textu';
$string['style_dlg:block_vertical_alignment'] = 'Vertikální zarovnání';
$string['style_dlg:block_whitespace'] = 'Zalamování textu';
$string['style_dlg:block_wordspacing'] = 'Rozestup slov';
$string['style_dlg:border'] = 'Hranice';
$string['style_dlg:border_tab'] = 'Ohraničení';
$string['style_dlg:bottom'] = 'Dole';
$string['style_dlg:box'] = 'Políčko';
$string['style_dlg:box_clear'] = 'Vyčistit';
$string['style_dlg:box_float'] = 'Plovoucí';
$string['style_dlg:box_height'] = 'Výška';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Šířka';
$string['style_dlg:bullet_image'] = 'Styl odrážek';
$string['style_dlg:clip'] = 'Ořezání (clip)';
$string['style_dlg:color'] = 'Barva';
$string['style_dlg:height'] = 'Výška';
$string['style_dlg:left'] = 'Vlevo';
$string['style_dlg:list'] = 'Seznam';
$string['style_dlg:list_tab'] = 'Seznam';
$string['style_dlg:list_type'] = 'Typ';
$string['style_dlg:margin'] = 'Okraje (margin)';
$string['style_dlg:overflow'] = 'Přetečení (overflow)';
$string['style_dlg:padding'] = 'Odsazení (padding)';
$string['style_dlg:placement'] = 'Umístěni';
$string['style_dlg:position'] = 'Umístění';
$string['style_dlg:positioning_tab'] = 'Umístění';
$string['style_dlg:positioning_type'] = 'Typ';
$string['style_dlg:right'] = 'Vpravo';
$string['style_dlg:same'] = 'Stejné pro všechny';
$string['style_dlg:style'] = 'Styl';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'Blikání';
$string['style_dlg:text_case'] = 'Velká písmena';
$string['style_dlg:text_color'] = 'Barva';
$string['style_dlg:text_decoration'] = 'Dekorace';
$string['style_dlg:text_font'] = 'Písmo';
$string['style_dlg:text_lineheight'] = 'Výška řádku';
$string['style_dlg:text_none'] = 'žádná';
$string['style_dlg:text_overline'] = 'Nadtržení';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Velikost';
$string['style_dlg:text_striketrough'] = 'Přeškrtnutí';
$string['style_dlg:text_style'] = 'Styl textu';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Podtržení';
$string['style_dlg:text_variant'] = 'Varianta';
$string['style_dlg:text_weight'] = 'Tučnost písma';
$string['style_dlg:title'] = 'Upravit CSS styl';
$string['style_dlg:toggle_insert_span'] = 'Pro výběr vložte rozsah';
$string['style_dlg:top'] = 'Nahoře';
$string['style_dlg:visibility'] = 'Viditelnost';
$string['style_dlg:width'] = 'Šířka';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Doplněk';
$string['subplugintype_tinymce_plural'] = 'Doplňky';
$string['table:cell'] = 'Buňka';
$string['table:cell_desc'] = 'Vlastnosti buňky';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '100';
$string['table:col'] = 'Sloupec';
$string['table:col_after_desc'] = 'Vložit sloupec za';
$string['table:col_before_desc'] = 'Vložit sloupec před';
$string['table:copy_row_desc'] = 'Kopírovat řádek tabulky';
$string['table:cut_row_desc'] = 'Vyjmout řádek tabulky';
$string['table:del'] = 'Odstranit tabulku';
$string['table:delete_col_desc'] = 'Odstranit sloupec tabulky';
$string['table:delete_row_desc'] = 'Odstranit řádek tabulky';
$string['table:desc'] = 'Vložit novou tabulku';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Sloučit buňky';
$string['table:paste_row_after_desc'] = 'Vložit řádek za';
$string['table:paste_row_before_desc'] = 'Vložit řádek před';
$string['table:props_desc'] = 'Vlastnosti tabulky';
$string['table:row'] = 'Řádek';
$string['table:row_after_desc'] = 'Vložit řádek za';
$string['table:row_before_desc'] = 'Vložit řádek před';
$string['table:row_desc'] = 'Vlastnosti řádku tabulky';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Rozdělit buňky';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '50';
$string['table_dlg:advanced_props'] = 'Rozšířené parametry';
$string['table_dlg:advanced_tab'] = 'Rozšířené';
$string['table_dlg:align'] = 'Zarovnání';
$string['table_dlg:align_bottom'] = 'Dolů';
$string['table_dlg:align_default'] = 'Výchozí';
$string['table_dlg:align_left'] = 'Vlevo';
$string['table_dlg:align_middle'] = 'Na střed';
$string['table_dlg:align_right'] = 'Vpravo';
$string['table_dlg:align_top'] = 'Nahoru';
$string['table_dlg:bgcolor'] = 'Barva pozadí';
$string['table_dlg:bgimage'] = 'Obrázek pozadí';
$string['table_dlg:border'] = 'Rámeček';
$string['table_dlg:bordercolor'] = 'Barva rámečku';
$string['table_dlg:caption'] = 'Nadpis tabulky';
$string['table_dlg:cell_all'] = 'Aktualizovat všechny buňky v tabulce';
$string['table_dlg:cell_cell'] = 'Aktualizovat zvolenou buňku';
$string['table_dlg:cell_col'] = 'Aktualizovat všechny buňky ve sloupci';
$string['table_dlg:cell_limit'] = 'Překročili jste maximální počet buněk {$cells}.';
$string['table_dlg:cell_row'] = 'Aktualizovat všechny buňky v řádku';
$string['table_dlg:cell_title'] = 'Vlastnosti buňky';
$string['table_dlg:cell_type'] = 'Typ buňky';
$string['table_dlg:cellpadding'] = 'Odsazení obsahu';
$string['table_dlg:cellspacing'] = 'Rozestup buněk';
$string['table_dlg:col_limit'] = 'Překročili jste maximální počet sloupců {$cols}.';
$string['table_dlg:colgroup'] = 'Skupina sloupců';
$string['table_dlg:cols'] = 'Sloupce';
$string['table_dlg:frame'] = 'Rámeček tabulky';
$string['table_dlg:frame_all'] = 'vše';
$string['table_dlg:frame_cols'] = 'sloupce';
$string['table_dlg:frame_groups'] = 'oblasti a skupiny sloupců';
$string['table_dlg:frame_none'] = 'žádná';
$string['table_dlg:frame_rows'] = 'řádky';
$string['table_dlg:general_props'] = 'Obecné parametry';
$string['table_dlg:general_tab'] = 'Obecné';
$string['table_dlg:height'] = 'Výška';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Kód jazyka';
$string['table_dlg:langdir'] = 'Směr textu';
$string['table_dlg:ltr'] = 'Zleva doprava';
$string['table_dlg:merge_cells_title'] = 'Spojit buňky';
$string['table_dlg:mime'] = 'MIME typ cíle';
$string['table_dlg:missing_scope'] = 'Skutečně chcete pokračovat bez určení oblasti hlavičky této tabulky? Bez ní může u některých uživatelů docházet k určitým problémům při interpretaci a zobrazování dat v tabulce.';
$string['table_dlg:row_all'] = 'Aktualizovat všechny řádky tabulky';
$string['table_dlg:row_even'] = 'Aktualizovat sudé řádky tabulky';
$string['table_dlg:row_limit'] = 'Překročili jste maximální počet řádků {$rows}.';
$string['table_dlg:row_odd'] = 'Aktualizovat liché řádky tabulky';
$string['table_dlg:row_row'] = 'Aktualizovat zvolený řádek';
$string['table_dlg:row_title'] = 'Vlastnosti řádku';
$string['table_dlg:rowgroup'] = 'Skupina řádků';
$string['table_dlg:rows'] = 'Řádky';
$string['table_dlg:rowtype'] = 'Typ řádku';
$string['table_dlg:rtl'] = 'Zprava doleva';
$string['table_dlg:rules'] = 'Vykreslení mřížky';
$string['table_dlg:rules_above'] = 'nahoře';
$string['table_dlg:rules_below'] = 'dole';
$string['table_dlg:rules_border'] = 'rámeček okolo';
$string['table_dlg:rules_box'] = 'box okolo';
$string['table_dlg:rules_hsides'] = 'nahoře a dole';
$string['table_dlg:rules_lhs'] = 'vlevo';
$string['table_dlg:rules_rhs'] = 'vpravo';
$string['table_dlg:rules_void'] = 'žádný';
$string['table_dlg:rules_vsides'] = 'vlevo a vpravo';
$string['table_dlg:scope'] = 'Hlavička pro';
$string['table_dlg:style'] = 'Styl';
$string['table_dlg:summary'] = 'Shrnutí obsahu';
$string['table_dlg:tbody'] = 'Tělo tabulky';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Pata tabulky';
$string['table_dlg:th'] = 'Záhlaví';
$string['table_dlg:thead'] = 'Hlavička tabulky';
$string['table_dlg:title'] = 'Vložit/upravit tabulku';
$string['table_dlg:valign'] = 'Vertikální zarovnání';
$string['table_dlg:width'] = 'Šířka';
$string['template:desc'] = 'Vložit předdefinovaný obsah ze šablony';
$string['template_dlg:cdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Neděle,Pondělí,Úterý,Středa,Čtvrtek,Pátek,Sobota,Neděle';
$string['template_dlg:day_short'] = 'Ne,Po,Út,St,Čt,Pá,So,Ne';
$string['template_dlg:desc'] = 'Vložit předdefinovaný obsah ze šablony';
$string['template_dlg:desc_label'] = 'Popis';
$string['template_dlg:label'] = 'Šablona';
$string['template_dlg:mdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Leden,Únor,Březen,Duben,Květen,Červen,Červenec,Srpen,Září,Říjen,Listopad,Prosinec';
$string['template_dlg:months_short'] = 'Led,Úno,Bře,Dub,Kvě,Čer,Čvc,Srp,Zář,Říj,Lis,Pro';
$string['template_dlg:preview'] = 'Náhled';
$string['template_dlg:select'] = 'Vybrat šablonu';
$string['template_dlg:title'] = 'Šablony';
$string['template_dlg:warning'] = 'Upozornění: Aktualizace šablony jinou způsobí ztrátu dat.';
$string['visualblocks:desc'] = 'Zobrazit/skrýt prvky bloku';
$string['visualchars:desc'] = 'Zobrazení skrytých znaků zapnout/vypnout';
$string['wordcount:words'] = 'Slov:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Zkratka';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Vložit/upravit atributy';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citace';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Odstraněný text';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Přidaný text';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributy';
$string['xhtmlxtras_dlg:attribs_title'] = 'Vložit/upravit atributy';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributy';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Události';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Klávesová zkratka';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citace';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Třída';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/Čas';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jazyk';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Směr textu';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Styl';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Pořadí pro tabulátor';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titulek';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Zleva doprava';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Zprava doleva';
$string['xhtmlxtras_dlg:events_tab'] = 'Události';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributy prvku';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Atributy události';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Obecné parametry';
$string['xhtmlxtras_dlg:general_tab'] = 'Obecné';
$string['xhtmlxtras_dlg:insert_date'] = 'Vložit aktuální datum/čas';
$string['xhtmlxtras_dlg:option_ltr'] = 'Zleva doprava';
$string['xhtmlxtras_dlg:option_rtl'] = 'Zprava doleva';
$string['xhtmlxtras_dlg:remove'] = 'Odstranit';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Zkratka';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citace';
$string['xhtmlxtras_dlg:title_del_element'] = 'Odstraněný text';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Přidaný text';
