<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'cs', version '3.10'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte nadcházející relace bigbluebuttonbn';
$string['bbbduetimeoverstartingtime'] = 'Čas této činnosti musí být větší než je čas zahájení';
$string['bbbdurationwarning'] = 'Maximální doba trvání této relace je %duration%  minut';
$string['bbbrecordallfromstartwarning'] = 'Tato relace od začátku se nahrává.';
$string['bbbrecordwarning'] = 'Relace je nahrávána.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Přidat novou BBB místnost / aktivitu';
$string['bigbluebuttonbn:join'] = 'Připojit k BBB schůzce';
$string['bigbluebuttonbn:managerecordings'] = 'Správa nahrávek bigbluebuttonbn';
$string['bigbluebuttonbn:meeting'] = 'Vytvořit instance s možnostmi živého vysílání';
$string['bigbluebuttonbn:recording'] = 'Vytvořit instance s možnostmi nahrávání';
$string['bigbluebuttonbn:view'] = 'Zobrazit místnost / aktivitu';
$string['calendarstarts'] = '{$a} je naplánováno na';
$string['completionattendance'] = 'Student se musí schůzky zúčastnit:';
$string['completionattendancedesc'] = 'Student se musí schůzky zúčastnit a zůstat v ní alespoň {$a} minut';
$string['completionattendancegroup'] = 'Vyžadovat účast';
$string['completionattendancegroup_help'] = 'K dokončení je nutná účast na schůzi po dobu (n) minut';
$string['completionengagementchats'] = 'Události chatu';
$string['completionengagementdesc'] = 'Student se musí během schůzky zapojit do aktivit';
$string['completionengagementemojis'] = 'Emodži';
$string['completionengagementgroup'] = 'Vyžadovat zapojení';
$string['completionengagementgroup_help'] = 'K dokončení je nutná aktivní účast během relace';
$string['completionengagementpollvotes'] = 'Hlasování';
$string['completionengagementraisehand'] = 'Událost hlasování';
$string['completionengagementtalks'] = 'Událost diskuse';
$string['completionengagementtalktime'] = 'Čas události';
$string['completionupdatestate'] = 'Stav aktualizace dokončení';
$string['completionvalidatestate'] = 'Potvrdit dokončení';
$string['completionvalidatestatetriggered'] = 'Bylo spuštěno ověření dokončení.';
$string['config_clienttype'] = 'Konfigurace typu "Web klient"';
$string['config_clienttype_default'] = 'Výchozí typ webového klienta';
$string['config_clienttype_default_description'] = 'Výběr mezi klasickým Adobe Flash klientem nebo novým HTML5 klientem.';
$string['config_clienttype_description'] = 'Toto nastavení povoluje / zakazuje volbu webového klienta pro každou místnost.';
$string['config_clienttype_editable'] = 'Volbu Webového klienta lze upravit';
$string['config_clienttype_editable_description'] = 'Tato volba povoluje volbu webového klienta (AdobeFlash / HTML5) z formuláře pro úpravu místnosti.';
$string['config_default_messages'] = 'Výchozí zprávy';
$string['config_default_messages_description'] = 'Nastavit výchozí hodnoty zpráv pro aktivity';
$string['config_disablecam_default'] = 'Ve výchozím nastavení zakázat kameru';
$string['config_disablecam_default_description'] = 'Pokud je povoleno, budou webové kamery zakázány.';
$string['config_disablecam_editable'] = 'Zákaz kamery lze upravit';
$string['config_disablecam_editable_description'] = 'Ve výchozím nastavení lze zakázat kameru, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablemic_default'] = 'Ve výchozím nastavení zakázat mikrofon';
$string['config_disablemic_default_description'] = 'Pokud je povoleno, mikrofony budou zakázány.';
$string['config_disablemic_editable'] = 'Zákaz mikrofonu lze upravit';
$string['config_disablemic_editable_description'] = 'Ve výchozím nastavení lze zakázat mikrofon, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablenote_default'] = 'Ve výchozím nastavení zakázat sdílené poznámky';
$string['config_disablenote_default_description'] = 'Pokud je povoleno, sdílené poznámky budou zakázány.';
$string['config_disablenote_editable'] = 'Zákaz sdílených poznámek lze upravit';
$string['config_disablenote_editable_description'] = 'Ve výchozím nastavení lze zakázat sdílené poznámky, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disableprivatechat_default'] = 'Ve výchozím nastavení je zakázán soukromý chat';
$string['config_disableprivatechat_default_description'] = 'Pokud je povoleno, soukromý chat bude zakázán.';
$string['config_disableprivatechat_editable'] = 'Zákaz soukromého chatu lze upravit';
$string['config_disableprivatechat_editable_description'] = 'Ve výchozím nastavení lze zakázat soukromý chat, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablepublicchat_default'] = 'Ve výchozím nastavení zakázat veřejný chat';
$string['config_disablepublicchat_default_description'] = 'Pokud je povoleno, bude veřejný chat zakázán.';
$string['config_disablepublicchat_editable'] = 'Zákaz veřejného chatu lze upravit';
$string['config_disablepublicchat_editable_description'] = 'Ve výchozím nastavení lze zakázat veřejný chat, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_experimental_features'] = 'Konfigurace experimentálních funkcí';
$string['config_experimental_features_description'] = 'Konfigurace experimentálních funkcí.';
$string['config_extended_capabilities'] = 'Konfigurace pro rozšířené možnosti';
$string['config_extended_capabilities_description'] = 'Konfigurace pro rozšířené možnosti, které server BigBlueButton nabízí.';
$string['config_general'] = 'Obecná konfigurace';
$string['config_general_description'] = 'Tato nastavení jsou používána <b>vždy  </b>';
$string['config_hideuserlist_default'] = 'Ve výchozím nastavení skrýt seznam uživatelů';
$string['config_hideuserlist_default_description'] = 'Pokud je povoleno, seznam uživatelů relace bude skrytý.';
$string['config_hideuserlist_editable'] = 'Skrytí seznamu uživatelů lze upravit';
$string['config_hideuserlist_editable_description'] = 'Ve výchozím nastavení lze zakázat skrytí seznamu uživatelů, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_importrecordings'] = 'Konfigurace funkce "Import nahrávky"';
$string['config_importrecordings_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_importrecordings_enabled'] = 'Povolení importu nahrávek';
$string['config_importrecordings_enabled_description'] = 'Pokud je tato funkce a funkce nahrávání povolena, je možné importovat nahrávky z různých kurzů do činnosti.';
$string['config_importrecordings_from_deleted_enabled'] = 'Je povoleno importovat nahrávky ze smazaných aktivit';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Je-li tato funkce a funkce nahrávání importu povolena, je možné importovat nahrávky z činností, které již nejsou v kurzu.';
$string['config_lockedlayout_default'] = 'Ve výchozím nastavení je rozložení uzamčeno';
$string['config_lockedlayout_default_description'] = 'Pokud je povoleno, rozložení relace bude uzamčeno.';
$string['config_lockedlayout_editable'] = 'Uzamčené rozložení lze upravit';
$string['config_lockedlayout_editable_description'] = 'Ve výchozím nastavení lze uzamčené rozložení upravit při přidání nebo aktualizaci instance.';
$string['config_lockonjoin_default'] = 'Ignorovat zámek při připojení je ve výchozím nastavení povoleno';
$string['config_lockonjoin_default_description'] = 'Pokud je povoleno, nastavení zámku bude ignorováno. Aby to mohlo platit, musí být povolena konfigurace zámku.';
$string['config_lockonjoin_editable'] = 'Ignorovat zámek při připojení lze upravit';
$string['config_lockonjoin_editable_description'] = 'Ve výchozím nastavení lze ignorování zámku při připojení upravit při přidání nebo aktualizaci instance.';
$string['config_lockonjoinconfigurable_default'] = 'Ve výchozím nastavení je konfigurace zámku povolena';
$string['config_lockonjoinconfigurable_default_description'] = 'Pokud je povoleno, nastavení zámku relace lze povolit nebo zakázat z výše uvedeného ovládacího prvku.';
$string['config_lockonjoinconfigurable_editable'] = 'Konfiguraci zámku lze upravit';
$string['config_lockonjoinconfigurable_editable_description'] = 'Konfiguraci zámku lze ve výchozím nastavení upravit při přidání nebo aktualizaci instance.';
$string['config_locksettings'] = 'Konfigurace nastavení zamykání';
$string['config_locksettings_description'] = 'Tato nastavení umožňují nebo zakazují možnosti v uživatelském rozhraní pro uzamčení nastavení a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_meetingevents_enabled'] = 'Zaregistrovat živé události';
$string['config_meetingevents_enabled_description'] = 'Po skončení relace povolte plugin pro přijímání a zpracování živých událostí. (Musí být povoleno pro „Dokončení aktivity“ a a bude fungovat, pouze pokud je server BigBlueButton schopen zpracovávat skripty post_events)';
$string['config_muteonstart'] = 'Konfigurace funkce "Při zahájení ztlumit"';
$string['config_muteonstart_default'] = 'Ve výchozím nastavení je výchozí zvuk ztlumen';
$string['config_muteonstart_default_description'] = 'Pokud je povoleno, bude relace při startu ztlumena.';
$string['config_muteonstart_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_muteonstart_editable'] = 'Ztlumení na startu lze upravit';
$string['config_muteonstart_editable_description'] = 'Ve výchozím nastavení může být ztlumení při spuštění upraveno při přidání nebo aktualizaci instance.';
$string['config_participant'] = 'Konfigurace účastníka';
$string['config_participant_description'] = 'Tato nastavení standardně definují roli účastníků konference.';
$string['config_participant_moderator_default'] = 'Ve výchozím nastavení Moderátor';
$string['config_participant_moderator_default_description'] = 'Toto pravidlo je ve výchozím nastavení použito při přidání nové místnosti.';
$string['config_presentation_default'] = 'Výchozí soubor pro funkci „Předběžná prezentace“';
$string['config_presentation_default_description'] = 'Toto nastavení umožňuje vybrat soubor, který má být použit jako výchozí ve všech instancích BBB, pokud je povolena "Předběžná prezentace".';
$string['config_preuploadpresentation'] = 'Konfigurace funkce "Předběžná prezentace"';
$string['config_preuploadpresentation_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti. Tato funkce funguje pouze v případě, že je server Moodle dostupný pro BigBlueButton ..';
$string['config_preuploadpresentation_editable'] = 'Prezentace před nahráním je upravitelná';
$string['config_preuploadpresentation_editable_description'] = 'Funkce prezentace před nahráním je v uživatelském rozhraní upravitelná, když je místnost nebo konference přidána nebo aktualizována.';
$string['config_recording'] = 'Konfigurace funkce "Záznam schůzky"';
$string['config_recording_all_from_start_default'] = 'Záznam od začátku';
$string['config_recording_all_from_start_default_description'] = 'Pokud je zaškrtnuto, schůzka bude zahájena';
$string['config_recording_all_from_start_editable'] = 'Záznam od začátku lze upravovat';
$string['config_recording_all_from_start_editable_description'] = 'Pokud je zaškrtnuto, obsahuje rozhraní možnost zapnout a vypnout záznam od začátku.';
$string['config_recording_default'] = 'Ve výchozím nastavení je funkce nahrávání povolena';
$string['config_recording_default_description'] = 'Pokud je povoleno, relace vytvořené v BigBlueButton budou mít možnosti nahrávání.';
$string['config_recording_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_recording_editable'] = 'Funkci nahrávání lze upravovat';
$string['config_recording_editable_description'] = 'Pokud je zaškrtnuto, rozhraní obsahuje možnost pro zapnutí a vypnutí funkce záznamu.';
$string['config_recording_hide_button_default'] = 'Skrýt tlačítko nahrávání';
$string['config_recording_hide_button_default_description'] = 'Pokud je zaškrtnuto, tlačítko pro záznam se skryje';
$string['config_recording_hide_button_editable'] = 'Tlačítko Skrýt záznam lze upravit';
$string['config_recording_hide_button_editable_description'] = 'Pokud je zaškrtnuto, rozhraní obsahuje možnost pro aktivaci a deaktivaci funkce skrýt záznam.';
$string['config_recording_icons_enabled'] = 'Ikony pro správu záznamu';
$string['config_recording_icons_enabled_description'] = 'Je-li tato volba povolena, zobrazí se panel pro správu záznamů ikony pro publikování / nepublikování a odstranění akcí.';
$string['config_recordingready_enabled'] = 'Když je záznam připraven, odeslat oznámení';
$string['config_recordingready_enabled_description'] = 'Povolit plugin pro odesílání upozornění, když je záznam připraven. (Funguje to pouze v případě, že je na serveru BigBlueButton povolen skript post_publish_recording_ready_callback)';
$string['config_recordings'] = 'Konfigurace funkce "Zobrazit nahrávky"';
$string['config_recordings_deleted_default'] = 'Zahrnout nahrávky ze smazaných činností standardně povolených';
$string['config_recordings_deleted_default_description'] = 'Pokud je tato volba povolena, záznamová tabulka bude obsahovat záznamy, které patří k vymazaným činnostem, pokud existuje.';
$string['config_recordings_deleted_editable'] = 'Vložené nahrávky z funkce smazaných činností lze upravovat';
$string['config_recordings_deleted_editable_description'] = 'Vložené nahrávky ze smazaných činností lze ve výchozím nastavení upravovat při přidání nebo aktualizaci instance.';
$string['config_recordings_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_recordings_general'] = 'Zobrazit nastavení nahrávání';
$string['config_recordings_general_description'] = 'Tato nastavení se používají pouze při zobrazování záznamů';
$string['config_recordings_html_default'] = 'Ve výchozím nastavení je povoleno uživatelské rozhraní jako html';
$string['config_recordings_html_default_description'] = 'Je-li tato možnost povolena, zobrazí se ve výchozím nastavení tabulka pro nahrávání v prostém HTML.';
$string['config_recordings_html_editable'] = 'Funkce UI jako html lze upravovat';
$string['config_recordings_html_editable_description'] = 'Výchozí nastavení uživatelského rozhraní UI jako hodnoty html lze upravovat při přidání nebo aktualizaci instance.';
$string['config_recordings_imported_default'] = 'Standardně zobrazit pouze importované odkazy';
$string['config_recordings_imported_default_description'] = 'Pokud je zapnuta, bude záznamová tabulka obsahovat pouze odkazy na importované nahrávky.';
$string['config_recordings_imported_editable'] = 'Zobrazovat lze pouze funkci importu importovaných odkazů';
$string['config_recordings_imported_editable_description'] = 'Zobrazit pouze importované odkazy ve výchozím nastavení lze upravovat při přidání nebo aktualizaci instance.';
$string['config_recordings_preview_default'] = 'Náhled je ve výchozím nastavení povolen';
$string['config_recordings_preview_default_description'] = 'Pokud je tato volba povolena, tabulka obsahuje náhled prezentace.';
$string['config_recordings_preview_editable'] = 'Funkce náhledu lze upravovat';
$string['config_recordings_preview_editable_description'] = 'Funkce náhledu může být upravena při přidání nebo aktualizaci instance.';
$string['config_recordings_sortorder'] = 'Řadit nahrávky ve vzestupném pořadí.';
$string['config_recordings_sortorder_description'] = 'Ve výchozím nastavení jsou záznamy zobrazeny v sestupném pořadí. Při zaškrtnutí budou seřazeny ve vzestupném pořadí.';
$string['config_recordings_validate_url'] = 'Ověřit adresu URL';
$string['config_recordings_validate_url_description'] = 'Pokud je zaškrtnuto, bude URL pro přehrávání ověřeno před přístupem uživatele.';
$string['config_scheduled'] = 'Konfigurace pro "Plánované relace"';
$string['config_scheduled_description'] = 'Tato nastavení definují některá chování standardně pro naplánované relace.';
$string['config_scheduled_duration_compensation'] = 'Náhradní čas (minuty)';
$string['config_scheduled_duration_compensation_description'] = 'Minuty přidané k naplánovanému uzavření při výpočtu doby trvání.';
$string['config_scheduled_duration_enabled'] = 'Je povoleno vypočítat dobu trvání';
$string['config_scheduled_duration_enabled_description'] = 'Trvání naplánované relace se vypočítá na základě času otevření a zavření.';
$string['config_scheduled_pre_opening'] = 'Přístupné před časem otevření (minuty)';
$string['config_scheduled_pre_opening_description'] = 'Doba v minutách, po kterou má být relace přístupná před plánovanou dobou otevření.';
$string['config_sendnotifications'] = 'Konfigurace funkce "Odeslat oznámení"';
$string['config_sendnotifications_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_sendnotifications_enabled'] = 'Povolit odesílání oznámení';
$string['config_sendnotifications_enabled_description'] = 'Pokud je povoleno, uživatelské rozhraní pro úpravu aktivity zahrnuje možnost odeslání oznámení zaregistrovanému uživateli, když je aktivita přidána nebo aktualizována.';
$string['config_server_url'] = 'Adresa URL serveru BigBlueButton';
$string['config_server_url_description'] = 'Adresa URL vašeho serveru BigBlueButton musí končit řetězcem /bigbluebutton/. (Tato výchozí adresa URL je pro server BigBlueButton poskytovaný společností Blindside Networks, kterou můžete použít pro testování.)';
$string['config_shared_secret'] = 'BigBlueButton sdílený klíč';
$string['config_shared_secret_description'] = 'Bezpečnostní sůl vašeho serveru BigBlueButton. (Tato výchozí sůl je pro server BigBlueButton poskytovaný společností Blindside Networks, kterou můžete použít pro testování.)';
$string['config_uidelegation_enabled'] = 'Delegování UI je povoleno';
$string['config_uidelegation_enabled_description'] = 'Tato nastavení povolují nebo zakazují delegování UI na server BigBlueButton.';
$string['config_userlimit'] = 'Konfigurace funkce "Limit uživatele"';
$string['config_userlimit_default'] = 'Ve výchozím nastavení je povolen limit uživatelů';
$string['config_userlimit_default_description'] = 'Počet uživatelů povolených v relaci ve výchozím nastavení při přidání nové místnosti nebo konference. Pokud je číslo nastaveno na 0, není nastaven žádný limit';
$string['config_userlimit_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_userlimit_editable'] = 'Funkci omezení uživatele lze upravit';
$string['config_userlimit_editable_description'] = 'Ve výchozím nastavení lze omezit limitní hodnotu uživatelů při přidání nebo aktualizaci místnosti nebo konference.';
$string['config_voicebridge'] = 'Konfigurace funkce "Hlasový most"';
$string['config_voicebridge_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_voicebridge_editable'] = 'Konferenční hlasový most lze upravit';
$string['config_voicebridge_editable_description'] = 'Číslo hlasového mostu konference může být trvale přiřazeno k konferencím v místnosti. Při přiřazení nelze toto číslo použít žádnou jinou místností nebo konferenci';
$string['config_waitformoderator'] = 'Konfigurace funkce "Čekejte na moderátora"';
$string['config_waitformoderator_cache_ttl'] = 'Čekání na vyrovnávací paměť moderátora TTL (sekundy)';
$string['config_waitformoderator_cache_ttl_description'] = 'Pro podporu velkého zatížení klientů tento plugin využívá cache. Tento parametr definuje dobu, po kterou bude mezipaměť uchovávána před odesláním dalšího požadavku na server BigBlueButton.';
$string['config_waitformoderator_default'] = 'Čekání na moderátora je standardně povoleno';
$string['config_waitformoderator_default_description'] = 'Čekání na moderátora je standardně povoleno při přidávání nové místnosti nebo konference.';
$string['config_waitformoderator_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_waitformoderator_editable'] = 'Funkce Čekání na moderátora lze upravit';
$string['config_waitformoderator_editable_description'] = 'Hodnota Čekání na moderátora lze upravit, když je místnost nebo konference přidána nebo aktualizována.';
$string['config_waitformoderator_ping_interval'] = 'Čekání na ping moderátora (sekundy)';
$string['config_waitformoderator_ping_interval_description'] = 'Když je povolena funkce čekání na moderátor, klient posílá ping pro zjištění stavu relace každých [number] sekund. Tento parametr definuje interval pro požadavky na server Moodle';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton využívá config.php s globální proměnnou, která byla zastaralá. Soubor prosím převeďte, protože nebude podporován v budoucích verzích';
$string['config_warning_curl_not_installed'] = 'Tato funkce vyžaduje rozšíření CURL pro php nainstalované a povolené. Nastavení budou přístupná pouze v případě, že je tato podmínka splněna.';
$string['config_welcome_default'] = 'Výchozí uvítací zpráva';
$string['config_welcome_default_description'] = 'Nahradí výchozí zprávu nastavenou pro server BigBlueButton. Zpráva může obsahovat klíčová slova  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), která budou automaticky nahrazena, a také html tagy jako <b> ... </b> nebo <i> </i>';
$string['config_welcome_editable'] = 'Výchozí uvítací zprávu mohou učitelé upravovat';
$string['config_welcome_editable_description'] = 'Uvítací zprávu lze upravit, když je instance přidána nebo aktualizována';
$string['email_body_notification_meeting_by'] = 'podle';
$string['email_body_notification_meeting_description'] = 'Popis';
$string['email_body_notification_meeting_details'] = 'Podrobnosti';
$string['email_body_notification_meeting_end_date'] = 'Datum ukončení';
$string['email_body_notification_meeting_has_been'] = 'byl';
$string['email_body_notification_meeting_start_date'] = 'Datum zahájení';
$string['email_body_notification_meeting_title'] = 'Nadpis';
$string['email_body_recording_ready_for'] = 'Nahrávání pro';
$string['email_body_recording_ready_is_ready'] = 'je připraven';
$string['email_footer_sent_by'] = 'Tato automatická zpráva byla odeslána';
$string['email_footer_sent_from'] = 'z kurzu';
$string['ends_at'] = 'Konec v';
$string['event_activity_created'] = 'Činnost vytvořena';
$string['event_activity_deleted'] = 'Činnost odstraněna';
$string['event_activity_updated'] = 'Činnost aktualizována';
$string['event_activity_viewed'] = 'Činnost zobrazeno';
$string['event_live_session'] = 'Událost žívá relace';
$string['event_meeting_created'] = 'Schůzka bylo vytvořena';
$string['event_meeting_ended'] = 'Schůzka nuceně ukončena';
$string['event_meeting_joined'] = 'Schůzka připojena';
$string['event_meeting_left'] = 'Schůzka proběhla';
$string['event_recording_deleted'] = 'Záznam byl vymazán';
$string['event_recording_edited'] = 'Záznam byl upraven';
$string['event_recording_imported'] = 'Záznam byl importován';
$string['event_recording_protected'] = 'Záznam je chráněn';
$string['event_recording_published'] = 'Záznam byl zveřejněn';
$string['event_recording_unprotected'] = 'Záznam je nechráněný';
$string['event_recording_unpublished'] = 'Publikování záznamu bylo zrušeno';
$string['event_recording_viewed'] = 'Záznam byl zobrazen';
$string['general_error_not_allowed_to_create_instances'] = 'Uživatel nesmí vytvářet žádné typy instancí.';
$string['general_error_unable_connect'] = 'Nelze se připojit. Zkontrolujte adresu URL serveru BigBlueButton A zkontrolujte, zda je spuštěn server BigBlueButton.';
$string['index_confirm_end'] = 'Přejete si ukončit virtuální třídu?';
$string['index_disabled'] = 'zakázán';
$string['index_enabled'] = 'povolen';
$string['index_ending'] = 'Ukončování virtuální učebny ... čekejte prosím';
$string['index_error_bbtn'] = 'ID BigBlueButton {$a} je nesprávné';
$string['index_error_checksum'] = 'Došlo k chybě kontrolního součtu. Ujistěte se, že jste zadali správnou sůl.';
$string['index_error_forciblyended'] = 'K této schůzce se nelze připojit, protože byla manuálně ukončena.';
$string['index_error_noinstances'] = 'Není to instance bigbluebuttonbn';
$string['index_error_unable_display'] = 'Schůzku nelze zobrazit. Zkontrolujte adresu URL serveru BigBlueButton a zkontrolujte, zda je server BigBlueButton běží.';
$string['index_heading'] = 'Učebna BigBlueButton';
$string['index_heading_actions'] = 'Činnosti';
$string['index_heading_group'] = 'Skupina';
$string['index_heading_moderator'] = 'Moderátoři';
$string['index_heading_name'] = 'Místnost';
$string['index_heading_recording'] = 'Záznam';
$string['index_heading_users'] = 'Uživatelé';
$string['index_heading_viewer'] = 'Diváci';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitivní';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na kognitivní hloubce dosažené studentem v aktivitě BigBlueButton.';
$string['indicator:socialbreadth'] = 'Sociální BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě BigBlueButton.';
$string['instance_type_default'] = 'Místnost/Aktivita s nahrávkami';
$string['instance_type_recording_only'] = 'Pouze nahrávky';
$string['instance_type_room_only'] = 'Pouze Místnost/Aktivita';
$string['minute'] = 'minuta';
$string['minutes'] = 'minuty';
$string['mod_form_block_clienttype'] = 'Technologie webového klienta';
$string['mod_form_block_clienttype_flash'] = 'Klient založený na technologii Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Klient založený na technologii HTML5';
$string['mod_form_block_general'] = 'Obecné nastavení';
$string['mod_form_block_participants'] = 'Role přiřazená během živého vysílání';
$string['mod_form_block_presentation'] = 'Obsah prezentace';
$string['mod_form_block_presentation_default'] = 'Výchozí obsah prezentace';
$string['mod_form_block_record'] = 'Nastavení záznamu';
$string['mod_form_block_recordings'] = 'Zobrazit záznamu';
$string['mod_form_block_room'] = 'Nastavení aktivity/místnosti';
$string['mod_form_block_schedule'] = 'Rozvrh relací';
$string['mod_form_field_block_clienttype'] = 'Technologie webového klienta';
$string['mod_form_field_closingtime'] = 'Připojení zavřeno';
$string['mod_form_field_conference_name'] = 'Název konference';
$string['mod_form_field_disablecam'] = 'Zakázat webové kamery';
$string['mod_form_field_disablemic'] = 'Zakázat mikrofony';
$string['mod_form_field_disablenote'] = 'Zakázat sdílené poznámky';
$string['mod_form_field_disableprivatechat'] = 'Zakázat soukromý chat';
$string['mod_form_field_disablepublicchat'] = 'Zakázat veřejný chat';
$string['mod_form_field_duration'] = 'Trvání';
$string['mod_form_field_duration_help'] = 'Nastavení trvání schůzky stanovuje dobu maximální délky do ukončení záznamu';
$string['mod_form_field_hideuserlist'] = 'Skrýt seznam uživatelů';
$string['mod_form_field_instanceprofiles'] = 'Typ instance';
$string['mod_form_field_instanceprofiles_help'] = 'Vybrat typ této instance BigBlueButton.';
$string['mod_form_field_intro'] = 'Popis';
$string['mod_form_field_intro_help'] = 'Stručný popis místnosti nebo konference.';
$string['mod_form_field_lockedlayout'] = 'Zamknout rozložení místnosti';
$string['mod_form_field_lockonjoin'] = 'Ignorovat nastavení zámku';
$string['mod_form_field_lockonjoinconfigurable'] = 'Povolit ignorovat nastavení zamykání';
$string['mod_form_field_muteonstart'] = 'Ztlumení při zahájení';
$string['mod_form_field_name'] = 'Jméno virtuální třídy';
$string['mod_form_field_nosettings'] = 'Nelze upravit žádná nastavení';
$string['mod_form_field_notification'] = 'Oznámit tuto změnu registrovaným uživatelům';
$string['mod_form_field_notification_created_help'] = 'Odeslání oznámení všem uživatelům, kteří jsou přihlášeni s  oznámením, že tato aktivita byla vytvořena';
$string['mod_form_field_notification_help'] = 'Odeslání oznámení všem uživatelům, kteří jsou přihlášeni s  oznámením, že tato aktivita byla vytvořena nebo změněna';
$string['mod_form_field_notification_modified_help'] = 'Odeslání oznámení všem uživatelům, kteří jsou přihlášeni s  oznámením, že tato aktivita byla změněna';
$string['mod_form_field_notification_msg_at'] = 've';
$string['mod_form_field_notification_msg_created'] = 'přidáno';
$string['mod_form_field_notification_msg_modified'] = 'upraveno';
$string['mod_form_field_openingtime'] = 'Připojit se';
$string['mod_form_field_participant_add'] = 'Přidat účastníka';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderátor';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Divák';
$string['mod_form_field_participant_list'] = 'Seznam účastníků';
$string['mod_form_field_participant_list_action_add'] = 'Přidat';
$string['mod_form_field_participant_list_action_remove'] = 'Odstranit';
$string['mod_form_field_participant_list_text_as'] = 'připojuje se k relaci jako';
$string['mod_form_field_participant_list_type_all'] = 'Všichni uživatelé zapsáni';
$string['mod_form_field_participant_list_type_owner'] = 'Vlastník';
$string['mod_form_field_participant_list_type_role'] = 'Role';
$string['mod_form_field_participant_list_type_user'] = 'Uživatel';
$string['mod_form_field_record'] = 'Relaci lze zaznamenat';
$string['mod_form_field_recordallfromstart'] = 'Záznam od zahájení';
$string['mod_form_field_recordhidebutton'] = 'Skrýt tlačítko nahrávání';
$string['mod_form_field_recordings_deleted'] = 'Zahrnout nahrávky z odstraněných aktivit';
$string['mod_form_field_recordings_html'] = 'Zobrazit tabulku v prostém html';
$string['mod_form_field_recordings_imported'] = 'Zobrazit pouze importované odkazy';
$string['mod_form_field_recordings_preview'] = 'Zobrazit náhled záznamu';
$string['mod_form_field_room_name'] = 'Název místnosti';
$string['mod_form_field_userlimit'] = 'Limit uživatelů';
$string['mod_form_field_userlimit_help'] = 'Povolený maximální počet uživatelů na schůzce. Pokud je limit nastaven na 0, počet uživatelů bude neomezený.';
$string['mod_form_field_voicebridge'] = 'Hlasový přístup [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Chyba formátování. Měli byste zadat číslo mezi 1 a 9999.';
$string['mod_form_field_voicebridge_help'] = 'Číslo hlasové konference, které účastníci zadají, aby se připojili k hlasové konferenci při použití telefonického připojení. Je třeba zadat číslo mezi 1 a 9999. Pokud je hodnota 0, bude statické číslo hlasového mostu ignorováno a BigBlueButton vygeneruje náhodné číslo. Před zadanými čtyřmi číslicemi bude číslo 7';
$string['mod_form_field_voicebridge_notunique_error'] = 'Není to jedinečná hodnota. Toto číslo používá jiná místnost nebo konference.';
$string['mod_form_field_wait'] = 'Počkat na moderátora';
$string['mod_form_field_wait_help'] = 'Diváci musí počkat, než moderátor vstoupí do relace, než to mohou udělat';
$string['mod_form_field_welcome'] = 'Uvítací zpráva';
$string['mod_form_field_welcome_default'] = '<br>Vítejte na <b>%%CONFNAME%%</b>!<br><br>Nápovědu k používání BigBlueButton najdete v těchto (krátkých) <a href="event:http://www.bigbluebutton.org/content/videos"><u>videotutoriálech</u></a>.<br><br>Pro připojení hlasového přístupu klepněte na ikonu sluchátek (nahoře v levém rohu). <b>Používejte sluchátka, abyste nerušili ostatní.</b>';
$string['mod_form_field_welcome_help'] = 'Nahradí výchozí zprávu nastavenou pro server BigBlueButton. Zpráva může obsahovat klíčová slova(%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), které budou automaticky nahrazeny, a také html tagy jako <b>...</b> nebo <i></i>';
$string['mod_form_locksettings'] = 'Nastavení zámku';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonBumožňuje vytvářet v rámci Moodle odkazy na on-line učebny vytvořené aplikací BigBlueButton.  Aplikace je open source konferenční systém pro distanční vzdělávání.

Pomocí BigBlueButton můžete zadat název, popis, položky kalendáře (který zadává data pro vstup do relací), skupiny, a podrobnosti o nahrávání sezení.

Chcete-li zobrazit nahrávky později, přidejte do tohoto kurzu studijní materiál Recordings.';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Správa BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Aby bylo možné vytvořit připojení k relacím BigBlueButton, je třeba si vyměňitt uživatelská data se serverem.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Celé jméno uživatele přistupujícího k serveru BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Uživatelské jméno uživatele přistupujícího k serveru BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Uloží konfiguraci místnosti nebo aktivity, která definuje funkce a obecné chování relace BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Seznam pravidel, která definují roli, kterou budou uživatelé mít na živém schůzce. ID uživatele může být uloženo, protože lze udělit oprávnění pro roli nebo uživatele.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Ukládá události spuštěné při použití pluginu.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typ události spuštěné uživatelem.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID schůzky, ke které měl uživatel přístup.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Mohou zahrnovat další informace týkající se schůzky nebo záznamu, který událost postihla.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Čas, kdy byl protokol vytvořen.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID uživatele uživatele, který událost spustil.';
$string['removedevents'] = 'Odstraněné události';
$string['removedlogs'] = 'Odstraněny vlastní protokoly';
$string['removedrecordings'] = 'Odstraněné nahrávky';
$string['removedtags'] = 'Odstraněné štítky';
$string['resetevents'] = 'Odstranit události';
$string['resetlogs'] = 'Odstranit protokoly';
$string['resetlogs_help'] = 'Odstranění protokolů způsobí ztrátu odkazů na nahrávky';
$string['resetrecordings'] = 'Odstranit nahrávky';
$string['resetrecordings_help'] = 'Odstranění záznamů z nich učiní nedostupné a nelze je vrátit zpět';
$string['resettags'] = 'Odstranit štítky';
$string['search:activity'] = 'BigBlueButton - informace o aktivitě';
$string['search:tags'] = 'BigBlueButton - informace o štítcích';
$string['sendnotification'] = 'Odeslat oznámení';
$string['started_at'] = 'Zahájeno';
$string['starts_at'] = 'Začátek v';
$string['view_conference_action_end'] = 'Ukončení relace';
$string['view_conference_action_join'] = 'Připojení k relaci';
$string['view_error_action_not_completed'] = 'Akci nelze dokončit';
$string['view_error_bigbluebutton'] = 'BigBlueButton odpověděl chybami. {$a}';
$string['view_error_create'] = 'Server BigBlueButton odpověděl chybovou zprávou, schůzku nelze vytvořit.';
$string['view_error_current_state_not_found'] = 'Aktuální stav nebyl nalezen. Záznam mohl být odstraněn nebo server BigBlueButton není kompatibilní s provedenou akcí.';
$string['view_error_import_no_courses'] = 'Žádné kurzy k vyhledání nahrávek';
$string['view_error_import_no_recordings'] = 'V tomto kurzu nejsou žádné záznamy pro import';
$string['view_error_invalid_session'] = 'Platnost relace vypršela. Vraťte se na hlavní stránku aktivity.';
$string['view_error_max_concurrent'] = 'Bylo dosaženo počtu povolených souběžných schůzek.';
$string['view_error_meeting_not_running'] = 'Něco se pokazilo, schůzka neběží.';
$string['view_error_no_group'] = 'Dosud nejsou nastaveny žádné skupiny. Před připojením ke schůzce vytvořte prosím skupiny.';
$string['view_error_no_group_student'] = 'Nejste zapsáni ve skupině. Obraťte se na svého učitele nebo správce.';
$string['view_error_no_group_teacher'] = 'Nejsou dosud nastaveny žádné skupiny. Nastavte prosím skupiny, nebo se obraťte na správce.';
$string['view_error_unable_join'] = 'Nelze se připojit ke schůzce. Zkontrolujte adresu URL serveru BigBlueButton a zkontrolujte, zda je server BigBlueButton běží.';
$string['view_error_unable_join_student'] = 'Nelze se připojit k serveru BigBlueButton. Obraťte se na svého učitele nebo správce.';
$string['view_error_unable_join_teacher'] = 'Nelze se připojit k serveru BigBlueButton. Obraťte se na správce.';
$string['view_error_url_missing_parameters'] = 'Na této adrese URL chybí parametry';
$string['view_error_userlimit_reached'] = 'Bylo dosaženo povoleného počtu uživatelů na schůzce.';
$string['view_groups_nogroups_warning'] = 'Místnost byla nakonfigurována pro použití skupin, ale kurz nemá definované skupiny.';
$string['view_groups_notenrolled_warning'] = 'Místnost byla nakonfigurována pro použití skupin, ale nejste zaregistrováni v žádné z nich.';
$string['view_groups_selection'] = 'Vyberte skupinu, ke které se chcete připojit a potvrďte akci';
$string['view_groups_selection_join'] = 'Připojit';
$string['view_groups_selection_warning'] = 'Pro každou skupinu je k dispozici konferenční místnost a máte přístup k více než jedné. Nezapomeňte vybrat tu správnou.';
$string['view_login_moderator'] = 'Přihlásit se jako moderátor ...';
$string['view_login_viewer'] = 'Přihlásit se jako divák ...';
$string['view_message_and'] = 'a';
$string['view_message_conference_has_ended'] = 'Tato konference skončila.';
$string['view_message_conference_in_progress'] = 'Tato konference probíhá.';
$string['view_message_conference_not_started'] = 'Tato konference ještě nezačala.';
$string['view_message_conference_room_ready'] = 'Tato konferenční místnost je připravena. Nyní se můžete k relaci připojit.';
$string['view_message_conference_wait_for_moderator'] = 'Čekání na připojení moderátora.';
$string['view_message_finished'] = 'Tato aktivita skončila.';
$string['view_message_has_joined'] = 'připojil se';
$string['view_message_have_joined'] = 'připojili se';
$string['view_message_hour'] = 'hodina';
$string['view_message_hours'] = 'hodin';
$string['view_message_importrecordings_disabled'] = 'Funkce pro import odkazů na nahrávání je na tomto serveru zakázána.';
$string['view_message_minute'] = 'minuta';
$string['view_message_minutes'] = 'minut';
$string['view_message_moderator'] = 'moderátor';
$string['view_message_moderators'] = 'moderátoři';
$string['view_message_norecordings'] = 'Nejsou žádné nahrávky, které by bylo možné zobrazit.';
$string['view_message_notavailableyet'] = 'Tato relace zatím není k dispozici.';
$string['view_message_recordings_disabled'] = 'Nahrávky byly na tomto serveru deaktivovány. Nelze použít instance BigBlueButton pouze pro nahrávky.';
$string['view_message_room_closed'] = 'Tato místnost je zavřena.';
$string['view_message_room_open'] = 'Tato místnost je otevřena.';
$string['view_message_room_ready'] = 'Tato místnost je připravena.';
$string['view_message_session_for'] = 'relace pro';
$string['view_message_session_has_user'] = 'Tady je';
$string['view_message_session_has_users'] = 'Tady jsou';
$string['view_message_session_no_users'] = 'V této relaci nejsou žádní uživatelé';
$string['view_message_session_running_for'] = 'Tato relace již běží';
$string['view_message_session_started_at'] = 'Tato relace začala v';
$string['view_message_tab_close'] = 'Tato karta / okno musí být zavřeno ručně';
$string['view_message_times'] = 'krát';
$string['view_message_user'] = 'uživatel';
$string['view_message_users'] = 'uživatelé';
$string['view_message_viewer'] = 'divák';
$string['view_message_viewers'] = 'diváků';
$string['view_mobile_message_groups_not_supported'] = 'Tato instance umožňuje práci se skupinami, ale mobilní aplikace to nepodporuje. Pokud chcete použít skupinovou podporu, otevřete ji na ploše.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Na této stránce jste překročili 45 sekund. Chcete-li se správně připojit ke schůzce, znovu ji prosím načtěte.';
$string['view_noguests'] = 'BigBlueButton není otevřen pro hosty';
$string['view_nojoin'] = 'Nemáte roli, která se může připojit k této relaci.';
$string['view_recording'] = 'nahrávka';
$string['view_recording_actionbar'] = 'Panel nástrojů';
$string['view_recording_activity'] = 'Aktivita';
$string['view_recording_button_import'] = 'Importujte odkazy na nahrávky';
$string['view_recording_button_return'] = 'Zpět';
$string['view_recording_course'] = 'Kurz';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Opravdu chcete {$a} smazat?';
$string['view_recording_delete_confirmation_warning_p'] = 'Tato nahrávka má přidružené odkazy {$a}, které byly importovány do různých kurzů nebo aktivit. Pokud je záznam vymazán, budou tyto odkazy také odstraněny';
$string['view_recording_delete_confirmation_warning_s'] = 'K tomuto záznamu je přiřazen odkaz {$a}, který byl importován do jiného kurzu nebo aktivity. Pokud je záznam smazán, bude také odkaz odstraněn';
$string['view_recording_description'] = 'Popis';
$string['view_recording_duration'] = 'Doba trvání';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Adresa URL pro tento formát záznamu je nedostupná.';
$string['view_recording_format_notes'] = 'Poznámky';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Prezentace';
$string['view_recording_format_screenshare'] = 'Sdílena obrazovka';
$string['view_recording_format_statistics'] = 'Statistika';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Opravdu chcete importovat tuto nahrávku?';
$string['view_recording_length'] = 'Délka';
$string['view_recording_link_warning'] = 'Toto je odkaz směřující na nahrávku, která byla vytvořena v jiném kurzu nebo aktivitě';
$string['view_recording_list_action_delete'] = 'Odstranění';
$string['view_recording_list_action_edit'] = 'Aktualizace';
$string['view_recording_list_action_play'] = 'Spustit';
$string['view_recording_list_action_process'] = 'Zpracování';
$string['view_recording_list_action_protect'] = 'Ochrana';
$string['view_recording_list_action_publish'] = 'Publikování';
$string['view_recording_list_action_unprotect'] = 'Zrušit ochranu';
$string['view_recording_list_action_unpublish'] = 'Zrušit publikování';
$string['view_recording_list_action_update'] = 'Aktualizace';
$string['view_recording_list_actionbar'] = 'Nástroje';
$string['view_recording_list_actionbar_delete'] = 'Odstranit';
$string['view_recording_list_actionbar_edit'] = 'Upravit';
$string['view_recording_list_actionbar_hide'] = 'Skrýt';
$string['view_recording_list_actionbar_import'] = 'Importovat';
$string['view_recording_list_actionbar_protect'] = 'Nastavit jako soukromé';
$string['view_recording_list_actionbar_publish'] = 'Publikovat';
$string['view_recording_list_actionbar_show'] = 'Zobrazit';
$string['view_recording_list_actionbar_unprotect'] = 'Nastavit jako veřejné';
$string['view_recording_list_actionbar_unpublish'] = 'Zrušit publikování';
$string['view_recording_list_activity'] = 'Činnost';
$string['view_recording_list_course'] = 'Kurz';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Popis';
$string['view_recording_list_duration'] = 'Trvání';
$string['view_recording_list_recording'] = 'Zaznamenávání';
$string['view_recording_meeting'] = 'Schůzka';
$string['view_recording_modal_button'] = 'Aplikovat';
$string['view_recording_modal_title'] = 'Nastavit hodnoty pro záznam';
$string['view_recording_name'] = 'Název';
$string['view_recording_playback'] = 'Přehrávání';
$string['view_recording_preview'] = 'Náhled';
$string['view_recording_preview_help'] = 'Umístěním kurzoru na obrázek jej zobrazíte v plné velikosti';
$string['view_recording_publish_link_deleted'] = 'Tento odkaz nelze znovu publikovat, protože aktuální záznam na aktuálním serveru BigBlueButton neexistuje. Odkaz by měl být odstraněn.';
$string['view_recording_publish_link_not_published'] = 'Tento odkaz nelze znovu publikovat, protože skutečný záznam není publikován';
$string['view_recording_recording'] = 'Záznam';
$string['view_recording_tags'] = 'Štítky';
$string['view_recording_unprotect_link_deleted'] = 'Tímto odkazem nelze zrušit ochranu, protože aktuální záznam na aktuálním serveru BigBlueButton neexistuje. Odkaz by měl být odstraněn.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Tímto odkazem nelze zrušit ochranu, protože skutečný záznam je chráněn';
$string['view_recording_unpublish_confirmation'] = 'Opravdu chcete zrušit publikování tohoto {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Tato nahrávka má přidružené odkazy {$a}, které byly importovány v různých kurzech nebo aktivitách. Pokud není záznam publikovaný, budou také nepublikovány tyto odkazy';
$string['view_recording_unpublish_confirmation_warning_s'] = 'K této nahrávce je přidružen odkaz {$a}, který byl importován v jiném kurzu nebo aktivitě. Pokud není záznam publikovaný, bude zrušen také odkaz';
$string['view_recording_yui_first'] = 'První';
$string['view_recording_yui_go'] = 'Přejít';
$string['view_recording_yui_last'] = 'Poslední';
$string['view_recording_yui_next'] = 'Další';
$string['view_recording_yui_page'] = 'Stránka';
$string['view_recording_yui_prev'] = 'Předchozí';
$string['view_recording_yui_rows'] = 'Řádky';
$string['view_recording_yui_show_all'] = 'Zobrazit vše';
$string['view_room'] = 'Zobrazit místnost';
$string['view_section_title_presentation'] = 'Soubor prezentace';
$string['view_section_title_recordings'] = 'Nahrávky';
$string['view_warning_default_server'] = 'Tento server Moodle využívá testovací server BigBlueButton, který je ve výchozím nastavení předkonfigurován. Měl by být nahrazen produkčním serverem.';
