<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_authorize', language 'sr_lt', version '3.10'.
 *
 * @package     enrol_authorize
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminacceptccs'] = 'Koji tipovi kreditnih kartica se prihvataju?';
$string['adminaccepts'] = 'Izaberite dozvoljene načine plaćanja i njihove tipove';
$string['adminauthorizeccapture'] = 'Pregled porudžbine i podešavanja zakazanog prihvatanja';
$string['adminauthorizeemail'] = 'Podešavanja slanja elektronske pošte';
$string['adminauthorizesettings'] = 'Podešavanja Authorize.net naloga';
$string['adminauthorizewide'] = 'Opšta podešavanja';
$string['adminconfighttps'] = 'Da biste koristili ovaj dodatak <br /> kao administrator >> Varijable >> Bezbednost >> HTTP bezbednost, proverite da li ste "<a href="{$a->url}"> loginhttps uključili.';
$string['adminconfighttpsgo'] = 'Idite na <a href="{$a->url}"> sigurnosnu stranu da bi oblikovali ovaj dodatak.';
$string['admincronsetup'] = 'Skript za održavanje cron.php nije pokretan bar 24 sata. <br />Cron mora biti omogućen ako želite da koristite mogućnosti zakazanog prihvatanja.<br /><b>Omogućite</b> \'Authorize.net dodatak\' i pravilno <b>podesite cron</b>; ili ponovo <b>uklonite oznaku sa an_review.</b><br />Ako onemogućite zakazano prihvatanje, transakcije će biti otkazane ukoliko ih ne pregledate u roku od 30 dana.<br />Označite <b>an_review</b> i upišite <b>\'0\' u polje an_capture_day</b> <br />ako želite <b>ručno</b> da prihvatite/odbijete uplate u roku od 30 dana.';
$string['adminemailexpiredsort'] = 'Kada se veći broj porudžbina na čekanju kojima uskoro ističe rok šalje predavačima putem e-pošte, koje od njih će biti istaknute kao važne?';
$string['adminemailexpiredsortcount'] = 'Broj porudžbina';
$string['adminemailexpiredsortsum'] = 'Ukupan iznos';
$string['adminemailexpsetting'] = '(0=onemogućavanje slanja e-pošte, podrazumevana vrednost=2, maksimalna vrednost=5)<br />(Podešavanja ručnog prihvatanja za slanje e-pošte: cron=omogućen, an_review=proveren, an_capture_day=0, an_emailexpired=1-5)';
$string['adminhelpcapturetitle'] = 'Dan zakazanog prihvatanja';
$string['adminhelpreviewtitle'] = 'Pregled porudžbine';
$string['adminneworder'] = 'Dragi administratore,

Primili ste novu porudžbinu koja čeka na prihvatanje:

Porudžbina broj: {$a->orderid}
Transakcija broj: {$a->transid}
Korisnik: {$a->user}
Kurs: {$a->course}
Iznos: {$a->amount}

OMOGUĆENO ZAKAZANO PRIHVATANjE?: {$a->acstatus}

Ako je omogućeno zakazano prihvatanje, kreditna kartica biće obrađena dana {$a->captureon} i korisnik će biti upisan na kurs, inače će porudžbina isteći dana {$a->expireon} i posle toga neće moći biti prihvaćena.

Možete i odmah prihvatiti/odbiti uplatu i ako želite upisati polaznika na kurs prateći sledeći link:
{$a->url}';
$string['adminnewordersubject'] = '{$a->course}: Nova porudžbina na čekanju: {$a->orderid}';
$string['adminpendingorders'] = 'Isključili ste mogućnost zakazanog prihvatanja.<br />Ukupno {$a->count} transakcija sa statusom \'Autorizovano/Čeka na prihvatanje\' biće poništena/o ukoliko ih ne potvrdite.<br />Da biste prihvatili/odbili uplate idite na stranicu <a href=\'{$a->url}\'>Upravljanje plaćanjem</a>.';
$string['adminteachermanagepay'] = 'Predavači mogu upravljati plaćanjem kursa.';
$string['allpendingorders'] = 'Sve narudžbine koje su u toku';
$string['amount'] = 'Iznos';
$string['anauthcode'] = 'Nabavite authcode';
$string['anauthcodedesc'] = 'Ako kreditna kartica korisnika ne može da bude prihvaćena direktno preko Interneta, nabavite autorizacioni kod telefonom od njegove banke.';
$string['anavs'] = 'Sistem za verifikaciju adrese';
$string['anavsdesc'] = 'Potvrdite ovde ako ste aktivirali \'Sistem za verifikaciju adrese\' (Address Verification System - AVS ) u okviru svog Authorize.Net naloga. Ovo zahteva  polja za adresu kao što su ulica, država, zemlja i poštanski kod, kada korisnik popunjava obrazac za plaćanje.';
$string['ancaptureday'] = 'Dan prihvatanja';
$string['ancapturedaydesc'] = 'Prihvatite kreditnu karticu automatski, osim ako predavač ili administrator ne pregledaju narudžbine unutar određenog broj dana. CRON MORA BITI OMOGUĆEN <br />(0 dana znači da će biti onemogućeno zakazano prihvatanje; takođe znači da će predavač ili administrator ručno pregledati narudžbinu. Transakcija će se otkazati ako onemogućite zakazano prihvatanje ili ukoliko ne pregledate transakciju u narednih 30 dana.)';
$string['anemailexpired'] = 'Obaveštenje o isticanju  roka';
$string['anemailexpireddesc'] = 'Ovo je korisno za \'ručno prihvatanje\'. Administratori će biti obavešteni odgovarajući broj dana pre nego što istekne rok narudžbina koje su na čekanju.';
$string['anemailexpiredteacher'] = 'Obaveštenje o isticanju  roka  - predavač';
$string['anemailexpiredteacherdesc'] = 'Ako ste omogućili ručno prihvatanje (vidi gore) i ako predavači mogu da upravljaju uplatama, onda će i oni biti obaveštavani o isticanju roka za narudžbine koje su na čekanju, Ovo će svim predavačima poslati e-poruku o broju narudžbina na čekanju koje će isteći.';
$string['anlogin'] = 'Authorize.net: Korisničko ime';
$string['anpassword'] = 'Authorize.net: Lozinka';
$string['anreferer'] = 'URL za preusmeravanje';
$string['anrefererdesc'] = 'Definišite URL referer za preusmeravanje ako ste to podesili na svom Authorize nalogu. To će poslati liniju "Prosleđivač: URL" u okviru Web zahteva.';
$string['anreview'] = 'Pregled';
$string['anreviewdesc'] = 'Pregled porudžbine pre obrade kreditne kartice';
$string['antestmode'] = 'Režim za testiranje';
$string['antestmodedesc'] = 'Pokreni transakciju u test režimu samo (novac neće biti prebačen)';
$string['antrankey'] = 'Authorize.net: Ključ za transakciju';
$string['approvedreview'] = 'Odobreni pregled';
$string['authcaptured'] = 'Autorizovano/Prihvaćeno';
$string['authcode'] = 'Kod za autorizaciju';
$string['authorize:config'] = 'Konfiguriši instancu za upis putem Authorize.Neta';
$string['authorize:manage'] = 'Upravljanje upisanim korisnicima';
$string['authorize:managepayments'] = 'Upravljanje uplatama';
$string['authorize:unenrol'] = 'Ispiši korisnike sa kursa';
$string['authorize:unenrolself'] = 'Ispiši sе sa kursa';
$string['authorize:uploadcsv'] = 'Postavi CSV  datoteku.';
$string['authorizedpendingcapture'] = 'Autorizovano/Čeka na prihvatanje';
$string['authorizeerror'] = 'Authorize.Net greška: {$a}';
$string['avsa'] = 'Adresa (ulica) se uklapa, ali ne i poštanski broj';
$string['avsb'] = 'Nisu date informacije o adresi';
$string['avse'] = 'Greška u sistemu za verifikaciju adresa';
$string['avsg'] = 'Banka koja je izdala karticu (van SAD-a)';
$string['avsn'] = 'Ne uklapa se ni adresa (ulica) ni poštanski broj';
$string['avsp'] = 'Sistem za verifikaciju adresa nije primenljiv';
$string['avsr'] = 'Ponovni pokušaj - Sistem nije dostupan ili je vreme isteklo';
$string['avsresult'] = 'AVS rezultat: {$a}';
$string['avss'] = 'Izdavač ne podržava ovu uslugu';
$string['avsu'] = 'Nisu dostupne informacije o adresi';
$string['avsw'] = 'Devetocifreni poštanski broj se uklapa, ali ne i adresa (ulica)';
$string['avsx'] = 'Adresa (ulica) i devetocifreni poštanski broj se uklapaju';
$string['avsy'] = 'Adresa (ulica) i petocifreni poštanski broj se uklapaju';
$string['avsz'] = 'Petocifreni poštanski broj se uklapa, ali ne i adresa (ulica)';
$string['canbecredit'] = 'Može biti refundirano do {$a->upto}';
$string['cancelled'] = 'Otkazano';
$string['capture'] = 'Prihvatanje';
$string['capturedpendingsettle'] = 'Prihvaćeno/Čeka na naplatu';
$string['capturedsettled'] = 'Prihvaćeno/Dogovoreno';
$string['captureyes'] = 'Kreditna kartica će biti prihvaćena i polaznik će biti upisan na kurs. Da li ste sigurni da to želite?';
$string['cccity'] = 'Mesto';
$string['ccexpire'] = 'Datum isteka važnosti kreditne kartice';
$string['ccexpired'] = 'Kreditna kartica je istekla';
$string['ccinvalid'] = 'Pogrešan broj kartice';
$string['cclastfour'] = 'poslednja četiri u CC polju';
$string['ccno'] = 'Broj kreditne kartice';
$string['ccstate'] = 'Država';
$string['cctype'] = 'Tip kreditne kartice';
$string['ccvv'] = 'Provera kreditne kartice';
$string['ccvvhelp'] = 'Pogledajte poleđinu kartice (poslednje 3 cifre)';
$string['choosemethod'] = 'Ukoliko znate pristupnu lozinku kursa unesite je;<br />u suprotnom morate da platite da biste upisali ovaj kurs.';
$string['chooseone'] = 'Popunite jedno ili oba polja';
$string['cost'] = 'Cena';
$string['costdefaultdesc'] = '<strong>U podešavanjima kursa, unesite -1</strong>u polje za cenu da biste koristili podrazumevani iznos.';
$string['currency'] = 'Valuta';
$string['cutofftime'] = 'Vreme prekida transakcije';
$string['cutofftimedesc'] = 'Vreme kada se kupe transakcije za naplatu. Kada je pokupljena poslednja transacija za naplatu?';
$string['dataentered'] = 'Uneti podaci';
$string['delete'] = 'Uništi';
$string['description'] = 'Authorize.net modul vam dozvoljava da postavite kurseve koji se plaćaju preko provajdera koji pružaju usluge plaćanja. Postoje dva načina da se postavi cena kursa: (1) cena na nivou sajta, podrazumevana za svaki kurs ili (2) podešavanjem svakog pojedinačnog kursa. Cena kursa ima prednost nad podrazumevanom cenom na nivou sajta.';
$string['echeckabacode'] = 'Bankovni ABA broj';
$string['echeckaccnum'] = 'Broj bankovnog računa';
$string['echeckacctype'] = 'Vrsta bankovnog računa';
$string['echeckbankname'] = 'Naziv banke';
$string['echeckbusinesschecking'] = 'Provera poslovanja';
$string['echeckchecking'] = 'Provera';
$string['echeckfirslasttname'] = 'Vlasnik bankovnog računa';
$string['echecksavings'] = 'Ušteđevina';
$string['enrolenddate'] = 'Datum završetka';
$string['enrolenddaterror'] = 'Datum završetka trajanja upisa na kurs ne može biti raniji od datuma njegovog početka';
$string['enrolname'] = 'Authorize.net gateway za plaćanje';
$string['enrolperiod'] = 'Period trajanja upisa na kurs';
$string['enrolstartdate'] = 'Datum početka';
$string['expired'] = 'Isteklo';
$string['expiremonth'] = 'Mesec isteka';
$string['expireyear'] = 'Godina isteka';
$string['firstnameoncard'] = 'Ime na kartici';
$string['haveauthcode'] = 'Već imam kod za autorizaciju.';
$string['howmuch'] = 'Koliko?';
$string['httpsrequired'] = 'Žao nam je, ali Vaš zahtev trenutno ne može biti obrađen. Konfiguracija ovog sajta ne može da bude pravilno podešena<br /><br />Molimo ne unosite broj Vaše kreditne kartice ukoliko ne vidite žuti katanac na dnu prozora vašeg Web čitača. Ako  se ovaj simbol pojavi, to znači da stranica šifrira sve podatke koji se razmenjuju između klijenta i servera. Na taj način su informacije zaštićene tokom transakcija između dva računara, pa broj Vaše kreditne kartice ne može biti presretnut ili ukraden na Internetu.';
$string['invalidaba'] = 'Pogrešan ABA broj';
$string['invalidaccnum'] = 'Pogrešan broj računa';
$string['invalidacctype'] = 'Pogrešan tip računa';
$string['isbusinesschecking'] = 'Da li se proverava poslovanje?';
$string['lastnameoncard'] = 'Prezime na kartici';
$string['logindesc'] = 'Ova opcija mora biti uključena. <br /><br />Molimo proverite da li ste uključili <a href="{$a->url}">loginhttps</a> u Administracija >> Promenljive >> Bezbednost.<br /><br />Uključivanjem ove opcije postići ćete to da Moodle koristi sigurnu https konekciju samo za stranica za pristup sistemu i uplate.';
$string['logininfo'] = 'Kada konfigurišete svoj Authorize.Net nalog, korisničko ime je neophodno, a takođe  morate uneti,<strong>bilo</strong> ključ transakcije<strong>ili</stron>
lozinku u odgovarajuće polje. Preporučujemo da, zbog bezbednosnih razloga, unesete ključ transakcije.';
$string['messageprovider:authorize_enrolment'] = 'Poruke o upisu putem Authorize.Neta';
$string['methodcc'] = 'Kreditna kartica';
$string['methodccdesc'] = 'Izaberite kreditnu karticu i tipove koji se prihvataju';
$string['methodecheck'] = 'eCheck (ACH)';
$string['methodecheckdesc'] = 'Izaberite eCheck i tipove koji se prihvataju';
$string['missingaba'] = 'Nedostaje ABA broj';
$string['missingaddress'] = 'Nedostaje adresa';
$string['missingbankname'] = 'Nedostaje naziv banke';
$string['missingcc'] = 'Nedostaje broj kreditne kartice';
$string['missingccauthcode'] = 'Nedostaje kod za autorizaciju.';
$string['missingccexpiremonth'] = 'Nedostaje mesec isteka';
$string['missingccexpireyear'] = 'Nedostaje godina isteka';
$string['missingcctype'] = 'Nedostaje tip kreditne kartice';
$string['missingcvv'] = 'Nedostaje verifikacioni broj';
$string['missingzip'] = 'Nedostaje poštanski broj';
$string['mypaymentsonly'] = 'Prikaži samo moje plaćanje.';
$string['nameoncard'] = 'Ime na kartici';
$string['new'] = 'Novo';
$string['nocost'] = 'Nema troškova za upis na ovaj kurs preko Authorize.Neta!';
$string['noreturns'] = 'Bez povraćaja novca!';
$string['notsettled'] = 'Nije utvrđeno';
$string['orderdetails'] = 'Detalji porudžbine';
$string['orderid'] = 'ID porudžbine';
$string['paymentmanagement'] = 'Upravljanje plaćanjem';
$string['paymentmethod'] = 'Način plaćanja';
$string['paymentpending'] = 'Vaša uplata za ovaj kurs, pod rednim brojem {$a->orderid}, čeka na prihvatanje. Pogledajte <a href=\'{$a->url}\'>Detalji porudžbine</a>.';
$string['pendingecheckemail'] = 'Poštovani direktore,

Trenutno {$a->count} echecks čekaju na prihvatanje, neophodno je da postavite csv datoteku da bi se korisnici prijavili.';
$string['pendingechecksubject'] = '{$a->course}: eChecks čekaju na prihvatanje ({$a->count})';
$string['pendingordersemail'] = 'Dragi administratore,

{$a->pending} transakcija koje čekaju na prihvatanje za kurs "{$a->course}" će isteći ukoliko ne prihvatite uplate u roku od {$a->days} dana.

Ova poruka Vam se šalje kao upozorenje, jer niste omogućili zakazano prihvatanje.
To znači da ručno morate da prihvatite ili odbijete svaku uplatu.

Da biste prihvatili/odbili uplate na čekanju idite na:
{$a->url}

Da biste omogućili zakazano prihvatanje, što bi značilo da više ne biste dobijali ovakve poruke upozorenja, idite na:

{$a->enrolurl}';
$string['pendingordersemailteacher'] = 'Dragi predavaču,

{$a->pending} transakcija ukupne vrednosti {$a->currency} {$a->sumcost} za kurs "{$a->course}"
će isteći ukoliko ne prihvatite uplate u roku od {$a->days} dana.

Morate ručno da prihvatate ili odbijate uplate jer administrator nije omogućio zakazano prihvatanje.

{$a->url}';
$string['pendingorderssubject'] = 'UPOZORENJE: {$a->course}, {$a->pending} porudžbina će isteći u roku od {$a->days} dana.';
$string['pluginname'] = 'Authorize.Net';
$string['reason11'] = 'Predat je duplikat transakcije.';
$string['reason13'] = 'Trgovački identifikator korisničkog imena nije ispravan ili taj nalog nije aktivan.';
$string['reason16'] = 'Transakcija nije pronađena.';
$string['reason17'] = 'Trgovac ne prihvata ovaj tip kreditne kartice.';
$string['reason245'] = 'Ovaj eCheck tip nije dozvoljen kad se koristi forma za plaćanje podržana mrežnim prolazom.';
$string['reason246'] = 'Ovaj eCheck tip nije dozvoljen.';
$string['reason27'] = 'Transakcija je rezultovala AVS neslaganjem. Adresa koja je data se ne slaže sa adresom za slanje računa vlasnika kartice.';
$string['reason28'] = 'Trgovac ne prihvata ovaj tip kreditne kartice.';
$string['reason30'] = 'Konfiguracija sa procesorom nije validna. Pozovite davaoca trgovinskih usluga.';
$string['reason39'] = 'Dostavljena šifra valute nije validna, nije podržana, nije dozvoljena za ovog trgovca ili pak nema zadat kurs.';
$string['reason43'] = 'Trgovac je pogrešno podešen pri procesoru. Pozovite davaoca trgovinskih usluga.';
$string['reason44'] = 'Ova transakcija je odbijena. Greška filtera kôda kreditne kartice!';
$string['reason45'] = 'Ova transakcija je odbijena. Greška filtera kôda kreditne  kartice/sistema za verifikaciju adresa.';
$string['reason47'] = 'Zahtevani iznos za naplatu ne sme biti veći od originalno odobrenog iznosa.';
$string['reason5'] = 'Potreban je validan iznos.';
$string['reason50'] = 'Transakcija čeka na naplatu i ne može biti refundirana.';
$string['reason51'] = 'Suma svih kredita za ovu transakciju veća je od vrednosti originalne transakcije.';
$string['reason54'] = 'Referencirana transakcija ne ispunjava uslove za izdavanje kredita.';
$string['reason55'] = 'Suma kredita za referenciranu transakciju bi prešla originalni debitni iznos.';
$string['reason56'] = 'Ovaj trgovac prihvata samo eCheck (ACH) transakcije; transakcije kreditnim karticama se ne prihvataju.';
$string['refund'] = 'Refundiranje';
$string['refunded'] = 'Refundirano';
$string['returns'] = 'Povraćaji';
$string['reviewfailed'] = 'Pregled nije uspeo';
$string['reviewnotify'] = 'Vaša uplata će biti pregledana. Očekujte e-poruku od Vašeg predavača u roku od nekoliko dana.';
$string['sendpaymentbutton'] = 'Pošalji uplatu';
$string['settled'] = 'Dogovoreno';
$string['settlementdate'] = 'Datum poravnanja (naplate)';
$string['shopper'] = 'Kupac';
$string['status'] = 'Dozvoli upise putem Autorize.Neta';
$string['subvoidyes'] = 'Refundirana transakcija {$a->transid} će biti poništena i na vaš račun će biti vraćen novac u iznosu od {$a->amount}. Da li ste sigurni da želite da nastavite?';
$string['tested'] = 'Testirano';
$string['testmode'] = '[REŽIM ZA TESTIRANJE]';
$string['testwarning'] = 'Izgleda da Prihvatanje/Poništavanje/Refundiranje rade u režimu za testiranje, ali nijedan zapis nije ažuriran ili umetnut u bazu podataka.';
$string['transid'] = 'Identifikator transakcije';
$string['underreview'] = 'U procesu pregleda';
$string['unenrolselfconfirm'] = 'Da li stvarno želite da se ispišete sa kursa "{$a}"?';
$string['unenrolstudent'] = 'Ispis polaznika?';
$string['uploadcsv'] = 'Postavljanje CSV datoteke';
$string['usingccmethod'] = 'Greška pri korišćenju opcije <a href="{$a->url}"><strong>Kreditna kartica</strong></a>';
$string['usingecheckmethod'] = 'Greška pri korišćenju opcije <a href="{$a->url}"><strong>eCheck</strong></a>';
$string['verifyaccount'] = 'Proverite svoj Authorize.Net nalog';
$string['verifyaccountresult'] = '<b>Rezultat provere:</b> {$a}';
$string['void'] = 'Ništa';
$string['voidyes'] = 'Transakcija će biti otkazana. Da li ste sigurni da to želite?';
$string['welcometocoursesemail'] = 'Poštovani polazniče,

Hvala Vam za Vaše uplate. Upisali ste se na sledeće kurseve:

{$a->courses}

Možete pogledati detaljne informacije o obavljenoj uplati ili urediti svoj korisnički profil:

{$a->paymenturl}
{$a->profileurl}';
$string['youcantdo'] = 'Ne možete izvršiti ovu akciju: {$a->action}';
$string['zipcode'] = 'Poštanski broj';
