<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'organizer', language 'it', version '3.10'.
 *
 * @package     organizer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Error'] = 'Errore';
$string['Info'] = 'Informazioni';
$string['Warning'] = 'Attenzione';
$string['absolutedeadline'] = 'Fine registrazione';
$string['absolutedeadline_help'] = 'Seleziona questo per definire il tempo dopo il quale non sono possibili ulteriori azioni dello studente.';
$string['actionlink_delete'] = 'Elimina';
$string['actionlink_edit'] = 'Modifica';
$string['actionlink_eval'] = 'Voto';
$string['actionlink_print'] = 'Stampa';
$string['actions'] = 'Azione';
$string['actions_help'] = 'Azione da intraprendere.';
$string['addappointment'] = 'Aggiungi appuntamento';
$string['addslots_placesinfo'] = 'Questa azione creerà {$a->numplaces} nuovi posti possibili, per un totale di {$a->totalplaces} posti possibili per {$a->numstudents} studenti.';
$string['addslots_placesinfo_group'] = 'Questa azione creerà {$a->numplaces} nuovi posti possibili, per un totale di {$a->totalplaces} posti possibili per i gruppi {$a->numgroups}.';
$string['allowcreationofpasttimeslots'] = 'Creazione delle fasce orarie passate';
$string['allowedprofilefieldsprint'] = 'Campi del profilo utente consentiti';
$string['allowedprofilefieldsprint2'] = 'Campi del profilo utente consentiti per la stampa di singoli slot dell\'organizzatore';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'I dettagli dell\'organizzatore e il modulo di registrazione saranno disponibili da <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Inizio registrazione';
$string['allowsubmissionsfromdate_help'] = 'Seleziona questo se vuoi rendere questo organizzatore disponibile per gli studenti dopo un certo momento.';
$string['allowsubmissionsfromdatesummary'] = 'Questo organizzatore accetterà le registrazioni da <strong>{$a}</strong>';
$string['allowsubmissionstodate'] = 'Fine registrazione';
$string['alwaysshowdescription'] = 'Visualizza sempre la descrizione';
$string['alwaysshowdescription_help'] = 'Se disabilitato, la descrizione del compito sopra sarà visibile agli studenti solo alla data di "Inizio iscrizione".';
$string['applicant'] = 'Questa è la persona che ha registrato il gruppo';
$string['appointment_reminder_student:fullmessage'] = 'Ciao {$a->nome destinatario}! Come parte del corso {$a->courseid} {$a->coursefullname}, hai un appuntamento {$a->sendername} il {$a->date} alle {$a->time} in { $a->location}. Sistema di messaggistica Moodle';
$string['appointment_reminder_student:group:fullmessage'] = 'Ciao {$a->nome destinatario}! Come parte del corso {$a->courseid} {$a->coursefullname}, hai un appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['appointment_reminder_student:group:smallmessage'] = 'Hai un appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} in {$a->location}.';
$string['appointment_reminder_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Promemoria appuntamento di gruppo';
$string['appointment_reminder_student:smallmessage'] = 'Hai un appuntamento {$a->sendername} il {$a->date} alle {$a->time} in {$a->location}.';
$string['appointment_reminder_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Promemoria appuntamento';
$string['appointment_reminder_teacher:digest:fullmessage'] = 'Ciao {$a->receivername}!

Domani hai i seguenti appuntamenti:

{$a->digest}

Moodle Messaging System';
$string['appointment_reminder_teacher:digest:smallmessage'] = 'Hai ricevuto un messaggio riassuntivo dei tuoi appuntamenti di domani.';
$string['appointment_reminder_teacher:digest:subject'] = 'Riassunto degli appuntamenti';
$string['appointment_reminder_teacher:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, hai un appuntamento con gli studenti il {$a->date} alle {$a->time} in {$a->location }. Sistema di messaggistica Moodle';
$string['appointment_reminder_teacher:group:digest:fullmessage'] = 'Ciao {$a->receivername}! Domani hai i seguenti appuntamenti: {$a->digest} Moodle Messaging System';
$string['appointment_reminder_teacher:group:digest:smallmessage'] = 'Hai ricevuto un messaggio riassuntivo dei tuoi appuntamenti di domani.';
$string['appointment_reminder_teacher:group:digest:subject'] = 'Appuntamento sommario';
$string['appointment_reminder_teacher:smallmessage'] = 'Hai un appuntamento con gli studenti il {$a->date} alle {$a->time} in {$a->location}.';
$string['appointment_reminder_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Promemoria appuntamento';
$string['appointmentcomments'] = 'Commenti';
$string['appointmentcomments_help'] = 'Informazioni addizionali circa gli appuntamenti possono essere aggiunte qui.';
$string['appointmentdatetime'] = 'Data e Ora';
$string['assign'] = 'Assegna';
$string['assign_notify_student:fullmessage'] = 'Ciao {$a->receivername}! Nell\'ambito del corso {$a->courseid} {$a->coursefullname} è stato assegnato un appuntamento con {$a->slot_teacher} il {$a->date} alle {$a->time} a te da {$a->sendername}. Insegnante: {$a->slot_teacher} Luogo: {$a->slot_location} Data: {$a->date} alle {$a->time} Sistema di messaggistica Moodle';
$string['assign_notify_student:group:fullmessage'] = 'Ciao {$a->receivername}! Nell\'ambito del corso {$a->courseid} {$a->coursefullname} è stato assegnato un appuntamento con {$a->slot_teacher} il {$a->date} alle {$a->time} al tuo gruppo {$a->groupname} da {$a->sendername}. Insegnante: {$a->slot_teacher} Luogo: {$a->slot_location} Data: {$a->date} alle {$a->time} Sistema di messaggistica Moodle';
$string['assign_notify_student:group:smallmessage'] = 'Un appuntamento con {$a->slot_teacher} il {$a->date} alle {$a->time} è stato assegnato al tuo gruppo {$a->groupname} da {$a->sendername}.';
$string['assign_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento assegnato dal docente';
$string['assign_notify_student:smallmessage'] = 'Un appuntamento con {$a->slot_teacher} il {$a->date} alle {$a->time} ti è stato assegnato da {$a->sendername}.';
$string['assign_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento assegnato dal docente';
$string['assign_notify_teacher:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, è stato assegnato un appuntamento con {$a->participantname} il {$a->date} alle {$a->time} a te da {$a->sendername}. Partecipante: {$a->participantname} Località: {$a->slot_location} Data: {$a->date} alle {$a->time} Sistema di messaggistica Moodle';
$string['assign_notify_teacher:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, è stato fissato un appuntamento con il gruppo {$a->groupname} il {$a->date} alle {$a->time} assegnato a te da {$a->sendername}. Gruppo: {$a->groupname} Località: {$a->slot_location} Data: {$a->date} alle {$a->time} Moodle Messaging System';
$string['assign_notify_teacher:group:smallmessage'] = 'Un appuntamento con il gruppo {$a->groupname} il {$a->date} alle {$a->time} ti è stato assegnato da {$a->sendername}.';
$string['assign_notify_teacher:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento assegnato';
$string['assign_notify_teacher:smallmessage'] = 'Un appuntamento con {$a->sendername} il {$a->date} alle {$a->time} è stato assegnato da te da {$a->sendername}';
$string['assign_notify_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento assegnato';
$string['assign_title'] = 'Assegna appuntamento';
$string['assignsuccess'] = 'La fascia oraria è stata assegnata con successo e il/i partecipante/i è stato informato.';
$string['assignsuccessnotsent'] = 'La fascia oraria è stata assegnata con successo MA il/i partecipante/i NON è stato avvisato.';
$string['atlocation'] = 'a';
$string['attended'] = 'frequentato';
$string['auth'] = 'Metodo di autenticazione';
$string['availability'] = 'Disponibilità';
$string['availablefrom'] = 'Applicazioni possibili da';
$string['availablefrom_help'] = 'Imposta l\'intervallo di tempo entro il quale gli studenti potranno registrarsi per queste fasce orarie. In alternativa, seleziona "Inizia ora" per abilitare immediatamente la registrazione.';
$string['availablegrouplist'] = 'Gruppi disponibili';
$string['availableslotsfor'] = 'fasce orarie disponibili per';
$string['back'] = 'Indietro';
$string['btn_add'] = 'Aggiungi nuove fasce orarie';
$string['btn_assign'] = 'Assegna fascia oraria';
$string['btn_comment'] = 'Modifica commento';
$string['btn_delete'] = 'Rimuovi fasce orarie selezionate';
$string['btn_deletesingle'] = 'Rimuovi la fascia oraria selezionata';
$string['btn_edit'] = 'Modifica le fasce orarie selezionate';
$string['btn_editsingle'] = 'Modifica fascia oraria selezionata';
$string['btn_eval'] = 'Valutazione fasce orarie selezionate';
$string['btn_eval_short'] = 'Voto';
$string['btn_evalsingle'] = 'Valutazione fascia oraria selezionata';
$string['btn_print'] = 'Stampa fasce orarie selezionate';
$string['btn_printsingle'] = 'Stampa fascia oraria selezionata';
$string['btn_queue'] = 'Coda';
$string['btn_reeval'] = 'Rivaluta';
$string['btn_register'] = 'Registrati';
$string['btn_remind'] = 'Invia promemoria';
$string['btn_reregister'] = 'Registrati di nuovo';
$string['btn_save'] = 'Salva commento';
$string['btn_send'] = 'Invia';
$string['btn_sendall'] = 'Invia promemoria a tutti gli studenti senza appuntamento';
$string['btn_start'] = 'Inizia';
$string['btn_unqueue'] = 'Rimuovi dalla coda';
$string['btn_unregister'] = 'Annulla Registrazione';
$string['calendarsettings'] = 'Impostazioni calendario';
$string['can_reregister'] = 'Puoi registrarti nuovamente ad un altro appuntamento.';
$string['cannot_eval'] = 'Impossibile valutare, lo studente ha un';
$string['changegradewarning'] = 'Questo organizzatore ha valutato gli appuntamenti e la modifica delle impostazioni del voto non ricalcolerà automaticamente i voti esistenti. Se desideri modificare il voto, devi riclassificare tutti gli appuntamenti esistenti.';
$string['collision'] = 'Avvertimento! Rilevata collisione con i seguenti eventi e/o Fasce Orarie:';
$string['configabsolutedeadline'] = 'L\'offset predefinito del selettore di data e ora dalla data e dall\'ora correnti.';
$string['configahead'] = 'avanti';
$string['configallowcreationofpasttimeslots'] = 'È consentito creare fasce orarie passate?';
$string['configday'] = 'Giorno';
$string['configdays'] = 'Giorno';
$string['configdigest'] = 'Invia il riepilogo degli appuntamenti del giorno successivo al docente.';
$string['configdigest_label'] = 'Invia la sintesi dell\'appuntamento agli insegnanti';
$string['configdontsend'] = 'Non inviare';
$string['configemailteachers'] = 'Invia notifiche e-mail agli insegnanti sulle modifiche allo stato di registrazione.';
$string['configemailteachers_label'] = 'Invia notifiche e-mail agli insegnanti';
$string['confighour'] = 'Ora';
$string['confighours'] = 'Ore';
$string['configintro'] = 'I valori impostati qui definiscono i valori predefiniti utilizzati nel modulo delle impostazioni quando si crea un nuovo organizzatore.';
$string['configlocationlink'] = 'Il collegamento a un motore di ricerca utilizzato per mostrare la strada per la posizione. Inserisci $searchstring nell\'URL in cui va la query.';
$string['configlocationslist'] = 'Posizioni per il campo di completamento automatico';
$string['configlocationslist_desc'] = 'Ogni località deve essere inserita in una riga separata!';
$string['configmaximumgrade'] = 'Imposta il valore predefinito selezionato nel campo del voto durante la creazione di un nuovo organizzatore. Questo è il voto massimo attribuibile a uno studente per il suo appuntamento.';
$string['configminute'] = 'minuto';
$string['configminutes'] = 'minuti';
$string['configmonth'] = 'mese';
$string['configmonths'] = 'mesi';
$string['confignever'] = 'Mai';
$string['configrelativedeadline'] = 'L\'orario predefinito prima di un appuntamento in cui i partecipanti dovrebbero esserne informati.';
$string['configrequiremodintro'] = 'Disattiva questa opzione se non vuoi obbligare gli utenti a inserire la descrizione di ogni attività.';
$string['configsingleslotprintfield'] = 'campo utente da stampare quando viene stampato un singolo slot';
$string['configweek'] = 'settimana';
$string['configweeks'] = 'settimane';
$string['configyear'] = 'anno';
$string['confirm_conflicts'] = 'Sei sicuro di voler ignorare le collisioni e di voler creare le fasce orarie?';
$string['confirm_delete'] = 'Cancella';
$string['confirm_organizer_remind_all'] = 'Invia';
$string['create'] = 'Crea';
$string['created'] = 'Creato';
$string['createsubmit'] = 'Crea Fascia Oraria';
$string['crontaskname'] = 'Cron job dell\'organizzatore';
$string['datapreviewtitle'] = 'Anteprima Dati';
$string['datapreviewtitle_help'] = 'Fare clic su [+] o [-] per mostrare o nascondere le colonne.';
$string['datetime'] = 'Appuntamento';
$string['datetime_help'] = 'Data e ora della fascia oraria.';
$string['day'] = 'giorno';
$string['day_0'] = 'Lunedì';
$string['day_1'] = 'Martedì';
$string['day_2'] = 'Mercoledì';
$string['day_3'] = 'Giovedì';
$string['day_4'] = 'Venerdì';
$string['day_5'] = 'Sabato';
$string['day_6'] = 'Domenica';
$string['day_pl'] = 'giorni';
$string['defaultsingleslotprintfields'] = 'Campi del profilo utente predefinito per slot di stampa singolo';
$string['delete_organizer_grades'] = 'Elimina i voti di tutti gli organizers';
$string['deleteheader'] = 'Elimina le seguenti fasce orarie:';
$string['deletekeep'] = 'I seguenti appuntamenti verranno annullati. Gli studenti registrati verranno avvisati e gli slot verranno cancellati';
$string['deletenoslots'] = 'Nessuna fascia oraria cancellabile selezionata';
$string['deleteorganizergrades'] = 'Elimina i voti dal registro dei voti';
$string['details'] = 'Dettagli Stato';
$string['details_help'] = 'Stato corrente di questa fascia oraria.';
$string['downloadfile'] = 'Scarica file';
$string['duedate'] = 'Data di Scadenza';
$string['duedateerror'] = 'La scadenza assoluta non può essere fissata prima della data di disponibilità!';
$string['duration'] = 'Durata';
$string['duration_help'] = 'Definisce la durata degli appuntamenti. Tutti i time frame definiti verranno suddivisi in fasce orarie della durata qui definita. L\'eventuale tempo rimanente rimarrà inutilizzato (ad esempio, se l\'intervallo di tempo è lungo 40 minuti e la durata è impostata su 15 minuti, ci saranno 2 fasce orarie in totale con 10 minuti in più non utilizzati).';
$string['edit_notify_student:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, i dettagli dell\'appuntamento {$a->sendername} il {$a->date} alle {$a->time} sono stati cambiato. Insegnante: {$a->slot_teacher} Località: {$a->slot_location} Max. partecipanti: {$a->slot_maxparticipants} Commenti: {$a->slot_comments} Moodle Messaging System';
$string['edit_notify_student:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, i dettagli dell\'appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} sono stati cambiato. Insegnante: {$a->slot_teacher} Località: {$a->slot_location} Max. partecipanti: {$a->slot_maxparticipants}';
$string['edit_notify_student:group:smallmessage'] = 'I dettagli dell\'appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} sono stati modificati.';
$string['edit_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - I dettagli dell\'appuntamento sono cambiati';
$string['edit_notify_student:smallmessage'] = 'I dettagli dell\'appuntamento {$a->sendername} il {$a->date} alle {$a->time} sono stati modificati.';
$string['edit_notify_teacher:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, i dettagli della fascia oraria del {$a->date} alle {$a->time} sono stati modificati da {$a ->nomemittente}. Insegnante: {$a->slot_teacher} Località: {$a->slot_location} Max. partecipanti: {$a->slot_maxparticipants} Commenti: {$a->slot_comments} Moodle Messaging System';
$string['edit_notify_teacher:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, i dettagli della fascia oraria del {$a->date} alle {$a->time} sono stati modificati da {$a ->nomemittente}. Insegnante: {$a->slot_teacher} Località: {$a->slot_location} Max. partecipanti: {$a->slot_maxparticipants} Commenti: {$a->slot_comments} Moodle Messaging System';
$string['edit_notify_teacher:group:smallmessage'] = 'I dettagli della fascia oraria del {$a->date} alle {$a->time} sono stati modificati da {$a->sendername}.';
$string['edit_notify_teacher:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - I dettagli dell\'appuntamento sono cambiati';
$string['edit_notify_teacher:smallmessage'] = 'I dettagli della fascia oraria del {$a->date} alle {$a->time} sono stati modificati da {$a->sendername}.';
$string['edit_notify_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - I dettagli dell\'appuntamento sono cambiati';
$string['edit_submit'] = 'Conferma modifiche';
$string['emailteachers'] = 'Invia notifiche e-mail agli insegnanti';
$string['emailteachers_help'] = 'Le notifiche per gli insegnanti quando uno studente registra la prima volta per una fascia oraria sono normalmente soppresse per evitare lo spam. Selezionare questa opzione per consentire all\'organizzatore di inviare tali notifiche e-mail agli insegnanti. Tieni presente che le notifiche per l\'annullamento della registrazione e la modifica degli fasce orarie vengono sempre inviate.';
$string['enableprintslotuserfields'] = 'Consenti modifica nei campi del profilo utente';
$string['enableprintslotuserfieldsdesc'] = 'Controlla se gli insegnanti sono autorizzati a modificare i campi del profilo utente selezionato predefinito di seguito';
$string['err_availablefromearly'] = 'Questa data non può essere impostata dopo la data di inizio!';
$string['err_availablefromlate'] = 'Questa data non può essere impostata dopo la data di fine!';
$string['err_availablepastdeadline'] = 'Questa fascia oraria non può essere reso disponibile oltre la scadenza dello scheduler ({$a->deadline})!';
$string['err_collision'] = 'Questo frame è in collisione con altri frame:';
$string['err_comments'] = 'Devi inserire una descrizione!';
$string['err_enddate'] = 'La data di fine non può essere impostata prima della data di inizio!';
$string['err_fromto'] = 'L\'ora di fine non può essere impostata prima dell\'ora di inizio!';
$string['err_fullminute'] = 'La durata deve essere di un minuto intero.';
$string['err_fullminutegap'] = 'Il divario deve essere di un minuto intero.';
$string['err_isgrouporganizer_app'] = 'Non è possibile modificare la modalità di gruppo poiché esistono già appuntamenti programmati in questo organizer!';
$string['err_location'] = 'Devi inserire un lougo!';
$string['err_noslots'] = 'Non sono stati selezionate fasce orarie!';
$string['err_posint'] = 'Devi inserire un numero intero positivo!';
$string['err_startdate'] = 'La data di inizio non può essere impostata prima della data odierna ({$a->now})!';
$string['eval_allow_new_appointments'] = 'Consenti la riconferma';
$string['eval_attended'] = 'Frequentato';
$string['eval_grade'] = 'Voto';
$string['eval_header'] = 'Fascia oraria selezionata';
$string['eval_no_participants'] = 'Questa fascia oraria non ha avuto partecipanti';
$string['eval_not_occured'] = 'Questa fascia oraria non si è ancora verificata';
$string['eval_notify_newappointment:student:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento {$a->sendername} il {$a->date} alle {$a->time} in {$a ->location} è stato valutato. Gli insegnanti del corso ti consentono di registrarti nuovamente a qualsiasi slot disponibile nell\'organizzatore {$a->organizername}. Sistema di messaggistica MoodleHello {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento {$a->sendername} il {$a->date} alle {$a->time} in {$a ->location} è stata valutata. Gli insegnanti del corso ti consentono di registrarti nuovamente a qualsiasi slot disponibile nell\'organizzatore {$a->organizername}. Sistema di messaggistica Moodle';
$string['eval_notify_newappointment:student:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} in {$a ->location} è stato valutato. Gli insegnanti del corso ti consentono di registrarti nuovamente a qualsiasi slot disponibile nell\'organizzatore {$a->organizername}. Sistema di messaggistica MoodleHello {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento {$a->sendername} il {$a->date} alle {$a->time} in {$a ->location} è stata valutata. Gli insegnanti del corso ti consentono di registrarti nuovamente a qualsiasi slot disponibile nell\'organizzatore {$a->organizername}. Sistema di messaggistica Moodle';
$string['eval_notify_newappointment:student:group:smallmessage'] = 'Il tuo appuntamento di gruppo il {$a->date} alle {$a->time} in {$a->location} è stato valutato.';
$string['eval_notify_newappointment:student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento valutato';
$string['eval_notify_newappointment:student:smallmessage'] = 'Il tuo appuntamento il {$a->date} alle {$a->time} in {$a->location} è stato valutato.';
$string['eval_notify_newappointment:student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento valutato';
$string['eval_notify_student:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento {$a->sendername} il {$a->date} alle {$a->time} in {$a ->location} è stata valutata. Sistema di messaggistica Moodle';
$string['eval_notify_student:group:fullmessage'] = 'Ciao {$a->receivername}!Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo appuntamento di gruppo {$a->sendername} il {$a->date} alle {$a->time} a {$ a->location} è stato valutato. Sistema di messaggistica Moodle';
$string['eval_notify_student:group:smallmessage'] = 'Il tuo appuntamento di gruppo il {$a->date} alle {$a->time} in {$a->location} è stato valutato.';
$string['eval_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento valutato';
$string['eval_notify_student:smallmessage'] = 'Il tuo appuntamento il {$a->date} alle {$a->time} in {$a->location} è stato valutato.';
$string['eval_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento valutato';
$string['evaluate'] = 'Valutare';
$string['event'] = 'Evento del calendario';
$string['eventappointmentadded'] = 'Studente iscritto a una fascia oraria.';
$string['eventappointmentassigned'] = 'L\'appuntamento è stato assegnato dal docente.';
$string['eventappointmentcommented'] = 'L\'appuntamento è stato commentato.';
$string['eventappointmentevaluated'] = 'L\'appuntamento è stato valutato.';
$string['eventappointmentlistprinted'] = 'L\'elenco degli appuntamenti è stato stampato.';
$string['eventappointmentremindersent'] = 'Promemoria appuntamento inviato.';
$string['eventappointmentremoved'] = 'Studente non registrato da una fascia oraria.';
$string['eventappwith:group'] = 'Appuntamento di gruppo';
$string['eventappwith:single'] = 'Appuntamento';
$string['eventnoparticipants'] = 'Nessun Partecipante';
$string['eventqueueadded'] = 'Aggiunto alla lista d\'attesa';
$string['eventqueueremoved'] = 'Rimosso dalla lista d\'attesa';
$string['eventregistrationsviewed'] = 'Scheda Iscrizioni visualizzata.';
$string['eventslotcreated'] = 'Nuovo fascia oraria creata.';
$string['eventslotdeleted'] = 'fascia oraria cancellata.';
$string['eventslotupdated'] = 'fascia oraria aggiornata.';
$string['eventslotviewed'] = 'fascia oraria visualizzata.';
$string['eventteacheranonymous'] = 'un docente anonimo';
$string['eventtemplate'] = '{$a->courselink} / {$a->organizerlink}: {$a->appwith} {$a->with} {$a->partecipanti}<br />Località: {$a->location} <br />';
$string['eventtemplatecomment'] = 'Commento:<br />{$a}<br />';
$string['eventtemplatewithoutlinks'] = '{$a->coursename} / {$a->organizername}: {$a->appwith} {$a->with} {$a->partecipants}<br />Località: {$a->location} <br />
mod_organizer/eventtemplatesenza collegamenti';
$string['eventtitle'] = '{$a->coursename} / {$a->organizername}: {$a->appwith}';
$string['eventwith'] = 'con';
$string['eventwithout'] = 'con';
$string['exportsettings'] = 'Impostazioni d\'Esportazione';
$string['filtertable'] = '"Ricerca in questa tabella"';
$string['filtertable_help'] = 'Cerca in queste fasce orarie le stringhe reciproche qui.';
$string['finalgrade'] = 'Questo valore è stato impostato nel registro dei voti e non può essere modificato con l\'organizzatore.';
$string['font_large'] = 'largo';
$string['font_medium'] = 'medio';
$string['font_small'] = 'piccolo';
$string['format'] = 'Formato';
$string['gap'] = 'Divario';
$string['gap_help'] = 'Definisce lo spazio tra due appuntamenti.';
$string['grade'] = 'Voto massimo';
$string['grade_help'] = 'Definisce il numero massimo di punti che può essere assegnato per qualsiasi appuntamento che può essere valutato.';
$string['group_registration_notify:student:queue:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha aggiunto il tuo gruppo {$a->groupname} alla lista d\'attesa della fascia oraria del {$ a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:queue:group:smallmessage'] = '{$a->sendername} ha aggiunto il tuo gruppo {$a->groupname} alla lista d\'attesa della fascia oraria il {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:queue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo in lista d\'attesa';
$string['group_registration_notify:student:register:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha registrato il tuo gruppo {$a->groupname} nella fascia oraria del {$a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:register:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha registrato il tuo gruppo {$a->groupname} nella fascia oraria del {$a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:register:group:smallmessage'] = '{$a->sendername} ha registrato il tuo gruppo {$a->groupname} nella fascia oraria del {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:register:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo registrato';
$string['group_registration_notify:student:register:smallmessage'] = '{$a->sendername} ha registrato il tuo gruppo {$a->groupname} nella fascia oraria del {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:register:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo registrato';
$string['group_registration_notify:student:reregister:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha registrato nuovamente il tuo gruppo {$a->groupname} in una nuova fascia oraria il {$a ->data} in {$a->ora} in {$a->posizione}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:reregister:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha registrato nuovamente il tuo gruppo {$a->groupname} in una nuova fascia oraria il {$a ->data} in {$a->ora} in {$a->posizione}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:reregister:group:smallmessage'] = '{$a->sendername} ha registrato nuovamente il tuo gruppo {$a->groupname} in una nuova fascia oraria il {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:reregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo ri-registrato';
$string['group_registration_notify:student:reregister:smallmessage'] = '{$a->sendername} ha registrato nuovamente il tuo gruppo {$a->groupname} in una nuova fascia oraria il {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:reregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo ri-registrato';
$string['group_registration_notify:student:unqueue:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha rimosso il tuo gruppo {$a->groupname} dalla lista di attesa della fascia oraria del {$ a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:unqueue:group:smallmessage'] = '{$a->sendername} ha rimosso il tuo gruppo {$a->groupname} dalla lista d\'attesa della fascia oraria del {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:unqueue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo rimosso dalla lista d\'attesa';
$string['group_registration_notify:student:unregister:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha annullato la registrazione del tuo gruppo {$a->groupname} dalla fascia oraria del {$a->date } a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:unregister:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, {$a->sendername} ha annullato la registrazione del tuo gruppo {$a->groupname} dalla fascia oraria del {$a->date } a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['group_registration_notify:student:unregister:group:smallmessage'] = '{$a->sendername} ha annullato la registrazione del tuo gruppo {$a->groupname} dalla fascia oraria del {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:unregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo non registrato';
$string['group_registration_notify:student:unregister:smallmessage'] = '{$a->sendername} ha annullato la registrazione del tuo gruppo {$a->groupname} dalla fascia oraria del {$a->date} alle {$a->time}.';
$string['group_registration_notify:student:unregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo non registrato';
$string['group_slot_available'] = 'fascia oraria disponibile';
$string['group_slot_full'] = 'fascia oraria occupato';
$string['groupmodeexistingcoursegroups'] = 'Usa gruppi di corsi esistenti';
$string['groupmodenogroups'] = 'Nessun appuntamento di gruppo';
$string['groupmodeslotgroups'] = 'Creazione di gruppi per fascia oraria vuota';
$string['groupmodeslotgroupsappointment'] = 'Creazione del gruppo per fascia oraria prenotata';
$string['groupoptions'] = 'Impostazioni di gruppo';
$string['grouporganizer_desc_hasgroup'] = 'Questo è un organizzatore di gruppi. Facendo clic sul pulsante di registrazione registrerai te e tutti i membri del tuo gruppo {$a->groupname} in questa fascia oraria. Tutti i membri del gruppo possono modificare e commentare la registrazione.';
$string['grouporganizer_desc_nogroup'] = 'Questo è un organizzatore di gruppi. Gli studenti possono iscrivere i propri gruppi agli appuntamenti. Tutti i membri del gruppo possono modificare e commentare la registrazione.';
$string['grouppicker'] = 'Selettore di gruppo';
$string['groupwarning'] = 'Controlla le opzioni di gruppo qui sotto!';
$string['headerfooter'] = 'Stampa intestazione/piè di pagina';
$string['headerfooter_help'] = 'Stampa intestazione/piè di pagina se selezionato';
$string['hidecalendar'] = 'Nascondi calendario';
$string['hidecalendar_help'] = 'Seleziona per nascondere il calendario in questo organizzatore';
$string['hour'] = 'ora';
$string['hour_pl'] = 'ore';
$string['img_title_due'] = 'La fascia oraria è in scadenza';
$string['img_title_evaluated'] = 'La fascia oraria è stato valutata';
$string['img_title_no_participants'] = 'La fascia oraria non ha avuto partecipanti';
$string['img_title_past_deadline'] = 'La fascia oraria ha superato la sua scadenza';
$string['img_title_pending'] = 'La fascia oraria è in attesa di valutazione';
$string['includetraineringroups'] = 'Includi il formatore nei gruppi';
$string['includetraineringroups_help'] = 'Se selezioni la casella di controllo, non solo i partecipanti alla fascia oraria ma anche i suoi trainer sono inclusi nei gruppi.';
$string['infobox_app_countdown'] = 'Tempo rimasto all\'appuntamento: {$a->days} giorni, {$a->hours} ore, {$a->minutes} minuti, {$a->seconds} secondi';
$string['infobox_app_occured'] = 'L\'appuntamento è già avvenuto.';
$string['infobox_deadline_countdown'] = 'Tempo rimasto alla scadenza: {$a->days} giorni, {$a->hours} ore, {$a->minutes} minuti, {$a->seconds} secondi';
$string['infobox_deadline_passed'] = 'Scaduto il termine per l\'iscrizione. Non è più possibile modificare le registrazioni.';
$string['infobox_deadline_passed_slot'] = 'Non è stato possibile creare xxx Fasce orarie perché è scaduta la scadenza per la registrazione.';
$string['infobox_deadlines_title'] = 'Scadenze';
$string['infobox_description_title'] = 'Descrizione Organizer';
$string['infobox_group'] = 'Il mio gruppo: {$a->groupname}';
$string['infobox_hidelegend'] = 'Nascondi legenda';
$string['infobox_legend_title'] = 'Legenda';
$string['infobox_messages_title'] = 'Messaggi di sistema';
$string['infobox_mycomments_title'] = 'I miei Commenti';
$string['infobox_myslot_noslot'] = 'Non sei registrato a nessuna fascia oraria al momento.';
$string['infobox_myslot_title'] = 'La mia fascia oraria';
$string['infobox_organizer_expired'] = 'Questo organizer scaduto il {$a->date} alle {$a->time}';
$string['infobox_organizer_expires'] = 'Questo organizer scadrà il {$a->date} alle {$a->time}.';
$string['infobox_organizer_never_expires'] = 'Questo organizzatore non ha scadenza.';
$string['infobox_showfreeslots'] = 'Fasce orarie libere';
$string['infobox_showhiddenslots'] = 'Fasce orarie nascoste';
$string['infobox_showlegend'] = 'Mostra legenda';
$string['infobox_showmyslotsonly'] = 'Le mie Fasce orarie';
$string['infobox_showregistrationsonly'] = 'Fasce orarie prenotate';
$string['infobox_showslots'] = 'Fasce orarie passate';
$string['infobox_slotoverview_title'] = 'Panoramica delle Fasce orarie';
$string['introeditor_error'] = 'bisogna dare una descrizione all\' Organizer1';
$string['invalidgrouping'] = 'Devi selezionare un gruppo valido!';
$string['inwaitingqueue'] = 'Lista d\'attesa';
$string['isgrouporganizer'] = 'Appuntamenti di Gruppo';
$string['isgrouporganizer_help'] = 'Seleziona questo se vuoi che questo organizzatore si occupi di gruppi anziché di singoli utenti. "Usa gruppi esistenti": un singolo membro del gruppo prenota uno spazio per il gruppo. "Creazione di gruppi per fascia oraria vuota": viene creato un gruppo di corsi per ogni nuova fascia oraria. "Creazione del gruppo per fascia oraria prenotata": viene creato un gruppo di corsi per ogni fascia oraria prenotata.';
$string['legend_anonymous'] = 'fascia oraria anonima';
$string['legend_comments'] = 'Commenti Studenti/Docenti';
$string['legend_due'] = 'Fascia oraria in scadenza';
$string['legend_evaluated'] = 'fascia oraria valutata';
$string['legend_feedback'] = 'Feedback del docente';
$string['legend_group_applicant'] = 'candidato del gruppo';
$string['legend_halfanonymous'] = 'Visibili solo i partecipanti della propria fascia oraria';
$string['legend_no_participants'] = 'La fascia oraria non ha avuto partecipanti';
$string['legend_not_occured'] = 'L\'appuntamento non è ancora arrivato';
$string['legend_organizer_expired'] = 'Organizer scaduto';
$string['legend_past_deadline'] = 'fascia oraria oltre la scadenza';
$string['legend_pending'] = 'fascia oraria in attesa di valutazione';
$string['legend_section_details'] = 'Icone dettagli fasce orarie';
$string['legend_section_status'] = 'Icone di Stato';
$string['location'] = 'Posizione';
$string['location_help'] = 'La posizione in cui si svolge la fascia oraria.';
$string['locationlink'] = 'URL del collegamento alla posizione';
$string['locationlink_help'] = 'Digita qui l\'indirizzo completo del sito web a cui desideri fare riferimento il link della posizione. Questo sito dovrebbe contenere almeno informazioni su come raggiungere la posizione. Si prega di digitare l\'indirizzo completo (compreso http://)';
$string['locationlinkenable'] = 'collegamento automatico alle informazioni sulla posizione';
$string['locationmandatory'] = 'L\'inserimento della posizione della fascia oraria è obbligatoria';
$string['locationsettings'] = 'Impostazioni posizione fascia oraria';
$string['maillink'] = 'L\'organizer è disponibile <a href="{$a}">qui</a>.';
$string['maxparticipants'] = 'Numero massimo di partecipanti';
$string['maxparticipants_help'] = 'Definisce il numero massimo di studenti che possono iscriversi a queste fasce orarie. Nel caso di un organizzatore di gruppo questo numero è sempre limitato a uno.';
$string['message_autogenerated2'] = 'Messaggio generato automaticamente';
$string['message_custommessage'] = 'Messaggio personalizzato';
$string['message_custommessage_help'] = 'Usa questo campo per inserire un testo personale nel messaggio generato automaticamente.';
$string['message_error_groupsynchronization'] = 'Sincronizzazione fascia oraria di gruppo fallita!';
$string['message_error_noactionchosen'] = 'Si prega di scegliere un\'azione prima di premere il pulsante Start.';
$string['message_error_slot_full_group'] = 'Questa fascia oraria è già occupata!';
$string['message_error_slot_full_single'] = 'Questa fascia oraria non ha più posti liberi!';
$string['message_error_unknown_unqueue'] = 'La tua voce in lista d\'attesa non può essere rimossa! Errore sconosciuto.';
$string['message_error_unknown_unregister'] = 'La tua registrazione non può essere rimossa! Errore sconosciuto.';
$string['message_info_available'] = 'Ci sono {$a->freeslots} fasce orarie vuote disponibili per gli utenti {$a->notregistered} senza alcun appuntamento.';
$string['message_info_available_group'] = 'Ci sono {$a->freeslots} fasce orarie vuote per i gruppi {$a->notregistered} senza alcun appuntamento.';
$string['message_info_reminders_sent_pl'] = 'Sono stati inviati {$a->count} promemoria.';
$string['message_info_reminders_sent_sg'] = 'Il promemoria {$a->count} è stato inviato.';
$string['message_info_slots_added_pl'] = '{$a->count} sono stati aggiunti nuove fasce orarie.';
$string['message_info_slots_added_sg'] = '{$a->count} è stato aggiunto un nuove fasce orarie.';
$string['message_info_slots_deleted'] = 'Sono stati eliminati le seguenti fasce orarie:<br/> {$a->deleted} slot eliminati.<br/> Gli utenti {$a->notified} sono stati avvisati.';
$string['message_info_slots_deleted_group'] = 'Sono stati eliminati le seguenti fasce orarie:<br/> {$a->deleted} slot eliminati.<br/> Gli utenti {$a->notified} sono stati avvisati.';
$string['message_warning_available'] = '<span style="color:red;">Attenzione</span> Ci sono {$a->freeslots} fasce orarie vuote disponibili per gli utenti {$a->notregistered} senza appuntamento.';
$string['message_warning_available_group'] = '<span style="color:red;">Attenzione</span> Ci sono {$a->freeslots} fasce orarie vuote disponibili per gruppi {$a->notregistered} senza alcun appuntamento.';
$string['message_warning_no_slots_added'] = 'Non sono stati aggiunti nuove fasce orarie!';
$string['message_warning_no_slots_selected'] = 'Devi prima selezionare almeno una fascia oraria!';
$string['message_warning_no_visible_slots_selected'] = 'Devi prima selezionare almeno una fascia oraria VISIBILE!';
$string['messageprovider:appointment_reminder_student'] = 'Promemoria appuntamento organizer';
$string['messageprovider:appointment_reminder_teacher'] = 'Promemoria appuntamento organizer (Insegnante)';
$string['messageprovider:assign_notify_student'] = 'Assegnazione dell\'organizer da parte dell\'insegnante';
$string['messageprovider:assign_notify_teacher'] = 'Assegnazione dell\'organizer';
$string['messageprovider:edit_notify_student'] = 'Modifiche dell\'organizer';
$string['messageprovider:edit_notify_teacher'] = 'Modifiche dell\'organizer (Docente)';
$string['messageprovider:eval_notify_student'] = 'Notifiche delle valutazioni dell\'organizer';
$string['messageprovider:group_registration_notify_student'] = 'Notifiche della registrazione di gruppo dell\'Organizer';
$string['messageprovider:manual_reminder_student'] = 'Promemoria Appuntamento Manuale dell\'organizer';
$string['messageprovider:register_notify_teacher'] = 'Notifica della registrazione dell\'organizer';
$string['messageprovider:register_notify_teacher_queue'] = 'Notifica della coda dell\'organizer';
$string['messageprovider:register_notify_teacher_register'] = 'Notifica della registrazione dell\'organizer';
$string['messageprovider:register_notify_teacher_reregister'] = 'Notifica della ri-registrazione dell\'organizer';
$string['messageprovider:register_notify_teacher_unqueue'] = 'Notifica di rimozione dalla coda dell\'organizer';
$string['messageprovider:register_notify_teacher_unregister'] = 'Notifica di annullamento dell\'iscrizione dell\'organizer';
$string['messageprovider:register_promotion_student'] = 'Organizer promosso dalla notifica della coda';
$string['messageprovider:register_reminder_student'] = 'Promemoria per la registrazione dell\'Organizer';
$string['messageprovider:slotdeleted_notify_student'] = 'fasce orarie dell\'organizzatore annullati';
$string['messageprovider:test'] = 'Messaggio di prova dell\'organizer';
$string['messages_all'] = 'Tutte le registrazioni, nuove registrazioni e cancellazioni';
$string['messages_none'] = 'Nessuna notifica di registrazione';
$string['messages_re_unreg'] = 'Solo re-iscrizioni e cancellazioni';
$string['min'] = 'minuto';
$string['min_pl'] = 'minuti';
$string['modformwarningplural'] = 'Questi campi non possono essere modificati poiché ci sono già appuntamenti in questo organizer';
$string['modformwarningsingular'] = 'Questo campo non può essere modificato perché ci sono già appuntamenti in questo organizer';
$string['modulename_help'] = 'Gli organizers consentono agli insegnanti di fissare appuntamenti con gli studenti creando fasce orarie a cui gli studenti possono registrarsi.';
$string['multimember'] = 'Gli utenti non possono appartenere a più gruppi all\'interno dello stesso gruppo!';
$string['multimemberspecific'] = 'L\'utente {$a->username} {$a->idnumber} è registrato in più di un gruppo! ({$a->gruppi})';
$string['multipleappointmentenddate'] = 'data di fine';
$string['multipleappointmentstartdate'] = 'data di inzio';
$string['mymoodle_app_slot'] = 'Appuntamento il {$a->date} alle {$a->time}';
$string['mymoodle_attended'] = '{$a->attended}/{$a->total} gli studenti hanno completato un appuntamento';
$string['mymoodle_attended_group'] = '{$a->attended}/{$a->total} i gruppi hanno completato un appuntamento';
$string['mymoodle_attended_group_short'] = '{$a->attended}/{$a->total} gruppi completati';
$string['mymoodle_attended_short'] = '{$a->attended}/{$a->total} studenti completati';
$string['mymoodle_completed_app'] = 'Hai completato il tuo appuntamento il {$a->date} alle {$a->time}';
$string['mymoodle_completed_app_group'] = 'Il tuo gruppo {$a->groupname} ha partecipato all\'appuntamento il {$a->date} alle {$a->time}';
$string['mymoodle_missed_app'] = 'Non hai partecipato all\'appuntamento il {$a->date} alle {$a->time}';
$string['mymoodle_missed_app_group'] = 'Il tuo gruppo {$a->groupname} non ha partecipato all\'appuntamento il {$a->date} alle {$a->time}';
$string['mymoodle_next_slot'] = 'Prossima fascia oraria il {$a->date} alle {$a->time}';
$string['mymoodle_no_reg_slot'] = 'Non sei ancora registrato in una fascia oraria';
$string['mymoodle_no_reg_slot_group'] = 'Il tuo gruppo {$a->groupname} non si è ancora registrato in una fascia oraria';
$string['mymoodle_no_slots'] = 'Nessuna fascia oraria in arrivo';
$string['mymoodle_organizer_expired'] = 'Questo organizer è scaduto il {$a->date} alle {$a->time}. Non puoi più usarlo';
$string['mymoodle_organizer_expires'] = 'Questo organizer scade il {$a->date} alle {$a->time}';
$string['mymoodle_pending_app'] = 'Il tuo appuntamento è in attesa di valutazione';
$string['mymoodle_pending_app_group'] = 'L\'appuntamento del tuo gruppo {$a->groupname} è in attesa di valutazione';
$string['mymoodle_reg_slot'] = 'Ti sei già registrato in una fascia oraria';
$string['mymoodle_reg_slot_group'] = 'Il tuo gruppo {$a->groupname} si è già registrato in una fascia oraria';
$string['mymoodle_registered'] = 'Gli studenti {$a->registered}/{$a->total} si sono registrati per un appuntamento';
$string['mymoodle_registered_group'] = 'I gruppi {$a->registered}/{$a->total} si sono registrati per un appuntamento';
$string['mymoodle_registered_group_short'] = '{$a->registered}/{$a->total} gruppi registrati';
$string['mymoodle_registered_short'] = '{$a->registered}/{$a->total} studenti registrati';
$string['mymoodle_upcoming_app'] = 'Il tuo appuntamento avrà luogo il {$a->date} alle {$a->time} a {$a->location}';
$string['mymoodle_upcoming_app_group'] = 'L\'appuntamento del tuo gruppo, {$a->groupname}, avrà luogo il {$a->date} alle {$a->time} a {$a->location}';
$string['newslot'] = 'Aggiungi altre fascie orarie';
$string['no_due_my_slots'] = 'Tutte le tue fasce orarie in questo organizzatore sono scadute e/o sono nascoste';
$string['no_due_slots'] = 'Tutte le fasce orarie create in questo organizzatore sono scadute';
$string['no_my_slots'] = 'Non hai fasce orarie create in questo organizer';
$string['no_slots'] = 'Non ci sono fasce orarie create in questo organizer';
$string['no_slots_defined'] = 'Non ci sono appuntamenti di fasce orarie disponibili al momento';
$string['no_slots_defined_teacher'] = 'Al momento non sono presenti fasce orarie per appuntamenti. Fai clic <a href="{$a->link}">qui</a> per crearne alcuni ora.';
$string['nocalendareventslotcreation'] = 'Nessun evento di calendario per fasce orarie vuote';
$string['nocalendareventslotcreation_help'] = 'Se selezioni questa opzione, nessun evento del calendario verrà creato durante la creazione delle fasce orarie. Solo gli appuntamenti creeranno eventi del calendario fasce orarie.';
$string['nofreeslots'] = 'Non sono disponibili fasce orarie.';
$string['nogroup'] = 'Nessun Gruppo';
$string['noparticipants'] = 'Nessun Partecipante';
$string['norightpage'] = 'Non sei autorizzato a richiamare questa pagina.';
$string['nosingleslotprintfields'] = 'La stampa non è possibile. Non ci sono campi utente definiti. Vedi le impostazioni dell\'organizer.';
$string['noslots'] = 'Nessuna fascia oraria per';
$string['noslotsselected'] = 'Nessuna fascia oraria selezionata!';
$string['notificationtime'] = 'Promemoria relativo appuntamento';
$string['notificationtime_help'] = 'Definisce quanto tempo prima dell\'appuntamento registrato deve essere ricordato allo studente.';
$string['novalidparticipants'] = 'Nessun partecipante valido';
$string['numentries'] = 'Voci mostrate per pagina';
$string['numentries_help'] = 'Scegli "ottimale" per ottimizzare la distribuzione delle voci dell\'elenco in base alla dimensione del testo e all\'orientamento della pagina scelti, se ci sono molti partecipanti registrati al tuo corso';
$string['organizer:addinstance'] = 'Aggiungi Organizer';
$string['organizer:addslots'] = 'Aggiungi nuove fasce orarie';
$string['organizer:assignslots'] = 'Assegna una fascia oraria ad uno studente';
$string['organizer:comment'] = 'Aggiungi commenti';
$string['organizer:deleteslots'] = 'Elimina fasce orarie esistenti';
$string['organizer:editslots'] = 'Modifica fasce orarie esistenti';
$string['organizer:evalslots'] = 'Fasce orarie di completamento del voto';
$string['organizer:leadslots'] = 'Fasce orarie di consegna';
$string['organizer:printslots'] = 'Stampa le fasce orarie esistenti';
$string['organizer:receivemessagesstudent'] = 'Ricevi messaggi come inviati agli studenti';
$string['organizer:receivemessagesteacher'] = 'Ricevi messaggi come inviati ai docenti';
$string['organizer:register'] = 'Registrati ad una fascia oraria';
$string['organizer:sendreminders'] = 'Invia promemoria di registrazione agli studenti';
$string['organizer:unregister'] = 'Annulla la registrazione da una fascia oraria';
$string['organizer:viewallslots'] = 'Visualizza tutte le fasce orarie come insegnante';
$string['organizer:viewmyslots'] = 'Visualizza le tue fasce orarie come insegnante';
$string['organizer:viewregistrations'] = 'Visualizza lo stato delle iscrizioni degli studenti';
$string['organizer:viewstudentview'] = 'Visualizza tutte le fasce orarie come studente';
$string['organizer_remind_all_no_recepients'] = 'Non ci sono destinatari validi.';
$string['organizer_remind_all_recepients_pl'] = 'Un totale di {$a->count} messaggi verrà inviato ai seguenti destinatari:';
$string['organizer_remind_all_recepients_sg'] = 'Un totale di {$a->count} messaggi verrà inviato ai seguenti destinatari:';
$string['organizer_remind_all_title'] = 'Invia Promemoria';
$string['organizercommon'] = 'Impostazioni Organizer';
$string['organizername'] = 'Nome Organizer';
$string['orientationlandscape'] = 'Scenario';
$string['orientationportrait'] = 'Ritratto';
$string['otherheader'] = 'Altro';
$string['pageorientation'] = 'Orientamento pagina';
$string['participants'] = 'Partecipante(i)';
$string['participants_help'] = 'Lista del/i Partecipante/i prenotati per questa fascia oraria.';
$string['pasttimeslotstring'] = 'Impossibile creare fasce orarie xxx perché non è consentita la creazione di fasce orarie passate.';
$string['pdf_notactive'] = 'non attivo';
$string['pdfsettings'] = 'Impostazioni PDF';
$string['places_inqueue'] = '{$a->inqueue} in lista d\'attesa';
$string['places_inqueue_withposition'] = '{$a->posizione coda}. posizione in lista d\'attesa';
$string['places_taken_pl'] = '{$a->numtakenplaces}/{$a->totalplaces} posti occupati';
$string['places_taken_sg'] = '{$a->numtakenplaces}/{$a->totalplaces} posto occupato';
$string['pluginadministration'] = 'Amministrazione Organizer';
$string['position'] = 'Posizione in coda';
$string['print_return'] = 'Ritorna al riepilogo di fascia oraria';
$string['printout'] = 'Stampare';
$string['printpreview'] = 'Anteprima di stampa (prime 10 voci)';
$string['printslotuserfieldsnotenabled'] = 'La funzione Campi utente fascia oraria di stampa non è abilitata dall\'amministratore.';
$string['printsubmit'] = 'Visualizza tabella stampabile';
$string['privacy:metadata:applicantidappointment'] = 'Identificatore dell\'utente che ha prenotato questa fascia oraria per il gruppo.';
$string['privacy:metadata:applicantidqueue'] = 'Identificatore dell\'utente che ha effettuato questa voce nella coda di attesa per il gruppo.';
$string['privacy:metadata:attended'] = 'Se l\'utente o il gruppo ha partecipato o meno alla fascia oraria.';
$string['privacy:metadata:comments'] = 'I commenti degli allenatori per questa fascia oraria.';
$string['privacy:metadata:feedback'] = 'Il feedback dei formatori durante la valutazione della fascia oraria.';
$string['privacy:metadata:grade'] = 'Il voto che l\'utente o il gruppo ha ricevuto per questa fascia oraria.';
$string['privacy:metadata:groupidappointment'] = 'Identificatore del gruppo utenti che ha prenotato questa fascia oraria.';
$string['privacy:metadata:groupidqueue'] = 'Identificatore del gruppo che ha effettuato questa voce nella coda di attesa per una fascia oraria.';
$string['privacy:metadata:organizerslotappointments'] = 'Tabella in cui sono memorizzati gli appuntamenti di fascia oraria.';
$string['privacy:metadata:organizerslotqueues'] = 'Tabella in cui sono archiviate le voci della coda di attesa per le fasce orarie.';
$string['privacy:metadata:organizerslottrainer'] = 'Tabella in cui sono memorizzati i trainer di una fascia oraria.';
$string['privacy:metadata:showfreeslotsonly'] = 'Preferenza dell\'utente: la tabella degli slot deve visualizzare solo le fasce orarie libere.';
$string['privacy:metadata:showhiddenslots'] = 'Preferenza dell\'utente: la tabella degli slot deve visualizzare le fasce orarie nascoste.';
$string['privacy:metadata:showmyslotsonly'] = 'Preferenza dell\'utente: la tabella delle le fasce orarie deve visualizzare solo le mie le fasce orarie.';
$string['privacy:metadata:showpasttimeslots'] = 'Preferenza dell\'utente: la tabella delle fasce orarie deve visualizzare anche le fasce orarie precedenti.';
$string['privacy:metadata:showregistrationsonly'] = 'Preferenza dell\'utente: la tabella fascia oraria deve visualizzare solo le registrazioni.';
$string['privacy:metadata:teacherapplicantid'] = 'Identificatore del formatore che ha assegnato questa fascia oraria a un partecipante o gruppo.';
$string['privacy:metadata:teacherapplicanttimemodified'] = 'Tempo in cui un trainer ha assegnato questa fascia oraria a un partecipante o gruppo.';
$string['privacy:metadata:trainerid'] = 'Identificatore di un trainer di una fascia oraria.';
$string['privacy:metadata:useridappointment'] = 'Identificatore dell\'utente che ha prenotato questa fascia oraria.';
$string['privacy:metadata:useridqueue'] = 'Identificatore dell\'utente che ha effettuato questa voce nella coda di attesa per una fascia oraria.';
$string['queue'] = 'code di attesa';
$string['queue_help'] = 'Le code di attesa consentono agli utenti di registrarsi in una fascia oraria anche se è già stato raggiunto il numero massimo di partecipanti. Gli utenti vengono aggiunti a una coda di attesa e assegnati alla fascia oraria (in ordine) non appena una fascia oraria diventa disponibile.';
$string['queuebody'] = 'La tua registrazione per una fascia oraria è stata promossa dallo stato "lista d\'attesa" allo stato "prenotato".';
$string['queuesubject'] = 'Organizzatore Moodle: promosso dalla coda';
$string['reg_status'] = 'Stato della registrazione';
$string['reg_status_not_registered'] = 'Non registrato';
$string['reg_status_organizer_expired'] = 'Organizer scaduto';
$string['reg_status_registered'] = 'Registrato';
$string['reg_status_slot_attended'] = 'Frequentato';
$string['reg_status_slot_attended_reapp'] = 'Frequentato, riconferma consentita';
$string['reg_status_slot_available'] = 'Fascia oraria disponibile';
$string['reg_status_slot_expired'] = 'Fascia oraria scaduta';
$string['reg_status_slot_full'] = 'Fascia oraria completa';
$string['reg_status_slot_not_attended'] = 'Non ha frequentato';
$string['reg_status_slot_not_attended_reapp'] = 'Non ha frequentato, riconferma consentita';
$string['reg_status_slot_past_deadline'] = 'Fascia oraria oltre la scadenza';
$string['reg_status_slot_pending'] = 'Fascia oraria in attesa di valutazione';
$string['register_notify_teacher:queue:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} si è messo in coda per la fascia oraria del {$a->date} alle {$a->time } in {$a->posizione}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:queue:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} ha messo in lista d\'attesa il gruppo {$a->groupname} per la fascia oraria di {$a ->data} in {$a->ora} in {$a->posizione}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:queue:group:smallmessage'] = 'Lo studente {$a->sendername} ha messo in lista d\'attesa il gruppo {$a->groupname} per la fascia oraria di {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:queue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo in lista d\'attesa';
$string['register_notify_teacher:queue:smallmessage'] = 'Lo studente {$a->sendername} è in coda per la fascia oraria di {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:queue:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Studente in coda';
$string['register_notify_teacher:register:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} si è registrato per la fascia oraria del {$a->date} alle {$a->time } in {$a->posizione}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:register:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} ha registrato il gruppo {$a->groupname} per la fascia oraria di {$a-> date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:register:group:smallmessage'] = 'Lo studente {$a->sendername} ha registrato il gruppo {$a->groupname} per la fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:register:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo registrato';
$string['register_notify_teacher:register:smallmessage'] = 'Lo studente {$a->sendername} si è registrato per la fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:register:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Studente registrato';
$string['register_notify_teacher:reregister:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} si è registrato nuovamente per la nuova fascia oraria il {$a->date} alle {$a ->ora} in {$a->posizione}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:reregister:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} ha registrato nuovamente il gruppo {$a->groupname} per la nuova fascia oraria il {$ a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:reregister:group:smallmessage'] = 'Lo studente {$a->sendername} ha registrato nuovamente il gruppo {$a->groupname} per la fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:reregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo ri-registrato';
$string['register_notify_teacher:reregister:smallmessage'] = 'Lo studente {$a->sendername} si è registrato nuovamente per la fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:reregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Studente registrato nuovamente';
$string['register_notify_teacher:unqueue:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} si è tolto dalla lista d\'attesa della fascia oraria il {$a->date} alle { $a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:unqueue:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} ha rimosso il gruppo {$a->groupname} dalla lista di attesa della fascia oraria del { $a->date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:unqueue:group:smallmessage'] = 'Lo studente {$a->sendername} ha rimosso il gruppo {$a->groupname} dalla lista d\'attesa della fascia oraria il {$a->date} alle {$a->time} in {$a->location }.';
$string['register_notify_teacher:unqueue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo rimosso dalla lista d\'attesa';
$string['register_notify_teacher:unqueue:smallmessage'] = 'Lo studente {$a->sendername} si è tolto dalla lista d\'attesa della fascia oraria {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:unqueue:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Studente rimosso dalla lista d\'attesa';
$string['register_notify_teacher:unregister:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} si è cancellato dalla fascia oraria il {$a->date} alle {$a->time } in {$a->posizione}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:unregister:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, lo studente {$a->sendername} ha annullato la registrazione del gruppo {$a->groupname} dalla fascia oraria di {$a-> date} a {$a->time} in {$a->location}. Sistema di messaggistica Moodle';
$string['register_notify_teacher:unregister:group:smallmessage'] = 'Lo studente {$a->sendername} ha annullato la registrazione del gruppo {$a->groupname} dalla fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:unregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Gruppo non registrato';
$string['register_notify_teacher:unregister:smallmessage'] = 'Lo studente {$a->sendername} ha annullato la registrazione dalla fascia oraria del {$a->date} alle {$a->time} in {$a->location}.';
$string['register_notify_teacher:unregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Studente non registrato';
$string['register_promotion_student:fullmessage'] = 'La tua registrazione per una fascia oraria è stata promossa dallo stato "lista d\'attesa" allo stato "prenotato".';
$string['register_promotion_student:smallmessage'] = 'La tua registrazione per una fascia oraria è stata promossa dallo stato "lista d\'attesa" allo stato "prenotato".';
$string['register_promotion_student:subject'] = 'Organizer Moodle: promosso dalla coda';
$string['register_reminder_student:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, o non ti sei ancora registrato a nessuna fascia oraria, o hai perso quella a cui ti sei registrato. {$a->custommessage} Sistema di messaggistica Moodle';
$string['register_reminder_student:group:fullmessage'] = 'Ciao {$a->receivername}! Come parte del corso {$a->courseid} {$a->coursefullname}, il tuo gruppo {$a->groupname} non si è ancora registrato a nessuna fascia oraria, o hai perso quella che hai fatto registrarsi a. {$a->custommessage} Sistema di messaggistica Moodle';
$string['register_reminder_student:group:smallmessage'] = 'Registra il tuo gruppo in una nuova fascia oraria.';
$string['register_reminder_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Promemoria di registrazione';
$string['register_reminder_student:smallmessage'] = 'Si prega di registrarsi in una (nuova) fascia oraria.';
$string['register_reminder_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Promemoria di registrazione';
$string['relative_deadline_before'] = 'prima dell\'appuntamento';
$string['relative_deadline_now'] = 'A partire da adesso';
$string['relativedeadline'] = 'Scadenza relativa';
$string['relativedeadline_help'] = 'Imposta la scadenza per la domanda per uno specifico intervallo di tempo specificato in anticipo. Gli studenti non potranno cambiare iscrizione o cancellarsi una volta scaduti i termini.';
$string['remindall_desc'] = 'Invia promemoria a tutti gli studenti senza appuntamento';
$string['requiremodintro'] = 'Richiedi la descrizione dell\'attività';
$string['reset_organizer_all'] = 'Eliminazione di fasce orarie, appuntamenti ed eventi correlati';
$string['resetorganizerall'] = 'Cancella tutti i dati dell\'organizer (fasce orarie e appuntamenti)';
$string['reviewsubmit'] = 'Rivedi le fasce orarie';
$string['rewievslotsheader'] = 'Rivedi le fasce orarie';
$string['search:activity'] = 'Organizer - informazione attività';
$string['sec'] = 'secondo';
$string['sec_pl'] = 'secondi';
$string['select'] = 'Seleziona fasce orarie';
$string['select_all_slots'] = 'Seleziona tutte le fasce orarie visibili';
$string['select_help'] = 'Seleziona una o più fasce orarie in cui vuoi operare';
$string['selectedgrouplist'] = 'Gruppi selezionati';
$string['selectedslots'] = 'Fasce orarie selezionate';
$string['signature'] = 'Firma';
$string['singleslotcommands'] = 'Singola azione per fascia oraria';
$string['singleslotcommands_help'] = 'Fare clic su un pulsante di azione per lavorare direttamente su una fascia oraria.';
$string['singleslotprintfield'] = 'Stampa campo fascia oraria utente';
$string['singleslotprintfield0'] = 'Stampa campo fascia oraria utente';
$string['singleslotprintfield0_help'] = 'Questi campi utente vengono utilizzati per ogni partecipante quando viene stampato un singolo slot.';
$string['singleslotprintfields'] = 'Campi profilo utente slot di stampa singolo';
$string['singleslotprintfields_help'] = 'TESTO FINTO - deve essere modificato con maggiori informazioni sui campi del profilo e su come sono controllati da un\'impostazione dell\'amministratore';
$string['slot'] = 'Appuntamento';
$string['slot_anonymous'] = 'Fascia oraria anonima';
$string['slot_slotvisible'] = 'Membri visibili esclusivamente se possiedono una fascia oraria';
$string['slot_visible'] = 'Membri della fascia oraria sempre visibili';
$string['slotassignedby'] = 'Fascia oraria assegna da';
$string['slotdeleted_notify_student:fullmessage'] = 'Ciao {$a->receivername}! Il tuo appuntamento nel corso {$a->courseshortname} il {$a->date} alle {$a->time} in {$a->location} è stato annullato. Nota che non hai più un appuntamento nell\'organizzatore {$a->organizername}. Segui il link per fissare un nuovo appuntamento: {$a->courselink}';
$string['slotdeleted_notify_student:group:fullmessage'] = 'Ciao {$a->receivername}! Il tuo appuntamento nel corso {$a->courseshortname} il {$a->date} alle {$a->time} in {$a->location} è stato annullato. Nota che non hai più un appuntamento nell\'organizzatore {$a->organizername}. Segui il link per fissare un nuovo appuntamento: {$a->courselink}';
$string['slotdeleted_notify_student:group:smallmessage'] = 'Il tuo appuntamento il {$a->date} alle {$a->time} nell\'organizzatore "{$a->organizername}" è stato annullato.';
$string['slotdeleted_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento annullato';
$string['slotdeleted_notify_student:smallmessage'] = 'Il tuo appuntamento il {$a->date} alle {$a->time} nell\'organizer "{$a->organizername}" è stato annullato.';
$string['slotdeleted_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Appuntamento annullato';
$string['slotdetails'] = 'Dettagli fasce orarie';
$string['slotfrom'] = 'da';
$string['slotlistempty'] = 'Nessuna fascia oraria presente';
$string['slotperiodendtime'] = 'data di fine';
$string['slotperiodheader'] = 'Genera fasce orarie per intervallo di date';
$string['slotperiodheader_help'] = 'Specificare la data di inizio e di fine a cui si applicheranno gli intervalli di tempo giornalieri (sezione di seguito). Specificare anche qui se lo slot deve essere visibile agli studenti.';
$string['slotperiodstarttime'] = 'data d\'inizio';
$string['slottimeframesheader'] = 'Tempi specifici';
$string['slottimeframesheader_help'] = 'Questa sezione consente la definizione in base ai giorni della settimana di intervalli di tempo che verranno riempiti con intervalli di appuntamenti con le proprietà specificate sopra. Ci può essere più di un intervallo di tempo al giorno. Se viene selezionato un intervallo di tempo di lunedì, genererà fasce orarie per ogni lunedì tra la data di inizio e quella di fine (inclusa).';
$string['slotto'] = 'a';
$string['status'] = 'Dettagli stato';
$string['status_help'] = 'Stato corrente di questa fascia oraria.';
$string['status_no_entries'] = 'Questo organizer non ha studenti registrati.';
$string['stroptimal'] = 'ottimo';
$string['studentcomment_title'] = 'Commenti studente';
$string['taballapp'] = 'Appuntamenti';
$string['tabstatus'] = 'Stato registarzione';
$string['tabstud'] = 'Vista studente';
$string['teacher'] = 'Docente';
$string['teacher_help'] = 'Lista degli Istruttori di questa fascia oraria';
$string['teacher_unchanged'] = '-- invariato --';
$string['teachercomment_title'] = 'Commenti docente';
$string['teacherfeedback_title'] = 'Feedback del docente';
$string['teacherid'] = 'Istruttore';
$string['teacherid_help'] = 'Seleziona l\'istruttore che vuoi guidi gli appuntamenti';
$string['teacherinvisible'] = 'Docente non visibile';
$string['teachervisible'] = 'Docente visibile';
$string['teachervisible_help'] = 'Seleziona questo se vuoi consentire agli studenti di vedere l\'insegnante associato alla fascia oraria.';
$string['textsize'] = 'Dimensione del testo';
$string['th_actions'] = 'Azione';
$string['th_appdetails'] = 'Dettagli';
$string['th_attended'] = 'Freq.';
$string['th_comments'] = 'Commenti del Partecipante';
$string['th_datetime'] = 'Data e Ora';
$string['th_datetimedeadline'] = 'Data e Ora';
$string['th_details'] = 'Stato';
$string['th_duration'] = 'Durata';
$string['th_evaluated'] = 'Valutazione';
$string['th_firstname'] = 'Nome';
$string['th_grade'] = 'Voto';
$string['th_group'] = 'Gruppo';
$string['th_groupname'] = 'Gruppo';
$string['th_lastname'] = 'Cognome';
$string['th_location'] = 'Località';
$string['th_participant'] = 'Partecipante';
$string['th_participants'] = 'Partecipanti';
$string['th_status'] = 'Stato';
$string['th_teacher'] = 'Docente';
$string['th_teachercomments'] = 'Commento del docente';
$string['timeshift'] = 'Spostamento della scadenza assoluta';
$string['timeslot'] = 'Fascia Oraria Organizer';
$string['title_add'] = 'Aggiungi un nuovo appuntamento di fasce orarie';
$string['title_comment'] = 'Modifica i tuoi commenti';
$string['title_delete'] = 'Elimina le fasce orarie selezionate';
$string['title_edit'] = 'Modifica le fasce orarie selezionate';
$string['title_eval'] = 'Valuta le fasce orarie selezionate';
$string['title_print'] = 'Stampa fasce orarie';
$string['totalday'] = 'xxx fasce orarie per yyy persone';
$string['totalday_groups'] = 'xxx fasce orarie per yyy gruppi';
$string['totalslots'] = 'da {$a->starttime} a {$a->endtime}, {$a->duration} {$a->unit} ciascuno, {$a->totalslots} fasce orarie in totale';
$string['totaltotal'] = 'Totale: xxx fasce orarie per yyy persone';
$string['totaltotal_groups'] = 'Totale: xxx fasce orarie per yyy gruppi';
$string['trainer'] = 'Istruttore';
$string['trainerid'] = 'Docente';
$string['trainerid_help'] = 'Seleziona l\'insegnante che vuoi guidare gli appuntamenti';
$string['unavailableslot'] = 'Questa fascia oraria è disponibile da';
$string['unknown'] = 'Sconosciuto';
$string['visibility'] = 'Visibilità dei membri - preimpostazione';
$string['visibility_all'] = 'Visibile';
$string['visibility_anonymous'] = 'Anonimo';
$string['visibility_help'] = 'Definizione dell\'opzione di visibilità predefinita con cui verrà creato un nuova fascia oraria.<br/><b>Anonimo:</b> I membri di questa fascia oraria sono sempre invisibili a tutti.<br/><b>Visibile:</ b> Tutti i membri di questa fascia oraria sono sempre visibili a tutti.<br/><b>Visibile solo ai membri della fascia oraria:</b> solo i membri della fascia oraria possono vedersi.';
$string['visibility_slot'] = 'Visibile solo ai membri della fascia oraria';
$string['visible'] = 'fascia oraria visibile';
$string['warning_groupingid'] = 'Modalità gruppo abilitata. Devi selezionare un raggruppamento valido.';
$string['warninggroupmode'] = 'Devi abilitare la modalità di gruppo e selezionare un raggruppamento per creare un organizer di gruppo!';
$string['warningtext1'] = 'Le fasce orarie selezionate contengono valori diversi in questo campo!';
$string['warningtext2'] = 'ATTENZIONE! Il contenuto di questo campo è stato modificato!';
$string['weekdaylabel'] = 'Fascia feriale';
$string['with'] = 'con';
