<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_clean', language 'de', version '3.10'.
 *
 * @package     theme_clean
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Clean</h2>
<p><img class=img-polaroid src="clean/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Über Clean</h3>
<p>Clean ist ein angepasstes Design auf der Basis von Bootstrap. StyleSheets, Rendering und Einstellungen werden von Bootstrap vererbt und können in Clean angepasst werden.
<h3>Autoren von Bootstrap</h3>
<p>Bootstrap wurde erstellt für Moodle 2.5 von:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Autoren von Clean</h3>
<p>Bas Brands, David Scotson, Mary Evans<br>
Kontakt: bas@sonsbeekmedia.nl<br>
Website: <a href="http://www.basbrands.nl">www.basbrands.nl</a>
</p>
<h3>Fehler melden</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>Weitere Information</h3>
<p><a href="clean/README.txt">Wie kann das Design kopiert und angepasst werden?</a></p>
</div>
</div>';
$string['configtitle'] = 'Clean';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden. Wenn Sie z.B. die Farbe der Links ändern möchten, geben Sie folgenden Code ein:
<pre>a:link, a:visited, a:hover, a:active, a:focus {color:blue;}</pre>';
$string['footnote'] = 'Fußzeile';
$string['footnotedesc'] = 'Der Inhalt dieses Feldes wird auf jeder Seite als Fußzeile angezeigt.';
$string['invert'] = 'Navigationsleiste invertieren';
$string['invertdesc'] = 'Diese Option invertiert die Farben in der Navigationsleiste. Die Hintergrundfarbe wird schwarz, die Textfarbe wird grau.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Dieses Logo wird lediglich im Kopfbereich der Startseite und der Loginseite angezeigt.<br>Falls die Höhe des Logos größer als 75 Pixel ist, fügen Sie folgende Anweisung mit der richtigen Höhe im Feld \'CSS-Anpassungen\' ein:
<pre>div.logo {height: 100px;}</pre>
Wenn die Höhe einen anderen Wert als 100 Pixel hat, passen Sie dies entsprechend an. Wenn hier kein Logo hinzugefügt wird, wird das Logo unter Erscheinung > Logos genutzt.';
$string['pluginname'] = 'Clean';
$string['privacy:metadata'] = 'Das Design Clean speichert keine personenbezogenen Nutzerdaten.';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['sitelogo'] = 'Site-Logo';
$string['sitename'] = 'Site-Bezeichnung und kleines Logo anzeigen';
$string['sitenamedesc'] = 'Wenn ein kleines Logo vorhanden ist, wird das Logo auf jeder Seite in der Navigationsleite angezeigt. Ohne kleines Logo wird der Name der Website angezeigt.';
$string['smalllogo'] = 'Kleines Logo';
$string['smalllogodesc'] = 'Das kleine Logo wird in der Navigationsleiste angezeigt. Wenn ein Logo für den Kopfbereich der Startseite und der Anmeldeseite verfügbar ist, wird das kleine Logo auf diesen Seiten nicht angezeigt. Wenn hier kein Logo hinzugefügt wird, wird das kompakte Logo unter Erscheinung > Logos genutzt.';
