<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'de', version '3.10'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Aktionen für die Bewertungsoberfläche';
$string['actionsforpost'] = 'Aktionen für Beiträge';
$string['activityoverview'] = 'Neue Forenbeiträge';
$string['addanewdiscussion'] = 'Neues Thema hinzufügen';
$string['addanewquestion'] = 'Neue Frage hinzufügen';
$string['addanewtopic'] = 'Neues Thema hinzufügen';
$string['addtofavourites'] = 'Dieses Thema markieren';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['alldiscussions'] = 'Alle Themen';
$string['allforums'] = 'Alle Foren';
$string['allowdiscussions'] = 'Darf \'{$a}\' in diesem Forum schreiben?';
$string['allowsallsubscribe'] = 'Alle dürfen im Forum über ihr Abonnement entscheiden.';
$string['allowsdiscussions'] = 'Alle dürfen im Forum ein neues Thema beginnen.';
$string['allsubscribe'] = 'Alle Foren abonnieren';
$string['allunsubscribe'] = 'Alle Foren abbestellen';
$string['allusers'] = 'Alle Nutzer/innen';
$string['alreadyfirstpost'] = 'Dies ist der erste Beitrag zu diesem Thema.';
$string['anyfile'] = 'Beliebige Datei';
$string['areaattachment'] = 'Anhänge';
$string['areapost'] = 'Mitteilungen';
$string['attachment'] = 'Anhang';
$string['attachment_help'] = 'Sie dürfen eine oder mehrere Dateien an einen Beitrag anhängen. Ein angehängtes Bild wird am Ende des Beitrags angezeigt.';
$string['attachmentname'] = 'Anhang {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Ohne Nachrichten-ID können Anhänge nicht exportiert werden.';
$string['attachments'] = 'Anhänge';
$string['attachmentswordcount'] = 'Anhänge und Wortzahl';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} antwortet privat an {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} antwortet an {$a->author}';
$string['availability'] = 'Verfügbarkeit';
$string['blockafter'] = 'Nutzer/innen sperren';
$string['blockafter_help'] = 'Diese Zahl legt fest, wie viele Beiträge pro Nutzer/in im angegebenen Zeitfenster maximal ins Forum eingetragen werden dürfen. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blockperiod'] = 'Sperrdauer';
$string['blockperiod_help'] = 'In diesem Zeitfenster dürfen maximal so viele Beiträge pro Nutzer/in ins Forum eingetragen werden, wie mit der Zahl \'Sperre\' festgelegt sind. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blockperioddisabled'] = 'Nicht sperren';
$string['blogforum'] = 'Standardforum in blog-ähnlicher Anzeige';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Forumstracking-Status für den Nutzer';
$string['calendardue'] = '{$a} ist fällig.';
$string['cancelreply'] = 'Antwort abbrechen';
$string['cannotadd'] = 'Der Beitrag konnte nicht zum Forum hingefügt werden';
$string['cannotadddiscussion'] = 'Nur Gruppenmitglieder dürfen Beiträge zum Forum hinzufügen.';
$string['cannotadddiscussionall'] = 'Sie dürfen kein neues Thema für alle Teilnehmer/innen anlegen.';
$string['cannotadddiscussiongroup'] = 'Da Sie keiner Gruppe angehören, können Sie kein neues Thema beginnen.';
$string['cannotaddsubscriber'] = 'Die ID {$a} konnte nicht zur Abonnentenliste hinzugefügt werden!';
$string['cannotaddteacherforumto'] = 'Das konvertierte Trainerforum konnte nicht im Kursabschnitt 0 eingefügt werden.';
$string['cannotcreatediscussion'] = 'Das neue Thema konnte nicht angelegt werden.';
$string['cannotcreateinstanceforteacher'] = 'Das neue Kursmodul für das Trainerforum konnte nicht erstellt werden.';
$string['cannotdeletediscussioninsinglediscussion'] = 'Sie dürfen den ersten Beitrag in einer Einzeldiskussion nicht löschen';
$string['cannotdeletepost'] = 'Sie dürfen diesen Beitrag nicht löschen!';
$string['cannoteditposts'] = 'Sie dürfen keine Beiträge anderer Nutzer/innen ändern!';
$string['cannotexportforum'] = 'Sie können das Forum nicht exportieren';
$string['cannotfavourite'] = 'Entschuldigung, aber Sie besitzen nicht die nötigen Rechte, um Themen zu markieren.';
$string['cannotfinddiscussion'] = 'Das Thema konnte im Forum nicht gefunden werden';
$string['cannotfindfirstpost'] = 'Der erste Beitrag konnte im Forum nicht gefunden werden';
$string['cannotfindorcreateforum'] = 'Das Forum \'Ankündigungen\' wurde nicht gefunden oder konnte nicht angelegt werden.';
$string['cannotfindparentpost'] = 'Der erste Beitrag in diesem Thema {$a} konnte nicht gefunden werden';
$string['cannotmovefromsingleforum'] = 'Das Thema kann nicht aus einem Einzeldiskussionsforum verschoben werden';
$string['cannotmovenotvisible'] = 'Forum unsichtbar';
$string['cannotmovetonotexist'] = 'Sie können nicht in dieses Forum wechseln - es existiert nicht!';
$string['cannotmovetonotfound'] = 'Das Zielforum wurde nicht im Kurs gefunden.';
$string['cannotmovetosingleforum'] = 'Das Thema kann nicht ein Einzeldiskussionsforum verschoben werden';
$string['cannotpindiscussions'] = 'Sie besitzen nicht die nötigen Rechte, um Themen zu anzupinnen.';
$string['cannotpurgecachedrss'] = 'Die zwischengespeicherten RSS-Feeds für die Quell- und/oder Ziel-Foren können nicht beseitigt werden - überprüfen Sie Ihre Forenberechtigungen.';
$string['cannotremovesubscriber'] = 'Die ID {$a} konnte nicht aus der Abonnentenliste entfernt werden!';
$string['cannotreply'] = 'Sie dürfen nicht auf diesen Beitrag antworten.';
$string['cannotsplit'] = 'Themen können in diesem Forum nicht geteilt werden.';
$string['cannotsubscribe'] = 'Für ein Abonnement müssen Sie Gruppenmitglied sein.';
$string['cannottrack'] = 'Das Tracking des Forums konnte nicht beendet werden.';
$string['cannotunsubscribe'] = 'Sie konnten nicht aus dem Forum abgemeldet werden.';
$string['cannotupdatepost'] = 'Sie können den Beitrag nicht aktualisieren.';
$string['cannotviewpostyet'] = 'Sie können fremde Beiträge erst lesen, wenn Sie selber einen Beitrag geschrieben haben.';
$string['cannotviewusersposts'] = 'Von dieser Person gibt es keine Beiträge, die Sie sehen könnten.';
$string['cleanreadtime'] = '\'Gelesen\' zu diesen Zeitpunkt markieren';
$string['clicktofavourite'] = 'Sie haben dieses Thema nicht markiert. Klicken, um zu markieren.';
$string['clicktolockdiscussion'] = 'Klicken, um dieses Thema zu sperren.';
$string['clicktosubscribe'] = 'Nicht abonniert. Klicken Sie, um das Forum zu abonnieren.';
$string['clicktounfavourite'] = 'Sie haben dieses Thema markiert. Klicken, um die Themenmarkierung zu entfernen.';
$string['clicktounlockdiscussion'] = 'Klicken, um dieses Thema zu entsperren.';
$string['clicktounsubscribe'] = 'Abonniert. Klicken, um das Forum abzubestellen.';
$string['close'] = 'Schließen';
$string['closegrader'] = 'Bewertung schließen';
$string['completiondiscussions'] = 'Teilnehmer/in muss ein Thema neu beginnen:';
$string['completiondiscussionsdesc'] = 'Teilnehmer/in muss mindestens {$a} Themen anlegen';
$string['completiondiscussionsgroup'] = 'Themen erforderlich';
$string['completiondiscussionshelp'] = 'Zum Abschluss sind Themen erforderlich';
$string['completionposts'] = 'Teilnehmer/in muss ein Thema neu beginnen oder Antworten verfassen:';
$string['completionpostsdesc'] = 'Teilnehmer/in muss mindestens {$a} Themen oder Antworten beitragen';
$string['completionpostsgroup'] = 'Forumsbeiträge erforderlich';
$string['completionpostshelp'] = 'Zum Abschluss sind Themen oder Antworten erforderlich';
$string['completionreplies'] = 'Teilnehmer/in muss Antworten verfassen:';
$string['completionrepliesdesc'] = 'Teilnehmer/in muss mindestens {$a} Antworten verfassen';
$string['completionrepliesgroup'] = 'Antworten erforderlich';
$string['completionreplieshelp'] = 'Zum Abschluss sind Antworten erforderlich';
$string['configcleanreadtime'] = 'Ältere Beiträge werden täglich zu dieser Zeit (Stunde) als \'gelesen\' markiert.';
$string['configdigestmailtime'] = 'Diese Option legt fest, wann die tägliche Zusammenfassung neuer Forumsbeiträge erstellt und versendet wird.';
$string['configdisplaymode'] = 'Standardanzeige für Themen, falls nichts eingestellt wurde.';
$string['configenablerssfeeds'] = 'Diese Option aktiviert die Einstellmöglichkeit von RSS Feeds für alle Foren. Jedes Forum muss einzeln für RSS Feeds freigegeben werden.';
$string['configenabletimedposts'] = 'Wenn diese Option aktiviert ist, dann lässt sich ein Zeitraum für die Sichtbarkeit eines Forumsbeitrags festlegen.';
$string['configlongpost'] = 'Jeder Beitrag wird als "lang" eingestuft, wenn er länger als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Tags). Beiträge auf der Startseite, auf Kursseiten im sozialen Format oder in Benutzerprofilen angezeigt werden, werden auf einen natürlichen Bruch zwischen den Werten forum_shortpost und forum_longpost gekürzt.';
$string['configmanydiscussions'] = 'Anzahl von Themen pro Seite';
$string['configmaxattachments'] = 'Voreinstellung für die Anzahl von Anhängen, die pro Beitrag in einem Forum erlaubt sind';
$string['configmaxbytes'] = 'Voreinstellung für die Dateigröße von Anhängen in Foren auf dieser Website (je nach Kurs oder durch andere lokale Einstellungen weiter eingeschränkt)';
$string['configoldpostdays'] = 'Anzahl der Tage, nach denen eine neue Nachricht automatisch als gelesen gilt.';
$string['configreplytouser'] = 'Wenn ein Forumsbeitrag per E-Mail verschickt wird, soll er die Teilnehmeradresse enthalten, damit der Empfänger persönlich antworten kann (statt über das Forum)? Wenn Sie "Ja" auswählen, können die Teilnehmer/innen in ihrem Profil festlegen, ob die E-Mail-Adresse veröffentlicht werden soll oder nicht.';
$string['configrssarticlesdefault'] = 'Wenn RSS Feeds aktiviert sind, wird hiermit die Anzahl von Artikeln (bzw. Themen oder Beiträgen) festgelegt.';
$string['configrsstypedefault'] = 'Wenn RSS Feeds aktiviert sind, wird hiermit der Standardtyp festgelegt.';
$string['configshortpost'] = 'Jeder Beitrag wird als kurz eingestuft, wenn er kürzer als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Codierung).';
$string['configsubscriptiontype'] = 'Standardeinstellung für Abonnement';
$string['configtrackingtype'] = 'Standardeinstellung zum Forumstracking';
$string['configtrackreadposts'] = 'Wenn diese Option aktiviert ist, steht die Markierung gelesen/ungelesen für alle zur Verfügung.';
$string['configusermarksread'] = 'Wenn diese Option aktiviert ist, müssen neue Nachrichten manuell als gelesen markiert werden. Andernfalls gilt eine Nachricht automatisch als gelesen, sobald sie einmal aufgerufen wurde.';
$string['confirmsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abonnieren?';
$string['confirmsubscribediscussion'] = 'Möchten Sie wirklich das Thema \'{$a->discussion}\' im Forum \'{$a->forum}\' abonnieren?';
$string['confirmunsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abbestellen?';
$string['confirmunsubscribediscussion'] = 'Möchten Sie wirklich das Thema \'{$a->discussion}\' im Forum \'{$a->forum}\' abbestellen?';
$string['couldnotadd'] = 'Fehler. Der Beitrag konnte nicht hinzugefügt werden.';
$string['couldnotdeletereplies'] = 'Der Beitrag darf nicht gelöscht werden, weil es dazu bereits Antworten gibt.';
$string['couldnotupdate'] = 'Fehler. Der Beitrag konnte nicht geändert werden.';
$string['created'] = 'Erstellt';
$string['crontask'] = 'E-Mail-Versand aus Foren';
$string['cutoffdate'] = 'Letzter Eingabetermin';
$string['cutoffdate_help'] = 'Wenn diese Option aktiviert ist, akzeptiert das Forum keine Beiträge mehr nach diesem Zeitpunkt.';
$string['cutoffdatereached'] = 'Der letzte Eingabetermin für dieses Forum ist erreicht. Sie können keinen Beitrag mehr schreiben.';
$string['cutoffdatevalidation'] = 'Der letzte Eingabetermin kann nicht früher liegen als das Fälligkeitsdatum.';
$string['delete'] = 'Löschen';
$string['deleteddiscussion'] = 'Das Thema wurde gelöscht.';
$string['deletedpost'] = 'Der Beitrag wurde gelöscht.';
$string['deletedposts'] = 'Diese Beiträge wurden gelöscht.';
$string['deleteduser'] = 'gelöscht';
$string['deletesure'] = 'Möchten Sie diesen Beitrag wirklich löschen?';
$string['deletesureplural'] = 'Möchten Sie diesen Beitrag und alle Antworten wirklich löschen? ({$a} Beiträge)';
$string['digestmailheader'] = 'Guten Tag,

diese E-Mail enthält die tägliche Zusammenfassung neuer Forenbeiträge von {$a->sitename}. Die Einstellungen zu den E-Mails aus Foren können Sie über {$a->userprefs} ändern.

Ihr E-Learning-Team';
$string['digestmailpost'] = 'Einstellungen zur Zusammenfassung neuer Forenbeiträge ändern';
$string['digestmailpostlink'] = 'Einstellungen für die Forumszusammenfassung ändern: {$a}';
$string['digestmailprefs'] = 'Ihr Profil';
$string['digestmailsubject'] = '{$a}: Zusammenfassung des Forums';
$string['digestmailtime'] = 'Termin für Foren- Zusammenfassungen';
$string['digestsentusers'] = 'Die E-Mail-Zusammenfassung wurde erfolgreich an {$a} Teilnehmer/innen gesendet.';
$string['disallowsubscribe'] = 'Das Forum kann nicht abonniert werden';
$string['disallowsubscribeteacher'] = 'Das Forum kann nicht abonniert werden (nur Trainer/innen)';
$string['disallowsubscription'] = 'Abonnement';
$string['disallowsubscription_help'] = 'Das Forum ist so eingestellt, dass Sie keine Themen abonnieren können.';
$string['discussion'] = 'Thema';
$string['discussionlistsortbycreatedasc'] = 'Nach Erstelldatum aufsteigend sortieren';
$string['discussionlistsortbycreateddesc'] = 'Nach Erstelldatum absteigend sortieren';
$string['discussionlistsortbydiscussionasc'] = 'Sortieren nach Thema in aufsteigender Reihenfolge';
$string['discussionlistsortbydiscussiondesc'] = 'Sortieren nach Thema in absteigender Reihenfolge';
$string['discussionlistsortbygroupasc'] = 'Sortieren nach Gruppe in aufsteigender Reihenfolge';
$string['discussionlistsortbygroupdesc'] = 'Sortieren nach Gruppe in absteigender Reihenfolge';
$string['discussionlistsortbylastpostasc'] = 'Nach Erstelldatum des letzten Beitrags aufsteigend sortieren';
$string['discussionlistsortbylastpostdesc'] = 'Nach Erstelldatum des letzten Beitrags absteigend sortieren';
$string['discussionlistsortbyrepliesasc'] = 'Nach Anzahl der Antworten aufsteigend sortieren';
$string['discussionlistsortbyrepliesdesc'] = 'Nach Anzahl der Antworten absteigend sortieren';
$string['discussionlistsortbystarterasc'] = 'Sortieren nach Themenstarter/in in aufsteigender Reihenfolge';
$string['discussionlistsortbystarterdesc'] = 'Sortieren nach Themenstarter/in in absteigender Reihenfolge';
$string['discussionlocked'] = 'Dieses Thema wurde gesperrt. Sie können hier nicht weiter antworten.';
$string['discussionlockingdisabled'] = 'Nicht sperren';
$string['discussionlockingheader'] = 'Themensperrung';
$string['discussionmoved'] = 'Dieses Thema wurde verschoben nach \'{$a}\'.';
$string['discussionmovedpost'] = 'Dieses Thema wurde verschoben nach <a href="{$a->discusshref}">hier</a> ins Forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Thema';
$string['discussionnownotsubscribed'] = '{$a->name} wird nicht benachrichtigt über neue Beiträge zu \'{$a->discussion}\' in \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} wird benachrichtigt über neue Beiträge zu \'{$a->discussion}\' in \'{$a->forum}\'';
$string['discussionpin'] = 'Anpinnen';
$string['discussionpinned'] = 'Angepinnt';
$string['discussionpinned_help'] = 'Angepinnte Themen bleiben in der Themenliste des Forums immer exponiert am Anfang stehen.';
$string['discussions'] = 'Themen';
$string['discussionsplit'] = 'Diskussion wurde aufgeteilt';
$string['discussionsstartedby'] = 'Themen begonnen von {$a}';
$string['discussionsstartedbyrecent'] = 'Themen kürzlich begonnen von {$a}';
$string['discussionsstartedbyuserincourse'] = 'Themen begonnen von {$a->fullname} in {$a->coursename}';
$string['discussionstartedby'] = 'Die Diskussion begann mit {$a}.';
$string['discussionsubscribed'] = 'Sie haben das Thema jetzt abonniert.';
$string['discussionsubscribestart'] = 'Ich möchte neue Beiträge zu diesem Thema als Mitteilung erhalten.';
$string['discussionsubscribestop'] = 'Ich möchte keine Mitteilungen zu diesem Thema erhalten.';
$string['discussionsubscription'] = 'Themenabonnement';
$string['discussionsubscription_help'] = 'Wenn Sie ein Thema abonnieren, bekommen Sie Mitteilungen über alle neuen Beiträge zu diesem Thema.';
$string['discussionunpin'] = 'Loslösen';
$string['discussionunsubscribed'] = 'Sie haben das Thema jetzt abbestellt.';
$string['discussthistopic'] = 'Thema diskutieren';
$string['discusstopicname'] = 'Diskutieren Sie das Thema: {$a}';
$string['displayend'] = 'Anzeigeende';
$string['displayend_help'] = 'Die Einstellung legt fest, ob ein Forumsbeitrag nach einem bestimmten Datum verborgen werden soll. Beachten Sie, dass Admins die Beiträge immer sehen dürfen.';
$string['displayenddate'] = 'Ende anzeigen: {$a}';
$string['displaymode'] = 'Anzeigemodus';
$string['displayperiod'] = 'Anzeigezeitraum';
$string['displaystart'] = 'Anzeigebeginn';
$string['displaystart_help'] = 'Die Option legt fest, ob ein Forumsbeitrag erst ab einem bestimmten Datum angezeigt werden soll. Administrator/innen dürfen immer alle Beiträge sehen.';
$string['displaystartdate'] = 'Beginn anzeigen: {$a}';
$string['displaywordcount'] = 'Wortzahl anzeigen';
$string['displaywordcount_help'] = 'Diese Option legt fest, ob die Anzahl der Wörter für jeden Forenbeitrag angezeigt werden soll.';
$string['duedate'] = 'Fälligkeitsdatum';
$string['duedate_help'] = 'Fälligkeitsdatum, um einen Beitrag in diesem Forum zu verfassen. Obwohl das Fälligkeitsdatum für das Forum im Kalender angezeigt wird, ist ein Schreiben im Forum auch danach noch möglich. Um das Schreiben nach einem bestimmten Datum zu verhindern, setzen Sie einen letzten Eingabetermin.';
$string['duedatetodisplayincalendar'] = 'Fälligkeitsdatum, das im Kalender angezeigt wird.';
$string['eachuserforum'] = 'Jede Person darf genau ein Thema anlegen';
$string['edit'] = 'Bearbeiten';
$string['editedby'] = 'Geändert von {$a->name} - Originaleintrag {$a->date}';
$string['editedpostupdated'] = 'Beitrag von {$a} wurde aktualisiert';
$string['editing'] = 'Wird bearbeitet';
$string['emaildigestcompleteshort'] = 'Vollständige Beiträge';
$string['emaildigestdefault'] = 'Standard ({$a})';
$string['emaildigestoffshort'] = 'Keine Zusammenfassung';
$string['emaildigestsubjectsshort'] = 'Nur die Themen';
$string['emaildigesttype'] = 'Optionen für die E-Mail-Zusammenfassung';
$string['emaildigesttype_help'] = 'Folgende Einstellungen stehen für die Benachrichtigung aus Foren zur Verfügung:

* Standard - Es wird die Einstellung im individuellen Nutzerprofil verwandt. Eine Änderung im eigenen Profil wird auch hier angezeigt.
* Keine Zusammenfassung - Sie erhalten für jeden Forenbeitrag eine Mitteilung.
* Zusammenfassung - vollständige Beiträge - Sie erhalten täglich eine Mitteilung. Diese enthält alle Forenbeiträge mit ihrem gesamten Inhalt.
* Zusammenfassung - nur Überschriften - Sie erhalten tägliche eine Mitteilung. Diese enthält nur die Überschriften der Forenbeiträge.';
$string['emptymessage'] = 'Bei Ihrem Beitrag ist ein Fehler aufgetreten. Eventuell haben Sie keinen Text eingegeben oder der Anhang war zu groß. Die Änderungen wurden nicht gespeichert.';
$string['errorcannotlock'] = 'Entschuldigung, aber Sie besitzen nicht die nötigen Rechte, um Themen zu sperren.';
$string['erroremptymessage'] = 'Die Mitteilung darf nicht leer sein.';
$string['erroremptysubject'] = 'Der Betreff darf nicht leer sein.';
$string['errorenrolmentrequired'] = 'Sie müssen in den Kurs eingeschrieben sein, um den Inhalt sehen zu können';
$string['errorwhiledelete'] = 'Beim Löschen des Beitrags ist ein Fehler aufgetreten.';
$string['eventassessableuploaded'] = 'Inhalte wurden bereitgestellt';
$string['eventcoursesearched'] = 'Kurs durchsucht';
$string['eventdiscussioncreated'] = 'Thema angelegt';
$string['eventdiscussiondeleted'] = 'Thema gelöscht';
$string['eventdiscussionmoved'] = 'Thema verschoben';
$string['eventdiscussionpinned'] = 'Thema angepinnt';
$string['eventdiscussionsubscriptioncreated'] = 'Themenabonnement angelegt';
$string['eventdiscussionsubscriptiondeleted'] = 'Themenabonnement gelöscht';
$string['eventdiscussionunpinned'] = 'Thema losgelöst';
$string['eventdiscussionupdated'] = 'Thema aktualisiert';
$string['eventdiscussionviewed'] = 'Thema angezeigt';
$string['eventpostcreated'] = 'Beitrag angelegt';
$string['eventpostdeleted'] = 'Beitrag gelöscht';
$string['eventpostupdated'] = 'Beitrag aktualisiert';
$string['eventreadtrackingdisabled'] = 'Forumstracking deaktiviert';
$string['eventreadtrackingenabled'] = 'Forumstracking aktiviert';
$string['eventsubscribersviewed'] = 'Abonnement/innen angezeigt';
$string['eventsubscriptioncreated'] = 'Abonnement angelegt';
$string['eventsubscriptiondeleted'] = 'Abonnement gelöscht';
$string['eventuserreportviewed'] = 'Nutzerübersicht angezeigt';
$string['everyonecanchoose'] = 'Alle dürfen entscheiden, ob sie das Forum abonnieren';
$string['everyonecannowchoose'] = 'Alle dürfen jetzt entscheiden, ob sie das Forum abonnieren';
$string['everyoneisnowsubscribed'] = 'Alle haben jetzt dieses Forum abonniert';
$string['everyoneissubscribed'] = 'Alle haben dieses Forum abonniert';
$string['existingsubscribers'] = 'Derzeitige Abonnenten';
$string['export'] = 'Export';
$string['exportattachmentname'] = 'Anhang {$a} ins Portfolio exportieren';
$string['exportdiscussion'] = 'Diskussion ins Portfolio exportieren';
$string['exporthumandates'] = 'Lesbare Zeitangaben';
$string['exporthumandates_help'] = 'Diese Option legt fest, ob Zeitangaben in einem für Menschen lesbaren Format oder als Zeitstempel (Folge von Zahlen) exportiert werden sollen.';
$string['exportoptions'] = 'Exportoptionen';
$string['exportstriphtml'] = 'HTML entfernen';
$string['exportstriphtml_help'] = 'Diese Option legt fest, ob HTML-Tags wie &lt;p&gt; und &lt;br&gt; aus der Mitteilung zum Forumsbeitrag entfernt werden sollen.';
$string['favourites'] = 'Markiert';
$string['favouriteupdated'] = 'Ihre Markierungsoption wurde aktualisiert.';
$string['firstpost'] = 'Erster Beitrag';
$string['forcedreadtracking'] = 'Verbindliches Forumstracking erlauben';
$string['forcedreadtracking_desc'] = 'Diese Option ermöglicht es in Foren, das Forumstracking für alle Nutzer/innen verbindlich vorzugeben. In Kursen mit vielen Foren und Beiträgen könnte sich die Ladezeit der Seite deutlich erhöhen. Wenn diese Option deaktiviert wird, wird ein vorher verbindliches Forumstracking zu einer optionalen Einstellung.';
$string['forcesubscribed'] = 'Dieses Forum muss von allen abonniert werden';
$string['forcesubscribed_help'] = 'Das Forum ist so eingestellt, dass Sie keine Themen abbestellen können.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Neues Forum hinzufügen';
$string['forum:addnews'] = 'Ankündigungen hinzufügen';
$string['forum:addquestion'] = 'Frage hinzufügen';
$string['forum:allowforcesubscribe'] = 'Einschreibung erzwingen zulassen';
$string['forum:canoverridecutoff'] = 'Nach dem letzten Eingabetermin ins Forum schreiben';
$string['forum:canoverridediscussionlock'] = 'In gesperrten Themen antworten';
$string['forum:canposttomygroups'] = 'Beiträge an alle Gruppen senden, zu denen Sie Zugriff hat';
$string['forum:cantogglefavourite'] = 'Themen mit Markierungen versehen';
$string['forum:createattachment'] = 'Anhänge hinzufügen';
$string['forum:deleteanypost'] = 'Alle Beiträge löschen (jederzeit)';
$string['forum:deleteownpost'] = 'Eigene Beiträge löschen (mit Zeitbegrenzung)';
$string['forum:editanypost'] = 'Alle Beiträge bearbeiten';
$string['forum:exportdiscussion'] = 'Gesamtes Thema exportieren';
$string['forum:exportforum'] = 'Forum exportieren';
$string['forum:exportownpost'] = 'Eigenen Beitrag exportieren';
$string['forum:exportpost'] = 'Beitrag exportieren';
$string['forum:grade'] = 'Forum bewerten';
$string['forum:managesubscriptions'] = 'Abonnements verwalten';
$string['forum:movediscussions'] = 'Themen verschieben';
$string['forum:pindiscussions'] = 'Themen anpinnen';
$string['forum:postprivatereply'] = 'Privat auf Beiträge antworten';
$string['forum:postwithoutthrottling'] = 'Keine Sperre bei zu vielen Beiträgen';
$string['forum:rate'] = 'Beiträge bewerten';
$string['forum:readprivatereplies'] = 'Private Antworten sehen';
$string['forum:replynews'] = 'Auf Ankündigungen antworten';
$string['forum:replypost'] = 'Auf Beiträge antworten';
$string['forum:splitdiscussions'] = 'Themen aufteilen';
$string['forum:startdiscussion'] = 'Neue Themen beginnen';
$string['forum:viewallratings'] = 'Alle Teilwertungen sehen';
$string['forum:viewanyrating'] = 'Alle Gesamtwertungen sehen';
$string['forum:viewdiscussion'] = 'Themen sehen';
$string['forum:viewhiddentimedposts'] = 'Verborgene zeitliche Beiträge sehen';
$string['forum:viewqandawithoutposting'] = 'Frage- und Antwortbeiträge immer sehen';
$string['forum:viewrating'] = 'Eigene Gesamtwertung sehen';
$string['forum:viewsubscribers'] = 'Abonnentenliste sehen';
$string['forumauthorhidden'] = 'Autor/in (verborgen)';
$string['forumblockingalmosttoomanyposts'] = 'Sie erreichen bald die Höchstzahl der zulässigen Beiträge. Sie haben {$a->numposts} Beiträge im Zeitraum {$a->blockperiod} veröffentlicht. Die Grenze ist bei {$a->blockafter} Beiträgen erreicht.';
$string['forumbodydeleted'] = 'Der Inhalt des Forumsbeitrags wurde gelöscht und kann nicht weiter angezeigt werden.';
$string['forumbodyhidden'] = 'Sie können diesen Beitrag momentan nicht anzeigen. Entweder haben Sie selber in dieser Diskussion noch nichts geschrieben oder die Bearbeitungszeit für den Beitrag läuft noch. Möglicherweise ist die aktuelle Zeit auch außerhalb der eingestellten Zeitspanne, während der der Beitrag angezeigt werden kann.';
$string['forumgrader'] = 'Bewertet/in für Forum';
$string['forumgradingnavigation'] = 'Navigation zur Forenbewertung';
$string['forumgradingpanel'] = 'Panel zur Forenbewertung';
$string['forumintro'] = 'Beschreibung';
$string['forumname'] = 'Forumsname';
$string['forumposts'] = 'Forumsbeiträge';
$string['forums'] = 'Foren';
$string['forumsubjectdeleted'] = 'Dieser Forumsbeitrag wurde gelöscht.';
$string['forumsubjecthidden'] = 'Betreff (verborgen)';
$string['forumtracked'] = 'Ungelesene Beiträge werden verfolgt';
$string['forumtrackednot'] = 'Ungelesene Beiträge werden nicht verfolgt';
$string['forumtype'] = 'Forumstyp';
$string['forumtype_help'] = 'Es gibt fünf verschiedene Forentypen:

* Diskussion zu einem Thema - Forum zu einem einzigen Thema, zu dem alle antworten dürfen. Dieser Typ funktioniert nicht mit separaten Gruppen.
* Jede Person darf genau ein Thema anlegen - Forum, in dem jede Person genau ein Thema beginnen darf. Alle Personen dürfen dann zu allen Themen antworten.
* Frage-Antwort-Forum - Forum, bei dem alle Personen zuerst einem eigenen Beitrag schreiben müssen, bevor sie die Beiträge der anderen sehen und darauf antworten können.
* Standardforum in blog-ähnlicher Anzeige - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema beginnen und auf alle Beiträge antworten kann. In einer Übersicht sind Betreffzeilen und die Beitragsanfänge sichtbar, zum jeweiligen Gesamtbeitrag und zu dessen Antworten führt ein Link.
* Standardforum - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema eröffnen und auf alle Beiträge antworten kann. In einer Übersicht sind alle Betreffzeilen zu sehen.';
$string['generalforum'] = 'Standardforum';
$string['generalforums'] = 'Allgemeines Forum';
$string['grade_forum_header'] = 'Bewertung des gesamten Forums';
$string['grade_forum_name'] = 'Ganzes Forum';
$string['grade_forum_title'] = 'Note';
$string['grade_rating_name'] = 'Bewerten ...';
$string['graded'] = 'Bewertet';
$string['gradedby'] = 'Bewertet von';
$string['gradeforrating'] = 'Note für Bewertung: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Note für Bewertung verborgen';
$string['gradeforwholeforum'] = 'Note für Forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Note für Forum verborgen';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = '{$a->name} Bewertung';
$string['gradeitemnameforwholeforum'] = '{$a->name} ganzes Forum';
$string['grades:gradesavedfor'] = 'Note gespeichert für {$a->fullname}';
$string['grades:gradesavefailed'] = 'Note für {$a->fullname} konnte nicht gespeichert werden: {$a->error}';
$string['gradeusers'] = 'Nutzer/innen bewerten';
$string['grading'] = 'Bewertung';
$string['gradingstatus'] = 'Bewertungsstatus:';
$string['hiddenforumpost'] = 'Verborgener Forumsbeitrag';
$string['hidegraderpanel'] = 'Bewerteroberfläche ausblenden';
$string['hidepreviousrepliescount'] = 'Vorherige Beiträge verbergen ({$a})';
$string['hideusersearch'] = 'Nutzersuche verbergen';
$string['indexoutoftotal'] = '{$a->index} von {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Forumsaktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Forum kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Forumsaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge, Feedback anzeigen, Feedback kommentieren, Beiträge nach Feedback überarbeiten).';
$string['indicator:socialbreadth'] = 'Forum sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Forumsaktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Forum sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Forumsaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein, Teilnahme mit anderen).';
$string['inforum'] = 'in {$a}';
$string['inpagereplysubject'] = 'Re: {$a}';
$string['inreplyto'] = 'Als Antwort auf {$a}';
$string['introblog'] = 'Die Beiträge in diesem Forum wurden automatisch aus Teilnehmerblogs des Kurses erstellt, weil die Blogeinträge nicht mehr verfügbar sind';
$string['intronews'] = 'Ankündigungen und Nachrichten';
$string['introsocial'] = 'Offenes Forum ohne Themeneinschränkung';
$string['introteacher'] = 'Forum für Traineranmerkungen und -diskussionen';
$string['invalidaccess'] = 'Seitenzugriff war nicht korrekt';
$string['invaliddigestsetting'] = 'Eine ungültige Einstellung für Mail-Zusammenfassungen wurde bereitgestellt.';
$string['invaliddiscussionid'] = 'Falsche Themen-ID';
$string['invalidforcesubscribe'] = 'Falscher Modus beim Abonnement ';
$string['invalidforumid'] = 'Falsche Foren-ID';
$string['invalidparentpostid'] = 'Vorgänger Beitrags-ID war ungültig.';
$string['invalidpostid'] = 'Ungültige Beitrags-ID {$a}';
$string['lastpost'] = 'Letzter Beitrag';
$string['learningforums'] = 'Lernforen';
$string['lockdiscussion'] = 'Dieses Thema sperren';
$string['lockdiscussionafter'] = 'Themen bei zu langer Inaktivität sperren';
$string['lockdiscussionafter_help'] = 'Themen können automatisch gesperrt werden, wenn eine angegebene Zeit seit der letzten Antwort überschritten ist.

Nutzer/innen mit dem Recht, in gesperrten Themen zu antworten, können ein Thema erneut öffnen und dort antworten.';
$string['locked'] = 'Gesperrt';
$string['lockupdated'] = 'Die Sperroption wurde aktualisiert.';
$string['longpost'] = 'Langer Beitrag';
$string['mailnow'] = 'Mitteilung ohne Verzögerung senden';
$string['managesubscriptionsoff'] = 'Abonnementverwaltung beenden';
$string['managesubscriptionson'] = 'Abonnements verwalten';
$string['manydiscussions'] = 'Themen pro Seite';
$string['markalldread'] = 'Alle Beiträge dieser Diskussion als gelesen markieren';
$string['markallread'] = 'Alle Beiträge in diesem Forum als gelesen markieren';
$string['markasread'] = 'Als gelesen markieren';
$string['markasreadonnotification'] = 'Beim Senden von Mitteilungen zum Forum';
$string['markasreadonnotification_help'] = 'Wenn Sie über einem Forumseintrag benachrichtigt werden, können Sie wählen, ob dies den Beitrag im Forumstracking als gelesen markieren soll.';
$string['markasreadonnotificationno'] = 'Markiere den Post nicht als gelesen';
$string['markasreadonnotificationyes'] = 'Markiere den Post als gelesen';
$string['markread'] = 'Als gelesen markieren';
$string['markreadbutton'] = 'Als gelesen<br />markieren';
$string['markunread'] = 'Als ungelesen markieren';
$string['markunreadbutton'] = 'Als ungelesen<br /> markieren';
$string['maxattachments'] = 'Anhänge (max.)';
$string['maxattachments_help'] = 'Diese Einstellung legt fest, wie viele Anhänge maximal pro Beitrag in diesem Forum erlaubt sind.';
$string['maxattachmentsize'] = 'Maximale Dateigröße';
$string['maxattachmentsize_help'] = 'Diese Einstellung legt fest, welche maximale Dateigröße pro Anhang in diesem Forum erlaubt ist.';
$string['maxtimehaspassed'] = 'Die Höchstdauer für die Bearbeitung dieses Eintrags ({$a}) ist überschritten!';
$string['message'] = 'Mitteilung';
$string['messageinboundattachmentdisallowed'] = 'Ihre Antwort kann nicht gepostet werden, weil sie einen Anhang beinhaltet und das Forum keine Anhänge akzeptiert.';
$string['messageinboundfilecountexceeded'] = 'Ihre Antwort kann nicht gepostet werden, weil sie mehr als die maximal erlaubte Anzahl von Anhängen beinhaltet  ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Ihre Antwort kann nicht gepostet werden, weil die Gesamtgröße der Anhänge  ({$a->filesize}) größer ist als die maximal erlaubte Größe für das Forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Ihre Antwort kann nicht gepostet werden, weil das Forum im Moment nicht verfügbar ist.';
$string['messageinboundnopostforum'] = 'Ihre Antwort kann nicht gepostet werden, weil Sie kein Recht haben, Beiträge im Forum {$a->forum->name} zu schreiben.';
$string['messageinboundthresholdhit'] = 'Ihre Antwort kann nicht gepostet werden, weil Sie wegen Überschreiten der Schwelle vorübergehend gesperrt wurden.';
$string['messageprovider:digests'] = 'Abonnierte Forenzusammenfassungen';
$string['messageprovider:posts'] = 'Abonnierte Forenbeiträge';
$string['missingsearchterms'] = 'Die folgenden Suchbegriffe tauchen lediglich in den HTML-Formatierungen dieser Mitteilung auf:';
$string['modeflatnewestfirst'] = 'Anzeige nach Zeit (neu > alt)';
$string['modeflatoldestfirst'] = 'Anzeige nach Zeit (alt > neu)';
$string['modenested'] = 'Anzeige in geschachtelter Form';
$string['modenestedv2'] = 'Antworten in experimentell verschachtelter Form';
$string['modethreaded'] = 'Anzeige in hierarchischer Form';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Richten Sie ein Forum ein, um den Personen in Ihrem Kurs die Gelegenheit zu geben, asynchrone Diskussionen zu führen, die über einen längeren Zeitraum stattfinden.

Es stehen verschiedene Forentypen zur Auswahl, z.B. ein Standardforum, in dem alle jederzeit eine neue Diskussion beginnen können; ein Forum, in dem jede/r Teilnehmer/in genau eine Diskussion posten kann; oder ein Frage-und-Antwort-Forum, in dem die Teilnehmer/innen zuerst Beiträge verfassen müssen, bevor sie die Beiträge anderer Teilnehmer/innen anzeigen können. Ein/e Trainer/in kann zulassen, dass Dateien an Forenbeiträge angehängt werden. Angehängte Bilder werden im Forumsbeitrag angezeigt.

Teilnehmer/innen können ein Forum abonnieren, um Benachrichtigungen über neue Forenbeiträge zu erhalten. Ein/e Trainer/in kann den Abonnementmodus auf optional, verbindlich oder automatisch einstellen oder das Abonnement vollständig verhindern. Bei Bedarf können Teilnehmer/innen daran gehindert werden, in einem bestimmten Zeitraum mehr als eine bestimmte Anzahl von Beiträgen zu veröffentlichen. Dies kann verhindern, dass Einzelpersonen Diskussionen dominieren.

Forenbeiträge können von Trainer/innen oder Teilnehmer/innen bewertet werden (Peer-Bewertung). Die Bewertungen können zu einer Endnote zusammengefasst werden, die in den Bewertungen festgehalten wird.

Die Aktivität Forum hat viele Verwendungsmöglichkeiten, wie z.B.

* Ein sozialer Raum für Teilnehmer/innen, um sich kennenzulernen
* Für Kursankündigungen (über ein Ankündigungen-Forum mit Zwangsabonnement)
* Zum Besprechen von Kursinhalten oder zum Lesen von Materialien
* Für die Fortsetzung einer Diskussion, die in einer persönlichen Sitzung begonnen wurde
* Für Diskussionen nur für Trainer/innen (über ein verborgenes Forum)
* Ein Hilfezentrum, in dem Tutoren/innen und Teilnehmer/innen Ratschläge geben können
* Als Bereich für eine 1:1-Unterstützung zwischen Teilnehmer/in und Trainer/in (über ein Forum mit separaten Gruppen und mit 1 Teilnehmer/in pro Gruppe)
* Für Erweiterungsaktivitäten, z.B. „Denksportaufgaben“, über die die Teilnehmer/innen nachdenken und Lösungen vorschlagen können';
$string['modulenameplural'] = 'Foren';
$string['more'] = 'weiter';
$string['movedmarker'] = '(Verschoben)';
$string['movethisdiscussionlabel'] = 'Bewegen Sie dieses Thema in das angegebene Forum';
$string['movethisdiscussionto'] = 'Das Thema verschieben nach ...';
$string['mustprovidediscussionorpost'] = 'Für den Export müssen Sie entweder eine Themen-ID oder eine Nachrichten-ID angeben';
$string['myprofileotherdis'] = 'Forumsthemen';
$string['myprofileowndis'] = 'Meine Forumsthemen';
$string['myprofileownpost'] = 'Meine Forenbeiträge';
$string['namenews'] = 'Ankündigungen';
$string['namenews_help'] = 'Das Ankündigungsforum ist ein Forum, das automatisch von Moodle in jedem Kurs und auch der Startseite generiert wird. Ausschließlich Trainer/innen und Administrator/innen dürfen im Ankündigungsforum schreiben. Pro Kurs kann es nur ein Ankündigungsforum geben. Im Block "Neuste Ankündigungen" werden die aktuelle Beiträge angezeigt.';
$string['namesocial'] = 'Soziales Forum';
$string['nameteacher'] = 'Trainerforum';
$string['newforumposts'] = 'Neue Forumsbeiträge';
$string['nextdiscussiona'] = 'Nächstes Thema: {$a}';
$string['nextuser'] = 'Änderungen speichern und zur nächsten Person';
$string['noattachments'] = 'Die Nachricht hat keine Anhänge';
$string['nodiscussions'] = 'Keine Themen im Forum';
$string['nodiscussionsstartedby'] = '\'{$a}\' hat noch kein Thema begonnen';
$string['nodiscussionsstartedbyyou'] = 'Sie haben noch kein Thema begonnen';
$string['noguestpost'] = 'Gäste dürfen keine Forumsbeiträge schreiben.';
$string['noguestsubscribe'] = 'Gäste können das Forum nicht abonnieren.';
$string['noguesttracking'] = 'Gäste dürfen keine Einstellungen vornehmen.';
$string['nomorepostscontaining'] = 'Es wurden keine weiteren Beiträge mit \'{$a}\' gefunden.';
$string['nonews'] = 'Keine Ankündigungen im Forum';
$string['noonecansubscribenow'] = 'Abonnements sind jetzt nicht erlaubt';
$string['nopermissiontosubscribe'] = 'Sie haben nicht das Recht, die Liste der Abonnenten im Forum anzuzeigen.';
$string['nopermissiontoview'] = 'Sie haben nicht das Recht, diesen Beitrag anzuzeigen.';
$string['nopostforum'] = 'Sie dürfen in diesem Forum eigenen keine Beiträge schreiben.';
$string['noposts'] = 'Keine Beiträge';
$string['nopostsmadebyuser'] = '\'{$a}\' hat keine Beiträge geschrieben';
$string['nopostsmadebyyou'] = 'Sie haben noch keine Beiträge geschrieben';
$string['noquestions'] = 'Keine Beiträge im Forum';
$string['nosubscribers'] = 'Keine Abonnent/innen im Forum';
$string['notexists'] = 'Diskussion existiert nicht länger';
$string['notgraded'] = 'Nicht bewertet';
$string['nothingnew'] = 'Nichts Neues für {$a}';
$string['notingroup'] = 'Das Forum steht nur Gruppenmitgliedern zur Verfügung.';
$string['notinstalled'] = 'Das Modul \'Forum\' ist nicht installiert.';
$string['notlocked'] = 'Sperren';
$string['notpartofdiscussion'] = 'Dieser Beitrag ist nicht Teil einer Diskussion!';
$string['notrackforum'] = 'Ungelesene Beiträge nicht markieren';
$string['notsubscribed'] = 'Abonnieren';
$string['nousersmatch'] = 'Für die angegebenen Kriterien wurden keine Nutzer/innen gefunden';
$string['noviewdiscussionspermission'] = 'Sie dürfen die Themen in diesem Forum nicht sehen';
$string['nowallsubscribed'] = 'Sie haben alle Foren in {$a} abonniert';
$string['nowallunsubscribed'] = 'Sie haben kein Forum in {$a} abonniert';
$string['nowgradinguser'] = 'Jetzt {$a} bewerten';
$string['nownotsubscribed'] = '{$a->name} wird künftig NICHT über Beiträge in \'{$a->forum}\' benachrichtigt';
$string['nownottracking'] = '{$a->name} will \'{$a->forum}\' nicht weiter verfolgen.';
$string['nowsubscribed'] = '{$a->name} wird künftig über Beiträge in \'{$a->forum}\' benachrichtigt';
$string['nowtracking'] = '{$a->name} verfolgt nun das \'{$a->forum}\'.';
$string['numberofreplies'] = 'Anzahl Antworten: {$a}';
$string['numposts'] = '{$a} Beiträge';
$string['olderdiscussions'] = 'Ältere Diskussionen';
$string['oldertopics'] = 'Ältere Themen';
$string['oldpostdays'] = '\'Gelesen\' nach x Tagen';
$string['overviewnumpostssince'] = 'Beiträge seit dem letzten Besuch: {$a}';
$string['overviewnumunread'] = 'Ungelesene Beiträge: {$a}';
$string['page-mod-forum-discuss'] = 'Forumsdiskussionsseite
';
$string['page-mod-forum-view'] = 'Forumshauptseite';
$string['page-mod-forum-x'] = 'Jede Forumsseite';
$string['parent'] = 'Ursprungsbeitrag';
$string['parentofthispost'] = 'Ursprungsbeitrag zum Beitrag';
$string['permalink'] = 'Dauerlink';
$string['permanentlinktoparentpost'] = 'Dauerhafter Link zum Ursprungsbeitrag dieses Beitrags';
$string['permanentlinktopost'] = 'Dauerhafter Link zu diesem Beitrag';
$string['pindiscussion'] = 'Dieses Thema anpinnen';
$string['pinupdated'] = 'Die Anpinnoption wurde aktualisiert.';
$string['pluginadministration'] = 'Forum-Administration';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Ihr Beitrag wurde erfolgreich hinzugefügt. </p><p>Wenn Sie etwas ändern möchten, haben Sie {$a} Zeit dafür.</p>';
$string['postaddedsuccess'] = 'Der Beitrag wurde erfolgreich eingefügt.';
$string['postaddedtimeleft'] = 'Wenn Sie etwas korrigieren möchten, haben Sie {$a} Zeit für diese Änderungen.';
$string['postbymailsuccess'] = 'Ihre Antwort \'{$a->subject}\' wurde erfolgreich hinzugefügt:{$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Ihre Antwort <a href="{$a->discussionurl}">{$a->subject}</a> wurde erfolgreich hinzugefügt.';
$string['postbyuser'] = '{$a->post} von {$a->user}';
$string['postincontext'] = 'Diskussion im Forum zeigen';
$string['postisprivatereply'] = 'Dies ist eine private Antwort, die ist nur sichtbar ist für Sie selber und für alle mit dem Recht, private Antworten zu sehen, wie Trainer/innen und Manager/innen.';
$string['postmailinfo'] = 'Dies ist eine Kopie einer Mitteilung, die in \'{$a}\' gepostet wurde.';
$string['postmailinfolink'] = 'Diese Mitteilung kommt aus dem Kurs \'{$a->coursename}\'.

Antworten Sie über diesen Link: {$a->replylink}';
$string['postmailnow'] = 'Dieser Beitrag wird direkt als E-Mail an alle Abonnent/innen des Forums versendet.';
$string['postmailreply'] = 'Zum Antworten klicken Sie auf diesen Link: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Nutzt Wissen über einzelne Fakten';
$string['postrating2'] = 'Reflektiert das Wissen in Einzelfällen';
$string['postrating3'] = 'Berücksichtigt den Gesamtzusammenhang und wägt Fakten ab';
$string['posts'] = 'Beiträge';
$string['postsfrom'] = 'Beiträge von';
$string['postsmadebyuser'] = 'Beiträge von {$a}';
$string['postsmadebyuserincourse'] = 'Beiträge von {$a->fullname} in {$a->coursename}';
$string['poststo'] = 'Beiträge an';
$string['posttoforum'] = 'Beitrag absenden';
$string['posttomygroups'] = 'Kopie an alle Gruppen senden';
$string['posttomygroups_help'] = 'Diesen Beitrag an alle Gruppen senden, zu denen Sie Zugriff haben. Teilnehmer/innen in den übrigen Gruppen können Ihren Beitrag nicht sehen.';
$string['postupdated'] = 'Der Beitrag wurde aktualisiert';
$string['potentialsubscribers'] = 'Mögliche Abonnent/innen';
$string['prevdiscussiona'] = 'Vorheriges Thema: {$a}';
$string['previoususer'] = 'Änderungen speichern und zur vorherigen Person';
$string['privacy:digesttypenone'] = 'Wir haben keine Daten zum bevorzugten Übersichtstyp für dieses Forum.';
$string['privacy:digesttypepreference'] = 'Sie haben den folgenden Übersichtstyp für das Forum ausgewählt: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Sie haben die folgende Abonnementeinstellung für das Forum ausgewählt: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Das Forum verwendet das Bewertungs-Subsystem, um eine Bewertung von Beiträgen zu ermöglichen.';
$string['privacy:metadata:core_tag'] = 'Das Forum verwendet das Tag-Subsystem, um Beiträge zu markieren, zu verschlagworten und zu kategorisieren.';
$string['privacy:metadata:forum_digests'] = 'Infos zur Tageszusammenfassung für jedes Forum';
$string['privacy:metadata:forum_digests:forum'] = 'Abonniertes Forum';
$string['privacy:metadata:forum_digests:maildigest'] = 'Einstellung zur Tageszusammenfassung';
$string['privacy:metadata:forum_digests:userid'] = 'Nutzer-ID mit der Tageszusammenfassung';
$string['privacy:metadata:forum_discussion_subs'] = 'Infos zu den Einschreibungen in einzelnen Forumsthemen';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID der Diskussion, in der die Person eingeschrieben ist';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Startzeit der Einschreibung';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID der Person, die in die Diskussion eingeschrieben ist';
$string['privacy:metadata:forum_discussions'] = 'Infos zu den individuellen Forumsthemen, die eine Person angelegt hat';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - was speichert dieses Feld?';
$string['privacy:metadata:forum_discussions:name'] = 'Thema, das für die Diskussion gewählt wurde';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Zeit, zu der das Thema zuletzt geändert wurde';
$string['privacy:metadata:forum_discussions:userid'] = 'ID der Person, die die Diskussion gestartet hat';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID der Person, die die Diskussion zuletzt bearbeitet hat';
$string['privacy:metadata:forum_grades'] = 'Bewertungsdaten für das Forum';
$string['privacy:metadata:forum_grades:forum'] = 'Forum, das bewertet wird';
$string['privacy:metadata:forum_grades:grade'] = 'Zugewiesene Note';
$string['privacy:metadata:forum_grades:userid'] = 'ID der Person, die bewertet hat';
$string['privacy:metadata:forum_posts'] = 'Infos über die Tageszusammenfassung  für jedes Forum';
$string['privacy:metadata:forum_posts:created'] = 'Zeit, zu der der Beitrag angelegt wurde.';
$string['privacy:metadata:forum_posts:discussion'] = 'Thema, zu dem der Beitrag gehört.';
$string['privacy:metadata:forum_posts:message'] = 'Mitteilung des Forumsbeitrags.';
$string['privacy:metadata:forum_posts:modified'] = 'Zeit, zu der der Beitrag zuletzt geändert wurde.';
$string['privacy:metadata:forum_posts:parent'] = 'Ursprungsbeitrag, auf den geantwortet wird';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID der Person, an die diese Antwort gesendet wurde.';
$string['privacy:metadata:forum_posts:subject'] = 'Betreff des Forumsbeitrags.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Mitteilung des Forumsbeitrags.';
$string['privacy:metadata:forum_posts:userid'] = 'ID der Person, die den Forumsbeitrag angelegt hat';
$string['privacy:metadata:forum_queue'] = 'Temporärer Log für Beiträge, die mit der Tageszusammenfassung gesendet werden.';
$string['privacy:metadata:forum_queue:discussionid'] = 'Themen-ID im Forum';
$string['privacy:metadata:forum_queue:postid'] = 'Beitrags-ID im Forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'Änderungszeitpunkt des originalen Beitrags';
$string['privacy:metadata:forum_queue:userid'] = 'Person, die über den Beitrag informiert werden soll';
$string['privacy:metadata:forum_read'] = 'Infos über gelesene Beiträge dieser Person';
$string['privacy:metadata:forum_read:discussionid'] = 'Thema, zu dem der Beitrag gehört.';
$string['privacy:metadata:forum_read:firstread'] = 'Zeit, zu der der Beitrag das erste Mal gelesen wurde.';
$string['privacy:metadata:forum_read:lastread'] = 'Zeit, zu der der Beitrag zum letzten Mal gelesen wurde.';
$string['privacy:metadata:forum_read:postid'] = 'Beitrag, der gelesen wurde.';
$string['privacy:metadata:forum_read:userid'] = 'ID der Person, zu der dieser Datensatz gehört.';
$string['privacy:metadata:forum_subscriptions'] = 'Infos, welche Themen diese Person abonniert hat.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum, das Nutzer abonniert hat';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID des Nutzers, der dem Forum zugeordnet ist';
$string['privacy:metadata:forum_track_prefs'] = 'Information welche Foren der Nutzer für die Lesemarkierung gewählt hat';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum, das Lesemarkierung aktiviert hat';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID des Nutzers, dem Forum Lesemarkierung zugeordnet ist';
$string['privacy:metadata:preference:autosubscribe'] = 'Ob Forum abonniert wird, wenn man dort einen Beitrag erstellt hat';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Die bevozugte Sortierreihenfolge von Themenlisten';
$string['privacy:metadata:preference:maildigest'] = 'Systemweite Einstellung für E-Mail-Digests';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Ob Forenbeiträge als gelesen gekennzeichnet werden sollen, wenn Mitteilung versandt wird';
$string['privacy:metadata:preference:trackforums'] = 'Ob Lesekennzeichnug markiert wird';
$string['privacy:postwasread'] = 'Der Beitrag wurde erstmals am {$a->firstread} und zuletzt am  {$a->lastread} gelesen.';
$string['privacy:readtrackingdisabled'] = 'Sie haben festgelegt, dass der Lesestatus für Forenbeiträge nicht getrackt wird.';
$string['privacy:request:delete:discussion:name'] = 'Löschen auf Anfrage des Nutzers';
$string['privacy:request:delete:post:message'] = 'Der Inhalt dieses Beitrags wird';
$string['privacy:request:delete:post:subject'] = 'Auf Anforderung des Autors löschen';
$string['privacy:subscribedtoforum'] = 'Sie haben dieses Forum abonniert.';
$string['privatereply'] = 'Privat antworten';
$string['privatereply_help'] = 'Eine private Antwort kann nur vom Autor des Beitrags, auf den geantwortet wird, und von Personen mit dem Recht \'Private Antworten sehen\' angezeigt werden.';
$string['processingdigest'] = 'Verarbeitung der E-Mail-Zusammenfassung für {$a}';
$string['processingpost'] = 'Beitrag {$a} wird bearbeitet';
$string['prune'] = 'Thema teilen';
$string['prunedpost'] = 'Mit diesem Beitrag wurde ein neues Thema begonnen';
$string['pruneheading'] = 'Das Thema teilen und mit diesem Beitrag ein neues Thema beginnen';
$string['qandaforum'] = 'Frage-Antwort-Forum';
$string['qandanotify'] = 'In diesem Frage-Antwort-Forum müssen Sie zuerst eine eigene Antwort eintragen, bevor Sie die Antworten anderer Personen sehen können';
$string['re'] = 'Re:';
$string['readtherest'] = 'Weiter lesen';
$string['removeallforumtags'] = 'Alle Foren-Tags entfernen';
$string['removefromfavourites'] = 'Themenmarkierung entfernen';
$string['replies'] = 'Antworten';
$string['repliesmany'] = '{$a} Antworten';
$string['repliesone'] = '{$a} Antwort bis jetzt';
$string['reply'] = 'Antworten';
$string['reply_handler'] = 'Auf Forumsbeiträge per E-Mail antworten';
$string['reply_handler_name'] = 'Auf Forumsbeiträge antworten';
$string['replyauthorself'] = '{$a} (Sie)';
$string['replyforum'] = 'Im Forum antworten';
$string['replyingtoauthor'] = 'Antworten an {$a}...';
$string['replyplaceholder'] = 'Schreiben Sie Ihre Antwort …';
$string['replytopostbyemail'] = 'Sie können auf diesen Beitrag direkt per E-Mail antworten.';
$string['replytouser'] = 'E-Mail-Adresse in Antwort nutzen';
$string['resetdigests'] = 'Alle nutzerspezifischen Einstellungen für Forenzusammenfassungen löschen';
$string['resetforums'] = 'Beiträge entfernen von';
$string['resetforumsall'] = 'Alle Beiträge löschen';
$string['resetsubscriptions'] = 'Alle Forumsabonnements entfernen';
$string['resettrackprefs'] = 'Alle Einstellungen zum Forumstracking löschen';
$string['rssarticles'] = 'Anzahl der neuen RSS-Artikel';
$string['rssarticles_help'] = 'Diese Einstellung legt die Anzahl der Beiträge fest, die als aktuell in
den RSS Feed übernommen werden. Eine Zahl zwischen 5 und 20 sollte bei den meisten Foren angemessen sein. Eine höhere Zahl ist erforderlich, wenn das Forum sehr aktiv ist.';
$string['rsssubscriberssdiscussions'] = 'RSS Feed für Themen';
$string['rsssubscriberssposts'] = 'RSS-Feed für Beiträge';
$string['rsstype'] = 'RSS Feed für diese Aktivität';
$string['rsstype_help'] = 'Um RSS Feeds für diese Aktivität zu aktivieren, wählen Sie entweder Themen oder Beiträge für diesen Feed aus.';
$string['rsstypedefault'] = 'RSS Feed Typ';
$string['search'] = 'Suche';
$string['search:activity'] = 'Forum - Aktivitätsinfo';
$string['search:post'] = 'Forum - Beiträge';
$string['searchdatefrom'] = 'Beiträge müssen neuer sein als';
$string['searchdateto'] = 'Beiträge müssen älter sein als';
$string['searchforumintro'] = 'Tragen Sie die Suchbegriffe in einem oder mehreren Feldern ein:';
$string['searchforums'] = 'Foren durchsuchen';
$string['searchfullwords'] = 'Vollständige Wörter suchen';
$string['searchnotwords'] = 'Wörter sollen NICHT im Suchergebnis vorkommen';
$string['searcholderposts'] = 'Ältere Beiträge suchen...';
$string['searchphrase'] = 'Dieser Text muss genau so im Beitrag vorkommen';
$string['searchresults'] = 'Suchergebnisse';
$string['searchsubject'] = 'Wörter sollen im Betreff vorkommen';
$string['searchtags'] = 'Ist versehen mit Tag';
$string['searchuser'] = 'Name des Autors/der Autorin';
$string['searchuserid'] = 'Moodle-ID des Autors/der Autorin';
$string['searchusers'] = 'Teilnehmersuche';
$string['searchwhichforums'] = 'Forum für Suche auswählen';
$string['searchwords'] = 'Wörter können an beliebiger Stelle des Beitrags auftauchen';
$string['seeallposts'] = 'Alle Beiträge dieser Person ansehen';
$string['sendstudentnotificationsdefault'] = 'Standardeinstellung für "Teilnehmer/innen benachrichtigen"';
$string['sendstudentnotificationsdefault_help'] = 'Setzen Sie den Standardwert für das Kontrollkästchen "Teilnehmer/innen benachrichtigen" auf der Bewerteroberfläche.';
$string['sendstudentnotificationsno'] = 'Nein';
$string['sendstudentnotificationsyes'] = 'Ja, Teilnehmer/innen benachrichtigen';
$string['settings'] = 'Einstellungen';
$string['shortpost'] = 'Kurzer Beitrag';
$string['showgraderpanel'] = 'Bewerteroberfläche zeigen';
$string['showingcountoftotaldiscussions'] = 'Liste der Themen - {$a->count} von {$a->total}';
$string['showmoreusers'] = 'Weitere Nutzer/innen anzeigen';
$string['showpreviousrepliescount'] = 'Vorherige Beiträge anzeigen ({$a})';
$string['showsubscribers'] = 'Abonnentenliste';
$string['showusersearch'] = 'Teilnehmersuche zeigen';
$string['singleforum'] = 'Diskussion zu einzelnem Thema';
$string['smallmessage'] = '{$a->user} schrieb in {$a->forumname}';
$string['smallmessagedigest'] = 'Die Tageszusammenfassung enthält {$a} Mitteilungen';
$string['starredonly'] = 'Nur Themen mit Markierungen suchen';
$string['startedby'] = 'Begonnen von';
$string['subject'] = 'Betreff';
$string['subscribe'] = 'Ich möchte das Forum abonnieren';
$string['subscribeall'] = 'Alle Teilnehmer/innen haben in dieses Forum abonniert';
$string['subscribed'] = 'Abonniert';
$string['subscribediscussion'] = 'Thema abonnieren';
$string['subscribeenrolledonly'] = 'Nur eingeschriebene Personen dürfen Forenbeiträge als Mitteilung abonnieren.';
$string['subscribenone'] = 'Forum für alle Teilnehmer/innen abbestellen';
$string['subscribers'] = 'Abonnent/innen';
$string['subscriberstowithcount'] = 'Abonnent/innen für \'{$a->name}\' ({$a->count})';
$string['subscribestart'] = 'Mitteilungen über neue Forenbeiträge an mich senden';
$string['subscribestop'] = 'Ich möchte nicht über neue Beiträge in dieesem Forum benachrichtigt werden';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Wenn Sie ein Forum abonniert haben, werden alle neuen Forenbeiträge als Mitteilung an Sie gesendet.

Normalerweise dürfen Sie auswählen, ob Sie die Beiträge bekommen möchten. Manche Foren sind aber so eingestellt, dass das Abonnement verpflichtend ist und jeder alle Beiträge bekommt.';
$string['subscriptionandtracking'] = 'Abonnement und Tracking';
$string['subscriptionauto'] = 'Automatisch';
$string['subscriptiondisabled'] = 'Deaktiviert';
$string['subscriptionforced'] = 'Verbindliches Abonnement';
$string['subscriptionmode'] = 'Abonnement';
$string['subscriptionmode_help'] = 'Alle Abonnent/innen dieses Forums bekommen die Beiträge als Mitteilungen gesendet. Es gibt unterschiedliche Modi für ein Abonnement:

* Optional - alle dürfen auswählen, ob sie das Forum abonnieren möchten oder nicht
* Verpflichtend - alle haben das Forum abonniert und niemand kann es abbestellen
* Automatisch - alle haben das Forum abonniert, dürfen es aber jederzeit abbestellen
* Deaktiviert - Das Forum kann von niemandem abonniert werden';
$string['subscriptionoptional'] = 'Optional';
$string['subscriptions'] = 'Abonnements';
$string['tagarea_forum_posts'] = 'Forenbeiträge';
$string['tagsdeleted'] = 'Foren-Tags wurden gelöscht';
$string['thisforumhasduedate'] = 'Das Fälligkeitsdatum, um in dieses Forum zu schreiben, ist {$a}.';
$string['thisforumisdue'] = 'Das Fälligkeitsdatum, um diesem Forum zu schreiben, war {$a}.';
$string['thisforumisthrottled'] = 'Für dieses Forum ist eine Höchstzahl von Beiträgen innerhalb eines bestimmten Zeitraums festgelegt worden. Dies gilt nach {$a->blockafter} Beiträgen innerhalb von {$a->blockperiod}';
$string['timed'] = 'Zeitlich festgelegt';
$string['timeddiscussion'] = 'Zeitlich festgelegtes Thema';
$string['timedhidden'] = 'Zeitgesteuerter Status: Für Teilnehmer/innen verborgen';
$string['timedposts'] = 'Zeitgesteuerte Beiträge';
$string['timedvisible'] = 'Zeitgesteuerter Status: Für Teilnehmer/innen sichtbar';
$string['timestartenderror'] = 'Das Forumsende muss nach dem Forumsbeginn liegen.';
$string['togglediscussionmenu'] = 'Themenmenü umschalten';
$string['togglefullscreen'] = 'Auf Vollbildschirm umschalten';
$string['togglesettingsdrawer'] = 'Einstellungsleiste umschalten';
$string['trackforum'] = 'Ungelesene Beiträge markieren';
$string['tracking'] = 'Markieren?';
$string['trackingoff'] = 'Aus';
$string['trackingon'] = 'Verbindlich';
$string['trackingoptional'] = 'Optional';
$string['trackingtype'] = 'Forumstracking';
$string['trackingtype_help'] = 'Mithilfe der Leseverfolgung können Teilnehmer/innen sehen, welche Beiträge sie noch nicht gesehen haben.

* Optional - Die Markierung ist ein- und ausschaltbar. Teilnehmer/innen finden dafür eine Einstellung im Aktionsmenü oder in der Forumsadministration. Sie müssen vorher das Forumstracking in den persönlichen Einstellungen aktiviert haben.
* Verbindlich - Wenn in der Website-Administration die Option \'Verbindliches Forumstracking erlauben\' aktiviert ist, ist eine weitere Option \'Verbindlich\' verfügbar. Hierbei ist das Forumstracking immer aktiviert, unabhängig von den persönlichen Nutzereinstellungen.';
$string['trackreadposts_header'] = 'Forumstracking';
$string['unlockdiscussion'] = 'Dieses Thema entsperren';
$string['unpindiscussion'] = 'Dieses Thema abpinnen';
$string['unread'] = 'Ungelesen';
$string['unreadpost'] = 'Ungelesener Beitrag';
$string['unreadposts'] = 'Ungelesene Beiträge';
$string['unreadpostsnumber'] = '{$a} ungelesene Beiträge';
$string['unreadpostsone'] = '1 ungelesener Beitrag';
$string['unsubscribe'] = 'Ich möchte das Forum abbestellen';
$string['unsubscribeall'] = 'Ich möchte alle Foren abbestellen';
$string['unsubscribeallconfirm'] = 'Sie haben aktuell abonniert: Foren {$a->Forums} und Themen {$a->discussions}. Möchten Sie wirklich alle Foren und Themen abbestellen und das automatische Abonnement deaktivieren?';
$string['unsubscribeallconfirmdiscussions'] = 'Sie haben aktuell abonniert: Themen {$a->discussions}. Möchten Sie wirklich alle Themen abbestellen und das automatische Abonnement deaktivieren?';
$string['unsubscribeallconfirmforums'] = 'Sie haben aktuell abonniert: Foren {$a->Forums}. Möchten Sie wirklich alle Foren abbestellen und das automatische Abonnement deaktivieren?';
$string['unsubscribealldone'] = 'Sie haben alle optionalen Abonnements abbestellt. Trotzdem werden Sie Beiträge aus Foren mit verbindlichen Abonnements erhalten. Die Forums-Benachrichtigungen können Sie in den Einstellungen Ihres Nutzerprofils verwalten.';
$string['unsubscribeallempty'] = 'Sie haben kein Forum abonniert. Die Systemnachrichten können Sie in den Einstellungen Ihres Nutzerprofils vollständig deaktivieren.';
$string['unsubscribed'] = 'Abgemeldet';
$string['unsubscribediscussion'] = 'Von diesem Thema abmelden';
$string['unsubscribediscussionlink'] = 'Von diesem Thema abmelden: {$a}';
$string['unsubscribelink'] = 'Aus diesem Forum abmelden: {$a}';
$string['unsubscribeshort'] = 'Abmelden';
$string['useexperimentalui'] = 'Experimentelle verschachtelte Themenansicht verwenden';
$string['usermarksread'] = '\'Gelesen\' manuell markieren';
$string['usernavigation'] = 'Nutzernavigation';
$string['usersforumposts'] = 'Forenbeiträge der Person';
$string['viewalldiscussions'] = 'Alle Themen anzeigen';
$string['viewconversation'] = 'Thema anzeigen';
$string['viewgrades'] = 'Bewertungen anzeigen';
$string['viewparentpost'] = 'Ursprungsbeitrag anzeigen';
$string['viewthediscussion'] = 'Thema anzeigen';
$string['warnafter'] = 'Warnung';
$string['warnafter_help'] = 'Vor dem Erreichen der Beitragshöchstzahl innerhalb des Zeitfensters können die Nutzer/innen gewarnt werden. Die Einstellung legt fest, nach wie vielen Beiträgen die Warnung gezeigt wird. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['warnformorepost'] = 'Warnung! Es gibt mehr als eine Diskussion in diesem Forum. Es wird die Aktuellste genutzt.';
$string['yournewquestion'] = 'Neue Frage';
$string['yournewtopic'] = 'Neues Thema';
$string['yourreply'] = 'Antwort';
