<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'board', language 'de', version '3.10'.
 *
 * @package     board
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Cancel'] = 'Abbrechen';
$string['Ok'] = 'OK';
$string['addrating'] = 'Beiträge bewerten';
$string['addrating_all'] = 'von allen';
$string['addrating_none'] = 'Deaktiviert';
$string['addrating_students'] = 'von Teilnehmer/innen';
$string['addrating_teachers'] = 'von Trainer/innen';
$string['aria_addmedia'] = '{type} für den Beitrag {post} aus Spalte {column} hinzufügen';
$string['aria_addmedianew'] = '{type} für den neuen Beitrag aus Spalte {column} hinzufügen';
$string['aria_canceledit'] = 'Bearbeitung für den Beitrag {post} aus Spalte {column} abbrechen';
$string['aria_cancelnew'] = 'Neuen Beitrag für die Spalte {column} abbrechen';
$string['aria_choosefileedit'] = 'Datei für den Beitrag {post} aus Spalte {column} auswählen';
$string['aria_choosefilenew'] = 'Datei für den neuen Beitrag aus Spalte {column} auswählen';
$string['aria_deleteattachment'] = 'Anhang für den Beitrag {post} aus Spalte {column} löschen';
$string['aria_deletecolumn'] = 'Spalte {column} löschen';
$string['aria_deletepost'] = 'Beitrag {post} aus Spalte {column} löschen';
$string['aria_newcolumn'] = 'Neue Spalte hinzufügen';
$string['aria_newpost'] = 'Neuen Beitrag zu Spalte {column} hinzufügen';
$string['aria_postedit'] = 'Bearbeitung für den Beitrag {post} aus Spalte {column} speichern';
$string['aria_postnew'] = 'Neuen Beitrag für die Spalte {column} speichern';
$string['aria_ratepost'] = 'Beitrag {post} aus der Spalte {column} bewerten';
$string['background_color'] = 'Hintergrundfarbe';
$string['background_image'] = 'Hintergrundbild';
$string['board:addinstance'] = 'Eine neue Board-Ressource hinzufügen';
$string['board:manageboard'] = 'Spalten und alle Beiträge bearbeiten';
$string['board:view'] = 'Board-Inhalt sehen und eigene Beiträge bearbeiten';
$string['boardsettings'] = 'Board-Einstellungen';
$string['cancel_button_text'] = 'Abbrechen';
$string['choose_file'] = 'Bilddatei auswählen';
$string['default_column_heading'] = 'Überschrift';
$string['event_add_column'] = 'Spalte hinzugefügt';
$string['event_add_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat die Boardspalte mit der ID \'{$a->objectid}\' und dem Namen \'{$a->name}\' erstellt.';
$string['event_add_note'] = 'Beitrag hinzugefügt';
$string['event_add_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat einen Boardbeitrag mit der ID \'{$a->objectid}\', der Überschrift \'{$a->heading}\', dem Inhalt \'{$a->content}\' und den Medien \'{$a->media}\' in der Spalte ID \'{$a->columnid}\' und der Gruppen-ID \'{$a->groupid}\' erstellt.';
$string['event_delete_column'] = 'Spalte gelöscht';
$string['event_delete_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat die Boardspalte mit der ID \'{$a->columnid}\' gelöscht.';
$string['event_delete_note'] = 'Beitrag gelöscht';
$string['event_delete_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat den Boardbeitrag mit der ID \'{$a->objectid}\' aus der Spalte ID \'{$a->columnid}\' gelöscht.';
$string['event_move_note'] = 'Beitrag verschoben';
$string['event_move_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat den Boardbeitrag mit der ID \'{$a->objectid}\' in die Spalte ID \'{$a->columnid}\' verschoben.';
$string['event_rate_note'] = 'Beitrag bewertet';
$string['event_rate_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat den Boardbeitrag mit der ID \'{$a->objectid}\' mit der Bewertung \'{$a->rating}\' bewertet.';
$string['event_update_column'] = 'Spalte aktualisiert';
$string['event_update_column_desc'] = 'Nutzer/in \'{$a->userid}\' hat die Boardspalte mit der ID \'{$a->columnid}\' zu \'{$a->name}\' aktualisiert.';
$string['event_update_note'] = 'Beitrag aktualisiert';
$string['event_update_note_desc'] = 'Nutzer/in \'{$a->userid}\' hat einen Boardbeitrag mit der ID \'{$a->objectid}\' zu der Überschrift \'{$a->heading}\', dem Inhalt \'{$a->content}\' und den Medien \'{$a->media}\' in der Spalte ID \'{$a->columnid}\' aktualisiert.';
$string['export_board'] = 'CSV exportieren';
$string['export_content'] = 'Beitragstext';
$string['export_email'] = 'E-Mail';
$string['export_firstname'] = 'Vorname';
$string['export_heading'] = 'Beitragsüberschrift';
$string['export_info'] = 'Beitragstitel';
$string['export_lastname'] = 'Nachname';
$string['export_submissions'] = 'Einrechungen exportieren';
$string['export_timecreated'] = 'Erstellungsdatum';
$string['export_url'] = 'Beitrags-URL';
$string['groupingid_required'] = 'Eine Kursgruppierung muss für diesen Gruppenmodus ausgewählt werden';
$string['hideheaders'] = 'Spaltentitel vor Teilnehmer/innen verbergen';
$string['history_refresh'] = 'Timer für die Aktualisierung des Boards';
$string['history_refresh_desc'] = 'Timeout in Sekunden zwischen automatischen Aktualisierungen des Boards. Bei einem Wert von 0 oder leer wird das Board nur bei Aktionen (Hinzufügen/Aktualisieren/etc.) aktualisiert.';
$string['invalid_file_extension'] = 'Die Dateierweiterung wird für den Upload nicht akzeptiert.';
$string['invalid_file_size_max'] = 'Die Datei ist zu groß, um akzeptiert zu werden.';
$string['invalid_file_size_min'] = 'Die Datei ist zu klein, um akzeptiert zu werden.';
$string['media_selection'] = 'Medienauswahl';
$string['media_selection_buttons'] = 'Buttons';
$string['media_selection_desc'] = 'Legen Sie fest, wie die Medienauswahl für Beiträge angezeigt werden soll.';
$string['media_selection_dropdown'] = 'Dropdown';
$string['modulename'] = 'Board';
$string['modulename_help'] = 'Dies ist eine Aktivität für Moodle, mit der Trainer/innen eine neue "Postit"-Tafel erstellen können.';
$string['modulenameplural'] = 'Boards';
$string['new_column_icon'] = 'Icon für neue Spalte';
$string['new_column_icon_desc'] = 'Icon, das auf den Buttons für eine neue Spalte angezeigt wird';
$string['new_note_icon'] = 'Icon für neuen Beitrag';
$string['new_note_icon_desc'] = 'Icon, das auf den Buttons für einen neuen Beitrag angezeigt wird';
$string['note_changed_text'] = 'Der Beitrag, den Sie gerade bearbeiten, wurde geändert.\\nDrücken Sie \'OK\', um den aktualisierten Beitrag anzusehen, oder \'Abbrechen\', um weiter zu bearbeiten.';
$string['note_deleted_text'] = 'Der Beitrag, den Sie am bearbeiten waren, wurde gelöscht.';
$string['option_empty'] = 'Keine';
$string['option_image'] = 'Bild';
$string['option_image_info'] = 'Bildtitel';
$string['option_image_url'] = 'Bild-URL';
$string['option_link_info'] = 'Linktitel';
$string['option_link_url'] = 'Link-URL';
$string['option_youtube'] = 'Video (YouTube)';
$string['option_youtube_info'] = 'Videotitel';
$string['option_youtube_url'] = 'Video-URL';
$string['pluginadministration'] = 'Board-Administration';
$string['pluginname'] = 'Board';
$string['post_button_text'] = 'Senden';
$string['post_max_length'] = 'Maximale Beitragslänge';
$string['post_max_length_desc'] = 'Die maximal zulässige Länge des Inhalts. Alles, was über diese Länge hinausgeht, wird abgeschnitten.';
$string['postbydate'] = 'Beiträge nach Datum';
$string['postbyenabled'] = 'Beiträge von Studierenden nach Datum einschränken';
$string['rate_note_text'] = 'Möchten Sie diesen Beitrag wirklich bewerten?';
$string['remove_column_text'] = 'Alle Beiträge zu dieser Spalte werden zusammen mit der Spalte selbst gelöscht.\\nMöchten Sie diese Spalte wirklich löschen?';
$string['remove_note_text'] = 'Dies wirkt sich auch auf alle anderen Nutzer/innen aus.\\nMöchten Sie diesen Beitrag wirklich löschen?';
$string['sortby'] = 'Sortiert nach';
$string['sortbydate'] = 'Erstellungsdatum';
$string['sortbyrating'] = 'Bewertung';
$string['warning'] = 'Benachrichtigung';
