<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'es_mx', version '3.10'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Puede previsualizar este examen, pero si este fuera un intento real, Usted estaría bloqueado debido a que :';
$string['action'] = 'Acción';
$string['activityoverview'] = 'Usted tiene exámenes pendientes';
$string['adaptive'] = 'Modo adaptativo';
$string['adaptive_help'] = 'Si se activa, se permite más de un intento de respuesta a una pregunta dentro del mismo intento de resolver el examen. Por ejemplo, si una respuesta se marca como incorrecta, el alumno podrá volver a intentarlo de inmediato. Sin embargo, según se establezca "Aplicar penalizaciones", se restará una penalización por cada intento equivocado.';
$string['add'] = 'Añadir';
$string['addaquestion'] = 'una nueva pregunta';
$string['addarandomquestion'] = 'una pregunta aleatoria';
$string['addarandomquestion_help'] = 'Cuando se añade una pregunta aleatoria, se traduce en que en el examen se inserta una pregunta seleccionada aleatoriamente de entre las que componen la categoría. Esto significa que los distintos alumnos tendrán probablemente una selección distinta de preguntas. Por otra parte, cuando el examen permite múltiples intentos, cada uno de ellos probablemente contendrá una nueva selección de preguntas.';
$string['addarandomselectedquestion'] = 'Añadir una pregunta seleccionada aleatoriamente ...';
$string['addasection'] = 'un nuevo encabezado de sección';
$string['adddescriptionlabel'] = 'Agregar un ítem de descripción';
$string['addingquestion'] = 'Agregando una pregunta';
$string['addingquestions'] = 'Esta parte de la página es el lugar para administrar su BasedeDatos de preguntas. Las preguntas se almacenan en categorías, para ayudarlo a tenerlas organizadas, y pueden ser utilizadas por cualquier examen en su curso o inclusive en otro curso si usted decidiera \'publicarlas\'.</p>
<p>Después de seleccionar o crear una categoría para preguntas, Usted podrá crear o editar preguntas. Puede seleccionar cualquiera de esas preguntas para agregarlas a su examen del otro lado de esta página.</p>';
$string['addmoreoverallfeedbacks'] = 'Agregar {no} campos más de retroalimentación';
$string['addnewgroupoverride'] = 'Agregar anulación de grupo';
$string['addnewpagesafterselected'] = 'Agregar nuevas páginas después de las preguntas seleccionadas';
$string['addnewquestionsqbank'] = 'Agregar preguntas a la categoría {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Agregar anulación de usuario';
$string['addpagebreak'] = 'Añadir salto de página';
$string['addpagehere'] = 'Agregar una página aquí';
$string['addquestion'] = 'Agregar pregunta';
$string['addquestionfrombankatend'] = 'Añadir del banco de preguntas al final';
$string['addquestionfrombanktopage'] = 'Añadir del banco de preguntas a la página {$a}';
$string['addquestions'] = 'Agregar preguntas';
$string['addquestionstoquiz'] = 'Agregar preguntas al examen actual';
$string['addrandom'] = 'Agregar {$a} preguntas aleatorias';
$string['addrandom1'] = '<< Agregar';
$string['addrandom2'] = 'preguntas aleatorias';
$string['addrandomfromcategory'] = 'Agregar preguntas aleatorias de la categoría:';
$string['addrandomquestion'] = 'Agregar pregunta aleatoria';
$string['addrandomquestionatend'] = 'Añadir una pregunta aleatoria al final';
$string['addrandomquestiontopage'] = 'Añadir una pregunta aleatoria a la página {$a}';
$string['addrandomquestiontoquiz'] = 'Agregar pregunta aleatoria al examen {$a}';
$string['addselectedquestionstoquiz'] = 'Añadir preguntas seleccionadas al examen';
$string['addselectedtoquiz'] = 'Agregar seleccionadas al examen';
$string['addtoquiz'] = 'Añadir al examen';
$string['affectedstudents'] = '{$a} afectados';
$string['aftereachquestion'] = 'Después de agregar cada pregunta';
$string['afternquestions'] = 'Después de agregar {$a} preguntas';
$string['age'] = 'edad';
$string['allattempts'] = 'Todos los intentos';
$string['allinone'] = 'Sin límite';
$string['allowreview'] = 'Permitir revisión';
$string['alreadysubmitted'] = 'Parece que usted ya contestó este examen';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Siempre disponible';
$string['analysisoptions'] = 'Opciones de análisis';
$string['analysistitle'] = 'Tabla de análisis de ítems';
$string['answer'] = 'Respuesta';
$string['answered'] = 'Contestadas';
$string['answerhowmany'] = '¿Una o varias respuestas?';
$string['answers'] = 'Soluciones correctas (patrón)';
$string['answersingleno'] = 'Se permiten varias respuestas';
$string['answersingleyes'] = 'Sólo una respuesta';
$string['answertoolong'] = 'Respuesta demasiado larga después de la línea {$a} (máx. 255 caracteres)';
$string['anytags'] = 'Cualquier marca';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = '¿Está seguro de que quiere eliminar todas las preguntas seleccionadas?';
$string['asshownoneditscreen'] = 'Tal como se muestra en la pantalla de edición';
$string['attempt'] = 'Intento {$a}';
$string['attemptalreadyclosed'] = 'Este intento ya ha sido finalizado.';
$string['attemptclosed'] = 'El intento aún no está cerrado';
$string['attemptduration'] = 'Tiempo empleado';
$string['attemptedon'] = 'Intentado el';
$string['attempterror'] = 'No tiene autorización para intentar resolver este examen debido a: {$a}';
$string['attempterrorcontentchange'] = 'Esta vista previa del examen ya no existe. (Cuando un examen es editado, cualquier vista previa en-progreso es automáticamente eliminada).';
$string['attempterrorcontentchangeforuser'] = 'Este intento de examen ya no existe.';
$string['attempterrorinvalid'] = 'ID del intento de examen inválida';
$string['attemptfirst'] = 'Primer intento';
$string['attemptincomplete'] = 'Este intento (de {$a}) no se ha completado aún.';
$string['attemptlast'] = 'Último intento';
$string['attemptnumber'] = 'Intento';
$string['attemptquiznow'] = 'Comenzar el examen ya';
$string['attemptreviewtitle'] = '{$a}: Revisión del intento';
$string['attemptreviewtitlepaged'] = '{$a->name}: Revisión de intento (página {$a->currentpage} de {$a->totalpages})';
$string['attempts'] = 'Intentos';
$string['attempts_help'] = 'El número total de intentos permitidos (no el número de intentos extra).';
$string['attemptsallowed'] = 'Intentos permitidos';
$string['attemptsdeleted'] = 'Intentos de resolver el examen fueron eliminados';
$string['attemptselection'] = 'Seleccionar qué intentos analizar por usuario:';
$string['attemptsexist'] = 'Ya no puede quitar o poner preguntas';
$string['attemptsnum'] = 'Intentos: {$a}';
$string['attemptsnumthisgroup'] = 'Intentos: {$a->total} ({$a->group} de este grupo)';
$string['attemptsnumyourgroups'] = 'Intentos: {$a->total} ({$a->group} de sus grupos)';
$string['attemptsonly'] = 'Mostrar solamente estudiantes con intentos';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Intento aún en curso';
$string['attemptsummarytitle'] = '{$a}: Resumen del intento';
$string['attemptsunlimited'] = 'Intentos ilimitados';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (página {$a->currentpage} de {$a->totalpages})';
$string['autosaveperiod'] = 'Retraso de auto-guardar';
$string['autosaveperiod_desc'] = 'Las respuestas de los estudiantes pueden ser guardadas automáticamente cada ciertos minutos durante los intentos de contestar un examen.  Las respuestas se guardan cuando alguna cambia, y después de este retraso. Ésto involucra una concertación/cesión: al guardar las respuestas se aumenta la carga del servidor, pero se reduce el riesgo de que los estudiantes pierdan su trabajo. Si Usted va a hacer más corto este retraso, Usted debería de cambiar gradualmente el valor y monitorear la carga del servidor. Si la carga se vuelve muy alta, haga el retraso más largo. El configurar el retraso a 0 desactiva el auto-guardar.';
$string['back'] = 'Volver a la vista previa de la pregunta';
$string['backtocourse'] = 'Volver al curso';
$string['backtoquestionlist'] = 'Volver a lista de preguntas';
$string['backtoquiz'] = 'Regresar a edición del examen';
$string['basicideasofquiz'] = 'Ideas básicas sobre la realización de exámenes';
$string['bestgrade'] = 'Calificación máxima';
$string['bothattempts'] = 'Mostrar estudiantes con y sin intentos';
$string['browsersecurity'] = 'Seguridad del navegador';
$string['browsersecurity_help'] = 'Si está seleccionada la "Pantalla completa emergente con cierta seguridad JavaScript",

* El examen sólo se iniciará si el estudiante tiene un navegador con JavaScript activado
* El examen aparece en una ventana emergente a pantalla completa que cubre todas las otras ventanas y no tiene controles de navegación
* Se impide a los estudiantes, en la medida de lo posible, el uso de acciones como copiar y pegar';
$string['calculated'] = 'Calculadas';
$string['calculatedquestion'] = 'Pregunta calculada no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['cannotcreatepath'] = 'No se puede crear la ruta ({$a})';
$string['cannoteditafterattempts'] = 'No puede agregar o quitar preguntas porque este examen ya ha sido realizado. ({$a})';
$string['cannotfindprevattempt'] = 'No se puede encontrar un intento previo en el que basarse';
$string['cannotfindquestionregard'] = '¡No se pudo conseguir preguntas para recalificación!';
$string['cannotinsert'] = 'No se puede insertar pregunta';
$string['cannotinsertrandomquestion'] = 'No se pudo insertar una nueva pregunta aleatoria.';
$string['cannotloadquestion'] = 'No se pudieron cargar las opciones de pregunta';
$string['cannotloadtypeinfo'] = 'Imposible cargar información sobre pregunta específica';
$string['cannotopen'] = 'No se puede exportar el archivo ({$a})';
$string['cannotremoveallsectionslots'] = 'Usted ha seleccionado todas las preguntas debajo del encabezado de  la sección \'{$a}\'. No está permitido el quitar todas las preguntas debajo de un encabezado de sección.';
$string['cannotremoveslots'] = 'No pueden quitar preguntas';
$string['cannotrestore'] = 'Imposible restaurar sesiones de pregunta';
$string['cannotreviewopen'] = 'No puede revisar este intento: aún está abierto.';
$string['cannotsavelayout'] = 'Imposible guardar el esquema';
$string['cannotsavenumberofquestion'] = 'Imposible guardar el número de preguntas por página';
$string['cannotsavequestion'] = 'No se pudo guardar la lista de preguntas';
$string['cannotsetgrade'] = 'No se pudo ajustar una nueva calificación máxima para el examen';
$string['cannotsetsumgrades'] = 'No se pudo ajustar la suma de calificaciones';
$string['cannotstartgradesmismatch'] = 'No se puede iniciar un intento para este examen. El examen está configurado para que se califique sobre {$a->grade} puntos, pero ninguna de las preguntas de este examen tiene puntos para calificación. Esto puede corregirse en la página de \'Editar examen\'.';
$string['cannotstartmissingquestion'] = 'No se puede iniciar el intento de resolver el examen. La definición del examen incluye una pregunta que no existe.';
$string['cannotstartnoquestions'] = 'No puede iniciarse un intento para este examen. El examen no ha sido configurado todavía. No se han agregado preguntas.';
$string['cannotwrite'] = 'No se puede escribir al archivo exportado ({$a})';
$string['canredoquestions'] = 'Permitir re-hacer dentro de un intento';
$string['canredoquestions_desc'] = 'Si se habilita, entonces cuando los estudiantes hayan terminado una pregunta, ellos verán un botón para \'Intentar otra pregunta similar a esta\'. Esto les permite intentar otra pregunta similar (elegida aleatoriamente), o intentar la misma pregunta nuevamente, sin tener que enviar el examen completo e iniciar otro examen nuevo. Esta opción es útil para exámenes de práctica (formativos).

Esta configuración solamente afecta a las preguntas y a los comportamientos (por ejemplo, retroalimentación inmediata, o interactiva con intentos múltiples), en donde es posible que el estudiante termine la pregunta antes de que el intento sea enviado.';
$string['canredoquestions_help'] = 'Si se habilita, entonces después de que los estudiantes hayan terminado una pregunta, se mostrará un botón para \'Intentar otra pregunta similar a esta\'. Esto les permite intentar una pregunta similar (elegida aleatoriamente), o la misma pregunta nuevamente, sin tener enviar el examen completo e iniciar otro examen nuevo. Esta opción es útil para exámenes de práctica (formativos).

Esta configuración solamente afecta a las preguntas y a los comportamientos (por ejemplo, retroalimentación inmediata, o interactiva con intentos múltiples), en donde es posible que el estudiante termine la pregunta antes de que el intento sea enviado.';
$string['canredoquestionsyes'] = 'Si, proporcionar la opción para intentar otra pregunta';
$string['caseno'] = 'Igual MAYÚSCULAS que minúsculas';
$string['casesensitive'] = 'Diferencia entre MAYÚSCULAS y minúsculas';
$string['caseyes'] = 'MAYÚSCULAS y minúsculas deben coincidir';
$string['categoryadded'] = 'Se añadió la categoría \'{$a}';
$string['categorydeleted'] = 'Se eliminó la categoría\'{$a}';
$string['categorynoedit'] = 'Usted no tiene privilegios de edición en la categoría \'{$a}\'.';
$string['categoryupdated'] = 'Categoría actualizada con éxito';
$string['close'] = 'Cerrar vista previa';
$string['closebeforeopen'] = 'No se pudo actualizar el examen: la fecha de cierre es anterior a la de apertura.';
$string['closed'] = 'Cerrado';
$string['closepreview'] = 'Cerrar vista previa';
$string['closereview'] = 'Cerrar revisión';
$string['comment'] = 'Comentario';
$string['commentorgrade'] = 'Hacer comentario o evitar calificación';
$string['comments'] = 'Comentarios';
$string['completedon'] = 'Finalizado en';
$string['completionattemptsexhausted'] = 'O todos los intentos disponibles completados';
$string['completionattemptsexhausted_help'] = 'Marcar el examen como completo cuando el estudiante haya agotado en número máximo de intentos.';
$string['completionattemptsexhausteddesc'] = 'Completo si todos los intentos disponibles estuvieran agotados';
$string['completionminattempts'] = 'Número mínimo de intentos:';
$string['completionminattemptserror'] = 'El número mínimo de intentos debe ser menor o igual a los intentos permitidos.';
$string['completionminattemptsgroup'] = 'Requerir intentos';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completionpass_help'] = 'Si se habilita, esta actividad es considerada completa cuando el estudiante recibe una calificación aprobatoria (según se especifica en la sección de Calificación de las configuraciones del examen) o superior.';
$string['completionpassdesc'] = 'El estudiante debe obtener una calificación aprobatoria para completar esta actividad';
$string['configadaptive'] = 'Si selecciona Sí en esta opción, el estudiante podrá dar múltiples respuestas a una pregunta incluso dentro del mismo intento de resolver el examen.';
$string['configattemptsallowed'] = 'Restricción del número de intentos que los estudiantes tienen para resolver el examen. Debido a las fallas eléctricas y del servicio de internet, se recomienda un mínimo de 2 para México.';
$string['configdecimaldigits'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestran las calificaciones.';
$string['configdecimalplaces'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestren las calificaciones del examen.';
$string['configdecimalplacesquestion'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestren las calificaciones de las preguntas individuales.';
$string['configdelay1'] = 'Si ajusta una demora, el estudiante deberá esperar ese tiempo antes de que pueda intentar resolver el examen tras el primer intento.';
$string['configdelay1st2nd'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su segundo intento hasta que haya transcurrido ese tiempo después de terminar su primer intento.';
$string['configdelay2'] = 'Si establece aquí una demora, el estudiante tendrá que esperar ese tiempo antes de efectuar su tercer intento (o posteriores) de resolver el examen.';
$string['configdelaylater'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su tercero, cuarto... intento hasta que haya transcurrido ese tiempo después de terminar su anterior intento.';
$string['configeachattemptbuildsonthelast'] = 'Si se permiten múltiples intentos, cada nuevo intento contendrá los resultados del intento previo.';
$string['configgrademethod'] = 'Método que se usará para calcular la calificación final del estudiante en el examen cuando se permiten múltiples intentos.';
$string['configintro'] = 'Los valores que especifique aquí definen los valores por defecto usados en el formato de especificaciones cuando usted crea un nuevo examen. Puede asimismo configurar qué ajustes del examen se considerarán avanzados.';
$string['configmaximumgrade'] = 'Valor por defecto a la que se ajustará la calificación del examen.';
$string['confignavmethod'] = 'En la navegación libre, las preguntas pueden contestarse en cualquier orden empleando la navegación. En la navegación secuencial, las preguntas deben contestarse en orden estricto.';
$string['confignewpageevery'] = 'Cuando se agregan preguntas al examen, los saltos de página se insertarán automáticamente de acuerdo con el valor que elija aquí.';
$string['configoutcomesadvanced'] = 'Si esta opción se activa, entonces los Resultados en el formato de edición del examen serán configuraciones avanzadas.';
$string['configpenaltyscheme'] = 'Penalización sustraída por cada respuesta errónea en el modo adaptativo.';
$string['configpopup'] = 'Usar \'tricks\' de JavaScript para tratar de restringir copiar y pegar, etc., durante los intentos de resolver este examen. Puede ser útil en laboratorios de Universidad, pero causar problemas en computadoras de casa o café internet en México y otros países.';
$string['configrequirepassword'] = 'Los estudiantes deben escribir esta contraseña antes de que puedan intentar resolver el examen.';
$string['configrequiresubnet'] = 'Los estudiantes únicamente pueden intentar resolver el examen desde estas computadoras.';
$string['configreviewoptions'] = 'Estas opciones controlan qué información pueden ver los usuarios cuando revisan un intento de resolver el examen o cuando examinan los reportes del examen.';
$string['configshowblocks'] = 'Mostrar bloques durante los intentos de responder al examen.';
$string['configshowuserpicture'] = 'Mostrar en pantalla la imagen del usuario durante los intentos.';
$string['configshufflewithin'] = 'Si habilita esta opción, las partes que componen las preguntas individuales se ordenarán al azar cada vez que un estudiante intenta resolver este examen, en el supuesto de que la opción esté también habilitada en los ajustes de la pregunta.';
$string['configtimelimit'] = 'Tiempo límite para los exámenes por defecto en minutos. 0 significa que no hay límite de tiempo.';
$string['configtimelimitsec'] = 'Tiempo límite (en segundos) predeterminado para resolver los exámenes. \'0\' significa que no hay límite de tiempo. 3600 =1 hora.';
$string['configurerandomquestion'] = 'Configurar pregunta';
$string['confirmclose'] = 'Una vez que envíe el examen, no podrá cambiar sus respuestas para este intento.';
$string['confirmremovequestion'] = '¿Está Usted seguro de querer remover esta pregunta {$a} ?';
$string['confirmremovesectionheading'] = '¿Está Usted seguro de querer remover el encabezado de sección \'{$a}\'?';
$string['confirmserverdelete'] = '¿Está seguro de que desea eliminar el servidor  <b>{$a}</b> de la lista?';
$string['connectionerror'] = 'Se perdió la conexión de red. (Falló auto-guardar).

Por favor tenga en cuenta que todas las respuestas escritas en esta página en los últimos minutos,  y después, intente re-conectar.

Una vez que se haya restablecido la reconexión, sus respuestas deberían de guardarse y este mensaje desaparecerá.';
$string['connectionok'] = 'Se restauró la conexión de red. Usted puede continuar con seguridad.';
$string['containercategorycreated'] = 'Esta categoría se ha creado para almacenar todas las categorías originales trasladadas al sitio debido a causas especificadas más abajo.';
$string['continueattemptquiz'] = 'Continuar el último intento';
$string['continuepreview'] = 'Continuar la previsualización anterior';
$string['copyingfrom'] = 'Creando una copia de la pregunta \'{$a}';
$string['copyingquestion'] = 'Copiando una pregunta';
$string['correct'] = 'Correcto';
$string['correctanswer'] = 'Respuesta correcta';
$string['correctanswerformula'] = 'Fórmula para calcular la respuesta correcta';
$string['correctansweris'] = 'Respuesta correcta: {$a}';
$string['correctanswerlength'] = 'Cifras significativas';
$string['correctanswers'] = 'Respuestas correctas';
$string['correctanswershows'] = 'La respuesta correcta muestra';
$string['corrresp'] = 'Respuesta Correcta';
$string['countdown'] = 'Cuenta atrás';
$string['countdownfinished'] = 'Este examen se está cerrando, debe enviar sus respuestas ahora.';
$string['countdowntenminutes'] = 'El examen se cerrará en diez minutos.';
$string['coursetestmanager'] = 'Formato de Mánager de curso de prueba';
$string['createcategoryandaddrandomquestion'] = 'Crear la categoría y añadir pregunta aleatoria';
$string['createfirst'] = 'Antes debe crear algunas preguntas de respuesta corta.';
$string['createmultiple'] = 'Añadir varias preguntas aleatorias al examen';
$string['createnewquestion'] = 'Crear una pregunta nueva';
$string['createquestionandadd'] = 'Crear una nueva pregunta y agregarla al examen.';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Necesita agregar al menos un conjunto de ítems para obtener una pregunta válida';
$string['datasetdefinitions'] = 'Definiciones reutilizables del conjunto de datos para la categoría {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Días disponible';
$string['decimaldigits'] = 'Número de decimales en calificaciones';
$string['decimalplaces'] = 'Posiciones Decimales en las calificaciones';
$string['decimalplaces_help'] = '<p>Mediante esta opción usted puede seleccionar el número de decimales mostrados en la calificación.</p> Solamente afecta cómo se muestra la calificación, pero no tiene efecto sobre cómo se guarda la calificación ni en la base de datos, ni en los cálculos internos, que se realizan con precisión completa.';
$string['decimalplacesquestion'] = 'Posiciones Decimales en las calificaciones de las preguntas';
$string['decimalplacesquestion_help'] = '<p>Usted puede elegir una precisión diferente cuando se muestran las calificaciones de preguntas individuales, a diferencia de la puntuación general del examen. Por ejemplo, es posible que la puntuación final del examen de redondeado al número entero más cercano, mientras que se tienen puntuaciones fraccionarias en las preguntas individuales</p>';
$string['decimalpoints'] = 'Número de decimales';
$string['default'] = 'Por defecto';
$string['defaultgrade'] = 'Puntos que vale la pregunta';
$string['defaultinfo'] = 'Categoría por defecto para las preguntas.';
$string['delay1'] = 'Tiempo entre el primer y el segundo intento';
$string['delay1st2nd'] = 'Forzar demora entre los intentos primero y segundo';
$string['delay1st2nd_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar ese tiempo antes de poder volver a contestar el examen después del primer intento.</p>';
$string['delay2'] = 'Tiempo entre los intentos posteriores';
$string['delaylater'] = 'Forzar demora entre intentos posteriores';
$string['delaylater_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar a que transcurra ese tiempo antes de poder intentar contestar el examen por tercera vez o en lo sucesivo.</p>';
$string['deleteattemptcheck'] = '¿Está totalmente seguro que quiere borrar definitivamente estos intentos?';
$string['deleteselected'] = 'Eliminar seleccionados';
$string['deletingquestionattempts'] = 'Eliminando intentos de resolver el examen';
$string['description'] = 'Descripción -';
$string['disabled'] = 'Deshabilitado';
$string['displayoptions'] = 'Mostrar opciones';
$string['donotuseautosave'] = 'No usar auto-guardar';
$string['download'] = 'Haga clic para descargar el archivo de categorías exportadas';
$string['downloadextra'] = '(el archivo se almacena también en los archivos del curso del  directorio /backupdata/quiz )';
$string['dragtoafter'] = 'Después de {$a}';
$string['dragtostart'] = 'Al inicio';
$string['duplicateresponse'] = 'Este envío ha sido pasado por alto debido a que usted dio una respuesta equivalente con anterioridad.';
$string['eachattemptbuildsonthelast'] = 'Cada intento se basa en el anterior';
$string['eachattemptbuildsonthelast_help'] = '<p>Si se permiten varios intentos y se selecciona <B>Sí</B>, cada nuevo intento contendrá el resultado del anterior. Esto permite completar un examen haciendo varios intentos partiendo en cada uno del resultado anterior.</p>';
$string['editcategories'] = 'Editar categorías';
$string['editcategory'] = 'Editar categoría';
$string['editcatquestions'] = 'Editar preguntas categóricas';
$string['editingquestion'] = 'Editando pregunta';
$string['editingquiz'] = 'Editando el examen';
$string['editingquiz_help'] = 'Cuando se crea un examen, los conceptos básicos son:

* El examen, que contiene preguntas en una o más páginas
* El banco de preguntas, que almacena copias de todas las preguntas organizadas en categorías
* Preguntas aleatorias: Cada vez que se intenta resolver el examen aparecen preguntas diferentes (los estudiantes tienen preguntas diferentes)';
$string['editingquizx'] = 'Editando examen: {$a}';
$string['editmaxmark'] = 'Editar puntuación máxima';
$string['editoverride'] = 'Anular edición';
$string['editqcats'] = 'Editar categorías de preguntas';
$string['editquestion'] = 'Editar pregunta';
$string['editquestions'] = 'Editar preguntas';
$string['editquiz'] = 'Editar examen';
$string['editquizquestions'] = 'Editar preguntas del examen';
$string['emailconfirmbody'] = 'Hola {$a->username},

Gracias por enviar sus respuestas al examen \'{$a->quizname}\' en el curso \'{$a->coursename}\' en {$a->submissiontime}.

Este mensaje confirma que sus respuestas han sido guardadas.

Puede acceder a este examen en {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Gracias por enviar sus respuestas a  \'{$a->quizname}';
$string['emailconfirmsubject'] = 'Confirmación de envío: {$a->quizname}';
$string['emailnotifybody'] = 'Hola, {$a->username},

{$a->studentname} ha completado  \'{$a->quizname}\' ({$a->quizurl}) en el curso \'{$a->coursename}\'

Puede revisar este intento en {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completado {$a->quizname}.
Vea {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completado {$a->quizname}';
$string['emailoverduebody'] = 'Estimado {$a->studentname},

Usted inició un intento de \'{$a->quizname}\' en el curso \'{$a->coursename}\', pero nunca lo envío. Debió de haberse enviado antes de {$a->attemptduedate}.

Si todavía quiere enviar este intento, vaya por favor a  {$a->attemptsummaryurl} y elija el botón \'enviar\'. Debe hacerlo antes de {$a->attemptgraceend} o de lo contrario no se le contará su intento.';
$string['emailoverduesmall'] = 'Usted no envío su intento para el  {$a->quizname}. Por favor vaya a {$a->attemptsummaryurl} antes de {$a->attemptgraceend} si todavía quiere enviar ese examen.';
$string['emailoverduesubject'] = 'Intento retrasados actualmente: {$a->quizname}';
$string['empty'] = 'Vacío';
$string['enabled'] = 'Habilidato';
$string['endtest'] = 'Terminar intento ...';
$string['erroraccessingreport'] = 'No puede acceder a este reporte';
$string['errorinquestion'] = 'Error en la pregunta';
$string['errormissingquestion'] = 'Error: el sistema ha perdido la pregunta con id {$a}';
$string['errornotnumbers'] = 'Error - las respuestas deben ser numéricas';
$string['errorunexpectedevent'] = 'Código de evento inesperado {$a->event} encontrado en la pregunta {$a->questionid} en el intento {$a->attemptid}.';
$string['essay'] = 'Ensayo';
$string['essayquestions'] = 'Preguntas';
$string['eventattemptdeleted'] = 'Intento de examen eliminado';
$string['eventattemptpreviewstarted'] = 'VIsta previa de intento de examen iniciada';
$string['eventattemptreviewed'] = 'Intento de examen revisado';
$string['eventattemptsummaryviewed'] = 'Resumen de intento de examen visto';
$string['eventattemptviewed'] = 'Intento de examen visto';
$string['eventeditpageviewed'] = 'Página de edición de examen vista';
$string['eventoverridecreated'] = 'Anulación de examen creada';
$string['eventoverridedeleted'] = 'Anulación de examen eliminada';
$string['eventoverrideupdated'] = 'Anulación de examen actualizada';
$string['eventquestionmanuallygraded'] = 'Pregunta calificada manualmente';
$string['eventquizattemptabandoned'] = 'Intento de examen abandonado';
$string['eventquizattemptregraded'] = 'Intento de examen recalificado';
$string['eventquizattemptstarted'] = 'Intento de examen iniciado';
$string['eventquizattemptsubmitted'] = 'Intento de examen enviado';
$string['eventquizattempttimelimitexceeded'] = 'Límite de tiempo excedido para intento de examen';
$string['eventreportviewed'] = 'Reporte de examen visto';
$string['everynquestions'] = 'Cada {$a} preguntas';
$string['everyquestion'] = 'Cada pregunta';
$string['everythingon'] = 'Todo activado';
$string['existingcategory'] = 'Categoría existente';
$string['exportcategory'] = 'categoría de exportación';
$string['exporterror'] = 'Ocurrió un error durante el procesamiento de la exportación';
$string['exportingquestions'] = 'Se están exportando las preguntas al archivo';
$string['exportname'] = 'Nombre del archivo';
$string['exportquestions'] = 'Exportar preguntas a un archivo';
$string['extraattemptrestrictions'] = 'Restricciones extra sobre los intentos';
$string['false'] = 'Falso';
$string['feedback'] = 'Comentario de retroalimentación';
$string['feedbackerrorboundaryformat'] = 'Los límites de la calificación de la retroalimentación deben ser un porcentaje o un número. El valor introducido en el límite {$a} no ha sido reconocido.';
$string['feedbackerrorboundaryoutofrange'] = 'Los límites de la calificación de la retroalimentación deben estar entre 0% y 100%. El valor introducido en el umbral {$a} está fuera de límites.';
$string['feedbackerrorjunkinboundary'] = 'Debe rellenar las casillas de los límites de la calificación de la retroalimentación sin dejar huecos.';
$string['feedbackerrorjunkinfeedback'] = 'Debe rellenar las casillas de retroalimentación sin dejar huecos.';
$string['feedbackerrororder'] = 'Los límites de la calificación de la retroalimentación deben estar en orden, comenzando por el más alto. El valor introducido en el umbral {$a} está fuera de la secuencia.';
$string['file'] = 'Archivo';
$string['fileformat'] = 'Formato de archivo';
$string['fillcorrect'] = 'Rellene con la opción correcta';
$string['filloutnumericalanswer'] = 'Usted proporciona al menos una respuesta posible y una tolerancia. La primera respuesta que coincida se usará para determinar la puntuación y la retroalimentación. Si proporciona alguna clase de retroalimentación sin ninguna respuesta al final, eso se mostrará a los estudiantes cuya respuesta correcta no coincida con ninguna de las demás respuestas.';
$string['filloutoneanswer'] = 'Debe llenar al menos una respuesta posible. Las respuestas en blanco no serán utilizadas. \'*\' se puede emplear como comodín para coincidir con cualquier caracter. La primera respuesta que coincida se usará para determinar la calificación y la retroalimentación.';
$string['filloutthreequestions'] = 'Debe llenar al menos tres preguntas. Las que deje en blanco no serán utilizadas.';
$string['fillouttwochoices'] = 'Debe elegir al menos dos opciones. Las opciones en blanco no serán utilizadas.';
$string['finishattemptdots'] = 'Terminar intento ...';
$string['finishreview'] = 'Finalizar revisión';
$string['forceregeneration'] = 'forzar regeneración';
$string['formatnotfound'] = 'No se encuentra el formato {$a} de exportación/importación';
$string['formulaerror'] = '¡Errores en la fórmula!';
$string['fractionsaddwrong'] = 'Las calificaciones positivas otorgadas no suman 100% sino {$a}%<br />¿Desea regresar y corregir esta pregunta?';
$string['fractionsnomax'] = 'Una de las preguntas debe ser 100% para que sea<br />posible alcanzar la calificación máxima<br />¿Desea regresar y corregir esta pregunta?';
$string['fromfile'] = 'desde archivo:';
$string['functiondisabledbysecuremode'] = 'Esa funcionalidad está actualmente deshabilitada';
$string['generalfeedback'] = 'Retroalimentación general';
$string['generalfeedback_help'] = '<p>La retroalimentación general sobre las preguntas es un texto que se muestra al estudiante una vez que ha intentado responder a una pregunta. A diferencia de la retroalimentación, que depende del tipo de pregunta y de la respuesta dada por el estudiante, aquí se muestra el mismo texto de retroalimentación general a todos los estudiantes.</p> <p>Usted puede controlar cuándo se muestra a los estudiantes la retroalimentación general utilizando las casillas de activación "Los estudiantes pueden revisar:" del formato de edición del examen.</p> <p>Puede usar la retroalimentación general para dar a los estudiantes información sobre qué conocimientos tratan de comprobar las preguntas, o bien para suministrarles un enlace a más información que podrían usar en el caso de no entender las preguntas.</p>';
$string['graceperiod'] = 'Período de gracia para envío';
$string['graceperiod_desc'] = 'Si se configura que cuando se agote el tiempo a "Hay un período de gracia...", entonces  esta es la cantidad por defecto de tiempo extra que está permitido.';
$string['graceperiod_help'] = 'Si se configura que cuando se agote el tiempo a "Hay un período de gracia...", entonces esta es la cantidad de tiempo extra que está permitido.';
$string['graceperiodmin'] = 'Período de gracia para último envío';
$string['graceperiodmin_desc'] = 'Hay un problema potencial al final del examen. Por una parte, queremos que los estudiantes sigan trabajando justo hasta el último segundo - con la ayuda del cronómetro que automáticamente envía el examen cuando se agota el tiempo. Por la otra parte, en ese instante se puede sobrecargar el servidor, y necesitar más tiempo para procesar las respuestas. Por lo tanto, aceptaremos respuestas hasta por esta cantidad de segundos después de agotado el tiempo, de forma que no sean penalizados debido a que el servidor se alentó. Sin embargo, el estudiante podría hacer trampa y obtener estos segundos extra para contestar el examen. Usted debe balancear de acuerdo a qué tanto confía en el desempeño rápido de su servidor durante los exámenes.';
$string['graceperiodtoosmall'] = 'El período de gracia debe ser mayor de  {$a}.';
$string['grade'] = 'Calificación';
$string['gradeall'] = 'Calificar todo';
$string['gradeaverage'] = 'Promedio de calificaciones';
$string['gradeboundary'] = 'Límites de calificación';
$string['gradeessays'] = 'Calificar ensayos';
$string['gradehighest'] = 'Calificación más alta';
$string['grademethod'] = 'Método de calificación';
$string['grademethod_help'] = '<P>Cuando se permiten múltiples intentos, hay diferentes maneras en las que puede usar las distintas calificaciones obtenidas para calcular la puntuación final del examen. <P><B>Calificación más alta</B><P> <UL> <P>La puntuación final es la más alta en cualquiera de los intentos. </UL> <P><B>Puntuación media</B><P> <UL> <P> La puntuación final es el promedio (la media simple) de la puntuación de todos los intentos.</UL> <P><B>Primera calificación</B><P> <UL> <P>La puntuación final es la obtenida en el primer intento (se ignoran los demás intentos).</UL> <P><B>Última calificación</B><P> <UL> <P>La calificación final es la obtenida en el intento más reciente.</UL>';
$string['gradesdeleted'] = 'Las calificaciones del examen fueron eliminadas';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'La calificación aprobatoria no puede ser cero porque este examen tiene configurado su método de terminación a requerir calificación aprobatoria. Por favor, configure un valor diferente de cero.';
$string['gradetopassnotset'] = 'Este examen no tiene configurada una calificación aprobatoria. Puede configurarse en la sección de Calificación de las configuraciones del examen.';
$string['gradingdetails'] = 'Puntos para este envío:
{$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Con las penalizaciones previas da como resultado
<strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Este envío supone una penalización de {$a}.';
$string['gradingdetailszeropenalty'] = 'Usted no ha sido penalizado por este envío';
$string['gradingmethod'] = 'Método de calificación: {$a}';
$string['groupoverrides'] = 'Anulaciones de grupo';
$string['groupoverridesdeleted'] = 'Anulaciones de grupo eliminadas';
$string['groupsnone'] = 'Sin grupos a los que Usted pueda acceder.';
$string['guestsno'] = 'Lo sentimos, los invitados no pueden ver o responder exámenes';
$string['hidebreaks'] = 'Ocultar saltos de página';
$string['hidereordertool'] = 'Ocultar herramienta de reordenamiento';
$string['history'] = 'Historial de respuestas';
$string['howquestionsbehave_desc'] = 'Configuración predeterminada del comportamiento de las preguntas en un examen.';
$string['imagedisplay'] = 'Imagen a mostrar';
$string['import_help'] = 'Esta función permite importar preguntas de archivos externos.

Si su archivo contiene caracteres no ascii, utilice la codificación UTF-8. Sea especialmente cuidadoso con los archivos generados por aplicaciones Microsoft Office, puesto que normalmente utilizan una codificación especial que puede no ser manejada correctamente.

Los formatos de Importar y Exportar son un recurso basado en plugins. Pueden encontrarse disponibles otros formatos opcionales en la base de datos de Módulos y Plugins.';
$string['importcategory'] = 'Categoría a donde importar';
$string['importerror'] = 'Ha ocurrido un error durante el procesamiento de la importación';
$string['importfilearea'] = 'Importar de un archivo que ya está en los archivos del curso...';
$string['importfileupload'] = 'Importar de subida de archivo...';
$string['importfromthisfile'] = 'Importar de este archivo';
$string['importingquestions'] = 'Importando {$a} preguntas del archivo';
$string['importmax10error'] = 'Hay un error en la pregunta. Usted no puede tener más de diez respuestas';
$string['importmaxerror'] = 'Hay un error en la pregunta.
Hay demasiadas respuestas.';
$string['importquestions'] = 'Importar preguntas de un archivo';
$string['inactiveoverridehelp'] = '* Esta anulación está inactiva porque el acceso del usuario a la actividad está restringido. Esto puede ser debido a asignaciones de rol, otras restricciones de acceso, o que la actividad esté oculta.';
$string['incorrect'] = 'Incorrecta';
$string['indicator:cognitivedepth'] = 'Examen cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad Examen.';
$string['indicator:cognitivedepthdef'] = 'Examen cognitiva';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso cognitivo ofrecido por las actividades de Examen durante este intervalo de análisis (Niveles = Sin Ver, Ver, Enviar, Ver retroalimentación, Comentar en retroalimentación, Reenviar después de ver retroalimentación)';
$string['indicator:socialbreadth'] = 'Examen social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad Examen.';
$string['indicator:socialbreadthdef'] = 'Examen social';
$string['indicator:socialbreadthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso social ofrecido por las actividades de Examen durante este intervalo de análisis (Niveles = Sin participación, Participante solo, Participante con otros)';
$string['indivresp'] = 'Respuestas de los individuos a cada ítem';
$string['info'] = 'Información';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Número inicial de campos de retroalimentación global';
$string['initialnumfeedbacks_desc'] = 'Al crear un nuevo examen, proporcione este número de cajas de retroalimentación global vacías. Una vez que el examen haya sido creado, el formato muestra el número de campos requeridos para el número de retroalimentaciones en el examen. La configuración debe de ser al menos de 1.';
$string['inprogress'] = 'En curso';
$string['introduction'] = 'Descripción';
$string['invalidattemptid'] = 'No existe un intento con esa ID';
$string['invalidcategory'] = 'El ID de la categoría no es válido';
$string['invalidoverrideid'] = 'ID de anulación no válido';
$string['invalidquestionid'] = 'ID de pregunta no válida';
$string['invalidquizid'] = 'ID de examen no válida';
$string['invalidrandomslot'] = 'ID de posición de pregunta aleatoria inválido';
$string['invalidsource'] = 'No se acepta la fuente como válida';
$string['invalidsourcetype'] = 'Tipo de fuente no válido.';
$string['invalidstateid'] = 'ID de estado no válida';
$string['lastanswer'] = 'Su última respuesta fue';
$string['layout'] = 'Diseño de cómo se presentará el examen';
$string['layoutasshown'] = 'Diseño de página como se muestra.';
$string['layoutasshownwithpages'] = 'Diseño de página como se muestra. <small>(Página nueva automática cada {$a} preguntas.)</small>';
$string['layoutshuffledandpaged'] = 'Las preguntas se ordenaron aleatoriamente con {$a} preguntas por página.';
$string['layoutshuffledsinglepage'] = 'Las preguntas se ordenaron aleatoriamente, todas en una sola página.';
$string['legacyquizaccessrulescron'] = 'Reglas de acceso al Examen del Cron antiguo';
$string['legacyquizreportscron'] = 'Reportes de Examen del Cron antiguo';
$string['link'] = 'Enlace';
$string['listitems'] = 'Lista de ítems del examen';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Fallo en la carga de preguntas: {$a}';
$string['makecopy'] = 'Guardar como nueva pregunta';
$string['managetypes'] = 'Gestionar tipos de preguntas y servidores';
$string['manualgradequestion'] = 'Calificar manualmente pregunta {$a->question} en {$a->quiz} por {$a->user}';
$string['manualgrading'] = 'Calificación';
$string['mark'] = 'Enviar';
$string['markall'] = 'Enviar página';
$string['marks'] = 'Puntos';
$string['marks_help'] = 'Los puntos numéricos (calificación)  para cada pregunta, y la calificación total del intento.';
$string['match'] = 'Relación de columnas';
$string['matchanswer'] = 'Respuesta relacionada';
$string['matchanswerno'] = 'Respuesta relacionada {$a}';
$string['max'] = 'Máx';
$string['maxmark'] = 'Puntaje máximo';
$string['messageprovider:attempt_overdue'] = 'Advertir cuando su intento de examen se retrase demasiado';
$string['messageprovider:confirmation'] = 'Confirmación de su envío del examen';
$string['messageprovider:submission'] = 'Notificación de envíos del examen de sus estudiantes';
$string['min'] = 'Mín';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'Debe especificar la respuesta correcta';
$string['missingitemtypename'] = 'Nombre faltante';
$string['missingquestion'] = 'Al parecer ya no existe esta pregunta';
$string['modulename'] = 'Examen';
$string['modulename_help'] = 'La actividad de examen le permite al profesor crear exámenes con preguntas de varios tipos, incluyendo opción múltiple, falso/verdadero, relacionar columnas, respuesta corta y calculada.

Un profesor puede permitir que se intente realizar el examen en varias ocasiones con el orden de las preguntas acomodado aleatoriamente. Se puede establecer un límite de tiempo si se desea.

Cada intento es calificado automáticamente y la calificación se guarda en el libro de calificaciones. El profesor puede elegir si hacer comentarios de retroalimentación y/o mostrar las respuestas correctas durante el intento, inmediatamente después o hasta que se cerró el examen.

Un profesor puede elegir entre una variedad de comportamientos de pregunta, incluyendo un modo adaptativo (que proporciona pistas antes de permitirle al estudiante intentarlo de nuevo), y retroalimentación inmediata con puntaje basado en certeza (donde el estudiante debe indicar que tan seguro está de su respuesta).

Los exámenes pueden usarse
* Como exámenes formales del curso
* Como mini pruebas para tareas de lectura al final de un tópico/tema
* Como práctica de examen empleando preguntas de exámenes de años anteriores
* Para proporcionar retroalimentación inmediata sobre el desempeño
* Para auto-evaluación.';
$string['modulenameplural'] = 'Exámenes';
$string['moveselectedonpage'] = 'Mover las preguntas seleccionadas a la página: {$a}';
$string['multichoice'] = 'Opción múltiple';
$string['multipleanswers'] = 'Seleccione  al menos una respuesta.';
$string['mustbesubmittedby'] = 'Este intento debe ser enviado para {$a}.';
$string['name'] = 'Nombre';
$string['navigatenext'] = 'Página siguiente';
$string['navigateprevious'] = 'Página anterior';
$string['navmethod'] = 'Método de navegación';
$string['navmethod_free'] = 'Libre';
$string['navmethod_help'] = 'Cuando se habilita la navegación secuencial, un estudiante debe progresar a través del examen en orden y no puede regresar a páginas anteriores ni brincar varias páginas adelante.';
$string['navmethod_seq'] = 'Secuencial';
$string['navnojswarning'] = 'Advertencia: estos vínculos no guardarán sus respuestas. Utilice el botón siguiente en la zona inferior de la página.';
$string['neverallononepage'] = 'Nunca, todas las preguntas en una página';
$string['newattemptfail'] = 'Error: No se ha podido comenzar un nuevo intento en el examen';
$string['newcategory'] = 'Nueva categoría';
$string['newpage'] = 'Página nueva';
$string['newpage_help'] = '<p>En los exámenes más extensos tiene sentido desplegar el examen en varias páginas, limitando el número de preguntas por página. Cuando se añaden preguntas al examen, se insertarán automáticamente saltos de página de acuerdo con el ajuste que se introduzca aquí. Sin embargo, uster podrá cambiar a mano los saltos de página más tarde en la página de edición. </p>';
$string['newpageevery'] = 'Comenzar automáticamente una nueva página';
$string['newsectionheading'] = 'Nuevo encabezado';
$string['noanswers'] = 'No se seleccionó ninguna respuesta';
$string['noattempts'] = 'No se ha intentado responder este examen';
$string['noattemptsfound'] = 'No se encontraron intentos.';
$string['noattemptstoshow'] = 'No hay intentos que mostrar';
$string['nocategory'] = 'Categoría incorrecta o no especificada';
$string['noclose'] = 'Sin fecha de cierre';
$string['nocommentsyet'] = 'Aún no hay comentarios.';
$string['noconnection'] = 'En este momento no existe conexión a un servicio web que pueda procesar esta pregunta. Por favor, póngase en contacto con su administrador.';
$string['nodataset'] = 'nada - no es un comodín';
$string['nodatasubmitted'] = 'No se han enviado datos.';
$string['noessayquestionsfound'] = 'No se encuentran preguntas calificadas manualmente';
$string['nogradewarning'] = 'Este examen no está calificado, por lo que no puede escribir una retroalimentación global en función de la calificación.';
$string['nomoreattempts'] = 'No se permiten más intentos';
$string['none'] = 'Ninguno(a)';
$string['noopen'] = 'Sin fecha de apertura';
$string['nooverridedata'] = 'Debe reemplazar al menos uno de los ajustes del examen.';
$string['nopossibledatasets'] = 'No datos posibles';
$string['noquestionintext'] = 'El texto de la pregunta no contiene ninguna pregunta incrustada';
$string['noquestions'] = 'Aún no se han agregado preguntas';
$string['noquestionsfound'] = 'No se han encontrado preguntas';
$string['noquestionsinquiz'] = 'No hay preguntas en este examen.';
$string['noquestionsnotinuse'] = 'Esta pregunta aleatoria no está en uso puesto que su categoría está vacía.';
$string['noquestionsonpage'] = 'Página vacía';
$string['noresponse'] = 'Sin respuesta';
$string['noreview'] = 'No está autorizado para revisar este examen';
$string['noreviewattempt'] = 'Usted no tiene permiso para revisar este intento.';
$string['noreviewshort'] = 'No permitido';
$string['noreviewuntil'] = 'No está autorizado para revistar este examen hasta el {$a}';
$string['noreviewuntilshort'] = 'Disponible {$a}';
$string['noscript'] = 'Para continuar, JavaScript debe estar habilitado';
$string['notavailabletostudents'] = 'Nota: Sus estudiantes no pueden acceder en este momento a este examen';
$string['notenoughrandomquestions'] = 'No existen suficientes preguntas en la categoría {$a->category} para crear la pregunta {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'No se han definido suficientes subpreguntas.<br /> ¿Quiere regresar y arreglar esta pregunta?';
$string['notimedependentitems'] = 'Actualmente el módulo Examen no permite ítems de tiempo limitado. Como alternativa, fije un tiempo límite para todo el examen. ¿Desea elegir un ítem diferente o usar el actual?';
$string['notyetgraded'] = 'Sin calificar aún';
$string['notyetviewed'] = 'No visto aún';
$string['notyourattempt'] = '¡Éste no es su intento!';
$string['noview'] = 'Al usuario ingresado no se le permite ver este examen.';
$string['numattempts'] = '{$a->studentnum}
{$a->studentstring} ha hecho
{$a->attemptnum} intentos';
$string['numattemptsmade'] = '{$a} intentos de contestar el examen';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérico';
$string['numquestionsx'] = 'Preguntas:{$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Sólo los profesores pueden exportar preguntas';
$string['onlyteachersimport'] = 'Sólo los profesores con permiso de edición pueden importar preguntas';
$string['onthispage'] = 'En esta página';
$string['open'] = 'Sin contestar';
$string['openafterclose'] = 'No pudo actualizarse el examen. Usted ha especificado una fecha de apertura posterior a la fecha de cierre.';
$string['openclosedatesupdated'] = 'Actualizadas fechas de apertura y cierre del examen';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Orden y paginación';
$string['orderandpaging_help'] = 'Los números 10, 20, 30, ... en el lado opuesto a las preguntas indican el orden de las preguntas. Los números aumentan en pasos de 10 en 10 para dejar espacio para insertar preguntas adicionales. Para re-ordenar las preguntas, cambie la numeración y después haga clic en el botón de "Re-ordenar preguntas".

Para añadir saltos de página después de una pregunta en particular, seleccione la casilla junto a la pregunta y elija el botón "Añadir páginas nuevas después de preguntas seleccionadas".

Para arreglar las preguntas de varias páginas, haga clic en el botón de re-paginar y elija el número deseado de preguntas por cada página.';
$string['orderingquiz'] = 'Orden y paginación';
$string['orderingquizx'] = 'Orden y paginación: {$a}';
$string['outcomesadvanced'] = 'Los resultados son configuraciones avanzadas';
$string['outof'] = '{$a->grade} de un total de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} de un total de {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Retroalimentación global según calificación';
$string['overallfeedback_help'] = '<p>La retroalimentación global consiste en un texto que se muestra al estudiante una vez que ha completado un intento de resolver el examen. El texto puede depender de la calificación que el estudiante haya conseguido.</p> <p>Por ejemplo, si usted escribe "¡Buen trabajo!" en la primera caja de retroalimentación, escriba 40% en la primera caja de límites de la calificación y escriba "Por favor, vuelve a revisar el trabajo de esta semana", los estudiantes que puntúen 40% o más verán el mensaje "¡Buen trabajo!", en tanto que los que hayan punteado menos del 40% verán el otro mensaje.</p> <p>Los límites de las calificaciones pueden especificarse en forma de porcentajes, por ejemplo "31.41%", o en forma de números, por ejemplo "7". Si el examen vale 10 puntos, un límite de calificación de 7 significa 7/10 o superior.</p>';
$string['overdue'] = 'Vencido';
$string['overduehandling'] = 'Cuando se agote el tiempo';
$string['overduehandling_desc'] = 'Qué deberá suceder por defecto si un estudiante no envía el examen antes de que se agote el tiempo.';
$string['overduehandling_help'] = 'Esta configuración controla lo que sucede si los alumnos no envían su intento de examen antes de que se agote el tiempo. Si los estudiantes están trabajando activamente en el examen en ese instante, entonces el cronómetro siempre enviará automáticamente el intento por ellos, pero si ellos se han salido del sitio, entonces esta configuración controla lo que sucederá.';
$string['overduehandlingautoabandon'] = 'Los intentos deben enviarse antes de que se agote el tiempo, o no serán contados';
$string['overduehandlingautosubmit'] = 'Los intentos abiertos son enviado automáticamente';
$string['overduehandlinggraceperiod'] = 'Hay un período de gracia para enviar los intentos abiertos, pero no pueden contestarse más preguntas';
$string['overduemustbesubmittedby'] = 'Este intento actualmente está vencido. Usted ya debería de haberlo enviado. Si Usted pretende que le califiquen este examen, debe de enviarlo a más tardar antes de {$a}.Si no lo envía para entonces, no se le contarán puntos de calificación para este intento.';
$string['override'] = 'Anular';
$string['overridedeletegroupsure'] = '¿Está seguro que desea eliminar la anulación del grupo {$a}?';
$string['overridedeleteusersure'] = '¿Está seguro que desea eliminar la anulación del usuario {$a}?';
$string['overridegroup'] = 'Reemplazar grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Anulaciones';
$string['overrideuser'] = 'Pasar por alto usuario';
$string['overrideusereventname'] = 'Administración del examen';
$string['page-mod-quiz-attempt'] = 'Intentar página de examen';
$string['page-mod-quiz-edit'] = 'Editar página del examen';
$string['page-mod-quiz-report'] = 'Cualquier página de reporte de examen';
$string['page-mod-quiz-review'] = 'Revisar página de intento de examen';
$string['page-mod-quiz-summary'] = 'Página resumen de intento de examen';
$string['page-mod-quiz-view'] = 'Página de información del examen';
$string['page-mod-quiz-x'] = 'Cualquier página del módulo Examen';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Tamaño de página';
$string['parent'] = 'Padre';
$string['parentcategory'] = 'Categoría padre';
$string['parsingquestions'] = 'Analizando preguntas del archivo de importación.';
$string['partiallycorrect'] = 'Parcialmente correcto';
$string['penalty'] = 'Penalización';
$string['penaltyscheme'] = 'Penalizar';
$string['penaltyscheme_help'] = '<p>Si un examen se realiza en modo adaptativo, se permitirá al estudiante intentar responder de nuevo tras una respuesta errónea. En este caso, tal vez usted quiera imponer una penalización por cada respuesta equivocada, para que sea substraída de la puntuación final de la pregunta. La cantidad de penalización se elige individualmente para cada pregunta cuando se fabrica o se edita la pregunta.</p> <p>Este ajuste no tiene efecto a menos que el examen se realice en modo adaptativo.</p>';
$string['percentcorrect'] = 'Porcentaje correcto';
$string['pleaseclose'] = 'Su petición ha sido procesada. Puede ahora cerrar la ventana';
$string['pluginadministration'] = 'Administración del examen';
$string['pluginname'] = 'Examen';
$string['popup'] = 'Mostrar el examen en una ventana \'segura\'';
$string['popupblockerwarning'] = 'Esta sección del examen está en modo seguro, lo que significa que usted necesita completar el examen en una ventana segura. Por favor, desactive el bloqueo de ventanas emergentes. Gracias.';
$string['popupnotice'] = 'Los estudiantes verán este examen en una ventana segura';
$string['preprocesserror'] = 'Ha ocurrido un error durante el procesamiento previo.';
$string['preview'] = 'Vista previa';
$string['previewquestion'] = 'Vista previa de la pregunta';
$string['previewquiz'] = 'Vista previa  {$a}';
$string['previewquiznow'] = 'Previsualizar el examen ahora';
$string['previous'] = 'Estado previo';
$string['privacy:metadata:core_question'] = 'La actividad de Examen almacena información de uso en el subsistema core_question.';
$string['privacy:metadata:quiz'] = 'La actividad de Examen hace uso de reportes de examen.';
$string['privacy:metadata:quiz_attempts'] = 'Detalles acerca de cada intento en un examen.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'El número del intento.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'La página actual en donde está el usuario.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Si es que esta es o no una vista previa del examen.';
$string['privacy:metadata:quiz_attempts:state'] = 'El estado actual del intento.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'La suma de calificaciones en el intento.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'La hora en la cual fue revisado el estado.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'La hora en la cual fue completado el intento.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'La hora en la cual fue actualizado el intento.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'La hora en la cual el intento fue subido vía una actualización fuera-de-línea.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'La hora en la cual fue iniciado el intento.';
$string['privacy:metadata:quiz_grades'] = 'Detalles acerca de la calificación global para este examen.';
$string['privacy:metadata:quiz_grades:grade'] = 'La calificación global para este examen.';
$string['privacy:metadata:quiz_grades:quiz'] = 'El examen que fue calificado.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'La hora en la cual la calificación fue modificada';
$string['privacy:metadata:quiz_grades:userid'] = 'El usuario que fue calificado.';
$string['privacy:metadata:quiz_overrides'] = 'Detalles acerca de anulaciones para este examen';
$string['privacy:metadata:quiz_overrides:quiz'] = 'El examen con información de anulación';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'La nueva hora de cierre para el examen.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'El nuevo límite de tiempo para el examen.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'La nueva hora de apertura para el examen.';
$string['privacy:metadata:quiz_overrides:userid'] = 'El usuario que está siendo anulado';
$string['privacy:metadata:quizaccess'] = 'La actividad de Examen hace uso de reglas de acceso al examen.';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Necesita tener permiso en el curso para añadir o editar preguntas en esta categoría';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nombre';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nombre';
$string['question'] = 'Pregunta';
$string['questionbank'] = 'del banco de preguntas';
$string['questionbankmanagement'] = 'Gestión del banco de preguntas';
$string['questionbehaviour'] = 'Comportamiento de las preguntas';
$string['questioncats'] = 'Categorías de pregunta';
$string['questiondeleted'] = 'Esta pregunta ha sido eliminada. Por favor, póngase en contacto con su profesor.';
$string['questiondependencyadd'] = 'No hay restricción acerca de cuando la pregunta {$a->thisq} pueda ser intentada • Haga clic para cambiar';
$string['questiondependencyfree'] = 'Sin restricción en esta pregunta';
$string['questiondependencyremove'] = 'La pregunta {$a->thisq} no puede ser intentada hasta que la pregunta anterior {$a->previousq} haya sido completada • Haga clic para cambiar';
$string['questiondependsonprevious'] = 'Esta pregunta no puede ser intentada hasta que haya sido completada la pregunta anterior.';
$string['questioninuse'] = 'La pregunta \'{$a->questionname}\' se utiliza en: <br />{$a->quiznames}<br />La pregunta no se borrará de estos exámenes, tan solo se borra de la lista de la categoría.';
$string['questionmissing'] = 'Falta la pregunta para esta sesión';
$string['questionname'] = 'Nombre de la pregunta';
$string['questionnonav'] = '<span class="accesshide">Pregunta </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Información </span>{$a->number}<span class="accesshide"> {$a- >attributes}</span>';
$string['questionnotloaded'] = 'La pregunta {$a} no se ha cargado desde la base de datos';
$string['questionorder'] = 'Orden de las preguntas';
$string['questionposition'] = 'Nueva posición en orden para pregunta {$a}';
$string['questions'] = 'Preguntas';
$string['questionsetpreview'] = 'Vista previa de conjunto de preguntas';
$string['questionsinclhidden'] = 'Preguntas (incluídas las ocultas)';
$string['questionsinthisquiz'] = 'Preguntas en este examen';
$string['questionsmatchingfilter'] = 'Preguntas que coinciden con este filtro: {$a}';
$string['questionsperpage'] = 'Número máximo de preguntas por página';
$string['questionsperpageselected'] = 'Se ha establecido el número de respuestas por página y la paginación está fijada actualmente. Como resultado, se han desactivado los controles de paginación. Puede cambiar esto en {$a}.';
$string['questionsperpagex'] = 'Preguntas por página: {$a}';
$string['questiontext'] = 'Texto de la pregunta';
$string['questiontextisempty'] = '[Texto de pregunta vacía]';
$string['questiontype'] = 'Tipo de pregunta {$a}';
$string['questiontypesetupoptions'] = 'Ajuste de opciones para los tipos de pregunta:';
$string['quiz:addinstance'] = 'Añadir un nuevo examen';
$string['quiz:attempt'] = 'Intentar resolver exámenes';
$string['quiz:deleteattempts'] = 'Eliminar intentos';
$string['quiz:emailconfirmsubmission'] = 'Recibir confirmación de sus propios envíos de examen';
$string['quiz:emailnotifysubmission'] = 'Recibir notificación de los envíos de examen de sus estudiantes';
$string['quiz:emailwarnoverdue'] = 'Recibir advertencia cuando su intento de examen se vuelve atrasado';
$string['quiz:grade'] = 'Calificar exámenes manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar el límite de tiempo en examen';
$string['quiz:manage'] = 'Gestionar exámenes';
$string['quiz:manageoverrides'] = 'Manejar sobre-ajustes (anulaciones) en examenes';
$string['quiz:preview'] = 'Vista previa de exámenes';
$string['quiz:regrade'] = 'Recalificar los intentos de resolver el examen';
$string['quiz:reviewmyattempts'] = 'Revisar sus propios intentos';
$string['quiz:view'] = 'Ver información sobre el examen';
$string['quiz:viewreports'] = 'Ver reportes de exámenes';
$string['quizavailable'] = 'El examen está disponible hasta el {$a}';
$string['quizclose'] = 'Cerrar el examen';
$string['quizclosed'] = 'Este examen se cerró el {$a}';
$string['quizcloses'] = 'Examen cerrado';
$string['quizcloseson'] = 'Este examen se cerrará en {$a}';
$string['quizeventcloses'] = '{$a} cierra';
$string['quizeventopens'] = '{$a} abre';
$string['quizisclosed'] = 'Este examen está cerrado';
$string['quizisclosedwillopen'] = 'Examen cerrado (abre {$a})';
$string['quizisopen'] = 'Este examen está abierto';
$string['quizisopenwillclose'] = 'El examen se abre (se cierra {$a})';
$string['quiznavigation'] = 'Navegación dentro del examen';
$string['quizopen'] = 'Abrir el examen';
$string['quizopenclose'] = 'Fechas de apertura y cierre';
$string['quizopenclose_help'] = 'Los estudiantes solo pueden iniciar su(s) intento(s) después de la hora en que se abre en examen y deben terminarlo antes de la hora en que se cierran.';
$string['quizopened'] = 'Este examen está abierto';
$string['quizopenedon'] = 'Este examen se abrió en {$a}';
$string['quizopens'] = 'Examen abierto';
$string['quizopenwillclose'] = 'Este examen está abierto, se cerrará en {$a}';
$string['quizordernotrandom'] = 'Orden no aleatorio';
$string['quizorderrandom'] = 'Orden aleatorio';
$string['quizreport'] = 'Reporte del examen';
$string['quizsettings'] = 'Ajustes del examen';
$string['quiztimer'] = 'Cronómetro regresivo del examen';
$string['quizwillopen'] = 'Este examen se abrirá en {$a}';
$string['random'] = 'Pregunta aleatoria';
$string['randomcreate'] = 'Crear preguntas aleatorias';
$string['randomediting'] = 'Editando una pregunta aleatoria';
$string['randomfromcategory'] = 'Pregunta aleatoria de la categoría.';
$string['randomfromexistingcategory'] = 'Pregunta aleatoria desde una categoría existente';
$string['randomfromunavailabletag'] = '{$a} (no disponible)';
$string['randomnosubcat'] = 'Preguntas sólo de esta categoría, no de sus sub-categorías.';
$string['randomnumber'] = 'Número de preguntas aleatorias';
$string['randomquestion'] = 'Pregunta aleatoria';
$string['randomquestion_help'] = 'Una pregunta aleatoria es una manera de insertar una pregunta elegida aleatoriamente desde una categoría especificada o por una marca especificada dentro de una actividad.';
$string['randomquestiontags'] = 'Marcas';
$string['randomquestiontags_help'] = 'Usted puede restringir aun más el criterio de selección al especificar algunas marcas de pregunta aquí.

Las preguntas "aleatorias" serán seleccionadas de entre las preguntas que tengan todas estas marcas.';
$string['randomquestionusinganewcategory'] = 'Pregunta aleatoria utilizando una categoría nueva';
$string['randomwithsubcat'] = 'Preguntas de esta categoría y de sus sub-categorías.';
$string['readytosend'] = 'Está a punto de enviar su examen para que sea calificado. ¿Está seguro de que desea continuar?';
$string['reattemptquiz'] = 'Reintentar el examen';
$string['recentlyaddedquestion'] = 'Pregunta agregada recientemente';
$string['recurse'] = 'Incluir también preguntas de subcategorías';
$string['redoesofthisquestion'] = 'Otras preguntas intentadas aquí: {$a}';
$string['redoquestion'] = 'Intentar otra pregunta como esta';
$string['regrade'] = 'Recalificar todos los intentos';
$string['regradecomplete'] = 'Todos los intentos han sido recalificados';
$string['regradecount'] = 'Se han cambiado {$a->changed} de {$a->attempt} calificaciones';
$string['regradedisplayexplanation'] = 'Los intentos que cambian durante la recalificación se muestran como hiperenlaces a la ventana de revisión de preguntas';
$string['regradenotallowed'] = 'No tiene los permisos para recalificar este examen';
$string['regradingquestion'] = 'Recalificando "{$a}".';
$string['regradingquiz'] = 'Recalificando el examen "{$a}"';
$string['remove'] = 'Quitar';
$string['removeallgroupoverrides'] = 'Eliminar todas las anulaciones de grupo';
$string['removeallquizattempts'] = 'Eliminar todos los intentos de resolver el examen';
$string['removealluseroverrides'] = 'Eliminar todas las anulaciones de usuario';
$string['removeemptypage'] = 'Eliminar la página vacía';
$string['removepagebreak'] = 'Remover salto de página';
$string['removeselected'] = 'Quitar las seleccionadas';
$string['rename'] = 'Renombrar';
$string['renderingserverconnectfailed'] = 'El servidor {$a} no ha podido procesar una petición RQP. Compruebe que la URL es correcta.';
$string['reorderquestions'] = 'Volver a ordenar las preguntas';
$string['reordertool'] = 'Mostrar herramienta de reordenación';
$string['repaginate'] = 'Repaginar con {$a} preguntas por página';
$string['repaginatecommand'] = 'Paginar de nuevo';
$string['repaginatenow'] = 'Repaginar ahora';
$string['replace'] = 'Reemplazar';
$string['replacementoptions'] = 'Opciones de reemplazar';
$string['report'] = 'Reportes';
$string['reportanalysis'] = 'Análisis de ítems';
$string['reportattemptsfrom'] = 'Intentos de';
$string['reportattemptsthatare'] = 'Los intentos que hay';
$string['reportdisplayoptions'] = 'Opciones de visualización';
$string['reportfullstat'] = 'Estadísticas detalladas';
$string['reportmulti_percent'] = 'Porcentajes mútiples';
$string['reportmulti_q_x_student'] = 'Opciones multi-estudiante';
$string['reportmulti_resp'] = 'Respuestas individuales';
$string['reportmustselectstate'] = 'Usted debe seleccionar al menos un estado.';
$string['reportnotfound'] = 'Reporte no conocido ({$a})';
$string['reportoverview'] = 'Vista general';
$string['reportregrade'] = 'Recalificar intentos';
$string['reportresponses'] = 'Respuestas detalladas';
$string['reports'] = 'Reportes';
$string['reportshowonly'] = 'Mostrar únicamente intentos';
$string['reportshowonlyfinished'] = 'Mostrar un máximo de un intento terminado por usuario ({$a})';
$string['reportsimplestat'] = 'Estadística simple';
$string['reportusersall'] = 'todos los usuarios que han intentado este examen';
$string['reportuserswith'] = 'usuarios inscritos que han intentado este examen';
$string['reportuserswithorwithout'] = 'usuarios inscritos, hayan o no intentado  este examen';
$string['reportuserswithout'] = 'usuarios inscritos que no han intentado este examen';
$string['reportwhattoinclude'] = 'Qué incluir en el reporte';
$string['requirepassword'] = 'Se requiere contraseña';
$string['requirepassword_help'] = '<p>Es un campo opcional</p> <p>Si añadimos una contraseña los alumnos deben escribir la misma contraseña antes de que puedan hacer el examen.</p>';
$string['requiresubnet'] = 'Se requiere dirección de red';
$string['requiresubnet_help'] = '<p align=center><b>Se requiere dirección de red</b></p> <p>Es un campo opcional.</p> <p>Podemos restringir el acceso a un examen a una subred particular como una red local (LAN) o Internet especificando una lista separada por comas de los números parciales o completos de dirección IP.</p> <p>Esto es especialmente útil para a proteger el examen y asegurarnos de que sólo pueda realizarse desde una determinada aula o red.</p> <p>Por ejemplo: <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p> <p>Hay tres tipos de números que podemos utilizar (no podemos utilizar dominios basados en texto como ejemplo.com): <ol> <li>Direcciones IP completas, tales como 192.168.10.1 que se asocian a una única computadora (o Proxy).</li> <li>Direcciones parciales, tales como 192.168 que se asocian a cualquier red que comience con esos números.</li> <li>Notación CIDR, como <b>231.54.211.0/20</b> que permiten habilitar con más precisión subredes.</li> </ol> </p> <p>Los espacios en blanco son ignorados.</p>

EJEMPLOS IP LABORATORIOS

132.248.62.248, 192.168.200.0/24 MULTIMEDIA

132.248.62.243, 192.168.91.0/24 BIBLIOTECA';
$string['response'] = 'Respuesta';
$string['responses'] = 'Respuestas del alumno';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Regresar al intento';
$string['reuseifpossible'] = 're-utilizar las eliminadas previamente';
$string['reverttodefaults'] = 'Restaurar las opciones default del examen';
$string['review'] = 'Revisión';
$string['reviewafter'] = 'Permitir revisión despues que se ha cerrado el examen';
$string['reviewalways'] = 'Permitir revisión en cualquier momento';
$string['reviewattempt'] = 'Revisión del intento';
$string['reviewbefore'] = 'Permitir revisión mientras el examen está abierto';
$string['reviewclosed'] = 'Después de que el examen sea cerrado';
$string['reviewduring'] = 'Durante el intento';
$string['reviewimmediately'] = 'Inmediatamente después del intento';
$string['reviewnever'] = 'No permitir revisión';
$string['reviewofattempt'] = 'Revisión del intento {$a}';
$string['reviewofpreview'] = 'Revisión de la vista previa';
$string['reviewofquestion'] = 'Revisión de pregunta {$a->question} en {$a->quiz} por {$a->user}';
$string['reviewopen'] = 'Después, mientras el examen sigue abierto';
$string['reviewoptions'] = 'Los estudiantes pueden revisar';
$string['reviewoptionsheading'] = 'Opciones para la revisión por el alumno';
$string['reviewoptionsheading_help'] = 'Estas opciones controlan qué información pueden ver los alumnos cuando revisan un intento de resolver el examen o cuando ven los reportes correspondientes.

**Durante el intento** estas configuraciones solamente son relevantes para algunos comportamientos como el \'interactivo con múltiples intentos\', en donde se muestra la retroalimentación durante el intento

**Immediatamente después del intento** estas configuraciones aplican para los primeros dos minutos después de hacer clic en \'Enviar todo y terminar\'.

**Más tarde, mientras el examen está aún abierto** estas configuraciones aplican después de esto, y antes de la fecha de cierre del examen.

**Después de que el examen sea cerrado** estas configuraciones aplican después de que haya pasado la fecha de cierre del examen. Si el examen no tiene fecha de cierre, este estado no se alcanza nunca.';
$string['reviewoverallfeedback'] = 'Retroalimentación global';
$string['reviewoverallfeedback_help'] = 'La retroalimentación se da al final del intento, dependiendo del puntaje total de estudiante.';
$string['reviewresponse'] = 'Revisar respuesta';
$string['reviewresponsetoq'] = 'Revisar respuesta (pregunta {$a})';
$string['reviewthisattempt'] = 'Revisar sus respuestas en este intento';
$string['rqp'] = 'Pregunta remota';
$string['rqps'] = 'Preguntas remotas';
$string['sameasoverall'] = 'Los mismos que para las calificaciones totales';
$string['save'] = 'Guardar';
$string['saveandedit'] = 'Guardar cambios y editar preguntas';
$string['saveattemptfailed'] = 'No se pudo guardar el intento de resolver el examen.';
$string['savedfromdeletedcourse'] = 'Guardado del curso eliminado "{$a}"';
$string['savegrades'] = 'Guardar calificaciones';
$string['savemyanswers'] = 'Guardar mis respuestas';
$string['savenosubmit'] = 'Guardar sin enviar';
$string['saveoverrideandstay'] = 'Guardar e introducir otra anulación';
$string['savequiz'] = 'Guardar todo el examen';
$string['saving'] = 'Guardando';
$string['savingnewgradeforquestion'] = 'Guardando nueva calificación para la pregunta con id {$a}.';
$string['savingnewmaximumgrade'] = 'Guardando nueva calificación máxima.';
$string['score'] = 'Puntuación bruta';
$string['scores'] = 'Calificaciones';
$string['search:activity'] = 'Examen - información de actividad';
$string['sectionheadingedit'] = 'Editar encabezado \'{$a}\'';
$string['sectionheadingremove'] = 'Remover encabezado \'{$a}\'';
$string['seequestions'] = '(Ver preguntas)';
$string['select'] = 'Seleccionar';
$string['selectall'] = 'Seleccionar todas';
$string['selectattempt'] = 'Seleccionar intento';
$string['selectcategory'] = 'Seleccionar categoría';
$string['selectedattempts'] = 'Intentos seleccionados...';
$string['selectmultipleitems'] = 'Seleccionar varios ítems';
$string['selectmultipletoolbar'] = 'Barra_de_herramienta selector múltiple';
$string['selectnone'] = 'Omitir todas';
$string['selectquestiontype'] = '-- Seleccionar tipo de pregunta --';
$string['serveradded'] = 'Servidor añadido';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Información del servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL del servidor';
$string['settingsoverrides'] = 'Anulaciones de configuraciones';
$string['shortanswer'] = 'Respuesta corta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar todas las preguntas en una página';
$string['showblocks'] = 'Mostrar bloques durante los intentos';
$string['showblocks_help'] = 'Si se selecciona SÍ, se mostrarán los bloques normales durante los intentos de resolver el examen';
$string['showbreaks'] = 'Mostrar saltos de página';
$string['showcategorycontents'] = 'Mostrar el contenido de la categoría {$a->arrow}';
$string['showcorrectanswer'] = '¿Mostrar respuestas correctas en la retroalimentación?';
$string['showdetailedmarks'] = 'Mostrar detalles de la puntuación';
$string['showeachpage'] = 'Mostrar una página cada vez';
$string['showfeedback'] = '¿Mostrar retroalimentación después de contestar?';
$string['showinsecurepopup'] = 'Utilizar una ventana emergente \'segura\' para los intentos';
$string['showlargeimage'] = 'Imagen grande';
$string['shownoattempts'] = 'Mostrar estudiantes sin intentos';
$string['shownoattemptsonly'] = 'Mostrar sólo estudiantes sin intentos';
$string['shownoimage'] = 'Sin imagen';
$string['showreport'] = 'Mostrar reporte';
$string['showsmallimage'] = 'Imagen pequeña';
$string['showteacherattempts'] = 'Mostrar intentos del profesor';
$string['showuserpicture'] = 'Mostrar la imagen del usuario';
$string['showuserpicture_help'] = 'Si usted habilita esta opción, el nombre del estudiante y su imagen serán mostradas en la pantalla durante el intento, y en la pantalla de revisión, haciendo más fácil el verificar la identidad del estudiante que intenta un examen supervisado.';
$string['shuffle'] = 'Orden al azar';
$string['shuffleanswers'] = 'Respuestas ordenadas al azar';
$string['shuffledrandomly'] = 'Presentadas al azar';
$string['shufflequestions'] = 'Barajar';
$string['shufflequestions_help'] = 'Si se habilita, cada vez que se intente contestar el examen, se barajará el orden de las preguntas en esta sección a un nuevo orden aleatorio.

Esto puede dificultar el que los estudiantes se compartan las respuestas, pero también hace más difícil que los estudiantes discutan con el profesor alguna pregunta en particular.';
$string['shufflewithin'] = 'Ordenar al azar las respuestas';
$string['shufflewithin_help'] = 'Si habilita esta opción, las respuestas para cada pregunta individual se ordenarán al azar cada vez que un estudiante conteste el examen, suponiendo que la opción también esté habilitada en los ajustes del módulo de exámenes. Esta opción sólo es aplicable a preguntas que tienen elementos múltiples, como las preguntas de opción múltiple o de relacionar columnas.';
$string['singleanswer'] = 'Seleccione una respuesta.';
$string['sortage'] = 'Ordenar por edad';
$string['sortalpha'] = 'Ordenar alfabéticamente';
$string['sortquestionsbyx'] = 'Ordenar preguntas por: {$a}';
$string['sortsubmit'] = 'Ordenar preguntas';
$string['sorttypealpha'] = 'Ordenar por tipo, nombre';
$string['specificapathnotonquestion'] = 'La ruta al archivo especificado no está en la pregunta especificada';
$string['specificquestionnotonquiz'] = 'La pregunta especificada no está en el examen especificado';
$string['startagain'] = 'Comenzar de nuevo';
$string['startattempt'] = 'Iniciar intento';
$string['startedon'] = 'Comenzado en';
$string['startnewpreview'] = 'Nueva vista previa';
$string['stateabandoned'] = 'Nunca enviados';
$string['statefinished'] = 'Terminados';
$string['statefinisheddetails'] = 'Enviado {$a}';
$string['stateinprogress'] = 'En progreso';
$string['statenotloaded'] = 'El estado de la pregunta {$a} no ha sido cargado desde la base de datos';
$string['stateoverdue'] = 'Atrasados';
$string['stateoverduedetails'] = 'Debe ser enviado para {$a}';
$string['status'] = 'Estatus';
$string['stoponerror'] = 'Parar al encontrar un error';
$string['submitallandfinish'] = 'Enviar todo y terminar';
$string['subneterror'] = 'Lo sentimos, este examen ha sido bloqueado de modo que sólo es accesible desde ciertas direcciones. En este momento su computadora no está autorizada para usar este examen.';
$string['subnetnotice'] = 'Este examen ha sido bloqueado, de modo que sólo es accesible desde ciertas ubicaciones. Su computadora no está en una sub-red habilitada. Como profesor, puede acceder en cualquier caso a la vista previa.';
$string['subplugintype_quiz'] = 'Reporte';
$string['subplugintype_quiz_plural'] = 'Reportes';
$string['subplugintype_quizaccess'] = 'Regla de acceso';
$string['subplugintype_quizaccess_plural'] = 'Reglas de acceso';
$string['substitutedby'] = 'serán sustituídas por';
$string['summaryofattempt'] = 'Resumen del intento';
$string['summaryofattempts'] = 'Resumen de sus intentos previos';
$string['temporaryblocked'] = 'Durante cierto tiempo no está autorizado a intentar de nuevo resolver el examen.<br /> Podrá intentarlo nuevamente en:';
$string['theattempt'] = 'El intento';
$string['theattempt_help'] = 'Si es que el estudiante puede revisar el intento.';
$string['time'] = 'Tiempo';
$string['timecompleted'] = 'Finalizado';
$string['timedelay'] = 'No se le permite a realizar el examen debido a que no ha transcurrido el tiempo necesario antes de intentarlo de nuevo.';
$string['timeleft'] = 'Tiempo restante';
$string['timelimit'] = 'Límite de tiempo';
$string['timelimit_help'] = 'Si está activado, un cronómetro se visualiza en una ventana flotante (se requiere JavaScript) mostrando una cuenta regresiva del tiempo disponible. Cuando el plazo se finaliza, el examen se envía automáticamente con las respuestas realizadas hasta el momento.';
$string['timelimitexeeded'] = 'Lo sentimos. Se ha sobrepasado el  tiempo para el examen.';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = '¡Se ha pasado el tiempo!';
$string['timetaken'] = 'Tiempo empleado';
$string['timing'] = 'Tiempo';
$string['tofile'] = 'al archivo';
$string['tolerance'] = 'Tolerancia';
$string['toomanyrandom'] = '¡El número requerido de preguntas aleatorias  es mayor de las que aun están disponibles en la categoría!';
$string['top'] = 'Arriba';
$string['totalmarksx'] = 'Total de puntos: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} preguntas en la categoría.';
$string['true'] = 'Verdadero';
$string['truefalse'] = 'Falso/Verdadero';
$string['type'] = 'Tipo';
$string['unfinished'] = 'abierto';
$string['ungraded'] = 'Sin calificar';
$string['unit'] = 'Unidad';
$string['unknowntype'] = 'Tipo de pregunta no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['updateoverdueattemptstask'] = 'Actualizando intentos de exámenes retrasados';
$string['updatequizslotswithrandomxofy'] = 'Actualizando posiciones del examen con datos de preguntas "aleatorias" ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Actualizar ajustes del examen';
$string['updatingatttemptgrades'] = 'Actualizando calificaciones de intentos.';
$string['updatingfinalgrades'] = 'Actualizando calificaciones finales.';
$string['updatingthegradebook'] = 'Actualizando el libro de calificaciones';
$string['upgradesure'] = '<div style="color: red;">En concreto, el módulo Examen efectuará un extenso cambio de las tablas del examen y esta actualización aún no ha sido suficientemente probada. Le recomendamos encarecidamente hacer un respaldo de las tablas de su base de datos antes de continuar.</div>';
$string['upgradingquizattempts'] = 'Actualizando intentos de exámenes: examen {$a->done}/{$a->outof} (Quiz id {$a->info})s';
$string['upgradingveryoldquizattempts'] = 'Actualizando intentos de examen muy antiguos: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoría ha sido conservada y movida al nivel del sitio porque, tras eliminar el curso, sus preguntas publicadas estaban en uso por otros cursos del servidor.';
$string['useroverrides'] = 'Anulaciones del usuario';
$string['useroverridesdeleted'] = 'Anulaciones de usuario eliminadas';
$string['usersnone'] = 'Ningún estudiante tiene acceso a este examen';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} intentos de exámenes';
$string['viewallreports'] = 'Ver los reportes de {$a} intentos';
$string['viewed'] = 'Visto';
$string['warningmissingtype'] = '<p><b>Este tipo de pregunta aún no ha sido instalado en su Moodle.<br />Por favor, comuníquelo a su administrador.</b></p>';
$string['wheregrade'] = '¿Dónde está mi calificación?';
$string['wildcard'] = 'Comodín';
$string['windowclosing'] = 'Esta ventana se cerrará en breve.';
$string['withsummary'] = 'con estadísticas resumidas';
$string['wronguse'] = 'Usted no puede usar esta página así';
$string['xhtml'] = 'Formato XHTML';
$string['youneedtoenrol'] = 'Necesita inscribirse en este curso antes de realizar este examen';
$string['yourfinalgradeis'] = 'Su calificación final para este examen es {$a}.';
