<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'geogebra', language 'es_mx', version '3.10'.
 *
 * @package     geogebra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityclosed'] = 'Esta actividad ya no está disponible';
$string['activitynotopened'] = 'Esta actividad aún no está disponible';
$string['attempt'] = 'Intento';
$string['attempts'] = 'Intentos';
$string['attemptsremaining'] = 'Intentos disponibles para esta actividad:';
$string['autograde'] = 'Actividad auto-calificable';
$string['availabledate'] = 'Disponible a partir de';
$string['average'] = 'Promedio';
$string['choosescripttype'] = 'Escoge el tipo de script (actividad)';
$string['comment'] = 'Comentario';
$string['contentheader'] = 'Contenido';
$string['coursewithoutstudents'] = 'No hay estudiantes inscritos en este curso';
$string['datestudent'] = 'Última modificación (envío)';
$string['dateteacher'] = 'Última modificación (calificación)';
$string['deleteallattempts'] = 'Eliminar todos los intentos';
$string['description'] = 'Descripción';
$string['discardchanges'] = 'Volver sin guardar cambios';
$string['duedate'] = 'Hasta';
$string['duration'] = 'Duración';
$string['enableLabelDrags'] = 'Permite arrastrar las etiquetas';
$string['enableRightClick'] = 'Habilita el botón derecho';
$string['errorattempt'] = 'Se ha producido un error. No se ha podido guardar el intento.';
$string['event_course_module_viewed'] = 'Módulo de curso visto';
$string['event_instances_list_viewed'] = 'Lista de instancias vista';
$string['expired'] = 'Esta actividad se cerró el {$a} y, por lo tanto, ya no está disponible.';
$string['extractedfromggb'] = 'Archivos extaridos de ggb';
$string['filename'] = 'Nombre del archivo';
$string['filenotfound'] = 'El archivo indicado no existe';
$string['filetype'] = 'Tipo';
$string['filetype_help'] = 'Esta configuración determina cómo se incluye la actividad GeoGebra en el curso. Hay 2 opciones:

* Archivo GeoGebra subido - Posibilita escoger un archivo ".ggb" válido mediante el selector de archivos.
* URL externa - Posibilita especificar la URL de una actividad GeoGebra. NOTA: La URL debe empezar con http(s) o www y contener un archivo ".ggb" válido';
$string['filetypeexternal'] = 'URL externa';
$string['filetypelocal'] = 'Archivo subido';
$string['firstattempt'] = 'Primer intento';
$string['for'] = 'para';
$string['functionalityoptionsgrp'] = 'Funcionalidades';
$string['geogebra:addinstance'] = 'Añadir un GeoGebra';
$string['geogebra:grade'] = 'Evaluar GeoGebra';
$string['geogebra:submit'] = 'Enviar GeoGebra';
$string['geogebra:view'] = 'Visualizar GeoGebra';
$string['geogebrafile'] = 'Fichero GeoGebra';
$string['geogebrafile_help'] = 'El archivo ".ggb" que contiene la actividad GeoGebra.';
$string['geogebraurl'] = 'URL';
$string['geogebraurl_help'] = 'Encuentre la construcción en <a href="https://www.geogebra.org/" target="_blank">geogebra.org</a>, ir a <strong>Detalles</strong>, clic derecho en <strong>Download</strong> y seleccionar <strong>Copiar dirección del enlace</strong>. Finallmente, ir al campo de URL y pegar el enlace con <strong>Ctrl+V</strong>.<br/>Vea un ejemplo paso-a-paso en: <a href="https://youtu.be/qbp-RuM4NpU" target="_blank">https://youtu.be/qbp-RuM4NpU</a>.';
$string['grade'] = 'Calificación';
$string['gradeit'] = 'Calificación';
$string['grademethod'] = 'Método de calificación';
$string['height'] = 'Alto';
$string['highestattempt'] = 'Mejor intento';
$string['httpnotallowed'] = 'Por el momento, no es posible utilizar archivos remotos';
$string['interfaceoptionsgrp'] = 'Interfaz del Usuario';
$string['invalidgeogebrafile'] = 'Se ha especificado un rachivo GeoGebra no válido. El archivo debe tener la extensión ".ggb".';
$string['invalidurl'] = 'Se ha especificado una URL no válido. La URL debe empezar con http(s) y enlazar a un archivo ".ggb" válido.';
$string['language'] = 'Idioma';
$string['lastattempt'] = 'Último intento';
$string['lastattemptremaining'] = 'Este es tu último intento en esta actividad';
$string['lastmodifiedgrade'] = 'Última (calificación) modificada';
$string['lastmodifiedsubmission'] = 'Último (envío) modificado';
$string['lowestattempt'] = 'Peor intento';
$string['manualgrade'] = '¿ Calificación manual?';
$string['maxattempts'] = 'Número máximo de intentos';
$string['modulename'] = 'GeoGebra';
$string['modulename_help'] = '<p><a href="http://www.geogebra.org" target="_blank">GeoGebra</a> es un programa de matemáticas dinámico, gratuito y multi-plataforma, para todos los niveles de educación, que une geometría, álgebra, tablas, estadísticas para graficar y cálculo en un paquete fácil de utilizar.</p>
<p>Por lo que el  <a href="http://www.gencat.cat/ensenyament/" target="_blank">Departamento de Educación de Cataluña</a> en colaboración con la <a href="http://acgeogebra.cat/" target="_blank">Asociación Catalana de GeoGebra</a> (ACG) y el equipo de desarrollo de GeoGeobra han implementado este módulo, que permite la incorporación de actividades de Geogebra dentro de Moodle. Sus principales características son:
<ul>
    <li>Permite incrustar fácilmente actividades GeoGebra en cursos Moodle.</li>
    <li>Les facilita a los estudiantes el seguimiento, porque almacena el puntaje, la fecha, la duración y construcción de cada intento hecho por los usuarios.</li>
    <li>Los estudiantes pueden guardar el estado de las actividades y continuar después.</li>
</ul>
</p>';
$string['modulenameplural'] = 'GeoGebra';
$string['msg_noattempts'] = 'Ya has realizado esta actividad el máximo número de veces';
$string['msg_nosessions'] = 'La actividad de Geogebra todavía no ha tenido ninguna sesión';
$string['name'] = 'Nombre';
$string['noattempts'] = '-';
$string['nograding'] = 'Sin calificación';
$string['nomoreattempts'] = 'Ya has realizado todos los intentos posibles para esta actividad';
$string['notopenyet'] = 'Esta actividad no estará disponible hasta {$a}';
$string['pluginadministration'] = 'Administración de GeoGebra';
$string['pluginname'] = 'GeoGebra';
$string['preview_geogebra'] = 'Previsualizar actividad geogebra';
$string['previewtab'] = 'Previsualizar';
$string['privacy'] = 'Privacidad de resultados';
$string['privacy:metadata:geogebra_attempts'] = 'Información acerca de los intentos de resultados del usuario para una actividad geogebra dada';
$string['privacy:metadata:geogebra_attempts:datestudent'] = 'El sello de tiempo que indica cuando fue terminado el intento por el estudiante';
$string['privacy:metadata:geogebra_attempts:dateteacher'] = 'El sello de tiempo que indica cuando fue terminado el intento por el profesor';
$string['privacy:metadata:geogebra_attempts:finished'] = 'El sello de tiempo que indica cuando fue terminado el intento por el usuario';
$string['privacy:metadata:geogebra_attempts:geogebra'] = 'La ID de la actividad de Elección';
$string['privacy:metadata:geogebra_attempts:gradecomment'] = 'El comentario de la calificación para el intento de la actividad geogebra.';
$string['privacy:metadata:geogebra_attempts:userid'] = 'La ID del usuario que contesta esta actividad geogebra';
$string['privacy:metadata:geogebra_attempts:vars'] = 'La ID de la opción que el usuario seleccionó.';
$string['redirecttocourse'] = 'La actividad se ha guardado correctamente. Se está volviendo a la pantalla de inicio.';
$string['report'] = 'Informe de';
$string['results'] = 'Resultados';
$string['resultstab'] = 'Resultados';
$string['resumeattempt'] = 'Continuación de un intento anterior';
$string['review'] = 'Revisión de';
$string['reviewtab'] = 'Revisión';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar los cambios';
$string['savewithoutsubmitting'] = 'Guarda sin enviar';
$string['settings'] = 'Configuraciones';
$string['showAlgebraInput'] = 'Muestra la barra de entrada';
$string['showMenuBar'] = 'Muestra la barra de menú';
$string['showResetIcon'] = 'Muestra el icono de reiniciar construcción';
$string['showToolBar'] = 'Muestra la barra de herramientas';
$string['showToolBarHelp'] = 'Muestra la ayuda de la barra de herramientas';
$string['showsubmit'] = 'Muestra el botón de enviar';
$string['status'] = 'Estado';
$string['submitandfinish'] = 'Entregar y terminar';
$string['timing'] = 'Tiempo';
$string['total'] = 'Total';
$string['unfinished'] = 'No finalizado';
$string['ungraded'] = 'Sin calificar';
$string['unlimitedattempts'] = 'Esta actividad no tiene límite de intentos';
$string['urledit'] = 'Archivo GeoGebra';
$string['urledit_help'] = 'El archivo ".ggb" que contiene la actividad GeoGebra.';
$string['useBrowserForJS'] = 'Usar JavaScript desde:';
$string['useBrowserForJS_geogebra'] = 'GeoGebra file (false)';
$string['useBrowserForJS_html'] = 'HTML (true)';
$string['view'] = 'Ver';
$string['viewattempt'] = 'Visualizar';
$string['viewattempts'] = 'Ver intentos';
$string['viewattempttab'] = 'Ver Intento';
$string['viewtab'] = 'Mostrar';
$string['weight'] = 'Ancho';
$string['width'] = 'Ancho';
