<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'eu', version '3.10'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ekintzak';
$string['activate'] = 'Gaitu sarbidea';
$string['activatesuccess'] = 'Dominetarako sarbidea ondo gaitu da.';
$string['addalignment'] = 'Gehitu kanpoko trebetasuna edo estandarra';
$string['addbackpack'] = 'Gehitu motxila';
$string['addbadge'] = 'Gehitu dominak';
$string['addbadge_help'] = 'Aukeratu dominarako baldintza honetara gehitu beharreko ikastaro guztiak. Eutsi CTRL teklari hainbat elementu aukeratzeko.';
$string['addbadgecriteria'] = 'Gehitu dominarako irizpidea';
$string['addcohort'] = 'Gehitu kohortea';
$string['addcohort_help'] = 'Aukeratu domina honen eskaerei lotu beharreko kohorte guztiak. Eutsi CTRL teklari hainbat elementu aukeratzeko.';
$string['addcompetency'] = 'Gehitu konpetentzia';
$string['addcompetency_help'] = 'Aukeratu domina honen baldintzetara gehitu beharreko konpetentzia guztiak. Mantendu Ctrl sakatuta item anitz hautatzeko.';
$string['addcourse'] = 'Gehitu ikastaroak';
$string['addcourse_help'] = 'Aukeratu dominarako baldintza honetara gehitu beharreko ikastaro guztiak. Eutsi CTRL teklari hainbat elementu aukeratzeko.';
$string['addcriteria'] = 'Gehitu irizpidea';
$string['addcriteriatext'] = 'Irizpideak gehitzen hasteko, mesedez egin aukera zabaltzen den menutik';
$string['addedtobackpack'] = 'Gehitu domina motxilara';
$string['addrelated'] = 'Gehitu erlazionatutako domina';
$string['addtobackpack'] = 'Gehitu motxilara';
$string['adminonly'] = 'Orri hau soilik gunearen kudeatzaileentzako da';
$string['after'] = 'emate-dataren ondoren.';
$string['aggregationmethod'] = 'Agregazio-metodoa';
$string['alignment'] = 'Lerrokatzea';
$string['all'] = 'Guztiak';
$string['allmethod'] = 'Aukeratutako baldintza guztiak betetzen dira';
$string['allmethodactivity'] = 'Aukeratutako jarduera guztiak osatuta daude';
$string['allmethodbadges'] = 'Aukeratutako domina guztiak eskuratu dira';
$string['allmethodcohort'] = 'Aukeratutako kohorte guztietan partaidetza';
$string['allmethodcompetencies'] = 'Aukeratutako konpetentzia guztiak osatu dira';
$string['allmethodcourseset'] = 'Aukeratutako ikastaro guztiak osatuta daude';
$string['allmethodmanual'] = 'Aukeratutako rol guztiek ematen dute domina.';
$string['allmethodprofile'] = 'Aukeratutako profileko eremu guztiak osatu dira';
$string['allowcoursebadges'] = 'Gaitu ikastaroko dominak';
$string['allowcoursebadges_desc'] = 'Baimendu dominak sortu eta emateko ikastaro-testuinguruan.';
$string['allowexternalbackpack'] = 'Kanpoko motxiletarako konexioa';
$string['allowexternalbackpack_desc'] = 'Gaituz gero, erabiltzaileek kanpoko motxiletara lotu eta gune honetako euren dominak partekatu ditzakete. Erabiltzaileek euren kanpoko motxilan publikoa den edozein domina-bilduma gune honetako euren profilean ere erakutsi ditzakete.  Zure gunera internetetik sartzerik ez badago aukera hau desgaituta uztea gomendatzen da.';
$string['any'] = 'Edozein';
$string['anymethod'] = 'Edozein baldintza betetzen da';
$string['anymethodactivity'] = 'Aukeratutako edozein jarduera osatu da';
$string['anymethodbadges'] = 'Aukeratutako edozein domina eskuratu da';
$string['anymethodcohort'] = 'Aukeratutako kohorteetako edozeinetan partaidetza';
$string['anymethodcompetencies'] = 'Ez da aukeratutako konpetentziarik osatu.';
$string['anymethodcourseset'] = 'Aukeratutako edozein ikastaro osatu da';
$string['anymethodmanual'] = 'Aukeratutako edozein rolek ematen du domina';
$string['anymethodprofile'] = 'Aukeratutako edozein profil-eremu osatu da';
$string['apiversion'] = 'Onartutako API bertsioa';
$string['archivebadge'] = '\'{$a}\' domina ezabatu nahi duzu, baina emandako dominak mantenduta?';
$string['archiveconfirm'] = 'Ezabatu eta mantendu emandako dominak';
$string['archivehelp'] = '<p>Aukera honen bidez domina "baztertuta" bezala markatuko da eta aurrerantzean ez da dominen zerrendan agertuko. Erabiltzaileek ezingo dute domina hau gehiago eskuratu, baina domina aurretik jaso dutenek euren profilean domina hau ikusi eta kanpo-motxiletara gehitzeko aukera izaten jarraituko dute.</p>
<p>Erabiltzaileek euren dominetara sarbidea izaten jarraitzea nahi izanez gero aukera hau hautatzea garrantzitsua da, domina guztiz ezabatu beharrean</p>';
$string['attachment'] = 'Erantsi domina mezuari';
$string['attachment_help'] = 'Gaituz gero, jasotzailearen e-mailari domina jaisteko moduan erantsiko zaio. (Eranskinek gaituta egon behar dute hemen aukera hau erabiltzeko: Gunearen kudeaketa > Pluginak > Irteerako mezuak > Posta elektronikoa)';
$string['award'] = 'Eman domina';
$string['awardedtoyou'] = 'Niri emandakoa';
$string['awardoncron'] = 'Dominetarako sarbidea modu egokian gaitu da. Erabiltzaile askok irabaz dezakete aldi berean domina hau. Gunea behar bezala ibiltzeko, ekintza hau prozesatzeko denbora-tartetxo bat beharko da.';
$string['awards'] = 'Jasotzaileak';
$string['backpackapiurl'] = 'Motxilaren APIaren URLa';
$string['backpackavailability'] = 'Dominaren kanpoko egiaztapena';
$string['backpackavailability_help'] = 'Domina-jasotzaileek zeuk emandako dominak irabazi dituztela egiaztatu ahal izateko, kanpoko motxila-zerbitzuak zure gunerako sarbidea izan behar du eta hartara bertatik emandako dominak egiaztatu.

Ez dirudi une honetan zure gunea eskuragarri dagoenik eta beraz orain arte emandako edo hemendik aurrera emandako dominak ezin izango dira egiaztatu.

**Zer dela-eta mezu hau?**

Izan daiteke firewall-ak saretik kanpoko erabiltzaileei sartzen ez uztea, gunea pasahitzez babestuta egotea edo gunea interneten eskuragarri ez dagoen ekipo batean aritzea (adibidez, makina batean lokalean).

**Arazoa al da?**

Dominak emango dituen lanean ari den gune bakoitzean konpondu behar duzu arazoa; bestela, jasotzaileek ezin izango dute egiaztatu zuk emandako dominak irabazi dituztela. Zure gunea ez badago aktiboa probako dominak sortu eta eman ditzakezu beti ere aktibatu aurretik gunea eskuragarri badago.

**Zer gertatzen da ezin badut nire gunerako erabateko sarbide publikoa eman?**

Egiaztatzeko beharrezko den URL bakarra [zure-gunearen-urla]/badges/assertion.php, da eta  fitxategi horretarako kanpoko sarbidea baimentzeko firewall-a aldatu ahal baduzu, dominek egiaztapenak funtzionatu egingo du.';
$string['backpackbadgessettings'] = 'Aldatu motxilaren ezarpenak';
$string['backpackbadgessummary'] = '{$a->totalcollections} bildumetako {$a->totalbadges} domina erakusten ari zara.';
$string['backpackcannotsendverification'] = 'Ezin da bidali egiaztapenerako e-maila';
$string['backpackconnected'] = 'Motxila konektatuta dago';
$string['backpackconnection'] = 'Motxilarako konexioa';
$string['backpackconnection_help'] = 'Kanpoko motxila batekin lotzeak gune honetako dominak partekatzeko aukera ematen dizu, baita zure motxilan publikoa den edozein domina-bilduma gune honetako zure profilean erakusteko aukera ere.';
$string['backpackconnectioncancelattempt'] = 'Konektatu beste helbide elektroniko bat erabilita';
$string['backpackconnectionconnect'] = 'Konektatu  motxilara';
$string['backpackconnectionnottested'] = 'Ezin da motxila honetarako konexioa probatu soilik Open Badges v2.0 motxilek onartzen dutelako.';
$string['backpackconnectionok'] = 'Motxilarako konexioa ondo egin da';
$string['backpackconnectionresendemail'] = 'Berriz bidali egiaztapenerako e-maila';
$string['backpackconnectionunexpectedmessage'] = 'Motxilak errorea itzuli du: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Arazoa gertatu da motxilarekin konektatzean. Egiaztatu zure kredentzialak eta saiatu zaitez berriro, mesedez.';
$string['backpackdetails'] = 'Motxilaren ezarpenak';
$string['backpackdisconnected'] = 'Motxila konektatu gabe dago';
$string['backpackemail'] = 'Helbide elektronikoa';
$string['backpackemail_help'] = 'Zure motxilarekin lotutako helbide elektronikoa. Konektatuta zauden bitartean, gune honetan irabazitako dominak helbide elektroniko honekin lotuko dira.';
$string['backpackemailverificationpending'] = 'Egiaztapena falta da';
$string['backpackemailverifyemailbody'] = 'Kaixo:

Zure dominen motxilara konexio berri baten eskaera egin da \'{$a->sitename}\' gunetik zure helbide elektronikoa erabilita.

Zure motxilako konexioa berretsi eta aktibatzeko mesedez hurrengo helbide honetara joan zaitez:

{$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Laguntza behar baduzu, mesedez jarri harremanetan zure guneko kudeatzailearekin:
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Dominen motxilarako helbide elektroniko bidezko egiaztapena';
$string['backpackemailverifypending'] = 'Helbide elektronikoa egiaztatzeko mezua bidali da <strong>{$a}</strong> helbidera. Egin klik bertan agertzen den estekan zure motxilako konexioa aktibatzeko.';
$string['backpackemailverifysuccess'] = 'Eskerrik asko zure helbide elektronikoa egiaztatzeagatik. Orain zure motxilarekin konektatuta zaude.';
$string['backpackemailverifytokenmismatch'] = 'Klik egin duzun estekaren tokena ez dator bat gordetako tokenarekin. Ziurtatu ezazu jasotako azken e-maila mezuko estekan klik egin duzula.';
$string['backpackexporterror'] = 'Domina ezin da motxilara esportatu';
$string['backpackimport'] = 'Domina inportatzeko ezarpenak';
$string['backpackimport_help'] = 'Motxilarako konexio egokia ezarri ondoren, zure motxilako dominak zure dominen orrian eta zure profil-orrian ikusi ahal izango dira.

Atal honetan, zure profilean erakutsi nahi dituzun motxilako domina-bildumak aukera ditzakezu.';
$string['backpackneedsupdate'] = 'Profil honetara lotutako motxila ez dator bat guneko motxilarekin. Motxila deskonektatu eta berriz lotu behar duzu.';
$string['backpackprovider'] = 'Motxila-hornitzailea';
$string['backpacksettings'] = 'Motxilaren ezarpenak';
$string['backpackweburl'] = 'Motxilaren URLa';
$string['badgedetails'] = 'Dominaren xehetasunak';
$string['badgeimage'] = 'Irudia';
$string['badgeimage_help'] = 'Hau da domina hau ematean erabiliko den irudia.

Irudi berria gehitzeko, bilatu eta aukeratu irudia (JPG edo PNG formatuan) eta ondoren egin klik "Gorde aldaketak" botoian. Irudiaren tamaina aldatu egingo da dominaren irudiaren baldintzetara egokitzeko.';
$string['badgeprivacysetting'] = 'Dominen pribatutasun-ezarpenak';
$string['badgeprivacysetting_help'] = 'Irabazten dituzun dominak zure kontuaren profil-orrian erakutsi ahal dira. Ezarpen honek irabazitako azken dominak automatikoki erakusteko aukera ematen dizu.

Zure dominen orrian kontrola ditzakezu banakako dominen pribatutasunaren ezarpenak.';
$string['badgeprivacysetting_str'] = 'Erakutsi automatikoki nire profil-orrian irabazi ditudan dominak.';
$string['badges'] = 'Dominak';
$string['badgesalt'] = 'Eraldaketa jasotzailearen helbide elektronikoa zifratzeko';
$string['badgesalt_desc'] = 'Hash bat erabilita motxila-zerbitzuek dominaren jatorriaren berri izan dezakete horren helbide elektronikoa erakutsi gabe. Ezarpen honek zenbakiak eta hizkiak baino ez ditu erabili behar.

Oharra: jasotzaileak egiaztatzeko, ez aldatu ezarpen hau behin dominak ematen hasita.';
$string['badgesdisabled'] = 'Dominak ez daude gaituta gune honetan';
$string['badgesearned'] = 'Lortutako domina-kopurua: {$a}';
$string['badgesettings'] = 'Dominen ezarpenak';
$string['badgestatus_0'] = 'Ez dago eskuragarri erabiltzaileentzat';
$string['badgestatus_1'] = 'Eskura erabiltzaileentzat';
$string['badgestatus_2'] = 'Ez dago eskuragarri erabiltzaileentzat';
$string['badgestatus_3'] = 'Eskura erabiltzaileentzat';
$string['badgestatus_4'] = 'Artxibatua';
$string['badgestoearn'] = 'Eskura daitekeen domina-kopurua: {$a}';
$string['badgesview'] = 'Ikastaroko dominak';
$string['badgeurl'] = 'Emandako dominarako esteka';
$string['balignment'] = 'Lerrokatzeak ({$a})';
$string['bawards'] = 'Jasotzaileak: ({$a})';
$string['bcriteria'] = 'Irizpidea';
$string['bdetails'] = 'Editatu zehaztasunak';
$string['bendorsement'] = 'Onarpena';
$string['bmessage'] = 'Mezua';
$string['boverview'] = 'Ikuspegi globala';
$string['brelated'] = 'Erlazionatutako dominak: ({$a})';
$string['bydate'] = 'noizko osatua:';
$string['claim'] = 'Erreklamatu';
$string['claimcomment'] = 'Onarpenaren iruzkina';
$string['claimid'] = 'Erreklamatzeko URLa';
$string['clearsettings'] = 'Garbitu ezarpenak';
$string['completioninfo'] = 'Domina hau ondorengo hau osatuta eman zen:';
$string['completionnotenabled'] = 'Ikastaro-osaketa ez dago gaituta ikastaro honetarako eta, beraz, ezin da dominarako irizpideetan erabili. Ikastaroaren ezarpenetan gaitu daiteke ikataro-osaketa.';
$string['configenablebadges'] = 'Gaituz gero, funtzio honek dominak sortu eta guneko erabiltzaileei emateko aukera emango dizu.';
$string['configuremessage'] = 'Dominaren mezua';
$string['connect'] = 'Konektatu';
$string['connected'] = 'Konektatuta';
$string['connecting'] = 'Konektatzen...';
$string['contact'] = 'Kontaktua';
$string['contact_help'] = 'Domina-emailearekin lotutako helbide elektroniko bat';
$string['copyof'] = '{$a}-ren kopia';
$string['coursebadges'] = 'Dominak';
$string['coursebadgesdisabled'] = 'Ikastaroko dominak ez daude gaituta gune honetan.';
$string['coursecompletion'] = 'Erabiltzaileek ikastaro hau osatu behar dute';
$string['create'] = 'Domina berria';
$string['createbutton'] = 'Sortu domina';
$string['creatorbody'] = '<p>{$a->user}(e)k dominarako baldintzak bete ditu eta domina hau lortu du. Ikusi emandako dominak hemen: {$a->link} </p>';
$string['creatorsubject'] = 'Norbaitek \'{$a}\' domina lortu du!';
$string['criteria_0'] = 'Domina hau honela lortzen da:';
$string['criteria_1'] = 'Jarduera-osaketa';
$string['criteria_1_help'] = 'Erabiltzaileei ikastaro batean hainbat jarduera osatu izanagatik domina bat emateko aukera eskaintzen du.';
$string['criteria_2'] = 'Eskuz ematea rolaren arabera';
$string['criteria_2_help'] = 'Erabiltzaileei gunean edo ikastaroan rol jakin bat izateagatik domina bat eskuz emateko aukera eskaintzen du.';
$string['criteria_3'] = 'Partaidetza soziala';
$string['criteria_3_help'] = 'Soziala';
$string['criteria_4'] = 'Ikastaro-osaketa';
$string['criteria_4_help'] = 'Erabiltzaileei ikastaroa osatu izanagatik domina bat emateko aukera eskaintzen du. Bestelako parametroak gehi dakizkioke irizpide honi, besteak beste, gutxieneko kalifikazioa edo ikastaroa bukatzeko data.';
$string['criteria_5'] = 'Ikastaro-multzoa osatzea';
$string['criteria_5_help'] = 'Erabiltzaileei ikastaro-multzo bat osatzeagatik domina bat emateko aukera eskaintzen du. Ikastaro bakoitzak bestelako parametroak izan ditzake, besteak beste, gutxieneko kalifikazioa edo ikastaroa bukatzeko data.';
$string['criteria_6'] = 'Profila osatzea';
$string['criteria_6_help'] = 'Erabiltzaileei norberaren profileko hainbat eremu betetzeagatik domina bat emateko aukera eskaintzen du. Pertsonalizatutako eta lehenetsitako eremuen artean aukera dezakezu.';
$string['criteria_7'] = 'Emandako dominak';
$string['criteria_7_help'] = 'Erabiltzaileei lortutako dominen arabera beste domina bat emateko aukera eskaintzen du.';
$string['criteria_8'] = 'Kohorteko partaidetza';
$string['criteria_8_help'] = 'Erabiltzaileei kohortetako partaidetzan oinarrituta domina bat emateko aukera eskaintzen du.';
$string['criteria_9'] = 'Konpetentziak';
$string['criteria_9_help'] = 'Erabiltzaileek osatutako konpetentzien arabera domina esleitzea ahalbidetzen du.';
$string['criteria_descr'] = 'Ondorengo baldintza betetzen dutenean emango zaie ikasleei domina hau:';
$string['criteria_descr_0'] = 'Erabiltzaileei domina hau zerrendako <strong>{$a}</strong> baldintza betetzean emango zaie.';
$string['criteria_descr_1'] = 'Ondorengo jardueretatik <strong>{$a}</strong> osatu dira:';
$string['criteria_descr_2'] = 'Domina hau ondorengo roletatik <strong>{$a}</strong> dituzten erabiltzaileek eman behar dute:';
$string['criteria_descr_4'] = 'Erabiltzaileek ikastaroa osatu behar dute';
$string['criteria_descr_5'] = 'Ondorengo ikastaroetatik <strong>{$a}</strong> osatu dira:';
$string['criteria_descr_6'] = 'Ondorengo erabiltzailearen profile-eremuetatik <strong>{$a}</strong> bete dira:';
$string['criteria_descr_7'] = 'Hurrengo dominetatik <strong>{$a}</strong> lortu behar dira:';
$string['criteria_descr_8'] = 'Beharrezkoa da hurrengo kohorteetarik <strong>{$a}</strong>etan partaidetza:';
$string['criteria_descr_9'] = 'Hurrengo konpetentzietatik <strong>{$a}</strong> osatu behar dira:';
$string['criteria_descr_bydate'] = '<em>{$a}</em> baino lehenago';
$string['criteria_descr_grade'] = '<em>{$a}</em> gutxieneko kalfikazioarekin';
$string['criteria_descr_short0'] = '<strong>{$a}</strong> osatuta hauetatik:';
$string['criteria_descr_short1'] = '<strong>{$a}</strong> osatuta hauetatik:';
$string['criteria_descr_short2'] = '<strong>{$a}</strong> emanda hauetatik:';
$string['criteria_descr_short4'] = 'Osatu ikastaroa';
$string['criteria_descr_short5'] = '<strong>{$a}</strong> osatuta hauetatik:';
$string['criteria_descr_short6'] = '<strong>{$a}</strong> osatuta hauetatik:';
$string['criteria_descr_short7'] = 'Hurrengoetatik <strong>{$a}</strong> osatu:';
$string['criteria_descr_short8'] = '<strong>{$a}</strong> kohortetan partaidetza hauen artean:';
$string['criteria_descr_short9'] = 'Osatu <strong>{$a}</strong> hurrengoetatik:';
$string['criteria_descr_single_1'] = 'Ondoko jarduera osatu behar da:';
$string['criteria_descr_single_2'] = 'Ondorengo rola duen erabiltzaileak eman behar du domina hau:';
$string['criteria_descr_single_4'] = 'Erabiltzaileek ikastaroa osatu behar dute';
$string['criteria_descr_single_5'] = 'Ondoko ikastaroa osatu behar da:';
$string['criteria_descr_single_6'] = 'Ondorengo erabiltzailearen profil-eremuak bete behar dira:';
$string['criteria_descr_single_7'] = 'Hurrengo domina lortu behar da:';
$string['criteria_descr_single_8'] = 'Derrigorrezkoa da hurrengo kohortean partaidetza:';
$string['criteria_descr_single_9'] = 'Hurrengo konpetentziak osatu behar dira:';
$string['criteria_descr_single_short1'] = 'Osatuta:';
$string['criteria_descr_single_short2'] = 'Nork emana:';
$string['criteria_descr_single_short4'] = 'Osatu ikastaroa';
$string['criteria_descr_single_short5'] = 'Osatuta:';
$string['criteria_descr_single_short6'] = 'Osatuta:';
$string['criteria_descr_single_short7'] = 'Osatu:';
$string['criteria_descr_single_short8'] = 'Partaidetza hemen:';
$string['criteria_descr_single_short9'] = 'Osatu';
$string['criteriacreated'] = 'Dominarako irizpidea modu egokian sortu da';
$string['criteriadeleted'] = 'Dominarako irizpidea modu egokian ezabatu da';
$string['criteriasummary'] = 'Irizpide-multzoa';
$string['criteriaupdated'] = 'Dominarako irizpidea modu egokian eguneratu da';
$string['criterror'] = 'Oraingo parametroekiko arazoak';
$string['criterror_help'] = 'Eremu-multzo honek erakusten du hasiera batean dominarako gehitu ziren baldintza guztiak baina dagoeneko eskuragarri ez daudenak. Gomendagarria da parametro hauek desaktibatzea aurrerantzean ikasleek domina hau eskura dezaketela ziurtatzeko.';
$string['currentimage'] = 'Oraingo irudia:';
$string['currentstatus'] = 'Oraingo egoera:';
$string['dateawarded'] = 'Emate-data';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Egun';
$string['deactivate'] = 'Desgaitu sarbidea';
$string['deactivatesuccess'] = 'Dominetarako sarbidea ondo desgaitu da.';
$string['defaultissuercontact'] = 'Domina-emailearen helbide elektronikoa';
$string['defaultissuercontact_desc'] = 'Domina-emailearekin lotutako helbide elektronikoa. Open Badges v2.0 motxila baten kasuan, eremu hau dominak motxilan publikatzean autentifikazioa egiteko erabiltzen da.';
$string['defaultissuername'] = 'Domina-emailearen izena';
$string['defaultissuername_desc'] = 'Ematen duen erakundearen edo organoaren izena.';
$string['defaultissuerpassword'] = 'Domina-emailearen pasahitza';
$string['defaultissuerpassword_help'] = 'Motxilaren gunean dominaren jasotzailearen helbide elektronikoa bera duen kontu bat izatea behar da Gunearen Kudeaketa / Dominak / Dominen Ezarpenak atalean. Kontuaren pasahitza da hemen sartu beharrekoa.';
$string['delbadge'] = '\'{$a}\' domina eta jada emandako domina guztiak ezabatu nahi dituzu?';
$string['delconfirm'] = 'Ezabatu domina eta kendu emandako guztiak';
$string['delcritconfirm'] = 'Ziur zaude irizpide hau ezabatu egin nahi duzula?';
$string['deletehelp'] = '<p>Domina bat guztiz ezabatzean domina horren xehetasunak eta irizpide guztiak betiko ezabatuak izango dira. Domina hau eskuratu duten erabiltzaileek ez dute domina horretara sarbidea izango euren profilean.</p>
<p>Oharra: Domina hau eskuratu eta euren kanpo-motxilara eraman duten erabiltzaileek domina kanpo-motxilan mantenduko dute. Dena den, ez dute gune honetako irizpide eta ebidentzia-orrietara sarbiderik izango</p>';
$string['delexternalbackpack'] = 'Ezabatu guneko motxila';
$string['delexternalbackpackconfirm'] = 'Ezabatu guneko \'{$a}\' motxila?';
$string['delparamconfirm'] = 'Ziur zaude parametro hau ezabatu nahi duzula?';
$string['description'] = 'Deskribapena';
$string['disconnect'] = 'Deskonektatu';
$string['donotaward'] = 'Une honetan domina hau ez dago aktibatuta eta beraz, ezin zaie erabiltzaileei eman. Domina hau eman nahi baduzu, aktiba ezazu.';
$string['editsettings'] = 'Editatu ezarpenak';
$string['enablebadges'] = 'Gaitu dominak';
$string['endorsement'] = 'Onarpena';
$string['error:backpackdatainvalid'] = 'Motxilak itzulitako datuak ez dira egokiak.';
$string['error:backpackemailnotfound'] = '\'{$a}\' helbide elektronikoa ez dago inongo motxilarekin lotuta. <a href="http://backpack.openbadges.org"> motxila bat sortu behar duzu</a> kontu horretarako edo saioa beste helbide elektroniko batekin hasi.';
$string['error:backpacknotavailable'] = 'Zure gunea ez dago internet bidez eskuragarri eta, beraz, gune honetan emandako edozein domina kanpoko motxila-zerbitzuek ezin izango dute egiaztatu.';
$string['error:backpackproblem'] = 'Arazo bat dago zure motxila-zerbitzu hornitzailearekin konektatzeko. Mesedez, saiatu berriz geroxeago.';
$string['error:badgeawardnotfound'] = 'Ezin da emandako domina hau egiaztatu. Baliteke domina hau kendu izana.';
$string['error:badgenotfound'] = 'Domina ez da aurkitu';
$string['error:cannotact'] = 'Ezin da domina aktibatu.';
$string['error:cannotawardbadge'] = 'Ezin zaio domina erabiltzaile bati eman.';
$string['error:cannotdeletecriterion'] = 'Irizpide hau ezin da ezabatu.';
$string['error:cannotrevokebadge'] = 'Ezin zaio erabiltzaile bati domina bat kendu';
$string['error:clone'] = 'Ezin da domina klonatu.';
$string['error:connectionunknownreason'] = 'Konexioa ez da modu egokian burutu, baina arrazoia ez dakigu.';
$string['error:duplicatename'] = 'Badago aldez aurretik izen hori duen domina sisteman.';
$string['error:externalbadgedoesntexist'] = 'Ez da domina aurkitu.';
$string['error:guestuseraccess'] = 'Bisitari gisa sartu zara. Dominak ikusteko erabiltzaile-kontua erabilita sartu behar duzu.';
$string['error:invalidcriteriatype'] = 'Irizpide mota desegokia';
$string['error:invalidexpiredate'] = 'Iraungitze-datak etorkizunekoa izan behar du.';
$string['error:invalidexpireperiod'] = 'Iraungitze data ezin da negatiboa edo 0 izan.';
$string['error:invalidparambadge'] = 'Domina ez da existitzen.';
$string['error:invalidparamcohort'] = 'Ez da kohortea existitzen.';
$string['error:noactivities'] = 'Ikastaro honetan ez dago osaketa-irizpideak gaituta dituen jarduerarik.';
$string['error:nobadges'] = 'Ez dago irizpide gisa gehitzeko sarbidea gaituta duen dominarik. Guneko domina batek soilik guneko beste dominak izan ditzake irizpide gisa. Ikastaroko domina batek ikastaroko beste dominak zein guneko dominak izan ditzake irizpide gisa.';
$string['error:nocohorts'] = 'Ez dago kohorterik';
$string['error:nocourses'] = 'Ikastaro-osaketa ez dago gaituta gune honetako inongo ikastarotan, beraz ezin da bat ere erakutsi. Ikastaro-osaketa gaitu egin behar da ikastaroaren ezarpenetan.';
$string['error:nogroupslink'] = '<p>Bilduma publikoak baino ez dira erakusten. Bilduma publikoren bat sortzeko <a href="{$a}" target="_blank" rel="nofollow">joan zaitez zure motxilara</a>.</p>';
$string['error:nogroupssummary'] = '<p>Ez dago dominen bilduma publikorik eskuragarri zure motxilan.</p>';
$string['error:nopermissiontoview'] = 'Ez duzu baimenik domina-jasotzaileak ikusteko';
$string['error:nosuchbadge'] = 'Ez dago {$a} id-a duen dominarik.';
$string['error:nosuchcohort'] = 'Kontuz! Kohorte hau jada ez da eskuragarri.';
$string['error:nosuchcourse'] = 'Kontuz: ikastaro hau ez dago eskuragarri.';
$string['error:nosuchfield'] = 'Kontuz: erabiltzailearen profil-eremu hau ez dago eskuragarri.';
$string['error:nosuchmod'] = 'Kontuz: jarduera hau ez dago eskuragarri.';
$string['error:nosuchrole'] = 'Kontuz: rol hau ez dago eskuragarri.';
$string['error:nosuchuser'] = 'Helbide elektroniko hau duen erabiltzaileak ez du oraingo motxila-hornitzailearekin konturik.';
$string['error:notifycoursedate'] = 'Kontuz: Ikastaro-osaketa eta jarduera-osaketarekin lotutako dominak ez dira ikastaroa hasi arte emango.';
$string['error:parameter'] = 'Kontuz: gutxinez parametro bat aukeratu behar da domina emateko lan-ildoa ziurtatzeko.';
$string['error:relatedbadgedoesntexist'] = 'Ez dago domina publikorik Identifikatzaile hau duenik.';
$string['error:requesterror'] = 'Konexio-eskariak huts egin du (errore-kodea {$a}).';
$string['error:requesttimeout'] = 'Konexio-eskaera tartea agortu egin da konexio burutu baino lehen.';
$string['error:save'] = 'Ezin da domina gorde.';
$string['error:userdeleted'] = '{$a->user} (Erabiltzaile hau ez dago dagoeneko {$a->site} -n)';
$string['eventbadgearchived'] = 'Domina artxibatu da';
$string['eventbadgeawarded'] = 'Domina eman da';
$string['eventbadgecreated'] = 'Domina sortu da';
$string['eventbadgecriteriacreated'] = 'Dominarako irizpidea sortu da';
$string['eventbadgecriteriadeleted'] = 'Dominarako irizpidea ezabatu da';
$string['eventbadgecriteriaupdated'] = 'Dominarako irizpidea eguneratu da';
$string['eventbadgedeleted'] = 'Domina ezabatu da';
$string['eventbadgedisabled'] = 'Domina desgaitu da';
$string['eventbadgeduplicated'] = 'Domina bikoiztu da';
$string['eventbadgeenabled'] = 'Domina gaitu da';
$string['eventbadgelistingviewed'] = 'Dominen zerrenda ikusi da';
$string['eventbadgerevoked'] = 'Domina kendu da';
$string['eventbadgeupdated'] = 'Domina eguneratu da';
$string['eventbadgeviewed'] = 'Domina ikusi da';
$string['evidence'] = 'Ebidentzia';
$string['existingrecipients'] = 'Existitzen diren domina-jasotzaileak';
$string['existsinbackpack'] = 'Domina dagoeneko motxilan dago';
$string['expired'] = 'Iraungita';
$string['expiredate'] = 'Domina {$a}-n iraungitzen da.';
$string['expireddate'] = 'Domina {$a}-n iraungitzen da.';
$string['expireperiod'] = 'Domina, eman eta  {$a} egunetara iraungitzen da.';
$string['expireperiodh'] = 'Domina, eman eta  {$a} ordutara iraungitzen da.';
$string['expireperiodm'] = 'Domina, eman eta  {$a} minututara iraungitzen da.';
$string['expireperiods'] = 'Domina, eman eta  {$a} segundotara iraungitzen da.';
$string['expirydate'] = 'Epemugaren data';
$string['expirydate_help'] = 'Aukeran, dominak data jakin batean iraungi daitezke, edo erabiltzaileari eman zitzaioneko dataren arabera kalkulatu daiteke.';
$string['externalbadges'] = 'Nire dominak beste web-gune batzuetan';
$string['externalbadges_help'] = 'Eremu honetan kanpoko motxilako dominak erakusten dira.';
$string['externalbadgesp'] = 'Beste web-gune batzuetako dominak:';
$string['externalconnectto'] = 'Kanpoko dominak erakusteko <a href="{$a}"> motxila batekin konektatu behar duzu</a>';
$string['fixed'] = 'Data zehatza';
$string['hidden'] = 'Ezkutuan';
$string['hiddenbadge'] = 'Tamalez, dominaren jabeak ez du informazio hau argitaratu.';
$string['imageauthoremail'] = 'Irudiaren egilearen helbide elektronikoa';
$string['imageauthoremail_help'] = 'Zehaztuz gero, irudiaren egilearen helbide elektronikoa dominaren orrian erakutsiko da.';
$string['imageauthorname'] = 'Irudiaren egilearen izena';
$string['imageauthorname_help'] = 'Zehaztuz gero, dominaren irudia egin duen egilearen izena dominaren orrian erakutsiko da.';
$string['imageauthorurl'] = 'Irudiaren egilearen URLa';
$string['imageauthorurl_help'] = 'Zehaztu gero,  irudia egin duen egilearen web-gunerako esteka dominaren orrian erakutsiko da. URLak http:// edo https:// motako aurrizkia izan behar luke.';
$string['imagecaption'] = 'Irudi-argazkia';
$string['imagecaption_help'] = 'Zehaztuz gero, irudi-argazkia dominaren orrian erakutsiko da.';
$string['includeauthdetails'] = 'Sartu autentifikazio-xehetasunak motxilarekin batera';
$string['invalidurl'] = 'URL baliogabea';
$string['issuancedetails'] = 'Dominaren iraungitzea';
$string['issuedbadge'] = 'Emandako dominaren informazioa';
$string['issuerdetails'] = 'Emailearen xehetasunak';
$string['issueremail'] = 'Helbide elektronikoa';
$string['issueremail_help'] = 'Onarpena ematen duen erakundearekin harremanetan jartzeko helbide elektronikoa.';
$string['issuername'] = 'Emailearen izena';
$string['issuername_endorsement'] = 'Onartzailearen izena';
$string['issuername_endorsement_help'] = 'Onartzailearen izena';
$string['issuername_help'] = 'Ematen duen erakundearen edo organoaren izena.';
$string['issuerurl'] = 'Emailearen URLa';
$string['issuerurl_help'] = 'Onarpena ematen duen erakundearen web-gunea. URLak http:// edo https:// motako aurrizkia izan behar luke.';
$string['language'] = 'Hizkuntza';
$string['language_help'] = 'Dominaren orrian erabiltako hizkuntza';
$string['listbackpacks'] = 'Motxilen zerrenda';
$string['localbadges'] = 'Nire dominak {$a} web-gunean';
$string['localbadgesh'] = 'Nire dominak web-gune honetan';
$string['localbadgesh_help'] = 'Ikastaroak edo ikastaroetako jarduerak bukatzeagatik edota beste baldintza batzuk betetzeagatik web-gune honetan lortutako domina guztiak.

Hemen kude ditzakezu zure dominak zure profil-orrian publiko edo pribatu eginez.

Zure domina guztiak batera edo banaka deskarga ditzakegu eta zure ordenagailuan gorde. Deskargatutako dominak zure kanpoko motxila-zerbitzura gehi daitezke.';
$string['localbadgesp'] = 'Hemengo dominak: {$a}:';
$string['localconnectto'] = 'Domina hauek web-gune honetatik kanpo konpartitzeko <a href="{$a}">motxila batera konektatu behar duzu</a>.';
$string['makeprivate'] = 'Egin pribatu';
$string['makepublic'] = 'Egin publiko';
$string['managebackpacks'] = 'Kudeatu motxilak';
$string['managebadges'] = 'Kudeatu dominak';
$string['message'] = 'Mezuaren edukia';
$string['messagebody'] = '<p>"%badgename%" domina lortu duzu!</p>
<p>Domina honi buruzko informazio gehiago %badgelink% dominaren informazio orrian topatu dezakezu.</p>
<p>Domina {$a}-tik deskarga eta kudeatu dezakezu.</p>';
$string['messagesubject'] = 'Zorionak! Domina bat irabazi duzu!';
$string['method'] = 'Irizpidea honela beteko da:';
$string['mingrade'] = 'Eskatutako gutxieneko kalifikazioa';
$string['month'] = 'Hilabete';
$string['mybackpack'] = 'Nire motxilaren ezarpenak';
$string['mybadges'] = 'Nire dominak';
$string['never'] = 'Inoiz ez';
$string['newbackpack'] = 'Gehitu motxila berri bat';
$string['newbadge'] = 'Gehitu domina berria';
$string['newimage'] = 'Irudi berria';
$string['noalignment'] = 'Dominak ez du kanpoko trebetasun edo estandarrik ezarrita.';
$string['noawards'] = 'Domina hau ez da oraindik irabazi.';
$string['nobackpack'] = 'Ez dago kontu honekin lotutako motxila-zerbitzurik.<br/>';
$string['nobackpackbadgessummary'] = 'Ez dago dominarik aukeratu duzun bilduman.';
$string['nobackpackcollectionssummary'] = 'Ez dago bildumarik aukeratuta.';
$string['nobackpacks'] = 'Ez dago motxilarik eskuragarri';
$string['nobadges'] = 'Ez dago dominarik eskuragarri.';
$string['nocompetencies'] = 'Ez da konpetentziarik aukeratu.';
$string['nocriteria'] = 'Oraindik ez da ezarri domina honetarako irizpiderik.';
$string['noendorsement'] = 'Dominak ez du onarpenik.';
$string['noexpiry'] = 'Domina honek ez du iragungitze-datarik.';
$string['noparamstoadd'] = 'Ez dago bestelako parametrorik dominaren baldintzetara gehitzeko.';
$string['norelated'] = 'Dominak ez du erlazionatutako beste dominarik.';
$string['notacceptedrole'] = 'Une honetan esleituta duzun rola ez da eskuz domina hau eman dezakeenetako bat.<br/>
Dagoeneko domina hau irabazi duten erabiltzaileak ikusi nahi badituzu, joan orri honetara {$a}';
$string['notconnected'] = 'Konektatu gabe';
$string['notealignment'] = 'Dominak jasotzen dituen kanpoko trebetasunak edo estandarrak zehaztu ahal dira. Edozein konpetentzia dominaren orrian erakutsiko da.';
$string['noteendorsement'] = 'Hirugarren batek dominari onarpena ematea balia daiteke dominaren balioa handitzeko. Adibidez, irakasle batek emandako domina eskolak onar dezake, edo tokian tokiko erakundearen domina goragoko erakunde nazionalak onar dezake.';
$string['noterelated'] = 'Konexia duten dominak erlazionatutakotzat joko dira. Adibidez, irizpide bera duten eta hizkuntza ezberdinetan erakusten diren dominak erlazionatutakotzat jo daitezke. Edozein domina dominen orrian erakutsiko da.';
$string['nothingtoadd'] = 'Ez dago gehitzeko bestelako irizpiderik.';
$string['notification'] = 'Jakinarazi dominaren sortzaileari';
$string['notification_help'] = 'Ezarpen honek kudeatzen ditu domina bat eman dela jakinarazteko domina-sortzaileari bidalitako jakinarazpenak.

Ondoren aukerak erabili ahal dira:

* **INOIZ EZ** – Ez bidali jakinarazpenik.

* **ALDIORO** – Bidali jakinarazpena domina ematen den bakoitzean.

* **EGUNERO** – Bidali jakinarazpena egunean behin.

* **ASTERO** – Bidali jakinarazpena astean behin.

* **HILERO** – Bidali jakinarazpena hilean behin.';
$string['notifydaily'] = 'Egunero';
$string['notifyevery'] = 'Bakoitzean';
$string['notifymonthly'] = 'Hilabetero';
$string['notifyweekly'] = 'Astero';
$string['numawards'] = 'Domina hau <a href="{$a->link}">{$a->count}</a> erabiltzaileri eman zaie.';
$string['numawardstat'] = 'Domina hau {$a} erabiltzaileri eman zaie.';
$string['oauth2issuer'] = 'OAuth 2 zerbitzuak';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['overallcrit'] = 'aukeratutako irizpideetatik bete da.';
$string['potentialrecipients'] = 'Balizko domina-jasotzaileak';
$string['preferences'] = 'Dominen aukerak';
$string['privacy:metadata:backpack'] = 'Erabiltzailearen motxilen erregistroa';
$string['privacy:metadata:backpack:backpackuid'] = 'Motxilaren identifikatzaile-bakarra';
$string['privacy:metadata:backpack:email'] = 'Motxilarekin lotutako helbide elektronikoa';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Motxilaren IDa';
$string['privacy:metadata:backpack:userid'] = 'Motxilaren jabea den erabiltzailearen IDa';
$string['privacy:metadata:backpackoauth2'] = 'Erabiltzaile batek kanpoko motxila bat konektatzen dueneko OAuth 2 informazioa';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 zerbitzuaren IDa';
$string['privacy:metadata:backpackoauth2:scope'] = 'Motxila-konexioaren esparru-zerrenda';
$string['privacy:metadata:backpackoauth2:token'] = 'Motxila-konexioaren tokena';
$string['privacy:metadata:backpackoauth2:userid'] = 'Motxila-konexioa egin duen erabiltzailearen IDa';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Konexioa aldatu duen erabiltzailearen IDa';
$string['privacy:metadata:badge'] = 'Dominen bilduma bat';
$string['privacy:metadata:badge:timecreated'] = 'Domina sortu zeneko unea';
$string['privacy:metadata:badge:timemodified'] = 'Domina azkenengoz aldatu zeneko unea';
$string['privacy:metadata:badge:usercreated'] = 'Domina sortu zuenerabiltzailearen IDa';
$string['privacy:metadata:badge:usermodified'] = 'Domina aldatu zuen erabiltzailearen IDa';
$string['privacy:metadata:criteriamet'] = 'Bete diren irizpideen bilduma bat';
$string['privacy:metadata:criteriamet:datemet'] = 'Irizpidea bete zeneko data';
$string['privacy:metadata:criteriamet:userid'] = 'Irizpidea bete duen erabiltzailearen IDa';
$string['privacy:metadata:external:backpacks'] = 'Erabiltzaileek euren dominak kanpoko motxiletara bidaltzean partekatzen den informazioa';
$string['privacy:metadata:external:backpacks:badge'] = 'Dominaren izena';
$string['privacy:metadata:external:backpacks:description'] = 'Dominaren deskribapena';
$string['privacy:metadata:external:backpacks:image'] = 'Dominaren irudia';
$string['privacy:metadata:external:backpacks:issuer'] = 'Emailearen inguruko informazioa';
$string['privacy:metadata:external:backpacks:url'] = 'Dominaren informazioa ikusgarri dagoen Moodleko URLa';
$string['privacy:metadata:issued'] = 'Emandako dominen erregistroa';
$string['privacy:metadata:issued:dateexpire'] = 'Domina-ematea iraungitzen deneko data';
$string['privacy:metadata:issued:dateissued'] = 'Domina-ematearen data';
$string['privacy:metadata:issued:userid'] = 'Domina jaso zuen erabiltzailearen IDa';
$string['privacy:metadata:manualaward'] = 'Eskuz emandako dominen erregistroa';
$string['privacy:metadata:manualaward:datemet'] = 'Erabiltzaileari domina eskuz eman zitzaioneko data';
$string['privacy:metadata:manualaward:issuerid'] = 'Domina eman zuen erabiltzailearen IDa';
$string['privacy:metadata:manualaward:issuerrole'] = 'Domina eman zuen erabiltzailearen rola';
$string['privacy:metadata:manualaward:recipientid'] = 'Eskuz emandako domina jaso duen erabiltzailearen IDa';
$string['recipientdetails'] = 'Jasotzailearen zehaztasunak';
$string['recipientidentificationproblem'] = 'Ezin da domina honetarako jasotzailerik aurkitu dauden erabiltzaileen artean.';
$string['recipients'] = 'Domina-jasotzaileak';
$string['recipientvalidationproblem'] = 'Une honetako erabiltzailea ezin da egiaztatu domina honen jasotzaile gisa.';
$string['relatedbages'] = 'Erlazionatutako dominak';
$string['relative'] = 'Data erlatiboa';
$string['requiredbadge'] = 'Gutxienez domina bat gehitu behar da dominen irizpidera.';
$string['requiredcohort'] = 'Gutxienez kohorte bat gehitu behar da kohorteen irizpideetan.';
$string['requiredcompetency'] = 'Konpetentzia-irizpideari gutxienez konpetentzia bat gehitu behar zaio.';
$string['requiredcourse'] = 'Gutxienez ikastaro bat gehitu behar da ikastaro-irizpide multzora.';
$string['reviewbadge'] = 'Dominarako sarbiderako aldaketak';
$string['reviewconfirm'] = '<p> hau eginda, erabiltzaileek zure domina ikusi ahal izango dute eta irabazten hasteko moduan izango dira.</p>

<p> Zenbait erabiltzailek dagoeneko beteta izango dituzte, agian, domina irabazteko irizpideak eta aktibatu orduko eman egingo zaie. </p>

<p> Domina lehenengoz eman orduko <strong>blokeatu</strong> egingo da - hainbat ezarpen, irizpideak eta iraungitze ezarpenak barne, ezin izango dira aldatu. </p>

<p> Ziur zaude \'{$a}\' dominarako sarbidea baimendu nahi duzula? </p>';
$string['revoke'] = 'Kendu domina';
$string['save'] = 'Gorde';
$string['searchname'] = 'BIlatu izenaren arabera';
$string['selectaward'] = 'Mesedez, aukeratu zein rol erabili nahi duzun domina hau emateko:';
$string['selectgroup_end'] = 'Bilduma publikoak baino ez dira erakusten. <a href="{$a}">Bisitatu ezazu zure motxila</a> bilduma publiko gehiago sortzeko.';
$string['selectgroup_start'] = 'Aukeratu gune honetan erakutsiko diren motxilako bildumak:';
$string['selecting'] = 'Aukeratutako dominekin...';
$string['setup'] = 'Konfiguratu konexioa';
$string['sitebackpack'] = 'Kanpoko motxila aktiboak';
$string['sitebackpack_help'] = 'Erabiltzaileek gune honetatik konektatu dezaketen kanpoko motxila. Kontuan izan ezarpen hau aldatuz gero bere motxilekin lotura eginda duten erabiltzaileek euren motxilen ezarpenen orrira joan eta motxila deskonektatu eta berriz lotu beharko dute.';
$string['sitebackpackdeleted'] = 'Guneko motxila ezabatua izan da.';
$string['sitebackpacknotdeleted'] = 'Motxila hau ezin da ezabatu une honetan gunean lehenetsitakoa delako.';
$string['sitebackpackverify'] = 'Motxilaren konexioa';
$string['sitebackpackwarning'] = 'Ezin izan da motxilarekin konektatu. <br/><br/>Egiaztatu ezazu "Domina-emailearen helbide elektronikoa" ezarpenak motxilaren webguneko kontuarentzako baliozko helbide elektronikoa duela.<br/><br/>Egiaztatu ezazu <a href="{$a->url}">guneko motxilaren ezarpenen orriko</a> "Domina-emailearen pasahitza" webguneko motxilaren kontuaren pasahitz zuzena dela.<br/><br/>Motxilak hurrengoa itzuli du: "{$a->warning}"';
$string['sitebadges'] = 'Guneko dominak';
$string['sitebadges_help'] = 'Guneko dominak soilik gunearekin lotutako jarduerak egin dituzten erabiltzaileei eman ahal zaizkie. Jarduera horien artean daude hainbat ikastaro osatzea edo erabiltzaile-profileko hainbat eremu betetzea. Guneko dominak eskuz ere eman ahal dizkio erabiltzaile batek beste bati.

Ikastaroekin lotutako jardueretarako dominak ikastaro testuinguruan sortu behar dira. Hemen aurki daitezke ikastaroko dominak: Kudeaketa >  Dominak';
$string['status'] = 'Dominen egoera';
$string['status_help'] = 'Domina baten egoerak zehazten du horren jokaera sisteman:

* ** ERABILGARRI ** - Erabiltzaileek domina irabaz dezaketela adierazten du. Domina erabilgarri dagoen bitartean ezin da horren irizpiderik aldatu.

* ** EZ ERABILGARRI ** - Domina hau ez dago erabiltzaileen eskra eta beraz ezin dute irabazi eta ezin da eskuz eman. Domina hori behin ere eman ez bada, irizpideak alda daitezke.

Domina bat gutxienez behin eman bada, automatikoki pasako da **BLOKEATUTA** egoerara. Erabiltzaileek lor ditzakete blokeatutako dominak baina horien irizpideak ezin dira aldatu. Blokeatutako domina baten zehaztasunak edo irizpideak aldatu behar badituzu, bikoiztu egin dezakezu domina eta beha diren aldaketa guztiak egin.

* Zertarako blokeatzen ditugu dominak? *

Domina bat irabazteko erabiltzaile guztiek baldintza berberak dituztela ziurtatzeko. Une honetan ezin da dominarik kendu. Dominen baldintzak edonoiz aldatzen uzten badugu, oso litekeena da azkenean domina bera duten erabiltzaileek baldintza erabat ezberdinak beteta lortu izana.';
$string['statusmessage_0'] = 'Domina hau ez dago une honetan erabiltzaileek erabiltzeko moduan. Gaitu sarbidea erabiltzaileek domina hau irabazi ahal izatea nahi baduzu.';
$string['statusmessage_1'] = 'Domina hau une honetan erabiltzaileek erabiltzeko moduan dago. Desgaitu sarbidea edozein aldaketa egiteko.';
$string['statusmessage_2'] = 'Domina hau ez dago une hontan erabiltzaileek erabiltzeko moduan eta irizpideak blokeatuta daude. Gaitu sarbidea erabiltzaileek domina hau irabazi ahal izatea nahi baduzu.';
$string['statusmessage_3'] = 'Domina hau une honetan erabiltzaileek erabiltzeko moduan dago eta irizpideak blokeatuta daude.';
$string['statusmessage_4'] = 'Domina hau une honetan artxibatuta dago.';
$string['subject'] = 'Mezuaren gaia';
$string['targetcode'] = 'Kodea';
$string['targetcode_help'] = 'Kate-identifikatzaile bakarra kanpoko trebetasun edo estandarra bere markoaren barruan kokatzeko.';
$string['targetdescription'] = 'Deskribapena';
$string['targetdescription_help'] = 'Kanpoko trebetasun edo estandarraren deskribapen laburra.';
$string['targetframework'] = 'Markoa';
$string['targetframework_help'] = 'Kanpoko trebetasun edo estandarraren markoaren izena.';
$string['targetname'] = 'Izena';
$string['targetname_help'] = 'Domina lotuta dagoen kanpoko trebetasun edo estandarra.';
$string['targeturl'] = 'URLa';
$string['targeturl_help'] = 'Esteka trebetasuna edo estandarra deskribatzen duen orrira.  URLak http:// edo https:// motako aurrizkia izan behar luke.';
$string['testbackpack'] = 'Probatu \'{$a}\' motxila';
$string['testsettings'] = 'Probarako ezarpenak';
$string['type'] = 'Mota';
$string['variablesubstitution'] = 'Aldagaien aldaketa mezuetan.';
$string['variablesubstitution_help'] = 'Domina-mezu batean, hainbat aldagai txerta daitezke gaian edota mezuan eta hartara benetako balioekin aldatu mezua bidaltzean. Aldagaiak ondoren adierazten den bezala txertatu behar dira testuan. Hurrengo aldagaiak erabili daitezke:

%badgename%
: honen ordez dominaren izen osoa agertuko da.

%username%
: jasotzailearen izen osoa agertuko da honen ordez.

%badgelink%
: emandako dominaren inguruko informazioa duen URL publikoa agertuko da honen ordez.';
$string['version'] = 'Bertsioa';
$string['version_help'] = 'Bertsioaren eremua dominaren garapenaren erregistroa eramateko erabil daiteke. Zehaztuz gero, bertsioa dominaren orrian erakutsiko da.';
$string['viewbadge'] = 'Ikusi emandako domina';
$string['visible'] = 'Ikusgai';
$string['warnexpired'] = '(Domina hau iraungita dago!)';
$string['year'] = 'Urte';
