<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'es', version '3.10'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Error cargando entradas del blog.';
$string['addon.blog.showonlyyourentries'] = 'Mostrar sólo sus entradas del blog.';
$string['addon.calendar.calendarevent'] = 'Evento de calendario';
$string['addon.calendar.calendarevents'] = 'Eventos de calendario';
$string['addon.calendar.calendarreminders'] = 'Recordatorios del calendario';
$string['addon.calendar.currentmonth'] = 'Mes actual';
$string['addon.calendar.defaultnotificationtime'] = 'Hora de notificación por defecto';
$string['addon.calendar.errorloadevent'] = 'Error cargando el evento.';
$string['addon.calendar.errorloadevents'] = 'Error cargando los eventos.';
$string['addon.calendar.noevents'] = 'No hay eventos';
$string['addon.calendar.reminders'] = 'Recordatorios';
$string['addon.calendar.setnewreminder'] = 'Crear un nuevo recordatorio';
$string['addon.competency.errornocompetenciesfound'] = 'No se encontraron competencias';
$string['addon.competency.nocompetencies'] = 'Sin competencias';
$string['addon.coursecompletion.complete'] = 'Completado';
$string['addon.coursecompletion.couldnotloadreport'] = 'No se puede cargar el informe de finalización del curso, por favor inténtalo de nuevo más tarde.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messages.contactlistempty'] = 'Lista de contactos vacía';
$string['addon.messages.contactname'] = 'Nombre del contacto';
$string['addon.messages.deletemessage'] = 'Eliminar mensaje';
$string['addon.messages.deletemessageconfirmation'] = '¿Está seguro que quiere eliminar este mensaje? Será eliminado solamente de su historial de mensaje y todavía será visible por el usuario que envió o recibió el mensaje.';
$string['addon.messages.errordeletemessage'] = 'Error borrando el mensaje.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Error al recuperar los contactos del servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Error al recuperar las discusiones del servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Error al recuperar usuarios del servidor.';
$string['addon.messages.messagenotsent'] = 'El mensaje no fue enviado; por favor inténtelo nuevamente después.';
$string['addon.messages.newmessages'] = 'Nuevos mensajes';
$string['addon.messages.nousersfound'] = 'No se encuentran usuarios';
$string['addon.messages.showdeletemessages'] = 'Mostrar mensajes borrados';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Desconectado';
$string['addon.messages.type_online'] = 'En línea';
$string['addon.messages.type_search'] = 'Resultados de la búsqueda';
$string['addon.messages.type_strangers'] = 'Otros';
$string['addon.messages.useentertosenddescdesktop'] = 'Si deshabilitado: puede usar Ctrl+Entrar para enviar el mensaje';
$string['addon.messages.useentertosenddescmac'] = 'Si deshabilitado: puede usar Cmd+Entrar para enviar el mensaje';
$string['addon.messages.warningconversationmessagenotsent'] = 'No se pudo enviar mensaje(s) a conversación {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'No se pudo enviar mensaje(s) al usuario {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor acepte las condiciones de envío.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'No puede añadir o editar un envío en la app porque no pudimos recuperar las condiciones de envío del sitio.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Algunos métodos de calificación no son compatibles aún con la aplicación y no se pueden modificar.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'No puede enviar para calificar en la app porque no pudimos recuperar las condiciones de envío del sitio.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'No puede añadir o editar un envío en la app porque algunos plugins no tienen soporte para editar:';
$string['addon.mod_assign.errorshowinginformation'] = 'No se puede mostrar la información del envío';
$string['addon.mod_assign.feedbacknotsupported'] = 'La retroalimentación no está soportada por la app y podría no mostrar la información completa';
$string['addon.mod_assign.gradenotsynced'] = 'Calificación no sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Los participantes sin envíos no se muestran';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Hay {{count}} borradores.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Hay {{count}} participantes.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Hay {{count}} envíos pendientes de calificación.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Hay {{count}} tareas enviadas.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Hay {{count}} equipos.';
$string['addon.mod_assign.submissionnotsupported'] = 'Este envío no está soportada por la app y es posible que no muestre la información completa';
$string['addon.mod_assign.syncblockedusercomponent'] = 'Calificación de usuario';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La calificación del envío se modificó en el sitio.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'El envío del usuario fue modificado en el sitio.';
$string['addon.mod_chat.confirmloss'] = '¿Está seguro? El histórico del chat se puede perder.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Se ha producido un error conectando al chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Se ha producido un error recuperando los datos del chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Se ha producido un error recuperando los usuarios del chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Se ha producido un error al enviar el mensaje.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Usted debe de estar conectado a Internet para enviar mensajes';
$string['addon.mod_chat.nosessionsfound'] = 'No se han encontrado sesiones';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sesiones incompletas';
$string['addon.mod_choice.errorgetchoice'] = 'Se ha producido un error recuperando los datos de la consulta.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% de los usuarios han escogido la opción: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Los resultados no incluyen su última respuesta. Por favor, sincronícelos para actualizarlos.';
$string['addon.mod_data.edittagsnotsupported'] = 'Lo sentimos, la edición de etiquetas no está soportada por la app.';
$string['addon.mod_data.errorapproving'] = 'Error al aprobar o desaprobar una entrada.';
$string['addon.mod_data.errordeleting'] = 'Error al eliminar entrada.';
$string['addon.mod_data.gettinglocation'] = 'Obteniendo localización';
$string['addon.mod_data.locationnotenabled'] = 'La localización no está habilitada';
$string['addon.mod_data.locationpermissiondenied'] = 'No se ha podido obtener permiso para acceder a su localización.';
$string['addon.mod_data.mylocation'] = 'Mi localización';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Lo sentimos, la búsqueda por etiquetas no está soportada por la app.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'La retroalimentación con captcha no puede ser completada si no está configurada, si está en modo fuera-de-línea o con el servidor caído.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Hay {{count}} respuestas enviadas.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Esta retroalimentación ha sido guardada para enviarse más tarde.';
$string['addon.mod_feedback.questionscountdescription'] = 'Hay {{count}} preguntas.';
$string['addon.mod_folder.emptyfilelist'] = 'No hay archivos que mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Error al obtener datos del foro.';
$string['addon.mod_forum.errorgetgroups'] = 'Error al obtener los datos del grupo.';
$string['addon.mod_forum.errorposttoallgroups'] = 'No se puede crear un nueva discusión en todos los grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'No existen temas de discusión en este foro';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discusiones';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respuestas';
$string['addon.mod_forum.refreshdiscussions'] = 'Actualizar foro';
$string['addon.mod_forum.refreshposts'] = 'Actualizar publicaciones del foro';
$string['addon.mod_glossary.browsemode'] = 'Navegar por las entradas';
$string['addon.mod_glossary.byalphabet'] = 'Alfabéticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupado por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoría';
$string['addon.mod_glossary.bynewestfirst'] = 'El más reciente primero';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Actualizado recientemente';
$string['addon.mod_glossary.bysearch'] = 'Buscar';
$string['addon.mod_glossary.cannoteditentry'] = 'No se puede editar la entrada';
$string['addon.mod_glossary.entriestobesynced'] = 'Entradas pendientes de ser sincronizadas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Esta entrada está pendiente de aprobación.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ha ocurrido un error cargando las entradas.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ha ocurrido un error cargando la entrada.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ha ocurrido un error cargando el glosario.';
$string['addon.mod_glossary.noentriesfound'] = 'No se han encontrado entradas.';
$string['addon.mod_glossary.searchquery'] = 'Tú búsqueda';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descargar archivo H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Error al obtener información de la actividad H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'El paquete H5P no está descargado. Necesita descargarlo para poder usarlo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'El paquete H5P ha sido modificado desde la última vez que lo descargó. Necesita descargarlo de nuevo para poder acceder.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Necesita estar conectado para ver el paquete H5P';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ver intento {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descripción';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lección contiene un salto hacia una página aleatoria de contenido. No puede ser intentada en la aplicación hasta que haya sido comenzada en un navegador web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Este intento no puede ser revisado ya que se ha terminado otro intento.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Este intento se ha terminado en fuera-de-línea.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Un intento fuera-de-línea fue sincronizado. ¿Quiere usted revisarlo?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Este intento se terminó en el sitio.';
$string['addon.mod_lti.errorgetlti'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'La dirección URL no es válida.';
$string['addon.mod_lti.launchactivity'] = 'Ejecutar la actividad';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Error al cargar el contenido de la página.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Puede tomar este cuestionario desde la aplicación, pero debe enviar la respuesta final utilizando el navegador por las razones siguientes:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Este intento de cuestionario no puede enviarse por las siguientes razones:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Este intento no se ha sincronizado desde {{$a}}. Si ha continuado este intento en otro dispositivo después de esta hora, podría perder datos.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocurrió un error al guardar las respuestas. ¿Está seguro de querer abandonar el cuestionario?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Este cuestionario no puede realizarse en la app porque su comportamiento no está soportado:';
$string['addon.mod_quiz.errordownloading'] = 'Error al descargar datos necesarios.';
$string['addon.mod_quiz.errorgetattempt'] = 'Error al obtener datos del intento.';
$string['addon.mod_quiz.errorgetquestions'] = 'Error al obtener las preguntas.';
$string['addon.mod_quiz.errorgetquiz'] = 'Error al obtener datos del cuestionario.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocurrió un error al leer las preguntas. Por favor intente este cuestionario desde un navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Este cuestionario no puede realizarse desde la aplicación porque contiene preguntas no incluidas en esta aplicación';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Este cuestionario no puede realizarse desde la app porque tiene condiciones de acceso no soportadas:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocurrió un error al guardar los datos del intento.';
$string['addon.mod_quiz.finishnotsynced'] = 'Finalizado pero no sincronizado.';
$string['addon.mod_quiz.opentoc'] = 'Abrir menú de navegación.';
$string['addon.mod_quiz.warningattemptfinished'] = 'El intento fuera de línea fue descartado porque fue terminado en el sitio o no fue encontrado.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algunas respuestas fuera de línea fueron descartas porque las preguntas fueron modificadas en línea.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'El intento no fue terminado porque algunas respuestas fuera de línea fueron descartadas. Por favor, revise sus respuestas y entonces envíe el intento nuevamente.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Este cuestionario contiene preguntas no incluidas en esta aplicación';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Se ha producido un error cargando el contenido.';
$string['addon.mod_resource.openthefile'] = 'Abrir';
$string['addon.mod_scorm.cannotcalculategrade'] = 'La calificación no se puede calcular.';
$string['addon.mod_scorm.dataattemptshown'] = 'Este dato pertenece al intento número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Se ha producido un error creando un nuevo intento fuera de línea. Por favor inténtelo otra vez.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Se ha producido un error descargando el paquete SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Se ha producido un error recuperando los datos del paquete SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Lo sentimos, la aplicación solo soporta SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'La descarga de paquetes SCORM está deshabilitada en esta instalación de Moodle. Contacte con el administrador.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este paquete SCORM no tiene una SCO visible para cargar.';
$string['addon.mod_scorm.errorpackagefile'] = 'Lo sentimos, la aplicación solo soporta paquetes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Se ha producido un error durante la sincronización. Por favor inténtelo de nuevo.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Este intento contiene datos que todavía no se han sincronizado .';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Este intento no se puede enviar porque has sobrepasado el máximo número de intentos.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM no se ha descargado. Lo hará automáticamente cuando lo abras.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este SCORM se ha modificado desde la última descarga. Se descargará automáticamente cuando lo abras.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Algunos datos fuera de línea del intento {{number}} se han eliminado porque no pueden crearse en el nuevo intento.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algunos intentos no pueden sincronizarse con el sitio porque el último intento en línea no ha finalizado. Por favor acabe primero el intento.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Lo sentimos, hay un problema enviando la encuesta. Por favor inténtelo otra vez.';
$string['addon.mod_survey.errorgetsurvey'] = 'Se ha producido un error recuperando los datos de la encuesta.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Ir a la URL';
$string['addon.mod_url.pointingtourl'] = 'La URL donde apunta este recurso';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocurrió un error al cargar la página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este wiki todavía no tiene ningun contenido.';
$string['addon.mod_wiki.gowikihome'] = 'Ir al inicio del wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'El título no debería estar vacío.';
$string['addon.mod_wiki.viewpage'] = 'Ver página';
$string['addon.mod_wiki.wikipage'] = 'Página del wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estrategia de calificación {{$a}} no soportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Debe introducir algún título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'El envío fue modificado en el sitio.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'La evaluación fue modificada en el sitio.';
$string['addon.notes.warningnotenotsent'] = 'No se pudieron añadir notas al curso {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Error al obtener notificaciones.';
$string['addon.notifications.notifications'] = 'Notificaciones';
$string['addon.notifications.playsound'] = 'Reproducir sonido';
$string['addon.notifications.therearentnotificationsyet'] = 'No hay notificaciones';
$string['addon.privatefiles.couldnotloadfiles'] = 'La lista de archivos no se pudo cargar.';
$string['addon.privatefiles.emptyfilelist'] = 'No hay archivos que mostrar.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Lamentablement no es posible subir archivos a su sitio.';
$string['addon.storagemanager.deletecourse'] = 'Descargar todos los datos del curso';
$string['addon.storagemanager.deletecourses'] = 'Borrar toda la información de los cursos.';
$string['addon.storagemanager.deletedatafrom'] = 'Descargar los datos de {{name}}';
$string['addon.storagemanager.info'] = 'Los ficheros restaurados en su dispositivo hacen que la aplicación funcione mas rápidamente y le permiten su uso sin estar conectado al internet. Puede descargar ficheros de manera segura para liberar espacio.';
$string['addon.storagemanager.managestorage'] = 'Administre el almacenamiento';
$string['addon.storagemanager.storageused'] = 'Almacenamiento utilizado:';
$string['appstoredescription'] = 'NOTA: Esta aplicación oficial de Moodle Mobile sólo funciona con sitios Moodle que se han configurado para permitirlo. Por favor, contacte con su administrador de Moodle si usted tiene algún problema de conexión.

Si su sitio Moodle se ha configurado correctamente, puede utilizar esta aplicación para:

- Navegar por el contenido de sus cursos, incluso sin conexión
- Recibir notificaciones instantáneas de mensajes y otros eventos
- Encontrar y contactar de forma rápida a otras personas en sus cursos
- Subir imágenes, audio, vídeos y otros archivos desde su dispositivo móvil
- Ver las calificaciones de los cursos
- ¡y más!

Por favor, vea http://docs.moodle.org/en/Mobile_app para toda la información más reciente.

Nos encantaría recibir cualquier crítica acerca de la aplicación y sus sugerencias sobre qué más quieres que pueda hacer.

La aplicación requiere los siguientes permisos:
Grabación de audio - Para la grabación de audio para subir a Moodle
Leer y modificar los contenidos de la tarjeta SD - El contenido se descarga en la tarjeta SD para que puedas verlos offline
Acceso a la red - Para ser capaz de conectar con su sitio Moodle y comprobar si está conectado o no para cambiar al modo fuera de línea
Ejecutar en el arranque - Así recibirá notificaciones locales incluso cuando la aplicación se ejecuta en segundo plano
Desactivar el modo stand - Podrá recibir las notificaciones push en cualquier momento';
$string['core.browser'] = 'Navegador.';
$string['core.cannotconnect'] = 'No se puede conectar';
$string['core.cannotconnecttrouble'] = 'Estamos experemintando problemas para conectar a su sitio.';
$string['core.cannotconnectverify'] = '<strong>Por favor compruebe que la dirección es correcta.</strong>';
$string['core.cannotdownloadfiles'] = 'La descarga de archivos está deshabilitada en su servicio Mobile. Por favor contacte al administrador de su sitio.';
$string['core.cannotopeninapp'] = 'Este tipo de archivo puede que no funcione en este dispositivo. ¿Desea abrirlo igualmente?';
$string['core.cannotopeninappdownload'] = 'Este tipo de archivo puede que no funcione en este dispositivo. ¿Desea descargalo igualmente?';
$string['core.captureaudio'] = 'Grabar audio';
$string['core.capturedimage'] = 'Foto tomada.';
$string['core.captureimage'] = 'Tomar foto';
$string['core.capturevideo'] = 'Grabar video';
$string['core.clearsearch'] = 'Limpiar búsqueda';
$string['core.clearstoreddata'] = 'Eliminar datos {{$a}}';
$string['core.clicktoseefull'] = 'Clic para ver el contenido al completo';
$string['core.comments.commentsnotworking'] = 'Los comentarios no se pueden recuperar.';
$string['core.comments.warningcommentsnotsent'] = 'No se han podido sincronizar los comentarios. {{error}}';
$string['core.confirmcanceledit'] = '¿Está usted seguro de que quiere abandonar esta página? Se perderán todos los cambios.';
$string['core.confirmgotabroot'] = '¿Está seguro que quiere regresar a {{name}}?';
$string['core.confirmgotabrootdefault'] = '¿Está seguro que quiere regresar a la pagina inicial de esta pestaña?';
$string['core.confirmleaveunknownchanges'] = '¿Está seguro que desea abandonar esta página? Si tiene cambios no guardados se perderán.';
$string['core.confirmloss'] = '¿Está seguro? Se perderán todos los cambios.';
$string['core.confirmopeninbrowser'] = '¿Quiere abrirlo en el navegador?';
$string['core.contenteditingsynced'] = 'El contenido que está editando ha sido sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escoger una cuenta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escoger una cuenta con la que abrir el enlace.';
$string['core.contentlinks.confirmurlothersite'] = 'Este enlace pertenece a otro sitio. ¿Quieres abrirlo?';
$string['core.contentlinks.errornoactions'] = 'No se ha encontrado ninguna acción para realizar con este enlace.';
$string['core.contentlinks.errornosites'] = 'No se ha encontrado ningún sitio para gestionar este enlace.';
$string['core.contentlinks.errorredirectothersite'] = 'La dirección web solicitada no puede dirigirse a otra pagina.';
$string['core.copiedtoclipboard'] = 'Texto copiado al portapapeles';
$string['core.copytoclipboard'] = 'Copiar al portapapeles';
$string['core.course.activitydisabled'] = 'Su  organización ha deshabilitado esta actividad en la aplicación móvil.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Esta actividad es un complemento de terceros que todavía no está soportada por la aplicación.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'El sitio no está usando la versión más reciente de Moodle. Por favor, contacte al administrador del sitio.';
$string['core.course.allsections'] = 'Todas las secciones';
$string['core.course.aria:sectionprogress'] = 'Progreso en la sección:';
$string['core.course.askadmintosupport'] = 'Contacte al administrador del sitio e indíquele que desea poder usar esta actividad en la aplicación.';
$string['core.course.availablespace'] = 'Actualmente tiene {{available}} espacio disponible.';
$string['core.course.cannotdeletewhiledownloading'] = 'No se pueden borrar archivos mientras la actividad se descarga. Por favor espere a que finalice la descarga.';
$string['core.course.confirmdeletemodulefiles'] = '¿Está seguro de querer eliminar estos archivos del módulo?';
$string['core.course.confirmdeletestoreddata'] = '¿Está seguro que desea eliminar la información almacenada?';
$string['core.course.confirmdownload'] = 'Está a punto de descargar {{size}}.{{availableSpace}} ¿Está seguro que desea continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'Ha sido imposible calcular el tamaño de la descarga. ¿Está seguro que desea continuar?';
$string['core.course.confirmdownloadzerosize'] = 'Esta a punto de descargar. {{availableSpace}} ¿Está seguro de que desea continuar?';
$string['core.course.confirmlimiteddownload'] = 'En este momento no está conectado al WI-FI.';
$string['core.course.confirmpartialdownloadsize'] = 'Está a punto de descargar <strong>al menos</strong> {{size}}. {{availableSpace}} ¿Está seguro que desea continuar?';
$string['core.course.contents'] = 'Contenidos';
$string['core.course.couldnotloadsectioncontent'] = 'No se ha podido cargar el contenido de la sección, por favor inténtelo más tarde.';
$string['core.course.couldnotloadsections'] = 'No se ha podido cargar las secciones, por favor inténtelo más tarde.';
$string['core.course.downloadcoursesprogressdescription'] = 'Descargando cursos: {{count}} descagados de un total de {{total}}';
$string['core.course.downloadsectionprogressdescription'] = 'Descargando sección: {{count}} descagado de un total de {{total}}';
$string['core.course.errordownloadingcourse'] = 'Error al descargar el curso.';
$string['core.course.errordownloadingsection'] = 'Error durante la descarga de la sección.';
$string['core.course.errorgetmodule'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['core.course.insufficientavailablequota'] = 'Su dispositivo no pudo encontrar espacio para guardar esta descarga. Debe estar reservando espacio para la actualización del sistema y de la aplicación. Por favor libere espacio en la memoria primero.';
$string['core.course.insufficientavailablespace'] = 'Está intentando descargar {{size}}. Esto dejará su dispositivo con espacio insuficiente para operar normalmente. Por favor libere espacio en la memoria primero.';
$string['core.course.manualcompletionnotsynced'] = 'Finalización manual no sincronizada.';
$string['core.course.nocontentavailable'] = 'No hay contenido disponible en este momento.';
$string['core.course.refreshcourse'] = 'Refrescar curso';
$string['core.course.useactivityonbrowser'] = 'Puede acceder a esta actividad mediante el navegador de su dispositivo.';
$string['core.course.warningmanualcompletionmodified'] = 'La finalización manual de una actividad fue modificada en el sitio.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Una parte de la finalización manual del curso \'{{name}}\' ha sido eliminada. {{error}}';
$string['core.coursenogroups'] = 'Usted no es miembro de ningún grupo de este curso.';
$string['core.courses.cannotretrievemorecategories'] = 'No se pueden recuperar categorías más profundas que el nivel {{$a}}.';
$string['core.courses.confirmselfenrol'] = '¿Está seguro que desea auto-matricularse en este curso?';
$string['core.courses.downloadcourses'] = 'Descargar cursos';
$string['core.courses.enrolme'] = 'Matricularme';
$string['core.courses.errorloadcategories'] = 'Ocurrió un error al cargar categorías.';
$string['core.courses.errorloadcourses'] = 'Se ha producido un error cargando los cursos.';
$string['core.courses.errorloadplugins'] = 'Los plugins requeridos por este curso no se han podido cargar correctamente. Por favor, reinicie la aplicación e inténtelo de nuevo.';
$string['core.courses.errorsearching'] = 'Se ha producido un error durante la búsqueda.';
$string['core.courses.errorselfenrol'] = 'Se ha producido un error durante la auto-matriculación.';
$string['core.courses.filtermycourses'] = 'Filtrar mis cursos';
$string['core.courses.notenrollable'] = 'No puede auto-matricularse en este curso.';
$string['core.courses.password'] = 'Clave';
$string['core.courses.searchcoursesadvice'] = 'Puede utilizar el botón de buscar cursos para acceder como invitado o auto-matricularse en los cursos que lo permitan.';
$string['core.courses.selfenrolment'] = 'Auto-matriculación';
$string['core.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo actual';
$string['core.datastoredoffline'] = 'Los datos se almacenaron en el dispositivo debido a que no se pudieron enviar. Serán enviados automáticamente más tarde.';
$string['core.deletedoffline'] = 'Eliminado fuera de línea';
$string['core.deleting'] = 'Borrando';
$string['core.desktop'] = 'Escritorio';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Descartar';
$string['core.downloaded'] = 'Descargada';
$string['core.downloading'] = 'Descargando...';
$string['core.editor.hidetoolbar'] = 'Ocultar la barra de herramientas';
$string['core.editor.toggle'] = 'Alternar el editor';
$string['core.emptysplit'] = 'Esta página aparecerá en blanco si el panel izquierdo está vacío o si está cargando.';
$string['core.errorchangecompletion'] = 'Ha ocurrido un error cargando el grado de realización. Por favor inténtalo de nuevo.';
$string['core.errordeletefile'] = 'Error al eliminar el archivo. Por favor inténtelo de nuevo.';
$string['core.errordownloading'] = 'Ocurrió un error descargando el archivo';
$string['core.errordownloadingsomefiles'] = 'Se ha producido un error descargando los ficheros del módulo. Algunos archivos se pueden haber perdido.';
$string['core.errorfileexistssamename'] = 'Ya existe un archivo con este nombre.';
$string['core.errorinvalidform'] = 'El formulario contiene datos inválidos. Por favor, asegúrese de rellenar todos los campos requeridos y que los datos son válidos.';
$string['core.errorinvalidresponse'] = 'Se ha recibido una respuesta no válida. Por favor contactar con el administrador de Moodle si el error persiste.';
$string['core.errorloadingcontent'] = 'Error cargando contenido.';
$string['core.errorofflinedisabled'] = 'La navegación fuera de línea está deshabilitada en su sitio. Necesita estar conectado a Internet para usar la aplicación.';
$string['core.erroropenfiledownloading'] = 'Error al abrir el archivo: tiene que esperar a que finalice la descarga.';
$string['core.erroropenfilenoapp'] = 'Error durante la apertura del archivo: no se encontró ninguna aplicación capaz de abrir este tipo de archivo.';
$string['core.erroropenfilenoextension'] = 'Se ha producido un error abriendo el archivo: el archivo no tiene extensión.';
$string['core.erroropenpopup'] = 'Esta actividad está intentando abrir una ventana emergente. Esta aplicación no lo soporta.';
$string['core.errorrenamefile'] = 'Error al renombrar el archivo. Por favor inténtelo de nuevo.';
$string['core.errorsomedatanotdownloaded'] = 'Si ha descargado esta actividad, por favor tenga en cuenta que la información no ha sido descargada durante el proceso de descarga por problemas en el  uso de datos y funcionamiento de la aplicación.';
$string['core.errorsync'] = 'Ocurrió un error al sincronizar. Por favor inténtelo de nuevo más tarde.';
$string['core.errorsyncblocked'] = 'Este/a {{$a}} no puede sincronizarse ahora mismo porque hay un proceso trabajando. Por favor inténtelo de nuevo más tarde. Si el problema persiste, intente reiniciar la aplicación.';
$string['core.errorurlschemeinvalidscheme'] = 'Esta URL está definida para otra aplicación: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Esta URL no se puede abrir en la aplicación.';
$string['core.filenameexist'] = 'El nombre de archivo ya existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Cámara';
$string['core.fileuploader.confirmuploadfile'] = 'Usted va a subir {{size}}. ¿Desea continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'No pudimos calcular el tamaño de la subida. ¿Está seguro de querer continuar?';
$string['core.fileuploader.errorcapturingaudio'] = 'Error capturando audio';
$string['core.fileuploader.errorcapturingimage'] = 'Error capturando imagen.';
$string['core.fileuploader.errorcapturingvideo'] = 'Error grabando el vídeo';
$string['core.fileuploader.errorgettingimagealbum'] = 'Error tomando la imagen desde al álbum.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Debe estar conectado para subir archivos.';
$string['core.fileuploader.errornoapp'] = 'Usted no tiene una app instalada para realizar esta acción.';
$string['core.fileuploader.errorreadingfile'] = 'Error al leer el archivo.';
$string['core.fileuploader.errorwhileuploading'] = 'Ocurrió un error al subir un archivo.';
$string['core.fileuploader.file'] = 'Archivo';
$string['core.fileuploader.fileuploaded'] = 'Archivo subido';
$string['core.fileuploader.maxbytesfile'] = 'El archivo {{$a.file}} es demasido grande. El tamaño máximo que puede subir es {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Álbumes de fotos';
$string['core.fileuploader.readingfile'] = 'Leyendo archivo';
$string['core.fileuploader.readingfileperc'] = 'Leyendo fichero: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Seleccionar un archivo';
$string['core.fileuploader.uploadafile'] = 'Subir un archivo';
$string['core.fileuploader.uploading'] = 'Subiendo';
$string['core.fileuploader.uploadingperc'] = 'Subiendo: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Ocurrió un error al obtener su email. Por favor, compruebe su conexión e inténtelo de nuevo.';
$string['core.h5p.offlinedisabled'] = 'Este sitio no permite la descarga de paquetes H5P';
$string['core.h5p.play'] = 'Visualizar H5P';
$string['core.hasdatatosync'] = 'Este/a {{$a}} tiene datos fuera de línea para sincronizarse.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = '¿Problemas para visualizar el contenido?';
$string['core.image'] = 'Imagen';
$string['core.imageviewer'] = 'Visor de imágenes';
$string['core.ioscookieshelp'] = 'El contenido incrustado puede requerir cookies. Por favor, abra las opciones de iOS y habilite "Permitir seguimiento entrre sitios web" e inténtlo de nuevo.';
$string['core.lastdownloaded'] = 'Última descarga';
$string['core.lastsync'] = 'Última sincronización';
$string['core.loadmore'] = 'Cargar más';
$string['core.login.authenticating'] = 'Autenticando';
$string['core.login.changepasswordbutton'] = 'Abrir la página de cambio de contraseña';
$string['core.login.changepasswordhelp'] = 'Si tiene problemas cambiando su contraseña por favor contacto al administrador de su sitio. "El administrador del sitio" es el encargado de la gestión de Moodle en su escuela/Universidad/empresa. Si desconoce como contactarle, por favor, contacte con su profesor.';
$string['core.login.changepasswordinstructions'] = 'No puede cambiar su contraseña en la aplicación. Por favor, pulse el siguiente botón para abrir el sitio en un navegador web y cambiar allí su contraseña. Tenga en cuenta que si cierra el navegador antes de cambiar la contraseña no se le redirigirá de nuevo a la aplicación.';
$string['core.login.changepasswordlogoutinstructions'] = 'Si prefiere cambiar el sitio o salir, por favor pulse el siguiente botón:';
$string['core.login.changepasswordreconnectinstructions'] = 'Pulse el siguiente botón para reconectar a su sitio. (Tenga en cuenta que si no cambió correctamente su contraseña volverá a la pantall aanterior).';
$string['core.login.confirmdeletesite'] = '¿Está seguro de que quiere eliminar el sitio {{sitename}}?';
$string['core.login.connect'] = 'Conectar';
$string['core.login.connecttomoodle'] = 'Conectar a Moodle';
$string['core.login.connecttomoodleapp'] = 'Está intentando conectarse a una página regular Moodle. Por favor descargue la aplicación Moodle para acceder a esta página.';
$string['core.login.connecttoworkplaceapp'] = 'Está intentando conectarse a una pagina de trabajo Moodle. Por favor descargue la aplicación Estación Trabajo Moodle para acceder a esta página.';
$string['core.login.contactyouradministrator'] = 'Contacte a su administrador del sitio para más ayuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, pídale al administrador que revise el siguiente problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Introduzca su nombre se usuario y contraseña para entrar';
$string['core.login.emailconfirmsentnoemail'] = '<p>Un email debería de haberse enviado a su dirección.</p><p>Contiene instrucciones fáciles para completar su registro.</p><p>Si persisten las dificultades, póngase en contacto con el administrador del sitio.</p>';
$string['core.login.emailnotmatch'] = 'Las direcciones de correo no coinciden.';
$string['core.login.erroraccesscontrolalloworigin'] = 'La llamada Cross-Origin que está intentando ha sido rechazada. Por favor visite https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Ha ocurrido un error eliminando este sitio. Por favor, inténtelo de nuevo.';
$string['core.login.errorexampleurl'] = 'La URL https://campus.example.edu es un ejemplo, no es un sitio de verdad. <strong>Por favor use la URL de su escuela u organización.</strong>';
$string['core.login.errorqrnoscheme'] = 'Esta URL no es válida para autenticación';
$string['core.login.errorupdatesite'] = 'Se ha producido un error actualizando el token del sitio.';
$string['core.login.faqcannotconnectanswer'] = 'Por favor, contacte al administrador de su sitio.';
$string['core.login.faqcannotconnectquestion'] = 'He introducido correctamente la dirección de mi sitio pero aún no puedo conectar.';
$string['core.login.faqcannotfindmysiteanswer'] = '¿Ha introducido el nombre correctamente? También es posible que su sitio no esté incluido en el directorio público. Si no lo puede encontrar, por favor introduzca en su lugar la dirección web (URL) de su sitio.';
$string['core.login.faqcannotfindmysitequestion'] = 'No puedo encontrar mi sitio.';
$string['core.login.faqsetupsiteanswer'] = 'Visite {{$link}} para comprobar las diferentes opciones disponibles a la hora de crear su propio sitio Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Comenzar';
$string['core.login.faqsetupsitequestion'] = 'Quiero crear mi propio sitio Moodle';
$string['core.login.faqtestappanswer'] = 'Para probar la app en un sitio Moodle de pruebas, escriba "teacher" o "student" en el campo "Su sitio" y haga clic en el botón "Conectar a su sitio"';
$string['core.login.faqtestappquestion'] = 'Solamente quiero probar la app, ¿Qué puedo hacer?';
$string['core.login.faqwhatisurlanswer'] = '<p>Cada organización tiene su propia dirección o URL única para su sitio Moodle. Para encontrar la dirección:</p><ol><li>Abra un navegador web y vaya a la página de inicio de sesión de su sitio Moodle.</li><li>En la parte superior de la página, en la barra de direcciones, verá la URL de su sitio Moodle, por ejemplo "campus.example.edu".<br>{{$ image}}</li><li>Copie la dirección (no copie "/login" y lo que viene después), péguela en la aplicación Moodle y luego haga clic en "Conectar a su sitio"</li><li>Ahora puede iniciar sesión en su sitio con su nombre de usuario y contraseña.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = '¿Cuál es la dirección de mi sitio? ¿Dónde puedo encontrar la URL de mi sitio?';
$string['core.login.faqwhereisqrcode'] = '¿Dónde puedo encontrar el código QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Si su organización lo ha habilitado, encontrará el código QR en su sitio Moodle en la parte inferior de su página de perfil de usuario.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Encuentre su sitio';
$string['core.login.helpmelogin'] = '<p>Existen muchos sitios Moodle en el mundo. Esta aplicación solamente puede conectar a sitios Moodle que tengan específicamente habilitado el acceso por la aplicación Moodle.</p><p>Si no puede conectarse a su sitio Moodle, póngase en contacto con el administrador del sitio y pídale que lea <a href="http://docs.moodle.org/es/Mobile_app" target="_blank">http://docs.moodle.org/es/Mobile_app</a></p><p>Para probar la aplicación en un sitio Moodle de muestra, escriba <i>teacher</i> o <i>student</i> en el campo de la <i>Dirección del sitio</i> y haga click en el <b>Botón Conectar</b>.</p>';
$string['core.login.invalidaccount'] = 'Por favor, verifique sus datos de acceso, o consulte con el administrador para revisar la configuración del sitio.';
$string['core.login.invalidmoodleversion'] = '<p>Versión inválida de sitio Moodle. La App Moodle solamente soporta sistemas Moodle {{$a}} en adelante.</p>
<p>Puede ponerse en contacto con el administrador de sus sitio y pedirle que actualice su sistema Moodle.</p>
<p>Los "Administradores del sitio" son las personas que gestionan el Moodle en su escuela/universidad/compañía o su organización educativa. Si no sabe a quien contactar, por favor póngase en contacto con sus profesores/entrenadores.</p>';
$string['core.login.invalidsite'] = 'La URL del sitio es inválida.';
$string['core.login.invalidtime'] = 'Hora incorrecta';
$string['core.login.invalidvaluemax'] = 'El valor máximo es {{$a}}';
$string['core.login.invalidvaluemin'] = 'El valor mínimo es {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Las características adicionales de Moodle Mobile han devuelto una respuesta inesperada, debe autenticarse utilizando el servicio estándar de Mobile.';
$string['core.login.loggedoutssodescription'] = 'Tiene que autenticarse nuevamente. Necesita acceder al sitio en una ventana del navegador.';
$string['core.login.loginbutton'] = 'Acceder';
$string['core.login.logininsiterequired'] = 'Para autentificarse en el sitio se ha de abrir una ventana de navegador.';
$string['core.login.mobileservicesnotenabled'] = 'El acceso móvil no está habilitado para este sitio, por favor, contacte con su administrador si piensa que debería estar habilitado.';
$string['core.login.notloggedin'] = 'Ha de entrar al sitio.';
$string['core.login.onboardingcreatemanagecourses'] = 'Crear y gestionar sus curos';
$string['core.login.onboardingenrolmanagestudents'] = 'Matricular y gestionar sus estudiantes';
$string['core.login.onboardinggetstarted'] = 'Comenzar con Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ya tengo un sitio Moodle';
$string['core.login.onboardingimalearner'] = 'Soy un estudiante';
$string['core.login.onboardingimaneducator'] = 'Soy un mentor/profesor';
$string['core.login.onboardingineedasite'] = 'Necesito un sitio Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Denos su opinión';
$string['core.login.onboardingtoconnect'] = 'Para utilizar la app de Moodle necesita un sitio Moodle.';
$string['core.login.onboardingwelcome'] = '¡Bienvenido a la app de Moodle!';
$string['core.login.or'] = 'O';
$string['core.login.passwordrequired'] = 'Contraseña obligatoria';
$string['core.login.recaptchachallengeimage'] = 'reto reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'La verificación ha expirado. Contesta nuevamente la pregunta de seguridad.';
$string['core.login.recaptchaincorrect'] = 'La respuesta a la pregunta de seguridad es incorrecta.';
$string['core.login.reconnect'] = 'Reconectar';
$string['core.login.reconnectdescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio.';
$string['core.login.reconnectssodescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio. Necesita hacerlo desde un navegador web.';
$string['core.login.searchby'] = 'Buscar por:';
$string['core.login.selectsite'] = 'Por favor seleccione su sitio:';
$string['core.login.signupplugindisabled'] = '{{$a}} no está habilitado';
$string['core.login.signuprequiredfieldnotsupported'] = 'El formulario de alta contiene un campo de usuario que no es compatible con la app. Por favor, cree su cuenta usando el navegador web.';
$string['core.login.siteaddress'] = 'Su sitio';
$string['core.login.sitebadgedescription'] = 'Hay {{count}} notificaciones sin leerr';
$string['core.login.sitehasredirect'] = 'Su sitio contiene al menos una redirección HTTP. La aplicación no puede seguir redirectiones, este puede ser el problema que impide a la aplicación conectar a su sitio.';
$string['core.login.siteinmaintenance'] = 'Su sitio está en modo mantenimiento';
$string['core.login.sitepolicynotagreederror'] = 'No se aceptó la política del sitio.';
$string['core.login.siteurl'] = 'URL del sitio';
$string['core.login.siteurlrequired'] = 'La URL del sitio es obligatoria, por ejemplo <i>http://www.yourmoodlesite.es o  https://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = '¿Todavía no puede conectar?';
$string['core.login.usernamerequired'] = 'Nombre de usuario obligatorio';
$string['core.login.visitchangepassword'] = '¿Quiere visitar el sitio para cambiar la contraseña?';
$string['core.login.webservicesnotenabled'] = 'Los Servicios Web no están habilitados en su sitio, por favor, contacte a su administrador de Moodle para obtener ayuda.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Todavía puede conectar al sitio introduciendo su usuario y contraseña.';
$string['core.login.yourenteredsite'] = 'Conectar a su sitio';
$string['core.lostconnection'] = 'Hemos perdido la conexión, necesita reconectar. Su token ya no es válido';
$string['core.mainmenu.changesite'] = 'Cambiar de sitio';
$string['core.mainmenu.website'] = 'Página web';
$string['core.needhelp'] = '¿Necesita ayuda?';
$string['core.networkerroriframemsg'] = 'Este contenido no está disponible sin conexión. Por favor, conecte a Internet e inténtelo de nuevo.';
$string['core.networkerrormsg'] = 'Conexión no disponible o sin funcionar.';
$string['core.nooptionavailable'] = 'No hay opción disponible';
$string['core.nopasswordchangeforced'] = 'No puede continuar sin cambiar su contraseña.';
$string['core.nopermissionerror'] = 'Discuple, pero no tiene permisos para realizar la acción.';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'No enviado';
$string['core.nummore'] = '{{$a}} más';
$string['core.openfile'] = 'Abrir archivo';
$string['core.openfullimage'] = 'Haga clic aquí para ver la imagen a tamaño completo';
$string['core.openinbrowser'] = 'Abrir en el navegador';
$string['core.openmodinbrowser'] = 'Abrir {{$a}} en el navegador';
$string['core.opensecurityquestion'] = 'Abrir pregunta de seguridad';
$string['core.opensettings'] = 'Abrir ajustes';
$string['core.openwith'] = 'Abrir con...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Reproducir';
$string['core.pulltorefresh'] = 'Tirar para recargar';
$string['core.qrscanner'] = 'Escáner de QR';
$string['core.question.cannotdeterminestatus'] = 'No se puede determinar el estado.';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Su sitio aún no admite adjuntos en sus respuestas.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Su sitio aún no soporta editar archivos adjuntos.';
$string['core.question.errorquestionnotsupported'] = 'Este tipo de pregunta no está soportada por la aplicación: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tocar para seleccionar y tocar para soltar.';
$string['core.question.questionmessage'] = 'Pregunta {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Será redirigido al sitio.';
$string['core.removefiles'] = 'Eliminar archivos {{$a}}';
$string['core.requireduserdatamissing'] = 'En este perfil de usuario faltan datos requeridos. Por favor, rellene estos datos e inténtelo otra vez.<br>{{$a}}';
$string['core.retry'] = 'Reintentar';
$string['core.scanqr'] = 'Escanear código QR';
$string['core.scrollbackward'] = 'Retroceder';
$string['core.scrollforward'] = 'Avanzar';
$string['core.searching'] = 'Buscando';
$string['core.settings.about'] = 'Acerca de';
$string['core.settings.appsettings'] = 'Configuración de la aplicación';
$string['core.settings.appversion'] = 'Versión de la aplicación';
$string['core.settings.cannotsyncloggedout'] = 'El sitio no se puede sincronizar porque ha cerrado sesión. Por favor inténtelo de nuevo cuando inicie sesión.';
$string['core.settings.cannotsyncoffline'] = 'No puede sincronizarse fuera de línea.';
$string['core.settings.cannotsyncwithoutwifi'] = 'No puede sincronizarse porque las configuraciones actuales solamente permiten sincronizar cuando está conectado a Wi-Fi. Por favor, conéctese a una red Wi-Fi.';
$string['core.settings.colorscheme'] = 'Esquema de colores';
$string['core.settings.colorscheme-dark'] = 'Oscuro';
$string['core.settings.colorscheme-light'] = 'Claro';
$string['core.settings.colorscheme-system'] = 'Valor por defecto';
$string['core.settings.colorscheme-system-notice'] = 'El valor por defecto depende de si su dispositivo es compatible.';
$string['core.settings.compilationinfo'] = 'Información de compilación';
$string['core.settings.copyinfo'] = 'Copiar información del dispositivo al portapapeles';
$string['core.settings.cordovadevicemodel'] = 'Modelo de dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versión de OS de dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma de dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'uuid del dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versión Cordova';
$string['core.settings.debugdisplaydescription'] = 'Si habilitado, las ventanas modales de error mostrarán más datos si es posible.';
$string['core.settings.deletesitefiles'] = '¿Está seguro de que desea borrar todos los archivos descargados de este sitio\'{{sitename}}\'? No podrá usar esta aplicación sin estar conectado al internet.';
$string['core.settings.deletesitefilestitle'] = 'Elimina los ficheros del sitio';
$string['core.settings.deviceinfo'] = 'Información del dispositivo';
$string['core.settings.deviceos'] = 'OS del dispositivo';
$string['core.settings.displayformat'] = 'Formato de visualización';
$string['core.settings.enabledownloadsection'] = 'Habilitar la descarga de secciones';
$string['core.settings.enablefirebaseanalytics'] = 'Habilitar Análisis de Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Si se configura,  esta aplicación recogerá el uso de datos anónimamente.';
$string['core.settings.enablerichtexteditor'] = 'Activar editor de texto enriquecido';
$string['core.settings.enablerichtexteditordescription'] = 'Si se habilita, se mostrará un editor de texto enriquecido en los lugares que lo permitan.';
$string['core.settings.enablesyncwifi'] = 'Permitir la sincronización solo con la WiFi activada';
$string['core.settings.entriesincache'] = '{{$a}} entradas en caché';
$string['core.settings.errordeletesitefiles'] = 'Se ha producido un error eliminando los ficheros del sitio.';
$string['core.settings.errorsyncsite'] = 'Se ha producido un error sincronizando los datos del sitio, por favor compruebe su conexión a internet y pruebe de nuevo.';
$string['core.settings.estimatedfreespace'] = 'Espacio libre (estimado)';
$string['core.settings.filesystemroot'] = 'Raíz del sistema de archivos';
$string['core.settings.fontsize'] = 'Tamaño del texto';
$string['core.settings.forcedsetting'] = 'Esta opción ha sido forzada en la configuración de su sitio.';
$string['core.settings.helpusimprove'] = 'Ayúdanos a mejorar';
$string['core.settings.ioscookies'] = 'Seguimiento entre sitios web';
$string['core.settings.ioscookiesdescription'] = 'El contenido incrustado puede requerir cookies. Por favor, abra las opciones de iOS y habilite "Permitir seguimiento entrre sitios web" e inténtlo de nuevo.';
$string['core.settings.localnotifavailable'] = 'Notificaciones locales disponibles';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Lenguaje del navegador';
$string['core.settings.navigatoruseragent'] = 'Agente de usuario del navegador';
$string['core.settings.networkstatus'] = 'Estado de la conexión a internet';
$string['core.settings.opensourcelicenses'] = 'Licencias de Código Abierto';
$string['core.settings.privacypolicy'] = 'Política de privacidad.';
$string['core.settings.publisher'] = 'Editor';
$string['core.settings.pushid'] = 'Identificador de notificaciones Push';
$string['core.settings.reportinbackground'] = 'Informar de los errores automáticamente';
$string['core.settings.screen'] = 'Información de pantalla';
$string['core.settings.showdownloadoptions'] = 'Mostrar opciones de descarga';
$string['core.settings.siteinfo'] = 'Información del sitio';
$string['core.settings.spaceusage'] = 'Espacio';
$string['core.settings.spaceusagehelp'] = 'Al borrar la información guardada del sitio se borrará toda la información disponible fuera de línea. Esta información le permite usar la aplicación cuando no está conectado a Internet.';
$string['core.settings.synchronization'] = 'Sincronización';
$string['core.settings.synchronizenow'] = 'Sincronizar ahora';
$string['core.settings.synchronizenowhelp'] = 'Al sincronizar un sitio se enviarán todos los cambios y actividad que realizó fuera de línea en el dispositivo, también sincronizará información como mensajes y notificaciones.';
$string['core.settings.syncsettings'] = 'Configuración de la sincronización';
$string['core.settings.wificonnection'] = 'Conexión WiFi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Elija una cuenta en la cual almacenar el archivo.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Ya existe un archivo con este nombre. ¿Desea usted remplazar el archivo existente o renombrarlo a  "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'No hay sitios almacenados. Por favor, añada un sitio antes de compartir un archivo con la aplicación.';
$string['core.sharedfiles.nosharedfiles'] = 'No hay archivos compartidos en este sitio.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'No tiene archivos para subir aquí. Si desea subir un archivo desde otra aplicación, localice ese archivo y haga clic en el botón para \'Abrir en\'.';
$string['core.sharedfiles.rename'] = 'Renombrar';
$string['core.sharedfiles.replace'] = 'Reemplazar';
$string['core.sharedfiles.sharedfiles'] = 'Archivos compartidos';
$string['core.sharedfiles.successstorefile'] = 'Archivo almacenado correctamente. Ahora puede seleccionar este archivo para subirlo a sus archivos privados, o adjuntarlo a algunas actividades.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Disculpe...';
$string['core.storingfiles'] = 'Almacenando archivos';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Esta etiqueta de area no está permitida por esta aplicación.';
$string['core.tag.tagareabadgedescription'] = 'Hay {{count}} elementos';
$string['core.tag.warningareasnotsupported'] = 'Algunas de las etiquetas de areas no se muestran porque no están permitidas en esta aplicación.';
$string['core.thereisdatatosync'] = 'Hay {{$a}} fuera de línea pendiente de ser sincronizado.';
$string['core.toggledelete'] = 'Mostrar/ocultar botones de borrado';
$string['core.tryagain'] = 'Intentar de nuevo';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = '¡Oh oh!';
$string['core.unexpectederror'] = 'Error inesperado. Por favor cierre y vuelva a abrir la aplicación para intentarlo de nuevo';
$string['core.unicodenotsupported'] = 'Los emojis no están soportado en este sitio; esos caracteres serán quitados cuando el mensaje sea enviado.';
$string['core.unicodenotsupportedcleanerror'] = 'Se encontró texto vacío al limpiar caracteres Unicode.';
$string['core.unknown'] = 'Desconocido';
$string['core.unzipping'] = 'Descomprimiendo';
$string['core.updaterequired'] = 'Actualización de la aplicación requerida';
$string['core.updaterequireddesc'] = 'Por favor actualice la aplicación a la versión {{$a}}';
$string['core.user.contact'] = 'Contacto';
$string['core.user.detailsnotavailable'] = 'No tiene acceso a los detalles de este usuario.';
$string['core.user.errorloaduser'] = 'Error cargando el usuario.';
$string['core.user.sendemail'] = 'Correo electrónico';
$string['core.user.userwithid'] = 'Usuario con ID {{id}}';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.viewembeddedcontent'] = 'Ver contenido embebido.';
$string['core.warningofflinedatadeleted'] = 'Los datos fuera de línea de {{component}} \'{{name}}\' han sido borrados. {{error}}';
$string['core.whoissiteadmin'] = '"El administrador del sitio" es el encargado de la gestión de Moodle en su escuela/Universidad/empresa. Si desconoce como contactarle, por favor, contacte con su profesor.';
$string['core.whoops'] = 'Oops!';
$string['core.whyisthishappening'] = '¿Porqué está pasando esto?';
$string['core.wsfunctionnotavailable'] = 'La función de webservice no está disponible.';
$string['core.youreoffline'] = 'Está desconectado';
$string['core.youreonline'] = 'Conectado de nuevo';
$string['pluginname'] = 'Cadenas de idioma de Moodle Mobile';
