<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'el', version '3.10'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Έλεγχος πρόσβασης';
$string['actionaftercorrectanswer'] = 'Ενέργεια μετά από σωστή απάντηση';
$string['actionaftercorrectanswer_help'] = 'Έπειτα από μια σωστή απάντηση σε μία ερώτηση, υπάρχουν 3 επιλογές για την επόμενη σελίδα:

* Κανονική πορεία - Ακολουθήστε την πορεία της διδασκαλίας
* Εμφάνιση μιας σελίδας που δεν έχει εμφανιστεί - Οι σελίδες εμφανίζονται με τυχαία σειρά με καμία σελίδα να μην εμφανίζεται δύο φορές
* Εμφάνιση μιας μη απαντημένης σελίδας - Οι σελίδες εμφανίζονται με τυχαία σειρά, με τις σελίδες που περιλαμβάνουν αναπάντητες ερωτήσεις να εμφανίζονται ξανά';
$string['actions'] = 'Ενέργειες';
$string['activitylink'] = 'Σύνδεσμος με την επόμενη δραστηριότητα';
$string['activitylink_help'] = 'Για να παρέχετε ένα σύνδεσμο στο τέλος της διδασκαλίας προς μια άλλη δραστηριότητα του μαθήματος, επιλέξτε την δραστηριότητα από το πτυσσόμενο μενού.';
$string['activitylinkname'] = 'Μετάβαση στο: {$a}';
$string['activityoverview'] = 'Υπάρχουν οφειλόμενες διδασκαλίες';
$string['addabranchtable'] = 'Προσθήκη σελίδας περιεχομένου';
$string['addanendofbranch'] = 'Προσθήκη τέλους διακλάδωσης';
$string['addanewpage'] = 'Προσθήκη νέας σελίδας';
$string['addaquestionpage'] = 'Προσθήκη σελίδας ερώτησης';
$string['addaquestionpagehere'] = 'Προσθήκη σελίδας ερώτησης εδώ';
$string['addbranchtable'] = 'Προσθήκη σελίδας περιεχομένου';
$string['addcluster'] = 'Προσθήκη συστάδας';
$string['addedabranchtable'] = 'Προστέθηκε σελίδα περιεχομένου';
$string['addedanendofbranch'] = 'Προστέθηκε τέλος διακλάδωσης';
$string['addedaquestionpage'] = 'Προστέθηκε σελίδα ερωτήσεων';
$string['addedcluster'] = 'Προστέθηκε συστάδα';
$string['addedendofcluster'] = 'Προστέθηκε τέλος συστάδας';
$string['addendofbranch'] = 'Προσθήκη τέλους διακλάδωσης';
$string['addendofcluster'] = 'Προσθήκη τέλους συστάδας';
$string['addessay'] = 'Δημιουργία μιας σελίδας ερώτησης έκθεσης';
$string['additionalattemptsremaining'] = 'Η διδασκαλία ολοκληρώθηκε! Μπορείτε να την επαναλάβετε.';
$string['addmatching'] = 'Δημιουργία μιας σελίδας ερώτησης αντιστοίχισης';
$string['addmultichoice'] = 'Δημιουργία μιας σελίδας ερώτησης πολλαπλής επιλογής';
$string['addnewgroupoverride'] = 'Προσθήκη παράκαμψης ομάδας';
$string['addnewuseroverride'] = 'Προσθήκη παράκαμψης χρήστη';
$string['addnumerical'] = 'Δημιουργία μιας σελίδας αριθμητικής ερώτησης';
$string['addpage'] = 'Προσθήκη μίας σελίδας';
$string['addshortanswer'] = 'Δημιουργία μιας σελίδας ερώτησης σύντομης απάντησης';
$string['addtruefalse'] = 'Δημιουργία μιας σελίδας ερώτησης σωστού/λάθους';
$string['allotheranswers'] = 'Όλες οι άλλες απαντήσεις';
$string['allotheranswersjump'] = 'Όλες οι άλλες απαντήσεις προκαλούν μεταπήδηση';
$string['allotheranswersscore'] = 'Όλες οι άλλες απαντήσεις βαθμολογούνται';
$string['allowofflineattempts'] = 'Να επιτρέπεται εκτός σύνδεσης χρήση της διδασκαλίας με χρήση της εφαρμογής κινητού';
$string['allowofflineattempts_help'] = 'Αν ενεργοποιηθεί, ένας χρήστης της εφαρμογής κινητού μπορεί να κατεβάσει τη διδασκαλία και να την προσπαθήσει εκτός σύνδεσης. Όλες οι πιθανές απαντήσεις καθώς και οι σωστές αποκρίσεις θα κατεβούν επίσης. Σημείωση: Δεν είναι δυνατόν για μια διδασκαλία να επιχειρηθεί εκτός σύνδεσης αν έχει όριο χρόνου.';
$string['anchortitle'] = 'Αρχή κύριου περιεχόμενου';
$string['and'] = 'ΚΑΙ';
$string['answer'] = 'Απάντηση';
$string['answeredcorrectly'] = 'απαντήθηκε σωστά.';
$string['answersfornumerical'] = 'Οι απαντήσεις σε αριθμητικές ερωτήσεις πρέπει να είναι ζευγάρια από ελάχιστες και μέγιστες τιμές';
$string['arrangebuttonshorizontally'] = 'Τακτοποίηση κουμπιών περιεχομένου οριζόντια;';
$string['attempt'] = 'Προσπάθεια: {$a}';
$string['attemptheader'] = 'Προσπάθεια';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Προσπάθειες';
$string['attemptsdeleted'] = 'Διαγραμμένες προσπάθειες';
$string['attemptsremaining'] = 'Σας απομένουν {$a} προσπάθειες';
$string['available'] = 'Διαθέσιμο από';
$string['averagescore'] = 'Μέσο σκορ';
$string['averagetime'] = 'Μέσος χρόνος';
$string['branch'] = 'Περιεχόμενο';
$string['branchtable'] = 'Περιεχόμενο (Πίν. διακλ.)';
$string['cancel'] = 'Άκυρο';
$string['cannotfindanswer'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση απάντησης';
$string['cannotfindattempt'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση προσπάθειας';
$string['cannotfindessay'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση έκθεσης';
$string['cannotfindfirstgrade'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση βαθμών';
$string['cannotfindfirstpage'] = 'Δεν ήταν δυνατή η εύρεση πρώτης σελίδας';
$string['cannotfindgrade'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση βαθμών';
$string['cannotfindnewestgrade'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση νεώτερου βαθμού';
$string['cannotfindnextpage'] = 'Αντίγραφο ασφαλείας διδασκαλίας: Η επόμενη σελίδα δεν βρέθηκε!';
$string['cannotfindpagerecord'] = 'Προσθήκη τέλους διακλάδωσης: αδυναμία εύρεσης εγγραφής σελίδας';
$string['cannotfindpages'] = 'Αποτυχία εύρεσης σελίδων διδασκαλίας';
$string['cannotfindpagetitle'] = 'Επιβεβαίωση διαγραφής: αδυναμία εύρεσης τίτλου σελίδας';
$string['cannotfindpreattempt'] = 'Δεν ήταν δυνατή η εύρεση εγγραφής προηγούμενης προσπάθειας!';
$string['cannotfindrecords'] = 'Σφάλμα: αποτυχία εύρεσης εγγραφών διδασκαλίας';
$string['cannotfindtimer'] = 'Σφάλμα: αποτυχία εύρεσης των εγγραφών του πίνακα lesson_timer (χρονόμετρο διδασκαλίας)';
$string['cannotfinduser'] = 'Σφάλμα: δεν ήταν δυνατή η εύρεση χρηστών';
$string['canretake'] = '{$a} μπορεί να το ξανακάνει';
$string['casesensitive'] = 'Χρήση κανονικών εκφράσεων';
$string['casesensitive_help'] = 'Επιλέξτε το πλαίσιο ελέγχου για να χρησιμοποιήσετε «κανονικές εκφράσεις» στην ανάλυση αποκρίσεων.';
$string['checkbranchtable'] = 'Έλεγχος σελίδας περιεχομένου';
$string['checkedthisone'] = 'Ελέγχθηκε αυτό.';
$string['checknavigation'] = 'Έλεγχος πλοήγησης';
$string['checkquestion'] = 'Έλεγχος ερώτησης';
$string['classstats'] = 'Στατιστικά τάξης';
$string['clicktodownload'] = 'Κάντε κλικ στον παρακάτω σύνδεσμο για λήψη του αρχείου.';
$string['closebeforeopen'] = 'Δεν είναι δυνατή η ενημέρωση της διδασκαλίας. Έχετε ορίσει ημερομηνία λήξης πριν την ημερομηνία έναρξης.';
$string['cluster'] = 'Συστάδα';
$string['clusterjump'] = 'Ερώτηση που δεν εμφανίστηκε μέσα σε συστάδα';
$string['clustertitle'] = 'Συστάδα';
$string['collapsed'] = 'Συμπτυγμένο';
$string['comments'] = 'Τα σχόλιά σας';
$string['completed'] = 'Ολοκληρώθηκε';
$string['completederror'] = 'Ολοκληρώστε την διδασκαλία';
$string['completethefollowingconditions'] = 'Πρέπει να εκπληρώνετε τις ακόλουθες προϋποθέσεις(η) στην <b>{$a}</b> διδασκαλία προκειμένου να συνεχίσετε.';
$string['completionendreached'] = 'Να απαιτείται φτάσιμο στο τέλος';
$string['completionendreached_desc'] = 'Ο μαθητής πρέπει να φτάσει στο τέλος της διδασκαλίας για να ολοκληρώσει αυτήν τη δραστηριότητα.';
$string['completiontimespent'] = 'Ο μαθητής πρέπει να κάνει αυτή τη δραστηριότητα τουλάχιστον για';
$string['completiontimespentdesc'] = 'Ο μαθητής πρέπει να κάνει αυτή τη δραστηριότητα τουλάχιστον για {$a}';
$string['completiontimespentgroup'] = 'Να απαιτείται (μέγιστος) χρόνος';
$string['conditionsfordependency'] = 'Προϋποθέσεις για την εξάρτηση';
$string['configintro'] = 'Οι τιμές που ορίζονται εδώ καθορίζουν τις προεπιλεγμένες τιμές που χρησιμοποιούνται στη φόρμα ρυθμίσεων όταν δημιουργείται μια νέα δραστηριότητα μαθήματος. Οι ρυθμίσεις που έχουν οριστεί ως προχωρημένες εμφανίζονται μόνο όταν κάνετε κλικ στο σύνδεσμο «Εμφάνιση περισσότερων ...».';
$string['configmaxanswers'] = 'Προεπιλογή του μέγιστου αριθμού απαντήσεων ανά σελίδα';
$string['configmediaclose'] = 'Εμφανίζεται ένα κουμπί εξόδου ως μέρος του αναδυόμενου παραθύρου που δημιουργείται για ένα συνδεδεμένο αρχείο πολυμέσων';
$string['configmediaheight'] = 'Ορίζει το ύψος του αναδυόμενου παραθύρου που εμφανίζεται για ένα συνδεδεμένο αρχείο πολυμέσων';
$string['configmediawidth'] = 'Ορίζει το πλάτος του αναδυόμενου παραθύρου που εμφανίζεται για ένα συνδεδεμένο αρχείο πολυμέσων';
$string['configpassword_desc'] = 'Εάν απαιτείται κωδικός πρόσβασης για να αποκτήσετε πρόσβαση στο μάθημα.';
$string['configslideshowbgcolor'] = 'Το χρώμα υπόβαθρου για την παρουσίαση, εάν ενεργοποιηθεί';
$string['configslideshowheight'] = 'Ορίζει το ύψος της παρουσίασης, εάν ενεργοποιηθεί';
$string['configslideshowwidth'] = 'Ορίζει το πλάτος της παρουσίασης, εάν ενεργοποιηθεί';
$string['configtimelimit_desc'] = 'Εάν έχει οριστεί χρονικό όριο, στην αρχή του μαθήματος εμφανίζεται μια προειδοποίηση και υπάρχει χρονομετρητής αντίστροφης μέτρησης. Εάν έχει οριστεί μηδέν, τότε δεν υπάρχει χρονικό όριο.';
$string['confirmdelete'] = 'Διαγραφή σελίδας';
$string['confirmdeletionofthispage'] = 'Επιβεβαίωση διαγραφής αυτής της σελίδας';
$string['congratulations'] = 'Συγχαρητήρια - τελειώσατε την διδασκαλία';
$string['continue'] = 'Συνέχεια';
$string['continuetoanswer'] = 'Συνεχίστε αλλάζοντας τις απαντήσεις.';
$string['continuetonextpage'] = 'Συνέχεια στην επόμενη σελίδα.';
$string['correctanswerjump'] = 'Διορθώστε την μεταπήδηση ερώτησης';
$string['correctanswerscore'] = 'Σκορ σωστής απάντησης';
$string['correctresponse'] = 'Σωστή ανταπόκριση';
$string['createaquestionpage'] = 'Δημιουργία μιας σελίδας ερώτησης';
$string['credit'] = 'Βαθμός';
$string['customscoring'] = 'Ατομικός τρόπος βαθμολόγησης';
$string['customscoring_help'] = 'Αν ενεργοποιηθεί, τότε σε κάθε απάντηση μπορεί να δοθεί μια αριθμητική τιμή βαθμών (θετική ή αρνητική).';
$string['deadline'] = 'Προθεσμία';
$string['defaultessayresponse'] = 'Η έκθεσή σας θα βαθμολογηθεί από τον διδάσκοντά σας.';
$string['deleteallattempts'] = 'Διαγραφή όλων των προσπαθειών της διδασκαλίας';
$string['deletedefaults'] = 'Διαγραφή {$a} x προεπιλογής διδασκαλίας';
$string['deletedpage'] = 'Διαγραμμένη σελίδα';
$string['deletepagenamed'] = 'Διαγραφή σελίδας: {$a}';
$string['deleting'] = 'Διαγραφή';
$string['deletingpage'] = 'Διαγραφή σελίδας: {$a}';
$string['dependencyon'] = 'Εξαρτάται από';
$string['dependencyon_help'] = 'Αυτή η ρύθμιση επιτρέπει πρόσβαση σε αυτή τη διδασκαλία αναλόγως της απόδοσης του μαθητή σε κάποια άλλη διδασκαλία στο ίδιο μάθημα.
Μπορεί να χρησιμοποιηθεί οποιοσδήποτε συνδυασμός χρόνου απασχόλησης, απλή ολοκλήρωση ή «βαθμός μεγαλύτερος από».';
$string['description'] = 'Περιγραφή';
$string['deselectallattempts'] = 'Αποεπιλογή όλων των προσπαθειών';
$string['detailedstats'] = 'Αναλυτικά στατιστικά';
$string['didnotanswerquestion'] = 'Δεν απάντησε αυτήν την ερώτηση.';
$string['didnotreceivecredit'] = 'Δεν έλαβε βαθμό';
$string['disabled'] = 'Απενεργοποιημένο';
$string['displaydefaultfeedback'] = 'Εμφάνιση προεπιλεγμένης ανατροφοδότησης';
$string['displaydefaultfeedback_help'] = 'Εάν ενεργοποιηθεί, όταν δεν βρεθεί απόκριση για μια συγκεκριμένη ερώτηση, θα εμφανιστεί η προεπιλεγμένη απόκριση «Αυτή είναι η σωστή απάντηση» ή «Αυτή είναι η λάθος απάντηση».';
$string['displayinleftmenu'] = 'Εμφάνιση στο μενού;';
$string['displayleftif'] = 'Ελάχιστος βαθμός για εμφάνιση μενού';
$string['displayleftif_help'] = 'Αυτή η ρύθμιση καθορίζει αν ο μαθητής πρέπει να επιτύχει κάποιο βαθμό πριν την εμφάνιση του αριστερού μενού. Αυτό αναγκάζει τον μαθητή να περάσει από όλο το μάθημα για την πρώτη του προσπάθεια, έπειτα μετά την επίτευξη του απαιτούμενου βαθμού θα μπορεί να χρησιμοποιήσει το μενού στα αριστερά για ανασκόπηση.';
$string['displayleftmenu'] = 'Εμφάνιση μενού';
$string['displayleftmenu_help'] = 'Αν ενεργοποιηθεί, εμφανίζεται ένα μενού που επιτρέπει στους χρήστες να πλοηγηθούν μέσα από τη λίστα των σελίδων.';
$string['displayofgrade'] = 'Εμφάνιση βαθμού (μόνο για μαθητές)';
$string['displayreview'] = 'Παροχή επιλογής επαναπροσπάθειας ερώτησης';
$string['displayreview_help'] = 'Εάν ενεργοποιηθεί, όταν μια ερώτηση απαντηθεί λανθασμένα, ο μαθητής έχει τη δυνατότητα να την δοκιμάσει ξανά χωρίς πίστωση πόντων ή να συνεχίσει με τη διδασκαλία. Εάν ο μαθητής κάνει κλικ για να προχωρήσει σε μια άλλη ερώτηση, τότε η επιλεγμένη (λάθος) απάντηση θα ακολουθηθεί. Από προεπιλογή, οι μεταπηδήσεις λανθασμένων απαντήσεων έχουν οριστεί σε «αυτή τη σελίδα» και έχουν βαθμολογία 0, επομένως συνιστάται να ορίσετε τη μεταπήδηση λανθασμένης απάντησης σε μια διαφορετική σελίδα για να αποτρέψετε σύγχυση των μαθητών σας.';
$string['displayscorewithessays'] = '<p>Πήρατε {$a->score} στα {$a->tempmaxgrade} για τις αυτόματα βαθμολογούμενες ερωτήσεις.</p><p>Οι {$a->essayquestions} ερωτήσεις έκθεσης θα βαθμολογηθούν και θα προστεθούν στο τελικό σας σκορ αργότερα.</p><p>Ο τρέχων βαθμός σας χωρίς τις ερωτήσεις έκθεσης είναι {$a->score} στα {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Το σκορ σας είναι {$a->score} (στα {$a->grade}).';
$string['duplicatepagenamed'] = 'Δημιουργία αντιγράφου σελίδας: {$a}';
$string['edit'] = 'Επεξεργασία';
$string['editbranchtable'] = 'Επεξεργασία σελίδας περιεχομένου';
$string['editcluster'] = 'Επεξεργασία συστάδας';
$string['editendofbranch'] = 'Επεξεργασία σελίδας τέλους διακλάδωσης';
$string['editendofcluster'] = 'Επεξεργασία μιας σελίδας τέλους συστάδας (μαθημάτων)';
$string['editessay'] = 'Επεξεργασία σελίδας ερωτήματος έκθεσης';
$string['editingquestionpage'] = 'Επεξεργασία σελίδας ερώτησης {$a}';
$string['editlessonsettings'] = 'Επεξεργασία ρυθμίσεων διδασκαλίας';
$string['editmatching'] = 'Επεξεργασία σελίδας ερώτησης αντιστοίχισης';
$string['editmultichoice'] = 'Επεξεργασία σελίδας ερωτήματος πολλαπλής επιλογής';
$string['editnumerical'] = 'Επεξεργασία σελίδας αριθμητικών ερωτήσεων';
$string['editoverride'] = 'Επεξεργασία παράκαμψης';
$string['editpage'] = 'Επεξεργασία περιεχομένων σελίδας';
$string['editpagecontent'] = 'Επεξεργασία περιεχομένων σελίδας';
$string['editquestion'] = 'Επεξεργασία σελίδας ερωτήματος';
$string['editshortanswer'] = 'Επεξεργασία σελίδας ερώτησης σύντομης απάντησης';
$string['edittruefalse'] = 'Επεξεργασία σελίδας ερώτησης σωστού/λάθους';
$string['email'] = 'Ηλεκτρονικό Ταχυδρομείο';
$string['emailallgradedessays'] = 'Αποστολή με ηλε.ταχυδρομείο ΟΛΩΝ των βαθμολογημένων εκθέσεων';
$string['emailgradedessays'] = 'Αποστολή με ηλε.ταχυδρομείο τις βαθμολογημένες εκθέσεις';
$string['emailsuccess'] = 'Τα μηνύματα ηλε.ταχυδρομείου στάλθηκαν με επιτυχία';
$string['emptypassword'] = 'Ο κωδικός πρόσβασης δεν μπορεί να είναι κενός';
$string['enabled'] = 'Ενεργοποιημένο';
$string['endofbranch'] = 'Τέλος διακλάδωσης';
$string['endofcluster'] = 'Τέλος συστάδας';
$string['endofclustertitle'] = 'Τέλος συστοιχίας';
$string['endoflesson'] = 'Τέλος διδασκαλίας';
$string['enteredthis'] = 'δόθηκε αυτό.';
$string['enterpassword'] = 'Παρακαλούμε εισάγετε τον κωδικό πρόσβασης:';
$string['eolstudentoutoftime'] = 'Προσοχή: Βγήκατε εκτός χρόνου σε αυτή την διδασκαλία. Η τελευταία απάντησή σας μπορεί να μη μετρήσει αν δόθηκε μετά το τέλος του χρόνου.';
$string['eolstudentoutoftimenoanswers'] = 'Δεν απαντήσατε καμία ερώτηση. Πήρατε 0 σε αυτήν τη διδασκαλία.';
$string['essay'] = 'Έκθεση';
$string['essayemailmessage2'] = '<p>Προτροπή έκθεσης:<blockquote>{$a->question}</blockquote></p><p>Η απόκρισή σας:<blockquote><em>{$a->response}</em></blockquote></p><p>Τα σχόλια του βαθμολογητή:<blockquote><em>{$a->comment}</em></blockquote></p><p>Πήρατε {$a->earned} στα {$a->outof} για αυτήν την ερώτηση έκθεσης.</p><p>Ο βαθμός σας στην διδασκαλία έχει αλλάξει σε {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Έχετε λάβει {$a->earned} από {$a->outof} για αυτή την ερώτηση.</p><p>Ο βαθμός σας για το μάθημα {$a->lesson} έχει αλλάξει σε {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Οι διαθέσιμοι βαθμοί για την ερώτηση μαθήματος';
$string['essaynotgradedyet'] = 'Αυτή η έκθεση δεν έχει βαθμολογηθεί ακόμη';
$string['essayresponses'] = 'Αποκρίσεις έκθεσης';
$string['essays'] = 'Εκθέσεις';
$string['essayscore'] = 'Σκορ έκθεσης';
$string['eventcontentpageviewed'] = 'Η σελίδα περιεχομένου προβλήθηκε';
$string['eventessayassessed'] = 'Η έκθεση αξιολογήθηκε';
$string['eventessayattemptviewed'] = 'Η προσπάθεια έκθεσης προβλήθηκε';
$string['eventhighscoreadded'] = 'Η άριστη βαθμολογία προστέθηκε';
$string['eventhighscoresviewed'] = 'Οι άριστες βαθμολογίες προβλήθηκαν';
$string['eventlessonended'] = 'Η διδασκαλία τελείωσε';
$string['eventlessonrestarted'] = 'Η διδασκαλία επανεκκινήθηκε';
$string['eventlessonresumed'] = 'Το μάθημα συνεχίζεται (επαναλαμβάνεται)';
$string['eventlessonstarted'] = 'Το μάθημα ξεκίνησε';
$string['eventoverridecreated'] = 'Η παράκαμψη διδασκαλίας δημιουργήθηκε';
$string['eventoverridedeleted'] = 'Η παράκαμψη διδασκαλίας διαγράφηκε';
$string['eventoverrideupdated'] = 'Η παράκαμψη διδασκαλίας ενημερώθηκε';
$string['eventpagecreated'] = 'Η σελίδα δημιουργήθηκε';
$string['eventpagedeleted'] = 'Η σελίδα διαγράφηκε';
$string['eventpagemoved'] = 'Η σελίδα μετακινήθηκε';
$string['eventpageupdated'] = 'Η σελίδα ενημερώθηκε';
$string['eventquestionanswered'] = 'Η ερώτηση απαντήθηκε';
$string['eventquestionviewed'] = 'Η ερώτηση προβλήθηκε';
$string['false'] = 'Λάθος';
$string['fileformat'] = 'Μορφότυπος αρχείου';
$string['finalwrong'] = 'Όχι ακριβώς.';
$string['finish'] = 'Τέλος';
$string['firstanswershould'] = 'Η πρώτη απάντηση να μεταπηδά στην σελίδα «Σωστή»';
$string['firstwrong'] = 'Απαντήσατε λανθασμένα. Θα θέλατε να προσπαθήσετε ξανά την ερώτηση; (Αν απαντήσετε τώρα την ερώτηση σωστά, δεν θα μετρήσει στο τελικό σκορ σας.)';
$string['flowcontrol'] = 'Έλεγχος ροής';
$string['fractionsaddwrong'] = 'Οι θετικές βαθμολογίες που επιλέξατε δεν αθροίζονται ως το 100%
<br />Αντίθετα, αθροίζονται στο {$a}%
<br />Θέλετε να γυρίσετε πίσω και να τροποποιήσετε την ερώτηση;';
$string['fractionsnomax'] = 'Μια από τις ερωτήσεις θα έπρεπε να είναι 100%, έτσι ώστε να είναι δυνατό
<br />να πάρει κάποιος το σύνολο της βαθμολογίας σε αυτή την ερώτηση.
<br />Θέλετε να επιστρέψετε και να τροποποιήσετε την ερώτηση;';
$string['full'] = 'Αναπτυγμένος';
$string['general'] = 'Γενικά';
$string['gotoendoflesson'] = 'Μετάβαση στο τέλος του μαθήματος';
$string['grade'] = 'Βαθμός';
$string['gradebetterthan'] = 'Βαθμός καλύτερος από (%)';
$string['gradebetterthanerror'] = 'Βαθμολογηθείτε καλύτερα από {$a} τις εκατό';
$string['graded'] = 'Βαθμολογήθηκε';
$string['gradeessay'] = 'Βαθμολογήστε τις ερωτήσεις της έκθεσης ({$a->notgradedcount} δεν βαθμολογήθηκαν και {$a->notsentcount} δεν στάλθηκαν)';
$string['gradeis'] = 'Ο βαθμός είναι {$a}';
$string['gradeoptions'] = 'Ρυθμίσεις βαθμού';
$string['groupoverrides'] = 'Παρακάμψεις ομάδας';
$string['groupoverridesdeleted'] = 'Οι παρακάμψεις ομάδας διαγράφηκαν';
$string['groupsnone'] = 'Δεν υπάρχουν προσβάσιμες για εσάς ομάδες.';
$string['handlingofretakes'] = 'Χειρισμός επανασυμπληρώσεων';
$string['handlingofretakes_help'] = 'Αν επιτρέπονται περισσότερες από μια προσπάθειες, αυτή η ρύθμιση καθορίζει εάν ο βαθμός για το μάθημα θα είναι ο μέσος όρος ή ο μέγιστος όλων των προσπαθειών.';
$string['havenotgradedyet'] = 'Δεν έχει βαθμολογηθεί ακόμα';
$string['here'] = 'εδώ';
$string['highscore'] = 'Υψηλό σκορ';
$string['hightime'] = 'Υψηλός χρόνος';
$string['importcount'] = 'Εισαγωγή {$a} ερωτήσεων';
$string['importquestions'] = 'Εισαγωγή ερωτήσεων';
$string['importquestions_help'] = 'Αυτό το χαρακτηριστικό επιτρέπει την εισαγωγή ερωτήσεων σε διάφορες μορφές μέσω αρχείου κειμένου.';
$string['inactiveoverridehelp'] = '* Αυτή η παράκαμψη είναι ανενεργή, επειδή η πρόσβαση του χρήστη στη δραστηριότητα είναι περιορισμένη. Αυτό μπορεί να οφείλεται σε αναθέσεις ομάδων ή ρόλων, σε άλλους περιορισμούς πρόσβασης ή στην απόκρυψη της δραστηριότητας.';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης διδασκαλίας';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα διδασκαλίας.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης διδασκαλίας';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες Διδασκαλίας κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση ανατροφοδότησης, Σχόλιο στην ανατροφοδότηση, Επανυποβολή μετά την εμφάνιση της ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος διδασκαλίας';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα διδασκαλίας.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος διδασκαλίας';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες Διδασκαλίας κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος, Συμμετέχων με άλλους)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['insertedpage'] = 'Εισαχθείσα σελίδα';
$string['invalidfile'] = 'Μη έγκυρο αρχείο';
$string['invalidid'] = 'Δεν δόθηκε κανένα αναγνωριστικό αρθρώματος μαθήματος ή αναγνωριστικό διδασκαλίας';
$string['invalidlessonid'] = 'Το αναγνωριστικό του μαθήματος δεν ήταν σωστό';
$string['invalidoverrideid'] = 'Άκυρο αναγνωριστικό παράκαμψης';
$string['invalidpageid'] = 'Μη έγκυρο αναγνωριστικό σελίδας';
$string['jump'] = 'Μεταπήδηση';
$string['jumps'] = 'Μεταπηδήσεις';
$string['jumps_help'] = 'Κάθε απάντηση (για ερωτήσεις) ή περιγραφή (για σελίδες περιεχομένου) έχει αντίστοιχη μεταπήδηση. Η μεταπήδηση μπορεί να είναι σχετική, όπως αυτή η (τρέχουσα) σελίδα ή η επόμενη σελίδα, ή απόλυτη, καθορίζοντας οποιαδήποτε από τις σελίδες του μαθήματος.';
$string['jumpsto'] = 'Μεταπήδηση σε <em>{$a}</em>';
$string['leftduringtimed'] = 'Αποχωρήσατε κατά τη διάρκεια χρονομετρημένης διδασκαλίας. <br />Παρακαλούμε, πατήστε Συνέχεια για να επανεκκινήσετε την διδασκαλία.';
$string['leftduringtimednoretake'] = 'Αποχωρήσατε κατά τη διάρκεια χρονομετρημένης διδασκαλίας και <br />δεν έχετε το δικαίωμα να επαναλάβετε ή να συνεχίσετε την διδασκαλία.';
$string['leftduringtimedsession'] = 'Έχετε φύγει κατά τη διάρκεια μιας χρονομετρημένης διδασκαλίας.';
$string['lesson:addinstance'] = 'Προσθήκη μιας νέας διδασκαλίας';
$string['lesson:edit'] = 'Επεξεργασία μιας δραστηριότητας διδασκαλίας';
$string['lesson:grade'] = 'Βαθμολόγηση ερωτήσεων έκθεσης της διδασκαλίας';
$string['lesson:manage'] = 'Διαχείριση δραστηριότητας διδασκαλίας';
$string['lesson:manageoverrides'] = 'Διαχείριση παρακάμψεων διδασκαλίας';
$string['lesson:view'] = 'Εμφάνιση δραστηριότητας της διδασκαλίας';
$string['lesson:viewreports'] = 'Εμφάνιση αναφορών της διδασκαλίας';
$string['lessonclosed'] = 'Αυτή η διδασκαλία έκλεισε {$a}.';
$string['lessoncloses'] = 'Κλείσιμο διδασκαλίας';
$string['lessoncloseson'] = 'Η διδασκαλία κλείνει στις {$a}';
$string['lessoneventcloses'] = 'Λήγει {$a}';
$string['lessoneventopens'] = 'Ξεκινά {$a}';
$string['lessonformating'] = 'Μορφοποίηση διδασκαλίας';
$string['lessonmenu'] = 'Μενού διδασκαλίας';
$string['lessonname'] = 'Διδασκαλία: {$a}';
$string['lessonnotready'] = 'Η διδασκαλία δεν είναι έτοιμη για παρακολούθηση. Παρακαλούμε επικοινωνήστε με τον/την {$a} σας.';
$string['lessonnotready2'] = 'Αυτή η διδασκαλία δεν είναι έτοιμη για παρακολούθηση.';
$string['lessonopen'] = 'Αυτή η διδασκαλία θα είναι ανοιχτή στις {$a}.';
$string['lessonopens'] = 'Άνοιγμα διδασκαλίας';
$string['lessonpagelinkingbroken'] = 'Δεν βρέθηκε η πρώτη σελίδα. Η σύνδεση με τη σελίδα της διδασκαλίας μάλλον έχει διακοπεί. Παρακαλούμε επικοινωνήστε με έναν διαχειριστή.';
$string['lessonstats'] = 'Στατιστικά διδασκαλίας';
$string['linkedmedia'] = 'Συνδεδεμένα πολυμέσα';
$string['loginfail'] = 'Αποτυχημένη σύνδεση. Παρακαλούμε προσπαθήστε ξανά...';
$string['lowscore'] = 'Χαμηλό σκορ';
$string['lowtime'] = 'Χαμηλός χρόνος';
$string['manualgrading'] = 'Βαθμολόγηση εκθέσεων';
$string['matchesanswer'] = 'Ταιριάζει με την απάντηση';
$string['matching'] = 'Ταίριασμα';
$string['matchingpair'] = 'Ζεύγος αντιστοίχισης {$a}';
$string['maxgrade'] = 'Μέγιστος βαθμός';
$string['maxgrade_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο βαθμό για το μάθημα. Αν οριστεί το 0, το μάθημα δεν εμφανίζεται στις σελίδες των βαθμών.';
$string['maximumnumberofanswersbranches'] = 'Μέγιστος αριθμός απαντήσεων';
$string['maximumnumberofanswersbranches_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο αριθμό απαντήσεων που μπορούν να χρησιμοποιηθούν στη διδασκαλία. Εάν χρησιμοποιηθούν μόνο ερωτήσεις σωστού/λάθους, μπορεί να ρυθμιστεί σε 2. Η ρύθμιση μπορεί να αλλάξει ανά πάσα στιγμή, καθώς επηρεάζει μόνο αυτά που βλέπει ο διδάσκων και όχι τα δεδομένα.';
$string['maximumnumberofattempts'] = 'Μέγιστος αριθμός προσπαθειών ανά ερώτηση';
$string['maximumnumberofattempts_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο αριθμό επιτρεπόμενων προσπαθειών για κάθε ερώτηση. Εάν απαντηθεί εσφαλμένα επανειλημμένα, όταν συμπληρωθεί ο μέγιστος αυτός αριθμός, τότε εμφανίζεται η επόμενη σελίδα της διδασκαλίας.';
$string['maximumnumberofattemptsreached'] = 'Συμπληρώθηκε ο μέγιστος αριθμός προσπαθειών - Μετάβαση στην επόμενη σελίδα';
$string['mediaclose'] = 'Εμφάνιση κουμπιού εξόδου';
$string['mediafile'] = 'Συνδεδεμένα πολυμέσα';
$string['mediafile_help'] = 'Ένα αρχείο πολυμέσων μπορεί να ανεβεί για χρήση στη διδασκαλία. Ένας σύνδεσμος «Κάντε κλικ εδώ για εμφάνιση» θα εμφανίζεται κατόπιν σε ένα μπλοκ με όνομα «Συνδεδεμένα πολυμέσα» σε κάθε σελίδα της διδασκαλίας.';
$string['mediafilepopup'] = 'Πατήστε εδώ για εμφάνιση';
$string['mediaheight'] = 'Ύψος αναδυόμενου παραθύρου';
$string['mediawidth'] = 'Πλάτος αναδυόμενου παραθύρου';
$string['messageprovider:graded_essay'] = 'Ειδοποίηση βαθμολόγησης της έκθεσης';
$string['minimumnumberofquestions'] = 'Ελάχιστος αριθμός ερωτήσεων';
$string['minimumnumberofquestions_help'] = 'Αυτή η ρύθμιση καθορίζει τον ελάχιστο αριθμό ερωτήσεων που θα χρησιμοποιηθούν για να υπολογιστεί ο βαθμός για την δραστηριότητα.';
$string['missingname'] = 'Παρακαλούμε εισάγετε ένα ψευδώνυμο';
$string['modattempts'] = 'Να επιτρέπεται η ανασκόπηση από μαθητή';
$string['modattempts_help'] = 'Εάν ενεργοποιηθεί, οι μαθητές μπορούν να πλοηγηθούν ξανά στο μάθημα από την αρχή.';
$string['modattemptsnoteacher'] = 'Η ανασκόπηση από μαθητή δουλεύει μόνο για τους μαθητές';
$string['modulename'] = 'Διδασκαλία';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας διδασκαλίας επιτρέπει σε ένα διδάσκοντα να παρέχει δραστηριότητες περιεχομένου ή/και πρακτικής εξάσκησης με ενδιαφέροντες και ευέλικτους τρόπους. Ένας διδάσκοντας μπορεί να χρησιμοποιήσει το μάθημα για να δημιουργήσει ένα γραμμικό σύνολο σελίδων περιεχομένου ή εκπαιδευτικών δραστηριοτήτων που προσφέρουν μια ποικιλία μονοπατιών ή επιλογών για τον εκπαιδευόμενο. Και στις δύο περιπτώσεις, οι διδάσκοντες μπορούν να επιλέξουν να αυξήσουν την συμμετοχή και να εξασφαλίσουν την κατανόηση συμπεριλαμβάνοντας ποικίλες ερωτήσεις, π.χ. πολλαπλή επιλογή, αντιστοίχιση και σύντομη απάντηση. Ανάλογα με την επιλογή της απάντησης του μαθητή και τον τρόπο με τον οποίο ο διδάσκων αναπτύσσει τη διδασκαλία, οι μαθητές μπορούν να προωθηθούν στην επόμενη σελίδα, να επιστραφούν σε μια προηγούμενη σελίδα ή να ανακατευθυνθούν σε μια πλήρως διαφορετική διαδρομή. Μια διδασκαλία μπορεί να βαθμολογηθεί, με τον βαθμό να καταγράφεται στο βαθμολόγιο. Οι διδασκαλίες μπορούν να χρησιμοποιηθούν:

* Για αυτοκατευθυνόμενη εκμάθηση ενός νέου θέματος
* Για σενάρια ή προσομοιώσεις/ασκήσεις λήψης αποφάσεων
* Για διαφοροποιημένη επανάληψη, με διαφορετικά σετ ερωτήσεων επανάληψης ανάλογα με τις απαντήσεις που δίνονται σε ερωτήσεις αρχικά.';
$string['modulename_link'] = 'άρθρωμα/διδασκαλία/εμφάνιση';
$string['modulenameplural'] = 'Ενότητες';
$string['move'] = 'Μετακίνηση σελίδας';
$string['movedpage'] = 'Μεταφερθείσα σελίδα';
$string['movepagehere'] = 'Μεταφορά σελίδας εδώ';
$string['movepagenamed'] = 'Μετακίνηση σελίδας: {$a}';
$string['moving'] = 'Μεταφορά σελίδας: {$a}';
$string['multianswer'] = 'Πολλαπλής απάντησης';
$string['multianswer_help'] = 'Επιλέξτε το πλαίσιο ελέγχου αν περισσότερες από μία απόκρισεις είναι σωστές.';
$string['multichoice'] = 'Πολλαπλής επιλογής';
$string['multipleanswer'] = 'Πολλαπλή απάντηση';
$string['nameapproved'] = 'Το όνομα εγκρίθηκε';
$string['namereject'] = 'Συγγνώμη, το όνομά σας απορρίφθηκε από το φίλτρο.<br />Παρακαλούμε επιλέξτε κάποιο άλλο όνομα.';
$string['new'] = 'νέο';
$string['nextpage'] = 'Επόμενη σελίδα';
$string['noanswer'] = 'Καμία απάντηση δεν δόθηκε. Παρακαλούμε, πηγαίνετε πίσω και καταχωρήστε την απάντησή σας.';
$string['noattemptrecordsfound'] = 'Δεν βρέθηκαν προσπάθειες: δεν δόθηκε βαθμός';
$string['nobranchtablefound'] = 'Δεν βρέθηκε σελίδα περιεχομένου (Πίν. διακλ.)';
$string['noclose'] = 'Χωρίς ημερομηνία λήξης';
$string['nocommentyet'] = 'Κανένα σχόλιο ακόμα.';
$string['nocoursemods'] = 'Δεν βρέθηκε καμία δραστηριότητα';
$string['nocredit'] = 'Χωρίς βαθμό';
$string['nodeadline'] = 'Χωρίς προθεσμία';
$string['noessayquestionsfound'] = 'Δεν βρέθηκαν ερωτήσεις έκθεσης σε αυτή την διδασκαλία';
$string['nohighscores'] = 'Χωρίς υψηλά σκορ';
$string['nolessonattempts'] = 'Δεν πραγματοποιήθηκαν προσπάθειες σε αυτήν τη διδασκαλία.';
$string['nolessonattemptsgroup'] = 'Δεν έχουν γίνει προσπάθειες από {$a} μέλη της ομάδας σε αυτή τη διδασκαλία.';
$string['none'] = 'Κανένα';
$string['nooneansweredcorrectly'] = 'Κανένας δεν απάντησε σωστά.';
$string['nooneansweredthisquestion'] = 'Κανένας δεν απάντησε αυτή την ερώτηση.';
$string['noonecheckedthis'] = 'Κανένας δεν το επέλεξε αυτό.';
$string['nooneenteredthis'] = 'Κανένας δεν μπήκε σε αυτό.';
$string['noonehasanswered'] = 'Κανένας δεν απάντησε σε ερώτηση έκθεσης ακόμα.';
$string['noonehasansweredgroup'] = 'Κανείς στο {$a} δεν έχει απαντήσει ακόμα σε μια ερώτηση έκθεσης.';
$string['noopen'] = 'Χωρίς ημερομηνία έναρξης';
$string['nooverridedata'] = 'Πρέπει να παρακάμψετε τουλάχιστον μία από τις ρυθμίσεις της διδασκαλίας.';
$string['noretake'] = 'Δεν έχετε το δικαίωμα να επαναλάβετε αυτήν τη διδασκαλία.';
$string['normal'] = 'Κανονική πορεία - ακολουθήστε την πορεία της διδασκαλίας';
$string['notcompleted'] = 'Δεν ολοκληρώθηκε';
$string['notcompletedwithdate'] = 'Μη ολοκληρωμένο ({$a})';
$string['notdefined'] = 'Δεν καθορίστηκε';
$string['notenoughsubquestions'] = 'Δεν έχουν οριστεί αρκετά υποερωτήματα!<br />
Θέλετε να επιστρέψετε και να διορθώσετε αυτήν την ερώτηση;';
$string['notenoughtimespent'] = 'Ολοκληρώσατε αυτή τη διδασκαλία σε {$a->timespent}, το οποίο είναι μικρότερο από τον απαιτούμενο χρόνο: {$a->timerequired}. Ίσως χρειαστεί να προσπαθήσετε ξανά το μάθημα.';
$string['notgraded'] = 'Χωρίς βαθμό';
$string['notitle'] = 'Χωρίς τίτλο';
$string['notyetcompleted'] = 'Η διδασκαλία έχει ξεκινήσει, αλλά δεν έχει ολοκληρωθεί ακόμη';
$string['numberofcorrectanswers'] = 'Αριθμός σωστών απαντήσεων: {$a}';
$string['numberofcorrectanswersheader'] = 'Αριθμός σωστών απαντήσεων';
$string['numberofcorrectmatches'] = 'Αριθμός σωστών αντιστοιχιών: {$a}';
$string['numberofpagestoshow'] = 'Αριθμός σελίδων προς εμφάνιση';
$string['numberofpagestoshow_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό των σελίδων που εμφανίζονται σε μία διδασκαλία. Εφαρμόζεται μόνο σε διδασκαλίες με σελίδες που εμφανίζονται με τυχαία σειρά (όταν η «Ενέργεια μετά από σωστή απάντηση» είναι ορισμένη σε «Εμφάνισε μια σελίδα που δεν έχει ξαναεμφανιστεί» ή «Εμφάνισε μια σελίδα που δεν έχει ξανα-απαντηθεί». Αν οριστεί σε 0, τότε εμφανίζονται όλες οι σελίδες.';
$string['numberofpagesviewed'] = 'Αριθμός απαντημένων ερωτήσεων: {$a}';
$string['numberofpagesviewedheader'] = 'Αριθμός απαντημένων ερωτήσεων';
$string['numberofpagesviewednotice'] = 'Αριθμός απαντημένων ερωτήσεων: {$a->nquestions} (Πρέπει να απαντήσετε τουλάχιστον: {$a->minquestions})';
$string['numerical'] = 'Αριθμητικός';
$string['numericanswer'] = 'Αριθμητική απάντηση';
$string['numericanswer_help'] = 'Μπορείτε να καθορίσετε έναν μεμονωμένο αριθμό ή μια περιοχή αριθμών χρησιμοποιώντας άνω και κάτω τελεία. Για παράδειγμα, 2:5 σημαίνει ότι οποιαδήποτε απάντηση μεταξύ 2 και 5 συμπεριλαμβανομένων των 2 και 5 είναι σωστή.';
$string['offlinedatamessage'] = 'Έχετε εργαστεί σε αυτήν την προσπάθεια χρησιμοποιώντας μια κινητή συσκευή. Τα δεδομένα αποθηκεύτηκαν για τελευταία φορά σε αυτόν τον ιστότοπο {$a}. Ελέγξτε ότι δεν έχετε καμία μη αποθηκευμένη εργασία.';
$string['ongoing'] = 'Εμφάνιση τρέχοντος σκορ';
$string['ongoing_help'] = 'Εάν ενεργοποιηθεί, κάθε σελίδα θα εμφανίσει τους τρέχοντες βαθμούς του μαθητή από το σύνολο που είναι δυνατό μέχρι τώρα.';
$string['ongoingcustom'] = 'Έχετε πάρει {$a->score} από τους {$a->currenthigh} πόντους μέχρι τώρα.';
$string['ongoingnormal'] = 'Έχετε απαντήσει {$a->correct} σωστά από τις {$a->viewed} προσπάθειες.';
$string['onpostperpage'] = 'Μια ανάρτηση μόνο ανά βαθμό';
$string['openafterclose'] = 'Έχετε ορίσει ημερομηνία έναρξης μετά την ημερομηνία λήξης';
$string['options'] = 'Επιλογές';
$string['or'] = 'Ή';
$string['ordered'] = 'Ταξινομημένο';
$string['other'] = 'Άλλο';
$string['outof'] = 'Από τα {$a}';
$string['override'] = 'Παράκαμψη';
$string['overridedeletegroupsure'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την παράκαμψη για την ομάδα {$a};';
$string['overridedeleteusersure'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την παράκαμψη για τον χρήστη {$a};';
$string['overridegroup'] = 'Παράκαμψη ομάδας';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Παρακάμψεις';
$string['overrideuser'] = 'Παράκαμψη χρήστη';
$string['overrideusereventname'] = '{$a->lesson} - Παράκαμψη';
$string['overview'] = 'Επισκόπηση';
$string['overview_help'] = 'Ένα μάθημα αποτελείται από πολλές σελίδες και προαιρετικά από σελίδες περιεχομένου.
Μια σελίδα περιέχει κάποιο περιεχόμενο και συνήθως τελειώνει με μια ερώτηση.
Συσχετισμένη με κάθε απάντηση στην ερώτηση είναι μια μεταπήδηση.
Η μεταπήδηση μπορεί να είναι σχετική, όπως αυτή η (τρέχουσα) σελίδα ή η επόμενη σελίδα, ή απόλυτη, καθορίζοντας οποιαδήποτε από τις σελίδες του μαθήματος.
Μια σελίδα περιεχομένου είναι μια σελίδα που περιέχει ένα σύνολο συνδέσμων σε άλλες σελίδες του μαθήματος,
για παράδειγμα έναν Πίνακα περιεχομένων.';
$string['page'] = 'Σελίδα: {$a}';
$string['page-mod-lesson-edit'] = 'Επεξεργασία σελίδας διδασκαλίας';
$string['page-mod-lesson-view'] = 'Εμφάνιση ή προεπισκόπηση σελίδας διδασκαλίας';
$string['page-mod-lesson-x'] = 'Οποιαδήποτε σελίδα διδασκαλίας';
$string['pageanswers'] = 'Απαντήσεις σελίδας';
$string['pagecontents'] = 'Περιεχόμενα σελίδας';
$string['pageresponses'] = 'Αποκρίσεις σελίδας';
$string['pages'] = 'Σελίδες';
$string['pagetitle'] = 'Τίτλος σελίδας';
$string['password'] = 'Κωδικός πρόσβασης';
$string['passwordprotectedlesson'] = 'Η {$a} είναι μια προστατευμένη με κωδικό πρόσβασης διδασκαλία.';
$string['pleasecheckoneanswer'] = 'Παρακαλούμε, επιλέξτε μία απάντηση';
$string['pleasecheckoneormoreanswers'] = 'Παρακαλούμε, επιλέξτε μία ή περισσότερες απαντήσεις';
$string['pleaseenteryouranswerinthebox'] = 'Παρακαλούμε, εισάγετε την απάντησή σας στο πλαίσιο';
$string['pleasematchtheabovepairs'] = 'Παρακαλούμε, αντιστοιχίστε τα παραπάνω ζεύγη';
$string['pluginadministration'] = 'Διαχείριση της διδασκαλίας';
$string['pluginname'] = 'Διδασκαλία';
$string['pointsearned'] = 'Κερδισμένοι πόντοι';
$string['postprocesserror'] = 'Ένα σφάλμα συνέβη κατά την μετα-επεξεργασία!';
$string['postsuccess'] = 'Επιτυχής αποστολή';
$string['practice'] = 'Μάθημα για πρακτική (εξάσκηση)';
$string['practice_help'] = 'Μια διδασκαλία πρακτικής (εξάσκησης), δεν εμφανίζεται στο βαθμολόγιο.';
$string['preprocesserror'] = 'Ένα σφάλμα συνέβη κατά την προ-επεξεργασία!';
$string['prerequisiteisobsolete'] = 'Η προαπαιτούμενη επιλογή διδασκαλίας πρόκειται να αφαιρεθεί. Παρακαλούμε χρησιμοποιήστε τους περιορισμούς πρόσβασης.';
$string['prerequisitelesson'] = 'Προαπαιτούμενη διδασκαλία';
$string['preview'] = 'Προεπισκόπηση';
$string['previewlesson'] = 'Προεπισκόπηση {$a}';
$string['previewpagenamed'] = 'Σελίδα προεπισκόπησης: {$a}';
$string['previouspage'] = 'Προηγούμενη σελίδα';
$string['privacy:metadata:attempts'] = 'Ένα ιστορικό προσπαθειών μιας σελίδας';
$string['privacy:metadata:attempts:answerid'] = 'Το αναγνωριστικό απάντησης';
$string['privacy:metadata:attempts:correct'] = 'Εάν η προσπάθεια ήταν σωστή';
$string['privacy:metadata:attempts:pageid'] = 'Το αναγνωριστικό σελίδας';
$string['privacy:metadata:attempts:retry'] = 'Ο αριθμός προσπάθειας';
$string['privacy:metadata:attempts:timeseen'] = 'Η ώρα που έγινε η προσπάθεια';
$string['privacy:metadata:attempts:useranswer'] = 'Λεπτομέρειες σχετικά με την απάντηση του χρήστη';
$string['privacy:metadata:attempts:userid'] = 'Το αναγνωριστικό χρήστη';
$string['privacy:metadata:branch'] = 'Ένα αρχείο των προβαλλόμενων σελίδων';
$string['privacy:metadata:branch:flag'] = 'Εάν η επόμενη σελίδα υπολογίστηκε τυχαία';
$string['privacy:metadata:branch:nextpageid'] = 'Το αναγνωριστικό της επόμενης σελίδας';
$string['privacy:metadata:branch:pageid'] = 'Το αναγνωριστικό σελίδας';
$string['privacy:metadata:branch:retry'] = 'Ο αριθμός προσπάθειας';
$string['privacy:metadata:branch:timeseen'] = 'Η ώρα προβολής της σελίδας';
$string['privacy:metadata:branch:userid'] = 'Το αναγνωριστικό χρήστη';
$string['privacy:metadata:grades'] = 'Ένα αρχείο των βαθμών για κάθε μάθημα';
$string['privacy:metadata:grades:completed'] = 'Η ημερομηνία κατά την οποία δόθηκε ο βαθμός';
$string['privacy:metadata:grades:grade'] = 'Ο βαθμός που δόθηκε';
$string['privacy:metadata:grades:userid'] = 'Το αναγνωριστικό χρήστη';
$string['privacy:metadata:overrides'] = 'Ένα ιστορικό παρακάμψεων ανά μάθημα';
$string['privacy:metadata:overrides:available'] = 'Η ώρα που μπορεί να επιχειρηθεί το μάθημα';
$string['privacy:metadata:overrides:deadline'] = 'Η προθεσμία ολοκλήρωσης του μαθήματος.';
$string['privacy:metadata:overrides:maxattempts'] = 'Ο μέγιστος αριθμός προσπαθειών';
$string['privacy:metadata:overrides:password'] = 'Ο κωδικός για πρόσβαση στο μάθημα';
$string['privacy:metadata:overrides:retake'] = 'Εάν επιτρέπονται επαναλήψεις';
$string['privacy:metadata:overrides:review'] = 'Εάν επιτρέπεται επανάληψη μιας ερώτησης';
$string['privacy:metadata:overrides:timelimit'] = 'Χρονικό όριο ολοκλήρωσης του μαθήματος, σε δευτερόλεπτα.';
$string['privacy:metadata:overrides:userid'] = 'Το αναγνωριστικό χρήστη';
$string['privacy:metadata:timer'] = 'Ένα ιστορικό κάθε προσπάθειας του μαθήματος';
$string['privacy:metadata:timer:completed'] = 'Εάν η προσπάθεια είναι ολοκληρωμένη';
$string['privacy:metadata:timer:lessontime'] = 'Την τελευταία στιγμή που καταγράφηκε δραστηριότητα';
$string['privacy:metadata:timer:starttime'] = 'Η ημερομηνία έναρξης της προσπάθειας';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Την τελευταία στιγμή που καταγράφηκε δραστηριότητα από την εφαρμογή κινητού';
$string['privacy:metadata:timer:userid'] = 'Το αναγνωριστικό χρήστη';
$string['privacy:metadata:userpref:lessonview'] = 'Ο προτιμώμενος τρόπος εμφάνισης κατά την επεξεργασία μαθημάτων';
$string['privacy:path:essayanswers'] = 'Απαντήσεις έκθεσης';
$string['privacy:path:essayresponses'] = 'Αποκρίσεις έκθεσης';
$string['privacy:path:pages'] = 'Σελίδες';
$string['processerror'] = 'Ένα σφάλμα συνέβη κατά την επεξεργασία!';
$string['progressbar'] = 'Μπάρα προόδου';
$string['progressbar_help'] = 'Εάν ενεργοποιηθεί, μια μπάρα εμφανίζεται στο κάτω μέρος των σελίδων του μαθήματος παρουσιάζοντας το κατά προσέγγιση ποσοστό ολοκλήρωσης.';
$string['progressbarteacherwarning'] = 'Η μπάρα προόδου δεν εμφανίζεται για {$a}';
$string['progressbarteacherwarning2'] = 'Δεν θα δείτε την μπάρα προόδου γιατί μπορείτε να επεξεργαστείτε αυτή την διδασκαλία';
$string['progresscompleted'] = 'Έχετε ολοκληρώσει το {$a}% της διδασκαλίας';
$string['qtype'] = 'Τύπος σελίδας';
$string['question'] = 'Ερώτηση';
$string['questionoption'] = 'Ερώτηση';
$string['questiontype'] = 'Τύπος ερώτησης';
$string['randombranch'] = 'Σελίδα τυχαίου περιεχομένου';
$string['randompageinbranch'] = 'Τυχαία ερώτηση σε σελίδα περιεχομένου';
$string['rank'] = 'Κατάταξη';
$string['rawgrade'] = 'Βαθμός χωρίς επεξεργασία';
$string['receivedcredit'] = 'Λάβατε βαθμό';
$string['redisplaypage'] = 'Επανεμφάνιση σελίδας';
$string['removeallgroupoverrides'] = 'Διαγραφή όλων των παρακάμψεων ομάδας';
$string['removealluseroverrides'] = 'Διαγραφή όλων των παρακάμψεων χρήστη';
$string['report'] = 'Αναφορά';
$string['reports'] = 'Αναφορές';
$string['response'] = 'Απόκριση';
$string['retakesallowed'] = 'Επιτρέπονται οι επαναλήψεις της διδασκαλίας (πολλές προσπάθειες)';
$string['retakesallowed_help'] = 'Αν ενεργοποιηθεί, οι μαθητές μπορούν να ξαναπροσπαθήσουν (επαναλάβουν) τη διδασκαλία κι άλλες φορές.';
$string['returnto'] = 'Επιστροφή στο {$a}';
$string['returntocourse'] = 'Επιστροφή στο μάθημα';
$string['reverttodefaults'] = 'Επαναφορά στις προεπιλογές διδασκαλίας';
$string['review'] = 'Ανασκόπηση';
$string['reviewlesson'] = 'Ανασκόπηση της διδασκαλίας';
$string['reviewquestionback'] = 'Ναι, θα ήθελα να δοκιμάσω πάλι';
$string['reviewquestioncontinue'] = 'Όχι, θα ήθελα να πάω στην επόμενη ερώτηση';
$string['sanitycheckfailed'] = 'Αποτυχημένος έλεγχος λογικής ορθότητας: Αυτή η προσπάθεια έχει διαγραφεί';
$string['save'] = 'Αποθήκευση';
$string['savechanges'] = 'Αποθήκευση αλλαγών';
$string['savechangesandeol'] = 'Αποθήκευση των αλλαγών και μετάβαση στο τέλος της διδασκαλίας';
$string['saveoverrideandstay'] = 'Αποθήκευση και εισαγωγή κι άλλης παράκαμψης';
$string['savepage'] = 'Αποθήκευση σελίδας';
$string['score'] = 'Το σκορ';
$string['score_help'] = 'Το σκορ χρησιμοποιείται μόνο όταν είναι ενεργοποιημένη η προσαρμοσμένη βαθμολόγηση. Σε κάθε απάντηση μπορεί να δοθεί αριθμητική τιμή (θετική ή αρνητική).';
$string['scores'] = 'Τα σκορ';
$string['search:activity'] = 'Διδασκαλία - πληροφορίες δραστηριότητας';
$string['secondpluswrong'] = 'Όχι ακριβώς. Θέλετε να δοκιμάσετε ξανά;';
$string['selectallattempts'] = 'Επιλογή όλων των προσπαθειών';
$string['selectaqtype'] = 'Επιλέξτε τύπο ερωτήματος';
$string['sent'] = 'Στάλθηκε';
$string['shortanswer'] = 'Σύντομη απάντηση';
$string['showanunansweredpage'] = 'Εμφάνιση μιας μη απαντημένης σελίδας';
$string['showanunseenpage'] = 'Εμφάνιση μιας σελίδας που δεν έχει εμφανιστεί';
$string['singleanswer'] = 'Μίας απάντησης';
$string['skip'] = 'Παράληψη πλοήγησης';
$string['slideshow'] = 'Προβολή διαφανειών';
$string['slideshow_help'] = 'Εάν ενεργοποιηθεί, η διδασκαλία εμφανίζεται ως παρουσίαση διαφανειών, με σταθερό πλάτος και ύψος.';
$string['slideshowbgcolor'] = 'Χρώμα υπόβαθρου της προβολής διαφανειών';
$string['slideshowheight'] = 'Ύψος προβολής διαφανειών';
$string['slideshowwidth'] = 'Πλάτος προβολής διαφανειών';
$string['startlesson'] = 'Έναρξη διδασκαλίας';
$string['studentattemptlesson'] = 'Αριθμός προσπάθειας {$a->attempt} του χρήστη {$a->firstname} {$a->lastname}';
$string['studentname'] = '{$a} Όνομα';
$string['studentoneminwarning'] = 'Προσοχή: Έχετε ένα λεπτό ή λιγότερο για να τελειώσετε την διδασκαλία.';
$string['studentoutoftimeforreview'] = 'Προσοχή: Έληξε ο χρόνος για έλεγχο αυτού του μαθήματος';
$string['studentresponse'] = 'απόκριση του χρήστη {$a}';
$string['submit'] = 'Υποβολή';
$string['submitname'] = 'Καταχώρηση ονόματος';
$string['teacherjumpwarning'] = 'Μία μεταπήδηση {$a->cluster} ή μια μεταπήδηση {$a->unseen} χρησιμοποιείται σε αυτήν τη διδασκαλία. Η μεταπήδηση επόμενης σελίδας θα χρησιμοποιηθεί αντί αυτών. Συνδεθείτε ως μαθητής για να δοκιμάσετε αυτές τις μεταπηδήσεις.';
$string['teacherongoingwarning'] = 'Το τρέχον σκορ εμφανίζεται μόνο στον μαθητή. Συνδεθείτε ως μαθητής για να ελέγξετε το τρέχον σκορ.';
$string['teachertimerwarning'] = 'Το χρονόμετρο λειτουργεί μόνο για τους μαθητές. Συνδεθείτε ως μαθητής για να δοκιμάσετε το χρονόμετρο.';
$string['thatsthecorrectanswer'] = 'Αυτή είναι η σωστή απάντηση';
$string['thatsthewronganswer'] = 'Αυτή είναι η λάθος απάντηση';
$string['thefollowingpagesjumptothispage'] = 'Οι επόμενες σελίδες μεταπηδούν σε αυτήν';
$string['thispage'] = 'Αυτή η σελίδα';
$string['timeisup'] = 'Τέλος χρόνου';
$string['timelimit'] = 'Χρονικό όριο';
$string['timelimit_help'] = 'Εάν ενεργοποιηθεί, εμφανίζεται μια προειδοποίηση σχετικά με το χρονικό όριο στην αρχή του μαθήματος και εμφανίζεται ένα χρονόμετρο αντίστροφης μέτρησης. Οποιεσδήποτε απαντήσεις δίνονται μετά το πέρας του χρόνου δεν βαθμολογούνται.';
$string['timelimitwarning'] = 'Έχετε {$a} για να ολοκληρώσετε τη διδασκαλία';
$string['timeremaining'] = 'Χρόνος που απομένει';
$string['timespenterror'] = 'Πρέπει να αφιερώσετε τουλάχιστον {$a} λεπτά στην διδασκαλία';
$string['timespentminutes'] = 'Χρόνος που πέρασε (σε λεπτά)';
$string['timetaken'] = 'Χρόνος που χρειάστηκε';
$string['totalpagesviewedheader'] = 'Αριθμός σελίδων που εμφανίστηκαν';
$string['true'] = 'Σωστό';
$string['truefalse'] = 'Σωστό/λάθος';
$string['unabledtosavefile'] = 'Αδυναμία αποθήκευσης του αρχείου που ανεβάσατε';
$string['unknownqtypesnotimported'] = '{$a} ερωτήσεις με μη υποστηριζόμενους τύπους ερωτήσεων δεν εισήχθησαν';
$string['unseenpageinbranch'] = 'Ερώτηση που δεν εμφανίσθηκε, μέσα σε μια σελίδα περιεχομένου';
$string['unsupportedqtype'] = 'Μη υποστηριζόμενος τύπος ερώτησης ({$a})!';
$string['updatedpage'] = 'Ανανεωμένη σελίδα';
$string['updatefailed'] = 'Αποτυχία ενημέρωσης';
$string['updatepagenamed'] = 'Ενημέρωση σελίδας: {$a}';
$string['usemaximum'] = 'Χρήση μέγιστου';
$string['usemean'] = 'Χρήση μέσου όρου';
$string['usepassword'] = 'Η διδασκαλία προστατεύεται με κωδικό πρόσβασης';
$string['usepassword_help'] = 'Αν ενεργοποιηθεί, απαιτείται ένας κωδικός για την πρόσβαση στη διδασκαλία.';
$string['useroverrides'] = 'Παρακάμψεις χρήστη';
$string['useroverridesdeleted'] = 'Οι παρακάμψεις χρήστη διαγράφηκαν';
$string['usersnone'] = 'Κανένας μαθητής δεν έχει πρόσβαση σε αυτή τη διδασκαλία';
$string['viewessayanswers'] = 'Δείτε τις απαντήσεις στην έκθεση';
$string['viewgrades'] = 'Εμφάνιση βαθμών';
$string['viewreports'] = 'Εμφάνιση {$a->attempts} ολοκληρωμένων προσπαθειών του χρήστη {$a->student}';
$string['viewreports2'] = 'Εμφάνιση των {$a} ολοκληρωμένων προσπαθειών';
$string['warning'] = 'Προειδοποίηση';
$string['welldone'] = 'Μπράβο!';
$string['whatdofirst'] = 'Τι θα θέλατε να κάνετε πρώτα;';
$string['withselectedattempts'] = 'Με τις επιλεγμένες προσπάθειες...';
$string['wronganswerjump'] = 'Μεταπήδηση λανθασμένης απάντησης';
$string['wronganswerscore'] = 'Σκορ λανθασμένης απάντησης';
$string['wrongresponse'] = 'Λανθασμένη απόκριση';
$string['xattempts'] = '{$a} προσπάθειες';
$string['youhaveseen'] = 'Έχετε δει περισσότερες από μία σελίδες αυτής της διδασκαλίας.<br />Θέλετε να ξεκινήσετε από την τελευταία σελίδα που είδατε;';
$string['youranswer'] = 'Η απάντησή σας';
$string['yourcurrentgradeis'] = 'Ο τρέχων βαθμός σας είναι {$a}';
$string['yourcurrentgradeisoutof'] = 'Ο τρέχον βαθμός σας είναι {$a->grade} στα {$a->total}';
$string['youshouldview'] = 'Πρέπει να απαντήσετε τουλάχιστον: {$a}';
