<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'ru', version '3.10'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aggregategrades'] = 'Пересчет оценок';
$string['aggregation'] = 'Расчет итоговой оценки';
$string['allocate'] = 'Распределение работ';
$string['allocatedetails'] = 'ожидалось: {$a->expected}<br />представлено: {$a->submitted}<br />не размещено: {$a->allocate}';
$string['allocation'] = 'Распределение работ';
$string['allocationconfigured'] = 'Распределение настроено';
$string['allocationdone'] = 'Распределение выполнено';
$string['allocationerror'] = 'Ошибка распределения';
$string['allowedfiletypesforoverallfeedback'] = 'Разрешенные типы файлов, прикрепляемых к отзыву';
$string['allowedfiletypesforoverallfeedback_help'] = 'Разрешенные типы файлов, прикрепляемых к отзыву, можно ограничить, задав список разрешенных типов файлов. Если поле оставлено пустым, то разрешены любые типы файлов.';
$string['allowedfiletypesforsubmission'] = 'Разрешенные типы файлов, прикрепляемых к ответу';
$string['allowedfiletypesforsubmission_help'] = 'Разрешенные типы файлов, прикрепляемых к ответу, можно ограничить,  задав список разрешенных типов файлов. Если поле оставлено пустым, то разрешены любые типы файлов.';
$string['allsubmissions'] = 'Все работы ({$a})';
$string['alreadygraded'] = 'Уже оценено';
$string['areaconclusion'] = 'Текст заключения';
$string['areainstructauthors'] = 'Инструкции для работы';
$string['areainstructreviewers'] = 'Инструкции по оценке';
$string['areaoverallfeedbackattachment'] = 'Вложения общего отзыва';
$string['areaoverallfeedbackcontent'] = 'Тексты общего отзыва';
$string['areasubmissionattachment'] = 'Приложения к работе';
$string['areasubmissioncontent'] = 'Текст работы';
$string['assess'] = 'Оценить';
$string['assessedexample'] = 'Оцененный пример работы';
$string['assessedsubmission'] = 'Оцененная работа';
$string['assessingexample'] = 'Оценка примера работы';
$string['assessingsubmission'] = 'Оценка работы';
$string['assessment'] = 'Оценка';
$string['assessmentby'] = 'от <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Оценка от {$a}';
$string['assessmentbyyourself'] = 'Самооценка';
$string['assessmentdeleted'] = 'Оценивание удалено';
$string['assessmentend'] = 'Конец оценивания';
$string['assessmentendbeforestart'] = 'Окончание оценивания не может быть указано раньше даты начала оценивания.';
$string['assessmentenddatetime'] = 'Срок оценивания:{$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} (конец оценивания)';
$string['assessmentform'] = 'Форма оценки';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Оценить</a>  <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Рекомендуемая оценка';
$string['assessmentreferenceconflict'] = 'Не доступен пример работы для оценивания которого Вы предоставили ссылку.';
$string['assessmentreferenceneeded'] = 'Вы должны оценить этот пример работы близко к рекомендуемой оценке. Нажмите кнопку «Продолжить» для оценки работы.';
$string['assessments'] = 'Оценки';
$string['assessmentsettings'] = 'Параметры оценки';
$string['assessmentstart'] = 'Начало оценивания';
$string['assessmentstartdatetime'] = 'Открыто для оценивания с: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} (открывается для оценивания)';
$string['assessmentweight'] = 'Вес оценки';
$string['assignedassessments'] = 'Работы, представленные для оценивания';
$string['assignedassessmentsnone'] = 'Нет работ, представленных для оценивания';
$string['backtoeditform'] = 'Вернуться к редактированию формы';
$string['byfullname'] = 'от <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'от {$a}';
$string['calculategradinggrades'] = 'Вычислить баллы за оценивание';
$string['calculategradinggradesdetails'] = 'ожидалось: {$a->expected}<br />вычислено: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Вычислить оценки за работы';
$string['calculatesubmissiongradesdetails'] = 'ожидалось: {$a->expected}<br />вычислено: {$a->calculated}';
$string['chooseuser'] = 'Выберите пользователя...';
$string['clearaggregatedgrades'] = 'Очистить все итоговые оценки';
$string['clearaggregatedgrades_help'] = 'Итоговые оценки за работы и баллы за оценивание будут очищены. Вы можете снова пересчитать эти оценки с нуля в фазе Оценивание оценок.';
$string['clearaggregatedgradesconfirm'] = 'Вы действительно хотите очистить вычисленные оценки за работы и баллы за оценивание?';
$string['clearassessments'] = 'Очистить оценки';
$string['clearassessments_help'] = 'Вычисленные оценки за работы и баллы за оценивание будут очищены. Информация в форме оценки будет сохранена, но все рецензенты должны снова открыть форму оценки и заново сохранить оценки для получения вычисленной оценки.';
$string['clearassessmentsconfirm'] = 'Вы уверены, что хотите удалить все баллы за оценивание? Вы не сможете вернуть свои собственные оценки, а рецензенты должны будут заново оценить размещенные работы.';
$string['conclusion'] = 'Заключение';
$string['conclusion_help'] = 'Текст заключения отображается участникам в конце семинара.';
$string['configexamplesmode'] = 'Режим по умолчанию оценки примеров в семинарах';
$string['configgrade'] = 'Максимальная оценка по умолчанию для работ в семинарах';
$string['configgradedecimals'] = 'Количество десятичных цифр после запятой по умолчанию при отображении оценок.';
$string['configgradinggrade'] = 'Максимальная оценка по умолчанию для оценок в семинарах';
$string['configmaxbytes'] = 'По умолчанию максимальный размер представляемого файла для всех семинаров на сайте (соотносится с установленным в курсе ограничением и с другими локальными установками).';
$string['configstrategy'] = 'Стратегия оценки по умолчанию для семинаров.';
$string['createsubmission'] = 'Представить работу';
$string['crontask'] = 'Фоновая обработка для семинара';
$string['daysago'] = 'Прошло дней - {$a}';
$string['daysleft'] = 'Осталось дней - {$a}';
$string['daystoday'] = 'сегодня';
$string['daystomorrow'] = 'завтра';
$string['daysyesterday'] = 'вчера';
$string['deadlinesignored'] = 'Ограничение времени к Вам не относятся';
$string['deletesubmission'] = 'Удалить ответ';
$string['editassessmentform'] = 'Редактировать форму оценки';
$string['editassessmentformstrategy'] = 'Редактировать форму оценки ({$a})';
$string['editingassessmentform'] = 'Редактирование формы оценки';
$string['editingsubmission'] = 'Редактирование работы';
$string['editsubmission'] = 'Редактировать работу';
$string['err_multiplesubmissions'] = 'При редактировании этой формы был сохранен еще один вариант работы. Несколько представленных работ одного пользователя не допускается.';
$string['err_removegrademappings'] = 'Не удалось удалить сопоставления неиспользованных оценок';
$string['evaluategradeswait'] = 'Пожалуйста, подождите, пока вычисляются оценки и баллы за оценивание';
$string['evaluation'] = 'Оценивание оценок';
$string['evaluationmethod'] = 'Метод оценивания оценок';
$string['evaluationmethod_help'] = 'Метод оценивания оценок определяет, как вычисляются баллы за оценивание. Вы можете позволить неоднократно пересчитывать баллы с различными настройками, пока не получите приемлемый результат.';
$string['evaluationsettings'] = 'Параметры оценки';
$string['eventassessableuploaded'] = 'Работа была загружена';
$string['eventassessmentevaluated'] = 'Оценка вычислена';
$string['eventassessmentevaluationsreset'] = 'Сброшено вычисление оценки';
$string['eventassessmentreevaluated'] = 'Оценка переопределена';
$string['eventphaseswitched'] = 'Фаза переключена';
$string['eventsubmissionassessed'] = 'Работа оценена';
$string['eventsubmissionassessmentsreset'] = 'Оценки работы очищены';
$string['eventsubmissioncreated'] = 'Представление работы создано';
$string['eventsubmissiondeleted'] = 'Ответ удален';
$string['eventsubmissionreassessed'] = 'Работа переоценена';
$string['eventsubmissionupdated'] = 'Работа обновлена';
$string['eventsubmissionviewed'] = 'Работа просмотрена';
$string['example'] = 'Пример работы';
$string['exampleadd'] = 'Добавить пример работы';
$string['exampleassess'] = 'Оценить пример работы';
$string['exampleassessments'] = 'Пример работы для оценки';
$string['exampleassesstask'] = 'Оценить примеры';
$string['exampleassesstaskdetails'] = 'ожидалось: {$a->expected}<br />оценено: {$a->assessed}';
$string['examplecomparing'] = 'Сравнение оценок примера работы';
$string['exampledelete'] = 'Удалить пример';
$string['exampledeleteconfirm'] = 'Вы действительно хотите удалить следующий пример работы? Нажмите кнопку «Продолжить» для удаления работы.';
$string['exampleedit'] = 'Редактировать пример';
$string['exampleediting'] = 'Редактирование примера';
$string['exampleneedassessed'] = 'Сначала Вы должны оценить все представленные примеры';
$string['exampleneedsubmission'] = 'Сначала Вы должны представить свою работу и оценить все представленные примеры';
$string['examplesbeforeassessment'] = 'Примеры должны быть оценены до оценивания работ сокурсников.';
$string['examplesbeforesubmission'] = 'Необходимо оценить примеры до представления собственной работы';
$string['examplesmode'] = 'Режим оценки примеров';
$string['examplesubmissions'] = 'Примеры работ';
$string['examplesvoluntary'] = 'Добровольная оценка примера работы';
$string['exportsubmission'] = 'Экспорт этой страницы';
$string['feedbackauthor'] = 'Отзыв для автора';
$string['feedbackauthorattachment'] = 'Приложение';
$string['feedbackby'] = 'Отзыв на {$a}';
$string['feedbackreviewer'] = 'Отзыв для рецензента';
$string['feedbacksettings'] = 'Отзыв';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Данные оценки';
$string['grade_grading_name'] = 'Оценка';
$string['grade_submission_name'] = 'Представленная работа';
$string['gradecalculated'] = 'Вычисленная оценка за работу';
$string['gradedecimals'] = 'Десятичных знаков в оценках';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Оценка: {$a->received} из {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (оценка)';
$string['gradeitemsubmission'] = '{$a->workshopname} (работа)';
$string['gradeover'] = 'Переопределить оценку за работу';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Отчет об оценках семинара';
$string['gradetopassgrading'] = 'Проходной балл за оценивание';
$string['gradetopasssubmission'] = 'Проходной балл за отправленный ответ';
$string['gradinggrade'] = 'Оценка за оценивание';
$string['gradinggrade_help'] = 'Этот параметр определяет максимальную оценку, которая может быть получена за оценивание работы.';
$string['gradinggradecalculated'] = 'Вычисленная оценка за оценивание';
$string['gradinggradeof'] = 'Баллы за оценивание (из {$a})';
$string['gradinggradeover'] = 'Переопределить баллы за оценивание';
$string['gradingsettings'] = 'Параметры оценивания';
$string['groupnoallowed'] = 'Вы не можете получить доступ к любой группе в этом семинаре';
$string['iamsure'] = 'Да, я уверен(а)';
$string['indicator:cognitivedepth'] = 'Семинар: познавательный аспект';
$string['indicator:cognitivedepth_help'] = 'Этот показатель основан на глубине познания, достигнутой студентом при работе с элементом курса «Семинар».';
$string['indicator:cognitivedepthdef'] = 'Семинар: познавательный аспект';
$string['indicator:cognitivedepthdef_help'] = 'Участник достиг этого процента познавательного взаимодействия, предлагаемого элементом курса «Семинар» в течение этого интервала анализа (Уровни = Нет просмотра, Просмотр, Отправка, Просмотр отзыва, Комментарий на отзыв, Повторная отправка после просмотра отзыва)';
$string['indicator:socialbreadth'] = 'Семинар: социальный аспект';
$string['indicator:socialbreadth_help'] = 'Этот показатель основан на широте общения, которая может быть достигнута студентом при работе с элементом Семинар.';
$string['indicator:socialbreadthdef'] = 'Семинар: социальный аспект';
$string['indicator:socialbreadthdef_help'] = 'Участник достиг этого процента социальной активности, предлагаемой элементами Семинар в течение этого интервала анализа (Уровни = нет участия, единственный участник, участник с другими)';
$string['info'] = 'Информация';
$string['instructauthors'] = 'Инструкции для работы';
$string['instructreviewers'] = 'Инструкции по оценке';
$string['introduction'] = 'Введение';
$string['latesubmissions'] = 'Работы, отправленные с опозданием';
$string['latesubmissions_desc'] = 'Разрешить представление работ после крайнего срока';
$string['latesubmissions_help'] = 'Если параметр включен, то автор может представить свою работу после истечения срока представления или в фазе оценки. Работы, отправленные с опозданием, уже нельзя будет изменить.';
$string['latesubmissionsallowed'] = 'Разрешить работы, отправленные с опозданием';
$string['legacyallocationplugincron'] = 'Устаревшее распределение работ семинара (cron)';
$string['maxbytes'] = 'Максимальный размер вложенного файла';
$string['modulename'] = 'Семинар';
$string['modulename_help'] = 'Модуль «Семинар» позволяет накапливать, просматривать, рецензировать и взаимно оценивать студенческие работы.

Студенты могут представлять свою работу в виде любых файлов, например, документы Word и электронные таблицы, а также могут вводить текст непосредственно в поле с помощью текстового редактора.

Материалы оцениваются с использованием нескольких критериев формы оценки, заданной преподавателем. Процесс оценки сокурсников и понимание формы оценки может быть осуществлено заранее с примером материалов, представленных преподавателем, вместе со ссылкой для оценивания. Студентам предоставляется возможность оценить одно или несколько представлений своих сокурсников. Представляемые работы и рецензии могут быть анонимными, если требуется.

Студенты получают две оценки за семинар - оценку за свою работу и баллы за свою оценку работ своих сокурсников. Оба типа записываются в журнал оценок.';
$string['modulenameplural'] = 'Семинары';
$string['myassessments'] = 'Мои оценки';
$string['mysubmission'] = 'Моя работа';
$string['nattachments'] = 'Максимальное количество приложений к работе';
$string['noexamples'] = 'В этом семинаре еще нет примеров';
$string['noexamplesformready'] = 'Вы должны определить форму оценки, прежде чем предоставлять пример работы';
$string['nogradeyet'] = 'Еще не оценено';
$string['nosubmissionfound'] = 'Не найдено работ этого пользователя';
$string['nosubmissions'] = 'На этом семинаре еще не представлено ни одной работы';
$string['nosubmissiontype'] = 'Должен быть доступен хотя бы один тип представления работ';
$string['notassessed'] = 'Еще не оцененные';
$string['nothingfound'] = 'Нечего показывать';
$string['nothingtoreview'] = 'Нечего рассматривать';
$string['notoverridden'] = 'Не переопределено';
$string['noworkshops'] = 'В этом курсе нет семинаров';
$string['noyoursubmission'] = 'Вы еще не отправили свою работу';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Общий отзыв';
$string['overallfeedbackfiles'] = 'Максимальное количество вложений общего отзыва';
$string['overallfeedbackmaxbytes'] = 'Максимальный размер вложения общего отзыва';
$string['overallfeedbackmode'] = 'Режим общего отзыва';
$string['overallfeedbackmode_0'] = 'Отключен';
$string['overallfeedbackmode_1'] = 'Включен (дополнительный)';
$string['overallfeedbackmode_2'] = 'Включен (обязательный)';
$string['overallfeedbackmode_help'] = 'При включенном параметре внизу формы оценивания отображается текстовое поле. Там рецензенты могут написать общий отзыв к работе или предоставить дополнительные пояснения своей оценки.';
$string['page-mod-workshop-x'] = 'Любая страница модуля Семинар';
$string['participant'] = 'Участник';
$string['participantrevierof'] = 'Рецензируемые участником:';
$string['participantreviewedby'] = 'Рецензенты участника:';
$string['phaseassessment'] = 'Фаза оценивания';
$string['phaseclosed'] = 'Закрыто';
$string['phaseevaluation'] = 'Фаза оценивания оценок';
$string['phasesetup'] = 'Фаза настройки';
$string['phasesoverlap'] = 'Фаза представления и фаза оценки не могут перекрываться';
$string['phasesubmission'] = 'Фаза представления работ';
$string['pluginadministration'] = 'Управление семинаром';
$string['pluginname'] = 'Семинар';
$string['prepareexamples'] = 'Подготовить примеры работ';
$string['previewassessmentform'] = 'Предварительный просмотр';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Суммарная оценка за оценивание пользователем всех работ семинара.';
$string['privacy:metadata:assessmentgrade'] = 'Общая оценка за представленную работу и за оценивание';
$string['privacy:metadata:assessmentgradinggrade'] = 'Баллы за оценивание';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Переопределенное вручную значение баллов за оценивание';
$string['privacy:metadata:assessmentid'] = 'ID оценки';
$string['privacy:metadata:authorid'] = 'ID автора работы';
$string['privacy:metadata:dimensiongrade'] = 'Оценка за данный параметр оценки';
$string['privacy:metadata:dimensionid'] = 'ID параметра оценки';
$string['privacy:metadata:example'] = 'Является ли эта запись примером представления работы';
$string['privacy:metadata:feedbackauthor'] = 'Отзыв для автора';
$string['privacy:metadata:feedbackauthorformat'] = 'Текстовый формат отзыва для автора';
$string['privacy:metadata:feedbackreviewer'] = 'Отзыв для пользователя, проводящего оценивание';
$string['privacy:metadata:feedbackreviewerformat'] = 'Текстовый формат отзыва для пользователя, проводящего оценивание';
$string['privacy:metadata:late'] = 'Было ли представление работы отправлено после установленного срока';
$string['privacy:metadata:peercomment'] = 'Комментарий к выставленной оценке от пользователя, который поставил оценку';
$string['privacy:metadata:peercommentformat'] = 'Текстовый формат комментария к данной оценке';
$string['privacy:metadata:preference:perpage'] = 'Количество представленных работ, которые пользователь предпочитает видеть на одной странице';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Пример представленной работы».';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Отчет о представленных работах семинара».';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Форма оценки».';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Работы, назначенные для оценивания».';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Оценка за семинар».';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Заключение».';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Пример работы для оценивания».';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Пример работы для оценивания».';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Отчет об оценках семинара».';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Инструкции по представлению работ».';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Инструкции по оцениванию».';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Введение».';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Общий отзыв».';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Ваша представленная работа».';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Опубликованные работы».';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Свернутое/развернутое состояние для вьюлета «Ваши оценки».';
$string['privacy:metadata:published'] = 'Следует ли публиковать представленные работы для всех участников после закрытия семинара';
$string['privacy:metadata:reviewerid'] = 'ID пользователя, поставившего оценку';
$string['privacy:metadata:strategy'] = 'Имя плагина стратегии оценивания, интерпретирующего значения записи';
$string['privacy:metadata:submissioncontent'] = 'Содержимое представленной работы';
$string['privacy:metadata:submissioncontentformat'] = 'Текстовый формат содержимого представленной работы';
$string['privacy:metadata:submissiongrade'] = 'Обобщенная оценка за представленную работу в виде десятичного числа из интервала 0...100.';
$string['privacy:metadata:submissiongradeover'] = 'Значение обобщенной оценки, переопределенное вручную';
$string['privacy:metadata:submissionid'] = 'ID представленной работы';
$string['privacy:metadata:submissiontitle'] = 'Название представленной работы';
$string['privacy:metadata:subsystem:corefiles'] = 'Модуль Семинар хранит файлы, прикрепленные к тексту ответа.';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'В модуль Семинар встроена поддержка систем предотвращения плагиата.';
$string['privacy:metadata:timeaggregated'] = 'Когда последний раз рассчитывалась обобщенная оценка';
$string['privacy:metadata:timecreated'] = 'Когда эта запись была создана в базе данных';
$string['privacy:metadata:timemodified'] = 'Когда эта запись была в последний раз изменена в базе данных';
$string['privacy:metadata:userid'] = 'ID пользователя, для которого рассчитывается обобщенная оценка';
$string['privacy:metadata:weight'] = 'Вес оценки';
$string['privacy:metadata:workshopaggregations'] = 'Содержит обобщенные оценки за оценивание';
$string['privacy:metadata:workshopassessments'] = 'Содержит информацию о распределенных оценках представленных работ семинара';
$string['privacy:metadata:workshopgrades'] = 'Содержит информацию о том, как формы оценивания были заполнены оценками и комментариями.';
$string['privacy:metadata:workshopid'] = 'ID семинара';
$string['privacy:metadata:workshopsubmissions'] = 'Содержит информацию о поданных работах семинара';
$string['privacy:request:delete:content'] = 'Контент был удален (по запросу пользователя или срок его действия истек)';
$string['privacy:request:delete:title'] = '[Удалено]';
$string['publishedsubmissions'] = 'Опубликованные работы';
$string['publishsubmission'] = 'Публикация работы';
$string['publishsubmission_help'] = 'Опубликованные работы доступны другим после завершения семинара.';
$string['reassess'] = 'Переоценить';
$string['receivedgrades'] = 'Полученные оценки';
$string['recentassessments'] = 'Оценки семинара:';
$string['recentsubmissions'] = 'Работы семинара:';
$string['resetassessments'] = 'Удалить все оценки';
$string['resetassessments_help'] = 'Вы можете выбрать для удаления только выделенные оценки, не затрагивая работы. Если работы должны быть удалены, то их оценки будут удалены безоговорочно и этот параметр игнорируется. Учтите, это также распространяется и на оценки примеров работ.';
$string['resetphase'] = 'Переключить в фазу настройки';
$string['resetphase_help'] = 'При включенном параметре все семинары будут приведены в начальную фазу настройки.';
$string['resetsubmissions'] = 'Удалить все работы';
$string['resetsubmissions_help'] = 'Все работы и их оценки будут удалены. Это не влияет на примеры работ.';
$string['saveandclose'] = 'Сохранить и закрыть';
$string['saveandcontinue'] = 'Сохранить и продолжить редактирование';
$string['saveandpreview'] = 'Сохранить и посмотреть';
$string['saveandshownext'] = 'Сохранить и показать следующее';
$string['search:activity'] = 'Семинар — информация об элементе курса';
$string['selfassessmentdisabled'] = 'Самооценка отключена';
$string['showingperpage'] = 'Элементов на странице - {$a}';
$string['showingperpagechange'] = 'Изменить ...';
$string['someuserswosubmission'] = 'Есть по меньшей мере один автор, который еще не представил свою работу';
$string['sortasc'] = 'Сортировать по возрастанию';
$string['sortdesc'] = 'Сортировать по убыванию';
$string['strategy'] = 'Стратегия оценивания';
$string['strategy_help'] = 'Стратегия оценки определяет используемую форму оценивания и методы оценивания работ.
Есть 4 варианта:

* Совокупная оценка - оценивается и комментируется соответствие заданным критериям
* Комментарии - комментируется соответствие заданным критериям, но оценка не может быть выставлена
* Количество ошибок - комментируется и оценивается (да/нет) соответствие заданным утверждениям
* Рубрика - оценивается соответствие одному заданному критерию';
$string['strategyhaschanged'] = 'Стратегия оценивания семинара изменилась, так как форма была открыта для редактирования.';
$string['submission'] = 'Работа';
$string['submissionattachment'] = 'Приложение';
$string['submissionby'] = 'Работа {$a}';
$string['submissioncontent'] = 'Содержимое работы';
$string['submissiondeleteconfirm'] = 'Вы уверены, что хотите удалить этот ответ?';
$string['submissiondeleteconfirmassess'] = 'Вы уверены, что хотите удалить этот ответ? Обратите внимание, что это также приведет к удалению {$a->count} оценок, связанных с этим ответом, что может повлиять на оценки рецензентов.';
$string['submissionend'] = 'Конец представления работ';
$string['submissionendbeforestart'] = 'Окончание срока подачи работ не может быть установлено ранее даты начала.';
$string['submissionenddatetime'] = 'Конец представления работ: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} (Окончание срока подачи работ)';
$string['submissionendswitch'] = 'Переключить на следующий этап после истечения срока подачи работ.';
$string['submissionendswitch_help'] = 'Если задано окончание срока подачи работ и установлен этот флажок, то семинар будет автоматически переключаться на этап оценивания после истечения срока подачи работ.

Если эта функция включена, то также рекомендуется задать метод планируемого распределения. Если работы не распределяются, то оценивание не может быть проведено, даже если сам семинар находится в стадии оценивания.';
$string['submissiongrade'] = 'Оценка за работу';
$string['submissiongrade_help'] = 'Этот параметр определяет максимальную оценку, которая может быть получена за представленные работы.';
$string['submissiongradeof'] = 'Оценка за работу (из {$a})';
$string['submissionlastmodified'] = 'Последнее изменение';
$string['submissionrequiredcontent'] = 'Вам нужно ввести текст или присоединить файл.';
$string['submissionrequiredfile'] = 'Вам нужно присоединить файл или ввести текст.';
$string['submissionsettings'] = 'Параметры работы';
$string['submissionsreport'] = 'Отчет об отправке ответов на семинар';
$string['submissionstart'] = 'Начало представления работ';
$string['submissionstartdatetime'] = 'Начало представления работ: {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} (открывается для подачи работ)';
$string['submissiontitle'] = 'Название';
$string['submissiontypedisabled'] = 'Этот тип представления работы отключен для этого семинара.';
$string['submissiontypefileavailable'] = 'Вложение файла <span class="accesshide">разрешено</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Вложение файла </span>Обязательно';
$string['submissiontypes'] = 'Типы представления работы';
$string['submissiontypetextavailable'] = 'Текст <span class="accesshide"> разрешен</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Текст</span>Обязателен';
$string['submittednotsubmitted'] = 'Отправлено ({$a->submitted}) / не отправлено ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Метод распределения работ';
$string['subplugintype_workshopallocation_plural'] = 'Методы распределения работ';
$string['subplugintype_workshopeval'] = 'Метод выставления баллов за оценивание';
$string['subplugintype_workshopeval_plural'] = 'Методы выставления баллов за оценивание';
$string['subplugintype_workshopform'] = 'Стратегия оценивания';
$string['subplugintype_workshopform_plural'] = 'Стратегии оценивания';
$string['switchingphase'] = 'Переключение фазы';
$string['switchphase'] = 'Переключить фазу';
$string['switchphase10'] = 'Переключиться на фазу настройки';
$string['switchphase10info'] = 'Вы собираетесь переключить семинар в фазу <strong> «Настройка»</strong>. В этой фазе пользователи не могут изменять свои работы или оценки работ. Преподаватели могут использовать эту фазу для изменения настроек семинара, изменения стратегии оценивания и корректировки формы оценивания.';
$string['switchphase20'] = 'Переключиться на фазу подачи';
$string['switchphase20info'] = 'Вы собираетесь переключить семинар в фазу <strong> «Представление»</strong>. В этой фазе студенты могут представить свои работы (в течение срока для представления, если он задан). Преподаватели могут распределять работы для рецензирования сокурсниками.';
$string['switchphase30'] = 'Переключение к фазе оценивания';
$string['switchphase30auto'] = 'После {$a->daydatetime} ({$a->distanceday}) семинар будет автоматически переключаться в фазу оценивания';
$string['switchphase30info'] = 'Вы собираетесь переключить семинар в фазу<strong> «Оценивание»</strong>. В этой фазе рецензенты могут оценивать представленные работы (в течение срока для оценки, если он задан).';
$string['switchphase40'] = 'Переключение к фазе оценивания';
$string['switchphase40info'] = 'Вы собираетесь переключить семинар в фазу <strong> «Оценивание оценок»</strong>. В этой фазе пользователи не могут изменять свои работы и оценки работ. Преподаватели могут использовать инструменты оценивания оценок для расчета итоговых оценок и предоставлять отзывы для рецензентов.';
$string['switchphase50'] = 'Семинар окончен';
$string['switchphase50info'] = 'Вы собираетесь закрыть семинар. Это приведет к появлению вычисленных оценок в журнале оценок. Студенты смогут просматривать свои работы и их оценки.';
$string['switchphaseauto'] = 'Запланированное переключение';
$string['switchphasenext'] = 'Переключиться к следующей фазе';
$string['taskassesspeers'] = 'Оценки сокурсников';
$string['taskassesspeersdetails'] = 'итог: {$a->total}<br />ожидается: {$a->todo}';
$string['taskassessself'] = 'Самооценка';
$string['taskconclusion'] = 'Написать заключение для семинара';
$string['taskdone'] = 'Задача выполнена';
$string['taskfail'] = 'Задача не выполнена';
$string['taskinfo'] = 'Информация о задаче';
$string['taskinstructauthors'] = 'Предоставить инструкции для работы';
$string['taskinstructreviewers'] = 'Предоставить инструкции по оцениванию';
$string['taskintro'] = 'Задать введение для семинара';
$string['tasksubmit'] = 'Отправить работу';
$string['tasktodo'] = 'Задача к выполнению';
$string['toolbox'] = 'Инструменты семинара';
$string['undersetup'] = 'В настоящее время семинар настраивается. Пожалуйста, подождите, пока он перейдет в следующую фазу.';
$string['useexamples'] = 'Использовать примеры';
$string['useexamples_desc'] = 'Для тренировки в оценивании предоставляются примеры работ.';
$string['useexamples_help'] = 'Если параметр включен, то пользователи могут попробовать оценить один или несколько представленных примеров и сравнить свои оценки с рекомендуемыми оценками. Эти оценки не учитываются в оценке за оценивание.';
$string['usepeerassessment'] = 'Использовать оценки сокурсников';
$string['usepeerassessment_desc'] = 'Студенты могут оценивать другие работы';
$string['usepeerassessment_help'] = 'Если параметр включен, то пользователь может оценить работы, представленные другими сокурсниками, и получит баллы за оценивание в дополнение к оценке за собственную работу.';
$string['userdatecreated'] = 'представлено: <span>{$a}</span>';
$string['userdatemodified'] = 'изменено: <span>{$a}</span>';
$string['userplan'] = 'План семинара';
$string['userplan_help'] = 'План семинара отображает все его фазы и списки задач для каждой фазы. Текущая фаза будет выделена и завершенные задачи помечены галочкой.';
$string['userplanaccessibilityskip'] = 'Перейти к текущим задачам';
$string['userplanaccessibilitytitle'] = 'Сроки проведения семинара с фазами ({$a})';
$string['userplancurrentphase'] = 'Текущая фаза';
$string['useselfassessment'] = 'Использовать самооценки';
$string['useselfassessment_desc'] = 'Студенты могут оценивать свою собственную работу';
$string['useselfassessment_help'] = 'Если параметр включен, то
пользователь может оценить собственную работу и получит баллы за оценивание в дополнение к оценке за свою работу.';
$string['viewworkshopsummary'] = 'Посмотреть итоги семинара';
$string['weightinfo'] = 'Вес: {$a}';
$string['withoutsubmission'] = 'Рецензент без собственной работы';
$string['workshop:addinstance'] = 'Добавлять новый семинар';
$string['workshop:allocate'] = 'Размещать работы для рассмотрения';
$string['workshop:deletesubmissions'] = 'Удалять ответы';
$string['workshop:editdimensions'] = 'Редактировать форму оценки';
$string['workshop:exportsubmissions'] = 'Экспортировать ответы';
$string['workshop:ignoredeadlines'] = 'Игнорировать ограничения по времени';
$string['workshop:manageexamples'] = 'Управлять примерами работ';
$string['workshop:overridegrades'] = 'Переопределять вычисленные оценки';
$string['workshop:peerassess'] = 'Оценивать сокурсников';
$string['workshop:publishsubmissions'] = 'Публиковать работы';
$string['workshop:submit'] = 'Представлять работы';
$string['workshop:switchphase'] = 'Переключать фазы';
$string['workshop:view'] = 'Просматривать семинар';
$string['workshop:viewallassessments'] = 'Просматривать все оценки';
$string['workshop:viewallsubmissions'] = 'Просматривать все работы';
$string['workshop:viewauthornames'] = 'Просматривать имена авторов';
$string['workshop:viewauthorpublished'] = 'Просматривать авторов опубликованных работ';
$string['workshop:viewpublishedsubmissions'] = 'Просматривать опубликованные работы';
$string['workshop:viewreviewernames'] = 'Просматривать имена рецензентов';
$string['workshopname'] = 'Название семинара';
$string['yourassessmentfor'] = 'Ваша оценка для {$a}';
$string['yourgrades'] = 'Ваши оценки';
$string['yoursubmission'] = 'Ваша работа';
