<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'ru', version '3.10'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Над';
$string['activitynavigationposition'] = 'Позиция активного элемента в навигации';
$string['activitynavigationpositiondesc'] = 'Выберите между «Выше» и «Ниже» для навигации по активным элементам. Если вы хотите использовать пользовательский CSS, используйте переключатель «#activitynavigation».';
$string['advert_alttext'] = 'Оформление рекламного баннера темы. Уровень 1';
$string['advert_heading'] = 'Оформление уровня 1 темы';
$string['advert_tagline'] = 'Хотите знать, как настроить темы, но не сильны в сфере разработки, нет опыта работы с php и с темами Moodle? Тогда "Moodlebites Theme Design. 1-й уровень" для Вас! Вы получите введение в разработку темы Moodle. Вы получите хорошую базу для дальнейшего развития при желании. Нажмите здесь для получения дополнительной информации';
$string['aftercontent'] = 'После контента';
$string['alert1'] = 'Первое уведомление';
$string['alert2'] = 'Второе уведомление';
$string['alert3'] = 'Третье уведомление';
$string['alert_edit'] = 'Редактировать оповещения';
$string['alert_general'] = 'Объявление';
$string['alert_info'] = 'Информация';
$string['alert_warning'] = 'Предупреждение';
$string['alertinfodesc'] = 'Введите настройки для вашего уведомления.';
$string['alertsdesc'] = 'На главной странице сайта появится уведомление (или несколько) в трех различных стилях. Пожалуйста, не забудьте отключить их, когда они будут больше не нужны.';
$string['alertsheading'] = 'Уведомления пользователям';
$string['alertsheadingsub'] = 'Показать важные объявления для пользователей на главной странице';
$string['alerttext'] = 'Текст уведомления';
$string['alerttextdesc'] = 'Текст, который будет отображаться в вашем уведомлении.';
$string['alerttitle'] = 'Название';
$string['alerttitledesc'] = 'Главное название/заголовок для вашего уведомления';
$string['alerttype'] = 'Уровень';
$string['alerttypedesc'] = 'Установите соответствующий уровень/тип уведомления для лучшего информирования пользователей';
$string['allclasses'] = 'Все классы';
$string['allcourses'] = 'Все курсы';
$string['allmodules'] = 'Все модули';
$string['allunits'] = 'Все задания';
$string['alternativecolors'] = 'Альтернативная цветовая схема {$a}';
$string['alternativethemecolor'] = 'Альтернативный цвет темы {$a}';
$string['alternativethemecolordesc'] = 'Цвет темы, который будет использоваться в альтернативной цветовой схеме {$a}.';
$string['alternativethemecolorname'] = 'Название альтернативной цветовой схемы {$a}';
$string['alternativethemecolornamedesc'] = 'Задайте запоминающееся название для этого набора цветов альтернативной темы';
$string['alternativethemecolors'] = 'Альтернативные цветовые схемы';
$string['alternativethemecolorsdesc'] = 'Определяет альтернативные цвета темы, которые может выбрать пользователь.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Цвет фона кнопки по умолчанию {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Задайте цвет фона для всех кнопок по умолчанию {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Цвет фона кнопки по умолчанию при наведении курсора {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Задайте цвет фона при наведении курсора для всех кнопок по умолчанию {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Цвет текста кнопки по умолчанию {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Задайте цвет текста для всех кнопок по умолчанию {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Цвет текста кнопки по умолчанию при наведении курсора {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Задайте цвет текста при наведении курсора для всех кнопок по умолчанию {$a}.';
$string['alternativethemefooterblockbackgroundcolour'] = 'Цвет фона блока в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Задайте цвет для фона блока в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterblockhovercolour'] = 'Цвет текста ссылки в блоке при наведении курсора в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Задайте цвет для текста ссылки в блоке при наведении курсора в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterblocktextcolour'] = 'Цвет текста в блоке в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Задайте цвет для текста в блоке в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterblockurlcolour'] = 'Цвет ссылки в блоке в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Задайте цвет ссылки в блоке в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefootercolor'] = 'Цвет фона нижнего колонтитула для альтернативной цветовой схемы {$a}';
$string['alternativethemefootercolordesc'] = 'Задайте цвет фона нижнего колонтитула для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterheadingcolor'] = 'Цвет заголовка нижнего колонтитула для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Задайте цвет заголовков нижнего колонтитула для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterhovercolor'] = 'Цвет ссылки при наведении курсора в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Задайте цвет ссылки при наведении курсора в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefootersepcolor'] = 'Цвет разделителя в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefootersepcolordesc'] = 'Разделители — это линии, используемые для разделения контента. Задайте здесь их цвет для альтернативной цветовой схемы {$a}.';
$string['alternativethemefootertextcolor'] = 'Цвет текста в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefootertextcolordesc'] = 'Задайте цвет текста в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemefooterurlcolor'] = 'Цвет ссылки в нижнем колонтитуле для альтернативной цветовой схемы {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Задайте цвет ссылки в нижнем колонтитуле для альтернативной цветовой схемы {$a}.';
$string['alternativethemehovercolor'] = 'Альтернативный цвет при наведении  {$a}';
$string['alternativethemehovercolordesc'] = 'Какого цвета должны быть ссылки при наведении на них курсора в альтернативной цветовой схеме {$a}.';
$string['alternativethemeiconcolor'] = 'Альтернативный цвет значков {$a}';
$string['alternativethemeiconcolordesc'] = 'Задайте альтернативный цвет для всех значков в схеме {$a}.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Альтернативный цвет фона для не посещенных пользователем курсов, в которые он записан {$a}';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Задайте альтернативный цвет фона для не посещенных пользователем курсов, в которые он записан {$a}. Параметр  «mycoursesorder» при этом устанавливается в «Последние посещенные...».';
$string['alternativethemename'] = 'Название цветовой схемы';
$string['alternativethemenamedesc'] = 'Укажите название для альтернативной цветовой схемы';
$string['alternativethemenavcolor'] = 'Цвет текста навигации {$a}';
$string['alternativethemenavcolordesc'] = 'Задайте альтернативный цвет текста для навигации в схеме {$a}. Будет использоваться навигационной панелью и стилем «Причудливый» иерархической навигации.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Цвет фона «Отправить все и закончить» {$a} в тесте';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Установите альтернативный {$a} цвет фона для кнопки «Отправить все и закончить» в тесте.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Цвет фона теста при наведении мыши на «Отправить все и закончить» {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Установите альтернативный цвет {$a} фона при наведении мыши для кнопки «Отправить все и закончить».';
$string['alternativethemequizsubmittextcolour'] = 'Цвет текста «Отправить все и закончить» {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = 'Установите альтернативный цвет текста {$a} для кнопки «Отправить все и закончить» в тесте.';
$string['alternativethemequizsubmittexthovercolour'] = 'Цвет при наведении курсора на «Отправить все и закончить» {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Установите альтернативный цвет {$a} текста при наведении мыши на кнопку «Отправить все и закончить» в тесте.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Альтернативный {$a} цвет фона предварительного блока';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Установите альтернативный цвет фона {$a} для предварительного блока';
$string['alternativethemesidepreblockhovercolour'] = 'Альтернативный {$a} цвет ссылки для предварительного блока';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Установите альтернативный цвет {$a} для предварительного блока при наведении на ссылку';
$string['alternativethemesidepreblocktextcolour'] = 'Альтернативный цвет текста {$a} предварительного блока';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Установите альтернативный цвет текста {$a} для предварительного блока';
$string['alternativethemesidepreblockurlcolour'] = 'Альтернативный цвет {$a} ссылки для предварительного блока';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Установите альтернативный цвет ссылки {$a} для предварительного блока';
$string['alternativethemeslidebuttoncolor'] = 'Альтернативный цвет кнопки слайда {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Цвет кнопки навигации на слайде для альтернативной цветовой схемы {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Альтернативный цвет кнопки слайда при наведении {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Цвет кнопки навигации на слайде при наведении курсора на кнопку для альтернативной цветовой схемы {$a}.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Альтернативный цвет фона подписи слайда {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Цвет фона подписи слайда для альтернативной цветовой схемы {$a}. Не используется при выборе варианта «Сбоку» для подписи слайда.';
$string['alternativethemeslidecaptiontextcolor'] = 'Альтернативный цвет текста подписи слайда {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Цвет текста подписи слайда для альтернативной цветовой схемы {$a}. Не используется при выборе варианта «Сбоку» для подписи слайда.';
$string['alternativethemeslidecolors'] = 'Альтернативные цвета слайда';
$string['alternativethemeslidecolorsdesc'] = 'Определяет альтернативные цвета слайда, которые пользователь может выбрать.';
$string['alternativethemestripebackgroundcolour'] = 'Альтернативный цвет фона для полос {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Задайте альтернативный цвет фона для полос в таблицах {$a}';
$string['alternativethemestripetextcolour'] = 'Альтернативный цвет текста для полос {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Задайте альтернативный цвет текста для полос в таблицах {$a}';
$string['alternativethemestripeurlcolour'] = 'Альтернативный цвет ссылки для полос {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Задайте альтернативный цвет ссылки для полос в таблицах {$a}';
$string['alternativethemetextcolor'] = 'Альтернативный цвет текста {$a}';
$string['alternativethemetextcolordesc'] = 'Задайте альтернативный цвет для текста в схеме  {$a}.';
$string['alternativethemeurlcolor'] = 'Альтернативный цвет ссылки {$a}';
$string['alternativethemeurlcolordesc'] = 'Задайте альтернативный цвет для ссылки в схеме  {$a}.';
$string['alwaysdisplay'] = 'Всегда показывать';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Введите URL своего мобильного приложения в магазине Google Play. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile).';
$string['androidurl'] = 'URL-адрес Android (Google Play)';
$string['asconfigintlower'] = '{$a->value} меньше, чем нижняя граница диапазона {$a->lower}';
$string['asconfigintnan'] = '{$a->value} не является числом';
$string['asconfigintupper'] = '{$a->value} больше, чем верхняя граница диапазона {$a->upper}';
$string['backtotop'] = 'К началу';
$string['badgepreferences'] = 'Значок';
$string['beforecontent'] = 'До контента';
$string['below'] = 'Ниже';
$string['breadcrumbsimple'] = 'Простой';
$string['breadcrumbstyle'] = 'Стиль иерархической навигации';
$string['breadcrumbstyled'] = 'Причудливый';
$string['breadcrumbstyledesc'] = 'Здесь Вы можете изменить стиль иерархической навигации';
$string['breadcrumbstylednocollapse'] = 'Причудливый без сворачивания';
$string['breadcrumbthin'] = 'Узкий';
$string['cachesused'] = 'Использованные кэши';
$string['calendarmi'] = 'Календарь';
$string['categoryctidesc'] = 'Включенный параметр позволяет Вам задавать изображения для каждой категории.';
$string['categoryctiheading'] = 'Изображения заголовков для категорий курсов';
$string['categoryctiheadingcategory'] = 'Изображения заголовков для категорий курсов: {$a->category}';
$string['categoryctiheadingcs'] = 'Настройка изображений заголовков для категорий курсов';
$string['categoryctiheadingsub'] = 'Использовать изображения для представления своих категорий в курсе';
$string['categoryctiheight'] = 'Высота изображения заголовка для категории курса «{$a->category}»';
$string['categoryctiheightdesc'] = 'Высота изображения для заголовка курса в категории «{$a->category}» от {$a->lower} до {$a->upper} пикселей.  Не добавляйте «px» к высоте, вводите только число.';
$string['categoryctiinfo'] = 'Настройки категории «{$a->category}»';
$string['categoryctiinfodesc'] = 'Настройки изображения заголовка для категории курсов: {$a->category}.';
$string['categoryctimage'] = 'Файл изображения заголовка для категории курсов «{$a->category}»';
$string['categoryctimagedesc'] = 'Файл изображения для заголовка курса в категории «{$a->category}».';
$string['categoryctimageurl'] = 'URL изображения заголовка для категории курсов «{$a->category}»';
$string['categoryctimageurldesc'] = 'URL изображения заголовка  курса в категории «{$a->category}». Если загружен файл, то он переопределяет эту настройку.';
$string['categoryctitextbackgroundcolour'] = 'Цвет фона текста заголовка для категории курсов «{$a->category}»';
$string['categoryctitextbackgroundcolourdesc'] = 'Цвет фона текста для заголовка курса в категории «{$a->category}».';
$string['categoryctitextbackgroundopacity'] = 'Непрозрачность фона текста заголовка для категории курсов «{$a->category}»';
$string['categoryctitextbackgroundopacitydesc'] = 'Непрозрачность фона текста для заголовка курса в категории «{$a->category}».';
$string['categoryctitextcolour'] = 'Цвет текста заголовка для категории курсов «{$a->category}»';
$string['categoryctitextcolourdesc'] = 'Цвет текста для заголовка курса в категории «{$a->category}».';
$string['categoryiconcategory'] = 'Значок для категории: {$a->category}.';
$string['categoryicondesc'] = 'При включенном параметре Вы сможете задавать значки для каждой категории курсов';
$string['categoryiconheading'] = 'Значки категорий';
$string['categoryiconheadingsub'] = 'Использовать значки для представления категорий';
$string['categoryiconinfo'] = 'Использовать пользовательский набор значков для категорий';
$string['categoryiconinfodesc'] = 'Введите имя значка, который Вы хотите использовать.  Список есть <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что стоит после «fa-».';
$string['categoryincoursebreadcrumbfeature'] = 'Категории в иерархической навигации курса';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Показывать ссылки на категории в иерархической навигации в курсе.';
$string['ccd'] = 'Дата создания курса';
$string['ced'] = 'Дата окончания курса';
$string['cfn'] = 'Полное название курса';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="скриншот Essential"/></p>
</div>
<div class="well">
<h3>О теме Essential</h3>
<p>Essential основана на теме Bootstrap, которая была создана для Moodle 2.5 с помощью:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Разработчики темы</h3>
<p>Автор исходной версии : Джулиан Ридден (Julian Ridden)<br>
С июля 2014 года работу продолжили:<br>
Гарет Барнард (Gareth J. Barnard)<br>
Дэвид Беземер (David Bezemer)<br>
С 9 октября 2014 года работу продолжает:<br>
Гарет Барнард (Gareth J. Barnard)<br>
</p>
<h3>Пожертвования</h3>
<p>Эта тема предоставляется бесплатно. Если Вы хотите выразить свою благодарность за использование этой темы, пожалуйста, поддержите, внеся свои пожертвования:
<h4>PayPal</h4>
<p>Пожалуйста, свяжитесь со мной через мой <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">профиль в Moodle</a> для получения подробностей, так как я — частное лицо и потому по  правилам PayPal не могу размещать кнопки \'buy me now\'.</p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank">
Пройдите по этой ссылке для пожертвования.
</a>
<br>Пожертвования помогут поддерживать тему и  позволят мне быстрее предоставить вам новые возможности и улучшения  темы. Без вашей поддержки тему невозможно поддерживать.</p>
<p>
<h3>Спонсоры</h3>
<p>За финансовую поддержку хотелось был поблагодарить:</p>
<ul>
<li>Михай Божонка, Межународный институт TCM (Mihai Bojonca, TCM International Institute).</li>
<li>Гвидо Хорнинг, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a> (Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a>)</li>
<li>Делвон Форрестер, Esparanza co uk (Delvon Forrester, Esparanza co uk)</li>
<li>iZone</li>
</ul>
</p>
<h3>Изменения под конкретного пользователя</h3>
<p>Если вам нравится эта тема и вы хотите, чтобы я изменил ее, перенес функциональность в другую тему или создал новую тему с нуля, я могу сделать это за определенную плату. Свяжитесь со мной через www.gjbarnard.co.uk/contact/, gjbarnard at gmail dot com   или about.me/gjbarnard для обсуждения ваших требований.</p>
</div></div>';
$string['colordesc'] = 'Здесь можно найти различные настройки для изменения многих цветов этой темы.';
$string['colorheading'] = 'Цвет';
$string['colorheadingsub'] = 'Задать цвета, используемые в этой теме';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Контактная информация';
$string['contactinfodesc'] = 'Введите свою контактную информацию';
$string['copyright'] = 'Авторские права';
$string['copyrightdesc'] = 'Название вашей организации.';
$string['coursecontentsearch'] = 'Поиск контента в курсе';
$string['coursecontentsearchdesc'] = 'Включить поиск по содержимому курса в Личном кабинете. Работает только в случае, когда тема «Essential» не задана в «$CFG->themedir».';
$string['coursegrades'] = 'Оценки по курсам';
$string['coursegradesmi'] = 'Оценки за курс';
$string['courselistteachericon'] = 'Значок для учителя в списке курсов';
$string['courselistteachericondesc'] = 'Введите имя значка, который Вы хотите использовать, или оставьте пустым, чтобы убрать значок.  Список есть <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что стоит после «fa-», например «star».';
$string['csd'] = 'Дата начала курса';
$string['ctioverride'] = 'Переопределять изображения категорий в курсе';
$string['ctioverridedesc'] = 'Если вы хотите переопределить изображение заголовка категории курса, когда это разрешено настройкой «enablecategorycti», то отредактируйте описание курса в настройках курса и добавьте изображение.  Затем отредактируйте в режиме HTML, убрав окружающие теги «p» и тег «br», затем уберите атрибуты «style», «width» и «height» и все классы, добавленные текстовым редактором к тегу «img».  После этого добавьте класс «categorycti».  Чтобы задать высоту (px), цвет текста содержащегося в ней заголовка, цвет фона и его непрозрачность, используйте атрибуты «ctih», «ctit», «ctib» и «ctio» соответственно, например:<br/><br/>&lt;img src=&quot;https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg&quot; alt=&quot;Заменяющее изображение&quot; class=&quot;categorycti&quot; ctih=&quot;250&quot; ctit=&quot;#afafaf&quot; ctib=&quot;#222222&quot; ctio=&quot;0.5&quot;&gt;<br/><br/>Это изображение не будет показываться в самом описании, когда вы будете просматривать список курсов.';
$string['ctioverrideheight'] = 'Переопределенная высота изображения для заголовка курса по умолчанию.';
$string['ctioverrideheightdesc'] = 'Переопределенная высота изображения для заголовка курса по умолчанию в диапазоне от {$a->lower} до {$a->upper} пикселей.  Не добавляйте «px» к высоте, вводите только число.';
$string['ctioverridetextbackgroundcolour'] = 'Переопределенный цвет фона текста для заголовка курса по умолчанию';
$string['ctioverridetextbackgroundcolourdesc'] = 'Переопределенный цвет фона текста для заголовка курса по умолчанию.';
$string['ctioverridetextbackgroundopacity'] = 'Переопределенная непрозрачность фона текста для заголовка курса по умолчанию';
$string['ctioverridetextbackgroundopacitydesc'] = 'Переопределенная непрозрачность фона текста для заголовка курса по умолчанию.';
$string['ctioverridetextcolour'] = 'Переопределенный цвет текста для заголовка курса по умолчанию';
$string['ctioverridetextcolourdesc'] = 'Переопределенный цвет текста для заголовка курса по умолчанию.';
$string['customcss'] = 'Пользовательский CSS';
$string['customcssdesc'] = 'Любые правила CSS, добавленные в этой текстовой области, будут отражаться на всех страницах сайта, что облегчает настройку этой темы.';
$string['customscrollbars'] = 'Пользовательские линейки прокрутки';
$string['customscrollbarsdesc'] = 'Использовать пользовательские линейки прокрутки. Они заменят стандартные линейки прокрутки браузера.';
$string['dbqueries'] = 'Чтение/Запись БД';
$string['dbtime'] = 'Время запросов БД';
$string['defaultcategoryicon'] = 'Значки для категорий по умолчанию';
$string['defaultcategoryicondesc'] = 'Задайте значок, который по умолчанию будет использоваться для категорий';
$string['defaultcategoryimagedesc'] = 'Установите изображение категории по умолчанию. При выполнении этого действия значок будет заменен.';
$string['defaultcolors'] = 'Цвета по умолчанию';
$string['displayafterlogin'] = 'Показывать только после входа в систему';
$string['displaybeforelogin'] = 'Показывать только до входа в систему';
$string['displayeditingmenu'] = 'Показывать кнопку редактирования';
$string['displayeditingmenudesc'] = 'Показывать кнопку с тем же функционалом, что и стандартная кнопка редактирования страницы в верхнем колонтитуле.';
$string['displayhiddenmycourses'] = 'Показывать скрытые курсы';
$string['displayhiddenmycoursesdesc'] = 'Показывать скрытые курсы для пользователей в меню курсов, если они имеют право просматривать скрытые курсы.';
$string['displaymycourses'] = 'Показывать курсы';
$string['displaymycoursesdesc'] = 'Показывать  в навигационной панели курсы, на которые записаны пользователи.';
$string['dontdisplay'] = 'Не отображать';
$string['editingmenu'] = 'Переключатель редактирования страниц';
$string['editingmenudesc'] = 'Показывает кнопку для включения/выключения режима редактирования текущей страницы, если пользователь имеет права редактировать эту страницу. Тот же функционал, что и у стандартной кнопки редактирования страницы.';
$string['enablealert'] = 'Включить предупреждения';
$string['enablealertdesc'] = 'Включить или отключить предупреждения';
$string['enablealternativethemecolors'] = 'Включить альтернативную цветовую схему {$a}';
$string['enablealternativethemecolorsdesc'] = 'При включенном параметре пользователь сможет выбрать альтернативную цветовую схему  {$a}.';
$string['enablecategorycti'] = 'Включить изображения заголовков категорий курсов';
$string['enablecategoryctics'] = 'Включить страницы настройки категорий для изображений заголовков категорий курсов.';
$string['enablecategorycticsdesc'] = 'При включенном параметре каждая категория верхнего уровня получит свою собственную страницу настройки.';
$string['enablecategoryctidesc'] = 'При включенном параметре Вы сможете выбрать изображения заголовков для категорий курсов после нажатия на кнопку «Сохранить изменения».';
$string['enablecategoryicon'] = 'Включить значки категорий';
$string['enablecategoryicondesc'] = 'Если параметр включен, то Вы сможете выбирать значки для категорий после нажатия «Сохранить изменения».';
$string['enablecustomcategoryicon'] = 'Включить пользовательские значки категорий';
$string['enablecustomcategoryicondesc'] = 'Если параметр включен, то ниже этого раздела Вы увидите все категории с параметром настройки рядом с их названием. Нажмите «Сохранить изменения» после включения или выключения этого параметра.';
$string['extperfinfoheading'] = 'Расширенная информация о производительности';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Введите адрес своей страницы в Facebook. (Например, https://www.facebook.com/mycollege)';
$string['facebookurl'] = 'URL-адрес Facebook';
$string['favicon'] = 'Пользовательский favicon';
$string['favicondesc'] = 'Загрузите свой собственный favicon. Он должен быть файлом .ico';
$string['featuredesc'] = 'Здесь вы найдете различные настройки для изменения множества возможностей, имеющихся в этой теме.';
$string['featureheading'] = 'Возможности';
$string['featureheadingsub'] = 'Задайте возможности, используемые в вашей теме';
$string['findcoursecontent'] = 'Контент курса:';
$string['fitvids'] = 'Использовать FitVids';
$string['fitvidsdesc'] = 'Включите FitVids (fitvidsjs.com), чтобы встроенные видео подстраивались под ширину окна браузера, стали «отзывчивыми» (responsive).  Если FitVids включен и вы хотите, чтобы он не использовался для конкретного видео, добавьте class="fitvidsignore" к тегу iframe в HTML-режиме редактора.  Например: «iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe».';
$string['fixedwidthnarrow'] = 'Фиксированная ширина - Узкий';
$string['fixedwidthnormal'] = 'Фиксированная ширина - Нормальный';
$string['fixedwidthwide'] = 'Фиксированная ширина - Широкий';
$string['flatnavigation'] = 'Включить параллельную навигацию';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Введите адрес своей страницы в Flickr. (Например, http://www.flickr.com/mycollege)';
$string['flickrurl'] = 'URL-адрес Flickr';
$string['floatingsubmitbuttons'] = 'Плавающие кнопки отправки';
$string['floatingsubmitbuttonsdesc'] = 'Включает «плавающую» область, в которой находятся кнопки, используемые для отправки формы на настольных устройствах. Это помогает сократить прокрутку на некоторых страницах. Не используется на странице записи на курс и в форуме.';
$string['fontcharacterset'] = 'Дополнительный набор символов для шрифтов Google';
$string['fontcharactersetcyrillic'] = 'Кириллица (Cyrillic)';
$string['fontcharactersetcyrillicext'] = 'Кириллица расширенная (Cyrillic Extended)';
$string['fontcharactersetdesc'] = 'Выберите дополнительные наборы символов для разных языков.
Использование нескольких наборов символов может замедлить загрузку веб-страницы, поэтому выбирайте только те наборы символов, которые действительно необходимы на странице.';
$string['fontcharactersetgreek'] = 'Греческий (Greek)';
$string['fontcharactersetgreekext'] = 'Греческий расширенный (Greek Extended)';
$string['fontcharactersetlatinext'] = 'Латиница  расширенная (Latin Extended)';
$string['fontcharactersetvietnamese'] = 'Вьетнамский (Vietnamese)';
$string['fontfileeotbody'] = 'Файл EOT-шрифта для основного текста';
$string['fontfileeotheading'] = 'Файл EOT-шрифта для заголовков';
$string['fontfileotfbody'] = 'Файл OTF-шрифта для основного текста';
$string['fontfileotfheading'] = 'Файл OTF-шрифта для заголовков';
$string['fontfiles'] = 'Файлы шрифтов';
$string['fontfilesdesc'] = 'Загрузите сюда свои файлы шрифтов (поддерживаются только файлы формата TTF).';
$string['fontfilesvgbody'] = 'Файл SVG-шрифта для основного текста';
$string['fontfilesvgheading'] = 'Файл SVG-шрифта для заголовков';
$string['fontfilettfbody'] = 'Файл шрифта TTF для основого текста';
$string['fontfilettfheading'] = 'Файл шрифта TTF для заголовков';
$string['fontfilewoffbody'] = 'Файл WOFF-шрифта для основного текста';
$string['fontfilewoffheading'] = 'Файл WOFF-шрифта для заголовков';
$string['fontfilewofftwobody'] = 'Файл WOFF2-шрифта для основного текста';
$string['fontfilewofftwoheading'] = 'Файл WOFF2-шрифта для заголовков';
$string['fontheadingdesc'] = 'Выберите и введите шрифты, которые Вы хотите использовать в своей среде Moodle.';
$string['fontheadingsub'] = 'Настройки шрифтов';
$string['fontnamebody'] = 'Шрифт текста';
$string['fontnamebodydesc'] = 'Введите точное имя шрифта, используемого для всего остального текста.';
$string['fontnameheading'] = 'Шрифт заголовка';
$string['fontnameheadingdesc'] = 'Введите точное имя шрифта, используемого для всех заголовков.';
$string['fontselect'] = 'Выбор шрифта';
$string['fontselectdesc'] = 'Выберите шрифт из списка доступных сочетаний. Нажмите на кнопку «Сохранить», чтобы увидеть настройки для выбранного вами варианта.';
$string['fontsettings'] = 'Шрифт';
$string['fonttypecustom'] = 'Шрифт пользователя';
$string['fonttypegoogle'] = 'Веб-шрифты Google';
$string['fonttypeuser'] = 'Шрифты пользователя';
$string['footerblockbackgroundcolour'] = 'Цвет фона блока в нижнем колонтитуле';
$string['footerblockbackgroundcolourdesc'] = 'Задайте цвет для фона блока в нижнем колонтитуле.';
$string['footerblockhovercolour'] = 'Цвет текста ссылки в блоке при наведении курсора в нижнем колонтитуле';
$string['footerblockhovercolourdesc'] = 'Задайте цвет для текста ссылки в блоке при наведении курсора в нижнем колонтитуле';
$string['footerblocktextcolour'] = 'Цвет текста в блоке в нижнем колонтитуле';
$string['footerblocktextcolourdesc'] = 'Задайте цвет для текста в блоке в нижнем колонтитуле.';
$string['footerblockurlcolour'] = 'Цвет ссылки в блоке в нижнем колонтитуле';
$string['footerblockurlcolourdesc'] = 'Задайте цвет ссылки в блоке в нижнем колонтитуле.';
$string['footercolor'] = 'Фон нижнего колонтитула';
$string['footercolordesc'] = 'Задайте цвет фона нижнего колонтитула.';
$string['footercolors'] = 'Цвета нижнего колонтитула';
$string['footercolorsdesc'] = 'Изменить цвета в нижнем колонтитуле страницы.';
$string['footerheading'] = 'Нижний колонтитул';
$string['footerheadingcolor'] = 'Цвет заголовка нижнего колонтитула';
$string['footerheadingcolordesc'] = 'Задайте цвет для заголовков в нижнем колонтитуле.';
$string['footerhovercolor'] = 'Цвет ссылки при наведении курсора в нижнем колонтитуле';
$string['footerhovercolordesc'] = 'Задайте цвет ссылки при наведении курсора в нижнем колонтитуле.';
$string['footersepcolor'] = 'Цвет разделителя нижнего колонтитула';
$string['footersepcolordesc'] = 'Разделители и линии используются для разделения содержимого. Задайте их цвет здесь.';
$string['footertextcolor'] = 'Цвет текста в нижнем колонтитуле';
$string['footertextcolordesc'] = 'Задайте цвет текста для нижнего колонтитула.';
$string['footerurlcolor'] = 'Цвет ссылки в нижнем колонтитуле';
$string['footerurlcolordesc'] = 'Задайте цвет ссылок в нижнем колонтитуле.';
$string['footnote'] = 'Сноска';
$string['footnotedesc'] = 'Всё, что Вы добавите в это поле, будет отображаться в нижнем колонтитуле каждой страницы Вашего сайта.';
$string['forumdiscussionsmi'] = 'Обсуждения';
$string['forumpostsmi'] = 'Сообщения форума';
$string['frontcontent'] = 'Включить область контента на главной странице';
$string['frontcontentarea'] = 'Содержимое области контента главной страницы';
$string['frontcontentareadesc'] = 'Всё, что Вы введете в это поле, будет отображаться на всю ширину страницы между слайд-шоу и рекламными блоками.';
$string['frontcontentdesc'] = 'Если данный параметр включен, пользовательская область контента будет добавлена между слайд-шоу и рекламными блоками.';
$string['frontcontentheading'] = 'Область контента главной страницы';
$string['frontpageblocks'] = 'Выравнивание блоков главной страницы';
$string['frontpageblocksdesc'] = 'Здесь вы можете указать, должны ли стандартные блоки Moodle на главной странице выравниваться до или после контента.';
$string['frontpageblocksheading'] = 'Блоки главной страницы';
$string['frontpageheading'] = 'Главная страница';
$string['frontpageheadingdesc'] = 'Настройте, какие дополнительные элементы Вы хотите показывать на главной странице.';
$string['frontpagemiddleblocks'] = 'Включить дополнительные блоки по центру главной страницы';
$string['frontpagemiddleblocksdesc'] = 'Если данный параметр включен, то три дополнительных блока будут показываться прямо под рекламными блоками.';
$string['frontpagesettingstitle'] = 'Настройки главной страницы';
$string['fullname'] = 'Полное название сайта';
$string['fullnamesummary'] = 'Полное название сайта и описание';
$string['generalheadingdesc'] = 'Настройте здесь глобальные параметры для темы.  Здесь Вы найдете настройки для макета и визуального представления.';
$string['generalheadingsub'] = 'Общие настройки';
$string['genericsettings'] = 'Общие';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'Введите адрес своего профиля на Google+. (Например, https://plus.google.com/+mycollege)';
$string['googleplusurl'] = 'URL-адрес Google+';
$string['gotobottom'] = 'Перейти в конец страницы';
$string['haveheaderblock'] = 'Область колонтитула блока';
$string['headerbackground'] = 'Изображение фона верхнего колонтитула';
$string['headerbackgrounddesc'] = 'Загрузите свое собственное изображение фона.';
$string['headerbackgroundstyle'] = 'Стиль фона колонтитула';
$string['headerbackgroundstyledesc'] = 'Выберите стиль для фона верхнего колонтитула.';
$string['headerheading'] = 'Верхний колонтитул';
$string['headertextcolor'] = 'Цвет текста верхнего колонтитула';
$string['headertextcolordesc'] = 'Задайте цвет текста для верхнего колонтитула.';
$string['headertitle'] = 'Заголовок в верхнем колонтитуле';
$string['headertitledesc'] = 'Настройте здесь заголовок для вывода в верхнем колонтитуле.';
$string['helplink'] = 'Ссылка на помощь';
$string['helplinkdesc'] = 'Если Вы выбрали «URL», то введите выше полный URL-адрес своего сайта помощи (он должен содержать http:// или https://). Если Вы выбрали «адрес E-mail», то введите свой адрес электронной почты.';
$string['helplinktype'] = 'Включить в меню ссылку на помощь';
$string['helplinktypedesc'] = 'Выберите, хотите ли Вы включить в меню пользователя возможность получения помощи. Вы можете задать URL-адрес, который будет открыт в новом окне, или указать адрес электронной почты.';
$string['hidedefaulteditingbutton'] = 'Скрыть стандартную кнопку редактирования страницы';
$string['hidedefaulteditingbuttondesc'] = 'Скрывает стандартную кнопку редактирования страницы на всех страницах. Эта настройка будет работать только при включенном параметре «Показывать кнопку редактирования».';
$string['hideonphone'] = 'Скрыть слайд-шоу на мобильных';
$string['hideonphonedesc'] = 'Выберите, если хотите отключить слайд-шоу на мобильных.';
$string['hideontablet'] = 'Скрыть слайд-шоу на планшетах';
$string['hideontabletdesc'] = 'Выберите, если хотите отключить слайд-шоу на планшетах.';
$string['icon'] = 'Иконка';
$string['image'] = 'Изображение';
$string['included'] = 'Включенные файлы';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Введите адрес своей страницы в Instagram. (Например, http://instagram.com/mycollege)';
$string['instagramurl'] = 'URL-адрес Instagram';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Введите адрес своего мобильного приложения в магазине App Store. Если у Вас нет своего приложения, Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Иконки домашней страницы для iOS';
$string['iosicondesc'] = 'Тема задает значок по умолчанию для домашних экранов iOS и android. При желании Вы можете загрузить свои значки.';
$string['iosurl'] = 'URL-адрес iPhone/iPad (App Store)';
$string['ipadicon'] = 'Значок для iPad (Не Retina)';
$string['ipadicondesc'] = 'Значок должен быть в виде PNG-файла размером 72px на 72px.';
$string['ipadretinaicon'] = 'Значок для  iPad (Retina)';
$string['ipadretinaicondesc'] = 'Значок должен быть в виде PNG-файла размером 144px на 144px.';
$string['iphoneicon'] = 'Значок для iPhone/iPod Touch (Не Retina)';
$string['iphoneicondesc'] = 'Значок должен быть в виде PNG-файла размером 57px на 57px.';
$string['iphoneretinaicon'] = 'Значок для iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Значок должен быть в виде PNG-файла размером 114px на 114px.';
$string['layout'] = 'Использовать стандартный вид курса';
$string['layoutdesc'] = 'Эта тема создана для размещения обоих колонок блоков с одной стороны. Если Вы предпочитаете стандартную раскладку Moodle, то можете включить этот параметр и вернуться к привычному старому виду в три колонки.';
$string['left'] = 'Слева';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Введите адрес своего профиля в LinkedIn. (Например, https://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'URL-адрес LinkedIn';
$string['loadtime'] = 'Время загрузки';
$string['loggedinas'] = 'вошел как';
$string['loggedinfrom'] = 'Вошел с';
$string['loggedinfrommi'] = 'Войти с помощью';
$string['loginbackgrounddesc'] = 'Загрузите свое собственное фоновое изображение для входа. Выберите стиль изображения ниже';
$string['loginbackgroundstyledesc'] = 'Выберите стиль для загруженного изображения';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Загрузите сюда свой логотип, если Вы хотите добавить его в заголовок сайта.
                       <br>Изображение должно быть высотой, равной заданному ниже параметру «Высота логотипа», и иметь любую подходящую ширину.
                       <br>Если Вы загрузите логотип, то он заменит стандартный значок и название сайта, отображаемые по умолчанию.';
$string['logodesktopwidth'] = 'Ширина логотипа для рабочего стола';
$string['logodimerror'] = 'Неправильно.  Пожалуйста, укажите«px» или «em» сразу после значения и не указывайте ничего до этого значения.';
$string['logomobilewidth'] = 'Ширина логотипа для мобильной версии';
$string['marketing1'] = 'Первый рекламный блок';
$string['marketing2'] = 'Второй рекламный блок';
$string['marketing3'] = 'Третий рекламный блок';
$string['marketingbuttontext'] = 'Текст ссылки';
$string['marketingbuttontextdesc'] = 'Текст, отображаемый на кнопке.';
$string['marketingbuttonurl'] = 'URL-адрес ссылки';
$string['marketingbuttonurldesc'] = 'URL-адрес, на который перейдет пользователь, нажав на кнопку рекламного блока.';
$string['marketingcontent'] = 'Содержимое блока';
$string['marketingcontentdesc'] = 'Содержимое, отображаемое в окне рекламного блока. Оно должно быть коротким и привлекательным.';
$string['marketingdesc'] = 'Эта тема дает возможность включить три «рекламных» или «маркетинговых» блока, размещенных под слайд-шоу. Это позволит Вам легко представить основную информацию для пользователей и дать им прямые ссылки на нужный контент.';
$string['marketingheading'] = 'Рекламные блоки';
$string['marketingheadingsub'] = 'Три блока на главной странице для добавления информации и ссылок';
$string['marketingheight'] = 'Высота контейнера рекламного блока (px)';
$string['marketingheightdesc'] = 'Задайте высоту контейнера рекламного блока в пикселах. Откорректируйте ее так, чтобы она соответствовала вашему контенту. Если какой-то из рекламных блоков содержит изображение или ссылку, то их высота будет добавлена к этому значению у всех рекламных блоков.';
$string['marketingicon'] = 'Значок';
$string['marketingicondesc'] = 'Название значка, который Вы хотите использовать. Список значков <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что после «fa-», например, «star».';
$string['marketingimage'] = 'Изображение';
$string['marketingimagedesc'] = 'Дает возможность отображать изображение над текстом в рекламном блоке';
$string['marketingimageheight'] = 'Высота рекламных изображений (px)';
$string['marketingimageheightdesc'] = 'Если Вы хотите показать изображения в рекламных блоках, то можете указать здесь их высоту в пикселях.';
$string['marketinginfodesc'] = 'Задайте настройки своего рекламного блока.';
$string['marketingtitle'] = 'Название';
$string['marketingtitledesc'] = 'Введите название этого рекламного блока';
$string['marketingurltarget'] = 'Где открывать';
$string['marketingurltargetdesc'] = 'Выберите, как ссылка будет открываться';
$string['marketingurltargetnew'] = 'Новая страница';
$string['marketingurltargetparent'] = 'Родительский фрейм';
$string['marketingurltargetself'] = 'Текущая страница';
$string['memused'] = 'Использованная память';
$string['messagesmi'] = 'Сообщения';
$string['messagesmidesc'] = 'Показать пункт «Меню сообщений», если опция обмена сообщениями включена.';
$string['mobileappsdesc'] = 'У вас есть веб-приложение в магазинах App Store или Google Play? Укажите здесь ссылки на эти приложения, чтобы пользователи смогли получить к ним доступ онлайн.';
$string['mobileappsheading'] = 'Мобильные приложения';
$string['mobileappsheadingsub'] = 'Ссылка на Ваше приложение для студентов, использующих мобильные устройства';
$string['modulesettingstitle'] = 'Настройки модуля';
$string['myclasses'] = 'Мои классы';
$string['mycourses'] = 'Мои курсы';
$string['mycoursescatsubmenu'] = 'Категория и подменю курса';
$string['mycoursesinfo'] = 'Меню курсов';
$string['mycoursesinfodesc'] = 'Отображать пользователю динамический список курсов, на которые он подписан.';
$string['mycoursesmax'] = 'Максимальное количество курсов';
$string['mycoursesmaxdesc'] = 'Укажите, сколько курсов должно отображаться в списке (от {$a->lower} до {$a->upper}, где \'{$a->lower}\' означает все курсы).';
$string['mycoursesorder'] = 'Порядок курсов';
$string['mycoursesorderdesc'] = 'Укажите, как должны быть отсортированы курсы. Порядок сортировки курсов может быть задан в настройке навигации «navsortmycoursessort».';
$string['mycoursesorderenrolbackcolour'] = 'Цвет фона для не посещенных пользователем курсов, в которые он записан';
$string['mycoursesorderenrolbackcolourdesc'] = 'Цвет фона для не посещенных пользователем курсов, в которые он записан {$a}. Параметр  «mycoursesorder» при этом устанавливается в «Последние посещенные...».';
$string['mycoursesorderid'] = 'ID курса';
$string['mycoursesorderidasc'] = 'По возрастанию';
$string['mycoursesorderiddes'] = 'По убыванию';
$string['mycoursesorderidorder'] = 'Порядок ID курсов';
$string['mycoursesorderidorderdesc'] = 'Порядок ID курсов, когда «ID курса» задан в качестве параметра «Порядок сортировки курсов».';
$string['mycoursesorderlast'] = 'Время последнего входа или время записи на курс, если вход не был произведен.';
$string['mycoursesordersort'] = 'Порядок сортировки курсов';
$string['mycoursetitle'] = 'Терминология';
$string['mycoursetitledesc'] = 'Измените терминологию для заголовка меню «Мои курсы». Если для параметра «mycoursesorder» задано значение «Последние посещенные...», то будет добавляться слово «последние».';
$string['mygrades'] = 'Мои оценки';
$string['mygradesmi'] = 'Мои оценки';
$string['mylatestclasses'] = 'Мои последние уроки';
$string['mylatestcourses'] = 'Мои последние курсы';
$string['mylatestmodules'] = 'Мои последние модули';
$string['mylatestunits'] = 'Мои последние блоки';
$string['mymodules'] = 'Мои модули';
$string['myunits'] = 'Мои задания';
$string['navbarabove'] = 'Навигационная панель над верхним колонтитулом';
$string['navbarbelow'] = 'Навигационная панель под верхним колонтитулом';
$string['navbartitle'] = 'Заголовок навигационной панели';
$string['navbartitledesc'] = 'Настройте здесь заголовок для вывода в навигационной панели.';
$string['nextsection'] = 'Следующий раздел';
$string['nobreadcrumb'] = 'Скрыть';
$string['noenrolments'] = 'Вы не записаны ни на один курс';
$string['noslidetitle'] = 'Нет названия для слайда {$a->slide}';
$string['notitle'] = 'Без заголовка';
$string['numberofcoursesandsubcatcourses'] = 'Число курсов/подкатегорий курсов';
$string['numberofslides'] = 'Количество слайдов';
$string['numberofslides_desc'] = 'Число слайдов в слайд-шоу.';
$string['oldnavbar'] = 'Использовать старое расположение навигационной панели';
$string['oldnavbardesc'] = 'Включите этот параметр для использования старого расположения навигационной панели.';
$string['pagebackground'] = 'Изображение для фона страницы';
$string['pagebackgrounddesc'] = 'Загрузите свое изображение для фона страницы. Выберите ниже стиль изображения.';
$string['pagebackgroundstyle'] = 'Стиль фона страницы';
$string['pagebackgroundstyledesc'] = 'Выберите стиль для загруженного изображения.';
$string['pagewidth'] = 'Задать ширину страницы';
$string['pagewidthdesc'] = 'Выберите из списка доступные варианты ширины для своего сайта.';
$string['participantsmenu'] = 'Меню участников';
$string['participantsmenudesc'] = 'Показать меню участников в курсе и на страницах модулей.';
$string['paypal_click'] = 'профиль в Moodle';
$string['paypal_desc'] = '{$a->url} для получения подробностей, так как я частное лицо и, по правилам PayPal, не могу размещать кнопки «buy me now» или ';
$string['peakmem'] = 'Пиковая память';
$string['perf_max'] = 'Детально';
$string['perf_min'] = 'Минимально';
$string['perfinfo'] = 'Режим информации о производительности';
$string['perfinfodesc'] = 'Многие сайты не нуждаются в подробной информации о производительности. Особенно, когда они просматриваются пользователями. При включенном параметре отображается сокращенная минимальная форма с базовой информацией о загрузке страницы.';
$string['perfinfoheading'] = 'Информация о производительности';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Введите адрес своей страницы в Pinterest. (Например, http://pinterest.com/mycollege/mypinboard)';
$string['pinteresturl'] = 'URL-адрес Pinterest';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Предпочтения';
$string['preferencesmidesc'] = 'Показать пункт "Меню настроек"';
$string['previoussection'] = 'Предыдущий раздел';
$string['privatefilesmi'] = 'Личные файлы';
$string['profilebarcustomtitle'] = 'Заголовок пользовательского блока профиля';
$string['profilebarcustomtitledesc'] = 'Задайте название для пользовательского блока профиля.';
$string['profilelinkmi'] = 'Ссылка профиля';
$string['profilelinkmidesc'] = 'Показать пункт меню «Ссылка профиля»';
$string['properties'] = 'Параметры';
$string['propertiesdesc'] = 'Список параметров';
$string['propertiesproperty'] = 'Параметр';
$string['propertiesreturn'] = 'Вернуться';
$string['propertiessub'] = 'Параметры';
$string['propertiesvalue'] = 'Значение';
$string['putpropertiesadded'] = 'Добавленный:';
$string['putpropertieschanged'] = 'Измененный:';
$string['putpropertiesfrom'] = 'Из';
$string['putpropertiesignorecti'] = 'Не учитывать настройки отображения заголовка курса';
$string['putpropertiesignored'] = 'Игнорируемый:';
$string['putpropertiesreportfiles'] = 'Не забудьте загрузить следующие файлы в свои настройки:';
$string['putpropertiessettingsreport'] = 'Отчёт о настройках';
$string['putpropertiesunchanged'] = 'Неизмененный:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Параметры';
$string['putpropertyreport'] = 'Отчёт';
$string['putpropertyversion'] = 'Версия:';
$string['readme_click'] = 'щелкните для чтения README.txt';
$string['readme_desc'] = 'Пожалуйста, {$a->url}, содержащего подробную информацию о теме Essential.';
$string['readme_title'] = 'Информация о теме Essential';
$string['readmore'] = 'Подробнее';
$string['region-footer-left'] = 'Нижний колонтитул (Слева)';
$string['region-footer-middle'] = 'Нижний колонтитул (По середине)';
$string['region-footer-right'] = 'Нижний колонтитул (Справа)';
$string['region-header'] = 'Заголовок';
$string['region-hidden-dock'] = 'Скрыть от пользователей';
$string['region-home'] = 'Домашняя страница';
$string['region-page-top'] = 'Верхняя часть страницы';
$string['region-side-post'] = 'Справа';
$string['region-side-pre'] = 'Слева';
$string['returntosection'] = 'Вернуться в раздел {$a->section}';
$string['returntosectionfeature'] = 'Вернуться к разделу';
$string['returntosectionfeaturedesc'] = 'Включить возможность «вернуться к разделу» в модулях курса.';
$string['returntosectiontextlimitfeature'] = 'Лимит текста в названии «Вернуться к разделу»';
$string['returntosectiontextlimitfeaturedesc'] = 'Максимальная длина для имени раздела на кнопке от {$a->lower} до {$a->upper} символов.';
$string['right'] = 'Справа';
$string['searchallcoursecontent'] = 'Поиск по всему содержанию курса';
$string['searchallcoursecontentenable'] = 'Включить поиск по всему содержанию курсу';
$string['serverload'] = 'Загрузка сервера';
$string['sessionsize'] = 'Размер сессии';
$string['shortname'] = 'Краткое название сайта';
$string['shortnamesummary'] = 'Краткое название сайта и описание';
$string['siteicon'] = 'Значок сайта';
$string['siteicondesc'] = 'У вашего сайта нет логотипа? Введите название значка, который Вы хотите использовать. Список значков <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что после «fa-».';
$string['skype'] = 'Аккаунт Skype';
$string['skypedesc'] = 'Введите имя пользователя Skype из профиля Skype своей организации. (Например, my.college).';
$string['skypeuri'] = 'URI аккаунта Skype';
$string['slidebuttoncolor'] = 'Цвет кнопки слайда';
$string['slidebuttoncolordesc'] = 'Цвет кнопки навигации на слайде';
$string['slidebuttonhovercolor'] = 'Цвет кнопки слайда при наведении';
$string['slidebuttonhovercolordesc'] = 'Цвет кнопки навигации на слайде при наведении курсора на кнопку';
$string['slidecaption'] = 'Подпись слайда';
$string['slidecaptionbackgroundcolor'] = 'Цвет фона подписи слайда';
$string['slidecaptionbackgroundcolordesc'] = 'Цвет фона подписи слайда. Не используется при выборе варианта «Сбоку» для подписи слайда.';
$string['slidecaptionbelow'] = 'Подпись слайда под изображением';
$string['slidecaptionbelowdesc'] = 'Если под изображением должна быть подпись слайда.';
$string['slidecaptionbeside'] = 'Сбоку';
$string['slidecaptioncentred'] = 'Выравнивать подпись слайда по центру';
$string['slidecaptioncentreddesc'] = 'Включите, если подпись слайда должна быть выровнена по центру.';
$string['slidecaptiondesc'] = 'Введите текст подписи для использования на слайде';
$string['slidecaptionontop'] = 'Сверху';
$string['slidecaptionoptions'] = 'Настройки подписи слайда';
$string['slidecaptionoptionsdesc'] = 'Где должны отображаться подписи относительно изображения.';
$string['slidecaptiontextcolor'] = 'Цвет текста подписи слайда';
$string['slidecaptiontextcolordesc'] = 'Цвет текста подписи слайда. Не используется при выборе варианта «Сбоку» для подписи слайда.';
$string['slidecaptionunderneath'] = 'Снизу';
$string['slidecolor'] = 'Цвет текста слайда';
$string['slidecolordesc'] = 'Цвет текста подписи слайда';
$string['slideimage'] = 'Изображение слайда';
$string['slideimagedesc'] = 'Лучше использовать изображение с прозрачностью.';
$string['slideinterval'] = 'Интервал между слайдами';
$string['slideintervaldesc'] = 'Интервал между сменой слайдов в миллисекундах.';
$string['slideno'] = 'Слайд {$a->slide}';
$string['slidenodesc'] = 'Задайте настройки для слайда {$a->slide}.';
$string['slideshowdesc'] = 'С помощью этих настроек создается динамическое слайд-шоу, состоящее максимум из 16 слайдов, предназначенных для продвижения важных элементов вашего сайта. Слайд-шоу может изменять свои размеры: высота изображения задается исходя из размера экрана. Рекомендуемая высота — 300px. Ширина задается как 100%, поэтому фактическая высота будет меньше, если ширина больше, чем размер экрана. На экранах меньшего размера высота динамически уменьшается без использования дополнительных изображений.  Используемые размеры: ширина экрана < 767px = высота 165px, ширина от 768px до 979px = высота 225px и ширина > 980px = высота 300px.  Если изображение для слайда не выбрано, то будет использоваться изображение default_slide из папки pix.';
$string['slideshowheading'] = 'Слайд-шоу';
$string['slideshowheadingsub'] = 'Динамическое слайд-шоу на главной странице';
$string['slidetitle'] = 'Заголовок слайда';
$string['slidetitledesc'] = 'Введите заголовок для Вашего слайда';
$string['slideurl'] = 'Ссылка для слайда';
$string['slideurldesc'] = 'Введите ссылку, на которую указывает изображение слайда';
$string['slideurltarget'] = 'Где открывать';
$string['slideurltargetdesc'] = 'Выберите, как ссылка должна будет открываться';
$string['slideurltargetnew'] = 'Новая страница';
$string['slideurltargetparent'] = 'Родительский фрейм';
$string['slideurltargetself'] = 'Текущая страница';
$string['socialdesc'] = 'Задайте прямые ссылки на основные социальные сети, продвигающие Ваш бренд. Они будут отображаться в верхнем колонтитуле каждой страницы.';
$string['socialheading'] = 'Социальные сети';
$string['socialheadingsub'] = 'Привлекайте своих пользователей в социальные сети';
$string['socialnetworks'] = 'Социальные сети';
$string['sponsor_desc'] = 'Пожалуйста, поддержите через PayPal, связавшись со мной через мой ';
$string['sponsor_desc2'] = ', чтобы поддержать продолжение разработки Essential или же просто выразить свою благодарность.';
$string['sponsor_title'] = 'Спонсировать Essential';
$string['stylecover'] = 'Обложка';
$string['stylefixed'] = 'Фиксированый';
$string['styleguide'] = 'Руководство по стилю';
$string['styleguidedesc'] = 'Оригинальный код документации лицензирован по лицензии «{$a->origcodelicenseurl}».  Holder.js лицензирован по лицензии «{$a->holderlicenseurl}» .  Дополнительный код  лицензирован по лицензии «{$a->thiscodelicenseurl}», которая является «{$a->compatible}» лицензией.  Контент лицензирован по лицензии «{$a->contentlicenseurl}». Документация была отформатирована для показа в Moodle с добавлением в нужных местах значков FontAwesome.  Дополнительный CSS можно найти в файле «essential_admin_setting_styleguide.php» после комментария «// Beyond docs.css.». Раздел «{$a->globalsettings}» был удален.';
$string['styleguidesub'] = 'Руководство по стилю Bootstrap V2.3.2';
$string['stylestretch'] = 'Растянутый';
$string['styletiled'] = 'Мозаика';
$string['themecolor'] = 'Цвет темы';
$string['themecolordesc'] = 'Основной цвет темы. Это изменит цвет многих компонентов, для создания желаемого цвета на вашем сайте Moodle.';
$string['themecolors'] = 'Цвета темы';
$string['themedefaultbuttonbackgroundcolour'] = 'Цвет фона кнопки по умолчанию';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Задайте цвет фона для всех кнопок по умолчанию.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Цвет фона кнопки по умолчанию при наведении курсора';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Задайте цвет фона при наведении курсора для всех кнопок по умолчанию.';
$string['themedefaultbuttontextcolour'] = 'Цвет текста кнопки по умолчанию';
$string['themedefaultbuttontextcolourdesc'] = 'Задайте цвет текста для всех кнопок по умолчанию.';
$string['themedefaultbuttontexthovercolour'] = 'Цвет текста кнопки по умолчанию при наведении курсора';
$string['themedefaultbuttontexthovercolourdesc'] = 'Задайте цвет текста при наведении курсора для всех кнопок по умолчанию.';
$string['themehovercolor'] = 'Цвет темы при наведении';
$string['themehovercolordesc'] = 'Какого цвета должны быть элементы темы при наведении на них курсора. Этот цвет используется для ссылок, меню и т.д.';
$string['themeiconcolor'] = 'Цвет значка';
$string['themeiconcolordesc'] = 'Задайте цвет для всех значков.';
$string['themenavcolor'] = 'Цвет текста навигации';
$string['themenavcolordesc'] = 'Задайте цвет текста для навигации. Будет использоваться навигационной панелью и стилем «Причудливый» иерархической навигации.';
$string['themequizsubmitbackgroundcolour'] = 'Цвет фона кнопки «Отправить всё и завершить тест»';
$string['themequizsubmitbackgroundcolourdesc'] = 'Задайте цвет фона для кнопки «Отправить всё и завершить тест»';
$string['themequizsubmitbackgroundhovercolour'] = 'Цвет фона кнопки «Отправить всё и завершить тест» при наведении курсора';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Задайте цвет фона для кнопки «Отправить всё и завершить тест» при наведении курсора';
$string['themequizsubmittextcolour'] = 'Цвет текста кнопки «Отправить всё и завершить тест»';
$string['themequizsubmittextcolourdesc'] = 'Задайте цвет текста для кнопки «Отправить всё и завершить тест»';
$string['themequizsubmittexthovercolour'] = 'Цвет текста кнопки «Отправить всё и завершить тест» при наведении курсора';
$string['themequizsubmittexthovercolourdesc'] = 'Задайте цвет текста для кнопки «Отправить всё и завершить тест» при наведении курсора';
$string['themestripebackgroundcolour'] = 'Цвет фона для полос';
$string['themestripebackgroundcolourdesc'] = 'Задайте цвет фона для полос в таблицах.';
$string['themestripetextcolour'] = 'Цвет текста для полос';
$string['themestripetextcolourdesc'] = 'Задайте цвет текста для полос в таблицах.';
$string['themestripeurlcolour'] = 'Цвет ссылки для полос';
$string['themestripeurlcolourdesc'] = 'Задайте цвет ссылки для полос в таблицах.';
$string['themetextcolor'] = 'Цвет текста';
$string['themetextcolordesc'] = 'Задайте цвет для текста.';
$string['themeurlcolor'] = 'Цвет ссылки';
$string['themeurlcolordesc'] = 'Задайте цвет для текста ссылки.';
$string['thiscourse'] = 'Этот курс';
$string['togglemarketing'] = 'Показывать рекламные блоки';
$string['togglemarketingdesc'] = 'Выберите, показывать или нет три рекламных блока на сайте.';
$string['toggleslideshow'] = 'Показывать слайд-шоу';
$string['toggleslideshowdesc'] = 'Выберите, показывать или нет слайд-шоу на сайте.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Введите адрес своей ленты в Twitter. (Например, https://www.twitter.com/mycollege)';
$string['twitterurl'] = 'URL-адрес Twitter';
$string['userimageborderradius'] = 'Радиус границы изображения пользователя';
$string['userimageborderradiusdesc'] = 'Укажите радиус границы между {$a->lower} и {$a->upper} пикселями изображения пользователя по всему сайту, за исключением заголовка, который использует настройку \'usermenuuserimageborderradius\'';
$string['usermenu'] = 'Меню пользователя';
$string['usermenudesc'] = 'Меню для пользователя.';
$string['usermenuuserimageborderradius'] = 'Радиус границы изображения в меню пользователя';
$string['usermenuuserimageborderradiusdesc'] = 'Укажите радиус границы между {$a->lower} и {$a->upper} пикселями изображения пользователя в меню пользователя';
$string['usersettingstitle'] = 'Пользовательские настройки';
$string['usesiteicon'] = 'Использовать значок сайта';
$string['usesiteicondesc'] = 'Использовать значок сайта, если нет логотипа.';
$string['variablewidth'] = 'Переменная ширина';
$string['versionalerttext1'] = 'Тема предназначена для другой версии Moodle.';
$string['versionalerttext2'] = 'Могут наблюдаться непредвиденные проблемы. Используйте версию темы, подходящую для вашей версии Moodle.';
$string['versionalerttitle'] = 'Предупреждение о версии:';
$string['visibleadminonly'] = 'Блоки, размещенные в области ниже, доступны только администраторам';
$string['vk'] = 'ВКонтакте';
$string['vkdesc'] = 'Введите адрес своей страницы ВКонтакте. (Например, http://www.vk.com/mycollege)';
$string['vkurl'] = 'URL-адрес ВКонтакте';
$string['website'] = 'Веб-сайт';
$string['websitedesc'] = 'Введите адрес своего сайта. (Например, http://www.pupkin.com)';
$string['websiteurl'] = 'URL-адрес веб-сайта';
$string['windows'] = 'Windows (для ПК)';
$string['windowsdesc'] = 'Введите URL-адрес своего мобильного приложения в Windows Store. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc).';
$string['windowsurl'] = 'URL-адрес Windows (для ПК)';
$string['winphone'] = 'Windows (для мобильных устройств)';
$string['winphonedesc'] = 'Введите URL-адрес своего мобильного приложения в магазине Windows Phone Store. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc).';
$string['winphoneurl'] = 'URL-адрес Windows (для мобильных устройств)';
$string['within'] = 'В пределах';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Введите адрес своего канала в YouTube. (Например, https://www.youtube.com/mycollege)';
$string['youtubeurl'] = 'URL-адрес YouTube';
