<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'ru', version '3.10'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Действие';
$string['additionalinfo'] = 'Дополнительная информация';
$string['additionalinfo_help'] = 'Текст, который будет отображаться в верхней части первой страницы анкетного опроса. (Например, инструкции, справочная информация и т. п.)';
$string['addnewquestion'] = 'Добавление вопроса: {$a}';
$string['addquestions'] = 'Добавить вопросы';
$string['addselqtype'] = 'Добавить выбранный тип вопроса';
$string['alignment'] = 'Выравнивание переключателей';
$string['alignment_help'] = 'Выберите выравнивание кнопок: вертикально (по умолчанию) или горизонтально.';
$string['all'] = 'Все';
$string['alreadyfilled'] = 'Вы уже заполнили этот анкетный опрос. Спасибо!';
$string['andaveragevalues'] = 'и среднее значение';
$string['anonymous'] = 'Анонимно';
$string['answerquestions'] = 'Ответьте на вопросы…';
$string['attempted'] = 'Ответы на опрос были сданы';
$string['attemptstillinprogress'] = 'В процессе. Сохранено:';
$string['autonumbering'] = 'Автоматическая нумерация';
$string['autonumbering_help'] = 'Автоматическая нумерация вопросов и страниц. Вы можете отключить автоматическую нумерацию для анкет с условиями ветвления.';
$string['autonumberno'] = 'Не нумеровать вопросы или страницы';
$string['autonumberpages'] = 'Автонумерация страниц';
$string['autonumberpagesandquestions'] = 'Автонумерация страниц и вопросов';
$string['autonumberquestions'] = 'Автонумерация вопросов';
$string['average'] = 'Среднее';
$string['averageposition'] = 'Средняя позиция';
$string['averagerank'] = 'Средняя оценка';
$string['bodytext'] = 'Текст';
$string['boxesnbexact'] = ' равно {$a} шт.';
$string['boxesnbmax'] = ' максимум {$a} шт.';
$string['boxesnbmin'] = ' минимум {$a} шт.';
$string['boxesnbreq'] = 'Количество флажков (галочек) для этого вопроса -';
$string['by'] = 'от';
$string['cannotviewpublicresponses'] = 'Вы не можете просматривать ответы на этот общий анкетный опрос.';
$string['chart:bipolar'] = 'Биполярная линейчатая';
$string['chart:hbar'] = 'Горизонтальная линейчатая';
$string['chart:radar'] = 'Лепестковая';
$string['chart:rose'] = 'Лепестковая с маркерами';
$string['chart:type'] = 'Тип диаграммы';
$string['chart:type_help'] = 'Выберите тип диаграммы для отображения результатов';
$string['chart:vprogress'] = 'Вертикальный индикатор';
$string['checkallradiobuttons'] = 'Проверьте все переключатели - <strong>{$a}</strong>!';
$string['checkboxes'] = 'Флажки';
$string['checkboxes_help'] = 'Введите каждый вариант в отдельной строке, чтобы пользователи могли выбрать один или несколько ответов.';
$string['checkbreaksadded'] = 'Новый разрыв страниц(ы) в позиции:';
$string['checkbreaksok'] = 'Все необходимые разрывы страниц установлены!';
$string['checkbreaksremoved'] = 'Удалены {$a} дополнительных разрыва страницы.';
$string['checknotstarted'] = 'Выбор не начат';
$string['checkstarted'] = 'Выбор начат';
$string['clicktoswitch'] = '(щелкните, чтобы изменить)';
$string['closed'] = 'Анкетный опрос был закрыт {$a}.';
$string['closedate'] = 'Использовать дату окончания';
$string['closeson'] = 'Анкетный опрос закрывается {$a}';
$string['completionsubmit'] = 'Студент должен ответить на этот опрос, чтобы выполить его';
$string['confalts'] = '- ИЛИ - <br />страница Подтверждения';
$string['configusergraph'] = 'Отображать графики для результатов «Личностного теста»';
$string['configusergraphlong'] = 'Использовать библиотеку <a href="http://www.rgraph.net/">Rgraph</a> для отображения графиков результатов «Личностного теста».';
$string['confirmdelallresp'] = 'Вы действительно хотите удалить ВСЕ ответы в этом анкетном опросе?';
$string['confirmdelchildren'] = 'Если вы удалите этот вопрос, то его дочерние вопросы также будут удалены:';
$string['confirmdelgroupresp'] = 'Вы уверены, что хотите удалить ВСЕ ответы группы «{$a}»?';
$string['confirmdelquestion'] = 'Вы уверены, что хотите удалить вопрос позиции {$a}?';
$string['confirmdelquestionresps'] = 'Это приведет к удалению ответов ({$a}), уже данных на этот вопрос.';
$string['confirmdelresp'] = 'Вы действительно хотите удалить ответ&nbsp;{$a}&nbsp;?';
$string['confpage'] = 'Текст заголовка';
$string['confpage_help'] = 'Заголовок (жирным шрифтом) и основной текст на странице подтверждения отображается после того, как пользователь завершает анкетный опрос. (URL, если он присутствует, имеет преимущество перед текстом подтверждения.) Если вы оставите это поле пустым, будет отображаться сообщение по умолчанию (Спасибо за заполнение анкетного опроса).';
$string['confpagedesc'] = 'Заголовок (жирным шрифтом) и основной текст на странице «Подтверждения» отображается после того, как пользователь завершает анкетный опрос. (URL, если он присутствует, имеет преимущество над текстом подтверждения.)';
$string['contentoptions'] = 'Параметры содержания';
$string['couldnotcreatenewsurvey'] = 'Не удалось создать новый опрос!';
$string['couldnotdelresp'] = 'Ответ удалить нельзя';
$string['createcontent'] = 'Определить содержание';
$string['createcontent_help'] = 'Выберите переключателем один из вариантов. По умолчанию - «Создать новый».';
$string['createnew'] = 'Создать новый';
$string['date'] = 'Дата';
$string['date_help'] = 'Используйте этот тип вопроса, если ожидаемый ответ - дата в корректном формате.';
$string['dateformatting'] = 'Использовать формат день/месяц/год, например - 14-ое марта, 1945: &nbsp; <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Удалить ВСЕ ответы';
$string['deletecurrentquestion'] = 'Удалить вопрос {$a}';
$string['deletedallgroupresp'] = 'Удалить ВСЕ ответы в группе {$a}';
$string['deletedallresp'] = 'Удалены ВСЕ ответы';
$string['deletedisabled'] = 'Этот элемент не может быть удален';
$string['deletedresp'] = 'Ответ удален';
$string['deleteresp'] = 'Удалить этот ответ';
$string['deletingresp'] = 'Удаление ответа';
$string['dependquestion'] = 'Родительский вопрос';
$string['dependquestion_help'] = 'Вы можете выбрать родительский вопрос и вариант ответа на него. Дочерний вопрос будет отображаться студенту только в том случае, если ранее были выбраны его родительский вопрос и ответ на него.';
$string['displaymethod'] = 'Метод показа, не определенный для вопроса.';
$string['download'] = 'Загрузить';
$string['downloadtextformat'] = 'Загрузить в текстовом формате';
$string['downloadtextformat_help'] = 'Эта функция позволяет сохранить все ответы анкетного опроса в текстовый файл (CSV). Этот файл затем может быть импортирован в электронную таблицу (например, MS Excel или Open Office Calc) или статистический пакет для дальнейшей обработки данных.';
$string['dropdown'] = 'Выпадающий список';
$string['dropdown_help'] = 'Использование выпадающего списка вместо переключателей не имеет реального преимущества, за исключением случаев с длинным списком предоставляемых вариантов ответов (список занимает меньше места на экране).';
$string['edit'] = 'Редактировать';
$string['editingquestionnaire'] = 'Редактирование Анкетного опроса - общая страница';
$string['editquestion'] = 'Редактирование вопроса {$a}';
$string['email'] = 'Адрес электронной почты';
$string['errnewname'] = 'К сожалению, это название уже используется. Выберите новое название.';
$string['erroropening'] = 'Ошибка открытия анкетного опроса.';
$string['errortable'] = 'Системная ошибка - таблица недостоверна.';
$string['essaybox'] = 'Поле Эссе';
$string['essaybox_help'] = 'В вопросе будет отображаться окно редактора шириной в Х столбцов и высотой в Y строк. Если вы оставите значения Х и Y по умолчанию - 0 (или, если вы установите его в 0), то HTML редактор будет отображаться со стандартной высотой и шириной (если редактор включен в контексте курса/пользователя и в профиле пользователя).';
$string['event_all_responses_deleted'] = 'Все ответы удалены';
$string['event_all_responses_saved_as_text'] = 'Все ответы сохранены в виде текста';
$string['event_all_responses_viewed'] = 'Просмотрен отчет «Все ответы»';
$string['event_individual_responses_viewed'] = 'Просмотрен отчет «Индивидуальный ответ»';
$string['event_non_respondents_viewed'] = 'Просмотрен список не сдавших ответы';
$string['event_previewed'] = 'Осуществлен предварительный просмотр анкетного опроса';
$string['event_question_created'] = 'Вопрос создан';
$string['event_question_deleted'] = 'Вопрос удален';
$string['event_response_deleted'] = 'Индивидуальный ответ удален';
$string['event_resumed'] = 'Попытка возобновлена';
$string['event_saved'] = 'Ответы сохранены';
$string['event_submitted'] = 'Ответы сданы';
$string['feedback'] = 'Отзыв';
$string['feedback_help'] = 'Помощь по отзыву';
$string['feedbackaddmorefeedbacks'] = 'Добавить еще поля ({no}) для отзыва';
$string['feedbackbysection'] = 'Разделы отзыва';
$string['feedbackeditingglobal'] = 'Редактирование общего отзыва на анкетный опрос';
$string['feedbackeditingmessages'] = 'Редактирование сообщений отзыва на анкетный опрос';
$string['feedbackeditingsections'] = 'Редактирование разделов отзыва на анкетный опрос';
$string['feedbackeditmessages'] = 'Сохранить настройки разделов и редактировать сообщения отзыва';
$string['feedbackeditsections'] = 'Сохранить настройки и редактировать разделы отзыва';
$string['feedbackerrorboundaryformat'] = 'Баллы в отзыве должны быть в виде процента или числа. Значение, введенное для границы {$a}, не распознано.';
$string['feedbackerrorboundaryoutofrange'] = 'Баллы в отзыве должны быть в диапазоне от 0% до 100%. Значение, введенное для границы {$a}, находится вне диапазона.';
$string['feedbackerrorjunkinboundary'] = 'Вы должны в отзыве заполнить баллы, не пропуская ни одного поля.';
$string['feedbackerrorjunkinfeedback'] = 'Вы должны заполнить все поля отзыва.';
$string['feedbackerrororder'] = 'Баллы в полях отзыва должны быть в порядке убывания. Значение, введенное для границы {$a}, находится  вне последовательности.';
$string['feedbackglobal'] = 'Общий отзыв';
$string['feedbackglobalheading'] = 'Заголовок общего отзыва';
$string['feedbackglobalmessages'] = 'Сообщения общего отзыва';
$string['feedbackhdr'] = 'Отзывы';
$string['feedbackheading'] = 'Заголовок отзыва';
$string['feedbackheading_help'] = 'В поле заголовка отзыва Вы можете использовать две переменные: $scorepercent и $oppositescorepercent.';
$string['feedbackmessages'] = 'Сообщения отзыва для раздела «{$a}»';
$string['feedbacknextsection'] = 'Следующий раздел «{$a}»';
$string['feedbacknone'] = 'Нет сообщений отзыва';
$string['feedbacknotes'] = 'Примечания отзыва';
$string['feedbacknotes_help'] = 'Введенный здесь текст будет отображаться респондентам в конце отчета с отзывом';
$string['feedbackoptions'] = 'Варианты отзыва';
$string['feedbackoptions_help'] = 'Варианты отзыва, если анкетный опрос содержит следующие типы вопросов: «Переключатель», «Выпадающий список» или «Балл». В настройках эти вопросы должны быть установлены как обязательные и должны быть заполнены их поля «Название вопроса» и перечень возможных ответов.';
$string['feedbackremovequestionfromsection'] = 'Этот вопрос является частью раздела отзыва [{$a}]';
$string['feedbackremovesection'] = 'Удаление этого вопроса приведет к полному удалению раздела отзыва [{$a}]';
$string['feedbackreport'] = 'Отчет отзыва';
$string['feedbackscore'] = 'Балл отзыва';
$string['feedbackscoreboundary'] = 'Границы баллов отзыва';
$string['feedbackscores'] = 'Показать баллы';
$string['feedbackscores_help'] = 'Отображать таблицу баллов отзыва';
$string['feedbacksection'] = 'Раздел';
$string['feedbacksectionheading'] = 'Заголовок для раздела «{$a}» отзыва';
$string['feedbacksectionheadingmissing'] = 'Вы должны ввести заголовок для этого раздела отзыва!';
$string['feedbacksectionheadingtext'] = 'Заголовок';
$string['feedbacksectionlabel'] = 'Метка';
$string['feedbacksectionlabel_help'] = 'Эта метка будет использоваться в графиках (диаграммах). Она должна быть как можно короче!';
$string['feedbacksections'] = 'Разделы отзыва {$a}';
$string['feedbacksectionsselect'] = 'Разделы';
$string['feedbacksectionsselect_help'] = 'Разместите свои вопросы в этих разделах';
$string['feedbacksettingssaved'] = 'Настройки отзыва сохранены';
$string['feedbacktype'] = 'Тип отзыва';
$string['field'] = 'Вопрос {$a}';
$string['fieldlength'] = 'Ширина поля ввода';
$string['fieldlength_help'] = 'Для типа вопроса «Текстовое поле» введите значения «Ширина поля ввода» и «Максимальная длина текста» для текста, который будет вводиться респондентом.
Значения по умолчанию — 20 символов для ширины поля ввода и 25 символов для максимальной длины вводимого текста.';
$string['finished'] = 'Вы ответили на все вопросы этого анкетного опроса!';
$string['firstrespondent'] = 'Первый респондент';
$string['formateditor'] = 'Редактор HTML';
$string['formatplain'] = 'Обычный текст';
$string['grade'] = 'Оценка представления';
$string['gradesdeleted'] = 'Оценки за опрос удалены';
$string['headingtext'] = 'Текст заголовка';
$string['horizontal'] = 'Горизонтально';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Включить коды выбранного варианта';
$string['includechoicetext'] = 'Включить текст выбранного варианта';
$string['includeincomplete'] = 'Включить неполные ответы';
$string['incorrectcourseid'] = 'ID курса ошибочен';
$string['incorrectmodule'] = 'ID модуля курса ошибочен';
$string['incorrectquestionnaire'] = 'Анкетный опрос ошибочен';
$string['invalidresponse'] = 'Определен недопустимый ответ';
$string['invalidresponserecord'] = 'Определена запись недопустимого ответа';
$string['invalidsurveyid'] = 'Недопустимый ID анкетного опроса';
$string['kindofratescale'] = 'Тип шкалы оценок';
$string['kindofratescale_help'] = 'Для получения дополнительной справки щелкните правой кнопкой мыши на ссылке, приведенной ниже.';
$string['lastrespondent'] = 'Последний респондент';
$string['length'] = 'Длина';
$string['managequestions'] = 'Управление вопросами';
$string['managequestions_help'] = 'В разделе «Управление вопросами» на странице редактирования вопросов Вы можете провести ряд операций над вопросами Анкетного опроса.';
$string['maxdigitsallowed'] = 'Разрешенный максимум цифр';
$string['maxdigitsallowed_help'] = 'Используйте параметр «Макс. позволено цифр», чтобы ограничить максимальное количество символов для числового ответа. Учтите, что десятичный разделитель тоже считается как отдельный символ!';
$string['maxforcedresponses'] = 'Принудительный максимум ответов';
$string['maxtextlength'] = 'Максимальная длина текста';
$string['messageprovider:message'] = 'Напоминание об анкетном опросе';
$string['minforcedresponses'] = 'Принудительный минимум ответов';
$string['minforcedresponses_help'] = 'Чтобы вынудить респондента отметить флажками (галочками) минимальное количество полей используйте параметр «Минимум», а «Максимум» — для максимального количества полей. Чтобы получить точное количество установленных флажков, задайте для «Минимум» и «Максимум» одно и то же значение. Если желательно только минимальное или максимальное значение, тогда оставляйте другой параметр в значении по умолчанию «0». Если Вы установите «Минимум» или «Максимум» в значение, отличное от «0» (значение по умолчанию), то респонденту будет показано предупреждающее сообщение, если он не выполнит Ваши требования.
Очевидно, Вы должны четко указать респонденту эти требования в общих инструкциях Анкетного опроса или в тексте соответствующих вопросов.';
$string['misconfigured'] = 'Неверный курс';
$string['missingname'] = 'Вопрос {$a} не может быть использован в этом разделе отзыва, потому что он не имеет имени.';
$string['missingnameandrequired'] = 'Вопрос {$a} не может быть использован в этом разделе отзыва, потому что он не имеет имени и не является обязательным.';
$string['missingquestion'] = 'Ошибка! Требуется ответ на вопрос';
$string['missingquestions'] = 'Ошибка! Требуются ответы на вопросы:';
$string['missingrequired'] = 'Вопрос {$a} не может быть использован в этом разделе отзыва, потому что он не является обязательным.';
$string['modulename'] = 'Анкетный опрос';
$string['modulename_help'] = 'Модуль «Анкетный опрос» позволяет провести опрос с целью сбора данных от пользователей, используя различные типы вопросов.';
$string['modulenameplural'] = 'Анкетные опросы';
$string['movedisabled'] = 'Этот элемент не может быть перемещен';
$string['myresponses'] = 'Все Ваши ответы';
$string['myresponsetitle'] = 'Результаты Ваших ответов - {$a}';
$string['myresults'] = 'Мои результаты';
$string['name'] = 'Название';
$string['navigate'] = 'Разрешить подчиненные вопросы';
$string['navigate_help'] = 'Разрешить в анкете дочерние вопросы, зависящие от выбора ответов на родительские вопросы типов «Да/Нет» и «Переключатель».';
$string['next'] = 'Далее';
$string['nextpage'] = 'Следующая страница';
$string['nlines'] = 'строк - {$a}';
$string['noanswer'] = 'Нет ответа';
$string['noattempts'] = 'Нет попыток ответов на этот опрос';
$string['nodata'] = 'Данные не представлены';
$string['noduplicates'] = 'Без повторяющихся ответов';
$string['noduplicateschoiceserror'] = 'Вы должны ввести хотя бы два возможных ответа для варианта «Без повторяющихся ответов»!';
$string['non_respondents'] = 'Пользователи, которые еще не сдали свои ответы на этот анкетный опрос';
$string['noneinuse'] = 'Этот анкетный опрос не содержит никаких вопросов.';
$string['nopublicsurveys'] = 'Нет общих анкетных опросов';
$string['noresponsedata'] = 'Нет ответов на этот вопрос.';
$string['noresponses'] = 'Нет ответов';
$string['normal'] = 'Обычный';
$string['not_started'] = 'не начато';
$string['notanumber'] = '<strong>{$a}</strong> - недопустимый формат числа';
$string['notapplicable'] = 'Н/О';
$string['notapplicablecolumn'] = 'Колонка Н/О';
$string['notavail'] = 'Этот анкетный опрос не готов! Попробуйте позже...';
$string['noteligible'] = 'Вы не можете заполнить этот анкетный опрос.';
$string['notemplatesurveys'] = 'Нет шаблона анкет';
$string['notenoughscaleitems'] = 'Вы должны ввести как минимум два элемента шкалы!';
$string['notopen'] = 'Этот анкетный опрос не будет открыт до {$a}';
$string['notrequired'] = 'Ответ не обязателен';
$string['nousersselected'] = 'Пользователи не выбраны';
$string['num'] = '№';
$string['numattemptsmade'] = 'Попыток ответа на этот опрос - {$a}';
$string['numberfloat'] = 'Введенное Вами число <strong>{$a->number}</strong> было округлено с точностью <strong>{$a->precision}</strong> десятичных цифр.';
$string['numberofdecimaldigits'] = 'Количество десятичных цифр';
$string['numberscaleitems'] = 'Количество элементов шкалы';
$string['numberscaleitems_help'] = 'Количество элементов шкалы является «числом пунктов», используемых в Вашей шкале оценивания. Обычно используется значение 3 — 5. Значение по умолчанию: «5».';
$string['numeric'] = 'Числовой';
$string['numeric_help'] = 'Используйте этот тип вопроса, если ожидаемый ответ - число в корректном формате.';
$string['of'] = 'от';
$string['opendate'] = 'Использовать дату начала';
$string['option'] = 'Параметр {$a}';
$string['optionalname'] = 'Название вопроса';
$string['optionalname_help'] = 'Название вопроса используется только при экспорте ответов в формат CSV/Excel. Если Вы не будете экспортировать в CSV, то о названиях вопросов можно вообще не беспокоиться. Если Вы планируете регулярно экспортировать данные анкетного опроса в CSV, то Вы можете выбрать один из двух вариантов для названий вопросов.';
$string['or'] = '- ИЛИ -';
$string['order_ascending'] = 'По возрастанию';
$string['order_default'] = 'Порядок по умолчанию';
$string['order_descending'] = 'По убыванию';
$string['orderresponses'] = 'Порядок ответов';
$string['orderresponses_help'] = 'При отображении всех ответов Вы можете определить порядок по количеству ответов (столбец «Среднее») для следующих 4 типов вопросов:

* одиночный выбор (переключатель)
* одиночный выбор (выпадающий список)
* множественный выбор (флажки)
* баллы вопросов (в том числе шкалы Лайкерта).

Ответы на странице «Все ответы» по умолчанию упорядочены в том порядке, в котором они вводились при создании анкетного опроса.
Вы можете выбрать отображение результатов по возрастанию или по убыванию.';
$string['osgood'] = 'Осгуд';
$string['other'] = 'Другое:';
$string['otherempty'] = 'Если Вы отметили этот вариант, Вы должны ввести некий текст в текстовое поле!';
$string['overviewnumresplog'] = 'ответы';
$string['overviewnumresplog1'] = 'ответ';
$string['overviewnumrespvw'] = 'ответы';
$string['overviewnumrespvw1'] = 'ответ';
$string['owner'] = 'Владелец';
$string['page'] = 'Страница';
$string['pageof'] = 'Страница {$a->page} из {$a->totpages}';
$string['participant'] = 'Участник';
$string['pleasecomplete'] = 'Пожалуйста, заполните этот выбор.';
$string['pluginadministration'] = 'Управление анкетным опросом';
$string['pluginname'] = 'Анкетный опрос';
$string['position'] = 'позиция';
$string['possibleanswers'] = 'Возможные ответы';
$string['posteddata'] = 'Достигнутая страница с размещенными данными:';
$string['preview_label'] = 'Предпросмотр';
$string['preview_questionnaire'] = 'Предпросмотр анкетного опроса';
$string['previewing'] = 'Предпросмотр Анкеты';
$string['previous'] = 'Назад';
$string['previouspage'] = 'Предыдущая страница';
$string['print'] = 'Печатать с ответами';
$string['printblank'] = 'Печатать бланк анкеты';
$string['printblanktooltip'] = 'Открыть удобное для печати окно с пустым Анкетным опросом';
$string['printtooltip'] = 'Открыть удобное для печати окно с текущими ответами';
$string['private'] = 'Личный';
$string['public'] = 'Общий';
$string['publiccopy'] = 'Копия:';
$string['publicoriginal'] = 'Оригинал:';
$string['qtype'] = 'Тип';
$string['qtype_help'] = 'Выберите: пользователи будут иметь возможность ответить один раз, ежедневно, еженедельно, ежемесячно или неоднократно.';
$string['qtypedaily'] = 'отвечать ежедневно';
$string['qtypemonthly'] = 'отвечать ежемесячно';
$string['qtypeonce'] = 'отвечать один раз';
$string['qtypeunlimited'] = 'отвечать многократно';
$string['qtypeweekly'] = 'отвечать еженедельно';
$string['questionnaire:addinstance'] = 'Добавлять новый экземпляр анкетного опроса';
$string['questionnaire:copysurveys'] = 'Копировать шаблоны и личные анкетные опросы';
$string['questionnaire:createpublic'] = 'Создавать общий анкетный опрос';
$string['questionnaire:createtemplates'] = 'Создавать шаблон анкетного опроса';
$string['questionnaire:deleteresponses'] = 'Удалять любые ответы';
$string['questionnaire:downloadresponses'] = 'Загружать ответы в CSV-файле';
$string['questionnaire:editquestions'] = 'Создавать и редактировать вопросы анкетного опроса';
$string['questionnaire:manage'] = 'Создавать и редактировать анкетные опросы';
$string['questionnaire:message'] = 'Отправлять сообщения не сдавшим ответы на опрос';
$string['questionnaire:preview'] = 'Осуществлять предварительный просмотр анкетного опроса';
$string['questionnaire:printblank'] = 'Печатать бланк опроса';
$string['questionnaire:readallresponseanytime'] = 'Просматривать все ответы в любое время';
$string['questionnaire:readallresponses'] = 'Просматривать сводку по ответам в соответствии с заданным временем доступности';
$string['questionnaire:readownresponses'] = 'Просматривать собственные ответы';
$string['questionnaire:submit'] = 'Заполнять анкетный опрос и сдавать ответы';
$string['questionnaire:view'] = 'Просматривать анкетный опрос';
$string['questionnaire:viewsingleresponse'] = 'Просматривать заполненные индивидуальные ответы';
$string['questionnaireadministration'] = 'Управление анкетным опросом';
$string['questionnairecloses'] = 'Опрос закрывается';
$string['questionnaireopens'] = 'Опрос открывается';
$string['questionnairereport'] = 'Отчет Анкетного опроса';
$string['questionnum'] = 'Вопрос №';
$string['questions'] = 'Вопросы';
$string['questionsinsection'] = 'Вопросы в этом разделе:';
$string['questiontypes'] = 'Типы вопросов';
$string['questiontypes_help'] = 'См. ниже документацию Moodle';
$string['radiobuttons'] = 'Переключатель';
$string['radiobuttons_help'] = 'В этом типе вопроса респондент должен выбрать один из предлагаемых вариантов.';
$string['rank'] = 'Ранг';
$string['ratescale'] = 'Балл (шкала 1...5)';
$string['ratescale_help'] = 'См. ниже документацию Moodle';
$string['realm'] = 'Тип анкетного опроса';
$string['realm_help'] = 'Сейчас есть три типа анкетных опросов:
 * Личный - принадлежит только курсу, в котором он создан.
 * Шаблон - может быть скопирован и отредактирован.
 * Общий - может использоваться в других курсах.';
$string['redirecturl'] = 'URL-адрес, к которому пользователь переадресовывается после завершения этого анкетного опроса.';
$string['remove'] = 'Удалить';
$string['removeallquestionnaireattempts'] = 'Удалить все ответы на вопросы';
$string['removenotinuse'] = 'В этом опросе используются вопросы из общего опроса, который был удален. Этот опрос не может больше использоваться и должен быть удален.';
$string['required'] = 'Ответ обязателен';
$string['required_help'] = 'Если Вы выберете «Да», то ответ на этот вопрос будет обязательным, то есть респондент не сможет сдать ответы на анкетный опрос, пока не ответит на этот вопрос.';
$string['requiredparameter'] = 'Отсутствует обязательный параметр.';
$string['reset'] = 'Сброс';
$string['respeligiblerepl'] = '(заменяется переопределенной ролью)';
$string['respondent'] = 'Респондент';
$string['respondenteligibleall'] = 'все';
$string['respondenteligiblestudents'] = 'только студенты';
$string['respondenteligibleteachers'] = 'только преподаватели';
$string['respondents'] = 'Респонденты';
$string['respondenttype'] = 'Вид респондента';
$string['respondenttype_help'] = 'Вы можете показать полные имена пользователей в каждом ответе, путем выбора параметра «полное имя».
Вы можете скрыть пользователей из ответов, выбрав параметр «анонимно».';
$string['respondenttypeanonymous'] = 'анонимно';
$string['respondenttypefullname'] = 'полное имя';
$string['response'] = 'Ответ';
$string['responsefieldlines'] = 'Размер поля ввода';
$string['responseformat'] = 'Формат ответа';
$string['responseoptions'] = 'Варианты ответа';
$string['responses'] = 'Ответа (ов)';
$string['responseview'] = 'Студенты могут видеть ВСЕ ответы';
$string['responseview_help'] = 'Вы можете определить, кто может видеть ответы всех респондентов в заполненных анкетных опросах (таблицы общей статистики).';
$string['responseviewstudentsalways'] = 'Всегда';
$string['responseviewstudentsnever'] = 'Никогда';
$string['responseviewstudentswhenanswered'] = 'После ответа на анкетный опрос';
$string['responseviewstudentswhenclosed'] = 'После того, как анкетный опрос закрыт';
$string['restrictedtoteacher'] = 'Эти функции могут редактировать только преподаватели!';
$string['resume'] = 'Сохранить/продолжить ответы';
$string['resume_help'] = 'Установка этого параметра позволяет пользователям сохранять свои ответы на анкетный опрос перед их сдачей.
Пользователи смогут оставить опрос незавершенным и позже продолжить с сохраненными ответами.';
$string['resumesurvey'] = 'Возобновить Анкетный опрос';
$string['return'] = 'Возврат';
$string['save'] = 'Сохранить';
$string['saveasnew'] = 'Сохранить как новый вопрос';
$string['savedbutnotsubmitted'] = 'Этот анкетный опрос был сохранен, но еще не сдан.';
$string['savedprogress'] = 'Ваши изменения сохранены. Вы можете вернуться в любое время, чтобы завершить этот анкетный опрос.';
$string['saveeditedquestion'] = 'Сохранить вопрос {$a}';
$string['savesettings'] = 'Сохранить настройки';
$string['section'] = 'Описание';
$string['sectionbreak'] = '----- Разрыв страницы -----';
$string['sectionbreak_help'] = '----- Разрыв страницы -----';
$string['sectionsnotset'] = 'Вы должны выбрать по меньшей мере ОДИН вопрос для каждого из разделов! <br /> Раздел(ы) без вопросов: {$a}';
$string['sectiontext'] = 'Метка';
$string['sectiontext_help'] = 'Это не вопрос, а короткий текст, отображаемый перед группой вопросов.';
$string['selecttheme'] = 'Выберите тему (css) для использования в этой анкете.';
$string['send'] = 'Отправить';
$string['send_message'] = 'Отправить сообщение выбранным пользователям';
$string['send_message_to'] = 'Отправить сообщение:';
$string['sendemail'] = 'Отправить по электронной почте.';
$string['sendemail_help'] = 'Посылает копию каждого представленного опроса по указанному адресу или адресам.
Вы можете предусмотреть более одного адреса, разделяя их запятыми.
Оставьте пустым, если письма не требуются.';
$string['settings'] = 'Настройки';
$string['settingssaved'] = 'Настройки сохранены';
$string['show_nonrespondents'] = 'Не сдавшие ответы';
$string['started'] = 'начато';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Тема';
$string['submitoptions'] = 'Параметры завершения';
$string['submitpreview'] = 'Предварительный просмотр сдаваемого варианта';
$string['submitpreviewcorrect'] = 'Это сдаваемый вариант будет принят как правильно заполненный.';
$string['submitsurvey'] = 'Сдать ответы на опрос';
$string['submitted'] = 'Сдано:';
$string['subtitle'] = 'Подзаголовок';
$string['subtitle_help'] = 'Подзаголовок этого анкетного опроса. Отображается только на первой странице ниже названия.';
$string['summary'] = 'Сводка';
$string['surveynotexists'] = 'анкетный опрос не существует.';
$string['surveyowner'] = 'Вы должны быть владельцем анкетного опроса, чтобы выполнить это действие.';
$string['surveyresponse'] = 'Ответ для анкетного опроса';
$string['template'] = 'Шаблон';
$string['templatenotviewable'] = 'Шаблон анкетного опроса не отображается в курсе.';
$string['text'] = 'Текст вопроса';
$string['textareacolumns'] = 'Ширина текстового поля';
$string['textareacolumns_help'] = 'Этот вопрос выглядит в виде пустого текстового поля с числом «x» столбцов в текстовом поле («ширина» поля) и числом «y» строк текстового поля («высота» поля).
Если Вы установите и для «x», и для «y» значения по умолчанию ( «0» ), то HTML-редактор будет отображен со стандартной высотой и шириной (если редактор выбран в профиле пользователя).';
$string['textarearows'] = 'Строки текстового поля';
$string['textbox'] = 'Текстовое поле';
$string['textbox_help'] = 'Для вопроса типа «Текстовое поле» введите высоту поля и максимальную длину текста, который может быть введен при ответе. Значения по умолчанию: 20 символов — высота поля и 25 символов — максимальная длина вводимого текста.';
$string['textdownloadoptions'] = 'Параметры для загрузки текста (CSV)';
$string['thank_head'] = 'Спасибо за завершение этого Анкетного опроса.';
$string['theme'] = 'Тема';
$string['thismonth'] = 'этот месяц';
$string['thisresponse'] = 'Этот ответ';
$string['thisweek'] = 'эта неделя';
$string['title'] = 'Заголовок';
$string['title_help'] = 'Заголовок этого анкетного опроса, который отображается вверху каждой страницы. По умолчанию Заголовком является Название анкетного опроса, но при желании Вы можете его отредактировать.';
$string['today'] = 'сегодня';
$string['total'] = 'Всего';
$string['totalresponses'] = 'Всего ответов на вопрос';
$string['type'] = 'Тип вопроса';
$string['undefinedquestiontype'] = 'Неопределенный тип вопроса!';
$string['unknown'] = 'Неизвестно';
$string['unknownaction'] = 'Определено неизвестное действие анкетного опроса ...';
$string['url'] = 'URL-адрес';
$string['url_help'] = 'URL-адрес, к которому пользователь переадресовывается после завершения этого анкетного опроса.';
$string['useprivate'] = 'Скопировать существующий';
$string['usepublic'] = 'Использовать общий';
$string['usetemplate'] = 'Использовать шаблон';
$string['vertical'] = 'Вертикально';
$string['view'] = 'Просмотр';
$string['viewallresponses'] = 'Просмотр всех ответов';
$string['viewallresponses_help'] = 'Если в анкетном опросе для параметра «Групповой режим» установлено значение «Видимые группы», а также если выбран режим «Изолированные группы», у пользователя есть право «moodle/site:accessallgroups» в текущем контексте, а в курсе определены группы, то пользователь получит доступ к выпадающему списку групп.
Этот выпадающий список позволяет пользователю «фильтровать» ответы на опрос по группам.
Если для параметра «Групповой режим» установлено в значение «Изолированные группы», пользователи, у которых нет права «moodle/site:accessallgroups» (обычно это студенты и ассистенты) смогут видеть только ответы групп, к которым они принадлежат.';
$string['viewbyresponse'] = 'Список ответов';
$string['viewindividualresponse'] = 'Индивидуальные ответы';
$string['viewindividualresponse_help'] = 'Щелкайте мышкой в приведенном ниже списке на именах респондентов, чтобы просмотреть их индивидуальные ответы.';
$string['viewresponses'] = 'Все ответы: ответов - {$a}';
$string['viewyourresponses'] = 'Ваши ответы: ответов - {$a}';
$string['warning'] = 'Внимание, замечена ошибка.';
$string['wronganswers'] = 'Что-то не так с Вашими ответами (см. ниже)';
$string['wrongdateformat'] = 'Введенная дата: <strong>{$a}</strong> не соответствует формату, указанному в примере.';
$string['wrongdaterange'] = 'ОШИБКА! Год должен быть установлен в диапазоне 1902 - 2037.';
$string['wrongformat'] = 'Что-то не так с Вашим ответом на вопрос:&nbsp;';
$string['wrongformats'] = 'Что-то не так с Вашими ответами на вопросы:&nbsp;';
$string['yesno'] = 'Да/Нет';
$string['yesno_help'] = 'Простой вопрос Да/Нет';
$string['yourresponse'] = 'Ваш ответ';
$string['yourresponses'] = 'Ваши ответы';
