<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'ru', version '3.10'.
 *
 * @package     local_moodlecloudsignup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'Пароль изменен';
$string['FOSUserBundle:change_password.submit'] = 'Изменить пароль';
$string['FOSUserBundle:form.current_password'] = 'Текущий пароль:';
$string['FOSUserBundle:form.email'] = 'Электронная почта:';
$string['FOSUserBundle:form.group_name'] = 'Название группы:';
$string['FOSUserBundle:form.new_password'] = 'Новый пароль:';
$string['FOSUserBundle:form.new_password_confirmation'] = 'Подтвердите пароль:';
$string['FOSUserBundle:form.password'] = 'Пароль:';
$string['FOSUserBundle:form.password_confirmation'] = 'Подтвердите пароль:';
$string['FOSUserBundle:form.username'] = 'Логин:';
$string['FOSUserBundle:group.edit.submit'] = 'Обновить группу';
$string['FOSUserBundle:group.flash.created'] = 'Группа создана';
$string['FOSUserBundle:group.flash.deleted'] = 'Группа удалена';
$string['FOSUserBundle:group.flash.updated'] = 'Группа обновлена';
$string['FOSUserBundle:group.new.submit'] = 'Создать группу';
$string['FOSUserBundle:group.show.name'] = 'Название группы';
$string['FOSUserBundle:layout.logged_in_as'] = 'Вы вошли как %username%';
$string['FOSUserBundle:layout.login'] = 'Вход';
$string['FOSUserBundle:layout.logout'] = 'Выход';
$string['FOSUserBundle:layout.register'] = 'Регистрация';
$string['FOSUserBundle:profile.edit.submit'] = 'Обновить';
$string['FOSUserBundle:profile.flash.updated'] = 'Профиль пользователя обновлен';
$string['FOSUserBundle:profile.show.email'] = 'Электронная почта';
$string['FOSUserBundle:profile.show.username'] = 'Логин';
$string['FOSUserBundle:registration.back'] = 'Вернуться на предыдущую страницу.';
$string['FOSUserBundle:registration.check_email'] = 'На адрес %email% отправлено письмо. В нём содержится ссылка, по которой вы можете подтвердить свою учетную запись.';
$string['FOSUserBundle:registration.confirmed'] = 'Поздравляем, %username%, Ваша учетная запись подтверждена.';
$string['FOSUserBundle:registration.email.message'] = 'Здравствуйте, %username%!

Для подтверждения вашей регистрации пройдите по ссылке %confirmationUrl%

С наилучшими пожеланиями,
команда MoodleCloud.';
$string['FOSUserBundle:registration.email.subject'] = 'Добро пожаловать, %username%!';
$string['FOSUserBundle:registration.flash.user_created'] = 'Пользователь успешно создан';
$string['FOSUserBundle:registration.submit'] = 'Регистрация';
$string['FOSUserBundle:resetting.check_email'] = 'На адрес %email% отправлено письмо. Оно содержит ссылку, при переходе по которой Ваш пароль будет сброшен.';
$string['FOSUserBundle:resetting.email.message'] = 'Здравствуйте, %username%!

Для сброса пароля, пожалуйста, пройдите по ссылке %confirmationUrl%

С наилучшими пожеланиями,
команда MoodleCloud.';
$string['FOSUserBundle:resetting.email.subject'] = 'Сброс пароля';
$string['FOSUserBundle:resetting.flash.success'] = 'Пароль успешно сброшен';
$string['FOSUserBundle:resetting.password_already_requested'] = 'Сброс пароля для данного пользователя уже запрашивался в течение последних 24 часов.';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'Логин или адрес электронной почты «%username%» не существует.';
$string['FOSUserBundle:resetting.request.submit'] = 'Сбросить пароль';
$string['FOSUserBundle:resetting.request.username'] = 'Логин или адрес электронной почты:';
$string['FOSUserBundle:resetting.reset.submit'] = 'Изменить пароль';
$string['FOSUserBundle:security.login.password'] = 'Пароль:';
$string['FOSUserBundle:security.login.remember_me'] = 'Запомнить меня';
$string['FOSUserBundle:security.login.submit'] = 'Войти';
$string['FOSUserBundle:security.login.username'] = 'Логин:';
$string['homepage:body.intro'] = 'Бесплатный хостинг Moodle от создателей Moodle.';
$string['homepage:body.title'] = 'MoodleCloud';
$string['homepage:general.faq'] = 'ЧАВО';
$string['homepage:general.servicestatus'] = 'Состояние службы';
$string['homepage:page.description'] = 'Решения, предоставленные хостингом Moodle, делают возможным всем создавать обучающие приложения «в облаке»';
$string['homepage:page.title'] = 'MoodleCloud: Бесплатные услуги хостинга от создателей Moodle';
$string['langconfig:direction'] = 'ltr';
$string['langconfig:langname'] = 'Русский';
$string['login:security.login.password'] = 'Пароль';
$string['login:security.login.password_placeholder'] = 'Пароль';
$string['login:security.login.submit'] = 'Войти';
$string['login:security.login.username'] = 'Имя пользователя MoodleCloud';
$string['login:security.login.username_placeholder'] = 'mysite.moodlecloud.com';
$string['messages:auditlog.administrator'] = 'Администрация MoodleCloud';
$string['messages:auditlog.automatedtool'] = 'Бот MoodleCloud';
$string['messages:auditlog.site.removalComplete'] = 'Этот сайт был удален';
$string['messages:auditlog.site.removalQueued'] = 'Было запрошено удаление сайта';
$string['messages:close'] = 'Закрыть';
$string['pluginname'] = 'Языковые строки портала MoodleCloud';
$string['portal:addons.buttons.add'] = 'Добавить';
$string['portal:addons.buttons.remove'] = 'Удалить';
$string['portal:addons.buttons.removing'] = 'Идет удаление';
$string['portal:addons.errors.doesnotexist'] = 'Указанное Вами дополнение не существует';
$string['portal:addons.nostudentads.description'] = 'Администраторы и учителя по-прежнему будут видеть рекламные объявления об услугах, связанных с Moodle.';
$string['portal:addons.nostudentads.flashes.disabled'] = 'С Вас больше не будут списываться средства за использование этого дополнения. После завершения этого периода оплаты (%billingendperiod%) студентам на Вашем сайте снова будет демонстрироваться реклама.';
$string['portal:addons.nostudentads.flashes.disabled.failed'] = 'Во время отключения рекламы произошла ошибка. Пожалуйста, попробуйте еще раз через некоторое время или свяжитесь с нами.';
$string['portal:addons.nostudentads.flashes.enabled'] = 'Спасибо за поддержку! Студентам на Вашем сайте больше не будет демонстрироваться реклама.';
$string['portal:addons.nostudentads.label'] = 'Реклама';
$string['portal:addons.nostudentads.removalconfirmation.body'] = 'С Вас больше не будут списываться средства за использование этого дополнения. После завершения этого периода оплаты студентам на Вашем сайте снова будет демонстрироваться реклама.';
$string['portal:addons.nostudentads.removalconfirmation.title'] = 'Удалить дополнение';
$string['portal:addons.nostudentads.states.disabled'] = 'Сейчас Ваш сайт демонстрирует студентам рекламу Google Ads, чтобы возместить наши расходы на бесплатный хостинг.';
$string['portal:addons.nostudentads.states.enabled'] = 'Ваш сайт не отображает студентам рекламу Google Ads, потому что Вы оплатили отключение рекламы.';
$string['portal:addons.nostudentads.title'] = 'Не отображать студентам рекламу';
$string['portal:addons.panel.lead'] = 'Вот некоторые дополнительные возможности по улучшению Вашего сайта';
$string['portal:addons.panel.title'] = 'Дополнения';
$string['portal:addons.pay'] = 'Перейти к оплате';
$string['portal:addons.strings.month'] = 'месяц';
$string['portal:addons.strings.price'] = '%price% %currency% в %period%';
$string['portal:billing.billingdetails.change.fields.cancel'] = 'Отмена';
$string['portal:billing.billingdetails.change.fields.save'] = 'Сохранить';
$string['portal:billing.billingdetails.change.labels.ccname'] = 'Имя держателя карты';
$string['portal:billing.billingdetails.change.labels.ccnumber'] = 'Номер кредитной карты';
$string['portal:billing.billingdetails.change.labels.cvv'] = 'CVV';
$string['portal:billing.billingdetails.change.labels.expiration'] = 'Окончание срока действия карты (ММ/ГГ)';
$string['portal:billing.billingdetails.change.panel.cardrequiredbecause'] = 'Данные Вашей кредитной карты хранятся в системе обработки платежей PayPal. Компания Moodle Pty Ltd не сохраняет эти данные и не имеет к ним доступа.';
$string['portal:billing.billingdetails.change.panel.title'] = 'Информация о карте';
$string['portal:billing.billingdetails.change.panel.verificationamount'] = 'Внимание: Для проверки данных Вашей кредитной карты на ней будет заблокирована небольшая сумма (обычно 1$), а затем эта операция будет отменена. Эта операция исчезнет из списка операций по карте через несколько дней, а сумма не будет списана.';
$string['portal:billing.billingdetails.change.placeholders.ccname'] = 'Ivan Ivanov';
$string['portal:billing.billingdetails.change.placeholders.expiration'] = 'ММ/ГГ';
$string['portal:billing.billingdetails.set.fields.save'] = 'Далее';
$string['portal:billing.billingdetails.strings.changepaymentdetails'] = 'Изменить данные для оплаты';
$string['portal:billing.billingdetails.strings.usethis'] = 'Использовать этот способ оплаты';
$string['portal:billing.errors.hard.addnewmethod'] = 'Во время проверки информации о карте произошла ошибка. Возможно, Вам следует проверить введенные данные и попробовать снова.';
$string['portal:billing.errors.hard.cancellation'] = 'Во время отмены платежа произошла ошибка. Мы свяжемся с Вами, как только эта проблема будет решена.';
$string['portal:billing.errors.hard.gateway'] = 'В настоящий момент обработка платежей невозможна. Пожалуйста, попробуйте позже.';
$string['portal:billing.errors.hard.generic'] = 'Во время обработки платежа произошла ошибка. Пожалуйста, проверьте информацию, связанную с выбранным способом оплаты.';
$string['portal:billing.errors.hard.updatenewmethod'] = 'Ваши данные для оплаты были сохранены, но во время обновления Вашей подписки произошла ошибка. Мы свяжемся с Вами, как только эта проблема будет решена.';
$string['portal:billing.errors.soft.contactbank'] = 'Во время обработки платежа произошла ошибка. Пожалуйста, свяжитесь с Вашим банком или попробуйте снова через некоторое время.';
$string['portal:billing.errors.soft.duplicate'] = 'Похоже, что Вы нажали кнопку слишком быстро: пожалуйста, проверьте, завершилась ли транзакция.';
$string['portal:billing.errors.soft.generic'] = 'Во время обработки платежа произошла ошибка. Пожалуйста, попробуйте снова через некоторое время.';
$string['portal:billing.errors.soft.wrongcardtype'] = 'К сожалению, мы не принимаем карты того типа, который Вы используете. Пожалуйста, используйте другую карту.';
$string['portal:billing.events.chargedsuccessfully.html'] = '<h1>Оплата услуг MoodleCloud прошла успешно</h1>
<p>Благодарим Вас за продление услуг MoodleCloud. Мы желаем Вам всего самого лучшего в нашем совместном путешествии в мир образования.</p>
<p>Информация о Вашем пакете услуг
<ul><li><a href="%url%">%fqdn%</a></li>
<li>Дата следующего платежа: %nextBillingDate%</li>
</p>
<p>Вам есть, что сказать?</p>
<p>Вступайте в <a href="https://moodleassociation.org">Ассоциацию пользователей Moodle</a>, чтобы принять участие в составлении плана развития Moodle.</p>
<p>Благодарим Вас за использование MoodleCloud!</p>
<p>Команда MoodleCloud</p>';
$string['portal:billing.events.chargedsuccessfully.plain'] = 'Оплата услуг MoodleCloud прошла успешно

Благодарим Вас за продление услуг MoodleCloud. Мы желаем Вам всего самого лучшего в нашем совместном путешествии в мир образования.
Информация о Вашем пакете услуг
 * %url%
 * Дата следующего платежа: %nextBillingDate%

Вам есть, что сказать?

Вступайте в Ассоциацию пользователей Moodle (https://moodleassociation.org), чтобы принять участие в составлении плана развития Moodle.

Благодарим Вас за использование MoodleCloud!

Команда MoodleCloud';
$string['portal:billing.events.chargedsuccessfully.title'] = 'Оплата услуг MoodleCloud прошла успешно';
$string['portal:billing.events.chargedunsuccessfully.html'] = '<h1>О нет! Произошла ошибка оплаты услуг MoodleCloud</h1>
<p>Мы попытались продлить подписку на услуги MoodleCloud, используя Ваши текущие данные для оплаты, но попытка платежа была отклонена.</p>
<p>Пожалуйста, зайдите на <a href="https://moodlecloud.com/ru/">Портал MoodleCloud</a>, чтобы убедиться, что Ваши данные для оплаты актуальны.</p>
<p>Если следующая попытка платежи также будет отклонена, Ваша подписка будет отменена и студентам на вашем сайте снова будет демонстрироваться реклама</p>
<p>Благодарим Вас за использование MoodleCloud!</p>
<p>Команда MoodleCloud</p>';
$string['portal:billing.events.chargedunsuccessfully.plain'] = 'О нет! Произошла ошибка оплаты услуг MoodleCloud

Мы попытались продлить подписку на услуги MoodleCloud, используя Ваши текущие данные для оплаты, но попытка платежа была отклонена.

Следующая попытка оплаты будет предпринята %nextBillingDate%. Пожалуйста, зайдите на <a href="https://moodlecloud.com/ru/">Портал MoodleCloud</a>, чтобы убедиться, что Ваши данные для оплаты актуальны.

Если следующая попытка платежи также будет отклонена, Ваша подписка будет отменена и студентам на вашем сайте снова будет демонстрироваться реклама.

Благодарим Вас за использование MoodleCloud!

Команда MoodleCloud';
$string['portal:billing.events.chargedunsuccessfully.title'] = 'О нет! Произошла ошибка оплаты услуг MoodleCloud';
$string['portal:billing.events.wentpastdue.html'] = '<h1>О нет! В очередной раз произошла ошибка оплаты услуг MoodleCloud</h1>
<p>Попытка провести регулярный платеж за дополнение «Не отображать студентам рекламу» на Вашем сайте <a href="%url%">%fqdn%</a> была отклонена 3 раза. (Мы предполагаем, что Вам следует проверить состояние Вашей кредитной карты в организации, выдавшей карту).</p>
<p>Студентам на Вашем сайте снова будет демонстрироваться реклама.</p>
<p>Вы можете в любое время возобновить подписку на дополнение «Не отображать студентам рекламу», посетив <a href="https://moodlecloud.com/ru/">портал MoodleCloud</a>.</p>
<p>Благодарим Вас за использование MoodleCloud!</p>
<p>Команда MoodleCloud</p>';
$string['portal:billing.events.wentpastdue.plain'] = 'О нет! В очередной раз произошла ошибка оплаты услуг MoodleCloud

Попытка провести регулярный платеж за дополнение «Не отображать студентам рекламу» на Вашем сайте %url% была отклонена 3 раза. (Мы предполагаем, что Вам следует проверить состояние Вашей кредитной карты в организации, выдавшей карту).

Студентам на Вашем сайте снова будет демонстрироваться реклама.

Вы можете в любое время возобновить подписку на дополнение «Не отображать студентам рекламу», посетив портал MoodleCloud: https://moodlecloud.com/ru/.

Благодарим Вас за использование MoodleCloud!

Команда MoodleCloud';
$string['portal:billing.events.wentpastdue.title'] = 'О нет! В очередной раз произошла ошибка оплаты услуг MoodleCloud';
$string['portal:billing.paymentMethods.mastercard'] = 'MasterCard';
$string['portal:billing.paymentMethods.panel.title'] = 'Пожалуйста, выберите способ оплаты для Вашей учетной записи MoodleCloud.';
$string['portal:billing.paymentMethods.visa'] = 'Visa';
$string['portal:billing.subscriptions.panel.title'] = 'Регулярные платежи';
$string['portal:billing.subscriptions.statuses.Active.title'] = 'Активно';
$string['portal:billing.subscriptions.statuses.Canceled.title'] = 'Отменено';
$string['portal:billing.subscriptions.statuses.Expired.title'] = 'Просрочено';
$string['portal:billing.subscriptions.statuses.Pending.title'] = 'В ожидании';
$string['portal:billing.subscriptions.table.nextBillingDate.title'] = 'Дата следующего платежа';
$string['portal:billing.subscriptions.table.nextBillingPeriodAmount.title'] = 'Сумма';
$string['portal:billing.subscriptions.table.planId.title'] = 'План';
$string['portal:billing.subscriptions.table.status.title'] = 'Статус';
$string['portal:billing.transactions.panel.title'] = 'История платежей';
$string['portal:billing.transactions.statuses.authorization_expired.title'] = 'Неудачно';
$string['portal:billing.transactions.statuses.authorized.title'] = 'Авторизовано';
$string['portal:billing.transactions.statuses.authorizing.title'] = 'В обработке';
$string['portal:billing.transactions.statuses.failed.title'] = 'Неудачно';
$string['portal:billing.transactions.statuses.gateway_rejected.title'] = 'Неудачно';
$string['portal:billing.transactions.statuses.processor_declined.title'] = 'Неудачно';
$string['portal:billing.transactions.statuses.settled.title'] = 'Транзакция завершена';
$string['portal:billing.transactions.statuses.settlement_confirmed.title'] = 'Транзакция завершена';
$string['portal:billing.transactions.statuses.settlement_declined.title'] = 'Неудачно';
$string['portal:billing.transactions.statuses.settlement_pending.title'] = 'Авторизовано';
$string['portal:billing.transactions.statuses.settling.title'] = 'Авторизовано';
$string['portal:billing.transactions.statuses.submitted_for_settlement.title'] = 'Авторизовано';
$string['portal:billing.transactions.statuses.unrecognized.title'] = 'Неизвестно';
$string['portal:billing.transactions.statuses.voided.title'] = 'Неудачно';
$string['portal:billing.transactions.table.amount.title'] = 'Сумма';
$string['portal:billing.transactions.table.creationDate.title'] = 'Дата';
$string['portal:billing.transactions.table.planId.title'] = 'План';
$string['portal:billing.transactions.table.status.title'] = 'Состояние';
$string['portal:export.html'] = '<h1>Здравствуйте!</h1>
<p>Экспорт Вашего сайта на MoodleCloud завершен. Вы можете загрузить файл по ссылке <a href="%url%">%url%</a>.
<p>Спасибо, что пользуетесь нашими услугами.</p>
<p>Команда MoodleCloud</p>';
$string['portal:export.plain'] = 'Здравствуйте!

Экспорт Вашего сайта на MoodleCloud завершен. Вы можете загрузить файл по ссылке %url%

Спасибо, что пользуетесь нашими услугами.
Команда MoodleCloud';
$string['portal:export.title'] = 'Файл экспорта MoodleCloud готов к загрузке';
$string['portal:graphs.axes.dbsize'] = 'Размер базы данных';
$string['portal:graphs.axes.filesize'] = 'Размер файла';
$string['portal:graphs.axes.users'] = 'Пользователи';
$string['portal:graphs.filetypes.application'] = 'Данные приложения';
$string['portal:graphs.filetypes.audio'] = 'Аудио';
$string['portal:graphs.filetypes.example'] = 'Пример';
$string['portal:graphs.filetypes.image'] = 'Изображения';
$string['portal:graphs.filetypes.message'] = 'Сообщения';
$string['portal:graphs.filetypes.model'] = 'Модели';
$string['portal:graphs.filetypes.multipart'] = 'Составные элементы';
$string['portal:graphs.filetypes.text'] = 'Текст';
$string['portal:graphs.filetypes.video'] = 'Видео';
$string['portal:historical.fetchfailure.lead'] = 'К сожалению, не удалось получить прошлую статистику. Пожалуйста,  позже попробуйте еще раз.';
$string['portal:historical.fetchfailure.title'] = 'О нет!';
$string['portal:list.body.lead'] = '';
$string['portal:list.body.title'] = 'Портал MoodleCloud';
$string['portal:list.table.titles.location'] = 'Расположение';
$string['portal:list.table.titles.subdomain'] = 'Поддомен';
$string['portal:messages.csrffailure'] = 'Ошибка подтверждения изменений. Пожалуйста, попробуйте еще раз.';
$string['portal:messages.removalqueued'] = 'В очереди на удаление';
$string['portal:messages.sitenotfound'] = 'Ошибка загрузки сайта. Пожалуйста, попробуйте еще раз.';
$string['portal:page.tabs.billing'] = 'Расчеты';
$string['portal:page.tabs.package'] = 'Пакет';
$string['portal:page.tabs.paymentdetails'] = 'Данные для оплаты';
$string['portal:page.tabs.statistics'] = 'Статистика';
$string['portal:page.tabs.support'] = 'Поддержка';
$string['portal:page.tabs.tools'] = 'Инструменты';
$string['portal:page.title'] = 'MoodleCloud: Портал';
$string['portal:plans.plans.MCFREE.cost'] = 'Бесплатно';
$string['portal:plans.plans.MCFREE.invoicetitle'] = 'Дополнения для бесплатного хостинга MoodleCloud';
$string['portal:plans.plans.MCFREE.title'] = 'Дополнения для бесплатного Moodle';
$string['portal:plans.strings.plan'] = 'План';
$string['portal:purchases.confirmationpage.cancel'] = 'Нет, спасибо';
$string['portal:purchases.confirmationpage.continue'] = 'Оплатить сейчас';
$string['portal:purchases.confirmationpage.lead'] = 'Вы приобретаете:';
$string['portal:purchases.confirmationpage.paymentnotice'] = 'Указанная сумма будет списана сегодня, а также будет списываться %dayofmonth%-го числа каждого месяца до тех пор, пока вы не удалите это дополнение.';
$string['portal:purchases.confirmationpage.title'] = 'Способ оплаты - подтверждение';
$string['portal:siteinfo.page.title'] = 'MoodleCloud: Информация о ПОДДОМЕНЕ';
$string['portal:siteinfo.panels.historical.title'] = 'Прошлая статистика';
$string['portal:siteinfo.panels.info.limit_disk'] = '%maxbytes% Мб дискового пространства';
$string['portal:siteinfo.panels.info.limit_users'] = '%maxusers% пользователей';
$string['portal:siteinfo.panels.info.limits'] = 'Ограничения';
$string['portal:siteinfo.panels.info.location'] = 'Расположение хостинга';
$string['portal:siteinfo.panels.info.package'] = 'Пакет';
$string['portal:siteinfo.panels.info.sitename'] = 'Имя сайта';
$string['portal:siteinfo.panels.info.status'] = 'Статус';
$string['portal:siteinfo.panels.info.title'] = 'Информация';
$string['portal:siteinfo.panels.info.version'] = 'Версия';
$string['portal:siteinfo.panels.statistics.title'] = 'Статистика';
$string['portal:statistics.fetchfailure.lead'] = 'К сожалению, не удалось получить текущую статистику. Пожалуйста, попробуйте еще раз позже.';
$string['portal:statistics.fetchfailure.title'] = 'О нет!';
$string['portal:statistics.graphs.databasesize'] = 'Размер базы данных';
$string['portal:statistics.graphs.files'] = 'Файлы';
$string['portal:statistics.graphs.users'] = 'Пользователи';
$string['portal:tasks.removal.warning.html'] = '<h1>Здравствуйте!
</h1>
<p>Мы обратили внимание, что в течение последних 60 дней Вы не пользовались своим сайтом <a href="%url%">%fqdn%</a> на MoodleCloud.</p>
<p>В соответствии с нашими Условиями обслуживания, Ваш сайт будет удален после %day% %month% %year%.</p>
<p>Вы можете предотвратить удаление сайта, если до указанной даты <a href="%url%/login/index.php">войдете в в систему</a>.</p>
<p>Если Вы хотите рассказать нам, почему Вы перестали пользоваться Вашим сайтом на MoodleCloud, пожалуйста, заполните <a href="https://www.surveymonkey.com/r/moodlecloud-inactive">короткую анкету (на английском языке)</a>.</p>

<p>Благодарим Вас за использование наших услуг.</p>
<p>Команда MoodleCloud</p>';
$string['portal:tasks.removal.warning.plain'] = 'Здравствуйте!

Мы обратили внимание, что в течение последних 60 дней Вы не пользовались своим сайтом %fqdn% на MoodleCloud.

В соответствии с нашими Условиями обслуживания, Ваш сайт будет удален после %day% %month% %year%.

Вы можете предотвратить удаление сайта, если до указанной даты войдете в в систему адресу %url%/login/index.php.

Если Вы хотите рассказать нам, почему Вы перестали пользоваться Вашим сайтом на MoodleCloud, пожалуйста, заполните короткую анкету (на английском языке):
https://www.surveymonkey.com/r/moodlecloud-inactive

Благодарим Вас за использование наших услуг.
Команда MoodleCloud';
$string['portal:tasks.removal.warning.title'] = 'Сайт MoodleCloud «%subdomain%» бездействует и скоро будет удален';
$string['portal:view.actionpending.panel.body'] = 'Применяются изменения';
$string['portal:view.actionpending.panel.lead'] = '<p>На этом сайте идет применение изменений и все дальнейшие попытки изменения будут блокироваться до тех пор, пока применяемые в текущий момент изменения не будут завершены.</p>';
$string['portal:view.actionpending.panel.title'] = 'Ожидается применение изменений';
$string['portal:view.billing.addcc.button'] = 'Сохранить кредитную карту';
$string['portal:view.billing.addcc.success'] = 'Информация о способе оплаты успешно сохранена';
$string['portal:view.billing.panel.empty'] = 'Вы еще не совершили ни одной покупки. Если Вы приобретете дополнение для Вашего сайта на MoodleCloud, здесь будет отображаться данные для оплаты и история расчетов.';
$string['portal:view.billing.panel.title'] = 'Данные кредитной карты';
$string['portal:view.billing.paymentmethod.title'] = 'Текущий способ оплаты';
$string['portal:view.danger.modal.buttons.cancel'] = 'Нет, это было недоразумение!';
$string['portal:view.danger.modal.buttons.continue'] = 'Да, действительно удалить мой сайт с MoodleCloud';
$string['portal:view.danger.modal.lead'] = 'Подтвердите, что Вы сохранили в другом месте всё необходимое содержимое и согласны, что Ваш сайт будет навсегда удален из нашей системы.';
$string['portal:view.danger.modal.title'] = 'Подтверждение удаления';
$string['portal:view.danger.panel.body.buttons.remove'] = 'Удалить мой сайт с MoodleCloud';
$string['portal:view.danger.panel.body.buttons.title'] = 'Вы уверены, что хотите покинуть нас?';
$string['portal:view.danger.panel.body.lead'] = '<p>После удаления этого сайта с MoodleCloud восстановление невозможно.</p>
<p>Пожалуйста, убедитесь, что Вы сохранили в другом месте всё необходимое содержимое и сайт больше не нужен.</p>';
$string['portal:view.danger.panel.body.title'] = 'Удалить мой сайт с ModleCloud';
$string['portal:view.danger.panel.title'] = 'Опасные действия';
$string['portal:view.export.flash'] = 'Идет экспорт вашего сайта «%subdomain%». Как только этот процесс будет завершен, Вы получите соответствующее уведомление по электронной почте.';
$string['portal:view.export.panel.body.intro'] = 'При экспорте Вашего сайта Вы получите базу данных и все файлы сайта. Вы сможете использовать их, чтобы разместить систему Moodle на собственном сервере или на сервере любого из <a href="https://moodle.com/partners/">Партнеров Moodle</a>. Учтите, что экспорт займет некоторое время. Как только этот процесс будет завершен, Вы получите соответствующее уведомление по электронной почте.';
$string['portal:view.export.panel.body.link'] = 'Экспорт Вашего сайта последний раз производился %day% %month% %year%. Вы можете <a href="%linktobackup%">загрузить файл здесь</a>.';
$string['portal:view.export.panel.body.requested'] = 'Ваш запрос на экспорт сайта обрабатывается. Как только этот процесс будет завершен, Вы получите соответствующее уведомление по электронной почте.';
$string['portal:view.export.panel.button'] = 'Экспортировать этот сайт';
$string['portal:view.export.panel.lead'] = 'Экспортировать этот сайт';
$string['portal:view.export.panel.title'] = 'Ваши данные MoodleCloud';
$string['signup:auditlog.account.created'] = 'Создана новая учетная запись';
$string['signup:auditlog.account.linked'] = 'Осуществлено присоединение к существующей учетной записи';
$string['signup:auditlog.account.validated'] = 'Проверка учетной записи завершена';
$string['signup:auditlog.account.validationstarted'] = 'Отправлено сообщение для проверки учетной записи';
$string['signup:auditlog.site.automaticallyconfirmed'] = 'Сайт подтвержден без проверки учетной записи пользователя';
$string['signup:auditlog.site.provisionQueued'] = 'Сайт поставлен в очередь на развертывание';
$string['signup:auditlog.site.provisionmailedout'] = 'Отправлено электронное сообщение с уведомлением об окончании развертывания';
$string['signup:auditlog.site.reserved'] = 'Сайт зарезервирован';
$string['signup:authcode.body.links.startover'] = 'Хотите начать сначала? <a href="%link%">Давайте вернемся к началу</a>.';
$string['signup:authcode.body.title'] = 'Подтвердите свой номер телефона.';
$string['signup:authcode.form.fields.authcode'] = 'Код подтверждения';
$string['signup:authcode.form.fields.continue'] = 'Продолжить';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:errors.blacklistinline'] = 'Извините, этот сайт не доступен.';
$string['signup:errors.invalidinline'] = 'Имя сайта должно иметь длину от 3 до 53 символов и содержать только латинские буквы (a-z), дефисы и цифры.';
$string['signup:errors.maxsites'] = 'Пользователь с таким номером телефона уже существует. Пользователи могут создавать только один сайт на MoodleCloud.';
$string['signup:errors.reserved'] = 'О нет! Кто-то уже зарегистрировал это имя.';
$string['signup:messages.failedvalidationcode'] = 'Что-то здесь не так. Проверьте, что код введен правильно.';
$string['signup:messages.passwordupdated'] = 'Отлично! Пароль сохранен. Вы можете использовать его для входа на свой сайт на MoodleCloud.';
$string['signup:messages.validationcode'] = 'Код подтверждения для сайта %subdomain%.moodlecloud.com - %code%';
$string['signup:page.description'] = 'Бесплатное образовательное программное обеспечение Moodle на «облачных» серверах позволяет в одно мгновение установить сайт Moodle для учителей и инструкторов';
$string['signup:page.title'] = 'MoodleCloud: Регистрация на бесплатном хостинге Moodle';
$string['signup:password.body.lead'] = '';
$string['signup:password.body.title'] = 'И, наконец, задайте свой пароль!';
$string['signup:password.form.fields.password'] = 'Новый пароль';
$string['signup:password.form.fields.password_confirmation'] = 'И еще раз, для подтверждения';
$string['signup:password.form.fields.save'] = 'Сохранить пароль';
$string['signup:password.form.placeholders.password'] = '';
$string['signup:password.form.placeholders.password_confirmation'] = '';
$string['signup:personal.body.lead'] = 'Осталось узнать, кто Вы и убедиться, что Вы согласны с Условиями обслуживания.';
$string['signup:personal.body.title'] = 'Имя сайта свободно!';
$string['signup:personal.form.fields.continue'] = 'Продолжить';
$string['signup:personal.form.fields.email'] = 'Адрес электронной почты';
$string['signup:personal.form.fields.firstname'] = 'Имя';
$string['signup:personal.form.fields.lastname'] = 'Фамилия';
$string['signup:personal.form.fields.phonenumber'] = 'Номер мобильного телефона';
$string['signup:personal.form.fields.tandc'] = 'Для продолжения Вам нужно согласиться с Условиями обслуживания.';
$string['signup:personal.form.fields.timezone'] = 'Часовой пояс';
$string['signup:personal.form.placeholders.email'] = '';
$string['signup:personal.form.placeholders.firstname'] = '';
$string['signup:personal.form.placeholders.lastname'] = '';
$string['signup:personal.form.placeholders.phonenumber'] = '';
$string['signup:personal.form.placeholders.timezone'] = 'Выберите часовой пояс';
$string['signup:provision_mail.page.html'] = '<h1>Добро пожаловать на MoodleCloud!</h1>
<p>Ваш бесплатный сайт Moodle <a href="%url%">%url%</a> создан.</p>
<p>Вы можете зайти на свой сайт Moodle используя логин «admin» и пароль, который Вы указали во время регистрации.</p>
<p>Ваш бесплатный сайт имеет ограничения: 50 активных пользователей и 200Мб дискового пространства.</p>
<p>Советы:</p>
<ul>
<li>Вы можете удалять ненужных пользователей используя средства администрирования сайта, чтобы освободить место для новых.</li>
<li>Чтобы уменьшить занимаемое дисковое пространство, по возможности, используйте ссылки на общедоступные ресурсы в Интернете, например, HTML-страницы, видео YouTube, и др.</li>
</ul>
<p>Для контроля использования ресурсов Вы можете в любой момент зайти на портал MoodleCloud по адресу moodlecloud.com. Для входа используйте имя своего сайта «%subdomain%» и такой же пароль, как у пользователя «admin» на Вашем сайте.</p>
<p>С уважением,</p>
<p>Команда MoodleCloud</p>';
$string['signup:provision_mail.page.plain'] = 'Добро пожаловать на MoodleCloud!
Ваш бесплатный сайт Moodle %url% создан.
Вы можете зайти на свой сайт Moodle, используя логин «admin» и пароль, который Вы указали во время регистрации.
Ваш бесплатный сайт имеет ограничения: 50 активных пользователей и 200Мб дискового пространства.
Советы:
— Вы можете удалять ненужных пользователей используя средства администрирования сайта, чтобы освободить место для новых.
— Чтобы уменьшить занимаемое дисковое пространство, по возможности, используйте ссылки на общедоступные ресурсы в Интернете, например, HTML-страницы, видео YouTube, и др.

Для контроля использования ресурсов Вы можете в любой момент зайти на портал MoodleCloud по адресу moodlecloud.com. Для входа используйте имя своего сайта «%subdomain%» и такой же пароль, как у пользователя «admin» на Вашем сайте.

С уважением,
Команда MoodleCloud';
$string['signup:provision_mail.page.title'] = 'Ваш сайт %fqdn% на MoodleCloud готов!';
$string['signup:provision_mail.subject'] = 'Ваш сайт %site.fqdn% на MoodleCloud готов!';
$string['signup:reserve.available'] = 'Ура! Это имя сайта свободно.';
$string['signup:reserve.body.lead'] = 'Задайте уникальное имя сайта и выберите расположение (где будет размещен Ваш сайт; мы рекомендуем выбирать самое близкое к Вам и Вашим студентам расположение).';
$string['signup:reserve.body.title'] = 'Ваш сайт на MoodleCloud почти готов!';
$string['signup:reserve.form.fields.continue'] = 'Создать мой сайт';
$string['signup:reserve.form.fields.region'] = 'Расположение хостинга';
$string['signup:reserve.form.fields.subdomain'] = 'Имя сайта';
$string['signup:reserve.form.placeholders.subdomain'] = 'yoursite.moodlecloud.com';
$string['signup:reserve.form.tooltips.region'] = 'Это расположение хостинга Вашего сайта. Мы рекомендуем выбрать место ближе к Вам и Вашим студентам.';
$string['signup:status.body.ariasetupcomplete'] = 'Установка Вашего нового сайта завершена. Теперь Вы можете войти.';
$string['signup:status.body.lead'] = '<p>Вуаля!</p>
<p>Как Вы и хотели, теперь у Вас есть свой собственный сайт Moodle.</p>
<p>Заходите и продолжайте создавать свое безупречное образовательное пространство.</p>';
$string['signup:status.body.login'] = 'Вход';
$string['signup:status.body.title'] = 'Все готово! Ваш собственный сайт Moodle, совершенно бесплатно!';
$string['signup:steps.x'] = 'Шаг %x%';
$string['signup:steps.xofy'] = 'Шаг %x% из %y%';
$string['signup:terms.title'] = 'Условия обслуживания MoodleCloud';
$string['signup:texts.statusintro'] = 'TODO';
$string['signup:texts.statustitle'] = 'Как Вы и хотели - Ваш собственный сайт Moodle, совершенно бесплатно!';
$string['status:label.expired'] = 'Удален в связи с бездействием';
$string['status:label.pendingIdentityConfirmation'] = 'Ожидает подтверждения';
$string['status:label.pendingProvision'] = 'В очереди на создание';
$string['status:label.pendingRemoval'] = 'В очереди на удаление';
$string['status:label.provisioned'] = 'Активен';
$string['status:label.removed'] = 'Удален';
$string['status:label.reserved'] = 'Зарезервирован';
$string['status:tooltip.expired'] = 'Сайт был удален из нашей системы в связи с отсутствием активности';
$string['status:tooltip.pendingIdentityConfirmation'] = 'Сайт зарезервирован и СМС с подтверждением было выслано.';
$string['status:tooltip.pendingProvision'] = 'Сайт отправлен для установки и будет готов очень-очень скоро!';
$string['status:tooltip.pendingRemoval'] = 'Сайт поставлен в очередь на удаление и скоро будет удален из нашей системы.';
$string['status:tooltip.provisioned'] = 'Сайт активен и доступен.';
$string['status:tooltip.removed'] = 'Сайт удален.';
$string['status:tooltip.reserved'] = 'Сайт зарезервирован, но процесс регистрации еще не закончен.';
$string['telephony:lookup.apifailure'] = 'Произошла ошибка в нашей системе отправки сообщений. Пожалуйста, попробуйте еще раз.';
$string['telephony:lookup.invalidnumber'] = 'Некорректный номер телефона';
$string['telephony:lookup.notacellphone'] = 'Вы должны ввести корректный номер мобильного телефона';
$string['telephony:validator.apifailure'] = 'Произошла ошибка в нашей системе отправки сообщений. Пожалуйста, попробуйте еще раз.';
$string['validators:billing.ccname.mustexist'] = 'Вы должны указать имя держателя карты';
$string['validators:fos_user.current_password.invalid'] = 'Вы неправильно ввели свой текущий пароль';
$string['validators:fos_user.email.already_used'] = 'Этот адрес электронной почты уже используется';
$string['validators:fos_user.email.blank'] = 'Пожалуйста, укажите адрес Вашей электронной почты';
$string['validators:fos_user.email.invalid'] = 'Некорректный адрес электронной почты';
$string['validators:fos_user.email.long'] = '[-Inf,Inf]Слишком длинный адрес электронной почты';
$string['validators:fos_user.email.short'] = '[-Inf,Inf]Слишком короткий адрес электронной почты';
$string['validators:fos_user.group.blank'] = 'Пожалуйста, укажите название группы';
$string['validators:fos_user.group.long'] = '[-Inf,Inf]Название группы слишком длинное';
$string['validators:fos_user.group.short'] = '[-Inf,Inf]Название группы слишком короткое';
$string['validators:fos_user.new_password.blank'] = 'Пожалуйста, укажите новый пароль';
$string['validators:fos_user.new_password.short'] = '[-Inf,Inf]Новый пароль слишком короткий';
$string['validators:fos_user.password.blank'] = 'Пожалуйста, укажите пароль';
$string['validators:fos_user.password.mismatch'] = 'Введенные пароли не совпадают';
$string['validators:fos_user.password.short'] = '[-Inf,Inf]Пароль слишком короткий';
$string['validators:fos_user.username.already_used'] = 'Логин уже используется';
$string['validators:fos_user.username.blank'] = 'Пожалуйста, укажите логин';
$string['validators:fos_user.username.long'] = '[-Inf,Inf]Логин слишком длинный';
$string['validators:fos_user.username.short'] = '[-Inf,Inf]Логин слишком короткий';
$string['validators:signup.email.format'] = 'Пожалуйста, введите корректный адрес электронной почты';
$string['validators:signup.email.mustexist'] = 'Пожалуйста, введите Ваш адрес электронной почты';
$string['validators:signup.phone.mustexist'] = 'Пожалуйста, укажите номер Вашего мобильного телефона';
$string['validators:signup.status.password_mismatch'] = 'Введенные пароли не совпадают';
$string['validators:signup.tandc.mustagree'] = 'Для использования MoodleCould Вы должны принять Условия обслуживания.';
$string['validators:signup.timezone.mustselect'] = 'Пожалуйста, укажите свой часовой пояс';
$string['validators:site.firstname.mustexist'] = 'Вы должны указать имя';
$string['validators:site.lastname.mustexist'] = 'Вы должны указать фамилию';
$string['validators:site.subdomain.format'] = 'Имя поддомена должно начинаться с буквы и содержать только латинские буквы (a-z), цифры и знак дефиса.';
$string['validators:site.subdomain.maxlength'] = 'Имя поддомена не может превышать 53 символа';
$string['validators:site.subdomain.minlength'] = 'Имя поддомена должно содержать не менее трех символов';
$string['validators:site.subdomain.mustexist'] = 'Вы должны указать имя поддомена';
