<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'certificate', language 'ru', version '3.10'.
 *
 * @package     certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addlinklabel'] = 'Добавить настройку для связанного элемента';
$string['addlinktitle'] = 'Щелкните для добавления еще одной настройки для связанного элемента';
$string['areaintro'] = 'Преамбула сертификата';
$string['awarded'] = 'Выдан';
$string['awardedto'] = 'Кому выдан';
$string['back'] = 'Назад';
$string['border'] = 'Рамка';
$string['borderblack'] = 'Чёрная';
$string['borderblue'] = 'Синяя';
$string['borderbrown'] = 'Коричневая';
$string['bordercolor'] = 'Рамка из линий';
$string['bordercolor_help'] = 'Поскольку изображения могут существенно увеличить размер файла PDF, Вы можете выбрать печать рамки из линий вместо использования изображения рамки (убедитесь, что параметр «Рамка-изображение» установлен в «Нет»). Параметр «Рамка из линий» будет печатать красивую рамку из трех линий разной толщины выбранным цветом.';
$string['bordergreen'] = 'Зеленая';
$string['borderlines'] = 'Линии';
$string['borderstyle'] = 'Рамка-изображение';
$string['borderstyle_help'] = 'Параметр «Рамка-изображение» позволяет вам выбрать изображение рамки из папки certificate/pix/borders. Выберите изображение рамки, которое вы хотите использовать по краям сертификата, или выберите «Нет», чтобы рамки не было.';
$string['certificate'] = 'Проверить код сертификата:';
$string['certificate:addinstance'] = 'Добавлять новый сертификат';
$string['certificate:manage'] = 'Управлять сертификатами';
$string['certificate:printteacher'] = 'Быть указанным в качестве учителя на сертификате, если параметр «Печатать учителя» включен';
$string['certificate:student'] = 'Получить сертификат';
$string['certificate:view'] = 'Просматривать сертификат';
$string['certificatename'] = 'Название сертификата';
$string['certificatereport'] = 'Отчет по сертификатам';
$string['certificatesfor'] = 'Сертификаты для';
$string['certificatetype'] = 'Тип сертификата';
$string['certificatetype_help'] = 'Здесь Вы определяете макет сертификата. Папка certificate/type содержит четыре сертификата по умолчанию:
«A4 (встроены)» печатает на листе формата A4 со встраиванием шрифтов.
«A4 (не встроены)» печатает на листе формата A4 без встраивания шрифтов.
«Letter (встроены)» печатает на листе формата Letter со встраиванием шрифтов.
«Letter (не встроены)» печатает на листе формата Letter без встраивания шрифтов.

Типы без встраивания шрифтов используют шрифты Helvetica и Times. Если Вы полагаете, что у пользователей нет этих шрифтов на их компьютерах, или если язык содержит знаки или символы, которые не поддерживаются шрифтами Helvetica и Times, то в этом случае используйте встраивание шрифтов. Встроенные шрифты используют гарнитуры Dejavusans и Dejavuserif. Это увеличивает размер файлов PDF, поэтому не рекомендуется использовать встраивание шрифтов без необходимости.

Папки с новыми типами могут быть добавлены в папку certificate/type. Название папки и новые языковые строки для нового типа должны быть добавлены в языковой файл certificate.';
$string['certify'] = 'Данный сертификат подтверждает, что';
$string['code'] = 'Код';
$string['completiondate'] = 'Завершение курса';
$string['course'] = 'за курс';
$string['coursegrade'] = 'Оценка по курсу';
$string['coursename'] = 'Курс';
$string['coursetimereq'] = 'Необходимые минуты в курсе';
$string['coursetimereq_help'] = 'Введите минимальное количество времени (в минутах), которое студент должен провести в курсе для того, чтобы получить сертификат.';
$string['credithours'] = 'Количество часов';
$string['customtext'] = 'Пользовательский текст';
$string['customtext_help'] = 'Если Вы хотите, чтобы на сертификате были указаны имена других учителей, отличающиеся от тех, кто назначен в курсе на роль учителя, не выбирайте «Печатать учителя» или какие-либо изображения подписей, кроме изображения линии. Введите имена учителей в это поле в том виде, в каком они должны быть выведены на сертификате. По умолчанию этот текст помещается в левом нижнем углу сертификата. Можно использовать следующие теги HTML: <br>, <p>, <b>, <i>, <u>, <img> (src и with (или height) являются обязательными), <a> (href обязателен), <font> (возможны следующие атрибуты: color, (шестнадцатеричный код цвета), face, (arial, times, courier, helvetica, symbol)).';
$string['date'] = 'Дата';
$string['datefmt'] = 'Формат даты';
$string['datefmt_help'] = 'Выберите формат даты для печати на сертификате. Или выберите последний вариант, чтобы дата выводилась в формате языка, выбранного пользователем.';
$string['datehelp'] = 'Дата';
$string['deletissuedcertificates'] = 'Удалить выданные сертификаты';
$string['delivery'] = 'Доставка';
$string['delivery_help'] = 'Выберите, каким образом студенты получат свой сертификат.
Открыть в новом окне: открывает сертификат в новом окне браузера.
Принудительная загрузка: открывает в браузере окно скачивания файла.
Электронная почта: при  выборе этого варианта сертификат отправляется студенту как вложение в письмо электронной почты.
После получения сертификата при щелчке по ссылке сертификата на главной странице курса, студенты видят дату получения сертификата и могут просмотреть его.';
$string['designoptions'] = 'Параметры оформления';
$string['download'] = 'Принудительная загрузка';
$string['emailcertificate'] = 'Электронная почта';
$string['emailothers'] = 'Электронное письмо другим пользователям';
$string['emailothers_help'] = 'Введите адреса электронной почты (разделяя их запятыми) тех людей, кого необходимо уведомить по электронной почте о том, что студенты получили сертификат.';
$string['emailstudenttext'] = 'В приложении находится Ваш сертификат за курс «{$a->course}».';
$string['emailteachermail'] = '{$a->student} получил(а) свой сертификат: «{$a->certificate}»
по итогам курса «{$a->course}».

Вы можете просмотреть его здесь:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} получил свой сертификат: «<i>{$a->certificate}</i>» за курс «{$a->course}».

Вы можете просмотреть его здесь:

    <a href="{$a->url}">Отчёт по сертификатам</a>.';
$string['emailteachers'] = 'Электронное письмо учителям';
$string['emailteachers_help'] = 'При включенном параметре учителя будут оповещены по электронной почте всякий раз, когда студенты получают сертификат.';
$string['entercode'] = 'Введите код сертификата для проверки:';
$string['fontsans'] = 'Гарнитура без засечек';
$string['fontsans_desc'] = 'Шрифтовая гарнитура без засечек для сертификатов со встроенными шрифтами';
$string['fontserif'] = 'Гарнитура с засечками';
$string['fontserif_desc'] = 'Шрифтовая гарнитура с засечками для сертификатов со встроенными шрифтами';
$string['getcertificate'] = 'Получить свой сертификат';
$string['grade'] = 'Оценка';
$string['gradedate'] = 'Дата оценки';
$string['gradefmt'] = 'Формат оценки';
$string['gradefmt_help'] = 'При выборе печати оценки на сертификате доступны три возможных формата:

Процентная оценка: Печатает оценку в виде процентов.
Балльная оценка: Печатает оценку в виде суммы баллов.
Буквенная оценка: Печатает процентную оценку в виде буквы.';
$string['gradeletter'] = 'Буквенная оценка';
$string['gradepercent'] = 'Процентная оценка';
$string['gradepoints'] = 'Балльная оценка';
$string['imagetype'] = 'Тип изображения';
$string['incompletemessage'] = 'Для того, чтобы скачать сертификат, необходимо сначала завершить все необходимые элементы курса. Пожалуйста, вернитесь в курс и закончите работу над ним.';
$string['intro'] = 'Инструкция';
$string['issued'] = 'Выдан';
$string['issueddate'] = 'Дата выдачи';
$string['issueoptions'] = 'Параметры выдачи';
$string['landscape'] = 'Альбомная';
$string['lastviewed'] = 'Вы последний раз получили этот сертификат:';
$string['letter'] = 'Буква';
$string['lockingoptions'] = 'Параметры блокировки';
$string['modulename'] = 'Сертификат';
$string['modulename_help'] = 'Этот модуль позволяет динамическую генерацию сертификатов, исходя из предварительно заданного учителем набора условий.';
$string['modulenameplural'] = 'Сертификаты';
$string['mycertificates'] = 'Мои сертификаты';
$string['nocertificates'] = 'Нет сертификатов';
$string['nocertificatesissued'] = 'Нет выданных сертификатов';
$string['nocertificatesreceived'] = 'не получил никаких сертификатов по курсу.';
$string['nofileselected'] = 'Необходимо выбрать файл для загрузки!';
$string['nogrades'] = 'Оценки не доступны';
$string['notapplicable'] = 'Н/Д';
$string['notfound'] = 'Сертификата с таким номером не существует.';
$string['notissued'] = 'Не выдан';
$string['notissuedyet'] = 'Еще не выдан';
$string['notreceived'] = 'Вы не получили этот сертификат';
$string['openbrowser'] = 'Открыть в новом окне';
$string['opendownload'] = 'Нажмите на кнопку ниже, чтобы сохранить сертификат на своем компьютере.';
$string['openemail'] = 'Щелкните на кнопке ниже и сертификат будет отправлен Вам в письме по электронной почте.';
$string['openwindow'] = 'Щелкните на кнопке ниже, чтобы открыть свой сертификат в новом окне браузера.';
$string['or'] = 'Или';
$string['orientation'] = 'Ориентация';
$string['orientation_help'] = 'Выберите ориентацию сертификата: портретную или альбомную.';
$string['pluginadministration'] = 'Управление сертификатом';
$string['pluginname'] = 'Сертификат';
$string['portrait'] = 'Портретная';
$string['printdate'] = 'Печатать дату';
$string['printdate_help'] = 'Эта дата, которая будет напечатана, если будет выбран параметр «Печатать дату». Если выбрана дата завершения курса, но студент не завершил курс, будет напечатана дата выдачи. Вы также можете выбрать печать даты оценки конкретного элемента курса. Если сертификат выдан до оценки этого элемента курса, будет напечатана дата выдачи.';
$string['printerfriendly'] = 'Страница для печати';
$string['printgrade'] = 'Печатать оценку';
$string['printgrade_help'] = 'Вы можете выбрать любой доступный оцениваемый элемент из журнала оценок для печати на сертификате оценки, полученной пользователем за этот элемент. Оцениваемые элементы перечисляются в том порядке, в котором они появляются в журнале оценок. Выберите формат оценки ниже.';
$string['printhours'] = 'Печатать количество часов';
$string['printhours_help'] = 'Введите количество часов, которое должно быть напечатано на сертификате.';
$string['printnumber'] = 'Печатать код';
$string['printnumber_help'] = 'На сертификате будет напечатан уникальный 10-значный код из случайных букв и цифр. Этот номер затем может быть проверен путем сравнения его с номером кода, показанным в отчёте по сертификатам.';
$string['printoutcome'] = 'Печатать показатель';
$string['printoutcome_help'] = 'Вы можете выбрать любой показатель курса, чтобы напечатать на сертификате название показателя и полученную пользователем оценку этого показателя. Например, «Выполнение заданий: Превосходно».';
$string['printseal'] = 'Изображение печати или логотипа';
$string['printseal_help'] = 'Этот параметр позволяет выбрать печать или логотип из папки certificate/pix/seals, чтобы напечатать на сертификате. По умолчанию, это изображение помещается в правом нижнем углу сертификата.';
$string['printsignature'] = 'Изображение подписи';
$string['printsignature_help'] = 'Этот параметр позволяет напечатать изображение подписи из папки certificate/pix/signatures. Вы можете напечатать изображение самой подписи или линию для того, чтобы поставить подпись вручную. По умолчанию, это изображение помещается в левом нижнем углу сертификата.';
$string['printteacher'] = 'Печатать учителя (учителей)';
$string['printteacher_help'] = 'Для печати на сертификате имени учителя задайте эту роль на уровне модуля. Сделайте это, если, например, в курсе есть несколько учителей или в курсе более одного сертификата и Вы хотите напечатать разные имена учителей на каждом сертификате. Щелкните на редактировании сертификата, затем выберите вкладку «Локально назначенные роли». Затем назначьте роль «Учитель» (учитель с правом редактирования) сертификату (они не обязательно должны быть учителями в курсе, Вы можете назначить эту роль кому угодно). Эти имена будут напечатаны на сертификате в качестве учителей.';
$string['printwmark'] = 'Изображение водяных знаков';
$string['printwmark_help'] = 'Файл водяного знака может быть размещен в качестве фона сертификата. Водяной знак — это приглушенный рисунок. Водяным знаком может быть логотип, печать, герб, слова или что-то иное, что Вы хотите использовать в качестве фонового рисунка.';
$string['receivedcerts'] = 'Полученные сертификаты';
$string['receiveddate'] = 'Дата получения';
$string['removecert'] = 'Выданные сертификаты удалены';
$string['report'] = 'Отчёт';
$string['reportcert'] = 'Отчёт по сертификатам';
$string['reportcert_help'] = 'Если выбрать «Да», то дата получения этого сертификата, код и название курса будут показан в Отчёте по сертификатам пользователя. При выборе «Печатать оценку на сертификате» эта оценка также будет показана в отчёте по сертификатам.';
$string['requiredtimenotmet'] = 'Вы должны провести в курсе минимум {$a->requiredtime} минут для получения доступа к этому сертификату';
$string['requiredtimenotvalid'] = 'Требуемое время должно быть числом больше 0';
$string['reviewcertificate'] = 'Просмотр своего сертификата';
$string['savecert'] = 'Сохранить сертификаты';
$string['savecert_help'] = 'Если этот параметр выбран, то копия файла PDF с сертификатом каждого пользователя будет сохранена в папке moddata файлов курса для этого сертификата. Ссылка на сохраненный сертификат каждого пользователя будет показана в отчёте по сертификатам.';
$string['seal'] = 'Печать';
$string['sigline'] = 'линия';
$string['signature'] = 'Подпись';
$string['statement'] = 'завершил курс';
$string['summaryofattempts'] = 'Список ранее выданных сертификатов';
$string['textoptions'] = 'Параметры текста';
$string['title'] = 'СЕРТИФИКАТ';
$string['to'] = 'Выдан';
$string['typeA4_embedded'] = 'A4 (встроены)';
$string['typeA4_non_embedded'] = 'A4 (не встроены)';
$string['typeletter_embedded'] = 'Letter (встроены)';
$string['typeletter_non_embedded'] = 'Letter (не встроены)';
$string['unsupportedfiletype'] = 'Файл должен быть в формате jpeg или png';
$string['uploadimage'] = 'Загрузить изображение';
$string['uploadimagedesc'] = 'Эта кнопка перенаправит Вас на новый экран, где Вы сможете загрузить изображения.';
$string['userdateformat'] = 'Формат даты языка пользователя';
$string['validate'] = 'Проверить';
$string['verifycertificate'] = 'Проверить сертификат';
$string['viewcertificateviews'] = 'Показать выданные сертификаты: {$a}';
$string['viewed'] = 'Вы получили этот сертификат:';
$string['viewtranscript'] = 'Показать сертификаты';
$string['watermark'] = 'Водяной знак';
