<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'hu', version '3.10'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Hozzáférés szabályozása';
$string['actionaftercorrectanswer'] = 'Helyes válasz utáni lépés';
$string['actionaftercorrectanswer_help'] = 'A kérdés helyes megválaszolása után 3 lehetőség közül választhat a következő oldalon:

* Szokásos - a lecke következő oldalának megjelenítése
* Egy új oldal megjelenítése - Az oldalak véletlenszerűen jelennek meg, minden oldal csak egyszer
* Egy megválaszolatlan oldal megjelenítése - Az oldalak véletlenszerűen jelennek meg a megválaszolatlan kérdések újbóli megjelenítésével';
$string['actions'] = 'Műveletek';
$string['activitylink'] = 'Kapcsolás a következő tevékenységhez';
$string['activitylink_help'] = 'A lenyíló menüből válasszon ki egy tevékenységet, amely a lecke végén az adott tevékenységre való hivatkozásként lesz látható.';
$string['activitylinkname'] = 'Áttérés ide: {$a}';
$string['activityoverview'] = 'Leckéi esedékesek';
$string['addabranchtable'] = 'Tartalomoldal beszúrása';
$string['addanendofbranch'] = 'Elágazás végének hozzáadása';
$string['addanewpage'] = 'Új oldal hozzáadása';
$string['addaquestionpage'] = 'Kérdésoldal beszúrása';
$string['addaquestionpagehere'] = 'Kérdésoldal beszúrása ide';
$string['addbranchtable'] = 'Tartalomoldal beszúrása';
$string['addcluster'] = 'Tömb beszúrása';
$string['addedabranchtable'] = 'Tartalomoldal hozzáadva';
$string['addedanendofbranch'] = 'Elágazás vége hozzáadva';
$string['addedaquestionpage'] = 'Kérdésoldal hozzáadva';
$string['addedcluster'] = 'Tömb hozzáadva';
$string['addedendofcluster'] = 'Tömb vége hozzáadva';
$string['addendofbranch'] = 'Elágazás végének hozzáadása';
$string['addendofcluster'] = 'Tömb végének hozzáadása';
$string['addessay'] = 'Esszékérdést tartalmazó oldal létrehozása';
$string['additionalattemptsremaining'] = 'Kész. Próbálkozzon újból a leckével.';
$string['addmatching'] = 'Párosító kérdést tartalmazó oldal létrehozása';
$string['addmultichoice'] = 'Feleletválasztós kérdést tartalmazó oldal létrehozása';
$string['addnewgroupoverride'] = 'Csoportos felülírás hozzáadása';
$string['addnewuseroverride'] = 'Felhasználói felülírás hozzáadása';
$string['addnumerical'] = 'Számkérdést tartalmazó oldal létrehozása';
$string['addpage'] = 'Oldal hozzáadása';
$string['addshortanswer'] = 'Rövid válaszos kérdést tartalmazó oldal létrehozása';
$string['addtruefalse'] = 'Eldöntendő kérdést tartalmazó oldal létrehozása';
$string['allotheranswers'] = 'Minden egyéb válasz';
$string['allotheranswersjump'] = 'Minden egyéb válaszhoz tartozó ugrás';
$string['allotheranswersscore'] = 'Minden egyéb válasz pontszáma';
$string['allowofflineattempts'] = 'Leckével való próbálkozás kapcsolat nélküli üzemmódban való engedélyezése a mobil alkalmazás használatával';
$string['allowofflineattempts_help'] = 'Bekapcsolása esetén a mobil alkalmazást használó letölthet egy leckét és kapcsolat nélküli üzemmódban próbálkozhat vele.
A letöltés kiterjed minden lehetséges válaszra és a helyes válaszokra is.
Megjegyzés: időkorlátos leckével kapcsolat nélküli üzemmódban nem próbálkozhat.';
$string['anchortitle'] = 'A fő tartalom kezdete';
$string['and'] = 'ÉS';
$string['answer'] = 'Válasz';
$string['answeredcorrectly'] = 'helyesen megválaszolva.';
$string['answersfornumerical'] = 'A számjegyes kérdések válaszait minimális és maximális értékeket tartalmazó, egymáshoz illő párok formájában kell megadni';
$string['arrangebuttonshorizontally'] = 'A tartalomgombok vízszintesen jelenjenek meg?';
$string['attempt'] = 'Próbálkozás: {$a}';
$string['attemptheader'] = 'Próbálkozás';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Próbálkozások';
$string['attemptsdeleted'] = 'Törölt próbálkozások';
$string['attemptsremaining'] = '{$a} próbálkozása maradt';
$string['available'] = 'Elérhető ekkortól';
$string['averagescore'] = 'Átlagpontszám';
$string['averagetime'] = 'Átlagidő';
$string['branch'] = 'Tartalom';
$string['branchtable'] = 'Tartalom';
$string['cancel'] = 'Mégse';
$string['cannotfindanswer'] = 'Hiba: nem található a válasz';
$string['cannotfindattempt'] = 'Hiba: nem található a próbálkozás';
$string['cannotfindessay'] = 'Hiba: nem található az esszé';
$string['cannotfindfirstgrade'] = 'Hiba: nem találhatók a pontok';
$string['cannotfindfirstpage'] = 'Nincs meg az első oldal';
$string['cannotfindgrade'] = 'Hiba: nem találhatók a pontok';
$string['cannotfindnewestgrade'] = 'Hiba: nem található a legutolsó pont';
$string['cannotfindnextpage'] = 'Lecke biztonsági mentése: nincs meg a következő oldal!';
$string['cannotfindpagerecord'] = 'Elágazás vége beszúrandó: az oldal rekordja nem található';
$string['cannotfindpages'] = 'Nincsenek meg a lecke oldalai';
$string['cannotfindpagetitle'] = 'Törlés megerősítése: az oldal címe nem található';
$string['cannotfindpreattempt'] = 'Az előző próbálkozás rekordja nem található!';
$string['cannotfindrecords'] = 'Hiba: nem találhatók a lecke rekordjai';
$string['cannotfindtimer'] = 'Hiba: nem találhatók a lesson_timer rekordok';
$string['cannotfinduser'] = 'Hiba: nem találhatók felhasználók';
$string['canretake'] = '{$a} újra próbálkozhat';
$string['casesensitive'] = 'Reguláris kifejezések használata';
$string['casesensitive_help'] = 'Reguláris kifejezések válaszok elemzésére való használatához jelölje be a jelölőnégyzetet';
$string['checkbranchtable'] = 'Tartalomoldal ellenőrzése';
$string['checkedthisone'] = 'Ellenőrizve.';
$string['checknavigation'] = 'Navigálás ellenőrzése';
$string['checkquestion'] = 'Kérdés ellenőrzése';
$string['classstats'] = 'Osztálystatisztika';
$string['clicktodownload'] = 'A következő hivatkozásra kattintva töltse le az állományt.';
$string['closebeforeopen'] = 'A lecke nem frissíthető. A kezdő időpont előtti befejezési időt adott meg.';
$string['cluster'] = 'Tömb';
$string['clusterjump'] = 'Kihagyott kérdés egy tömbben';
$string['clustertitle'] = 'Tömb';
$string['collapsed'] = 'Összecsukott';
$string['comments'] = 'Megjegyzései';
$string['completed'] = 'Kész';
$string['completederror'] = 'Fejezze be a leckét';
$string['completethefollowingconditions'] = 'A következőket kell teljesítenie a(z) <b>{$a}</b> leckében, mielőtt továbbléphet.';
$string['completionendreached'] = 'Vége elérendő';
$string['completionendreached_desc'] = 'A tevékenység teljesítéséhez a tanulónak a leckeoldal végéig el kell jutnia.';
$string['completiontimespent'] = 'A tanulóknak ezt a tevékenységet legalább ennyi ideig kell folytatni';
$string['completiontimespentdesc'] = 'A tanulónak legalább {$a} ideig el kell végeznie ezt a tevékenységet';
$string['completiontimespentgroup'] = 'Eltöltött idő előírása';
$string['conditionsfordependency'] = 'A teljesítés feltétele(i)';
$string['configintro'] = 'Az itt megadott értékek lesznek a beállítási űrlapon használandó új alapértékek új tevékenység létrehozásakor. A részletes beállítások a "Részletek..." hivatkozásra kattintva jelennek meg.';
$string['configmaxanswers'] = 'Oldalankénti válaszok maximális száma alapesetben';
$string['configmediaclose'] = 'Megjelenít egy kapcsolt médiumállományhoz előállított, előugró ablak bezárására való gombot';
$string['configmediaheight'] = 'Beállítja a kapcsolt médiumállományhoz előállított előugró ablak magasságát';
$string['configmediawidth'] = 'Beállítja a kapcsolt médiumállományhoz előállított előugró ablak szélességét';
$string['configpassword_desc'] = 'A lecke eléréséhez szükséges-e jelszó.';
$string['configslideshowbgcolor'] = 'Bekapcsolt diavetítés esetén annak háttérszíne';
$string['configslideshowheight'] = 'Bekapcsolt diavetítés esetén beállítja annak magasságát';
$string['configslideshowwidth'] = 'Bekapcsolt diavetítés esetén beállítja annak szélességét';
$string['configtimelimit_desc'] = 'Időkorlát beállítása esetén a lecke elején figyelmeztetés és visszaszámláló jelenik meg. 0-ra állítva nincs időkorlát.';
$string['confirmdelete'] = 'Oldal törlése';
$string['confirmdeletionofthispage'] = 'Oldal törlésének megerősítése';
$string['congratulations'] = 'Gratulálunk - elérte a lecke végét!';
$string['continue'] = 'Tovább';
$string['continuetoanswer'] = 'Tovább a válaszok módosításához';
$string['continuetonextpage'] = 'Tovább a következő oldalra';
$string['correctanswerjump'] = 'Helyes válasz utáni ugrás';
$string['correctanswerscore'] = 'Helyes válasz pontszáma';
$string['correctresponse'] = 'Tanuló helyes válasza';
$string['createaquestionpage'] = 'Kérdésoldal létrehozása';
$string['credit'] = 'Kredit';
$string['customscoring'] = 'Testre szabott pontozás';
$string['customscoring_help'] = 'Bekapcsolása esetén minden válaszhoz megadhat egy számjegyes (negatív vagy pozitív) pontértéket';
$string['deadline'] = 'Határidő';
$string['defaultessayresponse'] = 'Az esszét tanára fogja pontozni.';
$string['deleteallattempts'] = 'Leckével kapcsolatos összes próbálkozás törlése';
$string['deletedefaults'] = '{$a} x lecke alapbeállítása törölve';
$string['deletedpage'] = 'Oldal törölve';
$string['deletepagenamed'] = 'Oldaltörlés: {$a}';
$string['deleting'] = 'Törlés';
$string['deletingpage'] = 'A(z) {$a} oldal törlése';
$string['dependencyon'] = 'Összefüggés';
$string['dependencyon_help'] = '<p>Ezzel a beállítással a lecke összefüggésbe hozható a tanulónak az adott kurzuson belül egy
másik lecke során elért teljesítményével.  Ha az ezzel kapcsolatos
követelményeket nem teljesíti, akkor a tanuló számára ez a lecke nem lesz elérhető.</p>

<p>Az összefüggést meghatározó feltételek a következők:
    <ul>
        <li><span style="font-weight: bold;">Eltöltött idő</span>: a tanulónak az adott leckével ennyi ideig kell foglalkoznia.</li>
        <li><span style="font-weight: bold;">Elvégzés</span>: a tanulónak az adott leckét el kell végeznie.</li>
        <li><span style="font-weight: bold;">Ponthatár</span>: a tanulónak az adott leckével kapcsolatban
        a megadottnál magasabb pontot kell elérnie.</li>
    </ul>
    Szükség esetén a fentiek tetszés szerint kombinálhatók.
</p>';
$string['description'] = 'Leírás';
$string['deselectallattempts'] = 'Összes próbálkozás kijelölésének megszüntetése';
$string['detailedstats'] = 'Részletes statisztika';
$string['didnotanswerquestion'] = 'Nem válaszolt erre a kérdésre';
$string['didnotreceivecredit'] = 'Nem kapott kreditpontot';
$string['disabled'] = 'Kikapcsolva';
$string['displaydefaultfeedback'] = 'Alapbeállítás szerinti visszajelzés';
$string['displaydefaultfeedback_help'] = '<p>Ha <strong>Igen</strong>-re állítja, egy adott kérdés esetén ha nincs megadva egyéb visszajelzés,
az alapbeállítás szerinti "Helyes válasz" vagy "Helytelen válasz" lesz látható.</p>
<p>Ha <strong>Nem</strong>-re állítja, egy adott kérdés esetén ha nincs megadva egyéb visszajelzés,
semmilyen visszajelzés nem lesz látható.
A leckét tanulmányozó tanuló automatikusan a lecke következő oldalára kerül.</p>';
$string['displayinleftmenu'] = 'A menüben jelenjen meg?';
$string['displayleftif'] = 'Menü megjelenítése legalább ekkora osztályzat esetén';
$string['displayleftif_help'] = 'A beállítás eldönti, hogy a tanulónak a leckemenü megtekintéséhez egy osztályzatot el kell-e érnie. Így arra kényszeríti a tanulót, hogy az első próbálkozás alkalmával végigmenjen a teljes leckén. Ha a szükséges osztályzat eléri, ismétléshez használhatja a menüt.';
$string['displayleftmenu'] = 'Menü kijelzése';
$string['displayleftmenu_help'] = 'Bekapcsolása esetén megjeleníti az oldalakat felsoroló menüt.';
$string['displayofgrade'] = 'Pont kijelzése (csak tanulóknak)';
$string['displayreview'] = 'Újrapróbálkozás lehetővé tétele';
$string['displayreview_help'] = 'Bekapcsolása esetén hibás választ követően a tanuló kreditpont nélkül újrapróbálkozhat, vagy továbbléphet a leckében. Ha áttér a következő kérdésre, a kiválasztott (hibás) választ fogja követni. Alapesetben a hibás válaszos ugrás "erre az oldalra" van beállítva és 0 pontot ér, ezért célszerű egy másik oldalra ugrást beállítani a tanulók összezavarásának elkerülése érdekében.';
$string['displayscorewithessays'] = 'Az automatikus pontozású kérdéseknél {$a->score} pontot kapott a maximális {$a->tempmaxgrade} pontból.<br /><br />Az {$a->essayquestions} esszékérdés(é/ei)t később pontozzák és adják hozzá végső pontszámához.<br /><br />Az esszékérdés(ek) nélküli jelenlegi osztályzata {$a->score} a(z) {$a->grade} pontból';
$string['displayscorewithoutessays'] = 'Pontszáma {$a->score} ({$a->grade} pontból).';
$string['duplicatepagenamed'] = 'Ismétlődő oldal: {$a}';
$string['edit'] = 'Szerkesztés';
$string['editbranchtable'] = 'Tartalomoldal szerkesztése';
$string['editcluster'] = 'Tömb szerkesztése';
$string['editendofbranch'] = 'Elágazás végét tartalmazó oldal szerkesztése';
$string['editendofcluster'] = 'Tömb végét tartalmazó oldal szerkesztése';
$string['editessay'] = 'Esszékérdést tartalmazó oldal szerkesztése';
$string['editingquestionpage'] = 'A(z) {$a} kérdésoldal szerkesztése';
$string['editlessonsettings'] = 'Leckebeállítások szerkesztése';
$string['editmatching'] = 'Párosító kérdést tartalmazó oldal szerkesztése';
$string['editmultichoice'] = 'Feleletválasztós kérdést tartalmazó oldal szerkesztése';
$string['editnumerical'] = 'Számkérdést tartalmazó oldal szerkesztése';
$string['editoverride'] = 'Szerkesztés felülírása';
$string['editpage'] = 'Oldal tartalmának szerkesztése';
$string['editpagecontent'] = 'Oldal tartalmának szerkesztése';
$string['editquestion'] = 'Kérdést tartalmazó oldal szerkesztése';
$string['editshortanswer'] = 'Rövid válaszos kérdést tartalmazó oldal szerkesztése';
$string['edittruefalse'] = 'Eldöntendő kérdést tartalmazó oldal szerkesztése';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Az ÖSSZES osztályozott <br />esszé elküldése e-mailben';
$string['emailgradedessays'] = 'Pontozott esszék elküldése e-mailben';
$string['emailsuccess'] = 'Az e-mailek elküldése sikerült';
$string['emptypassword'] = 'A jelszó nem lehet üres';
$string['enabled'] = 'Bekapcsolva';
$string['endofbranch'] = 'Elágazás vége';
$string['endofcluster'] = 'Tömb vége';
$string['endofclustertitle'] = 'Tömb vége';
$string['endoflesson'] = 'Lecke vége';
$string['enteredthis'] = 'adta meg ezt.';
$string['enterpassword'] = 'Adja meg a jelszót:';
$string['eolstudentoutoftime'] = 'Figyelem! Túllépte a leckeidőt. Előfordulhat, hogy utolsó válasza már nem fog beszámítani.';
$string['eolstudentoutoftimenoanswers'] = 'Nem válaszolt egyetlen kérdésre sem. A leckére 0 pontot kapott.';
$string['essay'] = 'Esszé';
$string['essayemailmessage2'] = '<p>Esszéüzenet:<blockquote>{$a->question}</blockquote></p><p>Az Ön válasza:<blockquote><em>{$a->response}</em></blockquote></p><p>A pontozó megjegyzései:<blockquote><em>{$a->comment}</em></blockquote></p><p>Ezen esszékérdésre a lehetséges {$a->outof} pontból {$a->earned} pontot kapott.</p><p>A leckével kapcsolatos pontszáma {$a->newgrade}%-ra módosult.</p>';
$string['essayemailmessagesmall'] = '<p>Az esszékérdésre az összesen {$a->outof} pontból {$a->earned} pontot szerzett</p><p>Osztályzata {$a->lesson} lecke esetén {$a->newgrade}%-ra módosult.</p>';
$string['essayemailsubject'] = 'Leckekérdésre elérhető osztályzat';
$string['essaynotgradedyet'] = 'Az esszé még nincs leosztályozva';
$string['essayresponses'] = 'Esszéválaszok';
$string['essays'] = 'Esszék';
$string['essayscore'] = 'Esszé pontszáma';
$string['eventcontentpageviewed'] = 'Tartalomoldal megtekintve';
$string['eventessayassessed'] = 'Esszé értékelve';
$string['eventessayattemptviewed'] = 'Esszékérdéssel való próbálkozás megtekintve';
$string['eventlessonended'] = 'A lecke véget ért';
$string['eventlessonrestarted'] = 'Lecke újrakezdve';
$string['eventlessonresumed'] = 'Lecke folytatva';
$string['eventlessonstarted'] = 'A lecke elkezdődött';
$string['eventoverridecreated'] = 'Leckefelülírás létrehozva';
$string['eventoverridedeleted'] = 'Leckefelülírás törölve';
$string['eventoverrideupdated'] = 'Leckefelülírás frissítve';
$string['eventpagecreated'] = 'Oldal létrehozva';
$string['eventpagedeleted'] = 'Oldal törölve';
$string['eventpagemoved'] = 'Oldal áthelyezve';
$string['eventpageupdated'] = 'Oldal frissítve';
$string['eventquestionanswered'] = 'Kérdés megválaszolva';
$string['eventquestionviewed'] = 'Kérdés megtekintve';
$string['false'] = 'Hamis';
$string['fileformat'] = 'Állományforma';
$string['finalwrong'] = 'Nem egészen.';
$string['finish'] = 'Kész';
$string['firstanswershould'] = 'Az első válasznak a Helyes oldalra kell ugrania';
$string['firstwrong'] = 'Hibásan válaszolt. Azért a tanulás kedvéért folytatná még a próbálkozást (de már pontszerzés nélkül)?';
$string['flowcontrol'] = 'Folyamat szabályozása';
$string['fractionsaddwrong'] = 'A pozitív pontok összege nem 100%,<br />hanem {$a}%.<br />Visszatér és kijavítja ezt a kérdést?';
$string['fractionsnomax'] = 'Az egyik válaszlehetőségnek 100%-nak kell lenni ahhoz,<br />hogy teljes pontszámot kapjon erre a kérdésre.<br />Visszatér és kijavítja a kérdést?';
$string['full'] = 'Kibontva';
$string['general'] = 'Általános';
$string['gotoendoflesson'] = 'Tovább a lecke végére';
$string['grade'] = 'Pont';
$string['gradebetterthan'] = 'Ponthatár';
$string['gradebetterthanerror'] = '{$a} százaléknál magasabb pontszám szerzése';
$string['graded'] = 'Pontozott';
$string['gradeessay'] = 'Esszékérdések pontozása ({$a->notgradedcount} pontozatlan és {$a->notsentcount} elküldetlen)';
$string['gradeis'] = 'A pont: {$a}';
$string['gradeoptions'] = 'Pontozási lehetőségek';
$string['groupoverrides'] = 'Csoportfelülírások';
$string['groupoverridesdeleted'] = 'Csoportfelülírások törölve';
$string['groupsnone'] = 'Nincs elérhető csoport.';
$string['handlingofretakes'] = 'Leckeismétlés kezelése';
$string['handlingofretakes_help'] = '<p>Ha a tanulók megismételhetnek egy leckét, ezzel az opcióval a tanár megjelenítheti a leckére adott pontok számát például a Pontok oldalon, vagy úgy, mint a különféle próbálkozások pontjainak <b>átlagát</b>, vagy úgy, mint a tanulók <b>legjobb</b> próbálkozásaira adott pontszámot.</p>

<p>Ez az opció bármikor módosítható.</p>';
$string['havenotgradedyet'] = 'Még nincs pontozva.';
$string['here'] = 'itt';
$string['highscore'] = 'Magas pontszám';
$string['hightime'] = 'Leghosszabb idő';
$string['importcount'] = '{$a} kérdés importálása';
$string['importquestions'] = 'Kérdések importálása';
$string['importquestions_help'] = 'Ezzel a funkcióval külső, űrlapon keresztül feltöltött szöveges állományból importálhat különféle formájú kérdéseket.  
';
$string['inactiveoverridehelp'] = '* A felülírás nem működik, mert a felhasználó hozzáférése a tevékenységhez korlátozott. Ennek oka lehet a csoport- vagy szerepfeladatok, illetve egyéb korlátozások, vagy pedig rejtett tevékenység.';
$string['indicator:cognitivedepth'] = 'Kognitív lecke';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által a lecke kapcsán elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív lecke';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő az elemzési időszak alatt a Lecke tevékenységei során kognitív elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Újbóli leadás visszajelzés megtekintése után)';
$string['indicator:socialbreadth'] = 'Társas lecke';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által a lecke kapcsán elért társas lefedettségen alapul.';
$string['indicator:socialbreadthdef'] = 'Társas lecke';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő az elemzési időszak alatt a Lecke tevékenységei során társas elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs részvétel, Egyedüli részvétel, Másokkal együtt való részvétel)';
$string['insertedpage'] = 'Oldal beszúrva';
$string['invalidfile'] = 'Érvénytelen állomány';
$string['invalidid'] = 'Nem került sor kurzusmodul-azonosító vagy leckeazonosító átadására';
$string['invalidlessonid'] = 'hibás volt a leckeazonosító';
$string['invalidoverrideid'] = 'Érvénytelen felülírási azonosító';
$string['invalidpageid'] = 'Érvénytelen oldalazonosító';
$string['jump'] = 'Ugrás';
$string['jumps'] = 'Ugrások';
$string['jumps_help'] = 'Minden (kérdésre adott) válaszhoz vagy (tartalomoldalhoz tartozó) leíráshoz hozzátartozik egy hivatkozás. A hivatkozás lehet relatív, pl. ez az oldal vagy a következő oldal,  vagy abszolút, azaz a lecke bármely oldala.';
$string['jumpsto'] = 'Ugrások ide: {$a}';
$string['leftduringtimed'] = 'Időméréses lecke közben távozott.<br />Kattintson a Folytatás gombra, és kezdje újra a leckét.';
$string['leftduringtimednoretake'] = 'Időméréses lecke közben távozott, ezért nem ismételheti meg és nem folytathatja a leckét.';
$string['leftduringtimedsession'] = 'Időméréses óra közben távozott';
$string['lesson:addinstance'] = 'Új lecke hozzáadása';
$string['lesson:edit'] = 'Lecketevékenység szerkesztése';
$string['lesson:grade'] = 'A lecke esszékérdéseinek osztályozása';
$string['lesson:manage'] = 'Lecketevékenység kezelése';
$string['lesson:manageoverrides'] = 'Leckefelülírások kezelése';
$string['lesson:view'] = 'Lecketevékenység megtekintése';
$string['lesson:viewreports'] = 'Leckéről szóló jelentések megtekintése';
$string['lessonclosed'] = 'A lecke lezárult {$a} időpontban.';
$string['lessoncloses'] = 'A lecke lezárul';
$string['lessoncloseson'] = 'A lecke lezárul ekkor: {$a}';
$string['lessoneventcloses'] = '{$a} lezárul';
$string['lessoneventopens'] = '{$a} megnyílik';
$string['lessonformating'] = 'Lecke formázása';
$string['lessonmenu'] = 'Lecke menü';
$string['lessonname'] = 'Lecke: {$a}';
$string['lessonnotready'] = 'A lecke nem végezhető el. Forduljon a(z) {$a}-hoz.';
$string['lessonnotready2'] = 'A lecke még nem végezhető el.';
$string['lessonopen'] = 'A lecke {$a} időpontban kezdődik.';
$string['lessonopens'] = 'A lecke kezdődik';
$string['lessonpagelinkingbroken'] = 'Nincs meg az első oldal. A leckeoldal nem kapcsolódik. Forduljon a rendszergazdához.';
$string['lessonstats'] = 'Leckestatisztika';
$string['linkedmedia'] = 'Kapcsolt média';
$string['loginfail'] = 'Belépése nem sikerült, próbálja újra...';
$string['lowscore'] = 'Alacsony pontszám';
$string['lowtime'] = 'Legrövidebb idő';
$string['manualgrading'] = 'Osztályozott esszék';
$string['matchesanswer'] = 'Válasszal egyezik';
$string['matching'] = 'Párosítás';
$string['matchingpair'] = 'A(z) {$a} pár párosítása';
$string['maxgrade'] = 'Maximális pont';
$string['maxgrade_help'] = '<p>Ez az érték határozza meg azt a maximális pontszámot, amely a leckére adható. A tartomány 0 és 100% között változhat. Ez az érték a lecke alatt
bármikor módosítható. Bármely változás azonnal megjelenik a Pontok oldalon és a különféle listákban a tanulók számára megjelenő pontoknál.
Ha a pontszám 0-ra van állítva, a lecke nem jelenik  meg egy Pontok oldalon sem.</p>';
$string['maximumnumberofanswersbranches'] = 'Válaszok maximális száma';
$string['maximumnumberofanswersbranches_help'] = 'Ez az érték határozza meg azon válaszok maximális számát, amelyek egy leckében használhatók. Ha mindvégig csak IGAZ vagy HAMIS kérdések szerepelnek, akkor az értéket 2-re állíthatja. A beállítás bármikor módosítható, mivel csak azt érinti, amit a tanár lát, nem pedig az adatokat.';
$string['maximumnumberofattempts'] = 'Próbálkozások maximális száma kérdésenként';
$string['maximumnumberofattempts_help'] = 'Ez az érték határozza meg, hogy legfeljebb hányszor
lehet próbálkozni az egyes kérdések megoldása során. Hibás ismételt válasz esetén a maximális szám
elérését követően a lecke következő oldala jelenik meg.';
$string['maximumnumberofattemptsreached'] = 'A próbálkozások maximális számát elérte - áttérés a következő oldalra.';
$string['mediaclose'] = 'Lezárás gombjának kijelzése';
$string['mediafile'] = 'Kapcsolt média';
$string['mediafile_help'] = 'A leckéhez médiumállományt tölthet föl. Ekkor a lecke minden oldalán a Kapcsolt média blokkban megjelenik egy "A megtekintéshez kattintson ide" hivatkozás.';
$string['mediafilepopup'] = 'A megtekintéshez kattintson ide.';
$string['mediaheight'] = 'Előugró ablak magassága';
$string['mediawidth'] = 'Előugró ablak szélessége';
$string['messageprovider:graded_essay'] = 'Értesítés osztályozott esszéről';
$string['minimumnumberofquestions'] = 'Kérdések minimális száma';
$string['minimumnumberofquestions_help'] = 'Ez az érték határozza meg a tevékenységre adott pont kiszámításához használt kérdések minimális számát.';
$string['missingname'] = 'Adjon meg egy becenevet';
$string['modattempts'] = 'Önértékelés engedélyezése';
$string['modattempts_help'] = '<p>Lehetővé teszi, hogy a tanuló a leckében visszalépve módosítsa válaszait.</p>';
$string['modattemptsnoteacher'] = 'Önértékelést csak tanulók végezhetnek.';
$string['modulename'] = 'Lecke';
$string['modulename_help'] = 'Lecke

A lecke tartalmak érdekes és rugalmas módon való közvetítésére használható. Több oldalból tevődik össze. Minden oldal általában egy kérdéssel és hozzá egy sor lehetséges válasszal zárul. A tanuló a válaszadási lehetőségektől függően vagy továbblép a következő oldalra, vagy visszajut az előzőre. A leckén való végighaladás a közreadandó anyag struktúrájától függően lehet egyszerű és bonyolult.

A lecke osztályozható, az osztályzat az osztályozónaplóban rögzíthető.

Alkalmazható:

* Új téma önálló feldolgozására
* Forgatókönyvek és döntéshozatali kötülmények szimulálására
* Egyedi ismétlő-rendszerező tevékenységekre';
$string['modulenameplural'] = 'Leckék';
$string['move'] = 'Oldal áthelyezése';
$string['movedpage'] = 'Oldal áthelyezve';
$string['movepagehere'] = 'Oldal áthelyezése ide';
$string['movepagenamed'] = 'Oldaláthelyezés: {$a}';
$string['moving'] = 'A(z) {$a} oldal áthelyezése';
$string['multianswer'] = 'Feleletválasztós';
$string['multianswer_help'] = 'Jelölje be a négyzetet, ha egynél több válasz helyes.';
$string['multichoice'] = 'Feleletválasztós';
$string['multipleanswer'] = 'Több válasz';
$string['nameapproved'] = 'Név elfogadva';
$string['namereject'] = 'Nevét a szűrő nem fogadta el. Próbálkozzon egy másik névvel.';
$string['new'] = 'új';
$string['nextpage'] = 'Következő oldal';
$string['noanswer'] = 'Nincs megadva válasz. Lépjen vissza és adjon le egy választ.';
$string['noattemptrecordsfound'] = 'Nincs próbálkozás rögzítve: nem kapott pontot';
$string['nobranchtablefound'] = 'Nincs tartalomoldal';
$string['noclose'] = 'Nincs befejezési dátum';
$string['nocommentyet'] = 'Még nincs megjegyzés.';
$string['nocoursemods'] = 'Nincs tevékenység';
$string['nocredit'] = 'Nincs kreditpont';
$string['nodeadline'] = 'Nincs határidő';
$string['noessayquestionsfound'] = 'A leckében nincs esszékérdés.';
$string['nohighscores'] = 'Nincsenek legmagasabb pontszámok';
$string['nolessonattempts'] = 'A leckével kapcsolatosan nem történt próbálkozás.';
$string['nolessonattemptsgroup'] = '{$a} csoporttag a leckével nem próbálkozott.';
$string['none'] = 'Nincs';
$string['nooneansweredcorrectly'] = 'Senki nem felelt helyesen.';
$string['nooneansweredthisquestion'] = 'Senki nem felelt a kérdésre.';
$string['noonecheckedthis'] = 'Senki nem ellenőrizte ezt.';
$string['nooneenteredthis'] = 'Senki nem válaszolta ezt.';
$string['noonehasanswered'] = 'Senki nem válaszolt még egyetlen esszékérdésre sem.';
$string['noonehasansweredgroup'] = '{$a} esetén senki nem válaszolt esszékérdésre.';
$string['noopen'] = 'Nincs kezdési dátum';
$string['nooverridedata'] = 'A leckebeállítások közül legalább egyet felül kell írnia';
$string['noretake'] = 'Ezt a leckét nem ismételheti meg.';
$string['normal'] = 'Szokásos - kövesse a lecke útvonalát';
$string['notcompleted'] = 'Nincs befejezve';
$string['notcompletedwithdate'] = 'Nem fejeződött be  ({$a})';
$string['notdefined'] = 'Nincs megadva';
$string['notenoughsubquestions'] = 'Kevés alkérdést adott meg!<br />Visszatér és kijavítja ezt a kérdést?';
$string['notenoughtimespent'] = 'A leckét $a->timespent} idő alatt fejezte be, ez kevesebb, mint az előírt {$a->timerequired} idő.';
$string['notgraded'] = 'Nincs osztályozva';
$string['notitle'] = 'Nincs cím';
$string['notyetcompleted'] = 'A lecke elkezdődött, de még nem fejeződött be';
$string['numberofcorrectanswers'] = 'A helyes válaszok száma: {$a}';
$string['numberofcorrectanswersheader'] = 'Helyes válaszok száma';
$string['numberofcorrectmatches'] = 'A helyes megfelelések száma: {$a}';
$string['numberofpagestoshow'] = 'Megjelenítendő oldalak száma';
$string['numberofpagestoshow_help'] = '<p>Ez a paraméter kizárólag Flash Card típusú leckékre érvényes. Az alapérték
nulla, ami azt jelenti, hogy egy leckében minden oldal/kártya megjelenik. Ha ezt a paramétert nem nullának
megfelelő valamilyen értékre állítja, akkor az adott számú oldal fog megjelenni. Ha az adott
számú oldalt/kártyát a rendszer megmutatta, a lecke véget ér és a tanuló előtt
láthatóvá válik az elért pontszám.</p>

<p>Ha a paramétert a leckében lévő oldalak számánál nagyobb értékre
állítja, akkor a lecke akkor ér véget, ha megtörtént minden oldal megjelenítése.</p>';
$string['numberofpagesviewed'] = 'A megtekintett oldalak száma: {$a}';
$string['numberofpagesviewedheader'] = 'Megválaszolt kérdések száma';
$string['numberofpagesviewednotice'] = 'Megválaszolt kérdések száma: {$a->nquestions}; (Megválaszolandó legalább: {$a->minquestions})';
$string['numerical'] = 'Számjegyes';
$string['numericanswer'] = 'Számjegyes válasz';
$string['numericanswer_help'] = 'Megadhat egy számot vagy kettősponttal egy számtartományt. Például 2:5 esetén a 2 és 5 közé eső számok helyesek.';
$string['offlinedatamessage'] = 'A próbálkozást mobil eszközről kezdeményezte. A portál utolsó adatmentése  {$a} ezelőtt történt. Ellenőrizze, nincs-e mentendő munkája.';
$string['ongoing'] = 'Pillanatnyi pont mutatása';
$string['ongoing_help'] = '<p>Bekapcsolása esetén az egyes oldalakon megjelenik a tanuló által az összes
 megszerezhető pontból ez idáig megszerzett pontok száma.
 Példa: egy tanuló négy 5 pontos kérdésre válaszolt és egyre hibás választ adott.
 Ekkor a pillanatnyi pont 15/20 pont lesz.</p>';
$string['ongoingcustom'] = '{$a->score} pontot ért el az eddig elérhető {$a->currenthigh} pontból.';
$string['ongoingnormal'] = '{$a-&gt;correct} kérdést válaszolt meg helyesen az eddigi {$a-&gt;viewed} próbálkozásból';
$string['onpostperpage'] = 'Pontonként csak egy hozzászólás';
$string['openafterclose'] = 'A nyitási idő a zárási idő után van.';
$string['options'] = 'Lehetőségek';
$string['or'] = 'VAGY';
$string['ordered'] = 'Rendezett';
$string['other'] = 'Egyéb';
$string['outof'] = '{$a}-ból/-ből';
$string['override'] = 'Felülírás';
$string['overridedeletegroupsure'] = 'Biztosan törli {$a} csoport felülírását?';
$string['overridedeleteusersure'] = 'Biztosan törli {$a} felhasználó felülírását?';
$string['overridegroup'] = 'Csoport felülírása';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Felülírások';
$string['overrideuser'] = 'Felhasználó felülírása';
$string['overrideusereventname'] = '{$a->lesson} - Felülírás';
$string['overview'] = 'Áttekintés';
$string['overview_help'] = 'Egy-egy lecke néhány oldalból és esetlegesen tartalomoldalakból épül föl.
Egy oldalon valamilyen tartalom  jelenik meg, és általában egy kérdéssel végződik. A válaszokhoz hozzátartozik egy hivatkozás. A hivatkozás lehet relatív - adott oldalhoz, következő oldalhoz való ugrás - vagy abszolút - a lecke bármely oldalára vagy a lecke végére ugrás. A tartalomoldal a lecke más oldalaira, például a tartalomjegyzékre  mutató hivatkozásokat tartalmaz.';
$string['page'] = 'Oldal: {$a}';
$string['page-mod-lesson-edit'] = 'Leckeoldal szerkesztése';
$string['page-mod-lesson-view'] = 'Lecke megtekintése vagy előnézete';
$string['page-mod-lesson-x'] = 'Bármely leckeoldal';
$string['pageanswers'] = 'Oldal válaszai';
$string['pagecontents'] = 'Oldal tartalma';
$string['pageresponses'] = 'Oldal feleletei';
$string['pages'] = 'Oldalak';
$string['pagetitle'] = 'Oldal címe';
$string['password'] = 'Jelszó';
$string['passwordprotectedlesson'] = 'A(z) {$a} egy jelszóval védett lecke.';
$string['pleasecheckoneanswer'] = 'Jelöljön be egy választ';
$string['pleasecheckoneormoreanswers'] = 'Jelöljön be egy vagy több választ';
$string['pleaseenteryouranswerinthebox'] = 'A négyzetbe írja be a választ';
$string['pleasematchtheabovepairs'] = 'Párosítsa a fenti elemeket';
$string['pluginadministration'] = 'Lecke kezelése';
$string['pluginname'] = 'Lecke';
$string['pointsearned'] = 'Kapott pontok';
$string['postprocesserror'] = 'Hiba történt utófeldolgozás közben!';
$string['postsuccess'] = 'Az elküldés sikerült';
$string['practice'] = 'Gyakorló lecke';
$string['practice_help'] = '<p>A gyakorló lecke nem jelenik meg az osztálynaplóban.</p>';
$string['preprocesserror'] = 'Hiba történt előfeldolgozás közben!';
$string['prerequisiteisobsolete'] = 'Az előre elvégzendő lecke törlendő. Használja helyette a hozzáférés korlátozását.';
$string['prerequisitelesson'] = 'Előfeltételként megadott lecke';
$string['preview'] = 'Előzetes megtekintés';
$string['previewlesson'] = '{$a} előzetes képe';
$string['previewpagenamed'] = 'Oldal előnézete: {$a}';
$string['previouspage'] = 'Előző oldal';
$string['privacy:metadata:attempts'] = 'Oldal próbálkozásainak a rekordja';
$string['privacy:metadata:attempts:answerid'] = 'A válasz azonosítója';
$string['privacy:metadata:attempts:correct'] = 'Jó volt-e a próbálkozás';
$string['privacy:metadata:attempts:pageid'] = 'Az oldal azonosítója';
$string['privacy:metadata:attempts:retry'] = 'A próbálkozás száma';
$string['privacy:metadata:attempts:timeseen'] = 'A próbálkozás időpontja';
$string['privacy:metadata:attempts:useranswer'] = 'A felhasználó válaszának részletei';
$string['privacy:metadata:attempts:userid'] = 'A felhasználó azonosítója';
$string['privacy:metadata:branch'] = 'A megtekintett oldalak rekordja';
$string['privacy:metadata:branch:flag'] = 'A következő oldal kiszámítása véletlenszerű volt-e';
$string['privacy:metadata:branch:nextpageid'] = 'A következő oldal azonosítója';
$string['privacy:metadata:branch:pageid'] = 'Az oldal azonosítója';
$string['privacy:metadata:branch:retry'] = 'A próbálkozás száma';
$string['privacy:metadata:branch:timeseen'] = 'Az oldal megtekintésének időpontja';
$string['privacy:metadata:branch:userid'] = 'A felhasználó azonosítója';
$string['privacy:metadata:grades'] = 'Az egyes leckék után járó osztályzatok rekordja';
$string['privacy:metadata:grades:completed'] = 'Az osztályozás napja';
$string['privacy:metadata:grades:grade'] = 'Az adott osztályzat';
$string['privacy:metadata:grades:userid'] = 'A felhasználó azonosítója';
$string['privacy:metadata:overrides'] = 'Leckénkénti felülírások rekordja';
$string['privacy:metadata:overrides:available'] = 'A tanulók ettől az időponttól próbálkozhatnak a leckével';
$string['privacy:metadata:overrides:deadline'] = 'A tanulók eddig végezhetnek a leckével.';
$string['privacy:metadata:overrides:maxattempts'] = 'A próbálkozások maximális száma';
$string['privacy:metadata:overrides:password'] = 'A leckéhez tartozó jelszó';
$string['privacy:metadata:overrides:retake'] = 'Engedélyezett-e az újrapróbálkozás';
$string['privacy:metadata:overrides:review'] = 'Engedélyezett-e a kérdéssel való újrapróbálkozás';
$string['privacy:metadata:overrides:timelimit'] = 'A lecke befejezésének időkorlátja másodpercben';
$string['privacy:metadata:overrides:userid'] = 'A felhasználó azonosítója';
$string['privacy:metadata:timer'] = 'Leckével próbálkozás rekordja';
$string['privacy:metadata:timer:completed'] = 'Véget ért-e a próbálkozás';
$string['privacy:metadata:timer:lessontime'] = 'A tevékenység rögzítésének utolsó pillanata';
$string['privacy:metadata:timer:starttime'] = 'A próbálkozás kezdetének dátuma';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'A tevékenység mobil alkalmazásról rögzítésének utolsó pillanata';
$string['privacy:metadata:timer:userid'] = 'A felhasználó azonosítója';
$string['privacy:metadata:userpref:lessonview'] = 'Leckeszerkesztés során a kiválasztott kijelzési mód';
$string['privacy:path:essayanswers'] = 'Esszéválaszok';
$string['privacy:path:essayresponses'] = 'Esszéválaszok';
$string['privacy:path:pages'] = 'Oldalak';
$string['processerror'] = 'Hiba történt feldolgozás közben!';
$string['progressbar'] = 'Folyamatjelző';
$string['progressbar_help'] = '<p>Folyamatjelző megjelenítése a lecke alján.
Jelenleg a folyamatjelző lineáris lecke esetén pontos.</p>
<p>A teljesített százalék kiszámításakor a lecke elvégzésébe az
elágazási táblázatok és a helyesen
megválaszolt kérdésoldalak számítanak bele.  A lecke összes oldalainak a kiszámítása
során a tömbök és a tömbökön belüli oldalak csak egyetlen oldalnak számítanak,
a tömb vége és az elágazási táblázat oldalainak a vége viszont nem.
Minden egyéb oldal beleszámít a lecke teljes oldalszámába.</p>
<p>Megjegyzés: a folyamatjelző alapstílusa nem éppen tetszetős ;)  A folyamatjelző minden stílusa
(például: színek, háttérképek stb.) a mod/lesson/styles.php állományban módosítható.';
$string['progressbarteacherwarning'] = '{$a} folyamatjelzője nem látszik';
$string['progressbarteacherwarning2'] = 'A folyamatjelzőt nem fogja látni, mert Ön szerkesztheti ezt a leckét.';
$string['progresscompleted'] = 'A lecke {$a}%-át fejezte be.';
$string['qtype'] = 'Oldal típusa';
$string['question'] = 'Kérdés';
$string['questionoption'] = 'Kérdés';
$string['questiontype'] = 'Kérdésfajta';
$string['randombranch'] = 'Véletlenszerűen tartalomoldal';
$string['randompageinbranch'] = 'Véletlenszerű kérdés tartalomoldalon belül';
$string['rank'] = 'Sorrend';
$string['rawgrade'] = 'Nyers pont';
$string['receivedcredit'] = 'Kreditpontot kapott';
$string['redisplaypage'] = 'Oldal újbóli megjelenítése';
$string['removeallgroupoverrides'] = 'Az összes csoportfelülírás törlése';
$string['removealluseroverrides'] = 'Az összes felhasználó-felülírás törlése';
$string['report'] = 'Jelentés';
$string['reports'] = 'Jelentések';
$string['response'] = 'Tanuló válasza';
$string['retakesallowed'] = 'Újbóli próbálkozások engedélyezve';
$string['retakesallowed_help'] = '<p>Ez a beállítás határozza meg, hogy a tanulók egynél többször is elvégezhetnek-e egy
leckét. A tanár vélekedhet úgy, hogy a leckében szerepelnek olyan anyagok, amelyeket a tanulóknak
alaposan ismerniük kell. Ilyen esetben lehetővé kell tenni a lecke ismételt megtekintését. Ha viszont a
tananyag inkább afféle vizsga szerepét tölti be, azt a tanulók csak egyszer vehetik végig.</p>

<p>Ha engedélyezi a lecke újbóli elvégzését, akkor a pontokat tartalmazó oldalon
lévő <strong>pontok</strong> vagy az ismétlések <strong>átlagos</strong> pontszámát, vagy a
tanulóknak a leckére kapott <strong></strong> pontszámát jelzik. A következő paraméter azt
határozza meg, hogy a két pontozási lehetőség közül melyiket fogja használni.</p>

<p>Ne feledje, hogy a <strong>kérdéselemzés</strong> mindig a leckén végrehajtott első
próbálkozásból kapott válaszokra vonatkozik, a tanulók későbbi
próbálkozásait figyelmen kívül hagyja.</p>

<p>Alaphelyzetben ez az opció <strong>Igen</strong>-re van beállítva, vagyis a tanulók újból
elvégezhetik a leckét. Ezt az opciót feltehetőleg csak kivételes esetekben kell <strong>Nem</strong>-re állítani.</p>';
$string['returnto'] = 'Vissza ide: {$a}';
$string['returntocourse'] = 'Vissza a kurzushoz';
$string['reverttodefaults'] = 'Visszatérés a lecke alapbeállításaihoz';
$string['review'] = 'Értékelés';
$string['reviewlesson'] = 'Összefoglaló lecke';
$string['reviewquestionback'] = 'Igen, megpróbálnám';
$string['reviewquestioncontinue'] = 'Nem, továbblépek a következő kérdésre';
$string['sanitycheckfailed'] = 'Alaphiba ellenőrzése sikertelen: a próbálkozás törölve';
$string['save'] = 'Mentés';
$string['savechanges'] = 'Változások mentése';
$string['savechangesandeol'] = 'Minden változás mentése és áttérés a lecke végére';
$string['saveoverrideandstay'] = 'Mentés és másik felülírás megadása';
$string['savepage'] = 'Oldal mentése';
$string['score'] = 'Pontszám';
$string['score_help'] = 'Pontozás csak egyedi pontozás esetén használható. Ilyenkor minden válaszhoz egy (pozitív vagy negatív) számérték rendelhető.';
$string['scores'] = 'Pontszámok';
$string['search:activity'] = 'Lecketevékenységek';
$string['secondpluswrong'] = 'Nem pontos. Próbálkozna újra?';
$string['selectallattempts'] = 'Az összes próbálkozás kiválasztása';
$string['selectaqtype'] = 'Válasszon kérdéstípust';
$string['sent'] = 'Elküldve';
$string['shortanswer'] = 'Kiegészítendő';
$string['showanunansweredpage'] = 'Megválaszolatlan oldal megjelenítése';
$string['showanunseenpage'] = 'Kihagyott oldal megjelenítése';
$string['singleanswer'] = 'Egy válasz';
$string['skip'] = 'Navigálás kihagyása';
$string['slideshow'] = 'Bemutató';
$string['slideshow_help'] = '<p>A leckét rögzített szélességű és magasságú, testre szabott hátterű
bemutatóként jeleníti meg. CSS-alapú gördítősáv jelenik meg, ha a tartalom
szélessége vagy magassága meghaladja a képkockáét. A kérdések \'kilépnek\'
a bemutató módból, csak az oldalak (elágazási táblázatok) látszanak a
képkockában. A képkocka jobb és bal szélén a "Következő" és a "Vissza" gombok jelennek meg,
ha ez az opció az oldalon ki van választva. A többi gomb a képkocka alatt középen látszik.</p>';
$string['slideshowbgcolor'] = 'Bemutató háttérszíne';
$string['slideshowheight'] = 'Bemutató magassága';
$string['slideshowwidth'] = 'Bemutató szélessége';
$string['startlesson'] = 'Lecke elkezdése';
$string['studentattemptlesson'] = '{$a->lastname} {$a->firstname} próbálkozásainak száma {$a->attempt}';
$string['studentname'] = '{$a} név';
$string['studentoneminwarning'] = 'Vigyázat! A lecke befejezéséhez 1 percnél kevesebb ideje maradt.';
$string['studentoutoftimeforreview'] = 'Figyelem: a lecke ellenőrzéséről lekésett';
$string['studentresponse'] = '{$a} tanuló válasza';
$string['submit'] = 'Leadás';
$string['submitname'] = 'Név leadása';
$string['teacherjumpwarning'] = 'A lecke {$a->cluster} ugrást vagy {$a->unseen} ugrást tartalmaz. Helyette a következő oldalra ugrik. Az ugrások ellenőrzéséhez lépjen be tanulóként.';
$string['teacherongoingwarning'] = 'A pillanatnyi pontszám csak tanuló számára látható. Ellenőrzéséhez lépjen be tanulóként.';
$string['teachertimerwarning'] = 'Az időmérő csak tanuló számára látható. Ellenőrzéséhez lépjen be tanulóként.';
$string['thatsthecorrectanswer'] = 'Ez a helyes válasz';
$string['thatsthewronganswer'] = 'Ez a hibás válasz';
$string['thefollowingpagesjumptothispage'] = 'A következő oldalak erre az oldalra ugranak';
$string['thispage'] = 'Ez az oldal';
$string['timeisup'] = 'Az idő letelt';
$string['timelimit'] = 'Időkorlát';
$string['timelimit_help'] = 'Bekapcsolása esetén a lecke elején megjelenik az időkorlátra figyelmeztetés és egy visszaszámláló. Ha letelt az idő, a válasz kimarad az osztályozásból.';
$string['timelimitwarning'] = 'A lecke befejezéséhez rendelkezésére áll:  {$a}.';
$string['timeremaining'] = 'Hátralévő idő';
$string['timespenterror'] = 'Töltsön legalább {$a} percet a leckével';
$string['timespentminutes'] = 'Eltöltött idő (perc)';
$string['timetaken'] = 'Felhasznált idő';
$string['totalpagesviewedheader'] = 'Megtekintett oldalak száma';
$string['true'] = 'Igaz';
$string['truefalse'] = 'Igaz/hamis';
$string['unabledtosavefile'] = 'A feltöltött állományt nem lehetett elmenteni';
$string['unknownqtypesnotimported'] = 'A nem támogatott kérdéstípusú {$a} kérdés importálása nem történt meg';
$string['unseenpageinbranch'] = 'Kihagyott kérdés egy tartalomoldalon';
$string['unsupportedqtype'] = 'Nem támogatott kérdéstípus ({$a})!';
$string['updatedpage'] = 'Frissített oldal';
$string['updatefailed'] = 'A frissítés nem sikerült';
$string['updatepagenamed'] = 'Oldalfrissítés: {$a}';
$string['usemaximum'] = 'Maximális érték használata';
$string['usemean'] = 'Középérték használata';
$string['usepassword'] = 'Jelszóval védett lecke';
$string['usepassword_help'] = '<p>A tanuló csak akkor férhet hozzá a leckéhez, ha begépeli a jelszót.</p>';
$string['useroverrides'] = 'Felhasználó-felülírások';
$string['useroverridesdeleted'] = 'Felhasználó-felülírások törölve';
$string['usersnone'] = 'A leckéhez tanuló nem férhet hozzá';
$string['viewessayanswers'] = 'Esszéválaszok megtekintése';
$string['viewgrades'] = 'Pontok kijelzése';
$string['viewreports'] = '{$a->attempts} befejezett {$a->student} próbálkozás megtekintése';
$string['viewreports2'] = '{$a} befejezett próbálkozás megtekintése';
$string['warning'] = 'Figyelmeztetés';
$string['welldone'] = 'Nagyszerű!';
$string['whatdofirst'] = 'Mivel szeretne kezdeni?';
$string['withselectedattempts'] = 'A kiválasztott próbálkozásokkal...';
$string['wronganswerjump'] = 'Ugrás helytelen válaszról';
$string['wronganswerscore'] = 'Helytelen válaszra adott pontszám';
$string['wrongresponse'] = 'Tanuló helytelen válasza';
$string['xattempts'] = '{$a} próbálkozás';
$string['youhaveseen'] = 'Ebből a leckéből már egynél több oldalt látott.<br />Az utolsó megtekintett oldalon kívánja folytatni?';
$string['youranswer'] = 'Válasza';
$string['yourcurrentgradeis'] = 'Jelenlegi pontja:  {$a}';
$string['yourcurrentgradeisoutof'] = 'Jelenlegi pontjainak száma {$a->grade} pont a {$a->total} pontból';
$string['youshouldview'] = 'Minimálisan megválaszolandó: {$a}';
