<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'el', version '3.10'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ενέργεια';
$string['actions'] = 'Ενέργειες';
$string['addappointment'] = 'Προσθήκη κι άλλου μαθητή';
$string['addcommands'] = 'Προσθήκη χρονοθυρίδων';
$string['addondays'] = 'Προσθήκη ραντεβού στις';
$string['addsession'] = 'Προσθήκη επαναλαμβανόμενων χρονοθυρίδων';
$string['addsingleslot'] = 'Προσθήκη μίας μόνο χρονοθυρίδας';
$string['addslot'] = 'Μπορείτε να προσθέσετε επιπρόσθετες χρονοθυρίδες ραντεβού οποιαδήποτε στιγμή.';
$string['addstudenttogroup'] = 'Προσθήκη αυτού του μαθητή σε ομάδα ραντεβού';
$string['allappointments'] = 'Όλα τα ραντεβού';
$string['allononepage'] = 'Όλες οι χρονοθυρίδες σε μία σελίδα';
$string['allowgroup'] = 'Αποκλειστική χρονοθυρίδα - κάντε κλικ για αλλαγή';
$string['appointingstudent'] = 'Ραντεβού για χρονοθυρίδα';
$string['appointingstudentinnew'] = 'Ραντεβού για νέα χρονοθυρίδα';
$string['appointment'] = 'Ραντεβού';
$string['appointmentmode'] = 'Ορισμός της κατάστασης λειτουργίας των ραντεβού';
$string['appointmentno'] = 'Ραντεβού {$a}';
$string['appointmentnote'] = 'Σημειώσεις για το ραντεβού (ορατές σε μαθητή)';
$string['appointments'] = 'Ραντεβού';
$string['appointmentsgrouped'] = 'Ραντεβού ομαδοποιημένα κατά χρονοθυρίδα';
$string['appointmentsummary'] = 'Ραντεβού στις {$a->startdate} από {$a->starttime} έως {$a->endtime} με τον/την {$a->teacher}';
$string['appointsolo'] = 'μόνο εμένα';
$string['appointsomeone'] = 'Προσθήκη νέου ραντεβού';
$string['areaappointmentnote'] = 'Αρχεία σε σημειώσεις ραντεβού';
$string['areaslotnote'] = 'Αρχεία σε σημειώσεις χρονοθυρίδας';
$string['areateachernote'] = 'Αρχεία σε εμπιστευτικές σημειώσεις';
$string['attendablelbl'] = 'Σύνολο υποψηφίων για προγραμματισμό';
$string['availableslots'] = 'Διαθέσιμες χρονοθυρίδες';
$string['availableslotsall'] = 'Όλες οι χρονοθυρίδες';
$string['availableslotsnotowned'] = 'Χωρίς ιδιοκτήτη';
$string['availableslotsowned'] = 'ιδιοκτήτης';
$string['bookaslot'] = 'Κράτηση μιας χρονοθυρίδας';
$string['bookingdetails'] = 'Λεπτομέρειες κράτησης';
$string['bookinginstructions'] = 'Οδηγίες κρατήσεων';
$string['bookslot'] = 'Κράτηση χρονοθυρίδας';
$string['bookwithteacher'] = 'Διδάσκων';
$string['bookwithteacher_help'] = 'Επιλογή ενός διδάσκοντος για το ραντεβού.';
$string['break'] = 'Διάλειμμα μεταξύ χρονοθυρίδων';
$string['breaknotnegative'] = 'Η διάρκεια του διαλείμματος δεν μπορεί να είναι αρνητική';
$string['canbook1appointment'] = 'Μπορείτε να κάνετε κράτηση για ένα ακόμη ραντεβού σε αυτόν τον χρονοπρογραμματιστή.';
$string['canbooknappointments'] = 'Μπορείτε να κάνετε κράτηση για {$a} ακόμη ραντεβού σε αυτόν τον χρονοπρογραμματιστή.';
$string['canbooknofurtherappointments'] = 'Δεν μπορείτε να κάνετε πλέον καμία κράτηση για ραντεβού σε αυτόν τον χρονοπρογραμματιστή.';
$string['canbooksingleappointment'] = 'Μπορείτε να κάνετε κράτηση για ένα ραντεβού σε αυτόν τον χρονοπρογραμματιστή.';
$string['canbookunlimitedappointments'] = 'Μπορείτε να κάνετε κράτηση για οποιοδήποτε αριθμό ραντεβού σε αυτόν τον χρονοπρογραμματιστή.';
$string['cancelbooking'] = 'Ακύρωση κράτησης';
$string['chooseexisting'] = 'Επιλογή υπάρχοντος';
$string['choosingslotstart'] = 'Επιλογή χρόνου έναρξης';
$string['comments'] = 'Σχόλια';
$string['complete'] = 'Κρατημένο';
$string['confirmbooking'] = 'Επιβεβαίωση κράτησης';
$string['confirmdelete-all'] = 'Αυτό θα διαγράψει <b>όλες</b> τις χρονοθυρίδες σας σε αυτόν τον χρονοπρογραμματιστή. Η διαγραφή δεν αναιρείται. Σίγουρα διαγραφή;';
$string['confirmdelete-mine'] = 'Αυτό θα διαγράψει όλες τις χρονοθυρίδες σας σε αυτόν τον χρονοπρογραμματιστή. Η διαγραφή δεν αναιρείται. Σίγουρα διαγραφή;';
$string['confirmdelete-myunused'] = 'Αυτό θα διαγράψει όλες τις αχρησιμοποίητες χρονοθυρίδες σας σε αυτόν τον χρονοπρογραμματιστή. Η διαγραφή δεν αναιρείται. Σίγουρα διαγραφή;';
$string['confirmdelete-one'] = 'Διαγραφή χρονοθυρίδας;';
$string['confirmdelete-selected'] = 'Αυτό θα διαγράψει τις επιλεγμένες χρονοθυρίδες. Η διαγραφή δεν αναιρείται. Σίγουρα διαγραφή;';
$string['confirmdelete-unused'] = 'Αυτό θα διαγράψει όλες τις αχρησιμοποίητες χρονοθυρίδες σε αυτόν τον χρονοπρογραμματιστή. Η διαγραφή δεν αναιρείται. Σίγουρα διαγραφή;';
$string['confirmrevoke'] = 'Ανάκληση όλων των ραντεβού στην τρέχουσα χρονοθυρίδα;';
$string['conflictingslots'] = 'Η χρονοθυρίδα στο {$a} δεν μπορεί να δημιουργηθεί λόγω επικάλυψης άλλων χρονοθυρίδων:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} λεπτά) σε αυτόν τον χρονοπρογραμματιστή';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} λεπτά) στο μάθημα {$a->courseshortname}, χρονοπρογραμματιστής {$a->schedulername}';
$string['contentformat'] = 'Μορφότυπος';
$string['copytomyself'] = 'Αποστολή αντιγράφου στον εαυτό μου';
$string['course'] = 'Μάθημα';
$string['createexport'] = 'Δημιουργία αρχείου εξαγωγής';
$string['csvfieldseparator'] = 'Διαχωριστικό πεδίων για τα CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Αθροιστική διάρκεια των ραντεβού';
$string['datatoinclude'] = 'Δεδομένα για να συμπεριληφθούν';
$string['datatoinclude_help'] = 'Επιλογή των πεδίων που πρέπει να συμπεριληφθούν στην εξαγωγή. Κάθε ένα από αυτά θα εμφανίζεται σε μια στήλη του αρχείου εξόδου.';
$string['date'] = 'Ημερομηνία';
$string['datelist'] = 'Επισκόπηση';
$string['defaultslotduration'] = 'Προεπιλεγμένη διάρκεια διαστήματος';
$string['defaultslotduration_help'] = 'Η προεπιλεγμένη διάρκεια (σε λεπτά) για χρονοθυρίδες ραντεβού που ορίζετε';
$string['deleteallslots'] = 'Διαγραφή όλων των χρονοθυρίδων';
$string['deleteallunusedslots'] = 'Διαγραφή των αχρησιμοποίητων χρονοθυρίδων';
$string['deletecommands'] = 'Διαγραφή χρονοθυρίδων';
$string['deletedconflictingslots'] = 'Για την χρονοθυρίδα στο {$a}, οι χρονοθυρίδες που επικαλύπτονται έχουν διαγραφεί:';
$string['deletemyslots'] = 'Διαγραφή όλων των χρονοθυρίδων μου';
$string['deleteonsave'] = 'Διαγραφή αυτού του ραντεβού (όταν αποθηκεύεται η φόρμα)';
$string['deleteselection'] = 'Διαγραφή επιλεγμένων χρονοθυρίδων';
$string['deletetheseslots'] = 'Διαγραφή αυτών των χρονοθυρίδων';
$string['deleteunusedslots'] = 'Διαγραφή των αχρησιμοποίητων χρονοθυρίδων μου';
$string['department'] = 'Από πού;';
$string['disengage'] = 'Ακύρωση των ραντεβού μου';
$string['displayfrom'] = 'Εμφάνιση χρονοθυρίδας στους μαθητές από';
$string['distributetoslot'] = 'Διανομή σε όλη την ομάδα';
$string['divide'] = 'Διαίρεση σε χρονοθυρίδες;';
$string['duration'] = 'Διάρκεια';
$string['durationrange'] = 'Η διάρκεια χρονοθυρίδας πρέπει να είναι μεταξύ {$a->min} και {$a->max} λεπτών.';
$string['editbooking'] = 'Τροποποίηση κράτησης';
$string['email_applied_subject'] = '{$a->course_short}: Νέο ραντεβού';
$string['email_cancelled_subject'] = '{$a->course_short}: Το ραντεβού ακυρώθηκε ή μετακινήθηκε από έναν μαθητή';
$string['email_invite_html'] = '<p>Παρακαλούμε, επιλέξτε μια χρονοθυρίδα για ένα ραντεβού στις:</p><p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Πρόσκληση: {$a->module}';
$string['email_invitereminder_subject'] = 'Υπενθύμιση: {$a->module}';
$string['email_reminder_subject'] = '{$a->course_short}: Υπενθύμιση ραντεβού';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Το ραντεβού ακυρώθηκε από έναν διδάσκοντα';
$string['emailreminder'] = 'Αποστολή ενός μηνύματος ηλε.ταχυδρομείου';
$string['emailreminderondate'] = 'Αποστολή ενός μηνύματος ηλε.ταχυδρομείου στις';
$string['end'] = 'Τέλος';
$string['enddate'] = 'Επανάληψη χρονοθυρίδων μέχρι';
$string['event_appointmentlistviewed'] = 'Η λίστα με τα ραντεβού του χρονοπρογραμματιστή εμφανίστηκε';
$string['event_bookingadded'] = 'Η κράτηση χρονοπρογραμματιστή προστέθηκε';
$string['event_bookingformviewed'] = 'Η φόρμα κράτησης χρονοπρογραμματιστή εμφανίστηκε';
$string['event_bookingremoved'] = 'Η κράτηση χρονοπρογραμματιστή διαγράφηκε';
$string['event_slotadded'] = 'Η χρονοθυρίδα χρονοπρογραμματιστή προστέθηκε';
$string['event_slotdeleted'] = 'Η χρονοθυρίδα χρονοπρογραμματιστή διαγράφηκε';
$string['everyone'] = 'Οποιοσδήποτε';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Αποκλειστικός';
$string['exclusivity'] = 'Αποκλειστικότητα';
$string['exclusivityoverload'] = 'Η χρονοθυρίδα έχει {$a} εκχωρημένους μαθητές, περισσότερους από όσους επιτρέπονται από αυτή τη ρύθμιση.';
$string['exclusivitypositive'] = 'Ο αριθμός των μαθητών ανά χρονοθυρίδα πρέπει να είναι 1 ή μεγαλύτερος.';
$string['export'] = 'Εξαγωγή';
$string['exporthdr'] = 'Εξαγωγή χρονοθυρίδων και ραντεβού';
$string['exporttimerangeall'] = 'Μελλοντικές και περασμένες χρονοθυρίδες';
$string['exporttimerangefuture'] = 'Μόνο μελλοντικές χρονοθυρίδες';
$string['exporttimerangepast'] = 'Μόνο περασμένες χρονοθυρίδες';
$string['field-appointmentnote'] = 'Σημείωση ραντεβού (προς μαθητή)';
$string['field-attended'] = 'Παρακολουθήθηκε';
$string['field-date'] = 'Ημερομηνία';
$string['field-endtime'] = 'Ώρα λήξης';
$string['field-filecount'] = 'Αριθμός ανεβασμένων αρχείων';
$string['field-grade'] = 'Βαθμός';
$string['field-groupsmulti'] = 'Ομάδες (μερικές στήλες)';
$string['field-groupssingle'] = 'Ομάδες';
$string['field-groupssingle-label'] = 'Ομάδες (μία στήλη)';
$string['field-location'] = 'Τοποθεσία';
$string['field-maxstudents'] = 'Μέγιστος αριθμός μαθητών';
$string['field-slotnotes'] = 'Σημειώσεις χρονοθυρίδας';
$string['field-starttime'] = 'Ώρα έναρξης';
$string['field-studentemail'] = 'Διεύθυνση ηλε.ταχυδρομείου μαθητή';
$string['field-studentfirstname'] = 'Μικρό (βαπτιστικό) όνομα μαθητή';
$string['field-studentfullname'] = 'Πλήρες όνομα μαθητή';
$string['field-studentidnumber'] = 'Αναγνωριστικός αριθμός μαθητή';
$string['field-studentlastname'] = 'Επώνυμο μαθητή';
$string['field-studentnote'] = 'Μήνυμα από τον μαθητή';
$string['field-studentusername'] = 'Όνομα χρήστη μαθητή';
$string['field-teachernote'] = 'Εμπιστευτική σημείωση (μόνο διδάσκων)';
$string['fileformat'] = 'Μορφή αρχείου';
$string['finalgrade'] = 'Τελικός βαθμός';
$string['firstslotavailable'] = 'Η πρώτη χρονοθυρίδα θα ανοίξει στις: {$a}';
$string['forbidgroup'] = 'Χρονοθυρίδα ομάδας - κάντε κλικ για αλλαγή';
$string['forcewhenoverlap'] = 'Επιβολή σε περίπτωση επικάλυψης';
$string['forcewhenoverlap_link'] = 'άρθρωμα/χρονοπρογραμματιστής/διένεξη';
$string['forcourses'] = 'Επιλογή μαθητών σε μαθήματα';
$string['friday'] = 'Παρασκευή';
$string['generalconfig'] = 'Γενικές ρυθμίσεις';
$string['grade'] = 'Βαθμός';
$string['gradeingradebook'] = 'Βαθμός στο βαθμολόγιο';
$string['gradingstrategy'] = 'Στρατηγική βαθμολόγησης';
$string['group'] = 'ομάδα';
$string['groupbookings'] = 'Κρατήσεις σε ομάδες';
$string['groupbreakdown'] = 'Κατά μέγεθος ομάδας';
$string['groupscheduling'] = 'Ενεργοποίηση χρονοπρογραμματισμού ομάδων';
$string['groupsession'] = 'Σύνοδος ομάδας';
$string['groupsize'] = 'Μέγεθος ομάδας';
$string['guestscantdoanything'] = 'Οι επισκέπτες δεν μπορούν να κάνουν τίποτα εδώ.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Αγνόηση διενέξεων χρονοπρογραμματισμού';
$string['ignoreconflicts_link'] = 'άρθρωμα/χρονοπρογραμματιστής/διένεξη';
$string['includeemptyslots'] = 'Συμπερίληψη κενών χρονοθυρίδων';
$string['includeslotsfor'] = 'Συμπερίληψη χρονοθυρίδων για';
$string['incourse'] = 'στο μάθημα';
$string['introduction'] = 'Εισαγωγή';
$string['isnonexclusive'] = 'Μη-αποκλειστικά';
$string['landscape'] = 'Οριζόντια';
$string['lengthbreakdown'] = 'Κατά διάρκεια χρονοθυρίδας';
$string['limited'] = 'Με περιορισμό ({$a} ακόμη)';
$string['location'] = 'Τοποθεσία';
$string['location_help'] = 'Καθορίστε την προγραμματισμένη τοποθεσία της συνάντησης.';
$string['markasseennow'] = 'Επισήμανση ως αναγνωσμένου τώρα';
$string['maxgrade'] = 'Λάβετε τον υψηλότερο βαθμό';
$string['maxstudentlistsize'] = 'Μέγιστο μήκος λίστας μαθητών';
$string['maxstudentsperslot'] = 'Μέγιστος αριθμός μαθητών ανά θυρίδα';
$string['meangrade'] = 'Πάρτε τον μέσο βαθμό';
$string['message'] = 'Μήνυμα';
$string['messagebody'] = 'Σώμα μηνύματος';
$string['messageprovider:bookingnotification'] = 'Ειδοποίηση όταν μια κράτηση γίνεται ή ακυρώνεται';
$string['messageprovider:invitation'] = 'Πρόσκληση για κράτηση μιας χρονοθυρίδας';
$string['messageprovider:reminder'] = 'Υπενθύμιση ενός επερχόμενου ραντεβού';
$string['messagesent'] = 'Το μήνυμα στάλθηκε σε {$a} παραλήπτες';
$string['messagesubject'] = 'Θέμα';
$string['minutes'] = 'λεπτά';
$string['minutesperslot'] = 'λεπτά ανά χρονοθυρίδα';
$string['missingstudents'] = '{$a} μαθητές ακόμη πρέπει να κλείσουν ένα ραντεβού';
$string['mode'] = 'Κατάσταση λειτουργίας';
$string['modeappointments'] = 'ραντεβού';
$string['modeintro'] = 'Οι μαθητές μπορούν να κάνουν καταχώρηση';
$string['modeoneatatime'] = 'τη φορά';
$string['modeoneonly'] = 'σε αυτόν τον χρονοπρογραμματιστή';
$string['modulename'] = 'Χρονοπρογραμματιστής';
$string['modulename_link'] = 'άρθρωμα/χρονοπρογραμματιστής/εμφάνιση';
$string['modulenameplural'] = 'Χρονοπρογραμματιστές';
$string['monday'] = 'Δευτέρα';
$string['multiple'] = '(πολλαπλό)';
$string['myappointments'] = 'Τα ραντεβού μου';
$string['myself'] = 'Ο εαυτός μου';
$string['name'] = 'Όνομα χρονοπρογραμματιστή';
$string['needteachers'] = 'Δεν μπορούν να προστεθούν χρονοθυρίδες καθώς αυτό το μάθημα δεν έχει κανένα διδάσκοντα';
$string['never'] = 'Ποτέ';
$string['nfiles'] = '{$a} αρχεία';
$string['noappointments'] = 'Κανένα ραντεβού';
$string['noexistingstudents'] = 'Δεν είναι διαθέσιμος κανένας μαθητής για χρονοπρογραμματισμό';
$string['nogroups'] = 'Δεν είναι διαθέσιμη καμία ομάδα για χρονοπρογραμματισμό.';
$string['noresults'] = 'Κανένα αποτέλεσμα.';
$string['noschedulers'] = 'Δεν υπάρχει κανένας χρονοπρογραμματιστής';
$string['noslots'] = 'Δεν υπάρχει καμία χρονοθυρίδα για ραντεβού διαθέσιμη.';
$string['noslotsavailable'] = 'Δεν υπάρχει καμία χρονοθυρίδα διαθέσιμη για κράτηση για εκείνη την ώρα.';
$string['noslotsopennow'] = 'Δεν υπάρχει καμία χρονοθυρίδα ανοικτή για κράτηση αυτή τη στιγμή.';
$string['note'] = 'Βαθμός';
$string['noteacherforslot'] = 'Κανένας διδάσκοντας για τις χρονοθυρίδες';
$string['noteachershere'] = 'Κανένας διδάσκοντας διαθέσιμος';
$string['notenoughplaces'] = 'Λυπούμαστε, δεν υπάρχουν αρκετά ελεύθερα ραντεβού σε αυτή τη χρονοθυρίδα.';
$string['notesrequired'] = 'Πρέπει να δώσετε κάποιο κείμενο σε αυτό το πεδίο, πριν κάνετε κράτηση της χρονοθυρίδας.';
$string['notifications'] = 'Ειδοποιήσεις';
$string['notseen'] = 'Δεν εμφανίστηκε';
$string['now'] = 'Τώρα';
$string['occurrences'] = 'Εμφανίσεις';
$string['odsformat'] = 'ODS';
$string['on'] = 'στις';
$string['onedaybefore'] = '1 ημέρα πριν την χρονοθυρίδα';
$string['onelineperappointment'] = 'Μια γραμμή ανά ραντεβού';
$string['onelineperslot'] = 'Μια γραμμή ανά χρονοθυρίδα';
$string['oneslotadded'] = '1 χρονοθυρίδα προστέθηκε';
$string['oneslotdeleted'] = '1 χρονοθυρίδα διαγράφηκε';
$string['oneweekbefore'] = '1 εβδομάδα πριν την χρονοθυρίδα';
$string['onthemorningofappointment'] = 'Το πρωί της ημέρας του ραντεβού';
$string['options'] = 'Επιλογές';
$string['otherstudents'] = 'Άλλοι συμμετέχοντες';
$string['outlinegrade'] = 'Βαθμός: {$a}.';
$string['overall'] = 'Συνολικά';
$string['overlappings'] = 'Κάποιες άλλες χρονοθυρίδες επικαλύπτονται';
$string['pageperteacher'] = 'Μία σελίδα για κάθε {$a}';
$string['pagination'] = 'Σελιδοποίηση';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'Προσανατολισμός σελίδας PDF';
$string['pluginadministration'] = 'Διαχείριση χρονοπρογραμματιστή';
$string['pluginname'] = 'Χρονοπρογραμματιστής';
$string['portrait'] = 'Κάθετα';
$string['preview'] = 'Προεπισκόπηση';
$string['previewlimited'] = '(Η προεπισκόπηση περιορίζεται σε {$a} γραμμές.)';
$string['privacy:metadata:filepurpose'] = 'Αρχείο που χρησιμοποιείται στις σημειώσεις για την χρονοθυρίδα ή το ραντεβού';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Σημείωση από διδάσκοντα (ορατή στον μαθητή)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Μορφότυπος σημείωσης διδάσκοντος';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Εάν το ραντεβού παρακολουθήθηκε';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Βαθμός για το ραντεβού';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Ο μαθητής που έκανε κράτηση για το ραντεβού';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Σημείωση από μαθητή';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Μορφότυπος σημείωσης μαθητή';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Σημείωση από διδάσκοντα (ιδιωτικά)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Μορφότυπος ιδιωτικής σημείωσης διδάσκοντα';
$string['privacy:metadata:scheduler_slots'] = 'Αντιπροσωπεύει μια χρονοθυρίδα σε έναν χρονοπρογραμματιστή';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Τοποθεσία ραντεβού';
$string['privacy:metadata:scheduler_slots:duration'] = 'Διάρκεια της χρονοθυρίδας σε λεπτά';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Μέγιστος αριθμός μαθητών στην χρονοθυρίδα';
$string['privacy:metadata:scheduler_slots:notes'] = 'Σημειώσεις για την χρονοθυρίδα';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Μορφότυπος των σημειώσεων';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Ώρα έναρξης της χρονοθυρίδας';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Ο διδάσκοντας που συσχετίζεται με αυτή τη χρονοθυρίδα';
$string['purgeunusedslots'] = 'Εκκαθάριση αχρησιμοποίητων χρονοθυρίδων στο παρελθόν';
$string['recipients'] = 'Παραλήπτης';
$string['reminder'] = 'Υπενθύμιση';
$string['resetappointments'] = 'Διαγραφή ραντεβού και βαθμών';
$string['resetslots'] = 'Διαγραφή χρονοθυρίδων χρονοπρογραμματιστή';
$string['return'] = 'Επιστροφή στο μάθημα';
$string['revoke'] = 'Ανάκληση του ραντεβού';
$string['saturday'] = 'Σάββατο';
$string['save'] = 'Αποθήκευση';
$string['savechoice'] = 'Αποθήκευση της επιλογής μου';
$string['schedule'] = 'Χρονοπρογραμματισμός';
$string['scheduleappointment'] = 'Χρονοπρογραμματισμός ραντεβού για {$a}';
$string['schedulecancelled'] = '{$a} : Το ραντεβού σας ακυρώθηκε ή μετακινήθηκε';
$string['schedulegroups'] = 'Χρονοπρογραμματισμός κατά ομάδα';
$string['scheduleinnew'] = 'Χρονοπρογραμματισμός σε μια νέα χρονοθυρίδα';
$string['scheduleinslot'] = 'Χρονοπρογραμματισμός σε χρονοθυρίδα';
$string['scheduler'] = 'Χρονοπρογραμματιστής';
$string['scheduler:addinstance'] = 'Προσθήκη ενός νέου χρονοπρογραμματιστή';
$string['scheduler:appoint'] = 'Κράτηση χρονοθυρίδων';
$string['scheduler:attend'] = 'Παρακολούθηση μαθητών';
$string['scheduler:canscheduletootherteachers'] = 'Χρονοπρογραμματισμός ραντεβού για άλλα μέλη του προσωπικού';
$string['scheduler:disengage'] = 'Αυτή η δυνατότητα είναι παρωχημένη και δεν κάνει τίποτα';
$string['scheduler:editallgrades'] = 'Τροποποίηση βαθμών σε όλα τα ραντεβού.';
$string['scheduler:editallnotes'] = 'Τροποποίηση σημειώσεων ραντεβού σε όλα τα άλλα ραντεβού.';
$string['scheduler:manage'] = 'Διαχείριση των χρονοθυρίδων και των ραντεβού';
$string['scheduler:manageallappointments'] = 'Διαχείριση όλων των δεδομένων χρονοπρογραμματιστή';
$string['schedulestudents'] = 'Χρονοπρογραμματισμός ανά μαθητή';
$string['scopemenu'] = 'Εμφάνιση χρονοθυρίδων σε: {$a}';
$string['scopemenuself'] = 'Εμφάνιση των χρονοθυρίδων μου σε: {$a}';
$string['search:activity'] = 'Χρονοπρογραμματιστής - πληροφορίες δραστηριότητας';
$string['seen'] = 'Εμφανίστηκε';
$string['sendmessage'] = 'Αποστολή μηνύματος';
$string['sepcolon'] = 'Άνω κάτω τελεία';
$string['sepcomma'] = 'Κόμμα';
$string['sepsemicolon'] = 'Ερωτηματικό';
$string['septab'] = 'Στηλοθέτης';
$string['showemailplain'] = 'Εμφάνιση διευθύνσεων ηλε.ταχυδρομείου σε απλό κείμενο';
$string['showparticipants'] = 'Εμφάνιση συμμετεχόντων';
$string['slot'] = 'Χρονοθυρίδα';
$string['slot_is_just_in_use'] = 'Λυπούμαστε! Το ραντεβού μόλις επιλέχθηκε από κάποιον άλλο μαθητή. Παρακαλούμε, προσπαθήστε ξανά.';
$string['slotdatetime'] = '{$a->shortdatetime} για {$a->duration} λεπτά';
$string['slotdatetimelabel'] = 'Ημερομηνία και ώρα';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} στις {$a->startdate} από {$a->starttime} έως {$a->endtime} στη θέση {$a->location} με τον/την {$a->facilitator}.';
$string['slots'] = 'Χρονοθυρίδες';
$string['slotsadded'] = '{$a} χρονοθυρίδες προστέθηκαν';
$string['slotsdeleted'] = '{$a} χρονοθυρίδες διαγράφηκαν';
$string['slottype'] = 'Τύπος χρονοθυρίδας';
$string['slotupdated'] = '1 χρονοθυρίδα ενημερώθηκε';
$string['staffbreakdown'] = 'Από τον/την {$a}';
$string['staffrolename'] = 'Όνομα ρόλου του διδάσκοντα';
$string['start'] = 'Έναρξη';
$string['statistics'] = 'Στατιστικά';
$string['student'] = 'Μαθητής';
$string['studentbreakdown'] = 'Από μαθητή';
$string['studentcomments'] = 'Μήνυμα μαθητή';
$string['studentdetails'] = 'Λεπτομέρειες μαθητή';
$string['studentfiles'] = 'Ανεβασμένα αρχεία';
$string['studentmultiselect'] = 'Κάθε μαθητής μπορεί να επιλεγεί μόνο μια φορά σε αυτή τη χρονοθυρίδα';
$string['studentnote'] = 'Μήνυμα από μαθητή';
$string['students'] = 'Μαθητές';
$string['sunday'] = 'Κυριακή';
$string['tab-otherappointments'] = 'Όλα τα ραντεβού αυτού του μαθητή';
$string['tab-otherstudents'] = 'Μαθητές σε αυτή τη χρονοθυρίδα';
$string['tab-thisappointment'] = 'Αυτό το ραντεβού';
$string['teacher'] = 'Διδάσκων';
$string['teachernote'] = 'Εμπιστευτικές σημειώσεις (ορατές μόνο σε διδάσκοντα)';
$string['teachersmenu'] = 'Εμφάνιση χρονοθυρίδων για: {$a}';
$string['thiscourse'] = 'αυτό το μάθημα';
$string['thisscheduler'] = 'αυτόν τον χρονοπρογραμματιστή';
$string['thissite'] = 'ολόκληρο τον ιστότοπο';
$string['thursday'] = 'Πέμπτη';
$string['timefrom'] = 'Από:';
$string['timerange'] = 'Χρονικό εύρος';
$string['timeto'] = 'Έως:';
$string['totalgrade'] = 'Συνολικός βαθμός';
$string['tuesday'] = 'Τρίτη';
$string['unlimited'] = 'Απεριόριστος';
$string['upcomingslots'] = 'Επερχόμενες χρονοθυρίδες';
$string['updategrades'] = 'Ενημέρωση βαθμών';
$string['updatesingleslot'] = '';
$string['uploadmaxfiles'] = 'Μέγιστος αριθμός αρχείων για ανέβασμα';
$string['uploadmaxfilesglobal'] = 'Μέγιστος αριθμός αρχείων για ανέβασμα';
$string['uploadmaxsize'] = 'Μέγιστο μέγεθος αρχείου';
$string['uploadmaxsize_help'] = 'Μέγιστο μέγεθος αρχείου για ανέβασμα από μαθητές. Αυτό το όριο εφαρμόζεται ανά αρχείο.';
$string['uploadrequired'] = 'Πρέπει να ανεβάσετε αρχεία εδώ πριν κάνετε κράτηση για την χρονοθυρίδα.';
$string['uploadstudentfiles'] = 'Ανέβασμα αρχείων';
$string['usebookingform'] = 'Χρήση φόρμας κράτησης';
$string['usebookingform_link'] = 'άρθρωμα/χρονοπρογραμματιστής/φόρμακράτησης';
$string['usecaptcha'] = 'Χρήση CAPTCHA για νέες κρατήσεις';
$string['usenotes'] = 'Χρήση σημειώσεων για ραντεβού';
$string['usenotesboth'] = 'Και οι δύο τύποι σημειώσεων';
$string['usenotesnone'] = 'κανένας';
$string['usenotesstudent'] = 'Σημείωση ραντεβού, ορατή σε διδάσκοντα και μαθητή';
$string['usenotesteacher'] = 'Εμπιστευτική σημείωση, ορατή σε διδάσκοντες μόνο';
$string['usestudentnotes'] = 'Αφήστε τους μαθητές να δώσουν ένα μήνυμα';
$string['viewbooking'] = 'Δείτε λεπτομέρειες';
$string['wednesday'] = 'Τετάρτη';
$string['welcomenewteacher'] = 'Παρακαλούμε, κάντε κλικ στο πλήκτρο παρακάτω για προσθήκη χρονοθυρίδων ραντεβού.';
$string['what'] = 'Τί;';
$string['whathappened'] = 'Τί συνέβη;';
$string['whatresulted'] = 'Αποτελέσματα;';
$string['when'] = 'Πότε;';
$string['where'] = 'Πού;';
$string['who'] = 'Με ποιόν;';
$string['whosthere'] = 'Ποιός είναι εκεί;';
$string['xdaysbefore'] = '{$a} ημέρες πριν την χρονοθυρίδα';
$string['xweeksbefore'] = '{$a} εβδομάδες πριν τη χρονοθυρίδα';
$string['yesallgroups'] = 'Ναι, για όλες τις ομάδες';
$string['yesingrouping'] = 'Ναι, σε ομαδοποίηση {$a}';
$string['yesoptional'] = 'Ναι, προαιρετικά για μαθητή';
$string['yesrequired'] = 'Ναι, ο μαθητής πρέπει να δώσει ένα μήνυμα';
$string['yourappointmentnote'] = 'Σχόλια για σας μόνο';
$string['yourslotnotes'] = 'Σχόλια για την συνάντηση';
$string['yourstudentnote'] = 'Το μήνυμά σας';
$string['yourtotalgrade'] = 'Ο συνολικός βαθμός σε αυτή την δραστηριότητα είναι <strong>{$a}</strong>.';
