<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_learning_analytics', language 'pt', version '3.10'.
 *
 * @package     local_learning_analytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['dataprivacy_threshold_description'] = 'Este valor determina quantos "pontos de dados" um conjunto de dados precisa conter para que os dados sejam exibidos.';
$string['general_settings'] = 'Configurações gerais';
$string['help_faq'] = 'Perguntas mais frequentes (FAQ)';
$string['help_faq_data_storage_answer'] = 'Os dados apresentados são provenientes de duas fontes de dados.
Ambas as fontes são armazenadas na base de dados interna do Moodle.
A primeira fonte de dados é a base de dados interna do Moodle, tais como o número de alunos da disciplina (caixa à esquerda no painel).
Alguns destes conjuntos de dados podem ser visualizados noutras páginas do Moodle e são apenas visualizados de forma diferente nestas páginas.
A segunda fonte de dados são os dados recolhidos especificamente para apresentação na página \'Estatísticas de uso\'.
Todos os dados recolhidos para este fim são armazenados anonimamente e não podem ser monitorizados até aos utilizadores individuais.
Especificamente, os seguintes dados são armazenados com cada solicitação no Moodle:';
$string['help_faq_data_storage_answer_list'] = 'Tipo de ação (por exemplo, "Recurso visualizado")
Tempo (ao segundo)
Disciplina correspondente em que a ação ocorreu
Contexto correspondente (por exemplo: o recurso que foi visualizado)
Sistema operativo e navegador (por exemplo: "Windows 10" e "Firefox"). Detalhes do navegador ou versões do sistema operativo não são armazenados';
$string['help_faq_data_storage_question'] = 'Que dados são armazenados e exibidos pelo serviço?';
$string['help_faq_developer_answer'] = 'O serviço Análise da Aprendizagem é desenvolvido pelo Center for Teaching and Learning Services da RWTH Aachen University.
O desenvolvimento é Open Source e, por isso, pode verificar os algoritmos usados. Nas páginas a seguir pode aceder a mais informações:';
$string['help_faq_developer_question'] = 'Quem desenvolve o serviço e onde posso obter mais informações?';
$string['help_faq_personal_data_answer'] = 'Por motivos de privacidade dos dados, o serviço Análise da Aprendizagem não guarda dados personalizados. A maioria das estatísticas exibidas (por exemplo: as atividades mais usadas) contém apenas informações sobre a frequência com que um recurso foi acedido, mas não por quantos participantes.
Uma exceção a isto são as estatísticas sobre participantes e testes/trabalhos, que também exibem dados internos do Moodle.';
$string['help_faq_personal_data_question'] = 'Porque é que não é exibida qualquer estatística personalizada, como por exemplo: cliques por utilizador?';
$string['help_faq_privacy_threshold_answer'] = 'Por motivos de privacidade dos dados, os dados agregados são exibidos apenas se pelo menos {$a} pontos de dados estiverem presentes.';
$string['help_faq_privacy_threshold_question'] = 'Porque é que alguns valores são mostrados como "< {$a}"?';
$string['help_faq_visibility_answer'] = 'Para garantir a máxima transparência, os dados exibidos podem ser visualizados pelos proprietários da disciplina, bem como pelos participantes da disciplina.';
$string['help_faq_visibility_question'] = 'Quem pode acessar às estatísticas de uso?';
$string['help_faq_week_start_answer'] = 'A visualização no painel depende da configuração "Data de início" nas configurações da disciplina. Se a data ali especificada não corresponder ao início real, a exibição no painel também não estará correta.
O gestor desta disciplina pode corrigir a data nas configurações da disciplina (Geral / Data de início).';
$string['help_faq_week_start_question'] = 'Porque é que a primeira semana no gráfico do painel não corresponde ao início real de leitura?';
$string['help_take_tour'] = 'Demonstração ao utilizador';
$string['help_text'] = 'A página "Estatísticas de uso" do serviço Análise da Aprendizagem mostra as principais métricas da sua disciplina.

As estatísticas apresentadas são ao vivo e apresentam dados que foram recolhidos pelo serviço, bem como dados da própria disciplina Moodle. Todos os dados usados pelo serviço Análise da Aprendizagem são recolhidos de forma totalmente anónima e não podem ser monitorizados até aos utilizadores.';
$string['help_title'] = 'Ajuda';
$string['hits'] = 'Acessos';
$string['learners'] = 'Alunos';
$string['learning_analytics'] = 'Análise da Aprendizagem';
$string['navigation_position_beforekey_description'] = 'Permite especificar onde é adicionada na navegação da disciplina a hiperligação para a página. Por predefinição, a hiperligação é adicionada antes do primeiro nó de "secção". Valor de exemplo: <code>notas</code> a ser mostrado antes da hiperligação para as notas. Pode encontrar a chave de um nó na navegação usando as ferramentas do programador. Clique com o botão direito numa hiperligação na navegação, clique depois em <em>Inspecionar</em> e verifique o atributo <code>data-key</code> do elemento <code>a</code> correspondente.';
$string['pluginname'] = 'Análise da Aprendizagem';
$string['privacy:metadata'] = 'Este módulo não armazena quaisquer dados pessoais';
$string['sessions'] = 'Sessões';
$string['setting_course_ids_description'] = 'Use esta opção quando selecionar a segunda opção acima para decidir em quais disciplinas a interface do utilizador deve ser ativada.';
$string['setting_dashboard_boxes'] = 'Determina que caixas são exibidas no painel, em que ordem e o tamanho das caixas. A especificação está no formato <code>reportname:width</code>, separada por vírgulas. Uma linha tem uma largura máxima de 12, após a qual é quebrada. Por exemplo: <code>alunos:8, atividades:4</code> exibe duas caixas no painel, onde a primeira é muito mais larga do que a segunda. Na maioria dos casos, o valor só precisa ser alterado se outros sub-módulos estiverem instalados.';
$string['setting_status_course_customfield'] = 'Adicionar uma opção às configurações da disciplina para que os professores possam ativá-la';
$string['setting_status_description'] = 'Este valor define se a interface do utilizador deve ser ativada e se deve ser mostrada, ou não, uma hiperligação na navegação. Por predefinição, a hiperligação e a página ficam visíveis se o registo estiver ativado para a disciplina. Pode usar esta opção se pretender ativar o registo em todas disciplinas, mas só pretender a interface do utilizador em disciplinas específicas.';
$string['setting_status_option_disable'] = 'Ocultar a hiperligação de navegação e desativar a página para todas as disciplinas';
$string['setting_status_option_show_always'] = 'Mostrar a hiperligação de navegação para todas as disciplinas, mesmo que o registo esteja desativado para a disciplina (ative apenas se já registou dados anteriormente)';
$string['setting_status_option_show_if_enabled'] = 'Mostrar a hiperligação de navegação se o registo estiver ativado para a disciplina';
$string['show_full_list'] = 'Expandir lista';
$string['subplugintype_lalog'] = 'Registo A.A.';
$string['subplugintype_lalog_plural'] = 'Registos A.A.';
$string['subplugintype_lareport'] = 'Relatório A.A.';
$string['subplugintype_lareport_plural'] = 'Relatórios A.A.';
$string['tour_activities'] = 'A última visualização mostra as três atividades mais utilizadas nos últimos 7 dias.

Ao clicar na hiperligação, pode visualizar os detalhes das atividades da disciplina.';
$string['tour_box_hits'] = 'Este indicador mostra o número de ações nos últimos 7 dias. Por baixo do número pode ver as alterações dos 7 dias anteriores a estes.

Ao clicar na hiperligação abre um mapa, que mostra o número de ações ao longo de todo o semestre.';
$string['tour_box_learners'] = 'Este indicador mostra o número total de participantes. Por baixo do número é mostrada a alteração em relação à semana anterior.';
$string['tour_box_quiz_assign'] = 'Mostra o número de tentativas de testes e submissões de trabalhos nos últimos 7 dias. Abaixo, é mostrada novamente a alteração dos 7 dias anteriores.

Ao clicar na hiperligação, pode ver detalhes sobre os testes e trabalhos da disciplina.';
$string['tour_dashboard_boxes'] = 'Na área inferior, são exibidos informações importantes da disciplina.

Além disso, cada caixa contém uma hiperligação através da qual terá acesso a mais informações disponíveis.';
$string['tour_dashboard_graph'] = 'O gráfico mostra o número de todas as ações na respetiva semana.

Se a disciplina estiver a decorrer, o início da semana atual é marcado por uma linha pontilhada. Os números da semana não são exibidos.';
$string['tour_more_information'] = 'A demonstração ao utilizador está concluída. Esperamos ter-lhe dado uma visão global dos recursos.

Mais respostas às perguntas mais frequentes podem ser encontradas na página de ajuda.';
$string['tour_title'] = 'Análise da Aprendizagem';
