<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'pt', version '3.10'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Atividades';
$string['addcategory'] = 'Adicionar categoria';
$string['addcategoryerror'] = 'Não foi possível adicionar a categoria.';
$string['addexceptionerror'] = 'Ocorreu um erro ao adicionar uma exceção para userid:gradeitem';
$string['addfeedback'] = 'Adicionar comentário';
$string['addgradeletter'] = 'Adicionar uma nota alfabética';
$string['addidnumbers'] = 'Adicionar números de ID';
$string['additem'] = 'Adicionar item de avaliação';
$string['additionalfeedback'] = 'Feedback adicional';
$string['addoutcome'] = 'Adicionar um Resultado da aprendizagem';
$string['addoutcomeitem'] = 'Adicionar item do Resultado da aprendizagem';
$string['addscale'] = 'Adicionar escala';
$string['adjustedweight'] = 'Peso ajustado';
$string['aggregateextracreditmean'] = 'Média (com créditos extra)';
$string['aggregatemax'] = 'Nota mais alta';
$string['aggregatemean'] = 'Média';
$string['aggregatemedian'] = 'Mediana';
$string['aggregatemin'] = 'Nota mais baixa';
$string['aggregatemode'] = 'Moda';
$string['aggregatenotonlygraded'] = 'Incluir notas vazias';
$string['aggregateonlygraded'] = 'Excluir notas vazias';
$string['aggregateonlygraded_help'] = 'Uma nota vazia é uma nota em falta na pauta. Pode ser um trabalho que ainda não foi avaliado ou um teste que ainda não teve tentativas, etc.

Esta opção determina se as notas vazias não são incluídas nos cálculos ou se são consideradas pela nota mínima daquele item de avaliação. Por exemplo se o aluno não tem nota num trabalho cuja nota varia entre 0 e 100, então a nota considerada será 0.';
$string['aggregateoutcomes'] = 'Incluir resultados da aprendizagem na fórmula de cálculo';
$string['aggregateoutcomes_help'] = 'Se ativar esta opção, os resultados da aprendizagem são incluídos no cálculo. Isto pode originar resultados imprevisíveis no total da categoria.';
$string['aggregatesonly'] = 'Mudar para notas das categorias apenas';
$string['aggregatesubcatsupgradedgrades'] = 'Nota: A configuração de agregação "Agregar incluindo subcategorias" foi removida na sequência de uma atualização do site. Uma vez que esta configuração estava a ser usada nesta disciplina, recomenda-se que verifique esta alteração na pauta.';
$string['aggregatesum'] = 'Natural';
$string['aggregateweightedmean'] = 'Média ponderada';
$string['aggregateweightedmean2'] = 'Média ponderada simples';
$string['aggregation'] = 'Cálculo da nota';
$string['aggregation_help'] = 'A forma de cálculo determina como é calculada a nota total da categoria, podendo ser:

* Média - A soma de todas as notas, dividida pelo número total de notas
* Mediana - A nota do meio se as notas estiverem ordenadas
* Nota mais baixa
* Nota mais alta
* Moda - A nota que ocorre mais vezes
* Natural - A soma de todas as notas ponderadas pela respetiva nota máxima ou através de ponderação personalizada';
$string['aggregation_link'] = 'nota/cálculo';
$string['aggregationcoef'] = 'Peso';
$string['aggregationcoefextra'] = 'Crédito extra';
$string['aggregationcoefextra_help'] = 'Se a forma de cálculo é a Soma ou a Média ponderada simples e a caixa de seleção do Crédito extra está assinalada, o item da nota máxima não é adicionado à nota máxima da categoria, resultando na possibilidade de atingir a nota máxima (ou notas acima do máximo se ativo pelo administrador) na categoria sem ter a nota máxima em todos os itens.

Se a forma de cálculo for a \'Média (com créditos extra)\' e o crédito extra está configurado para um valor superior a 0, este é o fator pelo qual a nota é multiplicada antes de a adicionar ao total após o cálculo da média.';
$string['aggregationcoefextra_link'] = 'nota/cálculo';
$string['aggregationcoefextrasum'] = 'Crédito extra';
$string['aggregationcoefextrasum_help'] = 'Se a caixa de seleção do Crédito extra estiver selecionada, o item da nota máxima não é adicionado à nota máxima da categoria, resultando na possibilidade de atingir a nota máxima (ou notas acima do máximo se ativo pelo administrador) na categoria sem ter a nota máxima em todos os os itens.';
$string['aggregationcoefextrasum_link'] = 'nota/cálculo';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Peso do Crédito extra';
$string['aggregationcoefextraweight_help'] = 'Se o crédito extra está configurado para um valor superior a 0, a nota comporta-se como crédito extra no cálculo. O número é o fator pelo qual a nota é multiplicada antes de adicioná-la ao total após o cálculo da média.';
$string['aggregationcoefextraweight_link'] = 'nota/cálculo';
$string['aggregationcoefweight'] = 'Peso do item';
$string['aggregationcoefweight_help'] = 'O peso do item é usado no cálculo da nota da categoria para ajustar a importância do item comparativamente aos outros itens de avaliação na mesma categoria.';
$string['aggregationcoefweight_link'] = 'nota/cálculo';
$string['aggregationhintdropped'] = '(Excluídas)';
$string['aggregationhintexcluded'] = '(Excluídas)';
$string['aggregationhintextra'] = '(Crédito extra)';
$string['aggregationhintnovalue'] = '(não definido)';
$string['aggregationofa'] = 'Agregação de {$a}';
$string['aggregationposition'] = 'Posição da coluna total';
$string['aggregationposition_help'] = 'Esta opção determina se as colunas total da categoria e da disciplina são exibidas em primeiro ou último lugar na pauta.';
$string['aggregationsvisible'] = 'Tipos de cálculo disponíveis';
$string['aggregationsvisiblehelp'] = 'Escolha os tipos de cálculo que estarão disponíveis para uso na pauta. Prima a tecla CTRL para selecionar múltiplos itens.';
$string['allgrades'] = 'Todas as notas por categoria';
$string['allstudents'] = 'Todos os alunos';
$string['allusers'] = 'Todos os utilizadores';
$string['autosort'] = 'Ordenar de forma automática';
$string['availableidnumbers'] = 'Números de ID disponíveis';
$string['average'] = 'Média';
$string['averagesdecimalpoints'] = 'Casas decimais nas médias das colunas';
$string['averagesdecimalpoints_help'] = 'Esta opção determina o número de casas decimais a mostrar nas médias das notas ou se as casas decimais são herdadas da categoria ou item de avaliação.';
$string['averagesdisplaytype'] = 'Formato das médias das colunas';
$string['averagesdisplaytype_help'] = 'Esta opção determina se a média é exibida como nota real, percentagem ou nota alfabética, ou se é herdado o formato da categoria ou item de avaliação.';
$string['backupwithoutgradebook'] = 'A cópia de segurança não contém as configurações da pauta.';
$string['badgrade'] = 'A nota fornecida é inválida';
$string['badlyformattedscale'] = 'Introduza uma lista de valores separada por vírgulas (tem de inserir no mínimo dois valores)';
$string['baduser'] = 'O utilizador fornecido não é válido';
$string['bonuspoints'] = 'Pontos de bónus';
$string['bulkcheckboxes'] = 'Caixas de seleção em massa';
$string['calculatedgrade'] = 'Nota calculada';
$string['calculation'] = 'Cálculo da nota';
$string['calculation_help'] = 'O cálculo da nota é a fórmula usada para determinar as notas. A fórmula deve começar com um sinal de igualdade (=) e usar operadores comuns matemáticos, tais como max, min e sum. Pode ainda, se desejar, incluir outros itens de avaliação inserindo os respetivos ID entre parêntesis retos.';
$string['calculation_link'] = 'nota/cálculo';
$string['calculationadd'] = 'Adicionar cálculo';
$string['calculationedit'] = 'Editar cálculo';
$string['calculationsaved'] = 'Cálculo guardado';
$string['calculationview'] = 'Ver cálculo';
$string['cannotaccessgroup'] = 'Lamentamos mas não pode aceder às avaliações do grupo selecionado.';
$string['categories'] = 'Categorias';
$string['category'] = 'Categoria';
$string['categoryedit'] = 'Editar categoria';
$string['categoryname'] = 'Nome da categoria';
$string['categorytotal'] = 'Total da Categoria';
$string['categorytotalfull'] = 'Total de {$a->category}';
$string['categorytotalname'] = 'Nome do total da categoria';
$string['changedefaults'] = 'Alterar predefinições';
$string['changereportdefaults'] = 'Alterar predefinições do relatório';
$string['chooseaction'] = 'Selecione uma ação...';
$string['choosecategory'] = 'Selecionar categoria';
$string['collapsecriterion'] = 'Contrair critério';
$string['combo'] = 'Separadores e lista pendente';
$string['compact'] = 'Contraído';
$string['componentcontrolsvisibility'] = 'A visibilidade desta nota é controlada nas configurações da respetiva atividade.';
$string['contract'] = 'Categoria de contrato';
$string['contributiontocoursetotal'] = 'Contribuição para o total da disciplina';
$string['controls'] = 'Controlos';
$string['courseavg'] = 'Média da disciplina';
$string['coursegradecategory'] = 'Categoria da pauta';
$string['coursegradedisplaytype'] = 'Formato das notas da disciplina';
$string['coursegradedisplayupdated'] = 'O formato das notas da disciplina foi atualizado.';
$string['coursegradesettings'] = 'Configurações da pauta';
$string['coursename'] = 'Nome da disciplina';
$string['coursescales'] = 'Escalas da disciplina';
$string['coursesettings'] = 'Definições da disciplina';
$string['coursesettingsexplanation'] = 'As configurações da nota determinam como a pauta será exibida para todos os participantes na disciplina.';
$string['coursesiamtaking'] = 'Disciplinas em que estou inscrito';
$string['coursesiamteaching'] = 'Disciplinas em que sou professor';
$string['coursetotal'] = 'Total da disciplina';
$string['createcategory'] = 'Criar categoria';
$string['createcategoryerror'] = 'Não foi possível criar a nova categoria';
$string['creatinggradebooksettings'] = 'A criar configurações da pauta';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Tipo de cálculo ascendente';
$string['curveto'] = 'Calcular sobre';
$string['decimalpoints'] = 'Casas decimais';
$string['decimalpoints_help'] = 'Esta opção determina o número de casas decimais a mostrar para cada nota. Não tem nenhum efeito sobre os cálculos das notas, que são efetuados com uma precisão de cinco casas decimais.';
$string['default'] = 'Predefinido';
$string['defaultprev'] = 'Predefinido ({$a})';
$string['deletecategory'] = 'Apagar categoria';
$string['disablegradehistory'] = 'Desativar histórico das notas';
$string['disablegradehistory_help'] = 'Desativar registo do histórico de alterações nas tabelas relacionadas com a pauta. Esta ação pode tornar o servidor mais rápido e economizar espaço na base de dados.';
$string['displaylettergrade'] = 'Mostrar avaliações com notas alfabéticas';
$string['displaypercent'] = 'Mostrar percentagens';
$string['displaypoints'] = 'Mostrar pontos';
$string['displayweighted'] = 'Mostrar notas ponderadas';
$string['dropdown'] = 'Lista pendente';
$string['droplow'] = 'Ignorar notas mais baixas';
$string['droplow_help'] = 'Esta opção permite que um determinado número de notas mais baixas sejam excluídas do cálculo.';
$string['droplowestvalue'] = 'Definir valor da(s) nota(s) mais baixa(s) a ignorar';
$string['droplowestvalues'] = 'Ignorar os {$a} valores mais baixos';
$string['dropped'] = 'Ignorada(s)';
$string['dropxlowest'] = 'Ignorar as X mais baixa(s)';
$string['dropxlowestwarning'] = 'Nota: Se utilizar a opção \'Ignorar as X mais baixas\', a avaliação será calculada assumindo que todos os itens de uma categoria têm o mesmo valor pontual. Se os valores forem diferentes, os resultados serão imprevisíveis';
$string['duplicatedgradeitem'] = '{$a} (cópia)';
$string['duplicatescale'] = 'Duplicar escala';
$string['edit'] = 'Editar';
$string['editcalculation'] = 'Editar cálculo';
$string['editcalculationverbose'] = 'Editar cálculo de {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Editar feedback';
$string['editgrade'] = 'Editar nota';
$string['editgradeletters'] = 'Editar notas alfabéticas';
$string['editoutcome'] = 'Editar resultado da aprendizagem';
$string['editoutcomes'] = 'Editar resultados da aprendizagem';
$string['editscale'] = 'Editar escalas';
$string['edittree'] = 'Configuração';
$string['editverbose'] = 'Editar {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Ativar AJAX';
$string['enableajax_help'] = 'Ativar o AJAX na pauta simplifica e acelera as operações comuns. Isto também depende da ativação do JavaScript no navegador do utilizador.';
$string['enableoutcomes'] = 'Ativar a utilização de resultados da aprendizagem';
$string['enableoutcomes_help'] = 'Se ativar esta opção, os itens de avaliação podem ser avaliados com uma ou mais escalas associadas a competências.';
$string['encoding'] = 'Codificação';
$string['encoding_help'] = 'Selecione o tipo de codificação de caracteres utilizado para os dados. (A codificação padrão é a UTF-8.) Caso selecione por engano o tipo de codificação errado, irá aperceber-se do erro assim que for feita a pré-visualização dos dados para a importação.';
$string['errorcalculationbroken'] = 'Provavelmente trata-se de uma referência circular ou de uma fórmula de cálculo quebrada';
$string['errorcalculationnoequal'] = 'A fórmula tem de começar com um sinal de igual (=1+2)';
$string['errorcalculationunknown'] = 'Fórmula inválida';
$string['errorgradevaluenonnumeric'] = 'Recebido valor não numérico para avaliações altas ou baixas para';
$string['errornocalculationallowed'] = 'Não são permitidos cálculos para este item';
$string['errornocategorisedid'] = 'Não foi possível obter um ID não categorizado!';
$string['errornocourse'] = 'Não foi possível obter informação da disciplina';
$string['errorreprintheadersnonnumeric'] = 'Recebido valor não numérico para a reimpressão de cabeçalhos';
$string['errorsavegrade'] = 'Não foi possível guardar a nota.';
$string['errorsettinggrade'] = 'Erro ao guardar a nota de "{$a->itemname}" para o utilizador {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Ocorreu um erro ao atualizar a opção "Não incluir notas vazias" nas notas da categoria com o ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Ocorreu um erro ao atualizar a opção "Incluir resultados da aprendizagem na fórmula de cálculo" da nota da categoria com o ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Ocorreu um erro ao atualizar o tipo de cálculo na categoria com o ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Ocorreu um erro ao atualizar o peso do item de avaliação com o ID {$a->id}';
$string['eventgradedeleted'] = 'Nota eliminada';
$string['eventgradeitemcreated'] = 'Item de avaliação criado';
$string['eventgradeitemdeleted'] = 'Item da nota apagado';
$string['eventgradeitemupdated'] = 'Item de avaliação atualizado';
$string['eventgradelettercreated'] = 'Nota alfabética criada';
$string['eventgradeletterdeleted'] = 'Nota alfabética apagada';
$string['eventgradeletterupdated'] = 'Nota alfabética alterada';
$string['eventgradeviewed'] = 'As notas foram visualizadas na pauta';
$string['eventscalecreated'] = 'Escala criada';
$string['eventscaledeleted'] = 'Escala apagada';
$string['eventscaleupdated'] = 'Escala atualizada';
$string['eventusergraded'] = 'Utilizador avaliado';
$string['excluded'] = 'Excluir nota';
$string['excluded_help'] = 'Se selecionar esta opção, a nota não será incluída em nenhum cálculo.';
$string['expand'] = 'Expandir categoria';
$string['expandcriterion'] = 'Expandir critério';
$string['export'] = 'Exportar';
$string['exportalloutcomes'] = 'Exportar todos os resultados da aprendizagem';
$string['exportfeedback'] = 'Incluir comentários na exportação';
$string['exportfeedback_desc'] = 'Esta configuração pode ser alterada durante a exportação.';
$string['exportformatoptions'] = 'Opções de formato de exportação';
$string['exportonlyactive'] = 'Excluir utilizadores suspensos';
$string['exportonlyactive_help'] = 'Incluir na exportação apenas alunos cuja inscrição está ativa e que não tenha sido suspensa';
$string['exportplugins'] = 'Módulos de exportação';
$string['exportsettings'] = 'Definições de exportação';
$string['exportto'] = 'Exportar para';
$string['externalurl'] = 'URL externo';
$string['externalurl_desc'] = 'Caso esteja a ser utilizada uma pauta externa, o URL deve ser indicado aqui.';
$string['extracreditvalue'] = 'Valor do crédito extra {$a}';
$string['extracreditwarning'] = 'Nota: Atribuir crédito extra a todos os itens de uma categoria fará com que estes sejam removidos do cálculo da nota total, uma vez que não haverá um total de pontos';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Esta caixa permite adicionar qualquer comentário sobre a nota';
$string['feedbackadd'] = 'Adicionar feedback';
$string['feedbackedit'] = 'Editar feedback';
$string['feedbackfiles'] = 'Ficheiros de feedback';
$string['feedbackforgradeitems'] = 'Comentário para {$a}';
$string['feedbackhistoryfiles'] = 'Ficheiros de histórico do feedback';
$string['feedbacks'] = 'Comentários';
$string['feedbacksaved'] = 'Feedback guardado';
$string['feedbackview'] = 'Ver feedback';
$string['finalgrade'] = 'Nota final';
$string['finalgrade_help'] = 'Se a caixa de seleção Ajustada for ativada, pode inserir ou alterar ou alterar a nota.';
$string['fixedstudents'] = 'Fixar coluna dos alunos';
$string['fixedstudents_help'] = 'Permite fixar a coluna com o nome dos alunos, de modo a que, quando se realiza um scroll horizontal na pauta, o nome do aluno continue visível.';
$string['forceimport'] = 'Forçar importação';
$string['forceimport_help'] = 'Forçar importação de notas mesmo que as notas tenham sido atualizadas depois do ficheiro importado ter sido exportado';
$string['forceoff'] = 'Forçar: desligado';
$string['forceon'] = 'Forçar: ligado';
$string['forelementtypes'] = 'para o(s) {$a} selecionado(s)';
$string['forstudents'] = 'Para alunos';
$string['full'] = 'Completo';
$string['fullmode'] = 'Mudar para vista completa';
$string['generalsettings'] = 'Definições gerais';
$string['grade'] = 'Nota';
$string['grade_help'] = 'Nota a atribuir ao aluno pelo seu trabalho.';
$string['gradeadministration'] = 'Administração da pauta';
$string['gradealreadyupdated'] = '{$a} notas não foram importadas porque as notas no ficheiro de importação são mais antigas do que no relatório do avaliador. Para prosseguir com a importação de notas, use a opção de forçar importação.';
$string['gradeanalysis'] = 'Análise das notas';
$string['gradebook'] = 'Pauta';
$string['gradebookcalculationsfixbutton'] = 'Aceitar as alterações nas notas e resolver erros de cálculo';
$string['gradebookcalculationsuptodate'] = 'Os cálculos da pauta encontram-se atualizados. Poderá necessitar de atualizar/recarregar esta página para verificar as alterações efetuadas.';
$string['gradebookcalculationswarning'] = 'Nota: Foram encontrados alguns erros no cálculo das notas exibidas na pauta. Caso a sua disciplina ainda não tenha iniciado, ou esteja em progresso, é recomendado que corrija os erros clicando no botão abaixo, que resultará na alteração de algumas notas. Caso a sua disciplina já tenha terminado e as notas tenham sido submetidas, provavelmente não quererá resolver este problema.

A nova versão é {$a->currentversion} e neste momento está a utilizar a versão {$a->gradebookversion} da pauta. Pode ver a lista das alterações em <a href="{$a->url}">Alterações no cálculo das notas</a>.';
$string['gradebookhiddenerror'] = 'De momento, o relatório está configurado para ocultar toda a informação dos alunos.';
$string['gradebookhistories'] = 'Histórico das notas';
$string['gradebooksetup'] = 'Configurar a pauta';
$string['gradeboundary'] = 'Limite inferior do intervalo';
$string['gradeboundary_help'] = 'Esta opção determina a percentagem mínima da nota sobre a qual é atribuída uma nota alfabética.';
$string['gradecategories'] = 'Categorias da pauta';
$string['gradecategory'] = 'Categoria na pauta';
$string['gradecategoryonmodform'] = 'Categoria na pauta';
$string['gradecategoryonmodform_help'] = 'Esta opção controla a Categoria em que a nota desta atividade é inserida na pauta.';
$string['gradecategorysettings'] = 'Definições da categoria da pauta';
$string['gradedisplay'] = 'Exibição das notas';
$string['gradedisplaytype'] = 'Formato das notas';
$string['gradedisplaytype_help'] = 'Esta opção determina como são mostradas as notas nos relatórios.

* Notas alfabéticas - Letras ou palavras que representam um intervalo de notas, tal como definidas em \'Notas alfabéticas\' das configurações da pauta
* Percentagem - Relativa à nota máxima e mínima
* Real - Notas reais ou valor de uma escala';
$string['gradedon'] = 'Avaliado: {$a}';
$string['gradeexport'] = 'Exportar notas';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Campos personalizados de perfil na exportação das notas';
$string['gradeexportcustomprofilefields_desc'] = 'Incluir estes campos de perfil personalizados na exportação das notas, separados por vírgulas.';
$string['gradeexportdecimalpoints'] = 'Casas decimais na exportação das notas';
$string['gradeexportdecimalpoints_desc'] = 'O número de casas decimais na exportação das notas. Esta configuração pode ser alterada durante a exportação.';
$string['gradeexportdisplaytype'] = 'Formato das notas na exportação';
$string['gradeexportdisplaytype_desc'] = 'Durante a exportação as notas podem ser exibidas como notas reais, percentagens (como referência das notas máximas e mínimas) ou como letras (A, B, C, etc.). Esta configuração pode ser alterada durante a exportação.';
$string['gradeexportdisplaytypes'] = 'Tipos de exibição de exportação das notas';
$string['gradeexportuserprofilefields'] = 'Campos de perfil do utilizador na exportação das notas';
$string['gradeexportuserprofilefields_desc'] = 'Incluir estes campos de perfil do utilizador na exportação de notas, separados por vírgulas.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Nota mínima e máxima iniciais';
$string['gradehelp'] = 'Ajuda sobre Notas';
$string['gradehistorylifetime'] = 'Manter histórico das notas durante';
$string['gradehistorylifetime_help'] = 'Isto especifica o período de tempo que pretende manter o histórico das alterações nas tabelas relacionadas com a pauta. Recomenda-se que mantenha o maior tempo possível. Se tiver problemas de desempenho ou espaço limitado na base de dados, tente selecionar um valor inferior.';
$string['gradeimport'] = 'Importar notas';
$string['gradeimportfailed'] = 'Falha durante a importação das notas. Detalhes:';
$string['gradeitem'] = 'Item de avaliação';
$string['gradeitemaddusers'] = 'Excluir da avaliação';
$string['gradeitemadvanced'] = 'Opções avançadas dos itens de avaliação';
$string['gradeitemadvanced_help'] = 'Selecione todos os elementos que devem ser exibidos como avançados na edição dos itens de avaliação.';
$string['gradeitemislocked'] = 'Esta atividade está bloqueada na pauta. As alterações realizadas nas notas desta atividade não serão copiadas para a pauta, até que ela seja desbloqueada.';
$string['gradeitemlocked'] = 'Nota bloqueada';
$string['gradeitemmembersselected'] = 'Excluído(s) da avaliação';
$string['gradeitemminmax'] = 'Nota mínima e máxima conforme especificado nas configurações do item da pauta';
$string['gradeitemnonmembers'] = 'Incluído(s) na avaliação';
$string['gradeitemremovemembers'] = 'Incluir na avaliação';
$string['gradeitems'] = 'Itens de avaliação';
$string['gradeitemsettings'] = 'Definições de itens de avaliação';
$string['gradeitemsinc'] = 'Itens de avaliação a incluir';
$string['gradeletter'] = 'Nota alfabética';
$string['gradeletter_help'] = 'Notas alfabéticas são letras, A, B, C, ..., ou palavras como por exemplo Distinção, Mérito, ..., usadas para representar um intervalo de notas.';
$string['gradeletternote'] = 'Para eliminar uma nota alfabética basta limpar qualquer uma <br /> das 3 caixas de texto da nota e clicar em Submeter.';
$string['gradeletteroverridden'] = 'As notas alfabéticas predefinidas foram ajustadas.';
$string['gradeletters'] = 'Notas alfabéticas';
$string['gradelocked'] = 'Nota bloqueada';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Nota máxima';
$string['grademax_help'] = 'Esta opção determina a nota máxima quando são usados valores nas notas. A nota máxima de uma atividade é determinada na sua página de configuração.';
$string['grademin'] = 'Nota mínima';
$string['grademin_help'] = 'Esta opção determina a nota mínima quando são usados valores nas notas.';
$string['gradenotificationmessage'] = 'Tem novos comentários sobre o seu trabalho para "{$a}"';
$string['gradenotificationsubject'] = 'Foi avaliado';
$string['gradeoutcomeitem'] = 'Avaliar item de resultado da aprendizagem';
$string['gradeoutcomes'] = 'Resultados da aprendizagem';
$string['gradeoutcomescourses'] = 'Resultados da aprendizagem da disciplina';
$string['gradepass'] = 'Nota de aprovação';
$string['gradepass_help'] = 'Esta opção determina a nota mínima necessária para obter aprovação. O valor é usado nas atividades, na conclusão da disciplina e na pauta, onde as notas de aprovação são destacadas a verde e as de reprovação a vermelho.';
$string['gradepassgreaterthangrade'] = 'A nota de aprovação não pode ser superior à nota máxima ({$a})';
$string['gradepointdefault'] = 'Pontuação predefinida';
$string['gradepointdefault_help'] = 'Esta configuração determina o valor predefinido para a pontuação disponível num item de avaliação.';
$string['gradepointdefault_validateerror'] = 'Esta configuração deve ser um número inteiro entre 1 e o valor máximo definido.';
$string['gradepointmax'] = 'Valor máximo da pontuação';
$string['gradepointmax_help'] = 'Esta configuração determina o valor máximo para a pontuação disponível numa atividade.';
$string['gradepointmax_validateerror'] = 'Esta configuração deve ser um número inteiro entre 1 e 10000.';
$string['gradepreferences'] = 'Preferências de notas';
$string['gradepreferenceshelp'] = 'Ajuda sobre preferências de notas';
$string['gradepublishing'] = 'Ativar publicação';
$string['gradepublishing_help'] = 'A publicação das notas é uma maneira de importar e exportar notas através de um URL, sem a necessidade de autenticação no Moodle. Se ativar esta opção, os administradores e utilizadores com permissão para publicar notas (por predefinição, apenas os utilizadores com o papel de gestor) conseguem aceder/alterar as configurações de publicação das notas exportadas da pauta de cada disciplina.';
$string['gradepublishinglink'] = 'Descarregar: {$a}';
$string['gradereport'] = 'Pauta';
$string['graderreport'] = 'Relatório do avaliador';
$string['grades'] = 'Pauta';
$string['gradesforuser'] = 'Notas de {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Aviso: A atividade está a ser apagada! Algumas notas estão prestes a ser removidas.';
$string['gradesmoduledeletionprefix'] = '[Remoção em progresso]';
$string['gradesonly'] = 'Mudar para só notas';
$string['gradessettings'] = 'Definições de notas';
$string['gradetype'] = 'Tipo de nota';
$string['gradetype_help'] = 'Existem três tipos de notas:

* Nenhuma - Não existe avaliação
* Valor - Um valor numérico com um máximo e mínimo definido
* Escala - Item de uma listagem
* Texto - Apenas é dado feedback

Apenas os tipos de notas valor e escala podem ser agregados. O tipo de nota de uma atividade é definido nas suas configurações.';
$string['gradevaluetoobig'] = 'Um dos valores da nota é maior do que a nota máxima permitida de {$a}';
$string['gradeview'] = 'Ver nota';
$string['gradewasmodifiedduringediting'] = 'A nota inserida para {$a->itemname} de {$a->username} foi ignorada porque foi mais recentemente atualizada por outro utilizador.';
$string['gradeweighthelp'] = 'Ajuda sobre ponderação de notas';
$string['gradingmodulename'] = 'A avaliar ({$a})';
$string['groupavg'] = 'Média do grupo';
$string['hidden'] = 'Ocultar';
$string['hidden_help'] = 'Se selecionar esta opção, as notas ficam ocultas para os alunos. Se desejar, pode definir uma data até à qual as notas estão ocultas enquanto termina o processo de avaliação.';
$string['hiddenasdate'] = 'Mostrar data de submissão nas notas ocultas';
$string['hiddenasdate_help'] = 'Se o utilizador não consegue ver as notas ocultas mostrar a data de submissão, em vez de \'-\'.';
$string['hiddenuntil'] = 'Ocultar até';
$string['hiddenuntildate'] = 'Ocultar até: {$a}';
$string['hideadvanced'] = 'Ocultar funcionalidades avançadas';
$string['hideaverages'] = 'Ocultar médias';
$string['hidecalculations'] = 'Ocultar cálculos';
$string['hidecategory'] = 'Oculta';
$string['hideeyecons'] = 'Ocultar os ícones Mostrar/Ocultar';
$string['hidefeedback'] = 'Ocultar feedback';
$string['hideforcedsettings'] = 'Ocultar configurações forçadas';
$string['hideforcedsettings_help'] = 'Não mostrar as configurações forçadas na pauta.';
$string['hidegroups'] = 'Ocultar grupos';
$string['hidelocks'] = 'Ocultar bloqueios';
$string['hidenooutcomes'] = 'Mostrar resultados da aprendizagem';
$string['hidequickfeedback'] = 'Ocultar Comentário rápido';
$string['hideranges'] = 'Ocultar intervalos';
$string['hidetotalifhiddenitems'] = 'Ocultar totais se contiverem itens ocultos';
$string['hidetotalifhiddenitems_help'] = 'Esta opção especifica se os totais com notas ocultas são mostrados aos alunos ou substituídos por um hífen (-). Se for exibido, o total pode ser calculado excluindo ou incluindo os itens ocultos.

Se os itens ocultos são excluídos, o total que os alunos visualizam será diferente do total visto pelo professor na pauta, pois este vê todos os totais calculados (itens ocultos ou não). Se os itens ocultos são incluídos, os alunos podem calculá-los.';
$string['hidetotalshowexhiddenitems'] = 'Mostrar totais excluindo itens ocultos';
$string['hidetotalshowinchiddenitems'] = 'Mostrar totais incluindo itens ocultos';
$string['hideverbose'] = 'Ocultar {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Ordenar notas de forma ascendente';
$string['highgradedescending'] = 'Ordenar notas de forma decrescente';
$string['highgradeletter'] = 'Máxima';
$string['identifier'] = 'Identificar utilizador através de';
$string['idnumbers'] = 'Números de ID';
$string['ignore'] = 'Ignorar';
$string['import'] = 'Importar';
$string['importcsv'] = 'Importar CSV';
$string['importcsv_help'] = 'As notas podem ser importadas através de um ficheiro CSV com o seguinte formato:

* Cada linha do ficheiro contém apenas um registo
* Cada registo é um conjunto de dados separados por vírgulas ou outro tipo de separador
* O primeiro registo contém uma lista com os nomes dos campos, definindo assim o restante formato do ficheiro
* É necessário existir um campo com os dados de identificação dos utilizadores - pode ser o nome de utilizador, o número de identificação (ID) ou o endereço de e-mail

Se previamente exportar algumas notas, poderá obter um exemplo de um ficheiro com o formato correto. O ficheiro em questão poderá ser editado posteriormente e guardado como ficheiro CSV.';
$string['importcustom'] = 'Importar como resultados da aprendizagem personalizados (apenas nesta disciplina)';
$string['importerror'] = 'Ocorreu um erro, o script não foi chamado com os parâmetros corretos.';
$string['importfailed'] = 'A importação falhou. Nenhum dado foi importado.';
$string['importfeedback'] = 'Importar comentários';
$string['importfile'] = 'Importar ficheiro';
$string['importfilemissing'] = 'Não foi recebido qualquer ficheiro; volte à grelha e assegure-se de que envia um ficheiro válido.';
$string['importfrom'] = 'Importar a partir de';
$string['importoutcomenofile'] = 'O ficheiro carregado está vazio ou corrompido. Verifique se se trata de um ficheiro válido. O problema foi detetado na linha {$a}; este erro aconteceu porque as linhas de dados não tinham tantas colunas como na primeira linha (linha de cabeçalho), ou porque faltam cabeçalhos no ficheiro importado. Observe o ficheiro exportado para ver um exemplo de um ficheiro com um cabeçalho válido.';
$string['importoutcomes'] = 'Importar resultados da aprendizagem';
$string['importoutcomes_help'] = 'Os resultados da aprendizagem podem ser importados de um ficheiro CSV, igual ao formato em que são exportados.';
$string['importoutcomes_link'] = 'nota/competência';
$string['importoutcomesuccess'] = 'Resultado da aprendizagem "{$a->name}" importado com o ID #{$a->id}';
$string['importplugins'] = 'Módulos de importação';
$string['importpreview'] = 'Pré-visualização da importação';
$string['importsettings'] = 'Definições de importação';
$string['importskippednomanagescale'] = 'Não tem permissões para adicionar uma nova escala. O resultado da aprendizagem "{$a}" não foi importado, uma vez que era necessário criar uma nova escala.';
$string['importskippedoutcome'] = 'Neste contexto, já existe um resultado da aprendizagem com o nome curto "{$a}". O resultado da aprendizagem contido no ficheiro de importação foi ignorado.';
$string['importstandard'] = 'Importar como resultados de aprendizagem padrão';
$string['importsuccess'] = 'As notas foram importadas com sucesso';
$string['importxml'] = 'Importar XML';
$string['includescalesinaggregation'] = 'Incluir escalas nos cálculos';
$string['includescalesinaggregation_help'] = 'Determina se as escalas são incluídas, como números, nos cálculos das notas em todas as pautas de todas as disciplinas. <strong>Atenção</strong>: Se alterar esta opção todas as notas serão recalculadas.';
$string['incorrectcourseid'] = 'O ID da disciplina estava incorreto';
$string['incorrectcustomscale'] = '(Escala personalizada incorrecta, por favor, altere)';
$string['incorrectminmax'] = 'O mínimo tem de ser inferior ao máximo';
$string['inherit'] = 'Herdar';
$string['intersectioninfo'] = 'Informação Notas/Alunos';
$string['invalidgradeexporteddate'] = 'A data de exportação é inválida porque refere-se a mais do que um ano atrás, ou no futuro, ou porque o formato é inválido.';
$string['item'] = 'Item';
$string['iteminfo'] = 'Informação do item';
$string['iteminfo_help'] = 'Use este campo para introduzir mais informações sobre o item de avaliação. Esta informação não é exibida em nenhum outro lugar.';
$string['itemname'] = 'Nome do item';
$string['itemnamehelp'] = 'Nome deste item, forçado pelo módulo';
$string['items'] = 'Itens';
$string['itemsedit'] = 'Editar item de avaliação';
$string['keephigh'] = 'Manter as mais altas';
$string['keephigh_help'] = 'Se ativar esta opção, apenas serão consideradas as X notas mais altas, sendo X o valor selecionado.';
$string['keephighestvalues'] = 'Manter os {$a} valores mais altos';
$string['keymanager'] = 'Gestor de chaves';
$string['lessthanmin'] = 'A nota introduzida em {$a->itemname} para {$a->username} é inferior ao mínimo definido';
$string['letter'] = 'Nota alfabética';
$string['lettergrade'] = 'Nota Alfabética';
$string['lettergradenonnumber'] = 'Nota Baixa e/ou Alta não numéricas para';
$string['letterpercentage'] = 'Nota alfabética (percentagem)';
$string['letterreal'] = 'Nota alfabética (real)';
$string['letters'] = 'Notas alfabéticas';
$string['linkedactivity'] = 'Atividade associada';
$string['linkedactivity_help'] = 'Esta opção especifica uma atividade ao qual este item está hiperligado. Isto pode ser usado para medir o desempenho dos alunos baseado em critérios que não foram contemplados na avaliação da atividade.';
$string['linktoactivity'] = 'Hiperligação para a atividade {$a->name}: \'{$a->title}\'';
$string['lock'] = 'Bloquear';
$string['locked'] = 'Bloquear';
$string['locked_help'] = 'Se selecionar esta opção, as notas já não podem ser atualizadas automaticamente através da atividade.';
$string['locktime'] = 'Bloquear após';
$string['locktimedate'] = 'Bloquear após: {$a}';
$string['lockverbose'] = 'Bloquear {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Mais baixa';
$string['lowgradeletter'] = 'Mínima';
$string['manualitem'] = 'Item manual';
$string['mapfrom'] = 'Mapear a partir de';
$string['mapfrom_help'] = 'Selecione a coluna da folha de cálculo que contém os dados de identificação do utilizador, tal como o nome de utilizador, o número de identificação (ID) ou o endereço de e-mail.';
$string['mappings'] = 'Mapeamentos de itens de avaliação';
$string['mappings_help'] = 'Para cada coluna de nota da folha de cálculo, indique o item de avaliação a que corresponde para que a importação seja efetuada.';
$string['mapto'] = 'Mapear para';
$string['mapto_help'] = 'Selecione os mesmos dados de identificação selecionados em "Campo de origem".';
$string['max'] = 'Mais alta';
$string['maxgrade'] = 'Nota máxima';
$string['meanall'] = 'Todas as notas';
$string['meangraded'] = 'Notas não vazias';
$string['meanselection'] = 'Notas para cálculo das médias das colunas';
$string['meanselection_help'] = 'Esta opção determina se as células sem nota são incluídas no cálculo das médias da categoria e do item de avaliação.';
$string['median'] = 'Mediana';
$string['min'] = 'Mais baixa';
$string['minimum_show'] = 'Mostrar nota mínima';
$string['minimum_show_help'] = 'A nota mínima é usada para calcular notas e pesos. Se não for exibida, a nota mínima será predefinida como zero e não poderá ser editada.';
$string['minmaxtouse'] = 'Nota mínima e máxima utilizadas no cálculo';
$string['minmaxtouse_desc'] = 'Esta configuração determina se deve, ou não, utilizar a nota mínima e máxima quando a nota foi atribuída, ou o mínimo e o máximo especificado nas configurações para o item de avaliação no momento em que a nota é mostrada na pauta. Recomenda-se que altere esta configuração numa altura de pouca atividade na plataforma, porque como todas as notas vão ser recalculadas pode sobrecarregar muito o servidor.';
$string['minmaxtouse_help'] = 'Esta configuração determina se deve utilizar a nota mínima e máxima quando a nota foi atribuída, ou o mínimo e o máximo especificado nas configurações para o item de avaliação no momento em que a nota é mostrada na pauta.';
$string['minmaxupgradedgrades'] = 'Nota: Algumas notas foram alteradas de modo a resolver uma incoerência na pauta, causada por uma alteração das notas mínimas e máximas utilizadas para o cálculo da nota exibida. Recomenda-se que as alterações sejam revistas e aceites.';
$string['minmaxupgradefixbutton'] = 'Resolver incoerências';
$string['minmaxupgradewarning'] = 'Nota: Foi detetada uma incoerência em algumas avaliações devido a uma alteração das notas mínimas e máximas, utilizadas no cálculo da nota exibida na pauta. Recomenda-se que clique no botão abaixo para resolver a incoerência, embora tal vá resultar na alteração de algumas notas.';
$string['missingitemtypeoreid'] = 'O índice do array (itemtype ou eid) do segundo argumento da função grade_edit_tree_column_select::get_item_cell($item, $params) está em falta';
$string['missingscale'] = 'É preciso selecionar uma escala';
$string['mode'] = 'Moda';
$string['modgrade'] = 'Nota';
$string['modgrade_help'] = 'Selecione o tipo de nota a utilizar nesta atividade. Se escolher a opção \'Escala\', poderá selecionar o tipo de escala a usar a partir da lista pendente. Se selecionar a opção \'Nota\', poderá definir a nota máxima disponível para esta atividade.';
$string['modgradecantchangegradetype'] = 'Não pode alterar o tipo, porque já existem notas atribuídas neste item de avaliação.';
$string['modgradecantchangegradetypemsg'] = 'Como algumas notas já foram atribuídas, o tipo de nota não pode ser alterado. Se pretender alterar a nota máxima, deve primeiro selecionar se pretende, ou não, "Reajustar notas existentes".';
$string['modgradecantchangegradetyporscalemsg'] = 'Algumas notas já foram atribuídas, por isso, o tipo de nota e a escala não podem ser alterados.';
$string['modgradecantchangeratingmaxgrade'] = 'Não pode alterar a nota máxima quando já existem notas para uma atividade avaliada.';
$string['modgradecantchangescale'] = 'Não pode alterar a escala porque já existem notas para este item de avaliação.';
$string['modgradecategorycantchangegradetypemsg'] = 'Esta categoria possui itens de avaliação que foram ajustados. Por conseguinte, como algumas notas já foram atribuídas, o tipo de nota não pode ser alterado. Se pretender alterar a nota máxima, deve primeiro selecionar se pretende, ou não, "Reajustar notas existentes".';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Esta categoria possui itens de avaliação que foram ajustados. Por conseguinte, como algumas notas já foram atribuídas, o tipo de nota e a escala não podem ser alterados.';
$string['modgradecategoryrescalegrades'] = 'Recalcular ajustamento de notas';
$string['modgradecategoryrescalegrades_help'] = 'Ao alterar as notas máximas de um item da pauta, deve indicar se pretende que esta ação altere, ou não, a percentagem das notas já existentes.

Se definir esta configuração como \'Sim\', quaisquer notas existentes já reajustadas serão novamente reajustadas para que a percentagem da nota permaneça igual.

Por exemplo, se esta configuração for definida como \'Sim\', ao mudar a nota máxima de um item de 10 para 20, isto levaria a que uma nota de 6/10 (60%) fosse ajustada para 12/20 (60%). Se esta configuração for definida como \'Não\', a nota permanecerá inalterada, o que requer um ajuste manual dos itens de avaliação para garantir pontuações corretas.';
$string['modgradedonotmodify'] = 'Não modificar as notas existentes';
$string['modgradeerrorbadpoint'] = 'Valor da nota inválido. Deverá indicar um número inteiro entre 1 e {$a}';
$string['modgradeerrorbadscale'] = 'Escala selecionada inválida. Por favor, certifique-se de que seleciona uma escala a partir da seleção abaixo.';
$string['modgrademaxgrade'] = 'Nota máxima';
$string['modgraderescalegrades'] = 'Reajustar notas existentes';
$string['modgraderescalegrades_help'] = 'Ao alterar as notas máximas de um item da pauta, deve indicar se pretende que esta ação altere, ou não, a percentagem das notas já existentes.

Se definir esta configuração como \'Sim\', quaisquer notas existentes serão reajustadas para que a percentagem da nota permaneça igual.

Por exemplo, se esta configuração for definida como \'Sim\', ao mudar a nota máxima de um item de 10 para 20, isto levaria a que uma nota de 6/10 (60%) fosse ajustada para 12/20 (60%). Se esta configuração for definida como \'Não\', a nota passará de 6/10 (60%) para 6/20 (30%), o que requer um ajuste manual dos itens de avaliação para garantir pontuações corretas.';
$string['modgradetype'] = 'Tipo';
$string['modgradetypenone'] = 'Nenhum';
$string['modgradetypepoint'] = 'Nota';
$string['modgradetypescale'] = 'Escala';
$string['morethanmax'] = 'A nota introduzida em {$a->itemname} para {$a->username} é superior ao máximo permitido';
$string['moveselectedto'] = 'Mover os items selecionados para';
$string['movingelement'] = 'A mover {$a}';
$string['multfactor'] = 'Multiplicador';
$string['multfactor_help'] = 'O multiplicador é o fator pelo qual serão multiplicadas todas as notas para esta prova, com valor máximo igual à nota máxima. Por exemplo, se o multiplicador for 2 e a nota máxima for 100, todas as notas menores que 50 serão multiplicadas por 2, e as notas  maiores ou iguais a 50 serão convertidas em 100.';
$string['multfactorvalue'] = 'Multiplicador para {$a}';
$string['mustchooserescaleyesorno'] = 'Deve selecionar se pretende, ou não, reajustar as notas existentes.';
$string['mygrades'] = 'Hiperligação para a pauta no menu do utilizador';
$string['mygrades_desc'] = 'Esta configuração permite ligar a uma pauta externa a partir do menu do utilizador.';
$string['mypreferences'] = 'Minhas preferências';
$string['myreportpreferences'] = 'Minhas preferências';
$string['navmethod'] = 'Método de navegação';
$string['neverdeletehistory'] = 'Nunca eliminar histórico';
$string['newcategory'] = 'Nova categoria';
$string['newitem'] = 'Novo item de avaliação';
$string['newoutcomeitem'] = 'Novo item de resultados da aprendizagem';
$string['no'] = 'Não';
$string['nocategories'] = 'Não foi possível adicionar ou encontrar categorias da pauta nesta disciplina';
$string['nocategoryname'] = 'Não foi introduzido um nome para a categoria.';
$string['nocategoryview'] = 'Não existem categorias';
$string['nocourses'] = 'Não há disciplinas para mostrar';
$string['noforce'] = 'Não forçar';
$string['nogradeletters'] = 'As Notas alfabéticas não foram configuradas';
$string['nogradesreturned'] = 'Não foram devolvidas notas';
$string['noidnumber'] = 'Não existe número de ID';
$string['nolettergrade'] = 'Não há Notas alfabéticas para';
$string['nomode'] = 'ND';
$string['nonnumericweight'] = 'Recebido valor não numérico para';
$string['nonunlockableverbose'] = 'Esta nota não pode ser desbloqueada até que o item \'{$a->itemname}\' seja desbloqueado.';
$string['nonweightedpct'] = '% não ponderada';
$string['nooutcome'] = 'Nenhum resultado da aprendizagem';
$string['nooutcomes'] = 'Os itens dos resultados da aprendizagem devem estar ligados a resultado da aprendizagem da disciplina, mas não existem nesta disciplina. Pretende adicionar?';
$string['nopermissiontoresetweights'] = 'Sem permissão para redefinir os pesos';
$string['nopublish'] = 'Não publicar';
$string['noreports'] = 'Não está inscrito, nem a lecionar, em qualquer disciplina deste site.';
$string['norolesdefined'] = 'Não existem papéis definidos em Administração > Notas > Configurações > Papéis avaliados';
$string['noscales'] = 'Os resultados da aprendizagem devem estar ligadas a uma escala da disciplina ou escala global, mas não existe nenhuma. Pretende adicionar uma?';
$string['noselectedcategories'] = 'não foram selecionadas quaisquer categorias.';
$string['noselecteditems'] = 'não foram selecionados quaisquer itens.';
$string['notenrolled'] = 'Atualmente não está inscrito em nenhuma disciplina.';
$string['notteachererror'] = 'Tem que ser professor para usar esta funcionalidade';
$string['nousersloaded'] = 'Sem utilizadores carregados';
$string['nouserstograde'] = 'Sem utilizadores para avaliar';
$string['numberofgrades'] = 'Número de notas';
$string['onascaleof'] = 'numa escala de {$a->grademin} a {$a->grademax}';
$string['operations'] = 'Operações';
$string['options'] = 'Opções';
$string['others'] = 'Outros';
$string['outcome'] = 'Resultado da aprendizagem';
$string['outcome_help'] = 'Esta opção determina qual o resultado da aprendizagem que este item de avaliação representará na pauta.';
$string['outcomeassigntocourse'] = 'Adicionar outro resultado da aprendizagem a esta disciplina';
$string['outcomecategory'] = 'Criar resultado da aprendizagem na categoria';
$string['outcomecategorynew'] = 'Nova categoria';
$string['outcomeconfirmdelete'] = 'Tem a certeza de que pretende eliminar o resultado da aprendizagem "{$a}"?';
$string['outcomecreate'] = 'Adicionar novo resultado da aprendizagem';
$string['outcomedelete'] = 'Eliminar resultado da aprendizagem';
$string['outcomefullname'] = 'Nome completo';
$string['outcomeitem'] = 'Item de resultado da aprendizagem';
$string['outcomeitemsedit'] = 'Editar item de resultado da aprendizagem';
$string['outcomereport'] = 'Relatório do resultado da aprendizagem';
$string['outcomes'] = 'Resultados da aprendizagem';
$string['outcomescourse'] = 'Resultados da aprendizagem utilizados na disciplina';
$string['outcomescoursecustom'] = 'Competência(s) personalizada(s) utilizada(s) (não remover)';
$string['outcomescoursenotused'] = 'Competência(s)-padrão não utilizada(s)';
$string['outcomescourseused'] = 'Competência(s)-padrão utilizada(s) (não remover)';
$string['outcomescustom'] = 'Resultados da aprendizagem personalizados';
$string['outcomeshortname'] = 'Nome curto';
$string['outcomesstandard'] = 'Resultados da aprendizagem predefinidos';
$string['outcomesstandardavailable'] = 'Resultados da aprendizagem disponíveis';
$string['outcomestandard'] = 'Resultado da aprendizagem padrão';
$string['outcomestandard_help'] = 'Um resultado da aprendizagem padrão está disponível na plataforma para todas as disciplinas.';
$string['overallaverage'] = 'Média';
$string['overridden'] = 'Ajustar nota';
$string['overridden_help'] = 'Se ativar esta opção, a nota já não pode ser alterada pela atividade.

Quando uma nota é ajustada na pauta, esta caixa de seleção será ativada automaticamente. No entanto, pode ser desativada para que a nota volte a depender da atividade.';
$string['overriddennotice'] = 'A sua nota final nesta atividade foi alterada manualmente na pauta.';
$string['overridecat'] = 'Permitir ajuste manual das notas da categoria';
$string['overridecat_help'] = 'Se desativar esta configuração vai impossibilitar os utilizadores de ajustar as notas das categorias.';
$string['overridesitedefaultgradedisplaytype'] = 'Ajustar valores predefinidos do site';
$string['overridesitedefaultgradedisplaytype_help'] = 'Se selecionar esta opção, as notas alfabéticas e limites de intervalos para a disciplina podem ser configuradas, ao invés de serem usadas as configurações predefinidas do site.';
$string['overrideweightofa'] = 'Ajustar o peso de {$a}';
$string['parentcategory'] = 'Categoria ascendente';
$string['pctoftotalgrade'] = '% da nota final';
$string['percent'] = 'Percentagem';
$string['percentage'] = 'Percentagem';
$string['percentageletter'] = 'Percentagem (nota alfabética)';
$string['percentagereal'] = 'Percentagem (real)';
$string['percentascending'] = 'Ordenar por percentagem ascendente';
$string['percentdescending'] = 'Ordenar por percentagem decrescente';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Acréscimo';
$string['plusfactor_help'] = 'O acréscimo é um número que é adicionado a cada nota, após ser aplicado o multiplicador. Pode ser negativo.';
$string['plusfactorvalue'] = 'Acréscimo para {$a}';
$string['points'] = 'pontos';
$string['pointsascending'] = 'Ordenar por pontos ascendente';
$string['pointsdescending'] = 'Ordenar por pontos decrescente';
$string['positionfirst'] = 'Primeira';
$string['positionlast'] = 'Última';
$string['preferences'] = 'Preferências';
$string['prefgeneral'] = 'Geral';
$string['prefletters'] = 'Notas alfabéticas e limites de intervalos';
$string['prefrows'] = 'Linhas especiais';
$string['prefshow'] = 'Opções mostrar/ocultar';
$string['previewrows'] = 'Pré-visualizar linhas';
$string['privacy:metadata:categorieshistory'] = 'O registo de versões anteriores de categorias da pauta';
$string['privacy:metadata:filepurpose'] = 'Ficheiros de feedback armazenados na pauta para um utilizador.';
$string['privacy:metadata:grade_import_newitem'] = 'Tabela temporária para armazenar novos nomes de grade_item da importação de avaliação';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Um código de operação exclusivo para identificar uma operação de importações';
$string['privacy:metadata:grade_import_newitem:importer'] = 'O utilizador a importar os dados';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nome do novo item de avaliação';
$string['privacy:metadata:grade_import_values'] = 'Tabela temporária para importar avaliações';
$string['privacy:metadata:grade_import_values:feedback'] = 'Feedback de avaliação';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Valor da nota bruta';
$string['privacy:metadata:grade_import_values:importcode'] = 'Um código de operação exclusivo para identificar uma operação de importações';
$string['privacy:metadata:grade_import_values:importer'] = 'O utilizador a importar os dados';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Marcar se apenas o feedback foi importado';
$string['privacy:metadata:grade_import_values:userid'] = 'Utilizador cuja avaliação foi importada';
$string['privacy:metadata:grades'] = 'Registo das avaliações';
$string['privacy:metadata:grades:aggregationstatus'] = 'O estado de agregação';
$string['privacy:metadata:grades:aggregationweight'] = 'O peso na agregação';
$string['privacy:metadata:grades:feedback'] = 'O feedback';
$string['privacy:metadata:grades:finalgrade'] = 'A avaliação';
$string['privacy:metadata:grades:information'] = 'Informação adicional acerca da nota';
$string['privacy:metadata:grades:timemodified'] = 'A data/hora em que a avaliação foi modificada pela última vez';
$string['privacy:metadata:grades:userid'] = 'O ID de utilizador desta avaliação';
$string['privacy:metadata:grades:usermodified'] = 'O ID do utilizador que modificou o registo pela última vez';
$string['privacy:metadata:gradeshistory'] = 'O registo de avaliações anteriores';
$string['privacy:metadata:history:loggeduser'] = 'O ID do utilizador que estava autenticado quando a versão ocorreu';
$string['privacy:metadata:history:timemodified'] = 'A data/hora em que a versão da nota ocorreu';
$string['privacy:metadata:itemshistory'] = 'O registo de versões de avaliação anteriores';
$string['privacy:metadata:outcomes'] = 'O registo de resultados de aprendizagem';
$string['privacy:metadata:outcomes:timemodified'] = 'A data/hora em que o resultado de aprendizagem foi modificado';
$string['privacy:metadata:outcomes:usermodified'] = 'O utilizador que modificou o registo pela última vez';
$string['privacy:metadata:outcomeshistory'] = 'O registo de versões de resultados de aprendizagem anteriores';
$string['privacy:metadata:scale'] = 'O registo de escalas';
$string['privacy:metadata:scale:timemodified'] = 'A data/hora em que o registo foi modificado pela última vez';
$string['privacy:metadata:scale:userid'] = 'O ID do utilizador que modificou o registo pela última vez';
$string['privacy:metadata:scalehistory'] = 'Um registo de versões de escalas anteriores';
$string['privacy:path:relatedtome'] = 'Relacionado comigo';
$string['privacy:request:historyactiondelete'] = 'Apagar';
$string['privacy:request:historyactioninsert'] = 'Inserir';
$string['privacy:request:historyactionupdate'] = 'Atualizar';
$string['privacy:request:unknowndeletedgradeitem'] = 'Desconhecido (O item de avaliação foi apagado)';
$string['profilereport'] = 'Relatório no perfil do utilizador';
$string['profilereport_help'] = 'Relatório de avaliação exibido na página de perfil do utilizador.';
$string['publishing'] = 'Publicar';
$string['publishingoptions'] = 'Opções da publicação de notas';
$string['quickfeedback'] = 'Comentário rápido';
$string['quickgrading'] = 'Avaliação rápida';
$string['quickgrading_help'] = 'Se ativar esta opção, quando o modo de edição das notas está ativo, surge uma caixa para cada nota, permitindo editar várias notas ao mesmo tempo. As alterações serão guardadas e assinaladas após clicar no botão de Atualização.

Repare que quando uma nota é ajustada diretamente na pauta, o campo Ajustar nota correspondente áquela nota é selecionado e a nota deixará de poder ser alterada pela atividade a que a nota respeita.';
$string['range'] = 'Intervalo';
$string['rangedecimals'] = 'Casas decimais dos intervalos';
$string['rangedecimals_help'] = 'O número de casas decimais a mostrar no intervalo.';
$string['rangesdecimalpoints'] = 'Casas decimais exibidas nos intervalos';
$string['rangesdecimalpoints_help'] = 'Esta opção determina o número de casas decimais a mostrar em cada intervalo ou se é usada a configuração geral de casas decimais para o item de categoria ou nota (herdar).';
$string['rangesdisplaytype'] = 'Formato dos intervalos';
$string['rangesdisplaytype_help'] = 'Esta opção determina se o intervalo é apresentado como notas reais, percentagens ou notas alfabéticas, ou se o formato é herdado da categoria ou item de avaliação.';
$string['rank'] = 'Posição relativa';
$string['rawpct'] = '%';
$string['real'] = 'Real';
$string['realletter'] = 'Real (nota alfabética)';
$string['realpercentage'] = 'Real (percentagem)';
$string['recalculatinggrades'] = 'A recalcular as notas';
$string['recovergradesdefault'] = 'Recuperação de notas';
$string['recovergradesdefault_help'] = 'Recupera as notas antigas quando se reinscreve um aluno numa disciplina';
$string['refreshpreview'] = 'Atualizar pré-visualização';
$string['regradeanyway'] = 'Voltar a avaliar';
$string['removeallcoursegrades'] = 'Eliminar todas as notas';
$string['removeallcoursegrades_help'] = 'Se selecionado, todas as notas que foram adicionadas manualmente na pauta serão apagadas, juntamente com os dados e as notas que foram substituídas, excluídas, escondidas e bloqueadas. Apenas as notas associadas às atividades permanecerão.';
$string['removeallcourseitems'] = 'Eliminar todos os itens e categorias';
$string['removeallcourseitems_help'] = 'Se selecionado, todas as categorias e notas que foram adicionadas manualmente na pauta serão apagadas, juntamente com os dados e as notas que foram substituídas, excluídas, ocultadas e bloqueadas. Apenas permanecerão as notas associadas às atividades.';
$string['report'] = 'Relatório';
$string['reportdefault'] = 'Definições predefinidas do relatório ({$a})';
$string['reportplugins'] = 'Módulos de relatório';
$string['reportsettings'] = 'Definições dos relatórios';
$string['reprintheaders'] = 'Reimprimir cabeçalhos';
$string['resetweights'] = 'Redefinir pesos de {$a->itemname}';
$string['resetweightsshort'] = 'Redefinir pesos';
$string['respectingcurrentdata'] = 'deixando a opção atual sem alterações';
$string['rowpreviewnum'] = 'Número de linhas a pré-visualizar';
$string['rowpreviewnum_help'] = 'Os dados a importar podem ser pré-visualizados e confirmados antes da importação. Esta configuração determina o número de linhas a ser mostrado na pré-visualização.';
$string['savechanges'] = 'Guardar alterações';
$string['savepreferences'] = 'Guardar preferências';
$string['scaleconfirmdelete'] = 'Tem a certeza de que pretende apagar a escala "{$a}"?';
$string['scaledpct'] = '% ajustada';
$string['seeallcoursegrades'] = 'Ver todas as notas da disciplina';
$string['select'] = 'Selecionar {$a}';
$string['selectalloroneuser'] = 'Selecione todos ou um utilizador';
$string['selectauser'] = 'Selecione um utilizador';
$string['selectdestination'] = 'Selecionar destino de {$a}';
$string['separator'] = 'Separador';
$string['separator_help'] = 'Selecione o tipo de separador utilizado no Ficheiro CSV. (Habitualmente utiliza-se a vírgula.)';
$string['sepcolon'] = 'Dois pontos';
$string['sepcomma'] = 'Vírgula';
$string['sepsemicolon'] = 'Ponto e vírgula';
$string['septab'] = 'Tabulação';
$string['setcategories'] = 'Definir categorias';
$string['setcategorieserror'] = 'Tem que definir as categorias da disciplina antes de atribuir pesos às categorias';
$string['setgradeletters'] = 'Definir Notas alfabéticas';
$string['setpreferences'] = 'Definir preferências';
$string['setting'] = 'Definição';
$string['settings'] = 'Definições';
$string['setweights'] = 'Definir pesos';
$string['showactivityicons'] = 'Mostrar ícones das atividades';
$string['showactivityicons_help'] = 'Se ativar esta opção, os ícones das atividade são mostrados ao lado dos seus nomes.';
$string['showallhidden'] = 'Mostrar nome dos itens ocultos';
$string['showallstudents'] = 'Mostrar todos os alunos';
$string['showanalysisicon'] = 'Mostrar o ícone da análise de notas';
$string['showanalysisicon_desc'] = 'Predefinição para a opção de mostrar o ícone da análise de notas. Se a atividade permitir, são geradas ligações do ícone para uma página com uma explicação mais detalhada sobre a nota e como foi obtida.';
$string['showanalysisicon_help'] = 'Se a atividade permitir, são geradas ligações do ícone para uma página com uma explicação mais detalhada sobre a nota e como foi obtida.';
$string['showaverage'] = 'Mostrar média';
$string['showaverage_help'] = 'Mostrar a coluna da média. Tenha em atenção que os alunos poderão estimar a nota dos colegas caso a média seja calculada com um pequeno número de notas. Por motivos de desempenho o valor da média será aproximado se depender de itens ocultos.';
$string['showaverages'] = 'Mostrar médias das colunas';
$string['showaverages_help'] = 'Se ativar esta opção, o relatório do avaliador terá uma linha adicional que exibirá a média para cada categoria e item de avaliação.';
$string['showcalculations'] = 'Mostrar cálculos';
$string['showcalculations_help'] = 'Se ativar esta opção, quando o modo de edição da pauta está ativo, é exibido um ícone da calculadora em cada categoria e item de avaliação, com um indicador visual de que um item de avaliação é calculado.';
$string['showcontributiontocoursetotal'] = 'Mostrar contribuição para o total da disciplina';
$string['showcontributiontocoursetotal_help'] = 'Se deve mostrar uma coluna de percentagens indicando em quanto é que cada item de avaliação contribui para a percentagem total da disciplina do utilizador (após aplicação da ponderação).';
$string['showeyecons'] = 'Mostrar ícones mostrar/ocultar';
$string['showeyecons_help'] = 'Se ativar esta opção, quando o modo de edição da pauta está ativo, é exibido o ícone de mostrar/ocultar junto de cada item para controlar a sua visibilidade ao aluno.';
$string['showfeedback'] = 'Mostrar feedback';
$string['showfeedback_help'] = 'Mostrar a coluna de comentários.';
$string['showgrade'] = 'Mostrar notas';
$string['showgrade_help'] = 'Mostrar a coluna das notas.';
$string['showgroups'] = 'Mostrar grupos';
$string['showhiddenitems'] = 'Mostrar itens ocultos';
$string['showhiddenitems_help'] = 'Esta opção define se os itens ocultos são totalmente omitidos na pauta ou se apenas os seus nomes são exibidos aos alunos.

* Mostrar nomes dos itens ocultos - Os nomes dos itens ocultos são exibidos aos alunos mas as notas mantêm-se ocultas;
* Apenas itens ocultos até - Os itens da pauta definidos como "Ocultar até" uma determinada data ficarão totalmente ocultos até à data definida. Após esta data, estes itens serão exibidos na sua totalidade;
* Totalmente ocultos - Todos os itens ocultos são omitidos na pauta.';
$string['showhiddenuntilonly'] = 'Apenas itens ocultos até';
$string['showingaggregatesonly'] = 'Mostrar as notas das categorias apenas';
$string['showingfullmode'] = 'Vista completa';
$string['showinggradesonly'] = 'Mostrar apenas as notas';
$string['showlettergrade'] = 'Mostrar notas alfabéticas';
$string['showlettergrade_help'] = 'Mostrar a coluna das notas alfabéticas.';
$string['showlocks'] = 'Mostrar bloqueios';
$string['showlocks_help'] = 'Se ativar esta opção, quando o modo de edição da pauta está ativo, é exibido um ícone de bloquear/desbloquear para cada nota para controlar se esta pode ser automaticamente atualizada pela respetiva atividade.';
$string['shownohidden'] = 'Totalmente oculto';
$string['shownooutcomes'] = 'Ocultar resultados da aprendizagem';
$string['shownumberofgrades'] = 'Mostrar número de notas usado nas médias';
$string['shownumberofgrades_help'] = 'Se ativar esta opção, o número de notas utilizadas no cálculo da média é mostrado entre parêntesis após cada média.';
$string['showonlyactiveenrol'] = 'Mostrar apenas as inscrições ativas';
$string['showonlyactiveenrol_help'] = 'Esta definição determina se apenas os utilizadores inscritos e ativos serão visíveis no relatório da pauta. Se ativar esta opção, os utilizadores suspensos não serão mostrados na pauta.';
$string['showpercentage'] = 'Mostrar percentagem';
$string['showpercentage_help'] = 'Mostrar o valor da percentagem de cada item de avaliação.';
$string['showquickfeedback'] = 'Mostrar comentário rápido';
$string['showquickfeedback_help'] = 'Se ativar esta opção, quando o modo de edição das notas está ativo, surge uma caixa de comentários para cada nota, permitindo editar vários comentários ao mesmo tempo. As alterações serão guardadas e assinaladas após clicar no botão de Guardar.

Tenha em atenção que quando um comentário é editado diretamente na pauta não pode ser alterado pela atividade à qual a nota está associada.';
$string['showrange'] = 'Mostrar intervalos';
$string['showrange_help'] = 'Mostrar a coluna dos intervalos.';
$string['showranges'] = 'Mostrar intervalos';
$string['showranges_help'] = 'Se ativar esta opção, a pauta terá uma linha adicional que exibe o intervalo de variação configurado para cada categoria e item de avaliação.';
$string['showrank'] = 'Mostrar posição relativa';
$string['showrank_help'] = 'Mostrar a posição do aluno em relação ao resto da turma para cada item de avaliação.';
$string['showuserimage'] = 'Mostrar foto do utilizador';
$string['showuserimage_help'] = 'Se ativar esta opção, na pauta será exibida a imagem de perfil do utilizador junto ao seu nome.';
$string['showverbose'] = 'Mostrar {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Mostrar pesos';
$string['showweight_help'] = 'Mostrar a coluna com o peso das notas.';
$string['simpleview'] = 'Vista individual';
$string['singleview'] = 'Vista simples para {$a}';
$string['sitewide'] = 'Disponível ao nível do site';
$string['sort'] = 'ordenar';
$string['sortasc'] = 'Ordenação ascendente';
$string['sortbyfirstname'] = 'Ordenar por nome';
$string['sortbylastname'] = 'Ordenar por apelido';
$string['sortdesc'] = 'Ordenação descendente';
$string['standarddeviation'] = 'Desvio-padrão';
$string['stats'] = 'Estatísticas';
$string['statslink'] = 'Estatísticas';
$string['student'] = 'Aluno';
$string['studentsperpage'] = 'Alunos por página';
$string['studentsperpage_help'] = 'Esta opção determina o número de alunos exibidos por página na pauta.';
$string['studentsperpagereduced'] = 'Reduzir o número máximo de alunos por página de {$a->originalstudentsperpage} para {$a->studentsperpage}. Aumente os valores nas configurações PHP max_input_vars from {$a->maxinputvars}.';
$string['subcategory'] = 'Categoria normal';
$string['submissions'] = 'Submissões';
$string['submittedon'] = 'Submetido: {$a}';
$string['sumofgradesupgradedgrades'] = 'Nota: O método de agregação "Soma das notas" foi alterado para "Natural" na sequência de uma atualização do site. Uma vez que esta configuração estava a ser usada nesta disciplina, é recomendado que verifique esta alteração na pauta.';
$string['switchtofullview'] = 'Mudar para vista completa';
$string['switchtosimpleview'] = 'Mudar para vista simples';
$string['tabs'] = 'Separadores';
$string['topcategory'] = 'Super-categoria';
$string['total'] = 'Total';
$string['totalweight100'] = 'O peso total é igual a 100';
$string['totalweightnot100'] = 'O peso total não é igual a 100';
$string['turnfeedbackoff'] = 'Desativar feedback';
$string['turnfeedbackon'] = 'Ativar feedback';
$string['typenone'] = 'Nenhum';
$string['typescale'] = 'Escala';
$string['typescale_help'] = 'Esta opção determina a escala utilizada quando se utilizam escalas nas notas. A escala para um item de avaliação é definida nas configurações da atividade.';
$string['typetext'] = 'Texto';
$string['typevalue'] = 'Valor';
$string['uncategorised'] = 'Sem categoria';
$string['unchangedgrade'] = 'Nota inalterada';
$string['unenrolledusersinimport'] = 'Este processo de importação inclui as notas seguintes dos utilizadores não inscritos nesta disciplina: {$a}';
$string['unlimitedgrades'] = 'Ativar avaliações ilimitadas';
$string['unlimitedgrades_help'] = 'Por predefinição, as notas são limitadas pelos limites máximo e mínimo de cada item de avaliação. Se ativar esta opção, esses limites serão removidos o que permite que notas superiores a 100% possam ser introduzidas diretamente na pauta.';
$string['unlock'] = 'Desbloquear';
$string['unlockverbose'] = 'Desbloquear {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Não utilizado';
$string['updatedgradesonly'] = 'Exportar apenas as avaliações novas ou atualizadas';
$string['upgradedgradeshidemessage'] = 'Ignorar aviso';
$string['upgradedminmaxrevertmessage'] = 'Reverter as alterações';
$string['uploadgrades'] = 'Carregar notas';
$string['useadvanced'] = 'Usar funcionalidades avançadas';
$string['usedcourses'] = 'Disciplinas utilizadas';
$string['usedgradeitem'] = 'Item de avaliação utilizado';
$string['usenooutcome'] = 'Não utilizar resultados da aprendizagem';
$string['usenoscale'] = 'Não usar escalas';
$string['usepercent'] = 'Usar percentagens';
$string['user'] = 'Utilizador';
$string['userenrolmentsuspended'] = 'Inscrição de utilizador suspenso';
$string['userfields_show'] = 'Mostrar campos do utilizador';
$string['userfields_show_help'] = 'Mostrar campos adicionais do utilizador, como o endereço de e-mail no relatório do avaliador. Os campos específicos exibidos são controlados pela configuração do site \'showuseridentity\'';
$string['usergrade'] = 'Utilizador {$a->fullname} ({$a->useridnumber}) no item {$a->gradeidnumber}';
$string['userid'] = 'ID do utilizador';
$string['useridnumberwarning'] = 'Os utilizadores sem um número de ID são excluídos da exportação, pois não podem ser importados';
$string['usermappingerror'] = 'Erro de mapeamento de utilizador. Não foi possível encontrar o utilizador com {$a->field} de "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'O utilizador não é um membro do grupo atual.';
$string['usermappingerrormultipleusersfound'] = 'Erro no mapeamento de utilizadores: Vários utilizadores encontrados com {$a->campo} igual a "{$a->value}". Por favor, use um campo de mapeamento mais exclusivo.';
$string['usermappingerrorusernotfound'] = 'Erro de mapeamento de utilizador. Não foi possível encontrar o utilizador.';
$string['userpreferences'] = 'Preferências do utilizador';
$string['useweighted'] = 'Usar ponderações';
$string['verbosescales'] = 'Escalas alfabéticas';
$string['verbosescales_help'] = 'A escala alfabética utiliza palavras em vez de números. Colocar como "Sim" se pretender importar ambas as escalas, numérica e alfabética. Colocar "Não" se apenas pretender importar as escalas numéricas.';
$string['viewbygroup'] = 'Grupo';
$string['viewgrades'] = 'Ver notas';
$string['weight'] = 'Peso';
$string['weight_help'] = 'Um valor usado para determinar o valor relativo de múltiplos itens de avaliação numa categoria ou disciplina.';
$string['weightcourse'] = 'Usar notas ponderadas para a disciplina';
$string['weightedascending'] = 'Ordenar por % ponderada ascendente';
$string['weighteddescending'] = 'Ordenar por % ponderada decrescente';
$string['weightedpct'] = '% ponderada';
$string['weightedpctcontribution'] = '% ponderada';
$string['weightofa'] = 'Peso de {$a}';
$string['weightorextracredit'] = 'Peso ou crédito extra';
$string['weightoverride'] = 'Ajuste de peso';
$string['weightoverride_help'] = 'Desselecione esta opção para repor o peso de um item de avaliação para o seu valor calculado automaticamente. Selecionar esta opção vai evitar que o peso seja ajustado automaticamente.';
$string['weights'] = 'Peso';
$string['weightsadjusted'] = 'Os pesos dos itens de avaliação foram ajustados para um total de 100.';
$string['weightsedit'] = 'Editar pesos e extra créditos';
$string['weightuc'] = 'Peso efetivo';
$string['writinggradebookinfo'] = 'A escrever as configurações da pauta';
$string['xml'] = 'XML';
$string['yes'] = 'Sim';
$string['yourgrade'] = 'A sua nota';
