<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_authorize', language 'sr_cr', version '3.10'.
 *
 * @package     enrol_authorize
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminacceptccs'] = 'Који типови кредитних картица се прихватају?';
$string['adminaccepts'] = 'Изаберите дозвољене начине плаћања и њихове типове';
$string['adminauthorizeccapture'] = 'Преглед поруџбине и подешавања заказаног прихватања';
$string['adminauthorizeemail'] = 'Подешавања слања електронске поште';
$string['adminauthorizesettings'] = 'Подешавања Authorize.net налога';
$string['adminauthorizewide'] = 'Општа подешавања';
$string['adminconfighttps'] = 'Да бисте користили овај додатак <br /> као администратор >> Варијабле >> Безбедност >> HTTP безбедност, проверите да ли сте "<a href="{$a->url}"> loginhttps укључили.';
$string['adminconfighttpsgo'] = 'Идите на <a href="{$a->url}"> сигурносну страну да би обликовали овај додатак.';
$string['admincronsetup'] = 'Скрипт за одржавање cron.php није покретан бар 24 сата. <br />Cron мора бити омогућен ако желите да користите могућности заказаног прихватања.<br /><b>Омогућите</b> \'Authorize.net додатак\' и правилно <b>подесите cron</b>; или поново <b>уклоните ознаку са an_review.</b><br />Ако онемогућите заказано прихватање, трансакције ће бити отказане уколико их не прегледате у року од 30 дана.<br />Означите <b>an_review</b> и упишите <b>\'0\' у поље an_capture_day</b> <br />ако желите <b>ручно</b> да прихватите/одбијете уплате у року од 30 дана.';
$string['adminemailexpiredsort'] = 'Када се већи број поруџбина на чекању којима ускоро истиче рок шаље предавачима путем е-поште, које од њих ће бити истакнуте као важне?';
$string['adminemailexpiredsortcount'] = 'Број поруџбина';
$string['adminemailexpiredsortsum'] = 'Укупан износ';
$string['adminemailexpsetting'] = '(0=онемогућавање слања е-поште, подразумевана вредност=2, максимална вредност=5)<br />(Подешавања ручног прихватања за слање е-поште: cron=омогућен, an_review=проверен, an_capture_day=0, an_emailexpired=1-5)';
$string['adminhelpcapturetitle'] = 'Дан заказаног прихватања';
$string['adminhelpreviewtitle'] = 'Преглед поруџбине';
$string['adminneworder'] = 'Драги администраторе,

Примили сте нову поруџбину која чека на прихватање:

Поруџбина број: {$a->orderid}
Трансакција број: {$a->transid}
Корисник: {$a->user}
Курс: {$a->course}
Износ: {$a->amount}

ОМОГУЋЕНО ЗАКАЗАНО ПРИХВАТАЊЕ?: {$a->acstatus}

Ако је омогућено заказано прихватање, кредитна картица биће обрађена дана {$a->captureon} и корисник ће бити уписан на курс, иначе ће поруџбина истећи дана {$a->expireon} и после тога неће моћи бити прихваћена.

Можете и одмах прихватити/одбити уплату и ако желите уписати полазника на курс пратећи следећи линк:
{$a->url}';
$string['adminnewordersubject'] = '{$a->course}: Нова поруџбина на чекању: {$a->orderid}';
$string['adminpendingorders'] = 'Искључили сте могућност заказаног прихватања.<br />Укупно {$a->count} трансакција са статусом \'Ауторизовано/Чека на прихватање\' биће поништена/о уколико их не потврдите.<br />Да бисте прихватили/одбили уплате идите на страницу <a href=\'{$a->url}\'>Управљање плаћањем</a>.';
$string['adminteachermanagepay'] = 'Предавачи могу управљати плаћањем курса.';
$string['allpendingorders'] = 'Све наруџбине које су у току';
$string['amount'] = 'Износ';
$string['anauthcode'] = 'Набавите authcode';
$string['anauthcodedesc'] = 'Ако кредитна картица корисника не може да буде прихваћена директно преко Интернета, набавите ауторизациони код телефоном од његове банке.';
$string['anavs'] = 'Систем за верификацију адресе';
$string['anavsdesc'] = 'Потврдите овде ако сте активирали \'Систем за верификацију адресе\' (Address Verification System - AVS ) у оквиру свог Authorize.Net налога. Ово захтева  поља за адресу као што су улица, држава, земља и поштански код, када корисник попуњава образац за плаћање.';
$string['ancaptureday'] = 'Дан прихватања';
$string['ancapturedaydesc'] = 'Прихватите кредитну картицу аутоматски, осим ако предавач или администратор не прегледају наруџбине унутар одређеног број дана. CRON МОРА БИТИ ОМОГУЋЕН <br />(0 дана значи да ће бити онемогућено заказано прихватање; такође значи да ће предавач или администратор ручно прегледати наруџбину. Трансакција ће се отказати ако  онемогућите заказано прихватање или уколико не прегледате трансакцију у наредних 30 дана.)';
$string['anemailexpired'] = 'Обавештење о истицању  рока';
$string['anemailexpireddesc'] = 'Ово је корисно за \'ручно прихватање\'. Администратори ће бити обавештени одговарајући број дана пре него што истекне рок наруџбина које су на чекању.';
$string['anemailexpiredteacher'] = 'Обавештење о истицању  рока  - предавач';
$string['anemailexpiredteacherdesc'] = 'Ако сте омогућили ручно прихватање (види горе) и ако предавачи могу да управљају уплатама, онда ће и они бити обавештавани о истицању рока за наруџбине које су на чекању, Ово ће свим предавачима послати е-поруку о броју наруџбина на чекању које ће истећи.';
$string['anlogin'] = 'Authorize.net: Корисничко име';
$string['anpassword'] = 'Authorize.net: Лозинка';
$string['anreferer'] = 'URL за преусмеравање';
$string['anrefererdesc'] = 'Дефинишите URL реферер за преусмеравање ако сте то подесили на свом Authorize налогу. То ће послати линију "Прослеђивач: URL" у оквиру веб захтева.';
$string['anreview'] = 'Преглед';
$string['anreviewdesc'] = 'Преглед поруџбине пре обраде кредитне картице';
$string['antestmode'] = 'Режим за тестирање';
$string['antestmodedesc'] = 'Покрени трансакцију у тест режиму само (новац неће бити пребачен)';
$string['antrankey'] = 'Authorize.net: Кључ за трансакцију';
$string['approvedreview'] = 'Одобрени преглед';
$string['authcaptured'] = 'Ауторизовано/Прихваћено';
$string['authcode'] = 'Код за ауторизацију';
$string['authorize:config'] = 'Конфигуриши инстанцу за упис путем Authorize.Neta';
$string['authorize:manage'] = 'Управљање уписаним корисницима';
$string['authorize:managepayments'] = 'Управљање уплатама';
$string['authorize:unenrol'] = 'Испиши кориснике са курса';
$string['authorize:unenrolself'] = 'Испиши се са курса';
$string['authorize:uploadcsv'] = 'Постави CSV  датотеку.';
$string['authorizedpendingcapture'] = 'Ауторизовано/Чека на прихватање';
$string['authorizeerror'] = 'Authorize.Net грешка: {$a}';
$string['avsa'] = 'Адреса (улица) се уклапа, али не и поштански број';
$string['avsb'] = 'Нису дате информације о адреси';
$string['avse'] = 'Грешка у систему за верификацију адреса';
$string['avsg'] = 'Банка која је издала картицу (ван САД-а)';
$string['avsn'] = 'Не уклапа се ни адреса (улица) ни поштански број';
$string['avsp'] = 'Систем за верификацију адреса није применљив';
$string['avsr'] = 'Поновни покушај - Систем није доступан или је време истекло';
$string['avsresult'] = 'AVS резултат: {$a}';
$string['avss'] = 'Издавач не подржава ову услугу';
$string['avsu'] = 'Нису доступне информације о адреси';
$string['avsw'] = 'Деветоцифрени поштански број се уклапа, али не и адреса (улица)';
$string['avsx'] = 'Адреса (улица) и деветоцифрени поштански број се уклапају';
$string['avsy'] = 'Адреса (улица) и петоцифрени поштански број се уклапају';
$string['avsz'] = 'Петоцифрени поштански број се уклапа, али не и адреса (улица)';
$string['canbecredit'] = 'Може бити рефундирано до {$a->upto}';
$string['cancelled'] = 'Отказано';
$string['capture'] = 'Прихватање';
$string['capturedpendingsettle'] = 'Прихваћено/Чека на наплату';
$string['capturedsettled'] = 'Прихваћено/Договорено';
$string['captureyes'] = 'Кредитна картица ће бити прихваћена и полазник ће бити уписан на курс. Да ли сте сигурни да то желите?';
$string['cccity'] = 'Место';
$string['ccexpire'] = 'Датум истека важности кредитне картице';
$string['ccexpired'] = 'Кредитна картица је истекла';
$string['ccinvalid'] = 'Погрешан број картице';
$string['cclastfour'] = 'последња четири у CC пољу';
$string['ccno'] = 'Број кредитне картице';
$string['ccstate'] = 'Држава';
$string['cctype'] = 'Тип кредитне картице';
$string['ccvv'] = 'Провера кредитне картице';
$string['ccvvhelp'] = 'Погледајте полеђину картице (последње 3 цифре)';
$string['choosemethod'] = 'Уколико знате приступну лозинку курса унесите је;<br />у супротном морате да платите да бисте уписали овај курс.';
$string['chooseone'] = 'Попуните једно или оба поља';
$string['cost'] = 'Цена';
$string['costdefaultdesc'] = '<strong>У подешавањима курса, унесите -1</strong>у поље за цену да бисте користили подразумевани износ.';
$string['currency'] = 'Валута';
$string['cutofftime'] = 'Време прекида трансакције';
$string['cutofftimedesc'] = 'Време када се купе трансакције за наплату. Када је покупљена последња трансација за наплату?';
$string['dataentered'] = 'Унети подаци';
$string['delete'] = 'Уништи';
$string['description'] = 'Authorize.net модул вам дозвољава да поставите курсеве који се плаћају преко провајдера који пружају услуге плаћања. Постоје два начина да се постави цена курса: (1) цена на нивоу сајта, подразумевана за сваки курс или (2) подешавањем сваког појединачног курса. Цена курса има предност над подразумеваном ценом на нивоу сајта.';
$string['echeckabacode'] = 'Банковни ABA број';
$string['echeckaccnum'] = 'Број банковног рачуна';
$string['echeckacctype'] = 'Врста банковног рачуна';
$string['echeckbankname'] = 'Назив банке';
$string['echeckbusinesschecking'] = 'Провера пословања';
$string['echeckchecking'] = 'Провера';
$string['echeckfirslasttname'] = 'Власник банковног рачуна';
$string['echecksavings'] = 'Уштеђевина';
$string['enrolenddate'] = 'Датум завршетка';
$string['enrolenddaterror'] = 'Датум завршетка трајања уписа на курс не може бити ранији од датума његовог почетка';
$string['enrolname'] = 'Authorize.net gateway за плаћање';
$string['enrolperiod'] = 'Период трајања уписа на курс';
$string['enrolstartdate'] = 'Датум почетка';
$string['expired'] = 'Истекло';
$string['expiremonth'] = 'Месец истека';
$string['expireyear'] = 'Година истека';
$string['firstnameoncard'] = 'Име на картици';
$string['haveauthcode'] = 'Већ имам код за ауторизацију.';
$string['howmuch'] = 'Колико?';
$string['httpsrequired'] = 'Жао нам је, али Ваш захтев тренутно не може бити обрађен. Конфигурација овог сајта не може да буде правилно подешена<br /><br />Молимо не уносите број Ваше кредитне картице уколико не видите жути катанац на дну прозора вашег веб читача. Ако  се овај симбол појави, то значи да страница шифрира све податке који се размењују између клијента и сервера. На тај начин су информације заштићене током трансакција између два рачунара, па број Ваше кредитне картице не може бити пресретнут или украден на Интернету.';
$string['invalidaba'] = 'Погрешан ABA број';
$string['invalidaccnum'] = 'Погрешан број рачуна';
$string['invalidacctype'] = 'Погрешан тип рачуна';
$string['isbusinesschecking'] = 'Да ли се проверава пословање?';
$string['lastnameoncard'] = 'Презиме на картици';
$string['logindesc'] = 'Ова опција мора бити укључена. <br /><br />Молимо проверите да ли сте укључили <a href="{$a->url}">loginhttps</a> у Администрација >> Променљиве >> Безбедност.<br /><br />Укључивањем ове опције постићи ћете то да Moodle користи сигурну https конекцију само за страница за приступ систему и уплате.';
$string['logininfo'] = 'Када конфигуришете свој Authorize.Net налог, корисничко име је неопходно, а такође  морате унети,<strong>било</strong> кључ трансакције<strong>или</stron>
лозинку у одговарајуће поље. Препоручујемо да, због безбедносних разлога, унесете кључ трансакције.';
$string['messageprovider:authorize_enrolment'] = 'Поруке о упису путем Authorize.Neta';
$string['methodcc'] = 'Кредитна картица';
$string['methodccdesc'] = 'Изаберите кредитну картицу и типове који се прихватају';
$string['methodecheck'] = 'eCheck (ACH)';
$string['methodecheckdesc'] = 'Изаберите eCheck и типове који се прихватају';
$string['missingaba'] = 'Недостаје ABA број';
$string['missingaddress'] = 'Недостаје адреса';
$string['missingbankname'] = 'Недостаје назив банке';
$string['missingcc'] = 'Недостаје број кредитне картице';
$string['missingccauthcode'] = 'Недостаје код за ауторизацију.';
$string['missingccexpiremonth'] = 'Недостаје месец истека';
$string['missingccexpireyear'] = 'Недостаје година истека';
$string['missingcctype'] = 'Недостаје тип кредитне картице';
$string['missingcvv'] = 'Недостаје верификациони број';
$string['missingzip'] = 'Недостаје поштански број';
$string['mypaymentsonly'] = 'Прикажи само моје плаћање.';
$string['nameoncard'] = 'Име на картици';
$string['new'] = 'Ново';
$string['nocost'] = 'Нема трошкова за упис на овај курс преко Authorize.Neta!';
$string['noreturns'] = 'Без повраћаја новца!';
$string['notsettled'] = 'Није утврђено';
$string['orderdetails'] = 'Детаљи поруџбине';
$string['orderid'] = 'ID поруџбине';
$string['paymentmanagement'] = 'Управљање плаћањем';
$string['paymentmethod'] = 'Начин плаћања';
$string['paymentpending'] = 'Ваша уплата за овај курс, под редним бројем {$a->orderid}, чека на прихватање. Погледајте <a href=\'{$a->url}\'>Детаљи поруџбине</a>.';
$string['pendingecheckemail'] = 'Поштовани директоре,

Тренутно {$a->count} echecks чекају на прихватање, неопходно је да поставите csv датотеку да би се корисници пријавили.';
$string['pendingechecksubject'] = '{$a->course}: eChecks чекају на прихватање ({$a->count})';
$string['pendingordersemail'] = 'Драги администраторе,

{$a->pending} трансакција које чекају на прихватање за курс "{$a->course}" ће истећи уколико не прихватите уплате у року од {$a->days} дана.

Ова порука Вам се шаље као упозорење, јер нисте омогућили заказано прихватање.
То значи да ручно морате да прихватите или одбијете сваку уплату.

Да бисте прихватили/одбили уплате на чекању идите на:
{$a->url}

Да бисте омогућили заказано прихватање, што би значило да више не бисте добијали овакве поруке упозорења, идите на:

{$a->enrolurl}';
$string['pendingordersemailteacher'] = 'Драги предавачу,

{$a->pending} трансакција укупне вредности {$a->currency} {$a->sumcost} за курс "{$a->course}"
ће истећи уколико не прихватите уплате у року од {$a->days} дана.

Морате ручно да прихватате или одбијате уплате јер администратор није омогућио заказано прихватање.

{$a->url}';
$string['pendingorderssubject'] = 'УПОЗОРЕЊЕ: {$a->course}, {$a->pending} поруџбина ће истећи у року од {$a->days} дана.';
$string['pluginname'] = 'Authorize.Net';
$string['reason11'] = 'Предат је дупликат трансакције.';
$string['reason13'] = 'Трговачки идентификатор корисничког имена није исправан или тај налог није активан.';
$string['reason16'] = 'Трансакција није пронађена.';
$string['reason17'] = 'Трговац не прихвата овај тип кредитне картице.';
$string['reason245'] = 'Овај eCheck тип није дозвољен кад се користи форма за плаћање подржана мрежним пролазом.';
$string['reason246'] = 'Овај eCheck тип није дозвољен.';
$string['reason27'] = 'Трансакција је резултовала AVS неслагањем. Адреса која је дата се не слаже са адресом за слање рачуна власника картице.';
$string['reason28'] = 'Трговац не прихвата овај тип кредитне картице.';
$string['reason30'] = 'Конфигурација са процесором није валидна. Позовите даваоца трговинских услуга.';
$string['reason39'] = 'Достављена шифра валуте није валидна, није подржана, није дозвољена за овог трговца или пак нема задат курс.';
$string['reason43'] = '.Тргвац је погрешно подешен при процесору. Позовите даваоца трговинских услуга.';
$string['reason44'] = 'Ова трансакција је одбијена. Грешка филтера кôда кредитне картице!';
$string['reason45'] = 'Ова трансакција је одбијена. Грешка филтера кôда кредитне  картице/система за верификацију адреса.';
$string['reason47'] = 'Захтевани износ за наплату не сме бити већи од оригиналнo одобреног износа.';
$string['reason5'] = 'Потребан је валидан износ.';
$string['reason50'] = 'Трансакција чека на наплату и не може бити рефундирана.';
$string['reason51'] = 'Сума свих кредита за ову трансакцију већа је од вредности оригиналне трансакције.';
$string['reason54'] = 'Референцирана трансакција не испуњава услове за издавање кредита.';
$string['reason55'] = 'Сума кредита за референцирану трансакцију би прешла оригинални дебитни износ.';
$string['reason56'] = 'Овај трговац прихвата само eCheck (ACH) трансакције; трансакције кредитним картицама сe не прихватају.';
$string['refund'] = 'Рефундирање';
$string['refunded'] = 'Рефундирано';
$string['returns'] = 'Повраћаји';
$string['reviewfailed'] = 'Преглед није успео';
$string['reviewnotify'] = 'Ваша уплата ће бити прегледана. Очекујте е-поруку од Вашег предавача у року од неколико дана.';
$string['sendpaymentbutton'] = 'Пошаљи уплату';
$string['settled'] = 'Договорено';
$string['settlementdate'] = 'Датум поравнања (наплате)';
$string['shopper'] = 'Купац';
$string['status'] = 'Дозволи уписе путем Autorize.Neta';
$string['subvoidyes'] = 'Рефундирана трансакција {$a->transid} ће бити поништена и на ваш рачун ће бити враћен новац у износу од {$a->amount}. Да ли сте сигурни да желите да наставите?';
$string['tested'] = 'Тестирано';
$string['testmode'] = '[РЕЖИМ ЗА ТЕСТИРАЊЕ]';
$string['testwarning'] = 'Изгледа да Прихватање/Поништавање/Рефундирање раде у режиму за тестирање, али ниједан запис није ажуриран или уметнут у базу података.';
$string['transid'] = 'Идентификатор трансакције';
$string['underreview'] = 'У процесу прегледа';
$string['unenrolselfconfirm'] = 'Да ли стварно желите да се испишете са курса "{$a}"?';
$string['unenrolstudent'] = 'Испис полазника?';
$string['uploadcsv'] = 'Постављање CSV датотеке';
$string['usingccmethod'] = 'Грешка при коришћењу опције <a href="{$a->url}"><strong>Кредитна картица</strong></a>';
$string['usingecheckmethod'] = 'Грешка при коришћењу опције <a href="{$a->url}"><strong>eCheck</strong></a>';
$string['verifyaccount'] = 'Проверите свој Authorize.Net налог';
$string['verifyaccountresult'] = '<b>Резултат провере:</b> {$a}';
$string['void'] = 'Ништа';
$string['voidyes'] = 'Трансакција ће бити отказана. Да ли сте сигурни да то желите?';
$string['welcometocoursesemail'] = 'Поштовани полазниче,

Хвала Вам за Ваше уплате. Уписали сте се на следеће курсеве:

{$a->courses}

Можете погледати детаљне информације о обављеној уплати или уредити свој кориснички профил:

{$a->paymenturl}
{$a->profileurl}';
$string['youcantdo'] = 'Не можете извршити ову акцију: {$a->action}';
$string['zipcode'] = 'Поштански број';
