<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'sr_cr', version '3.10'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'На овом сајту већ постоји корисник са овим корисничким именом. Ако је ово ваш налог, пријавите се на систем тако што ћете унети корисничко име и лозинку, и то додати као повезану пријаву на страници са вашим параметрима.';
$string['alreadylinked'] = 'Овај екстерни налог је већ повезан са налогом на овом сајту';
$string['auth_oauth2description'] = 'Провера идентитета базирана на OAuth 2 стандарду';
$string['auth_oauth2settings'] = 'Подешавања OAuth 2 провере идентитета.';
$string['confirmaccountemail'] = 'Поштована/и {$a->fullname},

Затражено је отварање корисничког налога на сајту \'{$a->sitename}\' користећи вашу адресу е-поште.

Да бисте потврдили свој нови налог, молимо вас идите на следећу веб адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}

Уколико нисте затражили да вам се отвори нови кориснички налог могуће је да неко други покушава да вам компромитује налог. У том случају молимо одмах контактирајте администратора.';
$string['confirmaccountemailsubject'] = '{$a}: потврда налога';
$string['confirmationinvalid'] = 'Линк за потврду је или неважећи или је истекао. Покрените поступак пријављивања поново како бисте генерисали нову е-поруку за потврду.';
$string['confirmationpending'] = 'Овај налог чека потврду путем е-поруке.';
$string['confirmlinkedloginemail'] = 'Поштована/и{$a->fullname},

Креиран је захтев за повезивање {$a->issuername} пријаве на систем {$a->linkedemail} за ваш кориснички налог на сајту \'{$a->sitename}\' користећи вашу адресу е-поште.

Да бисте потврдили овај захтев и повезали ове пријаве на систем, молимо вас идите на следећу веб адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}

Уколико нисте затражили да вам се отвори нови кориснички налог могуће је да неко други покушава да вам компромитује налог. У том случају молимо одмах контактирајте администратора.';
$string['confirmlinkedloginemailsubject'] = '{$a}: потврда повезане пријаве на систем';
$string['createaccountswarning'] = 'Овај додатак за проверу идентитета дозвољава корисницима да креирају налоге на вашем сајту. Ако користите овај додатак пожељно би било да омогућите подешавање "authpreventaccountcreation".';
$string['createnewlinkedlogin'] = 'Повежи нови налог ({$a})';
$string['emailconfirmlink'] = 'Повежи свој налог';
$string['emailconfirmlinksent'] = '<p>Пронађен је налог, који већ постоји, са овом адресом е-поште, али још увек није повезан.</p>
<p>Налози морају бити повезани пре него што будете могли да се пријавите на систем.</p>
<p>Требало би да је послата порука на вашу е-адресу <b>{$a}</b>.</p>
<p>Она садржи једноставна упутства како да повежете своје налоге.</p>
<p>Уколико и даље будете имали потешкоћа, обратите се администратору сајта.</p>';
$string['emailpasswordchangeinfo'] = 'Поштована/и {$a->firstname},

Неко (вероватно ви) је затражио нову лозинку за ваш кориснички налог  на сајту \'{$a->sitename}\'.

Међутим, ваша лозинка се не може ресетовати зато што свој налог користите за пријаву на други сајт.

Молимо вас, да се пријавите као и пре, користећи линк на страници за пријаву.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Информације о промени лозинке';
$string['info'] = 'Екстерни налог';
$string['issuer'] = 'OAuth 2 Сервис';
$string['issuernologin'] = 'Овај давалац идентитета се не може користити за пријаву на систем';
$string['linkedlogins'] = 'Пријаве путем повезаних налога';
$string['linkedloginshelp'] = 'Помоћ за пријаве путем повезаних налога';
$string['loginerror_authenticationfailed'] = 'Процес провере идентитета није успео.';
$string['loginerror_cannotcreateaccounts'] = 'Налог са вашом адресом е-поште није било могуће пронаћи.';
$string['loginerror_invaliddomain'] = 'Адреса е-поште није дозвољена на овом сајту.';
$string['loginerror_nouserinfo'] = 'Нису добијене никакве корисничке информације. Могуће да OAuth 2 сервис није исправно конфигурисан.';
$string['loginerror_userincomplete'] = 'Добијене корисничке информације не садржа корисничко име и адресу е-поште. Могуће да OAuth 2 сервис није исправно конфигурисан.';
$string['noissuersavailable'] = 'Ниједан од конфигурисаних OAuth2 сервиса вам не дозвољава да повежете налоге за пријаву';
$string['notenabled'] = 'Нажалост, OAuth 2 додатак за проверу идентитета није омогућен';
$string['notloggedindebug'] = 'Покушај пријаве на систем није успео. Разлог: {$a}';
$string['notwhileloggedinas'] = 'Не може се управљати повезаним пријавама док сте пријављени као други корисник.';
$string['oauth2:managelinkedlogins'] = 'Управљање сопственим повезаним налозима за пријаву';
$string['plugindescription'] = 'Овај додатак за проверу идентитета приказује списак конфигурисаних давалаца идентитета на страници за пријаву. Избор даваоца идентитета омогућава корисницима да се пријаве на систем помоћу својих акредитива добијених од OAuth 2 даваоца.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2 провера идентитета';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Овај додатак је повезан са подсистемом за проверу идентитета.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Токен за потврду.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Временска ознака када истиче токен за потврду.';
$string['privacy:metadata:auth_oauth2:email'] = 'Екстерна адреса електронске поште која се мапира на овај налог.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'ID ознака OAuth 2 даваоца идентитета за ову OAuth 2 пријаву на систем';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2 налози везани за корисников Moodle налог.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Временска ознака када је кориснички налог повезан са OAuth 2 приступом.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Временска ознака када је овај запис измењен.';
$string['privacy:metadata:auth_oauth2:userid'] = 'Идентификатор корисничког налога за везаног за OAuth 2 приступ.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'ID ознака корисника који је изменио овај налог.';
$string['privacy:metadata:auth_oauth2:username'] = 'Екстерно корисничко име која се мапира на овај налог.';
